; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-globals
; RUN: opt -S -passes=openmp-opt < %s | FileCheck %s
target triple = "nvptx64"

%struct.KernelEnvironmentTy = type { %struct.ConfigurationEnvironmentTy, ptr, ptr }
%struct.ConfigurationEnvironmentTy = type { i8, i8, i8, i32, i32, i32, i32, i32, i32 }

@G = external global i32

@kernel0_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 0, i8 0, i8 1, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0 }, ptr null, ptr null }
@kernel1_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 0, i8 0, i8 1, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0 }, ptr null, ptr null }
@kernel2_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 0, i8 0, i8 1, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0 }, ptr null, ptr null }

;.
; CHECK: @G = external global i32
; CHECK: @kernel0_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 0, i8 0, i8 3, i32 0, i32 666, i32 0, i32 777, i32 0, i32 0 }, ptr null, ptr null }
; CHECK: @kernel1_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 0, i8 0, i8 3, i32 0, i32 666, i32 0, i32 777, i32 0, i32 0 }, ptr null, ptr null }
; CHECK: @kernel2_kernel_environment = local_unnamed_addr constant %struct.KernelEnvironmentTy { %struct.ConfigurationEnvironmentTy { i8 0, i8 0, i8 3, i32 0, i32 666, i32 0, i32 777, i32 0, i32 0 }, ptr null, ptr null }
; CHECK: @[[GLOB0:[0-9]+]] = private unnamed_addr constant [23 x i8] c"
; CHECK: @[[GLOB1:[0-9]+]] = private unnamed_addr constant %struct.ident_t { i32 0, i32 2, i32 0, i32 22, ptr @[[GLOB0]] }, align 8
;.
define weak void @kernel0(ptr %dyn) "kernel" #0 {
; CHECK-LABEL: define {{[^@]+}}@kernel0
; CHECK-SAME: (ptr [[DYN:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[I:%.*]] = call i32 @__kmpc_target_init(ptr @kernel0_kernel_environment, ptr [[DYN]])
; CHECK-NEXT:    [[THREAD_ID_IN_BLOCK:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
; CHECK-NEXT:    [[THREAD_IS_MAIN:%.*]] = icmp ne i32 [[THREAD_ID_IN_BLOCK]], 0
; CHECK-NEXT:    br i1 [[THREAD_IS_MAIN]], label [[EXIT_THREADS:%.*]], label [[MAIN_THREAD_USER_CODE:%.*]]
; CHECK:       exit.threads:
; CHECK-NEXT:    ret void
; CHECK:       main.thread.user_code:
; CHECK-NEXT:    call void @helper0() #[[ATTR1:[0-9]+]]
; CHECK-NEXT:    call void @helper1() #[[ATTR1]]
; CHECK-NEXT:    call void @helper2() #[[ATTR1]]
; CHECK-NEXT:    call void @__kmpc_target_deinit()
; CHECK-NEXT:    ret void
;
  %i = call i32 @__kmpc_target_init(ptr @kernel0_kernel_environment, ptr %dyn)
  call void @helper0()
  call void @helper1()
  call void @helper2()
  call void @__kmpc_target_deinit()
  ret void
}

define weak void @kernel1(ptr %dyn) "kernel" #0 {
; CHECK-LABEL: define {{[^@]+}}@kernel1
; CHECK-SAME: (ptr [[DYN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[I:%.*]] = call i32 @__kmpc_target_init(ptr @kernel1_kernel_environment, ptr [[DYN]])
; CHECK-NEXT:    [[THREAD_ID_IN_BLOCK:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
; CHECK-NEXT:    [[THREAD_IS_MAIN:%.*]] = icmp ne i32 [[THREAD_ID_IN_BLOCK]], 0
; CHECK-NEXT:    br i1 [[THREAD_IS_MAIN]], label [[EXIT_THREADS:%.*]], label [[MAIN_THREAD_USER_CODE:%.*]]
; CHECK:       exit.threads:
; CHECK-NEXT:    ret void
; CHECK:       main.thread.user_code:
; CHECK-NEXT:    call void @helper1() #[[ATTR1]]
; CHECK-NEXT:    call void @__kmpc_target_deinit()
; CHECK-NEXT:    ret void
;
  %i = call i32 @__kmpc_target_init(ptr @kernel1_kernel_environment, ptr %dyn)
  call void @helper1()
  call void @__kmpc_target_deinit()
  ret void
}

define weak void @kernel2(ptr %dyn) "kernel" #0 {
; CHECK-LABEL: define {{[^@]+}}@kernel2
; CHECK-SAME: (ptr [[DYN:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [0 x ptr], align 8
; CHECK-NEXT:    [[I:%.*]] = call i32 @__kmpc_target_init(ptr @kernel2_kernel_environment, ptr [[DYN]])
; CHECK-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[I]], -1
; CHECK-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[COMMON_RET:%.*]]
; CHECK:       common.ret:
; CHECK-NEXT:    ret void
; CHECK:       user_code.entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr null) #[[ATTR1]]
; CHECK-NEXT:    call void @helper0() #[[ATTR1]]
; CHECK-NEXT:    call void @helper1() #[[ATTR1]]
; CHECK-NEXT:    call void @helper2() #[[ATTR1]]
; CHECK-NEXT:    call void @__kmpc_parallel_51(ptr null, i32 [[TMP0]], i32 1, i32 -1, i32 -1, ptr @__omp_outlined__, ptr @__omp_outlined___wrapper, ptr [[CAPTURED_VARS_ADDRS]], i64 0)
; CHECK-NEXT:    call void @__kmpc_target_deinit()
; CHECK-NEXT:    ret void
;
entry:
  %captured_vars_addrs = alloca [0 x ptr], align 8
  %i = call i32 @__kmpc_target_init(ptr @kernel2_kernel_environment, ptr %dyn)
  %exec_user_code = icmp eq i32 %i, -1
  br i1 %exec_user_code, label %user_code.entry, label %common.ret

common.ret:
  ret void

user_code.entry:
  %0 = call i32 @__kmpc_global_thread_num(ptr null)
  call void @helper0()
  call void @helper1()
  call void @helper2()
  call void @__kmpc_parallel_51(ptr null, i32 %0, i32 1, i32 -1, i32 -1, ptr @__omp_outlined__, ptr @__omp_outlined___wrapper, ptr %captured_vars_addrs, i64 0)
  call void @__kmpc_target_deinit()
  ret void
}

define internal void @helper0() {
; CHECK-LABEL: define {{[^@]+}}@helper0
; CHECK-SAME: () #[[ATTR1]] {
; CHECK-NEXT:    br label [[REGION_CHECK_TID:%.*]]
; CHECK:       region.check.tid:
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i32 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[TMP2]], label [[REGION_GUARDED:%.*]], label [[REGION_BARRIER:%.*]]
; CHECK:       region.guarded:
; CHECK-NEXT:    store i32 666, ptr @G, align 4
; CHECK-NEXT:    br label [[REGION_GUARDED_END:%.*]]
; CHECK:       region.guarded.end:
; CHECK-NEXT:    br label [[REGION_BARRIER]]
; CHECK:       region.barrier:
; CHECK-NEXT:    call void @__kmpc_barrier_simple_spmd(ptr @[[GLOB1]], i32 [[TMP1]])
; CHECK-NEXT:    br label [[REGION_EXIT:%.*]]
; CHECK:       region.exit:
; CHECK-NEXT:    ret void
;
  %threadLimit = call i32 @__kmpc_get_hardware_num_threads_in_block()
  store i32 %threadLimit, ptr @G
  ret void
}

define internal void @helper1() {
; CHECK-LABEL: define {{[^@]+}}@helper1
; CHECK-SAME: () #[[ATTR1]] {
; CHECK-NEXT:    br label [[F:%.*]]
; CHECK:       t:
; CHECK-NEXT:    unreachable
; CHECK:       f:
; CHECK-NEXT:    ret void
;
  %threadLimit = call i32 @__kmpc_get_hardware_num_threads_in_block()
  %c = icmp eq i32 %threadLimit, 666
  br i1 %c, label %f, label %t
t:
  call void @helper0()
  ret void
f:
  ret void
}

define internal void @helper2() {
; CHECK-LABEL: define {{[^@]+}}@helper2
; CHECK-SAME: () #[[ATTR1]] {
; CHECK-NEXT:    br label [[REGION_CHECK_TID:%.*]]
; CHECK:       region.check.tid:
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i32 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[TMP2]], label [[REGION_GUARDED:%.*]], label [[REGION_BARRIER:%.*]]
; CHECK:       region.guarded:
; CHECK-NEXT:    store i32 666, ptr @G, align 4
; CHECK-NEXT:    br label [[REGION_GUARDED_END:%.*]]
; CHECK:       region.guarded.end:
; CHECK-NEXT:    br label [[REGION_BARRIER]]
; CHECK:       region.barrier:
; CHECK-NEXT:    call void @__kmpc_barrier_simple_spmd(ptr @[[GLOB1]], i32 [[TMP1]])
; CHECK-NEXT:    br label [[REGION_EXIT:%.*]]
; CHECK:       region.exit:
; CHECK-NEXT:    ret void
;
  %threadLimit = call i32 @__kmpc_get_hardware_num_threads_in_block()
  store i32 %threadLimit, ptr @G
  ret void
}

define internal void @__omp_outlined__(ptr noalias %.global_tid., ptr noalias %.bound_tid.) {
; CHECK-LABEL: define {{[^@]+}}@__omp_outlined__
; CHECK-SAME: (ptr noalias [[DOTGLOBAL_TID_:%.*]], ptr noalias [[DOTBOUND_TID_:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret void
;
entry:
  ret void
}

define internal void @__omp_outlined___wrapper(i16 zeroext %0, i32 %1) {
; CHECK-LABEL: define {{[^@]+}}@__omp_outlined___wrapper
; CHECK-SAME: (i16 zeroext [[TMP0:%.*]], i32 [[TMP1:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret void
;
entry:
  ret void
}

define internal i32 @__kmpc_get_hardware_num_threads_in_block() {
  %ret = call i32 @__kmpc_get_hardware_num_threads_in_block_dummy()
  ret i32 %ret
}
declare i32 @__kmpc_get_hardware_num_threads_in_block_dummy()
declare i32 @__kmpc_target_init(ptr, ptr) #1
declare void @__kmpc_target_deinit() #1
declare void @__kmpc_parallel_51(ptr, i32, i32, i32, i32, ptr, ptr, ptr, i64)
declare i32 @__kmpc_global_thread_num(ptr)


!llvm.module.flags = !{!0, !1}
!nvvm.annotations = !{!2, !3, !4}

attributes #0 = { "omp_target_thread_limit"="666" "omp_target_num_teams"="777"}

!0 = !{i32 7, !"openmp", i32 50}
!1 = !{i32 7, !"openmp-device", i32 50}
!2 = !{ptr @kernel0, !"kernel", i32 1}
!3 = !{ptr @kernel1, !"kernel", i32 1}
!4 = !{ptr @kernel2, !"kernel", i32 1}
;.
; CHECK: attributes #[[ATTR0]] = { "kernel" "omp_target_num_teams"="777" "omp_target_thread_limit"="666" }
; CHECK: attributes #[[ATTR1]] = { nounwind }
; CHECK: attributes #[[ATTR2:[0-9]+]] = { alwaysinline }
; CHECK: attributes #[[ATTR3:[0-9]+]] = { convergent nounwind }
;.
; CHECK: [[META0:![0-9]+]] = !{i32 7, !"openmp", i32 50}
; CHECK: [[META1:![0-9]+]] = !{i32 7, !"openmp-device", i32 50}
; CHECK: [[META2:![0-9]+]] = !{ptr @kernel0, !"kernel", i32 1}
; CHECK: [[META3:![0-9]+]] = !{ptr @kernel1, !"kernel", i32 1}
; CHECK: [[META4:![0-9]+]] = !{ptr @kernel2, !"kernel", i32 1}
;.
