# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=znver3 -iterations=1000 -timeline -register-file-stats < %s | FileCheck %s

# LLVM-MCA-BEGIN
mov %eax, %ecx
mov %ecx, %edx
mov %edx, %ebp
mov %ebp, %esi
mov %esi, %edi
mov %edi, %r8d
mov %r8d, %r9d
mov %r9d, %r10d
mov %r10d, %r11d
mov %r11d, %r12d
mov %r12d, %r13d
mov %r13d, %r14d
mov %r14d, %r15d
mov %r15d, %eax
# LLVM-MCA-END

# LLVM-MCA-BEGIN
mov %rax, %rcx
mov %rcx, %rdx
mov %rdx, %rbp
mov %rbp, %rsi
mov %rsi, %rdi
mov %rdi, %r8
mov %r8, %r9
mov %r9, %r10
mov %r10, %r11
mov %r11, %r12
mov %r12, %r13
mov %r13, %r14
mov %r14, %r15
mov %r15, %rax
# LLVM-MCA-END

# FIXME: what's the mnemonic for MOVSX32rr32 ?

# LLVM-MCA-BEGIN
xchgl %eax, %ecx
xchgl %ecx, %edx
xchgl %edx, %ebp
xchgl %ebp, %esi
xchgl %esi, %edi
xchgl %edi, %r8d
xchgl %r8d, %r9d
xchgl %r9d, %r10d
xchgl %r10d, %r11d
xchgl %r11d, %r12d
xchgl %r12d, %r13d
xchgl %r13d, %r14d
xchgl %r14d, %r15d
xchgl %r15d, %eax
# LLVM-MCA-END

# LLVM-MCA-BEGIN
xchgq %rax, %rcx
xchgq %rcx, %rdx
xchgq %rdx, %rbp
xchgq %rbp, %rsi
xchgq %rsi, %rdi
xchgq %rdi, %r8
xchgq %r8, %r9
xchgq %r9, %r10
xchgq %r10, %r11
xchgq %r11, %r12
xchgq %r12, %r13
xchgq %r13, %r14
xchgq %r14, %r15
xchgq %r15, %rax
# LLVM-MCA-END

# CHECK:      [0] Code Region

# CHECK:      Iterations:        1000
# CHECK-NEXT: Instructions:      14000
# CHECK-NEXT: Total Cycles:      2335
# CHECK-NEXT: Total uOps:        14000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    6.00
# CHECK-NEXT: IPC:               6.00
# CHECK-NEXT: Block RThroughput: 2.3

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      0     0.17                        movl	%eax, %ecx
# CHECK-NEXT:  1      0     0.17                        movl	%ecx, %edx
# CHECK-NEXT:  1      0     0.17                        movl	%edx, %ebp
# CHECK-NEXT:  1      0     0.17                        movl	%ebp, %esi
# CHECK-NEXT:  1      0     0.17                        movl	%esi, %edi
# CHECK-NEXT:  1      0     0.17                        movl	%edi, %r8d
# CHECK-NEXT:  1      0     0.17                        movl	%r8d, %r9d
# CHECK-NEXT:  1      0     0.17                        movl	%r9d, %r10d
# CHECK-NEXT:  1      0     0.17                        movl	%r10d, %r11d
# CHECK-NEXT:  1      0     0.17                        movl	%r11d, %r12d
# CHECK-NEXT:  1      0     0.17                        movl	%r12d, %r13d
# CHECK-NEXT:  1      0     0.17                        movl	%r13d, %r14d
# CHECK-NEXT:  1      0     0.17                        movl	%r14d, %r15d
# CHECK-NEXT:  1      0     0.17                        movl	%r15d, %eax

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    0
# CHECK-NEXT: Max number of mappings used:         0

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0
# CHECK-NEXT:    Number of optimizable moves:      14000
# CHECK-NEXT:    Number of moves eliminated:       14000  (100.0%)
# CHECK-NEXT:    Number of zero moves:             0  (0.0%)
# CHECK-NEXT:    Max moves eliminated per cycle:   6

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movl	%eax, %ecx
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movl	%ecx, %edx
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movl	%edx, %ebp
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movl	%ebp, %esi
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movl	%esi, %edi
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movl	%edi, %r8d
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movl	%r8d, %r9d
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movl	%r9d, %r10d
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movl	%r10d, %r11d
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movl	%r11d, %r12d
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movl	%r12d, %r13d
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movl	%r13d, %r14d
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movl	%r14d, %r15d
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movl	%r15d, %eax

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789
# CHECK-NEXT: Index     0123456789          01234

# CHECK:      [0,0]     DR   .    .    .    .   .   movl	%eax, %ecx
# CHECK-NEXT: [0,1]     DR   .    .    .    .   .   movl	%ecx, %edx
# CHECK-NEXT: [0,2]     DR   .    .    .    .   .   movl	%edx, %ebp
# CHECK-NEXT: [0,3]     DR   .    .    .    .   .   movl	%ebp, %esi
# CHECK-NEXT: [0,4]     DR   .    .    .    .   .   movl	%esi, %edi
# CHECK-NEXT: [0,5]     DR   .    .    .    .   .   movl	%edi, %r8d
# CHECK-NEXT: [0,6]     .DR  .    .    .    .   .   movl	%r8d, %r9d
# CHECK-NEXT: [0,7]     .DR  .    .    .    .   .   movl	%r9d, %r10d
# CHECK-NEXT: [0,8]     .DR  .    .    .    .   .   movl	%r10d, %r11d
# CHECK-NEXT: [0,9]     .DR  .    .    .    .   .   movl	%r11d, %r12d
# CHECK-NEXT: [0,10]    .DR  .    .    .    .   .   movl	%r12d, %r13d
# CHECK-NEXT: [0,11]    .DR  .    .    .    .   .   movl	%r13d, %r14d
# CHECK-NEXT: [0,12]    . DR .    .    .    .   .   movl	%r14d, %r15d
# CHECK-NEXT: [0,13]    . DR .    .    .    .   .   movl	%r15d, %eax
# CHECK-NEXT: [1,0]     . DR .    .    .    .   .   movl	%eax, %ecx
# CHECK-NEXT: [1,1]     . DR .    .    .    .   .   movl	%ecx, %edx
# CHECK-NEXT: [1,2]     . DR .    .    .    .   .   movl	%edx, %ebp
# CHECK-NEXT: [1,3]     . DR .    .    .    .   .   movl	%ebp, %esi
# CHECK-NEXT: [1,4]     .  DR.    .    .    .   .   movl	%esi, %edi
# CHECK-NEXT: [1,5]     .  DR.    .    .    .   .   movl	%edi, %r8d
# CHECK-NEXT: [1,6]     .  DR.    .    .    .   .   movl	%r8d, %r9d
# CHECK-NEXT: [1,7]     .  DR.    .    .    .   .   movl	%r9d, %r10d
# CHECK-NEXT: [1,8]     .  DR.    .    .    .   .   movl	%r10d, %r11d
# CHECK-NEXT: [1,9]     .  DR.    .    .    .   .   movl	%r11d, %r12d
# CHECK-NEXT: [1,10]    .   DR    .    .    .   .   movl	%r12d, %r13d
# CHECK-NEXT: [1,11]    .   DR    .    .    .   .   movl	%r13d, %r14d
# CHECK-NEXT: [1,12]    .   DR    .    .    .   .   movl	%r14d, %r15d
# CHECK-NEXT: [1,13]    .   DR    .    .    .   .   movl	%r15d, %eax
# CHECK-NEXT: [2,0]     .   DR    .    .    .   .   movl	%eax, %ecx
# CHECK-NEXT: [2,1]     .   DR    .    .    .   .   movl	%ecx, %edx
# CHECK-NEXT: [2,2]     .    DR   .    .    .   .   movl	%edx, %ebp
# CHECK-NEXT: [2,3]     .    DR   .    .    .   .   movl	%ebp, %esi
# CHECK-NEXT: [2,4]     .    DR   .    .    .   .   movl	%esi, %edi
# CHECK-NEXT: [2,5]     .    DR   .    .    .   .   movl	%edi, %r8d
# CHECK-NEXT: [2,6]     .    DR   .    .    .   .   movl	%r8d, %r9d
# CHECK-NEXT: [2,7]     .    DR   .    .    .   .   movl	%r9d, %r10d
# CHECK-NEXT: [2,8]     .    .DR  .    .    .   .   movl	%r10d, %r11d
# CHECK-NEXT: [2,9]     .    .DR  .    .    .   .   movl	%r11d, %r12d
# CHECK-NEXT: [2,10]    .    .DR  .    .    .   .   movl	%r12d, %r13d
# CHECK-NEXT: [2,11]    .    .DR  .    .    .   .   movl	%r13d, %r14d
# CHECK-NEXT: [2,12]    .    .DR  .    .    .   .   movl	%r14d, %r15d
# CHECK-NEXT: [2,13]    .    .DR  .    .    .   .   movl	%r15d, %eax
# CHECK-NEXT: [3,0]     .    . DR .    .    .   .   movl	%eax, %ecx
# CHECK-NEXT: [3,1]     .    . DR .    .    .   .   movl	%ecx, %edx
# CHECK-NEXT: [3,2]     .    . DR .    .    .   .   movl	%edx, %ebp
# CHECK-NEXT: [3,3]     .    . DR .    .    .   .   movl	%ebp, %esi
# CHECK-NEXT: [3,4]     .    . DR .    .    .   .   movl	%esi, %edi
# CHECK-NEXT: [3,5]     .    . DR .    .    .   .   movl	%edi, %r8d
# CHECK-NEXT: [3,6]     .    .  DR.    .    .   .   movl	%r8d, %r9d
# CHECK-NEXT: [3,7]     .    .  DR.    .    .   .   movl	%r9d, %r10d
# CHECK-NEXT: [3,8]     .    .  DR.    .    .   .   movl	%r10d, %r11d
# CHECK-NEXT: [3,9]     .    .  DR.    .    .   .   movl	%r11d, %r12d
# CHECK-NEXT: [3,10]    .    .  DR.    .    .   .   movl	%r12d, %r13d
# CHECK-NEXT: [3,11]    .    .  DR.    .    .   .   movl	%r13d, %r14d
# CHECK-NEXT: [3,12]    .    .   DR    .    .   .   movl	%r14d, %r15d
# CHECK-NEXT: [3,13]    .    .   DR    .    .   .   movl	%r15d, %eax
# CHECK-NEXT: [4,0]     .    .   DR    .    .   .   movl	%eax, %ecx
# CHECK-NEXT: [4,1]     .    .   DR    .    .   .   movl	%ecx, %edx
# CHECK-NEXT: [4,2]     .    .   DR    .    .   .   movl	%edx, %ebp
# CHECK-NEXT: [4,3]     .    .   DR    .    .   .   movl	%ebp, %esi
# CHECK-NEXT: [4,4]     .    .    DR   .    .   .   movl	%esi, %edi
# CHECK-NEXT: [4,5]     .    .    DR   .    .   .   movl	%edi, %r8d
# CHECK-NEXT: [4,6]     .    .    DR   .    .   .   movl	%r8d, %r9d
# CHECK-NEXT: [4,7]     .    .    DR   .    .   .   movl	%r9d, %r10d
# CHECK-NEXT: [4,8]     .    .    DR   .    .   .   movl	%r10d, %r11d
# CHECK-NEXT: [4,9]     .    .    DR   .    .   .   movl	%r11d, %r12d
# CHECK-NEXT: [4,10]    .    .    .DR  .    .   .   movl	%r12d, %r13d
# CHECK-NEXT: [4,11]    .    .    .DR  .    .   .   movl	%r13d, %r14d
# CHECK-NEXT: [4,12]    .    .    .DR  .    .   .   movl	%r14d, %r15d
# CHECK-NEXT: [4,13]    .    .    .DR  .    .   .   movl	%r15d, %eax
# CHECK-NEXT: [5,0]     .    .    .DR  .    .   .   movl	%eax, %ecx
# CHECK-NEXT: [5,1]     .    .    .DR  .    .   .   movl	%ecx, %edx
# CHECK-NEXT: [5,2]     .    .    . DR .    .   .   movl	%edx, %ebp
# CHECK-NEXT: [5,3]     .    .    . DR .    .   .   movl	%ebp, %esi
# CHECK-NEXT: [5,4]     .    .    . DR .    .   .   movl	%esi, %edi
# CHECK-NEXT: [5,5]     .    .    . DR .    .   .   movl	%edi, %r8d
# CHECK-NEXT: [5,6]     .    .    . DR .    .   .   movl	%r8d, %r9d
# CHECK-NEXT: [5,7]     .    .    . DR .    .   .   movl	%r9d, %r10d
# CHECK-NEXT: [5,8]     .    .    .  DR.    .   .   movl	%r10d, %r11d
# CHECK-NEXT: [5,9]     .    .    .  DR.    .   .   movl	%r11d, %r12d
# CHECK-NEXT: [5,10]    .    .    .  DR.    .   .   movl	%r12d, %r13d
# CHECK-NEXT: [5,11]    .    .    .  DR.    .   .   movl	%r13d, %r14d
# CHECK-NEXT: [5,12]    .    .    .  DR.    .   .   movl	%r14d, %r15d
# CHECK-NEXT: [5,13]    .    .    .  DR.    .   .   movl	%r15d, %eax
# CHECK-NEXT: [6,0]     .    .    .   DR    .   .   movl	%eax, %ecx
# CHECK-NEXT: [6,1]     .    .    .   DR    .   .   movl	%ecx, %edx
# CHECK-NEXT: [6,2]     .    .    .   DR    .   .   movl	%edx, %ebp
# CHECK-NEXT: [6,3]     .    .    .   DR    .   .   movl	%ebp, %esi
# CHECK-NEXT: [6,4]     .    .    .   DR    .   .   movl	%esi, %edi
# CHECK-NEXT: [6,5]     .    .    .   DR    .   .   movl	%edi, %r8d
# CHECK-NEXT: [6,6]     .    .    .    DR   .   .   movl	%r8d, %r9d
# CHECK-NEXT: [6,7]     .    .    .    DR   .   .   movl	%r9d, %r10d
# CHECK-NEXT: [6,8]     .    .    .    DR   .   .   movl	%r10d, %r11d
# CHECK-NEXT: [6,9]     .    .    .    DR   .   .   movl	%r11d, %r12d
# CHECK-NEXT: [6,10]    .    .    .    DR   .   .   movl	%r12d, %r13d
# CHECK-NEXT: [6,11]    .    .    .    DR   .   .   movl	%r13d, %r14d
# CHECK-NEXT: [6,12]    .    .    .    .DR  .   .   movl	%r14d, %r15d
# CHECK-NEXT: [6,13]    .    .    .    .DR  .   .   movl	%r15d, %eax
# CHECK-NEXT: [7,0]     .    .    .    .DR  .   .   movl	%eax, %ecx
# CHECK-NEXT: [7,1]     .    .    .    .DR  .   .   movl	%ecx, %edx
# CHECK-NEXT: [7,2]     .    .    .    .DR  .   .   movl	%edx, %ebp
# CHECK-NEXT: [7,3]     .    .    .    .DR  .   .   movl	%ebp, %esi
# CHECK-NEXT: [7,4]     .    .    .    . DR .   .   movl	%esi, %edi
# CHECK-NEXT: [7,5]     .    .    .    . DR .   .   movl	%edi, %r8d
# CHECK-NEXT: [7,6]     .    .    .    . DR .   .   movl	%r8d, %r9d
# CHECK-NEXT: [7,7]     .    .    .    . DR .   .   movl	%r9d, %r10d
# CHECK-NEXT: [7,8]     .    .    .    . DR .   .   movl	%r10d, %r11d
# CHECK-NEXT: [7,9]     .    .    .    . DR .   .   movl	%r11d, %r12d
# CHECK-NEXT: [7,10]    .    .    .    .  DR.   .   movl	%r12d, %r13d
# CHECK-NEXT: [7,11]    .    .    .    .  DR.   .   movl	%r13d, %r14d
# CHECK-NEXT: [7,12]    .    .    .    .  DR.   .   movl	%r14d, %r15d
# CHECK-NEXT: [7,13]    .    .    .    .  DR.   .   movl	%r15d, %eax
# CHECK-NEXT: [8,0]     .    .    .    .  DR.   .   movl	%eax, %ecx
# CHECK-NEXT: [8,1]     .    .    .    .  DR.   .   movl	%ecx, %edx
# CHECK-NEXT: [8,2]     .    .    .    .   DR   .   movl	%edx, %ebp
# CHECK-NEXT: [8,3]     .    .    .    .   DR   .   movl	%ebp, %esi
# CHECK-NEXT: [8,4]     .    .    .    .   DR   .   movl	%esi, %edi
# CHECK-NEXT: [8,5]     .    .    .    .   DR   .   movl	%edi, %r8d
# CHECK-NEXT: [8,6]     .    .    .    .   DR   .   movl	%r8d, %r9d
# CHECK-NEXT: [8,7]     .    .    .    .   DR   .   movl	%r9d, %r10d
# CHECK-NEXT: [8,8]     .    .    .    .    DR  .   movl	%r10d, %r11d
# CHECK-NEXT: [8,9]     .    .    .    .    DR  .   movl	%r11d, %r12d
# CHECK-NEXT: [8,10]    .    .    .    .    DR  .   movl	%r12d, %r13d
# CHECK-NEXT: [8,11]    .    .    .    .    DR  .   movl	%r13d, %r14d
# CHECK-NEXT: [8,12]    .    .    .    .    DR  .   movl	%r14d, %r15d
# CHECK-NEXT: [8,13]    .    .    .    .    DR  .   movl	%r15d, %eax
# CHECK-NEXT: [9,0]     .    .    .    .    .DR .   movl	%eax, %ecx
# CHECK-NEXT: [9,1]     .    .    .    .    .DR .   movl	%ecx, %edx
# CHECK-NEXT: [9,2]     .    .    .    .    .DR .   movl	%edx, %ebp
# CHECK-NEXT: [9,3]     .    .    .    .    .DR .   movl	%ebp, %esi
# CHECK-NEXT: [9,4]     .    .    .    .    .DR .   movl	%esi, %edi
# CHECK-NEXT: [9,5]     .    .    .    .    .DR .   movl	%edi, %r8d
# CHECK-NEXT: [9,6]     .    .    .    .    . DR.   movl	%r8d, %r9d
# CHECK-NEXT: [9,7]     .    .    .    .    . DR.   movl	%r9d, %r10d
# CHECK-NEXT: [9,8]     .    .    .    .    . DR.   movl	%r10d, %r11d
# CHECK-NEXT: [9,9]     .    .    .    .    . DR.   movl	%r11d, %r12d
# CHECK-NEXT: [9,10]    .    .    .    .    . DR.   movl	%r12d, %r13d
# CHECK-NEXT: [9,11]    .    .    .    .    . DR.   movl	%r13d, %r14d
# CHECK-NEXT: [9,12]    .    .    .    .    .  DR   movl	%r14d, %r15d
# CHECK-NEXT: [9,13]    .    .    .    .    .  DR   movl	%r15d, %eax

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     10    0.0    0.0    0.0       movl	%eax, %ecx
# CHECK-NEXT: 1.     10    0.0    0.0    0.0       movl	%ecx, %edx
# CHECK-NEXT: 2.     10    0.0    0.0    0.0       movl	%edx, %ebp
# CHECK-NEXT: 3.     10    0.0    0.0    0.0       movl	%ebp, %esi
# CHECK-NEXT: 4.     10    0.0    0.0    0.0       movl	%esi, %edi
# CHECK-NEXT: 5.     10    0.0    0.0    0.0       movl	%edi, %r8d
# CHECK-NEXT: 6.     10    0.0    0.0    0.0       movl	%r8d, %r9d
# CHECK-NEXT: 7.     10    0.0    0.0    0.0       movl	%r9d, %r10d
# CHECK-NEXT: 8.     10    0.0    0.0    0.0       movl	%r10d, %r11d
# CHECK-NEXT: 9.     10    0.0    0.0    0.0       movl	%r11d, %r12d
# CHECK-NEXT: 10.    10    0.0    0.0    0.0       movl	%r12d, %r13d
# CHECK-NEXT: 11.    10    0.0    0.0    0.0       movl	%r13d, %r14d
# CHECK-NEXT: 12.    10    0.0    0.0    0.0       movl	%r14d, %r15d
# CHECK-NEXT: 13.    10    0.0    0.0    0.0       movl	%r15d, %eax
# CHECK-NEXT:        10    0.0    0.0    0.0       <total>

# CHECK:      [1] Code Region

# CHECK:      Iterations:        1000
# CHECK-NEXT: Instructions:      14000
# CHECK-NEXT: Total Cycles:      2335
# CHECK-NEXT: Total uOps:        14000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    6.00
# CHECK-NEXT: IPC:               6.00
# CHECK-NEXT: Block RThroughput: 2.3

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      0     0.17                        movq	%rax, %rcx
# CHECK-NEXT:  1      0     0.17                        movq	%rcx, %rdx
# CHECK-NEXT:  1      0     0.17                        movq	%rdx, %rbp
# CHECK-NEXT:  1      0     0.17                        movq	%rbp, %rsi
# CHECK-NEXT:  1      0     0.17                        movq	%rsi, %rdi
# CHECK-NEXT:  1      0     0.17                        movq	%rdi, %r8
# CHECK-NEXT:  1      0     0.17                        movq	%r8, %r9
# CHECK-NEXT:  1      0     0.17                        movq	%r9, %r10
# CHECK-NEXT:  1      0     0.17                        movq	%r10, %r11
# CHECK-NEXT:  1      0     0.17                        movq	%r11, %r12
# CHECK-NEXT:  1      0     0.17                        movq	%r12, %r13
# CHECK-NEXT:  1      0     0.17                        movq	%r13, %r14
# CHECK-NEXT:  1      0     0.17                        movq	%r14, %r15
# CHECK-NEXT:  1      0     0.17                        movq	%r15, %rax

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    0
# CHECK-NEXT: Max number of mappings used:         0

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0
# CHECK-NEXT:    Number of optimizable moves:      14000
# CHECK-NEXT:    Number of moves eliminated:       14000  (100.0%)
# CHECK-NEXT:    Number of zero moves:             0  (0.0%)
# CHECK-NEXT:    Max moves eliminated per cycle:   6

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%rax, %rcx
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%rcx, %rdx
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%rdx, %rbp
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%rbp, %rsi
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%rsi, %rdi
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%rdi, %r8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%r8, %r9
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%r9, %r10
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%r10, %r11
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%r11, %r12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%r12, %r13
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%r13, %r14
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%r14, %r15
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     movq	%r15, %rax

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789
# CHECK-NEXT: Index     0123456789          01234

# CHECK:      [0,0]     DR   .    .    .    .   .   movq	%rax, %rcx
# CHECK-NEXT: [0,1]     DR   .    .    .    .   .   movq	%rcx, %rdx
# CHECK-NEXT: [0,2]     DR   .    .    .    .   .   movq	%rdx, %rbp
# CHECK-NEXT: [0,3]     DR   .    .    .    .   .   movq	%rbp, %rsi
# CHECK-NEXT: [0,4]     DR   .    .    .    .   .   movq	%rsi, %rdi
# CHECK-NEXT: [0,5]     DR   .    .    .    .   .   movq	%rdi, %r8
# CHECK-NEXT: [0,6]     .DR  .    .    .    .   .   movq	%r8, %r9
# CHECK-NEXT: [0,7]     .DR  .    .    .    .   .   movq	%r9, %r10
# CHECK-NEXT: [0,8]     .DR  .    .    .    .   .   movq	%r10, %r11
# CHECK-NEXT: [0,9]     .DR  .    .    .    .   .   movq	%r11, %r12
# CHECK-NEXT: [0,10]    .DR  .    .    .    .   .   movq	%r12, %r13
# CHECK-NEXT: [0,11]    .DR  .    .    .    .   .   movq	%r13, %r14
# CHECK-NEXT: [0,12]    . DR .    .    .    .   .   movq	%r14, %r15
# CHECK-NEXT: [0,13]    . DR .    .    .    .   .   movq	%r15, %rax
# CHECK-NEXT: [1,0]     . DR .    .    .    .   .   movq	%rax, %rcx
# CHECK-NEXT: [1,1]     . DR .    .    .    .   .   movq	%rcx, %rdx
# CHECK-NEXT: [1,2]     . DR .    .    .    .   .   movq	%rdx, %rbp
# CHECK-NEXT: [1,3]     . DR .    .    .    .   .   movq	%rbp, %rsi
# CHECK-NEXT: [1,4]     .  DR.    .    .    .   .   movq	%rsi, %rdi
# CHECK-NEXT: [1,5]     .  DR.    .    .    .   .   movq	%rdi, %r8
# CHECK-NEXT: [1,6]     .  DR.    .    .    .   .   movq	%r8, %r9
# CHECK-NEXT: [1,7]     .  DR.    .    .    .   .   movq	%r9, %r10
# CHECK-NEXT: [1,8]     .  DR.    .    .    .   .   movq	%r10, %r11
# CHECK-NEXT: [1,9]     .  DR.    .    .    .   .   movq	%r11, %r12
# CHECK-NEXT: [1,10]    .   DR    .    .    .   .   movq	%r12, %r13
# CHECK-NEXT: [1,11]    .   DR    .    .    .   .   movq	%r13, %r14
# CHECK-NEXT: [1,12]    .   DR    .    .    .   .   movq	%r14, %r15
# CHECK-NEXT: [1,13]    .   DR    .    .    .   .   movq	%r15, %rax
# CHECK-NEXT: [2,0]     .   DR    .    .    .   .   movq	%rax, %rcx
# CHECK-NEXT: [2,1]     .   DR    .    .    .   .   movq	%rcx, %rdx
# CHECK-NEXT: [2,2]     .    DR   .    .    .   .   movq	%rdx, %rbp
# CHECK-NEXT: [2,3]     .    DR   .    .    .   .   movq	%rbp, %rsi
# CHECK-NEXT: [2,4]     .    DR   .    .    .   .   movq	%rsi, %rdi
# CHECK-NEXT: [2,5]     .    DR   .    .    .   .   movq	%rdi, %r8
# CHECK-NEXT: [2,6]     .    DR   .    .    .   .   movq	%r8, %r9
# CHECK-NEXT: [2,7]     .    DR   .    .    .   .   movq	%r9, %r10
# CHECK-NEXT: [2,8]     .    .DR  .    .    .   .   movq	%r10, %r11
# CHECK-NEXT: [2,9]     .    .DR  .    .    .   .   movq	%r11, %r12
# CHECK-NEXT: [2,10]    .    .DR  .    .    .   .   movq	%r12, %r13
# CHECK-NEXT: [2,11]    .    .DR  .    .    .   .   movq	%r13, %r14
# CHECK-NEXT: [2,12]    .    .DR  .    .    .   .   movq	%r14, %r15
# CHECK-NEXT: [2,13]    .    .DR  .    .    .   .   movq	%r15, %rax
# CHECK-NEXT: [3,0]     .    . DR .    .    .   .   movq	%rax, %rcx
# CHECK-NEXT: [3,1]     .    . DR .    .    .   .   movq	%rcx, %rdx
# CHECK-NEXT: [3,2]     .    . DR .    .    .   .   movq	%rdx, %rbp
# CHECK-NEXT: [3,3]     .    . DR .    .    .   .   movq	%rbp, %rsi
# CHECK-NEXT: [3,4]     .    . DR .    .    .   .   movq	%rsi, %rdi
# CHECK-NEXT: [3,5]     .    . DR .    .    .   .   movq	%rdi, %r8
# CHECK-NEXT: [3,6]     .    .  DR.    .    .   .   movq	%r8, %r9
# CHECK-NEXT: [3,7]     .    .  DR.    .    .   .   movq	%r9, %r10
# CHECK-NEXT: [3,8]     .    .  DR.    .    .   .   movq	%r10, %r11
# CHECK-NEXT: [3,9]     .    .  DR.    .    .   .   movq	%r11, %r12
# CHECK-NEXT: [3,10]    .    .  DR.    .    .   .   movq	%r12, %r13
# CHECK-NEXT: [3,11]    .    .  DR.    .    .   .   movq	%r13, %r14
# CHECK-NEXT: [3,12]    .    .   DR    .    .   .   movq	%r14, %r15
# CHECK-NEXT: [3,13]    .    .   DR    .    .   .   movq	%r15, %rax
# CHECK-NEXT: [4,0]     .    .   DR    .    .   .   movq	%rax, %rcx
# CHECK-NEXT: [4,1]     .    .   DR    .    .   .   movq	%rcx, %rdx
# CHECK-NEXT: [4,2]     .    .   DR    .    .   .   movq	%rdx, %rbp
# CHECK-NEXT: [4,3]     .    .   DR    .    .   .   movq	%rbp, %rsi
# CHECK-NEXT: [4,4]     .    .    DR   .    .   .   movq	%rsi, %rdi
# CHECK-NEXT: [4,5]     .    .    DR   .    .   .   movq	%rdi, %r8
# CHECK-NEXT: [4,6]     .    .    DR   .    .   .   movq	%r8, %r9
# CHECK-NEXT: [4,7]     .    .    DR   .    .   .   movq	%r9, %r10
# CHECK-NEXT: [4,8]     .    .    DR   .    .   .   movq	%r10, %r11
# CHECK-NEXT: [4,9]     .    .    DR   .    .   .   movq	%r11, %r12
# CHECK-NEXT: [4,10]    .    .    .DR  .    .   .   movq	%r12, %r13
# CHECK-NEXT: [4,11]    .    .    .DR  .    .   .   movq	%r13, %r14
# CHECK-NEXT: [4,12]    .    .    .DR  .    .   .   movq	%r14, %r15
# CHECK-NEXT: [4,13]    .    .    .DR  .    .   .   movq	%r15, %rax
# CHECK-NEXT: [5,0]     .    .    .DR  .    .   .   movq	%rax, %rcx
# CHECK-NEXT: [5,1]     .    .    .DR  .    .   .   movq	%rcx, %rdx
# CHECK-NEXT: [5,2]     .    .    . DR .    .   .   movq	%rdx, %rbp
# CHECK-NEXT: [5,3]     .    .    . DR .    .   .   movq	%rbp, %rsi
# CHECK-NEXT: [5,4]     .    .    . DR .    .   .   movq	%rsi, %rdi
# CHECK-NEXT: [5,5]     .    .    . DR .    .   .   movq	%rdi, %r8
# CHECK-NEXT: [5,6]     .    .    . DR .    .   .   movq	%r8, %r9
# CHECK-NEXT: [5,7]     .    .    . DR .    .   .   movq	%r9, %r10
# CHECK-NEXT: [5,8]     .    .    .  DR.    .   .   movq	%r10, %r11
# CHECK-NEXT: [5,9]     .    .    .  DR.    .   .   movq	%r11, %r12
# CHECK-NEXT: [5,10]    .    .    .  DR.    .   .   movq	%r12, %r13
# CHECK-NEXT: [5,11]    .    .    .  DR.    .   .   movq	%r13, %r14
# CHECK-NEXT: [5,12]    .    .    .  DR.    .   .   movq	%r14, %r15
# CHECK-NEXT: [5,13]    .    .    .  DR.    .   .   movq	%r15, %rax
# CHECK-NEXT: [6,0]     .    .    .   DR    .   .   movq	%rax, %rcx
# CHECK-NEXT: [6,1]     .    .    .   DR    .   .   movq	%rcx, %rdx
# CHECK-NEXT: [6,2]     .    .    .   DR    .   .   movq	%rdx, %rbp
# CHECK-NEXT: [6,3]     .    .    .   DR    .   .   movq	%rbp, %rsi
# CHECK-NEXT: [6,4]     .    .    .   DR    .   .   movq	%rsi, %rdi
# CHECK-NEXT: [6,5]     .    .    .   DR    .   .   movq	%rdi, %r8
# CHECK-NEXT: [6,6]     .    .    .    DR   .   .   movq	%r8, %r9
# CHECK-NEXT: [6,7]     .    .    .    DR   .   .   movq	%r9, %r10
# CHECK-NEXT: [6,8]     .    .    .    DR   .   .   movq	%r10, %r11
# CHECK-NEXT: [6,9]     .    .    .    DR   .   .   movq	%r11, %r12
# CHECK-NEXT: [6,10]    .    .    .    DR   .   .   movq	%r12, %r13
# CHECK-NEXT: [6,11]    .    .    .    DR   .   .   movq	%r13, %r14
# CHECK-NEXT: [6,12]    .    .    .    .DR  .   .   movq	%r14, %r15
# CHECK-NEXT: [6,13]    .    .    .    .DR  .   .   movq	%r15, %rax
# CHECK-NEXT: [7,0]     .    .    .    .DR  .   .   movq	%rax, %rcx
# CHECK-NEXT: [7,1]     .    .    .    .DR  .   .   movq	%rcx, %rdx
# CHECK-NEXT: [7,2]     .    .    .    .DR  .   .   movq	%rdx, %rbp
# CHECK-NEXT: [7,3]     .    .    .    .DR  .   .   movq	%rbp, %rsi
# CHECK-NEXT: [7,4]     .    .    .    . DR .   .   movq	%rsi, %rdi
# CHECK-NEXT: [7,5]     .    .    .    . DR .   .   movq	%rdi, %r8
# CHECK-NEXT: [7,6]     .    .    .    . DR .   .   movq	%r8, %r9
# CHECK-NEXT: [7,7]     .    .    .    . DR .   .   movq	%r9, %r10
# CHECK-NEXT: [7,8]     .    .    .    . DR .   .   movq	%r10, %r11
# CHECK-NEXT: [7,9]     .    .    .    . DR .   .   movq	%r11, %r12
# CHECK-NEXT: [7,10]    .    .    .    .  DR.   .   movq	%r12, %r13
# CHECK-NEXT: [7,11]    .    .    .    .  DR.   .   movq	%r13, %r14
# CHECK-NEXT: [7,12]    .    .    .    .  DR.   .   movq	%r14, %r15
# CHECK-NEXT: [7,13]    .    .    .    .  DR.   .   movq	%r15, %rax
# CHECK-NEXT: [8,0]     .    .    .    .  DR.   .   movq	%rax, %rcx
# CHECK-NEXT: [8,1]     .    .    .    .  DR.   .   movq	%rcx, %rdx
# CHECK-NEXT: [8,2]     .    .    .    .   DR   .   movq	%rdx, %rbp
# CHECK-NEXT: [8,3]     .    .    .    .   DR   .   movq	%rbp, %rsi
# CHECK-NEXT: [8,4]     .    .    .    .   DR   .   movq	%rsi, %rdi
# CHECK-NEXT: [8,5]     .    .    .    .   DR   .   movq	%rdi, %r8
# CHECK-NEXT: [8,6]     .    .    .    .   DR   .   movq	%r8, %r9
# CHECK-NEXT: [8,7]     .    .    .    .   DR   .   movq	%r9, %r10
# CHECK-NEXT: [8,8]     .    .    .    .    DR  .   movq	%r10, %r11
# CHECK-NEXT: [8,9]     .    .    .    .    DR  .   movq	%r11, %r12
# CHECK-NEXT: [8,10]    .    .    .    .    DR  .   movq	%r12, %r13
# CHECK-NEXT: [8,11]    .    .    .    .    DR  .   movq	%r13, %r14
# CHECK-NEXT: [8,12]    .    .    .    .    DR  .   movq	%r14, %r15
# CHECK-NEXT: [8,13]    .    .    .    .    DR  .   movq	%r15, %rax
# CHECK-NEXT: [9,0]     .    .    .    .    .DR .   movq	%rax, %rcx
# CHECK-NEXT: [9,1]     .    .    .    .    .DR .   movq	%rcx, %rdx
# CHECK-NEXT: [9,2]     .    .    .    .    .DR .   movq	%rdx, %rbp
# CHECK-NEXT: [9,3]     .    .    .    .    .DR .   movq	%rbp, %rsi
# CHECK-NEXT: [9,4]     .    .    .    .    .DR .   movq	%rsi, %rdi
# CHECK-NEXT: [9,5]     .    .    .    .    .DR .   movq	%rdi, %r8
# CHECK-NEXT: [9,6]     .    .    .    .    . DR.   movq	%r8, %r9
# CHECK-NEXT: [9,7]     .    .    .    .    . DR.   movq	%r9, %r10
# CHECK-NEXT: [9,8]     .    .    .    .    . DR.   movq	%r10, %r11
# CHECK-NEXT: [9,9]     .    .    .    .    . DR.   movq	%r11, %r12
# CHECK-NEXT: [9,10]    .    .    .    .    . DR.   movq	%r12, %r13
# CHECK-NEXT: [9,11]    .    .    .    .    . DR.   movq	%r13, %r14
# CHECK-NEXT: [9,12]    .    .    .    .    .  DR   movq	%r14, %r15
# CHECK-NEXT: [9,13]    .    .    .    .    .  DR   movq	%r15, %rax

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     10    0.0    0.0    0.0       movq	%rax, %rcx
# CHECK-NEXT: 1.     10    0.0    0.0    0.0       movq	%rcx, %rdx
# CHECK-NEXT: 2.     10    0.0    0.0    0.0       movq	%rdx, %rbp
# CHECK-NEXT: 3.     10    0.0    0.0    0.0       movq	%rbp, %rsi
# CHECK-NEXT: 4.     10    0.0    0.0    0.0       movq	%rsi, %rdi
# CHECK-NEXT: 5.     10    0.0    0.0    0.0       movq	%rdi, %r8
# CHECK-NEXT: 6.     10    0.0    0.0    0.0       movq	%r8, %r9
# CHECK-NEXT: 7.     10    0.0    0.0    0.0       movq	%r9, %r10
# CHECK-NEXT: 8.     10    0.0    0.0    0.0       movq	%r10, %r11
# CHECK-NEXT: 9.     10    0.0    0.0    0.0       movq	%r11, %r12
# CHECK-NEXT: 10.    10    0.0    0.0    0.0       movq	%r12, %r13
# CHECK-NEXT: 11.    10    0.0    0.0    0.0       movq	%r13, %r14
# CHECK-NEXT: 12.    10    0.0    0.0    0.0       movq	%r14, %r15
# CHECK-NEXT: 13.    10    0.0    0.0    0.0       movq	%r15, %rax
# CHECK-NEXT:        10    0.0    0.0    0.0       <total>

# CHECK:      [2] Code Region

# CHECK:      Iterations:        1000
# CHECK-NEXT: Instructions:      14000
# CHECK-NEXT: Total Cycles:      4668
# CHECK-NEXT: Total uOps:        28000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    6.00
# CHECK-NEXT: IPC:               3.00
# CHECK-NEXT: Block RThroughput: 4.7

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  2      0     0.33                        xchgl	%ecx, %eax
# CHECK-NEXT:  2      0     0.33                        xchgl	%ecx, %edx
# CHECK-NEXT:  2      0     0.33                        xchgl	%edx, %ebp
# CHECK-NEXT:  2      0     0.33                        xchgl	%ebp, %esi
# CHECK-NEXT:  2      0     0.33                        xchgl	%esi, %edi
# CHECK-NEXT:  2      0     0.33                        xchgl	%edi, %r8d
# CHECK-NEXT:  2      0     0.33                        xchgl	%r8d, %r9d
# CHECK-NEXT:  2      0     0.33                        xchgl	%r9d, %r10d
# CHECK-NEXT:  2      0     0.33                        xchgl	%r10d, %r11d
# CHECK-NEXT:  2      0     0.33                        xchgl	%r11d, %r12d
# CHECK-NEXT:  2      0     0.33                        xchgl	%r12d, %r13d
# CHECK-NEXT:  2      0     0.33                        xchgl	%r13d, %r14d
# CHECK-NEXT:  2      0     0.33                        xchgl	%r14d, %r15d
# CHECK-NEXT:  2      0     0.33                        xchgl	%r15d, %eax

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    0
# CHECK-NEXT: Max number of mappings used:         0

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0
# CHECK-NEXT:    Number of optimizable moves:      28000
# CHECK-NEXT:    Number of moves eliminated:       28000  (100.0%)
# CHECK-NEXT:    Number of zero moves:             0  (0.0%)
# CHECK-NEXT:    Max moves eliminated per cycle:   6

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgl	%ecx, %eax
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgl	%ecx, %edx
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgl	%edx, %ebp
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgl	%ebp, %esi
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgl	%esi, %edi
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgl	%edi, %r8d
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgl	%r8d, %r9d
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgl	%r9d, %r10d
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgl	%r10d, %r11d
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgl	%r11d, %r12d
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgl	%r12d, %r13d
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgl	%r13d, %r14d
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgl	%r14d, %r15d
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgl	%r15d, %eax

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789          0123456789
# CHECK-NEXT: Index     0123456789          0123456789          01234567

# CHECK:      [0,0]     DR   .    .    .    .    .    .    .    .    . .   xchgl	%ecx, %eax
# CHECK-NEXT: [0,1]     DR   .    .    .    .    .    .    .    .    . .   xchgl	%ecx, %edx
# CHECK-NEXT: [0,2]     DR   .    .    .    .    .    .    .    .    . .   xchgl	%edx, %ebp
# CHECK-NEXT: [0,3]     .DR  .    .    .    .    .    .    .    .    . .   xchgl	%ebp, %esi
# CHECK-NEXT: [0,4]     .DR  .    .    .    .    .    .    .    .    . .   xchgl	%esi, %edi
# CHECK-NEXT: [0,5]     .DR  .    .    .    .    .    .    .    .    . .   xchgl	%edi, %r8d
# CHECK-NEXT: [0,6]     . DR .    .    .    .    .    .    .    .    . .   xchgl	%r8d, %r9d
# CHECK-NEXT: [0,7]     . DR .    .    .    .    .    .    .    .    . .   xchgl	%r9d, %r10d
# CHECK-NEXT: [0,8]     . DR .    .    .    .    .    .    .    .    . .   xchgl	%r10d, %r11d
# CHECK-NEXT: [0,9]     .  DR.    .    .    .    .    .    .    .    . .   xchgl	%r11d, %r12d
# CHECK-NEXT: [0,10]    .  DR.    .    .    .    .    .    .    .    . .   xchgl	%r12d, %r13d
# CHECK-NEXT: [0,11]    .  DR.    .    .    .    .    .    .    .    . .   xchgl	%r13d, %r14d
# CHECK-NEXT: [0,12]    .   DR    .    .    .    .    .    .    .    . .   xchgl	%r14d, %r15d
# CHECK-NEXT: [0,13]    .   DR    .    .    .    .    .    .    .    . .   xchgl	%r15d, %eax
# CHECK-NEXT: [1,0]     .   DR    .    .    .    .    .    .    .    . .   xchgl	%ecx, %eax
# CHECK-NEXT: [1,1]     .    DR   .    .    .    .    .    .    .    . .   xchgl	%ecx, %edx
# CHECK-NEXT: [1,2]     .    DR   .    .    .    .    .    .    .    . .   xchgl	%edx, %ebp
# CHECK-NEXT: [1,3]     .    DR   .    .    .    .    .    .    .    . .   xchgl	%ebp, %esi
# CHECK-NEXT: [1,4]     .    .DR  .    .    .    .    .    .    .    . .   xchgl	%esi, %edi
# CHECK-NEXT: [1,5]     .    .DR  .    .    .    .    .    .    .    . .   xchgl	%edi, %r8d
# CHECK-NEXT: [1,6]     .    .DR  .    .    .    .    .    .    .    . .   xchgl	%r8d, %r9d
# CHECK-NEXT: [1,7]     .    . DR .    .    .    .    .    .    .    . .   xchgl	%r9d, %r10d
# CHECK-NEXT: [1,8]     .    . DR .    .    .    .    .    .    .    . .   xchgl	%r10d, %r11d
# CHECK-NEXT: [1,9]     .    . DR .    .    .    .    .    .    .    . .   xchgl	%r11d, %r12d
# CHECK-NEXT: [1,10]    .    .  DR.    .    .    .    .    .    .    . .   xchgl	%r12d, %r13d
# CHECK-NEXT: [1,11]    .    .  DR.    .    .    .    .    .    .    . .   xchgl	%r13d, %r14d
# CHECK-NEXT: [1,12]    .    .  DR.    .    .    .    .    .    .    . .   xchgl	%r14d, %r15d
# CHECK-NEXT: [1,13]    .    .   DR    .    .    .    .    .    .    . .   xchgl	%r15d, %eax
# CHECK-NEXT: [2,0]     .    .   DR    .    .    .    .    .    .    . .   xchgl	%ecx, %eax
# CHECK-NEXT: [2,1]     .    .   DR    .    .    .    .    .    .    . .   xchgl	%ecx, %edx
# CHECK-NEXT: [2,2]     .    .    DR   .    .    .    .    .    .    . .   xchgl	%edx, %ebp
# CHECK-NEXT: [2,3]     .    .    DR   .    .    .    .    .    .    . .   xchgl	%ebp, %esi
# CHECK-NEXT: [2,4]     .    .    DR   .    .    .    .    .    .    . .   xchgl	%esi, %edi
# CHECK-NEXT: [2,5]     .    .    .DR  .    .    .    .    .    .    . .   xchgl	%edi, %r8d
# CHECK-NEXT: [2,6]     .    .    .DR  .    .    .    .    .    .    . .   xchgl	%r8d, %r9d
# CHECK-NEXT: [2,7]     .    .    .DR  .    .    .    .    .    .    . .   xchgl	%r9d, %r10d
# CHECK-NEXT: [2,8]     .    .    . DR .    .    .    .    .    .    . .   xchgl	%r10d, %r11d
# CHECK-NEXT: [2,9]     .    .    . DR .    .    .    .    .    .    . .   xchgl	%r11d, %r12d
# CHECK-NEXT: [2,10]    .    .    . DR .    .    .    .    .    .    . .   xchgl	%r12d, %r13d
# CHECK-NEXT: [2,11]    .    .    .  DR.    .    .    .    .    .    . .   xchgl	%r13d, %r14d
# CHECK-NEXT: [2,12]    .    .    .  DR.    .    .    .    .    .    . .   xchgl	%r14d, %r15d
# CHECK-NEXT: [2,13]    .    .    .  DR.    .    .    .    .    .    . .   xchgl	%r15d, %eax
# CHECK-NEXT: [3,0]     .    .    .   DR    .    .    .    .    .    . .   xchgl	%ecx, %eax
# CHECK-NEXT: [3,1]     .    .    .   DR    .    .    .    .    .    . .   xchgl	%ecx, %edx
# CHECK-NEXT: [3,2]     .    .    .   DR    .    .    .    .    .    . .   xchgl	%edx, %ebp
# CHECK-NEXT: [3,3]     .    .    .    DR   .    .    .    .    .    . .   xchgl	%ebp, %esi
# CHECK-NEXT: [3,4]     .    .    .    DR   .    .    .    .    .    . .   xchgl	%esi, %edi
# CHECK-NEXT: [3,5]     .    .    .    DR   .    .    .    .    .    . .   xchgl	%edi, %r8d
# CHECK-NEXT: [3,6]     .    .    .    .DR  .    .    .    .    .    . .   xchgl	%r8d, %r9d
# CHECK-NEXT: [3,7]     .    .    .    .DR  .    .    .    .    .    . .   xchgl	%r9d, %r10d
# CHECK-NEXT: [3,8]     .    .    .    .DR  .    .    .    .    .    . .   xchgl	%r10d, %r11d
# CHECK-NEXT: [3,9]     .    .    .    . DR .    .    .    .    .    . .   xchgl	%r11d, %r12d
# CHECK-NEXT: [3,10]    .    .    .    . DR .    .    .    .    .    . .   xchgl	%r12d, %r13d
# CHECK-NEXT: [3,11]    .    .    .    . DR .    .    .    .    .    . .   xchgl	%r13d, %r14d
# CHECK-NEXT: [3,12]    .    .    .    .  DR.    .    .    .    .    . .   xchgl	%r14d, %r15d
# CHECK-NEXT: [3,13]    .    .    .    .  DR.    .    .    .    .    . .   xchgl	%r15d, %eax
# CHECK-NEXT: [4,0]     .    .    .    .  DR.    .    .    .    .    . .   xchgl	%ecx, %eax
# CHECK-NEXT: [4,1]     .    .    .    .   DR    .    .    .    .    . .   xchgl	%ecx, %edx
# CHECK-NEXT: [4,2]     .    .    .    .   DR    .    .    .    .    . .   xchgl	%edx, %ebp
# CHECK-NEXT: [4,3]     .    .    .    .   DR    .    .    .    .    . .   xchgl	%ebp, %esi
# CHECK-NEXT: [4,4]     .    .    .    .    DR   .    .    .    .    . .   xchgl	%esi, %edi
# CHECK-NEXT: [4,5]     .    .    .    .    DR   .    .    .    .    . .   xchgl	%edi, %r8d
# CHECK-NEXT: [4,6]     .    .    .    .    DR   .    .    .    .    . .   xchgl	%r8d, %r9d
# CHECK-NEXT: [4,7]     .    .    .    .    .DR  .    .    .    .    . .   xchgl	%r9d, %r10d
# CHECK-NEXT: [4,8]     .    .    .    .    .DR  .    .    .    .    . .   xchgl	%r10d, %r11d
# CHECK-NEXT: [4,9]     .    .    .    .    .DR  .    .    .    .    . .   xchgl	%r11d, %r12d
# CHECK-NEXT: [4,10]    .    .    .    .    . DR .    .    .    .    . .   xchgl	%r12d, %r13d
# CHECK-NEXT: [4,11]    .    .    .    .    . DR .    .    .    .    . .   xchgl	%r13d, %r14d
# CHECK-NEXT: [4,12]    .    .    .    .    . DR .    .    .    .    . .   xchgl	%r14d, %r15d
# CHECK-NEXT: [4,13]    .    .    .    .    .  DR.    .    .    .    . .   xchgl	%r15d, %eax
# CHECK-NEXT: [5,0]     .    .    .    .    .  DR.    .    .    .    . .   xchgl	%ecx, %eax
# CHECK-NEXT: [5,1]     .    .    .    .    .  DR.    .    .    .    . .   xchgl	%ecx, %edx
# CHECK-NEXT: [5,2]     .    .    .    .    .   DR    .    .    .    . .   xchgl	%edx, %ebp
# CHECK-NEXT: [5,3]     .    .    .    .    .   DR    .    .    .    . .   xchgl	%ebp, %esi
# CHECK-NEXT: [5,4]     .    .    .    .    .   DR    .    .    .    . .   xchgl	%esi, %edi
# CHECK-NEXT: [5,5]     .    .    .    .    .    DR   .    .    .    . .   xchgl	%edi, %r8d
# CHECK-NEXT: [5,6]     .    .    .    .    .    DR   .    .    .    . .   xchgl	%r8d, %r9d
# CHECK-NEXT: [5,7]     .    .    .    .    .    DR   .    .    .    . .   xchgl	%r9d, %r10d
# CHECK-NEXT: [5,8]     .    .    .    .    .    .DR  .    .    .    . .   xchgl	%r10d, %r11d
# CHECK-NEXT: [5,9]     .    .    .    .    .    .DR  .    .    .    . .   xchgl	%r11d, %r12d
# CHECK-NEXT: [5,10]    .    .    .    .    .    .DR  .    .    .    . .   xchgl	%r12d, %r13d
# CHECK-NEXT: [5,11]    .    .    .    .    .    . DR .    .    .    . .   xchgl	%r13d, %r14d
# CHECK-NEXT: [5,12]    .    .    .    .    .    . DR .    .    .    . .   xchgl	%r14d, %r15d
# CHECK-NEXT: [5,13]    .    .    .    .    .    . DR .    .    .    . .   xchgl	%r15d, %eax
# CHECK-NEXT: [6,0]     .    .    .    .    .    .  DR.    .    .    . .   xchgl	%ecx, %eax
# CHECK-NEXT: [6,1]     .    .    .    .    .    .  DR.    .    .    . .   xchgl	%ecx, %edx
# CHECK-NEXT: [6,2]     .    .    .    .    .    .  DR.    .    .    . .   xchgl	%edx, %ebp
# CHECK-NEXT: [6,3]     .    .    .    .    .    .   DR    .    .    . .   xchgl	%ebp, %esi
# CHECK-NEXT: [6,4]     .    .    .    .    .    .   DR    .    .    . .   xchgl	%esi, %edi
# CHECK-NEXT: [6,5]     .    .    .    .    .    .   DR    .    .    . .   xchgl	%edi, %r8d
# CHECK-NEXT: [6,6]     .    .    .    .    .    .    DR   .    .    . .   xchgl	%r8d, %r9d
# CHECK-NEXT: [6,7]     .    .    .    .    .    .    DR   .    .    . .   xchgl	%r9d, %r10d
# CHECK-NEXT: [6,8]     .    .    .    .    .    .    DR   .    .    . .   xchgl	%r10d, %r11d
# CHECK-NEXT: [6,9]     .    .    .    .    .    .    .DR  .    .    . .   xchgl	%r11d, %r12d
# CHECK-NEXT: [6,10]    .    .    .    .    .    .    .DR  .    .    . .   xchgl	%r12d, %r13d
# CHECK-NEXT: [6,11]    .    .    .    .    .    .    .DR  .    .    . .   xchgl	%r13d, %r14d
# CHECK-NEXT: [6,12]    .    .    .    .    .    .    . DR .    .    . .   xchgl	%r14d, %r15d
# CHECK-NEXT: [6,13]    .    .    .    .    .    .    . DR .    .    . .   xchgl	%r15d, %eax
# CHECK-NEXT: [7,0]     .    .    .    .    .    .    . DR .    .    . .   xchgl	%ecx, %eax
# CHECK-NEXT: [7,1]     .    .    .    .    .    .    .  DR.    .    . .   xchgl	%ecx, %edx
# CHECK-NEXT: [7,2]     .    .    .    .    .    .    .  DR.    .    . .   xchgl	%edx, %ebp
# CHECK-NEXT: [7,3]     .    .    .    .    .    .    .  DR.    .    . .   xchgl	%ebp, %esi
# CHECK-NEXT: [7,4]     .    .    .    .    .    .    .   DR    .    . .   xchgl	%esi, %edi
# CHECK-NEXT: [7,5]     .    .    .    .    .    .    .   DR    .    . .   xchgl	%edi, %r8d
# CHECK-NEXT: [7,6]     .    .    .    .    .    .    .   DR    .    . .   xchgl	%r8d, %r9d
# CHECK-NEXT: [7,7]     .    .    .    .    .    .    .    DR   .    . .   xchgl	%r9d, %r10d
# CHECK-NEXT: [7,8]     .    .    .    .    .    .    .    DR   .    . .   xchgl	%r10d, %r11d
# CHECK-NEXT: [7,9]     .    .    .    .    .    .    .    DR   .    . .   xchgl	%r11d, %r12d
# CHECK-NEXT: [7,10]    .    .    .    .    .    .    .    .DR  .    . .   xchgl	%r12d, %r13d
# CHECK-NEXT: [7,11]    .    .    .    .    .    .    .    .DR  .    . .   xchgl	%r13d, %r14d
# CHECK-NEXT: [7,12]    .    .    .    .    .    .    .    .DR  .    . .   xchgl	%r14d, %r15d
# CHECK-NEXT: [7,13]    .    .    .    .    .    .    .    . DR .    . .   xchgl	%r15d, %eax
# CHECK-NEXT: [8,0]     .    .    .    .    .    .    .    . DR .    . .   xchgl	%ecx, %eax
# CHECK-NEXT: [8,1]     .    .    .    .    .    .    .    . DR .    . .   xchgl	%ecx, %edx
# CHECK-NEXT: [8,2]     .    .    .    .    .    .    .    .  DR.    . .   xchgl	%edx, %ebp
# CHECK-NEXT: [8,3]     .    .    .    .    .    .    .    .  DR.    . .   xchgl	%ebp, %esi
# CHECK-NEXT: [8,4]     .    .    .    .    .    .    .    .  DR.    . .   xchgl	%esi, %edi
# CHECK-NEXT: [8,5]     .    .    .    .    .    .    .    .   DR    . .   xchgl	%edi, %r8d
# CHECK-NEXT: [8,6]     .    .    .    .    .    .    .    .   DR    . .   xchgl	%r8d, %r9d
# CHECK-NEXT: [8,7]     .    .    .    .    .    .    .    .   DR    . .   xchgl	%r9d, %r10d
# CHECK-NEXT: [8,8]     .    .    .    .    .    .    .    .    DR   . .   xchgl	%r10d, %r11d
# CHECK-NEXT: [8,9]     .    .    .    .    .    .    .    .    DR   . .   xchgl	%r11d, %r12d
# CHECK-NEXT: [8,10]    .    .    .    .    .    .    .    .    DR   . .   xchgl	%r12d, %r13d
# CHECK-NEXT: [8,11]    .    .    .    .    .    .    .    .    .DR  . .   xchgl	%r13d, %r14d
# CHECK-NEXT: [8,12]    .    .    .    .    .    .    .    .    .DR  . .   xchgl	%r14d, %r15d
# CHECK-NEXT: [8,13]    .    .    .    .    .    .    .    .    .DR  . .   xchgl	%r15d, %eax
# CHECK-NEXT: [9,0]     .    .    .    .    .    .    .    .    . DR . .   xchgl	%ecx, %eax
# CHECK-NEXT: [9,1]     .    .    .    .    .    .    .    .    . DR . .   xchgl	%ecx, %edx
# CHECK-NEXT: [9,2]     .    .    .    .    .    .    .    .    . DR . .   xchgl	%edx, %ebp
# CHECK-NEXT: [9,3]     .    .    .    .    .    .    .    .    .  DR. .   xchgl	%ebp, %esi
# CHECK-NEXT: [9,4]     .    .    .    .    .    .    .    .    .  DR. .   xchgl	%esi, %edi
# CHECK-NEXT: [9,5]     .    .    .    .    .    .    .    .    .  DR. .   xchgl	%edi, %r8d
# CHECK-NEXT: [9,6]     .    .    .    .    .    .    .    .    .   DR .   xchgl	%r8d, %r9d
# CHECK-NEXT: [9,7]     .    .    .    .    .    .    .    .    .   DR .   xchgl	%r9d, %r10d
# CHECK-NEXT: [9,8]     .    .    .    .    .    .    .    .    .   DR .   xchgl	%r10d, %r11d
# CHECK-NEXT: [9,9]     .    .    .    .    .    .    .    .    .    DR.   xchgl	%r11d, %r12d
# CHECK-NEXT: [9,10]    .    .    .    .    .    .    .    .    .    DR.   xchgl	%r12d, %r13d
# CHECK-NEXT: [9,11]    .    .    .    .    .    .    .    .    .    DR.   xchgl	%r13d, %r14d
# CHECK-NEXT: [9,12]    .    .    .    .    .    .    .    .    .    .DR   xchgl	%r14d, %r15d
# CHECK-NEXT: [9,13]    .    .    .    .    .    .    .    .    .    .DR   xchgl	%r15d, %eax

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     10    0.0    0.0    0.0       xchgl	%ecx, %eax
# CHECK-NEXT: 1.     10    0.0    0.0    0.0       xchgl	%ecx, %edx
# CHECK-NEXT: 2.     10    0.0    0.0    0.0       xchgl	%edx, %ebp
# CHECK-NEXT: 3.     10    0.0    0.0    0.0       xchgl	%ebp, %esi
# CHECK-NEXT: 4.     10    0.0    0.0    0.0       xchgl	%esi, %edi
# CHECK-NEXT: 5.     10    0.0    0.0    0.0       xchgl	%edi, %r8d
# CHECK-NEXT: 6.     10    0.0    0.0    0.0       xchgl	%r8d, %r9d
# CHECK-NEXT: 7.     10    0.0    0.0    0.0       xchgl	%r9d, %r10d
# CHECK-NEXT: 8.     10    0.0    0.0    0.0       xchgl	%r10d, %r11d
# CHECK-NEXT: 9.     10    0.0    0.0    0.0       xchgl	%r11d, %r12d
# CHECK-NEXT: 10.    10    0.0    0.0    0.0       xchgl	%r12d, %r13d
# CHECK-NEXT: 11.    10    0.0    0.0    0.0       xchgl	%r13d, %r14d
# CHECK-NEXT: 12.    10    0.0    0.0    0.0       xchgl	%r14d, %r15d
# CHECK-NEXT: 13.    10    0.0    0.0    0.0       xchgl	%r15d, %eax
# CHECK-NEXT:        10    0.0    0.0    0.0       <total>

# CHECK:      [3] Code Region

# CHECK:      Iterations:        1000
# CHECK-NEXT: Instructions:      14000
# CHECK-NEXT: Total Cycles:      4668
# CHECK-NEXT: Total uOps:        28000

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    6.00
# CHECK-NEXT: IPC:               3.00
# CHECK-NEXT: Block RThroughput: 4.7

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  2      0     0.33                        xchgq	%rcx, %rax
# CHECK-NEXT:  2      0     0.33                        xchgq	%rcx, %rdx
# CHECK-NEXT:  2      0     0.33                        xchgq	%rdx, %rbp
# CHECK-NEXT:  2      0     0.33                        xchgq	%rbp, %rsi
# CHECK-NEXT:  2      0     0.33                        xchgq	%rsi, %rdi
# CHECK-NEXT:  2      0     0.33                        xchgq	%rdi, %r8
# CHECK-NEXT:  2      0     0.33                        xchgq	%r8, %r9
# CHECK-NEXT:  2      0     0.33                        xchgq	%r9, %r10
# CHECK-NEXT:  2      0     0.33                        xchgq	%r10, %r11
# CHECK-NEXT:  2      0     0.33                        xchgq	%r11, %r12
# CHECK-NEXT:  2      0     0.33                        xchgq	%r12, %r13
# CHECK-NEXT:  2      0     0.33                        xchgq	%r13, %r14
# CHECK-NEXT:  2      0     0.33                        xchgq	%r14, %r15
# CHECK-NEXT:  2      0     0.33                        xchgq	%r15, %rax

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    0
# CHECK-NEXT: Max number of mappings used:         0

# CHECK:      *  Register File #1 -- Zn3FpPRF:
# CHECK-NEXT:    Number of physical registers:     160
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0

# CHECK:      *  Register File #2 -- Zn3IntegerPRF:
# CHECK-NEXT:    Number of physical registers:     192
# CHECK-NEXT:    Total number of mappings created: 0
# CHECK-NEXT:    Max number of mappings used:      0
# CHECK-NEXT:    Number of optimizable moves:      28000
# CHECK-NEXT:    Number of moves eliminated:       28000  (100.0%)
# CHECK-NEXT:    Number of zero moves:             0  (0.0%)
# CHECK-NEXT:    Max moves eliminated per cycle:   6

# CHECK:      Resources:
# CHECK-NEXT: [0]   - Zn3AGU0
# CHECK-NEXT: [1]   - Zn3AGU1
# CHECK-NEXT: [2]   - Zn3AGU2
# CHECK-NEXT: [3]   - Zn3ALU0
# CHECK-NEXT: [4]   - Zn3ALU1
# CHECK-NEXT: [5]   - Zn3ALU2
# CHECK-NEXT: [6]   - Zn3ALU3
# CHECK-NEXT: [7]   - Zn3BRU1
# CHECK-NEXT: [8]   - Zn3FP0
# CHECK-NEXT: [9]   - Zn3FP1
# CHECK-NEXT: [10]  - Zn3FP2
# CHECK-NEXT: [11]  - Zn3FP3
# CHECK-NEXT: [12.0] - Zn3FP45
# CHECK-NEXT: [12.1] - Zn3FP45
# CHECK-NEXT: [13]  - Zn3FPSt
# CHECK-NEXT: [14.0] - Zn3LSU
# CHECK-NEXT: [14.1] - Zn3LSU
# CHECK-NEXT: [14.2] - Zn3LSU
# CHECK-NEXT: [15.0] - Zn3Load
# CHECK-NEXT: [15.1] - Zn3Load
# CHECK-NEXT: [15.2] - Zn3Load
# CHECK-NEXT: [16.0] - Zn3Store
# CHECK-NEXT: [16.1] - Zn3Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1]
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12.0] [12.1] [13]   [14.0] [14.1] [14.2] [15.0] [15.1] [15.2] [16.0] [16.1] Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgq	%rcx, %rax
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgq	%rcx, %rdx
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgq	%rdx, %rbp
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgq	%rbp, %rsi
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgq	%rsi, %rdi
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgq	%rdi, %r8
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgq	%r8, %r9
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgq	%r9, %r10
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgq	%r10, %r11
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgq	%r11, %r12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgq	%r12, %r13
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgq	%r13, %r14
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgq	%r14, %r15
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     xchgq	%r15, %rax

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789          0123456789
# CHECK-NEXT: Index     0123456789          0123456789          01234567

# CHECK:      [0,0]     DR   .    .    .    .    .    .    .    .    . .   xchgq	%rcx, %rax
# CHECK-NEXT: [0,1]     DR   .    .    .    .    .    .    .    .    . .   xchgq	%rcx, %rdx
# CHECK-NEXT: [0,2]     DR   .    .    .    .    .    .    .    .    . .   xchgq	%rdx, %rbp
# CHECK-NEXT: [0,3]     .DR  .    .    .    .    .    .    .    .    . .   xchgq	%rbp, %rsi
# CHECK-NEXT: [0,4]     .DR  .    .    .    .    .    .    .    .    . .   xchgq	%rsi, %rdi
# CHECK-NEXT: [0,5]     .DR  .    .    .    .    .    .    .    .    . .   xchgq	%rdi, %r8
# CHECK-NEXT: [0,6]     . DR .    .    .    .    .    .    .    .    . .   xchgq	%r8, %r9
# CHECK-NEXT: [0,7]     . DR .    .    .    .    .    .    .    .    . .   xchgq	%r9, %r10
# CHECK-NEXT: [0,8]     . DR .    .    .    .    .    .    .    .    . .   xchgq	%r10, %r11
# CHECK-NEXT: [0,9]     .  DR.    .    .    .    .    .    .    .    . .   xchgq	%r11, %r12
# CHECK-NEXT: [0,10]    .  DR.    .    .    .    .    .    .    .    . .   xchgq	%r12, %r13
# CHECK-NEXT: [0,11]    .  DR.    .    .    .    .    .    .    .    . .   xchgq	%r13, %r14
# CHECK-NEXT: [0,12]    .   DR    .    .    .    .    .    .    .    . .   xchgq	%r14, %r15
# CHECK-NEXT: [0,13]    .   DR    .    .    .    .    .    .    .    . .   xchgq	%r15, %rax
# CHECK-NEXT: [1,0]     .   DR    .    .    .    .    .    .    .    . .   xchgq	%rcx, %rax
# CHECK-NEXT: [1,1]     .    DR   .    .    .    .    .    .    .    . .   xchgq	%rcx, %rdx
# CHECK-NEXT: [1,2]     .    DR   .    .    .    .    .    .    .    . .   xchgq	%rdx, %rbp
# CHECK-NEXT: [1,3]     .    DR   .    .    .    .    .    .    .    . .   xchgq	%rbp, %rsi
# CHECK-NEXT: [1,4]     .    .DR  .    .    .    .    .    .    .    . .   xchgq	%rsi, %rdi
# CHECK-NEXT: [1,5]     .    .DR  .    .    .    .    .    .    .    . .   xchgq	%rdi, %r8
# CHECK-NEXT: [1,6]     .    .DR  .    .    .    .    .    .    .    . .   xchgq	%r8, %r9
# CHECK-NEXT: [1,7]     .    . DR .    .    .    .    .    .    .    . .   xchgq	%r9, %r10
# CHECK-NEXT: [1,8]     .    . DR .    .    .    .    .    .    .    . .   xchgq	%r10, %r11
# CHECK-NEXT: [1,9]     .    . DR .    .    .    .    .    .    .    . .   xchgq	%r11, %r12
# CHECK-NEXT: [1,10]    .    .  DR.    .    .    .    .    .    .    . .   xchgq	%r12, %r13
# CHECK-NEXT: [1,11]    .    .  DR.    .    .    .    .    .    .    . .   xchgq	%r13, %r14
# CHECK-NEXT: [1,12]    .    .  DR.    .    .    .    .    .    .    . .   xchgq	%r14, %r15
# CHECK-NEXT: [1,13]    .    .   DR    .    .    .    .    .    .    . .   xchgq	%r15, %rax
# CHECK-NEXT: [2,0]     .    .   DR    .    .    .    .    .    .    . .   xchgq	%rcx, %rax
# CHECK-NEXT: [2,1]     .    .   DR    .    .    .    .    .    .    . .   xchgq	%rcx, %rdx
# CHECK-NEXT: [2,2]     .    .    DR   .    .    .    .    .    .    . .   xchgq	%rdx, %rbp
# CHECK-NEXT: [2,3]     .    .    DR   .    .    .    .    .    .    . .   xchgq	%rbp, %rsi
# CHECK-NEXT: [2,4]     .    .    DR   .    .    .    .    .    .    . .   xchgq	%rsi, %rdi
# CHECK-NEXT: [2,5]     .    .    .DR  .    .    .    .    .    .    . .   xchgq	%rdi, %r8
# CHECK-NEXT: [2,6]     .    .    .DR  .    .    .    .    .    .    . .   xchgq	%r8, %r9
# CHECK-NEXT: [2,7]     .    .    .DR  .    .    .    .    .    .    . .   xchgq	%r9, %r10
# CHECK-NEXT: [2,8]     .    .    . DR .    .    .    .    .    .    . .   xchgq	%r10, %r11
# CHECK-NEXT: [2,9]     .    .    . DR .    .    .    .    .    .    . .   xchgq	%r11, %r12
# CHECK-NEXT: [2,10]    .    .    . DR .    .    .    .    .    .    . .   xchgq	%r12, %r13
# CHECK-NEXT: [2,11]    .    .    .  DR.    .    .    .    .    .    . .   xchgq	%r13, %r14
# CHECK-NEXT: [2,12]    .    .    .  DR.    .    .    .    .    .    . .   xchgq	%r14, %r15
# CHECK-NEXT: [2,13]    .    .    .  DR.    .    .    .    .    .    . .   xchgq	%r15, %rax
# CHECK-NEXT: [3,0]     .    .    .   DR    .    .    .    .    .    . .   xchgq	%rcx, %rax
# CHECK-NEXT: [3,1]     .    .    .   DR    .    .    .    .    .    . .   xchgq	%rcx, %rdx
# CHECK-NEXT: [3,2]     .    .    .   DR    .    .    .    .    .    . .   xchgq	%rdx, %rbp
# CHECK-NEXT: [3,3]     .    .    .    DR   .    .    .    .    .    . .   xchgq	%rbp, %rsi
# CHECK-NEXT: [3,4]     .    .    .    DR   .    .    .    .    .    . .   xchgq	%rsi, %rdi
# CHECK-NEXT: [3,5]     .    .    .    DR   .    .    .    .    .    . .   xchgq	%rdi, %r8
# CHECK-NEXT: [3,6]     .    .    .    .DR  .    .    .    .    .    . .   xchgq	%r8, %r9
# CHECK-NEXT: [3,7]     .    .    .    .DR  .    .    .    .    .    . .   xchgq	%r9, %r10
# CHECK-NEXT: [3,8]     .    .    .    .DR  .    .    .    .    .    . .   xchgq	%r10, %r11
# CHECK-NEXT: [3,9]     .    .    .    . DR .    .    .    .    .    . .   xchgq	%r11, %r12
# CHECK-NEXT: [3,10]    .    .    .    . DR .    .    .    .    .    . .   xchgq	%r12, %r13
# CHECK-NEXT: [3,11]    .    .    .    . DR .    .    .    .    .    . .   xchgq	%r13, %r14
# CHECK-NEXT: [3,12]    .    .    .    .  DR.    .    .    .    .    . .   xchgq	%r14, %r15
# CHECK-NEXT: [3,13]    .    .    .    .  DR.    .    .    .    .    . .   xchgq	%r15, %rax
# CHECK-NEXT: [4,0]     .    .    .    .  DR.    .    .    .    .    . .   xchgq	%rcx, %rax
# CHECK-NEXT: [4,1]     .    .    .    .   DR    .    .    .    .    . .   xchgq	%rcx, %rdx
# CHECK-NEXT: [4,2]     .    .    .    .   DR    .    .    .    .    . .   xchgq	%rdx, %rbp
# CHECK-NEXT: [4,3]     .    .    .    .   DR    .    .    .    .    . .   xchgq	%rbp, %rsi
# CHECK-NEXT: [4,4]     .    .    .    .    DR   .    .    .    .    . .   xchgq	%rsi, %rdi
# CHECK-NEXT: [4,5]     .    .    .    .    DR   .    .    .    .    . .   xchgq	%rdi, %r8
# CHECK-NEXT: [4,6]     .    .    .    .    DR   .    .    .    .    . .   xchgq	%r8, %r9
# CHECK-NEXT: [4,7]     .    .    .    .    .DR  .    .    .    .    . .   xchgq	%r9, %r10
# CHECK-NEXT: [4,8]     .    .    .    .    .DR  .    .    .    .    . .   xchgq	%r10, %r11
# CHECK-NEXT: [4,9]     .    .    .    .    .DR  .    .    .    .    . .   xchgq	%r11, %r12
# CHECK-NEXT: [4,10]    .    .    .    .    . DR .    .    .    .    . .   xchgq	%r12, %r13
# CHECK-NEXT: [4,11]    .    .    .    .    . DR .    .    .    .    . .   xchgq	%r13, %r14
# CHECK-NEXT: [4,12]    .    .    .    .    . DR .    .    .    .    . .   xchgq	%r14, %r15
# CHECK-NEXT: [4,13]    .    .    .    .    .  DR.    .    .    .    . .   xchgq	%r15, %rax
# CHECK-NEXT: [5,0]     .    .    .    .    .  DR.    .    .    .    . .   xchgq	%rcx, %rax
# CHECK-NEXT: [5,1]     .    .    .    .    .  DR.    .    .    .    . .   xchgq	%rcx, %rdx
# CHECK-NEXT: [5,2]     .    .    .    .    .   DR    .    .    .    . .   xchgq	%rdx, %rbp
# CHECK-NEXT: [5,3]     .    .    .    .    .   DR    .    .    .    . .   xchgq	%rbp, %rsi
# CHECK-NEXT: [5,4]     .    .    .    .    .   DR    .    .    .    . .   xchgq	%rsi, %rdi
# CHECK-NEXT: [5,5]     .    .    .    .    .    DR   .    .    .    . .   xchgq	%rdi, %r8
# CHECK-NEXT: [5,6]     .    .    .    .    .    DR   .    .    .    . .   xchgq	%r8, %r9
# CHECK-NEXT: [5,7]     .    .    .    .    .    DR   .    .    .    . .   xchgq	%r9, %r10
# CHECK-NEXT: [5,8]     .    .    .    .    .    .DR  .    .    .    . .   xchgq	%r10, %r11
# CHECK-NEXT: [5,9]     .    .    .    .    .    .DR  .    .    .    . .   xchgq	%r11, %r12
# CHECK-NEXT: [5,10]    .    .    .    .    .    .DR  .    .    .    . .   xchgq	%r12, %r13
# CHECK-NEXT: [5,11]    .    .    .    .    .    . DR .    .    .    . .   xchgq	%r13, %r14
# CHECK-NEXT: [5,12]    .    .    .    .    .    . DR .    .    .    . .   xchgq	%r14, %r15
# CHECK-NEXT: [5,13]    .    .    .    .    .    . DR .    .    .    . .   xchgq	%r15, %rax
# CHECK-NEXT: [6,0]     .    .    .    .    .    .  DR.    .    .    . .   xchgq	%rcx, %rax
# CHECK-NEXT: [6,1]     .    .    .    .    .    .  DR.    .    .    . .   xchgq	%rcx, %rdx
# CHECK-NEXT: [6,2]     .    .    .    .    .    .  DR.    .    .    . .   xchgq	%rdx, %rbp
# CHECK-NEXT: [6,3]     .    .    .    .    .    .   DR    .    .    . .   xchgq	%rbp, %rsi
# CHECK-NEXT: [6,4]     .    .    .    .    .    .   DR    .    .    . .   xchgq	%rsi, %rdi
# CHECK-NEXT: [6,5]     .    .    .    .    .    .   DR    .    .    . .   xchgq	%rdi, %r8
# CHECK-NEXT: [6,6]     .    .    .    .    .    .    DR   .    .    . .   xchgq	%r8, %r9
# CHECK-NEXT: [6,7]     .    .    .    .    .    .    DR   .    .    . .   xchgq	%r9, %r10
# CHECK-NEXT: [6,8]     .    .    .    .    .    .    DR   .    .    . .   xchgq	%r10, %r11
# CHECK-NEXT: [6,9]     .    .    .    .    .    .    .DR  .    .    . .   xchgq	%r11, %r12
# CHECK-NEXT: [6,10]    .    .    .    .    .    .    .DR  .    .    . .   xchgq	%r12, %r13
# CHECK-NEXT: [6,11]    .    .    .    .    .    .    .DR  .    .    . .   xchgq	%r13, %r14
# CHECK-NEXT: [6,12]    .    .    .    .    .    .    . DR .    .    . .   xchgq	%r14, %r15
# CHECK-NEXT: [6,13]    .    .    .    .    .    .    . DR .    .    . .   xchgq	%r15, %rax
# CHECK-NEXT: [7,0]     .    .    .    .    .    .    . DR .    .    . .   xchgq	%rcx, %rax
# CHECK-NEXT: [7,1]     .    .    .    .    .    .    .  DR.    .    . .   xchgq	%rcx, %rdx
# CHECK-NEXT: [7,2]     .    .    .    .    .    .    .  DR.    .    . .   xchgq	%rdx, %rbp
# CHECK-NEXT: [7,3]     .    .    .    .    .    .    .  DR.    .    . .   xchgq	%rbp, %rsi
# CHECK-NEXT: [7,4]     .    .    .    .    .    .    .   DR    .    . .   xchgq	%rsi, %rdi
# CHECK-NEXT: [7,5]     .    .    .    .    .    .    .   DR    .    . .   xchgq	%rdi, %r8
# CHECK-NEXT: [7,6]     .    .    .    .    .    .    .   DR    .    . .   xchgq	%r8, %r9
# CHECK-NEXT: [7,7]     .    .    .    .    .    .    .    DR   .    . .   xchgq	%r9, %r10
# CHECK-NEXT: [7,8]     .    .    .    .    .    .    .    DR   .    . .   xchgq	%r10, %r11
# CHECK-NEXT: [7,9]     .    .    .    .    .    .    .    DR   .    . .   xchgq	%r11, %r12
# CHECK-NEXT: [7,10]    .    .    .    .    .    .    .    .DR  .    . .   xchgq	%r12, %r13
# CHECK-NEXT: [7,11]    .    .    .    .    .    .    .    .DR  .    . .   xchgq	%r13, %r14
# CHECK-NEXT: [7,12]    .    .    .    .    .    .    .    .DR  .    . .   xchgq	%r14, %r15
# CHECK-NEXT: [7,13]    .    .    .    .    .    .    .    . DR .    . .   xchgq	%r15, %rax
# CHECK-NEXT: [8,0]     .    .    .    .    .    .    .    . DR .    . .   xchgq	%rcx, %rax
# CHECK-NEXT: [8,1]     .    .    .    .    .    .    .    . DR .    . .   xchgq	%rcx, %rdx
# CHECK-NEXT: [8,2]     .    .    .    .    .    .    .    .  DR.    . .   xchgq	%rdx, %rbp
# CHECK-NEXT: [8,3]     .    .    .    .    .    .    .    .  DR.    . .   xchgq	%rbp, %rsi
# CHECK-NEXT: [8,4]     .    .    .    .    .    .    .    .  DR.    . .   xchgq	%rsi, %rdi
# CHECK-NEXT: [8,5]     .    .    .    .    .    .    .    .   DR    . .   xchgq	%rdi, %r8
# CHECK-NEXT: [8,6]     .    .    .    .    .    .    .    .   DR    . .   xchgq	%r8, %r9
# CHECK-NEXT: [8,7]     .    .    .    .    .    .    .    .   DR    . .   xchgq	%r9, %r10
# CHECK-NEXT: [8,8]     .    .    .    .    .    .    .    .    DR   . .   xchgq	%r10, %r11
# CHECK-NEXT: [8,9]     .    .    .    .    .    .    .    .    DR   . .   xchgq	%r11, %r12
# CHECK-NEXT: [8,10]    .    .    .    .    .    .    .    .    DR   . .   xchgq	%r12, %r13
# CHECK-NEXT: [8,11]    .    .    .    .    .    .    .    .    .DR  . .   xchgq	%r13, %r14
# CHECK-NEXT: [8,12]    .    .    .    .    .    .    .    .    .DR  . .   xchgq	%r14, %r15
# CHECK-NEXT: [8,13]    .    .    .    .    .    .    .    .    .DR  . .   xchgq	%r15, %rax
# CHECK-NEXT: [9,0]     .    .    .    .    .    .    .    .    . DR . .   xchgq	%rcx, %rax
# CHECK-NEXT: [9,1]     .    .    .    .    .    .    .    .    . DR . .   xchgq	%rcx, %rdx
# CHECK-NEXT: [9,2]     .    .    .    .    .    .    .    .    . DR . .   xchgq	%rdx, %rbp
# CHECK-NEXT: [9,3]     .    .    .    .    .    .    .    .    .  DR. .   xchgq	%rbp, %rsi
# CHECK-NEXT: [9,4]     .    .    .    .    .    .    .    .    .  DR. .   xchgq	%rsi, %rdi
# CHECK-NEXT: [9,5]     .    .    .    .    .    .    .    .    .  DR. .   xchgq	%rdi, %r8
# CHECK-NEXT: [9,6]     .    .    .    .    .    .    .    .    .   DR .   xchgq	%r8, %r9
# CHECK-NEXT: [9,7]     .    .    .    .    .    .    .    .    .   DR .   xchgq	%r9, %r10
# CHECK-NEXT: [9,8]     .    .    .    .    .    .    .    .    .   DR .   xchgq	%r10, %r11
# CHECK-NEXT: [9,9]     .    .    .    .    .    .    .    .    .    DR.   xchgq	%r11, %r12
# CHECK-NEXT: [9,10]    .    .    .    .    .    .    .    .    .    DR.   xchgq	%r12, %r13
# CHECK-NEXT: [9,11]    .    .    .    .    .    .    .    .    .    DR.   xchgq	%r13, %r14
# CHECK-NEXT: [9,12]    .    .    .    .    .    .    .    .    .    .DR   xchgq	%r14, %r15
# CHECK-NEXT: [9,13]    .    .    .    .    .    .    .    .    .    .DR   xchgq	%r15, %rax

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     10    0.0    0.0    0.0       xchgq	%rcx, %rax
# CHECK-NEXT: 1.     10    0.0    0.0    0.0       xchgq	%rcx, %rdx
# CHECK-NEXT: 2.     10    0.0    0.0    0.0       xchgq	%rdx, %rbp
# CHECK-NEXT: 3.     10    0.0    0.0    0.0       xchgq	%rbp, %rsi
# CHECK-NEXT: 4.     10    0.0    0.0    0.0       xchgq	%rsi, %rdi
# CHECK-NEXT: 5.     10    0.0    0.0    0.0       xchgq	%rdi, %r8
# CHECK-NEXT: 6.     10    0.0    0.0    0.0       xchgq	%r8, %r9
# CHECK-NEXT: 7.     10    0.0    0.0    0.0       xchgq	%r9, %r10
# CHECK-NEXT: 8.     10    0.0    0.0    0.0       xchgq	%r10, %r11
# CHECK-NEXT: 9.     10    0.0    0.0    0.0       xchgq	%r11, %r12
# CHECK-NEXT: 10.    10    0.0    0.0    0.0       xchgq	%r12, %r13
# CHECK-NEXT: 11.    10    0.0    0.0    0.0       xchgq	%r13, %r14
# CHECK-NEXT: 12.    10    0.0    0.0    0.0       xchgq	%r14, %r15
# CHECK-NEXT: 13.    10    0.0    0.0    0.0       xchgq	%r15, %rax
# CHECK-NEXT:        10    0.0    0.0    0.0       <total>
