unit ButtonBase;

//  Replacement ButtonBase as original buttons
//  do not work in QT5
//  Need to avoid using Bitblt SCRAND & SCRPAINT
//  PB Nov-20


interface

uses
    Classes, Graphics, Buttons, LCLExceptionStackTrace;

type
    TButtonBase = class (TSpeedButton)
    private
        FDown,
        FPermanent  : boolean;
        FIndex      : integer;
        FGraphic    : TBitmap;

    protected
        DownChangedProc: TNotifyEvent;

        procedure SetIndex   (Ind: Integer);
        procedure SetGraphic (Bmp: TBitmap);
        function  GetGraphic: TBitmap;

        procedure SetGlyph;     virtual; abstract;
        procedure CheckGlyph;   virtual; abstract;

    public
        constructor Create (aOwner: TComponent); override;

    published
        property OnDownChanged: TNotifyEvent read DownChangedProc write DownChangedProc;
        property Down:        boolean read FDown        write FDown;
        property Permanent:   boolean read FPermanent   write FPermanent; // used in *.lfm
        property ButtonIndex: integer read FIndex       write SetIndex;
        property Graphic: TBitmap     read GetGraphic   write SetGraphic;
    end;


implementation

constructor TButtonBase.Create (aOwner: TComponent);
begin
    inherited;
    FGraphic    := nil;
    FDown       := False;
    ShowHint    := True;
    Findex      := -1;

	// Lazarus Issue #41600
	// Need lazarus >= v.5.0 or patch for commit c2c8fe7d
    {$IFDEF WINDOWS}
        DrawingEffectsEnabled := deeEnabled;
    {$ENDIF}
end;

procedure TButtonBase.SetIndex (Ind: integer);
begin
    if (FIndex <> Ind) then
    begin
        FIndex := Ind;
        CheckGlyph;
    end;
end;

procedure TButtonBase.SetGraphic (Bmp: TBitmap);
begin
     FGraphic := Bmp;
     CheckGlyph;
end;

function TButtonBase.GetGraphic: TBitmap;
begin
     GetGraphic := FGraphic;
end;

end.
