# CPack uses `rpm --supplements` to check if rpmbuild supports the "Supplements:" tag.
# This test intentionally uses a different method (build a test .spec) so any
# problems will be caught early if functionality should change in the future.
execute_process(
  COMMAND ${RPMBUILD_EXECUTABLE} --nobuild test_supplements.spec
  ERROR_QUIET
  WORKING_DIRECTORY ${CMAKE_CURRENT_LIST_DIR}
  RESULT_VARIABLE RPMBUILD_SUPPLEMENTS_RESULT)

if(RPMBUILD_SUPPLEMENTS_RESULT EQUAL 0)
  set(should_contain_supplements_tag_ true)
endif()

# Only verify that supplements tag is present only if that tag is supported.
# If it is not supported the rpm package was correctly generated by ignoring
# that tag and that was already checked by expected files test.
if(should_contain_supplements_tag_)
  execute_process(COMMAND ${RPM_EXECUTABLE} -q --supplements -p "${FOUND_FILE_1}"
                  RESULT_VARIABLE rpm_result_
                  OUTPUT_VARIABLE rpm_stdout_
                  ERROR_VARIABLE  rpm_stderr_
                  OUTPUT_STRIP_TRAILING_WHITESPACE)

  if(rpm_result_ OR NOT rpm_stdout_ STREQUAL "libsupplemented")
    string(REPLACE "\n" "\n  " rpm_stdout_ "${rpm_stdout_}")
    string(REPLACE "\n" "\n  " rpm_stderr_  "${rpm_stderr_}")
    message(FATAL_ERROR "RPM_SUPPLEMENTED package error: no supplemented packages\n"
      "result: ${rpm_result_}\n"
      "stdout:\n"
      "  ${rpm_stdout_}\n"
      "stderr:\n"
      "  ${rpm_stderr_}\n"
      )
  endif()
endif()
