/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2016 Intel Corporation
 */

struct i40e_reg_info {
	uint32_t base_addr;
	uint32_t count1;
	uint32_t stride1;
	uint32_t count2;
	uint32_t stride2;
	const char *name;
};

static const struct i40e_reg_info i40e_regs_adminq[] = {
	{I40E_VFQF_HENA(0), 1, 4, 0, 0, "VFQF_HENA"},
	{I40E_VFQF_HKEY(0), 12, 4, 0, 0, "VFQF_HKEY"},
	{I40E_VFQF_HREGION(0), 7, 4, 0, 0, "VFQF_HREGION"},
	{I40E_VPQF_CTL(0), 127, 4, 0, 0, "VPQF_CTL"},
	{I40E_PFLAN_QALLOC, 0, 0, 0, 0, "PFLAN_QALLOC"},
	{I40E_PFQF_CTL_0, 0, 0, 0, 0, "PFQF_CTL_0"},
	{I40E_VSILAN_QTABLE(0, 0), 7, 2048, 383, 4, "VSILAN_QTABLE"},
	{I40E_VSIQF_TCREGION(0, 0), 3, 2048, 383, 4, "VSIQF_TCREGION"},
	{I40E_VSILAN_QBASE(0), 383, 4, 0, 0, "VSILAN_QBASE"},
	{I40E_VSIQF_CTL(0), 383, 4, 0, 0, "VSIQF_CTL"},
	{I40E_PFQF_HKEY(0), 12, 128, 0, 0, "PFQF_HKEY"},
	{I40E_PFQF_HREGION(0), 7, 128, 0, 0, "PFQF_HREGION"},
	{I40E_PFQF_HENA(0), 1, 128, 0, 0, "PFQF_HENA"},
	{I40E_PFQF_FDALLOC, 0, 0, 0, 0, "PFQF_FDALLOC"},
	{I40E_PRTQF_FD_INSET(0, 0), 63, 64, 1, 32, "PRTQF_FD_INSET"},
	{I40E_PRTQF_FD_INSET(0, 0), 63, 64, 1, 32, "PRTQF_FD_INSET"},
	{I40E_PRTQF_FD_MSK(0, 0), 63, 64, 1, 32, "PRTQF_FD_MSK"},
	{I40E_PRTQF_FD_FLXINSET(0), 63, 32, 0, 0, "PRTQF_FD_FLXINSET"},
	{I40E_PRTQF_CTL_0, 0, 0, 0, 0, "PRTQF_CTL_0"},
	{I40E_GLQF_FD_MSK(0, 0), 1, 4, 63, 8, "GLQF_FD_MSK"},
	{I40E_GLQF_HASH_INSET(0, 0), 1, 4, 63, 8, "GLQF_HASH_INSET"},
	{I40E_GLQF_HASH_MSK(0, 0), 1, 4, 63, 8, "GLQF_HASH_MSK"},
	{I40E_GLQF_SWAP(0, 0), 1, 4, 63, 8, "GLQF_SWAP"},
	{I40E_GLFCOE_RCTL, 0, 0, 0, 0, "GLFCOE_RCTL"},
	{I40E_GLQF_CTL, 0, 0, 0, 0, "GLQF_CTL"},
	{I40E_GLQF_HSYM(0), 63, 4, 0, 0, "GLQF_HSYM"},
	{0, 0, 0, 0, 0, NULL}
};

static const struct i40e_reg_info i40e_regs_others[] = {
	{I40E_QTX_TAIL1(0), 15, 4, 0, 0, "QTX_TAIL1"},
	{I40E_VFPE_CQPDB(0), 127, 4, 0, 0, "VFPE_CQPDB"},
	{I40E_VFPE_CQPTAIL(0), 127, 4, 0, 0, "VFPE_CQPTAIL"},
	{I40E_VFPE_CCQPSTATUS(0), 127, 4, 0, 0, "VFPE_CCQPSTATUS"},
	{I40E_VFPE_CCQPLOW(0), 127, 4, 0, 0, "VFPE_CCQPLOW"},
	{I40E_VFPE_CCQPHIGH(0), 127, 4, 0, 0, "VFPE_CCQPHIGH"},
	{I40E_VFPE_IPCONFIG0(0), 127, 4, 0, 0, "VFPE_IPCONFIG0"},
	{I40E_VFPE_CQPERRCODES(0), 127, 4, 0, 0, "VFPE_CQPERRCODES"},
	{I40E_QRX_TAIL1(0), 15, 4, 0, 0, "QRX_TAIL1"},
	{I40E_VFINT_ITRN1(0, 0), 2, 64, 15, 4, "VFINT_ITRN1"},
	{I40E_VFPE_TCPNOWTIMER(0), 127, 4, 0, 0, "VFPE_TCPNOWTIMER"},
	{I40E_VFPE_MRTEIDXMASK(0), 127, 4, 0, 0, "VFPE_MRTEIDXMASK"},
	{I40E_VFPE_RCVUNEXPECTEDERROR(0), 127, 4, 0, 0,
		"VFPE_RCVUNEXPECTEDERROR"},
	{I40E_VFINT_DYN_CTLN1(0), 15, 4, 0, 0, "VFINT_DYN_CTLN1"},
	{I40E_VFINT_ICR01, 0, 0, 0, 0, "VFINT_ICR01"},
	{I40E_VFINT_ITR01(0), 2, 4, 0, 0, "VFINT_ITR01"},
	{I40E_VFINT_ICR0_ENA1, 0, 0, 0, 0, "VFINT_ICR0_ENA1"},
	{I40E_VFINT_STAT_CTL01, 0, 0, 0, 0, "VFINT_STAT_CTL01"},
	{I40E_VFINT_DYN_CTL01, 0, 0, 0, 0, "VFINT_DYN_CTL01"},
	{I40E_VF_ARQBAH1, 0, 0, 0, 0, "VF_ARQBAH1"},
	{I40E_VF_ATQH1, 0, 0, 0, 0, "VF_ATQH1"},
	{I40E_VF_ATQLEN1, 0, 0, 0, 0, "VF_ATQLEN1"},
	{I40E_VF_ARQBAL1, 0, 0, 0, 0, "VF_ARQBAL1"},
	{I40E_VF_ARQT1, 0, 0, 0, 0, "VF_ARQT1"},
	{I40E_VF_ARQH1, 0, 0, 0, 0, "VF_ARQH1"},
	{I40E_VF_ATQBAH1, 0, 0, 0, 0, "VF_ATQBAH1"},
	{I40E_VF_ATQBAL1, 0, 0, 0, 0, "VF_ATQBAL1"},
	{I40E_VF_ARQLEN1, 0, 0, 0, 0, "VF_ARQLEN1"},
	{I40E_PFPE_CQPDB, 0, 0, 0, 0, "PFPE_CQPDB"},
	{I40E_PFPE_CQPTAIL, 0, 0, 0, 0, "PFPE_CQPTAIL"},
	{I40E_PFPE_CCQPSTATUS, 0, 0, 0, 0, "PFPE_CCQPSTATUS"},
	{I40E_PFPE_CCQPLOW, 0, 0, 0, 0, "PFPE_CCQPLOW"},
	{I40E_PFPE_CCQPHIGH, 0, 0, 0, 0, "PFPE_CCQPHIGH"},
	{I40E_PFPE_IPCONFIG0, 0, 0, 0, 0, "PFPE_IPCONFIG0"},
	{I40E_VF_ATQT1, 0, 0, 0, 0, "VF_ATQT1"},
	{I40E_PFPE_TCPNOWTIMER, 0, 0, 0, 0, "PFPE_TCPNOWTIMER"},
	{I40E_PFPE_MRTEIDXMASK, 0, 0, 0, 0, "PFPE_MRTEIDXMASK"},
	{I40E_PFPE_RCVUNEXPECTEDERROR, 0, 0, 0, 0, "PFPE_RCVUNEXPECTEDERROR"},
	{I40E_PFPE_UDACTRL, 0, 0, 0, 0, "PFPE_UDACTRL"},
	{I40E_PFPE_UDAUCFBQPN, 0, 0, 0, 0, "PFPE_UDAUCFBQPN"},
	{I40E_VFGEN_RSTAT, 0, 0, 0, 0, "VFGEN_RSTAT"},
	{I40E_PFPE_CQPERRCODES, 0, 0, 0, 0, "PFPE_CQPERRCODES"},
	{I40E_PFPE_FLMXMITALLOCERR, 0, 0, 0, 0, "PFPE_FLMXMITALLOCERR"},
	{I40E_PFPE_FLMQ1ALLOCERR, 0, 0, 0, 0, "PFPE_FLMQ1ALLOCERR"},
	{I40E_VFPE_IPCONFIG01, 0, 0, 0, 0, "VFPE_IPCONFIG01"},
	{I40E_VFPE_MRTEIDXMASK1, 0, 0, 0, 0, "VFPE_MRTEIDXMASK1"},
	{I40E_VFPE_RCVUNEXPECTEDERROR1, 0, 0, 0, 0, "VFPE_RCVUNEXPECTEDERROR1"},
	{I40E_VFPE_CCQPHIGH1, 0, 0, 0, 0, "VFPE_CCQPHIGH1"},
	{I40E_VFPE_CQPERRCODES1, 0, 0, 0, 0, "VFPE_CQPERRCODES1"},
	{I40E_VFPE_CQPTAIL1, 0, 0, 0, 0, "VFPE_CQPTAIL1"},
	{I40E_VFPE_AEQALLOC1, 0, 0, 0, 0, "VFPE_AEQALLOC1"},
	{I40E_VFPE_TCPNOWTIMER1, 0, 0, 0, 0, "VFPE_TCPNOWTIMER1"},
	{I40E_VFPE_CCQPLOW1, 0, 0, 0, 0, "VFPE_CCQPLOW1"},
	{I40E_VFPE_CQACK1, 0, 0, 0, 0, "VFPE_CQACK1"},
	{I40E_VFPE_CQARM1, 0, 0, 0, 0, "VFPE_CQARM1"},
	{I40E_VFPE_CCQPSTATUS1, 0, 0, 0, 0, "VFPE_CCQPSTATUS1"},
	{I40E_VFPE_CQPDB1, 0, 0, 0, 0, "VFPE_CQPDB1"},
	{I40E_GLPE_VFUDACTRL(0), 31, 4, 0, 0, "GLPE_VFUDACTRL"},
	{I40E_VFPE_WQEALLOC1, 0, 0, 0, 0, "VFPE_WQEALLOC1"},
	{I40E_GLPE_VFUDAUCFBQPN(0), 31, 4, 0, 0, "GLPE_VFUDAUCFBQPN"},
	{I40E_GLPE_VFFLMXMITALLOCERR(0), 31, 4, 0, 0, "GLPE_VFFLMXMITALLOCERR"},
	{I40E_GLPE_VFFLMQ1ALLOCERR(0), 31, 4, 0, 0, "GLPE_VFFLMQ1ALLOCERR"},
	{I40E_VFQF_HLUT(0), 15, 4, 0, 0, "VFQF_HLUT"},
	{I40E_GLPE_CPUSTATUS0, 0, 0, 0, 0, "GLPE_CPUSTATUS0"},
	{I40E_GLPE_CPUSTATUS1, 0, 0, 0, 0, "GLPE_CPUSTATUS1"},
	{I40E_GLPE_CPUSTATUS2, 0, 0, 0, 0, "GLPE_CPUSTATUS2"},
	{I40E_GLPE_CPUTRIG0, 0, 0, 0, 0, "GLPE_CPUTRIG0"},
	{I40E_GLPE_VFFLMOBJCTRL(0), 31, 4, 0, 0, "GLPE_VFFLMOBJCTRL"},
	{I40E_VFCM_PE_ERRINFO, 0, 0, 0, 0, "VFCM_PE_ERRINFO"},
	{I40E_GLPE_RUPM_GCTL, 0, 0, 0, 0, "GLPE_RUPM_GCTL"},
	{I40E_GLPE_DUAL40_RUPM, 0, 0, 0, 0, "GLPE_DUAL40_RUPM"},
	{I40E_GLPE_RUPM_TXHOST_EN, 0, 0, 0, 0, "GLPE_RUPM_TXHOST_EN"},
	{I40E_PRTPE_RUPM_THRES, 0, 0, 0, 0, "PRTPE_RUPM_THRES"},
	{I40E_PRTPE_RUPM_CTL, 0, 0, 0, 0, "PRTPE_RUPM_CTL"},
	{I40E_PRTPE_RUPM_PFCCTL, 0, 0, 0, 0, "PRTPE_RUPM_PFCCTL"},
	{I40E_PRTPE_RUPM_PFCPC, 0, 0, 0, 0, "PRTPE_RUPM_PFCPC"},
	{I40E_PRTPE_RUPM_PFCTCC, 0, 0, 0, 0, "PRTPE_RUPM_PFCTCC"},
	{I40E_GLPE_RUPM_PUSHPOOL, 0, 0, 0, 0, "GLPE_RUPM_PUSHPOOL"},
	{I40E_GLPE_RUPM_FLRPOOL, 0, 0, 0, 0, "GLPE_RUPM_FLRPOOL"},
	{I40E_GLPE_RUPM_PTXPOOL, 0, 0, 0, 0, "GLPE_RUPM_PTXPOOL"},
	{I40E_GLPE_RUPM_CQPPOOL, 0, 0, 0, 0, "GLPE_RUPM_CQPPOOL"},
	{I40E_PRTE_RUPM_TCCNTR03, 0, 0, 0, 0, "PRTE_RUPM_TCCNTR03"},
	{I40E_PRTPE_RUPM_TCCNTR47, 0, 0, 0, 0, "PRTPE_RUPM_TCCNTR47"},
	{I40E_PRTPE_RUPM_CNTR, 0, 0, 0, 0, "PRTPE_RUPM_CNTR"},
	{I40E_PRTPE_RUPM_PTXTCCNTR03, 0, 0, 0, 0, "PRTPE_RUPM_PTXTCCNTR03"},
	{I40E_PRTPE_RUPM_PTCTCCNTR47, 0, 0, 0, 0, "PRTPE_RUPM_PTCTCCNTR47"},
	{I40E_VFCM_PE_ERRDATA, 0, 0, 0, 0, "VFCM_PE_ERRDATA"},
	{I40E_PFPCI_VF_FLUSH_DONE, 0, 0, 0, 0, "PFPCI_VF_FLUSH_DONE"},
	{I40E_GLPES_PFRXVLANERR(0), 15, 4, 0, 0, "GLPES_PFRXVLANERR"},
	{I40E_GLPES_PFIP4RXOCTSLO(0), 15, 8, 0, 0, "GLPES_PFIP4RXOCTSLO"},
	{I40E_GLPES_PFIP4RXOCTSHI(0), 15, 8, 0, 0, "GLPES_PFIP4RXOCTSHI"},
	{I40E_GLPES_PFIP4RXPKTSLO(0), 15, 8, 0, 0, "GLPES_PFIP4RXPKTSLO"},
	{I40E_GLPES_PFIP4RXPKTSHI(0), 15, 8, 0, 0, "GLPES_PFIP4RXPKTSHI"},
	{I40E_GLPES_PFIP4RXDISCARD(0), 15, 4, 0, 0, "GLPES_PFIP4RXDISCARD"},
	{I40E_GLPES_PFIP4RXTRUNC(0), 15, 4, 0, 0, "GLPES_PFIP4RXTRUNC"},
	{I40E_GLPES_PFIP4RXFRAGSLO(0), 15, 8, 0, 0, "GLPES_PFIP4RXFRAGSLO"},
	{I40E_GLPES_PFIP4RXFRAGSHI(0), 15, 8, 0, 0, "GLPES_PFIP4RXFRAGSHI"},
	{I40E_GLPES_PFIP4RXMCOCTSLO(0), 15, 8, 0, 0, "GLPES_PFIP4RXMCOCTSLO"},
	{I40E_GLPES_PFIP4RXMCOCTSHI(0), 15, 8, 0, 0, "GLPES_PFIP4RXMCOCTSHI"},
	{I40E_GLPES_PFIP4RXMCPKTSLO(0), 15, 8, 0, 0, "GLPES_PFIP4RXMCPKTSLO"},
	{I40E_GLPES_PFIP4RXMCPKTSHI(0), 15, 8, 0, 0, "GLPES_PFIP4RXMCPKTSHI"},
	{I40E_GLPES_PFIP6RXOCTSLO(0), 15, 8, 0, 0, "GLPES_PFIP6RXOCTSLO"},
	{I40E_GLPES_PFIP6RXOCTSHI(0), 15, 8, 0, 0, "GLPES_PFIP6RXOCTSHI"},
	{I40E_GLPES_PFIP6RXPKTSLO(0), 15, 8, 0, 0, "GLPES_PFIP6RXPKTSLO"},
	{I40E_GLPES_PFIP6RXPKTSHI(0), 15, 8, 0, 0, "GLPES_PFIP6RXPKTSHI"},
	{I40E_GLPES_PFIP6RXDISCARD(0), 15, 4, 0, 0, "GLPES_PFIP6RXDISCARD"},
	{I40E_GLPES_PFIP6RXTRUNC(0), 15, 4, 0, 0, "GLPES_PFIP6RXTRUNC"},
	{I40E_GLPES_PFIP6RXFRAGSLO(0), 15, 8, 0, 0, "GLPES_PFIP6RXFRAGSLO"},
	{I40E_GLPES_PFIP6RXFRAGSHI(0), 15, 8, 0, 0, "GLPES_PFIP6RXFRAGSHI"},
	{I40E_GLPES_PFIP6RXMCOCTSLO(0), 15, 8, 0, 0, "GLPES_PFIP6RXMCOCTSLO"},
	{I40E_GLPES_PFIP6RXMCOCTSHI(0), 15, 8, 0, 0, "GLPES_PFIP6RXMCOCTSHI"},
	{I40E_GLPES_PFIP6RXMCPKTSLO(0), 15, 8, 0, 0, "GLPES_PFIP6RXMCPKTSLO"},
	{I40E_GLPES_PFIP6RXMCPKTSHI(0), 15, 8, 0, 0, "GLPES_PFIP6RXMCPKTSHI"},
	{I40E_GLPES_PFIP4TXOCTSLO(0), 15, 8, 0, 0, "GLPES_PFIP4TXOCTSLO"},
	{I40E_GLPES_PFIP4TXOCTSHI(0), 15, 8, 0, 0, "GLPES_PFIP4TXOCTSHI"},
	{I40E_GLPES_PFIP4TXPKTSLO(0), 15, 8, 0, 0, "GLPES_PFIP4TXPKTSLO"},
	{I40E_GLPES_PFIP4TXPKTSHI(0), 15, 8, 0, 0, "GLPES_PFIP4TXPKTSHI"},
	{I40E_GLPES_PFIP4TXFRAGSLO(0), 15, 8, 0, 0, "GLPES_PFIP4TXFRAGSLO"},
	{I40E_GLPES_PFIP4TXFRAGSHI(0), 15, 8, 0, 0, "GLPES_PFIP4TXFRAGSHI"},
	{I40E_GLPES_PFIP4TXMCOCTSLO(0), 15, 8, 0, 0, "GLPES_PFIP4TXMCOCTSLO"},
	{I40E_GLPES_PFIP4TXMCOCTSHI(0), 15, 8, 0, 0, "GLPES_PFIP4TXMCOCTSHI"},
	{I40E_GLPES_PFIP4TXMCPKTSLO(0), 15, 8, 0, 0, "GLPES_PFIP4TXMCPKTSLO"},
	{I40E_GLPES_PFIP4TXMCPKTSHI(0), 15, 8, 0, 0, "GLPES_PFIP4TXMCPKTSHI"},
	{I40E_GLPES_PFIP6TXOCTSLO(0), 15, 8, 0, 0, "GLPES_PFIP6TXOCTSLO"},
	{I40E_GLPES_PFIP6TXOCTSHI(0), 15, 8, 0, 0, "GLPES_PFIP6TXOCTSHI"},
	{I40E_GLPES_PFIP6TXPKTSLO(0), 15, 8, 0, 0, "GLPES_PFIP6TXPKTSLO"},
	{I40E_GLPES_PFIP6TXPKTSHI(0), 15, 8, 0, 0, "GLPES_PFIP6TXPKTSHI"},
	{I40E_GLPES_PFIP6TXFRAGSLO(0), 15, 8, 0, 0, "GLPES_PFIP6TXFRAGSLO"},
	{I40E_GLPES_PFIP6TXFRAGSHI(0), 15, 8, 0, 0, "GLPES_PFIP6TXFRAGSHI"},
	{I40E_GLPES_PFIP6TXMCOCTSLO(0), 15, 8, 0, 0, "GLPES_PFIP6TXMCOCTSLO"},
	{I40E_GLPES_PFIP6TXMCOCTSHI(0), 15, 8, 0, 0, "GLPES_PFIP6TXMCOCTSHI"},
	{I40E_GLPES_PFIP6TXMCPKTSLO(0), 15, 8, 0, 0, "GLPES_PFIP6TXMCPKTSLO"},
	{I40E_GLPES_PFIP6TXMCPKTSHI(0), 15, 8, 0, 0, "GLPES_PFIP6TXMCPKTSHI"},
	{I40E_GLPES_PFIP4TXNOROUTE(0), 15, 4, 0, 0, "GLPES_PFIP4TXNOROUTE"},
	{I40E_GLPES_PFIP6TXNOROUTE(0), 15, 4, 0, 0, "GLPES_PFIP6TXNOROUTE"},
	{I40E_GLPES_PFTCPRXSEGSLO(0), 15, 8, 0, 0, "GLPES_PFTCPRXSEGSLO"},
	{I40E_GLPES_PFTCPRXSEGSHI(0), 15, 8, 0, 0, "GLPES_PFTCPRXSEGSHI"},
	{I40E_GLPES_PFTCPRXOPTERR(0), 15, 4, 0, 0, "GLPES_PFTCPRXOPTERR"},
	{I40E_GLPES_PFTCPRXPROTOERR(0), 15, 4, 0, 0, "GLPES_PFTCPRXPROTOERR"},
	{I40E_GLPES_PFTCPTXSEGLO(0), 15, 8, 0, 0, "GLPES_PFTCPTXSEGLO"},
	{I40E_GLPES_PFTCPTXSEGHI(0), 15, 8, 0, 0, "GLPES_PFTCPTXSEGHI"},
	{I40E_GLPES_PFTCPRTXSEG(0), 15, 4, 0, 0, "GLPES_PFTCPRTXSEG"},
	{I40E_GLPES_PFUDPRXPKTSLO(0), 15, 8, 0, 0, "GLPES_PFUDPRXPKTSLO"},
	{I40E_GLPES_PFUDPRXPKTSHI(0), 15, 8, 0, 0, "GLPES_PFUDPRXPKTSHI"},
	{I40E_GLPES_PFUDPTXPKTSLO(0), 15, 8, 0, 0, "GLPES_PFUDPTXPKTSLO"},
	{I40E_GLPES_PFUDPTXPKTSHI(0), 15, 8, 0, 0, "GLPES_PFUDPTXPKTSHI"},
	{I40E_GLPES_PFRDMARXWRSLO(0), 15, 8, 0, 0, "GLPES_PFRDMARXWRSLO"},
	{I40E_GLPES_PFRDMARXWRSHI(0), 15, 8, 0, 0, "GLPES_PFRDMARXWRSHI"},
	{I40E_GLPES_PFRDMARXRDSLO(0), 15, 8, 0, 0, "GLPES_PFRDMARXRDSLO"},
	{I40E_GLPES_PFRDMARXRDSHI(0), 15, 8, 0, 0, "GLPES_PFRDMARXRDSHI"},
	{I40E_GLPES_PFRDMARXSNDSLO(0), 15, 8, 0, 0, "GLPES_PFRDMARXSNDSLO"},
	{I40E_GLPES_PFRDMARXSNDSHI(0), 15, 8, 0, 0, "GLPES_PFRDMARXSNDSHI"},
	{I40E_GLPES_PFRDMATXWRSLO(0), 15, 8, 0, 0, "GLPES_PFRDMATXWRSLO"},
	{I40E_GLPES_PFRDMATXWRSHI(0), 15, 8, 0, 0, "GLPES_PFRDMATXWRSHI"},
	{I40E_GLPES_PFRDMATXRDSLO(0), 15, 8, 0, 0, "GLPES_PFRDMATXRDSLO"},
	{I40E_GLPES_PFRDMATXRDSHI(0), 15, 8, 0, 0, "GLPES_PFRDMATXRDSHI"},
	{I40E_GLPES_PFRDMATXSNDSLO(0), 15, 8, 0, 0, "GLPES_PFRDMATXSNDSLO"},
	{I40E_GLPES_PFRDMATXSNDSHI(0), 15, 8, 0, 0, "GLPES_PFRDMATXSNDSHI"},
	{I40E_GLPES_PFRDMAVBNDLO(0), 15, 8, 0, 0, "GLPES_PFRDMAVBNDLO"},
	{I40E_GLPES_PFRDMAVBNDHI(0), 15, 8, 0, 0, "GLPES_PFRDMAVBNDHI"},
	{I40E_GLPES_PFRDMAVINVLO(0), 15, 8, 0, 0, "GLPES_PFRDMAVINVLO"},
	{I40E_GLPES_PFRDMAVINVHI(0), 15, 8, 0, 0, "GLPES_PFRDMAVINVHI"},
	{I40E_GLPES_VFRXVLANERR(0), 31, 4, 0, 0, "GLPES_VFRXVLANERR"},
	{I40E_GLPES_VFIP4RXOCTSLO(0), 31, 8, 0, 0, "GLPES_VFIP4RXOCTSLO"},
	{I40E_GLPES_VFIP4RXOCTSHI(0), 31, 8, 0, 0, "GLPES_VFIP4RXOCTSHI"},
	{I40E_GLPES_VFIP4RXPKTSLO(0), 31, 8, 0, 0, "GLPES_VFIP4RXPKTSLO"},
	{I40E_GLPES_VFIP4RXPKTSHI(0), 31, 8, 0, 0, "GLPES_VFIP4RXPKTSHI"},
	{I40E_GLPES_VFIP4RXDISCARD(0), 31, 4, 0, 0, "GLPES_VFIP4RXDISCARD"},
	{I40E_GLPES_VFIP4RXTRUNC(0), 31, 4, 0, 0, "GLPES_VFIP4RXTRUNC"},
	{I40E_GLPES_VFIP4RXFRAGSLO(0), 31, 8, 0, 0, "GLPES_VFIP4RXFRAGSLO"},
	{I40E_GLPES_VFIP4RXFRAGSHI(0), 31, 8, 0, 0, "GLPES_VFIP4RXFRAGSHI"},
	{I40E_GLPES_VFIP4RXMCOCTSLO(0), 31, 8, 0, 0, "GLPES_VFIP4RXMCOCTSLO"},
	{I40E_GLPES_VFIP4RXMCOCTSHI(0), 31, 8, 0, 0, "GLPES_VFIP4RXMCOCTSHI"},
	{I40E_GLPES_VFIP4RXMCPKTSLO(0), 31, 8, 0, 0, "GLPES_VFIP4RXMCPKTSLO"},
	{I40E_GLPES_VFIP4RXMCPKTSHI(0), 31, 8, 0, 0, "GLPES_VFIP4RXMCPKTSHI"},
	{I40E_GLPES_VFIP6RXOCTSLO(0), 31, 8, 0, 0, "GLPES_VFIP6RXOCTSLO"},
	{I40E_GLPES_VFIP6RXOCTSHI(0), 31, 8, 0, 0, "GLPES_VFIP6RXOCTSHI"},
	{I40E_GLPES_VFIP6RXPKTSLO(0), 31, 8, 0, 0, "GLPES_VFIP6RXPKTSLO"},
	{I40E_GLPES_VFIP6RXPKTSHI(0), 31, 8, 0, 0, "GLPES_VFIP6RXPKTSHI"},
	{I40E_GLPES_VFIP6RXDISCARD(0), 31, 4, 0, 0, "GLPES_VFIP6RXDISCARD"},
	{I40E_GLPES_VFIP6RXTRUNC(0), 31, 4, 0, 0, "GLPES_VFIP6RXTRUNC"},
	{I40E_GLPES_VFIP6RXFRAGSLO(0), 31, 8, 0, 0, "GLPES_VFIP6RXFRAGSLO"},
	{I40E_GLPES_VFIP6RXFRAGSHI(0), 31, 8, 0, 0, "GLPES_VFIP6RXFRAGSHI"},
	{I40E_GLPES_VFIP6RXMCOCTSLO(0), 31, 8, 0, 0, "GLPES_VFIP6RXMCOCTSLO"},
	{I40E_GLPES_VFIP6RXMCOCTSHI(0), 31, 8, 0, 0, "GLPES_VFIP6RXMCOCTSHI"},
	{I40E_GLPES_VFIP6RXMCPKTSLO(0), 31, 8, 0, 0, "GLPES_VFIP6RXMCPKTSLO"},
	{I40E_GLPES_VFIP6RXMCPKTSHI(0), 31, 8, 0, 0, "GLPES_VFIP6RXMCPKTSHI"},
	{I40E_GLPES_VFIP4TXOCTSLO(0), 31, 8, 0, 0, "GLPES_VFIP4TXOCTSLO"},
	{I40E_GLPES_VFIP4TXOCTSHI(0), 31, 8, 0, 0, "GLPES_VFIP4TXOCTSHI"},
	{I40E_GLPES_VFIP4TXPKTSLO(0), 31, 8, 0, 0, "GLPES_VFIP4TXPKTSLO"},
	{I40E_GLPES_VFIP4TXPKTSHI(0), 31, 8, 0, 0, "GLPES_VFIP4TXPKTSHI"},
	{I40E_GLPES_VFIP4TXFRAGSLO(0), 31, 8, 0, 0, "GLPES_VFIP4TXFRAGSLO"},
	{I40E_GLPES_VFIP4TXFRAGSHI(0), 31, 8, 0, 0, "GLPES_VFIP4TXFRAGSHI"},
	{I40E_GLPES_VFIP4TXMCOCTSLO(0), 31, 8, 0, 0, "GLPES_VFIP4TXMCOCTSLO"},
	{I40E_GLPES_VFIP4TXMCOCTSHI(0), 31, 8, 0, 0, "GLPES_VFIP4TXMCOCTSHI"},
	{I40E_GLPES_VFIP4TXMCPKTSLO(0), 31, 8, 0, 0, "GLPES_VFIP4TXMCPKTSLO"},
	{I40E_GLPES_VFIP4TXMCPKTSHI(0), 31, 8, 0, 0, "GLPES_VFIP4TXMCPKTSHI"},
	{I40E_GLPES_VFIP6TXOCTSLO(0), 31, 8, 0, 0, "GLPES_VFIP6TXOCTSLO"},
	{I40E_GLPES_VFIP6TXOCTSHI(0), 31, 8, 0, 0, "GLPES_VFIP6TXOCTSHI"},
	{I40E_GLPES_VFIP6TXPKTSLO(0), 31, 8, 0, 0, "GLPES_VFIP6TXPKTSLO"},
	{I40E_GLPES_VFIP6TXPKTSHI(0), 31, 8, 0, 0, "GLPES_VFIP6TXPKTSHI"},
	{I40E_GLPES_VFIP6TXFRAGSLO(0), 31, 8, 0, 0, "GLPES_VFIP6TXFRAGSLO"},
	{I40E_GLPES_VFIP6TXFRAGSHI(0), 31, 8, 0, 0, "GLPES_VFIP6TXFRAGSHI"},
	{I40E_GLPES_VFIP6TXMCOCTSLO(0), 31, 8, 0, 0, "GLPES_VFIP6TXMCOCTSLO"},
	{I40E_GLPES_VFIP6TXMCOCTSHI(0), 31, 8, 0, 0, "GLPES_VFIP6TXMCOCTSHI"},
	{I40E_GLPES_VFIP6TXMCPKTSLO(0), 31, 8, 0, 0, "GLPES_VFIP6TXMCPKTSLO"},
	{I40E_GLPES_VFIP6TXMCPKTSHI(0), 31, 8, 0, 0, "GLPES_VFIP6TXMCPKTSHI"},
	{I40E_GLPES_VFIP4TXNOROUTE(0), 31, 4, 0, 0, "GLPES_VFIP4TXNOROUTE"},
	{I40E_GLPES_VFIP6TXNOROUTE(0), 31, 4, 0, 0, "GLPES_VFIP6TXNOROUTE"},
	{I40E_GLPES_VFTCPRXSEGSLO(0), 31, 8, 0, 0, "GLPES_VFTCPRXSEGSLO"},
	{I40E_GLPES_VFTCPRXSEGSHI(0), 31, 8, 0, 0, "GLPES_VFTCPRXSEGSHI"},
	{I40E_GLPES_VFTCPRXOPTERR(0), 31, 4, 0, 0, "GLPES_VFTCPRXOPTERR"},
	{I40E_GLPES_VFTCPRXPROTOERR(0), 31, 4, 0, 0, "GLPES_VFTCPRXPROTOERR"},
	{I40E_GLPES_VFTCPTXSEGLO(0), 31, 8, 0, 0, "GLPES_VFTCPTXSEGLO"},
	{I40E_GLPES_VFTCPTXSEGHI(0), 31, 8, 0, 0, "GLPES_VFTCPTXSEGHI"},
	{I40E_GLPES_VFTCPRTXSEG(0), 31, 4, 0, 0, "GLPES_VFTCPRTXSEG"},
	{I40E_GLPES_VFUDPRXPKTSLO(0), 31, 8, 0, 0, "GLPES_VFUDPRXPKTSLO"},
	{I40E_GLPES_VFUDPRXPKTSHI(0), 31, 8, 0, 0, "GLPES_VFUDPRXPKTSHI"},
	{I40E_GLPES_VFUDPTXPKTSLO(0), 31, 8, 0, 0, "GLPES_VFUDPTXPKTSLO"},
	{I40E_GLPES_VFUDPTXPKTSHI(0), 31, 8, 0, 0, "GLPES_VFUDPTXPKTSHI"},
	{I40E_GLPES_VFRDMARXWRSLO(0), 31, 8, 0, 0, "GLPES_VFRDMARXWRSLO"},
	{I40E_GLPES_VFRDMARXWRSHI(0), 31, 8, 0, 0, "GLPES_VFRDMARXWRSHI"},
	{I40E_GLPES_VFRDMARXRDSLO(0), 31, 8, 0, 0, "GLPES_VFRDMARXRDSLO"},
	{I40E_GLPES_VFRDMARXRDSHI(0), 31, 8, 0, 0, "GLPES_VFRDMARXRDSHI"},
	{I40E_GLPES_VFRDMARXSNDSLO(0), 31, 8, 0, 0, "GLPES_VFRDMARXSNDSLO"},
	{I40E_GLPES_VFRDMARXSNDSHI(0), 31, 8, 0, 0, "GLPES_VFRDMARXSNDSHI"},
	{I40E_GLPES_VFRDMATXWRSLO(0), 31, 8, 0, 0, "GLPES_VFRDMATXWRSLO"},
	{I40E_GLPES_VFRDMATXWRSHI(0), 31, 8, 0, 0, "GLPES_VFRDMATXWRSHI"},
	{I40E_GLPES_VFRDMATXRDSLO(0), 31, 8, 0, 0, "GLPES_VFRDMATXRDSLO"},
	{I40E_GLPES_VFRDMATXRDSHI(0), 31, 8, 0, 0, "GLPES_VFRDMATXRDSHI"},
	{I40E_GLPES_VFRDMATXSNDSLO(0), 31, 8, 0, 0, "GLPES_VFRDMATXSNDSLO"},
	{I40E_GLPES_VFRDMATXSNDSHI(0), 31, 8, 0, 0, "GLPES_VFRDMATXSNDSHI"},
	{I40E_GLPES_VFRDMAVBNDLO(0), 31, 8, 0, 0, "GLPES_VFRDMAVBNDLO"},
	{I40E_GLPES_VFRDMAVBNDHI(0), 31, 8, 0, 0, "GLPES_VFRDMAVBNDHI"},
	{I40E_GLPES_VFRDMAVINVLO(0), 31, 8, 0, 0, "GLPES_VFRDMAVINVLO"},
	{I40E_GLPES_VFRDMAVINVHI(0), 31, 8, 0, 0, "GLPES_VFRDMAVINVHI"},
	{I40E_GLPES_RDMARXUNALIGN, 0, 0, 0, 0, "GLPES_RDMARXUNALIGN"},
	{I40E_GLPES_RDMARXOOONOMARK, 0, 0, 0, 0, "GLPES_RDMARXOOONOMARK"},
	{I40E_GLPES_RDMARXMULTFPDUSLO, 0, 0, 0, 0, "GLPES_RDMARXMULTFPDUSLO"},
	{I40E_GLPES_RDMARXMULTFPDUSHI, 0, 0, 0, 0, "GLPES_RDMARXMULTFPDUSHI"},
	{I40E_GLPES_RDMARXOOODDPLO, 0, 0, 0, 0, "GLPES_RDMARXOOODDPLO"},
	{I40E_GLPES_RDMARXOOODDPHI, 0, 0, 0, 0, "GLPES_RDMARXOOODDPHI"},
	{I40E_GLPES_TCPRXPUREACKSLO, 0, 0, 0, 0, "GLPES_TCPRXPUREACKSLO"},
	{I40E_GLPES_TCPRXPUREACKHI, 0, 0, 0, 0, "GLPES_TCPRXPUREACKHI"},
	{I40E_GLPES_TCPRXONEHOLELO, 0, 0, 0, 0, "GLPES_TCPRXONEHOLELO"},
	{I40E_GLPES_TCPRXONEHOLEHI, 0, 0, 0, 0, "GLPES_TCPRXONEHOLEHI"},
	{I40E_GLPES_TCPRXTWOHOLELO, 0, 0, 0, 0, "GLPES_TCPRXTWOHOLELO"},
	{I40E_GLPES_TCPRXTWOHOLEHI, 0, 0, 0, 0, "GLPES_TCPRXTWOHOLEHI"},
	{I40E_GLPES_TCPRXTHREEHOLELO, 0, 0, 0, 0, "GLPES_TCPRXTHREEHOLELO"},
	{I40E_GLPES_TCPRXTHREEHOLEHI, 0, 0, 0, 0, "GLPES_TCPRXTHREEHOLEHI"},
	{I40E_GLPES_TCPRXFOURHOLELO, 0, 0, 0, 0, "GLPES_TCPRXFOURHOLELO"},
	{I40E_GLPES_TCPRXFOURHOLEHI, 0, 0, 0, 0, "GLPES_TCPRXFOURHOLEHI"},
	{I40E_GLPES_TCPTXRETRANSFASTLO, 0, 0, 0, 0, "GLPES_TCPTXRETRANSFASTLO"},
	{I40E_GLPES_TCPTXRETRANSFASTHI, 0, 0, 0, 0, "GLPES_TCPTXRETRANSFASTHI"},
	{I40E_GLPES_TCPTXTOUTSFASTLO, 0, 0, 0, 0, "GLPES_TCPTXTOUTSFASTLO"},
	{I40E_GLPES_TCPTXTOUTSFASTHI, 0, 0, 0, 0, "GLPES_TCPTXTOUTSFASTHI"},
	{I40E_GLPES_TCPTXTOUTSLO, 0, 0, 0, 0, "GLPES_TCPTXTOUTSLO"},
	{I40E_GLPES_TCPTXTOUTSHI, 0, 0, 0, 0, "GLPES_TCPTXTOUTSHI"},
	{I40E_PRTDCB_TCMSTC_RLPM(0), 7, 32, 0, 0, "PRTDCB_TCMSTC_RLPM"},
	{I40E_PRTDCB_RLPMC, 0, 0, 0, 0, "PRTDCB_RLPMC"},
	{I40E_PRTDCB_TCPMC_RLPM, 0, 0, 0, 0, "PRTDCB_TCPMC_RLPM"},
	{I40E_VFINT_ITRN(0, 0), 2, 2048, 511, 4, "VFINT_ITRN"},
	{I40E_VFINT_DYN_CTLN(0), 511, 4, 0, 0, "VFINT_DYN_CTLN"},
	{I40E_VPINT_LNKLSTN(0), 511, 4, 0, 0, "VPINT_LNKLSTN"},
	{I40E_VPINT_RATEN(0), 511, 4, 0, 0, "VPINT_RATEN"},
	{I40E_VPINT_CEQCTL(0), 511, 4, 0, 0, "VPINT_CEQCTL"},
	{I40E_VFINT_ITR0(0, 0), 2, 1024, 127, 4, "VFINT_ITR0"},
	{I40E_VFINT_STAT_CTL0(0), 127, 4, 0, 0, "VFINT_STAT_CTL0"},
	{I40E_VFINT_DYN_CTL0(0), 127, 4, 0, 0, "VFINT_DYN_CTL0"},
	{I40E_VPINT_LNKLST0(0), 127, 4, 0, 0, "VPINT_LNKLST0"},
	{I40E_VPINT_RATE0(0), 127, 4, 0, 0, "VPINT_RATE0"},
	{I40E_VPINT_AEQCTL(0), 127, 4, 0, 0, "VPINT_AEQCTL"},
	{I40E_VFINT_ICR0(0), 127, 4, 0, 0, "VFINT_ICR0"},
	{I40E_VFINT_ICR0_ENA(0), 127, 4, 0, 0, "VFINT_ICR0_ENA"},
	{I40E_PFINT_ITRN(0, 0), 2, 2048, 511, 4, "PFINT_ITRN"},
	{I40E_PFINT_DYN_CTLN(0), 511, 4, 0, 0, "PFINT_DYN_CTLN"},
	{I40E_PFINT_LNKLSTN(0), 511, 4, 0, 0, "PFINT_LNKLSTN"},
	{I40E_PFINT_RATEN(0), 511, 4, 0, 0, "PFINT_RATEN"},
	{I40E_PFINT_CEQCTL(0), 511, 4, 0, 0, "PFINT_CEQCTL"},
	{I40E_PFINT_ITR0(0), 2, 128, 0, 0, "PFINT_ITR0"},
	{I40E_PFINT_STAT_CTL0, 0, 0, 0, 0, "PFINT_STAT_CTL0"},
	{I40E_PFINT_DYN_CTL0, 0, 0, 0, 0, "PFINT_DYN_CTL0"},
	{I40E_PFINT_LNKLST0, 0, 0, 0, 0, "PFINT_LNKLST0"},
	{I40E_PFINT_RATE0, 0, 0, 0, 0, "PFINT_RATE0"},
	{I40E_PFINT_AEQCTL, 0, 0, 0, 0, "PFINT_AEQCTL"},
	{I40E_PFINT_ICR0, 0, 0, 0, 0, "PFINT_ICR0"},
	{I40E_PFINT_ICR0_ENA, 0, 0, 0, 0, "PFINT_ICR0_ENA"},
	{I40E_QINT_RQCTL(0), 1535, 4, 0, 0, "QINT_RQCTL"},
	{I40E_QINT_TQCTL(0), 1535, 4, 0, 0, "QINT_TQCTL"},
	{I40E_PFGEN_PORTMDIO_NUM, 0, 0, 0, 0, "PFGEN_PORTMDIO_NUM"},
	{I40E_GLINT_CTL, 0, 0, 0, 0, "GLINT_CTL"},
	{I40E_GLLAN_TSOMSK_F, 0, 0, 0, 0, "GLLAN_TSOMSK_F"},
	{I40E_GLLAN_TSOMSK_M, 0, 0, 0, 0, "GLLAN_TSOMSK_M"},
	{I40E_GLLAN_TSOMSK_L, 0, 0, 0, 0, "GLLAN_TSOMSK_L"},
	{I40E_GL_RDPU_CNTRL, 0, 0, 0, 0, "GL_RDPU_CNTRL"},
	{I40E_PFPM_FHFT_LENGTH(0), 7, 128, 0, 0, "PFPM_FHFT_LENGTH"},
	{I40E_PFPM_WUC, 0, 0, 0, 0, "PFPM_WUC"},
	{I40E_PFPM_WUFC, 0, 0, 0, 0, "PFPM_WUFC"},
	{I40E_PFPM_WUS, 0, 0, 0, 0, "PFPM_WUS"},
	{I40E_PRTPM_FHFHR, 0, 0, 0, 0, "PRTPM_FHFHR"},
	{I40E_GLPM_WUMC, 0, 0, 0, 0, "GLPM_WUMC"},
	{I40E_VPLAN_QTABLE(0, 0), 15, 1024, 127, 4, "VPLAN_QTABLE"},
	{I40E_VPLAN_MAPENA(0), 127, 4, 0, 0, "VPLAN_MAPENA"},
	{I40E_VFGEN_RSTAT1(0), 127, 4, 0, 0, "VFGEN_RSTAT1"},
	{I40E_VPLAN_QBASE(0), 127, 4, 0, 0, "VPLAN_QBASE"},
	{I40E_PF_ATQBAL, 0, 0, 0, 0, "PF_ATQBAL"},
	{I40E_GL_ATQBAL, 0, 0, 0, 0, "GL_ATQBAL"},
	{I40E_PF_ARQBAL, 0, 0, 0, 0, "PF_ARQBAL"},
	{I40E_GL_ARQBAL, 0, 0, 0, 0, "GL_ARQBAL"},
	{I40E_PF_ATQBAH, 0, 0, 0, 0, "PF_ATQBAH"},
	{I40E_GL_ATQBAH, 0, 0, 0, 0, "GL_ATQBAH"},
	{I40E_PF_ARQBAH, 0, 0, 0, 0, "PF_ARQBAH"},
	{I40E_GL_ARQBAH, 0, 0, 0, 0, "GL_ARQBAH"},
	{I40E_PF_ATQLEN, 0, 0, 0, 0, "PF_ATQLEN"},
	{I40E_GL_ATQLEN, 0, 0, 0, 0, "GL_ATQLEN"},
	{I40E_PF_ARQLEN, 0, 0, 0, 0, "PF_ARQLEN"},
	{I40E_PF_ATQH, 0, 0, 0, 0, "PF_ATQH"},
	{I40E_GL_ATQH, 0, 0, 0, 0, "GL_ATQH"},
	{I40E_PF_ARQH, 0, 0, 0, 0, "PF_ARQH"},
	{I40E_GL_ARQH, 0, 0, 0, 0, "GL_ARQH"},
	{I40E_PF_ATQT, 0, 0, 0, 0, "PF_ATQT"},
	{I40E_GL_ATQT, 0, 0, 0, 0, "GL_ATQT"},
	{I40E_PF_ARQT, 0, 0, 0, 0, "PF_ARQT"},
	{I40E_GL_ARQT, 0, 0, 0, 0, "GL_ARQT"},
	{I40E_VF_ATQBAL(0), 127, 4, 0, 0, "VF_ATQBAL"},
	{I40E_VF_ARQBAL(0), 127, 4, 0, 0, "VF_ARQBAL"},
	{I40E_VF_ATQBAH(0), 127, 4, 0, 0, "VF_ATQBAH"},
	{I40E_VF_ARQBAH(0), 127, 4, 0, 0, "VF_ARQBAH"},
	{I40E_VF_ATQLEN(0), 127, 4, 0, 0, "VF_ATQLEN"},
	{I40E_VF_ARQLEN(0), 127, 4, 0, 0, "VF_ARQLEN"},
	{I40E_VF_ATQH(0), 127, 4, 0, 0, "VF_ATQH"},
	{I40E_VF_ARQH(0), 127, 4, 0, 0, "VF_ARQH"},
	{I40E_VF_ATQT(0), 127, 4, 0, 0, "VF_ATQT"},
	{I40E_VF_ARQT(0), 127, 4, 0, 0, "VF_ARQT"},
	{I40E_PRTDCB_GENC, 0, 0, 0, 0, "PRTDCB_GENC"},
	{I40E_PRTDCB_GENS, 0, 0, 0, 0, "PRTDCB_GENS"},
	{I40E_GLDCB_GENC, 0, 0, 0, 0, "GLDCB_GENC"},
	{I40E_GL_FWSTS, 0, 0, 0, 0, "GL_FWSTS"},
	{I40E_GL_FWRESETCNT, 0, 0, 0, 0, "GL_FWRESETCNT"},
	{I40E_GL_VF_CTRL_TX(0), 127, 4, 0, 0, "GL_VF_CTRL_TX"},
	{I40E_GL_VF_CTRL_RX(0), 127, 4, 0, 0, "GL_VF_CTRL_RX"},
	{I40E_PRTTSYN_CTL1, 0, 0, 0, 0, "PRTTSYN_CTL1"},
	{I40E_PRTTSYN_RXTIME_H(0), 3, 32, 0, 0, "PRTTSYN_RXTIME_H"},
	{I40E_PRTTSYN_RXTIME_L(0), 3, 32, 0, 0, "PRTTSYN_RXTIME_L"},
	{I40E_PRTTSYN_STAT_1, 0, 0, 0, 0, "PRTTSYN_STAT_1"},
	{I40E_PRT_MNG_FTFT_MASK(0), 7, 32, 0, 0, "PRT_MNG_FTFT_MASK"},
	{I40E_PRT_MNG_FTFT_LENGTH, 0, 0, 0, 0, "PRT_MNG_FTFT_LENGTH"},
	{I40E_PRT_MNG_FTFT_DATA(0), 31, 32, 0, 0, "PRT_MNG_FTFT_DATA"},
	{I40E_GL_PPRS_SPARE, 0, 0, 0, 0, "GL_PPRS_SPARE"},
	{I40E_PFGEN_STATE, 0, 0, 0, 0, "PFGEN_STATE"},
	{I40E_PFINT_GPIO_ENA, 0, 0, 0, 0, "PFINT_GPIO_ENA"},
	{I40E_GLGEN_MISC_SPARE, 0, 0, 0, 0, "GLGEN_MISC_SPARE"},
	{I40E_GLGEN_GPIO_CTL(0), 29, 4, 0, 0, "GLGEN_GPIO_CTL"},
	{I40E_GLGEN_LED_CTL, 0, 0, 0, 0, "GLGEN_LED_CTL"},
	{I40E_GLGEN_GPIO_STAT, 0, 0, 0, 0, "GLGEN_GPIO_STAT"},
	{I40E_GLGEN_GPIO_TRANSIT, 0, 0, 0, 0, "GLGEN_GPIO_TRANSIT"},
	{I40E_GLGEN_GPIO_SET, 0, 0, 0, 0, "GLGEN_GPIO_SET"},
	{I40E_EMPINT_GPIO_ENA, 0, 0, 0, 0, "EMPINT_GPIO_ENA"},
	{I40E_GLGEN_MSCA(0), 3, 4, 0, 0, "GLGEN_MSCA"},
	{I40E_GLGEN_MSRWD(0), 3, 4, 0, 0, "GLGEN_MSRWD"},
	{I40E_GLGEN_I2CPARAMS(0), 3, 4, 0, 0, "GLGEN_I2CPARAMS"},
	{I40E_GLVFGEN_TIMER, 0, 0, 0, 0, "GLVFGEN_TIMER"},
	{I40E_GLGEN_MDIO_I2C_SEL(0), 3, 4, 0, 0, "GLGEN_MDIO_I2C_SEL"},
	{I40E_GLGEN_MDIO_CTRL(0), 3, 4, 0, 0, "GLGEN_MDIO_CTRL"},
	{I40E_GLGEN_I2CCMD(0), 3, 4, 0, 0, "GLGEN_I2CCMD"},
	{I40E_PRTMAC_PCS_XAUI_SWAP_A, 0, 0, 0, 0, "PRTMAC_PCS_XAUI_SWAP_A"},
	{I40E_PRTMAC_PCS_XAUI_SWAP_B, 0, 0, 0, 0, "PRTMAC_PCS_XAUI_SWAP_B"},
	{I40E_VSIGEN_RTRIG(0), 383, 4, 0, 0, "VSIGEN_RTRIG"},
	{I40E_VSIGEN_RSTAT(0), 383, 4, 0, 0, "VSIGEN_RSTAT"},
	{I40E_VPGEN_VFRTRIG(0), 127, 4, 0, 0, "VPGEN_VFRTRIG"},
	{I40E_VPGEN_VFRSTAT(0), 127, 4, 0, 0, "VPGEN_VFRSTAT"},
	{I40E_PFGEN_CTRL, 0, 0, 0, 0, "PFGEN_CTRL"},
	{I40E_PFGEN_DRUN, 0, 0, 0, 0, "PFGEN_DRUN"},
	{I40E_GLGEN_VFLRSTAT(0), 3, 4, 0, 0, "GLGEN_VFLRSTAT"},
	{I40E_GL_UFUSE, 0, 0, 0, 0, "GL_UFUSE"},
	{I40E_GL_GP_FUSE(0), 28, 4, 0, 0, "GL_GP_FUSE"},
	{I40E_PRTDCB_TETSC_TPB, 0, 0, 0, 0, "PRTDCB_TETSC_TPB"},
	{I40E_PF_FUNC_RID, 0, 0, 0, 0, "PF_FUNC_RID"},
	{I40E_PF_PCI_CIAA, 0, 0, 0, 0, "PF_PCI_CIAA"},
	{I40E_PF_PCI_CIAD, 0, 0, 0, 0, "PF_PCI_CIAD"},
	{I40E_PFPCI_FACTPS, 0, 0, 0, 0, "PFPCI_FACTPS"},
	{I40E_PFPCI_ICAUSE, 0, 0, 0, 0, "PFPCI_ICAUSE"},
	{I40E_PFPCI_IENA, 0, 0, 0, 0, "PFPCI_IENA"},
	{I40E_PFPCI_VMINDEX, 0, 0, 0, 0, "PFPCI_VMINDEX"},
	{I40E_PFPCI_VMPEND, 0, 0, 0, 0, "PFPCI_VMPEND"},
	{I40E_GLPCI_DREVID, 0, 0, 0, 0, "GLPCI_DREVID"},
	{I40E_GLPCI_BYTCTH, 0, 0, 0, 0, "GLPCI_BYTCTH"},
	{I40E_GLPCI_BYTCTL, 0, 0, 0, 0, "GLPCI_BYTCTL"},
	{I40E_GLPCI_GSCL_1, 0, 0, 0, 0, "GLPCI_GSCL_1"},
	{I40E_GLPCI_GSCL_2, 0, 0, 0, 0, "GLPCI_GSCL_2"},
	{I40E_GLPCI_GSCL_5_8(0), 3, 4, 0, 0, "GLPCI_GSCL_5_8"},
	{I40E_GLPCI_GSCN_0_3(0), 3, 4, 0, 0, "GLPCI_GSCN_0_3"},
	{I40E_GLPCI_PKTCT, 0, 0, 0, 0, "GLPCI_PKTCT"},
	{I40E_GLPCI_PQ_MAX_USED_SPC, 0, 0, 0, 0, "GLPCI_PQ_MAX_USED_SPC"},
	{I40E_GLPCI_PM_MUX_PFB, 0, 0, 0, 0, "GLPCI_PM_MUX_PFB"},
	{I40E_GLPCI_PM_MUX_NPQ, 0, 0, 0, 0, "GLPCI_PM_MUX_NPQ"},
	{I40E_GLPCI_SPARE_BITS_0, 0, 0, 0, 0, "GLPCI_SPARE_BITS_0"},
	{I40E_GLPCI_SPARE_BITS_1, 0, 0, 0, 0, "GLPCI_SPARE_BITS_1"},
	{I40E_GLPCI_CUR_RLAN_ALWD, 0, 0, 0, 0, "GLPCI_CUR_RLAN_ALWD"},
	{I40E_GLPCI_CUR_TLAN_ALWD, 0, 0, 0, 0, "GLPCI_CUR_TLAN_ALWD"},
	{I40E_GLPCI_CUR_RXPE_ALWD, 0, 0, 0, 0, "GLPCI_CUR_RXPE_ALWD"},
	{I40E_GLPCI_CUR_TXPE_ALWD, 0, 0, 0, 0, "GLPCI_CUR_TXPE_ALWD"},
	{I40E_GLPCI_CUR_PMAT_ALWD, 0, 0, 0, 0, "GLPCI_CUR_PMAT_ALWD"},
	{I40E_GLPCI_CUR_MNG_ALWD, 0, 0, 0, 0, "GLPCI_CUR_MNG_ALWD"},
	{I40E_GLPCI_CUR_TDPU_ALWD, 0, 0, 0, 0, "GLPCI_CUR_TDPU_ALWD"},
	{I40E_GLPCI_CUR_RLAN_RSVD, 0, 0, 0, 0, "GLPCI_CUR_RLAN_RSVD"},
	{I40E_GLPCI_CUR_TLAN_RSVD, 0, 0, 0, 0, "GLPCI_CUR_TLAN_RSVD"},
	{I40E_GLPCI_CUR_RXPE_RSVD, 0, 0, 0, 0, "GLPCI_CUR_RXPE_RSVD"},
	{I40E_GLPCI_CUR_TXPE_RSVD, 0, 0, 0, 0, "GLPCI_CUR_TXPE_RSVD"},
	{I40E_GLPCI_CUR_PMAT_RSVD, 0, 0, 0, 0, "GLPCI_CUR_PMAT_RSVD"},
	{I40E_GLPCI_CUR_MNG_RSVD, 0, 0, 0, 0, "GLPCI_CUR_MNG_RSVD"},
	{I40E_GLPCI_CUR_TDPU_RSVD, 0, 0, 0, 0, "GLPCI_CUR_TDPU_RSVD"},
	{I40E_PFPCI_VF_FLUSH_DONE1(0), 127, 4, 0, 0, "PFPCI_VF_FLUSH_DONE1"},
	{I40E_PFPCI_PF_FLUSH_DONE, 0, 0, 0, 0, "PFPCI_PF_FLUSH_DONE"},
	{I40E_PFPCI_VM_FLUSH_DONE, 0, 0, 0, 0, "PFPCI_VM_FLUSH_DONE"},
	{I40E_GLPCI_NPQ_CFG, 0, 0, 0, 0, "GLPCI_NPQ_CFG"},
	{I40E_GLPCI_CUR_CLNT_COMMON, 0, 0, 0, 0, "GLPCI_CUR_CLNT_COMMON"},
	{I40E_GLPCI_CUR_CLNT_PIPEMON, 0, 0, 0, 0, "GLPCI_CUR_CLNT_PIPEMON"},
	{I40E_GLPCI_CUR_WATMK_CLNT_COMMON, 0, 0, 0, 0,
		"GLPCI_CUR_WATMK_CLNT_COMMON"},
	{I40E_GLPCI_WATMK_CLNT_PIPEMON, 0, 0, 0, 0,
		"GLPCI_WATMK_CLNT_PIPEMON"},
	{I40E_GLPCI_WATMK_RLAN_ALWD, 0, 0, 0, 0, "GLPCI_WATMK_RLAN_ALWD"},
	{I40E_GLPCI_WATMK_TLAN_ALWD, 0, 0, 0, 0, "GLPCI_WATMK_TLAN_ALWD"},
	{I40E_GLPCI_WATMK_RXPE_ALWD, 0, 0, 0, 0, "GLPCI_WATMK_RXPE_ALWD"},
	{I40E_GLPCI_WATMK_TXPE_ALWD, 0, 0, 0, 0, "GLPCI_WATMK_TXPE_ALWD"},
	{I40E_GLPCI_WATMK_PMAT_ALWD, 0, 0, 0, 0, "GLPCI_WATMK_PMAT_ALWD"},
	{I40E_GLPCI_WATMK_MNG_ALWD, 0, 0, 0, 0, "GLPCI_WATMK_MNG_ALWD"},
	{I40E_GLPCI_WATMK_TPDU_ALWD, 0, 0, 0, 0, "GLPCI_WATMK_TPDU_ALWD"},
	{I40E_PRTDCB_TCMSTC(0), 7, 32, 0, 0, "PRTDCB_TCMSTC"},
	{I40E_PRTDCB_TFMSTC(0), 7, 32, 0, 0, "PRTDCB_TFMSTC"},
	{I40E_PRTDCB_TDPMC, 0, 0, 0, 0, "PRTDCB_TDPMC"},
	{I40E_PRTDCB_TCWSTC(0), 7, 32, 0, 0, "PRTDCB_TCWSTC"},
	{I40E_PRTDCB_TCPMC, 0, 0, 0, 0, "PRTDCB_TCPMC"},
	{I40E_GL_TUPM_SPARE, 0, 0, 0, 0, "GL_TUPM_SPARE"},
	{I40E_GLPEOC_CACHESIZE, 0, 0, 0, 0, "GLPEOC_CACHESIZE"},
	{I40E_GLPBLOC_CACHESIZE, 0, 0, 0, 0, "GLPBLOC_CACHESIZE"},
	{I40E_GLFOC_CACHESIZE, 0, 0, 0, 0, "GLFOC_CACHESIZE"},
	{I40E_PRTRPB_DHW(0), 7, 32, 0, 0, "PRTRPB_DHW"},
	{I40E_PRTRPB_DLW(0), 7, 32, 0, 0, "PRTRPB_DLW"},
	{I40E_PRTRPB_DPS(0), 7, 32, 0, 0, "PRTRPB_DPS"},
	{I40E_PRTRPB_SHT(0), 7, 32, 0, 0, "PRTRPB_SHT"},
	{I40E_PRTRPB_SHW, 0, 0, 0, 0, "PRTRPB_SHW"},
	{I40E_PRTRPB_SLT(0), 7, 32, 0, 0, "PRTRPB_SLT"},
	{I40E_PRTRPB_SLW, 0, 0, 0, 0, "PRTRPB_SLW"},
	{I40E_PRTRPB_SPS, 0, 0, 0, 0, "PRTRPB_SPS"},
	{I40E_GLRPB_DPSS, 0, 0, 0, 0, "GLRPB_DPSS"},
	{I40E_GLRPB_GHW, 0, 0, 0, 0, "GLRPB_GHW"},
	{I40E_GLRPB_GLW, 0, 0, 0, 0, "GLRPB_GLW"},
	{I40E_GLRPB_PHW, 0, 0, 0, 0, "GLRPB_PHW"},
	{I40E_GLRPB_PLW, 0, 0, 0, 0, "GLRPB_PLW"},
	{I40E_PRTDCB_TETSC_TCB, 0, 0, 0, 0, "PRTDCB_TETSC_TCB"},
	{I40E_GLNVM_ULD, 0, 0, 0, 0, "GLNVM_ULD"},
	{I40E_GLNVM_ULD, 0, 0, 0, 0, "GLNVM_ULD"},
	{I40E_GLNVM_PROTCSR(0), 59, 4, 0, 0, "GLNVM_PROTCSR"},
	{I40E_GLNVM_GENS, 0, 0, 0, 0, "GLNVM_GENS"},
	{I40E_GLNVM_FLASHID, 0, 0, 0, 0, "GLNVM_FLASHID"},
	{I40E_GLNVM_FLA, 0, 0, 0, 0, "GLNVM_FLA"},
	{I40E_GLNVM_FLA, 0, 0, 0, 0, "GLNVM_FLA"},
	{I40E_GLNVM_SRCTL, 0, 0, 0, 0, "GLNVM_SRCTL"},
	{I40E_GLNVM_SRDATA, 0, 0, 0, 0, "GLNVM_SRDATA"},
	{I40E_GLGEN_STAT, 0, 0, 0, 0, "GLGEN_STAT"},
	{I40E_GL_MNG_HWARB_CTRL, 0, 0, 0, 0, "GL_MNG_HWARB_CTRL"},
	{I40E_GL_MNG_FWSM, 0, 0, 0, 0, "GL_MNG_FWSM"},
	{I40E_GLNVM_ALTIMERS, 0, 0, 0, 0, "GLNVM_ALTIMERS"},
	{I40E_GLNVM_ULT, 0, 0, 0, 0, "GLNVM_ULT"},
	{I40E_MEM_INIT_DONE_STAT, 0, 0, 0, 0, "MEM_INIT_DONE_STAT"},
	{I40E_GLNVM_AL_REQ, 0, 0, 0, 0, "GLNVM_AL_REQ"},
	{I40E_MNGSB_MSGCTL, 0, 0, 0, 0, "MNGSB_MSGCTL"},
	{I40E_MNGSB_RSPCTL, 0, 0, 0, 0, "MNGSB_RSPCTL"},
	{I40E_MNGSB_DADD, 0, 0, 0, 0, "MNGSB_DADD"},
	{I40E_MNGSB_DCNT, 0, 0, 0, 0, "MNGSB_DCNT"},
	{I40E_MNGSB_FDCS, 0, 0, 0, 0, "MNGSB_FDCS"},
	{I40E_MNGSB_FDS, 0, 0, 0, 0, "MNGSB_FDS"},
	{I40E_MNGSB_FDCRC, 0, 0, 0, 0, "MNGSB_FDCRC"},
	{I40E_MNGSB_WHDR0, 0, 0, 0, 0, "MNGSB_WHDR0"},
	{I40E_MNGSB_WHDR1, 0, 0, 0, 0, "MNGSB_WHDR1"},
	{I40E_MNGSB_WHDR2, 0, 0, 0, 0, "MNGSB_WHDR2"},
	{I40E_MNGSB_WDATA, 0, 0, 0, 0, "MNGSB_WDATA"},
	{I40E_MNGSB_RHDR0, 0, 0, 0, 0, "MNGSB_RHDR0"},
	{I40E_MNGSB_RDATA, 0, 0, 0, 0, "MNGSB_RDATA"},
	{I40E_PFPM_APM, 0, 0, 0, 0, "PFPM_APM"},
	{I40E_PRTGEN_STATUS, 0, 0, 0, 0, "PRTGEN_STATUS"},
	{I40E_PRTGEN_CNF, 0, 0, 0, 0, "PRTGEN_CNF"},
	{I40E_PRTPM_GC, 0, 0, 0, 0, "PRTPM_GC"},
	{I40E_PRTGEN_CNF2, 0, 0, 0, 0, "PRTGEN_CNF2"},
	{I40E_GLGEN_RSTCTL, 0, 0, 0, 0, "GLGEN_RSTCTL"},
	{I40E_GLGEN_CLKSTAT, 0, 0, 0, 0, "GLGEN_CLKSTAT"},
	{I40E_GLGEN_RSTAT, 0, 0, 0, 0, "GLGEN_RSTAT"},
	{I40E_GLGEN_RTRIG, 0, 0, 0, 0, "GLGEN_RTRIG"},
	{I40E_GLGEN_PME_TO, 0, 0, 0, 0, "GLGEN_PME_TO"},
	{I40E_GLGEN_CAR_DEBUG, 0, 0, 0, 0, "GLGEN_CAR_DEBUG"},
	{I40E_PFPCI_CNF, 0, 0, 0, 0, "PFPCI_CNF"},
	{I40E_PFPCI_DEVID, 0, 0, 0, 0, "PFPCI_DEVID"},
	{I40E_PFPCI_SUBSYSID, 0, 0, 0, 0, "PFPCI_SUBSYSID"},
	{I40E_PFPCI_FUNC2, 0, 0, 0, 0, "PFPCI_FUNC2"},
	{I40E_PFPCI_FUNC, 0, 0, 0, 0, "PFPCI_FUNC"},
	{I40E_PFPCI_STATUS1, 0, 0, 0, 0, "PFPCI_STATUS1"},
	{I40E_PFPCI_PM, 0, 0, 0, 0, "PFPCI_PM"},
	{I40E_PFPCI_CLASS, 0, 0, 0, 0, "PFPCI_CLASS"},
	{I40E_GLTPH_CTRL, 0, 0, 0, 0, "GLTPH_CTRL"},
	{I40E_GLPCI_LBARCTRL, 0, 0, 0, 0, "GLPCI_LBARCTRL"},
	{I40E_GLPCI_SUBVENID, 0, 0, 0, 0, "GLPCI_SUBVENID"},
	{I40E_GLPCI_PWRDATA, 0, 0, 0, 0, "GLPCI_PWRDATA"},
	{I40E_GLPCI_CNF2, 0, 0, 0, 0, "GLPCI_CNF2"},
	{I40E_GLPCI_SERL, 0, 0, 0, 0, "GLPCI_SERL"},
	{I40E_GLPCI_SERH, 0, 0, 0, 0, "GLPCI_SERH"},
	{I40E_GLPCI_CAPCTRL, 0, 0, 0, 0, "GLPCI_CAPCTRL"},
	{I40E_GLPCI_CAPSUP, 0, 0, 0, 0, "GLPCI_CAPSUP"},
	{I40E_GLPCI_LINKCAP, 0, 0, 0, 0, "GLPCI_LINKCAP"},
	{I40E_GLPCI_PMSUP, 0, 0, 0, 0, "GLPCI_PMSUP"},
	{I40E_GLPCI_REVID, 0, 0, 0, 0, "GLPCI_REVID"},
	{I40E_GLPCI_VFSUP, 0, 0, 0, 0, "GLPCI_VFSUP"},
	{I40E_GLPCI_CNF, 0, 0, 0, 0, "GLPCI_CNF"},
	{I40E_GLPCI_UPADD, 0, 0, 0, 0, "GLPCI_UPADD"},
	{I40E_GLPCI_PCIERR, 0, 0, 0, 0, "GLPCI_PCIERR"},
	{I40E_GLPCI_VENDORID, 0, 0, 0, 0, "GLPCI_VENDORID"},
	{I40E_GL_UFUSE_SOC, 0, 0, 0, 0, "GL_UFUSE_SOC"},
	{I40E_PFHMC_SDCMD, 0, 0, 0, 0, "PFHMC_SDCMD"},
	{I40E_PFHMC_SDDATALOW, 0, 0, 0, 0, "PFHMC_SDDATALOW"},
	{I40E_PFHMC_SDDATAHIGH, 0, 0, 0, 0, "PFHMC_SDDATAHIGH"},
	{I40E_PFHMC_PDINV, 0, 0, 0, 0, "PFHMC_PDINV"},
	{I40E_PFHMC_ERRORINFO, 0, 0, 0, 0, "PFHMC_ERRORINFO"},
	{I40E_PFHMC_ERRORDATA, 0, 0, 0, 0, "PFHMC_ERRORDATA"},
	{I40E_GLHMC_SDPART(0), 15, 4, 0, 0, "GLHMC_SDPART"},
	{I40E_GLHMC_PFPESDPART(0), 15, 4, 0, 0, "GLHMC_PFPESDPART"},
	{I40E_GLHMC_PFASSIGN(0), 15, 4, 0, 0, "GLHMC_PFASSIGN"},
	{I40E_GLHMC_LANTXOBJSZ, 0, 0, 0, 0, "GLHMC_LANTXOBJSZ"},
	{I40E_GLHMC_LANQMAX, 0, 0, 0, 0, "GLHMC_LANQMAX"},
	{I40E_GLHMC_LANRXOBJSZ, 0, 0, 0, 0, "GLHMC_LANRXOBJSZ"},
	{I40E_GLHMC_FCOEDDPOBJSZ, 0, 0, 0, 0, "GLHMC_FCOEDDPOBJSZ"},
	{I40E_GLHMC_FCOEMAX, 0, 0, 0, 0, "GLHMC_FCOEMAX"},
	{I40E_GLHMC_FCOEFOBJSZ, 0, 0, 0, 0, "GLHMC_FCOEFOBJSZ"},
	{I40E_GLHMC_PEQPOBJSZ, 0, 0, 0, 0, "GLHMC_PEQPOBJSZ"},
	{I40E_GLHMC_PECQOBJSZ, 0, 0, 0, 0, "GLHMC_PECQOBJSZ"},
	{I40E_GLHMC_PESRQOBJSZ, 0, 0, 0, 0, "GLHMC_PESRQOBJSZ"},
	{I40E_GLHMC_PESRQMAX, 0, 0, 0, 0, "GLHMC_PESRQMAX"},
	{I40E_GLHMC_PEHTEOBJSZ, 0, 0, 0, 0, "GLHMC_PEHTEOBJSZ"},
	{I40E_GLHMC_PEHTMAX, 0, 0, 0, 0, "GLHMC_PEHTMAX"},
	{I40E_GLHMC_PEARPOBJSZ, 0, 0, 0, 0, "GLHMC_PEARPOBJSZ"},
	{I40E_GLHMC_PEARPMAX, 0, 0, 0, 0, "GLHMC_PEARPMAX"},
	{I40E_GLHMC_PEMROBJSZ, 0, 0, 0, 0, "GLHMC_PEMROBJSZ"},
	{I40E_GLHMC_PEMRMAX, 0, 0, 0, 0, "GLHMC_PEMRMAX"},
	{I40E_GLHMC_PEQ1OBJSZ, 0, 0, 0, 0, "GLHMC_PEQ1OBJSZ"},
	{I40E_GLHMC_PEQ1MAX, 0, 0, 0, 0, "GLHMC_PEQ1MAX"},
	{I40E_GLHMC_PEQ1FLMAX, 0, 0, 0, 0, "GLHMC_PEQ1FLMAX"},
	{I40E_GLHMC_FSIMCOBJSZ, 0, 0, 0, 0, "GLHMC_FSIMCOBJSZ"},
	{I40E_GLHMC_FSIMCMAX, 0, 0, 0, 0, "GLHMC_FSIMCMAX"},
	{I40E_GLHMC_FSIAVOBJSZ, 0, 0, 0, 0, "GLHMC_FSIAVOBJSZ"},
	{I40E_GLHMC_FSIAVMAX, 0, 0, 0, 0, "GLHMC_FSIAVMAX"},
	{I40E_GLHMC_PEPBLMAX, 0, 0, 0, 0, "GLHMC_PEPBLMAX"},
	{I40E_GLHMC_PETIMEROBJSZ, 0, 0, 0, 0, "GLHMC_PETIMEROBJSZ"},
	{I40E_GLHMC_PETIMERMAX, 0, 0, 0, 0, "GLHMC_PETIMERMAX"},
	{I40E_GLHMC_FCOEFMAX, 0, 0, 0, 0, "GLHMC_FCOEFMAX"},
	{I40E_GLHMC_PEPFFIRSTSD, 0, 0, 0, 0, "GLHMC_PEPFFIRSTSD"},
	{I40E_GLHMC_DBQPMAX, 0, 0, 0, 0, "GLHMC_DBQPMAX"},
	{I40E_GLHMC_DBCQMAX, 0, 0, 0, 0, "GLHMC_DBCQMAX"},
	{I40E_GLHMC_PEQPBASE(0), 15, 4, 0, 0, "GLHMC_PEQPBASE"},
	{I40E_GLHMC_PEQPCNT(0), 15, 4, 0, 0, "GLHMC_PEQPCNT"},
	{I40E_GLHMC_PECQBASE(0), 15, 4, 0, 0, "GLHMC_PECQBASE"},
	{I40E_GLHMC_PECQCNT(0), 15, 4, 0, 0, "GLHMC_PECQCNT"},
	{I40E_GLHMC_PESRQBASE(0), 15, 4, 0, 0, "GLHMC_PESRQBASE"},
	{I40E_GLHMC_PESRQCNT(0), 15, 4, 0, 0, "GLHMC_PESRQCNT"},
	{I40E_GLHMC_PEHTEBASE(0), 15, 4, 0, 0, "GLHMC_PEHTEBASE"},
	{I40E_GLHMC_PEHTCNT(0), 15, 4, 0, 0, "GLHMC_PEHTCNT"},
	{I40E_GLHMC_PEARPBASE(0), 15, 4, 0, 0, "GLHMC_PEARPBASE"},
	{I40E_GLHMC_PEARPCNT(0), 15, 4, 0, 0, "GLHMC_PEARPCNT"},
	{I40E_GLHMC_APBVTINUSEBASE(0), 15, 4, 0, 0, "GLHMC_APBVTINUSEBASE"},
	{I40E_GLHMC_PEMRBASE(0), 15, 4, 0, 0, "GLHMC_PEMRBASE"},
	{I40E_GLHMC_PEMRCNT(0), 15, 4, 0, 0, "GLHMC_PEMRCNT"},
	{I40E_GLHMC_PEQ1BASE(0), 15, 4, 0, 0, "GLHMC_PEQ1BASE"},
	{I40E_GLHMC_PEQ1CNT(0), 15, 4, 0, 0, "GLHMC_PEQ1CNT"},
	{I40E_GLHMC_PEQ1FLBASE(0), 15, 4, 0, 0, "GLHMC_PEQ1FLBASE"},
	{I40E_GLHMC_FSIAVBASE(0), 15, 4, 0, 0, "GLHMC_FSIAVBASE"},
	{I40E_GLHMC_FSIAVCNT(0), 15, 4, 0, 0, "GLHMC_FSIAVCNT"},
	{I40E_GLHMC_PEPBLBASE(0), 15, 4, 0, 0, "GLHMC_PEPBLBASE"},
	{I40E_GLHMC_PEPBLCNT(0), 15, 4, 0, 0, "GLHMC_PEPBLCNT"},
	{I40E_GLHMC_PETIMERBASE(0), 15, 4, 0, 0, "GLHMC_PETIMERBASE"},
	{I40E_GLHMC_PETIMERCNT(0), 15, 4, 0, 0, "GLHMC_PETIMERCNT"},
	{I40E_GLHMC_FSIMCBASE(0), 15, 4, 0, 0, "GLHMC_FSIMCBASE"},
	{I40E_GLHMC_FSIMCCNT(0), 15, 4, 0, 0, "GLHMC_FSIMCCNT"},
	{I40E_GLHMC_LANTXBASE(0), 15, 4, 0, 0, "GLHMC_LANTXBASE"},
	{I40E_GLHMC_LANTXCNT(0), 15, 4, 0, 0, "GLHMC_LANTXCNT"},
	{I40E_GLHMC_LANRXBASE(0), 15, 4, 0, 0, "GLHMC_LANRXBASE"},
	{I40E_GLHMC_LANRXCNT(0), 15, 4, 0, 0, "GLHMC_LANRXCNT"},
	{I40E_GLHMC_FCOEDDPBASE(0), 15, 4, 0, 0, "GLHMC_FCOEDDPBASE"},
	{I40E_GLHMC_FCOEDDPCNT(0), 15, 4, 0, 0, "GLHMC_FCOEDDPCNT"},
	{I40E_GLHMC_FCOEFBASE(0), 15, 4, 0, 0, "GLHMC_FCOEFBASE"},
	{I40E_GLHMC_FCOEFCNT(0), 15, 4, 0, 0, "GLHMC_FCOEFCNT"},
	{I40E_GLHMC_VFPDINV(0), 31, 4, 0, 0, "GLHMC_VFPDINV"},
	{I40E_GLHMC_VFSDPART(0), 31, 4, 0, 0, "GLHMC_VFSDPART"},
	{I40E_GLHMC_VFPEQPBASE(0), 31, 4, 0, 0, "GLHMC_VFPEQPBASE"},
	{I40E_GLHMC_VFPEQPCNT(0), 31, 4, 0, 0, "GLHMC_VFPEQPCNT"},
	{I40E_GLHMC_VFPECQBASE(0), 31, 4, 0, 0, "GLHMC_VFPECQBASE"},
	{I40E_GLHMC_VFPECQCNT(0), 31, 4, 0, 0, "GLHMC_VFPECQCNT"},
	{I40E_GLHMC_VFPESRQBASE(0), 31, 4, 0, 0, "GLHMC_VFPESRQBASE"},
	{I40E_GLHMC_VFPESRQCNT(0), 31, 4, 0, 0, "GLHMC_VFPESRQCNT"},
	{I40E_GLHMC_VFPEHTEBASE(0), 31, 4, 0, 0, "GLHMC_VFPEHTEBASE"},
	{I40E_GLHMC_VFPEHTCNT(0), 31, 4, 0, 0, "GLHMC_VFPEHTCNT"},
	{I40E_GLHMC_VFPEARPBASE(0), 31, 4, 0, 0, "GLHMC_VFPEARPBASE"},
	{I40E_GLHMC_VFPEARPCNT(0), 31, 4, 0, 0, "GLHMC_VFPEARPCNT"},
	{I40E_GLHMC_VFAPBVTINUSEBASE(0), 31, 4, 0, 0, "GLHMC_VFAPBVTINUSEBASE"},
	{I40E_GLHMC_VFPEMRBASE(0), 31, 4, 0, 0, "GLHMC_VFPEMRBASE"},
	{I40E_GLHMC_VFPEMRCNT(0), 31, 4, 0, 0, "GLHMC_VFPEMRCNT"},
	{I40E_GLHMC_VFPEQ1BASE(0), 31, 4, 0, 0, "GLHMC_VFPEQ1BASE"},
	{I40E_GLHMC_VFPEQ1CNT(0), 31, 4, 0, 0, "GLHMC_VFPEQ1CNT"},
	{I40E_GLHMC_VFPEQ1FLBASE(0), 31, 4, 0, 0, "GLHMC_VFPEQ1FLBASE"},
	{I40E_GLHMC_VFFSIAVBASE(0), 31, 4, 0, 0, "GLHMC_VFFSIAVBASE"},
	{I40E_GLHMC_VFFSIAVCNT(0), 31, 4, 0, 0, "GLHMC_VFFSIAVCNT"},
	{I40E_GLHMC_VFPEPBLBASE(0), 31, 4, 0, 0, "GLHMC_VFPEPBLBASE"},
	{I40E_GLHMC_VFPEPBLCNT(0), 31, 4, 0, 0, "GLHMC_VFPEPBLCNT"},
	{I40E_GLHMC_VFPETIMERBASE(0), 31, 4, 0, 0, "GLHMC_VFPETIMERBASE"},
	{I40E_GLHMC_VFPETIMERCNT(0), 31, 4, 0, 0, "GLHMC_VFPETIMERCNT"},
	{I40E_GLPDOC_CACHESIZE, 0, 0, 0, 0, "GLPDOC_CACHESIZE"},
	{I40E_QTX_HEAD(0), 1535, 4, 0, 0, "QTX_HEAD"},
	{I40E_VP_MDET_TX(0), 127, 4, 0, 0, "VP_MDET_TX"},
	{I40E_PF_MDET_TX, 0, 0, 0, 0, "PF_MDET_TX"},
	{I40E_GL_MDET_TX, 0, 0, 0, 0, "GL_MDET_TX"},
	{I40E_GL_TLAN_SPARE, 0, 0, 0, 0, "GL_TLAN_SPARE"},
	{I40E_GLLAN_TXPRE_QDIS(0), 11, 4, 0, 0, "GLLAN_TXPRE_QDIS"},
	{I40E_QTX_ENA(0), 1535, 4, 0, 0, "QTX_ENA"},
	{I40E_QTX_CTL(0), 1535, 4, 0, 0, "QTX_CTL"},
	{I40E_QTX_TAIL(0), 1535, 4, 0, 0, "QTX_TAIL"},
	{I40E_PFCM_LAN_ERRINFO, 0, 0, 0, 0, "PFCM_LAN_ERRINFO"},
	{I40E_PFCM_LAN_ERRDATA, 0, 0, 0, 0, "PFCM_LAN_ERRDATA"},
	{I40E_PFCM_LANCTXDATA(0), 3, 128, 0, 0, "PFCM_LANCTXDATA"},
	{I40E_PFCM_LANCTXCTL, 0, 0, 0, 0, "PFCM_LANCTXCTL"},
	{I40E_PFCM_LANCTXSTAT, 0, 0, 0, 0, "PFCM_LANCTXSTAT"},
	{I40E_GLCM_LAN_CACHESIZE, 0, 0, 0, 0, "GLCM_LAN_CACHESIZE"},
	{I40E_QRX_ENA(0), 1535, 4, 0, 0, "QRX_ENA"},
	{I40E_PRTDCB_RETSTCC(0), 7, 32, 0, 0, "PRTDCB_RETSTCC"},
	{I40E_PRTDCB_RPPMC, 0, 0, 0, 0, "PRTDCB_RPPMC"},
	{I40E_PRTDCB_RETSC, 0, 0, 0, 0, "PRTDCB_RETSC"},
	{I40E_PRTDCB_RUPTQ(0), 7, 32, 0, 0, "PRTDCB_RUPTQ"},
	{I40E_GLDCB_RUPTI, 0, 0, 0, 0, "GLDCB_RUPTI"},
	{I40E_QRX_TAIL(0), 1535, 4, 0, 0, "QRX_TAIL"},
	{I40E_VP_MDET_RX(0), 127, 4, 0, 0, "VP_MDET_RX"},
	{I40E_PF_MDET_RX, 0, 0, 0, 0, "PF_MDET_RX"},
	{I40E_GLLAN_RCTL_0, 0, 0, 0, 0, "GLLAN_RCTL_0"},
	{I40E_GL_MDET_RX, 0, 0, 0, 0, "GL_MDET_RX"},
	{I40E_VFPE_CQARM(0), 127, 4, 0, 0, "VFPE_CQARM"},
	{I40E_VFPE_CQACK(0), 127, 4, 0, 0, "VFPE_CQACK"},
	{I40E_VFPE_AEQALLOC(0), 127, 4, 0, 0, "VFPE_AEQALLOC"},
	{I40E_PFPE_CQARM, 0, 0, 0, 0, "PFPE_CQARM"},
	{I40E_PFPE_CQACK, 0, 0, 0, 0, "PFPE_CQACK"},
	{I40E_PFPE_AEQALLOC, 0, 0, 0, 0, "PFPE_AEQALLOC"},
	{I40E_GLHMC_DBCQPART(0), 15, 4, 0, 0, "GLHMC_DBCQPART"},
	{I40E_GLHMC_CEQPART(0), 15, 4, 0, 0, "GLHMC_CEQPART"},
	{I40E_GLPE_PFCQEDROPCNT(0), 15, 4, 0, 0, "GLPE_PFCQEDROPCNT"},
	{I40E_GLPE_PFCEQEDROPCNT(0), 15, 4, 0, 0, "GLPE_PFCEQEDROPCNT"},
	{I40E_GLPE_PFAEQEDROPCNT(0), 15, 4, 0, 0, "GLPE_PFAEQEDROPCNT"},
	{I40E_GLHMC_VFDBCQPART(0), 31, 4, 0, 0, "GLHMC_VFDBCQPART"},
	{I40E_GLHMC_VFCEQPART(0), 31, 4, 0, 0, "GLHMC_VFCEQPART"},
	{I40E_GLPE_VFCQEDROPCNT(0), 31, 4, 0, 0, "GLPE_VFCQEDROPCNT"},
	{I40E_GLPE_VFCEQEDROPCNT(0), 31, 4, 0, 0, "GLPE_VFCEQEDROPCNT"},
	{I40E_GLPE_VFAEQEDROPCNT(0), 31, 4, 0, 0, "GLPE_VFAEQEDROPCNT"},
	{I40E_VFPE_WQEALLOC(0), 127, 4, 0, 0, "VFPE_WQEALLOC"},
	{I40E_VFCM_PE_ERRINFO1(0), 127, 4, 0, 0, "VFCM_PE_ERRINFO1"},
	{I40E_VFCM_PE_ERRDATA1(0), 127, 4, 0, 0, "VFCM_PE_ERRDATA1"},
	{I40E_PFPE_WQEALLOC, 0, 0, 0, 0, "PFPE_WQEALLOC"},
	{I40E_PFCM_PE_ERRINFO, 0, 0, 0, 0, "PFCM_PE_ERRINFO"},
	{I40E_PFCM_PE_ERRDATA, 0, 0, 0, 0, "PFCM_PE_ERRDATA"},
	{I40E_GLHMC_DBQPPART(0), 15, 4, 0, 0, "GLHMC_DBQPPART"},
	{I40E_GLHMC_VFDBQPPART(0), 31, 4, 0, 0, "GLHMC_VFDBQPPART"},
	{I40E_GLCM_PE_CACHESIZE, 0, 0, 0, 0, "GLCM_PE_CACHESIZE"},
	{I40E_PFGEN_PORTNUM, 0, 0, 0, 0, "PFGEN_PORTNUM"},
	{I40E_PF_VT_PFALLOC, 0, 0, 0, 0, "PF_VT_PFALLOC"},
	{I40E_PRTDCB_TC2PFC, 0, 0, 0, 0, "PRTDCB_TC2PFC"},
	{I40E_PRTDCB_RUP2TC, 0, 0, 0, 0, "PRTDCB_RUP2TC"},
	{I40E_GLGEN_PCIFCNCNT, 0, 0, 0, 0, "GLGEN_PCIFCNCNT"},
	{I40E_PRTDCB_RUP, 0, 0, 0, 0, "PRTDCB_RUP"},
	{I40E_PRT_L2TAGSEN, 0, 0, 0, 0, "PRT_L2TAGSEN"},
	{I40E_PRTGL_SAL, 0, 0, 0, 0, "PRTGL_SAL"},
	{I40E_PRTGL_SAH, 0, 0, 0, 0, "PRTGL_SAH"},
	{I40E_PRTDCB_MFLCN, 0, 0, 0, 0, "PRTDCB_MFLCN"},
	{I40E_PRTMAC_LINK_DOWN_COUNTER, 0, 0, 0, 0,
		"PRTMAC_LINK_DOWN_COUNTER"},
	{I40E_PRTMAC_HSEC_CTL_RX_PAUSE_ENABLE, 0, 0, 0, 0,
		"PRTMAC_HSEC_CTL_RX_PAUSE_ENABLE"},
	{I40E_PRTMAC_HSEC_CTL_TX_PAUSE_ENABLE, 0, 0, 0, 0,
		"PRTMAC_HSEC_CTL_TX_PAUSE_ENABLE"},
	{I40E_PRTMAC_HSEC_CTL_RX_ENABLE_GCP, 0, 0, 0, 0,
		"PRTMAC_HSEC_CTL_RX_ENABLE_GCP"},
	{I40E_PRTMAC_HSEC_CTL_RX_PAUSE_DA_UCAST_PART1, 0, 0, 0, 0,
		"PRTMAC_HSEC_CTL_RX_PAUSE_DA_UCAST_PART1"},
	{I40E_PRTMAC_HSEC_CTL_RX_PAUSE_DA_UCAST_PART2, 0, 0, 0, 0,
		"PRTMAC_HSEC_CTL_RX_PAUSE_DA_UCAST_PART2"},
	{I40E_PRTMAC_HSEC_CTL_RX_PAUSE_SA_PART1, 0, 0, 0, 0,
		"PRTMAC_HSEC_CTL_RX_PAUSE_SA_PART1"},
	{I40E_PRTMAC_HSEC_CTL_RX_PAUSE_SA_PART2, 0, 0, 0, 0,
		"PRTMAC_HSEC_CTL_RX_PAUSE_SA_PART2"},
	{I40E_PRTMAC_HSEC_CTL_RX_ENABLE_GPP, 0, 0, 0, 0,
		"PRTMAC_HSEC_CTL_RX_ENABLE_GPP"},
	{I40E_PRTMAC_HSEC_CTL_RX_ENABLE_PPP, 0, 0, 0, 0,
		"PRTMAC_HSEC_CTL_RX_ENABLE_PPP"},
	{I40E_PRTMAC_HSEC_CTL_RX_FORWARD_CONTROL, 0, 0, 0, 0,
		"PRTMAC_HSEC_CTL_RX_FORWARD_CONTROL"},
	{I40E_PRTMAC_HSEC_CTL_TX_PAUSE_QUANTA(0), 8, 16, 0, 0,
		"PRTMAC_HSEC_CTL_TX_PAUSE_QUANTA"},
	{I40E_PRTMAC_HSEC_CTL_TX_PAUSE_REFRESH_TIMER(0), 8, 16, 0, 0,
		"PRTMAC_HSEC_CTL_TX_PAUSE_REFRESH_TIMER"},
	{I40E_PRTMAC_HSEC_CTL_TX_SA_PART1, 0, 0, 0, 0,
		"PRTMAC_HSEC_CTL_TX_SA_PART1"},
	{I40E_PRTMAC_HSEC_CTL_TX_SA_PART2, 0, 0, 0, 0,
		"PRTMAC_HSEC_CTL_TX_SA_PART2"},
	{I40E_PRTTSYN_INC_L, 0, 0, 0, 0, "PRTTSYN_INC_L"},
	{I40E_PRTTSYN_INC_H, 0, 0, 0, 0, "PRTTSYN_INC_H"},
	{I40E_PRTTSYN_EVNT_L(0), 1, 32, 0, 0, "PRTTSYN_EVNT_L"},
	{I40E_PRTTSYN_EVNT_H(0), 1, 32, 0, 0, "PRTTSYN_EVNT_H"},
	{I40E_PRTTSYN_TIME_L, 0, 0, 0, 0, "PRTTSYN_TIME_L"},
	{I40E_PRTTSYN_TIME_H, 0, 0, 0, 0, "PRTTSYN_TIME_H"},
	{I40E_PRTTSYN_TGT_L(0), 1, 32, 0, 0, "PRTTSYN_TGT_L"},
	{I40E_PRTTSYN_TGT_H(0), 1, 32, 0, 0, "PRTTSYN_TGT_H"},
	{I40E_PRTTSYN_TXTIME_L, 0, 0, 0, 0, "PRTTSYN_TXTIME_L"},
	{I40E_PRTTSYN_TXTIME_H, 0, 0, 0, 0, "PRTTSYN_TXTIME_H"},
	{I40E_PRTTSYN_CTL0, 0, 0, 0, 0, "PRTTSYN_CTL0"},
	{I40E_PRTTSYN_STAT_0, 0, 0, 0, 0, "PRTTSYN_STAT_0"},
	{I40E_PRTTSYN_CLKO(0), 1, 32, 0, 0, "PRTTSYN_CLKO"},
	{I40E_PRTTSYN_ADJ, 0, 0, 0, 0, "PRTTSYN_ADJ"},
	{I40E_PRTTSYN_AUX_0(0), 1, 32, 0, 0, "PRTTSYN_AUX_0"},
	{I40E_PRTTSYN_AUX_1(0), 1, 32, 0, 0, "PRTTSYN_AUX_1"},
	{I40E_PRTPM_EEE_STAT, 0, 0, 0, 0, "PRTPM_EEE_STAT"},
	{I40E_PRTPM_EEER, 0, 0, 0, 0, "PRTPM_EEER"},
	{I40E_PRTPM_EEEC, 0, 0, 0, 0, "PRTPM_EEEC"},
	{I40E_PRTPM_RLPIC, 0, 0, 0, 0, "PRTPM_RLPIC"},
	{I40E_PRTPM_TLPIC, 0, 0, 0, 0, "PRTPM_TLPIC"},
	{I40E_PRTPM_EEETXC, 0, 0, 0, 0, "PRTPM_EEETXC"},
	{I40E_PRTPM_EEEFWD, 0, 0, 0, 0, "PRTPM_EEEFWD"},
	{I40E_PRTPM_SAL(0), 3, 32, 0, 0, "PRTPM_SAL"},
	{I40E_PRTPM_SAH(0), 3, 32, 0, 0, "PRTPM_SAH"},
	{I40E_PRTDCB_TFCS, 0, 0, 0, 0, "PRTDCB_TFCS"},
	{I40E_PRTDCB_FCTTVN(0), 3, 32, 0, 0, "PRTDCB_FCTTVN"},
	{I40E_PRTDCB_FCRTV, 0, 0, 0, 0, "PRTDCB_FCRTV"},
	{I40E_PRTDCB_FCCFG, 0, 0, 0, 0, "PRTDCB_FCCFG"},
	{I40E_PRTDCB_TPFCTS(0), 7, 32, 0, 0, "PRTDCB_TPFCTS"},
	{I40E_VFQF_HLUT1(0, 0), 15, 1024, 127, 4, "VFQF_HLUT1"},
	{I40E_VSIQF_HLUT(0, 0), 15, 2048, 383, 4, "VSIQF_HLUT"},
	{I40E_VFQF_HKEY1(0, 0), 12, 1024, 127, 4, "VFQF_HKEY1"},
	{I40E_VFQF_HREGION1(0, 0), 7, 1024, 127, 4, "VFQF_HREGION1"},
	{I40E_VFQF_HENA1(0, 0), 1, 1024, 127, 4, "VFQF_HENA1"},
	{I40E_PFQF_HLUT(0), 127, 128, 0, 0, "PFQF_HLUT"},
	{I40E_X722_PFQF_HLUT(0), 127, 128, 0, 0, "X722_PFQF_HLUT"},
	{I40E_PFQF_CTL_1, 0, 0, 0, 0, "PFQF_CTL_1"},
	{I40E_PFQF_FDSTAT, 0, 0, 0, 0, "PFQF_FDSTAT"},
	{I40E_PRT_MNG_MIPAF6(0), 15, 32, 0, 0, "PRT_MNG_MIPAF6"},
	{I40E_PRT_MNG_MFUTP(0), 15, 32, 0, 0, "PRT_MNG_MFUTP"},
	{I40E_PRTQF_FLX_PIT(0), 8, 32, 0, 0, "PRTQF_FLX_PIT"},
	{I40E_PRT_MNG_MAVTV(0), 7, 32, 0, 0, "PRT_MNG_MAVTV"},
	{I40E_PRT_MNG_MDEF(0), 7, 32, 0, 0, "PRT_MNG_MDEF"},
	{I40E_PRT_MNG_MDEF_EXT(0), 7, 32, 0, 0, "PRT_MNG_MDEF_EXT"},
	{I40E_PRT_MNG_MIPAF4(0), 3, 32, 0, 0, "PRT_MNG_MIPAF4"},
	{I40E_PRT_MNG_MMAH(0), 3, 32, 0, 0, "PRT_MNG_MMAH"},
	{I40E_PRT_MNG_MMAL(0), 3, 32, 0, 0, "PRT_MNG_MMAL"},
	{I40E_PRT_MNG_MDEFVSI(0), 3, 32, 0, 0, "PRT_MNG_MDEFVSI"},
	{I40E_PRT_MNG_METF(0), 3, 32, 0, 0, "PRT_MNG_METF"},
	{I40E_PRT_MNG_MANC, 0, 0, 0, 0, "PRT_MNG_MANC"},
	{I40E_PRT_MNG_MNGONLY, 0, 0, 0, 0, "PRT_MNG_MNGONLY"},
	{I40E_PRT_MNG_MSFM, 0, 0, 0, 0, "PRT_MNG_MSFM"},
	{I40E_GLQF_APBVT(0), 2047, 4, 0, 0, "GLQF_APBVT"},
	{I40E_GLQF_PCNT(0), 511, 4, 0, 0, "GLQF_PCNT"},
	{I40E_GLQF_FD_PCTYPES(0), 63, 4, 0, 0, "GLQF_FD_PCTYPES"},
	{I40E_GLQF_ORT(0), 63, 4, 0, 0, "GLQF_ORT"},
	{I40E_GLQF_PIT(0), 23, 4, 0, 0, "GLQF_PIT"},
	{I40E_GL_PRS_FVBM(0), 3, 4, 0, 0, "GL_PRS_FVBM"},
	{I40E_GLQF_FDCNT_0, 0, 0, 0, 0, "GLQF_FDCNT_0"},
	{I40E_GL_MTG_FLU_MSK_H, 0, 0, 0, 0, "GL_MTG_FLU_MSK_H"},
	{I40E_GL_SWR_DEF_ACT_EN(0), 1, 4, 0, 0, "GL_SWR_DEF_ACT_EN"},
	{I40E_GLQF_HKEY(0), 12, 4, 0, 0, "GLQF_HKEY"},
	{I40E_GL_SWR_DEF_ACT(0), 35, 4, 0, 0, "GL_SWR_DEF_ACT"},
	{I40E_GLQF_FDEVICTFLAG, 0, 0, 0, 0, "GLQF_FDEVICTFLAG"},
	{I40E_PFQF_CTL_2, 0, 0, 0, 0, "PFQF_CTL_2"},
	{I40E_GLQF_FDEVICTENA(0), 1, 4, 0, 0, "GLQF_FDEVICTENA"},
	{I40E_VSIQF_HKEY(0, 0), 12, 2048, 383, 4, "VSIQF_HKEY"},
	{I40E_GLPRT_GORCL(0), 3, 8, 0, 0, "GLPRT_GORCL"},
	{I40E_GLPRT_GORCH(0), 3, 8, 0, 0, "GLPRT_GORCH"},
	{I40E_GLPRT_MLFC(0), 3, 8, 0, 0, "GLPRT_MLFC"},
	{I40E_GLPRT_MRFC(0), 3, 8, 0, 0, "GLPRT_MRFC"},
	{I40E_GLPRT_CRCERRS(0), 3, 8, 0, 0, "GLPRT_CRCERRS"},
	{I40E_GLPRT_RLEC(0), 3, 8, 0, 0, "GLPRT_RLEC"},
	{I40E_GLPRT_ILLERRC(0), 3, 8, 0, 0, "GLPRT_ILLERRC"},
	{I40E_GLPRT_RUC(0), 3, 8, 0, 0, "GLPRT_RUC"},
	{I40E_GLPRT_ROC(0), 3, 8, 0, 0, "GLPRT_ROC"},
	{I40E_GLPRT_LXONRXC(0), 3, 8, 0, 0, "GLPRT_LXONRXC"},
	{I40E_GLPRT_LXOFFRXC(0), 3, 8, 0, 0, "GLPRT_LXOFFRXC"},
	{I40E_GLPRT_PXONRXC(0, 0), 3, 8, 7, 32, "GLPRT_PXONRXC"},
	{I40E_GLPRT_PXOFFRXC(0, 0), 3, 8, 7, 32, "GLPRT_PXOFFRXC"},
	{I40E_GLPRT_RXON2OFFCNT(0, 0), 3, 8, 7, 32, "GLPRT_RXON2OFFCNT"},
	{I40E_GLPRT_PRC64L(0), 3, 8, 0, 0, "GLPRT_PRC64L"},
	{I40E_GLPRT_PRC64H(0), 3, 8, 0, 0, "GLPRT_PRC64H"},
	{I40E_GLPRT_PRC127L(0), 3, 8, 0, 0, "GLPRT_PRC127L"},
	{I40E_GLPRT_PRC127H(0), 3, 8, 0, 0, "GLPRT_PRC127H"},
	{I40E_GLPRT_PRC255L(0), 3, 8, 0, 0, "GLPRT_PRC255L"},
	{I40E_GLPRT_PRC255H(0), 3, 8, 0, 0, "GLPRT_PRC255H"},
	{I40E_GLPRT_PRC511L(0), 3, 8, 0, 0, "GLPRT_PRC511L"},
	{I40E_GLPRT_PRC511H(0), 3, 8, 0, 0, "GLPRT_PRC511H"},
	{I40E_GLPRT_PRC1023L(0), 3, 8, 0, 0, "GLPRT_PRC1023L"},
	{I40E_GLPRT_PRC1023H(0), 3, 8, 0, 0, "GLPRT_PRC1023H"},
	{I40E_GLPRT_PRC1522L(0), 3, 8, 0, 0, "GLPRT_PRC1522L"},
	{I40E_GLPRT_PRC1522H(0), 3, 8, 0, 0, "GLPRT_PRC1522H"},
	{I40E_GLPRT_PRC9522L(0), 3, 8, 0, 0, "GLPRT_PRC9522L"},
	{I40E_GLPRT_PRC9522H(0), 3, 8, 0, 0, "GLPRT_PRC9522H"},
	{I40E_GLPRT_RFC(0), 3, 8, 0, 0, "GLPRT_RFC"},
	{I40E_GLPRT_RJC(0), 3, 8, 0, 0, "GLPRT_RJC"},
	{I40E_GLPRT_UPRCL(0), 3, 8, 0, 0, "GLPRT_UPRCL"},
	{I40E_GLPRT_UPRCH(0), 3, 8, 0, 0, "GLPRT_UPRCH"},
	{I40E_GLPRT_MPRCL(0), 3, 8, 0, 0, "GLPRT_MPRCL"},
	{I40E_GLPRT_MPRCH(0), 3, 8, 0, 0, "GLPRT_MPRCH"},
	{I40E_GLPRT_BPRCL(0), 3, 8, 0, 0, "GLPRT_BPRCL"},
	{I40E_GLPRT_BPRCH(0), 3, 8, 0, 0, "GLPRT_BPRCH"},
	{I40E_GLPRT_RDPC(0), 3, 8, 0, 0, "GLPRT_RDPC"},
	{I40E_GLPRT_LDPC(0), 3, 8, 0, 0, "GLPRT_LDPC"},
	{I40E_GLPRT_RUPP(0), 3, 8, 0, 0, "GLPRT_RUPP"},
	{I40E_GLPRT_GOTCL(0), 3, 8, 0, 0, "GLPRT_GOTCL"},
	{I40E_GLPRT_GOTCH(0), 3, 8, 0, 0, "GLPRT_GOTCH"},
	{I40E_GLPRT_PTC64L(0), 3, 8, 0, 0, "GLPRT_PTC64L"},
	{I40E_GLPRT_PTC64H(0), 3, 8, 0, 0, "GLPRT_PTC64H"},
	{I40E_GLPRT_PTC127L(0), 3, 8, 0, 0, "GLPRT_PTC127L"},
	{I40E_GLPRT_PTC127H(0), 3, 8, 0, 0, "GLPRT_PTC127H"},
	{I40E_GLPRT_PTC255L(0), 3, 8, 0, 0, "GLPRT_PTC255L"},
	{I40E_GLPRT_PTC255H(0), 3, 8, 0, 0, "GLPRT_PTC255H"},
	{I40E_GLPRT_PTC511L(0), 3, 8, 0, 0, "GLPRT_PTC511L"},
	{I40E_GLPRT_PTC511H(0), 3, 8, 0, 0, "GLPRT_PTC511H"},
	{I40E_GLPRT_PTC1023L(0), 3, 8, 0, 0, "GLPRT_PTC1023L"},
	{I40E_GLPRT_PTC1023H(0), 3, 8, 0, 0, "GLPRT_PTC1023H"},
	{I40E_GLPRT_PTC1522L(0), 3, 8, 0, 0, "GLPRT_PTC1522L"},
	{I40E_GLPRT_PTC1522H(0), 3, 8, 0, 0, "GLPRT_PTC1522H"},
	{I40E_GLPRT_PTC9522L(0), 3, 8, 0, 0, "GLPRT_PTC9522L"},
	{I40E_GLPRT_PTC9522H(0), 3, 8, 0, 0, "GLPRT_PTC9522H"},
	{I40E_GLPRT_PXONTXC(0, 0), 3, 8, 7, 32, "GLPRT_PXONTXC"},
	{I40E_GLPRT_PXOFFTXC(0, 0), 3, 8, 7, 32, "GLPRT_PXOFFTXC"},
	{I40E_GLPRT_LXONTXC(0), 3, 8, 0, 0, "GLPRT_LXONTXC"},
	{I40E_GLPRT_LXOFFTXC(0), 3, 8, 0, 0, "GLPRT_LXOFFTXC"},
	{I40E_GLPRT_UPTCL(0), 3, 8, 0, 0, "GLPRT_UPTCL"},
	{I40E_GLPRT_UPTCH(0), 3, 8, 0, 0, "GLPRT_UPTCH"},
	{I40E_GLPRT_MPTCL(0), 3, 8, 0, 0, "GLPRT_MPTCL"},
	{I40E_GLPRT_MPTCH(0), 3, 8, 0, 0, "GLPRT_MPTCH"},
	{I40E_GLPRT_BPTCL(0), 3, 8, 0, 0, "GLPRT_BPTCL"},
	{I40E_GLPRT_BPTCH(0), 3, 8, 0, 0, "GLPRT_BPTCH"},
	{I40E_GLPRT_TDOLD(0), 3, 8, 0, 0, "GLPRT_TDOLD"},
	{I40E_GLV_RDPC(0), 383, 8, 0, 0, "GLV_RDPC"},
	{I40E_GL_FCOELAST(0), 143, 8, 0, 0, "GL_FCOELAST"},
	{I40E_GL_FCOEDDPC(0), 143, 8, 0, 0, "GL_FCOEDDPC"},
	{I40E_GL_FCOECRC(0), 143, 8, 0, 0, "GL_FCOECRC"},
	{I40E_GL_FCOEPRC(0), 143, 8, 0, 0, "GL_FCOEPRC"},
	{I40E_GL_RXERR1_L(0), 143, 8, 0, 0, "GL_RXERR1_L"},
	{I40E_GL_FCOEDIFEC(0), 143, 8, 0, 0, "GL_FCOEDIFEC"},
	{I40E_GL_RXERR2_L(0), 143, 8, 0, 0, "GL_RXERR2_L"},
	{I40E_GL_FCOEDWRCL(0), 143, 8, 0, 0, "GL_FCOEDWRCL"},
	{I40E_GL_FCOEDWRCH(0), 143, 8, 0, 0, "GL_FCOEDWRCH"},
	{I40E_GL_FCOERPDC(0), 143, 8, 0, 0, "GL_FCOERPDC"},
	{I40E_GLV_GOTCL(0), 383, 8, 0, 0, "GLV_GOTCL"},
	{I40E_GLV_GOTCH(0), 383, 8, 0, 0, "GLV_GOTCH"},
	{I40E_GLSW_GOTCL(0), 15, 8, 0, 0, "GLSW_GOTCL"},
	{I40E_GLSW_GOTCH(0), 15, 8, 0, 0, "GLSW_GOTCH"},
	{I40E_GLVEBVL_GOTCL(0), 127, 8, 0, 0, "GLVEBVL_GOTCL"},
	{I40E_GLVEBVL_GOTCH(0), 127, 8, 0, 0, "GLVEBVL_GOTCH"},
	{I40E_GLVEBTC_TBCL(0, 0), 7, 8, 15, 64, "GLVEBTC_TBCL"},
	{I40E_GLVEBTC_TBCH(0, 0), 7, 8, 15, 64, "GLVEBTC_TBCH"},
	{I40E_GLVEBTC_TPCL(0, 0), 7, 8, 15, 64, "GLVEBTC_TPCL"},
	{I40E_GLVEBTC_TPCH(0, 0), 7, 8, 15, 64, "GLVEBTC_TPCH"},
	{I40E_GLV_UPTCL(0), 383, 8, 0, 0, "GLV_UPTCL"},
	{I40E_GLV_UPTCH(0), 383, 8, 0, 0, "GLV_UPTCH"},
	{I40E_GLV_MPTCL(0), 383, 8, 0, 0, "GLV_MPTCL"},
	{I40E_GLV_MPTCH(0), 383, 8, 0, 0, "GLV_MPTCH"},
	{I40E_GLV_BPTCL(0), 383, 8, 0, 0, "GLV_BPTCL"},
	{I40E_GLV_BPTCH(0), 383, 8, 0, 0, "GLV_BPTCH"},
	{I40E_GLSW_UPTCL(0), 15, 8, 0, 0, "GLSW_UPTCL"},
	{I40E_GLSW_UPTCH(0), 15, 8, 0, 0, "GLSW_UPTCH"},
	{I40E_GLSW_MPTCL(0), 15, 8, 0, 0, "GLSW_MPTCL"},
	{I40E_GLSW_MPTCH(0), 15, 8, 0, 0, "GLSW_MPTCH"},
	{I40E_GLSW_BPTCL(0), 15, 8, 0, 0, "GLSW_BPTCL"},
	{I40E_GLSW_BPTCH(0), 15, 8, 0, 0, "GLSW_BPTCH"},
	{I40E_GLV_TEPC(0), 383, 4, 0, 0, "GLV_TEPC"},
	{I40E_GL_FCOEPTC(0), 143, 8, 0, 0, "GL_FCOEPTC"},
	{I40E_GLSW_TDPC(0), 15, 8, 0, 0, "GLSW_TDPC"},
	{I40E_GL_FCOEDWTCL(0), 143, 8, 0, 0, "GL_FCOEDWTCL"},
	{I40E_GL_FCOEDWTCH(0), 143, 8, 0, 0, "GL_FCOEDWTCH"},
	{I40E_GL_FCOEDIXEC(0), 143, 8, 0, 0, "GL_FCOEDIXEC"},
	{I40E_GL_FCOEDIXVC(0), 143, 8, 0, 0, "GL_FCOEDIXVC"},
	{I40E_GL_FCOEDIFTCL(0), 143, 8, 0, 0, "GL_FCOEDIFTCL"},
	{I40E_GLV_GORCL(0), 383, 8, 0, 0, "GLV_GORCL"},
	{I40E_GLV_GORCH(0), 383, 8, 0, 0, "GLV_GORCH"},
	{I40E_GLSW_GORCL(0), 15, 8, 0, 0, "GLSW_GORCL"},
	{I40E_GLSW_GORCH(0), 15, 8, 0, 0, "GLSW_GORCH"},
	{I40E_GLVEBVL_GORCL(0), 127, 8, 0, 0, "GLVEBVL_GORCL"},
	{I40E_GLVEBVL_GORCH(0), 127, 8, 0, 0, "GLVEBVL_GORCH"},
	{I40E_GLVEBTC_RBCL(0, 0), 7, 8, 15, 64, "GLVEBTC_RBCL"},
	{I40E_GLVEBTC_RBCH(0, 0), 7, 8, 15, 64, "GLVEBTC_RBCH"},
	{I40E_GLVEBTC_RPCL(0, 0), 7, 8, 15, 64, "GLVEBTC_RPCL"},
	{I40E_GLVEBTC_RPCH(0, 0), 7, 8, 15, 64, "GLVEBTC_RPCH"},
	{I40E_GLV_UPRCL(0), 383, 8, 0, 0, "GLV_UPRCL"},
	{I40E_GLV_UPRCH(0), 383, 8, 0, 0, "GLV_UPRCH"},
	{I40E_GLV_MPRCL(0), 383, 8, 0, 0, "GLV_MPRCL"},
	{I40E_GLV_MPRCH(0), 383, 8, 0, 0, "GLV_MPRCH"},
	{I40E_GLV_BPRCL(0), 383, 8, 0, 0, "GLV_BPRCL"},
	{I40E_GLV_BPRCH(0), 383, 8, 0, 0, "GLV_BPRCH"},
	{I40E_GLV_RUPP(0), 383, 8, 0, 0, "GLV_RUPP"},
	{I40E_GLSW_UPRCL(0), 15, 8, 0, 0, "GLSW_UPRCL"},
	{I40E_GLSW_UPRCH(0), 15, 8, 0, 0, "GLSW_UPRCH"},
	{I40E_GLSW_MPRCL(0), 15, 8, 0, 0, "GLSW_MPRCL"},
	{I40E_GLSW_MPRCH(0), 15, 8, 0, 0, "GLSW_MPRCH"},
	{I40E_GLSW_BPRCL(0), 15, 8, 0, 0, "GLSW_BPRCL"},
	{I40E_GLSW_BPRCH(0), 15, 8, 0, 0, "GLSW_BPRCH"},
	{I40E_GLSW_RUPP(0), 15, 8, 0, 0, "GLSW_RUPP"},
	{I40E_GLVEBVL_UPCL(0), 127, 8, 0, 0, "GLVEBVL_UPCL"},
	{I40E_GLVEBVL_UPCH(0), 127, 8, 0, 0, "GLVEBVL_UPCH"},
	{I40E_GLVEBVL_MPCL(0), 127, 8, 0, 0, "GLVEBVL_MPCL"},
	{I40E_GLVEBVL_MPCH(0), 127, 8, 0, 0, "GLVEBVL_MPCH"},
	{I40E_GLVEBVL_BPCL(0), 127, 8, 0, 0, "GLVEBVL_BPCL"},
	{I40E_GLVEBVL_BPCH(0), 127, 8, 0, 0, "GLVEBVL_BPCH"},
	{I40E_GLGEN_STAT_HALT, 0, 0, 0, 0, "GLGEN_STAT_HALT"},
	{I40E_GLGEN_STAT_CLEAR, 0, 0, 0, 0, "GLGEN_STAT_CLEAR"},
	{0, 0, 0, 0, 0, NULL}
};
