//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcosmos

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewCassandraClustersClient creates a new instance of CassandraClustersClient.
func (c *ClientFactory) NewCassandraClustersClient() *CassandraClustersClient {
	subClient, _ := NewCassandraClustersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCassandraDataCentersClient creates a new instance of CassandraDataCentersClient.
func (c *ClientFactory) NewCassandraDataCentersClient() *CassandraDataCentersClient {
	subClient, _ := NewCassandraDataCentersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCassandraResourcesClient creates a new instance of CassandraResourcesClient.
func (c *ClientFactory) NewCassandraResourcesClient() *CassandraResourcesClient {
	subClient, _ := NewCassandraResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCollectionClient creates a new instance of CollectionClient.
func (c *ClientFactory) NewCollectionClient() *CollectionClient {
	subClient, _ := NewCollectionClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCollectionPartitionClient creates a new instance of CollectionPartitionClient.
func (c *ClientFactory) NewCollectionPartitionClient() *CollectionPartitionClient {
	subClient, _ := NewCollectionPartitionClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCollectionPartitionRegionClient creates a new instance of CollectionPartitionRegionClient.
func (c *ClientFactory) NewCollectionPartitionRegionClient() *CollectionPartitionRegionClient {
	subClient, _ := NewCollectionPartitionRegionClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCollectionRegionClient creates a new instance of CollectionRegionClient.
func (c *ClientFactory) NewCollectionRegionClient() *CollectionRegionClient {
	subClient, _ := NewCollectionRegionClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDataTransferJobsClient creates a new instance of DataTransferJobsClient.
func (c *ClientFactory) NewDataTransferJobsClient() *DataTransferJobsClient {
	subClient, _ := NewDataTransferJobsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseAccountRegionClient creates a new instance of DatabaseAccountRegionClient.
func (c *ClientFactory) NewDatabaseAccountRegionClient() *DatabaseAccountRegionClient {
	subClient, _ := NewDatabaseAccountRegionClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseAccountsClient creates a new instance of DatabaseAccountsClient.
func (c *ClientFactory) NewDatabaseAccountsClient() *DatabaseAccountsClient {
	subClient, _ := NewDatabaseAccountsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDatabaseClient creates a new instance of DatabaseClient.
func (c *ClientFactory) NewDatabaseClient() *DatabaseClient {
	subClient, _ := NewDatabaseClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGraphResourcesClient creates a new instance of GraphResourcesClient.
func (c *ClientFactory) NewGraphResourcesClient() *GraphResourcesClient {
	subClient, _ := NewGraphResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGremlinResourcesClient creates a new instance of GremlinResourcesClient.
func (c *ClientFactory) NewGremlinResourcesClient() *GremlinResourcesClient {
	subClient, _ := NewGremlinResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLocationsClient creates a new instance of LocationsClient.
func (c *ClientFactory) NewLocationsClient() *LocationsClient {
	subClient, _ := NewLocationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMongoClustersClient creates a new instance of MongoClustersClient.
func (c *ClientFactory) NewMongoClustersClient() *MongoClustersClient {
	subClient, _ := NewMongoClustersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMongoDBResourcesClient creates a new instance of MongoDBResourcesClient.
func (c *ClientFactory) NewMongoDBResourcesClient() *MongoDBResourcesClient {
	subClient, _ := NewMongoDBResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNotebookWorkspacesClient creates a new instance of NotebookWorkspacesClient.
func (c *ClientFactory) NewNotebookWorkspacesClient() *NotebookWorkspacesClient {
	subClient, _ := NewNotebookWorkspacesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPartitionKeyRangeIDClient creates a new instance of PartitionKeyRangeIDClient.
func (c *ClientFactory) NewPartitionKeyRangeIDClient() *PartitionKeyRangeIDClient {
	subClient, _ := NewPartitionKeyRangeIDClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPartitionKeyRangeIDRegionClient creates a new instance of PartitionKeyRangeIDRegionClient.
func (c *ClientFactory) NewPartitionKeyRangeIDRegionClient() *PartitionKeyRangeIDRegionClient {
	subClient, _ := NewPartitionKeyRangeIDRegionClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPercentileClient creates a new instance of PercentileClient.
func (c *ClientFactory) NewPercentileClient() *PercentileClient {
	subClient, _ := NewPercentileClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPercentileSourceTargetClient creates a new instance of PercentileSourceTargetClient.
func (c *ClientFactory) NewPercentileSourceTargetClient() *PercentileSourceTargetClient {
	subClient, _ := NewPercentileSourceTargetClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPercentileTargetClient creates a new instance of PercentileTargetClient.
func (c *ClientFactory) NewPercentileTargetClient() *PercentileTargetClient {
	subClient, _ := NewPercentileTargetClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	subClient, _ := NewPrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorableDatabaseAccountsClient creates a new instance of RestorableDatabaseAccountsClient.
func (c *ClientFactory) NewRestorableDatabaseAccountsClient() *RestorableDatabaseAccountsClient {
	subClient, _ := NewRestorableDatabaseAccountsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorableGremlinDatabasesClient creates a new instance of RestorableGremlinDatabasesClient.
func (c *ClientFactory) NewRestorableGremlinDatabasesClient() *RestorableGremlinDatabasesClient {
	subClient, _ := NewRestorableGremlinDatabasesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorableGremlinGraphsClient creates a new instance of RestorableGremlinGraphsClient.
func (c *ClientFactory) NewRestorableGremlinGraphsClient() *RestorableGremlinGraphsClient {
	subClient, _ := NewRestorableGremlinGraphsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorableGremlinResourcesClient creates a new instance of RestorableGremlinResourcesClient.
func (c *ClientFactory) NewRestorableGremlinResourcesClient() *RestorableGremlinResourcesClient {
	subClient, _ := NewRestorableGremlinResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorableMongodbCollectionsClient creates a new instance of RestorableMongodbCollectionsClient.
func (c *ClientFactory) NewRestorableMongodbCollectionsClient() *RestorableMongodbCollectionsClient {
	subClient, _ := NewRestorableMongodbCollectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorableMongodbDatabasesClient creates a new instance of RestorableMongodbDatabasesClient.
func (c *ClientFactory) NewRestorableMongodbDatabasesClient() *RestorableMongodbDatabasesClient {
	subClient, _ := NewRestorableMongodbDatabasesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorableMongodbResourcesClient creates a new instance of RestorableMongodbResourcesClient.
func (c *ClientFactory) NewRestorableMongodbResourcesClient() *RestorableMongodbResourcesClient {
	subClient, _ := NewRestorableMongodbResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorableSQLContainersClient creates a new instance of RestorableSQLContainersClient.
func (c *ClientFactory) NewRestorableSQLContainersClient() *RestorableSQLContainersClient {
	subClient, _ := NewRestorableSQLContainersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorableSQLDatabasesClient creates a new instance of RestorableSQLDatabasesClient.
func (c *ClientFactory) NewRestorableSQLDatabasesClient() *RestorableSQLDatabasesClient {
	subClient, _ := NewRestorableSQLDatabasesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorableSQLResourcesClient creates a new instance of RestorableSQLResourcesClient.
func (c *ClientFactory) NewRestorableSQLResourcesClient() *RestorableSQLResourcesClient {
	subClient, _ := NewRestorableSQLResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorableTableResourcesClient creates a new instance of RestorableTableResourcesClient.
func (c *ClientFactory) NewRestorableTableResourcesClient() *RestorableTableResourcesClient {
	subClient, _ := NewRestorableTableResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorableTablesClient creates a new instance of RestorableTablesClient.
func (c *ClientFactory) NewRestorableTablesClient() *RestorableTablesClient {
	subClient, _ := NewRestorableTablesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLResourcesClient creates a new instance of SQLResourcesClient.
func (c *ClientFactory) NewSQLResourcesClient() *SQLResourcesClient {
	subClient, _ := NewSQLResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServiceClient creates a new instance of ServiceClient.
func (c *ClientFactory) NewServiceClient() *ServiceClient {
	subClient, _ := NewServiceClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTableResourcesClient creates a new instance of TableResourcesClient.
func (c *ClientFactory) NewTableResourcesClient() *TableResourcesClient {
	subClient, _ := NewTableResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
