//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armredis_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/redis/armredis/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/20312e2b31df58f0ea7560e87062d62aa92f0a14/specification/redis/resource-manager/Microsoft.Cache/stable/2023-08-01/examples/RedisCacheCheckNameAvailability.json
func ExampleClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armredis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewClient().CheckNameAvailability(ctx, armredis.CheckNameAvailabilityParameters{
		Name: to.Ptr("cacheName"),
		Type: to.Ptr("Microsoft.Cache/Redis"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/20312e2b31df58f0ea7560e87062d62aa92f0a14/specification/redis/resource-manager/Microsoft.Cache/stable/2023-08-01/examples/RedisCacheListUpgradeNotifications.json
func ExampleClient_NewListUpgradeNotificationsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armredis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListUpgradeNotificationsPager("rg1", "cache1", 5000, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.NotificationListResponse = armredis.NotificationListResponse{
		// 	Value: []*armredis.UpgradeNotification{
		// 		{
		// 			Name: to.Ptr("notification1"),
		// 			Timestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-02-16T23:20:50.520Z"); return t}()),
		// 			UpsellNotification: map[string]*string{
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/20312e2b31df58f0ea7560e87062d62aa92f0a14/specification/redis/resource-manager/Microsoft.Cache/stable/2023-08-01/examples/RedisCacheCreate.json
func ExampleClient_BeginCreate_redisCacheCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armredis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreate(ctx, "rg1", "cache1", armredis.CreateParameters{
		Location: to.Ptr("West US"),
		Properties: &armredis.CreateProperties{
			EnableNonSSLPort:  to.Ptr(true),
			MinimumTLSVersion: to.Ptr(armredis.TLSVersionOne2),
			RedisConfiguration: &armredis.CommonPropertiesRedisConfiguration{
				MaxmemoryPolicy: to.Ptr("allkeys-lru"),
			},
			RedisVersion:       to.Ptr("4"),
			ReplicasPerPrimary: to.Ptr[int32](2),
			ShardCount:         to.Ptr[int32](2),
			SKU: &armredis.SKU{
				Name:     to.Ptr(armredis.SKUNamePremium),
				Capacity: to.Ptr[int32](1),
				Family:   to.Ptr(armredis.SKUFamilyP),
			},
			StaticIP: to.Ptr("192.168.0.5"),
			SubnetID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1"),
		},
		Zones: []*string{
			to.Ptr("1")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ResourceInfo = armredis.ResourceInfo{
	// 	Name: to.Ptr("cache1"),
	// 	Type: to.Ptr("Microsoft.Cache/Redis"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache1"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armredis.Properties{
	// 		EnableNonSSLPort: to.Ptr(false),
	// 		MinimumTLSVersion: to.Ptr(armredis.TLSVersionOne2),
	// 		RedisConfiguration: &armredis.CommonPropertiesRedisConfiguration{
	// 			Maxclients: to.Ptr("1000"),
	// 			MaxmemoryDelta: to.Ptr("50"),
	// 			MaxmemoryReserved: to.Ptr("50"),
	// 		},
	// 		RedisVersion: to.Ptr("4.0.14"),
	// 		ReplicasPerMaster: to.Ptr[int32](2),
	// 		ReplicasPerPrimary: to.Ptr[int32](2),
	// 		UpdateChannel: to.Ptr(armredis.UpdateChannelStable),
	// 		SKU: &armredis.SKU{
	// 			Name: to.Ptr(armredis.SKUNamePremium),
	// 			Capacity: to.Ptr[int32](1),
	// 			Family: to.Ptr(armredis.SKUFamilyP),
	// 		},
	// 		AccessKeys: &armredis.AccessKeys{
	// 			PrimaryKey: to.Ptr("<primaryKey>"),
	// 			SecondaryKey: to.Ptr("<secondaryKey>"),
	// 		},
	// 		HostName: to.Ptr("cache1.redis.cache.windows.net"),
	// 		Instances: []*armredis.InstanceDetails{
	// 			{
	// 				IsMaster: to.Ptr(true),
	// 				IsPrimary: to.Ptr(true),
	// 				NonSSLPort: to.Ptr[int32](13000),
	// 				ShardID: to.Ptr[int32](0),
	// 				SSLPort: to.Ptr[int32](15000),
	// 				Zone: to.Ptr("1"),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(false),
	// 				IsPrimary: to.Ptr(false),
	// 				NonSSLPort: to.Ptr[int32](13001),
	// 				ShardID: to.Ptr[int32](0),
	// 				SSLPort: to.Ptr[int32](15001),
	// 				Zone: to.Ptr("1"),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(false),
	// 				IsPrimary: to.Ptr(false),
	// 				NonSSLPort: to.Ptr[int32](13002),
	// 				ShardID: to.Ptr[int32](0),
	// 				SSLPort: to.Ptr[int32](15002),
	// 				Zone: to.Ptr("1"),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(true),
	// 				IsPrimary: to.Ptr(true),
	// 				NonSSLPort: to.Ptr[int32](13003),
	// 				ShardID: to.Ptr[int32](1),
	// 				SSLPort: to.Ptr[int32](15003),
	// 				Zone: to.Ptr("1"),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(false),
	// 				IsPrimary: to.Ptr(false),
	// 				NonSSLPort: to.Ptr[int32](13004),
	// 				ShardID: to.Ptr[int32](1),
	// 				SSLPort: to.Ptr[int32](15004),
	// 				Zone: to.Ptr("1"),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(false),
	// 				IsPrimary: to.Ptr(false),
	// 				NonSSLPort: to.Ptr[int32](13005),
	// 				ShardID: to.Ptr[int32](1),
	// 				SSLPort: to.Ptr[int32](15005),
	// 				Zone: to.Ptr("1"),
	// 		}},
	// 		Port: to.Ptr[int32](6379),
	// 		ProvisioningState: to.Ptr(armredis.ProvisioningStateSucceeded),
	// 		SSLPort: to.Ptr[int32](6380),
	// 	},
	// 	Zones: []*string{
	// 		to.Ptr("1")},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/20312e2b31df58f0ea7560e87062d62aa92f0a14/specification/redis/resource-manager/Microsoft.Cache/stable/2023-08-01/examples/RedisCacheCreateDefaultVersion.json
func ExampleClient_BeginCreate_redisCacheCreateDefaultVersion() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armredis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreate(ctx, "rg1", "cache1", armredis.CreateParameters{
		Location: to.Ptr("West US"),
		Properties: &armredis.CreateProperties{
			EnableNonSSLPort:  to.Ptr(true),
			MinimumTLSVersion: to.Ptr(armredis.TLSVersionOne2),
			RedisConfiguration: &armredis.CommonPropertiesRedisConfiguration{
				MaxmemoryPolicy: to.Ptr("allkeys-lru"),
			},
			ReplicasPerPrimary: to.Ptr[int32](2),
			ShardCount:         to.Ptr[int32](2),
			SKU: &armredis.SKU{
				Name:     to.Ptr(armredis.SKUNamePremium),
				Capacity: to.Ptr[int32](1),
				Family:   to.Ptr(armredis.SKUFamilyP),
			},
			StaticIP: to.Ptr("192.168.0.5"),
			SubnetID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1"),
		},
		Zones: []*string{
			to.Ptr("1")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ResourceInfo = armredis.ResourceInfo{
	// 	Name: to.Ptr("cache1"),
	// 	Type: to.Ptr("Microsoft.Cache/Redis"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache1"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armredis.Properties{
	// 		EnableNonSSLPort: to.Ptr(false),
	// 		MinimumTLSVersion: to.Ptr(armredis.TLSVersionOne2),
	// 		RedisConfiguration: &armredis.CommonPropertiesRedisConfiguration{
	// 			Maxclients: to.Ptr("1000"),
	// 			MaxmemoryDelta: to.Ptr("50"),
	// 			MaxmemoryReserved: to.Ptr("50"),
	// 		},
	// 		RedisVersion: to.Ptr("6.0.14"),
	// 		ReplicasPerMaster: to.Ptr[int32](2),
	// 		ReplicasPerPrimary: to.Ptr[int32](2),
	// 		UpdateChannel: to.Ptr(armredis.UpdateChannelStable),
	// 		SKU: &armredis.SKU{
	// 			Name: to.Ptr(armredis.SKUNamePremium),
	// 			Capacity: to.Ptr[int32](1),
	// 			Family: to.Ptr(armredis.SKUFamilyP),
	// 		},
	// 		AccessKeys: &armredis.AccessKeys{
	// 			PrimaryKey: to.Ptr("<primaryKey>"),
	// 			SecondaryKey: to.Ptr("<secondaryKey>"),
	// 		},
	// 		HostName: to.Ptr("cache1.redis.cache.windows.net"),
	// 		Instances: []*armredis.InstanceDetails{
	// 			{
	// 				IsMaster: to.Ptr(true),
	// 				IsPrimary: to.Ptr(true),
	// 				NonSSLPort: to.Ptr[int32](13000),
	// 				ShardID: to.Ptr[int32](0),
	// 				SSLPort: to.Ptr[int32](15000),
	// 				Zone: to.Ptr("1"),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(false),
	// 				IsPrimary: to.Ptr(false),
	// 				NonSSLPort: to.Ptr[int32](13001),
	// 				ShardID: to.Ptr[int32](0),
	// 				SSLPort: to.Ptr[int32](15001),
	// 				Zone: to.Ptr("1"),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(false),
	// 				IsPrimary: to.Ptr(false),
	// 				NonSSLPort: to.Ptr[int32](13002),
	// 				ShardID: to.Ptr[int32](0),
	// 				SSLPort: to.Ptr[int32](15002),
	// 				Zone: to.Ptr("1"),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(true),
	// 				IsPrimary: to.Ptr(true),
	// 				NonSSLPort: to.Ptr[int32](13003),
	// 				ShardID: to.Ptr[int32](1),
	// 				SSLPort: to.Ptr[int32](15003),
	// 				Zone: to.Ptr("1"),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(false),
	// 				IsPrimary: to.Ptr(false),
	// 				NonSSLPort: to.Ptr[int32](13004),
	// 				ShardID: to.Ptr[int32](1),
	// 				SSLPort: to.Ptr[int32](15004),
	// 				Zone: to.Ptr("1"),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(false),
	// 				IsPrimary: to.Ptr(false),
	// 				NonSSLPort: to.Ptr[int32](13005),
	// 				ShardID: to.Ptr[int32](1),
	// 				SSLPort: to.Ptr[int32](15005),
	// 				Zone: to.Ptr("1"),
	// 		}},
	// 		Port: to.Ptr[int32](6379),
	// 		ProvisioningState: to.Ptr(armredis.ProvisioningStateSucceeded),
	// 		SSLPort: to.Ptr[int32](6380),
	// 	},
	// 	Zones: []*string{
	// 		to.Ptr("1")},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/20312e2b31df58f0ea7560e87062d62aa92f0a14/specification/redis/resource-manager/Microsoft.Cache/stable/2023-08-01/examples/RedisCacheCreateLatestVersion.json
func ExampleClient_BeginCreate_redisCacheCreateLatestVersion() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armredis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreate(ctx, "rg1", "cache1", armredis.CreateParameters{
		Location: to.Ptr("West US"),
		Properties: &armredis.CreateProperties{
			EnableNonSSLPort:  to.Ptr(true),
			MinimumTLSVersion: to.Ptr(armredis.TLSVersionOne2),
			RedisConfiguration: &armredis.CommonPropertiesRedisConfiguration{
				MaxmemoryPolicy: to.Ptr("allkeys-lru"),
			},
			RedisVersion:       to.Ptr("Latest"),
			ReplicasPerPrimary: to.Ptr[int32](2),
			ShardCount:         to.Ptr[int32](2),
			SKU: &armredis.SKU{
				Name:     to.Ptr(armredis.SKUNamePremium),
				Capacity: to.Ptr[int32](1),
				Family:   to.Ptr(armredis.SKUFamilyP),
			},
			StaticIP: to.Ptr("192.168.0.5"),
			SubnetID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1"),
		},
		Zones: []*string{
			to.Ptr("1")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ResourceInfo = armredis.ResourceInfo{
	// 	Name: to.Ptr("cache1"),
	// 	Type: to.Ptr("Microsoft.Cache/Redis"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache1"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armredis.Properties{
	// 		EnableNonSSLPort: to.Ptr(false),
	// 		MinimumTLSVersion: to.Ptr(armredis.TLSVersionOne2),
	// 		RedisConfiguration: &armredis.CommonPropertiesRedisConfiguration{
	// 			Maxclients: to.Ptr("1000"),
	// 			MaxmemoryDelta: to.Ptr("50"),
	// 			MaxmemoryReserved: to.Ptr("50"),
	// 		},
	// 		RedisVersion: to.Ptr("6.0.14"),
	// 		ReplicasPerMaster: to.Ptr[int32](2),
	// 		ReplicasPerPrimary: to.Ptr[int32](2),
	// 		UpdateChannel: to.Ptr(armredis.UpdateChannelStable),
	// 		SKU: &armredis.SKU{
	// 			Name: to.Ptr(armredis.SKUNamePremium),
	// 			Capacity: to.Ptr[int32](1),
	// 			Family: to.Ptr(armredis.SKUFamilyP),
	// 		},
	// 		AccessKeys: &armredis.AccessKeys{
	// 			PrimaryKey: to.Ptr("<primaryKey>"),
	// 			SecondaryKey: to.Ptr("<secondaryKey>"),
	// 		},
	// 		HostName: to.Ptr("cache1.redis.cache.windows.net"),
	// 		Instances: []*armredis.InstanceDetails{
	// 			{
	// 				IsMaster: to.Ptr(true),
	// 				IsPrimary: to.Ptr(true),
	// 				NonSSLPort: to.Ptr[int32](13000),
	// 				ShardID: to.Ptr[int32](0),
	// 				SSLPort: to.Ptr[int32](15000),
	// 				Zone: to.Ptr("1"),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(false),
	// 				IsPrimary: to.Ptr(false),
	// 				NonSSLPort: to.Ptr[int32](13001),
	// 				ShardID: to.Ptr[int32](0),
	// 				SSLPort: to.Ptr[int32](15001),
	// 				Zone: to.Ptr("1"),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(false),
	// 				IsPrimary: to.Ptr(false),
	// 				NonSSLPort: to.Ptr[int32](13002),
	// 				ShardID: to.Ptr[int32](0),
	// 				SSLPort: to.Ptr[int32](15002),
	// 				Zone: to.Ptr("1"),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(true),
	// 				IsPrimary: to.Ptr(true),
	// 				NonSSLPort: to.Ptr[int32](13003),
	// 				ShardID: to.Ptr[int32](1),
	// 				SSLPort: to.Ptr[int32](15003),
	// 				Zone: to.Ptr("1"),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(false),
	// 				IsPrimary: to.Ptr(false),
	// 				NonSSLPort: to.Ptr[int32](13004),
	// 				ShardID: to.Ptr[int32](1),
	// 				SSLPort: to.Ptr[int32](15004),
	// 				Zone: to.Ptr("1"),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(false),
	// 				IsPrimary: to.Ptr(false),
	// 				NonSSLPort: to.Ptr[int32](13005),
	// 				ShardID: to.Ptr[int32](1),
	// 				SSLPort: to.Ptr[int32](15005),
	// 				Zone: to.Ptr("1"),
	// 		}},
	// 		Port: to.Ptr[int32](6379),
	// 		ProvisioningState: to.Ptr(armredis.ProvisioningStateSucceeded),
	// 		SSLPort: to.Ptr[int32](6380),
	// 	},
	// 	Zones: []*string{
	// 		to.Ptr("1")},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/20312e2b31df58f0ea7560e87062d62aa92f0a14/specification/redis/resource-manager/Microsoft.Cache/stable/2023-08-01/examples/RedisCacheUpdate.json
func ExampleClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armredis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginUpdate(ctx, "rg1", "cache1", armredis.UpdateParameters{
		Properties: &armredis.UpdateProperties{
			EnableNonSSLPort:   to.Ptr(true),
			ReplicasPerPrimary: to.Ptr[int32](2),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ResourceInfo = armredis.ResourceInfo{
	// 	Name: to.Ptr("cache1"),
	// 	Type: to.Ptr("Microsoft.Cache/Redis"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache1"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armredis.Properties{
	// 		EnableNonSSLPort: to.Ptr(true),
	// 		RedisConfiguration: &armredis.CommonPropertiesRedisConfiguration{
	// 			Maxclients: to.Ptr("1000"),
	// 			MaxmemoryDelta: to.Ptr("50"),
	// 			MaxmemoryReserved: to.Ptr("50"),
	// 		},
	// 		RedisVersion: to.Ptr("3.0"),
	// 		ReplicasPerMaster: to.Ptr[int32](2),
	// 		ReplicasPerPrimary: to.Ptr[int32](2),
	// 		UpdateChannel: to.Ptr(armredis.UpdateChannelStable),
	// 		SKU: &armredis.SKU{
	// 			Name: to.Ptr(armredis.SKUNamePremium),
	// 			Capacity: to.Ptr[int32](1),
	// 			Family: to.Ptr(armredis.SKUFamilyP),
	// 		},
	// 		AccessKeys: &armredis.AccessKeys{
	// 			PrimaryKey: to.Ptr("<primaryKey>"),
	// 			SecondaryKey: to.Ptr("<secondaryKey>"),
	// 		},
	// 		HostName: to.Ptr("cache1.redis.cache.windows.net"),
	// 		Instances: []*armredis.InstanceDetails{
	// 			{
	// 				IsMaster: to.Ptr(true),
	// 				IsPrimary: to.Ptr(true),
	// 				NonSSLPort: to.Ptr[int32](13000),
	// 				SSLPort: to.Ptr[int32](15000),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(false),
	// 				IsPrimary: to.Ptr(false),
	// 				NonSSLPort: to.Ptr[int32](13001),
	// 				SSLPort: to.Ptr[int32](15001),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(false),
	// 				IsPrimary: to.Ptr(false),
	// 				NonSSLPort: to.Ptr[int32](13002),
	// 				SSLPort: to.Ptr[int32](15002),
	// 		}},
	// 		Port: to.Ptr[int32](6379),
	// 		ProvisioningState: to.Ptr(armredis.ProvisioningStateSucceeded),
	// 		SSLPort: to.Ptr[int32](6380),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/20312e2b31df58f0ea7560e87062d62aa92f0a14/specification/redis/resource-manager/Microsoft.Cache/stable/2023-08-01/examples/RedisCacheDelete.json
func ExampleClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armredis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginDelete(ctx, "rg1", "cache1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/20312e2b31df58f0ea7560e87062d62aa92f0a14/specification/redis/resource-manager/Microsoft.Cache/stable/2023-08-01/examples/RedisCacheGet.json
func ExampleClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armredis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Get(ctx, "rg1", "cache1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ResourceInfo = armredis.ResourceInfo{
	// 	Name: to.Ptr("cache1"),
	// 	Type: to.Ptr("Microsoft.Cache/Redis"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache1"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armredis.Properties{
	// 		EnableNonSSLPort: to.Ptr(true),
	// 		PublicNetworkAccess: to.Ptr(armredis.PublicNetworkAccessEnabled),
	// 		RedisConfiguration: &armredis.CommonPropertiesRedisConfiguration{
	// 		},
	// 		RedisVersion: to.Ptr("3.2"),
	// 		ReplicasPerMaster: to.Ptr[int32](2),
	// 		ReplicasPerPrimary: to.Ptr[int32](2),
	// 		UpdateChannel: to.Ptr(armredis.UpdateChannelStable),
	// 		SKU: &armredis.SKU{
	// 			Name: to.Ptr(armredis.SKUNamePremium),
	// 			Capacity: to.Ptr[int32](3),
	// 			Family: to.Ptr(armredis.SKUFamilyP),
	// 		},
	// 		HostName: to.Ptr("cache1.redis.cache.windows.net"),
	// 		Instances: []*armredis.InstanceDetails{
	// 			{
	// 				IsMaster: to.Ptr(true),
	// 				IsPrimary: to.Ptr(true),
	// 				NonSSLPort: to.Ptr[int32](13000),
	// 				SSLPort: to.Ptr[int32](15000),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(false),
	// 				IsPrimary: to.Ptr(false),
	// 				NonSSLPort: to.Ptr[int32](13001),
	// 				SSLPort: to.Ptr[int32](15001),
	// 			},
	// 			{
	// 				IsMaster: to.Ptr(false),
	// 				IsPrimary: to.Ptr(false),
	// 				NonSSLPort: to.Ptr[int32](13002),
	// 				SSLPort: to.Ptr[int32](15002),
	// 		}},
	// 		LinkedServers: []*armredis.LinkedServer{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache1/linkedServers/cache2"),
	// 		}},
	// 		Port: to.Ptr[int32](6379),
	// 		PrivateEndpointConnections: []*armredis.PrivateEndpointConnection{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache1/privateEndpointConnections/cachePec"),
	// 				Properties: &armredis.PrivateEndpointConnectionProperties{
	// 					PrivateEndpoint: &armredis.PrivateEndpoint{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/privateEndpoints/cachePe"),
	// 					},
	// 					PrivateLinkServiceConnectionState: &armredis.PrivateLinkServiceConnectionState{
	// 						Description: to.Ptr("Please approve my connection"),
	// 						ActionsRequired: to.Ptr("None"),
	// 						Status: to.Ptr(armredis.PrivateEndpointServiceConnectionStatusApproved),
	// 					},
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr(armredis.ProvisioningStateSucceeded),
	// 		SSLPort: to.Ptr[int32](6380),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/20312e2b31df58f0ea7560e87062d62aa92f0a14/specification/redis/resource-manager/Microsoft.Cache/stable/2023-08-01/examples/RedisCacheListByResourceGroup.json
func ExampleClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armredis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListByResourceGroupPager("rg1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ListResult = armredis.ListResult{
		// 	Value: []*armredis.ResourceInfo{
		// 		{
		// 			Name: to.Ptr("cache1"),
		// 			Type: to.Ptr("Microsoft.Cache/Redis"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache1"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armredis.Properties{
		// 				EnableNonSSLPort: to.Ptr(true),
		// 				RedisConfiguration: &armredis.CommonPropertiesRedisConfiguration{
		// 				},
		// 				RedisVersion: to.Ptr("3.2"),
		// 				SKU: &armredis.SKU{
		// 					Name: to.Ptr(armredis.SKUNameStandard),
		// 					Capacity: to.Ptr[int32](6),
		// 					Family: to.Ptr(armredis.SKUFamilyC),
		// 				},
		// 				HostName: to.Ptr("cache1.redis.cache.windows.net"),
		// 				Port: to.Ptr[int32](6379),
		// 				ProvisioningState: to.Ptr(armredis.ProvisioningStateSucceeded),
		// 				SSLPort: to.Ptr[int32](6380),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/20312e2b31df58f0ea7560e87062d62aa92f0a14/specification/redis/resource-manager/Microsoft.Cache/stable/2023-08-01/examples/RedisCacheList.json
func ExampleClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armredis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ListResult = armredis.ListResult{
		// 	Value: []*armredis.ResourceInfo{
		// 		{
		// 			Name: to.Ptr("cache1"),
		// 			Type: to.Ptr("Microsoft.Cache/Redis"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache1"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armredis.Properties{
		// 				EnableNonSSLPort: to.Ptr(true),
		// 				RedisConfiguration: &armredis.CommonPropertiesRedisConfiguration{
		// 				},
		// 				RedisVersion: to.Ptr("3.2"),
		// 				ReplicasPerMaster: to.Ptr[int32](2),
		// 				ReplicasPerPrimary: to.Ptr[int32](2),
		// 				UpdateChannel: to.Ptr(armredis.UpdateChannelStable),
		// 				SKU: &armredis.SKU{
		// 					Name: to.Ptr(armredis.SKUNameStandard),
		// 					Capacity: to.Ptr[int32](6),
		// 					Family: to.Ptr(armredis.SKUFamilyC),
		// 				},
		// 				HostName: to.Ptr("cache1.redis.cache.windows.net"),
		// 				Instances: []*armredis.InstanceDetails{
		// 					{
		// 						IsMaster: to.Ptr(true),
		// 						IsPrimary: to.Ptr(true),
		// 						NonSSLPort: to.Ptr[int32](13000),
		// 						SSLPort: to.Ptr[int32](15000),
		// 					},
		// 					{
		// 						IsMaster: to.Ptr(false),
		// 						IsPrimary: to.Ptr(false),
		// 						NonSSLPort: to.Ptr[int32](13001),
		// 						SSLPort: to.Ptr[int32](15001),
		// 					},
		// 					{
		// 						IsMaster: to.Ptr(false),
		// 						IsPrimary: to.Ptr(false),
		// 						NonSSLPort: to.Ptr[int32](13002),
		// 						SSLPort: to.Ptr[int32](15002),
		// 				}},
		// 				Port: to.Ptr[int32](6379),
		// 				ProvisioningState: to.Ptr(armredis.ProvisioningStateSucceeded),
		// 				SSLPort: to.Ptr[int32](6380),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/20312e2b31df58f0ea7560e87062d62aa92f0a14/specification/redis/resource-manager/Microsoft.Cache/stable/2023-08-01/examples/RedisCacheListKeys.json
func ExampleClient_ListKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armredis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().ListKeys(ctx, "rg1", "cache1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccessKeys = armredis.AccessKeys{
	// 	PrimaryKey: to.Ptr("<primaryKey>"),
	// 	SecondaryKey: to.Ptr("<secondaryKey>"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/20312e2b31df58f0ea7560e87062d62aa92f0a14/specification/redis/resource-manager/Microsoft.Cache/stable/2023-08-01/examples/RedisCacheRegenerateKey.json
func ExampleClient_RegenerateKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armredis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().RegenerateKey(ctx, "rg1", "cache1", armredis.RegenerateKeyParameters{
		KeyType: to.Ptr(armredis.RedisKeyTypePrimary),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccessKeys = armredis.AccessKeys{
	// 	PrimaryKey: to.Ptr("<primaryKey>"),
	// 	SecondaryKey: to.Ptr("<secondaryKey>"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/20312e2b31df58f0ea7560e87062d62aa92f0a14/specification/redis/resource-manager/Microsoft.Cache/stable/2023-08-01/examples/RedisCacheForceReboot.json
func ExampleClient_ForceReboot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armredis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().ForceReboot(ctx, "rg1", "cache1", armredis.RebootParameters{
		Ports: []*int32{
			to.Ptr[int32](13000),
			to.Ptr[int32](15001)},
		RebootType: to.Ptr(armredis.RebootTypeAllNodes),
		ShardID:    to.Ptr[int32](0),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ForceRebootResponse = armredis.ForceRebootResponse{
	// 	Message: to.Ptr("reboot operation enqueued"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/20312e2b31df58f0ea7560e87062d62aa92f0a14/specification/redis/resource-manager/Microsoft.Cache/stable/2023-08-01/examples/RedisCacheImport.json
func ExampleClient_BeginImportData() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armredis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginImportData(ctx, "rg1", "cache1", armredis.ImportRDBParameters{
		Format: to.Ptr("RDB"),
		Files: []*string{
			to.Ptr("http://fileuris.contoso.com/pathtofile1")},
		StorageSubscriptionID: to.Ptr("storageSubId"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/20312e2b31df58f0ea7560e87062d62aa92f0a14/specification/redis/resource-manager/Microsoft.Cache/stable/2023-08-01/examples/RedisCacheExport.json
func ExampleClient_BeginExportData() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armredis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginExportData(ctx, "rg1", "cache1", armredis.ExportRDBParameters{
		Format:                to.Ptr("RDB"),
		Container:             to.Ptr("https://contosostorage.blob.core.window.net/urltoBlobContainer?sasKeyParameters"),
		Prefix:                to.Ptr("datadump1"),
		StorageSubscriptionID: to.Ptr("storageSubId"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/20312e2b31df58f0ea7560e87062d62aa92f0a14/specification/redis/resource-manager/Microsoft.Cache/stable/2023-08-01/examples/RedisCacheFlush.json
func ExampleClient_BeginFlushCache() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armredis.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginFlushCache(ctx, "resource-group-name", "cache-name", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationStatusResult = armredis.OperationStatusResult{
	// 	Status: to.Ptr("Succeeded"),
	// }
}
