//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstreamanalytics_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/streamanalytics/armstreamanalytics"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/stable/2020-03-01/examples/Input_Create_Reference_Blob_CSV.json
func ExampleInputsClient_CreateOrReplace_createAReferenceBlobInputWithCsvSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInputsClient().CreateOrReplace(ctx, "sjrg8440", "sj9597", "input7225", armstreamanalytics.Input{
		Properties: &armstreamanalytics.ReferenceInputProperties{
			Type: to.Ptr("Reference"),
			Serialization: &armstreamanalytics.CSVSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
				Properties: &armstreamanalytics.CSVSerializationProperties{
					Encoding:       to.Ptr(armstreamanalytics.EncodingUTF8),
					FieldDelimiter: to.Ptr(","),
				},
			},
			Datasource: &armstreamanalytics.BlobReferenceInputDataSource{
				Type: to.Ptr("Microsoft.Storage/Blob"),
				Properties: &armstreamanalytics.BlobReferenceInputDataSourceProperties{
					Container:   to.Ptr("state"),
					DateFormat:  to.Ptr("yyyy/MM/dd"),
					PathPattern: to.Ptr("{date}/{time}"),
					StorageAccounts: []*armstreamanalytics.StorageAccount{
						{
							AccountKey:  to.Ptr("someAccountKey=="),
							AccountName: to.Ptr("someAccountName"),
						}},
					TimeFormat: to.Ptr("HH"),
				},
			},
		},
	}, &armstreamanalytics.InputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Input = armstreamanalytics.Input{
	// 	Name: to.Ptr("input7225"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg8440/providers/Microsoft.StreamAnalytics/streamingjobs/sj9597/inputs/input7225"),
	// 	Properties: &armstreamanalytics.ReferenceInputProperties{
	// 		Type: to.Ptr("Reference"),
	// 		Serialization: &armstreamanalytics.CSVSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
	// 			Properties: &armstreamanalytics.CSVSerializationProperties{
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 				FieldDelimiter: to.Ptr(","),
	// 			},
	// 		},
	// 		Datasource: &armstreamanalytics.BlobReferenceInputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/Blob"),
	// 			Properties: &armstreamanalytics.BlobReferenceInputDataSourceProperties{
	// 				Container: to.Ptr("state"),
	// 				DateFormat: to.Ptr("yyyy/MM/dd"),
	// 				PathPattern: to.Ptr("{date}/{time}"),
	// 				StorageAccounts: []*armstreamanalytics.StorageAccount{
	// 					{
	// 						AccountName: to.Ptr("someAccountName"),
	// 				}},
	// 				TimeFormat: to.Ptr("HH"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/stable/2020-03-01/examples/Input_Create_Stream_EventHub_JSON.json
func ExampleInputsClient_CreateOrReplace_createAStreamEventHubInputWithJsonSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInputsClient().CreateOrReplace(ctx, "sjrg3139", "sj197", "input7425", armstreamanalytics.Input{
		Properties: &armstreamanalytics.StreamInputProperties{
			Type: to.Ptr("Stream"),
			Serialization: &armstreamanalytics.JSONSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
				Properties: &armstreamanalytics.JSONSerializationProperties{
					Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
				},
			},
			Datasource: &armstreamanalytics.EventHubStreamInputDataSource{
				Type: to.Ptr("Microsoft.ServiceBus/EventHub"),
				Properties: &armstreamanalytics.EventHubStreamInputDataSourceProperties{
					ServiceBusNamespace:    to.Ptr("sdktest"),
					SharedAccessPolicyKey:  to.Ptr("someSharedAccessPolicyKey=="),
					SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
					EventHubName:           to.Ptr("sdkeventhub"),
					ConsumerGroupName:      to.Ptr("sdkconsumergroup"),
				},
			},
		},
	}, &armstreamanalytics.InputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Input = armstreamanalytics.Input{
	// 	Name: to.Ptr("input7425"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3139/providers/Microsoft.StreamAnalytics/streamingjobs/sj197/inputs/input7425"),
	// 	Properties: &armstreamanalytics.StreamInputProperties{
	// 		Type: to.Ptr("Stream"),
	// 		Serialization: &armstreamanalytics.JSONSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
	// 			Properties: &armstreamanalytics.JSONSerializationProperties{
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 			},
	// 		},
	// 		Datasource: &armstreamanalytics.EventHubStreamInputDataSource{
	// 			Type: to.Ptr("Microsoft.ServiceBus/EventHub"),
	// 			Properties: &armstreamanalytics.EventHubStreamInputDataSourceProperties{
	// 				ServiceBusNamespace: to.Ptr("sdktest"),
	// 				SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
	// 				EventHubName: to.Ptr("sdkeventhub"),
	// 				ConsumerGroupName: to.Ptr("sdkconsumergroup"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/stable/2020-03-01/examples/Input_Create_Stream_IoTHub_Avro.json
func ExampleInputsClient_CreateOrReplace_createAStreamIoTHubInputWithAvroSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInputsClient().CreateOrReplace(ctx, "sjrg3467", "sj9742", "input7970", armstreamanalytics.Input{
		Properties: &armstreamanalytics.StreamInputProperties{
			Type: to.Ptr("Stream"),
			Serialization: &armstreamanalytics.AvroSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeAvro),
			},
			Datasource: &armstreamanalytics.IoTHubStreamInputDataSource{
				Type: to.Ptr("Microsoft.Devices/IotHubs"),
				Properties: &armstreamanalytics.IoTHubStreamInputDataSourceProperties{
					ConsumerGroupName:      to.Ptr("sdkconsumergroup"),
					Endpoint:               to.Ptr("messages/events"),
					IotHubNamespace:        to.Ptr("iothub"),
					SharedAccessPolicyKey:  to.Ptr("sharedAccessPolicyKey="),
					SharedAccessPolicyName: to.Ptr("owner"),
				},
			},
		},
	}, &armstreamanalytics.InputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Input = armstreamanalytics.Input{
	// 	Name: to.Ptr("input7970"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3467/providers/Microsoft.StreamAnalytics/streamingjobs/sj9742/inputs/input7970"),
	// 	Properties: &armstreamanalytics.StreamInputProperties{
	// 		Type: to.Ptr("Stream"),
	// 		Serialization: &armstreamanalytics.AvroSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeAvro),
	// 			Properties: map[string]any{
	// 			},
	// 		},
	// 		Datasource: &armstreamanalytics.IoTHubStreamInputDataSource{
	// 			Type: to.Ptr("Microsoft.Devices/IotHubs"),
	// 			Properties: &armstreamanalytics.IoTHubStreamInputDataSourceProperties{
	// 				ConsumerGroupName: to.Ptr("sdkconsumergroup"),
	// 				Endpoint: to.Ptr("messages/events"),
	// 				IotHubNamespace: to.Ptr("iothub"),
	// 				SharedAccessPolicyName: to.Ptr("owner"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/stable/2020-03-01/examples/Input_Create_Stream_Blob_CSV.json
func ExampleInputsClient_CreateOrReplace_createAStreamBlobInputWithCsvSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInputsClient().CreateOrReplace(ctx, "sjrg8161", "sj6695", "input8899", armstreamanalytics.Input{
		Properties: &armstreamanalytics.StreamInputProperties{
			Type: to.Ptr("Stream"),
			Serialization: &armstreamanalytics.CSVSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
				Properties: &armstreamanalytics.CSVSerializationProperties{
					Encoding:       to.Ptr(armstreamanalytics.EncodingUTF8),
					FieldDelimiter: to.Ptr(","),
				},
			},
			Datasource: &armstreamanalytics.BlobStreamInputDataSource{
				Type: to.Ptr("Microsoft.Storage/Blob"),
				Properties: &armstreamanalytics.BlobStreamInputDataSourceProperties{
					Container:   to.Ptr("state"),
					DateFormat:  to.Ptr("yyyy/MM/dd"),
					PathPattern: to.Ptr("{date}/{time}"),
					StorageAccounts: []*armstreamanalytics.StorageAccount{
						{
							AccountKey:  to.Ptr("someAccountKey=="),
							AccountName: to.Ptr("someAccountName"),
						}},
					TimeFormat:           to.Ptr("HH"),
					SourcePartitionCount: to.Ptr[int32](16),
				},
			},
		},
	}, &armstreamanalytics.InputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Input = armstreamanalytics.Input{
	// 	Name: to.Ptr("input8899"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg8161/providers/Microsoft.StreamAnalytics/streamingjobs/sj6695/inputs/input8899"),
	// 	Properties: &armstreamanalytics.StreamInputProperties{
	// 		Type: to.Ptr("Stream"),
	// 		Serialization: &armstreamanalytics.CSVSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
	// 			Properties: &armstreamanalytics.CSVSerializationProperties{
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 				FieldDelimiter: to.Ptr(","),
	// 			},
	// 		},
	// 		Datasource: &armstreamanalytics.BlobStreamInputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/Blob"),
	// 			Properties: &armstreamanalytics.BlobStreamInputDataSourceProperties{
	// 				Container: to.Ptr("state"),
	// 				DateFormat: to.Ptr("yyyy/MM/dd"),
	// 				PathPattern: to.Ptr("{date}/{time}"),
	// 				StorageAccounts: []*armstreamanalytics.StorageAccount{
	// 					{
	// 						AccountName: to.Ptr("someAccountName"),
	// 				}},
	// 				TimeFormat: to.Ptr("HH"),
	// 				SourcePartitionCount: to.Ptr[int32](16),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/stable/2020-03-01/examples/Input_Update_Reference_Blob.json
func ExampleInputsClient_Update_updateAReferenceBlobInput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInputsClient().Update(ctx, "sjrg8440", "sj9597", "input7225", armstreamanalytics.Input{
		Properties: &armstreamanalytics.ReferenceInputProperties{
			Type: to.Ptr("Reference"),
			Serialization: &armstreamanalytics.CSVSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
				Properties: &armstreamanalytics.CSVSerializationProperties{
					Encoding:       to.Ptr(armstreamanalytics.EncodingUTF8),
					FieldDelimiter: to.Ptr("|"),
				},
			},
			Datasource: &armstreamanalytics.BlobReferenceInputDataSource{
				Type: to.Ptr("Microsoft.Storage/Blob"),
				Properties: &armstreamanalytics.BlobReferenceInputDataSourceProperties{
					Container: to.Ptr("differentContainer"),
				},
			},
		},
	}, &armstreamanalytics.InputsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Input = armstreamanalytics.Input{
	// 	Name: to.Ptr("input7225"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg8440/providers/Microsoft.StreamAnalytics/streamingjobs/sj9597/inputs/input7225"),
	// 	Properties: &armstreamanalytics.ReferenceInputProperties{
	// 		Type: to.Ptr("Reference"),
	// 		Serialization: &armstreamanalytics.CSVSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
	// 			Properties: &armstreamanalytics.CSVSerializationProperties{
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 				FieldDelimiter: to.Ptr("|"),
	// 			},
	// 		},
	// 		Datasource: &armstreamanalytics.BlobReferenceInputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/Blob"),
	// 			Properties: &armstreamanalytics.BlobReferenceInputDataSourceProperties{
	// 				Container: to.Ptr("differentContainer"),
	// 				DateFormat: to.Ptr("yyyy/MM/dd"),
	// 				PathPattern: to.Ptr("{date}/{time}"),
	// 				StorageAccounts: []*armstreamanalytics.StorageAccount{
	// 					{
	// 						AccountName: to.Ptr("someAccountName"),
	// 				}},
	// 				TimeFormat: to.Ptr("HH"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/stable/2020-03-01/examples/Input_Update_Stream_EventHub.json
func ExampleInputsClient_Update_updateAStreamEventHubInput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInputsClient().Update(ctx, "sjrg3139", "sj197", "input7425", armstreamanalytics.Input{
		Properties: &armstreamanalytics.StreamInputProperties{
			Type: to.Ptr("Stream"),
			Serialization: &armstreamanalytics.AvroSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeAvro),
			},
			Datasource: &armstreamanalytics.EventHubStreamInputDataSource{
				Type: to.Ptr("Microsoft.ServiceBus/EventHub"),
				Properties: &armstreamanalytics.EventHubStreamInputDataSourceProperties{
					ConsumerGroupName: to.Ptr("differentConsumerGroupName"),
				},
			},
		},
	}, &armstreamanalytics.InputsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Input = armstreamanalytics.Input{
	// 	Name: to.Ptr("input7425"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3139/providers/Microsoft.StreamAnalytics/streamingjobs/sj197/inputs/input7425"),
	// 	Properties: &armstreamanalytics.StreamInputProperties{
	// 		Type: to.Ptr("Stream"),
	// 		Serialization: &armstreamanalytics.AvroSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeAvro),
	// 			Properties: map[string]any{
	// 			},
	// 		},
	// 		Datasource: &armstreamanalytics.EventHubStreamInputDataSource{
	// 			Type: to.Ptr("Microsoft.ServiceBus/EventHub"),
	// 			Properties: &armstreamanalytics.EventHubStreamInputDataSourceProperties{
	// 				ServiceBusNamespace: to.Ptr("sdktest"),
	// 				SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
	// 				EventHubName: to.Ptr("sdkeventhub"),
	// 				ConsumerGroupName: to.Ptr("differentConsumerGroupName"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/stable/2020-03-01/examples/Input_Update_Stream_IoTHub.json
func ExampleInputsClient_Update_updateAStreamIoTHubInput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInputsClient().Update(ctx, "sjrg3467", "sj9742", "input7970", armstreamanalytics.Input{
		Properties: &armstreamanalytics.StreamInputProperties{
			Type: to.Ptr("Stream"),
			Serialization: &armstreamanalytics.CSVSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
				Properties: &armstreamanalytics.CSVSerializationProperties{
					Encoding:       to.Ptr(armstreamanalytics.EncodingUTF8),
					FieldDelimiter: to.Ptr("|"),
				},
			},
			Datasource: &armstreamanalytics.IoTHubStreamInputDataSource{
				Type: to.Ptr("Microsoft.Devices/IotHubs"),
				Properties: &armstreamanalytics.IoTHubStreamInputDataSourceProperties{
					Endpoint: to.Ptr("messages/operationsMonitoringEvents"),
				},
			},
		},
	}, &armstreamanalytics.InputsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Input = armstreamanalytics.Input{
	// 	Name: to.Ptr("input7970"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3467/providers/Microsoft.StreamAnalytics/streamingjobs/sj9742/inputs/input7970"),
	// 	Properties: &armstreamanalytics.StreamInputProperties{
	// 		Type: to.Ptr("Stream"),
	// 		Serialization: &armstreamanalytics.CSVSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
	// 			Properties: &armstreamanalytics.CSVSerializationProperties{
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 				FieldDelimiter: to.Ptr("|"),
	// 			},
	// 		},
	// 		Datasource: &armstreamanalytics.IoTHubStreamInputDataSource{
	// 			Type: to.Ptr("Microsoft.Devices/IotHubs"),
	// 			Properties: &armstreamanalytics.IoTHubStreamInputDataSourceProperties{
	// 				ConsumerGroupName: to.Ptr("sdkconsumergroup"),
	// 				Endpoint: to.Ptr("messages/operationsMonitoringEvents"),
	// 				IotHubNamespace: to.Ptr("iothub"),
	// 				SharedAccessPolicyName: to.Ptr("owner"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/stable/2020-03-01/examples/Input_Update_Stream_Blob.json
func ExampleInputsClient_Update_updateAStreamBlobInput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInputsClient().Update(ctx, "sjrg8161", "sj6695", "input8899", armstreamanalytics.Input{
		Properties: &armstreamanalytics.StreamInputProperties{
			Type: to.Ptr("Stream"),
			Serialization: &armstreamanalytics.CSVSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
				Properties: &armstreamanalytics.CSVSerializationProperties{
					Encoding:       to.Ptr(armstreamanalytics.EncodingUTF8),
					FieldDelimiter: to.Ptr("|"),
				},
			},
			Datasource: &armstreamanalytics.BlobStreamInputDataSource{
				Type: to.Ptr("Microsoft.Storage/Blob"),
				Properties: &armstreamanalytics.BlobStreamInputDataSourceProperties{
					SourcePartitionCount: to.Ptr[int32](32),
				},
			},
		},
	}, &armstreamanalytics.InputsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Input = armstreamanalytics.Input{
	// 	Name: to.Ptr("input8899"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg8161/providers/Microsoft.StreamAnalytics/streamingjobs/sj6695/inputs/input8899"),
	// 	Properties: &armstreamanalytics.StreamInputProperties{
	// 		Type: to.Ptr("Stream"),
	// 		Serialization: &armstreamanalytics.CSVSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
	// 			Properties: &armstreamanalytics.CSVSerializationProperties{
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 				FieldDelimiter: to.Ptr("|"),
	// 			},
	// 		},
	// 		Datasource: &armstreamanalytics.BlobStreamInputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/Blob"),
	// 			Properties: &armstreamanalytics.BlobStreamInputDataSourceProperties{
	// 				Container: to.Ptr("state"),
	// 				DateFormat: to.Ptr("yyyy/MM/dd"),
	// 				PathPattern: to.Ptr("{date}/{time}"),
	// 				StorageAccounts: []*armstreamanalytics.StorageAccount{
	// 					{
	// 						AccountName: to.Ptr("someAccountName"),
	// 				}},
	// 				TimeFormat: to.Ptr("HH"),
	// 				SourcePartitionCount: to.Ptr[int32](32),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/stable/2020-03-01/examples/Input_Delete.json
func ExampleInputsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewInputsClient().Delete(ctx, "sjrg8440", "sj9597", "input7225", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/stable/2020-03-01/examples/Input_Get_Reference_Blob_CSV.json
func ExampleInputsClient_Get_getAReferenceBlobInputWithCsvSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInputsClient().Get(ctx, "sjrg8440", "sj9597", "input7225", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Input = armstreamanalytics.Input{
	// 	Name: to.Ptr("input7225"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg8440/providers/Microsoft.StreamAnalytics/streamingjobs/sj9597/inputs/input7225"),
	// 	Properties: &armstreamanalytics.ReferenceInputProperties{
	// 		Type: to.Ptr("Reference"),
	// 		Serialization: &armstreamanalytics.CSVSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
	// 			Properties: &armstreamanalytics.CSVSerializationProperties{
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 				FieldDelimiter: to.Ptr(","),
	// 			},
	// 		},
	// 		Datasource: &armstreamanalytics.BlobReferenceInputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/Blob"),
	// 			Properties: &armstreamanalytics.BlobReferenceInputDataSourceProperties{
	// 				Container: to.Ptr("state"),
	// 				DateFormat: to.Ptr("yyyy/MM/dd"),
	// 				PathPattern: to.Ptr("{date}/{time}"),
	// 				StorageAccounts: []*armstreamanalytics.StorageAccount{
	// 					{
	// 						AccountName: to.Ptr("someAccountName"),
	// 				}},
	// 				TimeFormat: to.Ptr("HH"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/stable/2020-03-01/examples/Input_Get_Stream_EventHub_JSON.json
func ExampleInputsClient_Get_getAStreamEventHubInputWithJsonSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInputsClient().Get(ctx, "sjrg3139", "sj197", "input7425", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Input = armstreamanalytics.Input{
	// 	Name: to.Ptr("input7425"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3139/providers/Microsoft.StreamAnalytics/streamingjobs/sj197/inputs/input7425"),
	// 	Properties: &armstreamanalytics.StreamInputProperties{
	// 		Type: to.Ptr("Stream"),
	// 		Serialization: &armstreamanalytics.JSONSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
	// 			Properties: &armstreamanalytics.JSONSerializationProperties{
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 			},
	// 		},
	// 		Datasource: &armstreamanalytics.EventHubStreamInputDataSource{
	// 			Type: to.Ptr("Microsoft.ServiceBus/EventHub"),
	// 			Properties: &armstreamanalytics.EventHubStreamInputDataSourceProperties{
	// 				ServiceBusNamespace: to.Ptr("sdktest"),
	// 				SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
	// 				EventHubName: to.Ptr("sdkeventhub"),
	// 				ConsumerGroupName: to.Ptr("sdkconsumergroup"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/stable/2020-03-01/examples/Input_Get_Stream_IoTHub_Avro.json
func ExampleInputsClient_Get_getAStreamIoTHubInputWithAvroSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInputsClient().Get(ctx, "sjrg3467", "sj9742", "input7970", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Input = armstreamanalytics.Input{
	// 	Name: to.Ptr("input7970"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3467/providers/Microsoft.StreamAnalytics/streamingjobs/sj9742/inputs/input7970"),
	// 	Properties: &armstreamanalytics.StreamInputProperties{
	// 		Type: to.Ptr("Stream"),
	// 		Serialization: &armstreamanalytics.AvroSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeAvro),
	// 			Properties: map[string]any{
	// 			},
	// 		},
	// 		Datasource: &armstreamanalytics.IoTHubStreamInputDataSource{
	// 			Type: to.Ptr("Microsoft.Devices/IotHubs"),
	// 			Properties: &armstreamanalytics.IoTHubStreamInputDataSourceProperties{
	// 				ConsumerGroupName: to.Ptr("sdkconsumergroup"),
	// 				Endpoint: to.Ptr("messages/events"),
	// 				IotHubNamespace: to.Ptr("iothub"),
	// 				SharedAccessPolicyName: to.Ptr("owner"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/stable/2020-03-01/examples/Input_Get_Stream_Blob_CSV.json
func ExampleInputsClient_Get_getAStreamBlobInputWithCsvSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewInputsClient().Get(ctx, "sjrg8161", "sj6695", "input8899", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Input = armstreamanalytics.Input{
	// 	Name: to.Ptr("input8899"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg8161/providers/Microsoft.StreamAnalytics/streamingjobs/sj6695/inputs/input8899"),
	// 	Properties: &armstreamanalytics.StreamInputProperties{
	// 		Type: to.Ptr("Stream"),
	// 		Serialization: &armstreamanalytics.CSVSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
	// 			Properties: &armstreamanalytics.CSVSerializationProperties{
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 				FieldDelimiter: to.Ptr(","),
	// 			},
	// 		},
	// 		Datasource: &armstreamanalytics.BlobStreamInputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/Blob"),
	// 			Properties: &armstreamanalytics.BlobStreamInputDataSourceProperties{
	// 				Container: to.Ptr("state"),
	// 				DateFormat: to.Ptr("yyyy/MM/dd"),
	// 				PathPattern: to.Ptr("{date}/{time}"),
	// 				StorageAccounts: []*armstreamanalytics.StorageAccount{
	// 					{
	// 						AccountName: to.Ptr("someAccountName"),
	// 				}},
	// 				TimeFormat: to.Ptr("HH"),
	// 				SourcePartitionCount: to.Ptr[int32](16),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/stable/2020-03-01/examples/Input_ListByStreamingJob.json
func ExampleInputsClient_NewListByStreamingJobPager_listAllInputsInAStreamingJob() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewInputsClient().NewListByStreamingJobPager("sjrg8440", "sj9597", &armstreamanalytics.InputsClientListByStreamingJobOptions{Select: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.InputListResult = armstreamanalytics.InputListResult{
		// 	Value: []*armstreamanalytics.Input{
		// 		{
		// 			Name: to.Ptr("input7225"),
		// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
		// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg8440/providers/Microsoft.StreamAnalytics/streamingjobs/sj9597/inputs/input7225"),
		// 			Properties: &armstreamanalytics.ReferenceInputProperties{
		// 				Type: to.Ptr("Reference"),
		// 				Etag: to.Ptr("a4ceb697-1c8f-40c8-b951-fb5ee4757437"),
		// 				Serialization: &armstreamanalytics.CSVSerialization{
		// 					Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
		// 					Properties: &armstreamanalytics.CSVSerializationProperties{
		// 						Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
		// 						FieldDelimiter: to.Ptr("|"),
		// 					},
		// 				},
		// 				Datasource: &armstreamanalytics.BlobReferenceInputDataSource{
		// 					Type: to.Ptr("Microsoft.Storage/Blob"),
		// 					Properties: &armstreamanalytics.BlobReferenceInputDataSourceProperties{
		// 						Container: to.Ptr("differentContainer"),
		// 						DateFormat: to.Ptr("yyyy/MM/dd"),
		// 						PathPattern: to.Ptr("{date}/{time}"),
		// 						StorageAccounts: []*armstreamanalytics.StorageAccount{
		// 							{
		// 								AccountName: to.Ptr("someAccountName"),
		// 						}},
		// 						TimeFormat: to.Ptr("HH"),
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("input8899"),
		// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
		// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg8440/providers/Microsoft.StreamAnalytics/streamingjobs/sj9597/inputs/input8899"),
		// 			Properties: &armstreamanalytics.StreamInputProperties{
		// 				Type: to.Ptr("Stream"),
		// 				Etag: to.Ptr("3b35d57c-02f4-4b41-8e1d-af02a86c2fa1"),
		// 				Serialization: &armstreamanalytics.CSVSerialization{
		// 					Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
		// 					Properties: &armstreamanalytics.CSVSerializationProperties{
		// 						Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
		// 						FieldDelimiter: to.Ptr("|"),
		// 					},
		// 				},
		// 				Datasource: &armstreamanalytics.BlobStreamInputDataSource{
		// 					Type: to.Ptr("Microsoft.Storage/Blob"),
		// 					Properties: &armstreamanalytics.BlobStreamInputDataSourceProperties{
		// 						Container: to.Ptr("state"),
		// 						DateFormat: to.Ptr("yyyy/MM/dd"),
		// 						PathPattern: to.Ptr("{date}/{time}"),
		// 						StorageAccounts: []*armstreamanalytics.StorageAccount{
		// 							{
		// 								AccountName: to.Ptr("someAccountName"),
		// 						}},
		// 						TimeFormat: to.Ptr("HH"),
		// 						SourcePartitionCount: to.Ptr[int32](32),
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("input7425"),
		// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
		// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg8440/providers/Microsoft.StreamAnalytics/streamingjobs/sj9597/inputs/input7425"),
		// 			Properties: &armstreamanalytics.StreamInputProperties{
		// 				Type: to.Ptr("Stream"),
		// 				Etag: to.Ptr("7548f259-81b5-4ea7-b896-25c6717d98ba"),
		// 				Serialization: &armstreamanalytics.AvroSerialization{
		// 					Type: to.Ptr(armstreamanalytics.EventSerializationTypeAvro),
		// 					Properties: map[string]any{
		// 					},
		// 				},
		// 				Datasource: &armstreamanalytics.EventHubStreamInputDataSource{
		// 					Type: to.Ptr("Microsoft.ServiceBus/EventHub"),
		// 					Properties: &armstreamanalytics.EventHubStreamInputDataSourceProperties{
		// 						ServiceBusNamespace: to.Ptr("sdktest"),
		// 						SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
		// 						EventHubName: to.Ptr("sdkeventhub"),
		// 						ConsumerGroupName: to.Ptr("differentConsumerGroupName"),
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("input7970"),
		// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
		// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg8440/providers/Microsoft.StreamAnalytics/streamingjobs/sj9597/inputs/input7970"),
		// 			Properties: &armstreamanalytics.StreamInputProperties{
		// 				Type: to.Ptr("Stream"),
		// 				Etag: to.Ptr("e2d847e0-c95b-48ef-9e14-1afc1f2270cb"),
		// 				Serialization: &armstreamanalytics.CSVSerialization{
		// 					Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
		// 					Properties: &armstreamanalytics.CSVSerializationProperties{
		// 						Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
		// 						FieldDelimiter: to.Ptr("|"),
		// 					},
		// 				},
		// 				Datasource: &armstreamanalytics.IoTHubStreamInputDataSource{
		// 					Type: to.Ptr("Microsoft.Devices/IotHubs"),
		// 					Properties: &armstreamanalytics.IoTHubStreamInputDataSourceProperties{
		// 						ConsumerGroupName: to.Ptr("sdkconsumergroup"),
		// 						Endpoint: to.Ptr("messages/operationsMonitoringEvents"),
		// 						IotHubNamespace: to.Ptr("iothub"),
		// 						SharedAccessPolicyName: to.Ptr("owner"),
		// 					},
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/stable/2020-03-01/examples/Input_ListByStreamingJob_Diagnostics.json
func ExampleInputsClient_NewListByStreamingJobPager_listAllInputsInAStreamingJobAndIncludeDiagnosticInformationUsingTheSelectODataQueryParameter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewInputsClient().NewListByStreamingJobPager("sjrg3276", "sj7804", &armstreamanalytics.InputsClientListByStreamingJobOptions{Select: to.Ptr("*")})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.InputListResult = armstreamanalytics.InputListResult{
		// 	Value: []*armstreamanalytics.Input{
		// 		{
		// 			Name: to.Ptr("inputtest"),
		// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/inputs"),
		// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3276/providers/Microsoft.StreamAnalytics/streamingjobs/sj7804/inputs/inputtest"),
		// 			Properties: &armstreamanalytics.StreamInputProperties{
		// 				Type: to.Ptr("Stream"),
		// 				Diagnostics: &armstreamanalytics.Diagnostics{
		// 					Conditions: []*armstreamanalytics.DiagnosticCondition{
		// 						{
		// 							Code: to.Ptr("INP-3"),
		// 							Message: to.Ptr("Could not deserialize the input event as Json. Some possible reasons: 1) Malformed events 2) Input source configured with incorrect serialization format"),
		// 							Since: to.Ptr("2017-05-11T04:38:42.4938687Z"),
		// 					}},
		// 				},
		// 				Etag: to.Ptr("ca88f8fa-605b-4c7f-8695-46f5faa60cd0"),
		// 				Serialization: &armstreamanalytics.JSONSerialization{
		// 					Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
		// 					Properties: &armstreamanalytics.JSONSerializationProperties{
		// 						Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
		// 					},
		// 				},
		// 				Datasource: &armstreamanalytics.BlobStreamInputDataSource{
		// 					Type: to.Ptr("Microsoft.Storage/Blob"),
		// 					Properties: &armstreamanalytics.BlobStreamInputDataSourceProperties{
		// 						Container: to.Ptr("state"),
		// 						PathPattern: to.Ptr(""),
		// 						StorageAccounts: []*armstreamanalytics.StorageAccount{
		// 							{
		// 								AccountName: to.Ptr("someAccountName"),
		// 						}},
		// 					},
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/stable/2020-03-01/examples/Input_Test.json
func ExampleInputsClient_BeginTest() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewInputsClient().BeginTest(ctx, "sjrg8440", "sj9597", "input7225", &armstreamanalytics.InputsClientBeginTestOptions{Input: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ResourceTestStatus = armstreamanalytics.ResourceTestStatus{
	// 	Status: to.Ptr("TestSucceeded"),
	// }
}
