/*
 * (C) Copyright 2013 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation
 * nor does it submit to any jurisdiction.
 */

// TL7999

#include "atlas/grid/detail/spacing/gaussian/N.h"

namespace atlas {
namespace grid {
namespace spacing {
namespace gaussian {

DEFINE_GAUSSIAN_LATITUDES(
    4000,
    LIST(89.982777782041, 89.960467823498, 89.938026112601, 89.915554633223, 89.893071861958, 89.870583626524,
         89.848092337395, 89.825599170237, 89.803104766281, 89.780609504838, 89.758113624578, 89.735617283150,
         89.713120588868, 89.690623618599, 89.668126428400, 89.645629060112, 89.623131545602, 89.600633909559,
         89.578136171413, 89.555638346662, 89.533140447819, 89.510642485097, 89.488144466917, 89.465646400278,
         89.443148291053, 89.420650144201, 89.398151963940, 89.375653753880, 89.353155517131, 89.330657256382,
         89.308158973974, 89.285660671954, 89.263162352116, 89.240664016047, 89.218165665144, 89.195667300653,
         89.173168923684, 89.150670535227, 89.128172136173, 89.105673727319, 89.083175309389, 89.060676883034,
         89.038178448845, 89.015680007358, 88.993181559065, 88.970683104410, 88.948184643801, 88.925686177614,
         88.903187706190, 88.880689229847, 88.858190748874, 88.835692263540, 88.813193774093, 88.790695280762,
         88.768196783761, 88.745698283287, 88.723199779523, 88.700701272640, 88.678202762798, 88.655704250144,
         88.633205734819, 88.610707216951, 88.588208696663, 88.565710174068, 88.543211649272, 88.520713122378,
         88.498214593477, 88.475716062661, 88.453217530011, 88.430718995608, 88.408220459525, 88.385721921832,
         88.363223382596, 88.340724841881, 88.318226299744, 88.295727756243, 88.273229211430, 88.250730665357,
         88.228232118071, 88.205733569618, 88.183235020041, 88.160736469382, 88.138237917679, 88.115739364971,
         88.093240811293, 88.070742256678, 88.048243701159, 88.025745144768, 88.003246587532, 87.980748029482,
         87.958249470643, 87.935750911042, 87.913252350702, 87.890753789648, 87.868255227903, 87.845756665488,
         87.823258102423, 87.800759538729, 87.778260974425, 87.755762409529, 87.733263844059, 87.710765278031,
         87.688266711463, 87.665768144369, 87.643269576765, 87.620771008664, 87.598272440082, 87.575773871032,
         87.553275301526, 87.530776731576, 87.508278161196, 87.485779590396, 87.463281019188, 87.440782447582,
         87.418283875589, 87.395785303218, 87.373286730480, 87.350788157385, 87.328289583939, 87.305791010154,
         87.283292436037, 87.260793861596, 87.238295286839, 87.215796711774, 87.193298136408, 87.170799560749,
         87.148300984803, 87.125802408577, 87.103303832079, 87.080805255312, 87.058306678285, 87.035808101003,
         87.013309523472, 86.990810945697, 86.968312367684, 86.945813789438, 86.923315210965, 86.900816632268,
         86.878318053353, 86.855819474226, 86.833320894889, 86.810822315347, 86.788323735606, 86.765825155669,
         86.743326575540, 86.720827995223, 86.698329414722, 86.675830834040, 86.653332253182, 86.630833672151,
         86.608335090950, 86.585836509583, 86.563337928052, 86.540839346362, 86.518340764515, 86.495842182514,
         86.473343600362, 86.450845018063, 86.428346435618, 86.405847853031, 86.383349270303, 86.360850687439,
         86.338352104440, 86.315853521309, 86.293354938048, 86.270856354659, 86.248357771146, 86.225859187509,
         86.203360603752, 86.180862019876, 86.158363435884, 86.135864851777, 86.113366267558, 86.090867683228,
         86.068369098789, 86.045870514244, 86.023371929594, 86.000873344840, 85.978374759985, 85.955876175031,
         85.933377589978, 85.910879004828, 85.888380419584, 85.865881834246, 85.843383248817, 85.820884663297,
         85.798386077688, 85.775887491991, 85.753388906209, 85.730890320342, 85.708391734391, 85.685893148358,
         85.663394562245, 85.640895976052, 85.618397389780, 85.595898803431, 85.573400217007, 85.550901630507,
         85.528403043934, 85.505904457288, 85.483405870571, 85.460907283783, 85.438408696926, 85.415910110001,
         85.393411523008, 85.370912935948, 85.348414348824, 85.325915761635, 85.303417174382, 85.280918587066,
         85.258419999689, 85.235921412251, 85.213422824753, 85.190924237196, 85.168425649580, 85.145927061907,
         85.123428474177, 85.100929886391, 85.078431298550, 85.055932710655, 85.033434122705, 85.010935534703,
         84.988436946649, 84.965938358543, 84.943439770386, 84.920941182179, 84.898442593922, 84.875944005617,
         84.853445417263, 84.830946828862, 84.808448240413, 84.785949651918, 84.763451063378, 84.740952474792,
         84.718453886162, 84.695955297487, 84.673456708770, 84.650958120009, 84.628459531205, 84.605960942360,
         84.583462353474, 84.560963764546, 84.538465175579, 84.515966586571, 84.493467997524, 84.470969408439,
         84.448470819315, 84.425972230153, 84.403473640953, 84.380975051717, 84.358476462443, 84.335977873134,
         84.313479283789, 84.290980694409, 84.268482104994, 84.245983515544, 84.223484926060, 84.200986336543,
         84.178487746992, 84.155989157409, 84.133490567792, 84.110991978144, 84.088493388464, 84.065994798753,
         84.043496209010, 84.020997619237, 83.998499029433, 83.976000439600, 83.953501849737, 83.931003259844,
         83.908504669922, 83.886006079972, 83.863507489993, 83.841008899986, 83.818510309952, 83.796011719889,
         83.773513129800, 83.751014539684, 83.728515949541, 83.706017359372, 83.683518769177, 83.661020178956,
         83.638521588710, 83.616022998438, 83.593524408141, 83.571025817820, 83.548527227475, 83.526028637105,
         83.503530046711, 83.481031456294, 83.458532865853, 83.436034275389, 83.413535684902, 83.391037094392,
         83.368538503860, 83.346039913306, 83.323541322729, 83.301042732131, 83.278544141511, 83.256045550870,
         83.233546960207, 83.211048369524, 83.188549778820, 83.166051188095, 83.143552597351, 83.121054006585,
         83.098555415800, 83.076056824996, 83.053558234171, 83.031059643328, 83.008561052465, 82.986062461583,
         82.963563870682, 82.941065279763, 82.918566688825, 82.896068097869, 82.873569506895, 82.851070915903,
         82.828572324893, 82.806073733866, 82.783575142821, 82.761076551759, 82.738577960680, 82.716079369584,
         82.693580778471, 82.671082187341, 82.648583596195, 82.626085005032, 82.603586413854, 82.581087822659,
         82.558589231449, 82.536090640222, 82.513592048980, 82.491093457723, 82.468594866450, 82.446096275163,
         82.423597683860, 82.401099092542, 82.378600501209, 82.356101909862, 82.333603318500, 82.311104727124,
         82.288606135733, 82.266107544328, 82.243608952910, 82.221110361477, 82.198611770031, 82.176113178570,
         82.153614587097, 82.131115995610, 82.108617404109, 82.086118812596, 82.063620221069, 82.041121629529,
         82.018623037977, 81.996124446412, 81.973625854834, 81.951127263243, 81.928628671640, 81.906130080025,
         81.883631488397, 81.861132896757, 81.838634305106, 81.816135713442, 81.793637121767, 81.771138530079,
         81.748639938380, 81.726141346670, 81.703642754948, 81.681144163215, 81.658645571470, 81.636146979714,
         81.613648387948, 81.591149796170, 81.568651204381, 81.546152612581, 81.523654020771, 81.501155428950,
         81.478656837119, 81.456158245277, 81.433659653424, 81.411161061561, 81.388662469688, 81.366163877805,
         81.343665285912, 81.321166694009, 81.298668102095, 81.276169510172, 81.253670918240, 81.231172326297,
         81.208673734345, 81.186175142383, 81.163676550412, 81.141177958431, 81.118679366442, 81.096180774442,
         81.073682182434, 81.051183590416, 81.028684998390, 81.006186406354, 80.983687814310, 80.961189222257,
         80.938690630195, 80.916192038124, 80.893693446044, 80.871194853956, 80.848696261860, 80.826197669754,
         80.803699077641, 80.781200485519, 80.758701893389, 80.736203301251, 80.713704709104, 80.691206116950,
         80.668707524787, 80.646208932616, 80.623710340438, 80.601211748251, 80.578713156057, 80.556214563855,
         80.533715971645, 80.511217379428, 80.488718787203, 80.466220194970, 80.443721602730, 80.421223010483,
         80.398724418228, 80.376225825966, 80.353727233696, 80.331228641420, 80.308730049136, 80.286231456845,
         80.263732864547, 80.241234272242, 80.218735679930, 80.196237087611, 80.173738495285, 80.151239902952,
         80.128741310612, 80.106242718266, 80.083744125913, 80.061245533554, 80.038746941187, 80.016248348815,
         79.993749756435, 79.971251164049, 79.948752571657, 79.926253979258, 79.903755386853, 79.881256794442,
         79.858758202025, 79.836259609601, 79.813761017171, 79.791262424735, 79.768763832293, 79.746265239844,
         79.723766647390, 79.701268054930, 79.678769462464, 79.656270869991, 79.633772277514, 79.611273685030,
         79.588775092540, 79.566276500045, 79.543777907544, 79.521279315037, 79.498780722525, 79.476282130007,
         79.453783537483, 79.431284944954, 79.408786352420, 79.386287759879, 79.363789167334, 79.341290574783,
         79.318791982227, 79.296293389665, 79.273794797099, 79.251296204526, 79.228797611949, 79.206299019367,
         79.183800426779, 79.161301834186, 79.138803241588, 79.116304648985, 79.093806056377, 79.071307463764,
         79.048808871146, 79.026310278523, 79.003811685896, 78.981313093263, 78.958814500625, 78.936315907983,
         78.913817315336, 78.891318722684, 78.868820130027, 78.846321537366, 78.823822944700, 78.801324352029,
         78.778825759354, 78.756327166674, 78.733828573989, 78.711329981300, 78.688831388607, 78.666332795909,
         78.643834203206, 78.621335610500, 78.598837017788, 78.576338425073, 78.553839832353, 78.531341239628,
         78.508842646900, 78.486344054167, 78.463845461429, 78.441346868688, 78.418848275942, 78.396349683193,
         78.373851090439, 78.351352497681, 78.328853904918, 78.306355312152, 78.283856719382, 78.261358126607,
         78.238859533829, 78.216360941047, 78.193862348260, 78.171363755470, 78.148865162676, 78.126366569878,
         78.103867977076, 78.081369384270, 78.058870791460, 78.036372198647, 78.013873605830, 77.991375013009,
         77.968876420184, 77.946377827355, 77.923879234523, 77.901380641687, 77.878882048848, 77.856383456004,
         77.833884863158, 77.811386270307, 77.788887677453, 77.766389084596, 77.743890491735, 77.721391898870,
         77.698893306002, 77.676394713130, 77.653896120255, 77.631397527376, 77.608898934494, 77.586400341609,
         77.563901748720, 77.541403155828, 77.518904562933, 77.496405970034, 77.473907377132, 77.451408784226,
         77.428910191317, 77.406411598405, 77.383913005490, 77.361414412572, 77.338915819650, 77.316417226725,
         77.293918633797, 77.271420040866, 77.248921447931, 77.226422854994, 77.203924262053, 77.181425669109,
         77.158927076162, 77.136428483213, 77.113929890260, 77.091431297304, 77.068932704345, 77.046434111383,
         77.023935518418, 77.001436925450, 76.978938332479, 76.956439739505, 76.933941146528, 76.911442553549,
         76.888943960566, 76.866445367581, 76.843946774592, 76.821448181601, 76.798949588607, 76.776450995610,
         76.753952402611, 76.731453809608, 76.708955216603, 76.686456623595, 76.663958030584, 76.641459437571,
         76.618960844555, 76.596462251536, 76.573963658514, 76.551465065490, 76.528966472463, 76.506467879434,
         76.483969286401, 76.461470693367, 76.438972100329, 76.416473507289, 76.393974914246, 76.371476321201,
         76.348977728153, 76.326479135103, 76.303980542050, 76.281481948995, 76.258983355937, 76.236484762876,
         76.213986169813, 76.191487576748, 76.168988983680, 76.146490390610, 76.123991797537, 76.101493204462,
         76.078994611385, 76.056496018304, 76.033997425222, 76.011498832137, 75.989000239050, 75.966501645961,
         75.944003052869, 75.921504459775, 75.899005866678, 75.876507273579, 75.854008680478, 75.831510087375,
         75.809011494269, 75.786512901161, 75.764014308051, 75.741515714939, 75.719017121824, 75.696518528707,
         75.674019935588, 75.651521342466, 75.629022749343, 75.606524156217, 75.584025563089, 75.561526969959,
         75.539028376827, 75.516529783692, 75.494031190556, 75.471532597417, 75.449034004276, 75.426535411134,
         75.404036817989, 75.381538224842, 75.359039631692, 75.336541038541, 75.314042445388, 75.291543852233,
         75.269045259075, 75.246546665916, 75.224048072755, 75.201549479591, 75.179050886426, 75.156552293258,
         75.134053700089, 75.111555106918, 75.089056513744, 75.066557920569, 75.044059327392, 75.021560734213,
         74.999062141031, 74.976563547848, 74.954064954664, 74.931566361477, 74.909067768288, 74.886569175097,
         74.864070581905, 74.841571988710, 74.819073395514, 74.796574802316, 74.774076209116, 74.751577615914,
         74.729079022711, 74.706580429505, 74.684081836298, 74.661583243089, 74.639084649878, 74.616586056666,
         74.594087463451, 74.571588870235, 74.549090277017, 74.526591683797, 74.504093090576, 74.481594497353,
         74.459095904128, 74.436597310901, 74.414098717673, 74.391600124442, 74.369101531211, 74.346602937977,
         74.324104344742, 74.301605751505, 74.279107158266, 74.256608565026, 74.234109971784, 74.211611378541,
         74.189112785296, 74.166614192049, 74.144115598800, 74.121617005550, 74.099118412298, 74.076619819045,
         74.054121225790, 74.031622632533, 74.009124039275, 73.986625446016, 73.964126852754, 73.941628259491,
         73.919129666227, 73.896631072961, 73.874132479693, 73.851633886424, 73.829135293154, 73.806636699881,
         73.784138106608, 73.761639513332, 73.739140920056, 73.716642326777, 73.694143733498, 73.671645140216,
         73.649146546934, 73.626647953649, 73.604149360364, 73.581650767077, 73.559152173788, 73.536653580498,
         73.514154987206, 73.491656393913, 73.469157800619, 73.446659207323, 73.424160614026, 73.401662020727,
         73.379163427427, 73.356664834125, 73.334166240822, 73.311667647518, 73.289169054212, 73.266670460905,
         73.244171867596, 73.221673274286, 73.199174680975, 73.176676087662, 73.154177494348, 73.131678901033,
         73.109180307716, 73.086681714398, 73.064183121079, 73.041684527758, 73.019185934436, 72.996687341112,
         72.974188747788, 72.951690154462, 72.929191561134, 72.906692967806, 72.884194374476, 72.861695781144,
         72.839197187812, 72.816698594478, 72.794200001143, 72.771701407806, 72.749202814469, 72.726704221130,
         72.704205627790, 72.681707034448, 72.659208441106, 72.636709847762, 72.614211254416, 72.591712661070,
         72.569214067722, 72.546715474374, 72.524216881024, 72.501718287672, 72.479219694320, 72.456721100966,
         72.434222507611, 72.411723914255, 72.389225320898, 72.366726727539, 72.344228134180, 72.321729540819,
         72.299230947457, 72.276732354094, 72.254233760729, 72.231735167364, 72.209236573997, 72.186737980629,
         72.164239387260, 72.141740793890, 72.119242200519, 72.096743607146, 72.074245013773, 72.051746420398,
         72.029247827023, 72.006749233646, 71.984250640268, 71.961752046889, 71.939253453508, 71.916754860127,
         71.894256266745, 71.871757673361, 71.849259079977, 71.826760486591, 71.804261893204, 71.781763299816,
         71.759264706427, 71.736766113037, 71.714267519646, 71.691768926254, 71.669270332861, 71.646771739467,
         71.624273146072, 71.601774552675, 71.579275959278, 71.556777365880, 71.534278772480, 71.511780179080,
         71.489281585678, 71.466782992276, 71.444284398872, 71.421785805468, 71.399287212062, 71.376788618656,
         71.354290025248, 71.331791431840, 71.309292838430, 71.286794245020, 71.264295651608, 71.241797058196,
         71.219298464782, 71.196799871368, 71.174301277952, 71.151802684536, 71.129304091118, 71.106805497700,
         71.084306904281, 71.061808310860, 71.039309717439, 71.016811124017, 70.994312530594, 70.971813937170,
         70.949315343745, 70.926816750319, 70.904318156892, 70.881819563464, 70.859320970035, 70.836822376606,
         70.814323783175, 70.791825189744, 70.769326596311, 70.746828002878, 70.724329409444, 70.701830816008,
         70.679332222572, 70.656833629135, 70.634335035698, 70.611836442259, 70.589337848819, 70.566839255379,
         70.544340661937, 70.521842068495, 70.499343475052, 70.476844881608, 70.454346288163, 70.431847694717,
         70.409349101270, 70.386850507823, 70.364351914375, 70.341853320925, 70.319354727475, 70.296856134024,
         70.274357540573, 70.251858947120, 70.229360353667, 70.206861760212, 70.184363166757, 70.161864573301,
         70.139365979844, 70.116867386387, 70.094368792928, 70.071870199469, 70.049371606009, 70.026873012548,
         70.004374419086, 69.981875825624, 69.959377232160, 69.936878638696, 69.914380045231, 69.891881451766,
         69.869382858299, 69.846884264832, 69.824385671364, 69.801887077895, 69.779388484425, 69.756889890954,
         69.734391297483, 69.711892704011, 69.689394110538, 69.666895517065, 69.644396923590, 69.621898330115,
         69.599399736639, 69.576901143163, 69.554402549685, 69.531903956207, 69.509405362728, 69.486906769248,
         69.464408175768, 69.441909582287, 69.419410988805, 69.396912395322, 69.374413801839, 69.351915208354,
         69.329416614870, 69.306918021384, 69.284419427897, 69.261920834410, 69.239422240923, 69.216923647434,
         69.194425053945, 69.171926460455, 69.149427866964, 69.126929273473, 69.104430679980, 69.081932086488,
         69.059433492994, 69.036934899500, 69.014436306005, 68.991937712509, 68.969439119013, 68.946940525516,
         68.924441932018, 68.901943338519, 68.879444745020, 68.856946151521, 68.834447558020, 68.811948964519,
         68.789450371017, 68.766951777514, 68.744453184011, 68.721954590507, 68.699455997003, 68.676957403497,
         68.654458809991, 68.631960216485, 68.609461622978, 68.586963029470, 68.564464435961, 68.541965842452,
         68.519467248942, 68.496968655431, 68.474470061920, 68.451971468408, 68.429472874896, 68.406974281383,
         68.384475687869, 68.361977094355, 68.339478500839, 68.316979907324, 68.294481313807, 68.271982720290,
         68.249484126773, 68.226985533255, 68.204486939736, 68.181988346216, 68.159489752696, 68.136991159175,
         68.114492565654, 68.091993972132, 68.069495378609, 68.046996785086, 68.024498191562, 68.001999598038,
         67.979501004513, 67.957002410987, 67.934503817461, 67.912005223934, 67.889506630407, 67.867008036879,
         67.844509443350, 67.822010849821, 67.799512256291, 67.777013662761, 67.754515069230, 67.732016475698,
         67.709517882166, 67.687019288633, 67.664520695100, 67.642022101566, 67.619523508031, 67.597024914496,
         67.574526320960, 67.552027727424, 67.529529133887, 67.507030540350, 67.484531946812, 67.462033353273,
         67.439534759734, 67.417036166195, 67.394537572654, 67.372038979113, 67.349540385572, 67.327041792030,
         67.304543198488, 67.282044604945, 67.259546011401, 67.237047417857, 67.214548824312, 67.192050230767,
         67.169551637221, 67.147053043675, 67.124554450128, 67.102055856581, 67.079557263033, 67.057058669484,
         67.034560075935, 67.012061482386, 66.989562888836, 66.967064295285, 66.944565701734, 66.922067108182,
         66.899568514630, 66.877069921077, 66.854571327524, 66.832072733970, 66.809574140416, 66.787075546861,
         66.764576953306, 66.742078359750, 66.719579766194, 66.697081172637, 66.674582579080, 66.652083985522,
         66.629585391963, 66.607086798404, 66.584588204845, 66.562089611285, 66.539591017725, 66.517092424164,
         66.494593830602, 66.472095237040, 66.449596643478, 66.427098049915, 66.404599456352, 66.382100862788,
         66.359602269223, 66.337103675658, 66.314605082093, 66.292106488527, 66.269607894961, 66.247109301394,
         66.224610707827, 66.202112114259, 66.179613520691, 66.157114927122, 66.134616333553, 66.112117739983,
         66.089619146413, 66.067120552842, 66.044621959271, 66.022123365699, 65.999624772127, 65.977126178555,
         65.954627584982, 65.932128991408, 65.909630397834, 65.887131804260, 65.864633210685, 65.842134617110,
         65.819636023534, 65.797137429958, 65.774638836381, 65.752140242804, 65.729641649226, 65.707143055648,
         65.684644462070, 65.662145868491, 65.639647274911, 65.617148681331, 65.594650087751, 65.572151494170,
         65.549652900589, 65.527154307008, 65.504655713425, 65.482157119843, 65.459658526260, 65.437159932677,
         65.414661339093, 65.392162745508, 65.369664151924, 65.347165558339, 65.324666964753, 65.302168371167,
         65.279669777581, 65.257171183994, 65.234672590406, 65.212173996819, 65.189675403231, 65.167176809642,
         65.144678216053, 65.122179622464, 65.099681028874, 65.077182435284, 65.054683841693, 65.032185248102,
         65.009686654510, 64.987188060918, 64.964689467326, 64.942190873733, 64.919692280140, 64.897193686547,
         64.874695092953, 64.852196499358, 64.829697905764, 64.807199312168, 64.784700718573, 64.762202124977,
         64.739703531380, 64.717204937784, 64.694706344186, 64.672207750589, 64.649709156991, 64.627210563392,
         64.604711969793, 64.582213376194, 64.559714782595, 64.537216188995, 64.514717595394, 64.492219001794,
         64.469720408192, 64.447221814591, 64.424723220989, 64.402224627387, 64.379726033784, 64.357227440181,
         64.334728846577, 64.312230252974, 64.289731659369, 64.267233065765, 64.244734472160, 64.222235878554,
         64.199737284949, 64.177238691342, 64.154740097736, 64.132241504129, 64.109742910522, 64.087244316914,
         64.064745723306, 64.042247129698, 64.019748536089, 63.997249942480, 63.974751348870, 63.952252755261,
         63.929754161650, 63.907255568040, 63.884756974429, 63.862258380818, 63.839759787206, 63.817261193594,
         63.794762599982, 63.772264006369, 63.749765412756, 63.727266819142, 63.704768225528, 63.682269631914,
         63.659771038300, 63.637272444685, 63.614773851070, 63.592275257454, 63.569776663838, 63.547278070222,
         63.524779476605, 63.502280882988, 63.479782289371, 63.457283695753, 63.434785102135, 63.412286508517,
         63.389787914898, 63.367289321279, 63.344790727660, 63.322292134040, 63.299793540420, 63.277294946799,
         63.254796353178, 63.232297759557, 63.209799165936, 63.187300572314, 63.164801978692, 63.142303385070,
         63.119804791447, 63.097306197824, 63.074807604200, 63.052309010576, 63.029810416952, 63.007311823328,
         62.984813229703, 62.962314636078, 62.939816042453, 62.917317448827, 62.894818855201, 62.872320261574,
         62.849821667948, 62.827323074321, 62.804824480693, 62.782325887066, 62.759827293438, 62.737328699809,
         62.714830106181, 62.692331512552, 62.669832918922, 62.647334325293, 62.624835731663, 62.602337138033,
         62.579838544402, 62.557339950771, 62.534841357140, 62.512342763509, 62.489844169877, 62.467345576245,
         62.444846982612, 62.422348388979, 62.399849795346, 62.377351201713, 62.354852608079, 62.332354014446,
         62.309855420811, 62.287356827177, 62.264858233542, 62.242359639907, 62.219861046271, 62.197362452635,
         62.174863858999, 62.152365265363, 62.129866671726, 62.107368078089, 62.084869484452, 62.062370890814,
         62.039872297177, 62.017373703538, 61.994875109900, 61.972376516261, 61.949877922622, 61.927379328983,
         61.904880735343, 61.882382141703, 61.859883548063, 61.837384954423, 61.814886360782, 61.792387767141,
         61.769889173499, 61.747390579858, 61.724891986216, 61.702393392573, 61.679894798931, 61.657396205288,
         61.634897611645, 61.612399018002, 61.589900424358, 61.567401830714, 61.544903237070, 61.522404643425,
         61.499906049781, 61.477407456136, 61.454908862490, 61.432410268845, 61.409911675199, 61.387413081553,
         61.364914487906, 61.342415894260, 61.319917300613, 61.297418706965, 61.274920113318, 61.252421519670,
         61.229922926022, 61.207424332374, 61.184925738725, 61.162427145076, 61.139928551427, 61.117429957777,
         61.094931364128, 61.072432770478, 61.049934176828, 61.027435583177, 61.004936989526, 60.982438395875,
         60.959939802224, 60.937441208572, 60.914942614921, 60.892444021269, 60.869945427616, 60.847446833964,
         60.824948240311, 60.802449646658, 60.779951053004, 60.757452459351, 60.734953865697, 60.712455272043,
         60.689956678388, 60.667458084733, 60.644959491079, 60.622460897423, 60.599962303768, 60.577463710112,
         60.554965116456, 60.532466522800, 60.509967929144, 60.487469335487, 60.464970741830, 60.442472148173,
         60.419973554515, 60.397474960858, 60.374976367200, 60.352477773541, 60.329979179883, 60.307480586224,
         60.284981992565, 60.262483398906, 60.239984805247, 60.217486211587, 60.194987617927, 60.172489024267,
         60.149990430607, 60.127491836946, 60.104993243285, 60.082494649624, 60.059996055963, 60.037497462301,
         60.014998868639, 59.992500274977, 59.970001681315, 59.947503087652, 59.925004493989, 59.902505900326,
         59.880007306663, 59.857508712999, 59.835010119336, 59.812511525672, 59.790012932007, 59.767514338343,
         59.745015744678, 59.722517151013, 59.700018557348, 59.677519963683, 59.655021370017, 59.632522776351,
         59.610024182685, 59.587525589019, 59.565026995352, 59.542528401686, 59.520029808019, 59.497531214351,
         59.475032620684, 59.452534027016, 59.430035433348, 59.407536839680, 59.385038246012, 59.362539652343,
         59.340041058674, 59.317542465005, 59.295043871336, 59.272545277667, 59.250046683997, 59.227548090327,
         59.205049496657, 59.182550902986, 59.160052309316, 59.137553715645, 59.115055121974, 59.092556528303,
         59.070057934631, 59.047559340960, 59.025060747288, 59.002562153616, 58.980063559943, 58.957564966271,
         58.935066372598, 58.912567778925, 58.890069185252, 58.867570591578, 58.845071997905, 58.822573404231,
         58.800074810557, 58.777576216883, 58.755077623208, 58.732579029533, 58.710080435859, 58.687581842183,
         58.665083248508, 58.642584654833, 58.620086061157, 58.597587467481, 58.575088873805, 58.552590280128,
         58.530091686452, 58.507593092775, 58.485094499098, 58.462595905421, 58.440097311744, 58.417598718066,
         58.395100124388, 58.372601530710, 58.350102937032, 58.327604343353, 58.305105749675, 58.282607155996,
         58.260108562317, 58.237609968638, 58.215111374958, 58.192612781279, 58.170114187599, 58.147615593919,
         58.125117000239, 58.102618406558, 58.080119812878, 58.057621219197, 58.035122625516, 58.012624031835,
         57.990125438153, 57.967626844472, 57.945128250790, 57.922629657108, 57.900131063426, 57.877632469743,
         57.855133876061, 57.832635282378, 57.810136688695, 57.787638095012, 57.765139501328, 57.742640907645,
         57.720142313961, 57.697643720277, 57.675145126593, 57.652646532909, 57.630147939224, 57.607649345540,
         57.585150751855, 57.562652158170, 57.540153564484, 57.517654970799, 57.495156377113, 57.472657783427,
         57.450159189741, 57.427660596055, 57.405162002369, 57.382663408682, 57.360164814995, 57.337666221309,
         57.315167627621, 57.292669033934, 57.270170440247, 57.247671846559, 57.225173252871, 57.202674659183,
         57.180176065495, 57.157677471806, 57.135178878118, 57.112680284429, 57.090181690740, 57.067683097051,
         57.045184503362, 57.022685909672, 57.000187315982, 56.977688722293, 56.955190128603, 56.932691534912,
         56.910192941222, 56.887694347531, 56.865195753841, 56.842697160150, 56.820198566459, 56.797699972767,
         56.775201379076, 56.752702785384, 56.730204191692, 56.707705598001, 56.685207004308, 56.662708410616,
         56.640209816924, 56.617711223231, 56.595212629538, 56.572714035845, 56.550215442152, 56.527716848458,
         56.505218254765, 56.482719661071, 56.460221067377, 56.437722473683, 56.415223879989, 56.392725286295,
         56.370226692600, 56.347728098905, 56.325229505211, 56.302730911515, 56.280232317820, 56.257733724125,
         56.235235130429, 56.212736536734, 56.190237943038, 56.167739349342, 56.145240755645, 56.122742161949,
         56.100243568252, 56.077744974556, 56.055246380859, 56.032747787162, 56.010249193465, 55.987750599767,
         55.965252006070, 55.942753412372, 55.920254818674, 55.897756224976, 55.875257631278, 55.852759037579,
         55.830260443881, 55.807761850182, 55.785263256483, 55.762764662784, 55.740266069085, 55.717767475386,
         55.695268881686, 55.672770287987, 55.650271694287, 55.627773100587, 55.605274506887, 55.582775913187,
         55.560277319486, 55.537778725786, 55.515280132085, 55.492781538384, 55.470282944683, 55.447784350982,
         55.425285757280, 55.402787163579, 55.380288569877, 55.357789976175, 55.335291382473, 55.312792788771,
         55.290294195069, 55.267795601366, 55.245297007664, 55.222798413961, 55.200299820258, 55.177801226555,
         55.155302632852, 55.132804039148, 55.110305445445, 55.087806851741, 55.065308258037, 55.042809664333,
         55.020311070629, 54.997812476925, 54.975313883221, 54.952815289516, 54.930316695811, 54.907818102107,
         54.885319508401, 54.862820914696, 54.840322320991, 54.817823727286, 54.795325133580, 54.772826539874,
         54.750327946168, 54.727829352462, 54.705330758756, 54.682832165050, 54.660333571343, 54.637834977637,
         54.615336383930, 54.592837790223, 54.570339196516, 54.547840602809, 54.525342009101, 54.502843415394,
         54.480344821686, 54.457846227978, 54.435347634270, 54.412849040562, 54.390350446854, 54.367851853146,
         54.345353259437, 54.322854665729, 54.300356072020, 54.277857478311, 54.255358884602, 54.232860290893,
         54.210361697183, 54.187863103474, 54.165364509764, 54.142865916054, 54.120367322344, 54.097868728634,
         54.075370134924, 54.052871541214, 54.030372947503, 54.007874353793, 53.985375760082, 53.962877166371,
         53.940378572660, 53.917879978949, 53.895381385238, 53.872882791526, 53.850384197815, 53.827885604103,
         53.805387010391, 53.782888416679, 53.760389822967, 53.737891229255, 53.715392635543, 53.692894041830,
         53.670395448118, 53.647896854405, 53.625398260692, 53.602899666979, 53.580401073266, 53.557902479552,
         53.535403885839, 53.512905292125, 53.490406698412, 53.467908104698, 53.445409510984, 53.422910917270,
         53.400412323556, 53.377913729841, 53.355415136127, 53.332916542412, 53.310417948697, 53.287919354983,
         53.265420761268, 53.242922167552, 53.220423573837, 53.197924980122, 53.175426386406, 53.152927792691,
         53.130429198975, 53.107930605259, 53.085432011543, 53.062933417827, 53.040434824110, 53.017936230394,
         52.995437636678, 52.972939042961, 52.950440449244, 52.927941855527, 52.905443261810, 52.882944668093,
         52.860446074376, 52.837947480658, 52.815448886941, 52.792950293223, 52.770451699505, 52.747953105787,
         52.725454512069, 52.702955918351, 52.680457324633, 52.657958730914, 52.635460137196, 52.612961543477,
         52.590462949759, 52.567964356040, 52.545465762321, 52.522967168601, 52.500468574882, 52.477969981163,
         52.455471387443, 52.432972793724, 52.410474200004, 52.387975606284, 52.365477012564, 52.342978418844,
         52.320479825124, 52.297981231403, 52.275482637683, 52.252984043962, 52.230485450242, 52.207986856521,
         52.185488262800, 52.162989669079, 52.140491075358, 52.117992481636, 52.095493887915, 52.072995294193,
         52.050496700472, 52.027998106750, 52.005499513028, 51.983000919306, 51.960502325584, 51.938003731862,
         51.915505138139, 51.893006544417, 51.870507950694, 51.848009356972, 51.825510763249, 51.803012169526,
         51.780513575803, 51.758014982080, 51.735516388357, 51.713017794633, 51.690519200910, 51.668020607186,
         51.645522013462, 51.623023419738, 51.600524826015, 51.578026232290, 51.555527638566, 51.533029044842,
         51.510530451118, 51.488031857393, 51.465533263668, 51.443034669944, 51.420536076219, 51.398037482494,
         51.375538888769, 51.353040295044, 51.330541701318, 51.308043107593, 51.285544513868, 51.263045920142,
         51.240547326416, 51.218048732690, 51.195550138964, 51.173051545238, 51.150552951512, 51.128054357786,
         51.105555764059, 51.083057170333, 51.060558576606, 51.038059982880, 51.015561389153, 50.993062795426,
         50.970564201699, 50.948065607972, 50.925567014245, 50.903068420517, 50.880569826790, 50.858071233062,
         50.835572639334, 50.813074045607, 50.790575451879, 50.768076858151, 50.745578264423, 50.723079670695,
         50.700581076966, 50.678082483238, 50.655583889509, 50.633085295781, 50.610586702052, 50.588088108323,
         50.565589514594, 50.543090920865, 50.520592327136, 50.498093733407, 50.475595139677, 50.453096545948,
         50.430597952218, 50.408099358489, 50.385600764759, 50.363102171029, 50.340603577299, 50.318104983569,
         50.295606389839, 50.273107796109, 50.250609202378, 50.228110608648, 50.205612014917, 50.183113421187,
         50.160614827456, 50.138116233725, 50.115617639994, 50.093119046263, 50.070620452532, 50.048121858800,
         50.025623265069, 50.003124671337, 49.980626077606, 49.958127483874, 49.935628890142, 49.913130296411,
         49.890631702679, 49.868133108946, 49.845634515214, 49.823135921482, 49.800637327750, 49.778138734017,
         49.755640140285, 49.733141546552, 49.710642952819, 49.688144359086, 49.665645765353, 49.643147171620,
         49.620648577887, 49.598149984154, 49.575651390421, 49.553152796687, 49.530654202954, 49.508155609220,
         49.485657015486, 49.463158421752, 49.440659828018, 49.418161234284, 49.395662640550, 49.373164046816,
         49.350665453082, 49.328166859347, 49.305668265613, 49.283169671878, 49.260671078144, 49.238172484409,
         49.215673890674, 49.193175296939, 49.170676703204, 49.148178109469, 49.125679515734, 49.103180921998,
         49.080682328263, 49.058183734527, 49.035685140792, 49.013186547056, 48.990687953320, 48.968189359584,
         48.945690765848, 48.923192172112, 48.900693578376, 48.878194984640, 48.855696390904, 48.833197797167,
         48.810699203431, 48.788200609694, 48.765702015957, 48.743203422220, 48.720704828484, 48.698206234747,
         48.675707641010, 48.653209047272, 48.630710453535, 48.608211859798, 48.585713266060, 48.563214672323,
         48.540716078585, 48.518217484848, 48.495718891110, 48.473220297372, 48.450721703634, 48.428223109896,
         48.405724516158, 48.383225922419, 48.360727328681, 48.338228734943, 48.315730141204, 48.293231547466,
         48.270732953727, 48.248234359988, 48.225735766249, 48.203237172510, 48.180738578771, 48.158239985032,
         48.135741391293, 48.113242797554, 48.090744203815, 48.068245610075, 48.045747016336, 48.023248422596,
         48.000749828856, 47.978251235116, 47.955752641377, 47.933254047637, 47.910755453897, 47.888256860156,
         47.865758266416, 47.843259672676, 47.820761078935, 47.798262485195, 47.775763891454, 47.753265297714,
         47.730766703973, 47.708268110232, 47.685769516491, 47.663270922750, 47.640772329009, 47.618273735268,
         47.595775141527, 47.573276547786, 47.550777954044, 47.528279360303, 47.505780766561, 47.483282172820,
         47.460783579078, 47.438284985336, 47.415786391594, 47.393287797852, 47.370789204110, 47.348290610368,
         47.325792016626, 47.303293422883, 47.280794829141, 47.258296235399, 47.235797641656, 47.213299047913,
         47.190800454171, 47.168301860428, 47.145803266685, 47.123304672942, 47.100806079199, 47.078307485456,
         47.055808891713, 47.033310297970, 47.010811704226, 46.988313110483, 46.965814516739, 46.943315922996,
         46.920817329252, 46.898318735508, 46.875820141765, 46.853321548021, 46.830822954277, 46.808324360533,
         46.785825766788, 46.763327173044, 46.740828579300, 46.718329985556, 46.695831391811, 46.673332798067,
         46.650834204322, 46.628335610577, 46.605837016833, 46.583338423088, 46.560839829343, 46.538341235598,
         46.515842641853, 46.493344048108, 46.470845454362, 46.448346860617, 46.425848266872, 46.403349673126,
         46.380851079381, 46.358352485635, 46.335853891890, 46.313355298144, 46.290856704398, 46.268358110652,
         46.245859516906, 46.223360923160, 46.200862329414, 46.178363735668, 46.155865141921, 46.133366548175,
         46.110867954429, 46.088369360682, 46.065870766936, 46.043372173189, 46.020873579442, 45.998374985695,
         45.975876391948, 45.953377798202, 45.930879204454, 45.908380610707, 45.885882016960, 45.863383423213,
         45.840884829466, 45.818386235718, 45.795887641971, 45.773389048223, 45.750890454476, 45.728391860728,
         45.705893266980, 45.683394673232, 45.660896079485, 45.638397485737, 45.615898891988, 45.593400298240,
         45.570901704492, 45.548403110744, 45.525904516996, 45.503405923247, 45.480907329499, 45.458408735750,
         45.435910142002, 45.413411548253, 45.390912954504, 45.368414360755, 45.345915767006, 45.323417173257,
         45.300918579508, 45.278419985759, 45.255921392010, 45.233422798261, 45.210924204511, 45.188425610762,
         45.165927017013, 45.143428423263, 45.120929829513, 45.098431235764, 45.075932642014, 45.053434048264,
         45.030935454514, 45.008436860764, 44.985938267014, 44.963439673264, 44.940941079514, 44.918442485764,
         44.895943892014, 44.873445298263, 44.850946704513, 44.828448110762, 44.805949517012, 44.783450923261,
         44.760952329510, 44.738453735760, 44.715955142009, 44.693456548258, 44.670957954507, 44.648459360756,
         44.625960767005, 44.603462173254, 44.580963579502, 44.558464985751, 44.535966392000, 44.513467798248,
         44.490969204497, 44.468470610745, 44.445972016993, 44.423473423242, 44.400974829490, 44.378476235738,
         44.355977641986, 44.333479048234, 44.310980454482, 44.288481860730, 44.265983266978, 44.243484673226,
         44.220986079473, 44.198487485721, 44.175988891969, 44.153490298216, 44.130991704464, 44.108493110711,
         44.085994516958, 44.063495923205, 44.040997329453, 44.018498735700, 43.996000141947, 43.973501548194,
         43.951002954441, 43.928504360688, 43.906005766934, 43.883507173181, 43.861008579428, 43.838509985674,
         43.816011391921, 43.793512798167, 43.771014204414, 43.748515610660, 43.726017016906, 43.703518423153,
         43.681019829399, 43.658521235645, 43.636022641891, 43.613524048137, 43.591025454383, 43.568526860629,
         43.546028266874, 43.523529673120, 43.501031079366, 43.478532485611, 43.456033891857, 43.433535298102,
         43.411036704348, 43.388538110593, 43.366039516838, 43.343540923084, 43.321042329329, 43.298543735574,
         43.276045141819, 43.253546548064, 43.231047954309, 43.208549360554, 43.186050766798, 43.163552173043,
         43.141053579288, 43.118554985532, 43.096056391777, 43.073557798021, 43.051059204266, 43.028560610510,
         43.006062016754, 42.983563422999, 42.961064829243, 42.938566235487, 42.916067641731, 42.893569047975,
         42.871070454219, 42.848571860463, 42.826073266707, 42.803574672951, 42.781076079194, 42.758577485438,
         42.736078891681, 42.713580297925, 42.691081704168, 42.668583110412, 42.646084516655, 42.623585922899,
         42.601087329142, 42.578588735385, 42.556090141628, 42.533591547871, 42.511092954114, 42.488594360357,
         42.466095766600, 42.443597172843, 42.421098579086, 42.398599985328, 42.376101391571, 42.353602797814,
         42.331104204056, 42.308605610299, 42.286107016541, 42.263608422783, 42.241109829026, 42.218611235268,
         42.196112641510, 42.173614047752, 42.151115453994, 42.128616860236, 42.106118266478, 42.083619672720,
         42.061121078962, 42.038622485204, 42.016123891446, 41.993625297687, 41.971126703929, 41.948628110170,
         41.926129516412, 41.903630922653, 41.881132328895, 41.858633735136, 41.836135141378, 41.813636547619,
         41.791137953860, 41.768639360101, 41.746140766342, 41.723642172583, 41.701143578824, 41.678644985065,
         41.656146391306, 41.633647797547, 41.611149203787, 41.588650610028, 41.566152016269, 41.543653422509,
         41.521154828750, 41.498656234990, 41.476157641231, 41.453659047471, 41.431160453711, 41.408661859952,
         41.386163266192, 41.363664672432, 41.341166078672, 41.318667484912, 41.296168891152, 41.273670297392,
         41.251171703632, 41.228673109872, 41.206174516111, 41.183675922351, 41.161177328591, 41.138678734830,
         41.116180141070, 41.093681547309, 41.071182953549, 41.048684359788, 41.026185766028, 41.003687172267,
         40.981188578506, 40.958689984745, 40.936191390984, 40.913692797224, 40.891194203463, 40.868695609702,
         40.846197015940, 40.823698422179, 40.801199828418, 40.778701234657, 40.756202640896, 40.733704047134,
         40.711205453373, 40.688706859611, 40.666208265850, 40.643709672088, 40.621211078327, 40.598712484565,
         40.576213890803, 40.553715297042, 40.531216703280, 40.508718109518, 40.486219515756, 40.463720921994,
         40.441222328232, 40.418723734470, 40.396225140708, 40.373726546946, 40.351227953184, 40.328729359421,
         40.306230765659, 40.283732171897, 40.261233578134, 40.238734984372, 40.216236390609, 40.193737796847,
         40.171239203084, 40.148740609322, 40.126242015559, 40.103743421796, 40.081244828033, 40.058746234270,
         40.036247640508, 40.013749046745, 39.991250452982, 39.968751859218, 39.946253265455, 39.923754671692,
         39.901256077929, 39.878757484166, 39.856258890402, 39.833760296639, 39.811261702876, 39.788763109112,
         39.766264515349, 39.743765921585, 39.721267327822, 39.698768734058, 39.676270140294, 39.653771546531,
         39.631272952767, 39.608774359003, 39.586275765239, 39.563777171475, 39.541278577711, 39.518779983947,
         39.496281390183, 39.473782796419, 39.451284202655, 39.428785608891, 39.406287015126, 39.383788421362,
         39.361289827598, 39.338791233833, 39.316292640069, 39.293794046304, 39.271295452540, 39.248796858775,
         39.226298265010, 39.203799671246, 39.181301077481, 39.158802483716, 39.136303889951, 39.113805296187,
         39.091306702422, 39.068808108657, 39.046309514892, 39.023810921127, 39.001312327361, 38.978813733596,
         38.956315139831, 38.933816546066, 38.911317952301, 38.888819358535, 38.866320764770, 38.843822171004,
         38.821323577239, 38.798824983473, 38.776326389708, 38.753827795942, 38.731329202177, 38.708830608411,
         38.686332014645, 38.663833420879, 38.641334827113, 38.618836233348, 38.596337639582, 38.573839045816,
         38.551340452050, 38.528841858284, 38.506343264517, 38.483844670751, 38.461346076985, 38.438847483219,
         38.416348889453, 38.393850295686, 38.371351701920, 38.348853108153, 38.326354514387, 38.303855920620,
         38.281357326854, 38.258858733087, 38.236360139321, 38.213861545554, 38.191362951787, 38.168864358020,
         38.146365764254, 38.123867170487, 38.101368576720, 38.078869982953, 38.056371389186, 38.033872795419,
         38.011374201652, 37.988875607885, 37.966377014117, 37.943878420350, 37.921379826583, 37.898881232816,
         37.876382639048, 37.853884045281, 37.831385451513, 37.808886857746, 37.786388263978, 37.763889670211,
         37.741391076443, 37.718892482676, 37.696393888908, 37.673895295140, 37.651396701372, 37.628898107605,
         37.606399513837, 37.583900920069, 37.561402326301, 37.538903732533, 37.516405138765, 37.493906544997,
         37.471407951229, 37.448909357461, 37.426410763692, 37.403912169924, 37.381413576156, 37.358914982388,
         37.336416388619, 37.313917794851, 37.291419201082, 37.268920607314, 37.246422013545, 37.223923419777,
         37.201424826008, 37.178926232240, 37.156427638471, 37.133929044702, 37.111430450933, 37.088931857164,
         37.066433263396, 37.043934669627, 37.021436075858, 36.998937482089, 36.976438888320, 36.953940294551,
         36.931441700782, 36.908943107012, 36.886444513243, 36.863945919474, 36.841447325705, 36.818948731936,
         36.796450138166, 36.773951544397, 36.751452950627, 36.728954356858, 36.706455763088, 36.683957169319,
         36.661458575549, 36.638959981780, 36.616461388010, 36.593962794240, 36.571464200471, 36.548965606701,
         36.526467012931, 36.503968419161, 36.481469825391, 36.458971231621, 36.436472637851, 36.413974044081,
         36.391475450311, 36.368976856541, 36.346478262771, 36.323979669001, 36.301481075230, 36.278982481460,
         36.256483887690, 36.233985293920, 36.211486700149, 36.188988106379, 36.166489512608, 36.143990918838,
         36.121492325067, 36.098993731297, 36.076495137526, 36.053996543756, 36.031497949985, 36.008999356214,
         35.986500762443, 35.964002168673, 35.941503574902, 35.919004981131, 35.896506387360, 35.874007793589,
         35.851509199818, 35.829010606047, 35.806512012276, 35.784013418505, 35.761514824734, 35.739016230963,
         35.716517637191, 35.694019043420, 35.671520449649, 35.649021855877, 35.626523262106, 35.604024668335,
         35.581526074563, 35.559027480792, 35.536528887020, 35.514030293249, 35.491531699477, 35.469033105705,
         35.446534511934, 35.424035918162, 35.401537324390, 35.379038730619, 35.356540136847, 35.334041543075,
         35.311542949303, 35.289044355531, 35.266545761759, 35.244047167987, 35.221548574215, 35.199049980443,
         35.176551386671, 35.154052792899, 35.131554199127, 35.109055605354, 35.086557011582, 35.064058417810,
         35.041559824038, 35.019061230265, 34.996562636493, 34.974064042720, 34.951565448948, 34.929066855175,
         34.906568261403, 34.884069667630, 34.861571073858, 34.839072480085, 34.816573886312, 34.794075292540,
         34.771576698767, 34.749078104994, 34.726579511221, 34.704080917448, 34.681582323676, 34.659083729903,
         34.636585136130, 34.614086542357, 34.591587948584, 34.569089354811, 34.546590761037, 34.524092167264,
         34.501593573491, 34.479094979718, 34.456596385945, 34.434097792171, 34.411599198398, 34.389100604625,
         34.366602010851, 34.344103417078, 34.321604823304, 34.299106229531, 34.276607635757, 34.254109041984,
         34.231610448210, 34.209111854437, 34.186613260663, 34.164114666889, 34.141616073116, 34.119117479342,
         34.096618885568, 34.074120291794, 34.051621698020, 34.029123104246, 34.006624510473, 33.984125916699,
         33.961627322925, 33.939128729151, 33.916630135376, 33.894131541602, 33.871632947828, 33.849134354054,
         33.826635760280, 33.804137166506, 33.781638572731, 33.759139978957, 33.736641385183, 33.714142791408,
         33.691644197634, 33.669145603860, 33.646647010085, 33.624148416311, 33.601649822536, 33.579151228761,
         33.556652634987, 33.534154041212, 33.511655447438, 33.489156853663, 33.466658259888, 33.444159666113,
         33.421661072339, 33.399162478564, 33.376663884789, 33.354165291014, 33.331666697239, 33.309168103464,
         33.286669509689, 33.264170915914, 33.241672322139, 33.219173728364, 33.196675134589, 33.174176540814,
         33.151677947038, 33.129179353263, 33.106680759488, 33.084182165713, 33.061683571937, 33.039184978162,
         33.016686384387, 32.994187790611, 32.971689196836, 32.949190603060, 32.926692009285, 32.904193415509,
         32.881694821734, 32.859196227958, 32.836697634183, 32.814199040407, 32.791700446631, 32.769201852855,
         32.746703259080, 32.724204665304, 32.701706071528, 32.679207477752, 32.656708883976, 32.634210290200,
         32.611711696424, 32.589213102648, 32.566714508872, 32.544215915096, 32.521717321320, 32.499218727544,
         32.476720133768, 32.454221539992, 32.431722946216, 32.409224352440, 32.386725758663, 32.364227164887,
         32.341728571111, 32.319229977334, 32.296731383558, 32.274232789782, 32.251734196005, 32.229235602229,
         32.206737008452, 32.184238414676, 32.161739820899, 32.139241227122, 32.116742633346, 32.094244039569,
         32.071745445793, 32.049246852016, 32.026748258239, 32.004249664462, 31.981751070685, 31.959252476909,
         31.936753883132, 31.914255289355, 31.891756695578, 31.869258101801, 31.846759508024, 31.824260914247,
         31.801762320470, 31.779263726693, 31.756765132916, 31.734266539139, 31.711767945362, 31.689269351584,
         31.666770757807, 31.644272164030, 31.621773570253, 31.599274976475, 31.576776382698, 31.554277788921,
         31.531779195143, 31.509280601366, 31.486782007588, 31.464283413811, 31.441784820033, 31.419286226256,
         31.396787632478, 31.374289038701, 31.351790444923, 31.329291851145, 31.306793257368, 31.284294663590,
         31.261796069812, 31.239297476034, 31.216798882257, 31.194300288479, 31.171801694701, 31.149303100923,
         31.126804507145, 31.104305913367, 31.081807319589, 31.059308725811, 31.036810132033, 31.014311538255,
         30.991812944477, 30.969314350699, 30.946815756921, 30.924317163143, 30.901818569365, 30.879319975586,
         30.856821381808, 30.834322788030, 30.811824194251, 30.789325600473, 30.766827006695, 30.744328412916,
         30.721829819138, 30.699331225360, 30.676832631581, 30.654334037803, 30.631835444024, 30.609336850245,
         30.586838256467, 30.564339662688, 30.541841068910, 30.519342475131, 30.496843881352, 30.474345287574,
         30.451846693795, 30.429348100016, 30.406849506237, 30.384350912458, 30.361852318680, 30.339353724901,
         30.316855131122, 30.294356537343, 30.271857943564, 30.249359349785, 30.226860756006, 30.204362162227,
         30.181863568448, 30.159364974669, 30.136866380889, 30.114367787110, 30.091869193331, 30.069370599552,
         30.046872005773, 30.024373411993, 30.001874818214, 29.979376224435, 29.956877630656, 29.934379036876,
         29.911880443097, 29.889381849317, 29.866883255538, 29.844384661758, 29.821886067979, 29.799387474199,
         29.776888880420, 29.754390286640, 29.731891692861, 29.709393099081, 29.686894505301, 29.664395911522,
         29.641897317742, 29.619398723962, 29.596900130182, 29.574401536403, 29.551902942623, 29.529404348843,
         29.506905755063, 29.484407161283, 29.461908567503, 29.439409973723, 29.416911379943, 29.394412786163,
         29.371914192383, 29.349415598603, 29.326917004823, 29.304418411043, 29.281919817263, 29.259421223483,
         29.236922629703, 29.214424035923, 29.191925442142, 29.169426848362, 29.146928254582, 29.124429660802,
         29.101931067021, 29.079432473241, 29.056933879461, 29.034435285680, 29.011936691900, 28.989438098119,
         28.966939504339, 28.944440910558, 28.921942316778, 28.899443722997, 28.876945129217, 28.854446535436,
         28.831947941655, 28.809449347875, 28.786950754094, 28.764452160313, 28.741953566533, 28.719454972752,
         28.696956378971, 28.674457785190, 28.651959191410, 28.629460597629, 28.606962003848, 28.584463410067,
         28.561964816286, 28.539466222505, 28.516967628724, 28.494469034943, 28.471970441162, 28.449471847381,
         28.426973253600, 28.404474659819, 28.381976066038, 28.359477472257, 28.336978878476, 28.314480284694,
         28.291981690913, 28.269483097132, 28.246984503351, 28.224485909569, 28.201987315788, 28.179488722007,
         28.156990128225, 28.134491534444, 28.111992940663, 28.089494346881, 28.066995753100, 28.044497159318,
         28.021998565537, 27.999499971755, 27.977001377974, 27.954502784192, 27.932004190411, 27.909505596629,
         27.887007002847, 27.864508409066, 27.842009815284, 27.819511221502, 27.797012627721, 27.774514033939,
         27.752015440157, 27.729516846375, 27.707018252594, 27.684519658812, 27.662021065030, 27.639522471248,
         27.617023877466, 27.594525283684, 27.572026689902, 27.549528096120, 27.527029502338, 27.504530908556,
         27.482032314774, 27.459533720992, 27.437035127210, 27.414536533428, 27.392037939646, 27.369539345863,
         27.347040752081, 27.324542158299, 27.302043564517, 27.279544970735, 27.257046376952, 27.234547783170,
         27.212049189388, 27.189550595605, 27.167052001823, 27.144553408041, 27.122054814258, 27.099556220476,
         27.077057626693, 27.054559032911, 27.032060439128, 27.009561845346, 26.987063251563, 26.964564657781,
         26.942066063998, 26.919567470216, 26.897068876433, 26.874570282650, 26.852071688868, 26.829573095085,
         26.807074501302, 26.784575907519, 26.762077313737, 26.739578719954, 26.717080126171, 26.694581532388,
         26.672082938605, 26.649584344823, 26.627085751040, 26.604587157257, 26.582088563474, 26.559589969691,
         26.537091375908, 26.514592782125, 26.492094188342, 26.469595594559, 26.447097000776, 26.424598406993,
         26.402099813210, 26.379601219426, 26.357102625643, 26.334604031860, 26.312105438077, 26.289606844294,
         26.267108250510, 26.244609656727, 26.222111062944, 26.199612469161, 26.177113875377, 26.154615281594,
         26.132116687811, 26.109618094027, 26.087119500244, 26.064620906460, 26.042122312677, 26.019623718893,
         25.997125125110, 25.974626531326, 25.952127937543, 25.929629343759, 25.907130749976, 25.884632156192,
         25.862133562409, 25.839634968625, 25.817136374841, 25.794637781058, 25.772139187274, 25.749640593490,
         25.727141999706, 25.704643405923, 25.682144812139, 25.659646218355, 25.637147624571, 25.614649030787,
         25.592150437004, 25.569651843220, 25.547153249436, 25.524654655652, 25.502156061868, 25.479657468084,
         25.457158874300, 25.434660280516, 25.412161686732, 25.389663092948, 25.367164499164, 25.344665905380,
         25.322167311596, 25.299668717812, 25.277170124027, 25.254671530243, 25.232172936459, 25.209674342675,
         25.187175748891, 25.164677155106, 25.142178561322, 25.119679967538, 25.097181373754, 25.074682779969,
         25.052184186185, 25.029685592401, 25.007186998616, 24.984688404832, 24.962189811047, 24.939691217263,
         24.917192623479, 24.894694029694, 24.872195435910, 24.849696842125, 24.827198248340, 24.804699654556,
         24.782201060771, 24.759702466987, 24.737203873202, 24.714705279418, 24.692206685633, 24.669708091848,
         24.647209498064, 24.624710904279, 24.602212310494, 24.579713716709, 24.557215122925, 24.534716529140,
         24.512217935355, 24.489719341570, 24.467220747785, 24.444722154000, 24.422223560216, 24.399724966431,
         24.377226372646, 24.354727778861, 24.332229185076, 24.309730591291, 24.287231997506, 24.264733403721,
         24.242234809936, 24.219736216151, 24.197237622366, 24.174739028581, 24.152240434796, 24.129741841010,
         24.107243247225, 24.084744653440, 24.062246059655, 24.039747465870, 24.017248872085, 23.994750278299,
         23.972251684514, 23.949753090729, 23.927254496944, 23.904755903158, 23.882257309373, 23.859758715588,
         23.837260121802, 23.814761528017, 23.792262934231, 23.769764340446, 23.747265746661, 23.724767152875,
         23.702268559090, 23.679769965304, 23.657271371519, 23.634772777733, 23.612274183948, 23.589775590162,
         23.567276996376, 23.544778402591, 23.522279808805, 23.499781215020, 23.477282621234, 23.454784027448,
         23.432285433663, 23.409786839877, 23.387288246091, 23.364789652305, 23.342291058520, 23.319792464734,
         23.297293870948, 23.274795277162, 23.252296683376, 23.229798089591, 23.207299495805, 23.184800902019,
         23.162302308233, 23.139803714447, 23.117305120661, 23.094806526875, 23.072307933089, 23.049809339303,
         23.027310745517, 23.004812151731, 22.982313557945, 22.959814964159, 22.937316370373, 22.914817776587,
         22.892319182801, 22.869820589015, 22.847321995229, 22.824823401442, 22.802324807656, 22.779826213870,
         22.757327620084, 22.734829026298, 22.712330432511, 22.689831838725, 22.667333244939, 22.644834651153,
         22.622336057366, 22.599837463580, 22.577338869794, 22.554840276007, 22.532341682221, 22.509843088434,
         22.487344494648, 22.464845900862, 22.442347307075, 22.419848713289, 22.397350119502, 22.374851525716,
         22.352352931929, 22.329854338143, 22.307355744356, 22.284857150570, 22.262358556783, 22.239859962996,
         22.217361369210, 22.194862775423, 22.172364181637, 22.149865587850, 22.127366994063, 22.104868400277,
         22.082369806490, 22.059871212703, 22.037372618916, 22.014874025130, 21.992375431343, 21.969876837556,
         21.947378243769, 21.924879649982, 21.902381056196, 21.879882462409, 21.857383868622, 21.834885274835,
         21.812386681048, 21.789888087261, 21.767389493474, 21.744890899687, 21.722392305900, 21.699893712113,
         21.677395118326, 21.654896524539, 21.632397930752, 21.609899336965, 21.587400743178, 21.564902149391,
         21.542403555604, 21.519904961817, 21.497406368030, 21.474907774243, 21.452409180455, 21.429910586668,
         21.407411992881, 21.384913399094, 21.362414805307, 21.339916211519, 21.317417617732, 21.294919023945,
         21.272420430158, 21.249921836370, 21.227423242583, 21.204924648796, 21.182426055008, 21.159927461221,
         21.137428867434, 21.114930273646, 21.092431679859, 21.069933086071, 21.047434492284, 21.024935898497,
         21.002437304709, 20.979938710922, 20.957440117134, 20.934941523347, 20.912442929559, 20.889944335772,
         20.867445741984, 20.844947148196, 20.822448554409, 20.799949960621, 20.777451366834, 20.754952773046,
         20.732454179258, 20.709955585471, 20.687456991683, 20.664958397895, 20.642459804108, 20.619961210320,
         20.597462616532, 20.574964022744, 20.552465428957, 20.529966835169, 20.507468241381, 20.484969647593,
         20.462471053805, 20.439972460018, 20.417473866230, 20.394975272442, 20.372476678654, 20.349978084866,
         20.327479491078, 20.304980897290, 20.282482303502, 20.259983709714, 20.237485115926, 20.214986522138,
         20.192487928350, 20.169989334562, 20.147490740774, 20.124992146986, 20.102493553198, 20.079994959410,
         20.057496365622, 20.034997771834, 20.012499178046, 19.990000584258, 19.967501990470, 19.945003396681,
         19.922504802893, 19.900006209105, 19.877507615317, 19.855009021529, 19.832510427740, 19.810011833952,
         19.787513240164, 19.765014646376, 19.742516052587, 19.720017458799, 19.697518865011, 19.675020271223,
         19.652521677434, 19.630023083646, 19.607524489857, 19.585025896069, 19.562527302281, 19.540028708492,
         19.517530114704, 19.495031520915, 19.472532927127, 19.450034333339, 19.427535739550, 19.405037145762,
         19.382538551973, 19.360039958185, 19.337541364396, 19.315042770607, 19.292544176819, 19.270045583030,
         19.247546989242, 19.225048395453, 19.202549801665, 19.180051207876, 19.157552614087, 19.135054020299,
         19.112555426510, 19.090056832721, 19.067558238933, 19.045059645144, 19.022561051355, 19.000062457566,
         18.977563863778, 18.955065269989, 18.932566676200, 18.910068082411, 18.887569488623, 18.865070894834,
         18.842572301045, 18.820073707256, 18.797575113467, 18.775076519678, 18.752577925889, 18.730079332101,
         18.707580738312, 18.685082144523, 18.662583550734, 18.640084956945, 18.617586363156, 18.595087769367,
         18.572589175578, 18.550090581789, 18.527591988000, 18.505093394211, 18.482594800422, 18.460096206633,
         18.437597612844, 18.415099019055, 18.392600425266, 18.370101831477, 18.347603237687, 18.325104643898,
         18.302606050109, 18.280107456320, 18.257608862531, 18.235110268742, 18.212611674953, 18.190113081163,
         18.167614487374, 18.145115893585, 18.122617299796, 18.100118706006, 18.077620112217, 18.055121518428,
         18.032622924639, 18.010124330849, 17.987625737060, 17.965127143271, 17.942628549481, 17.920129955692,
         17.897631361903, 17.875132768113, 17.852634174324, 17.830135580535, 17.807636986745, 17.785138392956,
         17.762639799166, 17.740141205377, 17.717642611587, 17.695144017798, 17.672645424008, 17.650146830219,
         17.627648236429, 17.605149642640, 17.582651048850, 17.560152455061, 17.537653861271, 17.515155267482,
         17.492656673692, 17.470158079903, 17.447659486113, 17.425160892323, 17.402662298534, 17.380163704744,
         17.357665110954, 17.335166517165, 17.312667923375, 17.290169329585, 17.267670735796, 17.245172142006,
         17.222673548216, 17.200174954427, 17.177676360637, 17.155177766847, 17.132679173057, 17.110180579267,
         17.087681985478, 17.065183391688, 17.042684797898, 17.020186204108, 16.997687610318, 16.975189016529,
         16.952690422739, 16.930191828949, 16.907693235159, 16.885194641369, 16.862696047579, 16.840197453789,
         16.817698859999, 16.795200266209, 16.772701672419, 16.750203078629, 16.727704484839, 16.705205891049,
         16.682707297259, 16.660208703469, 16.637710109679, 16.615211515889, 16.592712922099, 16.570214328309,
         16.547715734519, 16.525217140729, 16.502718546939, 16.480219953149, 16.457721359359, 16.435222765569,
         16.412724171779, 16.390225577989, 16.367726984198, 16.345228390408, 16.322729796618, 16.300231202828,
         16.277732609038, 16.255234015247, 16.232735421457, 16.210236827667, 16.187738233877, 16.165239640086,
         16.142741046296, 16.120242452506, 16.097743858716, 16.075245264925, 16.052746671135, 16.030248077345,
         16.007749483554, 15.985250889764, 15.962752295974, 15.940253702183, 15.917755108393, 15.895256514603,
         15.872757920812, 15.850259327022, 15.827760733231, 15.805262139441, 15.782763545651, 15.760264951860,
         15.737766358070, 15.715267764279, 15.692769170489, 15.670270576698, 15.647771982908, 15.625273389117,
         15.602774795327, 15.580276201536, 15.557777607746, 15.535279013955, 15.512780420165, 15.490281826374,
         15.467783232583, 15.445284638793, 15.422786045002, 15.400287451212, 15.377788857421, 15.355290263630,
         15.332791669840, 15.310293076049, 15.287794482258, 15.265295888468, 15.242797294677, 15.220298700886,
         15.197800107096, 15.175301513305, 15.152802919514, 15.130304325724, 15.107805731933, 15.085307138142,
         15.062808544351, 15.040309950560, 15.017811356770, 14.995312762979, 14.972814169188, 14.950315575397,
         14.927816981606, 14.905318387816, 14.882819794025, 14.860321200234, 14.837822606443, 14.815324012652,
         14.792825418861, 14.770326825070, 14.747828231280, 14.725329637489, 14.702831043698, 14.680332449907,
         14.657833856116, 14.635335262325, 14.612836668534, 14.590338074743, 14.567839480952, 14.545340887161,
         14.522842293370, 14.500343699579, 14.477845105788, 14.455346511997, 14.432847918206, 14.410349324415,
         14.387850730624, 14.365352136833, 14.342853543042, 14.320354949251, 14.297856355460, 14.275357761668,
         14.252859167877, 14.230360574086, 14.207861980295, 14.185363386504, 14.162864792713, 14.140366198922,
         14.117867605131, 14.095369011339, 14.072870417548, 14.050371823757, 14.027873229966, 14.005374636175,
         13.982876042383, 13.960377448592, 13.937878854801, 13.915380261010, 13.892881667218, 13.870383073427,
         13.847884479636, 13.825385885845, 13.802887292053, 13.780388698262, 13.757890104471, 13.735391510679,
         13.712892916888, 13.690394323097, 13.667895729305, 13.645397135514, 13.622898541723, 13.600399947931,
         13.577901354140, 13.555402760348, 13.532904166557, 13.510405572766, 13.487906978974, 13.465408385183,
         13.442909791391, 13.420411197600, 13.397912603809, 13.375414010017, 13.352915416226, 13.330416822434,
         13.307918228643, 13.285419634851, 13.262921041060, 13.240422447268, 13.217923853477, 13.195425259685,
         13.172926665894, 13.150428072102, 13.127929478310, 13.105430884519, 13.082932290727, 13.060433696936,
         13.037935103144, 13.015436509353, 12.992937915561, 12.970439321769, 12.947940727978, 12.925442134186,
         12.902943540394, 12.880444946603, 12.857946352811, 12.835447759019, 12.812949165228, 12.790450571436,
         12.767951977644, 12.745453383853, 12.722954790061, 12.700456196269, 12.677957602478, 12.655459008686,
         12.632960414894, 12.610461821102, 12.587963227311, 12.565464633519, 12.542966039727, 12.520467445935,
         12.497968852144, 12.475470258352, 12.452971664560, 12.430473070768, 12.407974476976, 12.385475883184,
         12.362977289393, 12.340478695601, 12.317980101809, 12.295481508017, 12.272982914225, 12.250484320433,
         12.227985726641, 12.205487132850, 12.182988539058, 12.160489945266, 12.137991351474, 12.115492757682,
         12.092994163890, 12.070495570098, 12.047996976306, 12.025498382514, 12.002999788722, 11.980501194930,
         11.958002601138, 11.935504007346, 11.913005413554, 11.890506819762, 11.868008225970, 11.845509632178,
         11.823011038386, 11.800512444594, 11.778013850802, 11.755515257010, 11.733016663218, 11.710518069426,
         11.688019475634, 11.665520881842, 11.643022288050, 11.620523694258, 11.598025100466, 11.575526506674,
         11.553027912882, 11.530529319089, 11.508030725297, 11.485532131505, 11.463033537713, 11.440534943921,
         11.418036350129, 11.395537756337, 11.373039162544, 11.350540568752, 11.328041974960, 11.305543381168,
         11.283044787376, 11.260546193583, 11.238047599791, 11.215549005999, 11.193050412207, 11.170551818415,
         11.148053224622, 11.125554630830, 11.103056037038, 11.080557443246, 11.058058849453, 11.035560255661,
         11.013061661869, 10.990563068076, 10.968064474284, 10.945565880492, 10.923067286700, 10.900568692907,
         10.878070099115, 10.855571505323, 10.833072911530, 10.810574317738, 10.788075723946, 10.765577130153,
         10.743078536361, 10.720579942568, 10.698081348776, 10.675582754984, 10.653084161191, 10.630585567399,
         10.608086973607, 10.585588379814, 10.563089786022, 10.540591192229, 10.518092598437, 10.495594004644,
         10.473095410852, 10.450596817059, 10.428098223267, 10.405599629475, 10.383101035682, 10.360602441890,
         10.338103848097, 10.315605254305, 10.293106660512, 10.270608066720, 10.248109472927, 10.225610879135,
         10.203112285342, 10.180613691550, 10.158115097757, 10.135616503965, 10.113117910172, 10.090619316379,
         10.068120722587, 10.045622128794, 10.023123535002, 10.000624941209, 9.978126347417, 9.955627753624,
         9.933129159831, 9.910630566039, 9.888131972246, 9.865633378454, 9.843134784661, 9.820636190868, 9.798137597076,
         9.775639003283, 9.753140409490, 9.730641815698, 9.708143221905, 9.685644628112, 9.663146034320, 9.640647440527,
         9.618148846734, 9.595650252942, 9.573151659149, 9.550653065356, 9.528154471564, 9.505655877771, 9.483157283978,
         9.460658690185, 9.438160096393, 9.415661502600, 9.393162908807, 9.370664315014, 9.348165721222, 9.325667127429,
         9.303168533636, 9.280669939843, 9.258171346051, 9.235672752258, 9.213174158465, 9.190675564672, 9.168176970879,
         9.145678377087, 9.123179783294, 9.100681189501, 9.078182595708, 9.055684001915, 9.033185408123, 9.010686814330,
         8.988188220537, 8.965689626744, 8.943191032951, 8.920692439158, 8.898193845365, 8.875695251573, 8.853196657780,
         8.830698063987, 8.808199470194, 8.785700876401, 8.763202282608, 8.740703688815, 8.718205095022, 8.695706501229,
         8.673207907436, 8.650709313643, 8.628210719851, 8.605712126058, 8.583213532265, 8.560714938472, 8.538216344679,
         8.515717750886, 8.493219157093, 8.470720563300, 8.448221969507, 8.425723375714, 8.403224781921, 8.380726188128,
         8.358227594335, 8.335729000542, 8.313230406749, 8.290731812956, 8.268233219163, 8.245734625370, 8.223236031577,
         8.200737437784, 8.178238843991, 8.155740250198, 8.133241656405, 8.110743062612, 8.088244468819, 8.065745875025,
         8.043247281232, 8.020748687439, 7.998250093646, 7.975751499853, 7.953252906060, 7.930754312267, 7.908255718474,
         7.885757124681, 7.863258530888, 7.840759937095, 7.818261343301, 7.795762749508, 7.773264155715, 7.750765561922,
         7.728266968129, 7.705768374336, 7.683269780543, 7.660771186750, 7.638272592956, 7.615773999163, 7.593275405370,
         7.570776811577, 7.548278217784, 7.525779623991, 7.503281030197, 7.480782436404, 7.458283842611, 7.435785248818,
         7.413286655025, 7.390788061231, 7.368289467438, 7.345790873645, 7.323292279852, 7.300793686058, 7.278295092265,
         7.255796498472, 7.233297904679, 7.210799310886, 7.188300717092, 7.165802123299, 7.143303529506, 7.120804935713,
         7.098306341919, 7.075807748126, 7.053309154333, 7.030810560539, 7.008311966746, 6.985813372953, 6.963314779160,
         6.940816185366, 6.918317591573, 6.895818997780, 6.873320403986, 6.850821810193, 6.828323216400, 6.805824622606,
         6.783326028813, 6.760827435020, 6.738328841226, 6.715830247433, 6.693331653640, 6.670833059846, 6.648334466053,
         6.625835872260, 6.603337278466, 6.580838684673, 6.558340090880, 6.535841497086, 6.513342903293, 6.490844309500,
         6.468345715706, 6.445847121913, 6.423348528119, 6.400849934326, 6.378351340533, 6.355852746739, 6.333354152946,
         6.310855559152, 6.288356965359, 6.265858371566, 6.243359777772, 6.220861183979, 6.198362590185, 6.175863996392,
         6.153365402598, 6.130866808805, 6.108368215011, 6.085869621218, 6.063371027425, 6.040872433631, 6.018373839838,
         5.995875246044, 5.973376652251, 5.950878058457, 5.928379464664, 5.905880870870, 5.883382277077, 5.860883683283,
         5.838385089490, 5.815886495696, 5.793387901903, 5.770889308109, 5.748390714316, 5.725892120522, 5.703393526729,
         5.680894932935, 5.658396339142, 5.635897745348, 5.613399151555, 5.590900557761, 5.568401963968, 5.545903370174,
         5.523404776381, 5.500906182587, 5.478407588794, 5.455908995000, 5.433410401207, 5.410911807413, 5.388413213619,
         5.365914619826, 5.343416026032, 5.320917432239, 5.298418838445, 5.275920244652, 5.253421650858, 5.230923057064,
         5.208424463271, 5.185925869477, 5.163427275684, 5.140928681890, 5.118430088097, 5.095931494303, 5.073432900509,
         5.050934306716, 5.028435712922, 5.005937119128, 4.983438525335, 4.960939931541, 4.938441337748, 4.915942743954,
         4.893444150160, 4.870945556367, 4.848446962573, 4.825948368780, 4.803449774986, 4.780951181192, 4.758452587399,
         4.735953993605, 4.713455399811, 4.690956806018, 4.668458212224, 4.645959618430, 4.623461024637, 4.600962430843,
         4.578463837049, 4.555965243256, 4.533466649462, 4.510968055668, 4.488469461875, 4.465970868081, 4.443472274287,
         4.420973680494, 4.398475086700, 4.375976492906, 4.353477899113, 4.330979305319, 4.308480711525, 4.285982117731,
         4.263483523938, 4.240984930144, 4.218486336350, 4.195987742557, 4.173489148763, 4.150990554969, 4.128491961175,
         4.105993367382, 4.083494773588, 4.060996179794, 4.038497586001, 4.015998992207, 3.993500398413, 3.971001804619,
         3.948503210826, 3.926004617032, 3.903506023238, 3.881007429444, 3.858508835651, 3.836010241857, 3.813511648063,
         3.791013054269, 3.768514460476, 3.746015866682, 3.723517272888, 3.701018679094, 3.678520085301, 3.656021491507,
         3.633522897713, 3.611024303919, 3.588525710126, 3.566027116332, 3.543528522538, 3.521029928744, 3.498531334950,
         3.476032741157, 3.453534147363, 3.431035553569, 3.408536959775, 3.386038365981, 3.363539772188, 3.341041178394,
         3.318542584600, 3.296043990806, 3.273545397012, 3.251046803219, 3.228548209425, 3.206049615631, 3.183551021837,
         3.161052428043, 3.138553834250, 3.116055240456, 3.093556646662, 3.071058052868, 3.048559459074, 3.026060865281,
         3.003562271487, 2.981063677693, 2.958565083899, 2.936066490105, 2.913567896311, 2.891069302518, 2.868570708724,
         2.846072114930, 2.823573521136, 2.801074927342, 2.778576333548, 2.756077739754, 2.733579145961, 2.711080552167,
         2.688581958373, 2.666083364579, 2.643584770785, 2.621086176991, 2.598587583198, 2.576088989404, 2.553590395610,
         2.531091801816, 2.508593208022, 2.486094614228, 2.463596020434, 2.441097426640, 2.418598832847, 2.396100239053,
         2.373601645259, 2.351103051465, 2.328604457671, 2.306105863877, 2.283607270083, 2.261108676289, 2.238610082496,
         2.216111488702, 2.193612894908, 2.171114301114, 2.148615707320, 2.126117113526, 2.103618519732, 2.081119925938,
         2.058621332145, 2.036122738351, 2.013624144557, 1.991125550763, 1.968626956969, 1.946128363175, 1.923629769381,
         1.901131175587, 1.878632581793, 1.856133987999, 1.833635394206, 1.811136800412, 1.788638206618, 1.766139612824,
         1.743641019030, 1.721142425236, 1.698643831442, 1.676145237648, 1.653646643854, 1.631148050060, 1.608649456266,
         1.586150862473, 1.563652268679, 1.541153674885, 1.518655081091, 1.496156487297, 1.473657893503, 1.451159299709,
         1.428660705915, 1.406162112121, 1.383663518327, 1.361164924533, 1.338666330739, 1.316167736946, 1.293669143152,
         1.271170549358, 1.248671955564, 1.226173361770, 1.203674767976, 1.181176174182, 1.158677580388, 1.136178986594,
         1.113680392800, 1.091181799006, 1.068683205212, 1.046184611418, 1.023686017624, 1.001187423830, 0.978688830037,
         0.956190236243, 0.933691642449, 0.911193048655, 0.888694454861, 0.866195861067, 0.843697267273, 0.821198673479,
         0.798700079685, 0.776201485891, 0.753702892097, 0.731204298303, 0.708705704509, 0.686207110715, 0.663708516921,
         0.641209923127, 0.618711329334, 0.596212735540, 0.573714141746, 0.551215547952, 0.528716954158, 0.506218360364,
         0.483719766570, 0.461221172776, 0.438722578982, 0.416223985188, 0.393725391394, 0.371226797600, 0.348728203806,
         0.326229610012, 0.303731016218, 0.281232422424, 0.258733828630, 0.236235234836, 0.213736641043, 0.191238047249,
         0.168739453455, 0.146240859661, 0.123742265867, 0.101243672073, 0.078745078279, 0.056246484485, 0.033747890691,
         0.011249296897))

}  // namespace gaussian
}  // namespace spacing
}  // namespace grid
}  // namespace atlas
