// Copyright 2009-present MongoDB, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#if !defined(MONGOCXX_PRIVATE_DOXYGEN_PREPROCESSOR)
#error "This file is for documentation purposes only. It should not be included."
#endif // !defined(MONGOCXX_PRIVATE_DOXYGEN_PREPROCESSOR)

///
/// @file
/// For documentation purposes only.
///
/// @note This header is not includable!
///

///
/// @dir include/mongocxx
/// Provides headers declaring entities in @ref mongocxx
///

///
/// @dir include/mongocxx/docs
/// For documentation purposes only.
///

///
/// @namespace mongocxx
/// The top-level namespace within which all mongocxx library entities are declared.
///
/// In addition to declaring ABI namespaces (`v_noabi`, `v1`, etc.), this namespace also provides
/// "redeclarations" of entities within ABI namespaces. These redeclarations are intended to be the
/// preferred method for using mongocxx library entities when ABI stability of the mongocxx library is
/// NOT a requirement by the user. See [Root Namespace
/// Redeclarations](https://www.mongodb.com/docs/languages/cpp/cpp-driver/current/api-abi-versioning/abi-versioning/#std-label-cpp-abi-root-namespace-redec).
///

///
/// @namespace mongocxx::events
/// Declares entities describing APM events.
///

///
/// @namespace mongocxx::gridfs
/// Declares entities related to GridFS.
///

///
/// @namespace mongocxx::model
/// Declares entities representing bulk write operations.
///

///
/// @namespace mongocxx::options
/// Declares entities representing options to use with various commands.
///

///
/// @namespace mongocxx::options::gridfs
/// Declares entities representing options specific to GridFS.
///

///
/// @namespace mongocxx::result
/// Declares entities representing the result of various commands.
///

///
/// @namespace mongocxx::result::gridfs
/// Declares entities representing the result of GridFS commands.
///
