# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.computebulkactions import ComputeBulkActionsMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-computebulkactions
# USAGE
    python bulk_actions_create_or_update_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ComputeBulkActionsMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.bulk_actions.begin_create_or_update(
        resource_group_name="rgcomputebulkactions",
        location="eastus2euap",
        name="3ec2ab23-9f13-4328-85c8-21928acbc7b8",
        resource={
            "identity": {"type": "None", "userAssignedIdentities": {}},
            "plan": {
                "name": "owvrgjbxrkj",
                "product": "rlhap",
                "promotionCode": "agypojbtdxvgqgisautnhcoysgy",
                "publisher": "qhybdqbljmztcjujxal",
                "version": "ghmnlomqg",
            },
            "properties": {
                "capacity": 24,
                "capacityType": "VM",
                "computeProfile": {
                    "computeApiVersion": "bccikdfzgrygwpefvmvptutceg",
                    "extensions": [
                        {
                            "name": "gj",
                            "properties": {
                                "autoUpgradeMinorVersion": True,
                                "enableAutomaticUpgrade": True,
                                "forceUpdateTag": "mistpuvreycjbhahmcvgkjskeiop",
                                "protectedSettings": {},
                                "protectedSettingsFromKeyVault": {
                                    "secretUrl": "cuatfdkula",
                                    "sourceVault": {"id": "ioypuofzltakyfcomjwfkmyz"},
                                },
                                "provisionAfterExtensions": ["jddcihtuzdczkvkryhktzjlf"],
                                "publisher": "rzsodcysrfxkrgnrjqlpfqe",
                                "settings": {},
                                "suppressFailures": True,
                                "type": "eyehf",
                                "typeHandlerVersion": "wezzz",
                            },
                        }
                    ],
                    "virtualMachineProfile": {
                        "additionalCapabilities": {"hibernationEnabled": True, "ultraSSDEnabled": True},
                        "applicationProfile": {
                            "galleryApplications": [
                                {
                                    "configurationReference": "mddsvaruvzvblkafsotscupperzu",
                                    "enableAutomaticUpgrade": True,
                                    "order": 14,
                                    "packageReferenceId": "soddwzqduyolzz",
                                    "tags": "qgn",
                                    "treatFailureAsDeploymentFailure": True,
                                }
                            ]
                        },
                        "capacityReservation": {"capacityReservationGroup": {"id": "obwiwwsgkdg"}},
                        "diagnosticsProfile": {
                            "bootDiagnostics": {"enabled": True, "storageUri": "https://microsoft.com/a"}
                        },
                        "extensionsTimeBudget": "hvrimblcqujozpeurohjcn",
                        "licenseType": "iipnwxwfkfbbouzbwicqxnxicjz",
                        "networkProfile": {
                            "networkApiVersion": "2020-11-01",
                            "networkInterfaceConfigurations": [
                                {
                                    "name": "keppldrpxjgckgsmq",
                                    "properties": {
                                        "auxiliaryMode": "None",
                                        "auxiliarySku": "None",
                                        "deleteOption": "Delete",
                                        "disableTcpStateTracking": True,
                                        "dnsSettings": {"dnsServers": ["pnhvxygytoozxmkt"]},
                                        "dscpConfiguration": {"id": "ioypuofzltakyfcomjwfkmyz"},
                                        "enableAcceleratedNetworking": True,
                                        "enableFpga": True,
                                        "enableIPForwarding": True,
                                        "ipConfigurations": [
                                            {
                                                "name": "nqjufbencyticmohsdxogwiu",
                                                "properties": {
                                                    "applicationGatewayBackendAddressPools": [{"id": "obwiwwsgkdg"}],
                                                    "applicationSecurityGroups": [{"id": "obwiwwsgkdg"}],
                                                    "loadBalancerBackendAddressPools": [{"id": "obwiwwsgkdg"}],
                                                    "primary": True,
                                                    "privateIPAddressVersion": "IPv4",
                                                    "publicIPAddressConfiguration": {
                                                        "name": "kgvjhctjspzldadcmtgsojglhmj",
                                                        "properties": {
                                                            "deleteOption": "Delete",
                                                            "dnsSettings": {
                                                                "domainNameLabel": "vsvbcpusndz",
                                                                "domainNameLabelScope": "TenantReuse",
                                                            },
                                                            "idleTimeoutInMinutes": 22,
                                                            "ipTags": [
                                                                {
                                                                    "ipTagType": "hengwhngakjlsmhuegnlbtpmiihf",
                                                                    "tag": "zlnuzjdbdnwbtep",
                                                                }
                                                            ],
                                                            "publicIPAddressVersion": "IPv4",
                                                            "publicIPAllocationMethod": "Dynamic",
                                                            "publicIPPrefix": {"id": "obwiwwsgkdg"},
                                                        },
                                                        "sku": {"name": "Basic", "tier": "Regional"},
                                                        "tags": {},
                                                    },
                                                    "subnet": {"id": "djtafmblvomuabwlhlyoxzgdkwkz"},
                                                },
                                            }
                                        ],
                                        "networkSecurityGroup": {"id": "obwiwwsgkdg"},
                                        "primary": True,
                                    },
                                    "tags": {},
                                }
                            ],
                            "networkInterfaces": [
                                {
                                    "id": "bmlqsytfgnkwgkibsmsoeh",
                                    "properties": {"deleteOption": "Delete", "primary": True},
                                }
                            ],
                        },
                        "osProfile": {
                            "adminPassword": "<a-password-goes-here>",
                            "adminUsername": "tjdagcdhlpihlhkrz",
                            "allowExtensionOperations": True,
                            "computerName": "jagkikqx",
                            "customData": "jemgccf",
                            "linuxConfiguration": {
                                "disablePasswordAuthentication": True,
                                "enableVMAgentPlatformUpdates": True,
                                "patchSettings": {
                                    "assessmentMode": "ImageDefault",
                                    "automaticByPlatformSettings": {
                                        "bypassPlatformSafetyChecksOnUserSchedule": True,
                                        "rebootSetting": "Unknown",
                                    },
                                    "patchMode": "ImageDefault",
                                },
                                "provisionVMAgent": True,
                                "ssh": {"publicKeys": [{"keyData": "mfk", "path": "xyntsvqsiqsguyegxdvkmwhwz"}]},
                            },
                            "requireGuestProvisionSignal": True,
                            "secrets": [
                                {
                                    "sourceVault": {"id": "obwiwwsgkdg"},
                                    "vaultCertificates": [
                                        {
                                            "certificateStore": "zxrjtvfmltdj",
                                            "certificateUrl": "https://microsoft.com/agmunp",
                                        }
                                    ],
                                }
                            ],
                            "windowsConfiguration": {
                                "additionalUnattendContent": [
                                    {
                                        "componentName": "Microsoft-Windows-Shell-Setup",
                                        "content": "zdpsub",
                                        "passName": "OobeSystem",
                                        "settingName": "AutoLogon",
                                    }
                                ],
                                "enableAutomaticUpdates": True,
                                "patchSettings": {
                                    "assessmentMode": "ImageDefault",
                                    "automaticByPlatformSettings": {
                                        "bypassPlatformSafetyChecksOnUserSchedule": True,
                                        "rebootSetting": "Unknown",
                                    },
                                    "enableHotpatching": True,
                                    "patchMode": "Manual",
                                },
                                "provisionVMAgent": True,
                                "timeZone": "kiibvtut",
                                "winRM": {
                                    "listeners": [{"certificateUrl": "https://microsoft.com/a", "protocol": "Http"}]
                                },
                            },
                        },
                        "scheduledEventsPolicy": {
                            "allInstancesDown": {"automaticallyApprove": True},
                            "scheduledEventsAdditionalPublishingTargets": {
                                "eventGridAndResourceGraph": {"enable": True, "scheduledEventsApiVersion": "sbzjonqss"}
                            },
                            "userInitiatedReboot": {"automaticallyApprove": True},
                            "userInitiatedRedeploy": {"automaticallyApprove": True},
                        },
                        "scheduledEventsProfile": {
                            "osImageNotificationProfile": {
                                "enable": True,
                                "notBeforeTimeout": "fztbudpjkicyigtvltlbszmivfbmb",
                            },
                            "terminateNotificationProfile": {"enable": True, "notBeforeTimeout": "ypif"},
                        },
                        "securityProfile": {
                            "encryptionAtHost": True,
                            "encryptionIdentity": {"userAssignedIdentityResourceId": "wkiykqbrifryaruzokophodpjig"},
                            "proxyAgentSettings": {
                                "addProxyAgentExtension": True,
                                "enabled": True,
                                "imds": {
                                    "inVMAccessControlProfileReferenceId": "cubhuucckqkxbifmertj",
                                    "mode": "Audit",
                                },
                                "keyIncarnationId": 17,
                                "mode": "Audit",
                                "wireServer": {
                                    "inVMAccessControlProfileReferenceId": "cubhuucckqkxbifmertj",
                                    "mode": "Audit",
                                },
                            },
                            "securityType": "TrustedLaunch",
                            "uefiSettings": {"secureBootEnabled": True, "vTpmEnabled": True},
                        },
                        "storageProfile": {
                            "dataDisks": [
                                {
                                    "caching": "None",
                                    "createOption": "FromImage",
                                    "deleteOption": "Delete",
                                    "detachOption": "ForceDetach",
                                    "diskSizeGB": 24,
                                    "image": {"uri": "anvtwgmfthxmyhdnbvabmzyrknxwf"},
                                    "lun": 1,
                                    "managedDisk": {
                                        "diskEncryptionSet": {"id": "thmks"},
                                        "id": "zcoqnxlomkordbdolkxraqbwgsh",
                                        "securityProfile": {
                                            "diskEncryptionSet": {"id": "thmks"},
                                            "securityEncryptionType": "VMGuestStateOnly",
                                        },
                                        "storageAccountType": "Standard_LRS",
                                    },
                                    "name": "aq",
                                    "sourceResource": {"id": "fpabycyqmkqqfdfrzqmnykmy"},
                                    "toBeDetached": True,
                                    "vhd": {"uri": "anvtwgmfthxmyhdnbvabmzyrknxwf"},
                                    "writeAcceleratorEnabled": True,
                                }
                            ],
                            "diskControllerType": "SCSI",
                            "imageReference": {
                                "communityGalleryImageId": "bysd",
                                "id": "iwqrkiccafacxfctrxb",
                                "offer": "olkxwdozixpjkjuk",
                                "publisher": "edjvbyisusjhyvnzgyvhixmnfzzsy",
                                "sharedGalleryImageId": "ahzweiez",
                                "sku": "qmsq",
                                "version": "hruassyajrafmgmub",
                            },
                            "osDisk": {
                                "caching": "None",
                                "createOption": "FromImage",
                                "deleteOption": "Delete",
                                "diffDiskSettings": {"option": "Local", "placement": "CacheDisk"},
                                "diskSizeGB": 18,
                                "encryptionSettings": {
                                    "diskEncryptionKey": {
                                        "secretUrl": "cuatfdkula",
                                        "sourceVault": {"id": "ioypuofzltakyfcomjwfkmyz"},
                                    },
                                    "enabled": True,
                                    "keyEncryptionKey": {
                                        "keyUrl": "imt",
                                        "sourceVault": {"id": "ioypuofzltakyfcomjwfkmyz"},
                                    },
                                },
                                "image": {"uri": "https://microsoft.com/a"},
                                "managedDisk": {
                                    "diskEncryptionSet": {"id": "thmks"},
                                    "id": "wuqdcyunrkewr",
                                    "securityProfile": {
                                        "diskEncryptionSet": {"id": "thmks"},
                                        "securityEncryptionType": "VMGuestStateOnly",
                                    },
                                    "storageAccountType": "Standard_LRS",
                                },
                                "name": "pccysrjeo",
                                "osType": "Windows",
                                "vhd": {"uri": "anvtwgmfthxmyhdnbvabmzyrknxwf"},
                                "writeAcceleratorEnabled": True,
                            },
                        },
                        "userData": "qcsgczwavs",
                    },
                },
                "priorityProfile": {
                    "allocationStrategy": "LowestPrice",
                    "evictionPolicy": "Delete",
                    "maxPricePerVM": 21,
                    "type": "Regular",
                },
                "retryPolicy": {"retryCount": 9, "retryWindowInMinutes": 21},
                "vmAttributes": {
                    "acceleratorCount": {"max": 0, "min": 0},
                    "acceleratorManufacturers": ["AMD"],
                    "acceleratorSupport": "Excluded",
                    "acceleratorTypes": ["GPU"],
                    "allowedVMSizes": ["dmtpdlqphckngwjhvkucfze"],
                    "architectureTypes": ["ARM64"],
                    "burstableSupport": "Excluded",
                    "cpuManufacturers": ["Intel"],
                    "dataDiskCount": {"max": 0, "min": 0},
                    "excludedVMSizes": ["yhjhharuhcyfxjnhxmflvsrdmei"],
                    "hyperVGenerations": ["Gen1"],
                    "localStorageDiskTypes": ["HDD"],
                    "localStorageInGiB": {"max": 0, "min": 0},
                    "localStorageSupport": "Excluded",
                    "memoryInGiB": {"max": 0, "min": 0},
                    "memoryInGiBPerVCpu": {"max": 0, "min": 0},
                    "networkBandwidthInMbps": {"max": 0, "min": 0},
                    "networkInterfaceCount": {"max": 0, "min": 0},
                    "rdmaNetworkInterfaceCount": {"max": 0, "min": 0},
                    "rdmaSupport": "Excluded",
                    "vCpuCount": {"max": 0, "min": 0},
                    "vmCategories": ["GeneralPurpose"],
                },
                "vmSizesProfile": [{"name": "nolktwnfqdwikqiat", "rank": 46189}],
                "zoneAllocationPolicy": {
                    "distributionStrategy": "BestEffortSingleZone",
                    "zonePreferences": [{"rank": 46292, "zone": "voauikerqjpeepaeaokkcybyjd"}],
                },
            },
            "zones": ["cyriutfcgydtaezeso"],
        },
    ).result()
    print(response)


# x-ms-original-file: 2026-02-01-preview/BulkActions_CreateOrUpdate_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
