# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, AsyncIterator, Callable, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._utils.model_base import (
    Model as _Model,
    SdkJSONEncoder,
    _deserialize,
    _failsafe_deserialize,
)
from ..._utils.serialization import Deserializer, Serializer
from ..._utils.utils import prepare_multipart_form_data
from ...operations._operations import (
    build_authentication_exchange_aad_access_token_for_acr_refresh_token_request,
    build_authentication_exchange_acr_refresh_token_for_acr_access_token_request,
    build_authentication_get_acr_access_token_from_login_request,
    build_container_registry_blob_cancel_upload_request,
    build_container_registry_blob_check_blob_exists_request,
    build_container_registry_blob_check_chunk_exists_request,
    build_container_registry_blob_complete_upload_request,
    build_container_registry_blob_delete_blob_request,
    build_container_registry_blob_get_blob_request,
    build_container_registry_blob_get_chunk_request,
    build_container_registry_blob_get_upload_status_request,
    build_container_registry_blob_mount_blob_request,
    build_container_registry_blob_start_upload_request,
    build_container_registry_blob_upload_chunk_request,
    build_container_registry_check_docker_v2_support_request,
    build_container_registry_create_manifest_request,
    build_container_registry_delete_manifest_request,
    build_container_registry_delete_repository_request,
    build_container_registry_delete_tag_request,
    build_container_registry_get_manifest_properties_request,
    build_container_registry_get_manifest_request,
    build_container_registry_get_manifests_request,
    build_container_registry_get_properties_request,
    build_container_registry_get_repositories_request,
    build_container_registry_get_tag_properties_request,
    build_container_registry_get_tags_request,
    build_container_registry_update_manifest_properties_request,
    build_container_registry_update_properties_request,
    build_container_registry_update_tag_attributes_request,
)
from .._configuration import ContainerRegistryClientConfiguration

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]


class ContainerRegistryOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.containerregistry._generated.aio.ContainerRegistryClient`'s
        :attr:`container_registry` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: ContainerRegistryClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def check_docker_v2_support(self, **kwargs: Any) -> None:
        """Tells whether this Docker Registry instance supports Docker Registry HTTP API v2.

        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_container_registry_check_docker_v2_support_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_manifest(
        self, name: str, reference: str, *, accept: Optional[str] = None, **kwargs: Any
    ) -> _models.ManifestWrapper:
        """Get the manifest identified by ``name`` and ``reference`` where ``reference`` can be
        a tag or digest.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: A tag or a digest, pointing to a specific image. Required.
        :type reference: str
        :keyword accept: Accept header string delimited by comma. For example,
         application/vnd.docker.distribution.manifest.v2+json. Default value is None.
        :paramtype accept: str
        :return: ManifestWrapper. The ManifestWrapper is compatible with MutableMapping
        :rtype: ~azure.containerregistry._generated.models.ManifestWrapper
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ManifestWrapper] = kwargs.pop("cls", None)

        _request = build_container_registry_get_manifest_request(
            name=name,
            reference=reference,
            accept=accept,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ManifestWrapper, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_manifest(
        self,
        name: str,
        reference: str,
        payload: _models.Manifest,
        *,
        content_type: str = "application/vnd.docker.distribution.manifest.v2+json",
        **kwargs: Any
    ) -> None:
        """Put the manifest identified by ``name`` and ``reference`` where ``reference`` can be
        a tag or digest.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: A tag or a digest, pointing to a specific image. Required.
        :type reference: str
        :param payload: Manifest body, can take v1 or v2 values depending on accept header. Required.
        :type payload: ~azure.containerregistry._generated.models.Manifest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/vnd.docker.distribution.manifest.v2+json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_manifest(
        self,
        name: str,
        reference: str,
        payload: JSON,
        *,
        content_type: str = "application/vnd.docker.distribution.manifest.v2+json",
        **kwargs: Any
    ) -> None:
        """Put the manifest identified by ``name`` and ``reference`` where ``reference`` can be
        a tag or digest.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: A tag or a digest, pointing to a specific image. Required.
        :type reference: str
        :param payload: Manifest body, can take v1 or v2 values depending on accept header. Required.
        :type payload: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/vnd.docker.distribution.manifest.v2+json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_manifest(
        self,
        name: str,
        reference: str,
        payload: IO[bytes],
        *,
        content_type: str = "application/vnd.docker.distribution.manifest.v2+json",
        **kwargs: Any
    ) -> None:
        """Put the manifest identified by ``name`` and ``reference`` where ``reference`` can be
        a tag or digest.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: A tag or a digest, pointing to a specific image. Required.
        :type reference: str
        :param payload: Manifest body, can take v1 or v2 values depending on accept header. Required.
        :type payload: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/vnd.docker.distribution.manifest.v2+json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_manifest(
        self, name: str, reference: str, payload: Union[_models.Manifest, JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Put the manifest identified by ``name`` and ``reference`` where ``reference`` can be
        a tag or digest.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: A tag or a digest, pointing to a specific image. Required.
        :type reference: str
        :param payload: Manifest body, can take v1 or v2 values depending on accept header. Is one of
         the following types: Manifest, JSON, IO[bytes] Required.
        :type payload: ~azure.containerregistry._generated.models.Manifest or JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/vnd.docker.distribution.manifest.v2+json"
        _content = None
        if isinstance(payload, (IOBase, bytes)):
            _content = payload
        else:
            _content = json.dumps(payload, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_container_registry_create_manifest_request(
            name=name,
            reference=reference,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
        response_headers["Content-Length"] = self._deserialize("int", response.headers.get("Content-Length"))
        response_headers["Docker-Content-Digest"] = self._deserialize(
            "str", response.headers.get("Docker-Content-Digest")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def delete_manifest(self, name: str, reference: str, **kwargs: Any) -> None:
        """Delete the manifest identified by ``name`` and ``reference``. Note that a manifest
        can *only* be deleted by ``digest``.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: Digest of a BLOB. Required.
        :type reference: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_container_registry_delete_manifest_request(
            name=name,
            reference=reference,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def get_repositories(
        self, *, last: Optional[str] = None, n: Optional[int] = None, **kwargs: Any
    ) -> AsyncItemPaged[str]:
        """List repositories.

        :keyword last: Query parameter for the last item in previous query. Result set will include
         values lexically after last. Default value is None.
        :paramtype last: str
        :keyword n: Query parameter for max number of items. Default value is None.
        :paramtype n: int
        :return: An iterator like instance of str
        :rtype: ~azure.core.async_paging.AsyncItemPaged[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[str]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_container_registry_get_repositories_request(
                    last=last,
                    n=n,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint",
                        self._config.endpoint,
                        "str",
                        skip_quote=True,
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET",
                    urllib.parse.urljoin(next_link, _parsed_next_link.path),
                    params=_next_request_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint",
                        self._config.endpoint,
                        "str",
                        skip_quote=True,
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[str], deserialized.get("repositories", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("link") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(
                    status_code=response.status_code,
                    response=response,
                    error_map=error_map,
                )
                error = _failsafe_deserialize(
                    _models.AcrErrors,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_properties(self, name: str, **kwargs: Any) -> _models.ContainerRepositoryProperties:
        """Get repository attributes.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :return: ContainerRepositoryProperties. The ContainerRepositoryProperties is compatible with
         MutableMapping
        :rtype: ~azure.containerregistry._generated.models.ContainerRepositoryProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ContainerRepositoryProperties] = kwargs.pop("cls", None)

        _request = build_container_registry_get_properties_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ContainerRepositoryProperties, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_repository(self, name: str, **kwargs: Any) -> None:
        """Delete the repository identified by ``name``.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_container_registry_delete_repository_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update_properties(
        self,
        name: str,
        value: Optional[_models.RepositoryWriteableProperties] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ContainerRepositoryProperties:
        """Update the attribute identified by ``name`` where ``reference`` is the name of the
        repository.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param value: Repository attribute value. Default value is None.
        :type value: ~azure.containerregistry._generated.models.RepositoryWriteableProperties
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ContainerRepositoryProperties. The ContainerRepositoryProperties is compatible with
         MutableMapping
        :rtype: ~azure.containerregistry._generated.models.ContainerRepositoryProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_properties(
        self, name: str, value: Optional[JSON] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.ContainerRepositoryProperties:
        """Update the attribute identified by ``name`` where ``reference`` is the name of the
        repository.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param value: Repository attribute value. Default value is None.
        :type value: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ContainerRepositoryProperties. The ContainerRepositoryProperties is compatible with
         MutableMapping
        :rtype: ~azure.containerregistry._generated.models.ContainerRepositoryProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_properties(
        self, name: str, value: Optional[IO[bytes]] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.ContainerRepositoryProperties:
        """Update the attribute identified by ``name`` where ``reference`` is the name of the
        repository.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param value: Repository attribute value. Default value is None.
        :type value: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ContainerRepositoryProperties. The ContainerRepositoryProperties is compatible with
         MutableMapping
        :rtype: ~azure.containerregistry._generated.models.ContainerRepositoryProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_properties(
        self,
        name: str,
        value: Optional[Union[_models.RepositoryWriteableProperties, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models.ContainerRepositoryProperties:
        """Update the attribute identified by ``name`` where ``reference`` is the name of the
        repository.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param value: Repository attribute value. Is one of the following types:
         RepositoryWriteableProperties, JSON, IO[bytes] Default value is None.
        :type value: ~azure.containerregistry._generated.models.RepositoryWriteableProperties or JSON
         or IO[bytes]
        :return: ContainerRepositoryProperties. The ContainerRepositoryProperties is compatible with
         MutableMapping
        :rtype: ~azure.containerregistry._generated.models.ContainerRepositoryProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if value else None
        cls: ClsType[_models.ContainerRepositoryProperties] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if value else None
        _content = None
        if isinstance(value, (IOBase, bytes)):
            _content = value
        else:
            if value is not None:
                _content = json.dumps(value, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_container_registry_update_properties_request(
            name=name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ContainerRepositoryProperties, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_tags(
        self,
        name: str,
        *,
        last: Optional[str] = None,
        n: Optional[int] = None,
        orderby: Optional[Union[str, _models.ArtifactTagOrder]] = None,
        digest: Optional[str] = None,
        **kwargs: Any
    ) -> _models.TagList:
        """List tags of a repository.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :keyword last: Query parameter for the last item in previous query. Result set will include
         values lexically after last. Default value is None.
        :paramtype last: str
        :keyword n: query parameter for max number of items. Default value is None.
        :paramtype n: int
        :keyword orderby: orderby query parameter. Known values are: "none", "timedesc", and "timeasc".
         Default value is None.
        :paramtype orderby: str or ~azure.containerregistry._generated.models.ArtifactTagOrder
        :keyword digest: filter by digest. Default value is None.
        :paramtype digest: str
        :return: TagList. The TagList is compatible with MutableMapping
        :rtype: ~azure.containerregistry._generated.models.TagList
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TagList] = kwargs.pop("cls", None)

        _request = build_container_registry_get_tags_request(
            name=name,
            last=last,
            n=n,
            orderby=orderby,
            digest=digest,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Link"] = self._deserialize("str", response.headers.get("Link"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TagList, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_tag_properties(self, name: str, reference: str, **kwargs: Any) -> _models.ArtifactTagProperties:
        """Get tag attributes by tag.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: Tag name. Required.
        :type reference: str
        :return: ArtifactTagProperties. The ArtifactTagProperties is compatible with MutableMapping
        :rtype: ~azure.containerregistry._generated.models.ArtifactTagProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ArtifactTagProperties] = kwargs.pop("cls", None)

        _request = build_container_registry_get_tag_properties_request(
            name=name,
            reference=reference,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ArtifactTagProperties, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_tag_attributes(
        self,
        name: str,
        reference: str,
        value: Optional[_models.TagWriteableProperties] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ArtifactTagProperties:
        """Update tag attributes.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: Tag name. Required.
        :type reference: str
        :param value: Tag attribute value. Default value is None.
        :type value: ~azure.containerregistry._generated.models.TagWriteableProperties
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ArtifactTagProperties. The ArtifactTagProperties is compatible with MutableMapping
        :rtype: ~azure.containerregistry._generated.models.ArtifactTagProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_tag_attributes(
        self,
        name: str,
        reference: str,
        value: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ArtifactTagProperties:
        """Update tag attributes.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: Tag name. Required.
        :type reference: str
        :param value: Tag attribute value. Default value is None.
        :type value: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ArtifactTagProperties. The ArtifactTagProperties is compatible with MutableMapping
        :rtype: ~azure.containerregistry._generated.models.ArtifactTagProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_tag_attributes(
        self,
        name: str,
        reference: str,
        value: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ArtifactTagProperties:
        """Update tag attributes.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: Tag name. Required.
        :type reference: str
        :param value: Tag attribute value. Default value is None.
        :type value: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ArtifactTagProperties. The ArtifactTagProperties is compatible with MutableMapping
        :rtype: ~azure.containerregistry._generated.models.ArtifactTagProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_tag_attributes(
        self,
        name: str,
        reference: str,
        value: Optional[Union[_models.TagWriteableProperties, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models.ArtifactTagProperties:
        """Update tag attributes.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: Tag name. Required.
        :type reference: str
        :param value: Tag attribute value. Is one of the following types: TagWriteableProperties, JSON,
         IO[bytes] Default value is None.
        :type value: ~azure.containerregistry._generated.models.TagWriteableProperties or JSON or
         IO[bytes]
        :return: ArtifactTagProperties. The ArtifactTagProperties is compatible with MutableMapping
        :rtype: ~azure.containerregistry._generated.models.ArtifactTagProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if value else None
        cls: ClsType[_models.ArtifactTagProperties] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if value else None
        _content = None
        if isinstance(value, (IOBase, bytes)):
            _content = value
        else:
            if value is not None:
                _content = json.dumps(value, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_container_registry_update_tag_attributes_request(
            name=name,
            reference=reference,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ArtifactTagProperties, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_tag(self, name: str, reference: str, **kwargs: Any) -> None:
        """Delete tag.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param reference: Tag name. Required.
        :type reference: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_container_registry_delete_tag_request(
            name=name,
            reference=reference,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_manifests(
        self,
        name: str,
        *,
        last: Optional[str] = None,
        n: Optional[int] = None,
        orderby: Optional[Union[str, _models.ArtifactManifestOrder]] = None,
        **kwargs: Any
    ) -> _models.AcrManifests:
        """List manifests of a repository.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :keyword last: Query parameter for the last item in previous query. Result set will include
         values lexically after last. Default value is None.
        :paramtype last: str
        :keyword n: query parameter for max number of items. Default value is None.
        :paramtype n: int
        :keyword orderby: orderby query parameter. Known values are: "none", "timedesc", and "timeasc".
         Default value is None.
        :paramtype orderby: str or ~azure.containerregistry._generated.models.ArtifactManifestOrder
        :return: AcrManifests. The AcrManifests is compatible with MutableMapping
        :rtype: ~azure.containerregistry._generated.models.AcrManifests
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AcrManifests] = kwargs.pop("cls", None)

        _request = build_container_registry_get_manifests_request(
            name=name,
            last=last,
            n=n,
            orderby=orderby,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Link"] = self._deserialize("str", response.headers.get("Link"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AcrManifests, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_manifest_properties(
        self, name: str, digest: str, **kwargs: Any
    ) -> _models.ArtifactManifestProperties:
        """Get manifest attributes.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :return: ArtifactManifestProperties. The ArtifactManifestProperties is compatible with
         MutableMapping
        :rtype: ~azure.containerregistry._generated.models.ArtifactManifestProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ArtifactManifestProperties] = kwargs.pop("cls", None)

        _request = build_container_registry_get_manifest_properties_request(
            name=name,
            digest=digest,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ArtifactManifestProperties, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_manifest_properties(
        self,
        name: str,
        digest: str,
        value: Optional[_models.ManifestWriteableProperties] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ArtifactManifestProperties:
        """Update properties of a manifest.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :param value: Manifest attribute value. Default value is None.
        :type value: ~azure.containerregistry._generated.models.ManifestWriteableProperties
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ArtifactManifestProperties. The ArtifactManifestProperties is compatible with
         MutableMapping
        :rtype: ~azure.containerregistry._generated.models.ArtifactManifestProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_manifest_properties(
        self,
        name: str,
        digest: str,
        value: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ArtifactManifestProperties:
        """Update properties of a manifest.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :param value: Manifest attribute value. Default value is None.
        :type value: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ArtifactManifestProperties. The ArtifactManifestProperties is compatible with
         MutableMapping
        :rtype: ~azure.containerregistry._generated.models.ArtifactManifestProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_manifest_properties(
        self,
        name: str,
        digest: str,
        value: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ArtifactManifestProperties:
        """Update properties of a manifest.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :param value: Manifest attribute value. Default value is None.
        :type value: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ArtifactManifestProperties. The ArtifactManifestProperties is compatible with
         MutableMapping
        :rtype: ~azure.containerregistry._generated.models.ArtifactManifestProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_manifest_properties(
        self,
        name: str,
        digest: str,
        value: Optional[Union[_models.ManifestWriteableProperties, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models.ArtifactManifestProperties:
        """Update properties of a manifest.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :param value: Manifest attribute value. Is one of the following types:
         ManifestWriteableProperties, JSON, IO[bytes] Default value is None.
        :type value: ~azure.containerregistry._generated.models.ManifestWriteableProperties or JSON or
         IO[bytes]
        :return: ArtifactManifestProperties. The ArtifactManifestProperties is compatible with
         MutableMapping
        :rtype: ~azure.containerregistry._generated.models.ArtifactManifestProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if value else None
        cls: ClsType[_models.ArtifactManifestProperties] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if value else None
        _content = None
        if isinstance(value, (IOBase, bytes)):
            _content = value
        else:
            if value is not None:
                _content = json.dumps(value, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_container_registry_update_manifest_properties_request(
            name=name,
            digest=digest,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ArtifactManifestProperties, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class ContainerRegistryBlobOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.containerregistry._generated.aio.ContainerRegistryClient`'s
        :attr:`container_registry_blob` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: ContainerRegistryClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get_blob(self, name: str, digest: str, **kwargs: Any) -> Optional[AsyncIterator[bytes]]:
        """Retrieve the blob from the registry identified by digest.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :return: AsyncIterator[bytes] or None
        :rtype: AsyncIterator[bytes] or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Optional[AsyncIterator[bytes]]] = kwargs.pop("cls", None)

        _request = build_container_registry_blob_get_blob_request(
            name=name,
            digest=digest,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 307]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            response_headers["Content-Length"] = self._deserialize("int", response.headers.get("Content-Length"))
            response_headers["Docker-Content-Digest"] = self._deserialize(
                "str", response.headers.get("Docker-Content-Digest")
            )

        if response.status_code == 307:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def check_blob_exists(self, name: str, digest: str, **kwargs: Any) -> bool:
        """Same as GET, except only the headers are returned.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_container_registry_blob_check_blob_exists_request(
            name=name,
            digest=digest,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 307]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        if response.status_code == 200:
            response_headers["Content-Length"] = self._deserialize("int", response.headers.get("Content-Length"))
            response_headers["Docker-Content-Digest"] = self._deserialize(
                "str", response.headers.get("Docker-Content-Digest")
            )

        if response.status_code == 307:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
        return 200 <= response.status_code <= 299

    @distributed_trace_async
    async def delete_blob(self, name: str, digest: str, **kwargs: Any) -> None:
        """Removes an already uploaded blob.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_container_registry_blob_delete_blob_request(
            name=name,
            digest=digest,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Docker-Content-Digest"] = self._deserialize(
            "str", response.headers.get("Docker-Content-Digest")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def mount_blob(self, name: str, *, from_parameter: str, mount: str, **kwargs: Any) -> None:
        """Mount a blob identified by the ``mount`` parameter from another repository.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :keyword from_parameter: Name of the source repository. Required.
        :paramtype from_parameter: str
        :keyword mount: Digest of blob to mount from the source repository. Required.
        :paramtype mount: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_container_registry_blob_mount_blob_request(
            name=name,
            from_parameter=from_parameter,
            mount=mount,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
        response_headers["Docker-Upload-UUID"] = self._deserialize("str", response.headers.get("Docker-Upload-UUID"))
        response_headers["Docker-Content-Digest"] = self._deserialize(
            "str", response.headers.get("Docker-Content-Digest")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def get_upload_status(self, next_blob_uuid_link: str, **kwargs: Any) -> None:
        """Retrieve status of upload identified by uuid. The primary purpose of this
        endpoint is to resolve the current status of a resumable upload.

        :param next_blob_uuid_link: Link acquired from upload start or previous chunk. Note, do not
         include initial
         / (must do substring(1) ). Required.
        :type next_blob_uuid_link: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_container_registry_blob_get_upload_status_request(
            next_blob_uuid_link=next_blob_uuid_link,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Range"] = self._deserialize("str", response.headers.get("Range"))
        response_headers["Docker-Upload-UUID"] = self._deserialize("str", response.headers.get("Docker-Upload-UUID"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def upload_chunk(self, next_blob_uuid_link: str, value: bytes, **kwargs: Any) -> None:
        """Upload a stream of data without completing the upload.

        :param next_blob_uuid_link: Link acquired from upload start or previous chunk. Note, do not
         include initial
         / (must do substring(1) ). Required.
        :type next_blob_uuid_link: str
        :param value: Raw data of blob. Required.
        :type value: bytes
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/octet-stream"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = value

        _request = build_container_registry_blob_upload_chunk_request(
            next_blob_uuid_link=next_blob_uuid_link,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
        response_headers["Range"] = self._deserialize("str", response.headers.get("Range"))
        response_headers["Docker-Upload-UUID"] = self._deserialize("str", response.headers.get("Docker-Upload-UUID"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def complete_upload(
        self, next_blob_uuid_link: str, value: Optional[bytes] = None, *, digest: str, **kwargs: Any
    ) -> None:
        """Complete the upload, providing all the data in the body, if necessary. A
        request without a body will just complete the upload with previously uploaded
        content.

        :param next_blob_uuid_link: Link acquired from upload start or previous chunk. Note, do not
         include initial
         / (must do substring(1) ). Required.
        :type next_blob_uuid_link: str
        :param value: Optional raw data of blob. Default value is None.
        :type value: bytes
        :keyword digest: Digest of a BLOB. Required.
        :paramtype digest: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/octet-stream")
        )
        content_type = content_type if value else None
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = value

        _request = build_container_registry_blob_complete_upload_request(
            next_blob_uuid_link=next_blob_uuid_link,
            digest=digest,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
        response_headers["Range"] = self._deserialize("str", response.headers.get("Range"))
        response_headers["Docker-Content-Digest"] = self._deserialize(
            "str", response.headers.get("Docker-Content-Digest")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def cancel_upload(self, next_blob_uuid_link: str, **kwargs: Any) -> None:
        """Cancel outstanding upload processes, releasing associated resources. If this is
        not called, the unfinished uploads will eventually timeout.

        :param next_blob_uuid_link: Link acquired from upload start or previous chunk. Note, do not
         include initial
         / (must do substring(1) ). Required.
        :type next_blob_uuid_link: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_container_registry_blob_cancel_upload_request(
            next_blob_uuid_link=next_blob_uuid_link,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def start_upload(self, name: str, **kwargs: Any) -> None:
        """Initiate a resumable blob upload with an empty request body.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_container_registry_blob_start_upload_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
        response_headers["Range"] = self._deserialize("str", response.headers.get("Range"))
        response_headers["Docker-Upload-UUID"] = self._deserialize("str", response.headers.get("Docker-Upload-UUID"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def get_chunk(self, name: str, digest: str, *, range: str, **kwargs: Any) -> AsyncIterator[bytes]:
        """Retrieve the blob from the registry identified by ``digest``. This endpoint may
        also support RFC7233 compliant range requests. Support can be detected by
        issuing a HEAD request. If the header ``Accept-Range: bytes`` is returned, range
        requests can be used to fetch partial content.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :keyword range: Format : bytes=<start>-<end>,  HTTP Range header specifying blob chunk.
         Required.
        :paramtype range: str
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_container_registry_blob_get_chunk_request(
            name=name,
            digest=digest,
            range=range,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [206]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Content-Length"] = self._deserialize("int", response.headers.get("Content-Length"))
        response_headers["Content-Range"] = self._deserialize("str", response.headers.get("Content-Range"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def check_chunk_exists(self, name: str, digest: str, *, range: str, **kwargs: Any) -> bool:
        """Same as GET, except only the headers are returned.

        :param name: Name of the image (including the namespace). Required.
        :type name: str
        :param digest: Digest of a BLOB. Required.
        :type digest: str
        :keyword range: Format : bytes=<start>-<end>,  HTTP Range header specifying blob chunk.
         Required.
        :paramtype range: str
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_container_registry_blob_check_chunk_exists_request(
            name=name,
            digest=digest,
            range=range,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Content-Length"] = self._deserialize("int", response.headers.get("Content-Length"))
        response_headers["Content-Range"] = self._deserialize("str", response.headers.get("Content-Range"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
        return 200 <= response.status_code <= 299


class AuthenticationOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.containerregistry._generated.aio.ContainerRegistryClient`'s
        :attr:`authentication` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: ContainerRegistryClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def exchange_aad_access_token_for_acr_refresh_token(  # pylint: disable=name-too-long
        self, body: _models.MultipartBodyParameter, **kwargs: Any
    ) -> _models.AcrRefreshToken:
        """Exchange AAD tokens for an ACR refresh Token.

        :param body: The body of the request. Required.
        :type body: ~azure.containerregistry._generated.models.MultipartBodyParameter
        :return: AcrRefreshToken. The AcrRefreshToken is compatible with MutableMapping
        :rtype: ~azure.containerregistry._generated.models.AcrRefreshToken
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def exchange_aad_access_token_for_acr_refresh_token(  # pylint: disable=name-too-long
        self, body: JSON, **kwargs: Any
    ) -> _models.AcrRefreshToken:
        """Exchange AAD tokens for an ACR refresh Token.

        :param body: The body of the request. Required.
        :type body: JSON
        :return: AcrRefreshToken. The AcrRefreshToken is compatible with MutableMapping
        :rtype: ~azure.containerregistry._generated.models.AcrRefreshToken
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def exchange_aad_access_token_for_acr_refresh_token(  # pylint: disable=name-too-long
        self, body: Union[_models.MultipartBodyParameter, JSON], **kwargs: Any
    ) -> _models.AcrRefreshToken:
        """Exchange AAD tokens for an ACR refresh Token.

        :param body: The body of the request. Is either a MultipartBodyParameter type or a JSON type.
         Required.
        :type body: ~azure.containerregistry._generated.models.MultipartBodyParameter or JSON
        :return: AcrRefreshToken. The AcrRefreshToken is compatible with MutableMapping
        :rtype: ~azure.containerregistry._generated.models.AcrRefreshToken
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AcrRefreshToken] = kwargs.pop("cls", None)

        _body = body.as_dict() if isinstance(body, _Model) else body
        _file_fields: list[str] = []
        _data_fields: list[str] = [
            "grantType",
            "service",
            "tenant",
            "refreshToken",
            "accessToken",
        ]
        _files = prepare_multipart_form_data(_body, _file_fields, _data_fields)

        _request = build_authentication_exchange_aad_access_token_for_acr_refresh_token_request(
            files=_files,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AcrRefreshToken, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def exchange_acr_refresh_token_for_acr_access_token(  # pylint: disable=name-too-long
        self, body: _models.MultipartBodyParameter, **kwargs: Any
    ) -> _models.AcrAccessToken:
        """Exchange ACR Refresh token for an ACR Access Token.

        :param body: The body of the request. Required.
        :type body: ~azure.containerregistry._generated.models.MultipartBodyParameter
        :return: AcrAccessToken. The AcrAccessToken is compatible with MutableMapping
        :rtype: ~azure.containerregistry._generated.models.AcrAccessToken
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def exchange_acr_refresh_token_for_acr_access_token(  # pylint: disable=name-too-long
        self, body: JSON, **kwargs: Any
    ) -> _models.AcrAccessToken:
        """Exchange ACR Refresh token for an ACR Access Token.

        :param body: The body of the request. Required.
        :type body: JSON
        :return: AcrAccessToken. The AcrAccessToken is compatible with MutableMapping
        :rtype: ~azure.containerregistry._generated.models.AcrAccessToken
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def exchange_acr_refresh_token_for_acr_access_token(  # pylint: disable=name-too-long
        self, body: Union[_models.MultipartBodyParameter, JSON], **kwargs: Any
    ) -> _models.AcrAccessToken:
        """Exchange ACR Refresh token for an ACR Access Token.

        :param body: The body of the request. Is either a MultipartBodyParameter type or a JSON type.
         Required.
        :type body: ~azure.containerregistry._generated.models.MultipartBodyParameter or JSON
        :return: AcrAccessToken. The AcrAccessToken is compatible with MutableMapping
        :rtype: ~azure.containerregistry._generated.models.AcrAccessToken
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AcrAccessToken] = kwargs.pop("cls", None)

        _body = body.as_dict() if isinstance(body, _Model) else body
        _file_fields: list[str] = []
        _data_fields: list[str] = [
            "grantType",
            "service",
            "tenant",
            "refreshToken",
            "accessToken",
        ]
        _files = prepare_multipart_form_data(_body, _file_fields, _data_fields)

        _request = build_authentication_exchange_acr_refresh_token_for_acr_access_token_request(
            files=_files,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AcrAccessToken, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_acr_access_token_from_login(
        self, *, service: str, scope: str, **kwargs: Any
    ) -> _models.AcrAccessToken:
        """Exchange Username, Password and Scope for an ACR Access Token.

        :keyword service: Indicates the name of your Azure container registry. Required.
        :paramtype service: str
        :keyword scope: Expected to be a valid scope, and can be specified more than once for multiple
         scope requests. You can obtain this from the Www-Authenticate response header
         from the challenge. Required.
        :paramtype scope: str
        :return: AcrAccessToken. The AcrAccessToken is compatible with MutableMapping
        :rtype: ~azure.containerregistry._generated.models.AcrAccessToken
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AcrAccessToken] = kwargs.pop("cls", None)

        _request = build_authentication_get_acr_access_token_from_login_request(
            service=service,
            scope=scope,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.AcrErrors,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AcrAccessToken, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
