# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import StepType

if TYPE_CHECKING:
    from .. import models as _models


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerregistrytasks.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerregistrytasks.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgentPool(TrackedResource):
    """The agentpool that has the ARM resource and properties.
    The agentpool will have all information to create an agent pool.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerregistrytasks.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The properties associated with the agent pool.
    :vartype properties: ~azure.mgmt.containerregistrytasks.models.AgentPoolProperties
    """

    properties: Optional["_models.AgentPoolProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties associated with the agent pool."""

    __flattened_items = ["count", "tier", "os", "virtual_network_subnet_resource_id", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.AgentPoolProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class AgentPoolProperties(_Model):
    """The properties of agent pool.

    :ivar count: The count of agent machine.
    :vartype count: int
    :ivar tier: The Tier of agent machine.
    :vartype tier: str
    :ivar os: The OS of agent machine. Known values are: "Windows" and "Linux".
    :vartype os: str or ~azure.mgmt.containerregistrytasks.models.OS
    :ivar virtual_network_subnet_resource_id: The Virtual Network Subnet Resource Id of the agent
     machine.
    :vartype virtual_network_subnet_resource_id: str
    :ivar provisioning_state: The provisioning state of this agent pool. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.containerregistrytasks.models.ProvisioningState
    """

    count: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The count of agent machine."""
    tier: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Tier of agent machine."""
    os: Optional[Union[str, "_models.OS"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The OS of agent machine. Known values are: \"Windows\" and \"Linux\"."""
    virtual_network_subnet_resource_id: Optional[str] = rest_field(
        name="virtualNetworkSubnetResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Virtual Network Subnet Resource Id of the agent machine."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of this agent pool. Known values are: \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        count: Optional[int] = None,
        tier: Optional[str] = None,
        os: Optional[Union[str, "_models.OS"]] = None,
        virtual_network_subnet_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgentPoolPropertiesUpdateParameters(_Model):
    """AgentPoolPropertiesUpdateParameters.

    :ivar count: The count of agent machine.
    :vartype count: int
    """

    count: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The count of agent machine."""

    @overload
    def __init__(
        self,
        *,
        count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgentPoolQueueStatus(_Model):
    """The QueueStatus of Agent Pool.

    :ivar count: The number of pending runs in the queue.
    :vartype count: int
    """

    count: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of pending runs in the queue."""

    @overload
    def __init__(
        self,
        *,
        count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgentPoolUpdateParameters(_Model):
    """The parameters for updating an agent pool.

    :ivar properties: The properties associated with the agent pool.
    :vartype properties:
     ~azure.mgmt.containerregistrytasks.models.AgentPoolPropertiesUpdateParameters
    :ivar tags: The ARM resource tags.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.AgentPoolPropertiesUpdateParameters"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties associated with the agent pool."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ARM resource tags."""

    __flattened_items = ["count"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AgentPoolPropertiesUpdateParameters"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class AgentProperties(_Model):
    """The properties that determine the run agent configuration.

    :ivar cpu: The CPU configuration in terms of number of cores required for the run.
    :vartype cpu: int
    """

    cpu: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The CPU configuration in terms of number of cores required for the run."""

    @overload
    def __init__(
        self,
        *,
        cpu: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Argument(_Model):
    """The properties of a run argument.

    :ivar name: The name of the argument. Required.
    :vartype name: str
    :ivar value: The value of the argument. Required.
    :vartype value: str
    :ivar is_secret: Flag to indicate whether the argument represents a secret and want to be
     removed from build logs.
    :vartype is_secret: bool
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the argument. Required."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the argument. Required."""
    is_secret: Optional[bool] = rest_field(name="isSecret", visibility=["read", "create", "update", "delete", "query"])
    """Flag to indicate whether the argument represents a secret and want to be removed from build
     logs."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        value: str,
        is_secret: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AuthInfo(_Model):
    """The authorization properties for accessing the source code repository.

    :ivar token_type: The type of Auth token. Required. Known values are: "PAT" and "OAuth".
    :vartype token_type: str or ~azure.mgmt.containerregistrytasks.models.TokenType
    :ivar token: The access token used to access the source control provider. Required.
    :vartype token: str
    :ivar refresh_token: The refresh token used to refresh the access token.
    :vartype refresh_token: str
    :ivar scope: The scope of the access token.
    :vartype scope: str
    :ivar expires_in: Time in seconds that the token remains valid.
    :vartype expires_in: int
    """

    token_type: Union[str, "_models.TokenType"] = rest_field(
        name="tokenType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of Auth token. Required. Known values are: \"PAT\" and \"OAuth\"."""
    token: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The access token used to access the source control provider. Required."""
    refresh_token: Optional[str] = rest_field(
        name="refreshToken", visibility=["read", "create", "update", "delete", "query"]
    )
    """The refresh token used to refresh the access token."""
    scope: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The scope of the access token."""
    expires_in: Optional[int] = rest_field(name="expiresIn", visibility=["read", "create", "update", "delete", "query"])
    """Time in seconds that the token remains valid."""

    @overload
    def __init__(
        self,
        *,
        token_type: Union[str, "_models.TokenType"],
        token: str,
        refresh_token: Optional[str] = None,
        scope: Optional[str] = None,
        expires_in: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AuthInfoUpdateParameters(_Model):
    """The authorization properties for accessing the source code repository.

    :ivar token_type: The type of Auth token. Known values are: "PAT" and "OAuth".
    :vartype token_type: str or ~azure.mgmt.containerregistrytasks.models.TokenType
    :ivar token: The access token used to access the source control provider.
    :vartype token: str
    :ivar refresh_token: The refresh token used to refresh the access token.
    :vartype refresh_token: str
    :ivar scope: The scope of the access token.
    :vartype scope: str
    :ivar expires_in: Time in seconds that the token remains valid.
    :vartype expires_in: int
    """

    token_type: Optional[Union[str, "_models.TokenType"]] = rest_field(
        name="tokenType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of Auth token. Known values are: \"PAT\" and \"OAuth\"."""
    token: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The access token used to access the source control provider."""
    refresh_token: Optional[str] = rest_field(
        name="refreshToken", visibility=["read", "create", "update", "delete", "query"]
    )
    """The refresh token used to refresh the access token."""
    scope: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The scope of the access token."""
    expires_in: Optional[int] = rest_field(name="expiresIn", visibility=["read", "create", "update", "delete", "query"])
    """Time in seconds that the token remains valid."""

    @overload
    def __init__(
        self,
        *,
        token_type: Optional[Union[str, "_models.TokenType"]] = None,
        token: Optional[str] = None,
        refresh_token: Optional[str] = None,
        scope: Optional[str] = None,
        expires_in: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BaseImageDependency(_Model):
    """Properties that describe a base image dependency.

    :ivar type: The type of the base image dependency. Known values are: "BuildTime" and "RunTime".
    :vartype type: str or ~azure.mgmt.containerregistrytasks.models.BaseImageDependencyType
    :ivar registry: The registry login server.
    :vartype registry: str
    :ivar repository: The repository name.
    :vartype repository: str
    :ivar tag: The tag name.
    :vartype tag: str
    :ivar digest: The sha256-based digest of the image manifest.
    :vartype digest: str
    """

    type: Optional[Union[str, "_models.BaseImageDependencyType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the base image dependency. Known values are: \"BuildTime\" and \"RunTime\"."""
    registry: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The registry login server."""
    repository: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The repository name."""
    tag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tag name."""
    digest: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sha256-based digest of the image manifest."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.BaseImageDependencyType"]] = None,
        registry: Optional[str] = None,
        repository: Optional[str] = None,
        tag: Optional[str] = None,
        digest: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BaseImageTrigger(_Model):
    """The trigger based on base image dependency.

    :ivar base_image_trigger_type: The type of the auto trigger for base image dependency updates.
     Required. Known values are: "All" and "Runtime".
    :vartype base_image_trigger_type: str or
     ~azure.mgmt.containerregistrytasks.models.BaseImageTriggerType
    :ivar update_trigger_endpoint: The endpoint URL for receiving update triggers.
    :vartype update_trigger_endpoint: str
    :ivar update_trigger_payload_type: Type of Payload body for Base image update triggers. Known
     values are: "Default" and "Token".
    :vartype update_trigger_payload_type: str or
     ~azure.mgmt.containerregistrytasks.models.UpdateTriggerPayloadType
    :ivar status: The current status of trigger. Known values are: "Disabled" and "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistrytasks.models.TriggerStatus
    :ivar name: The name of the trigger. Required.
    :vartype name: str
    """

    base_image_trigger_type: Union[str, "_models.BaseImageTriggerType"] = rest_field(
        name="baseImageTriggerType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the auto trigger for base image dependency updates. Required. Known values are:
     \"All\" and \"Runtime\"."""
    update_trigger_endpoint: Optional[str] = rest_field(
        name="updateTriggerEndpoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """The endpoint URL for receiving update triggers."""
    update_trigger_payload_type: Optional[Union[str, "_models.UpdateTriggerPayloadType"]] = rest_field(
        name="updateTriggerPayloadType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of Payload body for Base image update triggers. Known values are: \"Default\" and
     \"Token\"."""
    status: Optional[Union[str, "_models.TriggerStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The current status of trigger. Known values are: \"Disabled\" and \"Enabled\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the trigger. Required."""

    @overload
    def __init__(
        self,
        *,
        base_image_trigger_type: Union[str, "_models.BaseImageTriggerType"],
        name: str,
        update_trigger_endpoint: Optional[str] = None,
        update_trigger_payload_type: Optional[Union[str, "_models.UpdateTriggerPayloadType"]] = None,
        status: Optional[Union[str, "_models.TriggerStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BaseImageTriggerUpdateParameters(_Model):
    """The properties for updating base image dependency trigger.

    :ivar base_image_trigger_type: The type of the auto trigger for base image dependency updates.
     Known values are: "All" and "Runtime".
    :vartype base_image_trigger_type: str or
     ~azure.mgmt.containerregistrytasks.models.BaseImageTriggerType
    :ivar update_trigger_endpoint: The endpoint URL for receiving update triggers.
    :vartype update_trigger_endpoint: str
    :ivar update_trigger_payload_type: Type of Payload body for Base image update triggers. Known
     values are: "Default" and "Token".
    :vartype update_trigger_payload_type: str or
     ~azure.mgmt.containerregistrytasks.models.UpdateTriggerPayloadType
    :ivar status: The current status of trigger. Known values are: "Disabled" and "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistrytasks.models.TriggerStatus
    :ivar name: The name of the trigger. Required.
    :vartype name: str
    """

    base_image_trigger_type: Optional[Union[str, "_models.BaseImageTriggerType"]] = rest_field(
        name="baseImageTriggerType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the auto trigger for base image dependency updates. Known values are: \"All\" and
     \"Runtime\"."""
    update_trigger_endpoint: Optional[str] = rest_field(
        name="updateTriggerEndpoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """The endpoint URL for receiving update triggers."""
    update_trigger_payload_type: Optional[Union[str, "_models.UpdateTriggerPayloadType"]] = rest_field(
        name="updateTriggerPayloadType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of Payload body for Base image update triggers. Known values are: \"Default\" and
     \"Token\"."""
    status: Optional[Union[str, "_models.TriggerStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The current status of trigger. Known values are: \"Disabled\" and \"Enabled\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the trigger. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        base_image_trigger_type: Optional[Union[str, "_models.BaseImageTriggerType"]] = None,
        update_trigger_endpoint: Optional[str] = None,
        update_trigger_payload_type: Optional[Union[str, "_models.UpdateTriggerPayloadType"]] = None,
        status: Optional[Union[str, "_models.TriggerStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Credentials(_Model):
    """The parameters that describes a set of credentials that will be used when a run is invoked.

    :ivar source_registry: Describes the credential parameters for accessing the source registry.
    :vartype source_registry: ~azure.mgmt.containerregistrytasks.models.SourceRegistryCredentials
    :ivar custom_registries: Describes the credential parameters for accessing other custom
     registries. The key
     for the dictionary item will be the registry login server (myregistry.azurecr.io) and
     the value of the item will be the registry credentials for accessing the registry.
    :vartype custom_registries: dict[str,
     ~azure.mgmt.containerregistrytasks.models.CustomRegistryCredentials]
    """

    source_registry: Optional["_models.SourceRegistryCredentials"] = rest_field(
        name="sourceRegistry", visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes the credential parameters for accessing the source registry."""
    custom_registries: Optional[dict[str, "_models.CustomRegistryCredentials"]] = rest_field(
        name="customRegistries", visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes the credential parameters for accessing other custom registries. The key
     for the dictionary item will be the registry login server (myregistry.azurecr.io) and
     the value of the item will be the registry credentials for accessing the registry."""

    @overload
    def __init__(
        self,
        *,
        source_registry: Optional["_models.SourceRegistryCredentials"] = None,
        custom_registries: Optional[dict[str, "_models.CustomRegistryCredentials"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomRegistryCredentials(_Model):
    """Describes the credentials that will be used to access a custom registry during a run.

    :ivar user_name: The username for logging into the custom registry.
    :vartype user_name: ~azure.mgmt.containerregistrytasks.models.SecretObject
    :ivar password: The password for logging into the custom registry. The password is a secret
     object that allows multiple ways of providing the value for it.
    :vartype password: ~azure.mgmt.containerregistrytasks.models.SecretObject
    :ivar identity: Indicates the managed identity assigned to the custom credential. If a
     user-assigned identity
     this value is the Client ID. If a system-assigned identity, the value will be ``system``. In
     the case of a system-assigned identity, the Client ID will be determined by the runner. This
     identity may be used to authenticate to key vault to retrieve credentials or it may be the only
     source of authentication used for accessing the registry.
    :vartype identity: str
    """

    user_name: Optional["_models.SecretObject"] = rest_field(
        name="userName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The username for logging into the custom registry."""
    password: Optional["_models.SecretObject"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The password for logging into the custom registry. The password is a secret
     object that allows multiple ways of providing the value for it."""
    identity: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates the managed identity assigned to the custom credential. If a user-assigned identity
     this value is the Client ID. If a system-assigned identity, the value will be ``system``. In
     the case of a system-assigned identity, the Client ID will be determined by the runner. This
     identity may be used to authenticate to key vault to retrieve credentials or it may be the only
     source of authentication used for accessing the registry."""

    @overload
    def __init__(
        self,
        *,
        user_name: Optional["_models.SecretObject"] = None,
        password: Optional["_models.SecretObject"] = None,
        identity: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RunRequest(_Model):
    """The request parameters for scheduling a run.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DockerBuildRequest, EncodedTaskRunRequest, FileTaskRunRequest, TaskRunRequest

    :ivar type: The type of the run request. Required. Default value is None.
    :vartype type: str
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :vartype is_archive_enabled: bool
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of the run request. Required. Default value is None."""
    is_archive_enabled: Optional[bool] = rest_field(
        name="isArchiveEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """The value that indicates whether archiving is enabled for the run or not."""
    agent_pool_name: Optional[str] = rest_field(
        name="agentPoolName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The dedicated agent pool for the run."""
    log_template: Optional[str] = rest_field(
        name="logTemplate", visibility=["read", "create", "update", "delete", "query"]
    )
    """The template that describes the repository and tag information for run log artifact."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        is_archive_enabled: Optional[bool] = None,
        agent_pool_name: Optional[str] = None,
        log_template: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DockerBuildRequest(RunRequest, discriminator="DockerBuildRequest"):
    """The parameters for a docker quick build.

    :ivar is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :vartype is_archive_enabled: bool
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    :ivar image_names: The fully qualified image names including the repository and tag.
    :vartype image_names: list[str]
    :ivar is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :vartype is_push_enabled: bool
    :ivar no_cache: The value of this property indicates whether the image cache is enabled or not.
    :vartype no_cache: bool
    :ivar docker_file_path: The Docker file path relative to the source location. Required.
    :vartype docker_file_path: str
    :ivar target: The name of the target build stage for the docker build.
    :vartype target: str
    :ivar arguments: The collection of override arguments to be used when executing the run.
    :vartype arguments: list[~azure.mgmt.containerregistrytasks.models.Argument]
    :ivar timeout: Run timeout in seconds.
    :vartype timeout: int
    :ivar platform: The platform properties against which the run has to happen. Required.
    :vartype platform: ~azure.mgmt.containerregistrytasks.models.PlatformProperties
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration: ~azure.mgmt.containerregistrytasks.models.AgentProperties
    :ivar source_location: The URL(absolute or relative) of the source context. It can be an URL to
     a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :vartype source_location: str
    :ivar credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :vartype credentials: ~azure.mgmt.containerregistrytasks.models.Credentials
    :ivar type: The type of the run request. Required. Default value is "DockerBuildRequest".
    :vartype type: str
    """

    image_names: Optional[list[str]] = rest_field(
        name="imageNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The fully qualified image names including the repository and tag."""
    is_push_enabled: Optional[bool] = rest_field(
        name="isPushEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """The value of this property indicates whether the image built should be pushed to the registry
     or not."""
    no_cache: Optional[bool] = rest_field(name="noCache", visibility=["read", "create", "update", "delete", "query"])
    """The value of this property indicates whether the image cache is enabled or not."""
    docker_file_path: str = rest_field(
        name="dockerFilePath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Docker file path relative to the source location. Required."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the target build stage for the docker build."""
    arguments: Optional[list["_models.Argument"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of override arguments to be used when executing the run."""
    timeout: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Run timeout in seconds."""
    platform: "_models.PlatformProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The platform properties against which the run has to happen. Required."""
    agent_configuration: Optional["_models.AgentProperties"] = rest_field(
        name="agentConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The machine configuration of the run agent."""
    source_location: Optional[str] = rest_field(
        name="sourceLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URL(absolute or relative) of the source context. It can be an URL to a tar or git
     repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API."""
    credentials: Optional["_models.Credentials"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties that describes a set of credentials that will be used when this run is invoked."""
    type: Literal["DockerBuildRequest"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the run request. Required. Default value is \"DockerBuildRequest\"."""

    @overload
    def __init__(
        self,
        *,
        docker_file_path: str,
        platform: "_models.PlatformProperties",
        is_archive_enabled: Optional[bool] = None,
        agent_pool_name: Optional[str] = None,
        log_template: Optional[str] = None,
        image_names: Optional[list[str]] = None,
        is_push_enabled: Optional[bool] = None,
        no_cache: Optional[bool] = None,
        target: Optional[str] = None,
        arguments: Optional[list["_models.Argument"]] = None,
        timeout: Optional[int] = None,
        agent_configuration: Optional["_models.AgentProperties"] = None,
        source_location: Optional[str] = None,
        credentials: Optional["_models.Credentials"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = "DockerBuildRequest"  # type: ignore


class TaskStepProperties(_Model):
    """Base properties for any task step.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DockerBuildStep, EncodedTaskStep, FileTaskStep

    :ivar type: The type of the step. Required. Known values are: "Docker", "FileTask", and
     "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistrytasks.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistrytasks.models.BaseImageDependency]
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of the step. Required. Known values are: \"Docker\", \"FileTask\", and
     \"EncodedTask\"."""
    base_image_dependencies: Optional[list["_models.BaseImageDependency"]] = rest_field(
        name="baseImageDependencies", visibility=["read"]
    )
    """List of base image dependencies for a step."""
    context_path: Optional[str] = rest_field(
        name="contextPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URL(absolute or relative) of the source context for the task step."""
    context_access_token: Optional[str] = rest_field(
        name="contextAccessToken", visibility=["read", "create", "update", "delete", "query"]
    )
    """The token (git PAT or SAS token of storage account blob) associated with the context for a
     step."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DockerBuildStep(TaskStepProperties, discriminator="Docker"):
    """The Docker build step.

    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistrytasks.models.BaseImageDependency]
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar image_names: The fully qualified image names including the repository and tag.
    :vartype image_names: list[str]
    :ivar is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :vartype is_push_enabled: bool
    :ivar no_cache: The value of this property indicates whether the image cache is enabled or not.
    :vartype no_cache: bool
    :ivar docker_file_path: The Docker file path relative to the source context. Required.
    :vartype docker_file_path: str
    :ivar target: The name of the target build stage for the docker build.
    :vartype target: str
    :ivar arguments: The collection of override arguments to be used when executing this build
     step.
    :vartype arguments: list[~azure.mgmt.containerregistrytasks.models.Argument]
    :ivar type: The type of the step. Required.
    :vartype type: str or ~azure.mgmt.containerregistrytasks.models.DOCKER
    """

    image_names: Optional[list[str]] = rest_field(
        name="imageNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The fully qualified image names including the repository and tag."""
    is_push_enabled: Optional[bool] = rest_field(
        name="isPushEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """The value of this property indicates whether the image built should be pushed to the registry
     or not."""
    no_cache: Optional[bool] = rest_field(name="noCache", visibility=["read", "create", "update", "delete", "query"])
    """The value of this property indicates whether the image cache is enabled or not."""
    docker_file_path: str = rest_field(
        name="dockerFilePath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Docker file path relative to the source context. Required."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the target build stage for the docker build."""
    arguments: Optional[list["_models.Argument"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of override arguments to be used when executing this build step."""
    type: Literal[StepType.DOCKER] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the step. Required."""

    @overload
    def __init__(
        self,
        *,
        docker_file_path: str,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        image_names: Optional[list[str]] = None,
        is_push_enabled: Optional[bool] = None,
        no_cache: Optional[bool] = None,
        target: Optional[str] = None,
        arguments: Optional[list["_models.Argument"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = StepType.DOCKER  # type: ignore


class TaskStepUpdateParameters(_Model):
    """Base properties for updating any task step.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DockerBuildStepUpdateParameters, EncodedTaskStepUpdateParameters, FileTaskStepUpdateParameters

    :ivar type: The type of the step. Required. Known values are: "Docker", "FileTask", and
     "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistrytasks.models.StepType
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of the step. Required. Known values are: \"Docker\", \"FileTask\", and
     \"EncodedTask\"."""
    context_path: Optional[str] = rest_field(
        name="contextPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URL(absolute or relative) of the source context for the task step."""
    context_access_token: Optional[str] = rest_field(
        name="contextAccessToken", visibility=["read", "create", "update", "delete", "query"]
    )
    """The token (git PAT or SAS token of storage account blob) associated with the context for a
     step."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DockerBuildStepUpdateParameters(TaskStepUpdateParameters, discriminator="Docker"):
    """The properties for updating a docker build step.

    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar image_names: The fully qualified image names including the repository and tag.
    :vartype image_names: list[str]
    :ivar is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :vartype is_push_enabled: bool
    :ivar no_cache: The value of this property indicates whether the image cache is enabled or not.
    :vartype no_cache: bool
    :ivar docker_file_path: The Docker file path relative to the source context.
    :vartype docker_file_path: str
    :ivar arguments: The collection of override arguments to be used when executing this build
     step.
    :vartype arguments: list[~azure.mgmt.containerregistrytasks.models.Argument]
    :ivar target: The name of the target build stage for the docker build.
    :vartype target: str
    :ivar type: The type of the step. Required.
    :vartype type: str or ~azure.mgmt.containerregistrytasks.models.DOCKER
    """

    image_names: Optional[list[str]] = rest_field(
        name="imageNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The fully qualified image names including the repository and tag."""
    is_push_enabled: Optional[bool] = rest_field(
        name="isPushEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """The value of this property indicates whether the image built should be pushed to the registry
     or not."""
    no_cache: Optional[bool] = rest_field(name="noCache", visibility=["read", "create", "update", "delete", "query"])
    """The value of this property indicates whether the image cache is enabled or not."""
    docker_file_path: Optional[str] = rest_field(
        name="dockerFilePath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Docker file path relative to the source context."""
    arguments: Optional[list["_models.Argument"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of override arguments to be used when executing this build step."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the target build stage for the docker build."""
    type: Literal[StepType.DOCKER] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the step. Required."""

    @overload
    def __init__(
        self,
        *,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        image_names: Optional[list[str]] = None,
        is_push_enabled: Optional[bool] = None,
        no_cache: Optional[bool] = None,
        docker_file_path: Optional[str] = None,
        arguments: Optional[list["_models.Argument"]] = None,
        target: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = StepType.DOCKER  # type: ignore


class EncodedTaskRunRequest(RunRequest, discriminator="EncodedTaskRunRequest"):
    """The parameters for a quick task run request.

    :ivar is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :vartype is_archive_enabled: bool
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    :ivar encoded_task_content: Base64 encoded value of the template/definition file content.
     Required.
    :vartype encoded_task_content: str
    :ivar encoded_values_content: Base64 encoded value of the parameters/values file content.
    :vartype encoded_values_content: str
    :ivar values_property: The collection of overridable values that can be passed when running a
     task.
    :vartype values_property: list[~azure.mgmt.containerregistrytasks.models.SetValue]
    :ivar timeout: Run timeout in seconds.
    :vartype timeout: int
    :ivar platform: The platform properties against which the run has to happen. Required.
    :vartype platform: ~azure.mgmt.containerregistrytasks.models.PlatformProperties
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration: ~azure.mgmt.containerregistrytasks.models.AgentProperties
    :ivar source_location: The URL(absolute or relative) of the source context. It can be an URL to
     a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :vartype source_location: str
    :ivar credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :vartype credentials: ~azure.mgmt.containerregistrytasks.models.Credentials
    :ivar type: The type of the run request. Required. Default value is "EncodedTaskRunRequest".
    :vartype type: str
    """

    encoded_task_content: str = rest_field(
        name="encodedTaskContent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Base64 encoded value of the template/definition file content. Required."""
    encoded_values_content: Optional[str] = rest_field(
        name="encodedValuesContent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Base64 encoded value of the parameters/values file content."""
    values_property: Optional[list["_models.SetValue"]] = rest_field(
        name="values", visibility=["read", "create", "update", "delete", "query"], original_tsp_name="values"
    )
    """The collection of overridable values that can be passed when running a task."""
    timeout: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Run timeout in seconds."""
    platform: "_models.PlatformProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The platform properties against which the run has to happen. Required."""
    agent_configuration: Optional["_models.AgentProperties"] = rest_field(
        name="agentConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The machine configuration of the run agent."""
    source_location: Optional[str] = rest_field(
        name="sourceLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URL(absolute or relative) of the source context. It can be an URL to a tar or git
     repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API."""
    credentials: Optional["_models.Credentials"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties that describes a set of credentials that will be used when this run is invoked."""
    type: Literal["EncodedTaskRunRequest"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the run request. Required. Default value is \"EncodedTaskRunRequest\"."""

    @overload
    def __init__(
        self,
        *,
        encoded_task_content: str,
        platform: "_models.PlatformProperties",
        is_archive_enabled: Optional[bool] = None,
        agent_pool_name: Optional[str] = None,
        log_template: Optional[str] = None,
        encoded_values_content: Optional[str] = None,
        values_property: Optional[list["_models.SetValue"]] = None,
        timeout: Optional[int] = None,
        agent_configuration: Optional["_models.AgentProperties"] = None,
        source_location: Optional[str] = None,
        credentials: Optional["_models.Credentials"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = "EncodedTaskRunRequest"  # type: ignore


class EncodedTaskStep(TaskStepProperties, discriminator="EncodedTask"):
    """The properties of a encoded task step.

    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistrytasks.models.BaseImageDependency]
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar encoded_task_content: Base64 encoded value of the template/definition file content.
     Required.
    :vartype encoded_task_content: str
    :ivar encoded_values_content: Base64 encoded value of the parameters/values file content.
    :vartype encoded_values_content: str
    :ivar values_property: The collection of overridable values that can be passed when running a
     task.
    :vartype values_property: list[~azure.mgmt.containerregistrytasks.models.SetValue]
    :ivar type: The type of the step. Required.
    :vartype type: str or ~azure.mgmt.containerregistrytasks.models.ENCODED_TASK
    """

    encoded_task_content: str = rest_field(
        name="encodedTaskContent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Base64 encoded value of the template/definition file content. Required."""
    encoded_values_content: Optional[str] = rest_field(
        name="encodedValuesContent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Base64 encoded value of the parameters/values file content."""
    values_property: Optional[list["_models.SetValue"]] = rest_field(
        name="values", visibility=["read", "create", "update", "delete", "query"], original_tsp_name="values"
    )
    """The collection of overridable values that can be passed when running a task."""
    type: Literal[StepType.ENCODED_TASK] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the step. Required."""

    @overload
    def __init__(
        self,
        *,
        encoded_task_content: str,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        encoded_values_content: Optional[str] = None,
        values_property: Optional[list["_models.SetValue"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = StepType.ENCODED_TASK  # type: ignore


class EncodedTaskStepUpdateParameters(TaskStepUpdateParameters, discriminator="EncodedTask"):
    """The properties for updating encoded task step.

    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar encoded_task_content: Base64 encoded value of the template/definition file content.
    :vartype encoded_task_content: str
    :ivar encoded_values_content: Base64 encoded value of the parameters/values file content.
    :vartype encoded_values_content: str
    :ivar values_property: The collection of overridable values that can be passed when running a
     task.
    :vartype values_property: list[~azure.mgmt.containerregistrytasks.models.SetValue]
    :ivar type: The type of the step. Required.
    :vartype type: str or ~azure.mgmt.containerregistrytasks.models.ENCODED_TASK
    """

    encoded_task_content: Optional[str] = rest_field(
        name="encodedTaskContent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Base64 encoded value of the template/definition file content."""
    encoded_values_content: Optional[str] = rest_field(
        name="encodedValuesContent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Base64 encoded value of the parameters/values file content."""
    values_property: Optional[list["_models.SetValue"]] = rest_field(
        name="values", visibility=["read", "create", "update", "delete", "query"], original_tsp_name="values"
    )
    """The collection of overridable values that can be passed when running a task."""
    type: Literal[StepType.ENCODED_TASK] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the step. Required."""

    @overload
    def __init__(
        self,
        *,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        encoded_task_content: Optional[str] = None,
        encoded_values_content: Optional[str] = None,
        values_property: Optional[list["_models.SetValue"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = StepType.ENCODED_TASK  # type: ignore


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.containerregistrytasks.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.containerregistrytasks.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.containerregistrytasks.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FileTaskRunRequest(RunRequest, discriminator="FileTaskRunRequest"):
    """The request parameters for a scheduling run against a task file.

    :ivar is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :vartype is_archive_enabled: bool
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    :ivar task_file_path: The template/definition file path relative to the source. Required.
    :vartype task_file_path: str
    :ivar values_file_path: The values/parameters file path relative to the source.
    :vartype values_file_path: str
    :ivar values_property: The collection of overridable values that can be passed when running a
     task.
    :vartype values_property: list[~azure.mgmt.containerregistrytasks.models.SetValue]
    :ivar timeout: Run timeout in seconds.
    :vartype timeout: int
    :ivar platform: The platform properties against which the run has to happen. Required.
    :vartype platform: ~azure.mgmt.containerregistrytasks.models.PlatformProperties
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration: ~azure.mgmt.containerregistrytasks.models.AgentProperties
    :ivar source_location: The URL(absolute or relative) of the source context. It can be an URL to
     a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :vartype source_location: str
    :ivar credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :vartype credentials: ~azure.mgmt.containerregistrytasks.models.Credentials
    :ivar type: The type of the run request. Required. Default value is "FileTaskRunRequest".
    :vartype type: str
    """

    task_file_path: str = rest_field(name="taskFilePath", visibility=["read", "create", "update", "delete", "query"])
    """The template/definition file path relative to the source. Required."""
    values_file_path: Optional[str] = rest_field(
        name="valuesFilePath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The values/parameters file path relative to the source."""
    values_property: Optional[list["_models.SetValue"]] = rest_field(
        name="values", visibility=["read", "create", "update", "delete", "query"], original_tsp_name="values"
    )
    """The collection of overridable values that can be passed when running a task."""
    timeout: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Run timeout in seconds."""
    platform: "_models.PlatformProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The platform properties against which the run has to happen. Required."""
    agent_configuration: Optional["_models.AgentProperties"] = rest_field(
        name="agentConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The machine configuration of the run agent."""
    source_location: Optional[str] = rest_field(
        name="sourceLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URL(absolute or relative) of the source context. It can be an URL to a tar or git
     repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API."""
    credentials: Optional["_models.Credentials"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties that describes a set of credentials that will be used when this run is invoked."""
    type: Literal["FileTaskRunRequest"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the run request. Required. Default value is \"FileTaskRunRequest\"."""

    @overload
    def __init__(
        self,
        *,
        task_file_path: str,
        platform: "_models.PlatformProperties",
        is_archive_enabled: Optional[bool] = None,
        agent_pool_name: Optional[str] = None,
        log_template: Optional[str] = None,
        values_file_path: Optional[str] = None,
        values_property: Optional[list["_models.SetValue"]] = None,
        timeout: Optional[int] = None,
        agent_configuration: Optional["_models.AgentProperties"] = None,
        source_location: Optional[str] = None,
        credentials: Optional["_models.Credentials"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = "FileTaskRunRequest"  # type: ignore


class FileTaskStep(TaskStepProperties, discriminator="FileTask"):
    """The properties of a task step.

    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistrytasks.models.BaseImageDependency]
    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar task_file_path: The task template/definition file path relative to the source context.
     Required.
    :vartype task_file_path: str
    :ivar values_file_path: The task values/parameters file path relative to the source context.
    :vartype values_file_path: str
    :ivar values_property: The collection of overridable values that can be passed when running a
     task.
    :vartype values_property: list[~azure.mgmt.containerregistrytasks.models.SetValue]
    :ivar type: The type of the step. Required.
    :vartype type: str or ~azure.mgmt.containerregistrytasks.models.FILE_TASK
    """

    task_file_path: str = rest_field(name="taskFilePath", visibility=["read", "create", "update", "delete", "query"])
    """The task template/definition file path relative to the source context. Required."""
    values_file_path: Optional[str] = rest_field(
        name="valuesFilePath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The task values/parameters file path relative to the source context."""
    values_property: Optional[list["_models.SetValue"]] = rest_field(
        name="values", visibility=["read", "create", "update", "delete", "query"], original_tsp_name="values"
    )
    """The collection of overridable values that can be passed when running a task."""
    type: Literal[StepType.FILE_TASK] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the step. Required."""

    @overload
    def __init__(
        self,
        *,
        task_file_path: str,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        values_file_path: Optional[str] = None,
        values_property: Optional[list["_models.SetValue"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = StepType.FILE_TASK  # type: ignore


class FileTaskStepUpdateParameters(TaskStepUpdateParameters, discriminator="FileTask"):
    """The properties of updating a task step.

    :ivar context_path: The URL(absolute or relative) of the source context for the task step.
    :vartype context_path: str
    :ivar context_access_token: The token (git PAT or SAS token of storage account blob) associated
     with the context for a step.
    :vartype context_access_token: str
    :ivar task_file_path: The task template/definition file path relative to the source context.
    :vartype task_file_path: str
    :ivar values_file_path: The values/parameters file path relative to the source context.
    :vartype values_file_path: str
    :ivar values_property: The collection of overridable values that can be passed when running a
     task.
    :vartype values_property: list[~azure.mgmt.containerregistrytasks.models.SetValue]
    :ivar type: The type of the step. Required.
    :vartype type: str or ~azure.mgmt.containerregistrytasks.models.FILE_TASK
    """

    task_file_path: Optional[str] = rest_field(
        name="taskFilePath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The task template/definition file path relative to the source context."""
    values_file_path: Optional[str] = rest_field(
        name="valuesFilePath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The values/parameters file path relative to the source context."""
    values_property: Optional[list["_models.SetValue"]] = rest_field(
        name="values", visibility=["read", "create", "update", "delete", "query"], original_tsp_name="values"
    )
    """The collection of overridable values that can be passed when running a task."""
    type: Literal[StepType.FILE_TASK] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the step. Required."""

    @overload
    def __init__(
        self,
        *,
        context_path: Optional[str] = None,
        context_access_token: Optional[str] = None,
        task_file_path: Optional[str] = None,
        values_file_path: Optional[str] = None,
        values_property: Optional[list["_models.SetValue"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = StepType.FILE_TASK  # type: ignore


class IdentityProperties(_Model):
    """Managed identity for the resource.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Known values are: "SystemAssigned", "UserAssigned",
     "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.containerregistrytasks.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity
     dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.containerregistrytasks.models.UserIdentityProperties]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of resource identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of resource."""
    type: Optional[Union[str, "_models.ResourceIdentityType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity type. Known values are: \"SystemAssigned\", \"UserAssigned\", \"SystemAssigned,
     UserAssigned\", and \"None\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserIdentityProperties"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of user identities associated with the resource. The user identity
     dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[dict[str, "_models.UserIdentityProperties"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImageDescriptor(_Model):
    """Properties for a registry image.

    :ivar registry: The registry login server.
    :vartype registry: str
    :ivar repository: The repository name.
    :vartype repository: str
    :ivar tag: The tag name.
    :vartype tag: str
    :ivar digest: The sha256-based digest of the image manifest.
    :vartype digest: str
    """

    registry: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The registry login server."""
    repository: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The repository name."""
    tag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tag name."""
    digest: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sha256-based digest of the image manifest."""

    @overload
    def __init__(
        self,
        *,
        registry: Optional[str] = None,
        repository: Optional[str] = None,
        tag: Optional[str] = None,
        digest: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImageUpdateTrigger(_Model):
    """The image update trigger that caused a build.

    :ivar id: The unique ID of the trigger.
    :vartype id: str
    :ivar timestamp: The timestamp when the image update happened.
    :vartype timestamp: ~datetime.datetime
    :ivar images: The list of image updates that caused the build.
    :vartype images: list[~azure.mgmt.containerregistrytasks.models.ImageDescriptor]
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of the trigger."""
    timestamp: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp when the image update happened."""
    images: Optional[list["_models.ImageDescriptor"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of image updates that caused the build."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        timestamp: Optional[datetime.datetime] = None,
        images: Optional[list["_models.ImageDescriptor"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OverrideTaskStepProperties(_Model):
    """OverrideTaskStepProperties.

    :ivar context_path: The source context against which run has to be queued.
    :vartype context_path: str
    :ivar file: The file against which run has to be queued.
    :vartype file: str
    :ivar arguments: Gets or sets the collection of override arguments to be used when
     executing a build step.
    :vartype arguments: list[~azure.mgmt.containerregistrytasks.models.Argument]
    :ivar target: The name of the target build stage for the docker build.
    :vartype target: str
    :ivar values_property: The collection of overridable values that can be passed when running a
     Task.
    :vartype values_property: list[~azure.mgmt.containerregistrytasks.models.SetValue]
    :ivar update_trigger_token: Base64 encoded update trigger token that will be attached with the
     base image trigger webhook.
    :vartype update_trigger_token: str
    """

    context_path: Optional[str] = rest_field(
        name="contextPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source context against which run has to be queued."""
    file: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The file against which run has to be queued."""
    arguments: Optional[list["_models.Argument"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the collection of override arguments to be used when
     executing a build step."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the target build stage for the docker build."""
    values_property: Optional[list["_models.SetValue"]] = rest_field(
        name="values", visibility=["read", "create", "update", "delete", "query"], original_tsp_name="values"
    )
    """The collection of overridable values that can be passed when running a Task."""
    update_trigger_token: Optional[str] = rest_field(
        name="updateTriggerToken", visibility=["read", "create", "update", "delete", "query"]
    )
    """Base64 encoded update trigger token that will be attached with the base image trigger webhook."""

    @overload
    def __init__(
        self,
        *,
        context_path: Optional[str] = None,
        file: Optional[str] = None,
        arguments: Optional[list["_models.Argument"]] = None,
        target: Optional[str] = None,
        values_property: Optional[list["_models.SetValue"]] = None,
        update_trigger_token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PlatformProperties(_Model):
    """The platform properties against which the run has to happen.

    :ivar os: The operating system type required for the run. Required. Known values are: "Windows"
     and "Linux".
    :vartype os: str or ~azure.mgmt.containerregistrytasks.models.OS
    :ivar architecture: The OS architecture. Known values are: "amd64", "x86", "386", "arm", and
     "arm64".
    :vartype architecture: str or ~azure.mgmt.containerregistrytasks.models.Architecture
    :ivar variant: Variant of the CPU. Known values are: "v6", "v7", and "v8".
    :vartype variant: str or ~azure.mgmt.containerregistrytasks.models.Variant
    """

    os: Union[str, "_models.OS"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The operating system type required for the run. Required. Known values are: \"Windows\" and
     \"Linux\"."""
    architecture: Optional[Union[str, "_models.Architecture"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The OS architecture. Known values are: \"amd64\", \"x86\", \"386\", \"arm\", and \"arm64\"."""
    variant: Optional[Union[str, "_models.Variant"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Variant of the CPU. Known values are: \"v6\", \"v7\", and \"v8\"."""

    @overload
    def __init__(
        self,
        *,
        os: Union[str, "_models.OS"],
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        variant: Optional[Union[str, "_models.Variant"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PlatformUpdateParameters(_Model):
    """The properties for updating the platform configuration.

    :ivar os: The operating system type required for the run. Known values are: "Windows" and
     "Linux".
    :vartype os: str or ~azure.mgmt.containerregistrytasks.models.OS
    :ivar architecture: The OS architecture. Known values are: "amd64", "x86", "386", "arm", and
     "arm64".
    :vartype architecture: str or ~azure.mgmt.containerregistrytasks.models.Architecture
    :ivar variant: Variant of the CPU. Known values are: "v6", "v7", and "v8".
    :vartype variant: str or ~azure.mgmt.containerregistrytasks.models.Variant
    """

    os: Optional[Union[str, "_models.OS"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The operating system type required for the run. Known values are: \"Windows\" and \"Linux\"."""
    architecture: Optional[Union[str, "_models.Architecture"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The OS architecture. Known values are: \"amd64\", \"x86\", \"386\", \"arm\", and \"arm64\"."""
    variant: Optional[Union[str, "_models.Variant"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Variant of the CPU. Known values are: \"v6\", \"v7\", and \"v8\"."""

    @overload
    def __init__(
        self,
        *,
        os: Optional[Union[str, "_models.OS"]] = None,
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        variant: Optional[Union[str, "_models.Variant"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerregistrytasks.models.SystemData
    """


class Run(ProxyResource):
    """Run resource properties.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerregistrytasks.models.SystemData
    :ivar properties: The properties of a run.
    :vartype properties: ~azure.mgmt.containerregistrytasks.models.RunProperties
    """

    properties: Optional["_models.RunProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of a run."""

    __flattened_items = [
        "run_id",
        "status",
        "last_updated_time",
        "run_type",
        "agent_pool_name",
        "create_time",
        "start_time",
        "finish_time",
        "output_images",
        "task",
        "image_update_trigger",
        "source_trigger",
        "timer_trigger",
        "platform",
        "agent_configuration",
        "source_registry_auth",
        "custom_registries",
        "run_error_message",
        "update_trigger_token",
        "log_artifact",
        "provisioning_state",
        "is_archive_enabled",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.RunProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class RunGetLogResult(_Model):
    """The result of get log link operation.

    :ivar log_link: The link to logs for a run on a azure container registry.
    :vartype log_link: str
    :ivar log_artifact_link: The link to logs in registry for a run on a azure container registry.
    :vartype log_artifact_link: str
    """

    log_link: Optional[str] = rest_field(name="logLink", visibility=["read", "create", "update", "delete", "query"])
    """The link to logs for a run on a azure container registry."""
    log_artifact_link: Optional[str] = rest_field(
        name="logArtifactLink", visibility=["read", "create", "update", "delete", "query"]
    )
    """The link to logs in registry for a run on a azure container registry."""

    @overload
    def __init__(
        self,
        *,
        log_link: Optional[str] = None,
        log_artifact_link: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RunProperties(_Model):
    """The properties for a run.

    :ivar run_id: The unique identifier for the run.
    :vartype run_id: str
    :ivar status: The current status of the run. Known values are: "Queued", "Started", "Running",
     "Succeeded", "Failed", "Canceled", "Error", and "Timeout".
    :vartype status: str or ~azure.mgmt.containerregistrytasks.models.RunStatus
    :ivar last_updated_time: The last updated time for the run.
    :vartype last_updated_time: ~datetime.datetime
    :ivar run_type: The type of run. Known values are: "QuickBuild", "QuickRun", "AutoBuild", and
     "AutoRun".
    :vartype run_type: str or ~azure.mgmt.containerregistrytasks.models.RunType
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar create_time: The time the run was scheduled.
    :vartype create_time: ~datetime.datetime
    :ivar start_time: The time the run started.
    :vartype start_time: ~datetime.datetime
    :ivar finish_time: The time the run finished.
    :vartype finish_time: ~datetime.datetime
    :ivar output_images: The list of all images that were generated from the run. This is
     applicable if the run generates base image dependencies.
    :vartype output_images: list[~azure.mgmt.containerregistrytasks.models.ImageDescriptor]
    :ivar task: The task against which run was scheduled.
    :vartype task: str
    :ivar image_update_trigger: The image update trigger that caused the run. This is applicable if
     the task has base image trigger configured.
    :vartype image_update_trigger: ~azure.mgmt.containerregistrytasks.models.ImageUpdateTrigger
    :ivar source_trigger: The source trigger that caused the run.
    :vartype source_trigger: ~azure.mgmt.containerregistrytasks.models.SourceTriggerDescriptor
    :ivar timer_trigger: The timer trigger that caused the run.
    :vartype timer_trigger: ~azure.mgmt.containerregistrytasks.models.TimerTriggerDescriptor
    :ivar platform: The platform properties against which the run will happen.
    :vartype platform: ~azure.mgmt.containerregistrytasks.models.PlatformProperties
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration: ~azure.mgmt.containerregistrytasks.models.AgentProperties
    :ivar source_registry_auth: The scope of the credentials that were used to login to the source
     registry during this run.
    :vartype source_registry_auth: str
    :ivar custom_registries: The list of custom registries that were logged in during this run.
    :vartype custom_registries: list[str]
    :ivar run_error_message: The error message received from backend systems after the run is
     scheduled.
    :vartype run_error_message: str
    :ivar update_trigger_token: The update trigger token passed for the Run.
    :vartype update_trigger_token: str
    :ivar log_artifact: The image description for the log artifact.
    :vartype log_artifact: ~azure.mgmt.containerregistrytasks.models.ImageDescriptor
    :ivar provisioning_state: The provisioning state of a run. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.containerregistrytasks.models.ProvisioningState
    :ivar is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :vartype is_archive_enabled: bool
    """

    run_id: Optional[str] = rest_field(name="runId", visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier for the run."""
    status: Optional[Union[str, "_models.RunStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The current status of the run. Known values are: \"Queued\", \"Started\", \"Running\",
     \"Succeeded\", \"Failed\", \"Canceled\", \"Error\", and \"Timeout\"."""
    last_updated_time: Optional[datetime.datetime] = rest_field(
        name="lastUpdatedTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last updated time for the run."""
    run_type: Optional[Union[str, "_models.RunType"]] = rest_field(
        name="runType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of run. Known values are: \"QuickBuild\", \"QuickRun\", \"AutoBuild\", and
     \"AutoRun\"."""
    agent_pool_name: Optional[str] = rest_field(
        name="agentPoolName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The dedicated agent pool for the run."""
    create_time: Optional[datetime.datetime] = rest_field(
        name="createTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time the run was scheduled."""
    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time the run started."""
    finish_time: Optional[datetime.datetime] = rest_field(
        name="finishTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time the run finished."""
    output_images: Optional[list["_models.ImageDescriptor"]] = rest_field(
        name="outputImages", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of all images that were generated from the run. This is applicable if the run
     generates base image dependencies."""
    task: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The task against which run was scheduled."""
    image_update_trigger: Optional["_models.ImageUpdateTrigger"] = rest_field(
        name="imageUpdateTrigger", visibility=["read", "create", "update", "delete", "query"]
    )
    """The image update trigger that caused the run. This is applicable if the task has base image
     trigger configured."""
    source_trigger: Optional["_models.SourceTriggerDescriptor"] = rest_field(
        name="sourceTrigger", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source trigger that caused the run."""
    timer_trigger: Optional["_models.TimerTriggerDescriptor"] = rest_field(
        name="timerTrigger", visibility=["read", "create", "update", "delete", "query"]
    )
    """The timer trigger that caused the run."""
    platform: Optional["_models.PlatformProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The platform properties against which the run will happen."""
    agent_configuration: Optional["_models.AgentProperties"] = rest_field(
        name="agentConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The machine configuration of the run agent."""
    source_registry_auth: Optional[str] = rest_field(
        name="sourceRegistryAuth", visibility=["read", "create", "update", "delete", "query"]
    )
    """The scope of the credentials that were used to login to the source registry during this run."""
    custom_registries: Optional[list[str]] = rest_field(
        name="customRegistries", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of custom registries that were logged in during this run."""
    run_error_message: Optional[str] = rest_field(name="runErrorMessage", visibility=["read"])
    """The error message received from backend systems after the run is scheduled."""
    update_trigger_token: Optional[str] = rest_field(
        name="updateTriggerToken", visibility=["read", "create", "update", "delete", "query"]
    )
    """The update trigger token passed for the Run."""
    log_artifact: Optional["_models.ImageDescriptor"] = rest_field(name="logArtifact", visibility=["read"])
    """The image description for the log artifact."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The provisioning state of a run. Known values are: \"Creating\", \"Updating\", \"Deleting\",
     \"Succeeded\", \"Failed\", and \"Canceled\"."""
    is_archive_enabled: Optional[bool] = rest_field(
        name="isArchiveEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """The value that indicates whether archiving is enabled or not."""

    @overload
    def __init__(
        self,
        *,
        run_id: Optional[str] = None,
        status: Optional[Union[str, "_models.RunStatus"]] = None,
        last_updated_time: Optional[datetime.datetime] = None,
        run_type: Optional[Union[str, "_models.RunType"]] = None,
        agent_pool_name: Optional[str] = None,
        create_time: Optional[datetime.datetime] = None,
        start_time: Optional[datetime.datetime] = None,
        finish_time: Optional[datetime.datetime] = None,
        output_images: Optional[list["_models.ImageDescriptor"]] = None,
        task: Optional[str] = None,
        image_update_trigger: Optional["_models.ImageUpdateTrigger"] = None,
        source_trigger: Optional["_models.SourceTriggerDescriptor"] = None,
        timer_trigger: Optional["_models.TimerTriggerDescriptor"] = None,
        platform: Optional["_models.PlatformProperties"] = None,
        agent_configuration: Optional["_models.AgentProperties"] = None,
        source_registry_auth: Optional[str] = None,
        custom_registries: Optional[list[str]] = None,
        update_trigger_token: Optional[str] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        is_archive_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RunUpdateParameters(_Model):
    """The set of run properties that can be updated.

    :ivar is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :vartype is_archive_enabled: bool
    """

    is_archive_enabled: Optional[bool] = rest_field(
        name="isArchiveEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """The value that indicates whether archiving is enabled or not."""

    @overload
    def __init__(
        self,
        *,
        is_archive_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecretObject(_Model):
    """Describes the properties of a secret object value.

    :ivar value: The value of the secret. The format of this value will be determined
     based on the type of the secret object. If the type is Opaque, the value will be
     used as is without any modification.
    :vartype value: str
    :ivar type: The type of the secret object which determines how the value of the secret object
     has to be
     interpreted. Known values are: "Opaque" and "Vaultsecret".
    :vartype type: str or ~azure.mgmt.containerregistrytasks.models.SecretObjectType
    """

    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the secret. The format of this value will be determined
     based on the type of the secret object. If the type is Opaque, the value will be
     used as is without any modification."""
    type: Optional[Union[str, "_models.SecretObjectType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the secret object which determines how the value of the secret object has to be
     interpreted. Known values are: \"Opaque\" and \"Vaultsecret\"."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[str] = None,
        type: Optional[Union[str, "_models.SecretObjectType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SetValue(_Model):
    """The properties of a overridable value that can be passed to a task template.

    :ivar name: The name of the overridable value. Required.
    :vartype name: str
    :ivar value: The overridable value. Required.
    :vartype value: str
    :ivar is_secret: Flag to indicate whether the value represents a secret or not.
    :vartype is_secret: bool
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the overridable value. Required."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The overridable value. Required."""
    is_secret: Optional[bool] = rest_field(name="isSecret", visibility=["read", "create", "update", "delete", "query"])
    """Flag to indicate whether the value represents a secret or not."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        value: str,
        is_secret: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SourceProperties(_Model):
    """The properties of the source code repository.

    :ivar source_control_type: The type of source control service. Required. Known values are:
     "Github" and "VisualStudioTeamService".
    :vartype source_control_type: str or
     ~azure.mgmt.containerregistrytasks.models.SourceControlType
    :ivar repository_url: The full URL to the source code repository. Required.
    :vartype repository_url: str
    :ivar branch: The branch name of the source code.
    :vartype branch: str
    :ivar source_control_auth_properties: The authorization properties for accessing the source
     code repository and to set up
     webhooks for notifications.
    :vartype source_control_auth_properties: ~azure.mgmt.containerregistrytasks.models.AuthInfo
    """

    source_control_type: Union[str, "_models.SourceControlType"] = rest_field(
        name="sourceControlType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of source control service. Required. Known values are: \"Github\" and
     \"VisualStudioTeamService\"."""
    repository_url: str = rest_field(name="repositoryUrl", visibility=["read", "create", "update", "delete", "query"])
    """The full URL to the source code repository. Required."""
    branch: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The branch name of the source code."""
    source_control_auth_properties: Optional["_models.AuthInfo"] = rest_field(
        name="sourceControlAuthProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """The authorization properties for accessing the source code repository and to set up
     webhooks for notifications."""

    @overload
    def __init__(
        self,
        *,
        source_control_type: Union[str, "_models.SourceControlType"],
        repository_url: str,
        branch: Optional[str] = None,
        source_control_auth_properties: Optional["_models.AuthInfo"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SourceRegistryCredentials(_Model):
    """Describes the credential parameters for accessing the source registry.

    :ivar identity: The Entra identity used for source registry login.
     The value is ``[system]`` for system-assigned managed identity, ``[caller]`` for caller
     identity,
     and client ID for user-assigned managed identity.
    :vartype identity: str
    :ivar login_mode: The authentication mode which determines the source registry login scope. The
     credentials for the source registry
     will be generated using the given scope. These credentials will be used to login to
     the source registry during the run. Known values are: "None" and "Default".
    :vartype login_mode: str or ~azure.mgmt.containerregistrytasks.models.SourceRegistryLoginMode
    """

    identity: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Entra identity used for source registry login.
     The value is ``[system]`` for system-assigned managed identity, ``[caller]`` for caller
     identity,
     and client ID for user-assigned managed identity."""
    login_mode: Optional[Union[str, "_models.SourceRegistryLoginMode"]] = rest_field(
        name="loginMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The authentication mode which determines the source registry login scope. The credentials for
     the source registry
     will be generated using the given scope. These credentials will be used to login to
     the source registry during the run. Known values are: \"None\" and \"Default\"."""

    @overload
    def __init__(
        self,
        *,
        identity: Optional[str] = None,
        login_mode: Optional[Union[str, "_models.SourceRegistryLoginMode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SourceTrigger(_Model):
    """The properties of a source based trigger.

    :ivar source_repository: The properties that describes the source(code) for the task. Required.
    :vartype source_repository: ~azure.mgmt.containerregistrytasks.models.SourceProperties
    :ivar source_trigger_events: The source event corresponding to the trigger. Required.
    :vartype source_trigger_events: list[str or
     ~azure.mgmt.containerregistrytasks.models.SourceTriggerEvent]
    :ivar status: The current status of trigger. Known values are: "Disabled" and "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistrytasks.models.TriggerStatus
    :ivar name: The name of the trigger. Required.
    :vartype name: str
    """

    source_repository: "_models.SourceProperties" = rest_field(
        name="sourceRepository", visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties that describes the source(code) for the task. Required."""
    source_trigger_events: list[Union[str, "_models.SourceTriggerEvent"]] = rest_field(
        name="sourceTriggerEvents", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source event corresponding to the trigger. Required."""
    status: Optional[Union[str, "_models.TriggerStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The current status of trigger. Known values are: \"Disabled\" and \"Enabled\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the trigger. Required."""

    @overload
    def __init__(
        self,
        *,
        source_repository: "_models.SourceProperties",
        source_trigger_events: list[Union[str, "_models.SourceTriggerEvent"]],
        name: str,
        status: Optional[Union[str, "_models.TriggerStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SourceTriggerDescriptor(_Model):
    """The source trigger that caused a run.

    :ivar id: The unique ID of the trigger.
    :vartype id: str
    :ivar event_type: The event type of the trigger.
    :vartype event_type: str
    :ivar commit_id: The unique ID that identifies a commit.
    :vartype commit_id: str
    :ivar pull_request_id: The unique ID that identifies pull request.
    :vartype pull_request_id: str
    :ivar repository_url: The repository URL.
    :vartype repository_url: str
    :ivar branch_name: The branch name in the repository.
    :vartype branch_name: str
    :ivar provider_type: The source control provider type.
    :vartype provider_type: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of the trigger."""
    event_type: Optional[str] = rest_field(name="eventType", visibility=["read", "create", "update", "delete", "query"])
    """The event type of the trigger."""
    commit_id: Optional[str] = rest_field(name="commitId", visibility=["read", "create", "update", "delete", "query"])
    """The unique ID that identifies a commit."""
    pull_request_id: Optional[str] = rest_field(
        name="pullRequestId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The unique ID that identifies pull request."""
    repository_url: Optional[str] = rest_field(
        name="repositoryUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """The repository URL."""
    branch_name: Optional[str] = rest_field(
        name="branchName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The branch name in the repository."""
    provider_type: Optional[str] = rest_field(
        name="providerType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source control provider type."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        event_type: Optional[str] = None,
        commit_id: Optional[str] = None,
        pull_request_id: Optional[str] = None,
        repository_url: Optional[str] = None,
        branch_name: Optional[str] = None,
        provider_type: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SourceTriggerUpdateParameters(_Model):
    """The properties for updating a source based trigger.

    :ivar source_repository: The properties that describes the source(code) for the task.
    :vartype source_repository: ~azure.mgmt.containerregistrytasks.models.SourceUpdateParameters
    :ivar source_trigger_events: The source event corresponding to the trigger.
    :vartype source_trigger_events: list[str or
     ~azure.mgmt.containerregistrytasks.models.SourceTriggerEvent]
    :ivar status: The current status of trigger. Known values are: "Disabled" and "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistrytasks.models.TriggerStatus
    :ivar name: The name of the trigger. Required.
    :vartype name: str
    """

    source_repository: Optional["_models.SourceUpdateParameters"] = rest_field(
        name="sourceRepository", visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties that describes the source(code) for the task."""
    source_trigger_events: Optional[list[Union[str, "_models.SourceTriggerEvent"]]] = rest_field(
        name="sourceTriggerEvents", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source event corresponding to the trigger."""
    status: Optional[Union[str, "_models.TriggerStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The current status of trigger. Known values are: \"Disabled\" and \"Enabled\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the trigger. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        source_repository: Optional["_models.SourceUpdateParameters"] = None,
        source_trigger_events: Optional[list[Union[str, "_models.SourceTriggerEvent"]]] = None,
        status: Optional[Union[str, "_models.TriggerStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SourceUpdateParameters(_Model):
    """The properties for updating the source code repository.

    :ivar source_control_type: The type of source control service. Known values are: "Github" and
     "VisualStudioTeamService".
    :vartype source_control_type: str or
     ~azure.mgmt.containerregistrytasks.models.SourceControlType
    :ivar repository_url: The full URL to the source code repository.
    :vartype repository_url: str
    :ivar branch: The branch name of the source code.
    :vartype branch: str
    :ivar source_control_auth_properties: The authorization properties for accessing the source
     code repository and to set up
     webhooks for notifications.
    :vartype source_control_auth_properties:
     ~azure.mgmt.containerregistrytasks.models.AuthInfoUpdateParameters
    """

    source_control_type: Optional[Union[str, "_models.SourceControlType"]] = rest_field(
        name="sourceControlType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of source control service. Known values are: \"Github\" and
     \"VisualStudioTeamService\"."""
    repository_url: Optional[str] = rest_field(
        name="repositoryUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """The full URL to the source code repository."""
    branch: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The branch name of the source code."""
    source_control_auth_properties: Optional["_models.AuthInfoUpdateParameters"] = rest_field(
        name="sourceControlAuthProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """The authorization properties for accessing the source code repository and to set up
     webhooks for notifications."""

    @overload
    def __init__(
        self,
        *,
        source_control_type: Optional[Union[str, "_models.SourceControlType"]] = None,
        repository_url: Optional[str] = None,
        branch: Optional[str] = None,
        source_control_auth_properties: Optional["_models.AuthInfoUpdateParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SourceUploadDefinition(_Model):
    """The properties of a response to source upload request.

    :ivar upload_url: The URL where the client can upload the source.
    :vartype upload_url: str
    :ivar relative_path: The relative path to the source. This is used to submit the subsequent
     queue build request.
    :vartype relative_path: str
    """

    upload_url: Optional[str] = rest_field(name="uploadUrl", visibility=["read", "create", "update", "delete", "query"])
    """The URL where the client can upload the source."""
    relative_path: Optional[str] = rest_field(
        name="relativePath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The relative path to the source. This is used to submit the subsequent queue build request."""

    @overload
    def __init__(
        self,
        *,
        upload_url: Optional[str] = None,
        relative_path: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.containerregistrytasks.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.containerregistrytasks.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Task(TrackedResource):
    """The task that has the ARM resource and task properties.
    The task will have all information to schedule a run against it.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerregistrytasks.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The properties of a task.
    :vartype properties: ~azure.mgmt.containerregistrytasks.models.TaskProperties
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.containerregistrytasks.models.IdentityProperties
    """

    properties: Optional["_models.TaskProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of a task."""
    identity: Optional["_models.IdentityProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Identity for the resource."""

    __flattened_items = [
        "provisioning_state",
        "creation_date",
        "status",
        "platform",
        "agent_configuration",
        "agent_pool_name",
        "timeout",
        "step",
        "trigger",
        "credentials",
        "log_template",
        "is_system_task",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.TaskProperties"] = None,
        identity: Optional["_models.IdentityProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class TaskProperties(_Model):
    """The properties of a task.

    :ivar provisioning_state: The provisioning state of the task. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.containerregistrytasks.models.ProvisioningState
    :ivar creation_date: The creation date of task.
    :vartype creation_date: ~datetime.datetime
    :ivar status: The current status of task. Known values are: "Disabled" and "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistrytasks.models.TaskStatus
    :ivar platform: The platform properties against which the run has to happen.
    :vartype platform: ~azure.mgmt.containerregistrytasks.models.PlatformProperties
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration: ~azure.mgmt.containerregistrytasks.models.AgentProperties
    :ivar agent_pool_name: The dedicated agent pool for the task.
    :vartype agent_pool_name: str
    :ivar timeout: Run timeout in seconds.
    :vartype timeout: int
    :ivar step: The properties of a task step.
    :vartype step: ~azure.mgmt.containerregistrytasks.models.TaskStepProperties
    :ivar trigger: The properties that describe all triggers for the task.
    :vartype trigger: ~azure.mgmt.containerregistrytasks.models.TriggerProperties
    :ivar credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :vartype credentials: ~azure.mgmt.containerregistrytasks.models.Credentials
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    :ivar is_system_task: The value of this property indicates whether the task resource is system
     task or not.
    :vartype is_system_task: bool
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the task. Known values are: \"Creating\", \"Updating\", \"Deleting\",
     \"Succeeded\", \"Failed\", and \"Canceled\"."""
    creation_date: Optional[datetime.datetime] = rest_field(name="creationDate", visibility=["read"], format="rfc3339")
    """The creation date of task."""
    status: Optional[Union[str, "_models.TaskStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The current status of task. Known values are: \"Disabled\" and \"Enabled\"."""
    platform: Optional["_models.PlatformProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The platform properties against which the run has to happen."""
    agent_configuration: Optional["_models.AgentProperties"] = rest_field(
        name="agentConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The machine configuration of the run agent."""
    agent_pool_name: Optional[str] = rest_field(
        name="agentPoolName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The dedicated agent pool for the task."""
    timeout: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Run timeout in seconds."""
    step: Optional["_models.TaskStepProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of a task step."""
    trigger: Optional["_models.TriggerProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties that describe all triggers for the task."""
    credentials: Optional["_models.Credentials"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties that describes a set of credentials that will be used when this run is invoked."""
    log_template: Optional[str] = rest_field(
        name="logTemplate", visibility=["read", "create", "update", "delete", "query"]
    )
    """The template that describes the repository and tag information for run log artifact."""
    is_system_task: Optional[bool] = rest_field(
        name="isSystemTask", visibility=["read", "create", "update", "delete", "query"]
    )
    """The value of this property indicates whether the task resource is system task or not."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.TaskStatus"]] = None,
        platform: Optional["_models.PlatformProperties"] = None,
        agent_configuration: Optional["_models.AgentProperties"] = None,
        agent_pool_name: Optional[str] = None,
        timeout: Optional[int] = None,
        step: Optional["_models.TaskStepProperties"] = None,
        trigger: Optional["_models.TriggerProperties"] = None,
        credentials: Optional["_models.Credentials"] = None,
        log_template: Optional[str] = None,
        is_system_task: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TaskPropertiesUpdateParameters(_Model):
    """The properties for updating a task.

    :ivar status: The current status of task. Known values are: "Disabled" and "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistrytasks.models.TaskStatus
    :ivar platform: The platform properties against which the run has to happen.
    :vartype platform: ~azure.mgmt.containerregistrytasks.models.PlatformUpdateParameters
    :ivar agent_configuration: The machine configuration of the run agent.
    :vartype agent_configuration: ~azure.mgmt.containerregistrytasks.models.AgentProperties
    :ivar agent_pool_name: The dedicated agent pool for the task.
    :vartype agent_pool_name: str
    :ivar timeout: Run timeout in seconds.
    :vartype timeout: int
    :ivar step: The properties for updating a task step.
    :vartype step: ~azure.mgmt.containerregistrytasks.models.TaskStepUpdateParameters
    :ivar trigger: The properties for updating trigger properties.
    :vartype trigger: ~azure.mgmt.containerregistrytasks.models.TriggerUpdateParameters
    :ivar credentials: The parameters that describes a set of credentials that will be used when
     this run is invoked.
    :vartype credentials: ~azure.mgmt.containerregistrytasks.models.Credentials
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    """

    status: Optional[Union[str, "_models.TaskStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The current status of task. Known values are: \"Disabled\" and \"Enabled\"."""
    platform: Optional["_models.PlatformUpdateParameters"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The platform properties against which the run has to happen."""
    agent_configuration: Optional["_models.AgentProperties"] = rest_field(
        name="agentConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The machine configuration of the run agent."""
    agent_pool_name: Optional[str] = rest_field(
        name="agentPoolName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The dedicated agent pool for the task."""
    timeout: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Run timeout in seconds."""
    step: Optional["_models.TaskStepUpdateParameters"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties for updating a task step."""
    trigger: Optional["_models.TriggerUpdateParameters"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties for updating trigger properties."""
    credentials: Optional["_models.Credentials"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The parameters that describes a set of credentials that will be used when this run is invoked."""
    log_template: Optional[str] = rest_field(
        name="logTemplate", visibility=["read", "create", "update", "delete", "query"]
    )
    """The template that describes the repository and tag information for run log artifact."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.TaskStatus"]] = None,
        platform: Optional["_models.PlatformUpdateParameters"] = None,
        agent_configuration: Optional["_models.AgentProperties"] = None,
        agent_pool_name: Optional[str] = None,
        timeout: Optional[int] = None,
        step: Optional["_models.TaskStepUpdateParameters"] = None,
        trigger: Optional["_models.TriggerUpdateParameters"] = None,
        credentials: Optional["_models.Credentials"] = None,
        log_template: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TaskRun(ProxyResource):
    """The task run that has the ARM resource and properties.
    The task run will have the information of request and result of a run.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerregistrytasks.models.SystemData
    :ivar properties: The properties associated with the task run, i.e., request and result of the
     run.
    :vartype properties: ~azure.mgmt.containerregistrytasks.models.TaskRunProperties
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.containerregistrytasks.models.IdentityProperties
    :ivar location: The location of the resource.
    :vartype location: str
    """

    properties: Optional["_models.TaskRunProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties associated with the task run, i.e., request and result of the run."""
    identity: Optional["_models.IdentityProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Identity for the resource."""
    location: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The location of the resource."""

    __flattened_items = ["provisioning_state", "run_request", "run_result", "force_update_tag"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.TaskRunProperties"] = None,
        identity: Optional["_models.IdentityProperties"] = None,
        location: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class TaskRunProperties(_Model):
    """The properties of task run.

    :ivar provisioning_state: The provisioning state of this task run. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.containerregistrytasks.models.ProvisioningState
    :ivar run_request: The request (parameters) for the run.
    :vartype run_request: ~azure.mgmt.containerregistrytasks.models.RunRequest
    :ivar run_result: The result of this task run.
    :vartype run_result: ~azure.mgmt.containerregistrytasks.models.Run
    :ivar force_update_tag: How the run should be forced to rerun even if the run request
     configuration has not changed.
    :vartype force_update_tag: str
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of this task run. Known values are: \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", and \"Canceled\"."""
    run_request: Optional["_models.RunRequest"] = rest_field(
        name="runRequest", visibility=["read", "create", "update", "delete", "query"]
    )
    """The request (parameters) for the run."""
    run_result: Optional["_models.Run"] = rest_field(name="runResult", visibility=["read"])
    """The result of this task run."""
    force_update_tag: Optional[str] = rest_field(
        name="forceUpdateTag", visibility=["read", "create", "update", "delete", "query"]
    )
    """How the run should be forced to rerun even if the run request configuration has not changed."""

    @overload
    def __init__(
        self,
        *,
        run_request: Optional["_models.RunRequest"] = None,
        force_update_tag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TaskRunPropertiesUpdateParameters(_Model):
    """The properties of a task run update parameters.

    :ivar run_request: The request (parameters) for the new run.
    :vartype run_request: ~azure.mgmt.containerregistrytasks.models.RunRequest
    :ivar force_update_tag: How the run should be forced to rerun even if the run request
     configuration has not changed.
    :vartype force_update_tag: str
    """

    run_request: Optional["_models.RunRequest"] = rest_field(
        name="runRequest", visibility=["read", "create", "update", "delete", "query"]
    )
    """The request (parameters) for the new run."""
    force_update_tag: Optional[str] = rest_field(
        name="forceUpdateTag", visibility=["read", "create", "update", "delete", "query"]
    )
    """How the run should be forced to rerun even if the run request configuration has not changed."""

    @overload
    def __init__(
        self,
        *,
        run_request: Optional["_models.RunRequest"] = None,
        force_update_tag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TaskRunRequest(RunRequest, discriminator="TaskRunRequest"):
    """The parameters for a task run request.

    :ivar is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :vartype is_archive_enabled: bool
    :ivar agent_pool_name: The dedicated agent pool for the run.
    :vartype agent_pool_name: str
    :ivar log_template: The template that describes the repository and tag information for run log
     artifact.
    :vartype log_template: str
    :ivar task_id: The resource ID of task against which run has to be queued. Required.
    :vartype task_id: str
    :ivar override_task_step_properties: Set of overridable parameters that can be passed when
     running a Task.
    :vartype override_task_step_properties:
     ~azure.mgmt.containerregistrytasks.models.OverrideTaskStepProperties
    :ivar type: The type of the run request. Required. Default value is "TaskRunRequest".
    :vartype type: str
    """

    task_id: str = rest_field(name="taskId", visibility=["read", "create", "update", "delete", "query"])
    """The resource ID of task against which run has to be queued. Required."""
    override_task_step_properties: Optional["_models.OverrideTaskStepProperties"] = rest_field(
        name="overrideTaskStepProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Set of overridable parameters that can be passed when running a Task."""
    type: Literal["TaskRunRequest"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the run request. Required. Default value is \"TaskRunRequest\"."""

    @overload
    def __init__(
        self,
        *,
        task_id: str,
        is_archive_enabled: Optional[bool] = None,
        agent_pool_name: Optional[str] = None,
        log_template: Optional[str] = None,
        override_task_step_properties: Optional["_models.OverrideTaskStepProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = "TaskRunRequest"  # type: ignore


class TaskRunUpdateParameters(_Model):
    """The parameters for updating a task run.

    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.containerregistrytasks.models.IdentityProperties
    :ivar properties: The properties for updating a task run.
    :vartype properties:
     ~azure.mgmt.containerregistrytasks.models.TaskRunPropertiesUpdateParameters
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The ARM resource tags.
    :vartype tags: dict[str, str]
    """

    identity: Optional["_models.IdentityProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Identity for the resource."""
    properties: Optional["_models.TaskRunPropertiesUpdateParameters"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties for updating a task run."""
    location: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The location of the resource."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ARM resource tags."""

    __flattened_items = ["run_request", "force_update_tag"]

    @overload
    def __init__(
        self,
        *,
        identity: Optional["_models.IdentityProperties"] = None,
        properties: Optional["_models.TaskRunPropertiesUpdateParameters"] = None,
        location: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class TaskUpdateParameters(_Model):
    """The parameters for updating a task.

    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.containerregistrytasks.models.IdentityProperties
    :ivar properties: The properties for updating a task.
    :vartype properties: ~azure.mgmt.containerregistrytasks.models.TaskPropertiesUpdateParameters
    :ivar tags: The ARM resource tags.
    :vartype tags: dict[str, str]
    """

    identity: Optional["_models.IdentityProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Identity for the resource."""
    properties: Optional["_models.TaskPropertiesUpdateParameters"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties for updating a task."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ARM resource tags."""

    __flattened_items = [
        "status",
        "platform",
        "agent_configuration",
        "agent_pool_name",
        "timeout",
        "step",
        "trigger",
        "credentials",
        "log_template",
    ]

    @overload
    def __init__(
        self,
        *,
        identity: Optional["_models.IdentityProperties"] = None,
        properties: Optional["_models.TaskPropertiesUpdateParameters"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class TimerTrigger(_Model):
    """The properties of a timer trigger.

    :ivar schedule: The CRON expression for the task schedule. Required.
    :vartype schedule: str
    :ivar status: The current status of trigger. Known values are: "Disabled" and "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistrytasks.models.TriggerStatus
    :ivar name: The name of the trigger. Required.
    :vartype name: str
    """

    schedule: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The CRON expression for the task schedule. Required."""
    status: Optional[Union[str, "_models.TriggerStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The current status of trigger. Known values are: \"Disabled\" and \"Enabled\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the trigger. Required."""

    @overload
    def __init__(
        self,
        *,
        schedule: str,
        name: str,
        status: Optional[Union[str, "_models.TriggerStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TimerTriggerDescriptor(_Model):
    """TimerTriggerDescriptor.

    :ivar timer_trigger_name: The timer trigger name that caused the run.
    :vartype timer_trigger_name: str
    :ivar schedule_occurrence: The occurrence that triggered the run.
    :vartype schedule_occurrence: str
    """

    timer_trigger_name: Optional[str] = rest_field(
        name="timerTriggerName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The timer trigger name that caused the run."""
    schedule_occurrence: Optional[str] = rest_field(
        name="scheduleOccurrence", visibility=["read", "create", "update", "delete", "query"]
    )
    """The occurrence that triggered the run."""

    @overload
    def __init__(
        self,
        *,
        timer_trigger_name: Optional[str] = None,
        schedule_occurrence: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TimerTriggerUpdateParameters(_Model):
    """The properties for updating a timer trigger.

    :ivar schedule: The CRON expression for the task schedule.
    :vartype schedule: str
    :ivar status: The current status of trigger. Known values are: "Disabled" and "Enabled".
    :vartype status: str or ~azure.mgmt.containerregistrytasks.models.TriggerStatus
    :ivar name: The name of the trigger. Required.
    :vartype name: str
    """

    schedule: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The CRON expression for the task schedule."""
    status: Optional[Union[str, "_models.TriggerStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The current status of trigger. Known values are: \"Disabled\" and \"Enabled\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the trigger. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        schedule: Optional[str] = None,
        status: Optional[Union[str, "_models.TriggerStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TriggerProperties(_Model):
    """The properties of a trigger.

    :ivar timer_triggers: The collection of timer triggers.
    :vartype timer_triggers: list[~azure.mgmt.containerregistrytasks.models.TimerTrigger]
    :ivar source_triggers: The collection of triggers based on source code repository.
    :vartype source_triggers: list[~azure.mgmt.containerregistrytasks.models.SourceTrigger]
    :ivar base_image_trigger: The trigger based on base image dependencies.
    :vartype base_image_trigger: ~azure.mgmt.containerregistrytasks.models.BaseImageTrigger
    """

    timer_triggers: Optional[list["_models.TimerTrigger"]] = rest_field(
        name="timerTriggers", visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of timer triggers."""
    source_triggers: Optional[list["_models.SourceTrigger"]] = rest_field(
        name="sourceTriggers", visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of triggers based on source code repository."""
    base_image_trigger: Optional["_models.BaseImageTrigger"] = rest_field(
        name="baseImageTrigger", visibility=["read", "create", "update", "delete", "query"]
    )
    """The trigger based on base image dependencies."""

    @overload
    def __init__(
        self,
        *,
        timer_triggers: Optional[list["_models.TimerTrigger"]] = None,
        source_triggers: Optional[list["_models.SourceTrigger"]] = None,
        base_image_trigger: Optional["_models.BaseImageTrigger"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TriggerUpdateParameters(_Model):
    """The properties for updating triggers.

    :ivar timer_triggers: The collection of timer triggers.
    :vartype timer_triggers:
     list[~azure.mgmt.containerregistrytasks.models.TimerTriggerUpdateParameters]
    :ivar source_triggers: The collection of triggers based on source code repository.
    :vartype source_triggers:
     list[~azure.mgmt.containerregistrytasks.models.SourceTriggerUpdateParameters]
    :ivar base_image_trigger: The trigger based on base image dependencies.
    :vartype base_image_trigger:
     ~azure.mgmt.containerregistrytasks.models.BaseImageTriggerUpdateParameters
    """

    timer_triggers: Optional[list["_models.TimerTriggerUpdateParameters"]] = rest_field(
        name="timerTriggers", visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of timer triggers."""
    source_triggers: Optional[list["_models.SourceTriggerUpdateParameters"]] = rest_field(
        name="sourceTriggers", visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of triggers based on source code repository."""
    base_image_trigger: Optional["_models.BaseImageTriggerUpdateParameters"] = rest_field(
        name="baseImageTrigger", visibility=["read", "create", "update", "delete", "query"]
    )
    """The trigger based on base image dependencies."""

    @overload
    def __init__(
        self,
        *,
        timer_triggers: Optional[list["_models.TimerTriggerUpdateParameters"]] = None,
        source_triggers: Optional[list["_models.SourceTriggerUpdateParameters"]] = None,
        base_image_trigger: Optional["_models.BaseImageTriggerUpdateParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserIdentityProperties(_Model):
    """UserIdentityProperties.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal id of user assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client id of user assigned identity."""
