# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementPrivateEndpointsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoints_begin_delete(self, resource_group):
        response = self.client.private_endpoints.begin_delete(
            resource_group_name=resource_group.name,
            private_endpoint_name="str",
            api_version="2025-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoints_get(self, resource_group):
        response = self.client.private_endpoints.get(
            resource_group_name=resource_group.name,
            private_endpoint_name="str",
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoints_begin_create_or_update(self, resource_group):
        response = self.client.private_endpoints.begin_create_or_update(
            resource_group_name=resource_group.name,
            private_endpoint_name="str",
            parameters={
                "applicationSecurityGroups": [
                    {
                        "etag": "str",
                        "id": "str",
                        "location": "str",
                        "name": "str",
                        "provisioningState": "str",
                        "resourceGuid": "str",
                        "tags": {"str": "str"},
                        "type": "str",
                    }
                ],
                "customDnsConfigs": [{"fqdn": "str", "ipAddresses": ["str"]}],
                "customNetworkInterfaceName": "str",
                "etag": "str",
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "ipConfigurations": [
                    {
                        "etag": "str",
                        "groupId": "str",
                        "memberName": "str",
                        "name": "str",
                        "privateIPAddress": "str",
                        "type": "str",
                    }
                ],
                "ipVersionType": "IPv4",
                "location": "str",
                "manualPrivateLinkServiceConnections": [
                    {
                        "etag": "str",
                        "groupIds": ["str"],
                        "id": "str",
                        "name": "str",
                        "privateLinkServiceConnectionState": {
                            "actionsRequired": "str",
                            "description": "str",
                            "status": "str",
                        },
                        "privateLinkServiceId": "str",
                        "provisioningState": "str",
                        "requestMessage": "str",
                        "type": "str",
                    }
                ],
                "name": "str",
                "networkInterfaces": [
                    {
                        "auxiliaryMode": "str",
                        "auxiliarySku": "str",
                        "defaultOutboundConnectivityEnabled": bool,
                        "disableTcpStateTracking": bool,
                        "dnsSettings": {
                            "appliedDnsServers": ["str"],
                            "dnsServers": ["str"],
                            "internalDnsNameLabel": "str",
                            "internalDomainNameSuffix": "str",
                            "internalFqdn": "str",
                        },
                        "dscpConfiguration": {"id": "str"},
                        "enableAcceleratedNetworking": bool,
                        "enableIPForwarding": bool,
                        "etag": "str",
                        "extendedLocation": {"name": "str", "type": "str"},
                        "hostedWorkloads": ["str"],
                        "id": "str",
                        "ipConfigurations": [
                            {
                                "applicationGatewayBackendAddressPools": [
                                    {
                                        "backendAddresses": [{"fqdn": "str", "ipAddress": "str"}],
                                        "backendIPConfigurations": [...],
                                        "etag": "str",
                                        "id": "str",
                                        "name": "str",
                                        "provisioningState": "str",
                                        "type": "str",
                                    }
                                ],
                                "applicationSecurityGroups": [
                                    {
                                        "etag": "str",
                                        "id": "str",
                                        "location": "str",
                                        "name": "str",
                                        "provisioningState": "str",
                                        "resourceGuid": "str",
                                        "tags": {"str": "str"},
                                        "type": "str",
                                    }
                                ],
                                "etag": "str",
                                "gatewayLoadBalancer": {"id": "str"},
                                "id": "str",
                                "loadBalancerBackendAddressPools": [
                                    {
                                        "backendIPConfigurations": [...],
                                        "drainPeriodInSeconds": 0,
                                        "etag": "str",
                                        "id": "str",
                                        "inboundNatRules": [{"id": "str"}],
                                        "loadBalancerBackendAddresses": [
                                            {
                                                "adminState": "str",
                                                "inboundNatRulesPortMapping": [
                                                    {"backendPort": 0, "frontendPort": 0, "inboundNatRuleName": "str"}
                                                ],
                                                "ipAddress": "str",
                                                "loadBalancerFrontendIPConfiguration": {"id": "str"},
                                                "name": "str",
                                                "networkInterfaceIPConfiguration": {"id": "str"},
                                                "subnet": {"id": "str"},
                                                "virtualNetwork": {"id": "str"},
                                            }
                                        ],
                                        "loadBalancingRules": [{"id": "str"}],
                                        "location": "str",
                                        "name": "str",
                                        "outboundRule": {"id": "str"},
                                        "outboundRules": [{"id": "str"}],
                                        "provisioningState": "str",
                                        "syncMode": "str",
                                        "tunnelInterfaces": [
                                            {"identifier": 0, "port": 0, "protocol": "str", "type": "str"}
                                        ],
                                        "type": "str",
                                        "virtualNetwork": {"id": "str"},
                                    }
                                ],
                                "loadBalancerInboundNatRules": [
                                    {
                                        "backendAddressPool": {"id": "str"},
                                        "backendIPConfiguration": ...,
                                        "backendPort": 0,
                                        "enableFloatingIP": bool,
                                        "enableTcpReset": bool,
                                        "etag": "str",
                                        "frontendIPConfiguration": {"id": "str"},
                                        "frontendPort": 0,
                                        "frontendPortRangeEnd": 0,
                                        "frontendPortRangeStart": 0,
                                        "id": "str",
                                        "idleTimeoutInMinutes": 0,
                                        "name": "str",
                                        "protocol": "str",
                                        "provisioningState": "str",
                                        "type": "str",
                                    }
                                ],
                                "name": "str",
                                "primary": bool,
                                "privateIPAddress": "str",
                                "privateIPAddressPrefixLength": 0,
                                "privateIPAddressVersion": "str",
                                "privateIPAllocationMethod": "str",
                                "privateLinkConnectionProperties": {
                                    "fqdns": ["str"],
                                    "groupId": "str",
                                    "requiredMemberName": "str",
                                },
                                "provisioningState": "str",
                                "publicIPAddress": {
                                    "ddosSettings": {"ddosProtectionPlan": {"id": "str"}, "protectionMode": "str"},
                                    "deleteOption": "str",
                                    "dnsSettings": {
                                        "domainNameLabel": "str",
                                        "domainNameLabelScope": "str",
                                        "fqdn": "str",
                                        "reverseFqdn": "str",
                                    },
                                    "etag": "str",
                                    "extendedLocation": {"name": "str", "type": "str"},
                                    "id": "str",
                                    "idleTimeoutInMinutes": 0,
                                    "ipAddress": "str",
                                    "ipConfiguration": {
                                        "etag": "str",
                                        "id": "str",
                                        "name": "str",
                                        "privateIPAddress": "str",
                                        "privateIPAllocationMethod": "str",
                                        "provisioningState": "str",
                                        "publicIPAddress": ...,
                                        "subnet": {
                                            "addressPrefix": "str",
                                            "addressPrefixes": ["str"],
                                            "applicationGatewayIPConfigurations": [
                                                {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "subnet": {"id": "str"},
                                                    "type": "str",
                                                }
                                            ],
                                            "defaultOutboundAccess": bool,
                                            "delegations": [
                                                {
                                                    "actions": ["str"],
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "serviceName": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "etag": "str",
                                            "id": "str",
                                            "ipAllocations": [{"id": "str"}],
                                            "ipConfigurationProfiles": [
                                                {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "subnet": ...,
                                                    "type": "str",
                                                }
                                            ],
                                            "ipConfigurations": [...],
                                            "ipamPoolPrefixAllocations": [
                                                {
                                                    "allocatedAddressPrefixes": ["str"],
                                                    "id": "str",
                                                    "numberOfIpAddresses": "str",
                                                }
                                            ],
                                            "name": "str",
                                            "natGateway": {"id": "str"},
                                            "networkSecurityGroup": {
                                                "defaultSecurityRules": [
                                                    {
                                                        "access": "str",
                                                        "description": "str",
                                                        "destinationAddressPrefix": "str",
                                                        "destinationAddressPrefixes": ["str"],
                                                        "destinationApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "destinationPortRange": "str",
                                                        "destinationPortRanges": ["str"],
                                                        "direction": "str",
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "priority": 0,
                                                        "protocol": "str",
                                                        "provisioningState": "str",
                                                        "sourceAddressPrefix": "str",
                                                        "sourceAddressPrefixes": ["str"],
                                                        "sourceApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "sourcePortRange": "str",
                                                        "sourcePortRanges": ["str"],
                                                        "type": "str",
                                                    }
                                                ],
                                                "etag": "str",
                                                "flowLogs": [
                                                    {
                                                        "enabled": bool,
                                                        "enabledFilteringCriteria": "str",
                                                        "etag": "str",
                                                        "flowAnalyticsConfiguration": {
                                                            "networkWatcherFlowAnalyticsConfiguration": {
                                                                "enabled": bool,
                                                                "trafficAnalyticsInterval": 0,
                                                                "workspaceId": "str",
                                                                "workspaceRegion": "str",
                                                                "workspaceResourceId": "str",
                                                            }
                                                        },
                                                        "format": {"type": "str", "version": 0},
                                                        "id": "str",
                                                        "identity": {
                                                            "principalId": "str",
                                                            "tenantId": "str",
                                                            "type": "str",
                                                            "userAssignedIdentities": {
                                                                "str": {"clientId": "str", "principalId": "str"}
                                                            },
                                                        },
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "recordTypes": "str",
                                                        "retentionPolicy": {"days": 0, "enabled": False},
                                                        "storageId": "str",
                                                        "tags": {"str": "str"},
                                                        "targetResourceGuid": "str",
                                                        "targetResourceId": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "flushConnection": bool,
                                                "id": "str",
                                                "location": "str",
                                                "name": "str",
                                                "networkInterfaces": [...],
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "securityRules": [
                                                    {
                                                        "access": "str",
                                                        "description": "str",
                                                        "destinationAddressPrefix": "str",
                                                        "destinationAddressPrefixes": ["str"],
                                                        "destinationApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "destinationPortRange": "str",
                                                        "destinationPortRanges": ["str"],
                                                        "direction": "str",
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "priority": 0,
                                                        "protocol": "str",
                                                        "provisioningState": "str",
                                                        "sourceAddressPrefix": "str",
                                                        "sourceAddressPrefixes": ["str"],
                                                        "sourceApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "sourcePortRange": "str",
                                                        "sourcePortRanges": ["str"],
                                                        "type": "str",
                                                    }
                                                ],
                                                "subnets": [...],
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            },
                                            "privateEndpointNetworkPolicies": "Disabled",
                                            "privateEndpoints": [...],
                                            "privateLinkServiceNetworkPolicies": "Enabled",
                                            "provisioningState": "str",
                                            "purpose": "str",
                                            "resourceNavigationLinks": [
                                                {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "link": "str",
                                                    "linkedResourceType": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "routeTable": {
                                                "disableBgpRoutePropagation": bool,
                                                "etag": "str",
                                                "id": "str",
                                                "location": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "routes": [
                                                    {
                                                        "addressPrefix": "str",
                                                        "etag": "str",
                                                        "hasBgpOverride": bool,
                                                        "id": "str",
                                                        "name": "str",
                                                        "nextHopIpAddress": "str",
                                                        "nextHopType": "str",
                                                        "provisioningState": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "subnets": [...],
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            },
                                            "serviceAssociationLinks": [
                                                {
                                                    "allowDelete": bool,
                                                    "etag": "str",
                                                    "id": "str",
                                                    "link": "str",
                                                    "linkedResourceType": "str",
                                                    "locations": ["str"],
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "serviceEndpointPolicies": [
                                                {
                                                    "contextualServiceEndpointPolicies": ["str"],
                                                    "etag": "str",
                                                    "id": "str",
                                                    "kind": "str",
                                                    "location": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "resourceGuid": "str",
                                                    "serviceAlias": "str",
                                                    "serviceEndpointPolicyDefinitions": [
                                                        {
                                                            "description": "str",
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "service": "str",
                                                            "serviceResources": ["str"],
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "subnets": [...],
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                }
                                            ],
                                            "serviceEndpoints": [
                                                {
                                                    "locations": ["str"],
                                                    "networkIdentifier": {"id": "str"},
                                                    "provisioningState": "str",
                                                    "service": "str",
                                                }
                                            ],
                                            "serviceGateway": {"id": "str"},
                                            "sharingScope": "str",
                                            "type": "str",
                                        },
                                    },
                                    "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                    "linkedPublicIPAddress": ...,
                                    "location": "str",
                                    "migrationPhase": "str",
                                    "name": "str",
                                    "natGateway": {
                                        "etag": "str",
                                        "id": "str",
                                        "idleTimeoutInMinutes": 0,
                                        "location": "str",
                                        "name": "str",
                                        "provisioningState": "str",
                                        "publicIpAddresses": [{"id": "str"}],
                                        "publicIpAddressesV6": [{"id": "str"}],
                                        "publicIpPrefixes": [{"id": "str"}],
                                        "publicIpPrefixesV6": [{"id": "str"}],
                                        "resourceGuid": "str",
                                        "serviceGateway": {"id": "str"},
                                        "sku": {"name": "str"},
                                        "sourceVirtualNetwork": {"id": "str"},
                                        "subnets": [{"id": "str"}],
                                        "tags": {"str": "str"},
                                        "type": "str",
                                        "zones": ["str"],
                                    },
                                    "provisioningState": "str",
                                    "publicIPAddressVersion": "str",
                                    "publicIPAllocationMethod": "str",
                                    "publicIPPrefix": {"id": "str"},
                                    "resourceGuid": "str",
                                    "servicePublicIPAddress": ...,
                                    "sku": {"name": "str", "tier": "str"},
                                    "tags": {"str": "str"},
                                    "type": "str",
                                    "zones": ["str"],
                                },
                                "subnet": {
                                    "addressPrefix": "str",
                                    "addressPrefixes": ["str"],
                                    "applicationGatewayIPConfigurations": [
                                        {
                                            "etag": "str",
                                            "id": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "subnet": {"id": "str"},
                                            "type": "str",
                                        }
                                    ],
                                    "defaultOutboundAccess": bool,
                                    "delegations": [
                                        {
                                            "actions": ["str"],
                                            "etag": "str",
                                            "id": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "serviceName": "str",
                                            "type": "str",
                                        }
                                    ],
                                    "etag": "str",
                                    "id": "str",
                                    "ipAllocations": [{"id": "str"}],
                                    "ipConfigurationProfiles": [
                                        {
                                            "etag": "str",
                                            "id": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "subnet": ...,
                                            "type": "str",
                                        }
                                    ],
                                    "ipConfigurations": [
                                        {
                                            "etag": "str",
                                            "id": "str",
                                            "name": "str",
                                            "privateIPAddress": "str",
                                            "privateIPAllocationMethod": "str",
                                            "provisioningState": "str",
                                            "publicIPAddress": {
                                                "ddosSettings": {
                                                    "ddosProtectionPlan": {"id": "str"},
                                                    "protectionMode": "str",
                                                },
                                                "deleteOption": "str",
                                                "dnsSettings": {
                                                    "domainNameLabel": "str",
                                                    "domainNameLabelScope": "str",
                                                    "fqdn": "str",
                                                    "reverseFqdn": "str",
                                                },
                                                "etag": "str",
                                                "extendedLocation": {"name": "str", "type": "str"},
                                                "id": "str",
                                                "idleTimeoutInMinutes": 0,
                                                "ipAddress": "str",
                                                "ipConfiguration": ...,
                                                "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                "linkedPublicIPAddress": ...,
                                                "location": "str",
                                                "migrationPhase": "str",
                                                "name": "str",
                                                "natGateway": {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "idleTimeoutInMinutes": 0,
                                                    "location": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "publicIpAddresses": [{"id": "str"}],
                                                    "publicIpAddressesV6": [{"id": "str"}],
                                                    "publicIpPrefixes": [{"id": "str"}],
                                                    "publicIpPrefixesV6": [{"id": "str"}],
                                                    "resourceGuid": "str",
                                                    "serviceGateway": {"id": "str"},
                                                    "sku": {"name": "str"},
                                                    "sourceVirtualNetwork": {"id": "str"},
                                                    "subnets": [{"id": "str"}],
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                    "zones": ["str"],
                                                },
                                                "provisioningState": "str",
                                                "publicIPAddressVersion": "str",
                                                "publicIPAllocationMethod": "str",
                                                "publicIPPrefix": {"id": "str"},
                                                "resourceGuid": "str",
                                                "servicePublicIPAddress": ...,
                                                "sku": {"name": "str", "tier": "str"},
                                                "tags": {"str": "str"},
                                                "type": "str",
                                                "zones": ["str"],
                                            },
                                            "subnet": ...,
                                        }
                                    ],
                                    "ipamPoolPrefixAllocations": [
                                        {"allocatedAddressPrefixes": ["str"], "id": "str", "numberOfIpAddresses": "str"}
                                    ],
                                    "name": "str",
                                    "natGateway": {"id": "str"},
                                    "networkSecurityGroup": {
                                        "defaultSecurityRules": [
                                            {
                                                "access": "str",
                                                "description": "str",
                                                "destinationAddressPrefix": "str",
                                                "destinationAddressPrefixes": ["str"],
                                                "destinationApplicationSecurityGroups": [
                                                    {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "resourceGuid": "str",
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                    }
                                                ],
                                                "destinationPortRange": "str",
                                                "destinationPortRanges": ["str"],
                                                "direction": "str",
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "priority": 0,
                                                "protocol": "str",
                                                "provisioningState": "str",
                                                "sourceAddressPrefix": "str",
                                                "sourceAddressPrefixes": ["str"],
                                                "sourceApplicationSecurityGroups": [
                                                    {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "resourceGuid": "str",
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                    }
                                                ],
                                                "sourcePortRange": "str",
                                                "sourcePortRanges": ["str"],
                                                "type": "str",
                                            }
                                        ],
                                        "etag": "str",
                                        "flowLogs": [
                                            {
                                                "enabled": bool,
                                                "enabledFilteringCriteria": "str",
                                                "etag": "str",
                                                "flowAnalyticsConfiguration": {
                                                    "networkWatcherFlowAnalyticsConfiguration": {
                                                        "enabled": bool,
                                                        "trafficAnalyticsInterval": 0,
                                                        "workspaceId": "str",
                                                        "workspaceRegion": "str",
                                                        "workspaceResourceId": "str",
                                                    }
                                                },
                                                "format": {"type": "str", "version": 0},
                                                "id": "str",
                                                "identity": {
                                                    "principalId": "str",
                                                    "tenantId": "str",
                                                    "type": "str",
                                                    "userAssignedIdentities": {
                                                        "str": {"clientId": "str", "principalId": "str"}
                                                    },
                                                },
                                                "location": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "recordTypes": "str",
                                                "retentionPolicy": {"days": 0, "enabled": False},
                                                "storageId": "str",
                                                "tags": {"str": "str"},
                                                "targetResourceGuid": "str",
                                                "targetResourceId": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "flushConnection": bool,
                                        "id": "str",
                                        "location": "str",
                                        "name": "str",
                                        "networkInterfaces": [...],
                                        "provisioningState": "str",
                                        "resourceGuid": "str",
                                        "securityRules": [
                                            {
                                                "access": "str",
                                                "description": "str",
                                                "destinationAddressPrefix": "str",
                                                "destinationAddressPrefixes": ["str"],
                                                "destinationApplicationSecurityGroups": [
                                                    {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "resourceGuid": "str",
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                    }
                                                ],
                                                "destinationPortRange": "str",
                                                "destinationPortRanges": ["str"],
                                                "direction": "str",
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "priority": 0,
                                                "protocol": "str",
                                                "provisioningState": "str",
                                                "sourceAddressPrefix": "str",
                                                "sourceAddressPrefixes": ["str"],
                                                "sourceApplicationSecurityGroups": [
                                                    {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "resourceGuid": "str",
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                    }
                                                ],
                                                "sourcePortRange": "str",
                                                "sourcePortRanges": ["str"],
                                                "type": "str",
                                            }
                                        ],
                                        "subnets": [...],
                                        "tags": {"str": "str"},
                                        "type": "str",
                                    },
                                    "privateEndpointNetworkPolicies": "Disabled",
                                    "privateEndpoints": [...],
                                    "privateLinkServiceNetworkPolicies": "Enabled",
                                    "provisioningState": "str",
                                    "purpose": "str",
                                    "resourceNavigationLinks": [
                                        {
                                            "etag": "str",
                                            "id": "str",
                                            "link": "str",
                                            "linkedResourceType": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "type": "str",
                                        }
                                    ],
                                    "routeTable": {
                                        "disableBgpRoutePropagation": bool,
                                        "etag": "str",
                                        "id": "str",
                                        "location": "str",
                                        "name": "str",
                                        "provisioningState": "str",
                                        "resourceGuid": "str",
                                        "routes": [
                                            {
                                                "addressPrefix": "str",
                                                "etag": "str",
                                                "hasBgpOverride": bool,
                                                "id": "str",
                                                "name": "str",
                                                "nextHopIpAddress": "str",
                                                "nextHopType": "str",
                                                "provisioningState": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "subnets": [...],
                                        "tags": {"str": "str"},
                                        "type": "str",
                                    },
                                    "serviceAssociationLinks": [
                                        {
                                            "allowDelete": bool,
                                            "etag": "str",
                                            "id": "str",
                                            "link": "str",
                                            "linkedResourceType": "str",
                                            "locations": ["str"],
                                            "name": "str",
                                            "provisioningState": "str",
                                            "type": "str",
                                        }
                                    ],
                                    "serviceEndpointPolicies": [
                                        {
                                            "contextualServiceEndpointPolicies": ["str"],
                                            "etag": "str",
                                            "id": "str",
                                            "kind": "str",
                                            "location": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "resourceGuid": "str",
                                            "serviceAlias": "str",
                                            "serviceEndpointPolicyDefinitions": [
                                                {
                                                    "description": "str",
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "service": "str",
                                                    "serviceResources": ["str"],
                                                    "type": "str",
                                                }
                                            ],
                                            "subnets": [...],
                                            "tags": {"str": "str"},
                                            "type": "str",
                                        }
                                    ],
                                    "serviceEndpoints": [
                                        {
                                            "locations": ["str"],
                                            "networkIdentifier": {"id": "str"},
                                            "provisioningState": "str",
                                            "service": "str",
                                        }
                                    ],
                                    "serviceGateway": {"id": "str"},
                                    "sharingScope": "str",
                                    "type": "str",
                                },
                                "type": "str",
                                "virtualNetworkTaps": [
                                    {
                                        "destinationLoadBalancerFrontEndIPConfiguration": {
                                            "etag": "str",
                                            "gatewayLoadBalancer": {"id": "str"},
                                            "id": "str",
                                            "inboundNatPools": [{"id": "str"}],
                                            "inboundNatRules": [{"id": "str"}],
                                            "loadBalancingRules": [{"id": "str"}],
                                            "name": "str",
                                            "outboundRules": [{"id": "str"}],
                                            "privateIPAddress": "str",
                                            "privateIPAddressVersion": "str",
                                            "privateIPAllocationMethod": "str",
                                            "provisioningState": "str",
                                            "publicIPAddress": {
                                                "ddosSettings": {
                                                    "ddosProtectionPlan": {"id": "str"},
                                                    "protectionMode": "str",
                                                },
                                                "deleteOption": "str",
                                                "dnsSettings": {
                                                    "domainNameLabel": "str",
                                                    "domainNameLabelScope": "str",
                                                    "fqdn": "str",
                                                    "reverseFqdn": "str",
                                                },
                                                "etag": "str",
                                                "extendedLocation": {"name": "str", "type": "str"},
                                                "id": "str",
                                                "idleTimeoutInMinutes": 0,
                                                "ipAddress": "str",
                                                "ipConfiguration": {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "privateIPAddress": "str",
                                                    "privateIPAllocationMethod": "str",
                                                    "provisioningState": "str",
                                                    "publicIPAddress": ...,
                                                    "subnet": {
                                                        "addressPrefix": "str",
                                                        "addressPrefixes": ["str"],
                                                        "applicationGatewayIPConfigurations": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "subnet": {"id": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "defaultOutboundAccess": bool,
                                                        "delegations": [
                                                            {
                                                                "actions": ["str"],
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "serviceName": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "etag": "str",
                                                        "id": "str",
                                                        "ipAllocations": [{"id": "str"}],
                                                        "ipConfigurationProfiles": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "subnet": ...,
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "ipConfigurations": [...],
                                                        "ipamPoolPrefixAllocations": [
                                                            {
                                                                "allocatedAddressPrefixes": ["str"],
                                                                "id": "str",
                                                                "numberOfIpAddresses": "str",
                                                            }
                                                        ],
                                                        "name": "str",
                                                        "natGateway": {"id": "str"},
                                                        "networkSecurityGroup": {
                                                            "defaultSecurityRules": [
                                                                {
                                                                    "access": "str",
                                                                    "description": "str",
                                                                    "destinationAddressPrefix": "str",
                                                                    "destinationAddressPrefixes": ["str"],
                                                                    "destinationApplicationSecurityGroups": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "destinationPortRange": "str",
                                                                    "destinationPortRanges": ["str"],
                                                                    "direction": "str",
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "priority": 0,
                                                                    "protocol": "str",
                                                                    "provisioningState": "str",
                                                                    "sourceAddressPrefix": "str",
                                                                    "sourceAddressPrefixes": ["str"],
                                                                    "sourceApplicationSecurityGroups": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "sourcePortRange": "str",
                                                                    "sourcePortRanges": ["str"],
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "etag": "str",
                                                            "flowLogs": [
                                                                {
                                                                    "enabled": bool,
                                                                    "enabledFilteringCriteria": "str",
                                                                    "etag": "str",
                                                                    "flowAnalyticsConfiguration": {
                                                                        "networkWatcherFlowAnalyticsConfiguration": {
                                                                            "enabled": bool,
                                                                            "trafficAnalyticsInterval": 0,
                                                                            "workspaceId": "str",
                                                                            "workspaceRegion": "str",
                                                                            "workspaceResourceId": "str",
                                                                        }
                                                                    },
                                                                    "format": {"type": "str", "version": 0},
                                                                    "id": "str",
                                                                    "identity": {
                                                                        "principalId": "str",
                                                                        "tenantId": "str",
                                                                        "type": "str",
                                                                        "userAssignedIdentities": {
                                                                            "str": {
                                                                                "clientId": "str",
                                                                                "principalId": "str",
                                                                            }
                                                                        },
                                                                    },
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "recordTypes": "str",
                                                                    "retentionPolicy": {"days": 0, "enabled": False},
                                                                    "storageId": "str",
                                                                    "tags": {"str": "str"},
                                                                    "targetResourceGuid": "str",
                                                                    "targetResourceId": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "flushConnection": bool,
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "networkInterfaces": [...],
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "securityRules": [
                                                                {
                                                                    "access": "str",
                                                                    "description": "str",
                                                                    "destinationAddressPrefix": "str",
                                                                    "destinationAddressPrefixes": ["str"],
                                                                    "destinationApplicationSecurityGroups": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "destinationPortRange": "str",
                                                                    "destinationPortRanges": ["str"],
                                                                    "direction": "str",
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "priority": 0,
                                                                    "protocol": "str",
                                                                    "provisioningState": "str",
                                                                    "sourceAddressPrefix": "str",
                                                                    "sourceAddressPrefixes": ["str"],
                                                                    "sourceApplicationSecurityGroups": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "sourcePortRange": "str",
                                                                    "sourcePortRanges": ["str"],
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "subnets": [...],
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        },
                                                        "privateEndpointNetworkPolicies": "Disabled",
                                                        "privateEndpoints": [...],
                                                        "privateLinkServiceNetworkPolicies": "Enabled",
                                                        "provisioningState": "str",
                                                        "purpose": "str",
                                                        "resourceNavigationLinks": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "link": "str",
                                                                "linkedResourceType": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "routeTable": {
                                                            "disableBgpRoutePropagation": bool,
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "routes": [
                                                                {
                                                                    "addressPrefix": "str",
                                                                    "etag": "str",
                                                                    "hasBgpOverride": bool,
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "nextHopIpAddress": "str",
                                                                    "nextHopType": "str",
                                                                    "provisioningState": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "subnets": [...],
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        },
                                                        "serviceAssociationLinks": [
                                                            {
                                                                "allowDelete": bool,
                                                                "etag": "str",
                                                                "id": "str",
                                                                "link": "str",
                                                                "linkedResourceType": "str",
                                                                "locations": ["str"],
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "serviceEndpointPolicies": [
                                                            {
                                                                "contextualServiceEndpointPolicies": ["str"],
                                                                "etag": "str",
                                                                "id": "str",
                                                                "kind": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "serviceAlias": "str",
                                                                "serviceEndpointPolicyDefinitions": [
                                                                    {
                                                                        "description": "str",
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "service": "str",
                                                                        "serviceResources": ["str"],
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "subnets": [...],
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "serviceEndpoints": [
                                                            {
                                                                "locations": ["str"],
                                                                "networkIdentifier": {"id": "str"},
                                                                "provisioningState": "str",
                                                                "service": "str",
                                                            }
                                                        ],
                                                        "serviceGateway": {"id": "str"},
                                                        "sharingScope": "str",
                                                        "type": "str",
                                                    },
                                                },
                                                "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                "linkedPublicIPAddress": ...,
                                                "location": "str",
                                                "migrationPhase": "str",
                                                "name": "str",
                                                "natGateway": {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "idleTimeoutInMinutes": 0,
                                                    "location": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "publicIpAddresses": [{"id": "str"}],
                                                    "publicIpAddressesV6": [{"id": "str"}],
                                                    "publicIpPrefixes": [{"id": "str"}],
                                                    "publicIpPrefixesV6": [{"id": "str"}],
                                                    "resourceGuid": "str",
                                                    "serviceGateway": {"id": "str"},
                                                    "sku": {"name": "str"},
                                                    "sourceVirtualNetwork": {"id": "str"},
                                                    "subnets": [{"id": "str"}],
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                    "zones": ["str"],
                                                },
                                                "provisioningState": "str",
                                                "publicIPAddressVersion": "str",
                                                "publicIPAllocationMethod": "str",
                                                "publicIPPrefix": {"id": "str"},
                                                "resourceGuid": "str",
                                                "servicePublicIPAddress": ...,
                                                "sku": {"name": "str", "tier": "str"},
                                                "tags": {"str": "str"},
                                                "type": "str",
                                                "zones": ["str"],
                                            },
                                            "publicIPPrefix": {"id": "str"},
                                            "subnet": {
                                                "addressPrefix": "str",
                                                "addressPrefixes": ["str"],
                                                "applicationGatewayIPConfigurations": [
                                                    {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "subnet": {"id": "str"},
                                                        "type": "str",
                                                    }
                                                ],
                                                "defaultOutboundAccess": bool,
                                                "delegations": [
                                                    {
                                                        "actions": ["str"],
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "serviceName": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "etag": "str",
                                                "id": "str",
                                                "ipAllocations": [{"id": "str"}],
                                                "ipConfigurationProfiles": [
                                                    {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "subnet": ...,
                                                        "type": "str",
                                                    }
                                                ],
                                                "ipConfigurations": [
                                                    {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "privateIPAddress": "str",
                                                        "privateIPAllocationMethod": "str",
                                                        "provisioningState": "str",
                                                        "publicIPAddress": {
                                                            "ddosSettings": {
                                                                "ddosProtectionPlan": {"id": "str"},
                                                                "protectionMode": "str",
                                                            },
                                                            "deleteOption": "str",
                                                            "dnsSettings": {
                                                                "domainNameLabel": "str",
                                                                "domainNameLabelScope": "str",
                                                                "fqdn": "str",
                                                                "reverseFqdn": "str",
                                                            },
                                                            "etag": "str",
                                                            "extendedLocation": {"name": "str", "type": "str"},
                                                            "id": "str",
                                                            "idleTimeoutInMinutes": 0,
                                                            "ipAddress": "str",
                                                            "ipConfiguration": ...,
                                                            "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                            "linkedPublicIPAddress": ...,
                                                            "location": "str",
                                                            "migrationPhase": "str",
                                                            "name": "str",
                                                            "natGateway": {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "idleTimeoutInMinutes": 0,
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "publicIpAddresses": [{"id": "str"}],
                                                                "publicIpAddressesV6": [{"id": "str"}],
                                                                "publicIpPrefixes": [{"id": "str"}],
                                                                "publicIpPrefixesV6": [{"id": "str"}],
                                                                "resourceGuid": "str",
                                                                "serviceGateway": {"id": "str"},
                                                                "sku": {"name": "str"},
                                                                "sourceVirtualNetwork": {"id": "str"},
                                                                "subnets": [{"id": "str"}],
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                                "zones": ["str"],
                                                            },
                                                            "provisioningState": "str",
                                                            "publicIPAddressVersion": "str",
                                                            "publicIPAllocationMethod": "str",
                                                            "publicIPPrefix": {"id": "str"},
                                                            "resourceGuid": "str",
                                                            "servicePublicIPAddress": ...,
                                                            "sku": {"name": "str", "tier": "str"},
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                            "zones": ["str"],
                                                        },
                                                        "subnet": ...,
                                                    }
                                                ],
                                                "ipamPoolPrefixAllocations": [
                                                    {
                                                        "allocatedAddressPrefixes": ["str"],
                                                        "id": "str",
                                                        "numberOfIpAddresses": "str",
                                                    }
                                                ],
                                                "name": "str",
                                                "natGateway": {"id": "str"},
                                                "networkSecurityGroup": {
                                                    "defaultSecurityRules": [
                                                        {
                                                            "access": "str",
                                                            "description": "str",
                                                            "destinationAddressPrefix": "str",
                                                            "destinationAddressPrefixes": ["str"],
                                                            "destinationApplicationSecurityGroups": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "destinationPortRange": "str",
                                                            "destinationPortRanges": ["str"],
                                                            "direction": "str",
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "priority": 0,
                                                            "protocol": "str",
                                                            "provisioningState": "str",
                                                            "sourceAddressPrefix": "str",
                                                            "sourceAddressPrefixes": ["str"],
                                                            "sourceApplicationSecurityGroups": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "sourcePortRange": "str",
                                                            "sourcePortRanges": ["str"],
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "etag": "str",
                                                    "flowLogs": [
                                                        {
                                                            "enabled": bool,
                                                            "enabledFilteringCriteria": "str",
                                                            "etag": "str",
                                                            "flowAnalyticsConfiguration": {
                                                                "networkWatcherFlowAnalyticsConfiguration": {
                                                                    "enabled": bool,
                                                                    "trafficAnalyticsInterval": 0,
                                                                    "workspaceId": "str",
                                                                    "workspaceRegion": "str",
                                                                    "workspaceResourceId": "str",
                                                                }
                                                            },
                                                            "format": {"type": "str", "version": 0},
                                                            "id": "str",
                                                            "identity": {
                                                                "principalId": "str",
                                                                "tenantId": "str",
                                                                "type": "str",
                                                                "userAssignedIdentities": {
                                                                    "str": {"clientId": "str", "principalId": "str"}
                                                                },
                                                            },
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "recordTypes": "str",
                                                            "retentionPolicy": {"days": 0, "enabled": False},
                                                            "storageId": "str",
                                                            "tags": {"str": "str"},
                                                            "targetResourceGuid": "str",
                                                            "targetResourceId": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "flushConnection": bool,
                                                    "id": "str",
                                                    "location": "str",
                                                    "name": "str",
                                                    "networkInterfaces": [...],
                                                    "provisioningState": "str",
                                                    "resourceGuid": "str",
                                                    "securityRules": [
                                                        {
                                                            "access": "str",
                                                            "description": "str",
                                                            "destinationAddressPrefix": "str",
                                                            "destinationAddressPrefixes": ["str"],
                                                            "destinationApplicationSecurityGroups": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "destinationPortRange": "str",
                                                            "destinationPortRanges": ["str"],
                                                            "direction": "str",
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "priority": 0,
                                                            "protocol": "str",
                                                            "provisioningState": "str",
                                                            "sourceAddressPrefix": "str",
                                                            "sourceAddressPrefixes": ["str"],
                                                            "sourceApplicationSecurityGroups": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "sourcePortRange": "str",
                                                            "sourcePortRanges": ["str"],
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "subnets": [...],
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                },
                                                "privateEndpointNetworkPolicies": "Disabled",
                                                "privateEndpoints": [...],
                                                "privateLinkServiceNetworkPolicies": "Enabled",
                                                "provisioningState": "str",
                                                "purpose": "str",
                                                "resourceNavigationLinks": [
                                                    {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "link": "str",
                                                        "linkedResourceType": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "routeTable": {
                                                    "disableBgpRoutePropagation": bool,
                                                    "etag": "str",
                                                    "id": "str",
                                                    "location": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "resourceGuid": "str",
                                                    "routes": [
                                                        {
                                                            "addressPrefix": "str",
                                                            "etag": "str",
                                                            "hasBgpOverride": bool,
                                                            "id": "str",
                                                            "name": "str",
                                                            "nextHopIpAddress": "str",
                                                            "nextHopType": "str",
                                                            "provisioningState": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "subnets": [...],
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                },
                                                "serviceAssociationLinks": [
                                                    {
                                                        "allowDelete": bool,
                                                        "etag": "str",
                                                        "id": "str",
                                                        "link": "str",
                                                        "linkedResourceType": "str",
                                                        "locations": ["str"],
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "serviceEndpointPolicies": [
                                                    {
                                                        "contextualServiceEndpointPolicies": ["str"],
                                                        "etag": "str",
                                                        "id": "str",
                                                        "kind": "str",
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "resourceGuid": "str",
                                                        "serviceAlias": "str",
                                                        "serviceEndpointPolicyDefinitions": [
                                                            {
                                                                "description": "str",
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "service": "str",
                                                                "serviceResources": ["str"],
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "subnets": [...],
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                    }
                                                ],
                                                "serviceEndpoints": [
                                                    {
                                                        "locations": ["str"],
                                                        "networkIdentifier": {"id": "str"},
                                                        "provisioningState": "str",
                                                        "service": "str",
                                                    }
                                                ],
                                                "serviceGateway": {"id": "str"},
                                                "sharingScope": "str",
                                                "type": "str",
                                            },
                                            "type": "str",
                                            "zones": ["str"],
                                        },
                                        "destinationNetworkInterfaceIPConfiguration": ...,
                                        "destinationPort": 0,
                                        "etag": "str",
                                        "id": "str",
                                        "location": "str",
                                        "name": "str",
                                        "networkInterfaceTapConfigurations": [
                                            {
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "type": "str",
                                                "virtualNetworkTap": ...,
                                            }
                                        ],
                                        "provisioningState": "str",
                                        "resourceGuid": "str",
                                        "tags": {"str": "str"},
                                        "type": "str",
                                    }
                                ],
                            }
                        ],
                        "location": "str",
                        "macAddress": "str",
                        "migrationPhase": "str",
                        "name": "str",
                        "networkSecurityGroup": {
                            "defaultSecurityRules": [
                                {
                                    "access": "str",
                                    "description": "str",
                                    "destinationAddressPrefix": "str",
                                    "destinationAddressPrefixes": ["str"],
                                    "destinationApplicationSecurityGroups": [
                                        {
                                            "etag": "str",
                                            "id": "str",
                                            "location": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "resourceGuid": "str",
                                            "tags": {"str": "str"},
                                            "type": "str",
                                        }
                                    ],
                                    "destinationPortRange": "str",
                                    "destinationPortRanges": ["str"],
                                    "direction": "str",
                                    "etag": "str",
                                    "id": "str",
                                    "name": "str",
                                    "priority": 0,
                                    "protocol": "str",
                                    "provisioningState": "str",
                                    "sourceAddressPrefix": "str",
                                    "sourceAddressPrefixes": ["str"],
                                    "sourceApplicationSecurityGroups": [
                                        {
                                            "etag": "str",
                                            "id": "str",
                                            "location": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "resourceGuid": "str",
                                            "tags": {"str": "str"},
                                            "type": "str",
                                        }
                                    ],
                                    "sourcePortRange": "str",
                                    "sourcePortRanges": ["str"],
                                    "type": "str",
                                }
                            ],
                            "etag": "str",
                            "flowLogs": [
                                {
                                    "enabled": bool,
                                    "enabledFilteringCriteria": "str",
                                    "etag": "str",
                                    "flowAnalyticsConfiguration": {
                                        "networkWatcherFlowAnalyticsConfiguration": {
                                            "enabled": bool,
                                            "trafficAnalyticsInterval": 0,
                                            "workspaceId": "str",
                                            "workspaceRegion": "str",
                                            "workspaceResourceId": "str",
                                        }
                                    },
                                    "format": {"type": "str", "version": 0},
                                    "id": "str",
                                    "identity": {
                                        "principalId": "str",
                                        "tenantId": "str",
                                        "type": "str",
                                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                                    },
                                    "location": "str",
                                    "name": "str",
                                    "provisioningState": "str",
                                    "recordTypes": "str",
                                    "retentionPolicy": {"days": 0, "enabled": False},
                                    "storageId": "str",
                                    "tags": {"str": "str"},
                                    "targetResourceGuid": "str",
                                    "targetResourceId": "str",
                                    "type": "str",
                                }
                            ],
                            "flushConnection": bool,
                            "id": "str",
                            "location": "str",
                            "name": "str",
                            "networkInterfaces": [...],
                            "provisioningState": "str",
                            "resourceGuid": "str",
                            "securityRules": [
                                {
                                    "access": "str",
                                    "description": "str",
                                    "destinationAddressPrefix": "str",
                                    "destinationAddressPrefixes": ["str"],
                                    "destinationApplicationSecurityGroups": [
                                        {
                                            "etag": "str",
                                            "id": "str",
                                            "location": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "resourceGuid": "str",
                                            "tags": {"str": "str"},
                                            "type": "str",
                                        }
                                    ],
                                    "destinationPortRange": "str",
                                    "destinationPortRanges": ["str"],
                                    "direction": "str",
                                    "etag": "str",
                                    "id": "str",
                                    "name": "str",
                                    "priority": 0,
                                    "protocol": "str",
                                    "provisioningState": "str",
                                    "sourceAddressPrefix": "str",
                                    "sourceAddressPrefixes": ["str"],
                                    "sourceApplicationSecurityGroups": [
                                        {
                                            "etag": "str",
                                            "id": "str",
                                            "location": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "resourceGuid": "str",
                                            "tags": {"str": "str"},
                                            "type": "str",
                                        }
                                    ],
                                    "sourcePortRange": "str",
                                    "sourcePortRanges": ["str"],
                                    "type": "str",
                                }
                            ],
                            "subnets": [
                                {
                                    "addressPrefix": "str",
                                    "addressPrefixes": ["str"],
                                    "applicationGatewayIPConfigurations": [
                                        {
                                            "etag": "str",
                                            "id": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "subnet": {"id": "str"},
                                            "type": "str",
                                        }
                                    ],
                                    "defaultOutboundAccess": bool,
                                    "delegations": [
                                        {
                                            "actions": ["str"],
                                            "etag": "str",
                                            "id": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "serviceName": "str",
                                            "type": "str",
                                        }
                                    ],
                                    "etag": "str",
                                    "id": "str",
                                    "ipAllocations": [{"id": "str"}],
                                    "ipConfigurationProfiles": [
                                        {
                                            "etag": "str",
                                            "id": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "subnet": ...,
                                            "type": "str",
                                        }
                                    ],
                                    "ipConfigurations": [
                                        {
                                            "etag": "str",
                                            "id": "str",
                                            "name": "str",
                                            "privateIPAddress": "str",
                                            "privateIPAllocationMethod": "str",
                                            "provisioningState": "str",
                                            "publicIPAddress": {
                                                "ddosSettings": {
                                                    "ddosProtectionPlan": {"id": "str"},
                                                    "protectionMode": "str",
                                                },
                                                "deleteOption": "str",
                                                "dnsSettings": {
                                                    "domainNameLabel": "str",
                                                    "domainNameLabelScope": "str",
                                                    "fqdn": "str",
                                                    "reverseFqdn": "str",
                                                },
                                                "etag": "str",
                                                "extendedLocation": {"name": "str", "type": "str"},
                                                "id": "str",
                                                "idleTimeoutInMinutes": 0,
                                                "ipAddress": "str",
                                                "ipConfiguration": ...,
                                                "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                "linkedPublicIPAddress": ...,
                                                "location": "str",
                                                "migrationPhase": "str",
                                                "name": "str",
                                                "natGateway": {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "idleTimeoutInMinutes": 0,
                                                    "location": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "publicIpAddresses": [{"id": "str"}],
                                                    "publicIpAddressesV6": [{"id": "str"}],
                                                    "publicIpPrefixes": [{"id": "str"}],
                                                    "publicIpPrefixesV6": [{"id": "str"}],
                                                    "resourceGuid": "str",
                                                    "serviceGateway": {"id": "str"},
                                                    "sku": {"name": "str"},
                                                    "sourceVirtualNetwork": {"id": "str"},
                                                    "subnets": [{"id": "str"}],
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                    "zones": ["str"],
                                                },
                                                "provisioningState": "str",
                                                "publicIPAddressVersion": "str",
                                                "publicIPAllocationMethod": "str",
                                                "publicIPPrefix": {"id": "str"},
                                                "resourceGuid": "str",
                                                "servicePublicIPAddress": ...,
                                                "sku": {"name": "str", "tier": "str"},
                                                "tags": {"str": "str"},
                                                "type": "str",
                                                "zones": ["str"],
                                            },
                                            "subnet": ...,
                                        }
                                    ],
                                    "ipamPoolPrefixAllocations": [
                                        {"allocatedAddressPrefixes": ["str"], "id": "str", "numberOfIpAddresses": "str"}
                                    ],
                                    "name": "str",
                                    "natGateway": {"id": "str"},
                                    "networkSecurityGroup": ...,
                                    "privateEndpointNetworkPolicies": "Disabled",
                                    "privateEndpoints": [...],
                                    "privateLinkServiceNetworkPolicies": "Enabled",
                                    "provisioningState": "str",
                                    "purpose": "str",
                                    "resourceNavigationLinks": [
                                        {
                                            "etag": "str",
                                            "id": "str",
                                            "link": "str",
                                            "linkedResourceType": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "type": "str",
                                        }
                                    ],
                                    "routeTable": {
                                        "disableBgpRoutePropagation": bool,
                                        "etag": "str",
                                        "id": "str",
                                        "location": "str",
                                        "name": "str",
                                        "provisioningState": "str",
                                        "resourceGuid": "str",
                                        "routes": [
                                            {
                                                "addressPrefix": "str",
                                                "etag": "str",
                                                "hasBgpOverride": bool,
                                                "id": "str",
                                                "name": "str",
                                                "nextHopIpAddress": "str",
                                                "nextHopType": "str",
                                                "provisioningState": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "subnets": [...],
                                        "tags": {"str": "str"},
                                        "type": "str",
                                    },
                                    "serviceAssociationLinks": [
                                        {
                                            "allowDelete": bool,
                                            "etag": "str",
                                            "id": "str",
                                            "link": "str",
                                            "linkedResourceType": "str",
                                            "locations": ["str"],
                                            "name": "str",
                                            "provisioningState": "str",
                                            "type": "str",
                                        }
                                    ],
                                    "serviceEndpointPolicies": [
                                        {
                                            "contextualServiceEndpointPolicies": ["str"],
                                            "etag": "str",
                                            "id": "str",
                                            "kind": "str",
                                            "location": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "resourceGuid": "str",
                                            "serviceAlias": "str",
                                            "serviceEndpointPolicyDefinitions": [
                                                {
                                                    "description": "str",
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "service": "str",
                                                    "serviceResources": ["str"],
                                                    "type": "str",
                                                }
                                            ],
                                            "subnets": [...],
                                            "tags": {"str": "str"},
                                            "type": "str",
                                        }
                                    ],
                                    "serviceEndpoints": [
                                        {
                                            "locations": ["str"],
                                            "networkIdentifier": {"id": "str"},
                                            "provisioningState": "str",
                                            "service": "str",
                                        }
                                    ],
                                    "serviceGateway": {"id": "str"},
                                    "sharingScope": "str",
                                    "type": "str",
                                }
                            ],
                            "tags": {"str": "str"},
                            "type": "str",
                        },
                        "nicType": "str",
                        "primary": bool,
                        "privateEndpoint": ...,
                        "privateLinkService": {
                            "accessMode": "str",
                            "alias": "str",
                            "autoApproval": {"subscriptions": ["str"]},
                            "destinationIPAddress": "str",
                            "enableProxyProtocol": bool,
                            "etag": "str",
                            "extendedLocation": {"name": "str", "type": "str"},
                            "fqdns": ["str"],
                            "id": "str",
                            "ipConfigurations": [
                                {
                                    "etag": "str",
                                    "id": "str",
                                    "name": "str",
                                    "primary": bool,
                                    "privateIPAddress": "str",
                                    "privateIPAddressVersion": "str",
                                    "privateIPAllocationMethod": "str",
                                    "provisioningState": "str",
                                    "subnet": {
                                        "addressPrefix": "str",
                                        "addressPrefixes": ["str"],
                                        "applicationGatewayIPConfigurations": [
                                            {
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "subnet": {"id": "str"},
                                                "type": "str",
                                            }
                                        ],
                                        "defaultOutboundAccess": bool,
                                        "delegations": [
                                            {
                                                "actions": ["str"],
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "serviceName": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "etag": "str",
                                        "id": "str",
                                        "ipAllocations": [{"id": "str"}],
                                        "ipConfigurationProfiles": [
                                            {
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "subnet": ...,
                                                "type": "str",
                                            }
                                        ],
                                        "ipConfigurations": [
                                            {
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "privateIPAddress": "str",
                                                "privateIPAllocationMethod": "str",
                                                "provisioningState": "str",
                                                "publicIPAddress": {
                                                    "ddosSettings": {
                                                        "ddosProtectionPlan": {"id": "str"},
                                                        "protectionMode": "str",
                                                    },
                                                    "deleteOption": "str",
                                                    "dnsSettings": {
                                                        "domainNameLabel": "str",
                                                        "domainNameLabelScope": "str",
                                                        "fqdn": "str",
                                                        "reverseFqdn": "str",
                                                    },
                                                    "etag": "str",
                                                    "extendedLocation": {"name": "str", "type": "str"},
                                                    "id": "str",
                                                    "idleTimeoutInMinutes": 0,
                                                    "ipAddress": "str",
                                                    "ipConfiguration": ...,
                                                    "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                    "linkedPublicIPAddress": ...,
                                                    "location": "str",
                                                    "migrationPhase": "str",
                                                    "name": "str",
                                                    "natGateway": {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "idleTimeoutInMinutes": 0,
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "publicIpAddresses": [{"id": "str"}],
                                                        "publicIpAddressesV6": [{"id": "str"}],
                                                        "publicIpPrefixes": [{"id": "str"}],
                                                        "publicIpPrefixesV6": [{"id": "str"}],
                                                        "resourceGuid": "str",
                                                        "serviceGateway": {"id": "str"},
                                                        "sku": {"name": "str"},
                                                        "sourceVirtualNetwork": {"id": "str"},
                                                        "subnets": [{"id": "str"}],
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                        "zones": ["str"],
                                                    },
                                                    "provisioningState": "str",
                                                    "publicIPAddressVersion": "str",
                                                    "publicIPAllocationMethod": "str",
                                                    "publicIPPrefix": {"id": "str"},
                                                    "resourceGuid": "str",
                                                    "servicePublicIPAddress": ...,
                                                    "sku": {"name": "str", "tier": "str"},
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                    "zones": ["str"],
                                                },
                                                "subnet": ...,
                                            }
                                        ],
                                        "ipamPoolPrefixAllocations": [
                                            {
                                                "allocatedAddressPrefixes": ["str"],
                                                "id": "str",
                                                "numberOfIpAddresses": "str",
                                            }
                                        ],
                                        "name": "str",
                                        "natGateway": {"id": "str"},
                                        "networkSecurityGroup": {
                                            "defaultSecurityRules": [
                                                {
                                                    "access": "str",
                                                    "description": "str",
                                                    "destinationAddressPrefix": "str",
                                                    "destinationAddressPrefixes": ["str"],
                                                    "destinationApplicationSecurityGroups": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "destinationPortRange": "str",
                                                    "destinationPortRanges": ["str"],
                                                    "direction": "str",
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "priority": 0,
                                                    "protocol": "str",
                                                    "provisioningState": "str",
                                                    "sourceAddressPrefix": "str",
                                                    "sourceAddressPrefixes": ["str"],
                                                    "sourceApplicationSecurityGroups": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "sourcePortRange": "str",
                                                    "sourcePortRanges": ["str"],
                                                    "type": "str",
                                                }
                                            ],
                                            "etag": "str",
                                            "flowLogs": [
                                                {
                                                    "enabled": bool,
                                                    "enabledFilteringCriteria": "str",
                                                    "etag": "str",
                                                    "flowAnalyticsConfiguration": {
                                                        "networkWatcherFlowAnalyticsConfiguration": {
                                                            "enabled": bool,
                                                            "trafficAnalyticsInterval": 0,
                                                            "workspaceId": "str",
                                                            "workspaceRegion": "str",
                                                            "workspaceResourceId": "str",
                                                        }
                                                    },
                                                    "format": {"type": "str", "version": 0},
                                                    "id": "str",
                                                    "identity": {
                                                        "principalId": "str",
                                                        "tenantId": "str",
                                                        "type": "str",
                                                        "userAssignedIdentities": {
                                                            "str": {"clientId": "str", "principalId": "str"}
                                                        },
                                                    },
                                                    "location": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "recordTypes": "str",
                                                    "retentionPolicy": {"days": 0, "enabled": False},
                                                    "storageId": "str",
                                                    "tags": {"str": "str"},
                                                    "targetResourceGuid": "str",
                                                    "targetResourceId": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "flushConnection": bool,
                                            "id": "str",
                                            "location": "str",
                                            "name": "str",
                                            "networkInterfaces": [...],
                                            "provisioningState": "str",
                                            "resourceGuid": "str",
                                            "securityRules": [
                                                {
                                                    "access": "str",
                                                    "description": "str",
                                                    "destinationAddressPrefix": "str",
                                                    "destinationAddressPrefixes": ["str"],
                                                    "destinationApplicationSecurityGroups": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "destinationPortRange": "str",
                                                    "destinationPortRanges": ["str"],
                                                    "direction": "str",
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "priority": 0,
                                                    "protocol": "str",
                                                    "provisioningState": "str",
                                                    "sourceAddressPrefix": "str",
                                                    "sourceAddressPrefixes": ["str"],
                                                    "sourceApplicationSecurityGroups": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "sourcePortRange": "str",
                                                    "sourcePortRanges": ["str"],
                                                    "type": "str",
                                                }
                                            ],
                                            "subnets": [...],
                                            "tags": {"str": "str"},
                                            "type": "str",
                                        },
                                        "privateEndpointNetworkPolicies": "Disabled",
                                        "privateEndpoints": [...],
                                        "privateLinkServiceNetworkPolicies": "Enabled",
                                        "provisioningState": "str",
                                        "purpose": "str",
                                        "resourceNavigationLinks": [
                                            {
                                                "etag": "str",
                                                "id": "str",
                                                "link": "str",
                                                "linkedResourceType": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "routeTable": {
                                            "disableBgpRoutePropagation": bool,
                                            "etag": "str",
                                            "id": "str",
                                            "location": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "resourceGuid": "str",
                                            "routes": [
                                                {
                                                    "addressPrefix": "str",
                                                    "etag": "str",
                                                    "hasBgpOverride": bool,
                                                    "id": "str",
                                                    "name": "str",
                                                    "nextHopIpAddress": "str",
                                                    "nextHopType": "str",
                                                    "provisioningState": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "subnets": [...],
                                            "tags": {"str": "str"},
                                            "type": "str",
                                        },
                                        "serviceAssociationLinks": [
                                            {
                                                "allowDelete": bool,
                                                "etag": "str",
                                                "id": "str",
                                                "link": "str",
                                                "linkedResourceType": "str",
                                                "locations": ["str"],
                                                "name": "str",
                                                "provisioningState": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "serviceEndpointPolicies": [
                                            {
                                                "contextualServiceEndpointPolicies": ["str"],
                                                "etag": "str",
                                                "id": "str",
                                                "kind": "str",
                                                "location": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "serviceAlias": "str",
                                                "serviceEndpointPolicyDefinitions": [
                                                    {
                                                        "description": "str",
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "service": "str",
                                                        "serviceResources": ["str"],
                                                        "type": "str",
                                                    }
                                                ],
                                                "subnets": [...],
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            }
                                        ],
                                        "serviceEndpoints": [
                                            {
                                                "locations": ["str"],
                                                "networkIdentifier": {"id": "str"},
                                                "provisioningState": "str",
                                                "service": "str",
                                            }
                                        ],
                                        "serviceGateway": {"id": "str"},
                                        "sharingScope": "str",
                                        "type": "str",
                                    },
                                    "type": "str",
                                }
                            ],
                            "loadBalancerFrontendIpConfigurations": [
                                {
                                    "etag": "str",
                                    "gatewayLoadBalancer": {"id": "str"},
                                    "id": "str",
                                    "inboundNatPools": [{"id": "str"}],
                                    "inboundNatRules": [{"id": "str"}],
                                    "loadBalancingRules": [{"id": "str"}],
                                    "name": "str",
                                    "outboundRules": [{"id": "str"}],
                                    "privateIPAddress": "str",
                                    "privateIPAddressVersion": "str",
                                    "privateIPAllocationMethod": "str",
                                    "provisioningState": "str",
                                    "publicIPAddress": {
                                        "ddosSettings": {"ddosProtectionPlan": {"id": "str"}, "protectionMode": "str"},
                                        "deleteOption": "str",
                                        "dnsSettings": {
                                            "domainNameLabel": "str",
                                            "domainNameLabelScope": "str",
                                            "fqdn": "str",
                                            "reverseFqdn": "str",
                                        },
                                        "etag": "str",
                                        "extendedLocation": {"name": "str", "type": "str"},
                                        "id": "str",
                                        "idleTimeoutInMinutes": 0,
                                        "ipAddress": "str",
                                        "ipConfiguration": {
                                            "etag": "str",
                                            "id": "str",
                                            "name": "str",
                                            "privateIPAddress": "str",
                                            "privateIPAllocationMethod": "str",
                                            "provisioningState": "str",
                                            "publicIPAddress": ...,
                                            "subnet": {
                                                "addressPrefix": "str",
                                                "addressPrefixes": ["str"],
                                                "applicationGatewayIPConfigurations": [
                                                    {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "subnet": {"id": "str"},
                                                        "type": "str",
                                                    }
                                                ],
                                                "defaultOutboundAccess": bool,
                                                "delegations": [
                                                    {
                                                        "actions": ["str"],
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "serviceName": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "etag": "str",
                                                "id": "str",
                                                "ipAllocations": [{"id": "str"}],
                                                "ipConfigurationProfiles": [
                                                    {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "subnet": ...,
                                                        "type": "str",
                                                    }
                                                ],
                                                "ipConfigurations": [...],
                                                "ipamPoolPrefixAllocations": [
                                                    {
                                                        "allocatedAddressPrefixes": ["str"],
                                                        "id": "str",
                                                        "numberOfIpAddresses": "str",
                                                    }
                                                ],
                                                "name": "str",
                                                "natGateway": {"id": "str"},
                                                "networkSecurityGroup": {
                                                    "defaultSecurityRules": [
                                                        {
                                                            "access": "str",
                                                            "description": "str",
                                                            "destinationAddressPrefix": "str",
                                                            "destinationAddressPrefixes": ["str"],
                                                            "destinationApplicationSecurityGroups": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "destinationPortRange": "str",
                                                            "destinationPortRanges": ["str"],
                                                            "direction": "str",
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "priority": 0,
                                                            "protocol": "str",
                                                            "provisioningState": "str",
                                                            "sourceAddressPrefix": "str",
                                                            "sourceAddressPrefixes": ["str"],
                                                            "sourceApplicationSecurityGroups": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "sourcePortRange": "str",
                                                            "sourcePortRanges": ["str"],
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "etag": "str",
                                                    "flowLogs": [
                                                        {
                                                            "enabled": bool,
                                                            "enabledFilteringCriteria": "str",
                                                            "etag": "str",
                                                            "flowAnalyticsConfiguration": {
                                                                "networkWatcherFlowAnalyticsConfiguration": {
                                                                    "enabled": bool,
                                                                    "trafficAnalyticsInterval": 0,
                                                                    "workspaceId": "str",
                                                                    "workspaceRegion": "str",
                                                                    "workspaceResourceId": "str",
                                                                }
                                                            },
                                                            "format": {"type": "str", "version": 0},
                                                            "id": "str",
                                                            "identity": {
                                                                "principalId": "str",
                                                                "tenantId": "str",
                                                                "type": "str",
                                                                "userAssignedIdentities": {
                                                                    "str": {"clientId": "str", "principalId": "str"}
                                                                },
                                                            },
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "recordTypes": "str",
                                                            "retentionPolicy": {"days": 0, "enabled": False},
                                                            "storageId": "str",
                                                            "tags": {"str": "str"},
                                                            "targetResourceGuid": "str",
                                                            "targetResourceId": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "flushConnection": bool,
                                                    "id": "str",
                                                    "location": "str",
                                                    "name": "str",
                                                    "networkInterfaces": [...],
                                                    "provisioningState": "str",
                                                    "resourceGuid": "str",
                                                    "securityRules": [
                                                        {
                                                            "access": "str",
                                                            "description": "str",
                                                            "destinationAddressPrefix": "str",
                                                            "destinationAddressPrefixes": ["str"],
                                                            "destinationApplicationSecurityGroups": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "destinationPortRange": "str",
                                                            "destinationPortRanges": ["str"],
                                                            "direction": "str",
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "priority": 0,
                                                            "protocol": "str",
                                                            "provisioningState": "str",
                                                            "sourceAddressPrefix": "str",
                                                            "sourceAddressPrefixes": ["str"],
                                                            "sourceApplicationSecurityGroups": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "sourcePortRange": "str",
                                                            "sourcePortRanges": ["str"],
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "subnets": [...],
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                },
                                                "privateEndpointNetworkPolicies": "Disabled",
                                                "privateEndpoints": [...],
                                                "privateLinkServiceNetworkPolicies": "Enabled",
                                                "provisioningState": "str",
                                                "purpose": "str",
                                                "resourceNavigationLinks": [
                                                    {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "link": "str",
                                                        "linkedResourceType": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "routeTable": {
                                                    "disableBgpRoutePropagation": bool,
                                                    "etag": "str",
                                                    "id": "str",
                                                    "location": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "resourceGuid": "str",
                                                    "routes": [
                                                        {
                                                            "addressPrefix": "str",
                                                            "etag": "str",
                                                            "hasBgpOverride": bool,
                                                            "id": "str",
                                                            "name": "str",
                                                            "nextHopIpAddress": "str",
                                                            "nextHopType": "str",
                                                            "provisioningState": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "subnets": [...],
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                },
                                                "serviceAssociationLinks": [
                                                    {
                                                        "allowDelete": bool,
                                                        "etag": "str",
                                                        "id": "str",
                                                        "link": "str",
                                                        "linkedResourceType": "str",
                                                        "locations": ["str"],
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "serviceEndpointPolicies": [
                                                    {
                                                        "contextualServiceEndpointPolicies": ["str"],
                                                        "etag": "str",
                                                        "id": "str",
                                                        "kind": "str",
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "resourceGuid": "str",
                                                        "serviceAlias": "str",
                                                        "serviceEndpointPolicyDefinitions": [
                                                            {
                                                                "description": "str",
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "service": "str",
                                                                "serviceResources": ["str"],
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "subnets": [...],
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                    }
                                                ],
                                                "serviceEndpoints": [
                                                    {
                                                        "locations": ["str"],
                                                        "networkIdentifier": {"id": "str"},
                                                        "provisioningState": "str",
                                                        "service": "str",
                                                    }
                                                ],
                                                "serviceGateway": {"id": "str"},
                                                "sharingScope": "str",
                                                "type": "str",
                                            },
                                        },
                                        "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                        "linkedPublicIPAddress": ...,
                                        "location": "str",
                                        "migrationPhase": "str",
                                        "name": "str",
                                        "natGateway": {
                                            "etag": "str",
                                            "id": "str",
                                            "idleTimeoutInMinutes": 0,
                                            "location": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "publicIpAddresses": [{"id": "str"}],
                                            "publicIpAddressesV6": [{"id": "str"}],
                                            "publicIpPrefixes": [{"id": "str"}],
                                            "publicIpPrefixesV6": [{"id": "str"}],
                                            "resourceGuid": "str",
                                            "serviceGateway": {"id": "str"},
                                            "sku": {"name": "str"},
                                            "sourceVirtualNetwork": {"id": "str"},
                                            "subnets": [{"id": "str"}],
                                            "tags": {"str": "str"},
                                            "type": "str",
                                            "zones": ["str"],
                                        },
                                        "provisioningState": "str",
                                        "publicIPAddressVersion": "str",
                                        "publicIPAllocationMethod": "str",
                                        "publicIPPrefix": {"id": "str"},
                                        "resourceGuid": "str",
                                        "servicePublicIPAddress": ...,
                                        "sku": {"name": "str", "tier": "str"},
                                        "tags": {"str": "str"},
                                        "type": "str",
                                        "zones": ["str"],
                                    },
                                    "publicIPPrefix": {"id": "str"},
                                    "subnet": {
                                        "addressPrefix": "str",
                                        "addressPrefixes": ["str"],
                                        "applicationGatewayIPConfigurations": [
                                            {
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "subnet": {"id": "str"},
                                                "type": "str",
                                            }
                                        ],
                                        "defaultOutboundAccess": bool,
                                        "delegations": [
                                            {
                                                "actions": ["str"],
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "serviceName": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "etag": "str",
                                        "id": "str",
                                        "ipAllocations": [{"id": "str"}],
                                        "ipConfigurationProfiles": [
                                            {
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "subnet": ...,
                                                "type": "str",
                                            }
                                        ],
                                        "ipConfigurations": [
                                            {
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "privateIPAddress": "str",
                                                "privateIPAllocationMethod": "str",
                                                "provisioningState": "str",
                                                "publicIPAddress": {
                                                    "ddosSettings": {
                                                        "ddosProtectionPlan": {"id": "str"},
                                                        "protectionMode": "str",
                                                    },
                                                    "deleteOption": "str",
                                                    "dnsSettings": {
                                                        "domainNameLabel": "str",
                                                        "domainNameLabelScope": "str",
                                                        "fqdn": "str",
                                                        "reverseFqdn": "str",
                                                    },
                                                    "etag": "str",
                                                    "extendedLocation": {"name": "str", "type": "str"},
                                                    "id": "str",
                                                    "idleTimeoutInMinutes": 0,
                                                    "ipAddress": "str",
                                                    "ipConfiguration": ...,
                                                    "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                    "linkedPublicIPAddress": ...,
                                                    "location": "str",
                                                    "migrationPhase": "str",
                                                    "name": "str",
                                                    "natGateway": {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "idleTimeoutInMinutes": 0,
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "publicIpAddresses": [{"id": "str"}],
                                                        "publicIpAddressesV6": [{"id": "str"}],
                                                        "publicIpPrefixes": [{"id": "str"}],
                                                        "publicIpPrefixesV6": [{"id": "str"}],
                                                        "resourceGuid": "str",
                                                        "serviceGateway": {"id": "str"},
                                                        "sku": {"name": "str"},
                                                        "sourceVirtualNetwork": {"id": "str"},
                                                        "subnets": [{"id": "str"}],
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                        "zones": ["str"],
                                                    },
                                                    "provisioningState": "str",
                                                    "publicIPAddressVersion": "str",
                                                    "publicIPAllocationMethod": "str",
                                                    "publicIPPrefix": {"id": "str"},
                                                    "resourceGuid": "str",
                                                    "servicePublicIPAddress": ...,
                                                    "sku": {"name": "str", "tier": "str"},
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                    "zones": ["str"],
                                                },
                                                "subnet": ...,
                                            }
                                        ],
                                        "ipamPoolPrefixAllocations": [
                                            {
                                                "allocatedAddressPrefixes": ["str"],
                                                "id": "str",
                                                "numberOfIpAddresses": "str",
                                            }
                                        ],
                                        "name": "str",
                                        "natGateway": {"id": "str"},
                                        "networkSecurityGroup": {
                                            "defaultSecurityRules": [
                                                {
                                                    "access": "str",
                                                    "description": "str",
                                                    "destinationAddressPrefix": "str",
                                                    "destinationAddressPrefixes": ["str"],
                                                    "destinationApplicationSecurityGroups": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "destinationPortRange": "str",
                                                    "destinationPortRanges": ["str"],
                                                    "direction": "str",
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "priority": 0,
                                                    "protocol": "str",
                                                    "provisioningState": "str",
                                                    "sourceAddressPrefix": "str",
                                                    "sourceAddressPrefixes": ["str"],
                                                    "sourceApplicationSecurityGroups": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "sourcePortRange": "str",
                                                    "sourcePortRanges": ["str"],
                                                    "type": "str",
                                                }
                                            ],
                                            "etag": "str",
                                            "flowLogs": [
                                                {
                                                    "enabled": bool,
                                                    "enabledFilteringCriteria": "str",
                                                    "etag": "str",
                                                    "flowAnalyticsConfiguration": {
                                                        "networkWatcherFlowAnalyticsConfiguration": {
                                                            "enabled": bool,
                                                            "trafficAnalyticsInterval": 0,
                                                            "workspaceId": "str",
                                                            "workspaceRegion": "str",
                                                            "workspaceResourceId": "str",
                                                        }
                                                    },
                                                    "format": {"type": "str", "version": 0},
                                                    "id": "str",
                                                    "identity": {
                                                        "principalId": "str",
                                                        "tenantId": "str",
                                                        "type": "str",
                                                        "userAssignedIdentities": {
                                                            "str": {"clientId": "str", "principalId": "str"}
                                                        },
                                                    },
                                                    "location": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "recordTypes": "str",
                                                    "retentionPolicy": {"days": 0, "enabled": False},
                                                    "storageId": "str",
                                                    "tags": {"str": "str"},
                                                    "targetResourceGuid": "str",
                                                    "targetResourceId": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "flushConnection": bool,
                                            "id": "str",
                                            "location": "str",
                                            "name": "str",
                                            "networkInterfaces": [...],
                                            "provisioningState": "str",
                                            "resourceGuid": "str",
                                            "securityRules": [
                                                {
                                                    "access": "str",
                                                    "description": "str",
                                                    "destinationAddressPrefix": "str",
                                                    "destinationAddressPrefixes": ["str"],
                                                    "destinationApplicationSecurityGroups": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "destinationPortRange": "str",
                                                    "destinationPortRanges": ["str"],
                                                    "direction": "str",
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "priority": 0,
                                                    "protocol": "str",
                                                    "provisioningState": "str",
                                                    "sourceAddressPrefix": "str",
                                                    "sourceAddressPrefixes": ["str"],
                                                    "sourceApplicationSecurityGroups": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "sourcePortRange": "str",
                                                    "sourcePortRanges": ["str"],
                                                    "type": "str",
                                                }
                                            ],
                                            "subnets": [...],
                                            "tags": {"str": "str"},
                                            "type": "str",
                                        },
                                        "privateEndpointNetworkPolicies": "Disabled",
                                        "privateEndpoints": [...],
                                        "privateLinkServiceNetworkPolicies": "Enabled",
                                        "provisioningState": "str",
                                        "purpose": "str",
                                        "resourceNavigationLinks": [
                                            {
                                                "etag": "str",
                                                "id": "str",
                                                "link": "str",
                                                "linkedResourceType": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "routeTable": {
                                            "disableBgpRoutePropagation": bool,
                                            "etag": "str",
                                            "id": "str",
                                            "location": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "resourceGuid": "str",
                                            "routes": [
                                                {
                                                    "addressPrefix": "str",
                                                    "etag": "str",
                                                    "hasBgpOverride": bool,
                                                    "id": "str",
                                                    "name": "str",
                                                    "nextHopIpAddress": "str",
                                                    "nextHopType": "str",
                                                    "provisioningState": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "subnets": [...],
                                            "tags": {"str": "str"},
                                            "type": "str",
                                        },
                                        "serviceAssociationLinks": [
                                            {
                                                "allowDelete": bool,
                                                "etag": "str",
                                                "id": "str",
                                                "link": "str",
                                                "linkedResourceType": "str",
                                                "locations": ["str"],
                                                "name": "str",
                                                "provisioningState": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "serviceEndpointPolicies": [
                                            {
                                                "contextualServiceEndpointPolicies": ["str"],
                                                "etag": "str",
                                                "id": "str",
                                                "kind": "str",
                                                "location": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "serviceAlias": "str",
                                                "serviceEndpointPolicyDefinitions": [
                                                    {
                                                        "description": "str",
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "service": "str",
                                                        "serviceResources": ["str"],
                                                        "type": "str",
                                                    }
                                                ],
                                                "subnets": [...],
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            }
                                        ],
                                        "serviceEndpoints": [
                                            {
                                                "locations": ["str"],
                                                "networkIdentifier": {"id": "str"},
                                                "provisioningState": "str",
                                                "service": "str",
                                            }
                                        ],
                                        "serviceGateway": {"id": "str"},
                                        "sharingScope": "str",
                                        "type": "str",
                                    },
                                    "type": "str",
                                    "zones": ["str"],
                                }
                            ],
                            "location": "str",
                            "name": "str",
                            "networkInterfaces": [...],
                            "privateEndpointConnections": [
                                {
                                    "etag": "str",
                                    "id": "str",
                                    "linkIdentifier": "str",
                                    "name": "str",
                                    "privateEndpoint": ...,
                                    "privateEndpointLocation": "str",
                                    "privateLinkServiceConnectionState": {
                                        "actionsRequired": "str",
                                        "description": "str",
                                        "status": "str",
                                    },
                                    "provisioningState": "str",
                                    "type": "str",
                                }
                            ],
                            "provisioningState": "str",
                            "tags": {"str": "str"},
                            "type": "str",
                            "visibility": {"subscriptions": ["str"]},
                        },
                        "provisioningState": "str",
                        "resourceGuid": "str",
                        "tags": {"str": "str"},
                        "tapConfigurations": [
                            {
                                "etag": "str",
                                "id": "str",
                                "name": "str",
                                "provisioningState": "str",
                                "type": "str",
                                "virtualNetworkTap": {
                                    "destinationLoadBalancerFrontEndIPConfiguration": {
                                        "etag": "str",
                                        "gatewayLoadBalancer": {"id": "str"},
                                        "id": "str",
                                        "inboundNatPools": [{"id": "str"}],
                                        "inboundNatRules": [{"id": "str"}],
                                        "loadBalancingRules": [{"id": "str"}],
                                        "name": "str",
                                        "outboundRules": [{"id": "str"}],
                                        "privateIPAddress": "str",
                                        "privateIPAddressVersion": "str",
                                        "privateIPAllocationMethod": "str",
                                        "provisioningState": "str",
                                        "publicIPAddress": {
                                            "ddosSettings": {
                                                "ddosProtectionPlan": {"id": "str"},
                                                "protectionMode": "str",
                                            },
                                            "deleteOption": "str",
                                            "dnsSettings": {
                                                "domainNameLabel": "str",
                                                "domainNameLabelScope": "str",
                                                "fqdn": "str",
                                                "reverseFqdn": "str",
                                            },
                                            "etag": "str",
                                            "extendedLocation": {"name": "str", "type": "str"},
                                            "id": "str",
                                            "idleTimeoutInMinutes": 0,
                                            "ipAddress": "str",
                                            "ipConfiguration": {
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "privateIPAddress": "str",
                                                "privateIPAllocationMethod": "str",
                                                "provisioningState": "str",
                                                "publicIPAddress": ...,
                                                "subnet": {
                                                    "addressPrefix": "str",
                                                    "addressPrefixes": ["str"],
                                                    "applicationGatewayIPConfigurations": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "subnet": {"id": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "defaultOutboundAccess": bool,
                                                    "delegations": [
                                                        {
                                                            "actions": ["str"],
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "serviceName": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "etag": "str",
                                                    "id": "str",
                                                    "ipAllocations": [{"id": "str"}],
                                                    "ipConfigurationProfiles": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "subnet": ...,
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "ipConfigurations": [...],
                                                    "ipamPoolPrefixAllocations": [
                                                        {
                                                            "allocatedAddressPrefixes": ["str"],
                                                            "id": "str",
                                                            "numberOfIpAddresses": "str",
                                                        }
                                                    ],
                                                    "name": "str",
                                                    "natGateway": {"id": "str"},
                                                    "networkSecurityGroup": {
                                                        "defaultSecurityRules": [
                                                            {
                                                                "access": "str",
                                                                "description": "str",
                                                                "destinationAddressPrefix": "str",
                                                                "destinationAddressPrefixes": ["str"],
                                                                "destinationApplicationSecurityGroups": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "destinationPortRange": "str",
                                                                "destinationPortRanges": ["str"],
                                                                "direction": "str",
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "priority": 0,
                                                                "protocol": "str",
                                                                "provisioningState": "str",
                                                                "sourceAddressPrefix": "str",
                                                                "sourceAddressPrefixes": ["str"],
                                                                "sourceApplicationSecurityGroups": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "sourcePortRange": "str",
                                                                "sourcePortRanges": ["str"],
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "etag": "str",
                                                        "flowLogs": [
                                                            {
                                                                "enabled": bool,
                                                                "enabledFilteringCriteria": "str",
                                                                "etag": "str",
                                                                "flowAnalyticsConfiguration": {
                                                                    "networkWatcherFlowAnalyticsConfiguration": {
                                                                        "enabled": bool,
                                                                        "trafficAnalyticsInterval": 0,
                                                                        "workspaceId": "str",
                                                                        "workspaceRegion": "str",
                                                                        "workspaceResourceId": "str",
                                                                    }
                                                                },
                                                                "format": {"type": "str", "version": 0},
                                                                "id": "str",
                                                                "identity": {
                                                                    "principalId": "str",
                                                                    "tenantId": "str",
                                                                    "type": "str",
                                                                    "userAssignedIdentities": {
                                                                        "str": {"clientId": "str", "principalId": "str"}
                                                                    },
                                                                },
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "recordTypes": "str",
                                                                "retentionPolicy": {"days": 0, "enabled": False},
                                                                "storageId": "str",
                                                                "tags": {"str": "str"},
                                                                "targetResourceGuid": "str",
                                                                "targetResourceId": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "flushConnection": bool,
                                                        "id": "str",
                                                        "location": "str",
                                                        "name": "str",
                                                        "networkInterfaces": [...],
                                                        "provisioningState": "str",
                                                        "resourceGuid": "str",
                                                        "securityRules": [
                                                            {
                                                                "access": "str",
                                                                "description": "str",
                                                                "destinationAddressPrefix": "str",
                                                                "destinationAddressPrefixes": ["str"],
                                                                "destinationApplicationSecurityGroups": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "destinationPortRange": "str",
                                                                "destinationPortRanges": ["str"],
                                                                "direction": "str",
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "priority": 0,
                                                                "protocol": "str",
                                                                "provisioningState": "str",
                                                                "sourceAddressPrefix": "str",
                                                                "sourceAddressPrefixes": ["str"],
                                                                "sourceApplicationSecurityGroups": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "sourcePortRange": "str",
                                                                "sourcePortRanges": ["str"],
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "subnets": [...],
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                    },
                                                    "privateEndpointNetworkPolicies": "Disabled",
                                                    "privateEndpoints": [...],
                                                    "privateLinkServiceNetworkPolicies": "Enabled",
                                                    "provisioningState": "str",
                                                    "purpose": "str",
                                                    "resourceNavigationLinks": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "link": "str",
                                                            "linkedResourceType": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "routeTable": {
                                                        "disableBgpRoutePropagation": bool,
                                                        "etag": "str",
                                                        "id": "str",
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "resourceGuid": "str",
                                                        "routes": [
                                                            {
                                                                "addressPrefix": "str",
                                                                "etag": "str",
                                                                "hasBgpOverride": bool,
                                                                "id": "str",
                                                                "name": "str",
                                                                "nextHopIpAddress": "str",
                                                                "nextHopType": "str",
                                                                "provisioningState": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "subnets": [...],
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                    },
                                                    "serviceAssociationLinks": [
                                                        {
                                                            "allowDelete": bool,
                                                            "etag": "str",
                                                            "id": "str",
                                                            "link": "str",
                                                            "linkedResourceType": "str",
                                                            "locations": ["str"],
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "serviceEndpointPolicies": [
                                                        {
                                                            "contextualServiceEndpointPolicies": ["str"],
                                                            "etag": "str",
                                                            "id": "str",
                                                            "kind": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "serviceAlias": "str",
                                                            "serviceEndpointPolicyDefinitions": [
                                                                {
                                                                    "description": "str",
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "service": "str",
                                                                    "serviceResources": ["str"],
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "subnets": [...],
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "serviceEndpoints": [
                                                        {
                                                            "locations": ["str"],
                                                            "networkIdentifier": {"id": "str"},
                                                            "provisioningState": "str",
                                                            "service": "str",
                                                        }
                                                    ],
                                                    "serviceGateway": {"id": "str"},
                                                    "sharingScope": "str",
                                                    "type": "str",
                                                },
                                            },
                                            "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                            "linkedPublicIPAddress": ...,
                                            "location": "str",
                                            "migrationPhase": "str",
                                            "name": "str",
                                            "natGateway": {
                                                "etag": "str",
                                                "id": "str",
                                                "idleTimeoutInMinutes": 0,
                                                "location": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "publicIpAddresses": [{"id": "str"}],
                                                "publicIpAddressesV6": [{"id": "str"}],
                                                "publicIpPrefixes": [{"id": "str"}],
                                                "publicIpPrefixesV6": [{"id": "str"}],
                                                "resourceGuid": "str",
                                                "serviceGateway": {"id": "str"},
                                                "sku": {"name": "str"},
                                                "sourceVirtualNetwork": {"id": "str"},
                                                "subnets": [{"id": "str"}],
                                                "tags": {"str": "str"},
                                                "type": "str",
                                                "zones": ["str"],
                                            },
                                            "provisioningState": "str",
                                            "publicIPAddressVersion": "str",
                                            "publicIPAllocationMethod": "str",
                                            "publicIPPrefix": {"id": "str"},
                                            "resourceGuid": "str",
                                            "servicePublicIPAddress": ...,
                                            "sku": {"name": "str", "tier": "str"},
                                            "tags": {"str": "str"},
                                            "type": "str",
                                            "zones": ["str"],
                                        },
                                        "publicIPPrefix": {"id": "str"},
                                        "subnet": {
                                            "addressPrefix": "str",
                                            "addressPrefixes": ["str"],
                                            "applicationGatewayIPConfigurations": [
                                                {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "subnet": {"id": "str"},
                                                    "type": "str",
                                                }
                                            ],
                                            "defaultOutboundAccess": bool,
                                            "delegations": [
                                                {
                                                    "actions": ["str"],
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "serviceName": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "etag": "str",
                                            "id": "str",
                                            "ipAllocations": [{"id": "str"}],
                                            "ipConfigurationProfiles": [
                                                {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "subnet": ...,
                                                    "type": "str",
                                                }
                                            ],
                                            "ipConfigurations": [
                                                {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "privateIPAddress": "str",
                                                    "privateIPAllocationMethod": "str",
                                                    "provisioningState": "str",
                                                    "publicIPAddress": {
                                                        "ddosSettings": {
                                                            "ddosProtectionPlan": {"id": "str"},
                                                            "protectionMode": "str",
                                                        },
                                                        "deleteOption": "str",
                                                        "dnsSettings": {
                                                            "domainNameLabel": "str",
                                                            "domainNameLabelScope": "str",
                                                            "fqdn": "str",
                                                            "reverseFqdn": "str",
                                                        },
                                                        "etag": "str",
                                                        "extendedLocation": {"name": "str", "type": "str"},
                                                        "id": "str",
                                                        "idleTimeoutInMinutes": 0,
                                                        "ipAddress": "str",
                                                        "ipConfiguration": ...,
                                                        "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                        "linkedPublicIPAddress": ...,
                                                        "location": "str",
                                                        "migrationPhase": "str",
                                                        "name": "str",
                                                        "natGateway": {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "idleTimeoutInMinutes": 0,
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "publicIpAddresses": [{"id": "str"}],
                                                            "publicIpAddressesV6": [{"id": "str"}],
                                                            "publicIpPrefixes": [{"id": "str"}],
                                                            "publicIpPrefixesV6": [{"id": "str"}],
                                                            "resourceGuid": "str",
                                                            "serviceGateway": {"id": "str"},
                                                            "sku": {"name": "str"},
                                                            "sourceVirtualNetwork": {"id": "str"},
                                                            "subnets": [{"id": "str"}],
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                            "zones": ["str"],
                                                        },
                                                        "provisioningState": "str",
                                                        "publicIPAddressVersion": "str",
                                                        "publicIPAllocationMethod": "str",
                                                        "publicIPPrefix": {"id": "str"},
                                                        "resourceGuid": "str",
                                                        "servicePublicIPAddress": ...,
                                                        "sku": {"name": "str", "tier": "str"},
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                        "zones": ["str"],
                                                    },
                                                    "subnet": ...,
                                                }
                                            ],
                                            "ipamPoolPrefixAllocations": [
                                                {
                                                    "allocatedAddressPrefixes": ["str"],
                                                    "id": "str",
                                                    "numberOfIpAddresses": "str",
                                                }
                                            ],
                                            "name": "str",
                                            "natGateway": {"id": "str"},
                                            "networkSecurityGroup": {
                                                "defaultSecurityRules": [
                                                    {
                                                        "access": "str",
                                                        "description": "str",
                                                        "destinationAddressPrefix": "str",
                                                        "destinationAddressPrefixes": ["str"],
                                                        "destinationApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "destinationPortRange": "str",
                                                        "destinationPortRanges": ["str"],
                                                        "direction": "str",
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "priority": 0,
                                                        "protocol": "str",
                                                        "provisioningState": "str",
                                                        "sourceAddressPrefix": "str",
                                                        "sourceAddressPrefixes": ["str"],
                                                        "sourceApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "sourcePortRange": "str",
                                                        "sourcePortRanges": ["str"],
                                                        "type": "str",
                                                    }
                                                ],
                                                "etag": "str",
                                                "flowLogs": [
                                                    {
                                                        "enabled": bool,
                                                        "enabledFilteringCriteria": "str",
                                                        "etag": "str",
                                                        "flowAnalyticsConfiguration": {
                                                            "networkWatcherFlowAnalyticsConfiguration": {
                                                                "enabled": bool,
                                                                "trafficAnalyticsInterval": 0,
                                                                "workspaceId": "str",
                                                                "workspaceRegion": "str",
                                                                "workspaceResourceId": "str",
                                                            }
                                                        },
                                                        "format": {"type": "str", "version": 0},
                                                        "id": "str",
                                                        "identity": {
                                                            "principalId": "str",
                                                            "tenantId": "str",
                                                            "type": "str",
                                                            "userAssignedIdentities": {
                                                                "str": {"clientId": "str", "principalId": "str"}
                                                            },
                                                        },
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "recordTypes": "str",
                                                        "retentionPolicy": {"days": 0, "enabled": False},
                                                        "storageId": "str",
                                                        "tags": {"str": "str"},
                                                        "targetResourceGuid": "str",
                                                        "targetResourceId": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "flushConnection": bool,
                                                "id": "str",
                                                "location": "str",
                                                "name": "str",
                                                "networkInterfaces": [...],
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "securityRules": [
                                                    {
                                                        "access": "str",
                                                        "description": "str",
                                                        "destinationAddressPrefix": "str",
                                                        "destinationAddressPrefixes": ["str"],
                                                        "destinationApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "destinationPortRange": "str",
                                                        "destinationPortRanges": ["str"],
                                                        "direction": "str",
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "priority": 0,
                                                        "protocol": "str",
                                                        "provisioningState": "str",
                                                        "sourceAddressPrefix": "str",
                                                        "sourceAddressPrefixes": ["str"],
                                                        "sourceApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "sourcePortRange": "str",
                                                        "sourcePortRanges": ["str"],
                                                        "type": "str",
                                                    }
                                                ],
                                                "subnets": [...],
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            },
                                            "privateEndpointNetworkPolicies": "Disabled",
                                            "privateEndpoints": [...],
                                            "privateLinkServiceNetworkPolicies": "Enabled",
                                            "provisioningState": "str",
                                            "purpose": "str",
                                            "resourceNavigationLinks": [
                                                {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "link": "str",
                                                    "linkedResourceType": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "routeTable": {
                                                "disableBgpRoutePropagation": bool,
                                                "etag": "str",
                                                "id": "str",
                                                "location": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "routes": [
                                                    {
                                                        "addressPrefix": "str",
                                                        "etag": "str",
                                                        "hasBgpOverride": bool,
                                                        "id": "str",
                                                        "name": "str",
                                                        "nextHopIpAddress": "str",
                                                        "nextHopType": "str",
                                                        "provisioningState": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "subnets": [...],
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            },
                                            "serviceAssociationLinks": [
                                                {
                                                    "allowDelete": bool,
                                                    "etag": "str",
                                                    "id": "str",
                                                    "link": "str",
                                                    "linkedResourceType": "str",
                                                    "locations": ["str"],
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "serviceEndpointPolicies": [
                                                {
                                                    "contextualServiceEndpointPolicies": ["str"],
                                                    "etag": "str",
                                                    "id": "str",
                                                    "kind": "str",
                                                    "location": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "resourceGuid": "str",
                                                    "serviceAlias": "str",
                                                    "serviceEndpointPolicyDefinitions": [
                                                        {
                                                            "description": "str",
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "service": "str",
                                                            "serviceResources": ["str"],
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "subnets": [...],
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                }
                                            ],
                                            "serviceEndpoints": [
                                                {
                                                    "locations": ["str"],
                                                    "networkIdentifier": {"id": "str"},
                                                    "provisioningState": "str",
                                                    "service": "str",
                                                }
                                            ],
                                            "serviceGateway": {"id": "str"},
                                            "sharingScope": "str",
                                            "type": "str",
                                        },
                                        "type": "str",
                                        "zones": ["str"],
                                    },
                                    "destinationNetworkInterfaceIPConfiguration": {
                                        "applicationGatewayBackendAddressPools": [
                                            {
                                                "backendAddresses": [{"fqdn": "str", "ipAddress": "str"}],
                                                "backendIPConfigurations": [...],
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "applicationSecurityGroups": [
                                            {
                                                "etag": "str",
                                                "id": "str",
                                                "location": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            }
                                        ],
                                        "etag": "str",
                                        "gatewayLoadBalancer": {"id": "str"},
                                        "id": "str",
                                        "loadBalancerBackendAddressPools": [
                                            {
                                                "backendIPConfigurations": [...],
                                                "drainPeriodInSeconds": 0,
                                                "etag": "str",
                                                "id": "str",
                                                "inboundNatRules": [{"id": "str"}],
                                                "loadBalancerBackendAddresses": [
                                                    {
                                                        "adminState": "str",
                                                        "inboundNatRulesPortMapping": [
                                                            {
                                                                "backendPort": 0,
                                                                "frontendPort": 0,
                                                                "inboundNatRuleName": "str",
                                                            }
                                                        ],
                                                        "ipAddress": "str",
                                                        "loadBalancerFrontendIPConfiguration": {"id": "str"},
                                                        "name": "str",
                                                        "networkInterfaceIPConfiguration": {"id": "str"},
                                                        "subnet": {"id": "str"},
                                                        "virtualNetwork": {"id": "str"},
                                                    }
                                                ],
                                                "loadBalancingRules": [{"id": "str"}],
                                                "location": "str",
                                                "name": "str",
                                                "outboundRule": {"id": "str"},
                                                "outboundRules": [{"id": "str"}],
                                                "provisioningState": "str",
                                                "syncMode": "str",
                                                "tunnelInterfaces": [
                                                    {"identifier": 0, "port": 0, "protocol": "str", "type": "str"}
                                                ],
                                                "type": "str",
                                                "virtualNetwork": {"id": "str"},
                                            }
                                        ],
                                        "loadBalancerInboundNatRules": [
                                            {
                                                "backendAddressPool": {"id": "str"},
                                                "backendIPConfiguration": ...,
                                                "backendPort": 0,
                                                "enableFloatingIP": bool,
                                                "enableTcpReset": bool,
                                                "etag": "str",
                                                "frontendIPConfiguration": {"id": "str"},
                                                "frontendPort": 0,
                                                "frontendPortRangeEnd": 0,
                                                "frontendPortRangeStart": 0,
                                                "id": "str",
                                                "idleTimeoutInMinutes": 0,
                                                "name": "str",
                                                "protocol": "str",
                                                "provisioningState": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "name": "str",
                                        "primary": bool,
                                        "privateIPAddress": "str",
                                        "privateIPAddressPrefixLength": 0,
                                        "privateIPAddressVersion": "str",
                                        "privateIPAllocationMethod": "str",
                                        "privateLinkConnectionProperties": {
                                            "fqdns": ["str"],
                                            "groupId": "str",
                                            "requiredMemberName": "str",
                                        },
                                        "provisioningState": "str",
                                        "publicIPAddress": {
                                            "ddosSettings": {
                                                "ddosProtectionPlan": {"id": "str"},
                                                "protectionMode": "str",
                                            },
                                            "deleteOption": "str",
                                            "dnsSettings": {
                                                "domainNameLabel": "str",
                                                "domainNameLabelScope": "str",
                                                "fqdn": "str",
                                                "reverseFqdn": "str",
                                            },
                                            "etag": "str",
                                            "extendedLocation": {"name": "str", "type": "str"},
                                            "id": "str",
                                            "idleTimeoutInMinutes": 0,
                                            "ipAddress": "str",
                                            "ipConfiguration": {
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "privateIPAddress": "str",
                                                "privateIPAllocationMethod": "str",
                                                "provisioningState": "str",
                                                "publicIPAddress": ...,
                                                "subnet": {
                                                    "addressPrefix": "str",
                                                    "addressPrefixes": ["str"],
                                                    "applicationGatewayIPConfigurations": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "subnet": {"id": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "defaultOutboundAccess": bool,
                                                    "delegations": [
                                                        {
                                                            "actions": ["str"],
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "serviceName": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "etag": "str",
                                                    "id": "str",
                                                    "ipAllocations": [{"id": "str"}],
                                                    "ipConfigurationProfiles": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "subnet": ...,
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "ipConfigurations": [...],
                                                    "ipamPoolPrefixAllocations": [
                                                        {
                                                            "allocatedAddressPrefixes": ["str"],
                                                            "id": "str",
                                                            "numberOfIpAddresses": "str",
                                                        }
                                                    ],
                                                    "name": "str",
                                                    "natGateway": {"id": "str"},
                                                    "networkSecurityGroup": {
                                                        "defaultSecurityRules": [
                                                            {
                                                                "access": "str",
                                                                "description": "str",
                                                                "destinationAddressPrefix": "str",
                                                                "destinationAddressPrefixes": ["str"],
                                                                "destinationApplicationSecurityGroups": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "destinationPortRange": "str",
                                                                "destinationPortRanges": ["str"],
                                                                "direction": "str",
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "priority": 0,
                                                                "protocol": "str",
                                                                "provisioningState": "str",
                                                                "sourceAddressPrefix": "str",
                                                                "sourceAddressPrefixes": ["str"],
                                                                "sourceApplicationSecurityGroups": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "sourcePortRange": "str",
                                                                "sourcePortRanges": ["str"],
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "etag": "str",
                                                        "flowLogs": [
                                                            {
                                                                "enabled": bool,
                                                                "enabledFilteringCriteria": "str",
                                                                "etag": "str",
                                                                "flowAnalyticsConfiguration": {
                                                                    "networkWatcherFlowAnalyticsConfiguration": {
                                                                        "enabled": bool,
                                                                        "trafficAnalyticsInterval": 0,
                                                                        "workspaceId": "str",
                                                                        "workspaceRegion": "str",
                                                                        "workspaceResourceId": "str",
                                                                    }
                                                                },
                                                                "format": {"type": "str", "version": 0},
                                                                "id": "str",
                                                                "identity": {
                                                                    "principalId": "str",
                                                                    "tenantId": "str",
                                                                    "type": "str",
                                                                    "userAssignedIdentities": {
                                                                        "str": {"clientId": "str", "principalId": "str"}
                                                                    },
                                                                },
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "recordTypes": "str",
                                                                "retentionPolicy": {"days": 0, "enabled": False},
                                                                "storageId": "str",
                                                                "tags": {"str": "str"},
                                                                "targetResourceGuid": "str",
                                                                "targetResourceId": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "flushConnection": bool,
                                                        "id": "str",
                                                        "location": "str",
                                                        "name": "str",
                                                        "networkInterfaces": [...],
                                                        "provisioningState": "str",
                                                        "resourceGuid": "str",
                                                        "securityRules": [
                                                            {
                                                                "access": "str",
                                                                "description": "str",
                                                                "destinationAddressPrefix": "str",
                                                                "destinationAddressPrefixes": ["str"],
                                                                "destinationApplicationSecurityGroups": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "destinationPortRange": "str",
                                                                "destinationPortRanges": ["str"],
                                                                "direction": "str",
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "priority": 0,
                                                                "protocol": "str",
                                                                "provisioningState": "str",
                                                                "sourceAddressPrefix": "str",
                                                                "sourceAddressPrefixes": ["str"],
                                                                "sourceApplicationSecurityGroups": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "sourcePortRange": "str",
                                                                "sourcePortRanges": ["str"],
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "subnets": [...],
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                    },
                                                    "privateEndpointNetworkPolicies": "Disabled",
                                                    "privateEndpoints": [...],
                                                    "privateLinkServiceNetworkPolicies": "Enabled",
                                                    "provisioningState": "str",
                                                    "purpose": "str",
                                                    "resourceNavigationLinks": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "link": "str",
                                                            "linkedResourceType": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "routeTable": {
                                                        "disableBgpRoutePropagation": bool,
                                                        "etag": "str",
                                                        "id": "str",
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "resourceGuid": "str",
                                                        "routes": [
                                                            {
                                                                "addressPrefix": "str",
                                                                "etag": "str",
                                                                "hasBgpOverride": bool,
                                                                "id": "str",
                                                                "name": "str",
                                                                "nextHopIpAddress": "str",
                                                                "nextHopType": "str",
                                                                "provisioningState": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "subnets": [...],
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                    },
                                                    "serviceAssociationLinks": [
                                                        {
                                                            "allowDelete": bool,
                                                            "etag": "str",
                                                            "id": "str",
                                                            "link": "str",
                                                            "linkedResourceType": "str",
                                                            "locations": ["str"],
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "serviceEndpointPolicies": [
                                                        {
                                                            "contextualServiceEndpointPolicies": ["str"],
                                                            "etag": "str",
                                                            "id": "str",
                                                            "kind": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "serviceAlias": "str",
                                                            "serviceEndpointPolicyDefinitions": [
                                                                {
                                                                    "description": "str",
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "service": "str",
                                                                    "serviceResources": ["str"],
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "subnets": [...],
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "serviceEndpoints": [
                                                        {
                                                            "locations": ["str"],
                                                            "networkIdentifier": {"id": "str"},
                                                            "provisioningState": "str",
                                                            "service": "str",
                                                        }
                                                    ],
                                                    "serviceGateway": {"id": "str"},
                                                    "sharingScope": "str",
                                                    "type": "str",
                                                },
                                            },
                                            "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                            "linkedPublicIPAddress": ...,
                                            "location": "str",
                                            "migrationPhase": "str",
                                            "name": "str",
                                            "natGateway": {
                                                "etag": "str",
                                                "id": "str",
                                                "idleTimeoutInMinutes": 0,
                                                "location": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "publicIpAddresses": [{"id": "str"}],
                                                "publicIpAddressesV6": [{"id": "str"}],
                                                "publicIpPrefixes": [{"id": "str"}],
                                                "publicIpPrefixesV6": [{"id": "str"}],
                                                "resourceGuid": "str",
                                                "serviceGateway": {"id": "str"},
                                                "sku": {"name": "str"},
                                                "sourceVirtualNetwork": {"id": "str"},
                                                "subnets": [{"id": "str"}],
                                                "tags": {"str": "str"},
                                                "type": "str",
                                                "zones": ["str"],
                                            },
                                            "provisioningState": "str",
                                            "publicIPAddressVersion": "str",
                                            "publicIPAllocationMethod": "str",
                                            "publicIPPrefix": {"id": "str"},
                                            "resourceGuid": "str",
                                            "servicePublicIPAddress": ...,
                                            "sku": {"name": "str", "tier": "str"},
                                            "tags": {"str": "str"},
                                            "type": "str",
                                            "zones": ["str"],
                                        },
                                        "subnet": {
                                            "addressPrefix": "str",
                                            "addressPrefixes": ["str"],
                                            "applicationGatewayIPConfigurations": [
                                                {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "subnet": {"id": "str"},
                                                    "type": "str",
                                                }
                                            ],
                                            "defaultOutboundAccess": bool,
                                            "delegations": [
                                                {
                                                    "actions": ["str"],
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "serviceName": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "etag": "str",
                                            "id": "str",
                                            "ipAllocations": [{"id": "str"}],
                                            "ipConfigurationProfiles": [
                                                {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "subnet": ...,
                                                    "type": "str",
                                                }
                                            ],
                                            "ipConfigurations": [
                                                {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "privateIPAddress": "str",
                                                    "privateIPAllocationMethod": "str",
                                                    "provisioningState": "str",
                                                    "publicIPAddress": {
                                                        "ddosSettings": {
                                                            "ddosProtectionPlan": {"id": "str"},
                                                            "protectionMode": "str",
                                                        },
                                                        "deleteOption": "str",
                                                        "dnsSettings": {
                                                            "domainNameLabel": "str",
                                                            "domainNameLabelScope": "str",
                                                            "fqdn": "str",
                                                            "reverseFqdn": "str",
                                                        },
                                                        "etag": "str",
                                                        "extendedLocation": {"name": "str", "type": "str"},
                                                        "id": "str",
                                                        "idleTimeoutInMinutes": 0,
                                                        "ipAddress": "str",
                                                        "ipConfiguration": ...,
                                                        "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                        "linkedPublicIPAddress": ...,
                                                        "location": "str",
                                                        "migrationPhase": "str",
                                                        "name": "str",
                                                        "natGateway": {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "idleTimeoutInMinutes": 0,
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "publicIpAddresses": [{"id": "str"}],
                                                            "publicIpAddressesV6": [{"id": "str"}],
                                                            "publicIpPrefixes": [{"id": "str"}],
                                                            "publicIpPrefixesV6": [{"id": "str"}],
                                                            "resourceGuid": "str",
                                                            "serviceGateway": {"id": "str"},
                                                            "sku": {"name": "str"},
                                                            "sourceVirtualNetwork": {"id": "str"},
                                                            "subnets": [{"id": "str"}],
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                            "zones": ["str"],
                                                        },
                                                        "provisioningState": "str",
                                                        "publicIPAddressVersion": "str",
                                                        "publicIPAllocationMethod": "str",
                                                        "publicIPPrefix": {"id": "str"},
                                                        "resourceGuid": "str",
                                                        "servicePublicIPAddress": ...,
                                                        "sku": {"name": "str", "tier": "str"},
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                        "zones": ["str"],
                                                    },
                                                    "subnet": ...,
                                                }
                                            ],
                                            "ipamPoolPrefixAllocations": [
                                                {
                                                    "allocatedAddressPrefixes": ["str"],
                                                    "id": "str",
                                                    "numberOfIpAddresses": "str",
                                                }
                                            ],
                                            "name": "str",
                                            "natGateway": {"id": "str"},
                                            "networkSecurityGroup": {
                                                "defaultSecurityRules": [
                                                    {
                                                        "access": "str",
                                                        "description": "str",
                                                        "destinationAddressPrefix": "str",
                                                        "destinationAddressPrefixes": ["str"],
                                                        "destinationApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "destinationPortRange": "str",
                                                        "destinationPortRanges": ["str"],
                                                        "direction": "str",
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "priority": 0,
                                                        "protocol": "str",
                                                        "provisioningState": "str",
                                                        "sourceAddressPrefix": "str",
                                                        "sourceAddressPrefixes": ["str"],
                                                        "sourceApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "sourcePortRange": "str",
                                                        "sourcePortRanges": ["str"],
                                                        "type": "str",
                                                    }
                                                ],
                                                "etag": "str",
                                                "flowLogs": [
                                                    {
                                                        "enabled": bool,
                                                        "enabledFilteringCriteria": "str",
                                                        "etag": "str",
                                                        "flowAnalyticsConfiguration": {
                                                            "networkWatcherFlowAnalyticsConfiguration": {
                                                                "enabled": bool,
                                                                "trafficAnalyticsInterval": 0,
                                                                "workspaceId": "str",
                                                                "workspaceRegion": "str",
                                                                "workspaceResourceId": "str",
                                                            }
                                                        },
                                                        "format": {"type": "str", "version": 0},
                                                        "id": "str",
                                                        "identity": {
                                                            "principalId": "str",
                                                            "tenantId": "str",
                                                            "type": "str",
                                                            "userAssignedIdentities": {
                                                                "str": {"clientId": "str", "principalId": "str"}
                                                            },
                                                        },
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "recordTypes": "str",
                                                        "retentionPolicy": {"days": 0, "enabled": False},
                                                        "storageId": "str",
                                                        "tags": {"str": "str"},
                                                        "targetResourceGuid": "str",
                                                        "targetResourceId": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "flushConnection": bool,
                                                "id": "str",
                                                "location": "str",
                                                "name": "str",
                                                "networkInterfaces": [...],
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "securityRules": [
                                                    {
                                                        "access": "str",
                                                        "description": "str",
                                                        "destinationAddressPrefix": "str",
                                                        "destinationAddressPrefixes": ["str"],
                                                        "destinationApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "destinationPortRange": "str",
                                                        "destinationPortRanges": ["str"],
                                                        "direction": "str",
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "priority": 0,
                                                        "protocol": "str",
                                                        "provisioningState": "str",
                                                        "sourceAddressPrefix": "str",
                                                        "sourceAddressPrefixes": ["str"],
                                                        "sourceApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "sourcePortRange": "str",
                                                        "sourcePortRanges": ["str"],
                                                        "type": "str",
                                                    }
                                                ],
                                                "subnets": [...],
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            },
                                            "privateEndpointNetworkPolicies": "Disabled",
                                            "privateEndpoints": [...],
                                            "privateLinkServiceNetworkPolicies": "Enabled",
                                            "provisioningState": "str",
                                            "purpose": "str",
                                            "resourceNavigationLinks": [
                                                {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "link": "str",
                                                    "linkedResourceType": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "routeTable": {
                                                "disableBgpRoutePropagation": bool,
                                                "etag": "str",
                                                "id": "str",
                                                "location": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "routes": [
                                                    {
                                                        "addressPrefix": "str",
                                                        "etag": "str",
                                                        "hasBgpOverride": bool,
                                                        "id": "str",
                                                        "name": "str",
                                                        "nextHopIpAddress": "str",
                                                        "nextHopType": "str",
                                                        "provisioningState": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "subnets": [...],
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            },
                                            "serviceAssociationLinks": [
                                                {
                                                    "allowDelete": bool,
                                                    "etag": "str",
                                                    "id": "str",
                                                    "link": "str",
                                                    "linkedResourceType": "str",
                                                    "locations": ["str"],
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "serviceEndpointPolicies": [
                                                {
                                                    "contextualServiceEndpointPolicies": ["str"],
                                                    "etag": "str",
                                                    "id": "str",
                                                    "kind": "str",
                                                    "location": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "resourceGuid": "str",
                                                    "serviceAlias": "str",
                                                    "serviceEndpointPolicyDefinitions": [
                                                        {
                                                            "description": "str",
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "service": "str",
                                                            "serviceResources": ["str"],
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "subnets": [...],
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                }
                                            ],
                                            "serviceEndpoints": [
                                                {
                                                    "locations": ["str"],
                                                    "networkIdentifier": {"id": "str"},
                                                    "provisioningState": "str",
                                                    "service": "str",
                                                }
                                            ],
                                            "serviceGateway": {"id": "str"},
                                            "sharingScope": "str",
                                            "type": "str",
                                        },
                                        "type": "str",
                                        "virtualNetworkTaps": [...],
                                    },
                                    "destinationPort": 0,
                                    "etag": "str",
                                    "id": "str",
                                    "location": "str",
                                    "name": "str",
                                    "networkInterfaceTapConfigurations": [...],
                                    "provisioningState": "str",
                                    "resourceGuid": "str",
                                    "tags": {"str": "str"},
                                    "type": "str",
                                },
                            }
                        ],
                        "type": "str",
                        "virtualMachine": {"id": "str"},
                        "vnetEncryptionSupported": bool,
                        "workloadType": "str",
                    }
                ],
                "privateLinkServiceConnections": [
                    {
                        "etag": "str",
                        "groupIds": ["str"],
                        "id": "str",
                        "name": "str",
                        "privateLinkServiceConnectionState": {
                            "actionsRequired": "str",
                            "description": "str",
                            "status": "str",
                        },
                        "privateLinkServiceId": "str",
                        "provisioningState": "str",
                        "requestMessage": "str",
                        "type": "str",
                    }
                ],
                "provisioningState": "str",
                "subnet": {
                    "addressPrefix": "str",
                    "addressPrefixes": ["str"],
                    "applicationGatewayIPConfigurations": [
                        {
                            "etag": "str",
                            "id": "str",
                            "name": "str",
                            "provisioningState": "str",
                            "subnet": {"id": "str"},
                            "type": "str",
                        }
                    ],
                    "defaultOutboundAccess": bool,
                    "delegations": [
                        {
                            "actions": ["str"],
                            "etag": "str",
                            "id": "str",
                            "name": "str",
                            "provisioningState": "str",
                            "serviceName": "str",
                            "type": "str",
                        }
                    ],
                    "etag": "str",
                    "id": "str",
                    "ipAllocations": [{"id": "str"}],
                    "ipConfigurationProfiles": [
                        {
                            "etag": "str",
                            "id": "str",
                            "name": "str",
                            "provisioningState": "str",
                            "subnet": ...,
                            "type": "str",
                        }
                    ],
                    "ipConfigurations": [
                        {
                            "etag": "str",
                            "id": "str",
                            "name": "str",
                            "privateIPAddress": "str",
                            "privateIPAllocationMethod": "str",
                            "provisioningState": "str",
                            "publicIPAddress": {
                                "ddosSettings": {"ddosProtectionPlan": {"id": "str"}, "protectionMode": "str"},
                                "deleteOption": "str",
                                "dnsSettings": {
                                    "domainNameLabel": "str",
                                    "domainNameLabelScope": "str",
                                    "fqdn": "str",
                                    "reverseFqdn": "str",
                                },
                                "etag": "str",
                                "extendedLocation": {"name": "str", "type": "str"},
                                "id": "str",
                                "idleTimeoutInMinutes": 0,
                                "ipAddress": "str",
                                "ipConfiguration": ...,
                                "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                "linkedPublicIPAddress": ...,
                                "location": "str",
                                "migrationPhase": "str",
                                "name": "str",
                                "natGateway": {
                                    "etag": "str",
                                    "id": "str",
                                    "idleTimeoutInMinutes": 0,
                                    "location": "str",
                                    "name": "str",
                                    "provisioningState": "str",
                                    "publicIpAddresses": [{"id": "str"}],
                                    "publicIpAddressesV6": [{"id": "str"}],
                                    "publicIpPrefixes": [{"id": "str"}],
                                    "publicIpPrefixesV6": [{"id": "str"}],
                                    "resourceGuid": "str",
                                    "serviceGateway": {"id": "str"},
                                    "sku": {"name": "str"},
                                    "sourceVirtualNetwork": {"id": "str"},
                                    "subnets": [{"id": "str"}],
                                    "tags": {"str": "str"},
                                    "type": "str",
                                    "zones": ["str"],
                                },
                                "provisioningState": "str",
                                "publicIPAddressVersion": "str",
                                "publicIPAllocationMethod": "str",
                                "publicIPPrefix": {"id": "str"},
                                "resourceGuid": "str",
                                "servicePublicIPAddress": ...,
                                "sku": {"name": "str", "tier": "str"},
                                "tags": {"str": "str"},
                                "type": "str",
                                "zones": ["str"],
                            },
                            "subnet": ...,
                        }
                    ],
                    "ipamPoolPrefixAllocations": [
                        {"allocatedAddressPrefixes": ["str"], "id": "str", "numberOfIpAddresses": "str"}
                    ],
                    "name": "str",
                    "natGateway": {"id": "str"},
                    "networkSecurityGroup": {
                        "defaultSecurityRules": [
                            {
                                "access": "str",
                                "description": "str",
                                "destinationAddressPrefix": "str",
                                "destinationAddressPrefixes": ["str"],
                                "destinationApplicationSecurityGroups": [
                                    {
                                        "etag": "str",
                                        "id": "str",
                                        "location": "str",
                                        "name": "str",
                                        "provisioningState": "str",
                                        "resourceGuid": "str",
                                        "tags": {"str": "str"},
                                        "type": "str",
                                    }
                                ],
                                "destinationPortRange": "str",
                                "destinationPortRanges": ["str"],
                                "direction": "str",
                                "etag": "str",
                                "id": "str",
                                "name": "str",
                                "priority": 0,
                                "protocol": "str",
                                "provisioningState": "str",
                                "sourceAddressPrefix": "str",
                                "sourceAddressPrefixes": ["str"],
                                "sourceApplicationSecurityGroups": [
                                    {
                                        "etag": "str",
                                        "id": "str",
                                        "location": "str",
                                        "name": "str",
                                        "provisioningState": "str",
                                        "resourceGuid": "str",
                                        "tags": {"str": "str"},
                                        "type": "str",
                                    }
                                ],
                                "sourcePortRange": "str",
                                "sourcePortRanges": ["str"],
                                "type": "str",
                            }
                        ],
                        "etag": "str",
                        "flowLogs": [
                            {
                                "enabled": bool,
                                "enabledFilteringCriteria": "str",
                                "etag": "str",
                                "flowAnalyticsConfiguration": {
                                    "networkWatcherFlowAnalyticsConfiguration": {
                                        "enabled": bool,
                                        "trafficAnalyticsInterval": 0,
                                        "workspaceId": "str",
                                        "workspaceRegion": "str",
                                        "workspaceResourceId": "str",
                                    }
                                },
                                "format": {"type": "str", "version": 0},
                                "id": "str",
                                "identity": {
                                    "principalId": "str",
                                    "tenantId": "str",
                                    "type": "str",
                                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                                },
                                "location": "str",
                                "name": "str",
                                "provisioningState": "str",
                                "recordTypes": "str",
                                "retentionPolicy": {"days": 0, "enabled": False},
                                "storageId": "str",
                                "tags": {"str": "str"},
                                "targetResourceGuid": "str",
                                "targetResourceId": "str",
                                "type": "str",
                            }
                        ],
                        "flushConnection": bool,
                        "id": "str",
                        "location": "str",
                        "name": "str",
                        "networkInterfaces": [
                            {
                                "auxiliaryMode": "str",
                                "auxiliarySku": "str",
                                "defaultOutboundConnectivityEnabled": bool,
                                "disableTcpStateTracking": bool,
                                "dnsSettings": {
                                    "appliedDnsServers": ["str"],
                                    "dnsServers": ["str"],
                                    "internalDnsNameLabel": "str",
                                    "internalDomainNameSuffix": "str",
                                    "internalFqdn": "str",
                                },
                                "dscpConfiguration": {"id": "str"},
                                "enableAcceleratedNetworking": bool,
                                "enableIPForwarding": bool,
                                "etag": "str",
                                "extendedLocation": {"name": "str", "type": "str"},
                                "hostedWorkloads": ["str"],
                                "id": "str",
                                "ipConfigurations": [
                                    {
                                        "applicationGatewayBackendAddressPools": [
                                            {
                                                "backendAddresses": [{"fqdn": "str", "ipAddress": "str"}],
                                                "backendIPConfigurations": [...],
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "applicationSecurityGroups": [
                                            {
                                                "etag": "str",
                                                "id": "str",
                                                "location": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            }
                                        ],
                                        "etag": "str",
                                        "gatewayLoadBalancer": {"id": "str"},
                                        "id": "str",
                                        "loadBalancerBackendAddressPools": [
                                            {
                                                "backendIPConfigurations": [...],
                                                "drainPeriodInSeconds": 0,
                                                "etag": "str",
                                                "id": "str",
                                                "inboundNatRules": [{"id": "str"}],
                                                "loadBalancerBackendAddresses": [
                                                    {
                                                        "adminState": "str",
                                                        "inboundNatRulesPortMapping": [
                                                            {
                                                                "backendPort": 0,
                                                                "frontendPort": 0,
                                                                "inboundNatRuleName": "str",
                                                            }
                                                        ],
                                                        "ipAddress": "str",
                                                        "loadBalancerFrontendIPConfiguration": {"id": "str"},
                                                        "name": "str",
                                                        "networkInterfaceIPConfiguration": {"id": "str"},
                                                        "subnet": {"id": "str"},
                                                        "virtualNetwork": {"id": "str"},
                                                    }
                                                ],
                                                "loadBalancingRules": [{"id": "str"}],
                                                "location": "str",
                                                "name": "str",
                                                "outboundRule": {"id": "str"},
                                                "outboundRules": [{"id": "str"}],
                                                "provisioningState": "str",
                                                "syncMode": "str",
                                                "tunnelInterfaces": [
                                                    {"identifier": 0, "port": 0, "protocol": "str", "type": "str"}
                                                ],
                                                "type": "str",
                                                "virtualNetwork": {"id": "str"},
                                            }
                                        ],
                                        "loadBalancerInboundNatRules": [
                                            {
                                                "backendAddressPool": {"id": "str"},
                                                "backendIPConfiguration": ...,
                                                "backendPort": 0,
                                                "enableFloatingIP": bool,
                                                "enableTcpReset": bool,
                                                "etag": "str",
                                                "frontendIPConfiguration": {"id": "str"},
                                                "frontendPort": 0,
                                                "frontendPortRangeEnd": 0,
                                                "frontendPortRangeStart": 0,
                                                "id": "str",
                                                "idleTimeoutInMinutes": 0,
                                                "name": "str",
                                                "protocol": "str",
                                                "provisioningState": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "name": "str",
                                        "primary": bool,
                                        "privateIPAddress": "str",
                                        "privateIPAddressPrefixLength": 0,
                                        "privateIPAddressVersion": "str",
                                        "privateIPAllocationMethod": "str",
                                        "privateLinkConnectionProperties": {
                                            "fqdns": ["str"],
                                            "groupId": "str",
                                            "requiredMemberName": "str",
                                        },
                                        "provisioningState": "str",
                                        "publicIPAddress": {
                                            "ddosSettings": {
                                                "ddosProtectionPlan": {"id": "str"},
                                                "protectionMode": "str",
                                            },
                                            "deleteOption": "str",
                                            "dnsSettings": {
                                                "domainNameLabel": "str",
                                                "domainNameLabelScope": "str",
                                                "fqdn": "str",
                                                "reverseFqdn": "str",
                                            },
                                            "etag": "str",
                                            "extendedLocation": {"name": "str", "type": "str"},
                                            "id": "str",
                                            "idleTimeoutInMinutes": 0,
                                            "ipAddress": "str",
                                            "ipConfiguration": {
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "privateIPAddress": "str",
                                                "privateIPAllocationMethod": "str",
                                                "provisioningState": "str",
                                                "publicIPAddress": ...,
                                                "subnet": ...,
                                            },
                                            "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                            "linkedPublicIPAddress": ...,
                                            "location": "str",
                                            "migrationPhase": "str",
                                            "name": "str",
                                            "natGateway": {
                                                "etag": "str",
                                                "id": "str",
                                                "idleTimeoutInMinutes": 0,
                                                "location": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "publicIpAddresses": [{"id": "str"}],
                                                "publicIpAddressesV6": [{"id": "str"}],
                                                "publicIpPrefixes": [{"id": "str"}],
                                                "publicIpPrefixesV6": [{"id": "str"}],
                                                "resourceGuid": "str",
                                                "serviceGateway": {"id": "str"},
                                                "sku": {"name": "str"},
                                                "sourceVirtualNetwork": {"id": "str"},
                                                "subnets": [{"id": "str"}],
                                                "tags": {"str": "str"},
                                                "type": "str",
                                                "zones": ["str"],
                                            },
                                            "provisioningState": "str",
                                            "publicIPAddressVersion": "str",
                                            "publicIPAllocationMethod": "str",
                                            "publicIPPrefix": {"id": "str"},
                                            "resourceGuid": "str",
                                            "servicePublicIPAddress": ...,
                                            "sku": {"name": "str", "tier": "str"},
                                            "tags": {"str": "str"},
                                            "type": "str",
                                            "zones": ["str"],
                                        },
                                        "subnet": ...,
                                        "type": "str",
                                        "virtualNetworkTaps": [
                                            {
                                                "destinationLoadBalancerFrontEndIPConfiguration": {
                                                    "etag": "str",
                                                    "gatewayLoadBalancer": {"id": "str"},
                                                    "id": "str",
                                                    "inboundNatPools": [{"id": "str"}],
                                                    "inboundNatRules": [{"id": "str"}],
                                                    "loadBalancingRules": [{"id": "str"}],
                                                    "name": "str",
                                                    "outboundRules": [{"id": "str"}],
                                                    "privateIPAddress": "str",
                                                    "privateIPAddressVersion": "str",
                                                    "privateIPAllocationMethod": "str",
                                                    "provisioningState": "str",
                                                    "publicIPAddress": {
                                                        "ddosSettings": {
                                                            "ddosProtectionPlan": {"id": "str"},
                                                            "protectionMode": "str",
                                                        },
                                                        "deleteOption": "str",
                                                        "dnsSettings": {
                                                            "domainNameLabel": "str",
                                                            "domainNameLabelScope": "str",
                                                            "fqdn": "str",
                                                            "reverseFqdn": "str",
                                                        },
                                                        "etag": "str",
                                                        "extendedLocation": {"name": "str", "type": "str"},
                                                        "id": "str",
                                                        "idleTimeoutInMinutes": 0,
                                                        "ipAddress": "str",
                                                        "ipConfiguration": {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "privateIPAddress": "str",
                                                            "privateIPAllocationMethod": "str",
                                                            "provisioningState": "str",
                                                            "publicIPAddress": ...,
                                                            "subnet": ...,
                                                        },
                                                        "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                        "linkedPublicIPAddress": ...,
                                                        "location": "str",
                                                        "migrationPhase": "str",
                                                        "name": "str",
                                                        "natGateway": {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "idleTimeoutInMinutes": 0,
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "publicIpAddresses": [{"id": "str"}],
                                                            "publicIpAddressesV6": [{"id": "str"}],
                                                            "publicIpPrefixes": [{"id": "str"}],
                                                            "publicIpPrefixesV6": [{"id": "str"}],
                                                            "resourceGuid": "str",
                                                            "serviceGateway": {"id": "str"},
                                                            "sku": {"name": "str"},
                                                            "sourceVirtualNetwork": {"id": "str"},
                                                            "subnets": [{"id": "str"}],
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                            "zones": ["str"],
                                                        },
                                                        "provisioningState": "str",
                                                        "publicIPAddressVersion": "str",
                                                        "publicIPAllocationMethod": "str",
                                                        "publicIPPrefix": {"id": "str"},
                                                        "resourceGuid": "str",
                                                        "servicePublicIPAddress": ...,
                                                        "sku": {"name": "str", "tier": "str"},
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                        "zones": ["str"],
                                                    },
                                                    "publicIPPrefix": {"id": "str"},
                                                    "subnet": ...,
                                                    "type": "str",
                                                    "zones": ["str"],
                                                },
                                                "destinationNetworkInterfaceIPConfiguration": ...,
                                                "destinationPort": 0,
                                                "etag": "str",
                                                "id": "str",
                                                "location": "str",
                                                "name": "str",
                                                "networkInterfaceTapConfigurations": [
                                                    {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "type": "str",
                                                        "virtualNetworkTap": ...,
                                                    }
                                                ],
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            }
                                        ],
                                    }
                                ],
                                "location": "str",
                                "macAddress": "str",
                                "migrationPhase": "str",
                                "name": "str",
                                "networkSecurityGroup": ...,
                                "nicType": "str",
                                "primary": bool,
                                "privateEndpoint": ...,
                                "privateLinkService": {
                                    "accessMode": "str",
                                    "alias": "str",
                                    "autoApproval": {"subscriptions": ["str"]},
                                    "destinationIPAddress": "str",
                                    "enableProxyProtocol": bool,
                                    "etag": "str",
                                    "extendedLocation": {"name": "str", "type": "str"},
                                    "fqdns": ["str"],
                                    "id": "str",
                                    "ipConfigurations": [
                                        {
                                            "etag": "str",
                                            "id": "str",
                                            "name": "str",
                                            "primary": bool,
                                            "privateIPAddress": "str",
                                            "privateIPAddressVersion": "str",
                                            "privateIPAllocationMethod": "str",
                                            "provisioningState": "str",
                                            "subnet": ...,
                                            "type": "str",
                                        }
                                    ],
                                    "loadBalancerFrontendIpConfigurations": [
                                        {
                                            "etag": "str",
                                            "gatewayLoadBalancer": {"id": "str"},
                                            "id": "str",
                                            "inboundNatPools": [{"id": "str"}],
                                            "inboundNatRules": [{"id": "str"}],
                                            "loadBalancingRules": [{"id": "str"}],
                                            "name": "str",
                                            "outboundRules": [{"id": "str"}],
                                            "privateIPAddress": "str",
                                            "privateIPAddressVersion": "str",
                                            "privateIPAllocationMethod": "str",
                                            "provisioningState": "str",
                                            "publicIPAddress": {
                                                "ddosSettings": {
                                                    "ddosProtectionPlan": {"id": "str"},
                                                    "protectionMode": "str",
                                                },
                                                "deleteOption": "str",
                                                "dnsSettings": {
                                                    "domainNameLabel": "str",
                                                    "domainNameLabelScope": "str",
                                                    "fqdn": "str",
                                                    "reverseFqdn": "str",
                                                },
                                                "etag": "str",
                                                "extendedLocation": {"name": "str", "type": "str"},
                                                "id": "str",
                                                "idleTimeoutInMinutes": 0,
                                                "ipAddress": "str",
                                                "ipConfiguration": {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "privateIPAddress": "str",
                                                    "privateIPAllocationMethod": "str",
                                                    "provisioningState": "str",
                                                    "publicIPAddress": ...,
                                                    "subnet": ...,
                                                },
                                                "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                "linkedPublicIPAddress": ...,
                                                "location": "str",
                                                "migrationPhase": "str",
                                                "name": "str",
                                                "natGateway": {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "idleTimeoutInMinutes": 0,
                                                    "location": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "publicIpAddresses": [{"id": "str"}],
                                                    "publicIpAddressesV6": [{"id": "str"}],
                                                    "publicIpPrefixes": [{"id": "str"}],
                                                    "publicIpPrefixesV6": [{"id": "str"}],
                                                    "resourceGuid": "str",
                                                    "serviceGateway": {"id": "str"},
                                                    "sku": {"name": "str"},
                                                    "sourceVirtualNetwork": {"id": "str"},
                                                    "subnets": [{"id": "str"}],
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                    "zones": ["str"],
                                                },
                                                "provisioningState": "str",
                                                "publicIPAddressVersion": "str",
                                                "publicIPAllocationMethod": "str",
                                                "publicIPPrefix": {"id": "str"},
                                                "resourceGuid": "str",
                                                "servicePublicIPAddress": ...,
                                                "sku": {"name": "str", "tier": "str"},
                                                "tags": {"str": "str"},
                                                "type": "str",
                                                "zones": ["str"],
                                            },
                                            "publicIPPrefix": {"id": "str"},
                                            "subnet": ...,
                                            "type": "str",
                                            "zones": ["str"],
                                        }
                                    ],
                                    "location": "str",
                                    "name": "str",
                                    "networkInterfaces": [...],
                                    "privateEndpointConnections": [
                                        {
                                            "etag": "str",
                                            "id": "str",
                                            "linkIdentifier": "str",
                                            "name": "str",
                                            "privateEndpoint": ...,
                                            "privateEndpointLocation": "str",
                                            "privateLinkServiceConnectionState": {
                                                "actionsRequired": "str",
                                                "description": "str",
                                                "status": "str",
                                            },
                                            "provisioningState": "str",
                                            "type": "str",
                                        }
                                    ],
                                    "provisioningState": "str",
                                    "tags": {"str": "str"},
                                    "type": "str",
                                    "visibility": {"subscriptions": ["str"]},
                                },
                                "provisioningState": "str",
                                "resourceGuid": "str",
                                "tags": {"str": "str"},
                                "tapConfigurations": [
                                    {
                                        "etag": "str",
                                        "id": "str",
                                        "name": "str",
                                        "provisioningState": "str",
                                        "type": "str",
                                        "virtualNetworkTap": {
                                            "destinationLoadBalancerFrontEndIPConfiguration": {
                                                "etag": "str",
                                                "gatewayLoadBalancer": {"id": "str"},
                                                "id": "str",
                                                "inboundNatPools": [{"id": "str"}],
                                                "inboundNatRules": [{"id": "str"}],
                                                "loadBalancingRules": [{"id": "str"}],
                                                "name": "str",
                                                "outboundRules": [{"id": "str"}],
                                                "privateIPAddress": "str",
                                                "privateIPAddressVersion": "str",
                                                "privateIPAllocationMethod": "str",
                                                "provisioningState": "str",
                                                "publicIPAddress": {
                                                    "ddosSettings": {
                                                        "ddosProtectionPlan": {"id": "str"},
                                                        "protectionMode": "str",
                                                    },
                                                    "deleteOption": "str",
                                                    "dnsSettings": {
                                                        "domainNameLabel": "str",
                                                        "domainNameLabelScope": "str",
                                                        "fqdn": "str",
                                                        "reverseFqdn": "str",
                                                    },
                                                    "etag": "str",
                                                    "extendedLocation": {"name": "str", "type": "str"},
                                                    "id": "str",
                                                    "idleTimeoutInMinutes": 0,
                                                    "ipAddress": "str",
                                                    "ipConfiguration": {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "privateIPAddress": "str",
                                                        "privateIPAllocationMethod": "str",
                                                        "provisioningState": "str",
                                                        "publicIPAddress": ...,
                                                        "subnet": ...,
                                                    },
                                                    "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                    "linkedPublicIPAddress": ...,
                                                    "location": "str",
                                                    "migrationPhase": "str",
                                                    "name": "str",
                                                    "natGateway": {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "idleTimeoutInMinutes": 0,
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "publicIpAddresses": [{"id": "str"}],
                                                        "publicIpAddressesV6": [{"id": "str"}],
                                                        "publicIpPrefixes": [{"id": "str"}],
                                                        "publicIpPrefixesV6": [{"id": "str"}],
                                                        "resourceGuid": "str",
                                                        "serviceGateway": {"id": "str"},
                                                        "sku": {"name": "str"},
                                                        "sourceVirtualNetwork": {"id": "str"},
                                                        "subnets": [{"id": "str"}],
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                        "zones": ["str"],
                                                    },
                                                    "provisioningState": "str",
                                                    "publicIPAddressVersion": "str",
                                                    "publicIPAllocationMethod": "str",
                                                    "publicIPPrefix": {"id": "str"},
                                                    "resourceGuid": "str",
                                                    "servicePublicIPAddress": ...,
                                                    "sku": {"name": "str", "tier": "str"},
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                    "zones": ["str"],
                                                },
                                                "publicIPPrefix": {"id": "str"},
                                                "subnet": ...,
                                                "type": "str",
                                                "zones": ["str"],
                                            },
                                            "destinationNetworkInterfaceIPConfiguration": {
                                                "applicationGatewayBackendAddressPools": [
                                                    {
                                                        "backendAddresses": [{"fqdn": "str", "ipAddress": "str"}],
                                                        "backendIPConfigurations": [...],
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "applicationSecurityGroups": [
                                                    {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "resourceGuid": "str",
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                    }
                                                ],
                                                "etag": "str",
                                                "gatewayLoadBalancer": {"id": "str"},
                                                "id": "str",
                                                "loadBalancerBackendAddressPools": [
                                                    {
                                                        "backendIPConfigurations": [...],
                                                        "drainPeriodInSeconds": 0,
                                                        "etag": "str",
                                                        "id": "str",
                                                        "inboundNatRules": [{"id": "str"}],
                                                        "loadBalancerBackendAddresses": [
                                                            {
                                                                "adminState": "str",
                                                                "inboundNatRulesPortMapping": [
                                                                    {
                                                                        "backendPort": 0,
                                                                        "frontendPort": 0,
                                                                        "inboundNatRuleName": "str",
                                                                    }
                                                                ],
                                                                "ipAddress": "str",
                                                                "loadBalancerFrontendIPConfiguration": {"id": "str"},
                                                                "name": "str",
                                                                "networkInterfaceIPConfiguration": {"id": "str"},
                                                                "subnet": {"id": "str"},
                                                                "virtualNetwork": {"id": "str"},
                                                            }
                                                        ],
                                                        "loadBalancingRules": [{"id": "str"}],
                                                        "location": "str",
                                                        "name": "str",
                                                        "outboundRule": {"id": "str"},
                                                        "outboundRules": [{"id": "str"}],
                                                        "provisioningState": "str",
                                                        "syncMode": "str",
                                                        "tunnelInterfaces": [
                                                            {
                                                                "identifier": 0,
                                                                "port": 0,
                                                                "protocol": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "type": "str",
                                                        "virtualNetwork": {"id": "str"},
                                                    }
                                                ],
                                                "loadBalancerInboundNatRules": [
                                                    {
                                                        "backendAddressPool": {"id": "str"},
                                                        "backendIPConfiguration": ...,
                                                        "backendPort": 0,
                                                        "enableFloatingIP": bool,
                                                        "enableTcpReset": bool,
                                                        "etag": "str",
                                                        "frontendIPConfiguration": {"id": "str"},
                                                        "frontendPort": 0,
                                                        "frontendPortRangeEnd": 0,
                                                        "frontendPortRangeStart": 0,
                                                        "id": "str",
                                                        "idleTimeoutInMinutes": 0,
                                                        "name": "str",
                                                        "protocol": "str",
                                                        "provisioningState": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "name": "str",
                                                "primary": bool,
                                                "privateIPAddress": "str",
                                                "privateIPAddressPrefixLength": 0,
                                                "privateIPAddressVersion": "str",
                                                "privateIPAllocationMethod": "str",
                                                "privateLinkConnectionProperties": {
                                                    "fqdns": ["str"],
                                                    "groupId": "str",
                                                    "requiredMemberName": "str",
                                                },
                                                "provisioningState": "str",
                                                "publicIPAddress": {
                                                    "ddosSettings": {
                                                        "ddosProtectionPlan": {"id": "str"},
                                                        "protectionMode": "str",
                                                    },
                                                    "deleteOption": "str",
                                                    "dnsSettings": {
                                                        "domainNameLabel": "str",
                                                        "domainNameLabelScope": "str",
                                                        "fqdn": "str",
                                                        "reverseFqdn": "str",
                                                    },
                                                    "etag": "str",
                                                    "extendedLocation": {"name": "str", "type": "str"},
                                                    "id": "str",
                                                    "idleTimeoutInMinutes": 0,
                                                    "ipAddress": "str",
                                                    "ipConfiguration": {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "privateIPAddress": "str",
                                                        "privateIPAllocationMethod": "str",
                                                        "provisioningState": "str",
                                                        "publicIPAddress": ...,
                                                        "subnet": ...,
                                                    },
                                                    "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                    "linkedPublicIPAddress": ...,
                                                    "location": "str",
                                                    "migrationPhase": "str",
                                                    "name": "str",
                                                    "natGateway": {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "idleTimeoutInMinutes": 0,
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "publicIpAddresses": [{"id": "str"}],
                                                        "publicIpAddressesV6": [{"id": "str"}],
                                                        "publicIpPrefixes": [{"id": "str"}],
                                                        "publicIpPrefixesV6": [{"id": "str"}],
                                                        "resourceGuid": "str",
                                                        "serviceGateway": {"id": "str"},
                                                        "sku": {"name": "str"},
                                                        "sourceVirtualNetwork": {"id": "str"},
                                                        "subnets": [{"id": "str"}],
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                        "zones": ["str"],
                                                    },
                                                    "provisioningState": "str",
                                                    "publicIPAddressVersion": "str",
                                                    "publicIPAllocationMethod": "str",
                                                    "publicIPPrefix": {"id": "str"},
                                                    "resourceGuid": "str",
                                                    "servicePublicIPAddress": ...,
                                                    "sku": {"name": "str", "tier": "str"},
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                    "zones": ["str"],
                                                },
                                                "subnet": ...,
                                                "type": "str",
                                                "virtualNetworkTaps": [...],
                                            },
                                            "destinationPort": 0,
                                            "etag": "str",
                                            "id": "str",
                                            "location": "str",
                                            "name": "str",
                                            "networkInterfaceTapConfigurations": [...],
                                            "provisioningState": "str",
                                            "resourceGuid": "str",
                                            "tags": {"str": "str"},
                                            "type": "str",
                                        },
                                    }
                                ],
                                "type": "str",
                                "virtualMachine": {"id": "str"},
                                "vnetEncryptionSupported": bool,
                                "workloadType": "str",
                            }
                        ],
                        "provisioningState": "str",
                        "resourceGuid": "str",
                        "securityRules": [
                            {
                                "access": "str",
                                "description": "str",
                                "destinationAddressPrefix": "str",
                                "destinationAddressPrefixes": ["str"],
                                "destinationApplicationSecurityGroups": [
                                    {
                                        "etag": "str",
                                        "id": "str",
                                        "location": "str",
                                        "name": "str",
                                        "provisioningState": "str",
                                        "resourceGuid": "str",
                                        "tags": {"str": "str"},
                                        "type": "str",
                                    }
                                ],
                                "destinationPortRange": "str",
                                "destinationPortRanges": ["str"],
                                "direction": "str",
                                "etag": "str",
                                "id": "str",
                                "name": "str",
                                "priority": 0,
                                "protocol": "str",
                                "provisioningState": "str",
                                "sourceAddressPrefix": "str",
                                "sourceAddressPrefixes": ["str"],
                                "sourceApplicationSecurityGroups": [
                                    {
                                        "etag": "str",
                                        "id": "str",
                                        "location": "str",
                                        "name": "str",
                                        "provisioningState": "str",
                                        "resourceGuid": "str",
                                        "tags": {"str": "str"},
                                        "type": "str",
                                    }
                                ],
                                "sourcePortRange": "str",
                                "sourcePortRanges": ["str"],
                                "type": "str",
                            }
                        ],
                        "subnets": [...],
                        "tags": {"str": "str"},
                        "type": "str",
                    },
                    "privateEndpointNetworkPolicies": "Disabled",
                    "privateEndpoints": [...],
                    "privateLinkServiceNetworkPolicies": "Enabled",
                    "provisioningState": "str",
                    "purpose": "str",
                    "resourceNavigationLinks": [
                        {
                            "etag": "str",
                            "id": "str",
                            "link": "str",
                            "linkedResourceType": "str",
                            "name": "str",
                            "provisioningState": "str",
                            "type": "str",
                        }
                    ],
                    "routeTable": {
                        "disableBgpRoutePropagation": bool,
                        "etag": "str",
                        "id": "str",
                        "location": "str",
                        "name": "str",
                        "provisioningState": "str",
                        "resourceGuid": "str",
                        "routes": [
                            {
                                "addressPrefix": "str",
                                "etag": "str",
                                "hasBgpOverride": bool,
                                "id": "str",
                                "name": "str",
                                "nextHopIpAddress": "str",
                                "nextHopType": "str",
                                "provisioningState": "str",
                                "type": "str",
                            }
                        ],
                        "subnets": [...],
                        "tags": {"str": "str"},
                        "type": "str",
                    },
                    "serviceAssociationLinks": [
                        {
                            "allowDelete": bool,
                            "etag": "str",
                            "id": "str",
                            "link": "str",
                            "linkedResourceType": "str",
                            "locations": ["str"],
                            "name": "str",
                            "provisioningState": "str",
                            "type": "str",
                        }
                    ],
                    "serviceEndpointPolicies": [
                        {
                            "contextualServiceEndpointPolicies": ["str"],
                            "etag": "str",
                            "id": "str",
                            "kind": "str",
                            "location": "str",
                            "name": "str",
                            "provisioningState": "str",
                            "resourceGuid": "str",
                            "serviceAlias": "str",
                            "serviceEndpointPolicyDefinitions": [
                                {
                                    "description": "str",
                                    "etag": "str",
                                    "id": "str",
                                    "name": "str",
                                    "provisioningState": "str",
                                    "service": "str",
                                    "serviceResources": ["str"],
                                    "type": "str",
                                }
                            ],
                            "subnets": [...],
                            "tags": {"str": "str"},
                            "type": "str",
                        }
                    ],
                    "serviceEndpoints": [
                        {
                            "locations": ["str"],
                            "networkIdentifier": {"id": "str"},
                            "provisioningState": "str",
                            "service": "str",
                        }
                    ],
                    "serviceGateway": {"id": "str"},
                    "sharingScope": "str",
                    "type": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoints_list(self, resource_group):
        response = self.client.private_endpoints.list(
            resource_group_name=resource_group.name,
            api_version="2025-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoints_list_by_subscription(self, resource_group):
        response = self.client.private_endpoints.list_by_subscription(
            api_version="2025-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
