# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.postgresqlflexibleservers import PostgreSQLManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPostgreSQLManagementAdministratorsMicrosoftEntraOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PostgreSQLManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_administrators_microsoft_entra_get(self, resource_group):
        response = self.client.administrators_microsoft_entra.get(
            resource_group_name=resource_group.name,
            server_name="str",
            object_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_administrators_microsoft_entra_begin_create_or_update(self, resource_group):
        response = self.client.administrators_microsoft_entra.begin_create_or_update(
            resource_group_name=resource_group.name,
            server_name="str",
            object_id="str",
            parameters={"properties": {"principalName": "str", "principalType": "str", "tenantId": "str"}},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_administrators_microsoft_entra_begin_delete(self, resource_group):
        response = self.client.administrators_microsoft_entra.begin_delete(
            resource_group_name=resource_group.name,
            server_name="str",
            object_id="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_administrators_microsoft_entra_list_by_server(self, resource_group):
        response = self.client.administrators_microsoft_entra.list_by_server(
            resource_group_name=resource_group.name,
            server_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
