# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from ..._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import (
    KnowledgeBaseModelKind,
    KnowledgeSourceKind,
    VectorSearchAlgorithmKind,
    VectorSearchCompressionKind,
    VectorSearchVectorizerKind,
)

if TYPE_CHECKING:
    from .. import models as _models
    from ...knowledgebases import models as _knowledgebases_models3


class CognitiveServicesAccount(_Model):
    """Base type for describing any Azure AI service resource attached to a skillset.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AIServicesAccountIdentity, AIServicesAccountKey, CognitiveServicesAccountKey,
    DefaultCognitiveServicesAccount

    :ivar odata_type: The discriminator for derived types. Required. Default value is None.
    :vartype odata_type: str
    :ivar description: Description of the Azure AI service resource attached to a skillset.
    :vartype description: str
    """

    __mapping__: dict[str, _Model] = {}
    odata_type: str = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])
    """The discriminator for derived types. Required. Default value is None."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of the Azure AI service resource attached to a skillset."""

    @overload
    def __init__(
        self,
        *,
        odata_type: str,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AIServicesAccountIdentity(CognitiveServicesAccount, discriminator="#Microsoft.Azure.Search.AIServicesByIdentity"):
    """The multi-region account of an Azure AI service resource that's attached to a skillset.

    :ivar description: Description of the Azure AI service resource attached to a skillset.
    :vartype description: str
    :ivar identity: The user-assigned managed identity used for connections to AI Service. If not
     specified, the system-assigned managed identity is used. On updates to the skillset, if the
     identity is unspecified, the value remains unchanged. If set to "none", the value of this
     property is cleared.
    :vartype identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
    :ivar subdomain_url: The subdomain url for the corresponding AI Service. Required.
    :vartype subdomain_url: str
    :ivar odata_type: A URI fragment specifying the type of Azure AI service resource attached to a
     skillset. Required. Default value is "#Microsoft.Azure.Search.AIServicesByIdentity".
    :vartype odata_type: str
    """

    identity: Optional["_models.SearchIndexerDataIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The user-assigned managed identity used for connections to AI Service. If not specified, the
     system-assigned managed identity is used. On updates to the skillset, if the identity is
     unspecified, the value remains unchanged. If set to \"none\", the value of this property is
     cleared."""
    subdomain_url: str = rest_field(name="subdomainUrl", visibility=["read", "create", "update", "delete", "query"])
    """The subdomain url for the corresponding AI Service. Required."""
    odata_type: Literal["#Microsoft.Azure.Search.AIServicesByIdentity"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of Azure AI service resource attached to a skillset.
     Required. Default value is \"#Microsoft.Azure.Search.AIServicesByIdentity\"."""

    @overload
    def __init__(
        self,
        *,
        subdomain_url: str,
        description: Optional[str] = None,
        identity: Optional["_models.SearchIndexerDataIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.AIServicesByIdentity"  # type: ignore


class AIServicesAccountKey(CognitiveServicesAccount, discriminator="#Microsoft.Azure.Search.AIServicesByKey"):
    """The account key of an Azure AI service resource that's attached to a skillset, to be used with
    the resource's subdomain.

    :ivar description: Description of the Azure AI service resource attached to a skillset.
    :vartype description: str
    :ivar key: The key used to provision the Azure AI service resource attached to a skillset.
     Required.
    :vartype key: str
    :ivar subdomain_url: The subdomain url for the corresponding AI Service. Required.
    :vartype subdomain_url: str
    :ivar odata_type: A URI fragment specifying the type of Azure AI service resource attached to a
     skillset. Required. Default value is "#Microsoft.Azure.Search.AIServicesByKey".
    :vartype odata_type: str
    """

    key: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The key used to provision the Azure AI service resource attached to a skillset. Required."""
    subdomain_url: str = rest_field(name="subdomainUrl", visibility=["read", "create", "update", "delete", "query"])
    """The subdomain url for the corresponding AI Service. Required."""
    odata_type: Literal["#Microsoft.Azure.Search.AIServicesByKey"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of Azure AI service resource attached to a skillset.
     Required. Default value is \"#Microsoft.Azure.Search.AIServicesByKey\"."""

    @overload
    def __init__(
        self,
        *,
        key: str,
        subdomain_url: str,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.AIServicesByKey"  # type: ignore


class AIServicesVisionParameters(_Model):
    """Specifies the AI Services Vision parameters for vectorizing a query image or text.

    :ivar model_version: The version of the model to use when calling the AI Services Vision
     service. It will default to the latest available when not specified. Required.
    :vartype model_version: str
    :ivar resource_uri: The resource URI of the AI Services resource. Required.
    :vartype resource_uri: str
    :ivar api_key: API key of the designated AI Services resource.
    :vartype api_key: str
    :ivar auth_identity: The user-assigned managed identity used for outbound connections. If an
     authResourceId is provided and it's not specified, the system-assigned managed identity is
     used. On updates to the index, if the identity is unspecified, the value remains unchanged. If
     set to "none", the value of this property is cleared.
    :vartype auth_identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
    """

    model_version: str = rest_field(name="modelVersion", visibility=["read", "create", "update", "delete", "query"])
    """The version of the model to use when calling the AI Services Vision service. It will default to
     the latest available when not specified. Required."""
    resource_uri: str = rest_field(name="resourceUri", visibility=["read", "create", "update", "delete", "query"])
    """The resource URI of the AI Services resource. Required."""
    api_key: Optional[str] = rest_field(name="apiKey", visibility=["read", "create", "update", "delete", "query"])
    """API key of the designated AI Services resource."""
    auth_identity: Optional["_models.SearchIndexerDataIdentity"] = rest_field(
        name="authIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user-assigned managed identity used for outbound connections. If an authResourceId is
     provided and it's not specified, the system-assigned managed identity is used. On updates to
     the index, if the identity is unspecified, the value remains unchanged. If set to \"none\", the
     value of this property is cleared."""

    @overload
    def __init__(
        self,
        *,
        model_version: str,
        resource_uri: str,
        api_key: Optional[str] = None,
        auth_identity: Optional["_models.SearchIndexerDataIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VectorSearchVectorizer(_Model):
    """Specifies the vectorization method to be used during query time.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AIServicesVisionVectorizer, AzureMachineLearningVectorizer, AzureOpenAIVectorizer,
    WebApiVectorizer

    :ivar vectorizer_name: The name to associate with this particular vectorization method.
     Required.
    :vartype vectorizer_name: str
    :ivar kind: Type of VectorSearchVectorizer. Required. Known values are: "azureOpenAI",
     "customWebApi", "aiServicesVision", and "aml".
    :vartype kind: str or ~azure.search.documents.indexes.models.VectorSearchVectorizerKind
    """

    __mapping__: dict[str, _Model] = {}
    vectorizer_name: str = rest_field(name="name", visibility=["read", "create", "update", "delete", "query"])
    """The name to associate with this particular vectorization method. Required."""
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """Type of VectorSearchVectorizer. Required. Known values are: \"azureOpenAI\", \"customWebApi\",
     \"aiServicesVision\", and \"aml\"."""

    @overload
    def __init__(
        self,
        *,
        vectorizer_name: str,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AIServicesVisionVectorizer(VectorSearchVectorizer, discriminator="aiServicesVision"):
    """Clears the identity property of a datasource.

    :ivar vectorizer_name: The name to associate with this particular vectorization method.
     Required.
    :vartype vectorizer_name: str
    :ivar ai_services_vision_parameters: Contains the parameters specific to AI Services Vision
     embedding vectorization.
    :vartype ai_services_vision_parameters:
     ~azure.search.documents.indexes.models.AIServicesVisionParameters
    :ivar kind: The name of the kind of vectorization method being configured for use with vector
     search. Required. Generate embeddings for an image or text input at query time using the Azure
     AI Services Vision Vectorize API.
    :vartype kind: str or ~azure.search.documents.indexes.models.AI_SERVICES_VISION
    """

    ai_services_vision_parameters: Optional["_models.AIServicesVisionParameters"] = rest_field(
        name="aiServicesVisionParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the parameters specific to AI Services Vision embedding vectorization."""
    kind: Literal[VectorSearchVectorizerKind.AI_SERVICES_VISION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The name of the kind of vectorization method being configured for use with vector search.
     Required. Generate embeddings for an image or text input at query time using the Azure AI
     Services Vision Vectorize API."""

    @overload
    def __init__(
        self,
        *,
        vectorizer_name: str,
        ai_services_vision_parameters: Optional["_models.AIServicesVisionParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = VectorSearchVectorizerKind.AI_SERVICES_VISION  # type: ignore


class AnalyzedTokenInfo(_Model):
    """Information about a token returned by an analyzer.

    :ivar token: The token returned by the analyzer. Required.
    :vartype token: str
    :ivar start_offset: The index of the first character of the token in the input text. Required.
    :vartype start_offset: int
    :ivar end_offset: The index of the last character of the token in the input text. Required.
    :vartype end_offset: int
    :ivar position: The position of the token in the input text relative to other tokens. The first
     token in the input text has position 0, the next has position 1, and so on. Depending on the
     analyzer used, some tokens might have the same position, for example if they are synonyms of
     each other. Required.
    :vartype position: int
    """

    token: str = rest_field(visibility=["read"])
    """The token returned by the analyzer. Required."""
    start_offset: int = rest_field(name="startOffset", visibility=["read"])
    """The index of the first character of the token in the input text. Required."""
    end_offset: int = rest_field(name="endOffset", visibility=["read"])
    """The index of the last character of the token in the input text. Required."""
    position: int = rest_field(visibility=["read"])
    """The position of the token in the input text relative to other tokens. The first token in the
     input text has position 0, the next has position 1, and so on. Depending on the analyzer used,
     some tokens might have the same position, for example if they are synonyms of each other.
     Required."""


class AnalyzeResult(_Model):
    """The result of testing an analyzer on text.

    :ivar tokens: The list of tokens returned by the analyzer specified in the request. Required.
    :vartype tokens: list[~azure.search.documents.indexes.models.AnalyzedTokenInfo]
    """

    tokens: list["_models.AnalyzedTokenInfo"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The list of tokens returned by the analyzer specified in the request. Required."""

    @overload
    def __init__(
        self,
        *,
        tokens: list["_models.AnalyzedTokenInfo"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnalyzeTextOptions(_Model):
    """Specifies some text and analysis components used to break that text into tokens.

    :ivar text: The text to break into tokens. Required.
    :vartype text: str
    :ivar analyzer_name: The name of the analyzer to use to break the given text. If this parameter
     is not specified, you must specify a tokenizer instead. The tokenizer and analyzer parameters
     are mutually exclusive. Known values are: "ar.microsoft", "ar.lucene", "hy.lucene",
     "bn.microsoft", "eu.lucene", "bg.microsoft", "bg.lucene", "ca.microsoft", "ca.lucene",
     "zh-Hans.microsoft", "zh-Hans.lucene", "zh-Hant.microsoft", "zh-Hant.lucene", "hr.microsoft",
     "cs.microsoft", "cs.lucene", "da.microsoft", "da.lucene", "nl.microsoft", "nl.lucene",
     "en.microsoft", "en.lucene", "et.microsoft", "fi.microsoft", "fi.lucene", "fr.microsoft",
     "fr.lucene", "gl.lucene", "de.microsoft", "de.lucene", "el.microsoft", "el.lucene",
     "gu.microsoft", "he.microsoft", "hi.microsoft", "hi.lucene", "hu.microsoft", "hu.lucene",
     "is.microsoft", "id.microsoft", "id.lucene", "ga.lucene", "it.microsoft", "it.lucene",
     "ja.microsoft", "ja.lucene", "kn.microsoft", "ko.microsoft", "ko.lucene", "lv.microsoft",
     "lv.lucene", "lt.microsoft", "ml.microsoft", "ms.microsoft", "mr.microsoft", "nb.microsoft",
     "no.lucene", "fa.lucene", "pl.microsoft", "pl.lucene", "pt-BR.microsoft", "pt-BR.lucene",
     "pt-PT.microsoft", "pt-PT.lucene", "pa.microsoft", "ro.microsoft", "ro.lucene", "ru.microsoft",
     "ru.lucene", "sr-cyrillic.microsoft", "sr-latin.microsoft", "sk.microsoft", "sl.microsoft",
     "es.microsoft", "es.lucene", "sv.microsoft", "sv.lucene", "ta.microsoft", "te.microsoft",
     "th.microsoft", "th.lucene", "tr.microsoft", "tr.lucene", "uk.microsoft", "ur.microsoft",
     "vi.microsoft", "standard.lucene", "standardasciifolding.lucene", "keyword", "pattern",
     "simple", "stop", and "whitespace".
    :vartype analyzer_name: str or ~azure.search.documents.indexes.models.LexicalAnalyzerName
    :ivar tokenizer_name: The name of the tokenizer to use to break the given text. If this
     parameter is not specified, you must specify an analyzer instead. The tokenizer and analyzer
     parameters are mutually exclusive. Known values are: "classic", "edgeNGram", "keyword_v2",
     "letter", "lowercase", "microsoft_language_tokenizer", "microsoft_language_stemming_tokenizer",
     "nGram", "path_hierarchy_v2", "pattern", "standard_v2", "uax_url_email", and "whitespace".
    :vartype tokenizer_name: str or ~azure.search.documents.indexes.models.LexicalTokenizerName
    :ivar normalizer_name: The name of the normalizer to use to normalize the given text. Known
     values are: "asciifolding", "elision", "lowercase", "standard", and "uppercase".
    :vartype normalizer_name: str or ~azure.search.documents.indexes.models.LexicalNormalizerName
    :ivar token_filters: An optional list of token filters to use when breaking the given text.
     This parameter can only be set when using the tokenizer parameter.
    :vartype token_filters: list[str or ~azure.search.documents.indexes.models.TokenFilterName]
    :ivar char_filters: An optional list of character filters to use when breaking the given text.
     This parameter can only be set when using the tokenizer parameter.
    :vartype char_filters: list[str or ~azure.search.documents.indexes.models.CharFilterName]
    """

    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text to break into tokens. Required."""
    analyzer_name: Optional[Union[str, "_models.LexicalAnalyzerName"]] = rest_field(
        name="analyzer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the analyzer to use to break the given text. If this parameter is not specified,
     you must specify a tokenizer instead. The tokenizer and analyzer parameters are mutually
     exclusive. Known values are: \"ar.microsoft\", \"ar.lucene\", \"hy.lucene\", \"bn.microsoft\",
     \"eu.lucene\", \"bg.microsoft\", \"bg.lucene\", \"ca.microsoft\", \"ca.lucene\",
     \"zh-Hans.microsoft\", \"zh-Hans.lucene\", \"zh-Hant.microsoft\", \"zh-Hant.lucene\",
     \"hr.microsoft\", \"cs.microsoft\", \"cs.lucene\", \"da.microsoft\", \"da.lucene\",
     \"nl.microsoft\", \"nl.lucene\", \"en.microsoft\", \"en.lucene\", \"et.microsoft\",
     \"fi.microsoft\", \"fi.lucene\", \"fr.microsoft\", \"fr.lucene\", \"gl.lucene\",
     \"de.microsoft\", \"de.lucene\", \"el.microsoft\", \"el.lucene\", \"gu.microsoft\",
     \"he.microsoft\", \"hi.microsoft\", \"hi.lucene\", \"hu.microsoft\", \"hu.lucene\",
     \"is.microsoft\", \"id.microsoft\", \"id.lucene\", \"ga.lucene\", \"it.microsoft\",
     \"it.lucene\", \"ja.microsoft\", \"ja.lucene\", \"kn.microsoft\", \"ko.microsoft\",
     \"ko.lucene\", \"lv.microsoft\", \"lv.lucene\", \"lt.microsoft\", \"ml.microsoft\",
     \"ms.microsoft\", \"mr.microsoft\", \"nb.microsoft\", \"no.lucene\", \"fa.lucene\",
     \"pl.microsoft\", \"pl.lucene\", \"pt-BR.microsoft\", \"pt-BR.lucene\", \"pt-PT.microsoft\",
     \"pt-PT.lucene\", \"pa.microsoft\", \"ro.microsoft\", \"ro.lucene\", \"ru.microsoft\",
     \"ru.lucene\", \"sr-cyrillic.microsoft\", \"sr-latin.microsoft\", \"sk.microsoft\",
     \"sl.microsoft\", \"es.microsoft\", \"es.lucene\", \"sv.microsoft\", \"sv.lucene\",
     \"ta.microsoft\", \"te.microsoft\", \"th.microsoft\", \"th.lucene\", \"tr.microsoft\",
     \"tr.lucene\", \"uk.microsoft\", \"ur.microsoft\", \"vi.microsoft\", \"standard.lucene\",
     \"standardasciifolding.lucene\", \"keyword\", \"pattern\", \"simple\", \"stop\", and
     \"whitespace\"."""
    tokenizer_name: Optional[Union[str, "_models.LexicalTokenizerName"]] = rest_field(
        name="tokenizer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the tokenizer to use to break the given text. If this parameter is not specified,
     you must specify an analyzer instead. The tokenizer and analyzer parameters are mutually
     exclusive. Known values are: \"classic\", \"edgeNGram\", \"keyword_v2\", \"letter\",
     \"lowercase\", \"microsoft_language_tokenizer\", \"microsoft_language_stemming_tokenizer\",
     \"nGram\", \"path_hierarchy_v2\", \"pattern\", \"standard_v2\", \"uax_url_email\", and
     \"whitespace\"."""
    normalizer_name: Optional[Union[str, "_models.LexicalNormalizerName"]] = rest_field(
        name="normalizer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the normalizer to use to normalize the given text. Known values are:
     \"asciifolding\", \"elision\", \"lowercase\", \"standard\", and \"uppercase\"."""
    token_filters: Optional[list[Union[str, "_models.TokenFilterName"]]] = rest_field(
        name="tokenFilters", visibility=["read", "create", "update", "delete", "query"]
    )
    """An optional list of token filters to use when breaking the given text. This parameter can only
     be set when using the tokenizer parameter."""
    char_filters: Optional[list[Union[str, "_models.CharFilterName"]]] = rest_field(
        name="charFilters", visibility=["read", "create", "update", "delete", "query"]
    )
    """An optional list of character filters to use when breaking the given text. This parameter can
     only be set when using the tokenizer parameter."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        analyzer_name: Optional[Union[str, "_models.LexicalAnalyzerName"]] = None,
        tokenizer_name: Optional[Union[str, "_models.LexicalTokenizerName"]] = None,
        normalizer_name: Optional[Union[str, "_models.LexicalNormalizerName"]] = None,
        token_filters: Optional[list[Union[str, "_models.TokenFilterName"]]] = None,
        char_filters: Optional[list[Union[str, "_models.CharFilterName"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TokenFilter(_Model):
    """Base type for token filters.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AsciiFoldingTokenFilter, CjkBigramTokenFilter, CommonGramTokenFilter,
    DictionaryDecompounderTokenFilter, EdgeNGramTokenFilter, EdgeNGramTokenFilterV2,
    ElisionTokenFilter, KeepTokenFilter, KeywordMarkerTokenFilter, LengthTokenFilter,
    LimitTokenFilter, NGramTokenFilter, NGramTokenFilterV2, PatternCaptureTokenFilter,
    PatternReplaceTokenFilter, PhoneticTokenFilter, ShingleTokenFilter, SnowballTokenFilter,
    StemmerOverrideTokenFilter, StemmerTokenFilter, StopwordsTokenFilter, SynonymTokenFilter,
    TruncateTokenFilter, UniqueTokenFilter, WordDelimiterTokenFilter

    :ivar odata_type: The discriminator for derived types. Required. Default value is None.
    :vartype odata_type: str
    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    """

    __mapping__: dict[str, _Model] = {}
    odata_type: str = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])
    """The discriminator for derived types. Required. Default value is None."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the token filter. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required."""

    @overload
    def __init__(
        self,
        *,
        odata_type: str,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AsciiFoldingTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.AsciiFoldingTokenFilter"):
    """Converts alphabetic, numeric, and symbolic Unicode characters which are not in the first 127
    ASCII characters (the "Basic Latin" Unicode block) into their ASCII equivalents, if such
    equivalents exist. This token filter is implemented using Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar preserve_original: A value indicating whether the original token will be kept. Default is
     false.
    :vartype preserve_original: bool
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.AsciiFoldingTokenFilter".
    :vartype odata_type: str
    """

    preserve_original: Optional[bool] = rest_field(
        name="preserveOriginal", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether the original token will be kept. Default is false."""
    odata_type: Literal["#Microsoft.Azure.Search.AsciiFoldingTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.AsciiFoldingTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        preserve_original: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.AsciiFoldingTokenFilter"  # type: ignore


class AzureActiveDirectoryApplicationCredentials(_Model):  # pylint: disable=name-too-long
    """Credentials of a registered application created for your search service, used for authenticated
    access to the encryption keys stored in Azure Key Vault.

    :ivar application_id: An AAD Application ID that was granted the required access permissions to
     the Azure Key Vault that is to be used when encrypting your data at rest. The Application ID
     should not be confused with the Object ID for your AAD Application. Required.
    :vartype application_id: str
    :ivar application_secret: The authentication key of the specified AAD application.
    :vartype application_secret: str
    """

    application_id: str = rest_field(name="applicationId", visibility=["read", "create", "update", "delete", "query"])
    """An AAD Application ID that was granted the required access permissions to the Azure Key Vault
     that is to be used when encrypting your data at rest. The Application ID should not be confused
     with the Object ID for your AAD Application. Required."""
    application_secret: Optional[str] = rest_field(
        name="applicationSecret", visibility=["read", "create", "update", "delete", "query"]
    )
    """The authentication key of the specified AAD application."""

    @overload
    def __init__(
        self,
        *,
        application_id: str,
        application_secret: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeSource(_Model):
    """Represents a knowledge source definition.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureBlobKnowledgeSource, IndexedOneLakeKnowledgeSource, IndexedSharePointKnowledgeSource,
    RemoteSharePointKnowledgeSource, SearchIndexKnowledgeSource, WebKnowledgeSource

    :ivar name: The name of the knowledge source. Required.
    :vartype name: str
    :ivar description: Optional user-defined description.
    :vartype description: str
    :ivar kind: The type of the knowledge source. Required. Known values are: "searchIndex",
     "azureBlob", "indexedSharePoint", "indexedOneLake", "web", and "remoteSharePoint".
    :vartype kind: str or ~azure.search.documents.indexes.models.KnowledgeSourceKind
    :ivar e_tag: The ETag of the knowledge source.
    :vartype e_tag: str
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your knowledge source
     definition when you want full assurance that no one, not even Microsoft, can decrypt them. Once
     you have encrypted your knowledge source definition, it will always remain encrypted. The
     search service will ignore attempts to set this property to null. You can change this property
     as needed if you want to rotate your encryption key; Your knowledge source definition will be
     unaffected. Encryption with customer-managed keys is not available for free search services,
     and is only available for paid services created on or after January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    """

    __mapping__: dict[str, _Model] = {}
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the knowledge source. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional user-defined description."""
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """The type of the knowledge source. Required. Known values are: \"searchIndex\", \"azureBlob\",
     \"indexedSharePoint\", \"indexedOneLake\", \"web\", and \"remoteSharePoint\"."""
    e_tag: Optional[str] = rest_field(name="@odata.etag", visibility=["read", "create", "update", "delete", "query"])
    """The ETag of the knowledge source."""
    encryption_key: Optional["_models.SearchResourceEncryptionKey"] = rest_field(
        name="encryptionKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """A description of an encryption key that you create in Azure Key Vault. This key is used to
     provide an additional level of encryption-at-rest for your knowledge source definition when you
     want full assurance that no one, not even Microsoft, can decrypt them. Once you have encrypted
     your knowledge source definition, it will always remain encrypted. The search service will
     ignore attempts to set this property to null. You can change this property as needed if you
     want to rotate your encryption key; Your knowledge source definition will be unaffected.
     Encryption with customer-managed keys is not available for free search services, and is only
     available for paid services created on or after January 1, 2019."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        kind: str,
        description: Optional[str] = None,
        e_tag: Optional[str] = None,
        encryption_key: Optional["_models.SearchResourceEncryptionKey"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureBlobKnowledgeSource(KnowledgeSource, discriminator="azureBlob"):
    """Configuration for Azure Blob Storage knowledge source.

    :ivar name: The name of the knowledge source. Required.
    :vartype name: str
    :ivar description: Optional user-defined description.
    :vartype description: str
    :ivar e_tag: The ETag of the knowledge source.
    :vartype e_tag: str
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your knowledge source
     definition when you want full assurance that no one, not even Microsoft, can decrypt them. Once
     you have encrypted your knowledge source definition, it will always remain encrypted. The
     search service will ignore attempts to set this property to null. You can change this property
     as needed if you want to rotate your encryption key; Your knowledge source definition will be
     unaffected. Encryption with customer-managed keys is not available for free search services,
     and is only available for paid services created on or after January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :ivar kind: Required. A knowledge source that read and ingest data from Azure Blob Storage to a
     Search Index.
    :vartype kind: str or ~azure.search.documents.indexes.models.AZURE_BLOB
    :ivar azure_blob_parameters: The type of the knowledge source. Required.
    :vartype azure_blob_parameters:
     ~azure.search.documents.indexes.models.AzureBlobKnowledgeSourceParameters
    """

    kind: Literal[KnowledgeSourceKind.AZURE_BLOB] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. A knowledge source that read and ingest data from Azure Blob Storage to a Search
     Index."""
    azure_blob_parameters: "_models.AzureBlobKnowledgeSourceParameters" = rest_field(
        name="azureBlobParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the knowledge source. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        azure_blob_parameters: "_models.AzureBlobKnowledgeSourceParameters",
        description: Optional[str] = None,
        e_tag: Optional[str] = None,
        encryption_key: Optional["_models.SearchResourceEncryptionKey"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeSourceKind.AZURE_BLOB  # type: ignore


class AzureBlobKnowledgeSourceParameters(_Model):
    """Parameters for Azure Blob Storage knowledge source.

    :ivar connection_string: Key-based connection string or the ResourceId format if using a
     managed identity. Required.
    :vartype connection_string: str
    :ivar container_name: The name of the blob storage container. Required.
    :vartype container_name: str
    :ivar folder_path: Optional folder path within the container.
    :vartype folder_path: str
    :ivar is_adls_gen2: Set to true if connecting to an ADLS Gen2 storage account. Default is
     false.
    :vartype is_adls_gen2: bool
    :ivar ingestion_parameters: Consolidates all general ingestion settings.
    :vartype ingestion_parameters:
     ~azure.search.documents.knowledgebases.models.KnowledgeSourceIngestionParameters
    :ivar created_resources: Resources created by the knowledge source.
    :vartype created_resources: ~azure.search.documents.indexes.models.CreatedResources
    """

    connection_string: str = rest_field(
        name="connectionString", visibility=["read", "create", "update", "delete", "query"]
    )
    """Key-based connection string or the ResourceId format if using a managed identity. Required."""
    container_name: str = rest_field(name="containerName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the blob storage container. Required."""
    folder_path: Optional[str] = rest_field(
        name="folderPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional folder path within the container."""
    is_adls_gen2: Optional[bool] = rest_field(
        name="isADLSGen2", visibility=["read", "create", "update", "delete", "query"]
    )
    """Set to true if connecting to an ADLS Gen2 storage account. Default is false."""
    ingestion_parameters: Optional["_knowledgebases_models3.KnowledgeSourceIngestionParameters"] = rest_field(
        name="ingestionParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Consolidates all general ingestion settings."""
    created_resources: Optional["_models.CreatedResources"] = rest_field(name="createdResources", visibility=["read"])
    """Resources created by the knowledge source."""

    @overload
    def __init__(
        self,
        *,
        connection_string: str,
        container_name: str,
        folder_path: Optional[str] = None,
        is_adls_gen2: Optional[bool] = None,
        ingestion_parameters: Optional["_knowledgebases_models3.KnowledgeSourceIngestionParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureMachineLearningParameters(_Model):
    """Specifies the properties for connecting to an AML vectorizer.

    :ivar scoring_uri: (Required for no authentication or key authentication) The scoring URI of
     the AML service to which the JSON payload will be sent. Only the https URI scheme is allowed.
     Required.
    :vartype scoring_uri: str
    :ivar authentication_key: (Required for key authentication) The key for the AML service.
    :vartype authentication_key: str
    :ivar resource_id: (Required for token authentication). The Azure Resource Manager resource ID
     of the AML service. It should be in the format
     subscriptions/{guid}/resourceGroups/{resource-group-name}/Microsoft.MachineLearningServices/workspaces/{workspace-name}/services/{service_name}.
    :vartype resource_id: str
    :ivar timeout: (Optional) When specified, indicates the timeout for the http client making the
     API call.
    :vartype timeout: ~datetime.timedelta
    :ivar region: (Optional for token authentication). The region the AML service is deployed in.
    :vartype region: str
    :ivar model_name: The name of the embedding model from the Azure AI Foundry Catalog that is
     deployed at the provided endpoint. Known values are:
     "OpenAI-CLIP-Image-Text-Embeddings-vit-base-patch32",
     "OpenAI-CLIP-Image-Text-Embeddings-ViT-Large-Patch14-336",
     "Facebook-DinoV2-Image-Embeddings-ViT-Base", "Facebook-DinoV2-Image-Embeddings-ViT-Giant",
     "Cohere-embed-v3-english", "Cohere-embed-v3-multilingual", and "Cohere-embed-v4".
    :vartype model_name: str or ~azure.search.documents.indexes.models.AIFoundryModelCatalogName
    """

    scoring_uri: str = rest_field(name="uri", visibility=["read", "create", "update", "delete", "query"])
    """(Required for no authentication or key authentication) The scoring URI of the AML service to
     which the JSON payload will be sent. Only the https URI scheme is allowed. Required."""
    authentication_key: Optional[str] = rest_field(
        name="key", visibility=["read", "create", "update", "delete", "query"]
    )
    """(Required for key authentication) The key for the AML service."""
    resource_id: Optional[str] = rest_field(
        name="resourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """(Required for token authentication). The Azure Resource Manager resource ID of the AML service.
     It should be in the format
     subscriptions/{guid}/resourceGroups/{resource-group-name}/Microsoft.MachineLearningServices/workspaces/{workspace-name}/services/{service_name}."""
    timeout: Optional[datetime.timedelta] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(Optional) When specified, indicates the timeout for the http client making the API call."""
    region: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(Optional for token authentication). The region the AML service is deployed in."""
    model_name: Optional[Union[str, "_models.AIFoundryModelCatalogName"]] = rest_field(
        name="modelName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the embedding model from the Azure AI Foundry Catalog that is deployed at the
     provided endpoint. Known values are: \"OpenAI-CLIP-Image-Text-Embeddings-vit-base-patch32\",
     \"OpenAI-CLIP-Image-Text-Embeddings-ViT-Large-Patch14-336\",
     \"Facebook-DinoV2-Image-Embeddings-ViT-Base\", \"Facebook-DinoV2-Image-Embeddings-ViT-Giant\",
     \"Cohere-embed-v3-english\", \"Cohere-embed-v3-multilingual\", and \"Cohere-embed-v4\"."""

    @overload
    def __init__(
        self,
        *,
        scoring_uri: str,
        authentication_key: Optional[str] = None,
        resource_id: Optional[str] = None,
        timeout: Optional[datetime.timedelta] = None,
        region: Optional[str] = None,
        model_name: Optional[Union[str, "_models.AIFoundryModelCatalogName"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerSkill(_Model):
    """Base type for skills.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureMachineLearningSkill, ChatCompletionSkill, WebApiSkill, AzureOpenAIEmbeddingSkill,
    CustomEntityLookupSkill, KeyPhraseExtractionSkill, LanguageDetectionSkill, MergeSkill,
    PIIDetectionSkill, SplitSkill, TextTranslationSkill, EntityLinkingSkill,
    EntityRecognitionSkillV3, SentimentSkillV3, ConditionalSkill, ContentUnderstandingSkill,
    DocumentExtractionSkill, DocumentIntelligenceLayoutSkill, ShaperSkill, ImageAnalysisSkill,
    OcrSkill, VisionVectorizeSkill

    :ivar odata_type: The discriminator for derived types. Required. Default value is None.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    """

    __mapping__: dict[str, _Model] = {}
    odata_type: str = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])
    """The discriminator for derived types. Required. Default value is None."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the skill which uniquely identifies it within the skillset. A skill with no name
     defined will be given a default name of its 1-based index in the skills array, prefixed with
     the character '#'."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description of the skill which describes the inputs, outputs, and usage of the skill."""
    context: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the level at which operations take place, such as the document root or document
     content (for example, /document or /document/content). The default is /document."""
    inputs: list["_models.InputFieldMappingEntry"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Inputs of the skills could be a column in the source data set, or the output of an upstream
     skill. Required."""
    outputs: list["_models.OutputFieldMappingEntry"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The output of a skill is either a field in a search index, or a value that can be consumed as
     an input by another skill. Required."""

    @overload
    def __init__(
        self,
        *,
        odata_type: str,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureMachineLearningSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Custom.AmlSkill"):
    """The AML skill allows you to extend AI enrichment with a custom Azure Machine Learning (AML)
    model. Once an AML model is trained and deployed, an AML skill integrates it into AI
    enrichment.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar scoring_uri: (Required for no authentication or key authentication) The scoring URI of
     the AML service to which the JSON payload will be sent. Only the https URI scheme is allowed.
    :vartype scoring_uri: str
    :ivar authentication_key: (Required for key authentication) The key for the AML service.
    :vartype authentication_key: str
    :ivar resource_id: (Required for token authentication). The Azure Resource Manager resource ID
     of the AML service. It should be in the format
     subscriptions/{guid}/resourceGroups/{resource-group-name}/Microsoft.MachineLearningServices/workspaces/{workspace-name}/services/{service_name}.
    :vartype resource_id: str
    :ivar timeout: (Optional) When specified, indicates the timeout for the http client making the
     API call.
    :vartype timeout: ~datetime.timedelta
    :ivar region: (Optional for token authentication). The region the AML service is deployed in.
    :vartype region: str
    :ivar degree_of_parallelism: (Optional) When specified, indicates the number of calls the
     indexer will make in parallel to the endpoint you have provided. You can decrease this value if
     your endpoint is failing under too high of a request load, or raise it if your endpoint is able
     to accept more requests and you would like an increase in the performance of the indexer. If
     not set, a default value of 5 is used. The degreeOfParallelism can be set to a maximum of 10
     and a minimum of 1.
    :vartype degree_of_parallelism: int
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Custom.AmlSkill".
    :vartype odata_type: str
    """

    scoring_uri: Optional[str] = rest_field(name="uri", visibility=["read", "create", "update", "delete", "query"])
    """(Required for no authentication or key authentication) The scoring URI of the AML service to
     which the JSON payload will be sent. Only the https URI scheme is allowed."""
    authentication_key: Optional[str] = rest_field(
        name="key", visibility=["read", "create", "update", "delete", "query"]
    )
    """(Required for key authentication) The key for the AML service."""
    resource_id: Optional[str] = rest_field(
        name="resourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """(Required for token authentication). The Azure Resource Manager resource ID of the AML service.
     It should be in the format
     subscriptions/{guid}/resourceGroups/{resource-group-name}/Microsoft.MachineLearningServices/workspaces/{workspace-name}/services/{service_name}."""
    timeout: Optional[datetime.timedelta] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(Optional) When specified, indicates the timeout for the http client making the API call."""
    region: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(Optional for token authentication). The region the AML service is deployed in."""
    degree_of_parallelism: Optional[int] = rest_field(
        name="degreeOfParallelism", visibility=["read", "create", "update", "delete", "query"]
    )
    """(Optional) When specified, indicates the number of calls the indexer will make in parallel to
     the endpoint you have provided. You can decrease this value if your endpoint is failing under
     too high of a request load, or raise it if your endpoint is able to accept more requests and
     you would like an increase in the performance of the indexer. If not set, a default value of 5
     is used. The degreeOfParallelism can be set to a maximum of 10 and a minimum of 1."""
    odata_type: Literal["#Microsoft.Skills.Custom.AmlSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Custom.AmlSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        scoring_uri: Optional[str] = None,
        authentication_key: Optional[str] = None,
        resource_id: Optional[str] = None,
        timeout: Optional[datetime.timedelta] = None,
        region: Optional[str] = None,
        degree_of_parallelism: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Custom.AmlSkill"  # type: ignore


class AzureMachineLearningVectorizer(VectorSearchVectorizer, discriminator="aml"):
    """Specifies an Azure Machine Learning endpoint deployed via the Azure AI Foundry Model Catalog
    for generating the vector embedding of a query string.

    :ivar vectorizer_name: The name to associate with this particular vectorization method.
     Required.
    :vartype vectorizer_name: str
    :ivar aml_parameters: Specifies the properties of the AML vectorizer.
    :vartype aml_parameters: ~azure.search.documents.indexes.models.AzureMachineLearningParameters
    :ivar kind: The name of the kind of vectorization method being configured for use with vector
     search. Required. Generate embeddings using an Azure Machine Learning endpoint deployed via the
     Azure AI Foundry Model Catalog at query time.
    :vartype kind: str or ~azure.search.documents.indexes.models.AML
    """

    aml_parameters: Optional["_models.AzureMachineLearningParameters"] = rest_field(
        name="amlParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the properties of the AML vectorizer."""
    kind: Literal[VectorSearchVectorizerKind.AML] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The name of the kind of vectorization method being configured for use with vector search.
     Required. Generate embeddings using an Azure Machine Learning endpoint deployed via the Azure
     AI Foundry Model Catalog at query time."""

    @overload
    def __init__(
        self,
        *,
        vectorizer_name: str,
        aml_parameters: Optional["_models.AzureMachineLearningParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = VectorSearchVectorizerKind.AML  # type: ignore


class AzureOpenAIEmbeddingSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Text.AzureOpenAIEmbeddingSkill"):
    """Allows you to generate a vector embedding for a given text input using the Azure OpenAI
    resource.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar resource_url: The resource URI of the Azure OpenAI resource.
    :vartype resource_url: str
    :ivar deployment_name: ID of the Azure OpenAI model deployment on the designated resource.
    :vartype deployment_name: str
    :ivar api_key: API key of the designated Azure OpenAI resource.
    :vartype api_key: str
    :ivar auth_identity: The user-assigned managed identity used for outbound connections.
    :vartype auth_identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
    :ivar model_name: The name of the embedding model that is deployed at the provided deploymentId
     path. Known values are: "text-embedding-ada-002", "text-embedding-3-large",
     "text-embedding-3-small", "gpt-4o", "gpt-4o-mini", "gpt-4.1", "gpt-4.1-mini", "gpt-4.1-nano",
     "gpt-5", "gpt-5-mini", and "gpt-5-nano".
    :vartype model_name: str or ~azure.search.documents.indexes.models.AzureOpenAIModelName
    :ivar dimensions: The number of dimensions the resulting output embeddings should have. Only
     supported in text-embedding-3 and later models.
    :vartype dimensions: int
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Text.AzureOpenAIEmbeddingSkill".
    :vartype odata_type: str
    """

    resource_url: Optional[str] = rest_field(
        name="resourceUri", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource URI of the Azure OpenAI resource."""
    deployment_name: Optional[str] = rest_field(
        name="deploymentId", visibility=["read", "create", "update", "delete", "query"]
    )
    """ID of the Azure OpenAI model deployment on the designated resource."""
    api_key: Optional[str] = rest_field(name="apiKey", visibility=["read", "create", "update", "delete", "query"])
    """API key of the designated Azure OpenAI resource."""
    auth_identity: Optional["_models.SearchIndexerDataIdentity"] = rest_field(
        name="authIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user-assigned managed identity used for outbound connections."""
    model_name: Optional[Union[str, "_models.AzureOpenAIModelName"]] = rest_field(
        name="modelName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the embedding model that is deployed at the provided deploymentId path. Known
     values are: \"text-embedding-ada-002\", \"text-embedding-3-large\", \"text-embedding-3-small\",
     \"gpt-4o\", \"gpt-4o-mini\", \"gpt-4.1\", \"gpt-4.1-mini\", \"gpt-4.1-nano\", \"gpt-5\",
     \"gpt-5-mini\", and \"gpt-5-nano\"."""
    dimensions: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of dimensions the resulting output embeddings should have. Only supported in
     text-embedding-3 and later models."""
    odata_type: Literal["#Microsoft.Skills.Text.AzureOpenAIEmbeddingSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Text.AzureOpenAIEmbeddingSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        resource_url: Optional[str] = None,
        deployment_name: Optional[str] = None,
        api_key: Optional[str] = None,
        auth_identity: Optional["_models.SearchIndexerDataIdentity"] = None,
        model_name: Optional[Union[str, "_models.AzureOpenAIModelName"]] = None,
        dimensions: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Text.AzureOpenAIEmbeddingSkill"  # type: ignore


class AzureOpenAITokenizerParameters(_Model):
    """Azure OpenAI Tokenizer parameters.

    :ivar encoder_model_name: Only applies if the unit is set to azureOpenAITokens. Options include
     'R50k_base', 'P50k_base', 'P50k_edit' and 'CL100k_base'. The default value is 'CL100k_base'.
     Known values are: "r50k_base", "p50k_base", "p50k_edit", and "cl100k_base".
    :vartype encoder_model_name: str or
     ~azure.search.documents.indexes.models.SplitSkillEncoderModelName
    :ivar allowed_special_tokens: (Optional) Only applies if the unit is set to azureOpenAITokens.
     This parameter defines a collection of special tokens that are permitted within the
     tokenization process.
    :vartype allowed_special_tokens: list[str]
    """

    encoder_model_name: Optional[Union[str, "_models.SplitSkillEncoderModelName"]] = rest_field(
        name="encoderModelName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Only applies if the unit is set to azureOpenAITokens. Options include 'R50k_base', 'P50k_base',
     'P50k_edit' and 'CL100k_base'. The default value is 'CL100k_base'. Known values are:
     \"r50k_base\", \"p50k_base\", \"p50k_edit\", and \"cl100k_base\"."""
    allowed_special_tokens: Optional[list[str]] = rest_field(
        name="allowedSpecialTokens", visibility=["read", "create", "update", "delete", "query"]
    )
    """(Optional) Only applies if the unit is set to azureOpenAITokens. This parameter defines a
     collection of special tokens that are permitted within the tokenization process."""

    @overload
    def __init__(
        self,
        *,
        encoder_model_name: Optional[Union[str, "_models.SplitSkillEncoderModelName"]] = None,
        allowed_special_tokens: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureOpenAIVectorizer(VectorSearchVectorizer, discriminator="azureOpenAI"):
    """Specifies the Azure OpenAI resource used to vectorize a query string.

    :ivar vectorizer_name: The name to associate with this particular vectorization method.
     Required.
    :vartype vectorizer_name: str
    :ivar parameters: Contains the parameters specific to Azure OpenAI embedding vectorization.
    :vartype parameters: ~azure.search.documents.indexes.models.AzureOpenAIVectorizerParameters
    :ivar kind: The name of the kind of vectorization method being configured for use with vector
     search. Required. Generate embeddings using an Azure OpenAI resource at query time.
    :vartype kind: str or ~azure.search.documents.indexes.models.AZURE_OPEN_AI
    """

    parameters: Optional["_models.AzureOpenAIVectorizerParameters"] = rest_field(
        name="azureOpenAIParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the parameters specific to Azure OpenAI embedding vectorization."""
    kind: Literal[VectorSearchVectorizerKind.AZURE_OPEN_AI] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The name of the kind of vectorization method being configured for use with vector search.
     Required. Generate embeddings using an Azure OpenAI resource at query time."""

    @overload
    def __init__(
        self,
        *,
        vectorizer_name: str,
        parameters: Optional["_models.AzureOpenAIVectorizerParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = VectorSearchVectorizerKind.AZURE_OPEN_AI  # type: ignore


class AzureOpenAIVectorizerParameters(_Model):
    """Specifies the parameters for connecting to the Azure OpenAI resource.

    :ivar resource_url: The resource URI of the Azure OpenAI resource.
    :vartype resource_url: str
    :ivar deployment_name: ID of the Azure OpenAI model deployment on the designated resource.
    :vartype deployment_name: str
    :ivar api_key: API key of the designated Azure OpenAI resource.
    :vartype api_key: str
    :ivar auth_identity: The user-assigned managed identity used for outbound connections.
    :vartype auth_identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
    :ivar model_name: The name of the embedding model that is deployed at the provided deploymentId
     path. Known values are: "text-embedding-ada-002", "text-embedding-3-large",
     "text-embedding-3-small", "gpt-4o", "gpt-4o-mini", "gpt-4.1", "gpt-4.1-mini", "gpt-4.1-nano",
     "gpt-5", "gpt-5-mini", and "gpt-5-nano".
    :vartype model_name: str or ~azure.search.documents.indexes.models.AzureOpenAIModelName
    """

    resource_url: Optional[str] = rest_field(
        name="resourceUri", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource URI of the Azure OpenAI resource."""
    deployment_name: Optional[str] = rest_field(
        name="deploymentId", visibility=["read", "create", "update", "delete", "query"]
    )
    """ID of the Azure OpenAI model deployment on the designated resource."""
    api_key: Optional[str] = rest_field(name="apiKey", visibility=["read", "create", "update", "delete", "query"])
    """API key of the designated Azure OpenAI resource."""
    auth_identity: Optional["_models.SearchIndexerDataIdentity"] = rest_field(
        name="authIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user-assigned managed identity used for outbound connections."""
    model_name: Optional[Union[str, "_models.AzureOpenAIModelName"]] = rest_field(
        name="modelName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the embedding model that is deployed at the provided deploymentId path. Known
     values are: \"text-embedding-ada-002\", \"text-embedding-3-large\", \"text-embedding-3-small\",
     \"gpt-4o\", \"gpt-4o-mini\", \"gpt-4.1\", \"gpt-4.1-mini\", \"gpt-4.1-nano\", \"gpt-5\",
     \"gpt-5-mini\", and \"gpt-5-nano\"."""

    @overload
    def __init__(
        self,
        *,
        resource_url: Optional[str] = None,
        deployment_name: Optional[str] = None,
        api_key: Optional[str] = None,
        auth_identity: Optional["_models.SearchIndexerDataIdentity"] = None,
        model_name: Optional[Union[str, "_models.AzureOpenAIModelName"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VectorSearchCompression(_Model):
    """Contains configuration options specific to the compression method used during indexing or
    querying.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BinaryQuantizationCompression, ScalarQuantizationCompression

    :ivar compression_name: The name to associate with this particular configuration. Required.
    :vartype compression_name: str
    :ivar rescoring_options: Contains the options for rescoring.
    :vartype rescoring_options: ~azure.search.documents.indexes.models.RescoringOptions
    :ivar truncation_dimension: The number of dimensions to truncate the vectors to. Truncating the
     vectors reduces the size of the vectors and the amount of data that needs to be transferred
     during search. This can save storage cost and improve search performance at the expense of
     recall. It should be only used for embeddings trained with Matryoshka Representation Learning
     (MRL) such as OpenAI text-embedding-3-large (small). The default value is null, which means no
     truncation.
    :vartype truncation_dimension: int
    :ivar kind: Type of VectorSearchCompression. Required. Known values are: "scalarQuantization"
     and "binaryQuantization".
    :vartype kind: str or ~azure.search.documents.indexes.models.VectorSearchCompressionKind
    """

    __mapping__: dict[str, _Model] = {}
    compression_name: str = rest_field(name="name", visibility=["read", "create", "update", "delete", "query"])
    """The name to associate with this particular configuration. Required."""
    rescoring_options: Optional["_models.RescoringOptions"] = rest_field(
        name="rescoringOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the options for rescoring."""
    truncation_dimension: Optional[int] = rest_field(
        name="truncationDimension", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of dimensions to truncate the vectors to. Truncating the vectors reduces the size of
     the vectors and the amount of data that needs to be transferred during search. This can save
     storage cost and improve search performance at the expense of recall. It should be only used
     for embeddings trained with Matryoshka Representation Learning (MRL) such as OpenAI
     text-embedding-3-large (small). The default value is null, which means no truncation."""
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """Type of VectorSearchCompression. Required. Known values are: \"scalarQuantization\" and
     \"binaryQuantization\"."""

    @overload
    def __init__(
        self,
        *,
        compression_name: str,
        kind: str,
        rescoring_options: Optional["_models.RescoringOptions"] = None,
        truncation_dimension: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BinaryQuantizationCompression(VectorSearchCompression, discriminator="binaryQuantization"):
    """Contains configuration options specific to the binary quantization compression method used
    during indexing and querying.

    :ivar compression_name: The name to associate with this particular configuration. Required.
    :vartype compression_name: str
    :ivar rescoring_options: Contains the options for rescoring.
    :vartype rescoring_options: ~azure.search.documents.indexes.models.RescoringOptions
    :ivar truncation_dimension: The number of dimensions to truncate the vectors to. Truncating the
     vectors reduces the size of the vectors and the amount of data that needs to be transferred
     during search. This can save storage cost and improve search performance at the expense of
     recall. It should be only used for embeddings trained with Matryoshka Representation Learning
     (MRL) such as OpenAI text-embedding-3-large (small). The default value is null, which means no
     truncation.
    :vartype truncation_dimension: int
    :ivar kind: The name of the kind of compression method being configured for use with vector
     search. Required. Binary Quantization, a type of compression method. In binary quantization,
     the original vectors values are compressed to the narrower binary type by discretizing and
     representing each component of a vector using binary values, thereby reducing the overall data
     size.
    :vartype kind: str or ~azure.search.documents.indexes.models.BINARY_QUANTIZATION
    """

    kind: Literal[VectorSearchCompressionKind.BINARY_QUANTIZATION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The name of the kind of compression method being configured for use with vector search.
     Required. Binary Quantization, a type of compression method. In binary quantization, the
     original vectors values are compressed to the narrower binary type by discretizing and
     representing each component of a vector using binary values, thereby reducing the overall data
     size."""

    @overload
    def __init__(
        self,
        *,
        compression_name: str,
        rescoring_options: Optional["_models.RescoringOptions"] = None,
        truncation_dimension: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = VectorSearchCompressionKind.BINARY_QUANTIZATION  # type: ignore


class SimilarityAlgorithm(_Model):
    """Base type for similarity algorithms. Similarity algorithms are used to calculate scores that
    tie queries to documents. The higher the score, the more relevant the document is to that
    specific query. Those scores are used to rank the search results.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BM25SimilarityAlgorithm, ClassicSimilarityAlgorithm

    :ivar odata_type: The discriminator for derived types. Required. Default value is None.
    :vartype odata_type: str
    """

    __mapping__: dict[str, _Model] = {}
    odata_type: str = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])
    """The discriminator for derived types. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        odata_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BM25SimilarityAlgorithm(SimilarityAlgorithm, discriminator="#Microsoft.Azure.Search.BM25Similarity"):
    """Ranking function based on the Okapi BM25 similarity algorithm. BM25 is a TF-IDF-like algorithm
    that includes length normalization (controlled by the 'b' parameter) as well as term frequency
    saturation (controlled by the 'k1' parameter).

    :ivar k1: This property controls the scaling function between the term frequency of each
     matching terms and the final relevance score of a document-query pair. By default, a value of
     1.2 is used. A value of 0.0 means the score does not scale with an increase in term frequency.
    :vartype k1: float
    :ivar b: This property controls how the length of a document affects the relevance score. By
     default, a value of 0.75 is used. A value of 0.0 means no length normalization is applied,
     while a value of 1.0 means the score is fully normalized by the length of the document.
    :vartype b: float
    :ivar odata_type: The discriminator for derived types. Required. Default value is
     "#Microsoft.Azure.Search.BM25Similarity".
    :vartype odata_type: str
    """

    k1: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """This property controls the scaling function between the term frequency of each matching terms
     and the final relevance score of a document-query pair. By default, a value of 1.2 is used. A
     value of 0.0 means the score does not scale with an increase in term frequency."""
    b: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """This property controls how the length of a document affects the relevance score. By default, a
     value of 0.75 is used. A value of 0.0 means no length normalization is applied, while a value
     of 1.0 means the score is fully normalized by the length of the document."""
    odata_type: Literal["#Microsoft.Azure.Search.BM25Similarity"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator for derived types. Required. Default value is
     \"#Microsoft.Azure.Search.BM25Similarity\"."""

    @overload
    def __init__(
        self,
        *,
        k1: Optional[float] = None,
        b: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.BM25Similarity"  # type: ignore


class CharFilter(_Model):
    """Base type for character filters.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MappingCharFilter, PatternReplaceCharFilter

    :ivar odata_type: The discriminator for derived types. Required. Default value is None.
    :vartype odata_type: str
    :ivar name: The name of the char filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    """

    __mapping__: dict[str, _Model] = {}
    odata_type: str = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])
    """The discriminator for derived types. Required. Default value is None."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the char filter. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required."""

    @overload
    def __init__(
        self,
        *,
        odata_type: str,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ChatCompletionCommonModelParameters(_Model):
    """Common language model parameters for Chat Completions. If omitted, default values are used.

    :ivar model_name: The name of the model to use (e.g., 'gpt-4o', etc.). Default is null if not
     specified.
    :vartype model_name: str
    :ivar frequency_penalty: A float in the range [-2,2] that reduces or increases likelihood of
     repeated tokens. Default is 0.
    :vartype frequency_penalty: float
    :ivar presence_penalty: A float in the range [-2,2] that penalizes new tokens based on their
     existing presence. Default is 0.
    :vartype presence_penalty: float
    :ivar max_tokens: Maximum number of tokens to generate.
    :vartype max_tokens: int
    :ivar temperature: Sampling temperature. Default is 0.7.
    :vartype temperature: float
    :ivar seed: Random seed for controlling deterministic outputs. If omitted, randomization is
     used.
    :vartype seed: int
    :ivar stop: List of stop sequences that will cut off text generation. Default is none.
    :vartype stop: list[str]
    """

    model_name: Optional[str] = rest_field(name="model", visibility=["read", "create", "update", "delete", "query"])
    """The name of the model to use (e.g., 'gpt-4o', etc.). Default is null if not specified."""
    frequency_penalty: Optional[float] = rest_field(
        name="frequencyPenalty", visibility=["read", "create", "update", "delete", "query"]
    )
    """A float in the range [-2,2] that reduces or increases likelihood of repeated tokens. Default is
     0."""
    presence_penalty: Optional[float] = rest_field(
        name="presencePenalty", visibility=["read", "create", "update", "delete", "query"]
    )
    """A float in the range [-2,2] that penalizes new tokens based on their existing presence. Default
     is 0."""
    max_tokens: Optional[int] = rest_field(name="maxTokens", visibility=["read", "create", "update", "delete", "query"])
    """Maximum number of tokens to generate."""
    temperature: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Sampling temperature. Default is 0.7."""
    seed: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Random seed for controlling deterministic outputs. If omitted, randomization is used."""
    stop: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of stop sequences that will cut off text generation. Default is none."""

    @overload
    def __init__(
        self,
        *,
        model_name: Optional[str] = None,
        frequency_penalty: Optional[float] = None,
        presence_penalty: Optional[float] = None,
        max_tokens: Optional[int] = None,
        temperature: Optional[float] = None,
        seed: Optional[int] = None,
        stop: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ChatCompletionResponseFormat(_Model):
    """Determines how the language model's response should be serialized. Defaults to 'text'.

    :ivar type: Specifies how the LLM should format the response. Known values are: "text",
     "jsonObject", and "jsonSchema".
    :vartype type: str or ~azure.search.documents.indexes.models.ChatCompletionResponseFormatType
    :ivar json_schema_properties: An open dictionary for extended properties. Required if 'type' ==
     'json_schema'.
    :vartype json_schema_properties:
     ~azure.search.documents.indexes.models.ChatCompletionSchemaProperties
    """

    type: Optional[Union[str, "_models.ChatCompletionResponseFormatType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies how the LLM should format the response. Known values are: \"text\", \"jsonObject\",
     and \"jsonSchema\"."""
    json_schema_properties: Optional["_models.ChatCompletionSchemaProperties"] = rest_field(
        name="jsonSchemaProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """An open dictionary for extended properties. Required if 'type' == 'json_schema'."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ChatCompletionResponseFormatType"]] = None,
        json_schema_properties: Optional["_models.ChatCompletionSchemaProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ChatCompletionSchema(_Model):
    """Object defining the custom schema the model will use to structure its output.

    :ivar type: Type of schema representation. Usually 'object'. Default is 'object'.
    :vartype type: str
    :ivar properties: A JSON-formatted string that defines the output schema's properties and
     constraints for the model.
    :vartype properties: str
    :ivar required: An array of the property names that are required to be part of the model's
     response. All properties must be included for structured outputs.
    :vartype required: list[str]
    :ivar additional_properties: Controls whether it is allowable for an object to contain
     additional keys / values that were not defined in the JSON Schema. Default is false.
    :vartype additional_properties: bool
    """

    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Type of schema representation. Usually 'object'. Default is 'object'."""
    properties: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A JSON-formatted string that defines the output schema's properties and constraints for the
     model."""
    required: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An array of the property names that are required to be part of the model's response. All
     properties must be included for structured outputs."""
    additional_properties: Optional[bool] = rest_field(
        name="additionalProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Controls whether it is allowable for an object to contain additional keys / values that were
     not defined in the JSON Schema. Default is false."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[str] = None,
        properties: Optional[str] = None,
        required: Optional[list[str]] = None,
        additional_properties: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ChatCompletionSchemaProperties(_Model):
    """Properties for JSON schema response format.

    :ivar name: Name of the json schema the model will adhere to.
    :vartype name: str
    :ivar description: Description of the json schema the model will adhere to.
    :vartype description: str
    :ivar strict: Whether or not the model's response should use structured outputs. Default is
     true.
    :vartype strict: bool
    :ivar schema: The schema definition.
    :vartype schema: ~azure.search.documents.indexes.models.ChatCompletionSchema
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the json schema the model will adhere to."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of the json schema the model will adhere to."""
    strict: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether or not the model's response should use structured outputs. Default is true."""
    schema: Optional["_models.ChatCompletionSchema"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The schema definition."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        strict: Optional[bool] = None,
        schema: Optional["_models.ChatCompletionSchema"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ChatCompletionSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Custom.ChatCompletionSkill"):
    """A skill that calls a language model via Azure AI Foundry's Chat Completions endpoint.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar uri: The url for the Web API. Required.
    :vartype uri: str
    :ivar http_headers: The headers required to make the http request.
    :vartype http_headers: ~azure.search.documents.indexes.models.WebApiHttpHeaders
    :ivar http_method: The method for the http request.
    :vartype http_method: str
    :ivar timeout: The desired timeout for the request. Default is 30 seconds.
    :vartype timeout: ~datetime.timedelta
    :ivar batch_size: The desired batch size which indicates number of documents.
    :vartype batch_size: int
    :ivar degree_of_parallelism: If set, the number of parallel calls that can be made to the Web
     API.
    :vartype degree_of_parallelism: int
    :ivar auth_resource_id: Applies to custom skills that connect to external code in an Azure
     function or some other application that provides the transformations. This value should be the
     application ID created for the function or app when it was registered with Azure Active
     Directory. When specified, the custom skill connects to the function or app using a managed ID
     (either system or user-assigned) of the search service and the access token of the function or
     app, using this value as the resource id for creating the scope of the access token.
    :vartype auth_resource_id: str
    :ivar auth_identity: The user-assigned managed identity used for outbound connections. If an
     authResourceId is provided and it's not specified, the system-assigned managed identity is
     used. On updates to the indexer, if the identity is unspecified, the value remains unchanged.
     If set to "none", the value of this property is cleared.
    :vartype auth_identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
    :ivar api_key: API key for authenticating to the model. Both apiKey and authIdentity cannot be
     specified at the same time.
    :vartype api_key: str
    :ivar common_model_parameters: Common language model parameters that customers can tweak. If
     omitted, reasonable defaults will be applied.
    :vartype common_model_parameters:
     ~azure.search.documents.indexes.models.ChatCompletionCommonModelParameters
    :ivar extra_parameters: Open-type dictionary for model-specific parameters that should be
     appended to the chat completions call. Follows Azure AI Foundry's extensibility pattern.
    :vartype extra_parameters: dict[str, any]
    :ivar extra_parameters_behavior: How extra parameters are handled by Azure AI Foundry. Default
     is 'error'. Known values are: "passThrough", "drop", and "error".
    :vartype extra_parameters_behavior: str or
     ~azure.search.documents.indexes.models.ChatCompletionExtraParametersBehavior
    :ivar response_format: Determines how the LLM should format its response. Defaults to 'text'
     response type.
    :vartype response_format: ~azure.search.documents.indexes.models.ChatCompletionResponseFormat
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Custom.ChatCompletionSkill".
    :vartype odata_type: str
    """

    uri: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The url for the Web API. Required."""
    http_headers: Optional["_models.WebApiHttpHeaders"] = rest_field(
        name="httpHeaders", visibility=["read", "create", "update", "delete", "query"]
    )
    """The headers required to make the http request."""
    http_method: Optional[str] = rest_field(
        name="httpMethod", visibility=["read", "create", "update", "delete", "query"]
    )
    """The method for the http request."""
    timeout: Optional[datetime.timedelta] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The desired timeout for the request. Default is 30 seconds."""
    batch_size: Optional[int] = rest_field(name="batchSize", visibility=["read", "create", "update", "delete", "query"])
    """The desired batch size which indicates number of documents."""
    degree_of_parallelism: Optional[int] = rest_field(
        name="degreeOfParallelism", visibility=["read", "create", "update", "delete", "query"]
    )
    """If set, the number of parallel calls that can be made to the Web API."""
    auth_resource_id: Optional[str] = rest_field(
        name="authResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Applies to custom skills that connect to external code in an Azure function or some other
     application that provides the transformations. This value should be the application ID created
     for the function or app when it was registered with Azure Active Directory. When specified, the
     custom skill connects to the function or app using a managed ID (either system or
     user-assigned) of the search service and the access token of the function or app, using this
     value as the resource id for creating the scope of the access token."""
    auth_identity: Optional["_models.SearchIndexerDataIdentity"] = rest_field(
        name="authIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user-assigned managed identity used for outbound connections. If an authResourceId is
     provided and it's not specified, the system-assigned managed identity is used. On updates to
     the indexer, if the identity is unspecified, the value remains unchanged. If set to \"none\",
     the value of this property is cleared."""
    api_key: Optional[str] = rest_field(name="apiKey", visibility=["read", "create", "update", "delete", "query"])
    """API key for authenticating to the model. Both apiKey and authIdentity cannot be specified at
     the same time."""
    common_model_parameters: Optional["_models.ChatCompletionCommonModelParameters"] = rest_field(
        name="commonModelParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Common language model parameters that customers can tweak. If omitted, reasonable defaults will
     be applied."""
    extra_parameters: Optional[dict[str, Any]] = rest_field(
        name="extraParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Open-type dictionary for model-specific parameters that should be appended to the chat
     completions call. Follows Azure AI Foundry's extensibility pattern."""
    extra_parameters_behavior: Optional[Union[str, "_models.ChatCompletionExtraParametersBehavior"]] = rest_field(
        name="extraParametersBehavior", visibility=["read", "create", "update", "delete", "query"]
    )
    """How extra parameters are handled by Azure AI Foundry. Default is 'error'. Known values are:
     \"passThrough\", \"drop\", and \"error\"."""
    response_format: Optional["_models.ChatCompletionResponseFormat"] = rest_field(
        name="responseFormat", visibility=["read", "create", "update", "delete", "query"]
    )
    """Determines how the LLM should format its response. Defaults to 'text' response type."""
    odata_type: Literal["#Microsoft.Skills.Custom.ChatCompletionSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Custom.ChatCompletionSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        uri: str,
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        http_headers: Optional["_models.WebApiHttpHeaders"] = None,
        http_method: Optional[str] = None,
        timeout: Optional[datetime.timedelta] = None,
        batch_size: Optional[int] = None,
        degree_of_parallelism: Optional[int] = None,
        auth_resource_id: Optional[str] = None,
        auth_identity: Optional["_models.SearchIndexerDataIdentity"] = None,
        api_key: Optional[str] = None,
        common_model_parameters: Optional["_models.ChatCompletionCommonModelParameters"] = None,
        extra_parameters: Optional[dict[str, Any]] = None,
        extra_parameters_behavior: Optional[Union[str, "_models.ChatCompletionExtraParametersBehavior"]] = None,
        response_format: Optional["_models.ChatCompletionResponseFormat"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Custom.ChatCompletionSkill"  # type: ignore


class CjkBigramTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.CjkBigramTokenFilter"):
    """Forms bigrams of CJK terms that are generated from the standard tokenizer. This token filter is
    implemented using Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar ignore_scripts: The scripts to ignore.
    :vartype ignore_scripts: list[str or
     ~azure.search.documents.indexes.models.CjkBigramTokenFilterScripts]
    :ivar output_unigrams: A value indicating whether to output both unigrams and bigrams (if
     true), or just bigrams (if false). Default is false.
    :vartype output_unigrams: bool
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.CjkBigramTokenFilter".
    :vartype odata_type: str
    """

    ignore_scripts: Optional[list[Union[str, "_models.CjkBigramTokenFilterScripts"]]] = rest_field(
        name="ignoreScripts", visibility=["read", "create", "update", "delete", "query"]
    )
    """The scripts to ignore."""
    output_unigrams: Optional[bool] = rest_field(
        name="outputUnigrams", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to output both unigrams and bigrams (if true), or just bigrams (if
     false). Default is false."""
    odata_type: Literal["#Microsoft.Azure.Search.CjkBigramTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.CjkBigramTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        ignore_scripts: Optional[list[Union[str, "_models.CjkBigramTokenFilterScripts"]]] = None,
        output_unigrams: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.CjkBigramTokenFilter"  # type: ignore


class ClassicSimilarityAlgorithm(SimilarityAlgorithm, discriminator="#Microsoft.Azure.Search.ClassicSimilarity"):
    """Legacy similarity algorithm which uses the Lucene TFIDFSimilarity implementation of TF-IDF.
    This variation of TF-IDF introduces static document length normalization as well as
    coordinating factors that penalize documents that only partially match the searched queries.

    :ivar odata_type: The discriminator for derived types. Required. Default value is
     "#Microsoft.Azure.Search.ClassicSimilarity".
    :vartype odata_type: str
    """

    odata_type: Literal["#Microsoft.Azure.Search.ClassicSimilarity"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator for derived types. Required. Default value is
     \"#Microsoft.Azure.Search.ClassicSimilarity\"."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.ClassicSimilarity"  # type: ignore


class LexicalTokenizer(_Model):
    """Base type for tokenizers.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ClassicTokenizer, EdgeNGramTokenizer, KeywordTokenizer, KeywordTokenizerV2,
    MicrosoftLanguageStemmingTokenizer, MicrosoftLanguageTokenizer, NGramTokenizer,
    PathHierarchyTokenizerV2, PatternTokenizer, LuceneStandardTokenizer, LuceneStandardTokenizerV2,
    UaxUrlEmailTokenizer

    :ivar odata_type: The discriminator for derived types. Required. Default value is None.
    :vartype odata_type: str
    :ivar name: The name of the tokenizer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    """

    __mapping__: dict[str, _Model] = {}
    odata_type: str = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])
    """The discriminator for derived types. Required. Default value is None."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the tokenizer. It must only contain letters, digits, spaces, dashes or underscores,
     can only start and end with alphanumeric characters, and is limited to 128 characters.
     Required."""

    @overload
    def __init__(
        self,
        *,
        odata_type: str,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClassicTokenizer(LexicalTokenizer, discriminator="#Microsoft.Azure.Search.ClassicTokenizer"):
    """Grammar-based tokenizer that is suitable for processing most European-language documents. This
    tokenizer is implemented using Apache Lucene.

    :ivar name: The name of the tokenizer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar max_token_length: The maximum token length. Default is 255. Tokens longer than the
     maximum length are split. The maximum token length that can be used is 300 characters.
    :vartype max_token_length: int
    :ivar odata_type: A URI fragment specifying the type of tokenizer. Required. Default value is
     "#Microsoft.Azure.Search.ClassicTokenizer".
    :vartype odata_type: str
    """

    max_token_length: Optional[int] = rest_field(
        name="maxTokenLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum token length. Default is 255. Tokens longer than the maximum length are split. The
     maximum token length that can be used is 300 characters."""
    odata_type: Literal["#Microsoft.Azure.Search.ClassicTokenizer"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of tokenizer. Required. Default value is
     \"#Microsoft.Azure.Search.ClassicTokenizer\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        max_token_length: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.ClassicTokenizer"  # type: ignore


class CognitiveServicesAccountKey(
    CognitiveServicesAccount, discriminator="#Microsoft.Azure.Search.CognitiveServicesByKey"
):
    """The multi-region account key of an Azure AI service resource that's attached to a skillset.

    :ivar description: Description of the Azure AI service resource attached to a skillset.
    :vartype description: str
    :ivar key: The key used to provision the Azure AI service resource attached to a skillset.
     Required.
    :vartype key: str
    :ivar odata_type: A URI fragment specifying the type of Azure AI service resource attached to a
     skillset. Required. Default value is "#Microsoft.Azure.Search.CognitiveServicesByKey".
    :vartype odata_type: str
    """

    key: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The key used to provision the Azure AI service resource attached to a skillset. Required."""
    odata_type: Literal["#Microsoft.Azure.Search.CognitiveServicesByKey"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of Azure AI service resource attached to a skillset.
     Required. Default value is \"#Microsoft.Azure.Search.CognitiveServicesByKey\"."""

    @overload
    def __init__(
        self,
        *,
        key: str,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.CognitiveServicesByKey"  # type: ignore


class CommonGramTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.CommonGramTokenFilter"):
    """Construct bigrams for frequently occurring terms while indexing. Single terms are still indexed
    too, with bigrams overlaid. This token filter is implemented using Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar common_words: The set of common words. Required.
    :vartype common_words: list[str]
    :ivar ignore_case: A value indicating whether common words matching will be case insensitive.
     Default is false.
    :vartype ignore_case: bool
    :ivar use_query_mode: A value that indicates whether the token filter is in query mode. When in
     query mode, the token filter generates bigrams and then removes common words and single terms
     followed by a common word. Default is false.
    :vartype use_query_mode: bool
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.CommonGramTokenFilter".
    :vartype odata_type: str
    """

    common_words: list[str] = rest_field(name="commonWords", visibility=["read", "create", "update", "delete", "query"])
    """The set of common words. Required."""
    ignore_case: Optional[bool] = rest_field(
        name="ignoreCase", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether common words matching will be case insensitive. Default is false."""
    use_query_mode: Optional[bool] = rest_field(
        name="queryMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value that indicates whether the token filter is in query mode. When in query mode, the token
     filter generates bigrams and then removes common words and single terms followed by a common
     word. Default is false."""
    odata_type: Literal["#Microsoft.Azure.Search.CommonGramTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.CommonGramTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        common_words: list[str],
        ignore_case: Optional[bool] = None,
        use_query_mode: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.CommonGramTokenFilter"  # type: ignore


class ConditionalSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Util.ConditionalSkill"):
    """A skill that enables scenarios that require a Boolean operation to determine the data to assign
    to an output.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Util.ConditionalSkill".
    :vartype odata_type: str
    """

    odata_type: Literal["#Microsoft.Skills.Util.ConditionalSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Util.ConditionalSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Util.ConditionalSkill"  # type: ignore


class ContentUnderstandingSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Util.ContentUnderstandingSkill"):
    """A skill that leverages Azure AI Content Understanding to process and extract structured
    insights from documents, enabling enriched, searchable content for enhanced document indexing
    and retrieval.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar extraction_options: Controls the cardinality of the content extracted from the document
     by the skill.
    :vartype extraction_options: list[str or
     ~azure.search.documents.indexes.models.ContentUnderstandingSkillExtractionOptions]
    :ivar chunking_properties: Controls the cardinality for chunking the content.
    :vartype chunking_properties:
     ~azure.search.documents.indexes.models.ContentUnderstandingSkillChunkingProperties
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Util.ContentUnderstandingSkill".
    :vartype odata_type: str
    """

    extraction_options: Optional[list[Union[str, "_models.ContentUnderstandingSkillExtractionOptions"]]] = rest_field(
        name="extractionOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Controls the cardinality of the content extracted from the document by the skill."""
    chunking_properties: Optional["_models.ContentUnderstandingSkillChunkingProperties"] = rest_field(
        name="chunkingProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Controls the cardinality for chunking the content."""
    odata_type: Literal["#Microsoft.Skills.Util.ContentUnderstandingSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Util.ContentUnderstandingSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        extraction_options: Optional[list[Union[str, "_models.ContentUnderstandingSkillExtractionOptions"]]] = None,
        chunking_properties: Optional["_models.ContentUnderstandingSkillChunkingProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Util.ContentUnderstandingSkill"  # type: ignore


class ContentUnderstandingSkillChunkingProperties(_Model):  # pylint: disable=name-too-long
    """Controls the cardinality for chunking the content.

    :ivar unit: The unit of the chunk. "characters"
    :vartype unit: str or
     ~azure.search.documents.indexes.models.ContentUnderstandingSkillChunkingUnit
    :ivar maximum_length: The maximum chunk length in characters. Default is 500.
    :vartype maximum_length: int
    :ivar overlap_length: The length of overlap provided between two text chunks. Default is 0.
    :vartype overlap_length: int
    """

    unit: Optional[Union[str, "_models.ContentUnderstandingSkillChunkingUnit"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The unit of the chunk. \"characters\""""
    maximum_length: Optional[int] = rest_field(
        name="maximumLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum chunk length in characters. Default is 500."""
    overlap_length: Optional[int] = rest_field(
        name="overlapLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """The length of overlap provided between two text chunks. Default is 0."""

    @overload
    def __init__(
        self,
        *,
        unit: Optional[Union[str, "_models.ContentUnderstandingSkillChunkingUnit"]] = None,
        maximum_length: Optional[int] = None,
        overlap_length: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CorsOptions(_Model):
    """Defines options to control Cross-Origin Resource Sharing (CORS) for an index.

    :ivar allowed_origins: The list of origins from which JavaScript code will be granted access to
     your index. Can contain a list of hosts of the form
     {protocol}://{fully-qualified-domain-name}[:{port#}], or a single '*' to allow all origins (not
     recommended). Required.
    :vartype allowed_origins: list[str]
    :ivar max_age_in_seconds: The duration for which browsers should cache CORS preflight
     responses. Defaults to 5 minutes.
    :vartype max_age_in_seconds: int
    """

    allowed_origins: list[str] = rest_field(
        name="allowedOrigins", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of origins from which JavaScript code will be granted access to your index. Can
     contain a list of hosts of the form {protocol}://{fully-qualified-domain-name}[:{port#}], or a
     single '*' to allow all origins (not recommended). Required."""
    max_age_in_seconds: Optional[int] = rest_field(
        name="maxAgeInSeconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The duration for which browsers should cache CORS preflight responses. Defaults to 5 minutes."""

    @overload
    def __init__(
        self,
        *,
        allowed_origins: list[str],
        max_age_in_seconds: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CreatedResources(_Model):
    """Resources created by the knowledge source. Keys represent resource types (e.g., 'datasource',
    'indexer', 'skillset', 'index') and values represent resource names.

    """


class LexicalAnalyzer(_Model):
    """Base type for analyzers.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CustomAnalyzer, PatternAnalyzer, LuceneStandardAnalyzer, StopAnalyzer

    :ivar odata_type: The discriminator for derived types. Required. Default value is None.
    :vartype odata_type: str
    :ivar name: The name of the analyzer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    """

    __mapping__: dict[str, _Model] = {}
    odata_type: str = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])
    """The discriminator for derived types. Required. Default value is None."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the analyzer. It must only contain letters, digits, spaces, dashes or underscores,
     can only start and end with alphanumeric characters, and is limited to 128 characters.
     Required."""

    @overload
    def __init__(
        self,
        *,
        odata_type: str,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomAnalyzer(LexicalAnalyzer, discriminator="#Microsoft.Azure.Search.CustomAnalyzer"):
    """Allows you to take control over the process of converting text into indexable/searchable
    tokens. It's a user-defined configuration consisting of a single predefined tokenizer and one
    or more filters. The tokenizer is responsible for breaking text into tokens, and the filters
    for modifying tokens emitted by the tokenizer.

    :ivar name: The name of the analyzer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar tokenizer: The name of the tokenizer to use to divide continuous text into a sequence of
     tokens, such as breaking a sentence into words. Required. Known values are: "classic",
     "edgeNGram", "keyword_v2", "letter", "lowercase", "microsoft_language_tokenizer",
     "microsoft_language_stemming_tokenizer", "nGram", "path_hierarchy_v2", "pattern",
     "standard_v2", "uax_url_email", and "whitespace".
    :vartype tokenizer: str or ~azure.search.documents.indexes.models.LexicalTokenizerName
    :ivar token_filters: A list of token filters used to filter out or modify the tokens generated
     by a tokenizer. For example, you can specify a lowercase filter that converts all characters to
     lowercase. The filters are run in the order in which they are listed.
    :vartype token_filters: list[str or ~azure.search.documents.indexes.models.TokenFilterName]
    :ivar char_filters: A list of character filters used to prepare input text before it is
     processed by the tokenizer. For instance, they can replace certain characters or symbols. The
     filters are run in the order in which they are listed.
    :vartype char_filters: list[str or ~azure.search.documents.indexes.models.CharFilterName]
    :ivar odata_type: A URI fragment specifying the type of analyzer. Required. Default value is
     "#Microsoft.Azure.Search.CustomAnalyzer".
    :vartype odata_type: str
    """

    tokenizer: Union[str, "_models.LexicalTokenizerName"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the tokenizer to use to divide continuous text into a sequence of tokens, such as
     breaking a sentence into words. Required. Known values are: \"classic\", \"edgeNGram\",
     \"keyword_v2\", \"letter\", \"lowercase\", \"microsoft_language_tokenizer\",
     \"microsoft_language_stemming_tokenizer\", \"nGram\", \"path_hierarchy_v2\", \"pattern\",
     \"standard_v2\", \"uax_url_email\", and \"whitespace\"."""
    token_filters: Optional[list[Union[str, "_models.TokenFilterName"]]] = rest_field(
        name="tokenFilters", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of token filters used to filter out or modify the tokens generated by a tokenizer. For
     example, you can specify a lowercase filter that converts all characters to lowercase. The
     filters are run in the order in which they are listed."""
    char_filters: Optional[list[Union[str, "_models.CharFilterName"]]] = rest_field(
        name="charFilters", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of character filters used to prepare input text before it is processed by the tokenizer.
     For instance, they can replace certain characters or symbols. The filters are run in the order
     in which they are listed."""
    odata_type: Literal["#Microsoft.Azure.Search.CustomAnalyzer"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of analyzer. Required. Default value is
     \"#Microsoft.Azure.Search.CustomAnalyzer\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        tokenizer: Union[str, "_models.LexicalTokenizerName"],
        token_filters: Optional[list[Union[str, "_models.TokenFilterName"]]] = None,
        char_filters: Optional[list[Union[str, "_models.CharFilterName"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.CustomAnalyzer"  # type: ignore


class CustomEntity(_Model):
    """An object that contains information about the matches that were found, and related metadata.

    :ivar name: The top-level entity descriptor. Matches in the skill output will be grouped by
     this name, and it should represent the "normalized" form of the text being found. Required.
    :vartype name: str
    :ivar description: This field can be used as a passthrough for custom metadata about the
     matched text(s). The value of this field will appear with every match of its entity in the
     skill output.
    :vartype description: str
    :ivar type: This field can be used as a passthrough for custom metadata about the matched
     text(s). The value of this field will appear with every match of its entity in the skill
     output.
    :vartype type: str
    :ivar subtype: This field can be used as a passthrough for custom metadata about the matched
     text(s). The value of this field will appear with every match of its entity in the skill
     output.
    :vartype subtype: str
    :ivar id: This field can be used as a passthrough for custom metadata about the matched
     text(s). The value of this field will appear with every match of its entity in the skill
     output.
    :vartype id: str
    :ivar case_sensitive: Defaults to false. Boolean value denoting whether comparisons with the
     entity name should be sensitive to character casing. Sample case insensitive matches of
     "Microsoft" could be: microsoft, microSoft, MICROSOFT.
    :vartype case_sensitive: bool
    :ivar accent_sensitive: Defaults to false. Boolean value denoting whether comparisons with the
     entity name should be sensitive to accent.
    :vartype accent_sensitive: bool
    :ivar fuzzy_edit_distance: Defaults to 0. Maximum value of 5. Denotes the acceptable number of
     divergent characters that would still constitute a match with the entity name. The smallest
     possible fuzziness for any given match is returned. For instance, if the edit distance is set
     to 3, "Windows10" would still match "Windows", "Windows10" and "Windows 7". When case
     sensitivity is set to false, case differences do NOT count towards fuzziness tolerance, but
     otherwise do.
    :vartype fuzzy_edit_distance: int
    :ivar default_case_sensitive: Changes the default case sensitivity value for this entity. It be
     used to change the default value of all aliases caseSensitive values.
    :vartype default_case_sensitive: bool
    :ivar default_accent_sensitive: Changes the default accent sensitivity value for this entity.
     It be used to change the default value of all aliases accentSensitive values.
    :vartype default_accent_sensitive: bool
    :ivar default_fuzzy_edit_distance: Changes the default fuzzy edit distance value for this
     entity. It can be used to change the default value of all aliases fuzzyEditDistance values.
    :vartype default_fuzzy_edit_distance: int
    :ivar aliases: An array of complex objects that can be used to specify alternative spellings or
     synonyms to the root entity name.
    :vartype aliases: list[~azure.search.documents.indexes.models.CustomEntityAlias]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The top-level entity descriptor. Matches in the skill output will be grouped by this name, and
     it should represent the \"normalized\" form of the text being found. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """This field can be used as a passthrough for custom metadata about the matched text(s). The
     value of this field will appear with every match of its entity in the skill output."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """This field can be used as a passthrough for custom metadata about the matched text(s). The
     value of this field will appear with every match of its entity in the skill output."""
    subtype: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """This field can be used as a passthrough for custom metadata about the matched text(s). The
     value of this field will appear with every match of its entity in the skill output."""
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """This field can be used as a passthrough for custom metadata about the matched text(s). The
     value of this field will appear with every match of its entity in the skill output."""
    case_sensitive: Optional[bool] = rest_field(
        name="caseSensitive", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defaults to false. Boolean value denoting whether comparisons with the entity name should be
     sensitive to character casing. Sample case insensitive matches of \"Microsoft\" could be:
     microsoft, microSoft, MICROSOFT."""
    accent_sensitive: Optional[bool] = rest_field(
        name="accentSensitive", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defaults to false. Boolean value denoting whether comparisons with the entity name should be
     sensitive to accent."""
    fuzzy_edit_distance: Optional[int] = rest_field(
        name="fuzzyEditDistance", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defaults to 0. Maximum value of 5. Denotes the acceptable number of divergent characters that
     would still constitute a match with the entity name. The smallest possible fuzziness for any
     given match is returned. For instance, if the edit distance is set to 3, \"Windows10\" would
     still match \"Windows\", \"Windows10\" and \"Windows 7\". When case sensitivity is set to
     false, case differences do NOT count towards fuzziness tolerance, but otherwise do."""
    default_case_sensitive: Optional[bool] = rest_field(
        name="defaultCaseSensitive", visibility=["read", "create", "update", "delete", "query"]
    )
    """Changes the default case sensitivity value for this entity. It be used to change the default
     value of all aliases caseSensitive values."""
    default_accent_sensitive: Optional[bool] = rest_field(
        name="defaultAccentSensitive", visibility=["read", "create", "update", "delete", "query"]
    )
    """Changes the default accent sensitivity value for this entity. It be used to change the default
     value of all aliases accentSensitive values."""
    default_fuzzy_edit_distance: Optional[int] = rest_field(
        name="defaultFuzzyEditDistance", visibility=["read", "create", "update", "delete", "query"]
    )
    """Changes the default fuzzy edit distance value for this entity. It can be used to change the
     default value of all aliases fuzzyEditDistance values."""
    aliases: Optional[list["_models.CustomEntityAlias"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An array of complex objects that can be used to specify alternative spellings or synonyms to
     the root entity name."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        type: Optional[str] = None,
        subtype: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        case_sensitive: Optional[bool] = None,
        accent_sensitive: Optional[bool] = None,
        fuzzy_edit_distance: Optional[int] = None,
        default_case_sensitive: Optional[bool] = None,
        default_accent_sensitive: Optional[bool] = None,
        default_fuzzy_edit_distance: Optional[int] = None,
        aliases: Optional[list["_models.CustomEntityAlias"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomEntityAlias(_Model):
    """A complex object that can be used to specify alternative spellings or synonyms to the root
    entity name.

    :ivar text: The text of the alias. Required.
    :vartype text: str
    :ivar case_sensitive: Determine if the alias is case sensitive.
    :vartype case_sensitive: bool
    :ivar accent_sensitive: Determine if the alias is accent sensitive.
    :vartype accent_sensitive: bool
    :ivar fuzzy_edit_distance: Determine the fuzzy edit distance of the alias.
    :vartype fuzzy_edit_distance: int
    """

    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text of the alias. Required."""
    case_sensitive: Optional[bool] = rest_field(
        name="caseSensitive", visibility=["read", "create", "update", "delete", "query"]
    )
    """Determine if the alias is case sensitive."""
    accent_sensitive: Optional[bool] = rest_field(
        name="accentSensitive", visibility=["read", "create", "update", "delete", "query"]
    )
    """Determine if the alias is accent sensitive."""
    fuzzy_edit_distance: Optional[int] = rest_field(
        name="fuzzyEditDistance", visibility=["read", "create", "update", "delete", "query"]
    )
    """Determine the fuzzy edit distance of the alias."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        case_sensitive: Optional[bool] = None,
        accent_sensitive: Optional[bool] = None,
        fuzzy_edit_distance: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomEntityLookupSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Text.CustomEntityLookupSkill"):
    """A skill looks for text from a custom, user-defined list of words and phrases.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is ``en``.
     Known values are: "da", "de", "en", "es", "fi", "fr", "it", "ko", and "pt".
    :vartype default_language_code: str or
     ~azure.search.documents.indexes.models.CustomEntityLookupSkillLanguage
    :ivar entities_definition_uri: Path to a JSON or CSV file containing all the target text to
     match against. This entity definition is read at the beginning of an indexer run. Any updates
     to this file during an indexer run will not take effect until subsequent runs. This config must
     be accessible over HTTPS.
    :vartype entities_definition_uri: str
    :ivar inline_entities_definition: The inline CustomEntity definition.
    :vartype inline_entities_definition: list[~azure.search.documents.indexes.models.CustomEntity]
    :ivar global_default_case_sensitive: A global flag for CaseSensitive. If CaseSensitive is not
     set in CustomEntity, this value will be the default value.
    :vartype global_default_case_sensitive: bool
    :ivar global_default_accent_sensitive: A global flag for AccentSensitive. If AccentSensitive is
     not set in CustomEntity, this value will be the default value.
    :vartype global_default_accent_sensitive: bool
    :ivar global_default_fuzzy_edit_distance: A global flag for FuzzyEditDistance. If
     FuzzyEditDistance is not set in CustomEntity, this value will be the default value.
    :vartype global_default_fuzzy_edit_distance: int
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Text.CustomEntityLookupSkill".
    :vartype odata_type: str
    """

    default_language_code: Optional[Union[str, "_models.CustomEntityLookupSkillLanguage"]] = rest_field(
        name="defaultLanguageCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating which language code to use. Default is ``en``. Known values are: \"da\",
     \"de\", \"en\", \"es\", \"fi\", \"fr\", \"it\", \"ko\", and \"pt\"."""
    entities_definition_uri: Optional[str] = rest_field(
        name="entitiesDefinitionUri", visibility=["read", "create", "update", "delete", "query"]
    )
    """Path to a JSON or CSV file containing all the target text to match against. This entity
     definition is read at the beginning of an indexer run. Any updates to this file during an
     indexer run will not take effect until subsequent runs. This config must be accessible over
     HTTPS."""
    inline_entities_definition: Optional[list["_models.CustomEntity"]] = rest_field(
        name="inlineEntitiesDefinition", visibility=["read", "create", "update", "delete", "query"]
    )
    """The inline CustomEntity definition."""
    global_default_case_sensitive: Optional[bool] = rest_field(
        name="globalDefaultCaseSensitive", visibility=["read", "create", "update", "delete", "query"]
    )
    """A global flag for CaseSensitive. If CaseSensitive is not set in CustomEntity, this value will
     be the default value."""
    global_default_accent_sensitive: Optional[bool] = rest_field(
        name="globalDefaultAccentSensitive", visibility=["read", "create", "update", "delete", "query"]
    )
    """A global flag for AccentSensitive. If AccentSensitive is not set in CustomEntity, this value
     will be the default value."""
    global_default_fuzzy_edit_distance: Optional[int] = rest_field(
        name="globalDefaultFuzzyEditDistance", visibility=["read", "create", "update", "delete", "query"]
    )
    """A global flag for FuzzyEditDistance. If FuzzyEditDistance is not set in CustomEntity, this
     value will be the default value."""
    odata_type: Literal["#Microsoft.Skills.Text.CustomEntityLookupSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Text.CustomEntityLookupSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[Union[str, "_models.CustomEntityLookupSkillLanguage"]] = None,
        entities_definition_uri: Optional[str] = None,
        inline_entities_definition: Optional[list["_models.CustomEntity"]] = None,
        global_default_case_sensitive: Optional[bool] = None,
        global_default_accent_sensitive: Optional[bool] = None,
        global_default_fuzzy_edit_distance: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Text.CustomEntityLookupSkill"  # type: ignore


class LexicalNormalizer(_Model):
    """Base type for normalizers.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CustomNormalizer

    :ivar odata_type: The discriminator for derived types. Required. Default value is None.
    :vartype odata_type: str
    :ivar name: The name of the char filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    """

    __mapping__: dict[str, _Model] = {}
    odata_type: str = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])
    """The discriminator for derived types. Required. Default value is None."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the char filter. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required."""

    @overload
    def __init__(
        self,
        *,
        odata_type: str,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomNormalizer(LexicalNormalizer, discriminator="#Microsoft.Azure.Search.CustomNormalizer"):
    """Allows you to configure normalization for filterable, sortable, and facetable fields, which by
    default operate with strict matching. This is a user-defined configuration consisting of at
    least one or more filters, which modify the token that is stored.

    :ivar name: The name of the char filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar token_filters: A list of token filters used to filter out or modify the input token. For
     example, you can specify a lowercase filter that converts all characters to lowercase. The
     filters are run in the order in which they are listed.
    :vartype token_filters: list[str or ~azure.search.documents.indexes.models.TokenFilterName]
    :ivar char_filters: A list of character filters used to prepare input text before it is
     processed. For instance, they can replace certain characters or symbols. The filters are run in
     the order in which they are listed.
    :vartype char_filters: list[str or ~azure.search.documents.indexes.models.CharFilterName]
    :ivar odata_type: A URI fragment specifying the type of normalizer. Required. Default value is
     "#Microsoft.Azure.Search.CustomNormalizer".
    :vartype odata_type: str
    """

    token_filters: Optional[list[Union[str, "_models.TokenFilterName"]]] = rest_field(
        name="tokenFilters", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of token filters used to filter out or modify the input token. For example, you can
     specify a lowercase filter that converts all characters to lowercase. The filters are run in
     the order in which they are listed."""
    char_filters: Optional[list[Union[str, "_models.CharFilterName"]]] = rest_field(
        name="charFilters", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of character filters used to prepare input text before it is processed. For instance,
     they can replace certain characters or symbols. The filters are run in the order in which they
     are listed."""
    odata_type: Literal["#Microsoft.Azure.Search.CustomNormalizer"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of normalizer. Required. Default value is
     \"#Microsoft.Azure.Search.CustomNormalizer\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        token_filters: Optional[list[Union[str, "_models.TokenFilterName"]]] = None,
        char_filters: Optional[list[Union[str, "_models.CharFilterName"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.CustomNormalizer"  # type: ignore


class DataChangeDetectionPolicy(_Model):
    """Base type for data change detection policies.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HighWaterMarkChangeDetectionPolicy, SqlIntegratedChangeTrackingPolicy

    :ivar odata_type: The discriminator for derived types. Required. Default value is None.
    :vartype odata_type: str
    """

    __mapping__: dict[str, _Model] = {}
    odata_type: str = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])
    """The discriminator for derived types. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        odata_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataDeletionDetectionPolicy(_Model):
    """Base type for data deletion detection policies.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    NativeBlobSoftDeleteDeletionDetectionPolicy, SoftDeleteColumnDeletionDetectionPolicy

    :ivar odata_type: The discriminator for derived types. Required. Default value is None.
    :vartype odata_type: str
    """

    __mapping__: dict[str, _Model] = {}
    odata_type: str = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])
    """The discriminator for derived types. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        odata_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataSourceCredentials(_Model):
    """Represents credentials that can be used to connect to a datasource.

    :ivar connection_string: The connection string for the datasource. Set to ``<unchanged>`` (with
     brackets) if you don't want the connection string updated. Set to ``<redacted>`` if you want to
     remove the connection string value from the datasource.
    :vartype connection_string: str
    """

    connection_string: Optional[str] = rest_field(
        name="connectionString", visibility=["read", "create", "update", "delete", "query"]
    )
    """The connection string for the datasource. Set to ``<unchanged>`` (with brackets) if you don't
     want the connection string updated. Set to ``<redacted>`` if you want to remove the connection
     string value from the datasource."""

    @overload
    def __init__(
        self,
        *,
        connection_string: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DefaultCognitiveServicesAccount(
    CognitiveServicesAccount, discriminator="#Microsoft.Azure.Search.DefaultCognitiveServices"
):
    """An empty object that represents the default Azure AI service resource for a skillset.

    :ivar description: Description of the Azure AI service resource attached to a skillset.
    :vartype description: str
    :ivar odata_type: A URI fragment specifying the type of Azure AI service resource attached to a
     skillset. Required. Default value is "#Microsoft.Azure.Search.DefaultCognitiveServices".
    :vartype odata_type: str
    """

    odata_type: Literal["#Microsoft.Azure.Search.DefaultCognitiveServices"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of Azure AI service resource attached to a skillset.
     Required. Default value is \"#Microsoft.Azure.Search.DefaultCognitiveServices\"."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.DefaultCognitiveServices"  # type: ignore


class DictionaryDecompounderTokenFilter(
    TokenFilter, discriminator="#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter"
):
    """Decomposes compound words found in many Germanic languages. This token filter is implemented
    using Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar word_list: The list of words to match against. Required.
    :vartype word_list: list[str]
    :ivar min_word_size: The minimum word size. Only words longer than this get processed. Default
     is 5. Maximum is 300.
    :vartype min_word_size: int
    :ivar min_subword_size: The minimum subword size. Only subwords longer than this are outputted.
     Default is 2. Maximum is 300.
    :vartype min_subword_size: int
    :ivar max_subword_size: The maximum subword size. Only subwords shorter than this are
     outputted. Default is 15. Maximum is 300.
    :vartype max_subword_size: int
    :ivar only_longest_match: A value indicating whether to add only the longest matching subword
     to the output. Default is false.
    :vartype only_longest_match: bool
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter".
    :vartype odata_type: str
    """

    word_list: list[str] = rest_field(name="wordList", visibility=["read", "create", "update", "delete", "query"])
    """The list of words to match against. Required."""
    min_word_size: Optional[int] = rest_field(
        name="minWordSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """The minimum word size. Only words longer than this get processed. Default is 5. Maximum is 300."""
    min_subword_size: Optional[int] = rest_field(
        name="minSubwordSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """The minimum subword size. Only subwords longer than this are outputted. Default is 2. Maximum
     is 300."""
    max_subword_size: Optional[int] = rest_field(
        name="maxSubwordSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum subword size. Only subwords shorter than this are outputted. Default is 15. Maximum
     is 300."""
    only_longest_match: Optional[bool] = rest_field(
        name="onlyLongestMatch", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to add only the longest matching subword to the output. Default is
     false."""
    odata_type: Literal["#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        word_list: list[str],
        min_word_size: Optional[int] = None,
        min_subword_size: Optional[int] = None,
        max_subword_size: Optional[int] = None,
        only_longest_match: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter"  # type: ignore


class ScoringFunction(_Model):
    """Base type for functions that can modify document scores during ranking.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DistanceScoringFunction, FreshnessScoringFunction, MagnitudeScoringFunction, TagScoringFunction

    :ivar field_name: The name of the field used as input to the scoring function. Required.
    :vartype field_name: str
    :ivar boost: A multiplier for the raw score. Must be a positive number not equal to 1.0.
     Required.
    :vartype boost: float
    :ivar interpolation: A value indicating how boosting will be interpolated across document
     scores; defaults to "Linear". Known values are: "linear", "constant", "quadratic", and
     "logarithmic".
    :vartype interpolation: str or
     ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
    :ivar type: Type of ScoringFunction. Required. Default value is None.
    :vartype type: str
    """

    __mapping__: dict[str, _Model] = {}
    field_name: str = rest_field(name="fieldName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the field used as input to the scoring function. Required."""
    boost: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A multiplier for the raw score. Must be a positive number not equal to 1.0. Required."""
    interpolation: Optional[Union[str, "_models.ScoringFunctionInterpolation"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating how boosting will be interpolated across document scores; defaults to
     \"Linear\". Known values are: \"linear\", \"constant\", \"quadratic\", and \"logarithmic\"."""
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Type of ScoringFunction. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        field_name: str,
        boost: float,
        type: str,
        interpolation: Optional[Union[str, "_models.ScoringFunctionInterpolation"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DistanceScoringFunction(ScoringFunction, discriminator="distance"):
    """Defines a function that boosts scores based on distance from a geographic location.

    :ivar field_name: The name of the field used as input to the scoring function. Required.
    :vartype field_name: str
    :ivar boost: A multiplier for the raw score. Must be a positive number not equal to 1.0.
     Required.
    :vartype boost: float
    :ivar interpolation: A value indicating how boosting will be interpolated across document
     scores; defaults to "Linear". Known values are: "linear", "constant", "quadratic", and
     "logarithmic".
    :vartype interpolation: str or
     ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
    :ivar parameters: Parameter values for the distance scoring function. Required.
    :vartype parameters: ~azure.search.documents.indexes.models.DistanceScoringParameters
    :ivar type: Indicates the type of function to use. Valid values include magnitude, freshness,
     distance, and tag. The function type must be lower case. Required. Default value is "distance".
    :vartype type: str
    """

    parameters: "_models.DistanceScoringParameters" = rest_field(
        name="distance", visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameter values for the distance scoring function. Required."""
    type: Literal["distance"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Indicates the type of function to use. Valid values include magnitude, freshness, distance, and
     tag. The function type must be lower case. Required. Default value is \"distance\"."""

    @overload
    def __init__(
        self,
        *,
        field_name: str,
        boost: float,
        parameters: "_models.DistanceScoringParameters",
        interpolation: Optional[Union[str, "_models.ScoringFunctionInterpolation"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = "distance"  # type: ignore


class DistanceScoringParameters(_Model):
    """Provides parameter values to a distance scoring function.

    :ivar reference_point_parameter: The name of the parameter passed in search queries to specify
     the reference location. Required.
    :vartype reference_point_parameter: str
    :ivar boosting_distance: The distance in kilometers from the reference location where the
     boosting range ends. Required.
    :vartype boosting_distance: float
    """

    reference_point_parameter: str = rest_field(
        name="referencePointParameter", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the parameter passed in search queries to specify the reference location. Required."""
    boosting_distance: float = rest_field(
        name="boostingDistance", visibility=["read", "create", "update", "delete", "query"]
    )
    """The distance in kilometers from the reference location where the boosting range ends. Required."""

    @overload
    def __init__(
        self,
        *,
        reference_point_parameter: str,
        boosting_distance: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentExtractionSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Util.DocumentExtractionSkill"):
    """A skill that extracts content from a file within the enrichment pipeline.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar parsing_mode: The parsingMode for the skill. Will be set to 'default' if not defined.
    :vartype parsing_mode: str
    :ivar data_to_extract: The type of data to be extracted for the skill. Will be set to
     'contentAndMetadata' if not defined.
    :vartype data_to_extract: str
    :ivar configuration: A dictionary of configurations for the skill.
    :vartype configuration: dict[str, any]
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Util.DocumentExtractionSkill".
    :vartype odata_type: str
    """

    parsing_mode: Optional[str] = rest_field(
        name="parsingMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The parsingMode for the skill. Will be set to 'default' if not defined."""
    data_to_extract: Optional[str] = rest_field(
        name="dataToExtract", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of data to be extracted for the skill. Will be set to 'contentAndMetadata' if not
     defined."""
    configuration: Optional[dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A dictionary of configurations for the skill."""
    odata_type: Literal["#Microsoft.Skills.Util.DocumentExtractionSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Util.DocumentExtractionSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        parsing_mode: Optional[str] = None,
        data_to_extract: Optional[str] = None,
        configuration: Optional[dict[str, Any]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Util.DocumentExtractionSkill"  # type: ignore


class DocumentIntelligenceLayoutSkill(
    SearchIndexerSkill, discriminator="#Microsoft.Skills.Util.DocumentIntelligenceLayoutSkill"
):
    """A skill that extracts content and layout information, via Azure AI Services, from files within
    the enrichment pipeline.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar output_format: Controls the output format. Default is 'markdown'. Known values are:
     "text" and "markdown".
    :vartype output_format: str or
     ~azure.search.documents.indexes.models.DocumentIntelligenceLayoutSkillOutputFormat
    :ivar output_mode: Controls the cardinality of the output produced by the skill. Default is
     'oneToMany'. "oneToMany"
    :vartype output_mode: str or
     ~azure.search.documents.indexes.models.DocumentIntelligenceLayoutSkillOutputMode
    :ivar markdown_header_depth: The depth of headers in the markdown output. Default is h6. Known
     values are: "h1", "h2", "h3", "h4", "h5", and "h6".
    :vartype markdown_header_depth: str or
     ~azure.search.documents.indexes.models.DocumentIntelligenceLayoutSkillMarkdownHeaderDepth
    :ivar extraction_options: Controls the cardinality of the content extracted from the document
     by the skill.
    :vartype extraction_options: list[str or
     ~azure.search.documents.indexes.models.DocumentIntelligenceLayoutSkillExtractionOptions]
    :ivar chunking_properties: Controls the cardinality for chunking the content.
    :vartype chunking_properties:
     ~azure.search.documents.indexes.models.DocumentIntelligenceLayoutSkillChunkingProperties
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Util.DocumentIntelligenceLayoutSkill".
    :vartype odata_type: str
    """

    output_format: Optional[Union[str, "_models.DocumentIntelligenceLayoutSkillOutputFormat"]] = rest_field(
        name="outputFormat", visibility=["read", "create", "update", "delete", "query"]
    )
    """Controls the output format. Default is 'markdown'. Known values are: \"text\" and \"markdown\"."""
    output_mode: Optional[Union[str, "_models.DocumentIntelligenceLayoutSkillOutputMode"]] = rest_field(
        name="outputMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Controls the cardinality of the output produced by the skill. Default is 'oneToMany'.
     \"oneToMany\""""
    markdown_header_depth: Optional[Union[str, "_models.DocumentIntelligenceLayoutSkillMarkdownHeaderDepth"]] = (
        rest_field(name="markdownHeaderDepth", visibility=["read", "create", "update", "delete", "query"])
    )
    """The depth of headers in the markdown output. Default is h6. Known values are: \"h1\", \"h2\",
     \"h3\", \"h4\", \"h5\", and \"h6\"."""
    extraction_options: Optional[list[Union[str, "_models.DocumentIntelligenceLayoutSkillExtractionOptions"]]] = (
        rest_field(name="extractionOptions", visibility=["read", "create", "update", "delete", "query"])
    )
    """Controls the cardinality of the content extracted from the document by the skill."""
    chunking_properties: Optional["_models.DocumentIntelligenceLayoutSkillChunkingProperties"] = rest_field(
        name="chunkingProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Controls the cardinality for chunking the content."""
    odata_type: Literal["#Microsoft.Skills.Util.DocumentIntelligenceLayoutSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Util.DocumentIntelligenceLayoutSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        output_format: Optional[Union[str, "_models.DocumentIntelligenceLayoutSkillOutputFormat"]] = None,
        output_mode: Optional[Union[str, "_models.DocumentIntelligenceLayoutSkillOutputMode"]] = None,
        markdown_header_depth: Optional[
            Union[str, "_models.DocumentIntelligenceLayoutSkillMarkdownHeaderDepth"]
        ] = None,
        extraction_options: Optional[
            list[Union[str, "_models.DocumentIntelligenceLayoutSkillExtractionOptions"]]
        ] = None,
        chunking_properties: Optional["_models.DocumentIntelligenceLayoutSkillChunkingProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Util.DocumentIntelligenceLayoutSkill"  # type: ignore


class DocumentIntelligenceLayoutSkillChunkingProperties(_Model):  # pylint: disable=name-too-long
    """Controls the cardinality for chunking the content.

    :ivar unit: The unit of the chunk. "characters"
    :vartype unit: str or
     ~azure.search.documents.indexes.models.DocumentIntelligenceLayoutSkillChunkingUnit
    :ivar maximum_length: The maximum chunk length in characters. Default is 500.
    :vartype maximum_length: int
    :ivar overlap_length: The length of overlap provided between two text chunks. Default is 0.
    :vartype overlap_length: int
    """

    unit: Optional[Union[str, "_models.DocumentIntelligenceLayoutSkillChunkingUnit"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The unit of the chunk. \"characters\""""
    maximum_length: Optional[int] = rest_field(
        name="maximumLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum chunk length in characters. Default is 500."""
    overlap_length: Optional[int] = rest_field(
        name="overlapLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """The length of overlap provided between two text chunks. Default is 0."""

    @overload
    def __init__(
        self,
        *,
        unit: Optional[Union[str, "_models.DocumentIntelligenceLayoutSkillChunkingUnit"]] = None,
        maximum_length: Optional[int] = None,
        overlap_length: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentKeysOrIds(_Model):
    """The type of the keysOrIds.

    :ivar document_keys: document keys to be reset.
    :vartype document_keys: list[str]
    :ivar datasource_document_ids: datasource document identifiers to be reset.
    :vartype datasource_document_ids: list[str]
    """

    document_keys: Optional[list[str]] = rest_field(
        name="documentKeys", visibility=["read", "create", "update", "delete", "query"]
    )
    """document keys to be reset."""
    datasource_document_ids: Optional[list[str]] = rest_field(
        name="datasourceDocumentIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """datasource document identifiers to be reset."""

    @overload
    def __init__(
        self,
        *,
        document_keys: Optional[list[str]] = None,
        datasource_document_ids: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EdgeNGramTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.EdgeNGramTokenFilter"):
    """Generates n-grams of the given size(s) starting from the front or the back of an input token.
    This token filter is implemented using Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar min_gram: The minimum n-gram length. Default is 1. Must be less than the value of
     maxGram.
    :vartype min_gram: int
    :ivar max_gram: The maximum n-gram length. Default is 2.
    :vartype max_gram: int
    :ivar side: Specifies which side of the input the n-gram should be generated from. Default is
     "front". Known values are: "front" and "back".
    :vartype side: str or ~azure.search.documents.indexes.models.EdgeNGramTokenFilterSide
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.EdgeNGramTokenFilter".
    :vartype odata_type: str
    """

    min_gram: Optional[int] = rest_field(name="minGram", visibility=["read", "create", "update", "delete", "query"])
    """The minimum n-gram length. Default is 1. Must be less than the value of maxGram."""
    max_gram: Optional[int] = rest_field(name="maxGram", visibility=["read", "create", "update", "delete", "query"])
    """The maximum n-gram length. Default is 2."""
    side: Optional[Union[str, "_models.EdgeNGramTokenFilterSide"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies which side of the input the n-gram should be generated from. Default is \"front\".
     Known values are: \"front\" and \"back\"."""
    odata_type: Literal["#Microsoft.Azure.Search.EdgeNGramTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.EdgeNGramTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        min_gram: Optional[int] = None,
        max_gram: Optional[int] = None,
        side: Optional[Union[str, "_models.EdgeNGramTokenFilterSide"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.EdgeNGramTokenFilter"  # type: ignore


class EdgeNGramTokenFilterV2(TokenFilter, discriminator="#Microsoft.Azure.Search.EdgeNGramTokenFilterV2"):
    """Generates n-grams of the given size(s) starting from the front or the back of an input token.
    This token filter is implemented using Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar min_gram: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the
     value of maxGram.
    :vartype min_gram: int
    :ivar max_gram: The maximum n-gram length. Default is 2. Maximum is 300.
    :vartype max_gram: int
    :ivar side: Specifies which side of the input the n-gram should be generated from. Default is
     "front". Known values are: "front" and "back".
    :vartype side: str or ~azure.search.documents.indexes.models.EdgeNGramTokenFilterSide
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.EdgeNGramTokenFilterV2".
    :vartype odata_type: str
    """

    min_gram: Optional[int] = rest_field(name="minGram", visibility=["read", "create", "update", "delete", "query"])
    """The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the value of
     maxGram."""
    max_gram: Optional[int] = rest_field(name="maxGram", visibility=["read", "create", "update", "delete", "query"])
    """The maximum n-gram length. Default is 2. Maximum is 300."""
    side: Optional[Union[str, "_models.EdgeNGramTokenFilterSide"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies which side of the input the n-gram should be generated from. Default is \"front\".
     Known values are: \"front\" and \"back\"."""
    odata_type: Literal["#Microsoft.Azure.Search.EdgeNGramTokenFilterV2"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.EdgeNGramTokenFilterV2\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        min_gram: Optional[int] = None,
        max_gram: Optional[int] = None,
        side: Optional[Union[str, "_models.EdgeNGramTokenFilterSide"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.EdgeNGramTokenFilterV2"  # type: ignore


class EdgeNGramTokenizer(LexicalTokenizer, discriminator="#Microsoft.Azure.Search.EdgeNGramTokenizer"):
    """Tokenizes the input from an edge into n-grams of the given size(s). This tokenizer is
    implemented using Apache Lucene.

    :ivar name: The name of the tokenizer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar min_gram: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the
     value of maxGram.
    :vartype min_gram: int
    :ivar max_gram: The maximum n-gram length. Default is 2. Maximum is 300.
    :vartype max_gram: int
    :ivar token_chars: Character classes to keep in the tokens.
    :vartype token_chars: list[str or ~azure.search.documents.indexes.models.TokenCharacterKind]
    :ivar odata_type: A URI fragment specifying the type of tokenizer. Required. Default value is
     "#Microsoft.Azure.Search.EdgeNGramTokenizer".
    :vartype odata_type: str
    """

    min_gram: Optional[int] = rest_field(name="minGram", visibility=["read", "create", "update", "delete", "query"])
    """The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the value of
     maxGram."""
    max_gram: Optional[int] = rest_field(name="maxGram", visibility=["read", "create", "update", "delete", "query"])
    """The maximum n-gram length. Default is 2. Maximum is 300."""
    token_chars: Optional[list[Union[str, "_models.TokenCharacterKind"]]] = rest_field(
        name="tokenChars", visibility=["read", "create", "update", "delete", "query"]
    )
    """Character classes to keep in the tokens."""
    odata_type: Literal["#Microsoft.Azure.Search.EdgeNGramTokenizer"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of tokenizer. Required. Default value is
     \"#Microsoft.Azure.Search.EdgeNGramTokenizer\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        min_gram: Optional[int] = None,
        max_gram: Optional[int] = None,
        token_chars: Optional[list[Union[str, "_models.TokenCharacterKind"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.EdgeNGramTokenizer"  # type: ignore


class ElisionTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.ElisionTokenFilter"):
    """Removes elisions. For example, "l'avion" (the plane) will be converted to "avion" (plane). This
    token filter is implemented using Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar articles: The set of articles to remove.
    :vartype articles: list[str]
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.ElisionTokenFilter".
    :vartype odata_type: str
    """

    articles: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The set of articles to remove."""
    odata_type: Literal["#Microsoft.Azure.Search.ElisionTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.ElisionTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        articles: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.ElisionTokenFilter"  # type: ignore


class EntityLinkingSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Text.V3.EntityLinkingSkill"):
    """Using the Text Analytics API, extracts linked entities from text.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is ``en``.
    :vartype default_language_code: str
    :ivar minimum_precision: A value between 0 and 1 that be used to only include entities whose
     confidence score is greater than the value specified. If not set (default), or if explicitly
     set to null, all entities will be included.
    :vartype minimum_precision: float
    :ivar model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :vartype model_version: str
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Text.V3.EntityLinkingSkill".
    :vartype odata_type: str
    """

    default_language_code: Optional[str] = rest_field(
        name="defaultLanguageCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating which language code to use. Default is ``en``."""
    minimum_precision: Optional[float] = rest_field(
        name="minimumPrecision", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value between 0 and 1 that be used to only include entities whose confidence score is greater
     than the value specified. If not set (default), or if explicitly set to null, all entities will
     be included."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The version of the model to use when calling the Text Analytics service. It will default to the
     latest available when not specified. We recommend you do not specify this value unless
     absolutely necessary."""
    odata_type: Literal["#Microsoft.Skills.Text.V3.EntityLinkingSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Text.V3.EntityLinkingSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[str] = None,
        minimum_precision: Optional[float] = None,
        model_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Text.V3.EntityLinkingSkill"  # type: ignore


class EntityRecognitionSkillV3(SearchIndexerSkill, discriminator="#Microsoft.Skills.Text.V3.EntityRecognitionSkill"):
    """Using the Text Analytics API, extracts entities of different types from text.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar categories: A list of entity categories that should be extracted.
    :vartype categories: list[str]
    :ivar default_language_code: A value indicating which language code to use. Default is ``en``.
    :vartype default_language_code: str
    :ivar minimum_precision: A value between 0 and 1 that be used to only include entities whose
     confidence score is greater than the value specified. If not set (default), or if explicitly
     set to null, all entities will be included.
    :vartype minimum_precision: float
    :ivar model_version: The version of the model to use when calling the Text Analytics API. It
     will default to the latest available when not specified. We recommend you do not specify this
     value unless absolutely necessary.
    :vartype model_version: str
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Text.V3.EntityRecognitionSkill".
    :vartype odata_type: str
    """

    categories: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of entity categories that should be extracted."""
    default_language_code: Optional[str] = rest_field(
        name="defaultLanguageCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating which language code to use. Default is ``en``."""
    minimum_precision: Optional[float] = rest_field(
        name="minimumPrecision", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value between 0 and 1 that be used to only include entities whose confidence score is greater
     than the value specified. If not set (default), or if explicitly set to null, all entities will
     be included."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The version of the model to use when calling the Text Analytics API. It will default to the
     latest available when not specified. We recommend you do not specify this value unless
     absolutely necessary."""
    odata_type: Literal["#Microsoft.Skills.Text.V3.EntityRecognitionSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Text.V3.EntityRecognitionSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        categories: Optional[list[str]] = None,
        default_language_code: Optional[str] = None,
        minimum_precision: Optional[float] = None,
        model_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Text.V3.EntityRecognitionSkill"  # type: ignore


class VectorSearchAlgorithmConfiguration(_Model):
    """Contains configuration options specific to the algorithm used during indexing or querying.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ExhaustiveKnnAlgorithmConfiguration, HnswAlgorithmConfiguration

    :ivar name: The name to associate with this particular configuration. Required.
    :vartype name: str
    :ivar kind: Type of VectorSearchAlgorithmConfiguration. Required. Known values are: "hnsw" and
     "exhaustiveKnn".
    :vartype kind: str or ~azure.search.documents.indexes.models.VectorSearchAlgorithmKind
    """

    __mapping__: dict[str, _Model] = {}
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name to associate with this particular configuration. Required."""
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """Type of VectorSearchAlgorithmConfiguration. Required. Known values are: \"hnsw\" and
     \"exhaustiveKnn\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExhaustiveKnnAlgorithmConfiguration(VectorSearchAlgorithmConfiguration, discriminator="exhaustiveKnn"):
    """Contains configuration options specific to the exhaustive KNN algorithm used during querying,
    which will perform brute-force search across the entire vector index.

    :ivar name: The name to associate with this particular configuration. Required.
    :vartype name: str
    :ivar parameters: Contains the parameters specific to exhaustive KNN algorithm.
    :vartype parameters: ~azure.search.documents.indexes.models.ExhaustiveKnnParameters
    :ivar kind: The name of the kind of algorithm being configured for use with vector search.
     Required. Exhaustive KNN algorithm which will perform brute-force search.
    :vartype kind: str or ~azure.search.documents.indexes.models.EXHAUSTIVE_KNN
    """

    parameters: Optional["_models.ExhaustiveKnnParameters"] = rest_field(
        name="exhaustiveKnnParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the parameters specific to exhaustive KNN algorithm."""
    kind: Literal[VectorSearchAlgorithmKind.EXHAUSTIVE_KNN] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The name of the kind of algorithm being configured for use with vector search. Required.
     Exhaustive KNN algorithm which will perform brute-force search."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        parameters: Optional["_models.ExhaustiveKnnParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = VectorSearchAlgorithmKind.EXHAUSTIVE_KNN  # type: ignore


class ExhaustiveKnnParameters(_Model):
    """Contains the parameters specific to exhaustive KNN algorithm.

    :ivar metric: The similarity metric to use for vector comparisons. Known values are: "cosine",
     "euclidean", "dotProduct", and "hamming".
    :vartype metric: str or ~azure.search.documents.indexes.models.VectorSearchAlgorithmMetric
    """

    metric: Optional[Union[str, "_models.VectorSearchAlgorithmMetric"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The similarity metric to use for vector comparisons. Known values are: \"cosine\",
     \"euclidean\", \"dotProduct\", and \"hamming\"."""

    @overload
    def __init__(
        self,
        *,
        metric: Optional[Union[str, "_models.VectorSearchAlgorithmMetric"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FieldMapping(_Model):
    """Defines a mapping between a field in a data source and a target field in an index.

    :ivar source_field_name: The name of the field in the data source. Required.
    :vartype source_field_name: str
    :ivar target_field_name: The name of the target field in the index. Same as the source field
     name by default.
    :vartype target_field_name: str
    :ivar mapping_function: A function to apply to each source field value before indexing.
    :vartype mapping_function: ~azure.search.documents.indexes.models.FieldMappingFunction
    """

    source_field_name: str = rest_field(
        name="sourceFieldName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the field in the data source. Required."""
    target_field_name: Optional[str] = rest_field(
        name="targetFieldName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the target field in the index. Same as the source field name by default."""
    mapping_function: Optional["_models.FieldMappingFunction"] = rest_field(
        name="mappingFunction", visibility=["read", "create", "update", "delete", "query"]
    )
    """A function to apply to each source field value before indexing."""

    @overload
    def __init__(
        self,
        *,
        source_field_name: str,
        target_field_name: Optional[str] = None,
        mapping_function: Optional["_models.FieldMappingFunction"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FieldMappingFunction(_Model):
    """Represents a function that transforms a value from a data source before indexing.

    :ivar name: The name of the field mapping function. Required.
    :vartype name: str
    :ivar parameters: A dictionary of parameter name/value pairs to pass to the function. Each
     value must be of a primitive type.
    :vartype parameters: dict[str, any]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the field mapping function. Required."""
    parameters: Optional[dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A dictionary of parameter name/value pairs to pass to the function. Each value must be of a
     primitive type."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        parameters: Optional[dict[str, Any]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FreshnessScoringFunction(ScoringFunction, discriminator="freshness"):
    """Defines a function that boosts scores based on the value of a date-time field.

    :ivar field_name: The name of the field used as input to the scoring function. Required.
    :vartype field_name: str
    :ivar boost: A multiplier for the raw score. Must be a positive number not equal to 1.0.
     Required.
    :vartype boost: float
    :ivar interpolation: A value indicating how boosting will be interpolated across document
     scores; defaults to "Linear". Known values are: "linear", "constant", "quadratic", and
     "logarithmic".
    :vartype interpolation: str or
     ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
    :ivar parameters: Parameter values for the freshness scoring function. Required.
    :vartype parameters: ~azure.search.documents.indexes.models.FreshnessScoringParameters
    :ivar type: Indicates the type of function to use. Valid values include magnitude, freshness,
     distance, and tag. The function type must be lower case. Required. Default value is
     "freshness".
    :vartype type: str
    """

    parameters: "_models.FreshnessScoringParameters" = rest_field(
        name="freshness", visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameter values for the freshness scoring function. Required."""
    type: Literal["freshness"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Indicates the type of function to use. Valid values include magnitude, freshness, distance, and
     tag. The function type must be lower case. Required. Default value is \"freshness\"."""

    @overload
    def __init__(
        self,
        *,
        field_name: str,
        boost: float,
        parameters: "_models.FreshnessScoringParameters",
        interpolation: Optional[Union[str, "_models.ScoringFunctionInterpolation"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = "freshness"  # type: ignore


class FreshnessScoringParameters(_Model):
    """Provides parameter values to a freshness scoring function.

    :ivar boosting_duration: The expiration period after which boosting will stop for a particular
     document. Required.
    :vartype boosting_duration: ~datetime.timedelta
    """

    boosting_duration: datetime.timedelta = rest_field(
        name="boostingDuration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The expiration period after which boosting will stop for a particular document. Required."""

    @overload
    def __init__(
        self,
        *,
        boosting_duration: datetime.timedelta,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GetIndexStatisticsResult(_Model):
    """Statistics for a given index. Statistics are collected periodically and are not guaranteed to
    always be up-to-date.

    :ivar document_count: The number of documents in the index. Required.
    :vartype document_count: int
    :ivar storage_size: The amount of storage in bytes consumed by the index. Required.
    :vartype storage_size: int
    :ivar vector_index_size: The amount of memory in bytes consumed by vectors in the index.
     Required.
    :vartype vector_index_size: int
    """

    document_count: int = rest_field(name="documentCount", visibility=["read"])
    """The number of documents in the index. Required."""
    storage_size: int = rest_field(name="storageSize", visibility=["read"])
    """The amount of storage in bytes consumed by the index. Required."""
    vector_index_size: int = rest_field(name="vectorIndexSize", visibility=["read"])
    """The amount of memory in bytes consumed by vectors in the index. Required."""


class HighWaterMarkChangeDetectionPolicy(
    DataChangeDetectionPolicy, discriminator="#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy"
):
    """Defines a data change detection policy that captures changes based on the value of a high water
    mark column.

    :ivar high_water_mark_column_name: The name of the high water mark column. Required.
    :vartype high_water_mark_column_name: str
    :ivar odata_type: A URI fragment specifying the type of data change detection policy. Required.
     Default value is "#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy".
    :vartype odata_type: str
    """

    high_water_mark_column_name: str = rest_field(
        name="highWaterMarkColumnName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the high water mark column. Required."""
    odata_type: Literal["#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of data change detection policy. Required. Default value is
     \"#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy\"."""

    @overload
    def __init__(
        self,
        *,
        high_water_mark_column_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy"  # type: ignore


class HnswAlgorithmConfiguration(VectorSearchAlgorithmConfiguration, discriminator="hnsw"):
    """Contains configuration options specific to the HNSW approximate nearest neighbors algorithm
    used during indexing and querying. The HNSW algorithm offers a tunable trade-off between search
    speed and accuracy.

    :ivar name: The name to associate with this particular configuration. Required.
    :vartype name: str
    :ivar parameters: Contains the parameters specific to HNSW algorithm.
    :vartype parameters: ~azure.search.documents.indexes.models.HnswParameters
    :ivar kind: The name of the kind of algorithm being configured for use with vector search.
     Required. HNSW (Hierarchical Navigable Small World), a type of approximate nearest neighbors
     algorithm.
    :vartype kind: str or ~azure.search.documents.indexes.models.HNSW
    """

    parameters: Optional["_models.HnswParameters"] = rest_field(
        name="hnswParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the parameters specific to HNSW algorithm."""
    kind: Literal[VectorSearchAlgorithmKind.HNSW] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The name of the kind of algorithm being configured for use with vector search. Required. HNSW
     (Hierarchical Navigable Small World), a type of approximate nearest neighbors algorithm."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        parameters: Optional["_models.HnswParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = VectorSearchAlgorithmKind.HNSW  # type: ignore


class HnswParameters(_Model):
    """Contains the parameters specific to the HNSW algorithm.

    :ivar m: The number of bi-directional links created for every new element during construction.
     Increasing this parameter value may improve recall and reduce retrieval times for datasets with
     high intrinsic dimensionality at the expense of increased memory consumption and longer
     indexing time.
    :vartype m: int
    :ivar ef_construction: The size of the dynamic list containing the nearest neighbors, which is
     used during index time. Increasing this parameter may improve index quality, at the expense of
     increased indexing time. At a certain point, increasing this parameter leads to diminishing
     returns.
    :vartype ef_construction: int
    :ivar ef_search: The size of the dynamic list containing the nearest neighbors, which is used
     during search time. Increasing this parameter may improve search results, at the expense of
     slower search. At a certain point, increasing this parameter leads to diminishing returns.
    :vartype ef_search: int
    :ivar metric: The similarity metric to use for vector comparisons. Known values are: "cosine",
     "euclidean", "dotProduct", and "hamming".
    :vartype metric: str or ~azure.search.documents.indexes.models.VectorSearchAlgorithmMetric
    """

    m: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of bi-directional links created for every new element during construction.
     Increasing this parameter value may improve recall and reduce retrieval times for datasets with
     high intrinsic dimensionality at the expense of increased memory consumption and longer
     indexing time."""
    ef_construction: Optional[int] = rest_field(
        name="efConstruction", visibility=["read", "create", "update", "delete", "query"]
    )
    """The size of the dynamic list containing the nearest neighbors, which is used during index time.
     Increasing this parameter may improve index quality, at the expense of increased indexing time.
     At a certain point, increasing this parameter leads to diminishing returns."""
    ef_search: Optional[int] = rest_field(name="efSearch", visibility=["read", "create", "update", "delete", "query"])
    """The size of the dynamic list containing the nearest neighbors, which is used during search
     time. Increasing this parameter may improve search results, at the expense of slower search. At
     a certain point, increasing this parameter leads to diminishing returns."""
    metric: Optional[Union[str, "_models.VectorSearchAlgorithmMetric"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The similarity metric to use for vector comparisons. Known values are: \"cosine\",
     \"euclidean\", \"dotProduct\", and \"hamming\"."""

    @overload
    def __init__(
        self,
        *,
        m: Optional[int] = None,
        ef_construction: Optional[int] = None,
        ef_search: Optional[int] = None,
        metric: Optional[Union[str, "_models.VectorSearchAlgorithmMetric"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImageAnalysisSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Vision.ImageAnalysisSkill"):
    """A skill that analyzes image files. It extracts a rich set of visual features based on the image
    content.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is ``en``.
     Known values are: "ar", "az", "bg", "bs", "ca", "cs", "cy", "da", "de", "el", "en", "es", "et",
     "eu", "fi", "fr", "ga", "gl", "he", "hi", "hr", "hu", "id", "it", "ja", "kk", "ko", "lt", "lv",
     "mk", "ms", "nb", "nl", "pl", "prs", "pt-BR", "pt", "pt-PT", "ro", "ru", "sk", "sl", "sr-Cyrl",
     "sr-Latn", "sv", "th", "tr", "uk", "vi", "zh", "zh-Hans", and "zh-Hant".
    :vartype default_language_code: str or
     ~azure.search.documents.indexes.models.ImageAnalysisSkillLanguage
    :ivar visual_features: A list of visual features.
    :vartype visual_features: list[str or ~azure.search.documents.indexes.models.VisualFeature]
    :ivar details: A string indicating which domain-specific details to return.
    :vartype details: list[str or ~azure.search.documents.indexes.models.ImageDetail]
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Vision.ImageAnalysisSkill".
    :vartype odata_type: str
    """

    default_language_code: Optional[Union[str, "_models.ImageAnalysisSkillLanguage"]] = rest_field(
        name="defaultLanguageCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating which language code to use. Default is ``en``. Known values are: \"ar\",
     \"az\", \"bg\", \"bs\", \"ca\", \"cs\", \"cy\", \"da\", \"de\", \"el\", \"en\", \"es\", \"et\",
     \"eu\", \"fi\", \"fr\", \"ga\", \"gl\", \"he\", \"hi\", \"hr\", \"hu\", \"id\", \"it\", \"ja\",
     \"kk\", \"ko\", \"lt\", \"lv\", \"mk\", \"ms\", \"nb\", \"nl\", \"pl\", \"prs\", \"pt-BR\",
     \"pt\", \"pt-PT\", \"ro\", \"ru\", \"sk\", \"sl\", \"sr-Cyrl\", \"sr-Latn\", \"sv\", \"th\",
     \"tr\", \"uk\", \"vi\", \"zh\", \"zh-Hans\", and \"zh-Hant\"."""
    visual_features: Optional[list[Union[str, "_models.VisualFeature"]]] = rest_field(
        name="visualFeatures", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of visual features."""
    details: Optional[list[Union[str, "_models.ImageDetail"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A string indicating which domain-specific details to return."""
    odata_type: Literal["#Microsoft.Skills.Vision.ImageAnalysisSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Vision.ImageAnalysisSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[Union[str, "_models.ImageAnalysisSkillLanguage"]] = None,
        visual_features: Optional[list[Union[str, "_models.VisualFeature"]]] = None,
        details: Optional[list[Union[str, "_models.ImageDetail"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Vision.ImageAnalysisSkill"  # type: ignore


class IndexedOneLakeKnowledgeSource(KnowledgeSource, discriminator="indexedOneLake"):
    """Configuration for OneLake knowledge source.

    :ivar name: The name of the knowledge source. Required.
    :vartype name: str
    :ivar description: Optional user-defined description.
    :vartype description: str
    :ivar e_tag: The ETag of the knowledge source.
    :vartype e_tag: str
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your knowledge source
     definition when you want full assurance that no one, not even Microsoft, can decrypt them. Once
     you have encrypted your knowledge source definition, it will always remain encrypted. The
     search service will ignore attempts to set this property to null. You can change this property
     as needed if you want to rotate your encryption key; Your knowledge source definition will be
     unaffected. Encryption with customer-managed keys is not available for free search services,
     and is only available for paid services created on or after January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :ivar kind: Required. A knowledge source that reads data from indexed OneLake.
    :vartype kind: str or ~azure.search.documents.indexes.models.INDEXED_ONE_LAKE
    :ivar indexed_one_lake_parameters: The parameters for the knowledge source. Required.
    :vartype indexed_one_lake_parameters:
     ~azure.search.documents.indexes.models.IndexedOneLakeKnowledgeSourceParameters
    """

    kind: Literal[KnowledgeSourceKind.INDEXED_ONE_LAKE] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. A knowledge source that reads data from indexed OneLake."""
    indexed_one_lake_parameters: "_models.IndexedOneLakeKnowledgeSourceParameters" = rest_field(
        name="indexedOneLakeParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """The parameters for the knowledge source. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        indexed_one_lake_parameters: "_models.IndexedOneLakeKnowledgeSourceParameters",
        description: Optional[str] = None,
        e_tag: Optional[str] = None,
        encryption_key: Optional["_models.SearchResourceEncryptionKey"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeSourceKind.INDEXED_ONE_LAKE  # type: ignore


class IndexedOneLakeKnowledgeSourceParameters(_Model):
    """Parameters for OneLake knowledge source.

    :ivar fabric_workspace_id: OneLake workspace ID. Required.
    :vartype fabric_workspace_id: str
    :ivar lakehouse_id: Specifies which OneLake lakehouse to access. Required.
    :vartype lakehouse_id: str
    :ivar target_path: Optional OneLakehouse folder or shortcut to filter OneLake content.
    :vartype target_path: str
    :ivar ingestion_parameters: Consolidates all general ingestion settings.
    :vartype ingestion_parameters:
     ~azure.search.documents.knowledgebases.models.KnowledgeSourceIngestionParameters
    :ivar created_resources: Resources created by the knowledge source.
    :vartype created_resources: ~azure.search.documents.indexes.models.CreatedResources
    """

    fabric_workspace_id: str = rest_field(
        name="fabricWorkspaceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """OneLake workspace ID. Required."""
    lakehouse_id: str = rest_field(name="lakehouseId", visibility=["read", "create", "update", "delete", "query"])
    """Specifies which OneLake lakehouse to access. Required."""
    target_path: Optional[str] = rest_field(
        name="targetPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional OneLakehouse folder or shortcut to filter OneLake content."""
    ingestion_parameters: Optional["_knowledgebases_models3.KnowledgeSourceIngestionParameters"] = rest_field(
        name="ingestionParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Consolidates all general ingestion settings."""
    created_resources: Optional["_models.CreatedResources"] = rest_field(name="createdResources", visibility=["read"])
    """Resources created by the knowledge source."""

    @overload
    def __init__(
        self,
        *,
        fabric_workspace_id: str,
        lakehouse_id: str,
        target_path: Optional[str] = None,
        ingestion_parameters: Optional["_knowledgebases_models3.KnowledgeSourceIngestionParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IndexedSharePointKnowledgeSource(KnowledgeSource, discriminator="indexedSharePoint"):
    """Configuration for SharePoint knowledge source.

    :ivar name: The name of the knowledge source. Required.
    :vartype name: str
    :ivar description: Optional user-defined description.
    :vartype description: str
    :ivar e_tag: The ETag of the knowledge source.
    :vartype e_tag: str
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your knowledge source
     definition when you want full assurance that no one, not even Microsoft, can decrypt them. Once
     you have encrypted your knowledge source definition, it will always remain encrypted. The
     search service will ignore attempts to set this property to null. You can change this property
     as needed if you want to rotate your encryption key; Your knowledge source definition will be
     unaffected. Encryption with customer-managed keys is not available for free search services,
     and is only available for paid services created on or after January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :ivar kind: Required. A knowledge source that reads data from indexed SharePoint.
    :vartype kind: str or ~azure.search.documents.indexes.models.INDEXED_SHARE_POINT
    :ivar indexed_share_point_parameters: The parameters for the knowledge source. Required.
    :vartype indexed_share_point_parameters:
     ~azure.search.documents.indexes.models.IndexedSharePointKnowledgeSourceParameters
    """

    kind: Literal[KnowledgeSourceKind.INDEXED_SHARE_POINT] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. A knowledge source that reads data from indexed SharePoint."""
    indexed_share_point_parameters: "_models.IndexedSharePointKnowledgeSourceParameters" = rest_field(
        name="indexedSharePointParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """The parameters for the knowledge source. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        indexed_share_point_parameters: "_models.IndexedSharePointKnowledgeSourceParameters",
        description: Optional[str] = None,
        e_tag: Optional[str] = None,
        encryption_key: Optional["_models.SearchResourceEncryptionKey"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeSourceKind.INDEXED_SHARE_POINT  # type: ignore


class IndexedSharePointKnowledgeSourceParameters(_Model):  # pylint: disable=name-too-long
    """Parameters for SharePoint knowledge source.

    :ivar connection_string: SharePoint connection string with format:
     SharePointOnlineEndpoint=[SharePoint site url];ApplicationId=[Azure AD App
     ID];ApplicationSecret=[Azure AD App client secret];TenantId=[SharePoint site tenant id].
     Required.
    :vartype connection_string: str
    :ivar container_name: Specifies which SharePoint libraries to access. Required. Known values
     are: "defaultSiteLibrary", "allSiteLibraries", and "useQuery".
    :vartype container_name: str or
     ~azure.search.documents.indexes.models.IndexedSharePointContainerName
    :ivar query: Optional query to filter SharePoint content.
    :vartype query: str
    :ivar ingestion_parameters: Consolidates all general ingestion settings.
    :vartype ingestion_parameters:
     ~azure.search.documents.knowledgebases.models.KnowledgeSourceIngestionParameters
    :ivar created_resources: Resources created by the knowledge source.
    :vartype created_resources: ~azure.search.documents.indexes.models.CreatedResources
    """

    connection_string: str = rest_field(
        name="connectionString", visibility=["read", "create", "update", "delete", "query"]
    )
    """SharePoint connection string with format: SharePointOnlineEndpoint=[SharePoint site
     url];ApplicationId=[Azure AD App ID];ApplicationSecret=[Azure AD App client
     secret];TenantId=[SharePoint site tenant id]. Required."""
    container_name: Union[str, "_models.IndexedSharePointContainerName"] = rest_field(
        name="containerName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies which SharePoint libraries to access. Required. Known values are:
     \"defaultSiteLibrary\", \"allSiteLibraries\", and \"useQuery\"."""
    query: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional query to filter SharePoint content."""
    ingestion_parameters: Optional["_knowledgebases_models3.KnowledgeSourceIngestionParameters"] = rest_field(
        name="ingestionParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Consolidates all general ingestion settings."""
    created_resources: Optional["_models.CreatedResources"] = rest_field(name="createdResources", visibility=["read"])
    """Resources created by the knowledge source."""

    @overload
    def __init__(
        self,
        *,
        connection_string: str,
        container_name: Union[str, "_models.IndexedSharePointContainerName"],
        query: Optional[str] = None,
        ingestion_parameters: Optional["_knowledgebases_models3.KnowledgeSourceIngestionParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IndexerCurrentState(_Model):
    """Represents all of the state that defines and dictates the indexer's current execution.

    :ivar mode: The mode the indexer is running in. Known values are: "indexingAllDocs",
     "indexingResetDocs", and "indexingResync".
    :vartype mode: str or ~azure.search.documents.indexes.models.IndexingMode
    :ivar all_docs_initial_tracking_state: Change tracking state used when indexing starts on all
     documents in the datasource.
    :vartype all_docs_initial_tracking_state: str
    :ivar all_docs_final_tracking_state: Change tracking state value when indexing finishes on all
     documents in the datasource.
    :vartype all_docs_final_tracking_state: str
    :ivar reset_docs_initial_tracking_state: Change tracking state used when indexing starts on
     select, reset documents in the datasource.
    :vartype reset_docs_initial_tracking_state: str
    :ivar reset_docs_final_tracking_state: Change tracking state value when indexing finishes on
     select, reset documents in the datasource.
    :vartype reset_docs_final_tracking_state: str
    :ivar resync_initial_tracking_state: Change tracking state used when indexing starts on
     selective options from the datasource.
    :vartype resync_initial_tracking_state: str
    :ivar resync_final_tracking_state: Change tracking state value when indexing finishes on
     selective options from the datasource.
    :vartype resync_final_tracking_state: str
    :ivar reset_document_keys: The list of document keys that have been reset. The document key is
     the document's unique identifier for the data in the search index. The indexer will prioritize
     selectively re-ingesting these keys.
    :vartype reset_document_keys: list[str]
    :ivar reset_datasource_document_ids: The list of datasource document ids that have been reset.
     The datasource document id is the unique identifier for the data in the datasource. The indexer
     will prioritize selectively re-ingesting these ids.
    :vartype reset_datasource_document_ids: list[str]
    """

    mode: Optional[Union[str, "_models.IndexingMode"]] = rest_field(visibility=["read"])
    """The mode the indexer is running in. Known values are: \"indexingAllDocs\",
     \"indexingResetDocs\", and \"indexingResync\"."""
    all_docs_initial_tracking_state: Optional[str] = rest_field(name="allDocsInitialTrackingState", visibility=["read"])
    """Change tracking state used when indexing starts on all documents in the datasource."""
    all_docs_final_tracking_state: Optional[str] = rest_field(name="allDocsFinalTrackingState", visibility=["read"])
    """Change tracking state value when indexing finishes on all documents in the datasource."""
    reset_docs_initial_tracking_state: Optional[str] = rest_field(
        name="resetDocsInitialTrackingState", visibility=["read"]
    )
    """Change tracking state used when indexing starts on select, reset documents in the datasource."""
    reset_docs_final_tracking_state: Optional[str] = rest_field(name="resetDocsFinalTrackingState", visibility=["read"])
    """Change tracking state value when indexing finishes on select, reset documents in the
     datasource."""
    resync_initial_tracking_state: Optional[str] = rest_field(name="resyncInitialTrackingState", visibility=["read"])
    """Change tracking state used when indexing starts on selective options from the datasource."""
    resync_final_tracking_state: Optional[str] = rest_field(name="resyncFinalTrackingState", visibility=["read"])
    """Change tracking state value when indexing finishes on selective options from the datasource."""
    reset_document_keys: Optional[list[str]] = rest_field(name="resetDocumentKeys", visibility=["read"])
    """The list of document keys that have been reset. The document key is the document's unique
     identifier for the data in the search index. The indexer will prioritize selectively
     re-ingesting these keys."""
    reset_datasource_document_ids: Optional[list[str]] = rest_field(
        name="resetDatasourceDocumentIds", visibility=["read"]
    )
    """The list of datasource document ids that have been reset. The datasource document id is the
     unique identifier for the data in the datasource. The indexer will prioritize selectively
     re-ingesting these ids."""


class IndexerExecutionResult(_Model):
    """Represents the result of an individual indexer execution.

    :ivar status: The outcome of this indexer execution. Required. Known values are:
     "transientFailure", "success", "inProgress", and "reset".
    :vartype status: str or ~azure.search.documents.indexes.models.IndexerExecutionStatus
    :ivar status_detail: The outcome of this indexer execution. Known values are: "resetDocs" and
     "resync".
    :vartype status_detail: str or
     ~azure.search.documents.indexes.models.IndexerExecutionStatusDetail
    :ivar mode: The mode the indexer is running in. Known values are: "indexingAllDocs",
     "indexingResetDocs", and "indexingResync".
    :vartype mode: str or ~azure.search.documents.indexes.models.IndexingMode
    :ivar error_message: The error message indicating the top-level error, if any.
    :vartype error_message: str
    :ivar start_time: The start time of this indexer execution.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of this indexer execution, if the execution has already completed.
    :vartype end_time: ~datetime.datetime
    :ivar errors: The item-level indexing errors. Required.
    :vartype errors: list[~azure.search.documents.indexes.models.SearchIndexerError]
    :ivar warnings: The item-level indexing warnings. Required.
    :vartype warnings: list[~azure.search.documents.indexes.models.SearchIndexerWarning]
    :ivar item_count: The number of items that were processed during this indexer execution. This
     includes both successfully processed items and items where indexing was attempted but failed.
     Required.
    :vartype item_count: int
    :ivar failed_item_count: The number of items that failed to be indexed during this indexer
     execution. Required.
    :vartype failed_item_count: int
    :ivar initial_tracking_state: Change tracking state with which an indexer execution started.
    :vartype initial_tracking_state: str
    :ivar final_tracking_state: Change tracking state with which an indexer execution finished.
    :vartype final_tracking_state: str
    """

    status: Union[str, "_models.IndexerExecutionStatus"] = rest_field(visibility=["read"])
    """The outcome of this indexer execution. Required. Known values are: \"transientFailure\",
     \"success\", \"inProgress\", and \"reset\"."""
    status_detail: Optional[Union[str, "_models.IndexerExecutionStatusDetail"]] = rest_field(
        name="statusDetail", visibility=["read"]
    )
    """The outcome of this indexer execution. Known values are: \"resetDocs\" and \"resync\"."""
    mode: Optional[Union[str, "_models.IndexingMode"]] = rest_field(visibility=["read"])
    """The mode the indexer is running in. Known values are: \"indexingAllDocs\",
     \"indexingResetDocs\", and \"indexingResync\"."""
    error_message: Optional[str] = rest_field(name="errorMessage", visibility=["read"])
    """The error message indicating the top-level error, if any."""
    start_time: Optional[datetime.datetime] = rest_field(name="startTime", visibility=["read"], format="rfc3339")
    """The start time of this indexer execution."""
    end_time: Optional[datetime.datetime] = rest_field(name="endTime", visibility=["read"], format="rfc3339")
    """The end time of this indexer execution, if the execution has already completed."""
    errors: list["_models.SearchIndexerError"] = rest_field(visibility=["read"])
    """The item-level indexing errors. Required."""
    warnings: list["_models.SearchIndexerWarning"] = rest_field(visibility=["read"])
    """The item-level indexing warnings. Required."""
    item_count: int = rest_field(name="itemsProcessed", visibility=["read"])
    """The number of items that were processed during this indexer execution. This includes both
     successfully processed items and items where indexing was attempted but failed. Required."""
    failed_item_count: int = rest_field(name="itemsFailed", visibility=["read"])
    """The number of items that failed to be indexed during this indexer execution. Required."""
    initial_tracking_state: Optional[str] = rest_field(name="initialTrackingState", visibility=["read"])
    """Change tracking state with which an indexer execution started."""
    final_tracking_state: Optional[str] = rest_field(name="finalTrackingState", visibility=["read"])
    """Change tracking state with which an indexer execution finished."""


class IndexerResyncBody(_Model):
    """Request body for resync indexer operation.

    :ivar options: Re-sync options that have been pre-defined from data source.
    :vartype options: list[str or ~azure.search.documents.indexes.models.IndexerResyncOption]
    """

    options: Optional[list[Union[str, "_models.IndexerResyncOption"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Re-sync options that have been pre-defined from data source."""

    @overload
    def __init__(
        self,
        *,
        options: Optional[list[Union[str, "_models.IndexerResyncOption"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IndexerRuntime(_Model):
    """Represents the indexer's cumulative runtime consumption in the service.

    :ivar used_seconds: Cumulative runtime of the indexer from the beginningTime to endingTime, in
     seconds. Required.
    :vartype used_seconds: int
    :ivar remaining_seconds: Cumulative runtime remaining for all indexers in the service from the
     beginningTime to endingTime, in seconds.
    :vartype remaining_seconds: int
    :ivar beginning_time: Beginning UTC time of the 24-hour period considered for indexer runtime
     usage (inclusive). Required.
    :vartype beginning_time: ~datetime.datetime
    :ivar ending_time: End UTC time of the 24-hour period considered for indexer runtime usage
     (inclusive). Required.
    :vartype ending_time: ~datetime.datetime
    """

    used_seconds: int = rest_field(name="usedSeconds", visibility=["read", "create", "update", "delete", "query"])
    """Cumulative runtime of the indexer from the beginningTime to endingTime, in seconds. Required."""
    remaining_seconds: Optional[int] = rest_field(
        name="remainingSeconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cumulative runtime remaining for all indexers in the service from the beginningTime to
     endingTime, in seconds."""
    beginning_time: datetime.datetime = rest_field(
        name="beginningTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Beginning UTC time of the 24-hour period considered for indexer runtime usage (inclusive).
     Required."""
    ending_time: datetime.datetime = rest_field(
        name="endingTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """End UTC time of the 24-hour period considered for indexer runtime usage (inclusive). Required."""

    @overload
    def __init__(
        self,
        *,
        used_seconds: int,
        beginning_time: datetime.datetime,
        ending_time: datetime.datetime,
        remaining_seconds: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IndexingParameters(_Model):
    """Represents parameters for indexer execution.

    :ivar batch_size: The number of items that are read from the data source and indexed as a
     single batch in order to improve performance. The default depends on the data source type.
    :vartype batch_size: int
    :ivar max_failed_items: The maximum number of items that can fail indexing for indexer
     execution to still be considered successful. -1 means no limit. Default is 0.
    :vartype max_failed_items: int
    :ivar max_failed_items_per_batch: The maximum number of items in a single batch that can fail
     indexing for the batch to still be considered successful. -1 means no limit. Default is 0.
    :vartype max_failed_items_per_batch: int
    :ivar configuration: A dictionary of indexer-specific configuration properties. Each name is
     the name of a specific property. Each value must be of a primitive type.
    :vartype configuration: ~azure.search.documents.indexes.models.IndexingParametersConfiguration
    """

    batch_size: Optional[int] = rest_field(name="batchSize", visibility=["read", "create", "update", "delete", "query"])
    """The number of items that are read from the data source and indexed as a single batch in order
     to improve performance. The default depends on the data source type."""
    max_failed_items: Optional[int] = rest_field(
        name="maxFailedItems", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of items that can fail indexing for indexer execution to still be considered
     successful. -1 means no limit. Default is 0."""
    max_failed_items_per_batch: Optional[int] = rest_field(
        name="maxFailedItemsPerBatch", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of items in a single batch that can fail indexing for the batch to still be
     considered successful. -1 means no limit. Default is 0."""
    configuration: Optional["_models.IndexingParametersConfiguration"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A dictionary of indexer-specific configuration properties. Each name is the name of a specific
     property. Each value must be of a primitive type."""

    @overload
    def __init__(
        self,
        *,
        batch_size: Optional[int] = None,
        max_failed_items: Optional[int] = None,
        max_failed_items_per_batch: Optional[int] = None,
        configuration: Optional["_models.IndexingParametersConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IndexingParametersConfiguration(_Model):
    """A dictionary of indexer-specific configuration properties. Each name is the name of a specific
    property. Each value must be of a primitive type.

    :ivar parsing_mode: Represents the parsing mode for indexing from an Azure blob data source.
     Known values are: "default", "text", "delimitedText", "json", "jsonArray", "jsonLines", and
     "markdown".
    :vartype parsing_mode: str or ~azure.search.documents.indexes.models.BlobIndexerParsingMode
    :ivar excluded_file_name_extensions: Comma-delimited list of filename extensions to ignore when
     processing from Azure blob storage.  For example, you could exclude ".png, .mp4" to skip over
     those files during indexing.
    :vartype excluded_file_name_extensions: str
    :ivar indexed_file_name_extensions: Comma-delimited list of filename extensions to select when
     processing from Azure blob storage.  For example, you could focus indexing on specific
     application files ".docx, .pptx, .msg" to specifically include those file types.
    :vartype indexed_file_name_extensions: str
    :ivar fail_on_unsupported_content_type: For Azure blobs, set to false if you want to continue
     indexing when an unsupported content type is encountered, and you don't know all the content
     types (file extensions) in advance.
    :vartype fail_on_unsupported_content_type: bool
    :ivar fail_on_unprocessable_document: For Azure blobs, set to false if you want to continue
     indexing if a document fails indexing.
    :vartype fail_on_unprocessable_document: bool
    :ivar index_storage_metadata_only_for_oversized_documents: For Azure blobs, set this property
     to true to still index storage metadata for blob content that is too large to process.
     Oversized blobs are treated as errors by default. For limits on blob size, see
     `https://learn.microsoft.com/azure/search/search-limits-quotas-capacity
     <https://learn.microsoft.com/azure/search/search-limits-quotas-capacity>`_.
    :vartype index_storage_metadata_only_for_oversized_documents: bool
    :ivar delimited_text_headers: For CSV blobs, specifies a comma-delimited list of column
     headers, useful for mapping source fields to destination fields in an index.
    :vartype delimited_text_headers: str
    :ivar delimited_text_delimiter: For CSV blobs, specifies the end-of-line single-character
     delimiter for CSV files where each line starts a new document (for example, "|").
    :vartype delimited_text_delimiter: str
    :ivar first_line_contains_headers: For CSV blobs, indicates that the first (non-blank) line of
     each blob contains headers.
    :vartype first_line_contains_headers: bool
    :ivar markdown_parsing_submode: Specifies the submode that will determine whether a markdown
     file will be parsed into exactly one search document or multiple search documents. Default is
     ``oneToMany``. Known values are: "oneToMany" and "oneToOne".
    :vartype markdown_parsing_submode: str or
     ~azure.search.documents.indexes.models.MarkdownParsingSubmode
    :ivar markdown_header_depth: Specifies the max header depth that will be considered while
     grouping markdown content. Default is ``h6``. Known values are: "h1", "h2", "h3", "h4", "h5",
     and "h6".
    :vartype markdown_header_depth: str or
     ~azure.search.documents.indexes.models.MarkdownHeaderDepth
    :ivar document_root: For JSON arrays, given a structured or semi-structured document, you can
     specify a path to the array using this property.
    :vartype document_root: str
    :ivar data_to_extract: Specifies the data to extract from Azure blob storage and tells the
     indexer which data to extract from image content when "imageAction" is set to a value other
     than "none".  This applies to embedded image content in a .PDF or other application, or image
     files such as .jpg and .png, in Azure blobs. Known values are: "storageMetadata",
     "allMetadata", and "contentAndMetadata".
    :vartype data_to_extract: str or
     ~azure.search.documents.indexes.models.BlobIndexerDataToExtract
    :ivar image_action: Determines how to process embedded images and image files in Azure blob
     storage.  Setting the "imageAction" configuration to any value other than "none" requires that
     a skillset also be attached to that indexer. Known values are: "none",
     "generateNormalizedImages", and "generateNormalizedImagePerPage".
    :vartype image_action: str or ~azure.search.documents.indexes.models.BlobIndexerImageAction
    :ivar allow_skillset_to_read_file_data: If true, will create a path //document//file_data that
     is an object representing the original file data downloaded from your blob data source. This
     allows you to pass the original file data to a custom skill for processing within the
     enrichment pipeline, or to the Document Extraction skill.
    :vartype allow_skillset_to_read_file_data: bool
    :ivar pdf_text_rotation_algorithm: Determines algorithm for text extraction from PDF files in
     Azure blob storage. Known values are: "none" and "detectAngles".
    :vartype pdf_text_rotation_algorithm: str or
     ~azure.search.documents.indexes.models.BlobIndexerPDFTextRotationAlgorithm
    :ivar execution_environment: Specifies the environment in which the indexer should execute.
     Known values are: "standard" and "private".
    :vartype execution_environment: str or
     ~azure.search.documents.indexes.models.IndexerExecutionEnvironment
    :ivar query_timeout: Increases the timeout beyond the 5-minute default for Azure SQL database
     data sources, specified in the format "hh:mm:ss".
    :vartype query_timeout: str
    """

    parsing_mode: Optional[Union[str, "_models.BlobIndexerParsingMode"]] = rest_field(
        name="parsingMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the parsing mode for indexing from an Azure blob data source. Known values are:
     \"default\", \"text\", \"delimitedText\", \"json\", \"jsonArray\", \"jsonLines\", and
     \"markdown\"."""
    excluded_file_name_extensions: Optional[str] = rest_field(
        name="excludedFileNameExtensions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Comma-delimited list of filename extensions to ignore when processing from Azure blob storage.
     For example, you could exclude \".png, .mp4\" to skip over those files during indexing."""
    indexed_file_name_extensions: Optional[str] = rest_field(
        name="indexedFileNameExtensions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Comma-delimited list of filename extensions to select when processing from Azure blob storage.
     For example, you could focus indexing on specific application files \".docx, .pptx, .msg\" to
     specifically include those file types."""
    fail_on_unsupported_content_type: Optional[bool] = rest_field(
        name="failOnUnsupportedContentType", visibility=["read", "create", "update", "delete", "query"]
    )
    """For Azure blobs, set to false if you want to continue indexing when an unsupported content type
     is encountered, and you don't know all the content types (file extensions) in advance."""
    fail_on_unprocessable_document: Optional[bool] = rest_field(
        name="failOnUnprocessableDocument", visibility=["read", "create", "update", "delete", "query"]
    )
    """For Azure blobs, set to false if you want to continue indexing if a document fails indexing."""
    index_storage_metadata_only_for_oversized_documents: Optional[bool] = rest_field(
        name="indexStorageMetadataOnlyForOversizedDocuments", visibility=["read", "create", "update", "delete", "query"]
    )
    """For Azure blobs, set this property to true to still index storage metadata for blob content
     that is too large to process. Oversized blobs are treated as errors by default. For limits on
     blob size, see `https://learn.microsoft.com/azure/search/search-limits-quotas-capacity
     <https://learn.microsoft.com/azure/search/search-limits-quotas-capacity>`_."""
    delimited_text_headers: Optional[str] = rest_field(
        name="delimitedTextHeaders", visibility=["read", "create", "update", "delete", "query"]
    )
    """For CSV blobs, specifies a comma-delimited list of column headers, useful for mapping source
     fields to destination fields in an index."""
    delimited_text_delimiter: Optional[str] = rest_field(
        name="delimitedTextDelimiter", visibility=["read", "create", "update", "delete", "query"]
    )
    """For CSV blobs, specifies the end-of-line single-character delimiter for CSV files where each
     line starts a new document (for example, \"|\")."""
    first_line_contains_headers: Optional[bool] = rest_field(
        name="firstLineContainsHeaders", visibility=["read", "create", "update", "delete", "query"]
    )
    """For CSV blobs, indicates that the first (non-blank) line of each blob contains headers."""
    markdown_parsing_submode: Optional[Union[str, "_models.MarkdownParsingSubmode"]] = rest_field(
        name="markdownParsingSubmode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the submode that will determine whether a markdown file will be parsed into exactly
     one search document or multiple search documents. Default is ``oneToMany``. Known values are:
     \"oneToMany\" and \"oneToOne\"."""
    markdown_header_depth: Optional[Union[str, "_models.MarkdownHeaderDepth"]] = rest_field(
        name="markdownHeaderDepth", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the max header depth that will be considered while grouping markdown content. Default
     is ``h6``. Known values are: \"h1\", \"h2\", \"h3\", \"h4\", \"h5\", and \"h6\"."""
    document_root: Optional[str] = rest_field(
        name="documentRoot", visibility=["read", "create", "update", "delete", "query"]
    )
    """For JSON arrays, given a structured or semi-structured document, you can specify a path to the
     array using this property."""
    data_to_extract: Optional[Union[str, "_models.BlobIndexerDataToExtract"]] = rest_field(
        name="dataToExtract", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the data to extract from Azure blob storage and tells the indexer which data to
     extract from image content when \"imageAction\" is set to a value other than \"none\".  This
     applies to embedded image content in a .PDF or other application, or image files such as .jpg
     and .png, in Azure blobs. Known values are: \"storageMetadata\", \"allMetadata\", and
     \"contentAndMetadata\"."""
    image_action: Optional[Union[str, "_models.BlobIndexerImageAction"]] = rest_field(
        name="imageAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """Determines how to process embedded images and image files in Azure blob storage.  Setting the
     \"imageAction\" configuration to any value other than \"none\" requires that a skillset also be
     attached to that indexer. Known values are: \"none\", \"generateNormalizedImages\", and
     \"generateNormalizedImagePerPage\"."""
    allow_skillset_to_read_file_data: Optional[bool] = rest_field(
        name="allowSkillsetToReadFileData", visibility=["read", "create", "update", "delete", "query"]
    )
    """If true, will create a path //document//file_data that is an object representing the original
     file data downloaded from your blob data source. This allows you to pass the original file data
     to a custom skill for processing within the enrichment pipeline, or to the Document Extraction
     skill."""
    pdf_text_rotation_algorithm: Optional[Union[str, "_models.BlobIndexerPDFTextRotationAlgorithm"]] = rest_field(
        name="pdfTextRotationAlgorithm", visibility=["read", "create", "update", "delete", "query"]
    )
    """Determines algorithm for text extraction from PDF files in Azure blob storage. Known values
     are: \"none\" and \"detectAngles\"."""
    execution_environment: Optional[Union[str, "_models.IndexerExecutionEnvironment"]] = rest_field(
        name="executionEnvironment", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the environment in which the indexer should execute. Known values are: \"standard\"
     and \"private\"."""
    query_timeout: Optional[str] = rest_field(
        name="queryTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """Increases the timeout beyond the 5-minute default for Azure SQL database data sources,
     specified in the format \"hh:mm:ss\"."""

    @overload
    def __init__(
        self,
        *,
        parsing_mode: Optional[Union[str, "_models.BlobIndexerParsingMode"]] = None,
        excluded_file_name_extensions: Optional[str] = None,
        indexed_file_name_extensions: Optional[str] = None,
        fail_on_unsupported_content_type: Optional[bool] = None,
        fail_on_unprocessable_document: Optional[bool] = None,
        index_storage_metadata_only_for_oversized_documents: Optional[bool] = None,
        delimited_text_headers: Optional[str] = None,
        delimited_text_delimiter: Optional[str] = None,
        first_line_contains_headers: Optional[bool] = None,
        markdown_parsing_submode: Optional[Union[str, "_models.MarkdownParsingSubmode"]] = None,
        markdown_header_depth: Optional[Union[str, "_models.MarkdownHeaderDepth"]] = None,
        document_root: Optional[str] = None,
        data_to_extract: Optional[Union[str, "_models.BlobIndexerDataToExtract"]] = None,
        image_action: Optional[Union[str, "_models.BlobIndexerImageAction"]] = None,
        allow_skillset_to_read_file_data: Optional[bool] = None,
        pdf_text_rotation_algorithm: Optional[Union[str, "_models.BlobIndexerPDFTextRotationAlgorithm"]] = None,
        execution_environment: Optional[Union[str, "_models.IndexerExecutionEnvironment"]] = None,
        query_timeout: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IndexingSchedule(_Model):
    """Represents a schedule for indexer execution.

    :ivar interval: The interval of time between indexer executions. Required.
    :vartype interval: ~datetime.timedelta
    :ivar start_time: The time when an indexer should start running.
    :vartype start_time: ~datetime.datetime
    """

    interval: datetime.timedelta = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The interval of time between indexer executions. Required."""
    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time when an indexer should start running."""

    @overload
    def __init__(
        self,
        *,
        interval: datetime.timedelta,
        start_time: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IndexStatisticsSummary(_Model):
    """Statistics for a given index. Statistics are collected periodically and are not guaranteed to
    always be up-to-date.

    :ivar name: The name of the index. Required.
    :vartype name: str
    :ivar document_count: The number of documents in the index. Required.
    :vartype document_count: int
    :ivar storage_size: The amount of storage in bytes consumed by the index. Required.
    :vartype storage_size: int
    :ivar vector_index_size: The amount of memory in bytes consumed by vectors in the index.
     Required.
    :vartype vector_index_size: int
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the index. Required."""
    document_count: int = rest_field(name="documentCount", visibility=["read"])
    """The number of documents in the index. Required."""
    storage_size: int = rest_field(name="storageSize", visibility=["read"])
    """The amount of storage in bytes consumed by the index. Required."""
    vector_index_size: int = rest_field(name="vectorIndexSize", visibility=["read"])
    """The amount of memory in bytes consumed by vectors in the index. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InputFieldMappingEntry(_Model):
    """Input field mapping for a skill.

    :ivar name: The name of the input. Required.
    :vartype name: str
    :ivar source: The source of the input.
    :vartype source: str
    :ivar source_context: The source context used for selecting recursive inputs.
    :vartype source_context: str
    :ivar inputs: The recursive inputs used when creating a complex type.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the input. Required."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The source of the input."""
    source_context: Optional[str] = rest_field(
        name="sourceContext", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source context used for selecting recursive inputs."""
    inputs: Optional[list["_models.InputFieldMappingEntry"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The recursive inputs used when creating a complex type."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        source: Optional[str] = None,
        source_context: Optional[str] = None,
        inputs: Optional[list["_models.InputFieldMappingEntry"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeepTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.KeepTokenFilter"):
    """A token filter that only keeps tokens with text contained in a specified list of words. This
    token filter is implemented using Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar keep_words: The list of words to keep. Required.
    :vartype keep_words: list[str]
    :ivar lower_case_keep_words: A value indicating whether to lower case all words first. Default
     is false.
    :vartype lower_case_keep_words: bool
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.KeepTokenFilter".
    :vartype odata_type: str
    """

    keep_words: list[str] = rest_field(name="keepWords", visibility=["read", "create", "update", "delete", "query"])
    """The list of words to keep. Required."""
    lower_case_keep_words: Optional[bool] = rest_field(
        name="keepWordsCase", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to lower case all words first. Default is false."""
    odata_type: Literal["#Microsoft.Azure.Search.KeepTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.KeepTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        keep_words: list[str],
        lower_case_keep_words: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.KeepTokenFilter"  # type: ignore


class KeyPhraseExtractionSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Text.KeyPhraseExtractionSkill"):
    """A skill that uses text analytics for key phrase extraction.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is ``en``.
     Known values are: "da", "nl", "en", "fi", "fr", "de", "it", "ja", "ko", "no", "pl", "pt-PT",
     "pt-BR", "ru", "es", and "sv".
    :vartype default_language_code: str or
     ~azure.search.documents.indexes.models.KeyPhraseExtractionSkillLanguage
    :ivar max_key_phrase_count: A number indicating how many key phrases to return. If absent, all
     identified key phrases will be returned.
    :vartype max_key_phrase_count: int
    :ivar model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :vartype model_version: str
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Text.KeyPhraseExtractionSkill".
    :vartype odata_type: str
    """

    default_language_code: Optional[Union[str, "_models.KeyPhraseExtractionSkillLanguage"]] = rest_field(
        name="defaultLanguageCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating which language code to use. Default is ``en``. Known values are: \"da\",
     \"nl\", \"en\", \"fi\", \"fr\", \"de\", \"it\", \"ja\", \"ko\", \"no\", \"pl\", \"pt-PT\",
     \"pt-BR\", \"ru\", \"es\", and \"sv\"."""
    max_key_phrase_count: Optional[int] = rest_field(
        name="maxKeyPhraseCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """A number indicating how many key phrases to return. If absent, all identified key phrases will
     be returned."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The version of the model to use when calling the Text Analytics service. It will default to the
     latest available when not specified. We recommend you do not specify this value unless
     absolutely necessary."""
    odata_type: Literal["#Microsoft.Skills.Text.KeyPhraseExtractionSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Text.KeyPhraseExtractionSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[Union[str, "_models.KeyPhraseExtractionSkillLanguage"]] = None,
        max_key_phrase_count: Optional[int] = None,
        model_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Text.KeyPhraseExtractionSkill"  # type: ignore


class KeywordMarkerTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.KeywordMarkerTokenFilter"):
    """Marks terms as keywords. This token filter is implemented using Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar keywords: A list of words to mark as keywords. Required.
    :vartype keywords: list[str]
    :ivar ignore_case: A value indicating whether to ignore case. If true, all words are converted
     to lower case first. Default is false.
    :vartype ignore_case: bool
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.KeywordMarkerTokenFilter".
    :vartype odata_type: str
    """

    keywords: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of words to mark as keywords. Required."""
    ignore_case: Optional[bool] = rest_field(
        name="ignoreCase", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to ignore case. If true, all words are converted to lower case
     first. Default is false."""
    odata_type: Literal["#Microsoft.Azure.Search.KeywordMarkerTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.KeywordMarkerTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        keywords: list[str],
        ignore_case: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.KeywordMarkerTokenFilter"  # type: ignore


class KeywordTokenizer(LexicalTokenizer, discriminator="#Microsoft.Azure.Search.KeywordTokenizer"):
    """Emits the entire input as a single token. This tokenizer is implemented using Apache Lucene.

    :ivar name: The name of the tokenizer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar buffer_size: The read buffer size in bytes. Default is 256.
    :vartype buffer_size: int
    :ivar odata_type: A URI fragment specifying the type of tokenizer. Required. Default value is
     "#Microsoft.Azure.Search.KeywordTokenizer".
    :vartype odata_type: str
    """

    buffer_size: Optional[int] = rest_field(
        name="bufferSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """The read buffer size in bytes. Default is 256."""
    odata_type: Literal["#Microsoft.Azure.Search.KeywordTokenizer"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of tokenizer. Required. Default value is
     \"#Microsoft.Azure.Search.KeywordTokenizer\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        buffer_size: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.KeywordTokenizer"  # type: ignore


class KeywordTokenizerV2(LexicalTokenizer, discriminator="#Microsoft.Azure.Search.KeywordTokenizerV2"):
    """Emits the entire input as a single token. This tokenizer is implemented using Apache Lucene.

    :ivar name: The name of the tokenizer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar max_token_length: The maximum token length. Default is 256. Tokens longer than the
     maximum length are split. The maximum token length that can be used is 300 characters.
    :vartype max_token_length: int
    :ivar odata_type: A URI fragment specifying the type of tokenizer. Required. Default value is
     "#Microsoft.Azure.Search.KeywordTokenizerV2".
    :vartype odata_type: str
    """

    max_token_length: Optional[int] = rest_field(
        name="maxTokenLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum token length. Default is 256. Tokens longer than the maximum length are split. The
     maximum token length that can be used is 300 characters."""
    odata_type: Literal["#Microsoft.Azure.Search.KeywordTokenizerV2"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of tokenizer. Required. Default value is
     \"#Microsoft.Azure.Search.KeywordTokenizerV2\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        max_token_length: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.KeywordTokenizerV2"  # type: ignore


class KnowledgeBase(_Model):
    """Represents a knowledge base definition.

    :ivar name: The name of the knowledge base. Required.
    :vartype name: str
    :ivar knowledge_sources: Knowledge sources referenced by this knowledge base. Required.
    :vartype knowledge_sources:
     list[~azure.search.documents.indexes.models.KnowledgeSourceReference]
    :ivar models: Contains configuration options on how to connect to AI models.
    :vartype models: list[~azure.search.documents.indexes.models.KnowledgeBaseModel]
    :ivar retrieval_reasoning_effort: The retrieval reasoning effort configuration.
    :vartype retrieval_reasoning_effort:
     ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalReasoningEffort
    :ivar output_mode: The output mode for the knowledge base. Known values are: "extractiveData"
     and "answerSynthesis".
    :vartype output_mode: str or
     ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalOutputMode
    :ivar e_tag: The ETag of the knowledge base.
    :vartype e_tag: str
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :ivar description: The description of the knowledge base.
    :vartype description: str
    :ivar retrieval_instructions: Instructions considered by the knowledge base when developing
     query plan.
    :vartype retrieval_instructions: str
    :ivar answer_instructions: Instructions considered by the knowledge base when generating
     answers.
    :vartype answer_instructions: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the knowledge base. Required."""
    knowledge_sources: list["_models.KnowledgeSourceReference"] = rest_field(
        name="knowledgeSources", visibility=["read", "create", "update", "delete", "query"]
    )
    """Knowledge sources referenced by this knowledge base. Required."""
    models: Optional[list["_models.KnowledgeBaseModel"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains configuration options on how to connect to AI models."""
    retrieval_reasoning_effort: Optional["_knowledgebases_models3.KnowledgeRetrievalReasoningEffort"] = rest_field(
        name="retrievalReasoningEffort", visibility=["read", "create", "update", "delete", "query"]
    )
    """The retrieval reasoning effort configuration."""
    output_mode: Optional[Union[str, "_knowledgebases_models3.KnowledgeRetrievalOutputMode"]] = rest_field(
        name="outputMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The output mode for the knowledge base. Known values are: \"extractiveData\" and
     \"answerSynthesis\"."""
    e_tag: Optional[str] = rest_field(name="@odata.etag", visibility=["read", "create", "update", "delete", "query"])
    """The ETag of the knowledge base."""
    encryption_key: Optional["_models.SearchResourceEncryptionKey"] = rest_field(
        name="encryptionKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """A description of an encryption key that you create in Azure Key Vault."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description of the knowledge base."""
    retrieval_instructions: Optional[str] = rest_field(
        name="retrievalInstructions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Instructions considered by the knowledge base when developing query plan."""
    answer_instructions: Optional[str] = rest_field(
        name="answerInstructions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Instructions considered by the knowledge base when generating answers."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        knowledge_sources: list["_models.KnowledgeSourceReference"],
        models: Optional[list["_models.KnowledgeBaseModel"]] = None,
        retrieval_reasoning_effort: Optional["_knowledgebases_models3.KnowledgeRetrievalReasoningEffort"] = None,
        output_mode: Optional[Union[str, "_knowledgebases_models3.KnowledgeRetrievalOutputMode"]] = None,
        e_tag: Optional[str] = None,
        encryption_key: Optional["_models.SearchResourceEncryptionKey"] = None,
        description: Optional[str] = None,
        retrieval_instructions: Optional[str] = None,
        answer_instructions: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseModel(_Model):
    """Specifies the connection parameters for the model to use for query planning.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeBaseAzureOpenAIModel

    :ivar kind: The AI model to be used for query planning. Required. "azureOpenAI"
    :vartype kind: str or ~azure.search.documents.indexes.models.KnowledgeBaseModelKind
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """The AI model to be used for query planning. Required. \"azureOpenAI\""""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseAzureOpenAIModel(KnowledgeBaseModel, discriminator="azureOpenAI"):
    """Specifies the Azure OpenAI resource used to do query planning.

    :ivar kind: Required. Use Azure Open AI models for query planning.
    :vartype kind: str or ~azure.search.documents.indexes.models.AZURE_OPEN_AI
    :ivar azure_open_ai_parameters: Azure OpenAI parameters. Required.
    :vartype azure_open_ai_parameters:
     ~azure.search.documents.indexes.models.AzureOpenAIVectorizerParameters
    """

    kind: Literal[KnowledgeBaseModelKind.AZURE_OPEN_AI] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Use Azure Open AI models for query planning."""
    azure_open_ai_parameters: "_models.AzureOpenAIVectorizerParameters" = rest_field(
        name="azureOpenAIParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure OpenAI parameters. Required."""

    @overload
    def __init__(
        self,
        *,
        azure_open_ai_parameters: "_models.AzureOpenAIVectorizerParameters",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeBaseModelKind.AZURE_OPEN_AI  # type: ignore


class KnowledgeSourceReference(_Model):
    """Reference to a knowledge source.

    :ivar name: The name of the knowledge source. Required.
    :vartype name: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the knowledge source. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LanguageDetectionSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Text.LanguageDetectionSkill"):
    """A skill that detects the language of input text and reports a single language code for every
    document submitted on the request. The language code is paired with a score indicating the
    confidence of the analysis.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_country_hint: A country code to use as a hint to the language detection model if
     it cannot disambiguate the language.
    :vartype default_country_hint: str
    :ivar model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :vartype model_version: str
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Text.LanguageDetectionSkill".
    :vartype odata_type: str
    """

    default_country_hint: Optional[str] = rest_field(
        name="defaultCountryHint", visibility=["read", "create", "update", "delete", "query"]
    )
    """A country code to use as a hint to the language detection model if it cannot disambiguate the
     language."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The version of the model to use when calling the Text Analytics service. It will default to the
     latest available when not specified. We recommend you do not specify this value unless
     absolutely necessary."""
    odata_type: Literal["#Microsoft.Skills.Text.LanguageDetectionSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Text.LanguageDetectionSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_country_hint: Optional[str] = None,
        model_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Text.LanguageDetectionSkill"  # type: ignore


class LengthTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.LengthTokenFilter"):
    """Removes words that are too long or too short. This token filter is implemented using Apache
    Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar min_length: The minimum length in characters. Default is 0. Maximum is 300. Must be less
     than the value of max.
    :vartype min_length: int
    :ivar max_length: The maximum length in characters. Default and maximum is 300.
    :vartype max_length: int
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.LengthTokenFilter".
    :vartype odata_type: str
    """

    min_length: Optional[int] = rest_field(name="min", visibility=["read", "create", "update", "delete", "query"])
    """The minimum length in characters. Default is 0. Maximum is 300. Must be less than the value of
     max."""
    max_length: Optional[int] = rest_field(name="max", visibility=["read", "create", "update", "delete", "query"])
    """The maximum length in characters. Default and maximum is 300."""
    odata_type: Literal["#Microsoft.Azure.Search.LengthTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.LengthTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        min_length: Optional[int] = None,
        max_length: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.LengthTokenFilter"  # type: ignore


class LimitTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.LimitTokenFilter"):
    """Limits the number of tokens while indexing. This token filter is implemented using Apache
    Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar max_token_count: The maximum number of tokens to produce. Default is 1.
    :vartype max_token_count: int
    :ivar consume_all_tokens: A value indicating whether all tokens from the input must be consumed
     even if maxTokenCount is reached. Default is false.
    :vartype consume_all_tokens: bool
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.LimitTokenFilter".
    :vartype odata_type: str
    """

    max_token_count: Optional[int] = rest_field(
        name="maxTokenCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of tokens to produce. Default is 1."""
    consume_all_tokens: Optional[bool] = rest_field(
        name="consumeAllTokens", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether all tokens from the input must be consumed even if maxTokenCount is
     reached. Default is false."""
    odata_type: Literal["#Microsoft.Azure.Search.LimitTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.LimitTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        max_token_count: Optional[int] = None,
        consume_all_tokens: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.LimitTokenFilter"  # type: ignore


class ListDataSourcesResult(_Model):
    """Response from a List Datasources request. If successful, it includes the full definitions of
    all datasources.

    :ivar data_sources: The datasources in the Search service. Required.
    :vartype data_sources:
     list[~azure.search.documents.indexes.models.SearchIndexerDataSourceConnection]
    """

    data_sources: list["_models.SearchIndexerDataSourceConnection"] = rest_field(name="value", visibility=["read"])
    """The datasources in the Search service. Required."""


class ListIndexersResult(_Model):
    """Response from a List Indexers request. If successful, it includes the full definitions of all
    indexers.

    :ivar indexers: The indexers in the Search service. Required.
    :vartype indexers: list[~azure.search.documents.indexes.models.SearchIndexer]
    """

    indexers: list["_models.SearchIndexer"] = rest_field(name="value", visibility=["read"])
    """The indexers in the Search service. Required."""


class ListSkillsetsResult(_Model):
    """Response from a list skillset request. If successful, it includes the full definitions of all
    skillsets.

    :ivar skillsets: The skillsets defined in the Search service. Required.
    :vartype skillsets: list[~azure.search.documents.indexes.models.SearchIndexerSkillset]
    """

    skillsets: list["_models.SearchIndexerSkillset"] = rest_field(name="value", visibility=["read"])
    """The skillsets defined in the Search service. Required."""


class ListSynonymMapsResult(_Model):
    """Response from a List SynonymMaps request. If successful, it includes the full definitions of
    all synonym maps.

    :ivar synonym_maps: The synonym maps in the Search service. Required.
    :vartype synonym_maps: list[~azure.search.documents.indexes.models.SynonymMap]
    """

    synonym_maps: list["_models.SynonymMap"] = rest_field(name="value", visibility=["read"])
    """The synonym maps in the Search service. Required."""


class LuceneStandardAnalyzer(LexicalAnalyzer, discriminator="#Microsoft.Azure.Search.StandardAnalyzer"):
    """Standard Apache Lucene analyzer; Composed of the standard tokenizer, lowercase filter and stop
    filter.

    :ivar name: The name of the analyzer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar max_token_length: The maximum token length. Default is 255. Tokens longer than the
     maximum length are split. The maximum token length that can be used is 300 characters.
    :vartype max_token_length: int
    :ivar stopwords: A list of stopwords.
    :vartype stopwords: list[str]
    :ivar odata_type: A URI fragment specifying the type of analyzer. Required. Default value is
     "#Microsoft.Azure.Search.StandardAnalyzer".
    :vartype odata_type: str
    """

    max_token_length: Optional[int] = rest_field(
        name="maxTokenLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum token length. Default is 255. Tokens longer than the maximum length are split. The
     maximum token length that can be used is 300 characters."""
    stopwords: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of stopwords."""
    odata_type: Literal["#Microsoft.Azure.Search.StandardAnalyzer"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of analyzer. Required. Default value is
     \"#Microsoft.Azure.Search.StandardAnalyzer\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        max_token_length: Optional[int] = None,
        stopwords: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.StandardAnalyzer"  # type: ignore


class LuceneStandardTokenizer(LexicalTokenizer, discriminator="#Microsoft.Azure.Search.StandardTokenizer"):
    """Breaks text following the Unicode Text Segmentation rules. This tokenizer is implemented using
    Apache Lucene.

    :ivar name: The name of the tokenizer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar max_token_length: The maximum token length. Default is 255. Tokens longer than the
     maximum length are split.
    :vartype max_token_length: int
    :ivar odata_type: A URI fragment specifying the type of tokenizer. Required. Default value is
     "#Microsoft.Azure.Search.StandardTokenizer".
    :vartype odata_type: str
    """

    max_token_length: Optional[int] = rest_field(
        name="maxTokenLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum token length. Default is 255. Tokens longer than the maximum length are split."""
    odata_type: Literal["#Microsoft.Azure.Search.StandardTokenizer"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of tokenizer. Required. Default value is
     \"#Microsoft.Azure.Search.StandardTokenizer\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        max_token_length: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.StandardTokenizer"  # type: ignore


class LuceneStandardTokenizerV2(LexicalTokenizer, discriminator="#Microsoft.Azure.Search.StandardTokenizerV2"):
    """Breaks text following the Unicode Text Segmentation rules. This tokenizer is implemented using
    Apache Lucene.

    :ivar name: The name of the tokenizer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar max_token_length: The maximum token length. Default is 255. Tokens longer than the
     maximum length are split. The maximum token length that can be used is 300 characters.
    :vartype max_token_length: int
    :ivar odata_type: A URI fragment specifying the type of tokenizer. Required. Default value is
     "#Microsoft.Azure.Search.StandardTokenizerV2".
    :vartype odata_type: str
    """

    max_token_length: Optional[int] = rest_field(
        name="maxTokenLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum token length. Default is 255. Tokens longer than the maximum length are split. The
     maximum token length that can be used is 300 characters."""
    odata_type: Literal["#Microsoft.Azure.Search.StandardTokenizerV2"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of tokenizer. Required. Default value is
     \"#Microsoft.Azure.Search.StandardTokenizerV2\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        max_token_length: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.StandardTokenizerV2"  # type: ignore


class MagnitudeScoringFunction(ScoringFunction, discriminator="magnitude"):
    """Defines a function that boosts scores based on the magnitude of a numeric field.

    :ivar field_name: The name of the field used as input to the scoring function. Required.
    :vartype field_name: str
    :ivar boost: A multiplier for the raw score. Must be a positive number not equal to 1.0.
     Required.
    :vartype boost: float
    :ivar interpolation: A value indicating how boosting will be interpolated across document
     scores; defaults to "Linear". Known values are: "linear", "constant", "quadratic", and
     "logarithmic".
    :vartype interpolation: str or
     ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
    :ivar parameters: Parameter values for the magnitude scoring function. Required.
    :vartype parameters: ~azure.search.documents.indexes.models.MagnitudeScoringParameters
    :ivar type: Indicates the type of function to use. Valid values include magnitude, freshness,
     distance, and tag. The function type must be lower case. Required. Default value is
     "magnitude".
    :vartype type: str
    """

    parameters: "_models.MagnitudeScoringParameters" = rest_field(
        name="magnitude", visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameter values for the magnitude scoring function. Required."""
    type: Literal["magnitude"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Indicates the type of function to use. Valid values include magnitude, freshness, distance, and
     tag. The function type must be lower case. Required. Default value is \"magnitude\"."""

    @overload
    def __init__(
        self,
        *,
        field_name: str,
        boost: float,
        parameters: "_models.MagnitudeScoringParameters",
        interpolation: Optional[Union[str, "_models.ScoringFunctionInterpolation"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = "magnitude"  # type: ignore


class MagnitudeScoringParameters(_Model):
    """Provides parameter values to a magnitude scoring function.

    :ivar boosting_range_start: The field value at which boosting starts. Required.
    :vartype boosting_range_start: float
    :ivar boosting_range_end: The field value at which boosting ends. Required.
    :vartype boosting_range_end: float
    :ivar should_boost_beyond_range_by_constant: A value indicating whether to apply a constant
     boost for field values beyond the range end value; default is false.
    :vartype should_boost_beyond_range_by_constant: bool
    """

    boosting_range_start: float = rest_field(
        name="boostingRangeStart", visibility=["read", "create", "update", "delete", "query"]
    )
    """The field value at which boosting starts. Required."""
    boosting_range_end: float = rest_field(
        name="boostingRangeEnd", visibility=["read", "create", "update", "delete", "query"]
    )
    """The field value at which boosting ends. Required."""
    should_boost_beyond_range_by_constant: Optional[bool] = rest_field(
        name="constantBoostBeyondRange", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to apply a constant boost for field values beyond the range end
     value; default is false."""

    @overload
    def __init__(
        self,
        *,
        boosting_range_start: float,
        boosting_range_end: float,
        should_boost_beyond_range_by_constant: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MappingCharFilter(CharFilter, discriminator="#Microsoft.Azure.Search.MappingCharFilter"):
    """A character filter that applies mappings defined with the mappings option. Matching is greedy
    (longest pattern matching at a given point wins). Replacement is allowed to be the empty
    string. This character filter is implemented using Apache Lucene.

    :ivar name: The name of the char filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar mappings: A list of mappings of the following format: "a=>b" (all occurrences of the
     character "a" will be replaced with character "b"). Required.
    :vartype mappings: list[str]
    :ivar odata_type: A URI fragment specifying the type of char filter. Required. Default value is
     "#Microsoft.Azure.Search.MappingCharFilter".
    :vartype odata_type: str
    """

    mappings: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of mappings of the following format: \"a=>b\" (all occurrences of the character \"a\"
     will be replaced with character \"b\"). Required."""
    odata_type: Literal["#Microsoft.Azure.Search.MappingCharFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of char filter. Required. Default value is
     \"#Microsoft.Azure.Search.MappingCharFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        mappings: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.MappingCharFilter"  # type: ignore


class MergeSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Text.MergeSkill"):
    """A skill for merging two or more strings into a single unified string, with an optional
    user-defined delimiter separating each component part.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar insert_pre_tag: The tag indicates the start of the merged text. By default, the tag is an
     empty space.
    :vartype insert_pre_tag: str
    :ivar insert_post_tag: The tag indicates the end of the merged text. By default, the tag is an
     empty space.
    :vartype insert_post_tag: str
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Text.MergeSkill".
    :vartype odata_type: str
    """

    insert_pre_tag: Optional[str] = rest_field(
        name="insertPreTag", visibility=["read", "create", "update", "delete", "query"]
    )
    """The tag indicates the start of the merged text. By default, the tag is an empty space."""
    insert_post_tag: Optional[str] = rest_field(
        name="insertPostTag", visibility=["read", "create", "update", "delete", "query"]
    )
    """The tag indicates the end of the merged text. By default, the tag is an empty space."""
    odata_type: Literal["#Microsoft.Skills.Text.MergeSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Text.MergeSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        insert_pre_tag: Optional[str] = None,
        insert_post_tag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Text.MergeSkill"  # type: ignore


class MicrosoftLanguageStemmingTokenizer(
    LexicalTokenizer, discriminator="#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer"
):
    """Divides text using language-specific rules and reduces words to their base forms.

    :ivar name: The name of the tokenizer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar max_token_length: The maximum token length. Tokens longer than the maximum length are
     split. Maximum token length that can be used is 300 characters. Tokens longer than 300
     characters are first split into tokens of length 300 and then each of those tokens is split
     based on the max token length set. Default is 255.
    :vartype max_token_length: int
    :ivar is_search_tokenizer: A value indicating how the tokenizer is used. Set to true if used as
     the search tokenizer, set to false if used as the indexing tokenizer. Default is false.
    :vartype is_search_tokenizer: bool
    :ivar language: The language to use. The default is English. Known values are: "arabic",
     "bangla", "bulgarian", "catalan", "croatian", "czech", "danish", "dutch", "english",
     "estonian", "finnish", "french", "german", "greek", "gujarati", "hebrew", "hindi", "hungarian",
     "icelandic", "indonesian", "italian", "kannada", "latvian", "lithuanian", "malay", "malayalam",
     "marathi", "norwegianBokmaal", "polish", "portuguese", "portugueseBrazilian", "punjabi",
     "romanian", "russian", "serbianCyrillic", "serbianLatin", "slovak", "slovenian", "spanish",
     "swedish", "tamil", "telugu", "turkish", "ukrainian", and "urdu".
    :vartype language: str or
     ~azure.search.documents.indexes.models.MicrosoftStemmingTokenizerLanguage
    :ivar odata_type: A URI fragment specifying the type of tokenizer. Required. Default value is
     "#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer".
    :vartype odata_type: str
    """

    max_token_length: Optional[int] = rest_field(
        name="maxTokenLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum token length. Tokens longer than the maximum length are split. Maximum token length
     that can be used is 300 characters. Tokens longer than 300 characters are first split into
     tokens of length 300 and then each of those tokens is split based on the max token length set.
     Default is 255."""
    is_search_tokenizer: Optional[bool] = rest_field(
        name="isSearchTokenizer", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating how the tokenizer is used. Set to true if used as the search tokenizer, set
     to false if used as the indexing tokenizer. Default is false."""
    language: Optional[Union[str, "_models.MicrosoftStemmingTokenizerLanguage"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The language to use. The default is English. Known values are: \"arabic\", \"bangla\",
     \"bulgarian\", \"catalan\", \"croatian\", \"czech\", \"danish\", \"dutch\", \"english\",
     \"estonian\", \"finnish\", \"french\", \"german\", \"greek\", \"gujarati\", \"hebrew\",
     \"hindi\", \"hungarian\", \"icelandic\", \"indonesian\", \"italian\", \"kannada\", \"latvian\",
     \"lithuanian\", \"malay\", \"malayalam\", \"marathi\", \"norwegianBokmaal\", \"polish\",
     \"portuguese\", \"portugueseBrazilian\", \"punjabi\", \"romanian\", \"russian\",
     \"serbianCyrillic\", \"serbianLatin\", \"slovak\", \"slovenian\", \"spanish\", \"swedish\",
     \"tamil\", \"telugu\", \"turkish\", \"ukrainian\", and \"urdu\"."""
    odata_type: Literal["#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of tokenizer. Required. Default value is
     \"#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        max_token_length: Optional[int] = None,
        is_search_tokenizer: Optional[bool] = None,
        language: Optional[Union[str, "_models.MicrosoftStemmingTokenizerLanguage"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer"  # type: ignore


class MicrosoftLanguageTokenizer(LexicalTokenizer, discriminator="#Microsoft.Azure.Search.MicrosoftLanguageTokenizer"):
    """Divides text using language-specific rules.

    :ivar name: The name of the tokenizer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar max_token_length: The maximum token length. Tokens longer than the maximum length are
     split. Maximum token length that can be used is 300 characters. Tokens longer than 300
     characters are first split into tokens of length 300 and then each of those tokens is split
     based on the max token length set. Default is 255.
    :vartype max_token_length: int
    :ivar is_search_tokenizer: A value indicating how the tokenizer is used. Set to true if used as
     the search tokenizer, set to false if used as the indexing tokenizer. Default is false.
    :vartype is_search_tokenizer: bool
    :ivar language: The language to use. The default is English. Known values are: "bangla",
     "bulgarian", "catalan", "chineseSimplified", "chineseTraditional", "croatian", "czech",
     "danish", "dutch", "english", "french", "german", "greek", "gujarati", "hindi", "icelandic",
     "indonesian", "italian", "japanese", "kannada", "korean", "malay", "malayalam", "marathi",
     "norwegianBokmaal", "polish", "portuguese", "portugueseBrazilian", "punjabi", "romanian",
     "russian", "serbianCyrillic", "serbianLatin", "slovenian", "spanish", "swedish", "tamil",
     "telugu", "thai", "ukrainian", "urdu", and "vietnamese".
    :vartype language: str or ~azure.search.documents.indexes.models.MicrosoftTokenizerLanguage
    :ivar odata_type: A URI fragment specifying the type of tokenizer. Required. Default value is
     "#Microsoft.Azure.Search.MicrosoftLanguageTokenizer".
    :vartype odata_type: str
    """

    max_token_length: Optional[int] = rest_field(
        name="maxTokenLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum token length. Tokens longer than the maximum length are split. Maximum token length
     that can be used is 300 characters. Tokens longer than 300 characters are first split into
     tokens of length 300 and then each of those tokens is split based on the max token length set.
     Default is 255."""
    is_search_tokenizer: Optional[bool] = rest_field(
        name="isSearchTokenizer", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating how the tokenizer is used. Set to true if used as the search tokenizer, set
     to false if used as the indexing tokenizer. Default is false."""
    language: Optional[Union[str, "_models.MicrosoftTokenizerLanguage"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The language to use. The default is English. Known values are: \"bangla\", \"bulgarian\",
     \"catalan\", \"chineseSimplified\", \"chineseTraditional\", \"croatian\", \"czech\",
     \"danish\", \"dutch\", \"english\", \"french\", \"german\", \"greek\", \"gujarati\", \"hindi\",
     \"icelandic\", \"indonesian\", \"italian\", \"japanese\", \"kannada\", \"korean\", \"malay\",
     \"malayalam\", \"marathi\", \"norwegianBokmaal\", \"polish\", \"portuguese\",
     \"portugueseBrazilian\", \"punjabi\", \"romanian\", \"russian\", \"serbianCyrillic\",
     \"serbianLatin\", \"slovenian\", \"spanish\", \"swedish\", \"tamil\", \"telugu\", \"thai\",
     \"ukrainian\", \"urdu\", and \"vietnamese\"."""
    odata_type: Literal["#Microsoft.Azure.Search.MicrosoftLanguageTokenizer"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of tokenizer. Required. Default value is
     \"#Microsoft.Azure.Search.MicrosoftLanguageTokenizer\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        max_token_length: Optional[int] = None,
        is_search_tokenizer: Optional[bool] = None,
        language: Optional[Union[str, "_models.MicrosoftTokenizerLanguage"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.MicrosoftLanguageTokenizer"  # type: ignore


class NativeBlobSoftDeleteDeletionDetectionPolicy(
    DataDeletionDetectionPolicy, discriminator="#Microsoft.Azure.Search.NativeBlobSoftDeleteDeletionDetectionPolicy"
):  # pylint: disable=name-too-long
    """Defines a data deletion detection policy utilizing Azure Blob Storage's native soft delete
    feature for deletion detection.

    :ivar odata_type: A URI fragment specifying the type of data deletion detection policy.
     Required. Default value is
     "#Microsoft.Azure.Search.NativeBlobSoftDeleteDeletionDetectionPolicy".
    :vartype odata_type: str
    """

    odata_type: Literal["#Microsoft.Azure.Search.NativeBlobSoftDeleteDeletionDetectionPolicy"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of data deletion detection policy. Required. Default value
     is \"#Microsoft.Azure.Search.NativeBlobSoftDeleteDeletionDetectionPolicy\"."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.NativeBlobSoftDeleteDeletionDetectionPolicy"  # type: ignore


class NGramTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.NGramTokenFilter"):
    """Generates n-grams of the given size(s). This token filter is implemented using Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar min_gram: The minimum n-gram length. Default is 1. Must be less than the value of
     maxGram.
    :vartype min_gram: int
    :ivar max_gram: The maximum n-gram length. Default is 2.
    :vartype max_gram: int
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.NGramTokenFilter".
    :vartype odata_type: str
    """

    min_gram: Optional[int] = rest_field(name="minGram", visibility=["read", "create", "update", "delete", "query"])
    """The minimum n-gram length. Default is 1. Must be less than the value of maxGram."""
    max_gram: Optional[int] = rest_field(name="maxGram", visibility=["read", "create", "update", "delete", "query"])
    """The maximum n-gram length. Default is 2."""
    odata_type: Literal["#Microsoft.Azure.Search.NGramTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.NGramTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        min_gram: Optional[int] = None,
        max_gram: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.NGramTokenFilter"  # type: ignore


class NGramTokenFilterV2(TokenFilter, discriminator="#Microsoft.Azure.Search.NGramTokenFilterV2"):
    """Generates n-grams of the given size(s). This token filter is implemented using Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar min_gram: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the
     value of maxGram.
    :vartype min_gram: int
    :ivar max_gram: The maximum n-gram length. Default is 2. Maximum is 300.
    :vartype max_gram: int
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.NGramTokenFilterV2".
    :vartype odata_type: str
    """

    min_gram: Optional[int] = rest_field(name="minGram", visibility=["read", "create", "update", "delete", "query"])
    """The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the value of
     maxGram."""
    max_gram: Optional[int] = rest_field(name="maxGram", visibility=["read", "create", "update", "delete", "query"])
    """The maximum n-gram length. Default is 2. Maximum is 300."""
    odata_type: Literal["#Microsoft.Azure.Search.NGramTokenFilterV2"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.NGramTokenFilterV2\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        min_gram: Optional[int] = None,
        max_gram: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.NGramTokenFilterV2"  # type: ignore


class NGramTokenizer(LexicalTokenizer, discriminator="#Microsoft.Azure.Search.NGramTokenizer"):
    """Tokenizes the input into n-grams of the given size(s). This tokenizer is implemented using
    Apache Lucene.

    :ivar name: The name of the tokenizer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar min_gram: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the
     value of maxGram.
    :vartype min_gram: int
    :ivar max_gram: The maximum n-gram length. Default is 2. Maximum is 300.
    :vartype max_gram: int
    :ivar token_chars: Character classes to keep in the tokens.
    :vartype token_chars: list[str or ~azure.search.documents.indexes.models.TokenCharacterKind]
    :ivar odata_type: A URI fragment specifying the type of tokenizer. Required. Default value is
     "#Microsoft.Azure.Search.NGramTokenizer".
    :vartype odata_type: str
    """

    min_gram: Optional[int] = rest_field(name="minGram", visibility=["read", "create", "update", "delete", "query"])
    """The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the value of
     maxGram."""
    max_gram: Optional[int] = rest_field(name="maxGram", visibility=["read", "create", "update", "delete", "query"])
    """The maximum n-gram length. Default is 2. Maximum is 300."""
    token_chars: Optional[list[Union[str, "_models.TokenCharacterKind"]]] = rest_field(
        name="tokenChars", visibility=["read", "create", "update", "delete", "query"]
    )
    """Character classes to keep in the tokens."""
    odata_type: Literal["#Microsoft.Azure.Search.NGramTokenizer"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of tokenizer. Required. Default value is
     \"#Microsoft.Azure.Search.NGramTokenizer\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        min_gram: Optional[int] = None,
        max_gram: Optional[int] = None,
        token_chars: Optional[list[Union[str, "_models.TokenCharacterKind"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.NGramTokenizer"  # type: ignore


class OcrSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Vision.OcrSkill"):
    """A skill that extracts text from image files.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is ``en``.
     Known values are: "af", "sq", "anp", "ar", "ast", "awa", "az", "bfy", "eu", "be", "be-cyrl",
     "be-latn", "bho", "bi", "brx", "bs", "bra", "br", "bg", "bns", "bua", "ca", "ceb", "rab", "ch",
     "hne", "zh-Hans", "zh-Hant", "kw", "co", "crh", "hr", "cs", "da", "prs", "dhi", "doi", "nl",
     "en", "myv", "et", "fo", "fj", "fil", "fi", "fr", "fur", "gag", "gl", "de", "gil", "gon", "el",
     "kl", "gvr", "ht", "hlb", "hni", "bgc", "haw", "hi", "mww", "hoc", "hu", "is", "smn", "id",
     "ia", "iu", "ga", "it", "ja", "Jns", "jv", "kea", "kac", "xnr", "krc", "kaa-cyrl", "kaa",
     "csb", "kk-cyrl", "kk-latn", "klr", "kha", "quc", "ko", "kfq", "kpy", "kos", "kum", "ku-arab",
     "ku-latn", "kru", "ky", "lkt", "la", "lt", "dsb", "smj", "lb", "bfz", "ms", "mt", "kmj", "gv",
     "mi", "mr", "mn", "cnr-cyrl", "cnr-latn", "nap", "ne", "niu", "nog", "sme", "nb", "no", "oc",
     "os", "ps", "fa", "pl", "pt", "pa", "ksh", "ro", "rm", "ru", "sck", "sm", "sa", "sat", "sco",
     "gd", "sr", "sr-Cyrl", "sr-Latn", "xsr", "srx", "sms", "sk", "sl", "so", "sma", "es", "sw",
     "sv", "tg", "tt", "tet", "thf", "to", "tr", "tk", "tyv", "hsb", "ur", "ug", "uz-arab",
     "uz-cyrl", "uz", "vo", "wae", "cy", "fy", "yua", "za", "zu", and "unk".
    :vartype default_language_code: str or ~azure.search.documents.indexes.models.OcrSkillLanguage
    :ivar should_detect_orientation: A value indicating to turn orientation detection on or not.
     Default is false.
    :vartype should_detect_orientation: bool
    :ivar line_ending: Defines the sequence of characters to use between the lines of text
     recognized by the OCR skill. The default value is "space". Known values are: "space",
     "carriageReturn", "lineFeed", and "carriageReturnLineFeed".
    :vartype line_ending: str or ~azure.search.documents.indexes.models.OcrLineEnding
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Vision.OcrSkill".
    :vartype odata_type: str
    """

    default_language_code: Optional[Union[str, "_models.OcrSkillLanguage"]] = rest_field(
        name="defaultLanguageCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating which language code to use. Default is ``en``. Known values are: \"af\",
     \"sq\", \"anp\", \"ar\", \"ast\", \"awa\", \"az\", \"bfy\", \"eu\", \"be\", \"be-cyrl\",
     \"be-latn\", \"bho\", \"bi\", \"brx\", \"bs\", \"bra\", \"br\", \"bg\", \"bns\", \"bua\",
     \"ca\", \"ceb\", \"rab\", \"ch\", \"hne\", \"zh-Hans\", \"zh-Hant\", \"kw\", \"co\", \"crh\",
     \"hr\", \"cs\", \"da\", \"prs\", \"dhi\", \"doi\", \"nl\", \"en\", \"myv\", \"et\", \"fo\",
     \"fj\", \"fil\", \"fi\", \"fr\", \"fur\", \"gag\", \"gl\", \"de\", \"gil\", \"gon\", \"el\",
     \"kl\", \"gvr\", \"ht\", \"hlb\", \"hni\", \"bgc\", \"haw\", \"hi\", \"mww\", \"hoc\", \"hu\",
     \"is\", \"smn\", \"id\", \"ia\", \"iu\", \"ga\", \"it\", \"ja\", \"Jns\", \"jv\", \"kea\",
     \"kac\", \"xnr\", \"krc\", \"kaa-cyrl\", \"kaa\", \"csb\", \"kk-cyrl\", \"kk-latn\", \"klr\",
     \"kha\", \"quc\", \"ko\", \"kfq\", \"kpy\", \"kos\", \"kum\", \"ku-arab\", \"ku-latn\",
     \"kru\", \"ky\", \"lkt\", \"la\", \"lt\", \"dsb\", \"smj\", \"lb\", \"bfz\", \"ms\", \"mt\",
     \"kmj\", \"gv\", \"mi\", \"mr\", \"mn\", \"cnr-cyrl\", \"cnr-latn\", \"nap\", \"ne\", \"niu\",
     \"nog\", \"sme\", \"nb\", \"no\", \"oc\", \"os\", \"ps\", \"fa\", \"pl\", \"pt\", \"pa\",
     \"ksh\", \"ro\", \"rm\", \"ru\", \"sck\", \"sm\", \"sa\", \"sat\", \"sco\", \"gd\", \"sr\",
     \"sr-Cyrl\", \"sr-Latn\", \"xsr\", \"srx\", \"sms\", \"sk\", \"sl\", \"so\", \"sma\", \"es\",
     \"sw\", \"sv\", \"tg\", \"tt\", \"tet\", \"thf\", \"to\", \"tr\", \"tk\", \"tyv\", \"hsb\",
     \"ur\", \"ug\", \"uz-arab\", \"uz-cyrl\", \"uz\", \"vo\", \"wae\", \"cy\", \"fy\", \"yua\",
     \"za\", \"zu\", and \"unk\"."""
    should_detect_orientation: Optional[bool] = rest_field(
        name="detectOrientation", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating to turn orientation detection on or not. Default is false."""
    line_ending: Optional[Union[str, "_models.OcrLineEnding"]] = rest_field(
        name="lineEnding", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the sequence of characters to use between the lines of text recognized by the OCR
     skill. The default value is \"space\". Known values are: \"space\", \"carriageReturn\",
     \"lineFeed\", and \"carriageReturnLineFeed\"."""
    odata_type: Literal["#Microsoft.Skills.Vision.OcrSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Vision.OcrSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[Union[str, "_models.OcrSkillLanguage"]] = None,
        should_detect_orientation: Optional[bool] = None,
        line_ending: Optional[Union[str, "_models.OcrLineEnding"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Vision.OcrSkill"  # type: ignore


class OutputFieldMappingEntry(_Model):
    """Output field mapping for a skill.

    :ivar name: The name of the output defined by the skill. Required.
    :vartype name: str
    :ivar target_name: The target name of the output. It is optional and default to name.
    :vartype target_name: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the output defined by the skill. Required."""
    target_name: Optional[str] = rest_field(
        name="targetName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The target name of the output. It is optional and default to name."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        target_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PathHierarchyTokenizerV2(LexicalTokenizer, discriminator="#Microsoft.Azure.Search.PathHierarchyTokenizerV2"):
    """Tokenizer for path-like hierarchies. This tokenizer is implemented using Apache Lucene.

    :ivar name: The name of the tokenizer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar delimiter: The delimiter character to use. Default is "/".
    :vartype delimiter: str
    :ivar replacement: A value that, if set, replaces the delimiter character. Default is "/".
    :vartype replacement: str
    :ivar max_token_length: The maximum token length. Default and maximum is 300.
    :vartype max_token_length: int
    :ivar reverse_token_order: A value indicating whether to generate tokens in reverse order.
     Default is false.
    :vartype reverse_token_order: bool
    :ivar number_of_tokens_to_skip: The number of initial tokens to skip. Default is 0.
    :vartype number_of_tokens_to_skip: int
    :ivar odata_type: A URI fragment specifying the type of tokenizer. Required. Default value is
     "#Microsoft.Azure.Search.PathHierarchyTokenizerV2".
    :vartype odata_type: str
    """

    delimiter: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The delimiter character to use. Default is \"/\"."""
    replacement: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A value that, if set, replaces the delimiter character. Default is \"/\"."""
    max_token_length: Optional[int] = rest_field(
        name="maxTokenLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum token length. Default and maximum is 300."""
    reverse_token_order: Optional[bool] = rest_field(
        name="reverse", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to generate tokens in reverse order. Default is false."""
    number_of_tokens_to_skip: Optional[int] = rest_field(
        name="skip", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of initial tokens to skip. Default is 0."""
    odata_type: Literal["#Microsoft.Azure.Search.PathHierarchyTokenizerV2"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of tokenizer. Required. Default value is
     \"#Microsoft.Azure.Search.PathHierarchyTokenizerV2\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        delimiter: Optional[str] = None,
        replacement: Optional[str] = None,
        max_token_length: Optional[int] = None,
        reverse_token_order: Optional[bool] = None,
        number_of_tokens_to_skip: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.PathHierarchyTokenizerV2"  # type: ignore


class PatternAnalyzer(LexicalAnalyzer, discriminator="#Microsoft.Azure.Search.PatternAnalyzer"):
    """Flexibly separates text into terms via a regular expression pattern. This analyzer is
    implemented using Apache Lucene.

    :ivar name: The name of the analyzer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar lower_case_terms: A value indicating whether terms should be lower-cased. Default is
     true.
    :vartype lower_case_terms: bool
    :ivar pattern: A regular expression pattern to match token separators. Default is an expression
     that matches one or more non-word characters.
    :vartype pattern: str
    :ivar flags: Regular expression flags, specified as a '|' separated string of RegexFlags
     values.
    :vartype flags: list[str or ~azure.search.documents.indexes.models.RegexFlags]
    :ivar stopwords: A list of stopwords.
    :vartype stopwords: list[str]
    :ivar odata_type: A URI fragment specifying the type of analyzer. Required. Default value is
     "#Microsoft.Azure.Search.PatternAnalyzer".
    :vartype odata_type: str
    """

    lower_case_terms: Optional[bool] = rest_field(
        name="lowercase", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether terms should be lower-cased. Default is true."""
    pattern: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A regular expression pattern to match token separators. Default is an expression that matches
     one or more non-word characters."""
    flags: Optional[list[Union[str, "_models.RegexFlags"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="pipeDelimited"
    )
    """Regular expression flags, specified as a '|' separated string of RegexFlags values."""
    stopwords: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of stopwords."""
    odata_type: Literal["#Microsoft.Azure.Search.PatternAnalyzer"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of analyzer. Required. Default value is
     \"#Microsoft.Azure.Search.PatternAnalyzer\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        lower_case_terms: Optional[bool] = None,
        pattern: Optional[str] = None,
        flags: Optional[list[Union[str, "_models.RegexFlags"]]] = None,
        stopwords: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.PatternAnalyzer"  # type: ignore


class PatternCaptureTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.PatternCaptureTokenFilter"):
    """Uses Java regexes to emit multiple tokens - one for each capture group in one or more patterns.
    This token filter is implemented using Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar patterns: A list of patterns to match against each token. Required.
    :vartype patterns: list[str]
    :ivar preserve_original: A value indicating whether to return the original token even if one of
     the patterns matches. Default is true.
    :vartype preserve_original: bool
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.PatternCaptureTokenFilter".
    :vartype odata_type: str
    """

    patterns: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of patterns to match against each token. Required."""
    preserve_original: Optional[bool] = rest_field(
        name="preserveOriginal", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to return the original token even if one of the patterns matches.
     Default is true."""
    odata_type: Literal["#Microsoft.Azure.Search.PatternCaptureTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.PatternCaptureTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        patterns: list[str],
        preserve_original: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.PatternCaptureTokenFilter"  # type: ignore


class PatternReplaceCharFilter(CharFilter, discriminator="#Microsoft.Azure.Search.PatternReplaceCharFilter"):
    """A character filter that replaces characters in the input string. It uses a regular expression
    to identify character sequences to preserve and a replacement pattern to identify characters to
    replace. For example, given the input text "aa bb aa bb", pattern "(aa)\\\\s+(bb)", and
    replacement "$1#$2", the result would be "aa#bb aa#bb". This character filter is implemented
    using Apache Lucene.

    :ivar name: The name of the char filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar pattern: A regular expression pattern. Required.
    :vartype pattern: str
    :ivar replacement: The replacement text. Required.
    :vartype replacement: str
    :ivar odata_type: A URI fragment specifying the type of char filter. Required. Default value is
     "#Microsoft.Azure.Search.PatternReplaceCharFilter".
    :vartype odata_type: str
    """

    pattern: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A regular expression pattern. Required."""
    replacement: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The replacement text. Required."""
    odata_type: Literal["#Microsoft.Azure.Search.PatternReplaceCharFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of char filter. Required. Default value is
     \"#Microsoft.Azure.Search.PatternReplaceCharFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        pattern: str,
        replacement: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.PatternReplaceCharFilter"  # type: ignore


class PatternReplaceTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.PatternReplaceTokenFilter"):
    """A character filter that replaces characters in the input string. It uses a regular expression
    to identify character sequences to preserve and a replacement pattern to identify characters to
    replace. For example, given the input text "aa bb aa bb", pattern "(aa)\\\\s+(bb)", and
    replacement "$1#$2", the result would be "aa#bb aa#bb". This token filter is implemented using
    Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar pattern: A regular expression pattern. Required.
    :vartype pattern: str
    :ivar replacement: The replacement text. Required.
    :vartype replacement: str
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.PatternReplaceTokenFilter".
    :vartype odata_type: str
    """

    pattern: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A regular expression pattern. Required."""
    replacement: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The replacement text. Required."""
    odata_type: Literal["#Microsoft.Azure.Search.PatternReplaceTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.PatternReplaceTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        pattern: str,
        replacement: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.PatternReplaceTokenFilter"  # type: ignore


class PatternTokenizer(LexicalTokenizer, discriminator="#Microsoft.Azure.Search.PatternTokenizer"):
    """Tokenizer that uses regex pattern matching to construct distinct tokens. This tokenizer is
    implemented using Apache Lucene.

    :ivar name: The name of the tokenizer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar pattern: A regular expression pattern to match token separators. Default is an expression
     that matches one or more non-word characters.
    :vartype pattern: str
    :ivar flags: Regular expression flags, specified as a '|' separated string of RegexFlags
     values.
    :vartype flags: list[str or ~azure.search.documents.indexes.models.RegexFlags]
    :ivar group: The zero-based ordinal of the matching group in the regular expression pattern to
     extract into tokens. Use -1 if you want to use the entire pattern to split the input into
     tokens, irrespective of matching groups. Default is -1.
    :vartype group: int
    :ivar odata_type: A URI fragment specifying the type of tokenizer. Required. Default value is
     "#Microsoft.Azure.Search.PatternTokenizer".
    :vartype odata_type: str
    """

    pattern: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A regular expression pattern to match token separators. Default is an expression that matches
     one or more non-word characters."""
    flags: Optional[list[Union[str, "_models.RegexFlags"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="pipeDelimited"
    )
    """Regular expression flags, specified as a '|' separated string of RegexFlags values."""
    group: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The zero-based ordinal of the matching group in the regular expression pattern to extract into
     tokens. Use -1 if you want to use the entire pattern to split the input into tokens,
     irrespective of matching groups. Default is -1."""
    odata_type: Literal["#Microsoft.Azure.Search.PatternTokenizer"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of tokenizer. Required. Default value is
     \"#Microsoft.Azure.Search.PatternTokenizer\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        pattern: Optional[str] = None,
        flags: Optional[list[Union[str, "_models.RegexFlags"]]] = None,
        group: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.PatternTokenizer"  # type: ignore


class PhoneticTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.PhoneticTokenFilter"):
    """Create tokens for phonetic matches. This token filter is implemented using Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar encoder: The phonetic encoder to use. Default is "metaphone". Known values are:
     "metaphone", "doubleMetaphone", "soundex", "refinedSoundex", "caverphone1", "caverphone2",
     "cologne", "nysiis", "koelnerPhonetik", "haasePhonetik", and "beiderMorse".
    :vartype encoder: str or ~azure.search.documents.indexes.models.PhoneticEncoder
    :ivar replace_original_tokens: A value indicating whether encoded tokens should replace
     original tokens. If false, encoded tokens are added as synonyms. Default is true.
    :vartype replace_original_tokens: bool
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.PhoneticTokenFilter".
    :vartype odata_type: str
    """

    encoder: Optional[Union[str, "_models.PhoneticEncoder"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The phonetic encoder to use. Default is \"metaphone\". Known values are: \"metaphone\",
     \"doubleMetaphone\", \"soundex\", \"refinedSoundex\", \"caverphone1\", \"caverphone2\",
     \"cologne\", \"nysiis\", \"koelnerPhonetik\", \"haasePhonetik\", and \"beiderMorse\"."""
    replace_original_tokens: Optional[bool] = rest_field(
        name="replace", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether encoded tokens should replace original tokens. If false, encoded
     tokens are added as synonyms. Default is true."""
    odata_type: Literal["#Microsoft.Azure.Search.PhoneticTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.PhoneticTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        encoder: Optional[Union[str, "_models.PhoneticEncoder"]] = None,
        replace_original_tokens: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.PhoneticTokenFilter"  # type: ignore


class PIIDetectionSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Text.PIIDetectionSkill"):
    """Using the Text Analytics API, extracts personal information from an input text and gives you
    the option of masking it.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is ``en``.
    :vartype default_language_code: str
    :ivar minimum_precision: A value between 0 and 1 that be used to only include entities whose
     confidence score is greater than the value specified. If not set (default), or if explicitly
     set to null, all entities will be included.
    :vartype minimum_precision: float
    :ivar masking_mode: A parameter that provides various ways to mask the personal information
     detected in the input text. Default is 'none'. Known values are: "none" and "replace".
    :vartype masking_mode: str or
     ~azure.search.documents.indexes.models.PIIDetectionSkillMaskingMode
    :ivar mask: The character used to mask the text if the maskingMode parameter is set to replace.
     Default is '*'.
    :vartype mask: str
    :ivar model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :vartype model_version: str
    :ivar pii_categories: A list of PII entity categories that should be extracted and masked.
    :vartype pii_categories: list[str]
    :ivar domain: If specified, will set the PII domain to include only a subset of the entity
     categories. Possible values include: 'phi', 'none'. Default is 'none'.
    :vartype domain: str
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Text.PIIDetectionSkill".
    :vartype odata_type: str
    """

    default_language_code: Optional[str] = rest_field(
        name="defaultLanguageCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating which language code to use. Default is ``en``."""
    minimum_precision: Optional[float] = rest_field(
        name="minimumPrecision", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value between 0 and 1 that be used to only include entities whose confidence score is greater
     than the value specified. If not set (default), or if explicitly set to null, all entities will
     be included."""
    masking_mode: Optional[Union[str, "_models.PIIDetectionSkillMaskingMode"]] = rest_field(
        name="maskingMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A parameter that provides various ways to mask the personal information detected in the input
     text. Default is 'none'. Known values are: \"none\" and \"replace\"."""
    mask: Optional[str] = rest_field(
        name="maskingCharacter", visibility=["read", "create", "update", "delete", "query"]
    )
    """The character used to mask the text if the maskingMode parameter is set to replace. Default is
     '*'."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The version of the model to use when calling the Text Analytics service. It will default to the
     latest available when not specified. We recommend you do not specify this value unless
     absolutely necessary."""
    pii_categories: Optional[list[str]] = rest_field(
        name="piiCategories", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of PII entity categories that should be extracted and masked."""
    domain: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """If specified, will set the PII domain to include only a subset of the entity categories.
     Possible values include: 'phi', 'none'. Default is 'none'."""
    odata_type: Literal["#Microsoft.Skills.Text.PIIDetectionSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Text.PIIDetectionSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[str] = None,
        minimum_precision: Optional[float] = None,
        masking_mode: Optional[Union[str, "_models.PIIDetectionSkillMaskingMode"]] = None,
        mask: Optional[str] = None,
        model_version: Optional[str] = None,
        pii_categories: Optional[list[str]] = None,
        domain: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Text.PIIDetectionSkill"  # type: ignore


class RemoteSharePointKnowledgeSource(KnowledgeSource, discriminator="remoteSharePoint"):
    """Configuration for remote SharePoint knowledge source.

    :ivar name: The name of the knowledge source. Required.
    :vartype name: str
    :ivar description: Optional user-defined description.
    :vartype description: str
    :ivar e_tag: The ETag of the knowledge source.
    :vartype e_tag: str
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your knowledge source
     definition when you want full assurance that no one, not even Microsoft, can decrypt them. Once
     you have encrypted your knowledge source definition, it will always remain encrypted. The
     search service will ignore attempts to set this property to null. You can change this property
     as needed if you want to rotate your encryption key; Your knowledge source definition will be
     unaffected. Encryption with customer-managed keys is not available for free search services,
     and is only available for paid services created on or after January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :ivar kind: Required. A knowledge source that reads data from remote SharePoint.
    :vartype kind: str or ~azure.search.documents.indexes.models.REMOTE_SHARE_POINT
    :ivar remote_share_point_parameters: The parameters for the remote SharePoint knowledge source.
    :vartype remote_share_point_parameters:
     ~azure.search.documents.indexes.models.RemoteSharePointKnowledgeSourceParameters
    """

    kind: Literal[KnowledgeSourceKind.REMOTE_SHARE_POINT] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. A knowledge source that reads data from remote SharePoint."""
    remote_share_point_parameters: Optional["_models.RemoteSharePointKnowledgeSourceParameters"] = rest_field(
        name="remoteSharePointParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """The parameters for the remote SharePoint knowledge source."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        e_tag: Optional[str] = None,
        encryption_key: Optional["_models.SearchResourceEncryptionKey"] = None,
        remote_share_point_parameters: Optional["_models.RemoteSharePointKnowledgeSourceParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeSourceKind.REMOTE_SHARE_POINT  # type: ignore


class RemoteSharePointKnowledgeSourceParameters(_Model):  # pylint: disable=name-too-long
    """Parameters for remote SharePoint knowledge source.

    :ivar filter_expression: Keyword Query Language (KQL) expression with queryable SharePoint
     properties and attributes to scope the retrieval before the query runs.
    :vartype filter_expression: str
    :ivar resource_metadata: A list of metadata fields to be returned for each item in the
     response. Only retrievable metadata properties can be included in this list. By default, no
     metadata is returned.
    :vartype resource_metadata: list[str]
    :ivar container_type_id: Container ID for SharePoint Embedded connection. When this is null, it
     will use SharePoint Online.
    :vartype container_type_id: str
    """

    filter_expression: Optional[str] = rest_field(
        name="filterExpression", visibility=["read", "create", "update", "delete", "query"]
    )
    """Keyword Query Language (KQL) expression with queryable SharePoint properties and attributes to
     scope the retrieval before the query runs."""
    resource_metadata: Optional[list[str]] = rest_field(
        name="resourceMetadata", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of metadata fields to be returned for each item in the response. Only retrievable
     metadata properties can be included in this list. By default, no metadata is returned."""
    container_type_id: Optional[str] = rest_field(
        name="containerTypeId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Container ID for SharePoint Embedded connection. When this is null, it will use SharePoint
     Online."""

    @overload
    def __init__(
        self,
        *,
        filter_expression: Optional[str] = None,
        resource_metadata: Optional[list[str]] = None,
        container_type_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RescoringOptions(_Model):
    """Contains the options for rescoring.

    :ivar enable_rescoring: If set to true, after the initial search on the compressed vectors, the
     similarity scores are recalculated using the full-precision vectors. This will improve recall
     at the expense of latency.
    :vartype enable_rescoring: bool
    :ivar default_oversampling: Default oversampling factor. Oversampling retrieves a greater set
     of potential documents to offset the resolution loss due to quantization. This increases the
     set of results that will be rescored on full-precision vectors. Minimum value is 1, meaning no
     oversampling (1x). This parameter can only be set when 'enableRescoring' is true. Higher values
     improve recall at the expense of latency.
    :vartype default_oversampling: float
    :ivar rescore_storage_method: Controls the storage method for original vectors. This setting is
     immutable. Known values are: "preserveOriginals" and "discardOriginals".
    :vartype rescore_storage_method: str or
     ~azure.search.documents.indexes.models.VectorSearchCompressionRescoreStorageMethod
    """

    enable_rescoring: Optional[bool] = rest_field(
        name="enableRescoring", visibility=["read", "create", "update", "delete", "query"]
    )
    """If set to true, after the initial search on the compressed vectors, the similarity scores are
     recalculated using the full-precision vectors. This will improve recall at the expense of
     latency."""
    default_oversampling: Optional[float] = rest_field(
        name="defaultOversampling", visibility=["read", "create", "update", "delete", "query"]
    )
    """Default oversampling factor. Oversampling retrieves a greater set of potential documents to
     offset the resolution loss due to quantization. This increases the set of results that will be
     rescored on full-precision vectors. Minimum value is 1, meaning no oversampling (1x). This
     parameter can only be set when 'enableRescoring' is true. Higher values improve recall at the
     expense of latency."""
    rescore_storage_method: Optional[Union[str, "_models.VectorSearchCompressionRescoreStorageMethod"]] = rest_field(
        name="rescoreStorageMethod", visibility=["read", "create", "update", "delete", "query"]
    )
    """Controls the storage method for original vectors. This setting is immutable. Known values are:
     \"preserveOriginals\" and \"discardOriginals\"."""

    @overload
    def __init__(
        self,
        *,
        enable_rescoring: Optional[bool] = None,
        default_oversampling: Optional[float] = None,
        rescore_storage_method: Optional[Union[str, "_models.VectorSearchCompressionRescoreStorageMethod"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceCounter(_Model):
    """Represents a resource's usage and quota.

    :ivar usage: The resource usage amount. Required.
    :vartype usage: int
    :ivar quota: The resource amount quota.
    :vartype quota: int
    """

    usage: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource usage amount. Required."""
    quota: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource amount quota."""

    @overload
    def __init__(
        self,
        *,
        usage: int,
        quota: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScalarQuantizationCompression(VectorSearchCompression, discriminator="scalarQuantization"):
    """Contains configuration options specific to the scalar quantization compression method used
    during indexing and querying.

    :ivar compression_name: The name to associate with this particular configuration. Required.
    :vartype compression_name: str
    :ivar rescoring_options: Contains the options for rescoring.
    :vartype rescoring_options: ~azure.search.documents.indexes.models.RescoringOptions
    :ivar truncation_dimension: The number of dimensions to truncate the vectors to. Truncating the
     vectors reduces the size of the vectors and the amount of data that needs to be transferred
     during search. This can save storage cost and improve search performance at the expense of
     recall. It should be only used for embeddings trained with Matryoshka Representation Learning
     (MRL) such as OpenAI text-embedding-3-large (small). The default value is null, which means no
     truncation.
    :vartype truncation_dimension: int
    :ivar parameters: Contains the parameters specific to Scalar Quantization.
    :vartype parameters: ~azure.search.documents.indexes.models.ScalarQuantizationParameters
    :ivar kind: The name of the kind of compression method being configured for use with vector
     search. Required. Scalar Quantization, a type of compression method. In scalar quantization,
     the original vectors values are compressed to a narrower type by discretizing and representing
     each component of a vector using a reduced set of quantized values, thereby reducing the
     overall data size.
    :vartype kind: str or ~azure.search.documents.indexes.models.SCALAR_QUANTIZATION
    """

    parameters: Optional["_models.ScalarQuantizationParameters"] = rest_field(
        name="scalarQuantizationParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the parameters specific to Scalar Quantization."""
    kind: Literal[VectorSearchCompressionKind.SCALAR_QUANTIZATION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The name of the kind of compression method being configured for use with vector search.
     Required. Scalar Quantization, a type of compression method. In scalar quantization, the
     original vectors values are compressed to a narrower type by discretizing and representing each
     component of a vector using a reduced set of quantized values, thereby reducing the overall
     data size."""

    @overload
    def __init__(
        self,
        *,
        compression_name: str,
        rescoring_options: Optional["_models.RescoringOptions"] = None,
        truncation_dimension: Optional[int] = None,
        parameters: Optional["_models.ScalarQuantizationParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = VectorSearchCompressionKind.SCALAR_QUANTIZATION  # type: ignore


class ScalarQuantizationParameters(_Model):
    """Contains the parameters specific to Scalar Quantization.

    :ivar quantized_data_type: The quantized data type of compressed vector values. "int8"
    :vartype quantized_data_type: str or
     ~azure.search.documents.indexes.models.VectorSearchCompressionTarget
    """

    quantized_data_type: Optional[Union[str, "_models.VectorSearchCompressionTarget"]] = rest_field(
        name="quantizedDataType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The quantized data type of compressed vector values. \"int8\""""

    @overload
    def __init__(
        self,
        *,
        quantized_data_type: Optional[Union[str, "_models.VectorSearchCompressionTarget"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScoringProfile(_Model):
    """Defines parameters for a search index that influence scoring in search queries.

    :ivar name: The name of the scoring profile. Required.
    :vartype name: str
    :ivar text_weights: Parameters that boost scoring based on text matches in certain index
     fields.
    :vartype text_weights: ~azure.search.documents.indexes.models.TextWeights
    :ivar functions: The collection of functions that influence the scoring of documents.
    :vartype functions: list[~azure.search.documents.indexes.models.ScoringFunction]
    :ivar function_aggregation: A value indicating how the results of individual scoring functions
     should be combined. Defaults to "Sum". Ignored if there are no scoring functions. Known values
     are: "sum", "average", "minimum", "maximum", "firstMatching", and "product".
    :vartype function_aggregation: str or
     ~azure.search.documents.indexes.models.ScoringFunctionAggregation
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the scoring profile. Required."""
    text_weights: Optional["_models.TextWeights"] = rest_field(
        name="text", visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameters that boost scoring based on text matches in certain index fields."""
    functions: Optional[list["_models.ScoringFunction"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of functions that influence the scoring of documents."""
    function_aggregation: Optional[Union[str, "_models.ScoringFunctionAggregation"]] = rest_field(
        name="functionAggregation", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating how the results of individual scoring functions should be combined. Defaults
     to \"Sum\". Ignored if there are no scoring functions. Known values are: \"sum\", \"average\",
     \"minimum\", \"maximum\", \"firstMatching\", and \"product\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        text_weights: Optional["_models.TextWeights"] = None,
        functions: Optional[list["_models.ScoringFunction"]] = None,
        function_aggregation: Optional[Union[str, "_models.ScoringFunctionAggregation"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchAlias(_Model):
    """Represents an index alias, which describes a mapping from the alias name to an index. The alias
    name can be used in place of the index name for supported operations.

    :ivar name: The name of the alias. Required.
    :vartype name: str
    :ivar indexes: The name of the index this alias maps to. Only one index name may be specified.
     Required.
    :vartype indexes: list[str]
    :ivar e_tag: The ETag of the alias.
    :vartype e_tag: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the alias. Required."""
    indexes: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the index this alias maps to. Only one index name may be specified. Required."""
    e_tag: Optional[str] = rest_field(name="@odata.etag", visibility=["read", "create", "update", "delete", "query"])
    """The ETag of the alias."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        indexes: list[str],
        e_tag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchField(_Model):
    """Represents a field in an index definition, which describes the name, data type, and search
    behavior of a field.

    :ivar name: The name of the field, which must be unique within the fields collection of the
     index or parent field. Required.
    :vartype name: str
    :ivar type: The data type of the field. Required. Known values are: "Edm.String", "Edm.Int32",
     "Edm.Int64", "Edm.Double", "Edm.Boolean", "Edm.DateTimeOffset", "Edm.GeographyPoint",
     "Edm.ComplexType", "Edm.Single", "Edm.Half", "Edm.Int16", "Edm.SByte", and "Edm.Byte".
    :vartype type: str or ~azure.search.documents.indexes.models.SearchFieldDataType
    :ivar key: A value indicating whether the field uniquely identifies documents in the index.
     Exactly one top-level field in each index must be chosen as the key field and it must be of
     type Edm.String. Key fields can be used to look up documents directly and update or delete
     specific documents. Default is false for simple fields and null for complex fields.
    :vartype key: bool
    :ivar retrievable: A value indicating whether the field can be returned in a search result. You
     can disable this option if you want to use a field (for example, margin) as a filter, sorting,
     or scoring mechanism but do not want the field to be visible to the end user. This property
     must be true for key fields, and it must be null for complex fields. This property can be
     changed on existing fields. Enabling this property does not cause any increase in index storage
     requirements. Default is true for simple fields, false for vector fields, and null for complex
     fields.
    :vartype retrievable: bool
    :ivar stored: An immutable value indicating whether the field will be persisted separately on
     disk to be returned in a search result. You can disable this option if you don't plan to return
     the field contents in a search response to save on storage overhead. This can only be set
     during index creation and only for vector fields. This property cannot be changed for existing
     fields or set as false for new fields. If this property is set as false, the property
     'retrievable' must also be set to false. This property must be true or unset for key fields,
     for new fields, and for non-vector fields, and it must be null for complex fields. Disabling
     this property will reduce index storage requirements. The default is true for vector fields.
    :vartype stored: bool
    :ivar searchable: A value indicating whether the field is full-text searchable. This means it
     will undergo analysis such as word-breaking during indexing. If you set a searchable field to a
     value like "sunny day", internally it will be split into the individual tokens "sunny" and
     "day". This enables full-text searches for these terms. Fields of type Edm.String or
     Collection(Edm.String) are searchable by default. This property must be false for simple fields
     of other non-string data types, and it must be null for complex fields. Note: searchable fields
     consume extra space in your index to accommodate additional tokenized versions of the field
     value for full-text searches. If you want to save space in your index and you don't need a
     field to be included in searches, set searchable to false.
    :vartype searchable: bool
    :ivar filterable: A value indicating whether to enable the field to be referenced in $filter
     queries. filterable differs from searchable in how strings are handled. Fields of type
     Edm.String or Collection(Edm.String) that are filterable do not undergo word-breaking, so
     comparisons are for exact matches only. For example, if you set such a field f to "sunny day",
     $filter=f eq 'sunny' will find no matches, but $filter=f eq 'sunny day' will. This property
     must be null for complex fields. Default is true for simple fields and null for complex fields.
    :vartype filterable: bool
    :ivar sortable: A value indicating whether to enable the field to be referenced in $orderby
     expressions. By default, the search engine sorts results by score, but in many experiences
     users will want to sort by fields in the documents. A simple field can be sortable only if it
     is single-valued (it has a single value in the scope of the parent document). Simple collection
     fields cannot be sortable, since they are multi-valued. Simple sub-fields of complex
     collections are also multi-valued, and therefore cannot be sortable. This is true whether it's
     an immediate parent field, or an ancestor field, that's the complex collection. Complex fields
     cannot be sortable and the sortable property must be null for such fields. The default for
     sortable is true for single-valued simple fields, false for multi-valued simple fields, and
     null for complex fields.
    :vartype sortable: bool
    :ivar facetable: A value indicating whether to enable the field to be referenced in facet
     queries. Typically used in a presentation of search results that includes hit count by category
     (for example, search for digital cameras and see hits by brand, by megapixels, by price, and so
     on). This property must be null for complex fields. Fields of type Edm.GeographyPoint or
     Collection(Edm.GeographyPoint) cannot be facetable. Default is true for all other simple
     fields.
    :vartype facetable: bool
    :ivar permission_filter: A value indicating whether the field should be used as a permission
     filter. Known values are: "userIds", "groupIds", and "rbacScope".
    :vartype permission_filter: str or ~azure.search.documents.indexes.models.PermissionFilter
    :ivar sensitivity_label: A value indicating whether the field contains sensitivity label
     information.
    :vartype sensitivity_label: bool
    :ivar analyzer_name: The name of the analyzer to use for the field. This option can be used
     only with searchable fields and it can't be set together with either searchAnalyzer or
     indexAnalyzer. Once the analyzer is chosen, it cannot be changed for the field. Must be null
     for complex fields. Known values are: "ar.microsoft", "ar.lucene", "hy.lucene", "bn.microsoft",
     "eu.lucene", "bg.microsoft", "bg.lucene", "ca.microsoft", "ca.lucene", "zh-Hans.microsoft",
     "zh-Hans.lucene", "zh-Hant.microsoft", "zh-Hant.lucene", "hr.microsoft", "cs.microsoft",
     "cs.lucene", "da.microsoft", "da.lucene", "nl.microsoft", "nl.lucene", "en.microsoft",
     "en.lucene", "et.microsoft", "fi.microsoft", "fi.lucene", "fr.microsoft", "fr.lucene",
     "gl.lucene", "de.microsoft", "de.lucene", "el.microsoft", "el.lucene", "gu.microsoft",
     "he.microsoft", "hi.microsoft", "hi.lucene", "hu.microsoft", "hu.lucene", "is.microsoft",
     "id.microsoft", "id.lucene", "ga.lucene", "it.microsoft", "it.lucene", "ja.microsoft",
     "ja.lucene", "kn.microsoft", "ko.microsoft", "ko.lucene", "lv.microsoft", "lv.lucene",
     "lt.microsoft", "ml.microsoft", "ms.microsoft", "mr.microsoft", "nb.microsoft", "no.lucene",
     "fa.lucene", "pl.microsoft", "pl.lucene", "pt-BR.microsoft", "pt-BR.lucene", "pt-PT.microsoft",
     "pt-PT.lucene", "pa.microsoft", "ro.microsoft", "ro.lucene", "ru.microsoft", "ru.lucene",
     "sr-cyrillic.microsoft", "sr-latin.microsoft", "sk.microsoft", "sl.microsoft", "es.microsoft",
     "es.lucene", "sv.microsoft", "sv.lucene", "ta.microsoft", "te.microsoft", "th.microsoft",
     "th.lucene", "tr.microsoft", "tr.lucene", "uk.microsoft", "ur.microsoft", "vi.microsoft",
     "standard.lucene", "standardasciifolding.lucene", "keyword", "pattern", "simple", "stop", and
     "whitespace".
    :vartype analyzer_name: str or ~azure.search.documents.indexes.models.LexicalAnalyzerName
    :ivar search_analyzer_name: The name of the analyzer used at search time for the field. This
     option can be used only with searchable fields. It must be set together with indexAnalyzer and
     it cannot be set together with the analyzer option. This property cannot be set to the name of
     a language analyzer; use the analyzer property instead if you need a language analyzer. This
     analyzer can be updated on an existing field. Must be null for complex fields. Known values
     are: "ar.microsoft", "ar.lucene", "hy.lucene", "bn.microsoft", "eu.lucene", "bg.microsoft",
     "bg.lucene", "ca.microsoft", "ca.lucene", "zh-Hans.microsoft", "zh-Hans.lucene",
     "zh-Hant.microsoft", "zh-Hant.lucene", "hr.microsoft", "cs.microsoft", "cs.lucene",
     "da.microsoft", "da.lucene", "nl.microsoft", "nl.lucene", "en.microsoft", "en.lucene",
     "et.microsoft", "fi.microsoft", "fi.lucene", "fr.microsoft", "fr.lucene", "gl.lucene",
     "de.microsoft", "de.lucene", "el.microsoft", "el.lucene", "gu.microsoft", "he.microsoft",
     "hi.microsoft", "hi.lucene", "hu.microsoft", "hu.lucene", "is.microsoft", "id.microsoft",
     "id.lucene", "ga.lucene", "it.microsoft", "it.lucene", "ja.microsoft", "ja.lucene",
     "kn.microsoft", "ko.microsoft", "ko.lucene", "lv.microsoft", "lv.lucene", "lt.microsoft",
     "ml.microsoft", "ms.microsoft", "mr.microsoft", "nb.microsoft", "no.lucene", "fa.lucene",
     "pl.microsoft", "pl.lucene", "pt-BR.microsoft", "pt-BR.lucene", "pt-PT.microsoft",
     "pt-PT.lucene", "pa.microsoft", "ro.microsoft", "ro.lucene", "ru.microsoft", "ru.lucene",
     "sr-cyrillic.microsoft", "sr-latin.microsoft", "sk.microsoft", "sl.microsoft", "es.microsoft",
     "es.lucene", "sv.microsoft", "sv.lucene", "ta.microsoft", "te.microsoft", "th.microsoft",
     "th.lucene", "tr.microsoft", "tr.lucene", "uk.microsoft", "ur.microsoft", "vi.microsoft",
     "standard.lucene", "standardasciifolding.lucene", "keyword", "pattern", "simple", "stop", and
     "whitespace".
    :vartype search_analyzer_name: str or
     ~azure.search.documents.indexes.models.LexicalAnalyzerName
    :ivar index_analyzer_name: The name of the analyzer used at indexing time for the field. This
     option can be used only with searchable fields. It must be set together with searchAnalyzer and
     it cannot be set together with the analyzer option.  This property cannot be set to the name of
     a language analyzer; use the analyzer property instead if you need a language analyzer. Once
     the analyzer is chosen, it cannot be changed for the field. Must be null for complex fields.
     Known values are: "ar.microsoft", "ar.lucene", "hy.lucene", "bn.microsoft", "eu.lucene",
     "bg.microsoft", "bg.lucene", "ca.microsoft", "ca.lucene", "zh-Hans.microsoft",
     "zh-Hans.lucene", "zh-Hant.microsoft", "zh-Hant.lucene", "hr.microsoft", "cs.microsoft",
     "cs.lucene", "da.microsoft", "da.lucene", "nl.microsoft", "nl.lucene", "en.microsoft",
     "en.lucene", "et.microsoft", "fi.microsoft", "fi.lucene", "fr.microsoft", "fr.lucene",
     "gl.lucene", "de.microsoft", "de.lucene", "el.microsoft", "el.lucene", "gu.microsoft",
     "he.microsoft", "hi.microsoft", "hi.lucene", "hu.microsoft", "hu.lucene", "is.microsoft",
     "id.microsoft", "id.lucene", "ga.lucene", "it.microsoft", "it.lucene", "ja.microsoft",
     "ja.lucene", "kn.microsoft", "ko.microsoft", "ko.lucene", "lv.microsoft", "lv.lucene",
     "lt.microsoft", "ml.microsoft", "ms.microsoft", "mr.microsoft", "nb.microsoft", "no.lucene",
     "fa.lucene", "pl.microsoft", "pl.lucene", "pt-BR.microsoft", "pt-BR.lucene", "pt-PT.microsoft",
     "pt-PT.lucene", "pa.microsoft", "ro.microsoft", "ro.lucene", "ru.microsoft", "ru.lucene",
     "sr-cyrillic.microsoft", "sr-latin.microsoft", "sk.microsoft", "sl.microsoft", "es.microsoft",
     "es.lucene", "sv.microsoft", "sv.lucene", "ta.microsoft", "te.microsoft", "th.microsoft",
     "th.lucene", "tr.microsoft", "tr.lucene", "uk.microsoft", "ur.microsoft", "vi.microsoft",
     "standard.lucene", "standardasciifolding.lucene", "keyword", "pattern", "simple", "stop", and
     "whitespace".
    :vartype index_analyzer_name: str or ~azure.search.documents.indexes.models.LexicalAnalyzerName
    :ivar normalizer_name: The name of the normalizer to use for the field. This option can be used
     only with fields with filterable, sortable, or facetable enabled. Once the normalizer is
     chosen, it cannot be changed for the field. Must be null for complex fields. Known values are:
     "asciifolding", "elision", "lowercase", "standard", and "uppercase".
    :vartype normalizer_name: str or ~azure.search.documents.indexes.models.LexicalNormalizerName
    :ivar vector_search_dimensions: The dimensionality of the vector field.
    :vartype vector_search_dimensions: int
    :ivar vector_search_profile_name: The name of the vector search profile that specifies the
     algorithm and vectorizer to use when searching the vector field.
    :vartype vector_search_profile_name: str
    :ivar vector_encoding_format: The encoding format to interpret the field contents. "packedBit"
    :vartype vector_encoding_format: str or
     ~azure.search.documents.indexes.models.VectorEncodingFormat
    :ivar synonym_map_names: A list of the names of synonym maps to associate with this field. This
     option can be used only with searchable fields. Currently only one synonym map per field is
     supported. Assigning a synonym map to a field ensures that query terms targeting that field are
     expanded at query-time using the rules in the synonym map. This attribute can be changed on
     existing fields. Must be null or an empty collection for complex fields.
    :vartype synonym_map_names: list[str]
    :ivar fields: A list of sub-fields if this is a field of type Edm.ComplexType or
     Collection(Edm.ComplexType). Must be null or empty for simple fields.
    :vartype fields: list[~azure.search.documents.indexes.models.SearchField]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the field, which must be unique within the fields collection of the index or parent
     field. Required."""
    type: Union[str, "_models.SearchFieldDataType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The data type of the field. Required. Known values are: \"Edm.String\", \"Edm.Int32\",
     \"Edm.Int64\", \"Edm.Double\", \"Edm.Boolean\", \"Edm.DateTimeOffset\", \"Edm.GeographyPoint\",
     \"Edm.ComplexType\", \"Edm.Single\", \"Edm.Half\", \"Edm.Int16\", \"Edm.SByte\", and
     \"Edm.Byte\"."""
    key: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A value indicating whether the field uniquely identifies documents in the index. Exactly one
     top-level field in each index must be chosen as the key field and it must be of type
     Edm.String. Key fields can be used to look up documents directly and update or delete specific
     documents. Default is false for simple fields and null for complex fields."""
    retrievable: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A value indicating whether the field can be returned in a search result. You can disable this
     option if you want to use a field (for example, margin) as a filter, sorting, or scoring
     mechanism but do not want the field to be visible to the end user. This property must be true
     for key fields, and it must be null for complex fields. This property can be changed on
     existing fields. Enabling this property does not cause any increase in index storage
     requirements. Default is true for simple fields, false for vector fields, and null for complex
     fields."""
    stored: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An immutable value indicating whether the field will be persisted separately on disk to be
     returned in a search result. You can disable this option if you don't plan to return the field
     contents in a search response to save on storage overhead. This can only be set during index
     creation and only for vector fields. This property cannot be changed for existing fields or set
     as false for new fields. If this property is set as false, the property 'retrievable' must also
     be set to false. This property must be true or unset for key fields, for new fields, and for
     non-vector fields, and it must be null for complex fields. Disabling this property will reduce
     index storage requirements. The default is true for vector fields."""
    searchable: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A value indicating whether the field is full-text searchable. This means it will undergo
     analysis such as word-breaking during indexing. If you set a searchable field to a value like
     \"sunny day\", internally it will be split into the individual tokens \"sunny\" and \"day\".
     This enables full-text searches for these terms. Fields of type Edm.String or
     Collection(Edm.String) are searchable by default. This property must be false for simple fields
     of other non-string data types, and it must be null for complex fields. Note: searchable fields
     consume extra space in your index to accommodate additional tokenized versions of the field
     value for full-text searches. If you want to save space in your index and you don't need a
     field to be included in searches, set searchable to false."""
    filterable: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A value indicating whether to enable the field to be referenced in $filter queries. filterable
     differs from searchable in how strings are handled. Fields of type Edm.String or
     Collection(Edm.String) that are filterable do not undergo word-breaking, so comparisons are for
     exact matches only. For example, if you set such a field f to \"sunny day\", $filter=f eq
     'sunny' will find no matches, but $filter=f eq 'sunny day' will. This property must be null for
     complex fields. Default is true for simple fields and null for complex fields."""
    sortable: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A value indicating whether to enable the field to be referenced in $orderby expressions. By
     default, the search engine sorts results by score, but in many experiences users will want to
     sort by fields in the documents. A simple field can be sortable only if it is single-valued (it
     has a single value in the scope of the parent document). Simple collection fields cannot be
     sortable, since they are multi-valued. Simple sub-fields of complex collections are also
     multi-valued, and therefore cannot be sortable. This is true whether it's an immediate parent
     field, or an ancestor field, that's the complex collection. Complex fields cannot be sortable
     and the sortable property must be null for such fields. The default for sortable is true for
     single-valued simple fields, false for multi-valued simple fields, and null for complex fields."""
    facetable: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A value indicating whether to enable the field to be referenced in facet queries. Typically
     used in a presentation of search results that includes hit count by category (for example,
     search for digital cameras and see hits by brand, by megapixels, by price, and so on). This
     property must be null for complex fields. Fields of type Edm.GeographyPoint or
     Collection(Edm.GeographyPoint) cannot be facetable. Default is true for all other simple
     fields."""
    permission_filter: Optional[Union[str, "_models.PermissionFilter"]] = rest_field(
        name="permissionFilter", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether the field should be used as a permission filter. Known values are:
     \"userIds\", \"groupIds\", and \"rbacScope\"."""
    sensitivity_label: Optional[bool] = rest_field(
        name="sensitivityLabel", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether the field contains sensitivity label information."""
    analyzer_name: Optional[Union[str, "_models.LexicalAnalyzerName"]] = rest_field(
        name="analyzer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the analyzer to use for the field. This option can be used only with searchable
     fields and it can't be set together with either searchAnalyzer or indexAnalyzer. Once the
     analyzer is chosen, it cannot be changed for the field. Must be null for complex fields. Known
     values are: \"ar.microsoft\", \"ar.lucene\", \"hy.lucene\", \"bn.microsoft\", \"eu.lucene\",
     \"bg.microsoft\", \"bg.lucene\", \"ca.microsoft\", \"ca.lucene\", \"zh-Hans.microsoft\",
     \"zh-Hans.lucene\", \"zh-Hant.microsoft\", \"zh-Hant.lucene\", \"hr.microsoft\",
     \"cs.microsoft\", \"cs.lucene\", \"da.microsoft\", \"da.lucene\", \"nl.microsoft\",
     \"nl.lucene\", \"en.microsoft\", \"en.lucene\", \"et.microsoft\", \"fi.microsoft\",
     \"fi.lucene\", \"fr.microsoft\", \"fr.lucene\", \"gl.lucene\", \"de.microsoft\", \"de.lucene\",
     \"el.microsoft\", \"el.lucene\", \"gu.microsoft\", \"he.microsoft\", \"hi.microsoft\",
     \"hi.lucene\", \"hu.microsoft\", \"hu.lucene\", \"is.microsoft\", \"id.microsoft\",
     \"id.lucene\", \"ga.lucene\", \"it.microsoft\", \"it.lucene\", \"ja.microsoft\", \"ja.lucene\",
     \"kn.microsoft\", \"ko.microsoft\", \"ko.lucene\", \"lv.microsoft\", \"lv.lucene\",
     \"lt.microsoft\", \"ml.microsoft\", \"ms.microsoft\", \"mr.microsoft\", \"nb.microsoft\",
     \"no.lucene\", \"fa.lucene\", \"pl.microsoft\", \"pl.lucene\", \"pt-BR.microsoft\",
     \"pt-BR.lucene\", \"pt-PT.microsoft\", \"pt-PT.lucene\", \"pa.microsoft\", \"ro.microsoft\",
     \"ro.lucene\", \"ru.microsoft\", \"ru.lucene\", \"sr-cyrillic.microsoft\",
     \"sr-latin.microsoft\", \"sk.microsoft\", \"sl.microsoft\", \"es.microsoft\", \"es.lucene\",
     \"sv.microsoft\", \"sv.lucene\", \"ta.microsoft\", \"te.microsoft\", \"th.microsoft\",
     \"th.lucene\", \"tr.microsoft\", \"tr.lucene\", \"uk.microsoft\", \"ur.microsoft\",
     \"vi.microsoft\", \"standard.lucene\", \"standardasciifolding.lucene\", \"keyword\",
     \"pattern\", \"simple\", \"stop\", and \"whitespace\"."""
    search_analyzer_name: Optional[Union[str, "_models.LexicalAnalyzerName"]] = rest_field(
        name="searchAnalyzer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the analyzer used at search time for the field. This option can be used only with
     searchable fields. It must be set together with indexAnalyzer and it cannot be set together
     with the analyzer option. This property cannot be set to the name of a language analyzer; use
     the analyzer property instead if you need a language analyzer. This analyzer can be updated on
     an existing field. Must be null for complex fields. Known values are: \"ar.microsoft\",
     \"ar.lucene\", \"hy.lucene\", \"bn.microsoft\", \"eu.lucene\", \"bg.microsoft\", \"bg.lucene\",
     \"ca.microsoft\", \"ca.lucene\", \"zh-Hans.microsoft\", \"zh-Hans.lucene\",
     \"zh-Hant.microsoft\", \"zh-Hant.lucene\", \"hr.microsoft\", \"cs.microsoft\", \"cs.lucene\",
     \"da.microsoft\", \"da.lucene\", \"nl.microsoft\", \"nl.lucene\", \"en.microsoft\",
     \"en.lucene\", \"et.microsoft\", \"fi.microsoft\", \"fi.lucene\", \"fr.microsoft\",
     \"fr.lucene\", \"gl.lucene\", \"de.microsoft\", \"de.lucene\", \"el.microsoft\", \"el.lucene\",
     \"gu.microsoft\", \"he.microsoft\", \"hi.microsoft\", \"hi.lucene\", \"hu.microsoft\",
     \"hu.lucene\", \"is.microsoft\", \"id.microsoft\", \"id.lucene\", \"ga.lucene\",
     \"it.microsoft\", \"it.lucene\", \"ja.microsoft\", \"ja.lucene\", \"kn.microsoft\",
     \"ko.microsoft\", \"ko.lucene\", \"lv.microsoft\", \"lv.lucene\", \"lt.microsoft\",
     \"ml.microsoft\", \"ms.microsoft\", \"mr.microsoft\", \"nb.microsoft\", \"no.lucene\",
     \"fa.lucene\", \"pl.microsoft\", \"pl.lucene\", \"pt-BR.microsoft\", \"pt-BR.lucene\",
     \"pt-PT.microsoft\", \"pt-PT.lucene\", \"pa.microsoft\", \"ro.microsoft\", \"ro.lucene\",
     \"ru.microsoft\", \"ru.lucene\", \"sr-cyrillic.microsoft\", \"sr-latin.microsoft\",
     \"sk.microsoft\", \"sl.microsoft\", \"es.microsoft\", \"es.lucene\", \"sv.microsoft\",
     \"sv.lucene\", \"ta.microsoft\", \"te.microsoft\", \"th.microsoft\", \"th.lucene\",
     \"tr.microsoft\", \"tr.lucene\", \"uk.microsoft\", \"ur.microsoft\", \"vi.microsoft\",
     \"standard.lucene\", \"standardasciifolding.lucene\", \"keyword\", \"pattern\", \"simple\",
     \"stop\", and \"whitespace\"."""
    index_analyzer_name: Optional[Union[str, "_models.LexicalAnalyzerName"]] = rest_field(
        name="indexAnalyzer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the analyzer used at indexing time for the field. This option can be used only with
     searchable fields. It must be set together with searchAnalyzer and it cannot be set together
     with the analyzer option.  This property cannot be set to the name of a language analyzer; use
     the analyzer property instead if you need a language analyzer. Once the analyzer is chosen, it
     cannot be changed for the field. Must be null for complex fields. Known values are:
     \"ar.microsoft\", \"ar.lucene\", \"hy.lucene\", \"bn.microsoft\", \"eu.lucene\",
     \"bg.microsoft\", \"bg.lucene\", \"ca.microsoft\", \"ca.lucene\", \"zh-Hans.microsoft\",
     \"zh-Hans.lucene\", \"zh-Hant.microsoft\", \"zh-Hant.lucene\", \"hr.microsoft\",
     \"cs.microsoft\", \"cs.lucene\", \"da.microsoft\", \"da.lucene\", \"nl.microsoft\",
     \"nl.lucene\", \"en.microsoft\", \"en.lucene\", \"et.microsoft\", \"fi.microsoft\",
     \"fi.lucene\", \"fr.microsoft\", \"fr.lucene\", \"gl.lucene\", \"de.microsoft\", \"de.lucene\",
     \"el.microsoft\", \"el.lucene\", \"gu.microsoft\", \"he.microsoft\", \"hi.microsoft\",
     \"hi.lucene\", \"hu.microsoft\", \"hu.lucene\", \"is.microsoft\", \"id.microsoft\",
     \"id.lucene\", \"ga.lucene\", \"it.microsoft\", \"it.lucene\", \"ja.microsoft\", \"ja.lucene\",
     \"kn.microsoft\", \"ko.microsoft\", \"ko.lucene\", \"lv.microsoft\", \"lv.lucene\",
     \"lt.microsoft\", \"ml.microsoft\", \"ms.microsoft\", \"mr.microsoft\", \"nb.microsoft\",
     \"no.lucene\", \"fa.lucene\", \"pl.microsoft\", \"pl.lucene\", \"pt-BR.microsoft\",
     \"pt-BR.lucene\", \"pt-PT.microsoft\", \"pt-PT.lucene\", \"pa.microsoft\", \"ro.microsoft\",
     \"ro.lucene\", \"ru.microsoft\", \"ru.lucene\", \"sr-cyrillic.microsoft\",
     \"sr-latin.microsoft\", \"sk.microsoft\", \"sl.microsoft\", \"es.microsoft\", \"es.lucene\",
     \"sv.microsoft\", \"sv.lucene\", \"ta.microsoft\", \"te.microsoft\", \"th.microsoft\",
     \"th.lucene\", \"tr.microsoft\", \"tr.lucene\", \"uk.microsoft\", \"ur.microsoft\",
     \"vi.microsoft\", \"standard.lucene\", \"standardasciifolding.lucene\", \"keyword\",
     \"pattern\", \"simple\", \"stop\", and \"whitespace\"."""
    normalizer_name: Optional[Union[str, "_models.LexicalNormalizerName"]] = rest_field(
        name="normalizer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the normalizer to use for the field. This option can be used only with fields with
     filterable, sortable, or facetable enabled. Once the normalizer is chosen, it cannot be changed
     for the field. Must be null for complex fields. Known values are: \"asciifolding\",
     \"elision\", \"lowercase\", \"standard\", and \"uppercase\"."""
    vector_search_dimensions: Optional[int] = rest_field(
        name="dimensions", visibility=["read", "create", "update", "delete", "query"]
    )
    """The dimensionality of the vector field."""
    vector_search_profile_name: Optional[str] = rest_field(
        name="vectorSearchProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the vector search profile that specifies the algorithm and vectorizer to use when
     searching the vector field."""
    vector_encoding_format: Optional[Union[str, "_models.VectorEncodingFormat"]] = rest_field(
        name="vectorEncoding", visibility=["read", "create", "update", "delete", "query"]
    )
    """The encoding format to interpret the field contents. \"packedBit\""""
    synonym_map_names: Optional[list[str]] = rest_field(
        name="synonymMaps", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of the names of synonym maps to associate with this field. This option can be used only
     with searchable fields. Currently only one synonym map per field is supported. Assigning a
     synonym map to a field ensures that query terms targeting that field are expanded at query-time
     using the rules in the synonym map. This attribute can be changed on existing fields. Must be
     null or an empty collection for complex fields."""
    fields: Optional[list["_models.SearchField"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of sub-fields if this is a field of type Edm.ComplexType or Collection(Edm.ComplexType).
     Must be null or empty for simple fields."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.SearchFieldDataType"],
        key: Optional[bool] = None,
        retrievable: Optional[bool] = None,
        stored: Optional[bool] = None,
        searchable: Optional[bool] = None,
        filterable: Optional[bool] = None,
        sortable: Optional[bool] = None,
        facetable: Optional[bool] = None,
        permission_filter: Optional[Union[str, "_models.PermissionFilter"]] = None,
        sensitivity_label: Optional[bool] = None,
        analyzer_name: Optional[Union[str, "_models.LexicalAnalyzerName"]] = None,
        search_analyzer_name: Optional[Union[str, "_models.LexicalAnalyzerName"]] = None,
        index_analyzer_name: Optional[Union[str, "_models.LexicalAnalyzerName"]] = None,
        normalizer_name: Optional[Union[str, "_models.LexicalNormalizerName"]] = None,
        vector_search_dimensions: Optional[int] = None,
        vector_search_profile_name: Optional[str] = None,
        vector_encoding_format: Optional[Union[str, "_models.VectorEncodingFormat"]] = None,
        synonym_map_names: Optional[list[str]] = None,
        fields: Optional[list["_models.SearchField"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndex(_Model):
    """Represents a search index definition, which describes the fields and search behavior of an
    index.

    :ivar name: The name of the index. Required.
    :vartype name: str
    :ivar description: The description of the index.
    :vartype description: str
    :ivar fields: The fields of the index. Required.
    :vartype fields: list[~azure.search.documents.indexes.models.SearchField]
    :ivar scoring_profiles: The scoring profiles for the index.
    :vartype scoring_profiles: list[~azure.search.documents.indexes.models.ScoringProfile]
    :ivar default_scoring_profile: The name of the scoring profile to use if none is specified in
     the query. If this property is not set and no scoring profile is specified in the query, then
     default scoring (tf-idf) will be used.
    :vartype default_scoring_profile: str
    :ivar cors_options: Options to control Cross-Origin Resource Sharing (CORS) for the index.
    :vartype cors_options: ~azure.search.documents.indexes.models.CorsOptions
    :ivar suggesters: The suggesters for the index.
    :vartype suggesters: list[~azure.search.documents.indexes.models.SearchSuggester]
    :ivar analyzers: The analyzers for the index.
    :vartype analyzers: list[~azure.search.documents.indexes.models.LexicalAnalyzer]
    :ivar tokenizers: The tokenizers for the index.
    :vartype tokenizers: list[~azure.search.documents.indexes.models.LexicalTokenizer]
    :ivar token_filters: The token filters for the index.
    :vartype token_filters: list[~azure.search.documents.indexes.models.TokenFilter]
    :ivar char_filters: The character filters for the index.
    :vartype char_filters: list[~azure.search.documents.indexes.models.CharFilter]
    :ivar normalizers: The normalizers for the index.
    :vartype normalizers: list[~azure.search.documents.indexes.models.LexicalNormalizer]
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your data when you
     want full assurance that no one, not even Microsoft, can decrypt your data. Once you have
     encrypted your data, it will always remain encrypted. The search service will ignore attempts
     to set this property to null. You can change this property as needed if you want to rotate your
     encryption key; Your data will be unaffected. Encryption with customer-managed keys is not
     available for free search services, and is only available for paid services created on or after
     January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :ivar similarity: The type of similarity algorithm to be used when scoring and ranking the
     documents matching a search query. The similarity algorithm can only be defined at index
     creation time and cannot be modified on existing indexes. If null, the ClassicSimilarity
     algorithm is used.
    :vartype similarity: ~azure.search.documents.indexes.models.SimilarityAlgorithm
    :ivar semantic_search: Defines parameters for a search index that influence semantic
     capabilities.
    :vartype semantic_search: ~azure.search.documents.indexes.models.SemanticSearch
    :ivar vector_search: Contains configuration options related to vector search.
    :vartype vector_search: ~azure.search.documents.indexes.models.VectorSearch
    :ivar permission_filter_option: A value indicating whether permission filtering is enabled for
     the index. Known values are: "enabled" and "disabled".
    :vartype permission_filter_option: str or
     ~azure.search.documents.indexes.models.SearchIndexPermissionFilterOption
    :ivar purview_enabled: A value indicating whether Purview is enabled for the index.
    :vartype purview_enabled: bool
    :ivar e_tag: The ETag of the index.
    :vartype e_tag: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the index. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description of the index."""
    fields: list["_models.SearchField"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The fields of the index. Required."""
    scoring_profiles: Optional[list["_models.ScoringProfile"]] = rest_field(
        name="scoringProfiles", visibility=["read", "create", "update", "delete", "query"]
    )
    """The scoring profiles for the index."""
    default_scoring_profile: Optional[str] = rest_field(
        name="defaultScoringProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the scoring profile to use if none is specified in the query. If this property is
     not set and no scoring profile is specified in the query, then default scoring (tf-idf) will be
     used."""
    cors_options: Optional["_models.CorsOptions"] = rest_field(
        name="corsOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Options to control Cross-Origin Resource Sharing (CORS) for the index."""
    suggesters: Optional[list["_models.SearchSuggester"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The suggesters for the index."""
    analyzers: Optional[list["_models.LexicalAnalyzer"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The analyzers for the index."""
    tokenizers: Optional[list["_models.LexicalTokenizer"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The tokenizers for the index."""
    token_filters: Optional[list["_models.TokenFilter"]] = rest_field(
        name="tokenFilters", visibility=["read", "create", "update", "delete", "query"]
    )
    """The token filters for the index."""
    char_filters: Optional[list["_models.CharFilter"]] = rest_field(
        name="charFilters", visibility=["read", "create", "update", "delete", "query"]
    )
    """The character filters for the index."""
    normalizers: Optional[list["_models.LexicalNormalizer"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The normalizers for the index."""
    encryption_key: Optional["_models.SearchResourceEncryptionKey"] = rest_field(
        name="encryptionKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """A description of an encryption key that you create in Azure Key Vault. This key is used to
     provide an additional level of encryption-at-rest for your data when you want full assurance
     that no one, not even Microsoft, can decrypt your data. Once you have encrypted your data, it
     will always remain encrypted. The search service will ignore attempts to set this property to
     null. You can change this property as needed if you want to rotate your encryption key; Your
     data will be unaffected. Encryption with customer-managed keys is not available for free search
     services, and is only available for paid services created on or after January 1, 2019."""
    similarity: Optional["_models.SimilarityAlgorithm"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of similarity algorithm to be used when scoring and ranking the documents matching a
     search query. The similarity algorithm can only be defined at index creation time and cannot be
     modified on existing indexes. If null, the ClassicSimilarity algorithm is used."""
    semantic_search: Optional["_models.SemanticSearch"] = rest_field(
        name="semantic", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines parameters for a search index that influence semantic capabilities."""
    vector_search: Optional["_models.VectorSearch"] = rest_field(
        name="vectorSearch", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains configuration options related to vector search."""
    permission_filter_option: Optional[Union[str, "_models.SearchIndexPermissionFilterOption"]] = rest_field(
        name="permissionFilterOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether permission filtering is enabled for the index. Known values are:
     \"enabled\" and \"disabled\"."""
    purview_enabled: Optional[bool] = rest_field(
        name="purviewEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether Purview is enabled for the index."""
    e_tag: Optional[str] = rest_field(name="@odata.etag", visibility=["read", "create", "update", "delete", "query"])
    """The ETag of the index."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        fields: list["_models.SearchField"],
        description: Optional[str] = None,
        scoring_profiles: Optional[list["_models.ScoringProfile"]] = None,
        default_scoring_profile: Optional[str] = None,
        cors_options: Optional["_models.CorsOptions"] = None,
        suggesters: Optional[list["_models.SearchSuggester"]] = None,
        analyzers: Optional[list["_models.LexicalAnalyzer"]] = None,
        tokenizers: Optional[list["_models.LexicalTokenizer"]] = None,
        token_filters: Optional[list["_models.TokenFilter"]] = None,
        char_filters: Optional[list["_models.CharFilter"]] = None,
        normalizers: Optional[list["_models.LexicalNormalizer"]] = None,
        encryption_key: Optional["_models.SearchResourceEncryptionKey"] = None,
        similarity: Optional["_models.SimilarityAlgorithm"] = None,
        semantic_search: Optional["_models.SemanticSearch"] = None,
        vector_search: Optional["_models.VectorSearch"] = None,
        permission_filter_option: Optional[Union[str, "_models.SearchIndexPermissionFilterOption"]] = None,
        purview_enabled: Optional[bool] = None,
        e_tag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexer(_Model):
    """Represents an indexer.

    :ivar name: The name of the indexer. Required.
    :vartype name: str
    :ivar description: The description of the indexer.
    :vartype description: str
    :ivar data_source_name: The name of the datasource from which this indexer reads data.
     Required.
    :vartype data_source_name: str
    :ivar skillset_name: The name of the skillset executing with this indexer.
    :vartype skillset_name: str
    :ivar target_index_name: The name of the index to which this indexer writes data. Required.
    :vartype target_index_name: str
    :ivar schedule: The schedule for this indexer.
    :vartype schedule: ~azure.search.documents.indexes.models.IndexingSchedule
    :ivar parameters: Parameters for indexer execution.
    :vartype parameters: ~azure.search.documents.indexes.models.IndexingParameters
    :ivar field_mappings: Defines mappings between fields in the data source and corresponding
     target fields in the index.
    :vartype field_mappings: list[~azure.search.documents.indexes.models.FieldMapping]
    :ivar output_field_mappings: Output field mappings are applied after enrichment and immediately
     before indexing.
    :vartype output_field_mappings: list[~azure.search.documents.indexes.models.FieldMapping]
    :ivar is_disabled: A value indicating whether the indexer is disabled. Default is false.
    :vartype is_disabled: bool
    :ivar e_tag: The ETag of the indexer.
    :vartype e_tag: str
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your indexer
     definition (as well as indexer execution status) when you want full assurance that no one, not
     even Microsoft, can decrypt them. Once you have encrypted your indexer definition, it will
     always remain encrypted. The search service will ignore attempts to set this property to null.
     You can change this property as needed if you want to rotate your encryption key; Your indexer
     definition (and indexer execution status) will be unaffected. Encryption with customer-managed
     keys is not available for free search services, and is only available for paid services created
     on or after January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :ivar cache: Adds caching to an enrichment pipeline to allow for incremental modification steps
     without having to rebuild the index every time.
    :vartype cache: ~azure.search.documents.indexes.models.SearchIndexerCache
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the indexer. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description of the indexer."""
    data_source_name: str = rest_field(
        name="dataSourceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the datasource from which this indexer reads data. Required."""
    skillset_name: Optional[str] = rest_field(
        name="skillsetName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the skillset executing with this indexer."""
    target_index_name: str = rest_field(
        name="targetIndexName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the index to which this indexer writes data. Required."""
    schedule: Optional["_models.IndexingSchedule"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The schedule for this indexer."""
    parameters: Optional["_models.IndexingParameters"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameters for indexer execution."""
    field_mappings: Optional[list["_models.FieldMapping"]] = rest_field(
        name="fieldMappings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines mappings between fields in the data source and corresponding target fields in the
     index."""
    output_field_mappings: Optional[list["_models.FieldMapping"]] = rest_field(
        name="outputFieldMappings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Output field mappings are applied after enrichment and immediately before indexing."""
    is_disabled: Optional[bool] = rest_field(
        name="disabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether the indexer is disabled. Default is false."""
    e_tag: Optional[str] = rest_field(name="@odata.etag", visibility=["read", "create", "update", "delete", "query"])
    """The ETag of the indexer."""
    encryption_key: Optional["_models.SearchResourceEncryptionKey"] = rest_field(
        name="encryptionKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """A description of an encryption key that you create in Azure Key Vault. This key is used to
     provide an additional level of encryption-at-rest for your indexer definition (as well as
     indexer execution status) when you want full assurance that no one, not even Microsoft, can
     decrypt them. Once you have encrypted your indexer definition, it will always remain encrypted.
     The search service will ignore attempts to set this property to null. You can change this
     property as needed if you want to rotate your encryption key; Your indexer definition (and
     indexer execution status) will be unaffected. Encryption with customer-managed keys is not
     available for free search services, and is only available for paid services created on or after
     January 1, 2019."""
    cache: Optional["_models.SearchIndexerCache"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Adds caching to an enrichment pipeline to allow for incremental modification steps without
     having to rebuild the index every time."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        data_source_name: str,
        target_index_name: str,
        description: Optional[str] = None,
        skillset_name: Optional[str] = None,
        schedule: Optional["_models.IndexingSchedule"] = None,
        parameters: Optional["_models.IndexingParameters"] = None,
        field_mappings: Optional[list["_models.FieldMapping"]] = None,
        output_field_mappings: Optional[list["_models.FieldMapping"]] = None,
        is_disabled: Optional[bool] = None,
        e_tag: Optional[str] = None,
        encryption_key: Optional["_models.SearchResourceEncryptionKey"] = None,
        cache: Optional["_models.SearchIndexerCache"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerCache(_Model):
    """The type of the cache.

    :ivar id: A guid for the SearchIndexerCache.
    :vartype id: str
    :ivar storage_connection_string: The connection string to the storage account where the cache
     data will be persisted.
    :vartype storage_connection_string: str
    :ivar enable_reprocessing: Specifies whether incremental reprocessing is enabled.
    :vartype enable_reprocessing: bool
    :ivar identity: The user-assigned managed identity used for connections to the enrichment
     cache.  If the connection string indicates an identity (ResourceId) and it's not specified, the
     system-assigned managed identity is used. On updates to the indexer, if the identity is
     unspecified, the value remains unchanged. If set to "none", the value of this property is
     cleared.
    :vartype identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A guid for the SearchIndexerCache."""
    storage_connection_string: Optional[str] = rest_field(
        name="storageConnectionString", visibility=["read", "create", "update", "delete", "query"]
    )
    """The connection string to the storage account where the cache data will be persisted."""
    enable_reprocessing: Optional[bool] = rest_field(
        name="enableReprocessing", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether incremental reprocessing is enabled."""
    identity: Optional["_models.SearchIndexerDataIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The user-assigned managed identity used for connections to the enrichment cache.  If the
     connection string indicates an identity (ResourceId) and it's not specified, the
     system-assigned managed identity is used. On updates to the indexer, if the identity is
     unspecified, the value remains unchanged. If set to \"none\", the value of this property is
     cleared."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        storage_connection_string: Optional[str] = None,
        enable_reprocessing: Optional[bool] = None,
        identity: Optional["_models.SearchIndexerDataIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerDataContainer(_Model):
    """Represents information about the entity (such as Azure SQL table or CosmosDB collection) that
    will be indexed.

    :ivar name: The name of the table or view (for Azure SQL data source) or collection (for
     CosmosDB data source) that will be indexed. Required.
    :vartype name: str
    :ivar query: A query that is applied to this data container. The syntax and meaning of this
     parameter is datasource-specific. Not supported by Azure SQL datasources.
    :vartype query: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the table or view (for Azure SQL data source) or collection (for CosmosDB data
     source) that will be indexed. Required."""
    query: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A query that is applied to this data container. The syntax and meaning of this parameter is
     datasource-specific. Not supported by Azure SQL datasources."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        query: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerDataIdentity(_Model):
    """Abstract base type for data identities.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SearchIndexerDataNoneIdentity, SearchIndexerDataUserAssignedIdentity

    :ivar odata_type: A URI fragment specifying the type of identity. Required. Default value is
     None.
    :vartype odata_type: str
    """

    __mapping__: dict[str, _Model] = {}
    odata_type: str = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])
    """A URI fragment specifying the type of identity. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        odata_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerDataNoneIdentity(
    SearchIndexerDataIdentity, discriminator="#Microsoft.Azure.Search.DataNoneIdentity"
):
    """Clears the identity property of a datasource.

    :ivar odata_type: The discriminator for derived types. Required. Default value is
     "#Microsoft.Azure.Search.DataNoneIdentity".
    :vartype odata_type: str
    """

    odata_type: Literal["#Microsoft.Azure.Search.DataNoneIdentity"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator for derived types. Required. Default value is
     \"#Microsoft.Azure.Search.DataNoneIdentity\"."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.DataNoneIdentity"  # type: ignore


class SearchIndexerDataSourceConnection(_Model):
    """Represents a datasource definition, which can be used to configure an indexer.

    :ivar name: The name of the datasource. Required.
    :vartype name: str
    :ivar description: The description of the datasource.
    :vartype description: str
    :ivar type: The type of the datasource. Required. Known values are: "azuresql", "cosmosdb",
     "azureblob", "azuretable", "mysql", "adlsgen2", "onelake", and "sharepoint".
    :vartype type: str or ~azure.search.documents.indexes.models.SearchIndexerDataSourceType
    :ivar sub_type: A specific type of the data source, in case the resource is capable of
     different modalities. For example, 'MongoDb' for certain 'cosmosDb' accounts.
    :vartype sub_type: str
    :ivar credentials: Credentials for the datasource. Required.
    :vartype credentials: ~azure.search.documents.indexes.models.DataSourceCredentials
    :ivar container: The data container for the datasource. Required.
    :vartype container: ~azure.search.documents.indexes.models.SearchIndexerDataContainer
    :ivar identity: An explicit managed identity to use for this datasource. If not specified and
     the connection string is a managed identity, the system-assigned managed identity is used. If
     not specified, the value remains unchanged. If "none" is specified, the value of this property
     is cleared.
    :vartype identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
    :ivar indexer_permission_options: Ingestion options with various types of permission data.
    :vartype indexer_permission_options: list[str or
     ~azure.search.documents.indexes.models.IndexerPermissionOption]
    :ivar data_change_detection_policy: The data change detection policy for the datasource.
    :vartype data_change_detection_policy:
     ~azure.search.documents.indexes.models.DataChangeDetectionPolicy
    :ivar data_deletion_detection_policy: The data deletion detection policy for the datasource.
    :vartype data_deletion_detection_policy:
     ~azure.search.documents.indexes.models.DataDeletionDetectionPolicy
    :ivar e_tag: The ETag of the data source.
    :vartype e_tag: str
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your datasource
     definition when you want full assurance that no one, not even Microsoft, can decrypt your data
     source definition. Once you have encrypted your data source definition, it will always remain
     encrypted. The search service will ignore attempts to set this property to null. You can change
     this property as needed if you want to rotate your encryption key; Your datasource definition
     will be unaffected. Encryption with customer-managed keys is not available for free search
     services, and is only available for paid services created on or after January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the datasource. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description of the datasource."""
    type: Union[str, "_models.SearchIndexerDataSourceType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the datasource. Required. Known values are: \"azuresql\", \"cosmosdb\",
     \"azureblob\", \"azuretable\", \"mysql\", \"adlsgen2\", \"onelake\", and \"sharepoint\"."""
    sub_type: Optional[str] = rest_field(name="subType", visibility=["read"])
    """A specific type of the data source, in case the resource is capable of different modalities.
     For example, 'MongoDb' for certain 'cosmosDb' accounts."""
    credentials: "_models.DataSourceCredentials" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Credentials for the datasource. Required."""
    container: "_models.SearchIndexerDataContainer" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The data container for the datasource. Required."""
    identity: Optional["_models.SearchIndexerDataIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An explicit managed identity to use for this datasource. If not specified and the connection
     string is a managed identity, the system-assigned managed identity is used. If not specified,
     the value remains unchanged. If \"none\" is specified, the value of this property is cleared."""
    indexer_permission_options: Optional[list[Union[str, "_models.IndexerPermissionOption"]]] = rest_field(
        name="indexerPermissionOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Ingestion options with various types of permission data."""
    data_change_detection_policy: Optional["_models.DataChangeDetectionPolicy"] = rest_field(
        name="dataChangeDetectionPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The data change detection policy for the datasource."""
    data_deletion_detection_policy: Optional["_models.DataDeletionDetectionPolicy"] = rest_field(
        name="dataDeletionDetectionPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The data deletion detection policy for the datasource."""
    e_tag: Optional[str] = rest_field(name="@odata.etag", visibility=["read", "create", "update", "delete", "query"])
    """The ETag of the data source."""
    encryption_key: Optional["_models.SearchResourceEncryptionKey"] = rest_field(
        name="encryptionKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """A description of an encryption key that you create in Azure Key Vault. This key is used to
     provide an additional level of encryption-at-rest for your datasource definition when you want
     full assurance that no one, not even Microsoft, can decrypt your data source definition. Once
     you have encrypted your data source definition, it will always remain encrypted. The search
     service will ignore attempts to set this property to null. You can change this property as
     needed if you want to rotate your encryption key; Your datasource definition will be
     unaffected. Encryption with customer-managed keys is not available for free search services,
     and is only available for paid services created on or after January 1, 2019."""

    __flattened_items = ["connection_string"]

    @overload
    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.SearchIndexerDataSourceType"],
        credentials: "_models.DataSourceCredentials",
        container: "_models.SearchIndexerDataContainer",
        description: Optional[str] = None,
        identity: Optional["_models.SearchIndexerDataIdentity"] = None,
        indexer_permission_options: Optional[list[Union[str, "_models.IndexerPermissionOption"]]] = None,
        data_change_detection_policy: Optional["_models.DataChangeDetectionPolicy"] = None,
        data_deletion_detection_policy: Optional["_models.DataDeletionDetectionPolicy"] = None,
        e_tag: Optional[str] = None,
        encryption_key: Optional["_models.SearchResourceEncryptionKey"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.credentials is None:
                return None
            return getattr(self.credentials, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.credentials is None:
                self.credentials = self._attr_to_rest_field["credentials"]._class_type()
            setattr(self.credentials, key, value)
        else:
            super().__setattr__(key, value)


class SearchIndexerDataUserAssignedIdentity(
    SearchIndexerDataIdentity, discriminator="#Microsoft.Azure.Search.DataUserAssignedIdentity"
):
    """Specifies the identity for a datasource to use.

    :ivar resource_id: The fully qualified Azure resource Id of a user assigned managed identity
     typically in the form
     "/subscriptions/12345678-1234-1234-1234-1234567890ab/resourceGroups/rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId"
     that should have been assigned to the search service. Required.
    :vartype resource_id: str
    :ivar odata_type: A URI fragment specifying the type of identity. Required. Default value is
     "#Microsoft.Azure.Search.DataUserAssignedIdentity".
    :vartype odata_type: str
    """

    resource_id: str = rest_field(
        name="userAssignedIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The fully qualified Azure resource Id of a user assigned managed identity typically in the form
     \"/subscriptions/12345678-1234-1234-1234-1234567890ab/resourceGroups/rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId\"
     that should have been assigned to the search service. Required."""
    odata_type: Literal["#Microsoft.Azure.Search.DataUserAssignedIdentity"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of identity. Required. Default value is
     \"#Microsoft.Azure.Search.DataUserAssignedIdentity\"."""

    @overload
    def __init__(
        self,
        *,
        resource_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.DataUserAssignedIdentity"  # type: ignore


class SearchIndexerError(_Model):
    """Represents an item- or document-level indexing error.

    :ivar key: The key of the item for which indexing failed.
    :vartype key: str
    :ivar error_message: The message describing the error that occurred while processing the item.
     Required.
    :vartype error_message: str
    :ivar status_code: The status code indicating why the indexing operation failed. Possible
     values include: 400 for a malformed input document, 404 for document not found, 409 for a
     version conflict, 422 when the index is temporarily unavailable, or 503 for when the service is
     too busy. Required.
    :vartype status_code: int
    :ivar name: The name of the source at which the error originated. For example, this could refer
     to a particular skill in the attached skillset. This may not be always available.
    :vartype name: str
    :ivar details: Additional, verbose details about the error to assist in debugging the indexer.
     This may not be always available.
    :vartype details: str
    :ivar documentation_link: A link to a troubleshooting guide for these classes of errors. This
     may not be always available.
    :vartype documentation_link: str
    """

    key: Optional[str] = rest_field(visibility=["read"])
    """The key of the item for which indexing failed."""
    error_message: str = rest_field(name="errorMessage", visibility=["read"])
    """The message describing the error that occurred while processing the item. Required."""
    status_code: int = rest_field(name="statusCode", visibility=["read"])
    """The status code indicating why the indexing operation failed. Possible values include: 400 for
     a malformed input document, 404 for document not found, 409 for a version conflict, 422 when
     the index is temporarily unavailable, or 503 for when the service is too busy. Required."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the source at which the error originated. For example, this could refer to a
     particular skill in the attached skillset. This may not be always available."""
    details: Optional[str] = rest_field(visibility=["read"])
    """Additional, verbose details about the error to assist in debugging the indexer. This may not be
     always available."""
    documentation_link: Optional[str] = rest_field(name="documentationLink", visibility=["read"])
    """A link to a troubleshooting guide for these classes of errors. This may not be always
     available."""


class SearchIndexerIndexProjection(_Model):
    """Definition of additional projections to secondary search indexes.

    :ivar selectors: A list of projections to be performed to secondary search indexes. Required.
    :vartype selectors:
     list[~azure.search.documents.indexes.models.SearchIndexerIndexProjectionSelector]
    :ivar parameters: A dictionary of index projection-specific configuration properties. Each name
     is the name of a specific property. Each value must be of a primitive type.
    :vartype parameters:
     ~azure.search.documents.indexes.models.SearchIndexerIndexProjectionsParameters
    """

    selectors: list["_models.SearchIndexerIndexProjectionSelector"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of projections to be performed to secondary search indexes. Required."""
    parameters: Optional["_models.SearchIndexerIndexProjectionsParameters"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A dictionary of index projection-specific configuration properties. Each name is the name of a
     specific property. Each value must be of a primitive type."""

    @overload
    def __init__(
        self,
        *,
        selectors: list["_models.SearchIndexerIndexProjectionSelector"],
        parameters: Optional["_models.SearchIndexerIndexProjectionsParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerIndexProjectionSelector(_Model):
    """Description for what data to store in the designated search index.

    :ivar target_index_name: Name of the search index to project to. Must have a key field with the
     'keyword' analyzer set. Required.
    :vartype target_index_name: str
    :ivar parent_key_field_name: Name of the field in the search index to map the parent document's
     key value to. Must be a string field that is filterable and not the key field. Required.
    :vartype parent_key_field_name: str
    :ivar source_context: Source context for the projections. Represents the cardinality at which
     the document will be split into multiple sub documents. Required.
    :vartype source_context: str
    :ivar mappings: Mappings for the projection, or which source should be mapped to which field in
     the target index. Required.
    :vartype mappings: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    """

    target_index_name: str = rest_field(
        name="targetIndexName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the search index to project to. Must have a key field with the 'keyword' analyzer set.
     Required."""
    parent_key_field_name: str = rest_field(
        name="parentKeyFieldName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the field in the search index to map the parent document's key value to. Must be a
     string field that is filterable and not the key field. Required."""
    source_context: str = rest_field(name="sourceContext", visibility=["read", "create", "update", "delete", "query"])
    """Source context for the projections. Represents the cardinality at which the document will be
     split into multiple sub documents. Required."""
    mappings: list["_models.InputFieldMappingEntry"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Mappings for the projection, or which source should be mapped to which field in the target
     index. Required."""

    @overload
    def __init__(
        self,
        *,
        target_index_name: str,
        parent_key_field_name: str,
        source_context: str,
        mappings: list["_models.InputFieldMappingEntry"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerIndexProjectionsParameters(_Model):
    """A dictionary of index projection-specific configuration properties. Each name is the name of a
    specific property. Each value must be of a primitive type.

    :ivar projection_mode: Defines behavior of the index projections in relation to the rest of the
     indexer. Known values are: "skipIndexingParentDocuments" and "includeIndexingParentDocuments".
    :vartype projection_mode: str or ~azure.search.documents.indexes.models.IndexProjectionMode
    """

    projection_mode: Optional[Union[str, "_models.IndexProjectionMode"]] = rest_field(
        name="projectionMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines behavior of the index projections in relation to the rest of the indexer. Known values
     are: \"skipIndexingParentDocuments\" and \"includeIndexingParentDocuments\"."""

    @overload
    def __init__(
        self,
        *,
        projection_mode: Optional[Union[str, "_models.IndexProjectionMode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerKnowledgeStore(_Model):
    """Definition of additional projections to azure blob, table, or files, of enriched data.

    :ivar storage_connection_string: The connection string to the storage account projections will
     be stored in. Required.
    :vartype storage_connection_string: str
    :ivar projections: A list of additional projections to perform during indexing. Required.
    :vartype projections:
     list[~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreProjection]
    :ivar identity: The user-assigned managed identity used for connections to Azure Storage when
     writing knowledge store projections. If the connection string indicates an identity
     (ResourceId) and it's not specified, the system-assigned managed identity is used. On updates
     to the indexer, if the identity is unspecified, the value remains unchanged. If set to "none",
     the value of this property is cleared.
    :vartype identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
    :ivar parameters: A dictionary of knowledge store-specific configuration properties. Each name
     is the name of a specific property. Each value must be of a primitive type.
    :vartype parameters:
     ~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreParameters
    """

    storage_connection_string: str = rest_field(
        name="storageConnectionString", visibility=["read", "create", "update", "delete", "query"]
    )
    """The connection string to the storage account projections will be stored in. Required."""
    projections: list["_models.SearchIndexerKnowledgeStoreProjection"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of additional projections to perform during indexing. Required."""
    identity: Optional["_models.SearchIndexerDataIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The user-assigned managed identity used for connections to Azure Storage when writing knowledge
     store projections. If the connection string indicates an identity (ResourceId) and it's not
     specified, the system-assigned managed identity is used. On updates to the indexer, if the
     identity is unspecified, the value remains unchanged. If set to \"none\", the value of this
     property is cleared."""
    parameters: Optional["_models.SearchIndexerKnowledgeStoreParameters"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A dictionary of knowledge store-specific configuration properties. Each name is the name of a
     specific property. Each value must be of a primitive type."""

    @overload
    def __init__(
        self,
        *,
        storage_connection_string: str,
        projections: list["_models.SearchIndexerKnowledgeStoreProjection"],
        identity: Optional["_models.SearchIndexerDataIdentity"] = None,
        parameters: Optional["_models.SearchIndexerKnowledgeStoreParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerKnowledgeStoreProjectionSelector(_Model):  # pylint: disable=name-too-long
    """Abstract class to share properties between concrete selectors.

    :ivar reference_key_name: Name of reference key to different projection.
    :vartype reference_key_name: str
    :ivar generated_key_name: Name of generated key to store projection under.
    :vartype generated_key_name: str
    :ivar source: Source data to project.
    :vartype source: str
    :ivar source_context: Source context for complex projections.
    :vartype source_context: str
    :ivar inputs: Nested inputs for complex projections.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    """

    reference_key_name: Optional[str] = rest_field(
        name="referenceKeyName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of reference key to different projection."""
    generated_key_name: Optional[str] = rest_field(
        name="generatedKeyName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of generated key to store projection under."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Source data to project."""
    source_context: Optional[str] = rest_field(
        name="sourceContext", visibility=["read", "create", "update", "delete", "query"]
    )
    """Source context for complex projections."""
    inputs: Optional[list["_models.InputFieldMappingEntry"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Nested inputs for complex projections."""

    @overload
    def __init__(
        self,
        *,
        reference_key_name: Optional[str] = None,
        generated_key_name: Optional[str] = None,
        source: Optional[str] = None,
        source_context: Optional[str] = None,
        inputs: Optional[list["_models.InputFieldMappingEntry"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerKnowledgeStoreBlobProjectionSelector(
    SearchIndexerKnowledgeStoreProjectionSelector
):  # pylint: disable=name-too-long
    """Abstract class to share properties between concrete selectors.

    :ivar reference_key_name: Name of reference key to different projection.
    :vartype reference_key_name: str
    :ivar generated_key_name: Name of generated key to store projection under.
    :vartype generated_key_name: str
    :ivar source: Source data to project.
    :vartype source: str
    :ivar source_context: Source context for complex projections.
    :vartype source_context: str
    :ivar inputs: Nested inputs for complex projections.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar storage_container: Blob container to store projections in. Required.
    :vartype storage_container: str
    """

    storage_container: str = rest_field(
        name="storageContainer", visibility=["read", "create", "update", "delete", "query"]
    )
    """Blob container to store projections in. Required."""

    @overload
    def __init__(
        self,
        *,
        storage_container: str,
        reference_key_name: Optional[str] = None,
        generated_key_name: Optional[str] = None,
        source: Optional[str] = None,
        source_context: Optional[str] = None,
        inputs: Optional[list["_models.InputFieldMappingEntry"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerKnowledgeStoreFileProjectionSelector(
    SearchIndexerKnowledgeStoreBlobProjectionSelector
):  # pylint: disable=name-too-long
    """Projection definition for what data to store in Azure Files.

    :ivar reference_key_name: Name of reference key to different projection.
    :vartype reference_key_name: str
    :ivar generated_key_name: Name of generated key to store projection under.
    :vartype generated_key_name: str
    :ivar source: Source data to project.
    :vartype source: str
    :ivar source_context: Source context for complex projections.
    :vartype source_context: str
    :ivar inputs: Nested inputs for complex projections.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar storage_container: Blob container to store projections in. Required.
    :vartype storage_container: str
    """

    @overload
    def __init__(
        self,
        *,
        storage_container: str,
        reference_key_name: Optional[str] = None,
        generated_key_name: Optional[str] = None,
        source: Optional[str] = None,
        source_context: Optional[str] = None,
        inputs: Optional[list["_models.InputFieldMappingEntry"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerKnowledgeStoreObjectProjectionSelector(
    SearchIndexerKnowledgeStoreBlobProjectionSelector
):  # pylint: disable=name-too-long
    """Projection definition for what data to store in Azure Blob.

    :ivar reference_key_name: Name of reference key to different projection.
    :vartype reference_key_name: str
    :ivar generated_key_name: Name of generated key to store projection under.
    :vartype generated_key_name: str
    :ivar source: Source data to project.
    :vartype source: str
    :ivar source_context: Source context for complex projections.
    :vartype source_context: str
    :ivar inputs: Nested inputs for complex projections.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar storage_container: Blob container to store projections in. Required.
    :vartype storage_container: str
    """

    @overload
    def __init__(
        self,
        *,
        storage_container: str,
        reference_key_name: Optional[str] = None,
        generated_key_name: Optional[str] = None,
        source: Optional[str] = None,
        source_context: Optional[str] = None,
        inputs: Optional[list["_models.InputFieldMappingEntry"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerKnowledgeStoreParameters(_Model):
    """A dictionary of knowledge store-specific configuration properties. Each name is the name of a
    specific property. Each value must be of a primitive type.

    :ivar synthesize_generated_key_name: Whether or not projections should synthesize a generated
     key name if one isn't already present.
    :vartype synthesize_generated_key_name: bool
    """

    synthesize_generated_key_name: Optional[bool] = rest_field(
        name="synthesizeGeneratedKeyName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether or not projections should synthesize a generated key name if one isn't already present."""

    @overload
    def __init__(
        self,
        *,
        synthesize_generated_key_name: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerKnowledgeStoreProjection(_Model):
    """Container object for various projection selectors.

    :ivar tables: Projections to Azure Table storage.
    :vartype tables:
     list[~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreTableProjectionSelector]
    :ivar objects: Projections to Azure Blob storage.
    :vartype objects:
     list[~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreObjectProjectionSelector]
    :ivar files: Projections to Azure File storage.
    :vartype files:
     list[~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreFileProjectionSelector]
    """

    tables: Optional[list["_models.SearchIndexerKnowledgeStoreTableProjectionSelector"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Projections to Azure Table storage."""
    objects: Optional[list["_models.SearchIndexerKnowledgeStoreObjectProjectionSelector"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Projections to Azure Blob storage."""
    files: Optional[list["_models.SearchIndexerKnowledgeStoreFileProjectionSelector"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Projections to Azure File storage."""

    @overload
    def __init__(
        self,
        *,
        tables: Optional[list["_models.SearchIndexerKnowledgeStoreTableProjectionSelector"]] = None,
        objects: Optional[list["_models.SearchIndexerKnowledgeStoreObjectProjectionSelector"]] = None,
        files: Optional[list["_models.SearchIndexerKnowledgeStoreFileProjectionSelector"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerKnowledgeStoreTableProjectionSelector(
    SearchIndexerKnowledgeStoreProjectionSelector
):  # pylint: disable=name-too-long
    """Description for what data to store in Azure Tables.

    :ivar reference_key_name: Name of reference key to different projection.
    :vartype reference_key_name: str
    :ivar source: Source data to project.
    :vartype source: str
    :ivar source_context: Source context for complex projections.
    :vartype source_context: str
    :ivar inputs: Nested inputs for complex projections.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar generated_key_name: Name of generated key to store projection under. Required.
    :vartype generated_key_name: str
    :ivar table_name: Name of the Azure table to store projected data in. Required.
    :vartype table_name: str
    """

    generated_key_name: str = rest_field(
        name="generatedKeyName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of generated key to store projection under. Required."""
    table_name: str = rest_field(name="tableName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the Azure table to store projected data in. Required."""

    @overload
    def __init__(
        self,
        *,
        generated_key_name: str,
        table_name: str,
        reference_key_name: Optional[str] = None,
        source: Optional[str] = None,
        source_context: Optional[str] = None,
        inputs: Optional[list["_models.InputFieldMappingEntry"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerLimits(_Model):
    """Represents the limits that can be applied to an indexer.

    :ivar max_run_time: The maximum duration that the indexer is permitted to run for one
     execution.
    :vartype max_run_time: ~datetime.timedelta
    :ivar max_document_extraction_size: The maximum size of a document, in bytes, which will be
     considered valid for indexing.
    :vartype max_document_extraction_size: int
    :ivar max_document_content_characters_to_extract: The maximum number of characters that will be
     extracted from a document picked up for indexing.
    :vartype max_document_content_characters_to_extract: int
    """

    max_run_time: Optional[datetime.timedelta] = rest_field(name="maxRunTime", visibility=["read"])
    """The maximum duration that the indexer is permitted to run for one execution."""
    max_document_extraction_size: Optional[int] = rest_field(name="maxDocumentExtractionSize", visibility=["read"])
    """The maximum size of a document, in bytes, which will be considered valid for indexing."""
    max_document_content_characters_to_extract: Optional[int] = rest_field(
        name="maxDocumentContentCharactersToExtract", visibility=["read"]
    )
    """The maximum number of characters that will be extracted from a document picked up for indexing."""


class SearchIndexerSkillset(_Model):
    """A list of skills.

    :ivar name: The name of the skillset. Required.
    :vartype name: str
    :ivar description: The description of the skillset.
    :vartype description: str
    :ivar skills: A list of skills in the skillset. Required.
    :vartype skills: list[~azure.search.documents.indexes.models.SearchIndexerSkill]
    :ivar cognitive_services_account: Details about the Azure AI service to be used when running
     skills.
    :vartype cognitive_services_account:
     ~azure.search.documents.indexes.models.CognitiveServicesAccount
    :ivar knowledge_store: Definition of additional projections to Azure blob, table, or files, of
     enriched data.
    :vartype knowledge_store: ~azure.search.documents.indexes.models.SearchIndexerKnowledgeStore
    :ivar index_projection: Definition of additional projections to secondary search index(es).
    :vartype index_projection: ~azure.search.documents.indexes.models.SearchIndexerIndexProjection
    :ivar e_tag: The ETag of the skillset.
    :vartype e_tag: str
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your skillset
     definition when you want full assurance that no one, not even Microsoft, can decrypt your
     skillset definition. Once you have encrypted your skillset definition, it will always remain
     encrypted. The search service will ignore attempts to set this property to null. You can change
     this property as needed if you want to rotate your encryption key; Your skillset definition
     will be unaffected. Encryption with customer-managed keys is not available for free search
     services, and is only available for paid services created on or after January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the skillset. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description of the skillset."""
    skills: list["_models.SearchIndexerSkill"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of skills in the skillset. Required."""
    cognitive_services_account: Optional["_models.CognitiveServicesAccount"] = rest_field(
        name="cognitiveServices", visibility=["read", "create", "update", "delete", "query"]
    )
    """Details about the Azure AI service to be used when running skills."""
    knowledge_store: Optional["_models.SearchIndexerKnowledgeStore"] = rest_field(
        name="knowledgeStore", visibility=["read", "create", "update", "delete", "query"]
    )
    """Definition of additional projections to Azure blob, table, or files, of enriched data."""
    index_projection: Optional["_models.SearchIndexerIndexProjection"] = rest_field(
        name="indexProjections", visibility=["read", "create", "update", "delete", "query"]
    )
    """Definition of additional projections to secondary search index(es)."""
    e_tag: Optional[str] = rest_field(name="@odata.etag", visibility=["read", "create", "update", "delete", "query"])
    """The ETag of the skillset."""
    encryption_key: Optional["_models.SearchResourceEncryptionKey"] = rest_field(
        name="encryptionKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """A description of an encryption key that you create in Azure Key Vault. This key is used to
     provide an additional level of encryption-at-rest for your skillset definition when you want
     full assurance that no one, not even Microsoft, can decrypt your skillset definition. Once you
     have encrypted your skillset definition, it will always remain encrypted. The search service
     will ignore attempts to set this property to null. You can change this property as needed if
     you want to rotate your encryption key; Your skillset definition will be unaffected. Encryption
     with customer-managed keys is not available for free search services, and is only available for
     paid services created on or after January 1, 2019."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        skills: list["_models.SearchIndexerSkill"],
        description: Optional[str] = None,
        cognitive_services_account: Optional["_models.CognitiveServicesAccount"] = None,
        knowledge_store: Optional["_models.SearchIndexerKnowledgeStore"] = None,
        index_projection: Optional["_models.SearchIndexerIndexProjection"] = None,
        e_tag: Optional[str] = None,
        encryption_key: Optional["_models.SearchResourceEncryptionKey"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexerStatus(_Model):
    """Represents the current status and execution history of an indexer.

    :ivar name: The name of the indexer. Required.
    :vartype name: str
    :ivar status: Overall indexer status. Required. Known values are: "unknown", "error", and
     "running".
    :vartype status: str or ~azure.search.documents.indexes.models.IndexerStatus
    :ivar runtime: Snapshot of the indexer's cumulative runtime consumption for the service over
     the current UTC period. Required.
    :vartype runtime: ~azure.search.documents.indexes.models.IndexerRuntime
    :ivar last_result: The result of the most recent or an in-progress indexer execution.
    :vartype last_result: ~azure.search.documents.indexes.models.IndexerExecutionResult
    :ivar execution_history: History of the recent indexer executions, sorted in reverse
     chronological order. Required.
    :vartype execution_history: list[~azure.search.documents.indexes.models.IndexerExecutionResult]
    :ivar limits: The execution limits for the indexer. Required.
    :vartype limits: ~azure.search.documents.indexes.models.SearchIndexerLimits
    :ivar current_state: All of the state that defines and dictates the indexer's current
     execution.
    :vartype current_state: ~azure.search.documents.indexes.models.IndexerCurrentState
    """

    name: str = rest_field(visibility=["read"])
    """The name of the indexer. Required."""
    status: Union[str, "_models.IndexerStatus"] = rest_field(visibility=["read"])
    """Overall indexer status. Required. Known values are: \"unknown\", \"error\", and \"running\"."""
    runtime: "_models.IndexerRuntime" = rest_field(visibility=["read"])
    """Snapshot of the indexer's cumulative runtime consumption for the service over the current UTC
     period. Required."""
    last_result: Optional["_models.IndexerExecutionResult"] = rest_field(name="lastResult", visibility=["read"])
    """The result of the most recent or an in-progress indexer execution."""
    execution_history: list["_models.IndexerExecutionResult"] = rest_field(name="executionHistory", visibility=["read"])
    """History of the recent indexer executions, sorted in reverse chronological order. Required."""
    limits: "_models.SearchIndexerLimits" = rest_field(visibility=["read"])
    """The execution limits for the indexer. Required."""
    current_state: Optional["_models.IndexerCurrentState"] = rest_field(name="currentState", visibility=["read"])
    """All of the state that defines and dictates the indexer's current execution."""


class SearchIndexerWarning(_Model):
    """Represents an item-level warning.

    :ivar key: The key of the item which generated a warning.
    :vartype key: str
    :ivar message: The message describing the warning that occurred while processing the item.
     Required.
    :vartype message: str
    :ivar name: The name of the source at which the warning originated. For example, this could
     refer to a particular skill in the attached skillset. This may not be always available.
    :vartype name: str
    :ivar details: Additional, verbose details about the warning to assist in debugging the
     indexer. This may not be always available.
    :vartype details: str
    :ivar documentation_link: A link to a troubleshooting guide for these classes of warnings. This
     may not be always available.
    :vartype documentation_link: str
    """

    key: Optional[str] = rest_field(visibility=["read"])
    """The key of the item which generated a warning."""
    message: str = rest_field(visibility=["read"])
    """The message describing the warning that occurred while processing the item. Required."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the source at which the warning originated. For example, this could refer to a
     particular skill in the attached skillset. This may not be always available."""
    details: Optional[str] = rest_field(visibility=["read"])
    """Additional, verbose details about the warning to assist in debugging the indexer. This may not
     be always available."""
    documentation_link: Optional[str] = rest_field(name="documentationLink", visibility=["read"])
    """A link to a troubleshooting guide for these classes of warnings. This may not be always
     available."""


class SearchIndexFieldReference(_Model):
    """Field reference for a search index.

    :ivar name: The name of the field. Required.
    :vartype name: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the field. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexKnowledgeSource(KnowledgeSource, discriminator="searchIndex"):
    """Knowledge Source targeting a search index.

    :ivar name: The name of the knowledge source. Required.
    :vartype name: str
    :ivar description: Optional user-defined description.
    :vartype description: str
    :ivar e_tag: The ETag of the knowledge source.
    :vartype e_tag: str
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your knowledge source
     definition when you want full assurance that no one, not even Microsoft, can decrypt them. Once
     you have encrypted your knowledge source definition, it will always remain encrypted. The
     search service will ignore attempts to set this property to null. You can change this property
     as needed if you want to rotate your encryption key; Your knowledge source definition will be
     unaffected. Encryption with customer-managed keys is not available for free search services,
     and is only available for paid services created on or after January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :ivar kind: Required. A knowledge source that reads data from a Search Index.
    :vartype kind: str or ~azure.search.documents.indexes.models.SEARCH_INDEX
    :ivar search_index_parameters: The parameters for the knowledge source. Required.
    :vartype search_index_parameters:
     ~azure.search.documents.indexes.models.SearchIndexKnowledgeSourceParameters
    """

    kind: Literal[KnowledgeSourceKind.SEARCH_INDEX] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. A knowledge source that reads data from a Search Index."""
    search_index_parameters: "_models.SearchIndexKnowledgeSourceParameters" = rest_field(
        name="searchIndexParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """The parameters for the knowledge source. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        search_index_parameters: "_models.SearchIndexKnowledgeSourceParameters",
        description: Optional[str] = None,
        e_tag: Optional[str] = None,
        encryption_key: Optional["_models.SearchResourceEncryptionKey"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeSourceKind.SEARCH_INDEX  # type: ignore


class SearchIndexKnowledgeSourceParameters(_Model):
    """Parameters for search index knowledge source.

    :ivar search_index_name: The name of the Search index. Required.
    :vartype search_index_name: str
    :ivar source_data_fields: Used to request additional fields for referenced source data.
    :vartype source_data_fields:
     list[~azure.search.documents.indexes.models.SearchIndexFieldReference]
    :ivar search_fields: Used to restrict which fields to search on the search index.
    :vartype search_fields: list[~azure.search.documents.indexes.models.SearchIndexFieldReference]
    :ivar semantic_configuration_name: Used to specify a different semantic configuration on the
     target search index other than the default one.
    :vartype semantic_configuration_name: str
    """

    search_index_name: str = rest_field(
        name="searchIndexName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the Search index. Required."""
    source_data_fields: Optional[list["_models.SearchIndexFieldReference"]] = rest_field(
        name="sourceDataFields", visibility=["read", "create", "update", "delete", "query"]
    )
    """Used to request additional fields for referenced source data."""
    search_fields: Optional[list["_models.SearchIndexFieldReference"]] = rest_field(
        name="searchFields", visibility=["read", "create", "update", "delete", "query"]
    )
    """Used to restrict which fields to search on the search index."""
    semantic_configuration_name: Optional[str] = rest_field(
        name="semanticConfigurationName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Used to specify a different semantic configuration on the target search index other than the
     default one."""

    @overload
    def __init__(
        self,
        *,
        search_index_name: str,
        source_data_fields: Optional[list["_models.SearchIndexFieldReference"]] = None,
        search_fields: Optional[list["_models.SearchIndexFieldReference"]] = None,
        semantic_configuration_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchIndexResponse(_Model):
    """Represents a search index definition, which describes the fields and search behavior of an
    index.

    :ivar name: The name of the index. Required.
    :vartype name: str
    :ivar description: The description of the index.
    :vartype description: str
    :ivar fields: The fields of the index.
    :vartype fields: list[~azure.search.documents.indexes.models.SearchField]
    :ivar scoring_profiles: The scoring profiles for the index.
    :vartype scoring_profiles: list[~azure.search.documents.indexes.models.ScoringProfile]
    :ivar default_scoring_profile: The name of the scoring profile to use if none is specified in
     the query. If this property is not set and no scoring profile is specified in the query, then
     default scoring (tf-idf) will be used.
    :vartype default_scoring_profile: str
    :ivar cors_options: Options to control Cross-Origin Resource Sharing (CORS) for the index.
    :vartype cors_options: ~azure.search.documents.indexes.models.CorsOptions
    :ivar suggesters: The suggesters for the index.
    :vartype suggesters: list[~azure.search.documents.indexes.models.SearchSuggester]
    :ivar analyzers: The analyzers for the index.
    :vartype analyzers: list[~azure.search.documents.indexes.models.LexicalAnalyzer]
    :ivar tokenizers: The tokenizers for the index.
    :vartype tokenizers: list[~azure.search.documents.indexes.models.LexicalTokenizer]
    :ivar token_filters: The token filters for the index.
    :vartype token_filters: list[~azure.search.documents.indexes.models.TokenFilter]
    :ivar char_filters: The character filters for the index.
    :vartype char_filters: list[~azure.search.documents.indexes.models.CharFilter]
    :ivar normalizers: The normalizers for the index.
    :vartype normalizers: list[~azure.search.documents.indexes.models.LexicalNormalizer]
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your data when you
     want full assurance that no one, not even Microsoft, can decrypt your data. Once you have
     encrypted your data, it will always remain encrypted. The search service will ignore attempts
     to set this property to null. You can change this property as needed if you want to rotate your
     encryption key; Your data will be unaffected. Encryption with customer-managed keys is not
     available for free search services, and is only available for paid services created on or after
     January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :ivar similarity: The type of similarity algorithm to be used when scoring and ranking the
     documents matching a search query. The similarity algorithm can only be defined at index
     creation time and cannot be modified on existing indexes. If null, the ClassicSimilarity
     algorithm is used.
    :vartype similarity: ~azure.search.documents.indexes.models.SimilarityAlgorithm
    :ivar semantic: Defines parameters for a search index that influence semantic capabilities.
    :vartype semantic: ~azure.search.documents.indexes.models.SemanticSearch
    :ivar vector_search: Contains configuration options related to vector search.
    :vartype vector_search: ~azure.search.documents.indexes.models.VectorSearch
    :ivar permission_filter_option: A value indicating whether permission filtering is enabled for
     the index. Known values are: "enabled" and "disabled".
    :vartype permission_filter_option: str or
     ~azure.search.documents.indexes.models.SearchIndexPermissionFilterOption
    :ivar purview_enabled: A value indicating whether Purview is enabled for the index.
    :vartype purview_enabled: bool
    :ivar e_tag: The ETag of the index.
    :vartype e_tag: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the index. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description of the index."""
    fields: Optional[list["_models.SearchField"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The fields of the index."""
    scoring_profiles: Optional[list["_models.ScoringProfile"]] = rest_field(
        name="scoringProfiles", visibility=["read", "create", "update", "delete", "query"]
    )
    """The scoring profiles for the index."""
    default_scoring_profile: Optional[str] = rest_field(
        name="defaultScoringProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the scoring profile to use if none is specified in the query. If this property is
     not set and no scoring profile is specified in the query, then default scoring (tf-idf) will be
     used."""
    cors_options: Optional["_models.CorsOptions"] = rest_field(
        name="corsOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Options to control Cross-Origin Resource Sharing (CORS) for the index."""
    suggesters: Optional[list["_models.SearchSuggester"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The suggesters for the index."""
    analyzers: Optional[list["_models.LexicalAnalyzer"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The analyzers for the index."""
    tokenizers: Optional[list["_models.LexicalTokenizer"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The tokenizers for the index."""
    token_filters: Optional[list["_models.TokenFilter"]] = rest_field(
        name="tokenFilters", visibility=["read", "create", "update", "delete", "query"]
    )
    """The token filters for the index."""
    char_filters: Optional[list["_models.CharFilter"]] = rest_field(
        name="charFilters", visibility=["read", "create", "update", "delete", "query"]
    )
    """The character filters for the index."""
    normalizers: Optional[list["_models.LexicalNormalizer"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The normalizers for the index."""
    encryption_key: Optional["_models.SearchResourceEncryptionKey"] = rest_field(
        name="encryptionKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """A description of an encryption key that you create in Azure Key Vault. This key is used to
     provide an additional level of encryption-at-rest for your data when you want full assurance
     that no one, not even Microsoft, can decrypt your data. Once you have encrypted your data, it
     will always remain encrypted. The search service will ignore attempts to set this property to
     null. You can change this property as needed if you want to rotate your encryption key; Your
     data will be unaffected. Encryption with customer-managed keys is not available for free search
     services, and is only available for paid services created on or after January 1, 2019."""
    similarity: Optional["_models.SimilarityAlgorithm"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of similarity algorithm to be used when scoring and ranking the documents matching a
     search query. The similarity algorithm can only be defined at index creation time and cannot be
     modified on existing indexes. If null, the ClassicSimilarity algorithm is used."""
    semantic: Optional["_models.SemanticSearch"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines parameters for a search index that influence semantic capabilities."""
    vector_search: Optional["_models.VectorSearch"] = rest_field(
        name="vectorSearch", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains configuration options related to vector search."""
    permission_filter_option: Optional[Union[str, "_models.SearchIndexPermissionFilterOption"]] = rest_field(
        name="permissionFilterOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether permission filtering is enabled for the index. Known values are:
     \"enabled\" and \"disabled\"."""
    purview_enabled: Optional[bool] = rest_field(
        name="purviewEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether Purview is enabled for the index."""
    e_tag: Optional[str] = rest_field(name="@odata.etag", visibility=["read", "create", "update", "delete", "query"])
    """The ETag of the index."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        fields: Optional[list["_models.SearchField"]] = None,
        scoring_profiles: Optional[list["_models.ScoringProfile"]] = None,
        default_scoring_profile: Optional[str] = None,
        cors_options: Optional["_models.CorsOptions"] = None,
        suggesters: Optional[list["_models.SearchSuggester"]] = None,
        analyzers: Optional[list["_models.LexicalAnalyzer"]] = None,
        tokenizers: Optional[list["_models.LexicalTokenizer"]] = None,
        token_filters: Optional[list["_models.TokenFilter"]] = None,
        char_filters: Optional[list["_models.CharFilter"]] = None,
        normalizers: Optional[list["_models.LexicalNormalizer"]] = None,
        encryption_key: Optional["_models.SearchResourceEncryptionKey"] = None,
        similarity: Optional["_models.SimilarityAlgorithm"] = None,
        semantic: Optional["_models.SemanticSearch"] = None,
        vector_search: Optional["_models.VectorSearch"] = None,
        permission_filter_option: Optional[Union[str, "_models.SearchIndexPermissionFilterOption"]] = None,
        purview_enabled: Optional[bool] = None,
        e_tag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchResourceEncryptionKey(_Model):
    """A customer-managed encryption key in Azure Key Vault. Keys that you create and manage can be
    used to encrypt or decrypt data-at-rest, such as indexes and synonym maps.

    :ivar key_name: The name of your Azure Key Vault key to be used to encrypt your data at rest.
     Required.
    :vartype key_name: str
    :ivar key_version: The version of your Azure Key Vault key to be used to encrypt your data at
     rest.
    :vartype key_version: str
    :ivar vault_uri: The URI of your Azure Key Vault, also referred to as DNS name, that contains
     the key to be used to encrypt your data at rest. An example URI might be
     ``https://my-keyvault-name.vault.azure.net``. Required.
    :vartype vault_uri: str
    :ivar access_credentials: Optional Azure Active Directory credentials used for accessing your
     Azure Key Vault. Not required if using managed identity instead.
    :vartype access_credentials:
     ~azure.search.documents.indexes.models.AzureActiveDirectoryApplicationCredentials
    :ivar identity: An explicit managed identity to use for this encryption key. If not specified
     and the access credentials property is null, the system-assigned managed identity is used. On
     update to the resource, if the explicit identity is unspecified, it remains unchanged. If
     "none" is specified, the value of this property is cleared.
    :vartype identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
    """

    key_name: str = rest_field(name="keyVaultKeyName", visibility=["read", "create", "update", "delete", "query"])
    """The name of your Azure Key Vault key to be used to encrypt your data at rest. Required."""
    key_version: Optional[str] = rest_field(
        name="keyVaultKeyVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The version of your Azure Key Vault key to be used to encrypt your data at rest."""
    vault_uri: str = rest_field(name="keyVaultUri", visibility=["read", "create", "update", "delete", "query"])
    """The URI of your Azure Key Vault, also referred to as DNS name, that contains the key to be used
     to encrypt your data at rest. An example URI might be
     ``https://my-keyvault-name.vault.azure.net``. Required."""
    access_credentials: Optional["_models.AzureActiveDirectoryApplicationCredentials"] = rest_field(
        name="accessCredentials", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional Azure Active Directory credentials used for accessing your Azure Key Vault. Not
     required if using managed identity instead."""
    identity: Optional["_models.SearchIndexerDataIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An explicit managed identity to use for this encryption key. If not specified and the access
     credentials property is null, the system-assigned managed identity is used. On update to the
     resource, if the explicit identity is unspecified, it remains unchanged. If \"none\" is
     specified, the value of this property is cleared."""

    __flattened_items = ["application_id", "application_secret"]

    @overload
    def __init__(
        self,
        *,
        key_name: str,
        vault_uri: str,
        key_version: Optional[str] = None,
        access_credentials: Optional["_models.AzureActiveDirectoryApplicationCredentials"] = None,
        identity: Optional["_models.SearchIndexerDataIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.access_credentials is None:
                return None
            return getattr(self.access_credentials, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.access_credentials is None:
                self.access_credentials = self._attr_to_rest_field["access_credentials"]._class_type()
            setattr(self.access_credentials, key, value)
        else:
            super().__setattr__(key, value)


class SearchServiceCounters(_Model):
    """Represents service-level resource counters and quotas.

    :ivar alias_counter: Total number of aliases. Required.
    :vartype alias_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :ivar document_counter: Total number of documents across all indexes in the service. Required.
    :vartype document_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :ivar index_counter: Total number of indexes. Required.
    :vartype index_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :ivar indexer_counter: Total number of indexers. Required.
    :vartype indexer_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :ivar data_source_counter: Total number of data sources. Required.
    :vartype data_source_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :ivar storage_size_counter: Total size of used storage in bytes. Required.
    :vartype storage_size_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :ivar synonym_map_counter: Total number of synonym maps. Required.
    :vartype synonym_map_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :ivar skillset_counter: Total number of skillsets. Required.
    :vartype skillset_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :ivar vector_index_size_counter: Total memory consumption of all vector indexes within the
     service, in bytes. Required.
    :vartype vector_index_size_counter: ~azure.search.documents.indexes.models.ResourceCounter
    """

    alias_counter: "_models.ResourceCounter" = rest_field(
        name="aliasesCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of aliases. Required."""
    document_counter: "_models.ResourceCounter" = rest_field(
        name="documentCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of documents across all indexes in the service. Required."""
    index_counter: "_models.ResourceCounter" = rest_field(
        name="indexesCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of indexes. Required."""
    indexer_counter: "_models.ResourceCounter" = rest_field(
        name="indexersCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of indexers. Required."""
    data_source_counter: "_models.ResourceCounter" = rest_field(
        name="dataSourcesCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of data sources. Required."""
    storage_size_counter: "_models.ResourceCounter" = rest_field(
        name="storageSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total size of used storage in bytes. Required."""
    synonym_map_counter: "_models.ResourceCounter" = rest_field(
        name="synonymMaps", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of synonym maps. Required."""
    skillset_counter: "_models.ResourceCounter" = rest_field(
        name="skillsetCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of skillsets. Required."""
    vector_index_size_counter: "_models.ResourceCounter" = rest_field(
        name="vectorIndexSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total memory consumption of all vector indexes within the service, in bytes. Required."""

    @overload
    def __init__(
        self,
        *,
        alias_counter: "_models.ResourceCounter",
        document_counter: "_models.ResourceCounter",
        index_counter: "_models.ResourceCounter",
        indexer_counter: "_models.ResourceCounter",
        data_source_counter: "_models.ResourceCounter",
        storage_size_counter: "_models.ResourceCounter",
        synonym_map_counter: "_models.ResourceCounter",
        skillset_counter: "_models.ResourceCounter",
        vector_index_size_counter: "_models.ResourceCounter",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchServiceLimits(_Model):
    """Represents various service level limits.

    :ivar max_fields_per_index: The maximum allowed fields per index.
    :vartype max_fields_per_index: int
    :ivar max_field_nesting_depth_per_index: The maximum depth which you can nest sub-fields in an
     index, including the top-level complex field. For example, a/b/c has a nesting depth of 3.
    :vartype max_field_nesting_depth_per_index: int
    :ivar max_complex_collection_fields_per_index: The maximum number of fields of type
     Collection(Edm.ComplexType) allowed in an index.
    :vartype max_complex_collection_fields_per_index: int
    :ivar max_complex_objects_in_collections_per_document: The maximum number of objects in complex
     collections allowed per document.
    :vartype max_complex_objects_in_collections_per_document: int
    :ivar max_storage_per_index_in_bytes: The maximum amount of storage in bytes allowed per index.
    :vartype max_storage_per_index_in_bytes: int
    :ivar max_cumulative_indexer_runtime_seconds: The maximum cumulative indexer runtime in seconds
     allowed for the service.
    :vartype max_cumulative_indexer_runtime_seconds: int
    """

    max_fields_per_index: Optional[int] = rest_field(
        name="maxFieldsPerIndex", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum allowed fields per index."""
    max_field_nesting_depth_per_index: Optional[int] = rest_field(
        name="maxFieldNestingDepthPerIndex", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum depth which you can nest sub-fields in an index, including the top-level complex
     field. For example, a/b/c has a nesting depth of 3."""
    max_complex_collection_fields_per_index: Optional[int] = rest_field(
        name="maxComplexCollectionFieldsPerIndex", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of fields of type Collection(Edm.ComplexType) allowed in an index."""
    max_complex_objects_in_collections_per_document: Optional[int] = rest_field(
        name="maxComplexObjectsInCollectionsPerDocument", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of objects in complex collections allowed per document."""
    max_storage_per_index_in_bytes: Optional[int] = rest_field(
        name="maxStoragePerIndex", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum amount of storage in bytes allowed per index."""
    max_cumulative_indexer_runtime_seconds: Optional[int] = rest_field(
        name="maxCumulativeIndexerRuntimeSeconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum cumulative indexer runtime in seconds allowed for the service."""

    @overload
    def __init__(
        self,
        *,
        max_fields_per_index: Optional[int] = None,
        max_field_nesting_depth_per_index: Optional[int] = None,
        max_complex_collection_fields_per_index: Optional[int] = None,
        max_complex_objects_in_collections_per_document: Optional[int] = None,
        max_storage_per_index_in_bytes: Optional[int] = None,
        max_cumulative_indexer_runtime_seconds: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchServiceStatistics(_Model):
    """Response from a get service statistics request. If successful, it includes service level
    counters and limits.

    :ivar counters: Service level resource counters. Required.
    :vartype counters: ~azure.search.documents.indexes.models.SearchServiceCounters
    :ivar limits: Service level general limits. Required.
    :vartype limits: ~azure.search.documents.indexes.models.SearchServiceLimits
    :ivar indexers_runtime: Service level indexer runtime consumption. Required.
    :vartype indexers_runtime: ~azure.search.documents.indexes.models.ServiceIndexersRuntime
    """

    counters: "_models.SearchServiceCounters" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Service level resource counters. Required."""
    limits: "_models.SearchServiceLimits" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Service level general limits. Required."""
    indexers_runtime: "_models.ServiceIndexersRuntime" = rest_field(
        name="indexersRuntime", visibility=["read", "create", "update", "delete", "query"]
    )
    """Service level indexer runtime consumption. Required."""

    @overload
    def __init__(
        self,
        *,
        counters: "_models.SearchServiceCounters",
        limits: "_models.SearchServiceLimits",
        indexers_runtime: "_models.ServiceIndexersRuntime",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SearchSuggester(_Model):
    """Defines how the Suggest API should apply to a group of fields in the index.

    :ivar name: The name of the suggester. Required.
    :vartype name: str
    :ivar search_mode: A value indicating the capabilities of the suggester. Required. Default
     value is "analyzingInfixMatching".
    :vartype search_mode: str
    :ivar source_fields: The list of field names to which the suggester applies. Each field must be
     searchable. Required.
    :vartype source_fields: list[str]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the suggester. Required."""
    search_mode: Literal["analyzingInfixMatching"] = rest_field(
        name="searchMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating the capabilities of the suggester. Required. Default value is
     \"analyzingInfixMatching\"."""
    source_fields: list[str] = rest_field(
        name="sourceFields", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of field names to which the suggester applies. Each field must be searchable.
     Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        source_fields: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.search_mode: Literal["analyzingInfixMatching"] = "analyzingInfixMatching"


class SemanticConfiguration(_Model):
    """Defines a specific configuration to be used in the context of semantic capabilities.

    :ivar name: The name of the semantic configuration. Required.
    :vartype name: str
    :ivar prioritized_fields: Describes the title, content, and keyword fields to be used for
     semantic ranking, captions, highlights, and answers. At least one of the three sub properties
     (titleField, prioritizedKeywordsFields and prioritizedContentFields) need to be set. Required.
    :vartype prioritized_fields: ~azure.search.documents.indexes.models.SemanticPrioritizedFields
    :ivar ranking_order: Specifies the score type to be used for the sort order of the search
     results. Known values are: "BoostedRerankerScore" and "RerankerScore".
    :vartype ranking_order: str or ~azure.search.documents.indexes.models.RankingOrder
    :ivar flighting_opt_in: Determines which semantic or query rewrite models to use during model
     flighting/upgrades.
    :vartype flighting_opt_in: bool
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the semantic configuration. Required."""
    prioritized_fields: "_models.SemanticPrioritizedFields" = rest_field(
        name="prioritizedFields", visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes the title, content, and keyword fields to be used for semantic ranking, captions,
     highlights, and answers. At least one of the three sub properties (titleField,
     prioritizedKeywordsFields and prioritizedContentFields) need to be set. Required."""
    ranking_order: Optional[Union[str, "_models.RankingOrder"]] = rest_field(
        name="rankingOrder", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the score type to be used for the sort order of the search results. Known values are:
     \"BoostedRerankerScore\" and \"RerankerScore\"."""
    flighting_opt_in: Optional[bool] = rest_field(
        name="flightingOptIn", visibility=["read", "create", "update", "delete", "query"]
    )
    """Determines which semantic or query rewrite models to use during model flighting/upgrades."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        prioritized_fields: "_models.SemanticPrioritizedFields",
        ranking_order: Optional[Union[str, "_models.RankingOrder"]] = None,
        flighting_opt_in: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SemanticField(_Model):
    """A field that is used as part of the semantic configuration.

    :ivar field_name: File name. Required.
    :vartype field_name: str
    """

    field_name: str = rest_field(name="fieldName", visibility=["read", "create", "update", "delete", "query"])
    """File name. Required."""

    @overload
    def __init__(
        self,
        *,
        field_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SemanticPrioritizedFields(_Model):
    """Describes the title, content, and keywords fields to be used for semantic ranking, captions,
    highlights, and answers.

    :ivar title_field: Defines the title field to be used for semantic ranking, captions,
     highlights, and answers. If you don't have a title field in your index, leave this blank.
    :vartype title_field: ~azure.search.documents.indexes.models.SemanticField
    :ivar content_fields: Defines the content fields to be used for semantic ranking, captions,
     highlights, and answers. For the best result, the selected fields should contain text in
     natural language form. The order of the fields in the array represents their priority. Fields
     with lower priority may get truncated if the content is long.
    :vartype content_fields: list[~azure.search.documents.indexes.models.SemanticField]
    :ivar keywords_fields: Defines the keyword fields to be used for semantic ranking, captions,
     highlights, and answers. For the best result, the selected fields should contain a list of
     keywords. The order of the fields in the array represents their priority. Fields with lower
     priority may get truncated if the content is long.
    :vartype keywords_fields: list[~azure.search.documents.indexes.models.SemanticField]
    """

    title_field: Optional["_models.SemanticField"] = rest_field(
        name="titleField", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the title field to be used for semantic ranking, captions, highlights, and answers. If
     you don't have a title field in your index, leave this blank."""
    content_fields: Optional[list["_models.SemanticField"]] = rest_field(
        name="prioritizedContentFields", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the content fields to be used for semantic ranking, captions, highlights, and answers.
     For the best result, the selected fields should contain text in natural language form. The
     order of the fields in the array represents their priority. Fields with lower priority may get
     truncated if the content is long."""
    keywords_fields: Optional[list["_models.SemanticField"]] = rest_field(
        name="prioritizedKeywordsFields", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the keyword fields to be used for semantic ranking, captions, highlights, and answers.
     For the best result, the selected fields should contain a list of keywords. The order of the
     fields in the array represents their priority. Fields with lower priority may get truncated if
     the content is long."""

    @overload
    def __init__(
        self,
        *,
        title_field: Optional["_models.SemanticField"] = None,
        content_fields: Optional[list["_models.SemanticField"]] = None,
        keywords_fields: Optional[list["_models.SemanticField"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SemanticSearch(_Model):
    """Defines parameters for a search index that influence semantic capabilities.

    :ivar default_configuration_name: Allows you to set the name of a default semantic
     configuration in your index, making it optional to pass it on as a query parameter every time.
    :vartype default_configuration_name: str
    :ivar configurations: The semantic configurations for the index.
    :vartype configurations: list[~azure.search.documents.indexes.models.SemanticConfiguration]
    """

    default_configuration_name: Optional[str] = rest_field(
        name="defaultConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allows you to set the name of a default semantic configuration in your index, making it
     optional to pass it on as a query parameter every time."""
    configurations: Optional[list["_models.SemanticConfiguration"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The semantic configurations for the index."""

    @overload
    def __init__(
        self,
        *,
        default_configuration_name: Optional[str] = None,
        configurations: Optional[list["_models.SemanticConfiguration"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SentimentSkillV3(SearchIndexerSkill, discriminator="#Microsoft.Skills.Text.V3.SentimentSkill"):
    """Using the Text Analytics API, evaluates unstructured text and for each record, provides
    sentiment labels (such as "negative", "neutral" and "positive") based on the highest confidence
    score found by the service at a sentence and document-level.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is ``en``.
    :vartype default_language_code: str
    :ivar include_opinion_mining: If set to true, the skill output will include information from
     Text Analytics for opinion mining, namely targets (nouns or verbs) and their associated
     assessment (adjective) in the text. Default is false.
    :vartype include_opinion_mining: bool
    :ivar model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :vartype model_version: str
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Text.V3.SentimentSkill".
    :vartype odata_type: str
    """

    default_language_code: Optional[str] = rest_field(
        name="defaultLanguageCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating which language code to use. Default is ``en``."""
    include_opinion_mining: Optional[bool] = rest_field(
        name="includeOpinionMining", visibility=["read", "create", "update", "delete", "query"]
    )
    """If set to true, the skill output will include information from Text Analytics for opinion
     mining, namely targets (nouns or verbs) and their associated assessment (adjective) in the
     text. Default is false."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The version of the model to use when calling the Text Analytics service. It will default to the
     latest available when not specified. We recommend you do not specify this value unless
     absolutely necessary."""
    odata_type: Literal["#Microsoft.Skills.Text.V3.SentimentSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Text.V3.SentimentSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[str] = None,
        include_opinion_mining: Optional[bool] = None,
        model_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Text.V3.SentimentSkill"  # type: ignore


class ServiceIndexersRuntime(_Model):
    """Represents service-level indexer runtime counters.

    :ivar used_seconds: Cumulative runtime of all indexers in the service from the beginningTime to
     endingTime, in seconds. Required.
    :vartype used_seconds: int
    :ivar remaining_seconds: Cumulative runtime remaining for all indexers in the service from the
     beginningTime to endingTime, in seconds.
    :vartype remaining_seconds: int
    :ivar beginning_time: Beginning UTC time of the 24-hour period considered for indexer runtime
     usage (inclusive). Required.
    :vartype beginning_time: ~datetime.datetime
    :ivar ending_time: End UTC time of the 24-hour period considered for indexer runtime usage
     (inclusive). Required.
    :vartype ending_time: ~datetime.datetime
    """

    used_seconds: int = rest_field(name="usedSeconds", visibility=["read", "create", "update", "delete", "query"])
    """Cumulative runtime of all indexers in the service from the beginningTime to endingTime, in
     seconds. Required."""
    remaining_seconds: Optional[int] = rest_field(
        name="remainingSeconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cumulative runtime remaining for all indexers in the service from the beginningTime to
     endingTime, in seconds."""
    beginning_time: datetime.datetime = rest_field(
        name="beginningTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Beginning UTC time of the 24-hour period considered for indexer runtime usage (inclusive).
     Required."""
    ending_time: datetime.datetime = rest_field(
        name="endingTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """End UTC time of the 24-hour period considered for indexer runtime usage (inclusive). Required."""

    @overload
    def __init__(
        self,
        *,
        used_seconds: int,
        beginning_time: datetime.datetime,
        ending_time: datetime.datetime,
        remaining_seconds: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ShaperSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Util.ShaperSkill"):
    """A skill for reshaping the outputs. It creates a complex type to support composite fields (also
    known as multipart fields).

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Util.ShaperSkill".
    :vartype odata_type: str
    """

    odata_type: Literal["#Microsoft.Skills.Util.ShaperSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Util.ShaperSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Util.ShaperSkill"  # type: ignore


class ShingleTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.ShingleTokenFilter"):
    """Creates combinations of tokens as a single token. This token filter is implemented using Apache
    Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar max_shingle_size: The maximum shingle size. Default and minimum value is 2.
    :vartype max_shingle_size: int
    :ivar min_shingle_size: The minimum shingle size. Default and minimum value is 2. Must be less
     than the value of maxShingleSize.
    :vartype min_shingle_size: int
    :ivar output_unigrams: A value indicating whether the output stream will contain the input
     tokens (unigrams) as well as shingles. Default is true.
    :vartype output_unigrams: bool
    :ivar output_unigrams_if_no_shingles: A value indicating whether to output unigrams for those
     times when no shingles are available. This property takes precedence when outputUnigrams is set
     to false. Default is false.
    :vartype output_unigrams_if_no_shingles: bool
    :ivar token_separator: The string to use when joining adjacent tokens to form a shingle.
     Default is a single space (" ").
    :vartype token_separator: str
    :ivar filter_token: The string to insert for each position at which there is no token. Default
     is an underscore ("_").
    :vartype filter_token: str
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.ShingleTokenFilter".
    :vartype odata_type: str
    """

    max_shingle_size: Optional[int] = rest_field(
        name="maxShingleSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum shingle size. Default and minimum value is 2."""
    min_shingle_size: Optional[int] = rest_field(
        name="minShingleSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """The minimum shingle size. Default and minimum value is 2. Must be less than the value of
     maxShingleSize."""
    output_unigrams: Optional[bool] = rest_field(
        name="outputUnigrams", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether the output stream will contain the input tokens (unigrams) as well
     as shingles. Default is true."""
    output_unigrams_if_no_shingles: Optional[bool] = rest_field(
        name="outputUnigramsIfNoShingles", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to output unigrams for those times when no shingles are available.
     This property takes precedence when outputUnigrams is set to false. Default is false."""
    token_separator: Optional[str] = rest_field(
        name="tokenSeparator", visibility=["read", "create", "update", "delete", "query"]
    )
    """The string to use when joining adjacent tokens to form a shingle. Default is a single space (\"
     \")."""
    filter_token: Optional[str] = rest_field(
        name="filterToken", visibility=["read", "create", "update", "delete", "query"]
    )
    """The string to insert for each position at which there is no token. Default is an underscore
     (\"_\")."""
    odata_type: Literal["#Microsoft.Azure.Search.ShingleTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.ShingleTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        max_shingle_size: Optional[int] = None,
        min_shingle_size: Optional[int] = None,
        output_unigrams: Optional[bool] = None,
        output_unigrams_if_no_shingles: Optional[bool] = None,
        token_separator: Optional[str] = None,
        filter_token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.ShingleTokenFilter"  # type: ignore


class SkillNames(_Model):
    """The type of the skill names.

    :ivar skill_names: the names of skills to be reset.
    :vartype skill_names: list[str]
    """

    skill_names: Optional[list[str]] = rest_field(
        name="skillNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """the names of skills to be reset."""

    @overload
    def __init__(
        self,
        *,
        skill_names: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SnowballTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.SnowballTokenFilter"):
    """A filter that stems words using a Snowball-generated stemmer. This token filter is implemented
    using Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar language: The language to use. Required. Known values are: "armenian", "basque",
     "catalan", "danish", "dutch", "english", "finnish", "french", "german", "german2", "hungarian",
     "italian", "kp", "lovins", "norwegian", "porter", "portuguese", "romanian", "russian",
     "spanish", "swedish", and "turkish".
    :vartype language: str or ~azure.search.documents.indexes.models.SnowballTokenFilterLanguage
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.SnowballTokenFilter".
    :vartype odata_type: str
    """

    language: Union[str, "_models.SnowballTokenFilterLanguage"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The language to use. Required. Known values are: \"armenian\", \"basque\", \"catalan\",
     \"danish\", \"dutch\", \"english\", \"finnish\", \"french\", \"german\", \"german2\",
     \"hungarian\", \"italian\", \"kp\", \"lovins\", \"norwegian\", \"porter\", \"portuguese\",
     \"romanian\", \"russian\", \"spanish\", \"swedish\", and \"turkish\"."""
    odata_type: Literal["#Microsoft.Azure.Search.SnowballTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.SnowballTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        language: Union[str, "_models.SnowballTokenFilterLanguage"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.SnowballTokenFilter"  # type: ignore


class SoftDeleteColumnDeletionDetectionPolicy(
    DataDeletionDetectionPolicy, discriminator="#Microsoft.Azure.Search.SoftDeleteColumnDeletionDetectionPolicy"
):
    """Defines a data deletion detection policy that implements a soft-deletion strategy. It
    determines whether an item should be deleted based on the value of a designated 'soft delete'
    column.

    :ivar soft_delete_column_name: The name of the column to use for soft-deletion detection.
    :vartype soft_delete_column_name: str
    :ivar soft_delete_marker_value: The marker value that identifies an item as deleted.
    :vartype soft_delete_marker_value: str
    :ivar odata_type: A URI fragment specifying the type of data deletion detection policy.
     Required. Default value is "#Microsoft.Azure.Search.SoftDeleteColumnDeletionDetectionPolicy".
    :vartype odata_type: str
    """

    soft_delete_column_name: Optional[str] = rest_field(
        name="softDeleteColumnName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the column to use for soft-deletion detection."""
    soft_delete_marker_value: Optional[str] = rest_field(
        name="softDeleteMarkerValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """The marker value that identifies an item as deleted."""
    odata_type: Literal["#Microsoft.Azure.Search.SoftDeleteColumnDeletionDetectionPolicy"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of data deletion detection policy. Required. Default value
     is \"#Microsoft.Azure.Search.SoftDeleteColumnDeletionDetectionPolicy\"."""

    @overload
    def __init__(
        self,
        *,
        soft_delete_column_name: Optional[str] = None,
        soft_delete_marker_value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.SoftDeleteColumnDeletionDetectionPolicy"  # type: ignore


class SplitSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Text.SplitSkill"):
    """A skill to split a string into chunks of text.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is ``en``.
     Known values are: "am", "bs", "cs", "da", "de", "en", "es", "et", "fi", "fr", "he", "hi", "hr",
     "hu", "id", "is", "it", "ja", "ko", "lv", "nb", "nl", "pl", "pt", "pt-br", "ru", "sk", "sl",
     "sr", "sv", "tr", "ur", and "zh".
    :vartype default_language_code: str or
     ~azure.search.documents.indexes.models.SplitSkillLanguage
    :ivar text_split_mode: A value indicating which split mode to perform. Known values are:
     "pages" and "sentences".
    :vartype text_split_mode: str or ~azure.search.documents.indexes.models.TextSplitMode
    :ivar maximum_page_length: The desired maximum page length. Default is 10000.
    :vartype maximum_page_length: int
    :ivar page_overlap_length: Only applicable when textSplitMode is set to 'pages'. If specified,
     n+1th chunk will start with this number of characters/tokens from the end of the nth chunk.
    :vartype page_overlap_length: int
    :ivar maximum_pages_to_take: Only applicable when textSplitMode is set to 'pages'. If
     specified, the SplitSkill will discontinue splitting after processing the first
     'maximumPagesToTake' pages, in order to improve performance when only a few initial pages are
     needed from each document.
    :vartype maximum_pages_to_take: int
    :ivar unit: Only applies if textSplitMode is set to pages. There are two possible values. The
     choice of the values will decide the length (maximumPageLength and pageOverlapLength)
     measurement. The default is 'characters', which means the length will be measured by character.
     Known values are: "characters" and "azureOpenAITokens".
    :vartype unit: str or ~azure.search.documents.indexes.models.SplitSkillUnit
    :ivar azure_open_ai_tokenizer_parameters: Only applies if the unit is set to azureOpenAITokens.
     If specified, the splitSkill will use these parameters when performing the tokenization. The
     parameters are a valid 'encoderModelName' and an optional 'allowedSpecialTokens' property.
    :vartype azure_open_ai_tokenizer_parameters:
     ~azure.search.documents.indexes.models.AzureOpenAITokenizerParameters
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Text.SplitSkill".
    :vartype odata_type: str
    """

    default_language_code: Optional[Union[str, "_models.SplitSkillLanguage"]] = rest_field(
        name="defaultLanguageCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating which language code to use. Default is ``en``. Known values are: \"am\",
     \"bs\", \"cs\", \"da\", \"de\", \"en\", \"es\", \"et\", \"fi\", \"fr\", \"he\", \"hi\", \"hr\",
     \"hu\", \"id\", \"is\", \"it\", \"ja\", \"ko\", \"lv\", \"nb\", \"nl\", \"pl\", \"pt\",
     \"pt-br\", \"ru\", \"sk\", \"sl\", \"sr\", \"sv\", \"tr\", \"ur\", and \"zh\"."""
    text_split_mode: Optional[Union[str, "_models.TextSplitMode"]] = rest_field(
        name="textSplitMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating which split mode to perform. Known values are: \"pages\" and \"sentences\"."""
    maximum_page_length: Optional[int] = rest_field(
        name="maximumPageLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired maximum page length. Default is 10000."""
    page_overlap_length: Optional[int] = rest_field(
        name="pageOverlapLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """Only applicable when textSplitMode is set to 'pages'. If specified, n+1th chunk will start with
     this number of characters/tokens from the end of the nth chunk."""
    maximum_pages_to_take: Optional[int] = rest_field(
        name="maximumPagesToTake", visibility=["read", "create", "update", "delete", "query"]
    )
    """Only applicable when textSplitMode is set to 'pages'. If specified, the SplitSkill will
     discontinue splitting after processing the first 'maximumPagesToTake' pages, in order to
     improve performance when only a few initial pages are needed from each document."""
    unit: Optional[Union[str, "_models.SplitSkillUnit"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Only applies if textSplitMode is set to pages. There are two possible values. The choice of the
     values will decide the length (maximumPageLength and pageOverlapLength) measurement. The
     default is 'characters', which means the length will be measured by character. Known values
     are: \"characters\" and \"azureOpenAITokens\"."""
    azure_open_ai_tokenizer_parameters: Optional["_models.AzureOpenAITokenizerParameters"] = rest_field(
        name="azureOpenAITokenizerParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Only applies if the unit is set to azureOpenAITokens. If specified, the splitSkill will use
     these parameters when performing the tokenization. The parameters are a valid
     'encoderModelName' and an optional 'allowedSpecialTokens' property."""
    odata_type: Literal["#Microsoft.Skills.Text.SplitSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Text.SplitSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_language_code: Optional[Union[str, "_models.SplitSkillLanguage"]] = None,
        text_split_mode: Optional[Union[str, "_models.TextSplitMode"]] = None,
        maximum_page_length: Optional[int] = None,
        page_overlap_length: Optional[int] = None,
        maximum_pages_to_take: Optional[int] = None,
        unit: Optional[Union[str, "_models.SplitSkillUnit"]] = None,
        azure_open_ai_tokenizer_parameters: Optional["_models.AzureOpenAITokenizerParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Text.SplitSkill"  # type: ignore


class SqlIntegratedChangeTrackingPolicy(
    DataChangeDetectionPolicy, discriminator="#Microsoft.Azure.Search.SqlIntegratedChangeTrackingPolicy"
):
    """Defines a data change detection policy that captures changes using the Integrated Change
    Tracking feature of Azure SQL Database.

    :ivar odata_type: A URI fragment specifying the type of data change detection policy. Required.
     Default value is "#Microsoft.Azure.Search.SqlIntegratedChangeTrackingPolicy".
    :vartype odata_type: str
    """

    odata_type: Literal["#Microsoft.Azure.Search.SqlIntegratedChangeTrackingPolicy"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of data change detection policy. Required. Default value is
     \"#Microsoft.Azure.Search.SqlIntegratedChangeTrackingPolicy\"."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.SqlIntegratedChangeTrackingPolicy"  # type: ignore


class StemmerOverrideTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.StemmerOverrideTokenFilter"):
    """Provides the ability to override other stemming filters with custom dictionary-based stemming.
    Any dictionary-stemmed terms will be marked as keywords so that they will not be stemmed with
    stemmers down the chain. Must be placed before any stemming filters. This token filter is
    implemented using Apache Lucene. See
    `http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/miscellaneous/StemmerOverrideFilter.html
    <http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/miscellaneous/StemmerOverrideFilter.html>`_.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar rules: A list of stemming rules in the following format: "word => stem", for example:
     "ran => run". Required.
    :vartype rules: list[str]
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.StemmerOverrideTokenFilter".
    :vartype odata_type: str
    """

    rules: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of stemming rules in the following format: \"word => stem\", for example: \"ran =>
     run\". Required."""
    odata_type: Literal["#Microsoft.Azure.Search.StemmerOverrideTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.StemmerOverrideTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        rules: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.StemmerOverrideTokenFilter"  # type: ignore


class StemmerTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.StemmerTokenFilter"):
    """Language specific stemming filter. This token filter is implemented using Apache Lucene. See
    `https://learn.microsoft.com/rest/api/searchservice/Custom-analyzers-in-Azure-Search#TokenFilters
    <https://learn.microsoft.com/rest/api/searchservice/Custom-analyzers-in-Azure-Search#TokenFilters>`_.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar language: The language to use. Required. Known values are: "arabic", "armenian",
     "basque", "brazilian", "bulgarian", "catalan", "czech", "danish", "dutch", "dutchKp",
     "english", "lightEnglish", "minimalEnglish", "possessiveEnglish", "porter2", "lovins",
     "finnish", "lightFinnish", "french", "lightFrench", "minimalFrench", "galician",
     "minimalGalician", "german", "german2", "lightGerman", "minimalGerman", "greek", "hindi",
     "hungarian", "lightHungarian", "indonesian", "irish", "italian", "lightItalian", "sorani",
     "latvian", "norwegian", "lightNorwegian", "minimalNorwegian", "lightNynorsk", "minimalNynorsk",
     "portuguese", "lightPortuguese", "minimalPortuguese", "portugueseRslp", "romanian", "russian",
     "lightRussian", "spanish", "lightSpanish", "swedish", "lightSwedish", and "turkish".
    :vartype language: str or ~azure.search.documents.indexes.models.StemmerTokenFilterLanguage
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.StemmerTokenFilter".
    :vartype odata_type: str
    """

    language: Union[str, "_models.StemmerTokenFilterLanguage"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The language to use. Required. Known values are: \"arabic\", \"armenian\", \"basque\",
     \"brazilian\", \"bulgarian\", \"catalan\", \"czech\", \"danish\", \"dutch\", \"dutchKp\",
     \"english\", \"lightEnglish\", \"minimalEnglish\", \"possessiveEnglish\", \"porter2\",
     \"lovins\", \"finnish\", \"lightFinnish\", \"french\", \"lightFrench\", \"minimalFrench\",
     \"galician\", \"minimalGalician\", \"german\", \"german2\", \"lightGerman\", \"minimalGerman\",
     \"greek\", \"hindi\", \"hungarian\", \"lightHungarian\", \"indonesian\", \"irish\",
     \"italian\", \"lightItalian\", \"sorani\", \"latvian\", \"norwegian\", \"lightNorwegian\",
     \"minimalNorwegian\", \"lightNynorsk\", \"minimalNynorsk\", \"portuguese\",
     \"lightPortuguese\", \"minimalPortuguese\", \"portugueseRslp\", \"romanian\", \"russian\",
     \"lightRussian\", \"spanish\", \"lightSpanish\", \"swedish\", \"lightSwedish\", and
     \"turkish\"."""
    odata_type: Literal["#Microsoft.Azure.Search.StemmerTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.StemmerTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        language: Union[str, "_models.StemmerTokenFilterLanguage"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.StemmerTokenFilter"  # type: ignore


class StopAnalyzer(LexicalAnalyzer, discriminator="#Microsoft.Azure.Search.StopAnalyzer"):
    """Divides text at non-letters; Applies the lowercase and stopword token filters. This analyzer is
    implemented using Apache Lucene.

    :ivar name: The name of the analyzer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar stopwords: A list of stopwords.
    :vartype stopwords: list[str]
    :ivar odata_type: A URI fragment specifying the type of analyzer. Required. Default value is
     "#Microsoft.Azure.Search.StopAnalyzer".
    :vartype odata_type: str
    """

    stopwords: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of stopwords."""
    odata_type: Literal["#Microsoft.Azure.Search.StopAnalyzer"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of analyzer. Required. Default value is
     \"#Microsoft.Azure.Search.StopAnalyzer\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        stopwords: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.StopAnalyzer"  # type: ignore


class StopwordsTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.StopwordsTokenFilter"):
    """Removes stop words from a token stream. This token filter is implemented using Apache Lucene.
    See
    `http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/StopFilter.html
    <http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/StopFilter.html>`_.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar stopwords: The list of stopwords. This property and the stopwords list property cannot
     both be set.
    :vartype stopwords: list[str]
    :ivar stopwords_list: A predefined list of stopwords to use. This property and the stopwords
     property cannot both be set. Default is English. Known values are: "arabic", "armenian",
     "basque", "brazilian", "bulgarian", "catalan", "czech", "danish", "dutch", "english",
     "finnish", "french", "galician", "german", "greek", "hindi", "hungarian", "indonesian",
     "irish", "italian", "latvian", "norwegian", "persian", "portuguese", "romanian", "russian",
     "sorani", "spanish", "swedish", "thai", and "turkish".
    :vartype stopwords_list: str or ~azure.search.documents.indexes.models.StopwordsList
    :ivar ignore_case: A value indicating whether to ignore case. If true, all words are converted
     to lower case first. Default is false.
    :vartype ignore_case: bool
    :ivar remove_trailing_stop_words: A value indicating whether to ignore the last search term if
     it's a stop word. Default is true.
    :vartype remove_trailing_stop_words: bool
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.StopwordsTokenFilter".
    :vartype odata_type: str
    """

    stopwords: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The list of stopwords. This property and the stopwords list property cannot both be set."""
    stopwords_list: Optional[Union[str, "_models.StopwordsList"]] = rest_field(
        name="stopwordsList", visibility=["read", "create", "update", "delete", "query"]
    )
    """A predefined list of stopwords to use. This property and the stopwords property cannot both be
     set. Default is English. Known values are: \"arabic\", \"armenian\", \"basque\", \"brazilian\",
     \"bulgarian\", \"catalan\", \"czech\", \"danish\", \"dutch\", \"english\", \"finnish\",
     \"french\", \"galician\", \"german\", \"greek\", \"hindi\", \"hungarian\", \"indonesian\",
     \"irish\", \"italian\", \"latvian\", \"norwegian\", \"persian\", \"portuguese\", \"romanian\",
     \"russian\", \"sorani\", \"spanish\", \"swedish\", \"thai\", and \"turkish\"."""
    ignore_case: Optional[bool] = rest_field(
        name="ignoreCase", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to ignore case. If true, all words are converted to lower case
     first. Default is false."""
    remove_trailing_stop_words: Optional[bool] = rest_field(
        name="removeTrailing", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to ignore the last search term if it's a stop word. Default is true."""
    odata_type: Literal["#Microsoft.Azure.Search.StopwordsTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.StopwordsTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        stopwords: Optional[list[str]] = None,
        stopwords_list: Optional[Union[str, "_models.StopwordsList"]] = None,
        ignore_case: Optional[bool] = None,
        remove_trailing_stop_words: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.StopwordsTokenFilter"  # type: ignore


class SynonymMap(_Model):
    """Represents a synonym map definition.

    :ivar name: The name of the synonym map. Required.
    :vartype name: str
    :ivar format: The format of the synonym map. Only the 'solr' format is currently supported.
     Required. Default value is "solr".
    :vartype format: str
    :ivar synonyms: A series of synonym rules in the specified synonym map format. The rules must
     be separated by newlines. Required.
    :vartype synonyms: list[str]
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your data when you
     want full assurance that no one, not even Microsoft, can decrypt your data. Once you have
     encrypted your data, it will always remain encrypted. The search service will ignore attempts
     to set this property to null. You can change this property as needed if you want to rotate your
     encryption key; Your data will be unaffected. Encryption with customer-managed keys is not
     available for free search services, and is only available for paid services created on or after
     January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :ivar e_tag: The ETag of the synonym map.
    :vartype e_tag: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the synonym map. Required."""
    format: Literal["solr"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The format of the synonym map. Only the 'solr' format is currently supported. Required. Default
     value is \"solr\"."""
    synonyms: list[str] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="newlineDelimited"
    )
    """A series of synonym rules in the specified synonym map format. The rules must be separated by
     newlines. Required."""
    encryption_key: Optional["_models.SearchResourceEncryptionKey"] = rest_field(
        name="encryptionKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """A description of an encryption key that you create in Azure Key Vault. This key is used to
     provide an additional level of encryption-at-rest for your data when you want full assurance
     that no one, not even Microsoft, can decrypt your data. Once you have encrypted your data, it
     will always remain encrypted. The search service will ignore attempts to set this property to
     null. You can change this property as needed if you want to rotate your encryption key; Your
     data will be unaffected. Encryption with customer-managed keys is not available for free search
     services, and is only available for paid services created on or after January 1, 2019."""
    e_tag: Optional[str] = rest_field(name="@odata.etag", visibility=["read", "create", "update", "delete", "query"])
    """The ETag of the synonym map."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        synonyms: list[str],
        encryption_key: Optional["_models.SearchResourceEncryptionKey"] = None,
        e_tag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.format: Literal["solr"] = "solr"


class SynonymTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.SynonymTokenFilter"):
    """Matches single or multi-word synonyms in a token stream. This token filter is implemented using
    Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar synonyms: A list of synonyms in following one of two formats: 1. incredible,
     unbelievable, fabulous => amazing - all terms on the left side of => symbol will be replaced
     with all terms on its right side; 2. incredible, unbelievable, fabulous, amazing - comma
     separated list of equivalent words. Set the expand option to change how this list is
     interpreted. Required.
    :vartype synonyms: list[str]
    :ivar ignore_case: A value indicating whether to case-fold input for matching. Default is
     false.
    :vartype ignore_case: bool
    :ivar expand: A value indicating whether all words in the list of synonyms (if => notation is
     not used) will map to one another. If true, all words in the list of synonyms (if => notation
     is not used) will map to one another. The following list: incredible, unbelievable, fabulous,
     amazing is equivalent to: incredible, unbelievable, fabulous, amazing => incredible,
     unbelievable, fabulous, amazing. If false, the following list: incredible, unbelievable,
     fabulous, amazing will be equivalent to: incredible, unbelievable, fabulous, amazing =>
     incredible. Default is true.
    :vartype expand: bool
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.SynonymTokenFilter".
    :vartype odata_type: str
    """

    synonyms: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of synonyms in following one of two formats: 1. incredible, unbelievable, fabulous =>
     amazing - all terms on the left side of => symbol will be replaced with all terms on its right
     side; 2. incredible, unbelievable, fabulous, amazing - comma separated list of equivalent
     words. Set the expand option to change how this list is interpreted. Required."""
    ignore_case: Optional[bool] = rest_field(
        name="ignoreCase", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to case-fold input for matching. Default is false."""
    expand: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A value indicating whether all words in the list of synonyms (if => notation is not used) will
     map to one another. If true, all words in the list of synonyms (if => notation is not used)
     will map to one another. The following list: incredible, unbelievable, fabulous, amazing is
     equivalent to: incredible, unbelievable, fabulous, amazing => incredible, unbelievable,
     fabulous, amazing. If false, the following list: incredible, unbelievable, fabulous, amazing
     will be equivalent to: incredible, unbelievable, fabulous, amazing => incredible. Default is
     true."""
    odata_type: Literal["#Microsoft.Azure.Search.SynonymTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.SynonymTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        synonyms: list[str],
        ignore_case: Optional[bool] = None,
        expand: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.SynonymTokenFilter"  # type: ignore


class TagScoringFunction(ScoringFunction, discriminator="tag"):
    """Defines a function that boosts scores of documents with string values matching a given list of
    tags.

    :ivar field_name: The name of the field used as input to the scoring function. Required.
    :vartype field_name: str
    :ivar boost: A multiplier for the raw score. Must be a positive number not equal to 1.0.
     Required.
    :vartype boost: float
    :ivar interpolation: A value indicating how boosting will be interpolated across document
     scores; defaults to "Linear". Known values are: "linear", "constant", "quadratic", and
     "logarithmic".
    :vartype interpolation: str or
     ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
    :ivar parameters: Parameter values for the tag scoring function. Required.
    :vartype parameters: ~azure.search.documents.indexes.models.TagScoringParameters
    :ivar type: Indicates the type of function to use. Valid values include magnitude, freshness,
     distance, and tag. The function type must be lower case. Required. Default value is "tag".
    :vartype type: str
    """

    parameters: "_models.TagScoringParameters" = rest_field(
        name="tag", visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameter values for the tag scoring function. Required."""
    type: Literal["tag"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Indicates the type of function to use. Valid values include magnitude, freshness, distance, and
     tag. The function type must be lower case. Required. Default value is \"tag\"."""

    @overload
    def __init__(
        self,
        *,
        field_name: str,
        boost: float,
        parameters: "_models.TagScoringParameters",
        interpolation: Optional[Union[str, "_models.ScoringFunctionInterpolation"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = "tag"  # type: ignore


class TagScoringParameters(_Model):
    """Provides parameter values to a tag scoring function.

    :ivar tags_parameter: The name of the parameter passed in search queries to specify the list of
     tags to compare against the target field. Required.
    :vartype tags_parameter: str
    """

    tags_parameter: str = rest_field(name="tagsParameter", visibility=["read", "create", "update", "delete", "query"])
    """The name of the parameter passed in search queries to specify the list of tags to compare
     against the target field. Required."""

    @overload
    def __init__(
        self,
        *,
        tags_parameter: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TextTranslationSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Text.TranslationSkill"):
    """A skill to translate text from one language to another.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_to_language_code: The language code to translate documents into for documents
     that don't specify the to language explicitly. Required. Known values are: "af", "ar", "bn",
     "bs", "bg", "yue", "ca", "zh-Hans", "zh-Hant", "hr", "cs", "da", "nl", "en", "et", "fj", "fil",
     "fi", "fr", "de", "el", "ht", "he", "hi", "mww", "hu", "is", "id", "it", "ja", "sw", "tlh",
     "tlh-Latn", "tlh-Piqd", "ko", "lv", "lt", "mg", "ms", "mt", "nb", "fa", "pl", "pt", "pt-br",
     "pt-PT", "otq", "ro", "ru", "sm", "sr-Cyrl", "sr-Latn", "sk", "sl", "es", "sv", "ty", "ta",
     "te", "th", "to", "tr", "uk", "ur", "vi", "cy", "yua", "ga", "kn", "mi", "ml", and "pa".
    :vartype default_to_language_code: str or
     ~azure.search.documents.indexes.models.TextTranslationSkillLanguage
    :ivar default_from_language_code: The language code to translate documents from for documents
     that don't specify the from language explicitly. Known values are: "af", "ar", "bn", "bs",
     "bg", "yue", "ca", "zh-Hans", "zh-Hant", "hr", "cs", "da", "nl", "en", "et", "fj", "fil", "fi",
     "fr", "de", "el", "ht", "he", "hi", "mww", "hu", "is", "id", "it", "ja", "sw", "tlh",
     "tlh-Latn", "tlh-Piqd", "ko", "lv", "lt", "mg", "ms", "mt", "nb", "fa", "pl", "pt", "pt-br",
     "pt-PT", "otq", "ro", "ru", "sm", "sr-Cyrl", "sr-Latn", "sk", "sl", "es", "sv", "ty", "ta",
     "te", "th", "to", "tr", "uk", "ur", "vi", "cy", "yua", "ga", "kn", "mi", "ml", and "pa".
    :vartype default_from_language_code: str or
     ~azure.search.documents.indexes.models.TextTranslationSkillLanguage
    :ivar suggested_from: The language code to translate documents from when neither the
     fromLanguageCode input nor the defaultFromLanguageCode parameter are provided, and the
     automatic language detection is unsuccessful. Default is ``en``. Known values are: "af", "ar",
     "bn", "bs", "bg", "yue", "ca", "zh-Hans", "zh-Hant", "hr", "cs", "da", "nl", "en", "et", "fj",
     "fil", "fi", "fr", "de", "el", "ht", "he", "hi", "mww", "hu", "is", "id", "it", "ja", "sw",
     "tlh", "tlh-Latn", "tlh-Piqd", "ko", "lv", "lt", "mg", "ms", "mt", "nb", "fa", "pl", "pt",
     "pt-br", "pt-PT", "otq", "ro", "ru", "sm", "sr-Cyrl", "sr-Latn", "sk", "sl", "es", "sv", "ty",
     "ta", "te", "th", "to", "tr", "uk", "ur", "vi", "cy", "yua", "ga", "kn", "mi", "ml", and "pa".
    :vartype suggested_from: str or
     ~azure.search.documents.indexes.models.TextTranslationSkillLanguage
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Text.TranslationSkill".
    :vartype odata_type: str
    """

    default_to_language_code: Union[str, "_models.TextTranslationSkillLanguage"] = rest_field(
        name="defaultToLanguageCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The language code to translate documents into for documents that don't specify the to language
     explicitly. Required. Known values are: \"af\", \"ar\", \"bn\", \"bs\", \"bg\", \"yue\",
     \"ca\", \"zh-Hans\", \"zh-Hant\", \"hr\", \"cs\", \"da\", \"nl\", \"en\", \"et\", \"fj\",
     \"fil\", \"fi\", \"fr\", \"de\", \"el\", \"ht\", \"he\", \"hi\", \"mww\", \"hu\", \"is\",
     \"id\", \"it\", \"ja\", \"sw\", \"tlh\", \"tlh-Latn\", \"tlh-Piqd\", \"ko\", \"lv\", \"lt\",
     \"mg\", \"ms\", \"mt\", \"nb\", \"fa\", \"pl\", \"pt\", \"pt-br\", \"pt-PT\", \"otq\", \"ro\",
     \"ru\", \"sm\", \"sr-Cyrl\", \"sr-Latn\", \"sk\", \"sl\", \"es\", \"sv\", \"ty\", \"ta\",
     \"te\", \"th\", \"to\", \"tr\", \"uk\", \"ur\", \"vi\", \"cy\", \"yua\", \"ga\", \"kn\",
     \"mi\", \"ml\", and \"pa\"."""
    default_from_language_code: Optional[Union[str, "_models.TextTranslationSkillLanguage"]] = rest_field(
        name="defaultFromLanguageCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The language code to translate documents from for documents that don't specify the from
     language explicitly. Known values are: \"af\", \"ar\", \"bn\", \"bs\", \"bg\", \"yue\", \"ca\",
     \"zh-Hans\", \"zh-Hant\", \"hr\", \"cs\", \"da\", \"nl\", \"en\", \"et\", \"fj\", \"fil\",
     \"fi\", \"fr\", \"de\", \"el\", \"ht\", \"he\", \"hi\", \"mww\", \"hu\", \"is\", \"id\",
     \"it\", \"ja\", \"sw\", \"tlh\", \"tlh-Latn\", \"tlh-Piqd\", \"ko\", \"lv\", \"lt\", \"mg\",
     \"ms\", \"mt\", \"nb\", \"fa\", \"pl\", \"pt\", \"pt-br\", \"pt-PT\", \"otq\", \"ro\", \"ru\",
     \"sm\", \"sr-Cyrl\", \"sr-Latn\", \"sk\", \"sl\", \"es\", \"sv\", \"ty\", \"ta\", \"te\",
     \"th\", \"to\", \"tr\", \"uk\", \"ur\", \"vi\", \"cy\", \"yua\", \"ga\", \"kn\", \"mi\",
     \"ml\", and \"pa\"."""
    suggested_from: Optional[Union[str, "_models.TextTranslationSkillLanguage"]] = rest_field(
        name="suggestedFrom", visibility=["read", "create", "update", "delete", "query"]
    )
    """The language code to translate documents from when neither the fromLanguageCode input nor the
     defaultFromLanguageCode parameter are provided, and the automatic language detection is
     unsuccessful. Default is ``en``. Known values are: \"af\", \"ar\", \"bn\", \"bs\", \"bg\",
     \"yue\", \"ca\", \"zh-Hans\", \"zh-Hant\", \"hr\", \"cs\", \"da\", \"nl\", \"en\", \"et\",
     \"fj\", \"fil\", \"fi\", \"fr\", \"de\", \"el\", \"ht\", \"he\", \"hi\", \"mww\", \"hu\",
     \"is\", \"id\", \"it\", \"ja\", \"sw\", \"tlh\", \"tlh-Latn\", \"tlh-Piqd\", \"ko\", \"lv\",
     \"lt\", \"mg\", \"ms\", \"mt\", \"nb\", \"fa\", \"pl\", \"pt\", \"pt-br\", \"pt-PT\", \"otq\",
     \"ro\", \"ru\", \"sm\", \"sr-Cyrl\", \"sr-Latn\", \"sk\", \"sl\", \"es\", \"sv\", \"ty\",
     \"ta\", \"te\", \"th\", \"to\", \"tr\", \"uk\", \"ur\", \"vi\", \"cy\", \"yua\", \"ga\",
     \"kn\", \"mi\", \"ml\", and \"pa\"."""
    odata_type: Literal["#Microsoft.Skills.Text.TranslationSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Text.TranslationSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        default_to_language_code: Union[str, "_models.TextTranslationSkillLanguage"],
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        default_from_language_code: Optional[Union[str, "_models.TextTranslationSkillLanguage"]] = None,
        suggested_from: Optional[Union[str, "_models.TextTranslationSkillLanguage"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Text.TranslationSkill"  # type: ignore


class TextWeights(_Model):
    """Defines weights on index fields for which matches should boost scoring in search queries.

    :ivar weights: The dictionary of per-field weights to boost document scoring. The keys are
     field names and the values are the weights for each field. Required.
    :vartype weights: dict[str, float]
    """

    weights: dict[str, float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The dictionary of per-field weights to boost document scoring. The keys are field names and the
     values are the weights for each field. Required."""

    @overload
    def __init__(
        self,
        *,
        weights: dict[str, float],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TruncateTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.TruncateTokenFilter"):
    """Truncates the terms to a specific length. This token filter is implemented using Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar length: The length at which terms will be truncated. Default and maximum is 300.
    :vartype length: int
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.TruncateTokenFilter".
    :vartype odata_type: str
    """

    length: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The length at which terms will be truncated. Default and maximum is 300."""
    odata_type: Literal["#Microsoft.Azure.Search.TruncateTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.TruncateTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        length: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.TruncateTokenFilter"  # type: ignore


class UaxUrlEmailTokenizer(LexicalTokenizer, discriminator="#Microsoft.Azure.Search.UaxUrlEmailTokenizer"):
    """Tokenizes urls and emails as one token. This tokenizer is implemented using Apache Lucene.

    :ivar name: The name of the tokenizer. It must only contain letters, digits, spaces, dashes or
     underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar max_token_length: The maximum token length. Default is 255. Tokens longer than the
     maximum length are split. The maximum token length that can be used is 300 characters.
    :vartype max_token_length: int
    :ivar odata_type: A URI fragment specifying the type of tokenizer. Required. Default value is
     "#Microsoft.Azure.Search.UaxUrlEmailTokenizer".
    :vartype odata_type: str
    """

    max_token_length: Optional[int] = rest_field(
        name="maxTokenLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum token length. Default is 255. Tokens longer than the maximum length are split. The
     maximum token length that can be used is 300 characters."""
    odata_type: Literal["#Microsoft.Azure.Search.UaxUrlEmailTokenizer"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of tokenizer. Required. Default value is
     \"#Microsoft.Azure.Search.UaxUrlEmailTokenizer\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        max_token_length: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.UaxUrlEmailTokenizer"  # type: ignore


class UniqueTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.UniqueTokenFilter"):
    """Filters out tokens with same text as the previous token. This token filter is implemented using
    Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar only_on_same_position: A value indicating whether to remove duplicates only at the same
     position. Default is false.
    :vartype only_on_same_position: bool
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.UniqueTokenFilter".
    :vartype odata_type: str
    """

    only_on_same_position: Optional[bool] = rest_field(
        name="onlyOnSamePosition", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to remove duplicates only at the same position. Default is false."""
    odata_type: Literal["#Microsoft.Azure.Search.UniqueTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.UniqueTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        only_on_same_position: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.UniqueTokenFilter"  # type: ignore


class VectorSearch(_Model):
    """Contains configuration options related to vector search.

    :ivar profiles: Defines combinations of configurations to use with vector search.
    :vartype profiles: list[~azure.search.documents.indexes.models.VectorSearchProfile]
    :ivar algorithms: Contains configuration options specific to the algorithm used during indexing
     or querying.
    :vartype algorithms:
     list[~azure.search.documents.indexes.models.VectorSearchAlgorithmConfiguration]
    :ivar vectorizers: Contains configuration options on how to vectorize text vector queries.
    :vartype vectorizers: list[~azure.search.documents.indexes.models.VectorSearchVectorizer]
    :ivar compressions: Contains configuration options specific to the compression method used
     during indexing or querying.
    :vartype compressions: list[~azure.search.documents.indexes.models.VectorSearchCompression]
    """

    profiles: Optional[list["_models.VectorSearchProfile"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines combinations of configurations to use with vector search."""
    algorithms: Optional[list["_models.VectorSearchAlgorithmConfiguration"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains configuration options specific to the algorithm used during indexing or querying."""
    vectorizers: Optional[list["_models.VectorSearchVectorizer"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains configuration options on how to vectorize text vector queries."""
    compressions: Optional[list["_models.VectorSearchCompression"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains configuration options specific to the compression method used during indexing or
     querying."""

    @overload
    def __init__(
        self,
        *,
        profiles: Optional[list["_models.VectorSearchProfile"]] = None,
        algorithms: Optional[list["_models.VectorSearchAlgorithmConfiguration"]] = None,
        vectorizers: Optional[list["_models.VectorSearchVectorizer"]] = None,
        compressions: Optional[list["_models.VectorSearchCompression"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VectorSearchProfile(_Model):
    """Defines a combination of configurations to use with vector search.

    :ivar name: The name to associate with this particular vector search profile. Required.
    :vartype name: str
    :ivar algorithm_configuration_name: The name of the vector search algorithm configuration that
     specifies the algorithm and optional parameters. Required.
    :vartype algorithm_configuration_name: str
    :ivar vectorizer_name: The name of the vectorization being configured for use with vector
     search.
    :vartype vectorizer_name: str
    :ivar compression_name: The name of the compression method configuration that specifies the
     compression method and optional parameters.
    :vartype compression_name: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name to associate with this particular vector search profile. Required."""
    algorithm_configuration_name: str = rest_field(
        name="algorithm", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the vector search algorithm configuration that specifies the algorithm and optional
     parameters. Required."""
    vectorizer_name: Optional[str] = rest_field(
        name="vectorizer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the vectorization being configured for use with vector search."""
    compression_name: Optional[str] = rest_field(
        name="compression", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the compression method configuration that specifies the compression method and
     optional parameters."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        algorithm_configuration_name: str,
        vectorizer_name: Optional[str] = None,
        compression_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VisionVectorizeSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Vision.VectorizeSkill"):
    """Allows you to generate a vector embedding for a given image or text input using the Azure AI
    Services Vision Vectorize API.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar model_version: The version of the model to use when calling the AI Services Vision
     service. It will default to the latest available when not specified. Required.
    :vartype model_version: str
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Vision.VectorizeSkill".
    :vartype odata_type: str
    """

    model_version: str = rest_field(name="modelVersion", visibility=["read", "create", "update", "delete", "query"])
    """The version of the model to use when calling the AI Services Vision service. It will default to
     the latest available when not specified. Required."""
    odata_type: Literal["#Microsoft.Skills.Vision.VectorizeSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Vision.VectorizeSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        model_version: str,
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Vision.VectorizeSkill"  # type: ignore


class WebApiHttpHeaders(_Model):
    """A dictionary of http request headers."""


class WebApiSkill(SearchIndexerSkill, discriminator="#Microsoft.Skills.Custom.WebApiSkill"):
    """A skill that can call a Web API endpoint, allowing you to extend a skillset by having it call
    your custom code.

    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Inputs of the skills could be a column in the source data set, or the output of
     an upstream skill. Required.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: The output of a skill is either a field in a search index, or a value that can
     be consumed as an input by another skill. Required.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar uri: The url for the Web API. Required.
    :vartype uri: str
    :ivar http_headers: The headers required to make the http request.
    :vartype http_headers: ~azure.search.documents.indexes.models.WebApiHttpHeaders
    :ivar http_method: The method for the http request.
    :vartype http_method: str
    :ivar timeout: The desired timeout for the request. Default is 30 seconds.
    :vartype timeout: ~datetime.timedelta
    :ivar batch_size: The desired batch size which indicates number of documents.
    :vartype batch_size: int
    :ivar degree_of_parallelism: If set, the number of parallel calls that can be made to the Web
     API.
    :vartype degree_of_parallelism: int
    :ivar auth_resource_id: Applies to custom skills that connect to external code in an Azure
     function or some other application that provides the transformations. This value should be the
     application ID created for the function or app when it was registered with Azure Active
     Directory. When specified, the custom skill connects to the function or app using a managed ID
     (either system or user-assigned) of the search service and the access token of the function or
     app, using this value as the resource id for creating the scope of the access token.
    :vartype auth_resource_id: str
    :ivar auth_identity: The user-assigned managed identity used for outbound connections. If an
     authResourceId is provided and it's not specified, the system-assigned managed identity is
     used. On updates to the indexer, if the identity is unspecified, the value remains unchanged.
     If set to "none", the value of this property is cleared.
    :vartype auth_identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
    :ivar odata_type: A URI fragment specifying the type of skill. Required. Default value is
     "#Microsoft.Skills.Custom.WebApiSkill".
    :vartype odata_type: str
    """

    uri: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The url for the Web API. Required."""
    http_headers: Optional["_models.WebApiHttpHeaders"] = rest_field(
        name="httpHeaders", visibility=["read", "create", "update", "delete", "query"]
    )
    """The headers required to make the http request."""
    http_method: Optional[str] = rest_field(
        name="httpMethod", visibility=["read", "create", "update", "delete", "query"]
    )
    """The method for the http request."""
    timeout: Optional[datetime.timedelta] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The desired timeout for the request. Default is 30 seconds."""
    batch_size: Optional[int] = rest_field(name="batchSize", visibility=["read", "create", "update", "delete", "query"])
    """The desired batch size which indicates number of documents."""
    degree_of_parallelism: Optional[int] = rest_field(
        name="degreeOfParallelism", visibility=["read", "create", "update", "delete", "query"]
    )
    """If set, the number of parallel calls that can be made to the Web API."""
    auth_resource_id: Optional[str] = rest_field(
        name="authResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Applies to custom skills that connect to external code in an Azure function or some other
     application that provides the transformations. This value should be the application ID created
     for the function or app when it was registered with Azure Active Directory. When specified, the
     custom skill connects to the function or app using a managed ID (either system or
     user-assigned) of the search service and the access token of the function or app, using this
     value as the resource id for creating the scope of the access token."""
    auth_identity: Optional["_models.SearchIndexerDataIdentity"] = rest_field(
        name="authIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user-assigned managed identity used for outbound connections. If an authResourceId is
     provided and it's not specified, the system-assigned managed identity is used. On updates to
     the indexer, if the identity is unspecified, the value remains unchanged. If set to \"none\",
     the value of this property is cleared."""
    odata_type: Literal["#Microsoft.Skills.Custom.WebApiSkill"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of skill. Required. Default value is
     \"#Microsoft.Skills.Custom.WebApiSkill\"."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputFieldMappingEntry"],
        outputs: list["_models.OutputFieldMappingEntry"],
        uri: str,
        name: Optional[str] = None,
        description: Optional[str] = None,
        context: Optional[str] = None,
        http_headers: Optional["_models.WebApiHttpHeaders"] = None,
        http_method: Optional[str] = None,
        timeout: Optional[datetime.timedelta] = None,
        batch_size: Optional[int] = None,
        degree_of_parallelism: Optional[int] = None,
        auth_resource_id: Optional[str] = None,
        auth_identity: Optional["_models.SearchIndexerDataIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Skills.Custom.WebApiSkill"  # type: ignore


class WebApiVectorizer(VectorSearchVectorizer, discriminator="customWebApi"):
    """Specifies a user-defined vectorizer for generating the vector embedding of a query string.
    Integration of an external vectorizer is achieved using the custom Web API interface of a
    skillset.

    :ivar vectorizer_name: The name to associate with this particular vectorization method.
     Required.
    :vartype vectorizer_name: str
    :ivar web_api_parameters: Specifies the properties of the user-defined vectorizer.
    :vartype web_api_parameters: ~azure.search.documents.indexes.models.WebApiVectorizerParameters
    :ivar kind: The name of the kind of vectorization method being configured for use with vector
     search. Required. Generate embeddings using a custom web endpoint at query time.
    :vartype kind: str or ~azure.search.documents.indexes.models.CUSTOM_WEB_API
    """

    web_api_parameters: Optional["_models.WebApiVectorizerParameters"] = rest_field(
        name="customWebApiParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the properties of the user-defined vectorizer."""
    kind: Literal[VectorSearchVectorizerKind.CUSTOM_WEB_API] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The name of the kind of vectorization method being configured for use with vector search.
     Required. Generate embeddings using a custom web endpoint at query time."""

    @overload
    def __init__(
        self,
        *,
        vectorizer_name: str,
        web_api_parameters: Optional["_models.WebApiVectorizerParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = VectorSearchVectorizerKind.CUSTOM_WEB_API  # type: ignore


class WebApiVectorizerParameters(_Model):
    """Specifies the properties for connecting to a user-defined vectorizer.

    :ivar url: The URI of the Web API providing the vectorizer.
    :vartype url: str
    :ivar http_headers: The headers required to make the HTTP request.
    :vartype http_headers: dict[str, str]
    :ivar http_method: The method for the HTTP request.
    :vartype http_method: str
    :ivar timeout: The desired timeout for the request. Default is 30 seconds.
    :vartype timeout: ~datetime.timedelta
    :ivar auth_resource_id: Applies to custom endpoints that connect to external code in an Azure
     function or some other application that provides the transformations. This value should be the
     application ID created for the function or app when it was registered with Azure Active
     Directory. When specified, the vectorization connects to the function or app using a managed ID
     (either system or user-assigned) of the search service and the access token of the function or
     app, using this value as the resource id for creating the scope of the access token.
    :vartype auth_resource_id: str
    :ivar auth_identity: The user-assigned managed identity used for outbound connections. If an
     authResourceId is provided and it's not specified, the system-assigned managed identity is
     used. On updates to the indexer, if the identity is unspecified, the value remains unchanged.
     If set to "none", the value of this property is cleared.
    :vartype auth_identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
    """

    url: Optional[str] = rest_field(name="uri", visibility=["read", "create", "update", "delete", "query"])
    """The URI of the Web API providing the vectorizer."""
    http_headers: Optional[dict[str, str]] = rest_field(
        name="httpHeaders", visibility=["read", "create", "update", "delete", "query"]
    )
    """The headers required to make the HTTP request."""
    http_method: Optional[str] = rest_field(
        name="httpMethod", visibility=["read", "create", "update", "delete", "query"]
    )
    """The method for the HTTP request."""
    timeout: Optional[datetime.timedelta] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The desired timeout for the request. Default is 30 seconds."""
    auth_resource_id: Optional[str] = rest_field(
        name="authResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Applies to custom endpoints that connect to external code in an Azure function or some other
     application that provides the transformations. This value should be the application ID created
     for the function or app when it was registered with Azure Active Directory. When specified, the
     vectorization connects to the function or app using a managed ID (either system or
     user-assigned) of the search service and the access token of the function or app, using this
     value as the resource id for creating the scope of the access token."""
    auth_identity: Optional["_models.SearchIndexerDataIdentity"] = rest_field(
        name="authIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user-assigned managed identity used for outbound connections. If an authResourceId is
     provided and it's not specified, the system-assigned managed identity is used. On updates to
     the indexer, if the identity is unspecified, the value remains unchanged. If set to \"none\",
     the value of this property is cleared."""

    @overload
    def __init__(
        self,
        *,
        url: Optional[str] = None,
        http_headers: Optional[dict[str, str]] = None,
        http_method: Optional[str] = None,
        timeout: Optional[datetime.timedelta] = None,
        auth_resource_id: Optional[str] = None,
        auth_identity: Optional["_models.SearchIndexerDataIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WebKnowledgeSource(KnowledgeSource, discriminator="web"):
    """Knowledge Source targeting web results.

    :ivar name: The name of the knowledge source. Required.
    :vartype name: str
    :ivar description: Optional user-defined description.
    :vartype description: str
    :ivar e_tag: The ETag of the knowledge source.
    :vartype e_tag: str
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your knowledge source
     definition when you want full assurance that no one, not even Microsoft, can decrypt them. Once
     you have encrypted your knowledge source definition, it will always remain encrypted. The
     search service will ignore attempts to set this property to null. You can change this property
     as needed if you want to rotate your encryption key; Your knowledge source definition will be
     unaffected. Encryption with customer-managed keys is not available for free search services,
     and is only available for paid services created on or after January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :ivar kind: Required. A knowledge source that reads data from the web.
    :vartype kind: str or ~azure.search.documents.indexes.models.WEB
    :ivar web_parameters: The parameters for the web knowledge source.
    :vartype web_parameters: ~azure.search.documents.indexes.models.WebKnowledgeSourceParameters
    """

    kind: Literal[KnowledgeSourceKind.WEB] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. A knowledge source that reads data from the web."""
    web_parameters: Optional["_models.WebKnowledgeSourceParameters"] = rest_field(
        name="webParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """The parameters for the web knowledge source."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        e_tag: Optional[str] = None,
        encryption_key: Optional["_models.SearchResourceEncryptionKey"] = None,
        web_parameters: Optional["_models.WebKnowledgeSourceParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeSourceKind.WEB  # type: ignore


class WebKnowledgeSourceDomain(_Model):
    """Configuration for web knowledge source domain.

    :ivar address: The address of the domain. Required.
    :vartype address: str
    :ivar include_subpages: Whether or not to include subpages from this domain.
    :vartype include_subpages: bool
    """

    address: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The address of the domain. Required."""
    include_subpages: Optional[bool] = rest_field(
        name="includeSubpages", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether or not to include subpages from this domain."""

    @overload
    def __init__(
        self,
        *,
        address: str,
        include_subpages: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WebKnowledgeSourceDomains(_Model):
    """Domain allow/block configuration for web knowledge source.

    :ivar allowed_domains: Domains that are allowed for web results.
    :vartype allowed_domains: list[~azure.search.documents.indexes.models.WebKnowledgeSourceDomain]
    :ivar blocked_domains: Domains that are blocked from web results.
    :vartype blocked_domains: list[~azure.search.documents.indexes.models.WebKnowledgeSourceDomain]
    """

    allowed_domains: Optional[list["_models.WebKnowledgeSourceDomain"]] = rest_field(
        name="allowedDomains", visibility=["read", "create", "update", "delete", "query"]
    )
    """Domains that are allowed for web results."""
    blocked_domains: Optional[list["_models.WebKnowledgeSourceDomain"]] = rest_field(
        name="blockedDomains", visibility=["read", "create", "update", "delete", "query"]
    )
    """Domains that are blocked from web results."""

    @overload
    def __init__(
        self,
        *,
        allowed_domains: Optional[list["_models.WebKnowledgeSourceDomain"]] = None,
        blocked_domains: Optional[list["_models.WebKnowledgeSourceDomain"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WebKnowledgeSourceParameters(_Model):
    """Parameters for web knowledge source.

    :ivar domains: Domain allow/block configuration for web results.
    :vartype domains: ~azure.search.documents.indexes.models.WebKnowledgeSourceDomains
    """

    domains: Optional["_models.WebKnowledgeSourceDomains"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Domain allow/block configuration for web results."""

    @overload
    def __init__(
        self,
        *,
        domains: Optional["_models.WebKnowledgeSourceDomains"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WordDelimiterTokenFilter(TokenFilter, discriminator="#Microsoft.Azure.Search.WordDelimiterTokenFilter"):
    """Splits words into subwords and performs optional transformations on subword groups. This token
    filter is implemented using Apache Lucene.

    :ivar name: The name of the token filter. It must only contain letters, digits, spaces, dashes
     or underscores, can only start and end with alphanumeric characters, and is limited to 128
     characters. Required.
    :vartype name: str
    :ivar generate_word_parts: A value indicating whether to generate part words. If set, causes
     parts of words to be generated; for example "AzureSearch" becomes "Azure" "Search". Default is
     true.
    :vartype generate_word_parts: bool
    :ivar generate_number_parts: A value indicating whether to generate number subwords. Default is
     true.
    :vartype generate_number_parts: bool
    :ivar catenate_words: A value indicating whether maximum runs of word parts will be catenated.
     For example, if this is set to true, "Azure-Search" becomes "AzureSearch". Default is false.
    :vartype catenate_words: bool
    :ivar catenate_numbers: A value indicating whether maximum runs of number parts will be
     catenated. For example, if this is set to true, "1-2" becomes "12". Default is false.
    :vartype catenate_numbers: bool
    :ivar catenate_all: A value indicating whether all subword parts will be catenated. For
     example, if this is set to true, "Azure-Search-1" becomes "AzureSearch1". Default is false.
    :vartype catenate_all: bool
    :ivar split_on_case_change: A value indicating whether to split words on caseChange. For
     example, if this is set to true, "AzureSearch" becomes "Azure" "Search". Default is true.
    :vartype split_on_case_change: bool
    :ivar preserve_original: A value indicating whether original words will be preserved and added
     to the subword list. Default is false.
    :vartype preserve_original: bool
    :ivar split_on_numerics: A value indicating whether to split on numbers. For example, if this
     is set to true, "Azure1Search" becomes "Azure" "1" "Search". Default is true.
    :vartype split_on_numerics: bool
    :ivar stem_english_possessive: A value indicating whether to remove trailing "'s" for each
     subword. Default is true.
    :vartype stem_english_possessive: bool
    :ivar protected_words: A list of tokens to protect from being delimited.
    :vartype protected_words: list[str]
    :ivar odata_type: A URI fragment specifying the type of token filter. Required. Default value
     is "#Microsoft.Azure.Search.WordDelimiterTokenFilter".
    :vartype odata_type: str
    """

    generate_word_parts: Optional[bool] = rest_field(
        name="generateWordParts", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to generate part words. If set, causes parts of words to be
     generated; for example \"AzureSearch\" becomes \"Azure\" \"Search\". Default is true."""
    generate_number_parts: Optional[bool] = rest_field(
        name="generateNumberParts", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to generate number subwords. Default is true."""
    catenate_words: Optional[bool] = rest_field(
        name="catenateWords", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether maximum runs of word parts will be catenated. For example, if this
     is set to true, \"Azure-Search\" becomes \"AzureSearch\". Default is false."""
    catenate_numbers: Optional[bool] = rest_field(
        name="catenateNumbers", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether maximum runs of number parts will be catenated. For example, if this
     is set to true, \"1-2\" becomes \"12\". Default is false."""
    catenate_all: Optional[bool] = rest_field(
        name="catenateAll", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether all subword parts will be catenated. For example, if this is set to
     true, \"Azure-Search-1\" becomes \"AzureSearch1\". Default is false."""
    split_on_case_change: Optional[bool] = rest_field(
        name="splitOnCaseChange", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to split words on caseChange. For example, if this is set to true,
     \"AzureSearch\" becomes \"Azure\" \"Search\". Default is true."""
    preserve_original: Optional[bool] = rest_field(
        name="preserveOriginal", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether original words will be preserved and added to the subword list.
     Default is false."""
    split_on_numerics: Optional[bool] = rest_field(
        name="splitOnNumerics", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to split on numbers. For example, if this is set to true,
     \"Azure1Search\" becomes \"Azure\" \"1\" \"Search\". Default is true."""
    stem_english_possessive: Optional[bool] = rest_field(
        name="stemEnglishPossessive", visibility=["read", "create", "update", "delete", "query"]
    )
    """A value indicating whether to remove trailing \"'s\" for each subword. Default is true."""
    protected_words: Optional[list[str]] = rest_field(
        name="protectedWords", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of tokens to protect from being delimited."""
    odata_type: Literal["#Microsoft.Azure.Search.WordDelimiterTokenFilter"] = rest_discriminator(name="@odata.type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A URI fragment specifying the type of token filter. Required. Default value is
     \"#Microsoft.Azure.Search.WordDelimiterTokenFilter\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        generate_word_parts: Optional[bool] = None,
        generate_number_parts: Optional[bool] = None,
        catenate_words: Optional[bool] = None,
        catenate_numbers: Optional[bool] = None,
        catenate_all: Optional[bool] = None,
        split_on_case_change: Optional[bool] = None,
        preserve_original: Optional[bool] = None,
        split_on_numerics: Optional[bool] = None,
        stem_english_possessive: Optional[bool] = None,
        protected_words: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.odata_type = "#Microsoft.Azure.Search.WordDelimiterTokenFilter"  # type: ignore
