
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Graphic3d_Structure.hxx>
#include <Graphic3d_TransformPers.hxx>
#include <SelectMgr_Selection.hxx>
#include <gp_Trsf.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <SelectMgr_EntityOwner.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Graphic3d_Camera.hxx>
#include <SelectMgr_FrustumBuilder.hxx>
#include <SelectMgr_ViewClipRange.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <V3d_Viewer.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <SelectMgr_EntityOwner.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <SelectMgr_EntityOwner.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <SelectMgr_EntityOwner.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <SelectMgr_EntityOwner.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <SelectMgr_ViewerSelector.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <SelectMgr_EntityOwner.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Ax1.hxx>
#include <Graphic3d_SequenceOfHClipPlane.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <SelectMgr_SensitiveEntitySet.hxx>
#include <V3d_View.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <SelectMgr.hxx>
#include <SelectMgr_AndFilter.hxx>
#include <SelectMgr_AndOrFilter.hxx>
#include <SelectMgr_AxisIntersector.hxx>
#include <SelectMgr_BaseFrustum.hxx>
#include <SelectMgr_BaseIntersector.hxx>
#include <SelectMgr_BVHThreadPool.hxx>
#include <SelectMgr_CompositionFilter.hxx>
#include <SelectMgr_EntityOwner.hxx>
#include <SelectMgr_Filter.hxx>
#include <SelectMgr_FilterType.hxx>
#include <SelectMgr_Frustum.hxx>
#include <SelectMgr_FrustumBuilder.hxx>
#include <SelectMgr_IndexedDataMapOfOwnerCriterion.hxx>
#include <SelectMgr_IndexedMapOfOwner.hxx>
#include <SelectMgr_ListIteratorOfListOfFilter.hxx>
#include <SelectMgr_ListOfFilter.hxx>
#include <SelectMgr_OrFilter.hxx>
#include <SelectMgr_PickingStrategy.hxx>
#include <SelectMgr_RectangularFrustum.hxx>
#include <SelectMgr_SelectableObject.hxx>
#include <SelectMgr_SelectableObjectSet.hxx>
#include <SelectMgr_SelectingVolumeManager.hxx>
#include <SelectMgr_Selection.hxx>
#include <SelectMgr_SelectionImageFiller.hxx>
#include <SelectMgr_SelectionManager.hxx>
#include <SelectMgr_SelectionType.hxx>
#include <SelectMgr_SensitiveEntity.hxx>
#include <SelectMgr_SensitiveEntitySet.hxx>
#include <SelectMgr_SequenceOfOwner.hxx>
#include <SelectMgr_SequenceOfSelection.hxx>
#include <SelectMgr_SortCriterion.hxx>
#include <SelectMgr_StateOfSelection.hxx>
#include <SelectMgr_ToleranceMap.hxx>
#include <SelectMgr_TriangularFrustum.hxx>
#include <SelectMgr_TriangularFrustumSet.hxx>
#include <SelectMgr_TypeOfBVHUpdate.hxx>
#include <SelectMgr_TypeOfDepthTolerance.hxx>
#include <SelectMgr_TypeOfUpdate.hxx>
#include <SelectMgr_VectorTypes.hxx>
#include <SelectMgr_ViewClipRange.hxx>
#include <SelectMgr_ViewerSelector.hxx>
#include <SelectMgr_ViewerSelector3d.hxx>

// template related includes

// ./opencascade/SelectMgr_IndexedDataMapOfOwnerCriterion.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/SelectMgr_ListOfFilter.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/SelectMgr_ListOfFilter.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/SelectMgr_SensitiveEntitySet.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/SelectMgr_SequenceOfOwner.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/SelectMgr_SequenceOfSelection.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/SelectMgr_TriangularFrustumSet.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/SelectMgr_VectorTypes.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/SelectMgr_ViewerSelector.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_SelectMgr(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("SelectMgr"));
py::object klass;

//Python trampoline classes
    class Py_SelectMgr_BaseIntersector : public SelectMgr_BaseIntersector{
    public:
        using SelectMgr_BaseIntersector::SelectMgr_BaseIntersector;


        // public pure virtual
        void Build() override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,Build,) };
        Standard_Boolean IsScalable() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,IsScalable,) };
        handle<SelectMgr_BaseIntersector> ScaleAndTransform( const Standard_Integer theScaleFactor, const gp_GTrsf & theTrsf, const handle<SelectMgr_FrustumBuilder> & theBuilder) const  override { using return_type = handle<SelectMgr_BaseIntersector>;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,ScaleAndTransform,theScaleFactor,theTrsf,theBuilder) };
        handle<SelectMgr_BaseIntersector> CopyWithBuilder( const handle<SelectMgr_FrustumBuilder> & theBuilder) const  override { using return_type = handle<SelectMgr_BaseIntersector>;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,CopyWithBuilder,theBuilder) };
        Standard_Boolean OverlapsBox( const SelectMgr_Vec3 & theBoxMin, const SelectMgr_Vec3 & theBoxMax, const SelectMgr_ViewClipRange & theClipRange,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsBox,theBoxMin,theBoxMax,theClipRange,thePickResult) };
        Standard_Boolean OverlapsBox( const SelectMgr_Vec3 & theBoxMin, const SelectMgr_Vec3 & theBoxMax,Standard_Boolean * theInside) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsBox,theBoxMin,theBoxMax,theInside) };
        Standard_Boolean OverlapsPoint( const gp_Pnt & thePnt, const SelectMgr_ViewClipRange & theClipRange,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsPoint,thePnt,theClipRange,thePickResult) };
        Standard_Boolean OverlapsPoint( const gp_Pnt & thePnt) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsPoint,thePnt) };
        Standard_Boolean OverlapsPolygon( const TColgp_Array1OfPnt & theArrayOfPnts,Select3D_TypeOfSensitivity theSensType, const SelectMgr_ViewClipRange & theClipRange,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsPolygon,theArrayOfPnts,theSensType,theClipRange,thePickResult) };
        Standard_Boolean OverlapsSegment( const gp_Pnt & thePnt1, const gp_Pnt & thePnt2, const SelectMgr_ViewClipRange & theClipRange,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsSegment,thePnt1,thePnt2,theClipRange,thePickResult) };
        Standard_Boolean OverlapsTriangle( const gp_Pnt & thePnt1, const gp_Pnt & thePnt2, const gp_Pnt & thePnt3,Select3D_TypeOfSensitivity theSensType, const SelectMgr_ViewClipRange & theClipRange,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsTriangle,thePnt1,thePnt2,thePnt3,theSensType,theClipRange,thePickResult) };
        Standard_Boolean OverlapsSphere( const gp_Pnt & theCenter, const Standard_Real theRadius,Standard_Boolean * theInside) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsSphere,theCenter,theRadius,theInside) };
        Standard_Boolean OverlapsSphere( const gp_Pnt & theCenter, const Standard_Real theRadius, const SelectMgr_ViewClipRange & theClipRange,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsSphere,theCenter,theRadius,theClipRange,thePickResult) };
        Standard_Boolean OverlapsCylinder( const Standard_Real theBottomRad, const Standard_Real theTopRad, const Standard_Real theHeight, const gp_Trsf & theTrsf, const Standard_Boolean theIsHollow, const SelectMgr_ViewClipRange & theClipRange,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsCylinder,theBottomRad,theTopRad,theHeight,theTrsf,theIsHollow,theClipRange,thePickResult) };
        Standard_Boolean OverlapsCylinder( const Standard_Real theBottomRad, const Standard_Real theTopRad, const Standard_Real theHeight, const gp_Trsf & theTrsf, const Standard_Boolean theIsHollow,Standard_Boolean * theInside) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsCylinder,theBottomRad,theTopRad,theHeight,theTrsf,theIsHollow,theInside) };
        Standard_Boolean OverlapsCircle( const Standard_Real theBottomRad, const gp_Trsf & theTrsf, const Standard_Boolean theIsFilled, const SelectMgr_ViewClipRange & theClipRange,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsCircle,theBottomRad,theTrsf,theIsFilled,theClipRange,thePickResult) };
        Standard_Boolean OverlapsCircle( const Standard_Real theBottomRad, const gp_Trsf & theTrsf, const Standard_Boolean theIsFilled,Standard_Boolean * theInside) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsCircle,theBottomRad,theTrsf,theIsFilled,theInside) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_SelectMgr_Filter : public SelectMgr_Filter{
    public:
        using SelectMgr_Filter::SelectMgr_Filter;


        // public pure virtual
        Standard_Boolean IsOk( const handle<SelectMgr_EntityOwner> & anObj) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_Filter,IsOk,anObj) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_SelectMgr_SelectableObject : public SelectMgr_SelectableObject{
    public:
        using SelectMgr_SelectableObject::SelectMgr_SelectableObject;


        // public pure virtual
        void ComputeSelection( const handle<SelectMgr_Selection> & theSelection, const Standard_Integer theMode) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_SelectableObject,ComputeSelection,theSelection,theMode) };


        // protected pure virtual

        void Compute( const handle<PrsMgr_PresentationManager> & thePrsMgr, const handle<Prs3d_Presentation> & thePrs, const Standard_Integer theMode) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,PrsMgr_PresentableObject,Compute,thePrsMgr,thePrs,theMode) };

        // private pure virtual

    };
    class Py_SelectMgr_SelectionImageFiller : public SelectMgr_SelectionImageFiller{
    public:
        using SelectMgr_SelectionImageFiller::SelectMgr_SelectionImageFiller;


        // public pure virtual
        void Fill( const Standard_Integer theCol, const Standard_Integer theRow, const Standard_Integer thePicked) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_SelectionImageFiller,Fill,theCol,theRow,thePicked) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_SelectMgr_BaseFrustum : public SelectMgr_BaseFrustum{
    public:
        using SelectMgr_BaseFrustum::SelectMgr_BaseFrustum;


        // public pure virtual

        void Build() override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,Build,) };
        Standard_Boolean IsScalable() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,IsScalable,) };
        handle<SelectMgr_BaseIntersector> ScaleAndTransform( const Standard_Integer theScaleFactor, const gp_GTrsf & theTrsf, const handle<SelectMgr_FrustumBuilder> & theBuilder) const  override { using return_type = handle<SelectMgr_BaseIntersector>;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,ScaleAndTransform,theScaleFactor,theTrsf,theBuilder) };
        handle<SelectMgr_BaseIntersector> CopyWithBuilder( const handle<SelectMgr_FrustumBuilder> & theBuilder) const  override { using return_type = handle<SelectMgr_BaseIntersector>;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,CopyWithBuilder,theBuilder) };
        Standard_Boolean OverlapsBox( const SelectMgr_Vec3 & theBoxMin, const SelectMgr_Vec3 & theBoxMax, const SelectMgr_ViewClipRange & theClipRange,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsBox,theBoxMin,theBoxMax,theClipRange,thePickResult) };
        Standard_Boolean OverlapsBox( const SelectMgr_Vec3 & theBoxMin, const SelectMgr_Vec3 & theBoxMax,Standard_Boolean * theInside) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsBox,theBoxMin,theBoxMax,theInside) };
        Standard_Boolean OverlapsPoint( const gp_Pnt & thePnt, const SelectMgr_ViewClipRange & theClipRange,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsPoint,thePnt,theClipRange,thePickResult) };
        Standard_Boolean OverlapsPoint( const gp_Pnt & thePnt) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsPoint,thePnt) };
        Standard_Boolean OverlapsPolygon( const TColgp_Array1OfPnt & theArrayOfPnts,Select3D_TypeOfSensitivity theSensType, const SelectMgr_ViewClipRange & theClipRange,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsPolygon,theArrayOfPnts,theSensType,theClipRange,thePickResult) };
        Standard_Boolean OverlapsSegment( const gp_Pnt & thePnt1, const gp_Pnt & thePnt2, const SelectMgr_ViewClipRange & theClipRange,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsSegment,thePnt1,thePnt2,theClipRange,thePickResult) };
        Standard_Boolean OverlapsTriangle( const gp_Pnt & thePnt1, const gp_Pnt & thePnt2, const gp_Pnt & thePnt3,Select3D_TypeOfSensitivity theSensType, const SelectMgr_ViewClipRange & theClipRange,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsTriangle,thePnt1,thePnt2,thePnt3,theSensType,theClipRange,thePickResult) };
        Standard_Boolean OverlapsSphere( const gp_Pnt & theCenter, const Standard_Real theRadius,Standard_Boolean * theInside) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsSphere,theCenter,theRadius,theInside) };
        Standard_Boolean OverlapsSphere( const gp_Pnt & theCenter, const Standard_Real theRadius, const SelectMgr_ViewClipRange & theClipRange,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsSphere,theCenter,theRadius,theClipRange,thePickResult) };
        Standard_Boolean OverlapsCylinder( const Standard_Real theBottomRad, const Standard_Real theTopRad, const Standard_Real theHeight, const gp_Trsf & theTrsf, const Standard_Boolean theIsHollow, const SelectMgr_ViewClipRange & theClipRange,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsCylinder,theBottomRad,theTopRad,theHeight,theTrsf,theIsHollow,theClipRange,thePickResult) };
        Standard_Boolean OverlapsCylinder( const Standard_Real theBottomRad, const Standard_Real theTopRad, const Standard_Real theHeight, const gp_Trsf & theTrsf, const Standard_Boolean theIsHollow,Standard_Boolean * theInside) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsCylinder,theBottomRad,theTopRad,theHeight,theTrsf,theIsHollow,theInside) };
        Standard_Boolean OverlapsCircle( const Standard_Real theBottomRad, const gp_Trsf & theTrsf, const Standard_Boolean theIsFilled, const SelectMgr_ViewClipRange & theClipRange,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsCircle,theBottomRad,theTrsf,theIsFilled,theClipRange,thePickResult) };
        Standard_Boolean OverlapsCircle( const Standard_Real theBottomRad, const gp_Trsf & theTrsf, const Standard_Boolean theIsFilled,Standard_Boolean * theInside) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_BaseIntersector,OverlapsCircle,theBottomRad,theTrsf,theIsFilled,theInside) };

        // protected pure virtual


        // private pure virtual

    };
    class Py_SelectMgr_CompositionFilter : public SelectMgr_CompositionFilter{
    public:
        using SelectMgr_CompositionFilter::SelectMgr_CompositionFilter;


        // public pure virtual

        Standard_Boolean IsOk( const handle<SelectMgr_EntityOwner> & anObj) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectMgr_Filter,IsOk,anObj) };

        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class SelectMgr from ./opencascade/SelectMgr.hxx
    klass = m.attr("SelectMgr");

    // default constructor
    register_default_constructor<SelectMgr , shared_ptr<SelectMgr>>(m,"SelectMgr");

    // nested enums

    static_cast<py::class_<SelectMgr , shared_ptr<SelectMgr>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("ComputeSensitivePrs_s",
                    (void (*)(  const handle<Graphic3d_Structure> & ,   const handle<SelectMgr_Selection> & ,   const gp_Trsf & ,   const handle<Graphic3d_TransformPers> &  ) ) static_cast<void (*)(  const handle<Graphic3d_Structure> & ,   const handle<SelectMgr_Selection> & ,   const gp_Trsf & ,   const handle<Graphic3d_TransformPers> &  ) >(&SelectMgr::ComputeSensitivePrs),
                    R"#(Compute debug presentation for sensitive objects.)#"  , py::arg("theStructure"),  py::arg("theSel"),  py::arg("theLoc"),  py::arg("theTrsfPers")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class SelectMgr_BVHThreadPool from ./opencascade/SelectMgr_BVHThreadPool.hxx
    klass = m.attr("SelectMgr_BVHThreadPool");


    // nested enums

    static_cast<py::class_<SelectMgr_BVHThreadPool ,opencascade::handle<SelectMgr_BVHThreadPool>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init< Standard_Integer >()  , py::arg("theNbThreads") )
    // custom constructors
    // methods
        .def("AddEntity",
             (void (SelectMgr_BVHThreadPool::*)(  const handle<Select3D_SensitiveEntity> &  ) ) static_cast<void (SelectMgr_BVHThreadPool::*)(  const handle<Select3D_SensitiveEntity> &  ) >(&SelectMgr_BVHThreadPool::AddEntity),
             R"#(Queue a sensitive entity to build its BVH)#"  , py::arg("theEntity")
          )
        .def("StopThreads",
             (void (SelectMgr_BVHThreadPool::*)() ) static_cast<void (SelectMgr_BVHThreadPool::*)() >(&SelectMgr_BVHThreadPool::StopThreads),
             R"#(Stops threads)#" 
          )
        .def("WaitThreads",
             (void (SelectMgr_BVHThreadPool::*)() ) static_cast<void (SelectMgr_BVHThreadPool::*)() >(&SelectMgr_BVHThreadPool::WaitThreads),
             R"#(Waits for all threads finish their jobs)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_BVHThreadPool::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_BVHThreadPool::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_BVHThreadPool::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_BVHThreadPool::*)() const>(&SelectMgr_BVHThreadPool::DynamicType),
             R"#()#"
             
         )
       .def("Threads",
             (NCollection_Array1<SelectMgr_BVHThreadPool::BVHThread> & (SelectMgr_BVHThreadPool::*)() ) static_cast<NCollection_Array1<SelectMgr_BVHThreadPool::BVHThread> & (SelectMgr_BVHThreadPool::*)() >(&SelectMgr_BVHThreadPool::Threads),
             R"#(Returns array of threads)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class SelectMgr_BaseIntersector from ./opencascade/SelectMgr_BaseIntersector.hxx
    klass = m.attr("SelectMgr_BaseIntersector");


    // nested enums

    static_cast<py::class_<SelectMgr_BaseIntersector ,opencascade::handle<SelectMgr_BaseIntersector> ,Py_SelectMgr_BaseIntersector , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Build",
             (void (SelectMgr_BaseIntersector::*)() ) static_cast<void (SelectMgr_BaseIntersector::*)() >(&SelectMgr_BaseIntersector::Build),
             R"#(Builds intersector according to internal parameters)#" 
          )
        .def("GetSelectionType",
             (SelectMgr_SelectionType (SelectMgr_BaseIntersector::*)() const) static_cast<SelectMgr_SelectionType (SelectMgr_BaseIntersector::*)() const>(&SelectMgr_BaseIntersector::GetSelectionType),
             R"#(Returns selection type of this intersector)#" 
          )
        .def("IsScalable",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)() const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)() const>(&SelectMgr_BaseIntersector::IsScalable),
             R"#(Checks if it is possible to scale this intersector.)#" 
          )
        .def("SetPixelTolerance",
             (void (SelectMgr_BaseIntersector::*)(  const Standard_Integer  ) ) static_cast<void (SelectMgr_BaseIntersector::*)(  const Standard_Integer  ) >(&SelectMgr_BaseIntersector::SetPixelTolerance),
             R"#(Sets pixel tolerance. It makes sense only for scalable intersectors (built on a single point). This method does nothing for the base class.)#"  , py::arg("theTol")
          )
        .def("ScaleAndTransform",
             (handle<SelectMgr_BaseIntersector> (SelectMgr_BaseIntersector::*)(  const Standard_Integer ,   const gp_GTrsf & ,   const handle<SelectMgr_FrustumBuilder> &  ) const) static_cast<handle<SelectMgr_BaseIntersector> (SelectMgr_BaseIntersector::*)(  const Standard_Integer ,   const gp_GTrsf & ,   const handle<SelectMgr_FrustumBuilder> &  ) const>(&SelectMgr_BaseIntersector::ScaleAndTransform),
             R"#(Note that this method does not perform any checks on type of the frustum.)#"  , py::arg("theScaleFactor"),  py::arg("theTrsf"),  py::arg("theBuilder")
          )
        .def("CopyWithBuilder",
             (handle<SelectMgr_BaseIntersector> (SelectMgr_BaseIntersector::*)(  const handle<SelectMgr_FrustumBuilder> &  ) const) static_cast<handle<SelectMgr_BaseIntersector> (SelectMgr_BaseIntersector::*)(  const handle<SelectMgr_FrustumBuilder> &  ) const>(&SelectMgr_BaseIntersector::CopyWithBuilder),
             R"#(Returns a copy of the frustum with the input builder assigned)#"  , py::arg("theBuilder")
          )
        .def("SetCamera",
             (void (SelectMgr_BaseIntersector::*)(  const handle<Graphic3d_Camera> &  ) ) static_cast<void (SelectMgr_BaseIntersector::*)(  const handle<Graphic3d_Camera> &  ) >(&SelectMgr_BaseIntersector::SetCamera),
             R"#(Saves camera definition.)#"  , py::arg("theCamera")
          )
        .def("SetWindowSize",
             (void (SelectMgr_BaseIntersector::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_BaseIntersector::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&SelectMgr_BaseIntersector::SetWindowSize),
             R"#(Sets current window size. This method does nothing for the base class.)#"  , py::arg("theWidth"),  py::arg("theHeight")
          )
        .def("SetViewport",
             (void (SelectMgr_BaseIntersector::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<void (SelectMgr_BaseIntersector::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) >(&SelectMgr_BaseIntersector::SetViewport),
             R"#(Sets viewport parameters. This method does nothing for the base class.)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theWidth"),  py::arg("theHeight")
          )
        .def("GetPlanes",
             (void (SelectMgr_BaseIntersector::*)( NCollection_Vector<SelectMgr_Vec4> &  ) const) static_cast<void (SelectMgr_BaseIntersector::*)( NCollection_Vector<SelectMgr_Vec4> &  ) const>(&SelectMgr_BaseIntersector::GetPlanes),
             R"#(Stores plane equation coefficients (in the following form: Ax + By + Cz + D = 0) to the given vector. This method only clears input vector for the base class.)#"  , py::arg("thePlaneEquations")
          )
        .def("OverlapsBox",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_BaseIntersector::OverlapsBox),
             R"#(SAT intersection test between defined volume and given axis-aligned box)#"  , py::arg("theBoxMin"),  py::arg("theBoxMax"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsBox",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,  Standard_Boolean *  ) const>(&SelectMgr_BaseIntersector::OverlapsBox),
             R"#(Returns true if selecting volume is overlapped by axis-aligned bounding box with minimum corner at point theMinPt and maximum at point theMaxPt)#"  , py::arg("theBoxMin"),  py::arg("theBoxMax"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("OverlapsPoint",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)(  const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)(  const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_BaseIntersector::OverlapsPoint),
             R"#(Intersection test between defined volume and given point)#"  , py::arg("thePnt"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsPoint",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)(  const gp_Pnt &  ) const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)(  const gp_Pnt &  ) const>(&SelectMgr_BaseIntersector::OverlapsPoint),
             R"#(Intersection test between defined volume and given point Does not perform depth calculation, so this method is defined as helper function for inclusion test. Therefore, its implementation makes sense only for rectangular frustum with box selection mode activated.)#"  , py::arg("thePnt")
          )
        .def("OverlapsPolygon",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)(  const TColgp_Array1OfPnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)(  const TColgp_Array1OfPnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_BaseIntersector::OverlapsPolygon),
             R"#(SAT intersection test between defined volume and given ordered set of points, representing line segments. The test may be considered of interior part or boundary line defined by segments depending on given sensitivity type)#"  , py::arg("theArrayOfPnts"),  py::arg("theSensType"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsSegment",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_BaseIntersector::OverlapsSegment),
             R"#(Checks if line segment overlaps selecting frustum)#"  , py::arg("thePnt1"),  py::arg("thePnt2"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsTriangle",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_BaseIntersector::OverlapsTriangle),
             R"#(SAT intersection test between defined volume and given triangle. The test may be considered of interior part or boundary line defined by triangle vertices depending on given sensitivity type)#"  , py::arg("thePnt1"),  py::arg("thePnt2"),  py::arg("thePnt3"),  py::arg("theSensType"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsSphere",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)(  const gp_Pnt & ,   const Standard_Real ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)(  const gp_Pnt & ,   const Standard_Real ,  Standard_Boolean *  ) const>(&SelectMgr_BaseIntersector::OverlapsSphere),
             R"#(Returns true if selecting volume is overlapped by sphere with center theCenter and radius theRadius)#"  , py::arg("theCenter"),  py::arg("theRadius"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("OverlapsSphere",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)(  const gp_Pnt & ,   const Standard_Real ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)(  const gp_Pnt & ,   const Standard_Real ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_BaseIntersector::OverlapsSphere),
             R"#(Returns true if selecting volume is overlapped by sphere with center theCenter and radius theRadius)#"  , py::arg("theCenter"),  py::arg("theRadius"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsCylinder",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_BaseIntersector::OverlapsCylinder),
             R"#(Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses theBottomRad and theTopRad, height theHeight and transformation to apply theTrsf.)#"  , py::arg("theBottomRad"),  py::arg("theTopRad"),  py::arg("theHeight"),  py::arg("theTrsf"),  py::arg("theIsHollow"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsCylinder",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const>(&SelectMgr_BaseIntersector::OverlapsCylinder),
             R"#(Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses theBottomRad and theTopRad, height theHeight and transformation to apply theTrsf.)#"  , py::arg("theBottomRad"),  py::arg("theTopRad"),  py::arg("theHeight"),  py::arg("theTrsf"),  py::arg("theIsHollow"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("OverlapsCircle",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_BaseIntersector::OverlapsCircle),
             R"#(Returns true if selecting volume is overlapped by circle with radius theRadius, boolean theIsFilled and transformation to apply theTrsf. The position and orientation of the circle are specified via theTrsf transformation for gp::XOY() with center in gp::Origin().)#"  , py::arg("theBottomRad"),  py::arg("theTrsf"),  py::arg("theIsFilled"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsCircle",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const>(&SelectMgr_BaseIntersector::OverlapsCircle),
             R"#(Returns true if selecting volume is overlapped by circle with radius theRadius, boolean theIsFilled and transformation to apply theTrsf. The position and orientation of the circle are specified via theTrsf transformation for gp::XOY() with center in gp::Origin().)#"  , py::arg("theBottomRad"),  py::arg("theTrsf"),  py::arg("theIsFilled"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("DistToGeometryCenter",
             (Standard_Real (SelectMgr_BaseIntersector::*)(  const gp_Pnt &  ) const) static_cast<Standard_Real (SelectMgr_BaseIntersector::*)(  const gp_Pnt &  ) const>(&SelectMgr_BaseIntersector::DistToGeometryCenter),
             R"#(Measures distance between 3d projection of user-picked screen point and given point theCOG. It makes sense only for intersectors built on a single point. This method returns infinite value for the base class.)#"  , py::arg("theCOG")
          )
        .def("DetectedPoint",
             (gp_Pnt (SelectMgr_BaseIntersector::*)(  const Standard_Real  ) const) static_cast<gp_Pnt (SelectMgr_BaseIntersector::*)(  const Standard_Real  ) const>(&SelectMgr_BaseIntersector::DetectedPoint),
             R"#(Calculates the point on a view ray that was detected during the run of selection algo by given depth. It makes sense only for intersectors built on a single point. This method returns infinite point for the base class.)#"  , py::arg("theDepth")
          )
        .def("DumpJson",
             (void (SelectMgr_BaseIntersector::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (SelectMgr_BaseIntersector::*)( Standard_OStream & ,  Standard_Integer  ) const>(&SelectMgr_BaseIntersector::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("RaySphereIntersection",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)(  const gp_Pnt & ,   const Standard_Real ,   const gp_Pnt & ,   const gp_Dir & ,  Standard_Real & ,  Standard_Real &  ) const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)(  const gp_Pnt & ,   const Standard_Real ,   const gp_Pnt & ,   const gp_Dir & ,  Standard_Real & ,  Standard_Real &  ) const>(&SelectMgr_BaseIntersector::RaySphereIntersection),
             R"#(Checks whether the ray that starts at the point theLoc and directs with the direction theRayDir intersects with the sphere with center at theCenter and radius TheRadius)#"  , py::arg("theCenter"),  py::arg("theRadius"),  py::arg("theLoc"),  py::arg("theRayDir"),  py::arg("theTimeEnter"),  py::arg("theTimeLeave")
          )
        .def("RayCylinderIntersection",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Pnt & ,   const gp_Dir & ,   const Standard_Boolean ,  Standard_Real & ,  Standard_Real &  ) const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Pnt & ,   const gp_Dir & ,   const Standard_Boolean ,  Standard_Real & ,  Standard_Real &  ) const>(&SelectMgr_BaseIntersector::RayCylinderIntersection),
             R"#(Checks whether the ray that starts at the point theLoc and directs with the direction theRayDir intersects with the hollow cylinder (or cone))#"  , py::arg("theBottomRadius"),  py::arg("theTopRadius"),  py::arg("theHeight"),  py::arg("theLoc"),  py::arg("theRayDir"),  py::arg("theIsHollow"),  py::arg("theTimeEnter"),  py::arg("theTimeLeave")
          )
        .def("RayCircleIntersection",
             (Standard_Boolean (SelectMgr_BaseIntersector::*)(  const Standard_Real ,   const gp_Pnt & ,   const gp_Dir & ,   const Standard_Boolean ,  Standard_Real &  ) const) static_cast<Standard_Boolean (SelectMgr_BaseIntersector::*)(  const Standard_Real ,   const gp_Pnt & ,   const gp_Dir & ,   const Standard_Boolean ,  Standard_Real &  ) const>(&SelectMgr_BaseIntersector::RayCircleIntersection),
             R"#(Checks whether the ray that starts at the point theLoc and directs with the direction theRayDir intersects with the circle)#"  , py::arg("theRadius"),  py::arg("theLoc"),  py::arg("theRayDir"),  py::arg("theIsFilled"),  py::arg("theTime")
          )
    // methods using call by reference i.s.o. return
        .def("WindowSize",
             []( SelectMgr_BaseIntersector &self   ){
                 Standard_Integer  theWidth;
                Standard_Integer  theHeight;

                 self.WindowSize(theWidth,theHeight);
                 
                 return std::make_tuple(theWidth,theHeight); },
             R"#(Returns current window size. This method doesn't set any output values for the base class.)#" 
          )
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_BaseIntersector::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_BaseIntersector::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Camera",
             ( const handle<Graphic3d_Camera> & (SelectMgr_BaseIntersector::*)() const) static_cast< const handle<Graphic3d_Camera> & (SelectMgr_BaseIntersector::*)() const>(&SelectMgr_BaseIntersector::Camera),
             R"#(Return camera definition.)#"
             
         )
       .def("GetNearPnt",
             ( const gp_Pnt & (SelectMgr_BaseIntersector::*)() const) static_cast< const gp_Pnt & (SelectMgr_BaseIntersector::*)() const>(&SelectMgr_BaseIntersector::GetNearPnt),
             R"#(Returns near point of intersector. This method returns zero point for the base class.)#"
             
         )
       .def("GetFarPnt",
             ( const gp_Pnt & (SelectMgr_BaseIntersector::*)() const) static_cast< const gp_Pnt & (SelectMgr_BaseIntersector::*)() const>(&SelectMgr_BaseIntersector::GetFarPnt),
             R"#(Returns far point of intersector. This method returns zero point for the base class.)#"
             
         )
       .def("GetViewRayDirection",
             ( const gp_Dir & (SelectMgr_BaseIntersector::*)() const) static_cast< const gp_Dir & (SelectMgr_BaseIntersector::*)() const>(&SelectMgr_BaseIntersector::GetViewRayDirection),
             R"#(Returns direction ray of intersector. This method returns zero direction for the base class.)#"
             
         )
       .def("GetMousePosition",
             ( const gp_Pnt2d & (SelectMgr_BaseIntersector::*)() const) static_cast< const gp_Pnt2d & (SelectMgr_BaseIntersector::*)() const>(&SelectMgr_BaseIntersector::GetMousePosition),
             R"#(Returns current mouse coordinates. This method returns infinite point for the base class.)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_BaseIntersector::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_BaseIntersector::*)() const>(&SelectMgr_BaseIntersector::DynamicType),
             R"#()#"
             
         )
;

    // Class SelectMgr_EntityOwner from ./opencascade/SelectMgr_EntityOwner.hxx
    klass = m.attr("SelectMgr_EntityOwner");


    // nested enums

    static_cast<py::class_<SelectMgr_EntityOwner ,opencascade::handle<SelectMgr_EntityOwner>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  const Standard_Integer >()  , py::arg("aPriority")=static_cast< const Standard_Integer>(0) )
        .def(py::init<  const handle<SelectMgr_SelectableObject> &, const Standard_Integer >()  , py::arg("aSO"),  py::arg("aPriority")=static_cast< const Standard_Integer>(0) )
        .def(py::init<  const handle<SelectMgr_EntityOwner> &, const Standard_Integer >()  , py::arg("theOwner"),  py::arg("aPriority")=static_cast< const Standard_Integer>(0) )
    // custom constructors
    // methods
        .def("Priority",
             (Standard_Integer (SelectMgr_EntityOwner::*)() const) static_cast<Standard_Integer (SelectMgr_EntityOwner::*)() const>(&SelectMgr_EntityOwner::Priority),
             R"#(Return selection priority (within range [0-9]) for results with the same depth; 0 by default. Example - selection of shapes: the owners are selectable objects (presentations) a user can give vertex priority [3], edges [2] faces [1] shape [0], so that if during selection one vertex one edge and one face are simultaneously detected, the vertex will only be hilighted.)#" 
          )
        .def("SetPriority",
             (void (SelectMgr_EntityOwner::*)( Standard_Integer  ) ) static_cast<void (SelectMgr_EntityOwner::*)( Standard_Integer  ) >(&SelectMgr_EntityOwner::SetPriority),
             R"#(Sets the selectable priority of the owner within range [0-9].)#"  , py::arg("thePriority")
          )
        .def("HasSelectable",
             (Standard_Boolean (SelectMgr_EntityOwner::*)() const) static_cast<Standard_Boolean (SelectMgr_EntityOwner::*)() const>(&SelectMgr_EntityOwner::HasSelectable),
             R"#(Returns true if there is a selectable object to serve as an owner.)#" 
          )
        .def("Selectable",
             (handle<SelectMgr_SelectableObject> (SelectMgr_EntityOwner::*)() const) static_cast<handle<SelectMgr_SelectableObject> (SelectMgr_EntityOwner::*)() const>(&SelectMgr_EntityOwner::Selectable),
             R"#(Returns a selectable object detected in the working context.)#" 
          )
        .def("SetSelectable",
             (void (SelectMgr_EntityOwner::*)(  const handle<SelectMgr_SelectableObject> &  ) ) static_cast<void (SelectMgr_EntityOwner::*)(  const handle<SelectMgr_SelectableObject> &  ) >(&SelectMgr_EntityOwner::SetSelectable),
             R"#(Sets the selectable object.)#"  , py::arg("theSelObj")
          )
        .def("HandleMouseClick",
             (Standard_Boolean (SelectMgr_EntityOwner::*)(  const Graphic3d_Vec2i & ,  Aspect_VKeyMouse ,  Aspect_VKeyFlags ,  bool  ) ) static_cast<Standard_Boolean (SelectMgr_EntityOwner::*)(  const Graphic3d_Vec2i & ,  Aspect_VKeyMouse ,  Aspect_VKeyFlags ,  bool  ) >(&SelectMgr_EntityOwner::HandleMouseClick),
             R"#(Handle mouse button click event. Does nothing by default and returns FALSE.)#"  , py::arg("thePoint"),  py::arg("theButton"),  py::arg("theModifiers"),  py::arg("theIsDoubleClick")
          )
        .def("IsHilighted",
             (Standard_Boolean (SelectMgr_EntityOwner::*)(  const handle<PrsMgr_PresentationManager> & ,   const Standard_Integer  ) const) static_cast<Standard_Boolean (SelectMgr_EntityOwner::*)(  const handle<PrsMgr_PresentationManager> & ,   const Standard_Integer  ) const>(&SelectMgr_EntityOwner::IsHilighted),
             R"#(Returns true if the presentation manager highlights selections corresponding to the selection mode.)#"  , py::arg("thePrsMgr"),  py::arg("theMode")=static_cast< const Standard_Integer>(0)
          )
        .def("HilightWithColor",
             (void (SelectMgr_EntityOwner::*)(  const handle<PrsMgr_PresentationManager> & ,   const handle<Prs3d_Drawer> & ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_EntityOwner::*)(  const handle<PrsMgr_PresentationManager> & ,   const handle<Prs3d_Drawer> & ,   const Standard_Integer  ) >(&SelectMgr_EntityOwner::HilightWithColor),
             R"#(Highlights selectable object's presentation with display mode in presentation manager with given highlight style. Also a check for auto-highlight is performed - if selectable object manages highlighting on its own, execution will be passed to SelectMgr_SelectableObject::HilightOwnerWithColor method.)#"  , py::arg("thePrsMgr"),  py::arg("theStyle"),  py::arg("theMode")=static_cast< const Standard_Integer>(0)
          )
        .def("Unhilight",
             (void (SelectMgr_EntityOwner::*)(  const handle<PrsMgr_PresentationManager> & ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_EntityOwner::*)(  const handle<PrsMgr_PresentationManager> & ,   const Standard_Integer  ) >(&SelectMgr_EntityOwner::Unhilight),
             R"#(Removes highlighting from the owner of a detected selectable object in the presentation manager. This object could be the owner of a sensitive primitive.)#"  , py::arg("thePrsMgr"),  py::arg("theMode")=static_cast< const Standard_Integer>(0)
          )
        .def("Clear",
             (void (SelectMgr_EntityOwner::*)(  const handle<PrsMgr_PresentationManager> & ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_EntityOwner::*)(  const handle<PrsMgr_PresentationManager> & ,   const Standard_Integer  ) >(&SelectMgr_EntityOwner::Clear),
             R"#(Clears the owners matching the value of the selection mode aMode from the presentation manager object aPM.)#"  , py::arg("thePrsMgr"),  py::arg("theMode")=static_cast< const Standard_Integer>(0)
          )
        .def("HasLocation",
             (Standard_Boolean (SelectMgr_EntityOwner::*)() const) static_cast<Standard_Boolean (SelectMgr_EntityOwner::*)() const>(&SelectMgr_EntityOwner::HasLocation),
             R"#(Returns TRUE if selectable has transformation.)#" 
          )
        .def("Location",
             (TopLoc_Location (SelectMgr_EntityOwner::*)() const) static_cast<TopLoc_Location (SelectMgr_EntityOwner::*)() const>(&SelectMgr_EntityOwner::Location),
             R"#(Returns transformation of selectable.)#" 
          )
        .def("SetLocation",
             (void (SelectMgr_EntityOwner::*)(  const TopLoc_Location &  ) ) static_cast<void (SelectMgr_EntityOwner::*)(  const TopLoc_Location &  ) >(&SelectMgr_EntityOwner::SetLocation),
             R"#(Change owner location (callback for handling change of location of selectable object).)#"  , py::arg("theLocation")
          )
        .def("IsSelected",
             (Standard_Boolean (SelectMgr_EntityOwner::*)() const) static_cast<Standard_Boolean (SelectMgr_EntityOwner::*)() const>(&SelectMgr_EntityOwner::IsSelected),
             R"#(Returns Standard_True if the owner is selected.)#" 
          )
        .def("SetSelected",
             (void (SelectMgr_EntityOwner::*)(  const Standard_Boolean  ) ) static_cast<void (SelectMgr_EntityOwner::*)(  const Standard_Boolean  ) >(&SelectMgr_EntityOwner::SetSelected),
             R"#(Set the state of the owner.)#"  , py::arg("theIsSelected")
          )
        .def("Select",
             (Standard_Boolean (SelectMgr_EntityOwner::*)(  const AIS_SelectionScheme ,   const Standard_Boolean  ) const) static_cast<Standard_Boolean (SelectMgr_EntityOwner::*)(  const AIS_SelectionScheme ,   const Standard_Boolean  ) const>(&SelectMgr_EntityOwner::Select),
             R"#(If the object needs to be selected, it returns true.)#"  , py::arg("theSelScheme"),  py::arg("theIsDetected")
          )
        .def("State",
             (Standard_Integer (SelectMgr_EntityOwner::*)() const) static_cast<Standard_Integer (SelectMgr_EntityOwner::*)() const>(&SelectMgr_EntityOwner::State),
             R"#(Returns selection state.)#" 
          )
        .def("State",
             (void (SelectMgr_EntityOwner::*)(  const Standard_Integer  ) ) static_cast<void (SelectMgr_EntityOwner::*)(  const Standard_Integer  ) >(&SelectMgr_EntityOwner::State),
             R"#(Set the state of the owner. The method is deprecated. Use SetSelected() instead.)#"  , py::arg("theStatus")
          )
        .def("IsAutoHilight",
             (Standard_Boolean (SelectMgr_EntityOwner::*)() const) static_cast<Standard_Boolean (SelectMgr_EntityOwner::*)() const>(&SelectMgr_EntityOwner::IsAutoHilight),
             R"#(if owner is not auto hilighted, for group contains many such owners will be called one method HilightSelected of SelectableObject)#" 
          )
        .def("IsForcedHilight",
             (Standard_Boolean (SelectMgr_EntityOwner::*)() const) static_cast<Standard_Boolean (SelectMgr_EntityOwner::*)() const>(&SelectMgr_EntityOwner::IsForcedHilight),
             R"#(if this method returns TRUE the owner will always call method Hilight for SelectableObject when the owner is detected. By default it always return FALSE.)#" 
          )
        .def("SetZLayer",
             (void (SelectMgr_EntityOwner::*)(  const Graphic3d_ZLayerId  ) ) static_cast<void (SelectMgr_EntityOwner::*)(  const Graphic3d_ZLayerId  ) >(&SelectMgr_EntityOwner::SetZLayer),
             R"#(Set Z layer ID and update all presentations.)#"  , py::arg("theLayerId")
          )
        .def("UpdateHighlightTrsf",
             (void (SelectMgr_EntityOwner::*)(  const handle<V3d_Viewer> & ,   const handle<PrsMgr_PresentationManager> & ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_EntityOwner::*)(  const handle<V3d_Viewer> & ,   const handle<PrsMgr_PresentationManager> & ,   const Standard_Integer  ) >(&SelectMgr_EntityOwner::UpdateHighlightTrsf),
             R"#(Implements immediate application of location transformation of parent object to dynamic highlight structure)#"  , py::arg("theViewer"),  py::arg("theManager"),  py::arg("theDispMode")
          )
        .def("IsSameSelectable",
             (Standard_Boolean (SelectMgr_EntityOwner::*)(  const handle<SelectMgr_SelectableObject> &  ) const) static_cast<Standard_Boolean (SelectMgr_EntityOwner::*)(  const handle<SelectMgr_SelectableObject> &  ) const>(&SelectMgr_EntityOwner::IsSameSelectable),
             R"#(Returns true if pointer to selectable object of this owner is equal to the given one)#"  , py::arg("theOther")
          )
        .def("ComesFromDecomposition",
             (Standard_Boolean (SelectMgr_EntityOwner::*)() const) static_cast<Standard_Boolean (SelectMgr_EntityOwner::*)() const>(&SelectMgr_EntityOwner::ComesFromDecomposition),
             R"#(Returns TRUE if this owner points to a part of object and FALSE for entire object.)#" 
          )
        .def("SetComesFromDecomposition",
             (void (SelectMgr_EntityOwner::*)(  const Standard_Boolean  ) ) static_cast<void (SelectMgr_EntityOwner::*)(  const Standard_Boolean  ) >(&SelectMgr_EntityOwner::SetComesFromDecomposition),
             R"#(Sets flag indicating this owner points to a part of object (TRUE) or to entire object (FALSE).)#"  , py::arg("theIsFromDecomposition")
          )
        .def("DumpJson",
             (void (SelectMgr_EntityOwner::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (SelectMgr_EntityOwner::*)( Standard_OStream & ,  Standard_Integer  ) const>(&SelectMgr_EntityOwner::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("Set",
             (void (SelectMgr_EntityOwner::*)(  const handle<SelectMgr_SelectableObject> &  ) ) static_cast<void (SelectMgr_EntityOwner::*)(  const handle<SelectMgr_SelectableObject> &  ) >(&SelectMgr_EntityOwner::Set),
             R"#(Sets the selectable object.)#"  , py::arg("theSelObj")
          )
        .def("Set",
             (void (SelectMgr_EntityOwner::*)(  const Standard_Integer  ) ) static_cast<void (SelectMgr_EntityOwner::*)(  const Standard_Integer  ) >(&SelectMgr_EntityOwner::Set),
             R"#(sets the selectable priority of the owner)#"  , py::arg("thePriority")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_EntityOwner::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_EntityOwner::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_EntityOwner::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_EntityOwner::*)() const>(&SelectMgr_EntityOwner::DynamicType),
             R"#()#"
             
         )
;

    // Class SelectMgr_Filter from ./opencascade/SelectMgr_Filter.hxx
    klass = m.attr("SelectMgr_Filter");


    // nested enums

    static_cast<py::class_<SelectMgr_Filter ,opencascade::handle<SelectMgr_Filter> ,Py_SelectMgr_Filter , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("IsOk",
             (Standard_Boolean (SelectMgr_Filter::*)(  const handle<SelectMgr_EntityOwner> &  ) const) static_cast<Standard_Boolean (SelectMgr_Filter::*)(  const handle<SelectMgr_EntityOwner> &  ) const>(&SelectMgr_Filter::IsOk),
             R"#(Indicates that the selected Interactive Object passes the filter. The owner, anObj, can be either direct or user. A direct owner is the corresponding construction element, whereas a user is the compound shape of which the entity forms a part. When an object is detected by the mouse - in AIS, this is done through a context selector - its owner is passed to the filter as an argument. If the object returns Standard_True, it is kept; if not, it is rejected. If you are creating a filter class inheriting this framework, and the daughter class is to be used in an AIS local context, you will need to implement the virtual function ActsOn.)#"  , py::arg("anObj")
          )
        .def("ActsOn",
             (Standard_Boolean (SelectMgr_Filter::*)(  const TopAbs_ShapeEnum  ) const) static_cast<Standard_Boolean (SelectMgr_Filter::*)(  const TopAbs_ShapeEnum  ) const>(&SelectMgr_Filter::ActsOn),
             R"#(Returns true in an AIS local context, if this filter operates on a type of subshape defined in a filter class inheriting this framework. This function completes IsOk in an AIS local context.)#"  , py::arg("aStandardMode")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_Filter::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_Filter::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_Filter::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_Filter::*)() const>(&SelectMgr_Filter::DynamicType),
             R"#()#"
             
         )
;

    // Class SelectMgr_FrustumBuilder from ./opencascade/SelectMgr_FrustumBuilder.hxx
    klass = m.attr("SelectMgr_FrustumBuilder");


    // nested enums

    static_cast<py::class_<SelectMgr_FrustumBuilder ,opencascade::handle<SelectMgr_FrustumBuilder>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetCamera",
             (void (SelectMgr_FrustumBuilder::*)(  const handle<Graphic3d_Camera> &  ) ) static_cast<void (SelectMgr_FrustumBuilder::*)(  const handle<Graphic3d_Camera> &  ) >(&SelectMgr_FrustumBuilder::SetCamera),
             R"#(Stores current camera)#"  , py::arg("theCamera")
          )
        .def("SetWindowSize",
             (void (SelectMgr_FrustumBuilder::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_FrustumBuilder::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&SelectMgr_FrustumBuilder::SetWindowSize),
             R"#(Stores current window width and height)#"  , py::arg("theWidth"),  py::arg("theHeight")
          )
        .def("SetViewport",
             (void (SelectMgr_FrustumBuilder::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<void (SelectMgr_FrustumBuilder::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) >(&SelectMgr_FrustumBuilder::SetViewport),
             R"#(Stores current viewport coordinates)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theWidth"),  py::arg("theHeight")
          )
        .def("InvalidateViewport",
             (void (SelectMgr_FrustumBuilder::*)() ) static_cast<void (SelectMgr_FrustumBuilder::*)() >(&SelectMgr_FrustumBuilder::InvalidateViewport),
             R"#()#" 
          )
        .def("SignedPlanePntDist",
             (Standard_Real (SelectMgr_FrustumBuilder::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 &  ) const) static_cast<Standard_Real (SelectMgr_FrustumBuilder::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 &  ) const>(&SelectMgr_FrustumBuilder::SignedPlanePntDist),
             R"#(Calculates signed distance between plane with equation theEq and point thePnt)#"  , py::arg("theEq"),  py::arg("thePnt")
          )
        .def("ProjectPntOnViewPlane",
             (gp_Pnt (SelectMgr_FrustumBuilder::*)(  const Standard_Real & ,   const Standard_Real & ,   const Standard_Real &  ) const) static_cast<gp_Pnt (SelectMgr_FrustumBuilder::*)(  const Standard_Real & ,   const Standard_Real & ,   const Standard_Real &  ) const>(&SelectMgr_FrustumBuilder::ProjectPntOnViewPlane),
             R"#(Projects 2d screen point onto view frustum plane: theZ = 0 - near plane, theZ = 1 - far plane)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ")
          )
    // methods using call by reference i.s.o. return
        .def("WindowSize",
             []( SelectMgr_FrustumBuilder &self   ){
                 Standard_Integer  theWidth;
                Standard_Integer  theHeight;

                 self.WindowSize(theWidth,theHeight);
                 
                 return std::make_tuple(theWidth,theHeight); },
             R"#()#" 
          )
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_FrustumBuilder::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_FrustumBuilder::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Camera",
             ( const handle<Graphic3d_Camera> & (SelectMgr_FrustumBuilder::*)() const) static_cast< const handle<Graphic3d_Camera> & (SelectMgr_FrustumBuilder::*)() const>(&SelectMgr_FrustumBuilder::Camera),
             R"#(Returns current camera)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_FrustumBuilder::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_FrustumBuilder::*)() const>(&SelectMgr_FrustumBuilder::DynamicType),
             R"#()#"
             
         )
;

    // Class SelectMgr_RectangularFrustum from ./opencascade/SelectMgr_RectangularFrustum.hxx
    klass = m.attr("SelectMgr_RectangularFrustum");


    // nested enums

    static_cast<py::class_<SelectMgr_RectangularFrustum , shared_ptr<SelectMgr_RectangularFrustum>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Init",
             (void (SelectMgr_RectangularFrustum::*)(  const gp_Pnt2d &  ) ) static_cast<void (SelectMgr_RectangularFrustum::*)(  const gp_Pnt2d &  ) >(&SelectMgr_RectangularFrustum::Init),
             R"#(Initializes volume according to the point and given pixel tolerance)#"  , py::arg("thePoint")
          )
        .def("Init",
             (void (SelectMgr_RectangularFrustum::*)(  const gp_Pnt2d & ,   const gp_Pnt2d &  ) ) static_cast<void (SelectMgr_RectangularFrustum::*)(  const gp_Pnt2d & ,   const gp_Pnt2d &  ) >(&SelectMgr_RectangularFrustum::Init),
             R"#(Initializes volume according to the selected rectangle)#"  , py::arg("theMinPnt"),  py::arg("theMaxPnt")
          )
        .def("isIntersectCircle",
             (Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const Standard_Real ,   const gp_Pnt & ,   const gp_Trsf & ,   const TColgp_Array1OfPnt &  ) const) static_cast<Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const Standard_Real ,   const gp_Pnt & ,   const gp_Trsf & ,   const TColgp_Array1OfPnt &  ) const>(&SelectMgr_RectangularFrustum::isIntersectCircle),
             R"#(Returns True if Frustum (theVertices) intersects the circle.)#"  , py::arg("theRadius"),  py::arg("theCenter"),  py::arg("theTrsf"),  py::arg("theVertices")
          )
        .def("isSegmentsIntersect",
             (Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt &  ) const) static_cast<Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt &  ) const>(&SelectMgr_RectangularFrustum::isSegmentsIntersect),
             R"#(Returns True if Seg1 (thePnt1Seg1, thePnt2Seg1) and Seg2 (thePnt1Seg2, thePnt2Seg2) intersect.)#"  , py::arg("thePnt1Seg1"),  py::arg("thePnt2Seg1"),  py::arg("thePnt1Seg2"),  py::arg("thePnt2Seg2")
          )
        .def("Build",
             (void (SelectMgr_RectangularFrustum::*)() ) static_cast<void (SelectMgr_RectangularFrustum::*)() >(&SelectMgr_RectangularFrustum::Build),
             R"#(Builds volume according to internal parameters. NOTE: it should be called after Init() method)#" 
          )
        .def("IsScalable",
             (Standard_Boolean (SelectMgr_RectangularFrustum::*)() const) static_cast<Standard_Boolean (SelectMgr_RectangularFrustum::*)() const>(&SelectMgr_RectangularFrustum::IsScalable),
             R"#(Checks if it is possible to scale this frustum. It is true for frustum built on a single point.)#" 
          )
        .def("ScaleAndTransform",
             (handle<SelectMgr_BaseIntersector> (SelectMgr_RectangularFrustum::*)(  const Standard_Integer ,   const gp_GTrsf & ,   const handle<SelectMgr_FrustumBuilder> &  ) const) static_cast<handle<SelectMgr_BaseIntersector> (SelectMgr_RectangularFrustum::*)(  const Standard_Integer ,   const gp_GTrsf & ,   const handle<SelectMgr_FrustumBuilder> &  ) const>(&SelectMgr_RectangularFrustum::ScaleAndTransform),
             R"#(IMPORTANT: Scaling makes sense only for frustum built on a single point! Note that this method does not perform any checks on type of the frustum. Returns a copy of the frustum resized according to the scale factor given and transforms it using the matrix given. There are no default parameters, but in case if: - transformation only is needed: must be initialized as any negative value; - scale only is needed: must be set to gp_Identity. Builder is an optional argument that represents corresponding settings for re-constructing transformed frustum from scratch. Can be null if reconstruction is not expected furthermore.)#"  , py::arg("theScaleFactor"),  py::arg("theTrsf"),  py::arg("theBuilder")
          )
        .def("CopyWithBuilder",
             (handle<SelectMgr_BaseIntersector> (SelectMgr_RectangularFrustum::*)(  const handle<SelectMgr_FrustumBuilder> &  ) const) static_cast<handle<SelectMgr_BaseIntersector> (SelectMgr_RectangularFrustum::*)(  const handle<SelectMgr_FrustumBuilder> &  ) const>(&SelectMgr_RectangularFrustum::CopyWithBuilder),
             R"#(Returns a copy of the frustum using the given frustum builder configuration. Returned frustum should be re-constructed before being used.)#"  , py::arg("theBuilder")
          )
        .def("OverlapsBox",
             (Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_RectangularFrustum::OverlapsBox),
             R"#(SAT intersection test between defined volume and given axis-aligned box)#"  , py::arg("theBoxMin"),  py::arg("theBoxMax"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsBox",
             (Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,  Standard_Boolean *  ) const>(&SelectMgr_RectangularFrustum::OverlapsBox),
             R"#(Returns true if selecting volume is overlapped by axis-aligned bounding box with minimum corner at point theMinPt and maximum at point theMaxPt)#"  , py::arg("theBoxMin"),  py::arg("theBoxMax"),  py::arg("theInside")
          )
        .def("OverlapsPoint",
             (Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_RectangularFrustum::OverlapsPoint),
             R"#(Intersection test between defined volume and given point)#"  , py::arg("thePnt"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsPoint",
             (Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const gp_Pnt &  ) const) static_cast<Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const gp_Pnt &  ) const>(&SelectMgr_RectangularFrustum::OverlapsPoint),
             R"#(Intersection test between defined volume and given point)#"  , py::arg("thePnt")
          )
        .def("OverlapsPolygon",
             (Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const TColgp_Array1OfPnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const TColgp_Array1OfPnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_RectangularFrustum::OverlapsPolygon),
             R"#(SAT intersection test between defined volume and given ordered set of points, representing line segments. The test may be considered of interior part or boundary line defined by segments depending on given sensitivity type)#"  , py::arg("theArrayOfPnts"),  py::arg("theSensType"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsSegment",
             (Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_RectangularFrustum::OverlapsSegment),
             R"#(Checks if line segment overlaps selecting frustum)#"  , py::arg("thePnt1"),  py::arg("thePnt2"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsTriangle",
             (Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_RectangularFrustum::OverlapsTriangle),
             R"#(SAT intersection test between defined volume and given triangle. The test may be considered of interior part or boundary line defined by triangle vertices depending on given sensitivity type)#"  , py::arg("thePnt1"),  py::arg("thePnt2"),  py::arg("thePnt3"),  py::arg("theSensType"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsSphere",
             (Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const gp_Pnt & ,   const Standard_Real ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const gp_Pnt & ,   const Standard_Real ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_RectangularFrustum::OverlapsSphere),
             R"#(Intersection test between defined volume and given sphere)#"  , py::arg("theCenter"),  py::arg("theRadius"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsSphere",
             (Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const gp_Pnt & ,   const Standard_Real ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const gp_Pnt & ,   const Standard_Real ,  Standard_Boolean *  ) const>(&SelectMgr_RectangularFrustum::OverlapsSphere),
             R"#(Intersection test between defined volume and given sphere)#"  , py::arg("theCenter"),  py::arg("theRadius"),  py::arg("theInside")
          )
        .def("OverlapsCylinder",
             (Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_RectangularFrustum::OverlapsCylinder),
             R"#(Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses theBottomRad and theTopRad, height theHeight and transformation to apply theTrsf.)#"  , py::arg("theBottomRad"),  py::arg("theTopRad"),  py::arg("theHeight"),  py::arg("theTrsf"),  py::arg("theIsHollow"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsCylinder",
             (Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const>(&SelectMgr_RectangularFrustum::OverlapsCylinder),
             R"#(Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses theBottomRad and theTopRad, height theHeight and transformation to apply theTrsf.)#"  , py::arg("theBottomRad"),  py::arg("theTopRad"),  py::arg("theHeight"),  py::arg("theTrsf"),  py::arg("theIsHollow"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("OverlapsCircle",
             (Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_RectangularFrustum::OverlapsCircle),
             R"#(Returns true if selecting volume is overlapped by circle with radius theRadius, boolean theIsFilled and transformation to apply theTrsf. The position and orientation of the circle are specified via theTrsf transformation for gp::XOY() with center in gp::Origin().)#"  , py::arg("theBottomRad"),  py::arg("theTrsf"),  py::arg("theIsFilled"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsCircle",
             (Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_RectangularFrustum::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const>(&SelectMgr_RectangularFrustum::OverlapsCircle),
             R"#(Returns true if selecting volume is overlapped by circle with radius theRadius, boolean theIsFilled and transformation to apply theTrsf. The position and orientation of the circle are specified via theTrsf transformation for gp::XOY() with center in gp::Origin().)#"  , py::arg("theBottomRad"),  py::arg("theTrsf"),  py::arg("theIsFilled"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("DistToGeometryCenter",
             (Standard_Real (SelectMgr_RectangularFrustum::*)(  const gp_Pnt &  ) const) static_cast<Standard_Real (SelectMgr_RectangularFrustum::*)(  const gp_Pnt &  ) const>(&SelectMgr_RectangularFrustum::DistToGeometryCenter),
             R"#(Measures distance between 3d projection of user-picked screen point and given point theCOG. It makes sense only for frustums built on a single point.)#"  , py::arg("theCOG")
          )
        .def("DetectedPoint",
             (gp_Pnt (SelectMgr_RectangularFrustum::*)(  const Standard_Real  ) const) static_cast<gp_Pnt (SelectMgr_RectangularFrustum::*)(  const Standard_Real  ) const>(&SelectMgr_RectangularFrustum::DetectedPoint),
             R"#(Calculates the point on a view ray that was detected during the run of selection algo by given depth)#"  , py::arg("theDepth")
          )
        .def("GetVertices",
             ( const gp_Pnt * (SelectMgr_RectangularFrustum::*)() const) static_cast< const gp_Pnt * (SelectMgr_RectangularFrustum::*)() const>(&SelectMgr_RectangularFrustum::GetVertices),
             R"#(A set of helper functions that return rectangular selecting frustum data)#" 
          )
        .def("GetPlanes",
             (void (SelectMgr_RectangularFrustum::*)( NCollection_Vector<SelectMgr_Vec4> &  ) const) static_cast<void (SelectMgr_RectangularFrustum::*)( NCollection_Vector<SelectMgr_Vec4> &  ) const>(&SelectMgr_RectangularFrustum::GetPlanes),
             R"#(Stores plane equation coefficients (in the following form: Ax + By + Cz + D = 0) to the given vector)#"  , py::arg("thePlaneEquations")
          )
        .def("DumpJson",
             (void (SelectMgr_RectangularFrustum::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (SelectMgr_RectangularFrustum::*)( Standard_OStream & ,  Standard_Integer  ) const>(&SelectMgr_RectangularFrustum::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetNearPnt",
             ( const gp_Pnt & (SelectMgr_RectangularFrustum::*)() const) static_cast< const gp_Pnt & (SelectMgr_RectangularFrustum::*)() const>(&SelectMgr_RectangularFrustum::GetNearPnt),
             R"#(Returns projection of 2d mouse picked point or projection of center of 2d rectangle (for point and rectangular selection correspondingly) onto near view frustum plane)#"
             
         )
       .def("GetFarPnt",
             ( const gp_Pnt & (SelectMgr_RectangularFrustum::*)() const) static_cast< const gp_Pnt & (SelectMgr_RectangularFrustum::*)() const>(&SelectMgr_RectangularFrustum::GetFarPnt),
             R"#(Returns projection of 2d mouse picked point or projection of center of 2d rectangle (for point and rectangular selection correspondingly) onto far view frustum plane)#"
             
         )
       .def("GetViewRayDirection",
             ( const gp_Dir & (SelectMgr_RectangularFrustum::*)() const) static_cast< const gp_Dir & (SelectMgr_RectangularFrustum::*)() const>(&SelectMgr_RectangularFrustum::GetViewRayDirection),
             R"#(Returns view ray direction.)#"
             
         )
       .def("GetMousePosition",
             ( const gp_Pnt2d & (SelectMgr_RectangularFrustum::*)() const) static_cast< const gp_Pnt2d & (SelectMgr_RectangularFrustum::*)() const>(&SelectMgr_RectangularFrustum::GetMousePosition),
             R"#(Returns current mouse coordinates.)#"
             
         )
;

    // Class SelectMgr_SelectableObject from ./opencascade/SelectMgr_SelectableObject.hxx
    klass = m.attr("SelectMgr_SelectableObject");


    // nested enums

    static_cast<py::class_<SelectMgr_SelectableObject ,opencascade::handle<SelectMgr_SelectableObject> ,Py_SelectMgr_SelectableObject , PrsMgr_PresentableObject >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("ComputeSelection",
             (void (SelectMgr_SelectableObject::*)(  const handle<SelectMgr_Selection> & ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_SelectableObject::*)(  const handle<SelectMgr_Selection> & ,   const Standard_Integer  ) >(&SelectMgr_SelectableObject::ComputeSelection),
             R"#(Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.)#"  , py::arg("theSelection"),  py::arg("theMode")
          )
        .def("AcceptShapeDecomposition",
             (Standard_Boolean (SelectMgr_SelectableObject::*)() const) static_cast<Standard_Boolean (SelectMgr_SelectableObject::*)() const>(&SelectMgr_SelectableObject::AcceptShapeDecomposition),
             R"#(Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.)#" 
          )
        .def("RecomputePrimitives",
             (void (SelectMgr_SelectableObject::*)() ) static_cast<void (SelectMgr_SelectableObject::*)() >(&SelectMgr_SelectableObject::RecomputePrimitives),
             R"#(Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.)#" 
          )
        .def("RecomputePrimitives",
             (void (SelectMgr_SelectableObject::*)(  const Standard_Integer  ) ) static_cast<void (SelectMgr_SelectableObject::*)(  const Standard_Integer  ) >(&SelectMgr_SelectableObject::RecomputePrimitives),
             R"#(Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.)#"  , py::arg("theMode")
          )
        .def("AddSelection",
             (void (SelectMgr_SelectableObject::*)(  const handle<SelectMgr_Selection> & ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_SelectableObject::*)(  const handle<SelectMgr_Selection> & ,   const Standard_Integer  ) >(&SelectMgr_SelectableObject::AddSelection),
             R"#(Adds the selection aSelection with the selection mode index aMode to this framework.)#"  , py::arg("aSelection"),  py::arg("aMode")
          )
        .def("ClearSelections",
             (void (SelectMgr_SelectableObject::*)(  const Standard_Boolean  ) ) static_cast<void (SelectMgr_SelectableObject::*)(  const Standard_Boolean  ) >(&SelectMgr_SelectableObject::ClearSelections),
             R"#(Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.)#"  , py::arg("update")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def("Selection",
             ( const handle<SelectMgr_Selection> & (SelectMgr_SelectableObject::*)(  const Standard_Integer  ) const) static_cast< const handle<SelectMgr_Selection> & (SelectMgr_SelectableObject::*)(  const Standard_Integer  ) const>(&SelectMgr_SelectableObject::Selection),
             R"#(Returns the selection having specified selection mode or NULL.)#"  , py::arg("theMode")
          )
        .def("HasSelection",
             (Standard_Boolean (SelectMgr_SelectableObject::*)(  const Standard_Integer  ) const) static_cast<Standard_Boolean (SelectMgr_SelectableObject::*)(  const Standard_Integer  ) const>(&SelectMgr_SelectableObject::HasSelection),
             R"#(Returns true if a selection corresponding to the selection mode theMode was computed for this object.)#"  , py::arg("theMode")
          )
        .def("ResetTransformation",
             (void (SelectMgr_SelectableObject::*)() ) static_cast<void (SelectMgr_SelectableObject::*)() >(&SelectMgr_SelectableObject::ResetTransformation),
             R"#()#" 
          )
        .def("UpdateTransformation",
             (void (SelectMgr_SelectableObject::*)() ) static_cast<void (SelectMgr_SelectableObject::*)() >(&SelectMgr_SelectableObject::UpdateTransformation),
             R"#(Recomputes the location of the selection aSelection.)#" 
          )
        .def("UpdateTransformations",
             (void (SelectMgr_SelectableObject::*)(  const handle<SelectMgr_Selection> &  ) ) static_cast<void (SelectMgr_SelectableObject::*)(  const handle<SelectMgr_Selection> &  ) >(&SelectMgr_SelectableObject::UpdateTransformations),
             R"#(Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.)#"  , py::arg("aSelection")
          )
        .def("HilightSelected",
             (void (SelectMgr_SelectableObject::*)(  const handle<PrsMgr_PresentationManager> & ,   const SelectMgr_SequenceOfOwner &  ) ) static_cast<void (SelectMgr_SelectableObject::*)(  const handle<PrsMgr_PresentationManager> & ,   const SelectMgr_SequenceOfOwner &  ) >(&SelectMgr_SelectableObject::HilightSelected),
             R"#(Method which draws selected owners ( for fast presentation draw ))#"  , py::arg("thePrsMgr"),  py::arg("theSeq")
          )
        .def("ClearSelected",
             (void (SelectMgr_SelectableObject::*)() ) static_cast<void (SelectMgr_SelectableObject::*)() >(&SelectMgr_SelectableObject::ClearSelected),
             R"#(Method which clear all selected owners belonging to this selectable object ( for fast presentation draw ))#" 
          )
        .def("ClearDynamicHighlight",
             (void (SelectMgr_SelectableObject::*)(  const handle<PrsMgr_PresentationManager> &  ) ) static_cast<void (SelectMgr_SelectableObject::*)(  const handle<PrsMgr_PresentationManager> &  ) >(&SelectMgr_SelectableObject::ClearDynamicHighlight),
             R"#(Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.)#"  , py::arg("theMgr")
          )
        .def("HilightOwnerWithColor",
             (void (SelectMgr_SelectableObject::*)(  const handle<PrsMgr_PresentationManager> & ,   const handle<Prs3d_Drawer> & ,   const handle<SelectMgr_EntityOwner> &  ) ) static_cast<void (SelectMgr_SelectableObject::*)(  const handle<PrsMgr_PresentationManager> & ,   const handle<Prs3d_Drawer> & ,   const handle<SelectMgr_EntityOwner> &  ) >(&SelectMgr_SelectableObject::HilightOwnerWithColor),
             R"#(Method which hilight an owner belonging to this selectable object ( for fast presentation draw ))#"  , py::arg("thePM"),  py::arg("theStyle"),  py::arg("theOwner")
          )
        .def("IsAutoHilight",
             (Standard_Boolean (SelectMgr_SelectableObject::*)() const) static_cast<Standard_Boolean (SelectMgr_SelectableObject::*)() const>(&SelectMgr_SelectableObject::IsAutoHilight),
             R"#(If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.)#" 
          )
        .def("SetAutoHilight",
             (void (SelectMgr_SelectableObject::*)(  const Standard_Boolean  ) ) static_cast<void (SelectMgr_SelectableObject::*)(  const Standard_Boolean  ) >(&SelectMgr_SelectableObject::SetAutoHilight),
             R"#(Set AutoHilight property to true or false.)#"  , py::arg("theAutoHilight")
          )
        .def("GetHilightPresentation",
             (handle<Prs3d_Presentation> (SelectMgr_SelectableObject::*)(  const handle<PrsMgr_PresentationManager> &  ) ) static_cast<handle<Prs3d_Presentation> (SelectMgr_SelectableObject::*)(  const handle<PrsMgr_PresentationManager> &  ) >(&SelectMgr_SelectableObject::GetHilightPresentation),
             R"#(Creates or returns existing presentation for highlighting detected object.)#"  , py::arg("thePrsMgr")
          )
        .def("GetSelectPresentation",
             (handle<Prs3d_Presentation> (SelectMgr_SelectableObject::*)(  const handle<PrsMgr_PresentationManager> &  ) ) static_cast<handle<Prs3d_Presentation> (SelectMgr_SelectableObject::*)(  const handle<PrsMgr_PresentationManager> &  ) >(&SelectMgr_SelectableObject::GetSelectPresentation),
             R"#(Creates or returns existing presentation for highlighting selected object.)#"  , py::arg("thePrsMgr")
          )
        .def("ErasePresentations",
             (void (SelectMgr_SelectableObject::*)( Standard_Boolean  ) ) static_cast<void (SelectMgr_SelectableObject::*)( Standard_Boolean  ) >(&SelectMgr_SelectableObject::ErasePresentations),
             R"#(Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().)#"  , py::arg("theToRemove")
          )
        .def("SetZLayer",
             (void (SelectMgr_SelectableObject::*)(  const Graphic3d_ZLayerId  ) ) static_cast<void (SelectMgr_SelectableObject::*)(  const Graphic3d_ZLayerId  ) >(&SelectMgr_SelectableObject::SetZLayer),
             R"#(Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.)#"  , py::arg("theLayerId")
          )
        .def("UpdateSelection",
             (void (SelectMgr_SelectableObject::*)(  const Standard_Integer  ) ) static_cast<void (SelectMgr_SelectableObject::*)(  const Standard_Integer  ) >(&SelectMgr_SelectableObject::UpdateSelection),
             R"#(Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.)#"  , py::arg("theMode")=static_cast< const Standard_Integer>(- 1)
          )
        .def("SetAssemblyOwner",
             (void (SelectMgr_SelectableObject::*)(  const handle<SelectMgr_EntityOwner> & ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_SelectableObject::*)(  const handle<SelectMgr_EntityOwner> & ,   const Standard_Integer  ) >(&SelectMgr_SelectableObject::SetAssemblyOwner),
             R"#(Sets common entity owner for assembly sensitive object entities)#"  , py::arg("theOwner"),  py::arg("theMode")=static_cast< const Standard_Integer>(- 1)
          )
        .def("BndBoxOfSelected",
             (Bnd_Box (SelectMgr_SelectableObject::*)(  const handle<SelectMgr_IndexedMapOfOwner> &  ) ) static_cast<Bnd_Box (SelectMgr_SelectableObject::*)(  const handle<SelectMgr_IndexedMapOfOwner> &  ) >(&SelectMgr_SelectableObject::BndBoxOfSelected),
             R"#(Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection)#"  , py::arg("theOwners")
          )
        .def("GlobalSelectionMode",
             (Standard_Integer (SelectMgr_SelectableObject::*)() const) static_cast<Standard_Integer (SelectMgr_SelectableObject::*)() const>(&SelectMgr_SelectableObject::GlobalSelectionMode),
             R"#(Returns the mode for selection of object as a whole; 0 by default.)#" 
          )
        .def("GlobalSelOwner",
             (handle<SelectMgr_EntityOwner> (SelectMgr_SelectableObject::*)() const) static_cast<handle<SelectMgr_EntityOwner> (SelectMgr_SelectableObject::*)() const>(&SelectMgr_SelectableObject::GlobalSelOwner),
             R"#(Returns the owner of mode for selection of object as a whole)#" 
          )
        .def("DumpJson",
             (void (SelectMgr_SelectableObject::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (SelectMgr_SelectableObject::*)( Standard_OStream & ,  Standard_Integer  ) const>(&SelectMgr_SelectableObject::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_SelectableObject::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_SelectableObject::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_SelectableObject::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_SelectableObject::*)() const>(&SelectMgr_SelectableObject::DynamicType),
             R"#()#"
             
         )
       .def("Selections",
             ( const SelectMgr_SequenceOfSelection & (SelectMgr_SelectableObject::*)() const) static_cast< const SelectMgr_SequenceOfSelection & (SelectMgr_SelectableObject::*)() const>(&SelectMgr_SelectableObject::Selections),
             R"#(Return the sequence of selections.)#"
             
         )
       .def("GetAssemblyOwner",
             ( const handle<SelectMgr_EntityOwner> & (SelectMgr_SelectableObject::*)() const) static_cast< const handle<SelectMgr_EntityOwner> & (SelectMgr_SelectableObject::*)() const>(&SelectMgr_SelectableObject::GetAssemblyOwner),
             R"#(Returns common entity owner if the object is an assembly)#"
             
         )
;

    // Class SelectMgr_SelectableObjectSet from ./opencascade/SelectMgr_SelectableObjectSet.hxx
    klass = m.attr("SelectMgr_SelectableObjectSet");


    // nested enums
        py::enum_<SelectMgr_SelectableObjectSet::BVHSubset>(klass, "BVHSubset_e", R"#(This enumeration declares names for subsets of selectable objects. Each subset has independent BVH tree. The class maintains subsets of selectable objects by their persistence flag. This allows to restric rebuilding of the trees for particular subset when the camera change does not implicitly require it: - BVHSubset_3d refers to the subset of normal world-space 3D objects. Associated BVH tree does not depend on the camera's state at all. This subset uses binned BVH builder with 32 bins and 1 element per leaf. - BVHSubset_3dPersistent refers to the subset of 3D persistent selectable objects (rotate, pan, zoom persistence). Associated BVH tree needs to be updated when either the camera's projection and position change. This subset uses linear BVH builder with 32 levels of depth and 1 element per leaf. - BVHSubset_2dPersistent refers to the subset of 2D persistent selectable objects. Associated BVH tree needs to be updated only when camera's projection changes. Bounding volumes for this object subclass is represented directly in eye space coordinates. This subset uses linear BVH builder with 32 levels of depth and 1 element per leaf. - BVHSubset_ortho3dPersistent refers to the subset of 3D persistent selectable objects (rotate, pan, zoom persistence) that contains `Graphic3d_TMF_OrthoPers` persistence mode. Associated BVH tree needs to be updated when either the camera's projection and position change. This subset uses linear BVH builder with 32 levels of depth and 1 element per leaf. - BVHSubset_ortho2dPersistent refers to the subset of 2D persistent selectable objects that contains `Graphic3d_TMF_OrthoPers` persistence mode. Associated BVH tree needs to be updated only when camera's projection changes. Bounding volumes for this object subclass is represented directly in eye space coordinates. This subset uses linear BVH builder with 32 levels of depth and 1 element per leaf.)#")
            .value("BVHSubset_3d", SelectMgr_SelectableObjectSet::BVHSubset::BVHSubset_3d)
            .value("BVHSubset_3dPersistent", SelectMgr_SelectableObjectSet::BVHSubset::BVHSubset_3dPersistent)
            .value("BVHSubset_2dPersistent", SelectMgr_SelectableObjectSet::BVHSubset::BVHSubset_2dPersistent)
            .value("BVHSubset_ortho3dPersistent", SelectMgr_SelectableObjectSet::BVHSubset::BVHSubset_ortho3dPersistent)
            .value("BVHSubset_ortho2dPersistent", SelectMgr_SelectableObjectSet::BVHSubset::BVHSubset_ortho2dPersistent)
            .value("BVHSubsetNb", SelectMgr_SelectableObjectSet::BVHSubset::BVHSubsetNb).export_values();

    static_cast<py::class_<SelectMgr_SelectableObjectSet , shared_ptr<SelectMgr_SelectableObjectSet>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Append",
             (Standard_Boolean (SelectMgr_SelectableObjectSet::*)(  const handle<SelectMgr_SelectableObject> &  ) ) static_cast<Standard_Boolean (SelectMgr_SelectableObjectSet::*)(  const handle<SelectMgr_SelectableObject> &  ) >(&SelectMgr_SelectableObjectSet::Append),
             R"#(Adds the new selectable object to the set. The selectable object is placed into one of the predefined subsets depending on its persistence type. After adding an object, this method marks the corresponding BVH tree for rebuild.)#"  , py::arg("theObject")
          )
        .def("Remove",
             (Standard_Boolean (SelectMgr_SelectableObjectSet::*)(  const handle<SelectMgr_SelectableObject> &  ) ) static_cast<Standard_Boolean (SelectMgr_SelectableObjectSet::*)(  const handle<SelectMgr_SelectableObject> &  ) >(&SelectMgr_SelectableObjectSet::Remove),
             R"#(Removes the selectable object from the set. The selectable object is removed from the subset it has been placed into. After removing an object, this method marks the corresponding BVH tree for rebuild.)#"  , py::arg("theObject")
          )
        .def("ChangeSubset",
             (void (SelectMgr_SelectableObjectSet::*)(  const handle<SelectMgr_SelectableObject> &  ) ) static_cast<void (SelectMgr_SelectableObjectSet::*)(  const handle<SelectMgr_SelectableObject> &  ) >(&SelectMgr_SelectableObjectSet::ChangeSubset),
             R"#(Performs necessary updates when object's persistence types changes. This method should be called right after changing transformation persistence flags of the objects and before updating BVH tree - to provide up-to-date state of the object set.)#"  , py::arg("theObject")
          )
        .def("UpdateBVH",
             (void (SelectMgr_SelectableObjectSet::*)(  const handle<Graphic3d_Camera> & ,   const Graphic3d_Vec2i &  ) ) static_cast<void (SelectMgr_SelectableObjectSet::*)(  const handle<Graphic3d_Camera> & ,   const Graphic3d_Vec2i &  ) >(&SelectMgr_SelectableObjectSet::UpdateBVH),
             R"#(Updates outdated BVH trees and remembers the last state of the camera view-projection matrices and viewport (window) dimensions.)#"  , py::arg("theCam"),  py::arg("theWinSize")
          )
        .def("MarkDirty",
             (void (SelectMgr_SelectableObjectSet::*)() ) static_cast<void (SelectMgr_SelectableObjectSet::*)() >(&SelectMgr_SelectableObjectSet::MarkDirty),
             R"#(Marks every BVH subset for update.)#" 
          )
        .def("Contains",
             (Standard_Boolean (SelectMgr_SelectableObjectSet::*)(  const handle<SelectMgr_SelectableObject> &  ) const) static_cast<Standard_Boolean (SelectMgr_SelectableObjectSet::*)(  const handle<SelectMgr_SelectableObject> &  ) const>(&SelectMgr_SelectableObjectSet::Contains),
             R"#(Returns true if this objects set contains theObject given.)#"  , py::arg("theObject")
          )
        .def("IsEmpty",
             (Standard_Boolean (SelectMgr_SelectableObjectSet::*)() const) static_cast<Standard_Boolean (SelectMgr_SelectableObjectSet::*)() const>(&SelectMgr_SelectableObjectSet::IsEmpty),
             R"#(Returns true if the object set does not contain any selectable objects.)#" 
          )
        .def("IsEmpty",
             (Standard_Boolean (SelectMgr_SelectableObjectSet::*)(  const SelectMgr_SelectableObjectSet::BVHSubset  ) const) static_cast<Standard_Boolean (SelectMgr_SelectableObjectSet::*)(  const SelectMgr_SelectableObjectSet::BVHSubset  ) const>(&SelectMgr_SelectableObjectSet::IsEmpty),
             R"#(Returns true if the specified object subset is empty.)#"  , py::arg("theSubset")
          )
        .def("GetObjectById",
             ( const handle<SelectMgr_SelectableObject> & (SelectMgr_SelectableObjectSet::*)(  const SelectMgr_SelectableObjectSet::BVHSubset ,   const Standard_Integer  ) const) static_cast< const handle<SelectMgr_SelectableObject> & (SelectMgr_SelectableObjectSet::*)(  const SelectMgr_SelectableObjectSet::BVHSubset ,   const Standard_Integer  ) const>(&SelectMgr_SelectableObjectSet::GetObjectById),
             R"#(Returns object from subset theSubset by theIndex given. The method allows to get selectable object referred by the index of an element of the subset's BVH tree.)#"  , py::arg("theSubset"),  py::arg("theIndex")
          )
        .def("BVH",
             ( const handle<BVH_Tree<Standard_Real, 3>> & (SelectMgr_SelectableObjectSet::*)(  const SelectMgr_SelectableObjectSet::BVHSubset  ) const) static_cast< const handle<BVH_Tree<Standard_Real, 3>> & (SelectMgr_SelectableObjectSet::*)(  const SelectMgr_SelectableObjectSet::BVHSubset  ) const>(&SelectMgr_SelectableObjectSet::BVH),
             R"#(Returns computed BVH for the theSubset given.)#"  , py::arg("theSubset")
          )
        .def("DumpJson",
             (void (SelectMgr_SelectableObjectSet::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (SelectMgr_SelectableObjectSet::*)( Standard_OStream & ,  Standard_Integer  ) const>(&SelectMgr_SelectableObjectSet::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class SelectMgr_SelectingVolumeManager from ./opencascade/SelectMgr_SelectingVolumeManager.hxx
    klass = m.attr("SelectMgr_SelectingVolumeManager");


    // nested enums

    static_cast<py::class_<SelectMgr_SelectingVolumeManager , shared_ptr<SelectMgr_SelectingVolumeManager>  , SelectBasics_SelectingVolumeManager >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("InitPointSelectingVolume",
             (void (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt2d &  ) ) static_cast<void (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt2d &  ) >(&SelectMgr_SelectingVolumeManager::InitPointSelectingVolume),
             R"#(Creates, initializes and activates rectangular selecting frustum for point selection)#"  , py::arg("thePoint")
          )
        .def("InitBoxSelectingVolume",
             (void (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt2d & ,   const gp_Pnt2d &  ) ) static_cast<void (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt2d & ,   const gp_Pnt2d &  ) >(&SelectMgr_SelectingVolumeManager::InitBoxSelectingVolume),
             R"#(Creates, initializes and activates rectangular selecting frustum for box selection)#"  , py::arg("theMinPt"),  py::arg("theMaxPt")
          )
        .def("InitPolylineSelectingVolume",
             (void (SelectMgr_SelectingVolumeManager::*)(  const TColgp_Array1OfPnt2d &  ) ) static_cast<void (SelectMgr_SelectingVolumeManager::*)(  const TColgp_Array1OfPnt2d &  ) >(&SelectMgr_SelectingVolumeManager::InitPolylineSelectingVolume),
             R"#(Creates, initializes and activates set of triangular selecting frustums for polyline selection)#"  , py::arg("thePoints")
          )
        .def("InitAxisSelectingVolume",
             (void (SelectMgr_SelectingVolumeManager::*)(  const gp_Ax1 &  ) ) static_cast<void (SelectMgr_SelectingVolumeManager::*)(  const gp_Ax1 &  ) >(&SelectMgr_SelectingVolumeManager::InitAxisSelectingVolume),
             R"#(Creates and activates axis selector for point selection)#"  , py::arg("theAxis")
          )
        .def("InitSelectingVolume",
             (void (SelectMgr_SelectingVolumeManager::*)(  const handle<SelectMgr_BaseIntersector> &  ) ) static_cast<void (SelectMgr_SelectingVolumeManager::*)(  const handle<SelectMgr_BaseIntersector> &  ) >(&SelectMgr_SelectingVolumeManager::InitSelectingVolume),
             R"#(Sets as active the custom selecting volume)#"  , py::arg("theVolume")
          )
        .def("BuildSelectingVolume",
             (void (SelectMgr_SelectingVolumeManager::*)() ) static_cast<void (SelectMgr_SelectingVolumeManager::*)() >(&SelectMgr_SelectingVolumeManager::BuildSelectingVolume),
             R"#(Builds previously initialized selecting volume.)#" 
          )
        .def("GetActiveSelectionType",
             (Standard_Integer (SelectMgr_SelectingVolumeManager::*)() const) static_cast<Standard_Integer (SelectMgr_SelectingVolumeManager::*)() const>(&SelectMgr_SelectingVolumeManager::GetActiveSelectionType),
             R"#()#" 
          )
        .def("ScaleAndTransform",
             (SelectMgr_SelectingVolumeManager (SelectMgr_SelectingVolumeManager::*)(  const Standard_Integer ,   const gp_GTrsf & ,   const handle<SelectMgr_FrustumBuilder> &  ) const) static_cast<SelectMgr_SelectingVolumeManager (SelectMgr_SelectingVolumeManager::*)(  const Standard_Integer ,   const gp_GTrsf & ,   const handle<SelectMgr_FrustumBuilder> &  ) const>(&SelectMgr_SelectingVolumeManager::ScaleAndTransform),
             R"#(IMPORTANT: Scaling makes sense only for frustum built on a single point! Note that this method does not perform any checks on type of the frustum.)#"  , py::arg("theScaleFactor"),  py::arg("theTrsf"),  py::arg("theBuilder")
          )
        .def("CopyWithBuilder",
             (SelectMgr_SelectingVolumeManager (SelectMgr_SelectingVolumeManager::*)(  const handle<SelectMgr_FrustumBuilder> &  ) const) static_cast<SelectMgr_SelectingVolumeManager (SelectMgr_SelectingVolumeManager::*)(  const handle<SelectMgr_FrustumBuilder> &  ) const>(&SelectMgr_SelectingVolumeManager::CopyWithBuilder),
             R"#(Returns a copy of the selecting volume manager and its active frustum re-constructed using the passed builder. Builder is an argument that represents corresponding settings for re-constructing transformed frustum from scratch.)#"  , py::arg("theBuilder")
          )
        .def("SetCamera",
             (void (SelectMgr_SelectingVolumeManager::*)(  const handle<Graphic3d_Camera> &  ) ) static_cast<void (SelectMgr_SelectingVolumeManager::*)(  const handle<Graphic3d_Camera> &  ) >(&SelectMgr_SelectingVolumeManager::SetCamera),
             R"#(Updates camera projection and orientation matrices in all selecting volumes Note: this method should be called after selection volume building else exception will be thrown)#"  , py::arg("theCamera")
          )
        .def("SetViewport",
             (void (SelectMgr_SelectingVolumeManager::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<void (SelectMgr_SelectingVolumeManager::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) >(&SelectMgr_SelectingVolumeManager::SetViewport),
             R"#(Updates viewport in all selecting volumes Note: this method should be called after selection volume building else exception will be thrown)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theWidth"),  py::arg("theHeight")
          )
        .def("SetPixelTolerance",
             (void (SelectMgr_SelectingVolumeManager::*)(  const Standard_Integer  ) ) static_cast<void (SelectMgr_SelectingVolumeManager::*)(  const Standard_Integer  ) >(&SelectMgr_SelectingVolumeManager::SetPixelTolerance),
             R"#(Updates pixel tolerance in all selecting volumes Note: this method should be called after selection volume building else exception will be thrown)#"  , py::arg("theTolerance")
          )
        .def("SetWindowSize",
             (void (SelectMgr_SelectingVolumeManager::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_SelectingVolumeManager::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&SelectMgr_SelectingVolumeManager::SetWindowSize),
             R"#(Updates window size in all selecting volumes Note: this method should be called after selection volume building else exception will be thrown)#"  , py::arg("theWidth"),  py::arg("theHeight")
          )
        .def("OverlapsBox",
             (Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_SelectingVolumeManager::OverlapsBox),
             R"#(SAT intersection test between defined volume and given axis-aligned box)#"  , py::arg("theBoxMin"),  py::arg("theBoxMax"),  py::arg("thePickResult")
          )
        .def("OverlapsBox",
             (Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,  Standard_Boolean *  ) const>(&SelectMgr_SelectingVolumeManager::OverlapsBox),
             R"#(Returns true if selecting volume is overlapped by axis-aligned bounding box with minimum corner at point theMinPt and maximum at point theMaxPt)#"  , py::arg("theBoxMin"),  py::arg("theBoxMax"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("OverlapsPoint",
             (Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_SelectingVolumeManager::OverlapsPoint),
             R"#(Intersection test between defined volume and given point)#"  , py::arg("thePnt"),  py::arg("thePickResult")
          )
        .def("OverlapsPoint",
             (Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt &  ) const) static_cast<Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt &  ) const>(&SelectMgr_SelectingVolumeManager::OverlapsPoint),
             R"#(Intersection test between defined volume and given point)#"  , py::arg("thePnt")
          )
        .def("OverlapsPolygon",
             (Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const TColgp_Array1OfPnt & ,  Standard_Integer ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const TColgp_Array1OfPnt & ,  Standard_Integer ,  SelectBasics_PickResult &  ) const>(&SelectMgr_SelectingVolumeManager::OverlapsPolygon),
             R"#(SAT intersection test between defined volume and given ordered set of points, representing line segments. The test may be considered of interior part or boundary line defined by segments depending on given sensitivity type)#"  , py::arg("theArrayOfPts"),  py::arg("theSensType"),  py::arg("thePickResult")
          )
        .def("OverlapsSegment",
             (Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt & ,   const gp_Pnt & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt & ,   const gp_Pnt & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_SelectingVolumeManager::OverlapsSegment),
             R"#(Checks if line segment overlaps selecting frustum)#"  , py::arg("thePnt1"),  py::arg("thePnt2"),  py::arg("thePickResult")
          )
        .def("OverlapsTriangle",
             (Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,  Standard_Integer ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,  Standard_Integer ,  SelectBasics_PickResult &  ) const>(&SelectMgr_SelectingVolumeManager::OverlapsTriangle),
             R"#(SAT intersection test between defined volume and given triangle. The test may be considered of interior part or boundary line defined by triangle vertices depending on given sensitivity type)#"  , py::arg("thePnt1"),  py::arg("thePnt2"),  py::arg("thePnt3"),  py::arg("theSensType"),  py::arg("thePickResult")
          )
        .def("OverlapsSphere",
             (Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt & ,   const Standard_Real ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt & ,   const Standard_Real ,  SelectBasics_PickResult &  ) const>(&SelectMgr_SelectingVolumeManager::OverlapsSphere),
             R"#(Intersection test between defined volume and given sphere)#"  , py::arg("theCenter"),  py::arg("theRadius"),  py::arg("thePickResult")
          )
        .def("OverlapsSphere",
             (Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt & ,   const Standard_Real ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt & ,   const Standard_Real ,  Standard_Boolean *  ) const>(&SelectMgr_SelectingVolumeManager::OverlapsSphere),
             R"#(Intersection test between defined volume and given sphere)#"  , py::arg("theCenter"),  py::arg("theRadius"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("OverlapsCylinder",
             (Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  SelectBasics_PickResult &  ) const>(&SelectMgr_SelectingVolumeManager::OverlapsCylinder),
             R"#(Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses theBottomRad and theTopRad, height theHeight and transformation to apply theTrsf.)#"  , py::arg("theBottomRad"),  py::arg("theTopRad"),  py::arg("theHeight"),  py::arg("theTrsf"),  py::arg("theIsHollow"),  py::arg("thePickResult")
          )
        .def("OverlapsCylinder",
             (Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const>(&SelectMgr_SelectingVolumeManager::OverlapsCylinder),
             R"#(Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses theBottomRad and theTopRad, height theHeight and transformation to apply theTrsf.)#"  , py::arg("theBottomRad"),  py::arg("theTopRad"),  py::arg("theHeight"),  py::arg("theTrsf"),  py::arg("theIsHollow"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("OverlapsCircle",
             (Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  SelectBasics_PickResult &  ) const>(&SelectMgr_SelectingVolumeManager::OverlapsCircle),
             R"#(Returns true if selecting volume is overlapped by circle with radius theRadius, boolean theIsFilled and transformation to apply theTrsf. The position and orientation of the circle are specified via theTrsf transformation for gp::XOY() with center in gp::Origin().)#"  , py::arg("theBottomRad"),  py::arg("theTrsf"),  py::arg("theIsFilled"),  py::arg("thePickResult")
          )
        .def("OverlapsCircle",
             (Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_SelectingVolumeManager::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const>(&SelectMgr_SelectingVolumeManager::OverlapsCircle),
             R"#(Returns true if selecting volume is overlapped by circle with radius theRadius, boolean theIsFilled and transformation to apply theTrsf. The position and orientation of the circle are specified via theTrsf transformation for gp::XOY() with center in gp::Origin().)#"  , py::arg("theBottomRad"),  py::arg("theTrsf"),  py::arg("theIsFilled"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("DistToGeometryCenter",
             (Standard_Real (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt &  ) const) static_cast<Standard_Real (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt &  ) const>(&SelectMgr_SelectingVolumeManager::DistToGeometryCenter),
             R"#(Measures distance between 3d projection of user-picked screen point and given point theCOG)#"  , py::arg("theCOG")
          )
        .def("DetectedPoint",
             (gp_Pnt (SelectMgr_SelectingVolumeManager::*)(  const Standard_Real  ) const) static_cast<gp_Pnt (SelectMgr_SelectingVolumeManager::*)(  const Standard_Real  ) const>(&SelectMgr_SelectingVolumeManager::DetectedPoint),
             R"#(Calculates the point on a view ray that was detected during the run of selection algo by given depth. Throws exception if active selection type is not Point.)#"  , py::arg("theDepth")
          )
        .def("AllowOverlapDetection",
             (void (SelectMgr_SelectingVolumeManager::*)(  const Standard_Boolean  ) ) static_cast<void (SelectMgr_SelectingVolumeManager::*)(  const Standard_Boolean  ) >(&SelectMgr_SelectingVolumeManager::AllowOverlapDetection),
             R"#(If theIsToAllow is false, only fully included sensitives will be detected, otherwise the algorithm will mark both included and overlapped entities as matched)#"  , py::arg("theIsToAllow")
          )
        .def("IsOverlapAllowed",
             (Standard_Boolean (SelectMgr_SelectingVolumeManager::*)() const) static_cast<Standard_Boolean (SelectMgr_SelectingVolumeManager::*)() const>(&SelectMgr_SelectingVolumeManager::IsOverlapAllowed),
             R"#()#" 
          )
        .def("SetViewClipping",
             (void (SelectMgr_SelectingVolumeManager::*)(  const handle<Graphic3d_SequenceOfHClipPlane> & ,   const handle<Graphic3d_SequenceOfHClipPlane> & ,   const SelectMgr_SelectingVolumeManager *  ) ) static_cast<void (SelectMgr_SelectingVolumeManager::*)(  const handle<Graphic3d_SequenceOfHClipPlane> & ,   const handle<Graphic3d_SequenceOfHClipPlane> & ,   const SelectMgr_SelectingVolumeManager *  ) >(&SelectMgr_SelectingVolumeManager::SetViewClipping),
             R"#(Valid for point selection only! Computes depth range for clipping planes.)#"  , py::arg("theViewPlanes"),  py::arg("theObjPlanes"),  py::arg("theWorldSelMgr")
          )
        .def("SetViewClipping",
             (void (SelectMgr_SelectingVolumeManager::*)(  const SelectMgr_SelectingVolumeManager &  ) ) static_cast<void (SelectMgr_SelectingVolumeManager::*)(  const SelectMgr_SelectingVolumeManager &  ) >(&SelectMgr_SelectingVolumeManager::SetViewClipping),
             R"#(Copy clipping planes from another volume manager.)#"  , py::arg("theOther")
          )
        .def("SetViewClipRanges",
             (void (SelectMgr_SelectingVolumeManager::*)(  const SelectMgr_ViewClipRange &  ) ) static_cast<void (SelectMgr_SelectingVolumeManager::*)(  const SelectMgr_ViewClipRange &  ) >(&SelectMgr_SelectingVolumeManager::SetViewClipRanges),
             R"#(Set clipping range.)#"  , py::arg("theRange")
          )
        .def("GetVertices",
             ( const gp_Pnt * (SelectMgr_SelectingVolumeManager::*)() const) static_cast< const gp_Pnt * (SelectMgr_SelectingVolumeManager::*)() const>(&SelectMgr_SelectingVolumeManager::GetVertices),
             R"#(A set of helper functions that return rectangular selecting frustum data)#" 
          )
        .def("GetNearPickedPnt",
             (gp_Pnt (SelectMgr_SelectingVolumeManager::*)() const) static_cast<gp_Pnt (SelectMgr_SelectingVolumeManager::*)() const>(&SelectMgr_SelectingVolumeManager::GetNearPickedPnt),
             R"#(Valid only for point and rectangular selection. Returns projection of 2d mouse picked point or projection of center of 2d rectangle (for point and rectangular selection correspondingly) onto near view frustum plane)#" 
          )
        .def("GetFarPickedPnt",
             (gp_Pnt (SelectMgr_SelectingVolumeManager::*)() const) static_cast<gp_Pnt (SelectMgr_SelectingVolumeManager::*)() const>(&SelectMgr_SelectingVolumeManager::GetFarPickedPnt),
             R"#(Valid only for point and rectangular selection. Returns projection of 2d mouse picked point or projection of center of 2d rectangle (for point and rectangular selection correspondingly) onto far view frustum plane)#" 
          )
        .def("GetViewRayDirection",
             (gp_Dir (SelectMgr_SelectingVolumeManager::*)() const) static_cast<gp_Dir (SelectMgr_SelectingVolumeManager::*)() const>(&SelectMgr_SelectingVolumeManager::GetViewRayDirection),
             R"#(Valid only for point and rectangular selection. Returns view ray direction)#" 
          )
        .def("IsScalableActiveVolume",
             (Standard_Boolean (SelectMgr_SelectingVolumeManager::*)() const) static_cast<Standard_Boolean (SelectMgr_SelectingVolumeManager::*)() const>(&SelectMgr_SelectingVolumeManager::IsScalableActiveVolume),
             R"#(Checks if it is possible to scale current active selecting volume)#" 
          )
        .def("GetMousePosition",
             (gp_Pnt2d (SelectMgr_SelectingVolumeManager::*)() const) static_cast<gp_Pnt2d (SelectMgr_SelectingVolumeManager::*)() const>(&SelectMgr_SelectingVolumeManager::GetMousePosition),
             R"#(Returns mouse coordinates for Point selection mode.)#" 
          )
        .def("GetPlanes",
             (void (SelectMgr_SelectingVolumeManager::*)( NCollection_Vector<SelectMgr_Vec4> &  ) const) static_cast<void (SelectMgr_SelectingVolumeManager::*)( NCollection_Vector<SelectMgr_Vec4> &  ) const>(&SelectMgr_SelectingVolumeManager::GetPlanes),
             R"#(Stores plane equation coefficients (in the following form: Ax + By + Cz + D = 0) to the given vector)#"  , py::arg("thePlaneEquations")
          )
        .def("DumpJson",
             (void (SelectMgr_SelectingVolumeManager::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (SelectMgr_SelectingVolumeManager::*)( Standard_OStream & ,  Standard_Integer  ) const>(&SelectMgr_SelectingVolumeManager::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("BuildSelectingVolume",
             (void (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt2d &  ) ) static_cast<void (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt2d &  ) >(&SelectMgr_SelectingVolumeManager::BuildSelectingVolume),
             R"#()#"  , py::arg("thePoint")
          )
        .def("BuildSelectingVolume",
             (void (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt2d & ,   const gp_Pnt2d &  ) ) static_cast<void (SelectMgr_SelectingVolumeManager::*)(  const gp_Pnt2d & ,   const gp_Pnt2d &  ) >(&SelectMgr_SelectingVolumeManager::BuildSelectingVolume),
             R"#()#"  , py::arg("theMinPt"),  py::arg("theMaxPt")
          )
        .def("BuildSelectingVolume",
             (void (SelectMgr_SelectingVolumeManager::*)(  const TColgp_Array1OfPnt2d &  ) ) static_cast<void (SelectMgr_SelectingVolumeManager::*)(  const TColgp_Array1OfPnt2d &  ) >(&SelectMgr_SelectingVolumeManager::BuildSelectingVolume),
             R"#()#"  , py::arg("thePoints")
          )
    // methods using call by reference i.s.o. return
        .def("WindowSize",
             []( SelectMgr_SelectingVolumeManager &self   ){
                 Standard_Integer  theWidth;
                Standard_Integer  theHeight;

                 self.WindowSize(theWidth,theHeight);
                 
                 return std::make_tuple(theWidth,theHeight); },
             R"#(Returns window size)#" 
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ActiveVolume",
             ( const handle<SelectMgr_BaseIntersector> & (SelectMgr_SelectingVolumeManager::*)() const) static_cast< const handle<SelectMgr_BaseIntersector> & (SelectMgr_SelectingVolumeManager::*)() const>(&SelectMgr_SelectingVolumeManager::ActiveVolume),
             R"#(Returns active selecting volume that was built during last run of OCCT selection mechanism)#"
             
         )
       .def("Camera",
             ( const handle<Graphic3d_Camera> & (SelectMgr_SelectingVolumeManager::*)() const) static_cast< const handle<Graphic3d_Camera> & (SelectMgr_SelectingVolumeManager::*)() const>(&SelectMgr_SelectingVolumeManager::Camera),
             R"#(Returns current camera definition.)#"
             
         )
       .def("ViewClipping",
             ( const handle<Graphic3d_SequenceOfHClipPlane> & (SelectMgr_SelectingVolumeManager::*)() const) static_cast< const handle<Graphic3d_SequenceOfHClipPlane> & (SelectMgr_SelectingVolumeManager::*)() const>(&SelectMgr_SelectingVolumeManager::ViewClipping),
             R"#(Return view clipping planes.)#"
             
         )
       .def("ObjectClipping",
             ( const handle<Graphic3d_SequenceOfHClipPlane> & (SelectMgr_SelectingVolumeManager::*)() const) static_cast< const handle<Graphic3d_SequenceOfHClipPlane> & (SelectMgr_SelectingVolumeManager::*)() const>(&SelectMgr_SelectingVolumeManager::ObjectClipping),
             R"#(Return object clipping planes.)#"
             
         )
       .def("ViewClipRanges",
             ( const SelectMgr_ViewClipRange & (SelectMgr_SelectingVolumeManager::*)() const) static_cast< const SelectMgr_ViewClipRange & (SelectMgr_SelectingVolumeManager::*)() const>(&SelectMgr_SelectingVolumeManager::ViewClipRanges),
             R"#(Return clipping range.)#"
             
         )
;

    // Class SelectMgr_Selection from ./opencascade/SelectMgr_Selection.hxx
    klass = m.attr("SelectMgr_Selection");


    // nested enums

    static_cast<py::class_<SelectMgr_Selection ,opencascade::handle<SelectMgr_Selection>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  const Standard_Integer >()  , py::arg("theModeIdx")=static_cast< const Standard_Integer>(0) )
    // custom constructors
    // methods
        .def("Destroy",
             (void (SelectMgr_Selection::*)() ) static_cast<void (SelectMgr_Selection::*)() >(&SelectMgr_Selection::Destroy),
             R"#()#" 
          )
        .def("Add",
             (void (SelectMgr_Selection::*)(  const handle<Select3D_SensitiveEntity> &  ) ) static_cast<void (SelectMgr_Selection::*)(  const handle<Select3D_SensitiveEntity> &  ) >(&SelectMgr_Selection::Add),
             R"#(Adds the sensitive primitive to the list of stored entities in this object. Raises NullObject if the primitive is a null handle.)#"  , py::arg("theSensitive")
          )
        .def("Clear",
             (void (SelectMgr_Selection::*)() ) static_cast<void (SelectMgr_Selection::*)() >(&SelectMgr_Selection::Clear),
             R"#(empties the selection from all the stored entities)#" 
          )
        .def("IsEmpty",
             (Standard_Boolean (SelectMgr_Selection::*)() const) static_cast<Standard_Boolean (SelectMgr_Selection::*)() const>(&SelectMgr_Selection::IsEmpty),
             R"#(returns true if no sensitive entity is stored.)#" 
          )
        .def("Mode",
             (Standard_Integer (SelectMgr_Selection::*)() const) static_cast<Standard_Integer (SelectMgr_Selection::*)() const>(&SelectMgr_Selection::Mode),
             R"#(returns the selection mode represented by this selection)#" 
          )
        .def("UpdateStatus",
             (SelectMgr_TypeOfUpdate (SelectMgr_Selection::*)() const) static_cast<SelectMgr_TypeOfUpdate (SelectMgr_Selection::*)() const>(&SelectMgr_Selection::UpdateStatus),
             R"#(Returns the flag UpdateFlag. This flag gives the update status of this framework in a ViewerSelector object: - full - partial, or - none.)#" 
          )
        .def("UpdateStatus",
             (void (SelectMgr_Selection::*)(  const SelectMgr_TypeOfUpdate  ) ) static_cast<void (SelectMgr_Selection::*)(  const SelectMgr_TypeOfUpdate  ) >(&SelectMgr_Selection::UpdateStatus),
             R"#()#"  , py::arg("theStatus")
          )
        .def("UpdateBVHStatus",
             (void (SelectMgr_Selection::*)(  const SelectMgr_TypeOfBVHUpdate  ) ) static_cast<void (SelectMgr_Selection::*)(  const SelectMgr_TypeOfBVHUpdate  ) >(&SelectMgr_Selection::UpdateBVHStatus),
             R"#()#"  , py::arg("theStatus")
          )
        .def("BVHUpdateStatus",
             (SelectMgr_TypeOfBVHUpdate (SelectMgr_Selection::*)() const) static_cast<SelectMgr_TypeOfBVHUpdate (SelectMgr_Selection::*)() const>(&SelectMgr_Selection::BVHUpdateStatus),
             R"#()#" 
          )
        .def("GetSelectionState",
             (SelectMgr_StateOfSelection (SelectMgr_Selection::*)() const) static_cast<SelectMgr_StateOfSelection (SelectMgr_Selection::*)() const>(&SelectMgr_Selection::GetSelectionState),
             R"#(Returns status of selection)#" 
          )
        .def("SetSelectionState",
             (void (SelectMgr_Selection::*)(  const SelectMgr_StateOfSelection  ) const) static_cast<void (SelectMgr_Selection::*)(  const SelectMgr_StateOfSelection  ) const>(&SelectMgr_Selection::SetSelectionState),
             R"#(Sets status of selection)#"  , py::arg("theState")
          )
        .def("Sensitivity",
             (Standard_Integer (SelectMgr_Selection::*)() const) static_cast<Standard_Integer (SelectMgr_Selection::*)() const>(&SelectMgr_Selection::Sensitivity),
             R"#(Returns sensitivity of the selection)#" 
          )
        .def("SetSensitivity",
             (void (SelectMgr_Selection::*)(  const Standard_Integer  ) ) static_cast<void (SelectMgr_Selection::*)(  const Standard_Integer  ) >(&SelectMgr_Selection::SetSensitivity),
             R"#(Changes sensitivity of the selection and all its entities to the given value. IMPORTANT: This method does not update any outer selection structures, so for proper updates use SelectMgr_SelectionManager::SetSelectionSensitivity method.)#"  , py::arg("theNewSens")
          )
        .def("DumpJson",
             (void (SelectMgr_Selection::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (SelectMgr_Selection::*)( Standard_OStream & ,  Standard_Integer  ) const>(&SelectMgr_Selection::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_Selection::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_Selection::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_Selection::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_Selection::*)() const>(&SelectMgr_Selection::DynamicType),
             R"#()#"
             
         )
       .def("Entities",
             ( const NCollection_Vector<handle<SelectMgr_SensitiveEntity>> & (SelectMgr_Selection::*)() const) static_cast< const NCollection_Vector<handle<SelectMgr_SensitiveEntity>> & (SelectMgr_Selection::*)() const>(&SelectMgr_Selection::Entities),
             R"#(Return entities.)#"
             
         )
       .def("ChangeEntities",
             (NCollection_Vector<handle<SelectMgr_SensitiveEntity>> & (SelectMgr_Selection::*)() ) static_cast<NCollection_Vector<handle<SelectMgr_SensitiveEntity>> & (SelectMgr_Selection::*)() >(&SelectMgr_Selection::ChangeEntities),
             R"#(Return entities.)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class SelectMgr_SelectionImageFiller from ./opencascade/SelectMgr_SelectionImageFiller.hxx
    klass = m.attr("SelectMgr_SelectionImageFiller");


    // nested enums

    static_cast<py::class_<SelectMgr_SelectionImageFiller ,opencascade::handle<SelectMgr_SelectionImageFiller> ,Py_SelectMgr_SelectionImageFiller , Standard_Transient >>(klass)
    // constructors
        .def(py::init< Image_PixMap &,SelectMgr_ViewerSelector * >()  , py::arg("thePixMap"),  py::arg("theSelector") )
    // custom constructors
    // methods
        .def("Fill",
             (void (SelectMgr_SelectionImageFiller::*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_SelectionImageFiller::*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer  ) >(&SelectMgr_SelectionImageFiller::Fill),
             R"#(Fill pixel at specified position.)#"  , py::arg("theCol"),  py::arg("theRow"),  py::arg("thePicked")
          )
        .def("Flush",
             (void (SelectMgr_SelectionImageFiller::*)() ) static_cast<void (SelectMgr_SelectionImageFiller::*)() >(&SelectMgr_SelectionImageFiller::Flush),
             R"#(Flush results into final image.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("CreateFiller_s",
                    (handle<SelectMgr_SelectionImageFiller> (*)( Image_PixMap & ,  SelectMgr_ViewerSelector * ,  StdSelect_TypeOfSelectionImage  ) ) static_cast<handle<SelectMgr_SelectionImageFiller> (*)( Image_PixMap & ,  SelectMgr_ViewerSelector * ,  StdSelect_TypeOfSelectionImage  ) >(&SelectMgr_SelectionImageFiller::CreateFiller),
                    R"#(Create filler of specified type.)#"  , py::arg("thePixMap"),  py::arg("theSelector"),  py::arg("theType")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class SelectMgr_SelectionManager from ./opencascade/SelectMgr_SelectionManager.hxx
    klass = m.attr("SelectMgr_SelectionManager");


    // nested enums

    static_cast<py::class_<SelectMgr_SelectionManager ,opencascade::handle<SelectMgr_SelectionManager>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  const handle<SelectMgr_ViewerSelector> & >()  , py::arg("theSelector") )
    // custom constructors
    // methods
        .def("Contains",
             (Standard_Boolean (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> &  ) const) static_cast<Standard_Boolean (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> &  ) const>(&SelectMgr_SelectionManager::Contains),
             R"#(Returns true if the manager contains the selectable object theObject.)#"  , py::arg("theObject")
          )
        .def("Load",
             (void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer  ) >(&SelectMgr_SelectionManager::Load),
             R"#(Loads and computes selection mode theMode (if it is not equal to -1) in global context and adds selectable object to BVH tree. If the object theObject has an already calculated selection with mode theMode and it was removed, the selection will be recalculated.)#"  , py::arg("theObject"),  py::arg("theMode")=static_cast< const Standard_Integer>(- 1)
          )
        .def("Remove",
             (void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> &  ) ) static_cast<void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> &  ) >(&SelectMgr_SelectionManager::Remove),
             R"#(Removes selectable object theObject from all viewer selectors it was added to previously, removes it from all contexts and clears all computed selections of theObject.)#"  , py::arg("theObject")
          )
        .def("Activate",
             (void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer  ) >(&SelectMgr_SelectionManager::Activate),
             R"#(Activates the selection mode theMode in the selector theSelector for the selectable object anObject. By default, theMode is equal to 0. If theSelector is set to default (NULL), the selection with the mode theMode will be activated in all the viewers available.)#"  , py::arg("theObject"),  py::arg("theMode")=static_cast< const Standard_Integer>(0)
          )
        .def("Deactivate",
             (void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer  ) >(&SelectMgr_SelectionManager::Deactivate),
             R"#(Deactivates mode theMode of theObject in theSelector. If theMode value is set to default (-1), all active selection modes will be deactivated. Likewise, if theSelector value is set to default (NULL), theMode will be deactivated in all viewer selectors.)#"  , py::arg("theObject"),  py::arg("theMode")=static_cast< const Standard_Integer>(- 1)
          )
        .def("IsActivated",
             (Standard_Boolean (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer  ) const) static_cast<Standard_Boolean (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer  ) const>(&SelectMgr_SelectionManager::IsActivated),
             R"#(Returns true if the selection with theMode is active for the selectable object theObject and selector theSelector. If all parameters are set to default values, it returns it there is any active selection in any known viewer selector for object theObject.)#"  , py::arg("theObject"),  py::arg("theMode")=static_cast< const Standard_Integer>(- 1)
          )
        .def("ClearSelectionStructures",
             (void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer  ) >(&SelectMgr_SelectionManager::ClearSelectionStructures),
             R"#(Removes sensitive entities from all viewer selectors after method Clear() was called to the selection they belonged to or it was recomputed somehow.)#"  , py::arg("theObj"),  py::arg("theMode")=static_cast< const Standard_Integer>(- 1)
          )
        .def("RestoreSelectionStructures",
             (void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer  ) >(&SelectMgr_SelectionManager::RestoreSelectionStructures),
             R"#(Re-adds newly calculated sensitive entities of recomputed selection defined by mode theMode to all viewer selectors contained that selection.)#"  , py::arg("theObj"),  py::arg("theMode")=static_cast< const Standard_Integer>(- 1)
          )
        .def("RecomputeSelection",
             (void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Boolean ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Boolean ,   const Standard_Integer  ) >(&SelectMgr_SelectionManager::RecomputeSelection),
             R"#(Recomputes activated selections of theObject for all known viewer selectors according to theMode specified. If theMode is set to default (-1), then all activated selections will be recomputed. If theIsForce is set to true, then selection mode theMode for object theObject will be recomputed regardless of its activation status.)#"  , py::arg("theObject"),  py::arg("theIsForce")=static_cast< const Standard_Boolean>(Standard_False),  py::arg("theMode")=static_cast< const Standard_Integer>(- 1)
          )
        .def("Update",
             (void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Boolean  ) ) static_cast<void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Boolean  ) >(&SelectMgr_SelectionManager::Update),
             R"#(Updates all selections of theObject in all viewer selectors according to its current update status. If theIsForce is set to true, the call is equal to recomputation.)#"  , py::arg("theObject"),  py::arg("theIsForce")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def("SetUpdateMode",
             (void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const SelectMgr_TypeOfUpdate  ) ) static_cast<void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const SelectMgr_TypeOfUpdate  ) >(&SelectMgr_SelectionManager::SetUpdateMode),
             R"#(Sets type of update of all selections of theObject to the given theType.)#"  , py::arg("theObject"),  py::arg("theType")
          )
        .def("SetUpdateMode",
             (void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer ,   const SelectMgr_TypeOfUpdate  ) ) static_cast<void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer ,   const SelectMgr_TypeOfUpdate  ) >(&SelectMgr_SelectionManager::SetUpdateMode),
             R"#(Sets type of update of selection with theMode of theObject to the given theType.)#"  , py::arg("theObject"),  py::arg("theMode"),  py::arg("theType")
          )
        .def("SetSelectionSensitivity",
             (void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer ,   const Standard_Integer  ) >(&SelectMgr_SelectionManager::SetSelectionSensitivity),
             R"#(Allows to manage sensitivity of a particular selection of interactive object theObject and changes previous sensitivity value of all sensitive entities in selection with theMode to the given theNewSensitivity.)#"  , py::arg("theObject"),  py::arg("theMode"),  py::arg("theNewSens")
          )
        .def("UpdateSelection",
             (void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> &  ) ) static_cast<void (SelectMgr_SelectionManager::*)(  const handle<SelectMgr_SelectableObject> &  ) >(&SelectMgr_SelectionManager::UpdateSelection),
             R"#(Re-adds selectable object in BVHs in all viewer selectors.)#"  , py::arg("theObj")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_SelectionManager::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_SelectionManager::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_SelectionManager::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_SelectionManager::*)() const>(&SelectMgr_SelectionManager::DynamicType),
             R"#()#"
             
         )
       .def("Selector",
             ( const handle<SelectMgr_ViewerSelector> & (SelectMgr_SelectionManager::*)() const) static_cast< const handle<SelectMgr_ViewerSelector> & (SelectMgr_SelectionManager::*)() const>(&SelectMgr_SelectionManager::Selector),
             R"#(Return the Selector.)#"
             
         )
;

    // Class SelectMgr_SensitiveEntity from ./opencascade/SelectMgr_SensitiveEntity.hxx
    klass = m.attr("SelectMgr_SensitiveEntity");


    // nested enums

    static_cast<py::class_<SelectMgr_SensitiveEntity ,opencascade::handle<SelectMgr_SensitiveEntity>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  const handle<Select3D_SensitiveEntity> & >()  , py::arg("theEntity") )
    // custom constructors
    // methods
        .def("Clear",
             (void (SelectMgr_SensitiveEntity::*)() ) static_cast<void (SelectMgr_SensitiveEntity::*)() >(&SelectMgr_SensitiveEntity::Clear),
             R"#(Clears up all resources and memory)#" 
          )
        .def("IsActiveForSelection",
             (Standard_Boolean (SelectMgr_SensitiveEntity::*)() const) static_cast<Standard_Boolean (SelectMgr_SensitiveEntity::*)() const>(&SelectMgr_SensitiveEntity::IsActiveForSelection),
             R"#(Returns true if this entity belongs to the active selection mode of parent object)#" 
          )
        .def("ResetSelectionActiveStatus",
             (void (SelectMgr_SensitiveEntity::*)() const) static_cast<void (SelectMgr_SensitiveEntity::*)() const>(&SelectMgr_SensitiveEntity::ResetSelectionActiveStatus),
             R"#(Marks entity as inactive for selection)#" 
          )
        .def("SetActiveForSelection",
             (void (SelectMgr_SensitiveEntity::*)() const) static_cast<void (SelectMgr_SensitiveEntity::*)() const>(&SelectMgr_SensitiveEntity::SetActiveForSelection),
             R"#(Marks entity as active for selection)#" 
          )
        .def("DumpJson",
             (void (SelectMgr_SensitiveEntity::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (SelectMgr_SensitiveEntity::*)( Standard_OStream & ,  Standard_Integer  ) const>(&SelectMgr_SensitiveEntity::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_SensitiveEntity::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_SensitiveEntity::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("BaseSensitive",
             ( const handle<Select3D_SensitiveEntity> & (SelectMgr_SensitiveEntity::*)() const) static_cast< const handle<Select3D_SensitiveEntity> & (SelectMgr_SensitiveEntity::*)() const>(&SelectMgr_SensitiveEntity::BaseSensitive),
             R"#(Returns related instance of SelectBasics class)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_SensitiveEntity::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_SensitiveEntity::*)() const>(&SelectMgr_SensitiveEntity::DynamicType),
             R"#()#"
             
         )
;

    // Class SelectMgr_SensitiveEntitySet from ./opencascade/SelectMgr_SensitiveEntitySet.hxx
    klass = m.attr("SelectMgr_SensitiveEntitySet");


    // nested enums

    static_cast<py::class_<SelectMgr_SensitiveEntitySet , shared_ptr<SelectMgr_SensitiveEntitySet>  >>(klass)
    // constructors
        .def(py::init<  const handle<Select3D_BVHBuilder3d> & >()  , py::arg("theBuilder") )
    // custom constructors
    // methods
        .def("Append",
             (void (SelectMgr_SensitiveEntitySet::*)(  const handle<SelectMgr_SensitiveEntity> &  ) ) static_cast<void (SelectMgr_SensitiveEntitySet::*)(  const handle<SelectMgr_SensitiveEntity> &  ) >(&SelectMgr_SensitiveEntitySet::Append),
             R"#(Adds new entity to the set and marks BVH tree for rebuild)#"  , py::arg("theEntity")
          )
        .def("Append",
             (void (SelectMgr_SensitiveEntitySet::*)(  const handle<SelectMgr_Selection> &  ) ) static_cast<void (SelectMgr_SensitiveEntitySet::*)(  const handle<SelectMgr_Selection> &  ) >(&SelectMgr_SensitiveEntitySet::Append),
             R"#(Adds every entity of selection theSelection to the set and marks BVH tree for rebuild)#"  , py::arg("theSelection")
          )
        .def("Remove",
             (void (SelectMgr_SensitiveEntitySet::*)(  const handle<SelectMgr_Selection> &  ) ) static_cast<void (SelectMgr_SensitiveEntitySet::*)(  const handle<SelectMgr_Selection> &  ) >(&SelectMgr_SensitiveEntitySet::Remove),
             R"#(Removes every entity of selection theSelection from the set and marks BVH tree for rebuild)#"  , py::arg("theSelection")
          )
        .def("Box",
             (Select3D_BndBox3d (SelectMgr_SensitiveEntitySet::*)(  const Standard_Integer  ) const) static_cast<Select3D_BndBox3d (SelectMgr_SensitiveEntitySet::*)(  const Standard_Integer  ) const>(&SelectMgr_SensitiveEntitySet::Box),
             R"#(Returns bounding box of entity with index theIdx)#"  , py::arg("theIndex")
          )
        .def("Center",
             (Standard_Real (SelectMgr_SensitiveEntitySet::*)(  const Standard_Integer ,   const Standard_Integer  ) const) static_cast<Standard_Real (SelectMgr_SensitiveEntitySet::*)(  const Standard_Integer ,   const Standard_Integer  ) const>(&SelectMgr_SensitiveEntitySet::Center),
             R"#(Returns geometry center of sensitive entity index theIdx along the given axis theAxis)#"  , py::arg("theIndex"),  py::arg("theAxis")
          )
        .def("Swap",
             (void (SelectMgr_SensitiveEntitySet::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_SensitiveEntitySet::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&SelectMgr_SensitiveEntitySet::Swap),
             R"#(Swaps items with indexes theIdx1 and theIdx2)#"  , py::arg("theIndex1"),  py::arg("theIndex2")
          )
        .def("Size",
             (Standard_Integer (SelectMgr_SensitiveEntitySet::*)() const) static_cast<Standard_Integer (SelectMgr_SensitiveEntitySet::*)() const>(&SelectMgr_SensitiveEntitySet::Size),
             R"#(Returns the amount of entities)#" 
          )
        .def("GetSensitiveById",
             ( const handle<SelectMgr_SensitiveEntity> & (SelectMgr_SensitiveEntitySet::*)(  const Standard_Integer  ) const) static_cast< const handle<SelectMgr_SensitiveEntity> & (SelectMgr_SensitiveEntitySet::*)(  const Standard_Integer  ) const>(&SelectMgr_SensitiveEntitySet::GetSensitiveById),
             R"#(Returns the entity with index theIndex in the set)#"  , py::arg("theIndex")
          )
        .def("HasEntityWithPersistence",
             (Standard_Boolean (SelectMgr_SensitiveEntitySet::*)() const) static_cast<Standard_Boolean (SelectMgr_SensitiveEntitySet::*)() const>(&SelectMgr_SensitiveEntitySet::HasEntityWithPersistence),
             R"#(Returns map of entities.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_SensitiveEntitySet::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_SensitiveEntitySet::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_SensitiveEntitySet::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_SensitiveEntitySet::*)() const>(&SelectMgr_SensitiveEntitySet::DynamicType),
             R"#()#"
             
         )
       .def("Sensitives",
             ( const SelectMgr_IndexedMapOfHSensitive & (SelectMgr_SensitiveEntitySet::*)() const) static_cast< const SelectMgr_IndexedMapOfHSensitive & (SelectMgr_SensitiveEntitySet::*)() const>(&SelectMgr_SensitiveEntitySet::Sensitives),
             R"#(Returns map of entities.)#"
             
         )
       .def("Owners",
             ( const SelectMgr_MapOfOwners & (SelectMgr_SensitiveEntitySet::*)() const) static_cast< const SelectMgr_MapOfOwners & (SelectMgr_SensitiveEntitySet::*)() const>(&SelectMgr_SensitiveEntitySet::Owners),
             R"#(Returns map of owners.)#"
             
         )
;

    // Class SelectMgr_SortCriterion from ./opencascade/SelectMgr_SortCriterion.hxx
    klass = m.attr("SelectMgr_SortCriterion");


    // nested enums

    static_cast<py::class_<SelectMgr_SortCriterion , shared_ptr<SelectMgr_SortCriterion>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("IsCloserDepth",
             (bool (SelectMgr_SortCriterion::*)(  const SelectMgr_SortCriterion &  ) const) static_cast<bool (SelectMgr_SortCriterion::*)(  const SelectMgr_SortCriterion &  ) const>(&SelectMgr_SortCriterion::IsCloserDepth),
             R"#(Compare with another item by depth, priority and minDist.)#"  , py::arg("theOther")
          )
        .def("IsHigherPriority",
             (bool (SelectMgr_SortCriterion::*)(  const SelectMgr_SortCriterion &  ) const) static_cast<bool (SelectMgr_SortCriterion::*)(  const SelectMgr_SortCriterion &  ) const>(&SelectMgr_SortCriterion::IsHigherPriority),
             R"#(Compare with another item using old logic (OCCT version <= 6.3.1) with priority considered preceding depth.)#"  , py::arg("theOther")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("Point", &SelectMgr_SortCriterion::Point)
        .def_readwrite("Normal", &SelectMgr_SortCriterion::Normal)
        .def_readwrite("Depth", &SelectMgr_SortCriterion::Depth)
        .def_readwrite("MinDist", &SelectMgr_SortCriterion::MinDist)
        .def_readwrite("Tolerance", &SelectMgr_SortCriterion::Tolerance)
        .def_readwrite("SelectionPriority", &SelectMgr_SortCriterion::SelectionPriority)
        .def_readwrite("DisplayPriority", &SelectMgr_SortCriterion::DisplayPriority)
        .def_readwrite("ZLayerPosition", &SelectMgr_SortCriterion::ZLayerPosition)
        .def_readwrite("NbOwnerMatches", &SelectMgr_SortCriterion::NbOwnerMatches)
        .def_readwrite("IsPreferPriority", &SelectMgr_SortCriterion::IsPreferPriority)
    // methods returning by ref wrapped as properties
;

    // Class SelectMgr_ToleranceMap from ./opencascade/SelectMgr_ToleranceMap.hxx
    klass = m.attr("SelectMgr_ToleranceMap");


    // nested enums

    static_cast<py::class_<SelectMgr_ToleranceMap , shared_ptr<SelectMgr_ToleranceMap>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Add",
             (void (SelectMgr_ToleranceMap::*)(  const Standard_Integer &  ) ) static_cast<void (SelectMgr_ToleranceMap::*)(  const Standard_Integer &  ) >(&SelectMgr_ToleranceMap::Add),
             R"#(Adds the value given to map, checks if the current tolerance value should be replaced by theTolerance)#"  , py::arg("theTolerance")
          )
        .def("Decrement",
             (void (SelectMgr_ToleranceMap::*)(  const Standard_Integer &  ) ) static_cast<void (SelectMgr_ToleranceMap::*)(  const Standard_Integer &  ) >(&SelectMgr_ToleranceMap::Decrement),
             R"#(Decrements a counter of the tolerance given, checks if the current tolerance value should be recalculated)#"  , py::arg("theTolerance")
          )
        .def("Tolerance",
             (Standard_Integer (SelectMgr_ToleranceMap::*)() const) static_cast<Standard_Integer (SelectMgr_ToleranceMap::*)() const>(&SelectMgr_ToleranceMap::Tolerance),
             R"#(Returns a current tolerance that must be applied)#" 
          )
        .def("SetCustomTolerance",
             (void (SelectMgr_ToleranceMap::*)(  const Standard_Integer  ) ) static_cast<void (SelectMgr_ToleranceMap::*)(  const Standard_Integer  ) >(&SelectMgr_ToleranceMap::SetCustomTolerance),
             R"#(Sets tolerance to the given one and disables adaptive checks)#"  , py::arg("theTolerance")
          )
        .def("ResetDefaults",
             (void (SelectMgr_ToleranceMap::*)() ) static_cast<void (SelectMgr_ToleranceMap::*)() >(&SelectMgr_ToleranceMap::ResetDefaults),
             R"#(Unsets a custom tolerance and enables adaptive checks)#" 
          )
        .def("CustomTolerance",
             (Standard_Integer (SelectMgr_ToleranceMap::*)() const) static_cast<Standard_Integer (SelectMgr_ToleranceMap::*)() const>(&SelectMgr_ToleranceMap::CustomTolerance),
             R"#(Returns the value of custom tolerance regardless of it validity)#" 
          )
        .def("IsCustomTolSet",
             (Standard_Boolean (SelectMgr_ToleranceMap::*)() const) static_cast<Standard_Boolean (SelectMgr_ToleranceMap::*)() const>(&SelectMgr_ToleranceMap::IsCustomTolSet),
             R"#(Returns true if custom tolerance value is greater than zero)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class SelectMgr_TriangularFrustum from ./opencascade/SelectMgr_TriangularFrustum.hxx
    klass = m.attr("SelectMgr_TriangularFrustum");


    // nested enums

    static_cast<py::class_<SelectMgr_TriangularFrustum , shared_ptr<SelectMgr_TriangularFrustum>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Init",
             (void (SelectMgr_TriangularFrustum::*)(  const gp_Pnt2d & ,   const gp_Pnt2d & ,   const gp_Pnt2d &  ) ) static_cast<void (SelectMgr_TriangularFrustum::*)(  const gp_Pnt2d & ,   const gp_Pnt2d & ,   const gp_Pnt2d &  ) >(&SelectMgr_TriangularFrustum::Init),
             R"#(Initializes selection triangle by input points)#"  , py::arg("theP1"),  py::arg("theP2"),  py::arg("theP3")
          )
        .def("Build",
             (void (SelectMgr_TriangularFrustum::*)() ) static_cast<void (SelectMgr_TriangularFrustum::*)() >(&SelectMgr_TriangularFrustum::Build),
             R"#(Creates new triangular frustum with bases of triangles with vertices theP1, theP2 and theP3 projections onto near and far view frustum planes (only for triangular frustums) NOTE: it should be called after Init() method)#" 
          )
        .def("IsScalable",
             (Standard_Boolean (SelectMgr_TriangularFrustum::*)() const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustum::*)() const>(&SelectMgr_TriangularFrustum::IsScalable),
             R"#(Returns FALSE (not applicable to this volume).)#" 
          )
        .def("ScaleAndTransform",
             (handle<SelectMgr_BaseIntersector> (SelectMgr_TriangularFrustum::*)(  const Standard_Integer ,   const gp_GTrsf & ,   const handle<SelectMgr_FrustumBuilder> &  ) const) static_cast<handle<SelectMgr_BaseIntersector> (SelectMgr_TriangularFrustum::*)(  const Standard_Integer ,   const gp_GTrsf & ,   const handle<SelectMgr_FrustumBuilder> &  ) const>(&SelectMgr_TriangularFrustum::ScaleAndTransform),
             R"#(Returns a copy of the frustum transformed according to the matrix given)#"  , py::arg("theScale"),  py::arg("theTrsf"),  py::arg("theBuilder")
          )
        .def("CopyWithBuilder",
             (handle<SelectMgr_BaseIntersector> (SelectMgr_TriangularFrustum::*)(  const handle<SelectMgr_FrustumBuilder> &  ) const) static_cast<handle<SelectMgr_BaseIntersector> (SelectMgr_TriangularFrustum::*)(  const handle<SelectMgr_FrustumBuilder> &  ) const>(&SelectMgr_TriangularFrustum::CopyWithBuilder),
             R"#(Returns a copy of the frustum using the given frustum builder configuration. Returned frustum should be re-constructed before being used.)#"  , py::arg("theBuilder")
          )
        .def("OverlapsBox",
             (Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_TriangularFrustum::OverlapsBox),
             R"#(SAT intersection test between defined volume and given axis-aligned box)#"  , py::arg("theMinPnt"),  py::arg("theMaxPnt"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsBox",
             (Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,  Standard_Boolean *  ) const>(&SelectMgr_TriangularFrustum::OverlapsBox),
             R"#(Returns true if selecting volume is overlapped by axis-aligned bounding box with minimum corner at point theMinPt and maximum at point theMaxPt)#"  , py::arg("theMinPt"),  py::arg("theMaxPt"),  py::arg("theInside")
          )
        .def("OverlapsPoint",
             (Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_TriangularFrustum::OverlapsPoint),
             R"#(Intersection test between defined volume and given point)#"  , py::arg("thePnt"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsPoint",
             (Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const gp_Pnt &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const gp_Pnt &  ) const>(&SelectMgr_TriangularFrustum::OverlapsPoint),
             R"#(Always returns FALSE (not applicable to this selector).)#"  , py::arg("arg0")
          )
        .def("OverlapsPolygon",
             (Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const TColgp_Array1OfPnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const TColgp_Array1OfPnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_TriangularFrustum::OverlapsPolygon),
             R"#(SAT intersection test between defined volume and given ordered set of points, representing line segments. The test may be considered of interior part or boundary line defined by segments depending on given sensitivity type)#"  , py::arg("theArrayOfPnts"),  py::arg("theSensType"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsSegment",
             (Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_TriangularFrustum::OverlapsSegment),
             R"#(Checks if line segment overlaps selecting frustum)#"  , py::arg("thePnt1"),  py::arg("thePnt2"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsTriangle",
             (Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_TriangularFrustum::OverlapsTriangle),
             R"#(SAT intersection test between defined volume and given triangle. The test may be considered of interior part or boundary line defined by triangle vertices depending on given sensitivity type)#"  , py::arg("thePnt1"),  py::arg("thePnt2"),  py::arg("thePnt3"),  py::arg("theSensType"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsSphere",
             (Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const gp_Pnt & ,   const Standard_Real ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const gp_Pnt & ,   const Standard_Real ,  Standard_Boolean *  ) const>(&SelectMgr_TriangularFrustum::OverlapsSphere),
             R"#(Returns true if selecting volume is overlapped by sphere with center theCenter and radius theRadius)#"  , py::arg("theCenter"),  py::arg("theRadius"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("OverlapsSphere",
             (Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const gp_Pnt & ,   const Standard_Real ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const gp_Pnt & ,   const Standard_Real ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_TriangularFrustum::OverlapsSphere),
             R"#(Returns true if selecting volume is overlapped by sphere with center theCenter and radius theRadius)#"  , py::arg("theCenter"),  py::arg("theRadius"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsCylinder",
             (Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_TriangularFrustum::OverlapsCylinder),
             R"#(Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses theBottomRad and theTopRad, height theHeight and transformation to apply theTrsf.)#"  , py::arg("theBottomRad"),  py::arg("theTopRad"),  py::arg("theHeight"),  py::arg("theTrsf"),  py::arg("theIsHollow"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsCylinder",
             (Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const>(&SelectMgr_TriangularFrustum::OverlapsCylinder),
             R"#(Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses theBottomRad and theTopRad, height theHeight and transformation to apply theTrsf.)#"  , py::arg("theBottomRad"),  py::arg("theTopRad"),  py::arg("theHeight"),  py::arg("theTrsf"),  py::arg("theIsHollow"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("OverlapsCircle",
             (Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_TriangularFrustum::OverlapsCircle),
             R"#(Returns true if selecting volume is overlapped by circle with radius theRadius, boolean theIsFilled and transformation to apply theTrsf. The position and orientation of the circle are specified via theTrsf transformation for gp::XOY() with center in gp::Origin().)#"  , py::arg("theRadius"),  py::arg("theTrsf"),  py::arg("theIsFilled"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsCircle",
             (Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustum::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const>(&SelectMgr_TriangularFrustum::OverlapsCircle),
             R"#(Returns true if selecting volume is overlapped by circle with radius theRadius, boolean theIsFilled and transformation to apply theTrsf. The position and orientation of the circle are specified via theTrsf transformation for gp::XOY() with center in gp::Origin().)#"  , py::arg("theRadius"),  py::arg("theTrsf"),  py::arg("theIsFilled"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("Clear",
             (void (SelectMgr_TriangularFrustum::*)() ) static_cast<void (SelectMgr_TriangularFrustum::*)() >(&SelectMgr_TriangularFrustum::Clear),
             R"#(Nullifies the handle to corresponding builder instance to prevent memory leaks)#" 
          )
        .def("GetPlanes",
             (void (SelectMgr_TriangularFrustum::*)( NCollection_Vector<SelectMgr_Vec4> &  ) const) static_cast<void (SelectMgr_TriangularFrustum::*)( NCollection_Vector<SelectMgr_Vec4> &  ) const>(&SelectMgr_TriangularFrustum::GetPlanes),
             R"#(Stores plane equation coefficients (in the following form: Ax + By + Cz + D = 0) to the given vector)#"  , py::arg("thePlaneEquations")
          )
        .def("DumpJson",
             (void (SelectMgr_TriangularFrustum::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (SelectMgr_TriangularFrustum::*)( Standard_OStream & ,  Standard_Integer  ) const>(&SelectMgr_TriangularFrustum::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_TriangularFrustum::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_TriangularFrustum::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_TriangularFrustum::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_TriangularFrustum::*)() const>(&SelectMgr_TriangularFrustum::DynamicType),
             R"#()#"
             
         )
;

    // Class SelectMgr_ViewClipRange from ./opencascade/SelectMgr_ViewClipRange.hxx
    klass = m.attr("SelectMgr_ViewClipRange");


    // nested enums

    static_cast<py::class_<SelectMgr_ViewClipRange , shared_ptr<SelectMgr_ViewClipRange>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("IsClipped",
             (Standard_Boolean (SelectMgr_ViewClipRange::*)(  const Standard_Real  ) const) static_cast<Standard_Boolean (SelectMgr_ViewClipRange::*)(  const Standard_Real  ) const>(&SelectMgr_ViewClipRange::IsClipped),
             R"#(Check if the given depth is not within clipping range(s), e.g. TRUE means depth is clipped.)#"  , py::arg("theDepth")
          )
        .def("GetNearestDepth",
             (Standard_Boolean (SelectMgr_ViewClipRange::*)(  const Bnd_Range & ,  Standard_Real &  ) const) static_cast<Standard_Boolean (SelectMgr_ViewClipRange::*)(  const Bnd_Range & ,  Standard_Real &  ) const>(&SelectMgr_ViewClipRange::GetNearestDepth),
             R"#(Calculates the min not clipped value from the range. Returns FALSE if the whole range is clipped.)#"  , py::arg("theRange"),  py::arg("theDepth")
          )
        .def("SetVoid",
             (void (SelectMgr_ViewClipRange::*)() ) static_cast<void (SelectMgr_ViewClipRange::*)() >(&SelectMgr_ViewClipRange::SetVoid),
             R"#(Clears clipping range.)#" 
          )
        .def("AddClippingPlanes",
             (void (SelectMgr_ViewClipRange::*)(  const Graphic3d_SequenceOfHClipPlane & ,   const gp_Ax1 &  ) ) static_cast<void (SelectMgr_ViewClipRange::*)(  const Graphic3d_SequenceOfHClipPlane & ,   const gp_Ax1 &  ) >(&SelectMgr_ViewClipRange::AddClippingPlanes),
             R"#(Add clipping planes. Planes and picking ray should be defined in the same coordinate system.)#"  , py::arg("thePlanes"),  py::arg("thePickRay")
          )
        .def("AddClipSubRange",
             (void (SelectMgr_ViewClipRange::*)(  const Bnd_Range &  ) ) static_cast<void (SelectMgr_ViewClipRange::*)(  const Bnd_Range &  ) >(&SelectMgr_ViewClipRange::AddClipSubRange),
             R"#(Adds a clipping sub-range (for clipping chains).)#"  , py::arg("theRange")
          )
        .def("DumpJson",
             (void (SelectMgr_ViewClipRange::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (SelectMgr_ViewClipRange::*)( Standard_OStream & ,  Standard_Integer  ) const>(&SelectMgr_ViewClipRange::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ChangeUnclipRange",
             (Bnd_Range & (SelectMgr_ViewClipRange::*)() ) static_cast<Bnd_Range & (SelectMgr_ViewClipRange::*)() >(&SelectMgr_ViewClipRange::ChangeUnclipRange),
             R"#(Returns the main unclipped range; [-inf, inf] by default.)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class SelectMgr_ViewerSelector from ./opencascade/SelectMgr_ViewerSelector.hxx
    klass = m.attr("SelectMgr_ViewerSelector");


    // nested enums

    static_cast<py::class_<SelectMgr_ViewerSelector ,opencascade::handle<SelectMgr_ViewerSelector>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("CustomPixelTolerance",
             (Standard_Integer (SelectMgr_ViewerSelector::*)() const) static_cast<Standard_Integer (SelectMgr_ViewerSelector::*)() const>(&SelectMgr_ViewerSelector::CustomPixelTolerance),
             R"#(Returns custom pixel tolerance value.)#" 
          )
        .def("SetPixelTolerance",
             (void (SelectMgr_ViewerSelector::*)(  const Standard_Integer  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const Standard_Integer  ) >(&SelectMgr_ViewerSelector::SetPixelTolerance),
             R"#(Sets the pixel tolerance <theTolerance>.)#"  , py::arg("theTolerance")
          )
        .def("Sensitivity",
             (Standard_Real (SelectMgr_ViewerSelector::*)() const) static_cast<Standard_Real (SelectMgr_ViewerSelector::*)() const>(&SelectMgr_ViewerSelector::Sensitivity),
             R"#(Returns the largest sensitivity of picking)#" 
          )
        .def("PixelTolerance",
             (Standard_Integer (SelectMgr_ViewerSelector::*)() const) static_cast<Standard_Integer (SelectMgr_ViewerSelector::*)() const>(&SelectMgr_ViewerSelector::PixelTolerance),
             R"#(Returns the largest pixel tolerance.)#" 
          )
        .def("SortResult",
             (void (SelectMgr_ViewerSelector::*)() const) static_cast<void (SelectMgr_ViewerSelector::*)() const>(&SelectMgr_ViewerSelector::SortResult),
             R"#(Sorts the detected entities by priority and distance.)#" 
          )
        .def("OnePicked",
             (handle<SelectMgr_EntityOwner> (SelectMgr_ViewerSelector::*)() const) static_cast<handle<SelectMgr_EntityOwner> (SelectMgr_ViewerSelector::*)() const>(&SelectMgr_ViewerSelector::OnePicked),
             R"#(Returns the picked element with the highest priority, and which is the closest to the last successful mouse position.)#" 
          )
        .def("ToPickClosest",
             (bool (SelectMgr_ViewerSelector::*)() const) static_cast<bool (SelectMgr_ViewerSelector::*)() const>(&SelectMgr_ViewerSelector::ToPickClosest),
             R"#(Return the flag determining precedence of picked depth (distance from eye to entity) over entity priority in sorted results; TRUE by default. When flag is TRUE, priority will be considered only if entities have the same depth within the tolerance. When flag is FALSE, entities with higher priority will be in front regardless of their depth (like x-ray).)#" 
          )
        .def("SetPickClosest",
             (void (SelectMgr_ViewerSelector::*)( bool  ) ) static_cast<void (SelectMgr_ViewerSelector::*)( bool  ) >(&SelectMgr_ViewerSelector::SetPickClosest),
             R"#(Set flag determining precedence of picked depth over entity priority in sorted results.)#"  , py::arg("theToPreferClosest")
          )
        .def("DepthToleranceType",
             (SelectMgr_TypeOfDepthTolerance (SelectMgr_ViewerSelector::*)() const) static_cast<SelectMgr_TypeOfDepthTolerance (SelectMgr_ViewerSelector::*)() const>(&SelectMgr_ViewerSelector::DepthToleranceType),
             R"#(Return the type of tolerance for considering two entities having a similar depth (distance from eye to entity); SelectMgr_TypeOfDepthTolerance_SensitivityFactor by default.)#" 
          )
        .def("DepthTolerance",
             (Standard_Real (SelectMgr_ViewerSelector::*)() const) static_cast<Standard_Real (SelectMgr_ViewerSelector::*)() const>(&SelectMgr_ViewerSelector::DepthTolerance),
             R"#(Return the tolerance for considering two entities having a similar depth (distance from eye to entity).)#" 
          )
        .def("SetDepthTolerance",
             (void (SelectMgr_ViewerSelector::*)( SelectMgr_TypeOfDepthTolerance ,  Standard_Real  ) ) static_cast<void (SelectMgr_ViewerSelector::*)( SelectMgr_TypeOfDepthTolerance ,  Standard_Real  ) >(&SelectMgr_ViewerSelector::SetDepthTolerance),
             R"#(Set the tolerance for considering two entities having a similar depth (distance from eye to entity).)#"  , py::arg("theType"),  py::arg("theTolerance")
          )
        .def("NbPicked",
             (Standard_Integer (SelectMgr_ViewerSelector::*)() const) static_cast<Standard_Integer (SelectMgr_ViewerSelector::*)() const>(&SelectMgr_ViewerSelector::NbPicked),
             R"#(Returns the number of detected owners.)#" 
          )
        .def("ClearPicked",
             (void (SelectMgr_ViewerSelector::*)() ) static_cast<void (SelectMgr_ViewerSelector::*)() >(&SelectMgr_ViewerSelector::ClearPicked),
             R"#(Clears picking results.)#" 
          )
        .def("Clear",
             (void (SelectMgr_ViewerSelector::*)() ) static_cast<void (SelectMgr_ViewerSelector::*)() >(&SelectMgr_ViewerSelector::Clear),
             R"#(Empties all the tables, removes all selections...)#" 
          )
        .def("Picked",
             (handle<SelectMgr_EntityOwner> (SelectMgr_ViewerSelector::*)(  const Standard_Integer  ) const) static_cast<handle<SelectMgr_EntityOwner> (SelectMgr_ViewerSelector::*)(  const Standard_Integer  ) const>(&SelectMgr_ViewerSelector::Picked),
             R"#(Returns the entity Owner for the object picked at specified position.)#"  , py::arg("theRank")
          )
        .def("PickedData",
             ( const SelectMgr_SortCriterion & (SelectMgr_ViewerSelector::*)(  const Standard_Integer  ) const) static_cast< const SelectMgr_SortCriterion & (SelectMgr_ViewerSelector::*)(  const Standard_Integer  ) const>(&SelectMgr_ViewerSelector::PickedData),
             R"#(Returns the Entity for the object picked at specified position.)#"  , py::arg("theRank")
          )
        .def("PickedEntity",
             ( const handle<Select3D_SensitiveEntity> & (SelectMgr_ViewerSelector::*)(  const Standard_Integer  ) const) static_cast< const handle<Select3D_SensitiveEntity> & (SelectMgr_ViewerSelector::*)(  const Standard_Integer  ) const>(&SelectMgr_ViewerSelector::PickedEntity),
             R"#(Returns the Entity for the object picked at specified position.)#"  , py::arg("theRank")
          )
        .def("PickedPoint",
             (gp_Pnt (SelectMgr_ViewerSelector::*)(  const Standard_Integer  ) const) static_cast<gp_Pnt (SelectMgr_ViewerSelector::*)(  const Standard_Integer  ) const>(&SelectMgr_ViewerSelector::PickedPoint),
             R"#(Returns the 3D point (intersection of picking axis with the object nearest to eye) for the object picked at specified position.)#"  , py::arg("theRank")
          )
        .def("RemovePicked",
             (Standard_Boolean (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> &  ) ) static_cast<Standard_Boolean (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> &  ) >(&SelectMgr_ViewerSelector::RemovePicked),
             R"#(Remove picked entities associated with specified object.)#"  , py::arg("theObject")
          )
        .def("Contains",
             (Standard_Boolean (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> &  ) const) static_cast<Standard_Boolean (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> &  ) const>(&SelectMgr_ViewerSelector::Contains),
             R"#()#"  , py::arg("theObject")
          )
        .def("EntitySetBuilder",
             ( const handle<Select3D_BVHBuilder3d> (SelectMgr_ViewerSelector::*)() ) static_cast< const handle<Select3D_BVHBuilder3d> (SelectMgr_ViewerSelector::*)() >(&SelectMgr_ViewerSelector::EntitySetBuilder),
             R"#(Returns the default builder used to construct BVH of entity set.)#" 
          )
        .def("SetEntitySetBuilder",
             (void (SelectMgr_ViewerSelector::*)(  const handle<Select3D_BVHBuilder3d> &  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const handle<Select3D_BVHBuilder3d> &  ) >(&SelectMgr_ViewerSelector::SetEntitySetBuilder),
             R"#(Sets the default builder used to construct BVH of entity set. The new builder will be also assigned for already defined objects, but computed BVH trees will not be invalidated.)#"  , py::arg("theBuilder")
          )
        .def("Modes",
             (Standard_Boolean (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> & ,  TColStd_ListOfInteger & ,   const SelectMgr_StateOfSelection  ) const) static_cast<Standard_Boolean (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> & ,  TColStd_ListOfInteger & ,   const SelectMgr_StateOfSelection  ) const>(&SelectMgr_ViewerSelector::Modes),
             R"#(Returns the list of selection modes ModeList found in this selector for the selectable object aSelectableObject. Returns true if aSelectableObject is referenced inside this selector; returns false if the object is not present in this selector.)#"  , py::arg("theSelectableObject"),  py::arg("theModeList"),  py::arg("theWantedState")=static_cast< const SelectMgr_StateOfSelection>(SelectMgr_SOS_Any)
          )
        .def("IsActive",
             (Standard_Boolean (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer  ) const) static_cast<Standard_Boolean (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer  ) const>(&SelectMgr_ViewerSelector::IsActive),
             R"#(Returns true if the selectable object aSelectableObject having the selection mode aMode is active in this selector.)#"  , py::arg("theSelectableObject"),  py::arg("theMode")
          )
        .def("IsInside",
             (Standard_Boolean (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer  ) const) static_cast<Standard_Boolean (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Integer  ) const>(&SelectMgr_ViewerSelector::IsInside),
             R"#(Returns true if the selectable object aSelectableObject having the selection mode aMode is in this selector.)#"  , py::arg("theSelectableObject"),  py::arg("theMode")
          )
        .def("Status",
             (SelectMgr_StateOfSelection (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_Selection> &  ) const) static_cast<SelectMgr_StateOfSelection (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_Selection> &  ) const>(&SelectMgr_ViewerSelector::Status),
             R"#(Returns the selection status Status of the selection aSelection.)#"  , py::arg("theSelection")
          )
        .def("Status",
             (TCollection_AsciiString (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> &  ) const) static_cast<TCollection_AsciiString (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> &  ) const>(&SelectMgr_ViewerSelector::Status),
             R"#()#"  , py::arg("theSelectableObject")
          )
        .def("ActiveOwners",
             (void (SelectMgr_ViewerSelector::*)( NCollection_List<handle<SelectMgr_EntityOwner>> &  ) const) static_cast<void (SelectMgr_ViewerSelector::*)( NCollection_List<handle<SelectMgr_EntityOwner>> &  ) const>(&SelectMgr_ViewerSelector::ActiveOwners),
             R"#(Returns the list of active entity owners)#"  , py::arg("theOwners")
          )
        .def("AddSelectableObject",
             (void (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> &  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> &  ) >(&SelectMgr_ViewerSelector::AddSelectableObject),
             R"#(Adds new object to the map of selectable objects)#"  , py::arg("theObject")
          )
        .def("AddSelectionToObject",
             (void (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> & ,   const handle<SelectMgr_Selection> &  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> & ,   const handle<SelectMgr_Selection> &  ) >(&SelectMgr_ViewerSelector::AddSelectionToObject),
             R"#(Adds new selection to the object and builds its BVH tree)#"  , py::arg("theObject"),  py::arg("theSelection")
          )
        .def("MoveSelectableObject",
             (void (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> &  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> &  ) >(&SelectMgr_ViewerSelector::MoveSelectableObject),
             R"#(Moves existing object from set of not transform persistence objects to set of transform persistence objects (or vice versa).)#"  , py::arg("theObject")
          )
        .def("RemoveSelectableObject",
             (void (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> &  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> &  ) >(&SelectMgr_ViewerSelector::RemoveSelectableObject),
             R"#(Removes selectable object from map of selectable ones)#"  , py::arg("theObject")
          )
        .def("RemoveSelectionOfObject",
             (void (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> & ,   const handle<SelectMgr_Selection> &  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> & ,   const handle<SelectMgr_Selection> &  ) >(&SelectMgr_ViewerSelector::RemoveSelectionOfObject),
             R"#(Removes selection of the object and marks its BVH tree for rebuild)#"  , py::arg("theObject"),  py::arg("theSelection")
          )
        .def("RebuildObjectsTree",
             (void (SelectMgr_ViewerSelector::*)(  const Standard_Boolean  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const Standard_Boolean  ) >(&SelectMgr_ViewerSelector::RebuildObjectsTree),
             R"#(Marks BVH of selectable objects for rebuild. Parameter theIsForce set as true guarantees that 1st level BVH for the viewer selector will be rebuilt during this call)#"  , py::arg("theIsForce")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def("RebuildSensitivesTree",
             (void (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Boolean  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_SelectableObject> & ,   const Standard_Boolean  ) >(&SelectMgr_ViewerSelector::RebuildSensitivesTree),
             R"#(Marks BVH of sensitive entities of particular selectable object for rebuild. Parameter theIsForce set as true guarantees that 2nd level BVH for the object given will be rebuilt during this call)#"  , py::arg("theObject"),  py::arg("theIsForce")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def("ResetSelectionActivationStatus",
             (void (SelectMgr_ViewerSelector::*)() ) static_cast<void (SelectMgr_ViewerSelector::*)() >(&SelectMgr_ViewerSelector::ResetSelectionActivationStatus),
             R"#(Marks all added sensitive entities of all objects as non-selectable)#" 
          )
        .def("AllowOverlapDetection",
             (void (SelectMgr_ViewerSelector::*)(  const Standard_Boolean  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const Standard_Boolean  ) >(&SelectMgr_ViewerSelector::AllowOverlapDetection),
             R"#(Is used for rectangular selection only If theIsToAllow is false, only fully included sensitives will be detected, otherwise the algorithm will mark both included and overlapped entities as matched)#"  , py::arg("theIsToAllow")
          )
        .def("Pick",
             (void (SelectMgr_ViewerSelector::*)(  const Standard_Integer ,   const Standard_Integer ,   const handle<V3d_View> &  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const Standard_Integer ,   const Standard_Integer ,   const handle<V3d_View> &  ) >(&SelectMgr_ViewerSelector::Pick),
             R"#(Picks the sensitive entity at the pixel coordinates of the mouse <theXPix> and <theYPix>. The selector looks for touched areas and owners.)#"  , py::arg("theXPix"),  py::arg("theYPix"),  py::arg("theView")
          )
        .def("Pick",
             (void (SelectMgr_ViewerSelector::*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const handle<V3d_View> &  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Integer ,   const handle<V3d_View> &  ) >(&SelectMgr_ViewerSelector::Pick),
             R"#(Picks the sensitive entity according to the minimum and maximum pixel values <theXPMin>, <theYPMin>, <theXPMax> and <theYPMax> defining a 2D area for selection in the 3D view aView.)#"  , py::arg("theXPMin"),  py::arg("theYPMin"),  py::arg("theXPMax"),  py::arg("theYPMax"),  py::arg("theView")
          )
        .def("Pick",
             (void (SelectMgr_ViewerSelector::*)(  const TColgp_Array1OfPnt2d & ,   const handle<V3d_View> &  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const TColgp_Array1OfPnt2d & ,   const handle<V3d_View> &  ) >(&SelectMgr_ViewerSelector::Pick),
             R"#(pick action - input pixel values for polyline selection for selection.)#"  , py::arg("thePolyline"),  py::arg("theView")
          )
        .def("Pick",
             (void (SelectMgr_ViewerSelector::*)(  const gp_Ax1 & ,   const handle<V3d_View> &  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const gp_Ax1 & ,   const handle<V3d_View> &  ) >(&SelectMgr_ViewerSelector::Pick),
             R"#(Picks the sensitive entity according to the input axis. This is geometric intersection 3D objects by axis (camera parameters are ignored and objects with transform persistence are skipped).)#"  , py::arg("theAxis"),  py::arg("theView")
          )
        .def("ToPixMap",
             (Standard_Boolean (SelectMgr_ViewerSelector::*)( Image_PixMap & ,   const handle<V3d_View> & ,   const StdSelect_TypeOfSelectionImage ,   const Standard_Integer  ) ) static_cast<Standard_Boolean (SelectMgr_ViewerSelector::*)( Image_PixMap & ,   const handle<V3d_View> & ,   const StdSelect_TypeOfSelectionImage ,   const Standard_Integer  ) >(&SelectMgr_ViewerSelector::ToPixMap),
             R"#(Dump of detection results into image. This method performs axis picking for each pixel in the image and generates a color depending on picking results and selection image type.)#"  , py::arg("theImage"),  py::arg("theView"),  py::arg("theType"),  py::arg("thePickedIndex")=static_cast< const Standard_Integer>(1)
          )
        .def("DisplaySensitive",
             (void (SelectMgr_ViewerSelector::*)(  const handle<V3d_View> &  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const handle<V3d_View> &  ) >(&SelectMgr_ViewerSelector::DisplaySensitive),
             R"#(Displays sensitives in view <theView>.)#"  , py::arg("theView")
          )
        .def("ClearSensitive",
             (void (SelectMgr_ViewerSelector::*)(  const handle<V3d_View> &  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const handle<V3d_View> &  ) >(&SelectMgr_ViewerSelector::ClearSensitive),
             R"#()#"  , py::arg("theView")
          )
        .def("DisplaySensitive",
             (void (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_Selection> & ,   const gp_Trsf & ,   const handle<V3d_View> & ,   const Standard_Boolean  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const handle<SelectMgr_Selection> & ,   const gp_Trsf & ,   const handle<V3d_View> & ,   const Standard_Boolean  ) >(&SelectMgr_ViewerSelector::DisplaySensitive),
             R"#()#"  , py::arg("theSel"),  py::arg("theTrsf"),  py::arg("theView"),  py::arg("theToClearOthers")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def("DumpJson",
             (void (SelectMgr_ViewerSelector::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (SelectMgr_ViewerSelector::*)( Standard_OStream & ,  Standard_Integer  ) const>(&SelectMgr_ViewerSelector::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("SetToPrebuildBVH",
             (void (SelectMgr_ViewerSelector::*)( Standard_Boolean ,  Standard_Integer  ) ) static_cast<void (SelectMgr_ViewerSelector::*)( Standard_Boolean ,  Standard_Integer  ) >(&SelectMgr_ViewerSelector::SetToPrebuildBVH),
             R"#(Enables/disables building BVH for sensitives in separate threads)#"  , py::arg("theToPrebuild"),  py::arg("theThreadsNum")=static_cast<Standard_Integer>(- 1)
          )
        .def("QueueBVHBuild",
             (void (SelectMgr_ViewerSelector::*)(  const handle<Select3D_SensitiveEntity> &  ) ) static_cast<void (SelectMgr_ViewerSelector::*)(  const handle<Select3D_SensitiveEntity> &  ) >(&SelectMgr_ViewerSelector::QueueBVHBuild),
             R"#(Queues a sensitive entity to build its BVH)#"  , py::arg("theEntity")
          )
        .def("WaitForBVHBuild",
             (void (SelectMgr_ViewerSelector::*)() ) static_cast<void (SelectMgr_ViewerSelector::*)() >(&SelectMgr_ViewerSelector::WaitForBVHBuild),
             R"#(Waits BVH threads finished building)#" 
          )
        .def("ToPrebuildBVH",
             (Standard_Boolean (SelectMgr_ViewerSelector::*)() const) static_cast<Standard_Boolean (SelectMgr_ViewerSelector::*)() const>(&SelectMgr_ViewerSelector::ToPrebuildBVH),
             R"#(Returns TRUE if building BVH for sensitives in separate threads is enabled)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_ViewerSelector::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_ViewerSelector::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_ViewerSelector::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_ViewerSelector::*)() const>(&SelectMgr_ViewerSelector::DynamicType),
             R"#()#"
             
         )
       .def("GetManager",
             (SelectMgr_SelectingVolumeManager & (SelectMgr_ViewerSelector::*)() ) static_cast<SelectMgr_SelectingVolumeManager & (SelectMgr_ViewerSelector::*)() >(&SelectMgr_ViewerSelector::GetManager),
             R"#(Returns instance of selecting volume manager of the viewer selector)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("SelectableObjects",
             ( const SelectMgr_SelectableObjectSet & (SelectMgr_ViewerSelector::*)() const) static_cast< const SelectMgr_SelectableObjectSet & (SelectMgr_ViewerSelector::*)() const>(&SelectMgr_ViewerSelector::SelectableObjects),
             R"#(Return map of selectable objects.)#"
             
         )
;

    // Class SelectMgr_AxisIntersector from ./opencascade/SelectMgr_AxisIntersector.hxx
    klass = m.attr("SelectMgr_AxisIntersector");


    // nested enums

    static_cast<py::class_<SelectMgr_AxisIntersector ,opencascade::handle<SelectMgr_AxisIntersector>  , SelectMgr_BaseIntersector >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Init",
             (void (SelectMgr_AxisIntersector::*)(  const gp_Ax1 &  ) ) static_cast<void (SelectMgr_AxisIntersector::*)(  const gp_Ax1 &  ) >(&SelectMgr_AxisIntersector::Init),
             R"#(Initializes selecting axis according to the input one)#"  , py::arg("theAxis")
          )
        .def("Build",
             (void (SelectMgr_AxisIntersector::*)() ) static_cast<void (SelectMgr_AxisIntersector::*)() >(&SelectMgr_AxisIntersector::Build),
             R"#(Builds axis according to internal parameters. NOTE: it should be called after Init() method)#" 
          )
        .def("SetCamera",
             (void (SelectMgr_AxisIntersector::*)(  const handle<Graphic3d_Camera> &  ) ) static_cast<void (SelectMgr_AxisIntersector::*)(  const handle<Graphic3d_Camera> &  ) >(&SelectMgr_AxisIntersector::SetCamera),
             R"#(Saves camera definition. Do nothing for axis intersector (not applicable to this volume).)#"  , py::arg("theCamera")
          )
        .def("IsScalable",
             (Standard_Boolean (SelectMgr_AxisIntersector::*)() const) static_cast<Standard_Boolean (SelectMgr_AxisIntersector::*)() const>(&SelectMgr_AxisIntersector::IsScalable),
             R"#(Returns FALSE (not applicable to this volume).)#" 
          )
        .def("ScaleAndTransform",
             (handle<SelectMgr_BaseIntersector> (SelectMgr_AxisIntersector::*)(  const Standard_Integer ,   const gp_GTrsf & ,   const handle<SelectMgr_FrustumBuilder> &  ) const) static_cast<handle<SelectMgr_BaseIntersector> (SelectMgr_AxisIntersector::*)(  const Standard_Integer ,   const gp_GTrsf & ,   const handle<SelectMgr_FrustumBuilder> &  ) const>(&SelectMgr_AxisIntersector::ScaleAndTransform),
             R"#(IMPORTANT: Scaling doesn't make sense for this intersector. Returns a copy of the intersector transformed using the matrix given. Builder is an optional argument that represents corresponding settings for re-constructing transformed frustum from scratch. Can be null if reconstruction is not expected furthermore.)#"  , py::arg("theScaleFactor"),  py::arg("theTrsf"),  py::arg("theBuilder")
          )
        .def("CopyWithBuilder",
             (handle<SelectMgr_BaseIntersector> (SelectMgr_AxisIntersector::*)(  const handle<SelectMgr_FrustumBuilder> &  ) const) static_cast<handle<SelectMgr_BaseIntersector> (SelectMgr_AxisIntersector::*)(  const handle<SelectMgr_FrustumBuilder> &  ) const>(&SelectMgr_AxisIntersector::CopyWithBuilder),
             R"#(Returns a copy of the intersector transformed using the builder configuration given. Builder is an argument that represents corresponding settings for re-constructing transformed frustum from scratch. In this class, builder is not used and theBuilder parameter is ignored.)#"  , py::arg("theBuilder")
          )
        .def("OverlapsBox",
             (Standard_Boolean (SelectMgr_AxisIntersector::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_AxisIntersector::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_AxisIntersector::OverlapsBox),
             R"#(Intersection test between defined axis and given axis-aligned box)#"  , py::arg("theBoxMin"),  py::arg("theBoxMax"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsBox",
             (Standard_Boolean (SelectMgr_AxisIntersector::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_AxisIntersector::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,  Standard_Boolean *  ) const>(&SelectMgr_AxisIntersector::OverlapsBox),
             R"#(Returns true if selecting axis intersects axis-aligned bounding box with minimum corner at point theMinPt and maximum at point theMaxPt)#"  , py::arg("theBoxMin"),  py::arg("theBoxMax"),  py::arg("theInside")
          )
        .def("OverlapsPoint",
             (Standard_Boolean (SelectMgr_AxisIntersector::*)(  const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_AxisIntersector::*)(  const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_AxisIntersector::OverlapsPoint),
             R"#(Intersection test between defined axis and given point)#"  , py::arg("thePnt"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsPoint",
             (Standard_Boolean (SelectMgr_AxisIntersector::*)(  const gp_Pnt &  ) const) static_cast<Standard_Boolean (SelectMgr_AxisIntersector::*)(  const gp_Pnt &  ) const>(&SelectMgr_AxisIntersector::OverlapsPoint),
             R"#(Intersection test between defined axis and given point)#"  , py::arg("thePnt")
          )
        .def("OverlapsPolygon",
             (Standard_Boolean (SelectMgr_AxisIntersector::*)(  const TColgp_Array1OfPnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_AxisIntersector::*)(  const TColgp_Array1OfPnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_AxisIntersector::OverlapsPolygon),
             R"#(Intersection test between defined axis and given ordered set of points, representing line segments. The test may be considered of interior part or boundary line defined by segments depending on given sensitivity type)#"  , py::arg("theArrayOfPnts"),  py::arg("theSensType"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsSegment",
             (Standard_Boolean (SelectMgr_AxisIntersector::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_AxisIntersector::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_AxisIntersector::OverlapsSegment),
             R"#(Checks if selecting axis intersects line segment)#"  , py::arg("thePnt1"),  py::arg("thePnt2"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsTriangle",
             (Standard_Boolean (SelectMgr_AxisIntersector::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_AxisIntersector::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_AxisIntersector::OverlapsTriangle),
             R"#(Intersection test between defined axis and given triangle. The test may be considered of interior part or boundary line defined by triangle vertices depending on given sensitivity type)#"  , py::arg("thePnt1"),  py::arg("thePnt2"),  py::arg("thePnt3"),  py::arg("theSensType"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsSphere",
             (Standard_Boolean (SelectMgr_AxisIntersector::*)(  const gp_Pnt & ,   const Standard_Real ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_AxisIntersector::*)(  const gp_Pnt & ,   const Standard_Real ,  Standard_Boolean *  ) const>(&SelectMgr_AxisIntersector::OverlapsSphere),
             R"#(Intersection test between defined axis and given sphere with center theCenter and radius theRadius)#"  , py::arg("theCenter"),  py::arg("theRadius"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("OverlapsSphere",
             (Standard_Boolean (SelectMgr_AxisIntersector::*)(  const gp_Pnt & ,   const Standard_Real ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_AxisIntersector::*)(  const gp_Pnt & ,   const Standard_Real ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_AxisIntersector::OverlapsSphere),
             R"#(Intersection test between defined axis and given sphere with center theCenter and radius theRadius)#"  , py::arg("theCenter"),  py::arg("theRadius"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsCylinder",
             (Standard_Boolean (SelectMgr_AxisIntersector::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_AxisIntersector::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_AxisIntersector::OverlapsCylinder),
             R"#(Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses theBottomRad and theTopRad, height theHeight and transformation to apply theTrsf.)#"  , py::arg("theBottomRad"),  py::arg("theTopRad"),  py::arg("theHeight"),  py::arg("theTrsf"),  py::arg("theIsHollow"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsCylinder",
             (Standard_Boolean (SelectMgr_AxisIntersector::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_AxisIntersector::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const>(&SelectMgr_AxisIntersector::OverlapsCylinder),
             R"#(Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses theBottomRad and theTopRad, height theHeight and transformation to apply theTrsf.)#"  , py::arg("theBottomRad"),  py::arg("theTopRad"),  py::arg("theHeight"),  py::arg("theTrsf"),  py::arg("theIsHollow"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("OverlapsCircle",
             (Standard_Boolean (SelectMgr_AxisIntersector::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_AxisIntersector::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_AxisIntersector::OverlapsCircle),
             R"#(Returns true if selecting volume is overlapped by circle with radius theRadius, boolean theIsFilled and transformation to apply theTrsf. The position and orientation of the circle are specified via theTrsf transformation for gp::XOY() with center in gp::Origin().)#"  , py::arg("theRadius"),  py::arg("theTrsf"),  py::arg("theIsFilled"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsCircle",
             (Standard_Boolean (SelectMgr_AxisIntersector::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_AxisIntersector::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const>(&SelectMgr_AxisIntersector::OverlapsCircle),
             R"#(Returns true if selecting volume is overlapped by circle with radius theRadius, boolean theIsFilled and transformation to apply theTrsf. The position and orientation of the circle are specified via theTrsf transformation for gp::XOY() with center in gp::Origin().)#"  , py::arg("theRadius"),  py::arg("theTrsf"),  py::arg("theIsFilled"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("DistToGeometryCenter",
             (Standard_Real (SelectMgr_AxisIntersector::*)(  const gp_Pnt &  ) const) static_cast<Standard_Real (SelectMgr_AxisIntersector::*)(  const gp_Pnt &  ) const>(&SelectMgr_AxisIntersector::DistToGeometryCenter),
             R"#(Measures distance between start axis point and given point theCOG.)#"  , py::arg("theCOG")
          )
        .def("DetectedPoint",
             (gp_Pnt (SelectMgr_AxisIntersector::*)(  const Standard_Real  ) const) static_cast<gp_Pnt (SelectMgr_AxisIntersector::*)(  const Standard_Real  ) const>(&SelectMgr_AxisIntersector::DetectedPoint),
             R"#(Calculates the point on a axis ray that was detected during the run of selection algo by given depth)#"  , py::arg("theDepth")
          )
        .def("DumpJson",
             (void (SelectMgr_AxisIntersector::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (SelectMgr_AxisIntersector::*)( Standard_OStream & ,  Standard_Integer  ) const>(&SelectMgr_AxisIntersector::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetNearPnt",
             ( const gp_Pnt & (SelectMgr_AxisIntersector::*)() const) static_cast< const gp_Pnt & (SelectMgr_AxisIntersector::*)() const>(&SelectMgr_AxisIntersector::GetNearPnt),
             R"#(Returns near point along axis.)#"
             
         )
       .def("GetFarPnt",
             ( const gp_Pnt & (SelectMgr_AxisIntersector::*)() const) static_cast< const gp_Pnt & (SelectMgr_AxisIntersector::*)() const>(&SelectMgr_AxisIntersector::GetFarPnt),
             R"#(Returns far point along axis (infinite).)#"
             
         )
       .def("GetViewRayDirection",
             ( const gp_Dir & (SelectMgr_AxisIntersector::*)() const) static_cast< const gp_Dir & (SelectMgr_AxisIntersector::*)() const>(&SelectMgr_AxisIntersector::GetViewRayDirection),
             R"#(Returns axis direction.)#"
             
         )
;

    // Class SelectMgr_BaseFrustum from ./opencascade/SelectMgr_BaseFrustum.hxx
    klass = m.attr("SelectMgr_BaseFrustum");


    // nested enums

    static_cast<py::class_<SelectMgr_BaseFrustum ,opencascade::handle<SelectMgr_BaseFrustum> ,Py_SelectMgr_BaseFrustum , SelectMgr_BaseIntersector >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetBuilder",
             (void (SelectMgr_BaseFrustum::*)(  const handle<SelectMgr_FrustumBuilder> &  ) ) static_cast<void (SelectMgr_BaseFrustum::*)(  const handle<SelectMgr_FrustumBuilder> &  ) >(&SelectMgr_BaseFrustum::SetBuilder),
             R"#(Nullifies the builder created in the constructor and copies the pointer given)#"  , py::arg("theBuilder")
          )
        .def("SetCamera",
             (void (SelectMgr_BaseFrustum::*)(  const handle<Graphic3d_Camera> &  ) ) static_cast<void (SelectMgr_BaseFrustum::*)(  const handle<Graphic3d_Camera> &  ) >(&SelectMgr_BaseFrustum::SetCamera),
             R"#(Saves camera definition and passes it to builder)#"  , py::arg("theCamera")
          )
        .def("SetPixelTolerance",
             (void (SelectMgr_BaseFrustum::*)(  const Standard_Integer  ) ) static_cast<void (SelectMgr_BaseFrustum::*)(  const Standard_Integer  ) >(&SelectMgr_BaseFrustum::SetPixelTolerance),
             R"#()#"  , py::arg("theTol")
          )
        .def("SetWindowSize",
             (void (SelectMgr_BaseFrustum::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (SelectMgr_BaseFrustum::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&SelectMgr_BaseFrustum::SetWindowSize),
             R"#()#"  , py::arg("theWidth"),  py::arg("theHeight")
          )
        .def("SetViewport",
             (void (SelectMgr_BaseFrustum::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<void (SelectMgr_BaseFrustum::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const Standard_Real  ) >(&SelectMgr_BaseFrustum::SetViewport),
             R"#(Passes viewport parameters to builder)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theWidth"),  py::arg("theHeight")
          )
        .def("IsBoundaryIntersectSphere",
             (Standard_Boolean (SelectMgr_BaseFrustum::*)(  const gp_Pnt & ,   const Standard_Real ,   const gp_Dir & ,   const TColgp_Array1OfPnt & ,  Standard_Boolean &  ) const) static_cast<Standard_Boolean (SelectMgr_BaseFrustum::*)(  const gp_Pnt & ,   const Standard_Real ,   const gp_Dir & ,   const TColgp_Array1OfPnt & ,  Standard_Boolean &  ) const>(&SelectMgr_BaseFrustum::IsBoundaryIntersectSphere),
             R"#(Checks whether the boundary of the current volume selection intersects with a sphere or are there it's boundaries lying inside the sphere)#"  , py::arg("theCenter"),  py::arg("theRadius"),  py::arg("thePlaneNormal"),  py::arg("theBoundaries"),  py::arg("theBoundaryInside")
          )
        .def("DumpJson",
             (void (SelectMgr_BaseFrustum::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (SelectMgr_BaseFrustum::*)( Standard_OStream & ,  Standard_Integer  ) const>(&SelectMgr_BaseFrustum::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
        .def("WindowSize",
             []( SelectMgr_BaseFrustum &self   ){
                 Standard_Integer  theWidth;
                Standard_Integer  theHeight;

                 self.WindowSize(theWidth,theHeight);
                 
                 return std::make_tuple(theWidth,theHeight); },
             R"#()#" 
          )
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_BaseFrustum::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_BaseFrustum::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_BaseFrustum::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_BaseFrustum::*)() const>(&SelectMgr_BaseFrustum::DynamicType),
             R"#()#"
             
         )
;

    // Class SelectMgr_CompositionFilter from ./opencascade/SelectMgr_CompositionFilter.hxx
    klass = m.attr("SelectMgr_CompositionFilter");


    // nested enums

    static_cast<py::class_<SelectMgr_CompositionFilter ,opencascade::handle<SelectMgr_CompositionFilter> ,Py_SelectMgr_CompositionFilter , SelectMgr_Filter >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Add",
             (void (SelectMgr_CompositionFilter::*)(  const handle<SelectMgr_Filter> &  ) ) static_cast<void (SelectMgr_CompositionFilter::*)(  const handle<SelectMgr_Filter> &  ) >(&SelectMgr_CompositionFilter::Add),
             R"#(Adds the filter afilter to a filter object created by a filter class inheriting this framework.)#"  , py::arg("afilter")
          )
        .def("Remove",
             (void (SelectMgr_CompositionFilter::*)(  const handle<SelectMgr_Filter> &  ) ) static_cast<void (SelectMgr_CompositionFilter::*)(  const handle<SelectMgr_Filter> &  ) >(&SelectMgr_CompositionFilter::Remove),
             R"#(Removes the filter aFilter from this framework.)#"  , py::arg("aFilter")
          )
        .def("IsEmpty",
             (Standard_Boolean (SelectMgr_CompositionFilter::*)() const) static_cast<Standard_Boolean (SelectMgr_CompositionFilter::*)() const>(&SelectMgr_CompositionFilter::IsEmpty),
             R"#(Returns true if this framework is empty.)#" 
          )
        .def("IsIn",
             (Standard_Boolean (SelectMgr_CompositionFilter::*)(  const handle<SelectMgr_Filter> &  ) const) static_cast<Standard_Boolean (SelectMgr_CompositionFilter::*)(  const handle<SelectMgr_Filter> &  ) const>(&SelectMgr_CompositionFilter::IsIn),
             R"#(Returns true if the filter aFilter is in this framework.)#"  , py::arg("aFilter")
          )
        .def("Clear",
             (void (SelectMgr_CompositionFilter::*)() ) static_cast<void (SelectMgr_CompositionFilter::*)() >(&SelectMgr_CompositionFilter::Clear),
             R"#(Clears the filters used in this framework.)#" 
          )
        .def("ActsOn",
             (Standard_Boolean (SelectMgr_CompositionFilter::*)(  const TopAbs_ShapeEnum  ) const) static_cast<Standard_Boolean (SelectMgr_CompositionFilter::*)(  const TopAbs_ShapeEnum  ) const>(&SelectMgr_CompositionFilter::ActsOn),
             R"#()#"  , py::arg("aStandardMode")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_CompositionFilter::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_CompositionFilter::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("StoredFilters",
             ( const SelectMgr_ListOfFilter & (SelectMgr_CompositionFilter::*)() const) static_cast< const SelectMgr_ListOfFilter & (SelectMgr_CompositionFilter::*)() const>(&SelectMgr_CompositionFilter::StoredFilters),
             R"#(Returns the list of stored filters from this framework.)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_CompositionFilter::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_CompositionFilter::*)() const>(&SelectMgr_CompositionFilter::DynamicType),
             R"#()#"
             
         )
;

    // Class SelectMgr_AndFilter from ./opencascade/SelectMgr_AndFilter.hxx
    klass = m.attr("SelectMgr_AndFilter");


    // nested enums

    static_cast<py::class_<SelectMgr_AndFilter ,opencascade::handle<SelectMgr_AndFilter>  , SelectMgr_CompositionFilter >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("IsOk",
             (Standard_Boolean (SelectMgr_AndFilter::*)(  const handle<SelectMgr_EntityOwner> &  ) const) static_cast<Standard_Boolean (SelectMgr_AndFilter::*)(  const handle<SelectMgr_EntityOwner> &  ) const>(&SelectMgr_AndFilter::IsOk),
             R"#()#"  , py::arg("anobj")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_AndFilter::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_AndFilter::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_AndFilter::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_AndFilter::*)() const>(&SelectMgr_AndFilter::DynamicType),
             R"#()#"
             
         )
;

    // Class SelectMgr_AndOrFilter from ./opencascade/SelectMgr_AndOrFilter.hxx
    klass = m.attr("SelectMgr_AndOrFilter");


    // nested enums

    static_cast<py::class_<SelectMgr_AndOrFilter ,opencascade::handle<SelectMgr_AndOrFilter>  , SelectMgr_CompositionFilter >>(klass)
    // constructors
        .def(py::init<  const SelectMgr_FilterType >()  , py::arg("theFilterType") )
    // custom constructors
    // methods
        .def("IsOk",
             (Standard_Boolean (SelectMgr_AndOrFilter::*)(  const handle<SelectMgr_EntityOwner> &  ) const) static_cast<Standard_Boolean (SelectMgr_AndOrFilter::*)(  const handle<SelectMgr_EntityOwner> &  ) const>(&SelectMgr_AndOrFilter::IsOk),
             R"#(Indicates that the selected Interactive Object passes the filter.)#"  , py::arg("theObj")
          )
        .def("SetDisabledObjects",
             (void (SelectMgr_AndOrFilter::*)(  const handle<Graphic3d_NMapOfTransient> &  ) ) static_cast<void (SelectMgr_AndOrFilter::*)(  const handle<Graphic3d_NMapOfTransient> &  ) >(&SelectMgr_AndOrFilter::SetDisabledObjects),
             R"#(Disable selection of specified objects.)#"  , py::arg("theObjects")
          )
        .def("FilterType",
             (SelectMgr_FilterType (SelectMgr_AndOrFilter::*)() const) static_cast<SelectMgr_FilterType (SelectMgr_AndOrFilter::*)() const>(&SelectMgr_AndOrFilter::FilterType),
             R"#(Returns a selection filter type ( SelectMgr_FilterType).)#" 
          )
        .def("SetFilterType",
             (void (SelectMgr_AndOrFilter::*)(  const SelectMgr_FilterType  ) ) static_cast<void (SelectMgr_AndOrFilter::*)(  const SelectMgr_FilterType  ) >(&SelectMgr_AndOrFilter::SetFilterType),
             R"#(Sets a selection filter type. SelectMgr_FilterType_OR selection filter is used be default.)#"  , py::arg("theFilterType")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_AndOrFilter::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_AndOrFilter::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_AndOrFilter::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_AndOrFilter::*)() const>(&SelectMgr_AndOrFilter::DynamicType),
             R"#()#"
             
         )
;

    // Class SelectMgr_OrFilter from ./opencascade/SelectMgr_OrFilter.hxx
    klass = m.attr("SelectMgr_OrFilter");


    // nested enums

    static_cast<py::class_<SelectMgr_OrFilter ,opencascade::handle<SelectMgr_OrFilter>  , SelectMgr_CompositionFilter >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("IsOk",
             (Standard_Boolean (SelectMgr_OrFilter::*)(  const handle<SelectMgr_EntityOwner> &  ) const) static_cast<Standard_Boolean (SelectMgr_OrFilter::*)(  const handle<SelectMgr_EntityOwner> &  ) const>(&SelectMgr_OrFilter::IsOk),
             R"#()#"  , py::arg("anobj")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&SelectMgr_OrFilter::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&SelectMgr_OrFilter::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (SelectMgr_OrFilter::*)() const) static_cast< const handle<Standard_Type> & (SelectMgr_OrFilter::*)() const>(&SelectMgr_OrFilter::DynamicType),
             R"#()#"
             
         )
;

    // Class SelectMgr_TriangularFrustumSet from ./opencascade/SelectMgr_TriangularFrustumSet.hxx
    klass = m.attr("SelectMgr_TriangularFrustumSet");


    // nested enums

    static_cast<py::class_<SelectMgr_TriangularFrustumSet ,opencascade::handle<SelectMgr_TriangularFrustumSet>  , SelectMgr_BaseFrustum >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Init",
             (void (SelectMgr_TriangularFrustumSet::*)(  const TColgp_Array1OfPnt2d &  ) ) static_cast<void (SelectMgr_TriangularFrustumSet::*)(  const TColgp_Array1OfPnt2d &  ) >(&SelectMgr_TriangularFrustumSet::Init),
             R"#(Initializes set of triangular frustums by polyline)#"  , py::arg("thePoints")
          )
        .def("Build",
             (void (SelectMgr_TriangularFrustumSet::*)() ) static_cast<void (SelectMgr_TriangularFrustumSet::*)() >(&SelectMgr_TriangularFrustumSet::Build),
             R"#(Meshes polygon bounded by polyline. Than organizes a set of triangular frustums, where each triangle's projection onto near and far view frustum planes is considered as a frustum base NOTE: it should be called after Init() method)#" 
          )
        .def("IsScalable",
             (Standard_Boolean (SelectMgr_TriangularFrustumSet::*)() const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustumSet::*)() const>(&SelectMgr_TriangularFrustumSet::IsScalable),
             R"#(Returns FALSE (not applicable to this volume).)#" 
          )
        .def("ScaleAndTransform",
             (handle<SelectMgr_BaseIntersector> (SelectMgr_TriangularFrustumSet::*)(  const Standard_Integer ,   const gp_GTrsf & ,   const handle<SelectMgr_FrustumBuilder> &  ) const) static_cast<handle<SelectMgr_BaseIntersector> (SelectMgr_TriangularFrustumSet::*)(  const Standard_Integer ,   const gp_GTrsf & ,   const handle<SelectMgr_FrustumBuilder> &  ) const>(&SelectMgr_TriangularFrustumSet::ScaleAndTransform),
             R"#(Returns a copy of the frustum with all sub-volumes transformed according to the matrix given)#"  , py::arg("theScale"),  py::arg("theTrsf"),  py::arg("theBuilder")
          )
        .def("CopyWithBuilder",
             (handle<SelectMgr_BaseIntersector> (SelectMgr_TriangularFrustumSet::*)(  const handle<SelectMgr_FrustumBuilder> &  ) const) static_cast<handle<SelectMgr_BaseIntersector> (SelectMgr_TriangularFrustumSet::*)(  const handle<SelectMgr_FrustumBuilder> &  ) const>(&SelectMgr_TriangularFrustumSet::CopyWithBuilder),
             R"#(Returns a copy of the frustum using the given frustum builder configuration. Returned frustum should be re-constructed before being used.)#"  , py::arg("theBuilder")
          )
        .def("OverlapsBox",
             (Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_TriangularFrustumSet::OverlapsBox),
             R"#()#"  , py::arg("theMinPnt"),  py::arg("theMaxPnt"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsBox",
             (Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const SelectMgr_Vec3 & ,   const SelectMgr_Vec3 & ,  Standard_Boolean *  ) const>(&SelectMgr_TriangularFrustumSet::OverlapsBox),
             R"#()#"  , py::arg("theMinPnt"),  py::arg("theMaxPnt"),  py::arg("theInside")
          )
        .def("OverlapsPoint",
             (Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_TriangularFrustumSet::OverlapsPoint),
             R"#()#"  , py::arg("thePnt"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsPoint",
             (Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const gp_Pnt &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const gp_Pnt &  ) const>(&SelectMgr_TriangularFrustumSet::OverlapsPoint),
             R"#(Always returns FALSE (not applicable to this selector).)#"  , py::arg("arg0")
          )
        .def("OverlapsPolygon",
             (Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const TColgp_Array1OfPnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const TColgp_Array1OfPnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_TriangularFrustumSet::OverlapsPolygon),
             R"#()#"  , py::arg("theArrayOfPnts"),  py::arg("theSensType"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsSegment",
             (Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_TriangularFrustumSet::OverlapsSegment),
             R"#()#"  , py::arg("thePnt1"),  py::arg("thePnt2"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsTriangle",
             (Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,  Select3D_TypeOfSensitivity ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_TriangularFrustumSet::OverlapsTriangle),
             R"#()#"  , py::arg("thePnt1"),  py::arg("thePnt2"),  py::arg("thePnt3"),  py::arg("theSensType"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("DetectedPoint",
             (gp_Pnt (SelectMgr_TriangularFrustumSet::*)(  const Standard_Real  ) const) static_cast<gp_Pnt (SelectMgr_TriangularFrustumSet::*)(  const Standard_Real  ) const>(&SelectMgr_TriangularFrustumSet::DetectedPoint),
             R"#(Calculates the point on a view ray that was detected during the run of selection algo by given depth)#"  , py::arg("theDepth")
          )
        .def("OverlapsSphere",
             (Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const gp_Pnt & ,   const Standard_Real ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const gp_Pnt & ,   const Standard_Real ,  Standard_Boolean *  ) const>(&SelectMgr_TriangularFrustumSet::OverlapsSphere),
             R"#(Returns true if selecting volume is overlapped by sphere with center theCenter and radius theRadius)#"  , py::arg("theCenter"),  py::arg("theRadius"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("OverlapsSphere",
             (Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const gp_Pnt & ,   const Standard_Real ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const gp_Pnt & ,   const Standard_Real ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_TriangularFrustumSet::OverlapsSphere),
             R"#(Returns true if selecting volume is overlapped by sphere with center theCenter and radius theRadius)#"  , py::arg("theCenter"),  py::arg("theRadius"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsCylinder",
             (Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_TriangularFrustumSet::OverlapsCylinder),
             R"#(Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses theBottomRad and theTopRad, height theHeight and transformation to apply theTrsf.)#"  , py::arg("theBottomRad"),  py::arg("theTopRad"),  py::arg("theHeight"),  py::arg("theTrsf"),  py::arg("theIsHollow"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsCylinder",
             (Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const>(&SelectMgr_TriangularFrustumSet::OverlapsCylinder),
             R"#(Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses theBottomRad and theTopRad, height theHeight and transformation to apply theTrsf.)#"  , py::arg("theBottomRad"),  py::arg("theTopRad"),  py::arg("theHeight"),  py::arg("theTrsf"),  py::arg("theIsHollow"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("OverlapsCircle",
             (Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,   const SelectMgr_ViewClipRange & ,  SelectBasics_PickResult &  ) const>(&SelectMgr_TriangularFrustumSet::OverlapsCircle),
             R"#(Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses theBottomRad and theTopRad, height theHeight and transformation to apply theTrsf.)#"  , py::arg("theBottomRad"),  py::arg("theTrsf"),  py::arg("theIsFilled"),  py::arg("theClipRange"),  py::arg("thePickResult")
          )
        .def("OverlapsCircle",
             (Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectMgr_TriangularFrustumSet::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const>(&SelectMgr_TriangularFrustumSet::OverlapsCircle),
             R"#(Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses theBottomRad and theTopRad, height theHeight and transformation to apply theTrsf.)#"  , py::arg("theBottomRad"),  py::arg("theTrsf"),  py::arg("theIsFilled"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("GetPlanes",
             (void (SelectMgr_TriangularFrustumSet::*)( NCollection_Vector<SelectMgr_Vec4> &  ) const) static_cast<void (SelectMgr_TriangularFrustumSet::*)( NCollection_Vector<SelectMgr_Vec4> &  ) const>(&SelectMgr_TriangularFrustumSet::GetPlanes),
             R"#(Stores plane equation coefficients (in the following form: Ax + By + Cz + D = 0) to the given vector)#"  , py::arg("thePlaneEquations")
          )
        .def("SetAllowOverlapDetection",
             (void (SelectMgr_TriangularFrustumSet::*)(  const Standard_Boolean  ) ) static_cast<void (SelectMgr_TriangularFrustumSet::*)(  const Standard_Boolean  ) >(&SelectMgr_TriangularFrustumSet::SetAllowOverlapDetection),
             R"#(If theIsToAllow is false, only fully included sensitives will be detected, otherwise the algorithm will mark both included and overlapped entities as matched)#"  , py::arg("theIsToAllow")
          )
        .def("DumpJson",
             (void (SelectMgr_TriangularFrustumSet::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (SelectMgr_TriangularFrustumSet::*)( Standard_OStream & ,  Standard_Integer  ) const>(&SelectMgr_TriangularFrustumSet::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions
auto mSelectMgr_MatOp = static_cast<py::module>(m.attr("SelectMgr_MatOp"));

// ./opencascade/SelectMgr.hxx
// ./opencascade/SelectMgr_AndFilter.hxx
// ./opencascade/SelectMgr_AndOrFilter.hxx
// ./opencascade/SelectMgr_AxisIntersector.hxx
// ./opencascade/SelectMgr_BVHThreadPool.hxx
// ./opencascade/SelectMgr_BaseFrustum.hxx
// ./opencascade/SelectMgr_BaseIntersector.hxx
// ./opencascade/SelectMgr_CompositionFilter.hxx
// ./opencascade/SelectMgr_EntityOwner.hxx
// ./opencascade/SelectMgr_Filter.hxx
// ./opencascade/SelectMgr_FilterType.hxx
// ./opencascade/SelectMgr_Frustum.hxx
// ./opencascade/SelectMgr_FrustumBuilder.hxx
// ./opencascade/SelectMgr_IndexedDataMapOfOwnerCriterion.hxx
// ./opencascade/SelectMgr_IndexedMapOfOwner.hxx
// ./opencascade/SelectMgr_ListIteratorOfListOfFilter.hxx
// ./opencascade/SelectMgr_ListOfFilter.hxx
// ./opencascade/SelectMgr_OrFilter.hxx
// ./opencascade/SelectMgr_PickingStrategy.hxx
// ./opencascade/SelectMgr_RectangularFrustum.hxx
// ./opencascade/SelectMgr_SelectableObject.hxx
// ./opencascade/SelectMgr_SelectableObjectSet.hxx
// ./opencascade/SelectMgr_SelectingVolumeManager.hxx
// ./opencascade/SelectMgr_Selection.hxx
// ./opencascade/SelectMgr_SelectionImageFiller.hxx
// ./opencascade/SelectMgr_SelectionManager.hxx
// ./opencascade/SelectMgr_SelectionType.hxx
// ./opencascade/SelectMgr_SensitiveEntity.hxx
// ./opencascade/SelectMgr_SensitiveEntitySet.hxx
// ./opencascade/SelectMgr_SequenceOfOwner.hxx
// ./opencascade/SelectMgr_SequenceOfSelection.hxx
// ./opencascade/SelectMgr_SortCriterion.hxx
// ./opencascade/SelectMgr_StateOfSelection.hxx
// ./opencascade/SelectMgr_ToleranceMap.hxx
// ./opencascade/SelectMgr_TriangularFrustum.hxx
// ./opencascade/SelectMgr_TriangularFrustumSet.hxx
// ./opencascade/SelectMgr_TypeOfBVHUpdate.hxx
// ./opencascade/SelectMgr_TypeOfDepthTolerance.hxx
// ./opencascade/SelectMgr_TypeOfUpdate.hxx
// ./opencascade/SelectMgr_VectorTypes.hxx
    mSelectMgr_MatOp.def("Transform",
          (SelectMgr_Vec3 (*)(  const gp_Trsf & ,   const SelectMgr_Vec3 &  ))  static_cast<SelectMgr_Vec3 (*)(  const gp_Trsf & ,   const SelectMgr_Vec3 &  )>(&SelectMgr_MatOp::Transform),
          R"#()#"  , py::arg("theTrsf"),  py::arg("theVec")
          );
// ./opencascade/SelectMgr_ViewClipRange.hxx
// ./opencascade/SelectMgr_ViewerSelector.hxx
// ./opencascade/SelectMgr_ViewerSelector3d.hxx

// Additional functions


// operators

// register typdefs
    register_template_NCollection_IndexedDataMap<opencascade::handle<SelectMgr_EntityOwner>, SelectMgr_SortCriterion>(m,"SelectMgr_IndexedDataMapOfOwnerCriterion");
    register_template_NCollection_List<opencascade::handle<SelectMgr_Filter>>(m,"SelectMgr_ListOfFilter");
    register_template_NCollection_DataMap<opencascade::handle<SelectMgr_EntityOwner>, Standard_Integer>(m,"SelectMgr_MapOfOwners");
    register_template_NCollection_Sequence<opencascade::handle<SelectMgr_EntityOwner>>(m,"SelectMgr_SequenceOfOwner");
    register_template_NCollection_Sequence<opencascade::handle<SelectMgr_Selection>>(m,"SelectMgr_SequenceOfSelection");
    register_template_NCollection_List<opencascade::handle<SelectMgr_TriangularFrustum>>(m,"SelectMgr_TriangFrustums");
    register_template_NCollection_Vec3<Standard_Real>(m,"SelectMgr_Vec3");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
