
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <ShapeProcess_Operator.hxx>
#include <ShapeProcess_Context.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Resource_Manager.hxx>
#include <Message_Messenger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_ProgressRange.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <ShapeProcess_ShapeContext.hxx>
#include <BRepTools_Modification.hxx>
#include <ShapeExtend_MsgRegistrator.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <ShapeProcess_Context.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <ShapeExtend_MsgRegistrator.hxx>
#include <ShapeBuild_ReShape.hxx>
#include <BRepTools_Modifier.hxx>
#include <Message_Msg.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <ShapeProcess.hxx>
#include <ShapeProcess_Context.hxx>
#include <ShapeProcess_Operator.hxx>
#include <ShapeProcess_OperFunc.hxx>
#include <ShapeProcess_OperLibrary.hxx>
#include <ShapeProcess_ShapeContext.hxx>
#include <ShapeProcess_UOperator.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_ShapeProcess(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("ShapeProcess"));
py::object klass;

//Python trampoline classes
    class Py_ShapeProcess_Operator : public ShapeProcess_Operator{
    public:
        using ShapeProcess_Operator::ShapeProcess_Operator;


        // public pure virtual
        Standard_Boolean Perform( const handle<ShapeProcess_Context> & context, const Message_ProgressRange & theProgress) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,ShapeProcess_Operator,Perform,context,theProgress) };


        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class ShapeProcess from ./opencascade/ShapeProcess.hxx
    klass = m.attr("ShapeProcess");

    // default constructor
    register_default_constructor<ShapeProcess , shared_ptr<ShapeProcess>>(m,"ShapeProcess");

    // nested enums
        py::enum_<ShapeProcess::Operation>(klass, "Operation_e", R"#(Describes all available operations. C++11 enum class is not used to allow implicit conversion to underlying type.)#")
            .value("First", ShapeProcess::Operation::First)
            .value("DirectFaces", ShapeProcess::Operation::DirectFaces)
            .value("SameParameter", ShapeProcess::Operation::SameParameter)
            .value("SetTolerance", ShapeProcess::Operation::SetTolerance)
            .value("SplitAngle", ShapeProcess::Operation::SplitAngle)
            .value("BSplineRestriction", ShapeProcess::Operation::BSplineRestriction)
            .value("ElementaryToRevolution", ShapeProcess::Operation::ElementaryToRevolution)
            .value("SweptToElementary", ShapeProcess::Operation::SweptToElementary)
            .value("SurfaceToBSpline", ShapeProcess::Operation::SurfaceToBSpline)
            .value("ToBezier", ShapeProcess::Operation::ToBezier)
            .value("SplitContinuity", ShapeProcess::Operation::SplitContinuity)
            .value("SplitClosedFaces", ShapeProcess::Operation::SplitClosedFaces)
            .value("FixWireGaps", ShapeProcess::Operation::FixWireGaps)
            .value("FixFaceSize", ShapeProcess::Operation::FixFaceSize)
            .value("DropSmallSolids", ShapeProcess::Operation::DropSmallSolids)
            .value("DropSmallEdges", ShapeProcess::Operation::DropSmallEdges)
            .value("FixShape", ShapeProcess::Operation::FixShape)
            .value("SplitClosedEdges", ShapeProcess::Operation::SplitClosedEdges)
            .value("SplitCommonVertex", ShapeProcess::Operation::SplitCommonVertex)
            .value("Last", ShapeProcess::Operation::Last).export_values();

    static_cast<py::class_<ShapeProcess , shared_ptr<ShapeProcess>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("RegisterOperator_s",
                    (Standard_Boolean (*)(  const Standard_CString ,   const handle<ShapeProcess_Operator> &  ) ) static_cast<Standard_Boolean (*)(  const Standard_CString ,   const handle<ShapeProcess_Operator> &  ) >(&ShapeProcess::RegisterOperator),
                    R"#(Registers operator to make it visible for Performer)#"  , py::arg("name"),  py::arg("op")
          )
        .def_static("FindOperator_s",
                    (Standard_Boolean (*)(  const Standard_CString ,  handle<ShapeProcess_Operator> &  ) ) static_cast<Standard_Boolean (*)(  const Standard_CString ,  handle<ShapeProcess_Operator> &  ) >(&ShapeProcess::FindOperator),
                    R"#(Finds operator by its name)#"  , py::arg("name"),  py::arg("op")
          )
        .def_static("Perform_s",
                    (Standard_Boolean (*)(  const handle<ShapeProcess_Context> & ,   const Standard_CString ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (*)(  const handle<ShapeProcess_Context> & ,   const Standard_CString ,   const Message_ProgressRange &  ) >(&ShapeProcess::Perform),
                    R"#(Performs a specified sequence of operators on Context Resource file and other data should be already loaded to Context (including description of sequence seq))#"  , py::arg("context"),  py::arg("seq"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def_static("Perform_s",
                    (Standard_Boolean (*)(  const handle<ShapeProcess_Context> & ,   const typename ShapeProcess::OperationsFlags & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (*)(  const handle<ShapeProcess_Context> & ,   const typename ShapeProcess::OperationsFlags & ,   const Message_ProgressRange &  ) >(&ShapeProcess::Perform),
                    R"#(Performs a specified sequence of operators on theContext.)#"  , py::arg("theContext"),  py::arg("theOperations"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def_static("ToOperationFlag_s",
                    (std::pair<ShapeProcess::Operation, bool> (*)(  const char *  ) ) static_cast<std::pair<ShapeProcess::Operation, bool> (*)(  const char *  ) >(&ShapeProcess::ToOperationFlag),
                    R"#(Converts operation name to operation flag.)#"  , py::arg("theName")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class ShapeProcess_Context from ./opencascade/ShapeProcess_Context.hxx
    klass = m.attr("ShapeProcess_Context");


    // nested enums

    static_cast<py::class_<ShapeProcess_Context ,opencascade::handle<ShapeProcess_Context>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const Standard_CString, const Standard_CString >()  , py::arg("file"),  py::arg("scope")=static_cast< const Standard_CString>("") )
    // custom constructors
    // methods
        .def("Init",
             (Standard_Boolean (ShapeProcess_Context::*)(  const Standard_CString ,   const Standard_CString  ) ) static_cast<Standard_Boolean (ShapeProcess_Context::*)(  const Standard_CString ,   const Standard_CString  ) >(&ShapeProcess_Context::Init),
             R"#(Initialises a tool by loading resource file and (if specified) sets starting scope Returns False if resource file not found)#"  , py::arg("file"),  py::arg("scope")=static_cast< const Standard_CString>("")
          )
        .def("LoadResourceManager",
             (handle<Resource_Manager> (ShapeProcess_Context::*)(  const Standard_CString  ) ) static_cast<handle<Resource_Manager> (ShapeProcess_Context::*)(  const Standard_CString  ) >(&ShapeProcess_Context::LoadResourceManager),
             R"#(Loading Resource_Manager object if this object not equal internal static Resource_Manager object or internal static Resource_Manager object is null)#"  , py::arg("file")
          )
        .def("SetScope",
             (void (ShapeProcess_Context::*)(  const Standard_CString  ) ) static_cast<void (ShapeProcess_Context::*)(  const Standard_CString  ) >(&ShapeProcess_Context::SetScope),
             R"#(Set a new (sub)scope)#"  , py::arg("scope")
          )
        .def("UnSetScope",
             (void (ShapeProcess_Context::*)() ) static_cast<void (ShapeProcess_Context::*)() >(&ShapeProcess_Context::UnSetScope),
             R"#(Go out of current scope)#" 
          )
        .def("IsParamSet",
             (Standard_Boolean (ShapeProcess_Context::*)(  const Standard_CString  ) const) static_cast<Standard_Boolean (ShapeProcess_Context::*)(  const Standard_CString  ) const>(&ShapeProcess_Context::IsParamSet),
             R"#(Returns True if parameter is defined in the resource file)#"  , py::arg("param")
          )
        .def("GetReal",
             (Standard_Boolean (ShapeProcess_Context::*)(  const Standard_CString ,  Standard_Real &  ) const) static_cast<Standard_Boolean (ShapeProcess_Context::*)(  const Standard_CString ,  Standard_Real &  ) const>(&ShapeProcess_Context::GetReal),
             R"#()#"  , py::arg("param"),  py::arg("val")
          )
        .def("GetInteger",
             (Standard_Boolean (ShapeProcess_Context::*)(  const Standard_CString ,  Standard_Integer &  ) const) static_cast<Standard_Boolean (ShapeProcess_Context::*)(  const Standard_CString ,  Standard_Integer &  ) const>(&ShapeProcess_Context::GetInteger),
             R"#()#"  , py::arg("param"),  py::arg("val")
          )
        .def("GetBoolean",
             (Standard_Boolean (ShapeProcess_Context::*)(  const Standard_CString ,  Standard_Boolean &  ) const) static_cast<Standard_Boolean (ShapeProcess_Context::*)(  const Standard_CString ,  Standard_Boolean &  ) const>(&ShapeProcess_Context::GetBoolean),
             R"#()#"  , py::arg("param"),  py::arg("val")
          )
        .def("GetString",
             (Standard_Boolean (ShapeProcess_Context::*)(  const Standard_CString ,  TCollection_AsciiString &  ) const) static_cast<Standard_Boolean (ShapeProcess_Context::*)(  const Standard_CString ,  TCollection_AsciiString &  ) const>(&ShapeProcess_Context::GetString),
             R"#(Get value of parameter as being of specific type Returns False if parameter is not defined or has a wrong type)#"  , py::arg("param"),  py::arg("val")
          )
        .def("RealVal",
             (Standard_Real (ShapeProcess_Context::*)(  const Standard_CString ,   const Standard_Real  ) const) static_cast<Standard_Real (ShapeProcess_Context::*)(  const Standard_CString ,   const Standard_Real  ) const>(&ShapeProcess_Context::RealVal),
             R"#()#"  , py::arg("param"),  py::arg("def_")
          )
        .def("IntegerVal",
             (Standard_Integer (ShapeProcess_Context::*)(  const Standard_CString ,   const Standard_Integer  ) const) static_cast<Standard_Integer (ShapeProcess_Context::*)(  const Standard_CString ,   const Standard_Integer  ) const>(&ShapeProcess_Context::IntegerVal),
             R"#()#"  , py::arg("param"),  py::arg("def_")
          )
        .def("BooleanVal",
             (Standard_Boolean (ShapeProcess_Context::*)(  const Standard_CString ,   const Standard_Boolean  ) const) static_cast<Standard_Boolean (ShapeProcess_Context::*)(  const Standard_CString ,   const Standard_Boolean  ) const>(&ShapeProcess_Context::BooleanVal),
             R"#()#"  , py::arg("param"),  py::arg("def_")
          )
        .def("StringVal",
             (Standard_CString (ShapeProcess_Context::*)(  const Standard_CString ,   const Standard_CString  ) const) static_cast<Standard_CString (ShapeProcess_Context::*)(  const Standard_CString ,   const Standard_CString  ) const>(&ShapeProcess_Context::StringVal),
             R"#(Get value of parameter as being of specific type If parameter is not defined or does not have expected type, returns default value as specified)#"  , py::arg("param"),  py::arg("def_")
          )
        .def("SetMessenger",
             (void (ShapeProcess_Context::*)(  const handle<Message_Messenger> &  ) ) static_cast<void (ShapeProcess_Context::*)(  const handle<Message_Messenger> &  ) >(&ShapeProcess_Context::SetMessenger),
             R"#(Sets Messenger used for outputting messages.)#"  , py::arg("messenger")
          )
        .def("Messenger",
             (handle<Message_Messenger> (ShapeProcess_Context::*)() const) static_cast<handle<Message_Messenger> (ShapeProcess_Context::*)() const>(&ShapeProcess_Context::Messenger),
             R"#(Returns Messenger used for outputting messages.)#" 
          )
        .def("SetTraceLevel",
             (void (ShapeProcess_Context::*)(  const Standard_Integer  ) ) static_cast<void (ShapeProcess_Context::*)(  const Standard_Integer  ) >(&ShapeProcess_Context::SetTraceLevel),
             R"#(Sets trace level used for outputting messages - 0: no trace at all - 1: errors - 2: errors and warnings - 3: all messages Default is 1 : Errors traced)#"  , py::arg("tracelev")
          )
        .def("TraceLevel",
             (Standard_Integer (ShapeProcess_Context::*)() const) static_cast<Standard_Integer (ShapeProcess_Context::*)() const>(&ShapeProcess_Context::TraceLevel),
             R"#(Returns trace level used for outputting messages.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&ShapeProcess_Context::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&ShapeProcess_Context::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ResourceManager",
             ( const handle<Resource_Manager> & (ShapeProcess_Context::*)() const) static_cast< const handle<Resource_Manager> & (ShapeProcess_Context::*)() const>(&ShapeProcess_Context::ResourceManager),
             R"#(Returns internal Resource_Manager object)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (ShapeProcess_Context::*)() const) static_cast< const handle<Standard_Type> & (ShapeProcess_Context::*)() const>(&ShapeProcess_Context::DynamicType),
             R"#()#"
             
         )
;

    // Class ShapeProcess_OperLibrary from ./opencascade/ShapeProcess_OperLibrary.hxx
    klass = m.attr("ShapeProcess_OperLibrary");

    // default constructor
    register_default_constructor<ShapeProcess_OperLibrary , shared_ptr<ShapeProcess_OperLibrary>>(m,"ShapeProcess_OperLibrary");

    // nested enums

    static_cast<py::class_<ShapeProcess_OperLibrary , shared_ptr<ShapeProcess_OperLibrary>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Init_s",
                    (void (*)() ) static_cast<void (*)() >(&ShapeProcess_OperLibrary::Init),
                    R"#(Registers all the operators)#" 
          )
        .def_static("ApplyModifier_s",
                    (TopoDS_Shape (*)(  const TopoDS_Shape & ,   const handle<ShapeProcess_ShapeContext> & ,   const handle<BRepTools_Modification> & ,  TopTools_DataMapOfShapeShape & ,   const handle<ShapeExtend_MsgRegistrator> & ,  Standard_Boolean  ) ) static_cast<TopoDS_Shape (*)(  const TopoDS_Shape & ,   const handle<ShapeProcess_ShapeContext> & ,   const handle<BRepTools_Modification> & ,  TopTools_DataMapOfShapeShape & ,   const handle<ShapeExtend_MsgRegistrator> & ,  Standard_Boolean  ) >(&ShapeProcess_OperLibrary::ApplyModifier),
                    R"#(Applies BRepTools_Modification to a shape, taking into account sharing of components of compounds. if theMutableInput vat is set to true then input shape S can be modified during the modification process.)#"  , py::arg("S"),  py::arg("context"),  py::arg("M"),  py::arg("map"),  py::arg("msg")=static_cast< const handle<ShapeExtend_MsgRegistrator> &>(0),  py::arg("theMutableInput")=static_cast<Standard_Boolean>(Standard_False)
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class ShapeProcess_Operator from ./opencascade/ShapeProcess_Operator.hxx
    klass = m.attr("ShapeProcess_Operator");


    // nested enums

    static_cast<py::class_<ShapeProcess_Operator ,opencascade::handle<ShapeProcess_Operator> ,Py_ShapeProcess_Operator , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Perform",
             (Standard_Boolean (ShapeProcess_Operator::*)(  const handle<ShapeProcess_Context> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (ShapeProcess_Operator::*)(  const handle<ShapeProcess_Context> & ,   const Message_ProgressRange &  ) >(&ShapeProcess_Operator::Perform),
             R"#(Performs operation and eventually records changes in the context)#"  , py::arg("context"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&ShapeProcess_Operator::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&ShapeProcess_Operator::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (ShapeProcess_Operator::*)() const) static_cast< const handle<Standard_Type> & (ShapeProcess_Operator::*)() const>(&ShapeProcess_Operator::DynamicType),
             R"#()#"
             
         )
;

    // Class ShapeProcess_ShapeContext from ./opencascade/ShapeProcess_ShapeContext.hxx
    klass = m.attr("ShapeProcess_ShapeContext");


    // nested enums

    static_cast<py::class_<ShapeProcess_ShapeContext ,opencascade::handle<ShapeProcess_ShapeContext>  , ShapeProcess_Context >>(klass)
    // constructors
        .def(py::init<  const Standard_CString, const Standard_CString >()  , py::arg("file"),  py::arg("seq")=static_cast< const Standard_CString>("") )
        .def(py::init<  const TopoDS_Shape &, const Standard_CString, const Standard_CString >()  , py::arg("S"),  py::arg("file"),  py::arg("seq")=static_cast< const Standard_CString>("") )
    // custom constructors
    // methods
        .def("Init",
             (void (ShapeProcess_ShapeContext::*)(  const TopoDS_Shape &  ) ) static_cast<void (ShapeProcess_ShapeContext::*)(  const TopoDS_Shape &  ) >(&ShapeProcess_ShapeContext::Init),
             R"#(Initializes tool by a new shape and clears all results)#"  , py::arg("S")
          )
        .def("SetDetalisation",
             (void (ShapeProcess_ShapeContext::*)(  const TopAbs_ShapeEnum  ) ) static_cast<void (ShapeProcess_ShapeContext::*)(  const TopAbs_ShapeEnum  ) >(&ShapeProcess_ShapeContext::SetDetalisation),
             R"#()#"  , py::arg("level")
          )
        .def("GetDetalisation",
             (TopAbs_ShapeEnum (ShapeProcess_ShapeContext::*)() const) static_cast<TopAbs_ShapeEnum (ShapeProcess_ShapeContext::*)() const>(&ShapeProcess_ShapeContext::GetDetalisation),
             R"#(Set and get value for detalisation level Only shapes of types from TopoDS_COMPOUND and until specified detalisation level will be recorded in maps To cancel mapping, use TopAbs_SHAPE To force full mapping, use TopAbs_VERTEX The default level is TopAbs_FACE)#" 
          )
        .def("SetResult",
             (void (ShapeProcess_ShapeContext::*)(  const TopoDS_Shape &  ) ) static_cast<void (ShapeProcess_ShapeContext::*)(  const TopoDS_Shape &  ) >(&ShapeProcess_ShapeContext::SetResult),
             R"#(Sets a new result shape NOTE: this method should be used very carefully to keep consistency of modifications It is recommended to use RecordModification() methods with explicit definition of mapping from current result to a new one)#"  , py::arg("S")
          )
        .def("RecordModification",
             (void (ShapeProcess_ShapeContext::*)(  const TopTools_DataMapOfShapeShape & ,   const handle<ShapeExtend_MsgRegistrator> &  ) ) static_cast<void (ShapeProcess_ShapeContext::*)(  const TopTools_DataMapOfShapeShape & ,   const handle<ShapeExtend_MsgRegistrator> &  ) >(&ShapeProcess_ShapeContext::RecordModification),
             R"#()#"  , py::arg("repl"),  py::arg("msg")=static_cast< const handle<ShapeExtend_MsgRegistrator> &>(0)
          )
        .def("RecordModification",
             (void (ShapeProcess_ShapeContext::*)(  const handle<ShapeBuild_ReShape> & ,   const handle<ShapeExtend_MsgRegistrator> &  ) ) static_cast<void (ShapeProcess_ShapeContext::*)(  const handle<ShapeBuild_ReShape> & ,   const handle<ShapeExtend_MsgRegistrator> &  ) >(&ShapeProcess_ShapeContext::RecordModification),
             R"#()#"  , py::arg("repl"),  py::arg("msg")
          )
        .def("RecordModification",
             (void (ShapeProcess_ShapeContext::*)(  const handle<ShapeBuild_ReShape> &  ) ) static_cast<void (ShapeProcess_ShapeContext::*)(  const handle<ShapeBuild_ReShape> &  ) >(&ShapeProcess_ShapeContext::RecordModification),
             R"#()#"  , py::arg("repl")
          )
        .def("RecordModification",
             (void (ShapeProcess_ShapeContext::*)(  const TopoDS_Shape & ,   const BRepTools_Modifier & ,   const handle<ShapeExtend_MsgRegistrator> &  ) ) static_cast<void (ShapeProcess_ShapeContext::*)(  const TopoDS_Shape & ,   const BRepTools_Modifier & ,   const handle<ShapeExtend_MsgRegistrator> &  ) >(&ShapeProcess_ShapeContext::RecordModification),
             R"#(Records modifications and resets result accordingly NOTE: modification of resulting shape should be explicitly defined in the maps along with modifications of subshapes)#"  , py::arg("sh"),  py::arg("repl"),  py::arg("msg")=static_cast< const handle<ShapeExtend_MsgRegistrator> &>(0)
          )
        .def("AddMessage",
             (void (ShapeProcess_ShapeContext::*)(  const TopoDS_Shape & ,   const Message_Msg & ,   const Message_Gravity  ) ) static_cast<void (ShapeProcess_ShapeContext::*)(  const TopoDS_Shape & ,   const Message_Msg & ,   const Message_Gravity  ) >(&ShapeProcess_ShapeContext::AddMessage),
             R"#(Record a message for shape S Shape S should be one of subshapes of original shape (or whole one), but not one of intermediate shapes Records only if Message() is not Null)#"  , py::arg("S"),  py::arg("msg"),  py::arg("gravity")=static_cast< const Message_Gravity>(Message_Warning)
          )
        .def("GetContinuity",
             (Standard_Boolean (ShapeProcess_ShapeContext::*)(  const Standard_CString ,  GeomAbs_Shape &  ) const) static_cast<Standard_Boolean (ShapeProcess_ShapeContext::*)(  const Standard_CString ,  GeomAbs_Shape &  ) const>(&ShapeProcess_ShapeContext::GetContinuity),
             R"#(Get value of parameter as being of the type GeomAbs_Shape Returns False if parameter is not defined or has a wrong type)#"  , py::arg("param"),  py::arg("val")
          )
        .def("ContinuityVal",
             (GeomAbs_Shape (ShapeProcess_ShapeContext::*)(  const Standard_CString ,   const GeomAbs_Shape  ) const) static_cast<GeomAbs_Shape (ShapeProcess_ShapeContext::*)(  const Standard_CString ,   const GeomAbs_Shape  ) const>(&ShapeProcess_ShapeContext::ContinuityVal),
             R"#(Get value of parameter as being of the type GeomAbs_Shape If parameter is not defined or does not have expected type, returns default value as specified)#"  , py::arg("param"),  py::arg("def_")
          )
        .def("PrintStatistics",
             (void (ShapeProcess_ShapeContext::*)() const) static_cast<void (ShapeProcess_ShapeContext::*)() const>(&ShapeProcess_ShapeContext::PrintStatistics),
             R"#(Prints statistics on Shape Processing onto the current Messenger.)#" 
          )
        .def("SetNonManifold",
             (void (ShapeProcess_ShapeContext::*)( Standard_Boolean  ) ) static_cast<void (ShapeProcess_ShapeContext::*)( Standard_Boolean  ) >(&ShapeProcess_ShapeContext::SetNonManifold),
             R"#(Set NonManifold flag)#"  , py::arg("theNonManifold")
          )
        .def("IsNonManifold",
             (Standard_Boolean (ShapeProcess_ShapeContext::*)() ) static_cast<Standard_Boolean (ShapeProcess_ShapeContext::*)() >(&ShapeProcess_ShapeContext::IsNonManifold),
             R"#(Get NonManifold flag)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&ShapeProcess_ShapeContext::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&ShapeProcess_ShapeContext::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Shape",
             ( const TopoDS_Shape & (ShapeProcess_ShapeContext::*)() const) static_cast< const TopoDS_Shape & (ShapeProcess_ShapeContext::*)() const>(&ShapeProcess_ShapeContext::Shape),
             R"#(Returns shape being processed)#"
             
         )
       .def("Result",
             ( const TopoDS_Shape & (ShapeProcess_ShapeContext::*)() const) static_cast< const TopoDS_Shape & (ShapeProcess_ShapeContext::*)() const>(&ShapeProcess_ShapeContext::Result),
             R"#(Returns current result)#"
             
         )
       .def("Map",
             ( const TopTools_DataMapOfShapeShape & (ShapeProcess_ShapeContext::*)() const) static_cast< const TopTools_DataMapOfShapeShape & (ShapeProcess_ShapeContext::*)() const>(&ShapeProcess_ShapeContext::Map),
             R"#(Returns map of replacements shape -> shape This map is not recursive)#"
             
         )
       .def("Messages",
             ( const handle<ShapeExtend_MsgRegistrator> & (ShapeProcess_ShapeContext::*)() const) static_cast< const handle<ShapeExtend_MsgRegistrator> & (ShapeProcess_ShapeContext::*)() const>(&ShapeProcess_ShapeContext::Messages),
             R"#()#"
             
         )
       .def("Messages",
             (handle<ShapeExtend_MsgRegistrator> & (ShapeProcess_ShapeContext::*)() ) static_cast<handle<ShapeExtend_MsgRegistrator> & (ShapeProcess_ShapeContext::*)() >(&ShapeProcess_ShapeContext::Messages),
             R"#(Returns messages recorded during shape processing It can be nullified before processing in order to avoid recording messages)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (ShapeProcess_ShapeContext::*)() const) static_cast< const handle<Standard_Type> & (ShapeProcess_ShapeContext::*)() const>(&ShapeProcess_ShapeContext::DynamicType),
             R"#()#"
             
         )
;

    // Class ShapeProcess_UOperator from ./opencascade/ShapeProcess_UOperator.hxx
    klass = m.attr("ShapeProcess_UOperator");


    // nested enums

    static_cast<py::class_<ShapeProcess_UOperator ,opencascade::handle<ShapeProcess_UOperator>  , ShapeProcess_Operator >>(klass)
    // constructors
        .def(py::init<  const ShapeProcess_OperFunc >()  , py::arg("func") )
    // custom constructors
    // methods
        .def("Perform",
             (Standard_Boolean (ShapeProcess_UOperator::*)(  const handle<ShapeProcess_Context> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (ShapeProcess_UOperator::*)(  const handle<ShapeProcess_Context> & ,   const Message_ProgressRange &  ) >(&ShapeProcess_UOperator::Perform),
             R"#(Performs operation and records changes in the context)#"  , py::arg("context"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&ShapeProcess_UOperator::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&ShapeProcess_UOperator::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (ShapeProcess_UOperator::*)() const) static_cast< const handle<Standard_Type> & (ShapeProcess_UOperator::*)() const>(&ShapeProcess_UOperator::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/ShapeProcess.hxx
// ./opencascade/ShapeProcess_Context.hxx
// ./opencascade/ShapeProcess_OperFunc.hxx
// ./opencascade/ShapeProcess_OperLibrary.hxx
// ./opencascade/ShapeProcess_Operator.hxx
// ./opencascade/ShapeProcess_ShapeContext.hxx
// ./opencascade/ShapeProcess_UOperator.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
