
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XmlMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Attribute.hxx>
#include <XmlObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Attribute.hxx>
#include <XmlObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>

// module includes
#include <XmlMNaming.hxx>
#include <XmlMNaming_NamedShapeDriver.hxx>
#include <XmlMNaming_NamingDriver.hxx>
#include <XmlMNaming_Shape1.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_XmlMNaming_enums(py::module &main_module) {


py::module m = main_module.def_submodule("XmlMNaming", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<XmlMNaming , shared_ptr<XmlMNaming>  >(m,"XmlMNaming",R"#()#");
    py::class_<XmlMNaming_Shape1 , shared_ptr<XmlMNaming_Shape1>  >(m,"XmlMNaming_Shape1",R"#(The XmlMNaming_Shape1 is the Persistent view of a TopoDS_Shape.)#");
    py::class_<XmlMNaming_NamedShapeDriver ,opencascade::handle<XmlMNaming_NamedShapeDriver>  , XmlMDF_ADriver >(m,"XmlMNaming_NamedShapeDriver",R"#()#");
    py::class_<XmlMNaming_NamingDriver ,opencascade::handle<XmlMNaming_NamingDriver>  , XmlMDF_ADriver >(m,"XmlMNaming_NamingDriver",R"#()#");

};

// user-defined post-inclusion per module

// user-defined post
