% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zap_label.R
\name{zap_label}
\alias{zap_label}
\title{Zap variable labels}
\usage{
zap_label(x)
}
\arguments{
\item{x}{A vector or data frame}
}
\description{
Removes variable label, leaving unlabelled vectors as is.
}
\examples{
x1 <- labelled(1:5, c(good = 1, bad = 5), label = "rating")
x1
zap_label(x1)

x2 <- labelled_spss(c(1:4, 9), label = "score", na_values = 9)
x2
zap_label(x2)

# zap_label also works with data frames
df <- tibble::tibble(x1, x2)
str(df)
str(zap_label(df))
}
\seealso{
\code{\link[=zap_labels]{zap_labels()}} to remove value labels.

Other zappers: 
\code{\link{zap_empty}()},
\code{\link{zap_formats}()},
\code{\link{zap_labels}()},
\code{\link{zap_widths}()}
}
\concept{zappers}
