# 2022-04-19 Triage Log

A rough week, if only in terms of the sheer number of PRs that were flagged as regressions. Going through 31 regressive PR's, 13 of them rollups, is not fun.
There were some nice wins from e.g. [#95968](https://github.com/rust-lang/rust/pull/95968) and [#95981](https://github.com/rust-lang/rust/pull/95981).
The main worrisome regression is a 1% compile-time from [#96010](https://github.com/rust-lang/rust/pull/96010) that seems like it was not expected.

Triage done by **@pnkfelix**.
Revision range: [4e1927db..4ca19e09](https://perf.rust-lang.org/?start=4e1927db3c399fa34dc71992bd5dbec09f945c3d&end=4ca19e09d302a4cbde14f9cb1bc109179dc824cd&absolute=false&stat=instructions%3Au)

7 Regressions, 12 Improvements, 24 Mixed; 13 of them in rollups
51 artifact comparisons made in total

#### Regressions

Rollup of 7 pull requests [#95966](https://github.com/rust-lang/rust/pull/95966) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4e1927db3c399fa34dc71992bd5dbec09f945c3d&end=2a83fbc42a9bb6bfdb8d3fb4ecce83fb410d7642&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 2 | 2 | 0 | 0 | 2 |
| mean | 0.2% | 0.3% | N/A | N/A | 0.2% |
| max | 0.2% | 0.4% | N/A | N/A | 0.2% |
* left comment: Unclear cause, fairly small regression, and rollup: not worth the time to investigate -- benefit/cost tradeoff is not worth it.

Rollup of 4 pull requests [#95999](https://github.com/rust-lang/rust/pull/95999) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1491e5cc148391f7679542b8e9b4e6d2430a7b69&end=b768f248e99688a2d7649731a99b2f2ad962abf5&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 3 | 0 | 0 | 0 |
| mean | N/A | 1.0% | N/A | N/A | N/A |
| max | N/A | 1.2% | N/A | N/A | N/A |
* left comment: I don't see any reason why the PRs in this rollup would have anything to do with its associated regression.

Use mir constant in thir instead of ty::Const [#94255](https://github.com/rust-lang/rust/pull/94255) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b768f248e99688a2d7649731a99b2f2ad962abf5&end=e3c43e64eceb00e13b1932229aa9b2d774e6af96&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 2 | 12 | 0 | 0 | 2 |
| mean | 0.2% | 0.4% | N/A | N/A | 0.2% |
| max | 0.2% | 0.5% | N/A | N/A | 0.2% |
* left comment: An earlier perf run, on I think the same commit series as what was eventually merged, showed no primary regressions at all.
* A number of secondary benchmarks regressed, but they are all stress test microbenchmarks, and should not block landing work of this nature.
* So, I'm chalking the minor amount of regression that was observed up to noise.

Update stdarch [#95958](https://github.com/rust-lang/rust/pull/95958) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0d13f6afeba4935499abe0c9a07426c94492c94e&end=dc4bfcbdfff651c82eff4bdd311d28e54d1513c4&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 1 | 8 | 0 | 0 | 1 |
| mean | 1.1% | 0.7% | N/A | N/A | 1.1% |
| max | 1.1% | 1.2% | N/A | N/A | 1.1% |
* left comments. Only one regression but it wasn't clear why this PR would cause it.
* Subsequent attempt to cachegrind diff the two rustc's indicate that there may be some amount of noise at play here. Marked as triaged.

Rollup of 7 pull requests [#96123](https://github.com/rust-lang/rust/pull/96123) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2fa9789f596dd7639e1a242d466637b53179f4d1&end=878c7833f6c1ff10e2fd89074e5bd4ef5ff15936&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 6 | 0 | 0 | 0 |
| mean | N/A | 0.4% | N/A | N/A | N/A |
| max | N/A | 0.5% | N/A | N/A | N/A |
* six secondary regressions, all in variants of `match-stress` and all on the order of 0.48%.
* left comment: narrow scope, secondary benchmark, small regression, and rollup: not worth investigating further.

Rollup of 5 pull requests [#96178](https://github.com/rust-lang/rust/pull/96178) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0516711ab057d9731f55511f00f9d426bc9db724&end=8305398d7ae6128811ec2b3223939bcd067530c2&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 1 | 0 | 0 | 0 | 1 |
| mean | 2.5% | N/A | N/A | N/A | 2.5% |
| max | 2.5% | N/A | N/A | N/A | 2.5% |
* regressed syn-opt-1.0.89 opt full by 2.5%.
* The only PR on the list in this rollup that I could imagine having any effect at all on performance is PR #96156.
* looked at graph, seems like benchmark became more noisy recently, and this is part of the variance injected by that noise.

Add slice::remainder [#92287](https://github.com/rust-lang/rust/pull/92287) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=311e2683e1bad87715b1558f7900e294d24ce491&end=d5ae66c12c6bdf1a5739ae1fce8057fd76ba0f47&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 2 | 0 | 0 | 0 |
| mean | N/A | 1.2% | N/A | N/A | N/A |
| max | N/A | 1.2% | N/A | N/A | N/A |
* regressed externs (a secondary benchmark) incr-full in debug and opt profiles by 1.2%.
* left comment; based on cachegrind output and the perf graph, this does not seem to be a persistent regression. We do not need to worry about it.

#### Improvements

Rollup of 5 pull requests [#95974](https://github.com/rust-lang/rust/pull/95974) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2a83fbc42a9bb6bfdb8d3fb4ecce83fb410d7642&end=327caac4d01aef74d6577b87c295270608be09fa&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 0 | 0 | 7 | 0 |
| mean | N/A | N/A | N/A | -0.3% | N/A |
| max | N/A | N/A | N/A | -0.6% | N/A |


errors: lazily load fallback fluent bundle [#95968](https://github.com/rust-lang/rust/pull/95968) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=dc4bfcbdfff651c82eff4bdd311d28e54d1513c4&end=34a6c9f26e2ce32cad0d71f5e342365b09f4d12c&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 0 | 19 | 30 | 19 |
| mean | N/A | N/A | -2.7% | -2.9% | -2.7% |
| max | N/A | N/A | -10.4% | -5.2% | -10.4% |


Optimize `<SourceFile as Decodable>::decode` [#95981](https://github.com/rust-lang/rust/pull/95981) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=34a6c9f26e2ce32cad0d71f5e342365b09f4d12c&end=f387c930ee7c84357f8fa9f4c38903c00404ac46&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 1 | 16 | 76 | 16 |
| mean | N/A | 0.9% | -1.5% | -1.5% | -1.5% |
| max | N/A | 0.9% | -5.1% | -4.5% | -5.1% |


Remove `<mbe::TokenTree as Clone>` [#95928](https://github.com/rust-lang/rust/pull/95928) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f387c930ee7c84357f8fa9f4c38903c00404ac46&end=f9d4d12b6ab97fae8b9a6f607473fe149f38f6bd&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 2 | 25 | 14 | 25 |
| mean | N/A | 0.3% | -0.5% | -2.6% | -0.5% |
| max | N/A | 0.3% | -0.7% | -4.8% | -0.7% |


Allow self-profiler to only record potentially costly arguments when argument recording is turned on [#95689](https://github.com/rust-lang/rust/pull/95689) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c8422403f775126c40d558838d321c063554c822&end=febce1fc316f5618d5bb8f05d19e2e3ba868c007&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 0 | 0 | 3 | 0 |
| mean | N/A | N/A | N/A | -1.1% | N/A |
| max | N/A | N/A | N/A | -1.1% | N/A |


Fix `x test --doc --stage 0 library/std` [#95993](https://github.com/rust-lang/rust/pull/95993) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d9b3ff7d34335c5bc0b2afed640b65d64a85fe03&end=2fa9789f596dd7639e1a242d466637b53179f4d1&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 0 | 0 | 5 | 0 |
| mean | N/A | N/A | N/A | -1.1% | N/A |
| max | N/A | N/A | N/A | -1.2% | N/A |


Rollup of 6 pull requests [#96134](https://github.com/rust-lang/rust/pull/96134) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=563ef23529ae800b2b136cabdc71a81d86a75f58&end=2c28b0eaf9843ec0f493fca2dba506fe4d9174fb&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 0 | 0 | 3 | 0 |
| mean | N/A | N/A | N/A | -1.1% | N/A |
| max | N/A | N/A | N/A | -1.1% | N/A |


Speed up Vec::clear(). [#96002](https://github.com/rust-lang/rust/pull/96002) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2c28b0eaf9843ec0f493fca2dba506fe4d9174fb&end=43a71dc732af0f7cc5895cca8d001184c252426a&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 0 | 1 | 0 | 1 |
| mean | N/A | N/A | -1.5% | N/A | -1.5% |
| max | N/A | N/A | -1.5% | N/A | -1.5% |


fix error handling for pthread_sigmask(3) [#93530](https://github.com/rust-lang/rust/pull/93530) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ec77f252434a532fdb5699ae4f21a3072d211edd&end=e27d9df4319bd822e64f620676543d31e9c7ae2c&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 0 | 1 | 0 | 1 |
| mean | N/A | N/A | -3.0% | N/A | -3.0% |
| max | N/A | N/A | -3.0% | N/A | -3.0% |


Respect ranlib specified for target during LLVM build [#96080](https://github.com/rust-lang/rust/pull/96080) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=faecdc05abc997ba3be693024724ce205facb686&end=491f619f564a4ff9ae4cc837e27bb919d04c31be&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 0 | 1 | 2 | 1 |
| mean | N/A | N/A | -2.2% | -1.2% | -2.2% |
| max | N/A | N/A | -2.2% | -1.2% | -2.2% |


Require all paths passed to `ShouldRun::paths` to exist on disk [#95906](https://github.com/rust-lang/rust/pull/95906) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6fd7e9010db6be7605241c39eab7c5078ee2d5bd&end=0516711ab057d9731f55511f00f9d426bc9db724&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 0 | 1 | 0 | 1 |
| mean | N/A | N/A | -1.0% | N/A | -1.0% |
| max | N/A | N/A | -1.0% | N/A | -1.0% |


show suggestion to replace generic bounds with associated types in more cases [#95379](https://github.com/rust-lang/rust/pull/95379) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d5ae66c12c6bdf1a5739ae1fce8057fd76ba0f47&end=e2661bac6d8ae6b9e2a26cd08e9c087ab59e1357&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 0 | 1 | 0 | 1 |
| mean | N/A | N/A | -1.8% | N/A | -1.8% |
| max | N/A | N/A | -1.8% | N/A | -1.8% |


#### Mixed

Skip `Lazy` for some metadata tables [#95867](https://github.com/rust-lang/rust/pull/95867) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=327caac4d01aef74d6577b87c295270608be09fa&end=de56c295c394349a68f293039481c3aa6402f9c6&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 5 | 0 | 1 | 0 |
| mean | N/A | 0.4% | N/A | -0.7% | N/A |
| max | N/A | 0.5% | N/A | -0.7% | N/A |
* already triaged by the PR author.

Rollup of 4 pull requests [#95987](https://github.com/rust-lang/rust/pull/95987) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=de56c295c394349a68f293039481c3aa6402f9c6&end=52ca603da73ae9eaddf96f77953b33ad8c47cc8e&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 13 | 0 | 7 | 0 |
| mean | N/A | 1.7% | N/A | -0.4% | N/A |
| max | N/A | 3.0% | N/A | -0.6% | N/A |
* the big hit here was to tt-muncher (a secondary benchmark), which regressed on 10 different configurations, by amounts varying from 1.4% up to 3.0%.
* the cachegrind diff for the 3.0% hit is here: https://gist.github.com/7674ad03c8f72705eb5bd2651202f40a
* that cachegrind diff leads pnkfelix to think that PR #95794: "parse_tt: a few more tweaks" is the cause of the regression, specifically commit 4ba609601f1a99ddf3cf0cf70f57c4a045f0f23f
* however, that PR went through multiple rounds of performance evaluation.
* in any case, looking at the graph for tt-muncher indicates that whatever performance hit was suffered, it was subsequently resolved by PR #95928.

rustdoc: Reduce allocations in a `markdown` function [#95905](https://github.com/rust-lang/rust/pull/95905) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=52ca603da73ae9eaddf96f77953b33ad8c47cc8e&end=f6cef572d6d75a3b7dea5f496d3bd981986e94ca&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 2 | 4 | 4 | 4 |
| mean | N/A | 1.2% | -0.3% | -0.3% | -0.3% |
| max | N/A | 1.2% | -0.4% | -0.4% | -0.4% |
* the primary regressions were to externs incr-full, debug and opt variants.
* from looking at the graph, there may be a faint upward trend on externs as a whole, but pnkfelix does not think this PR caused any direct regression.

Rollup of 7 pull requests [#95990](https://github.com/rust-lang/rust/pull/95990) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f6cef572d6d75a3b7dea5f496d3bd981986e94ca&end=1491e5cc148391f7679542b8e9b4e6d2430a7b69&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 10 | 8 | 0 | 5 | 10 |
| mean | 0.7% | 9.3% | N/A | -0.8% | 0.7% |
| max | 4.1% | 71.7% | N/A | -1.2% | 4.1% |
* This PR regressed diesel doc by 4.1%, and associated-items doc by 71% (!). Seems important.
* It seems likely that the rustdoc regression is due to PR #95316.
* Left comment on PR #95316; not marking rollup as triaged for now.

Remove NodeIdHashingMode. [#95656](https://github.com/rust-lang/rust/pull/95656) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e3c43e64eceb00e13b1932229aa9b2d774e6af96&end=f38c5c8e5d76ea9a87fece143425ef7c703c706a&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 103 | 75 | 0 | 8 | 103 |
| mean | 0.6% | 0.7% | N/A | -0.5% | 0.6% |
| max | 1.1% | 1.7% | N/A | -0.8% | 1.1% |
* Already marked as triaged since it addressed significant footgun in incr-comp; see [comment from mw](https://github.com/rust-lang/rust/pull/95656#issuecomment-1097694966)

Rollup of 6 pull requests [#96015](https://github.com/rust-lang/rust/pull/96015) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ab33f71a8be01a93d4d14ee5755beeefe38f1946&end=0d13f6afeba4935499abe0c9a07426c94492c94e&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 6 | 0 | 2 | 0 |
| mean | N/A | 0.7% | N/A | -0.3% | N/A |
| max | N/A | 1.1% | N/A | -0.4% | N/A |
* only secondary regressions, and majority are to ctfe-stress-5 incr-unchanged (on all of check,debug,opt), on the order of 1.1%.
* did local cachegrind run on check build: https://gist.github.com/4be85f17d74ee6bf2c92efcd922a6fc9
* regression seems to be blamed upon `rustc_data_structures::intern::Interned<rustc_middle::mir::interpret::allocation::Allocation> as rustc_data_structures::stable_hasher::HashStable<rustc_query_system::ich::hcx::StableHashingContext>>::hash_stable`
* but nothing in the rollup PR seems like it could possibly have had an impact there.
* the graph of ctfe-stress-5-check does seem like there has been some gradual regression over time, starting around 2022-04-09.
* pnkfelix would not blame that on this rollup PR, though.

Update cargo [#96031](https://github.com/rust-lang/rust/pull/96031) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f9d4d12b6ab97fae8b9a6f607473fe149f38f6bd&end=e371eeb778c293cc85ce396cec5d6372fe1ef8b7&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 3 | 0 | 1 | 0 |
| mean | N/A | 1.1% | N/A | -0.4% | N/A |
| max | N/A | 1.1% | N/A | -0.4% | N/A |
* Regressions are just to secondary benchmarks and pnkfelix thinks benefits of a cargo update outweigh the costs presented here, such as they are.

library: Move `CStr` to libcore, and `CString` to liballoc [#94079](https://github.com/rust-lang/rust/pull/94079) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=69a5ae35fe5bb507ca5987e12392dce5186480b9&end=1e6fe5855a115ef7f17f3e17205fab7340775701&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 1 | 3 | 0 | 2 | 1 |
| mean | 0.8% | 0.9% | N/A | -0.6% | 0.8% |
| max | 0.8% | 1.2% | N/A | -0.7% | 0.8% |
* Report claims this Caused a 0.8% regression on primary benchmark unicode-normalization-0.1.19 (check full).
* I was not able to reproduce the regression locally; all my runs showed an improvement.
* This may be running afoul of rust-lang/rustc-perf#1299

Rollup of 11 pull requests [#96087](https://github.com/rust-lang/rust/pull/96087) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1e6fe5855a115ef7f17f3e17205fab7340775701&end=3f391b84552f210adec7893b50c5da74f9362ae4&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 1 | 1 | 1 | 5 | 2 |
| mean | 0.7% | 0.6% | -0.8% | -0.8% | -0.1% |
| max | 0.7% | 0.6% | -0.8% | -1.1% | -0.8% |
* Report claims this Caused a 0.8% regression on primary benchmark unicode-normalization-0.1.19 (check full).
* This, like other PR's this week, may be running afoul of rust-lang/rustc-perf#1299


Optimize RcInnerPtr::inc_strong()/inc_weak() instruction count [#95224](https://github.com/rust-lang/rust/pull/95224) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3f391b84552f210adec7893b50c5da74f9362ae4&end=bb1a03c4fcbe547168fab128fa39b08d1122a1c2&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 4 | 0 | 1 | 0 |
| mean | N/A | 1.9% | N/A | -0.3% | N/A |
| max | N/A | 3.9% | N/A | -0.3% | N/A |
* The bulk of this regression is attached to secondary benchmark regression-31157 opt (incr-patched: println, incr-full, full), by up to 3.86%
* the [self-profile data](https://perf.rust-lang.org/detailed-query.html?commit=bb1a03c4fcbe547168fab128fa39b08d1122a1c2&base_commit=3f391b84552f210adec7893b50c5da74f9362ae4&benchmark=regression-31157-opt&scenario=incr-patched:%20println) seems to indicate that the bulk of the cost here is spent in LLVM.
* the cachegrind output seconds that: https://gist.github.com/4fa7403ee2e812e7712c5046e9eb4d72
* This PR is motivated by an improvement to the object code itself generated by the compiler. I guess that improvement did not result in a net win for the compiler itself.
* regression-31157 (rust#31157) is encoding a case where we were seeing a 20x slowdown. So we should not be worrying about 2% or 4% performance losses there.

Only check the compiler and standard library before documenting them (take 2) [#95450](https://github.com/rust-lang/rust/pull/95450) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bb1a03c4fcbe547168fab128fa39b08d1122a1c2&end=27490eb4232ceebc4f5e1e11b529b55994cf0333&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 1 | 1 | 0 | 2 | 1 |
| mean | 0.9% | 0.4% | N/A | -1.2% | 0.9% |
| max | 0.9% | 0.4% | N/A | -1.2% | 0.9% |
* hypothesized to be noise and pnkfelix doesn't have time to dig more deeply.
* left comment, marked as triaged.

Better method call error messages [#92364](https://github.com/rust-lang/rust/pull/92364) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=080d5452e1bb6e18e12a073d4d0283fd9b6dac0b&end=07bb916d44a66d2caba427c7ee132bbeb245977b&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 4 | 3 | 0 | 3 |
| mean | N/A | 0.8% | -1.1% | N/A | -1.1% |
| max | N/A | 1.2% | -1.5% | N/A | -1.5% |
* The main regression here was to externs, but as previously noted, there's a lot of historical noise in the data for externs, and not trustworthy.

Rollup of 9 pull requests [#96108](https://github.com/rust-lang/rust/pull/96108) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=07bb916d44a66d2caba427c7ee132bbeb245977b&end=c8422403f775126c40d558838d321c063554c822&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 3 | 0 | 2 | 0 |
| mean | N/A | 1.1% | N/A | -0.5% | N/A |
| max | N/A | 1.1% | N/A | -0.7% | N/A |
* This observed 1% regression on ctfe-stress-5.
* Much like PR #96015, I do not think I would put individual blame on this rollup PR for the problems we may be seeing over time in ctfe-stress-5.

Rollup of 7 pull requests [#96117](https://github.com/rust-lang/rust/pull/96117) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=febce1fc316f5618d5bb8f05d19e2e3ba868c007&end=d9b3ff7d34335c5bc0b2afed640b65d64a85fe03&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 3 | 0 | 1 | 0 |
| mean | N/A | 1.1% | N/A | -0.4% | N/A |
| max | N/A | 1.1% | N/A | -0.4% | N/A |
* This observed 1% regression on ctfe-stress-5.
* Much like PR #96015 and PR #96108, I do not think I would put individual blame on this rollup PR for the problems we may be seeing over time in ctfe-stress-5.


rustc_metadata: Do not encode unnecessary module children [#95899](https://github.com/rust-lang/rust/pull/95899) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=878c7833f6c1ff10e2fd89074e5bd4ef5ff15936&end=563ef23529ae800b2b136cabdc71a81d86a75f58&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 4 | 0 | 10 | 0 |
| mean | N/A | 0.9% | N/A | -0.7% | N/A |
| max | N/A | 1.1% | N/A | -1.4% | N/A |
* This observed 1% regression on ctfe-stress-5.
* Much like PR #96015, #96108, and #96117, I do not think I would put individual blame on this PR for the problems we may be seeing over time in ctfe-stress-5.


Implement `core::ptr::Unique` on top of `NonNull` [#96010](https://github.com/rust-lang/rust/pull/96010) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=43a71dc732af0f7cc5895cca8d001184c252426a&end=ac8b11810f4a0def3596ee401feb9ef00015b555&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 20 | 10 | 0 | 6 | 20 |
| mean | 0.6% | 1.3% | N/A | -0.4% | 0.6% |
| max | 1.2% | 2.5% | N/A | -0.5% | 1.2% |
* This seems like it introduced a regression into the compilation times for a lot of important crates.
* I'm not clear on what its buying us, it seems like internal code cleanup? That doesn't justify a >=1% compile-time regression to webrender and syn.

Refactor HIR item-like traversal (part 1) [#95655](https://github.com/rust-lang/rust/pull/95655) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ac8b11810f4a0def3596ee401feb9ef00015b555&end=edba28277038f24ee80b88b66e054ec33facefa4&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 33 | 32 | 0 | 3 | 33 |
| mean | 0.3% | 0.7% | N/A | -1.0% | 0.3% |
| max | 0.4% | 1.6% | N/A | -1.0% | 0.4% |
* This is an expected regression and has already been marked as triaged.

Remove last vestiges of skippng ident span hashing [#96016](https://github.com/rust-lang/rust/pull/96016) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=edba28277038f24ee80b88b66e054ec33facefa4&end=af68f7182e11de7eced78078313e9ba0436db84e&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 1 | 0 | 0 | 7 | 1 |
| mean | 2.6% | N/A | N/A | -0.4% | 2.6% |
| max | 2.6% | N/A | N/A | -0.5% | 2.6% |
* This was already marked as triaged, but at the time it was marked, the only regressions were to secondary benchmarks.
* The version that landed flagged a 2.6% regression to primary benchmark syn-1.0.89
* (self-profile says its due to extra time spent in LLVM).
* anyway the historical data makes me think this is just noise.

Report undeclared lifetimes during late resolution. [#95779](https://github.com/rust-lang/rust/pull/95779) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=af68f7182e11de7eced78078313e9ba0436db84e&end=1ec2c136b35bd4660cba778346f8df7daf2ab173&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 58 | 39 | 1 | 2 | 59 |
| mean | 0.5% | 0.5% | -2.5% | -1.0% | 0.5% |
| max | 0.8% | 1.1% | -2.5% | -1.0% | -2.5% |
* These performance regressions were anticipated (via measurement) during review of the PR and effectively already triaged.


Fix rustdoc duplicated blanket impls [#96091](https://github.com/rust-lang/rust/pull/96091) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1ec2c136b35bd4660cba778346f8df7daf2ab173&end=ad4e98ed7dc535d161886b17f7792501baa82c9b&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 3 | 0 | 3 | 0 |
| mean | N/A | 1.1% | N/A | -1.1% | N/A |
| max | N/A | 1.2% | N/A | -1.1% | N/A |
* The main hit is to externs, which I'm rejecting as ignorable this week due to extant noise.

Revert: Make TLS __getit #[inline(always)] on non-Windows [#96139](https://github.com/rust-lang/rust/pull/96139) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ad4e98ed7dc535d161886b17f7792501baa82c9b&end=ec77f252434a532fdb5699ae4f21a3072d211edd&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 1 | 3 | 0 | 1 | 1 |
| mean | 3.3% | 1.1% | N/A | -0.7% | 3.3% |
| max | 3.3% | 1.1% | N/A | -0.7% | 3.3% |
* Unfortunately this injected a 3.3% hit to syn-1.0.89, ...
* ... but it is also fixing a beta-regression, which takes priority here.
* anyway its already marked as triaged by simulacrum.

Make `x test --stage 2 compiler/rustc_XXX` faster to run [#96000](https://github.com/rust-lang/rust/pull/96000) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7b5408d3fbfc4bcb7c5b2b2f08369156406dc03b&end=74582acd3b49c0f44d53cfafa20d26595a1ae278&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 1 | 0 | 0 | 1 | 1 |
| mean | 1.5% | N/A | N/A | -0.7% | 1.5% |
| max | 1.5% | N/A | N/A | -0.7% | 1.5% |
* This was flagged as injecting a 1.5% regression on syn-1.0.89.
* It seems like syn-1.0.89 opt full suddenly became much noisier around 2022-04-17, and I do not know why.

Micro-optimize `ty::relate::relate_substs` by avoiding `match` [#96020](https://github.com/rust-lang/rust/pull/96020) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e2661bac6d8ae6b9e2a26cd08e9c087ab59e1357&end=c102c5cfc60203c82460bdde2eecd19ccd8c125b&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 6 | 0 | 8 | 0 |
| mean | N/A | 1.8% | N/A | -0.6% | N/A |
| max | N/A | 2.3% | N/A | -1.2% | N/A |
* Already triaged by nnethercote.

Rollup of 6 pull requests [#96214](https://github.com/rust-lang/rust/pull/96214) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c102c5cfc60203c82460bdde2eecd19ccd8c125b&end=4ca19e09d302a4cbde14f9cb1bc109179dc824cd&stat=instructions:u)
| | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:---:|:---:|:---:|:---:|:---:|:---:|
| count | 0 | 5 | 1 | 1 | 1 |
| mean | N/A | 0.9% | -0.2% | -0.2% | -0.2% |
| max | N/A | 1.5% | -0.2% | -0.2% | -0.2% |
* regressed deeply-nested-multi incr-unchanged by 1% to 1.5%.
* the bulk of the regression here seems to already be blamable on PR #96020. Why is this rollup PR getting flagged separately? (filed a bug against rustc-perf for this.)

#### Untriaged Pull Requests

- [#96178 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/96178)
- [#96123 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/96123)
- [#96117 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/96117)
- [#96108 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/96108)
- [#96091 Fix rustdoc duplicated blanket impls](https://github.com/rust-lang/rust/pull/96091)
- [#96087 Rollup of 11 pull requests](https://github.com/rust-lang/rust/pull/96087)
- [#96031 Update cargo](https://github.com/rust-lang/rust/pull/96031)
- [#96020 Micro-optimize `ty::relate::relate_substs` by avoiding `match`](https://github.com/rust-lang/rust/pull/96020)
- [#96015 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/96015)
- [#96010 Implement `core::ptr::Unique` on top of `NonNull`](https://github.com/rust-lang/rust/pull/96010)
- [#96000 Make `x test --stage 2 compiler/rustc_XXX` faster to run](https://github.com/rust-lang/rust/pull/96000)
- [#95999 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/95999)
- [#95990 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/95990)
- [#95987 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/95987)
- [#95966 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/95966)
- [#95958 Update stdarch](https://github.com/rust-lang/rust/pull/95958)
- [#95899 rustc_metadata: Do not encode unnecessary module children](https://github.com/rust-lang/rust/pull/95899)
- [#95893 Respect -Z verify-llvm-ir and other flags that add extra passes when combined with -C no-prepopulate-passes in the new LLVM Pass Manager.](https://github.com/rust-lang/rust/pull/95893)
- [#95835 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/95835)
- [#95794 `parse_tt`: a few more tweaks](https://github.com/rust-lang/rust/pull/95794)
- [#95779 Report undeclared lifetimes during late resolution.](https://github.com/rust-lang/rust/pull/95779)
- [#95742 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/95742)
- [#95715 Shrink `Nonterminal`](https://github.com/rust-lang/rust/pull/95715)
- [#95706 rustdoc: Early doc link resolution fixes and refactorings](https://github.com/rust-lang/rust/pull/95706)
- [#95702 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/95702)
- [#95667 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/95667)
- [#95662 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/95662)
- [#95645 Fix intra doc link ICE when trying to get traits in scope for primitive](https://github.com/rust-lang/rust/pull/95645)
- [#95450 Only check the compiler and standard library before documenting them (take 2)](https://github.com/rust-lang/rust/pull/95450)
- [#95399 Faster parsing for lower numbers for radix up to 16 (cont.)](https://github.com/rust-lang/rust/pull/95399)
