/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/

#ifndef CHANGEGROUPINTELDIALOG_H
#define CHANGEGROUPINTELDIALOG_H

#include <QDialog>
#include <QPainter>
#include <QPainterPath>
#include <QListWidget>
#include <QDebug>

#include "hoverwidget.h"

//struct custom_struct
//{
//    QString groupname;
//    QString passphrase;
//    QString groupid;
//    QString usergroup;
//};

namespace Ui {
class ChangeGroupIntelDialog;
}

class ChangeGroupIntelDialog : public QDialog
{
    Q_OBJECT

public:
    explicit ChangeGroupIntelDialog(QWidget *parent = nullptr);
    ~ChangeGroupIntelDialog();

public:
    void initGeneralItemsStyle();
    void initItemsStyle(QListWidget * listWidget);
    void initNewGroupBtn();
    void loadGroupInfo();
    void showCreateGroupDialog();

protected:
    void paintEvent(QPaintEvent * event);

private:
    Ui::ChangeGroupIntelDialog *ui;

    HoverWidget *addWgt;
    //QList<custom_struct *>  *value;

    void setupInit();
    void signalsBind();


};

#endif // CHANGEGROUPINTELDIALOG_H
