// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_ASSEMBLER_COND_RD_RN_OPERAND_RM_SHIFT_RS_SBC_A32_H_
#define VIXL_ASSEMBLER_COND_RD_RN_OPERAND_RM_SHIFT_RS_SBC_A32_H_

const byte kInstruction_sbc_mi_r8_r10_r8_LSL_r0[] = {
  0x18, 0x80, 0xca, 0x40 // sbc mi r8 r10 r8 LSL r0
};
const byte kInstruction_sbc_cc_r11_r4_r13_ROR_r8[] = {
  0x7d, 0xb8, 0xc4, 0x30 // sbc cc r11 r4 r13 ROR r8
};
const byte kInstruction_sbc_al_r13_r11_r3_ROR_r4[] = {
  0x73, 0xd4, 0xcb, 0xe0 // sbc al r13 r11 r3 ROR r4
};
const byte kInstruction_sbc_gt_r11_r5_r4_LSR_r11[] = {
  0x34, 0xbb, 0xc5, 0xc0 // sbc gt r11 r5 r4 LSR r11
};
const byte kInstruction_sbc_vs_r12_r0_r8_ROR_r13[] = {
  0x78, 0xcd, 0xc0, 0x60 // sbc vs r12 r0 r8 ROR r13
};
const byte kInstruction_sbc_pl_r10_r12_r5_LSL_r5[] = {
  0x15, 0xa5, 0xcc, 0x50 // sbc pl r10 r12 r5 LSL r5
};
const byte kInstruction_sbc_ls_r10_r2_r2_LSL_r9[] = {
  0x12, 0xa9, 0xc2, 0x90 // sbc ls r10 r2 r2 LSL r9
};
const byte kInstruction_sbc_eq_r12_r7_r9_LSR_r7[] = {
  0x39, 0xc7, 0xc7, 0x00 // sbc eq r12 r7 r9 LSR r7
};
const byte kInstruction_sbc_mi_r3_r13_r0_ROR_r11[] = {
  0x70, 0x3b, 0xcd, 0x40 // sbc mi r3 r13 r0 ROR r11
};
const byte kInstruction_sbc_lt_r9_r0_r9_ASR_r12[] = {
  0x59, 0x9c, 0xc0, 0xb0 // sbc lt r9 r0 r9 ASR r12
};
const byte kInstruction_sbc_le_r12_r8_r14_ROR_r1[] = {
  0x7e, 0xc1, 0xc8, 0xd0 // sbc le r12 r8 r14 ROR r1
};
const byte kInstruction_sbc_cc_r7_r1_r14_LSL_r0[] = {
  0x1e, 0x70, 0xc1, 0x30 // sbc cc r7 r1 r14 LSL r0
};
const byte kInstruction_sbc_le_r11_r13_r3_ROR_r6[] = {
  0x73, 0xb6, 0xcd, 0xd0 // sbc le r11 r13 r3 ROR r6
};
const byte kInstruction_sbc_al_r5_r8_r9_ASR_r14[] = {
  0x59, 0x5e, 0xc8, 0xe0 // sbc al r5 r8 r9 ASR r14
};
const byte kInstruction_sbc_hi_r1_r2_r7_ASR_r13[] = {
  0x57, 0x1d, 0xc2, 0x80 // sbc hi r1 r2 r7 ASR r13
};
const byte kInstruction_sbc_al_r13_r8_r7_LSR_r12[] = {
  0x37, 0xdc, 0xc8, 0xe0 // sbc al r13 r8 r7 LSR r12
};
const byte kInstruction_sbc_vc_r3_r6_r4_ASR_r4[] = {
  0x54, 0x34, 0xc6, 0x70 // sbc vc r3 r6 r4 ASR r4
};
const byte kInstruction_sbc_lt_r12_r4_r6_LSL_r5[] = {
  0x16, 0xc5, 0xc4, 0xb0 // sbc lt r12 r4 r6 LSL r5
};
const byte kInstruction_sbc_ls_r13_r5_r11_ROR_r8[] = {
  0x7b, 0xd8, 0xc5, 0x90 // sbc ls r13 r5 r11 ROR r8
};
const byte kInstruction_sbc_vc_r11_r10_r11_LSL_r9[] = {
  0x1b, 0xb9, 0xca, 0x70 // sbc vc r11 r10 r11 LSL r9
};
const byte kInstruction_sbc_al_r13_r14_r10_LSR_r4[] = {
  0x3a, 0xd4, 0xce, 0xe0 // sbc al r13 r14 r10 LSR r4
};
const byte kInstruction_sbc_ge_r12_r13_r6_ASR_r12[] = {
  0x56, 0xcc, 0xcd, 0xa0 // sbc ge r12 r13 r6 ASR r12
};
const byte kInstruction_sbc_ne_r14_r6_r12_ROR_r0[] = {
  0x7c, 0xe0, 0xc6, 0x10 // sbc ne r14 r6 r12 ROR r0
};
const byte kInstruction_sbc_ls_r13_r14_r14_ASR_r13[] = {
  0x5e, 0xdd, 0xce, 0x90 // sbc ls r13 r14 r14 ASR r13
};
const byte kInstruction_sbc_lt_r10_r13_r7_ROR_r8[] = {
  0x77, 0xa8, 0xcd, 0xb0 // sbc lt r10 r13 r7 ROR r8
};
const byte kInstruction_sbc_lt_r8_r8_r9_ASR_r0[] = {
  0x59, 0x80, 0xc8, 0xb0 // sbc lt r8 r8 r9 ASR r0
};
const byte kInstruction_sbc_ne_r7_r5_r4_LSR_r8[] = {
  0x34, 0x78, 0xc5, 0x10 // sbc ne r7 r5 r4 LSR r8
};
const byte kInstruction_sbc_mi_r11_r5_r1_LSL_r13[] = {
  0x11, 0xbd, 0xc5, 0x40 // sbc mi r11 r5 r1 LSL r13
};
const byte kInstruction_sbc_ge_r14_r1_r2_LSL_r1[] = {
  0x12, 0xe1, 0xc1, 0xa0 // sbc ge r14 r1 r2 LSL r1
};
const byte kInstruction_sbc_ls_r6_r11_r4_ASR_r11[] = {
  0x54, 0x6b, 0xcb, 0x90 // sbc ls r6 r11 r4 ASR r11
};
const byte kInstruction_sbc_hi_r11_r12_r4_LSR_r13[] = {
  0x34, 0xbd, 0xcc, 0x80 // sbc hi r11 r12 r4 LSR r13
};
const byte kInstruction_sbc_le_r9_r3_r0_LSL_r7[] = {
  0x10, 0x97, 0xc3, 0xd0 // sbc le r9 r3 r0 LSL r7
};
const byte kInstruction_sbc_ls_r8_r7_r4_ASR_r3[] = {
  0x54, 0x83, 0xc7, 0x90 // sbc ls r8 r7 r4 ASR r3
};
const byte kInstruction_sbc_pl_r9_r13_r11_LSL_r7[] = {
  0x1b, 0x97, 0xcd, 0x50 // sbc pl r9 r13 r11 LSL r7
};
const byte kInstruction_sbc_eq_r12_r7_r11_ASR_r3[] = {
  0x5b, 0xc3, 0xc7, 0x00 // sbc eq r12 r7 r11 ASR r3
};
const byte kInstruction_sbc_mi_r3_r9_r13_ROR_r10[] = {
  0x7d, 0x3a, 0xc9, 0x40 // sbc mi r3 r9 r13 ROR r10
};
const byte kInstruction_sbc_mi_r14_r8_r10_ROR_r10[] = {
  0x7a, 0xea, 0xc8, 0x40 // sbc mi r14 r8 r10 ROR r10
};
const byte kInstruction_sbc_lt_r5_r3_r5_LSL_r1[] = {
  0x15, 0x51, 0xc3, 0xb0 // sbc lt r5 r3 r5 LSL r1
};
const byte kInstruction_sbc_ne_r12_r6_r1_LSL_r7[] = {
  0x11, 0xc7, 0xc6, 0x10 // sbc ne r12 r6 r1 LSL r7
};
const byte kInstruction_sbc_lt_r3_r6_r5_ASR_r1[] = {
  0x55, 0x31, 0xc6, 0xb0 // sbc lt r3 r6 r5 ASR r1
};
const byte kInstruction_sbc_lt_r14_r0_r0_LSR_r11[] = {
  0x30, 0xeb, 0xc0, 0xb0 // sbc lt r14 r0 r0 LSR r11
};
const byte kInstruction_sbc_eq_r11_r10_r4_LSL_r14[] = {
  0x14, 0xbe, 0xca, 0x00 // sbc eq r11 r10 r4 LSL r14
};
const byte kInstruction_sbc_lt_r2_r14_r11_LSL_r9[] = {
  0x1b, 0x29, 0xce, 0xb0 // sbc lt r2 r14 r11 LSL r9
};
const byte kInstruction_sbc_mi_r0_r6_r14_ASR_r11[] = {
  0x5e, 0x0b, 0xc6, 0x40 // sbc mi r0 r6 r14 ASR r11
};
const byte kInstruction_sbc_le_r4_r6_r3_LSR_r11[] = {
  0x33, 0x4b, 0xc6, 0xd0 // sbc le r4 r6 r3 LSR r11
};
const byte kInstruction_sbc_cs_r2_r6_r1_ROR_r5[] = {
  0x71, 0x25, 0xc6, 0x20 // sbc cs r2 r6 r1 ROR r5
};
const byte kInstruction_sbc_ne_r10_r9_r10_ROR_r4[] = {
  0x7a, 0xa4, 0xc9, 0x10 // sbc ne r10 r9 r10 ROR r4
};
const byte kInstruction_sbc_pl_r7_r9_r11_LSR_r14[] = {
  0x3b, 0x7e, 0xc9, 0x50 // sbc pl r7 r9 r11 LSR r14
};
const byte kInstruction_sbc_pl_r11_r8_r3_ASR_r5[] = {
  0x53, 0xb5, 0xc8, 0x50 // sbc pl r11 r8 r3 ASR r5
};
const byte kInstruction_sbc_le_r10_r4_r10_ROR_r8[] = {
  0x7a, 0xa8, 0xc4, 0xd0 // sbc le r10 r4 r10 ROR r8
};
const byte kInstruction_sbc_ne_r8_r14_r8_LSL_r5[] = {
  0x18, 0x85, 0xce, 0x10 // sbc ne r8 r14 r8 LSL r5
};
const byte kInstruction_sbc_eq_r12_r5_r2_LSL_r11[] = {
  0x12, 0xcb, 0xc5, 0x00 // sbc eq r12 r5 r2 LSL r11
};
const byte kInstruction_sbc_pl_r9_r9_r8_ASR_r2[] = {
  0x58, 0x92, 0xc9, 0x50 // sbc pl r9 r9 r8 ASR r2
};
const byte kInstruction_sbc_hi_r8_r12_r3_LSL_r5[] = {
  0x13, 0x85, 0xcc, 0x80 // sbc hi r8 r12 r3 LSL r5
};
const byte kInstruction_sbc_eq_r6_r5_r9_LSL_r3[] = {
  0x19, 0x63, 0xc5, 0x00 // sbc eq r6 r5 r9 LSL r3
};
const byte kInstruction_sbc_lt_r5_r1_r9_LSR_r6[] = {
  0x39, 0x56, 0xc1, 0xb0 // sbc lt r5 r1 r9 LSR r6
};
const byte kInstruction_sbc_hi_r9_r9_r0_LSL_r5[] = {
  0x10, 0x95, 0xc9, 0x80 // sbc hi r9 r9 r0 LSL r5
};
const byte kInstruction_sbc_cs_r6_r6_r5_LSL_r8[] = {
  0x15, 0x68, 0xc6, 0x20 // sbc cs r6 r6 r5 LSL r8
};
const byte kInstruction_sbc_cs_r0_r1_r6_LSR_r12[] = {
  0x36, 0x0c, 0xc1, 0x20 // sbc cs r0 r1 r6 LSR r12
};
const byte kInstruction_sbc_cc_r4_r6_r13_ASR_r6[] = {
  0x5d, 0x46, 0xc6, 0x30 // sbc cc r4 r6 r13 ASR r6
};
const byte kInstruction_sbc_hi_r11_r8_r10_LSR_r5[] = {
  0x3a, 0xb5, 0xc8, 0x80 // sbc hi r11 r8 r10 LSR r5
};
const byte kInstruction_sbc_ls_r8_r1_r14_ROR_r14[] = {
  0x7e, 0x8e, 0xc1, 0x90 // sbc ls r8 r1 r14 ROR r14
};
const byte kInstruction_sbc_pl_r8_r2_r12_ASR_r7[] = {
  0x5c, 0x87, 0xc2, 0x50 // sbc pl r8 r2 r12 ASR r7
};
const byte kInstruction_sbc_gt_r14_r7_r5_ROR_r11[] = {
  0x75, 0xeb, 0xc7, 0xc0 // sbc gt r14 r7 r5 ROR r11
};
const byte kInstruction_sbc_eq_r3_r6_r13_ROR_r0[] = {
  0x7d, 0x30, 0xc6, 0x00 // sbc eq r3 r6 r13 ROR r0
};
const byte kInstruction_sbc_le_r4_r8_r8_ROR_r11[] = {
  0x78, 0x4b, 0xc8, 0xd0 // sbc le r4 r8 r8 ROR r11
};
const byte kInstruction_sbc_ge_r2_r7_r5_ASR_r6[] = {
  0x55, 0x26, 0xc7, 0xa0 // sbc ge r2 r7 r5 ASR r6
};
const byte kInstruction_sbc_cc_r8_r12_r5_LSL_r11[] = {
  0x15, 0x8b, 0xcc, 0x30 // sbc cc r8 r12 r5 LSL r11
};
const byte kInstruction_sbc_vc_r11_r10_r3_ROR_r5[] = {
  0x73, 0xb5, 0xca, 0x70 // sbc vc r11 r10 r3 ROR r5
};
const byte kInstruction_sbc_vc_r11_r9_r11_LSL_r6[] = {
  0x1b, 0xb6, 0xc9, 0x70 // sbc vc r11 r9 r11 LSL r6
};
const byte kInstruction_sbc_lt_r6_r5_r0_ROR_r9[] = {
  0x70, 0x69, 0xc5, 0xb0 // sbc lt r6 r5 r0 ROR r9
};
const byte kInstruction_sbc_cs_r13_r7_r11_ASR_r9[] = {
  0x5b, 0xd9, 0xc7, 0x20 // sbc cs r13 r7 r11 ASR r9
};
const byte kInstruction_sbc_cs_r9_r7_r9_ROR_r11[] = {
  0x79, 0x9b, 0xc7, 0x20 // sbc cs r9 r7 r9 ROR r11
};
const byte kInstruction_sbc_ls_r14_r3_r2_ASR_r11[] = {
  0x52, 0xeb, 0xc3, 0x90 // sbc ls r14 r3 r2 ASR r11
};
const byte kInstruction_sbc_vc_r0_r1_r1_LSR_r0[] = {
  0x31, 0x00, 0xc1, 0x70 // sbc vc r0 r1 r1 LSR r0
};
const byte kInstruction_sbc_mi_r10_r8_r8_LSR_r13[] = {
  0x38, 0xad, 0xc8, 0x40 // sbc mi r10 r8 r8 LSR r13
};
const byte kInstruction_sbc_pl_r8_r14_r3_LSL_r8[] = {
  0x13, 0x88, 0xce, 0x50 // sbc pl r8 r14 r3 LSL r8
};
const byte kInstruction_sbc_ne_r6_r4_r1_LSL_r12[] = {
  0x11, 0x6c, 0xc4, 0x10 // sbc ne r6 r4 r1 LSL r12
};
const byte kInstruction_sbc_lt_r2_r2_r7_ROR_r0[] = {
  0x77, 0x20, 0xc2, 0xb0 // sbc lt r2 r2 r7 ROR r0
};
const byte kInstruction_sbc_lt_r2_r4_r13_ASR_r5[] = {
  0x5d, 0x25, 0xc4, 0xb0 // sbc lt r2 r4 r13 ASR r5
};
const byte kInstruction_sbc_eq_r8_r1_r2_ROR_r13[] = {
  0x72, 0x8d, 0xc1, 0x00 // sbc eq r8 r1 r2 ROR r13
};
const byte kInstruction_sbc_lt_r1_r8_r10_LSR_r7[] = {
  0x3a, 0x17, 0xc8, 0xb0 // sbc lt r1 r8 r10 LSR r7
};
const byte kInstruction_sbc_cs_r7_r5_r9_LSL_r9[] = {
  0x19, 0x79, 0xc5, 0x20 // sbc cs r7 r5 r9 LSL r9
};
const byte kInstruction_sbc_mi_r8_r0_r6_LSL_r8[] = {
  0x16, 0x88, 0xc0, 0x40 // sbc mi r8 r0 r6 LSL r8
};
const byte kInstruction_sbc_cs_r7_r12_r3_ROR_r6[] = {
  0x73, 0x76, 0xcc, 0x20 // sbc cs r7 r12 r3 ROR r6
};
const byte kInstruction_sbc_vs_r13_r8_r13_LSR_r4[] = {
  0x3d, 0xd4, 0xc8, 0x60 // sbc vs r13 r8 r13 LSR r4
};
const byte kInstruction_sbc_cc_r4_r13_r7_ROR_r11[] = {
  0x77, 0x4b, 0xcd, 0x30 // sbc cc r4 r13 r7 ROR r11
};
const byte kInstruction_sbc_ge_r10_r5_r9_LSR_r13[] = {
  0x39, 0xad, 0xc5, 0xa0 // sbc ge r10 r5 r9 LSR r13
};
const byte kInstruction_sbc_cc_r0_r5_r9_ASR_r4[] = {
  0x59, 0x04, 0xc5, 0x30 // sbc cc r0 r5 r9 ASR r4
};
const byte kInstruction_sbc_cc_r1_r5_r8_LSR_r12[] = {
  0x38, 0x1c, 0xc5, 0x30 // sbc cc r1 r5 r8 LSR r12
};
const byte kInstruction_sbc_ls_r12_r3_r5_LSL_r6[] = {
  0x15, 0xc6, 0xc3, 0x90 // sbc ls r12 r3 r5 LSL r6
};
const byte kInstruction_sbc_cs_r10_r0_r4_ASR_r7[] = {
  0x54, 0xa7, 0xc0, 0x20 // sbc cs r10 r0 r4 ASR r7
};
const byte kInstruction_sbc_ge_r10_r13_r14_ROR_r6[] = {
  0x7e, 0xa6, 0xcd, 0xa0 // sbc ge r10 r13 r14 ROR r6
};
const byte kInstruction_sbc_al_r9_r0_r9_ROR_r3[] = {
  0x79, 0x93, 0xc0, 0xe0 // sbc al r9 r0 r9 ROR r3
};
const byte kInstruction_sbc_vs_r4_r5_r12_ASR_r6[] = {
  0x5c, 0x46, 0xc5, 0x60 // sbc vs r4 r5 r12 ASR r6
};
const byte kInstruction_sbc_lt_r4_r1_r14_LSL_r12[] = {
  0x1e, 0x4c, 0xc1, 0xb0 // sbc lt r4 r1 r14 LSL r12
};
const byte kInstruction_sbc_cs_r14_r11_r8_ROR_r4[] = {
  0x78, 0xe4, 0xcb, 0x20 // sbc cs r14 r11 r8 ROR r4
};
const byte kInstruction_sbc_hi_r12_r0_r14_LSR_r11[] = {
  0x3e, 0xcb, 0xc0, 0x80 // sbc hi r12 r0 r14 LSR r11
};
const byte kInstruction_sbc_le_r8_r6_r4_ASR_r7[] = {
  0x54, 0x87, 0xc6, 0xd0 // sbc le r8 r6 r4 ASR r7
};
const byte kInstruction_sbc_mi_r13_r4_r14_LSR_r10[] = {
  0x3e, 0xda, 0xc4, 0x40 // sbc mi r13 r4 r14 LSR r10
};
const byte kInstruction_sbc_vs_r11_r10_r5_LSL_r10[] = {
  0x15, 0xba, 0xca, 0x60 // sbc vs r11 r10 r5 LSL r10
};
const byte kInstruction_sbc_cc_r4_r0_r5_LSR_r2[] = {
  0x35, 0x42, 0xc0, 0x30 // sbc cc r4 r0 r5 LSR r2
};
const byte kInstruction_sbc_pl_r9_r14_r0_LSL_r3[] = {
  0x10, 0x93, 0xce, 0x50 // sbc pl r9 r14 r0 LSL r3
};
const byte kInstruction_sbc_vc_r7_r2_r14_ASR_r1[] = {
  0x5e, 0x71, 0xc2, 0x70 // sbc vc r7 r2 r14 ASR r1
};
const byte kInstruction_sbc_gt_r4_r14_r1_ROR_r10[] = {
  0x71, 0x4a, 0xce, 0xc0 // sbc gt r4 r14 r1 ROR r10
};
const byte kInstruction_sbc_lt_r6_r4_r10_LSL_r7[] = {
  0x1a, 0x67, 0xc4, 0xb0 // sbc lt r6 r4 r10 LSL r7
};
const byte kInstruction_sbc_hi_r1_r14_r5_LSL_r12[] = {
  0x15, 0x1c, 0xce, 0x80 // sbc hi r1 r14 r5 LSL r12
};
const byte kInstruction_sbc_cc_r14_r12_r4_ASR_r14[] = {
  0x54, 0xee, 0xcc, 0x30 // sbc cc r14 r12 r4 ASR r14
};
const byte kInstruction_sbc_cc_r0_r8_r5_ROR_r8[] = {
  0x75, 0x08, 0xc8, 0x30 // sbc cc r0 r8 r5 ROR r8
};
const byte kInstruction_sbc_gt_r9_r9_r0_ASR_r4[] = {
  0x50, 0x94, 0xc9, 0xc0 // sbc gt r9 r9 r0 ASR r4
};
const byte kInstruction_sbc_mi_r8_r11_r12_ASR_r4[] = {
  0x5c, 0x84, 0xcb, 0x40 // sbc mi r8 r11 r12 ASR r4
};
const byte kInstruction_sbc_vs_r0_r12_r0_LSR_r11[] = {
  0x30, 0x0b, 0xcc, 0x60 // sbc vs r0 r12 r0 LSR r11
};
const byte kInstruction_sbc_ge_r0_r9_r1_ASR_r0[] = {
  0x51, 0x00, 0xc9, 0xa0 // sbc ge r0 r9 r1 ASR r0
};
const byte kInstruction_sbc_al_r10_r11_r5_LSR_r4[] = {
  0x35, 0xa4, 0xcb, 0xe0 // sbc al r10 r11 r5 LSR r4
};
const byte kInstruction_sbc_eq_r0_r6_r8_LSR_r10[] = {
  0x38, 0x0a, 0xc6, 0x00 // sbc eq r0 r6 r8 LSR r10
};
const byte kInstruction_sbc_cc_r13_r12_r14_ROR_r9[] = {
  0x7e, 0xd9, 0xcc, 0x30 // sbc cc r13 r12 r14 ROR r9
};
const byte kInstruction_sbc_ls_r4_r11_r0_LSL_r14[] = {
  0x10, 0x4e, 0xcb, 0x90 // sbc ls r4 r11 r0 LSL r14
};
const byte kInstruction_sbc_hi_r1_r6_r12_LSR_r13[] = {
  0x3c, 0x1d, 0xc6, 0x80 // sbc hi r1 r6 r12 LSR r13
};
const byte kInstruction_sbc_cs_r7_r11_r1_ASR_r5[] = {
  0x51, 0x75, 0xcb, 0x20 // sbc cs r7 r11 r1 ASR r5
};
const byte kInstruction_sbc_cc_r7_r5_r4_ASR_r11[] = {
  0x54, 0x7b, 0xc5, 0x30 // sbc cc r7 r5 r4 ASR r11
};
const byte kInstruction_sbc_hi_r7_r2_r5_ROR_r5[] = {
  0x75, 0x75, 0xc2, 0x80 // sbc hi r7 r2 r5 ROR r5
};
const byte kInstruction_sbc_vc_r11_r9_r7_LSL_r14[] = {
  0x17, 0xbe, 0xc9, 0x70 // sbc vc r11 r9 r7 LSL r14
};
const byte kInstruction_sbc_le_r12_r1_r3_ROR_r7[] = {
  0x73, 0xc7, 0xc1, 0xd0 // sbc le r12 r1 r3 ROR r7
};
const byte kInstruction_sbc_al_r8_r14_r0_ASR_r12[] = {
  0x50, 0x8c, 0xce, 0xe0 // sbc al r8 r14 r0 ASR r12
};
const byte kInstruction_sbc_vc_r14_r3_r0_ROR_r1[] = {
  0x70, 0xe1, 0xc3, 0x70 // sbc vc r14 r3 r0 ROR r1
};
const byte kInstruction_sbc_pl_r10_r8_r3_ROR_r4[] = {
  0x73, 0xa4, 0xc8, 0x50 // sbc pl r10 r8 r3 ROR r4
};
const byte kInstruction_sbc_al_r9_r14_r12_LSL_r4[] = {
  0x1c, 0x94, 0xce, 0xe0 // sbc al r9 r14 r12 LSL r4
};
const byte kInstruction_sbc_vs_r8_r3_r14_ASR_r7[] = {
  0x5e, 0x87, 0xc3, 0x60 // sbc vs r8 r3 r14 ASR r7
};
const byte kInstruction_sbc_hi_r4_r8_r13_LSL_r1[] = {
  0x1d, 0x41, 0xc8, 0x80 // sbc hi r4 r8 r13 LSL r1
};
const byte kInstruction_sbc_al_r6_r11_r11_LSL_r14[] = {
  0x1b, 0x6e, 0xcb, 0xe0 // sbc al r6 r11 r11 LSL r14
};
const byte kInstruction_sbc_al_r7_r2_r4_LSR_r1[] = {
  0x34, 0x71, 0xc2, 0xe0 // sbc al r7 r2 r4 LSR r1
};
const byte kInstruction_sbc_vc_r5_r10_r3_ASR_r8[] = {
  0x53, 0x58, 0xca, 0x70 // sbc vc r5 r10 r3 ASR r8
};
const byte kInstruction_sbc_cc_r3_r10_r9_ROR_r11[] = {
  0x79, 0x3b, 0xca, 0x30 // sbc cc r3 r10 r9 ROR r11
};
const byte kInstruction_sbc_eq_r11_r9_r8_LSL_r2[] = {
  0x18, 0xb2, 0xc9, 0x00 // sbc eq r11 r9 r8 LSL r2
};
const byte kInstruction_sbc_mi_r6_r9_r5_ASR_r12[] = {
  0x55, 0x6c, 0xc9, 0x40 // sbc mi r6 r9 r5 ASR r12
};
const byte kInstruction_sbc_hi_r6_r6_r0_ASR_r9[] = {
  0x50, 0x69, 0xc6, 0x80 // sbc hi r6 r6 r0 ASR r9
};
const byte kInstruction_sbc_ge_r12_r13_r1_LSL_r9[] = {
  0x11, 0xc9, 0xcd, 0xa0 // sbc ge r12 r13 r1 LSL r9
};
const byte kInstruction_sbc_le_r4_r9_r14_ASR_r2[] = {
  0x5e, 0x42, 0xc9, 0xd0 // sbc le r4 r9 r14 ASR r2
};
const byte kInstruction_sbc_gt_r5_r3_r9_ROR_r5[] = {
  0x79, 0x55, 0xc3, 0xc0 // sbc gt r5 r3 r9 ROR r5
};
const byte kInstruction_sbc_al_r14_r5_r13_ROR_r7[] = {
  0x7d, 0xe7, 0xc5, 0xe0 // sbc al r14 r5 r13 ROR r7
};
const byte kInstruction_sbc_lt_r2_r1_r14_ASR_r8[] = {
  0x5e, 0x28, 0xc1, 0xb0 // sbc lt r2 r1 r14 ASR r8
};
const byte kInstruction_sbc_al_r12_r7_r8_LSL_r11[] = {
  0x18, 0xcb, 0xc7, 0xe0 // sbc al r12 r7 r8 LSL r11
};
const byte kInstruction_sbc_ne_r4_r12_r14_LSL_r1[] = {
  0x1e, 0x41, 0xcc, 0x10 // sbc ne r4 r12 r14 LSL r1
};
const byte kInstruction_sbc_vs_r7_r14_r4_LSL_r6[] = {
  0x14, 0x76, 0xce, 0x60 // sbc vs r7 r14 r4 LSL r6
};
const byte kInstruction_sbc_ge_r12_r5_r11_ASR_r4[] = {
  0x5b, 0xc4, 0xc5, 0xa0 // sbc ge r12 r5 r11 ASR r4
};
const byte kInstruction_sbc_gt_r4_r10_r6_LSR_r6[] = {
  0x36, 0x46, 0xca, 0xc0 // sbc gt r4 r10 r6 LSR r6
};
const byte kInstruction_sbc_cc_r14_r8_r14_LSR_r8[] = {
  0x3e, 0xe8, 0xc8, 0x30 // sbc cc r14 r8 r14 LSR r8
};
const byte kInstruction_sbc_al_r1_r14_r11_LSR_r7[] = {
  0x3b, 0x17, 0xce, 0xe0 // sbc al r1 r14 r11 LSR r7
};
const byte kInstruction_sbc_pl_r13_r6_r5_ASR_r14[] = {
  0x55, 0xde, 0xc6, 0x50 // sbc pl r13 r6 r5 ASR r14
};
const byte kInstruction_sbc_cc_r10_r6_r9_ROR_r13[] = {
  0x79, 0xad, 0xc6, 0x30 // sbc cc r10 r6 r9 ROR r13
};
const byte kInstruction_sbc_ne_r0_r4_r7_ROR_r13[] = {
  0x77, 0x0d, 0xc4, 0x10 // sbc ne r0 r4 r7 ROR r13
};
const byte kInstruction_sbc_vc_r12_r0_r14_LSL_r13[] = {
  0x1e, 0xcd, 0xc0, 0x70 // sbc vc r12 r0 r14 LSL r13
};
const byte kInstruction_sbc_al_r10_r13_r13_ROR_r5[] = {
  0x7d, 0xa5, 0xcd, 0xe0 // sbc al r10 r13 r13 ROR r5
};
const byte kInstruction_sbc_cs_r10_r3_r0_ROR_r7[] = {
  0x70, 0xa7, 0xc3, 0x20 // sbc cs r10 r3 r0 ROR r7
};
const byte kInstruction_sbc_ge_r10_r14_r14_ROR_r6[] = {
  0x7e, 0xa6, 0xce, 0xa0 // sbc ge r10 r14 r14 ROR r6
};
const byte kInstruction_sbc_pl_r0_r10_r10_LSL_r4[] = {
  0x1a, 0x04, 0xca, 0x50 // sbc pl r0 r10 r10 LSL r4
};
const byte kInstruction_sbc_vs_r1_r2_r7_ASR_r6[] = {
  0x57, 0x16, 0xc2, 0x60 // sbc vs r1 r2 r7 ASR r6
};
const byte kInstruction_sbc_cs_r9_r11_r9_LSL_r9[] = {
  0x19, 0x99, 0xcb, 0x20 // sbc cs r9 r11 r9 LSL r9
};
const byte kInstruction_sbc_eq_r10_r8_r4_LSL_r6[] = {
  0x14, 0xa6, 0xc8, 0x00 // sbc eq r10 r8 r4 LSL r6
};
const byte kInstruction_sbc_vc_r8_r5_r12_LSL_r8[] = {
  0x1c, 0x88, 0xc5, 0x70 // sbc vc r8 r5 r12 LSL r8
};
const byte kInstruction_sbc_pl_r1_r13_r11_LSL_r8[] = {
  0x1b, 0x18, 0xcd, 0x50 // sbc pl r1 r13 r11 LSL r8
};
const byte kInstruction_sbc_le_r9_r10_r5_ROR_r4[] = {
  0x75, 0x94, 0xca, 0xd0 // sbc le r9 r10 r5 ROR r4
};
const byte kInstruction_sbc_vs_r8_r3_r0_ASR_r11[] = {
  0x50, 0x8b, 0xc3, 0x60 // sbc vs r8 r3 r0 ASR r11
};
const byte kInstruction_sbc_hi_r12_r0_r13_LSL_r2[] = {
  0x1d, 0xc2, 0xc0, 0x80 // sbc hi r12 r0 r13 LSL r2
};
const byte kInstruction_sbc_lt_r4_r2_r8_LSL_r5[] = {
  0x18, 0x45, 0xc2, 0xb0 // sbc lt r4 r2 r8 LSL r5
};
const byte kInstruction_sbc_ge_r9_r4_r13_LSL_r13[] = {
  0x1d, 0x9d, 0xc4, 0xa0 // sbc ge r9 r4 r13 LSL r13
};
const byte kInstruction_sbc_ge_r0_r2_r1_ROR_r8[] = {
  0x71, 0x08, 0xc2, 0xa0 // sbc ge r0 r2 r1 ROR r8
};
const byte kInstruction_sbc_le_r6_r13_r9_LSR_r0[] = {
  0x39, 0x60, 0xcd, 0xd0 // sbc le r6 r13 r9 LSR r0
};
const byte kInstruction_sbc_ls_r13_r7_r4_ASR_r3[] = {
  0x54, 0xd3, 0xc7, 0x90 // sbc ls r13 r7 r4 ASR r3
};
const byte kInstruction_sbc_vc_r8_r13_r6_LSR_r14[] = {
  0x36, 0x8e, 0xcd, 0x70 // sbc vc r8 r13 r6 LSR r14
};
const byte kInstruction_sbc_pl_r10_r5_r3_LSR_r9[] = {
  0x33, 0xa9, 0xc5, 0x50 // sbc pl r10 r5 r3 LSR r9
};
const byte kInstruction_sbc_al_r6_r3_r14_LSR_r7[] = {
  0x3e, 0x67, 0xc3, 0xe0 // sbc al r6 r3 r14 LSR r7
};
const byte kInstruction_sbc_cc_r3_r5_r3_ROR_r10[] = {
  0x73, 0x3a, 0xc5, 0x30 // sbc cc r3 r5 r3 ROR r10
};
const byte kInstruction_sbc_cs_r4_r11_r2_LSR_r10[] = {
  0x32, 0x4a, 0xcb, 0x20 // sbc cs r4 r11 r2 LSR r10
};
const byte kInstruction_sbc_lt_r6_r10_r5_ASR_r8[] = {
  0x55, 0x68, 0xca, 0xb0 // sbc lt r6 r10 r5 ASR r8
};
const byte kInstruction_sbc_ge_r0_r13_r10_ASR_r8[] = {
  0x5a, 0x08, 0xcd, 0xa0 // sbc ge r0 r13 r10 ASR r8
};
const byte kInstruction_sbc_cs_r8_r8_r0_LSL_r9[] = {
  0x10, 0x89, 0xc8, 0x20 // sbc cs r8 r8 r0 LSL r9
};
const byte kInstruction_sbc_gt_r1_r1_r1_ASR_r2[] = {
  0x51, 0x12, 0xc1, 0xc0 // sbc gt r1 r1 r1 ASR r2
};
const byte kInstruction_sbc_al_r5_r0_r14_ROR_r3[] = {
  0x7e, 0x53, 0xc0, 0xe0 // sbc al r5 r0 r14 ROR r3
};
const byte kInstruction_sbc_mi_r3_r9_r14_LSL_r9[] = {
  0x1e, 0x39, 0xc9, 0x40 // sbc mi r3 r9 r14 LSL r9
};
const byte kInstruction_sbc_ls_r9_r6_r5_LSL_r9[] = {
  0x15, 0x99, 0xc6, 0x90 // sbc ls r9 r6 r5 LSL r9
};
const byte kInstruction_sbc_lt_r13_r3_r1_LSL_r13[] = {
  0x11, 0xdd, 0xc3, 0xb0 // sbc lt r13 r3 r1 LSL r13
};
const byte kInstruction_sbc_lt_r9_r14_r3_ASR_r3[] = {
  0x53, 0x93, 0xce, 0xb0 // sbc lt r9 r14 r3 ASR r3
};
const byte kInstruction_sbc_cc_r5_r4_r1_LSR_r0[] = {
  0x31, 0x50, 0xc4, 0x30 // sbc cc r5 r4 r1 LSR r0
};
const byte kInstruction_sbc_cs_r9_r7_r8_ASR_r0[] = {
  0x58, 0x90, 0xc7, 0x20 // sbc cs r9 r7 r8 ASR r0
};
const byte kInstruction_sbc_ge_r8_r6_r14_ROR_r7[] = {
  0x7e, 0x87, 0xc6, 0xa0 // sbc ge r8 r6 r14 ROR r7
};
const byte kInstruction_sbc_le_r14_r8_r12_LSL_r0[] = {
  0x1c, 0xe0, 0xc8, 0xd0 // sbc le r14 r8 r12 LSL r0
};
const byte kInstruction_sbc_mi_r0_r13_r14_ASR_r3[] = {
  0x5e, 0x03, 0xcd, 0x40 // sbc mi r0 r13 r14 ASR r3
};
const byte kInstruction_sbc_cs_r7_r4_r9_ROR_r8[] = {
  0x79, 0x78, 0xc4, 0x20 // sbc cs r7 r4 r9 ROR r8
};
const byte kInstruction_sbc_ne_r4_r6_r11_ROR_r2[] = {
  0x7b, 0x42, 0xc6, 0x10 // sbc ne r4 r6 r11 ROR r2
};
const byte kInstruction_sbc_gt_r8_r8_r9_ROR_r12[] = {
  0x79, 0x8c, 0xc8, 0xc0 // sbc gt r8 r8 r9 ROR r12
};
const byte kInstruction_sbc_hi_r1_r2_r0_LSR_r13[] = {
  0x30, 0x1d, 0xc2, 0x80 // sbc hi r1 r2 r0 LSR r13
};
const byte kInstruction_sbc_ge_r14_r12_r6_ASR_r5[] = {
  0x56, 0xe5, 0xcc, 0xa0 // sbc ge r14 r12 r6 ASR r5
};
const byte kInstruction_sbc_ge_r5_r4_r7_LSR_r14[] = {
  0x37, 0x5e, 0xc4, 0xa0 // sbc ge r5 r4 r7 LSR r14
};
const byte kInstruction_sbc_cc_r13_r11_r10_LSR_r2[] = {
  0x3a, 0xd2, 0xcb, 0x30 // sbc cc r13 r11 r10 LSR r2
};
const byte kInstruction_sbc_mi_r3_r9_r14_LSR_r14[] = {
  0x3e, 0x3e, 0xc9, 0x40 // sbc mi r3 r9 r14 LSR r14
};
const byte kInstruction_sbc_ne_r10_r3_r4_LSR_r3[] = {
  0x34, 0xa3, 0xc3, 0x10 // sbc ne r10 r3 r4 LSR r3
};
const byte kInstruction_sbc_ls_r14_r9_r6_LSL_r9[] = {
  0x16, 0xe9, 0xc9, 0x90 // sbc ls r14 r9 r6 LSL r9
};
const byte kInstruction_sbc_ls_r8_r2_r8_ROR_r7[] = {
  0x78, 0x87, 0xc2, 0x90 // sbc ls r8 r2 r8 ROR r7
};
const byte kInstruction_sbc_ne_r2_r6_r3_ROR_r3[] = {
  0x73, 0x23, 0xc6, 0x10 // sbc ne r2 r6 r3 ROR r3
};
const byte kInstruction_sbc_mi_r12_r3_r11_ASR_r11[] = {
  0x5b, 0xcb, 0xc3, 0x40 // sbc mi r12 r3 r11 ASR r11
};
const byte kInstruction_sbc_le_r7_r10_r11_LSL_r9[] = {
  0x1b, 0x79, 0xca, 0xd0 // sbc le r7 r10 r11 LSL r9
};
const byte kInstruction_sbc_al_r1_r2_r10_ROR_r8[] = {
  0x7a, 0x18, 0xc2, 0xe0 // sbc al r1 r2 r10 ROR r8
};
const byte kInstruction_sbc_cc_r7_r9_r14_LSL_r7[] = {
  0x1e, 0x77, 0xc9, 0x30 // sbc cc r7 r9 r14 LSL r7
};
const byte kInstruction_sbc_cc_r9_r3_r5_LSL_r8[] = {
  0x15, 0x98, 0xc3, 0x30 // sbc cc r9 r3 r5 LSL r8
};
const byte kInstruction_sbc_hi_r8_r3_r8_ROR_r2[] = {
  0x78, 0x82, 0xc3, 0x80 // sbc hi r8 r3 r8 ROR r2
};
const byte kInstruction_sbc_pl_r10_r13_r14_LSR_r10[] = {
  0x3e, 0xaa, 0xcd, 0x50 // sbc pl r10 r13 r14 LSR r10
};
const byte kInstruction_sbc_lt_r13_r4_r13_LSR_r12[] = {
  0x3d, 0xdc, 0xc4, 0xb0 // sbc lt r13 r4 r13 LSR r12
};
const byte kInstruction_sbc_ls_r12_r14_r11_LSR_r13[] = {
  0x3b, 0xcd, 0xce, 0x90 // sbc ls r12 r14 r11 LSR r13
};
const byte kInstruction_sbc_vs_r11_r10_r10_ASR_r2[] = {
  0x5a, 0xb2, 0xca, 0x60 // sbc vs r11 r10 r10 ASR r2
};
const byte kInstruction_sbc_cc_r5_r8_r13_LSL_r10[] = {
  0x1d, 0x5a, 0xc8, 0x30 // sbc cc r5 r8 r13 LSL r10
};
const byte kInstruction_sbc_cs_r7_r4_r11_LSR_r14[] = {
  0x3b, 0x7e, 0xc4, 0x20 // sbc cs r7 r4 r11 LSR r14
};
const byte kInstruction_sbc_lt_r1_r12_r7_ASR_r11[] = {
  0x57, 0x1b, 0xcc, 0xb0 // sbc lt r1 r12 r7 ASR r11
};
const byte kInstruction_sbc_vc_r11_r4_r4_LSL_r10[] = {
  0x14, 0xba, 0xc4, 0x70 // sbc vc r11 r4 r4 LSL r10
};
const byte kInstruction_sbc_vc_r7_r4_r6_LSR_r7[] = {
  0x36, 0x77, 0xc4, 0x70 // sbc vc r7 r4 r6 LSR r7
};
const byte kInstruction_sbc_vc_r0_r3_r0_ASR_r14[] = {
  0x50, 0x0e, 0xc3, 0x70 // sbc vc r0 r3 r0 ASR r14
};
const byte kInstruction_sbc_mi_r11_r8_r13_ASR_r8[] = {
  0x5d, 0xb8, 0xc8, 0x40 // sbc mi r11 r8 r13 ASR r8
};
const byte kInstruction_sbc_gt_r13_r14_r6_LSL_r11[] = {
  0x16, 0xdb, 0xce, 0xc0 // sbc gt r13 r14 r6 LSL r11
};
const byte kInstruction_sbc_cs_r3_r2_r6_LSL_r8[] = {
  0x16, 0x38, 0xc2, 0x20 // sbc cs r3 r2 r6 LSL r8
};
const byte kInstruction_sbc_ne_r7_r5_r5_LSL_r8[] = {
  0x15, 0x78, 0xc5, 0x10 // sbc ne r7 r5 r5 LSL r8
};
const byte kInstruction_sbc_lt_r0_r12_r6_LSR_r0[] = {
  0x36, 0x00, 0xcc, 0xb0 // sbc lt r0 r12 r6 LSR r0
};
const byte kInstruction_sbc_ls_r11_r9_r12_ROR_r2[] = {
  0x7c, 0xb2, 0xc9, 0x90 // sbc ls r11 r9 r12 ROR r2
};
const byte kInstruction_sbc_ls_r6_r0_r8_LSR_r4[] = {
  0x38, 0x64, 0xc0, 0x90 // sbc ls r6 r0 r8 LSR r4
};
const byte kInstruction_sbc_lt_r6_r7_r0_ROR_r13[] = {
  0x70, 0x6d, 0xc7, 0xb0 // sbc lt r6 r7 r0 ROR r13
};
const byte kInstruction_sbc_gt_r14_r4_r1_LSL_r8[] = {
  0x11, 0xe8, 0xc4, 0xc0 // sbc gt r14 r4 r1 LSL r8
};
const byte kInstruction_sbc_al_r14_r5_r6_LSL_r7[] = {
  0x16, 0xe7, 0xc5, 0xe0 // sbc al r14 r5 r6 LSL r7
};
const byte kInstruction_sbc_ge_r9_r6_r4_LSR_r8[] = {
  0x34, 0x98, 0xc6, 0xa0 // sbc ge r9 r6 r4 LSR r8
};
const byte kInstruction_sbc_lt_r2_r14_r13_ROR_r3[] = {
  0x7d, 0x23, 0xce, 0xb0 // sbc lt r2 r14 r13 ROR r3
};
const byte kInstruction_sbc_al_r11_r1_r13_LSR_r9[] = {
  0x3d, 0xb9, 0xc1, 0xe0 // sbc al r11 r1 r13 LSR r9
};
const byte kInstruction_sbc_vs_r8_r2_r5_LSL_r11[] = {
  0x15, 0x8b, 0xc2, 0x60 // sbc vs r8 r2 r5 LSL r11
};
const byte kInstruction_sbc_pl_r8_r14_r8_LSL_r7[] = {
  0x18, 0x87, 0xce, 0x50 // sbc pl r8 r14 r8 LSL r7
};
const byte kInstruction_sbc_cs_r10_r5_r5_ASR_r4[] = {
  0x55, 0xa4, 0xc5, 0x20 // sbc cs r10 r5 r5 ASR r4
};
const byte kInstruction_sbc_eq_r12_r14_r9_LSR_r11[] = {
  0x39, 0xcb, 0xce, 0x00 // sbc eq r12 r14 r9 LSR r11
};
const byte kInstruction_sbc_lt_r1_r3_r3_LSL_r1[] = {
  0x13, 0x11, 0xc3, 0xb0 // sbc lt r1 r3 r3 LSL r1
};
const byte kInstruction_sbc_le_r4_r13_r4_ASR_r8[] = {
  0x54, 0x48, 0xcd, 0xd0 // sbc le r4 r13 r4 ASR r8
};
const byte kInstruction_sbc_ne_r5_r4_r2_LSL_r8[] = {
  0x12, 0x58, 0xc4, 0x10 // sbc ne r5 r4 r2 LSL r8
};
const byte kInstruction_sbc_le_r3_r14_r13_LSR_r1[] = {
  0x3d, 0x31, 0xce, 0xd0 // sbc le r3 r14 r13 LSR r1
};
const byte kInstruction_sbc_cc_r6_r3_r5_LSL_r1[] = {
  0x15, 0x61, 0xc3, 0x30 // sbc cc r6 r3 r5 LSL r1
};
const byte kInstruction_sbc_lt_r9_r6_r11_LSR_r14[] = {
  0x3b, 0x9e, 0xc6, 0xb0 // sbc lt r9 r6 r11 LSR r14
};
const byte kInstruction_sbc_cc_r13_r8_r10_ROR_r1[] = {
  0x7a, 0xd1, 0xc8, 0x30 // sbc cc r13 r8 r10 ROR r1
};
const byte kInstruction_sbc_lt_r7_r10_r11_LSR_r2[] = {
  0x3b, 0x72, 0xca, 0xb0 // sbc lt r7 r10 r11 LSR r2
};
const byte kInstruction_sbc_pl_r0_r9_r5_LSR_r8[] = {
  0x35, 0x08, 0xc9, 0x50 // sbc pl r0 r9 r5 LSR r8
};
const byte kInstruction_sbc_eq_r8_r9_r11_LSR_r13[] = {
  0x3b, 0x8d, 0xc9, 0x00 // sbc eq r8 r9 r11 LSR r13
};
const byte kInstruction_sbc_hi_r10_r1_r9_ROR_r12[] = {
  0x79, 0xac, 0xc1, 0x80 // sbc hi r10 r1 r9 ROR r12
};
const byte kInstruction_sbc_pl_r13_r1_r14_LSL_r14[] = {
  0x1e, 0xde, 0xc1, 0x50 // sbc pl r13 r1 r14 LSL r14
};
const byte kInstruction_sbc_eq_r13_r3_r7_LSR_r13[] = {
  0x37, 0xdd, 0xc3, 0x00 // sbc eq r13 r3 r7 LSR r13
};
const byte kInstruction_sbc_eq_r3_r6_r6_ASR_r14[] = {
  0x56, 0x3e, 0xc6, 0x00 // sbc eq r3 r6 r6 ASR r14
};
const byte kInstruction_sbc_gt_r5_r4_r8_ROR_r13[] = {
  0x78, 0x5d, 0xc4, 0xc0 // sbc gt r5 r4 r8 ROR r13
};
const byte kInstruction_sbc_al_r9_r7_r0_ROR_r3[] = {
  0x70, 0x93, 0xc7, 0xe0 // sbc al r9 r7 r0 ROR r3
};
const byte kInstruction_sbc_mi_r13_r11_r3_LSL_r1[] = {
  0x13, 0xd1, 0xcb, 0x40 // sbc mi r13 r11 r3 LSL r1
};
const byte kInstruction_sbc_ls_r11_r14_r6_LSL_r14[] = {
  0x16, 0xbe, 0xce, 0x90 // sbc ls r11 r14 r6 LSL r14
};
const byte kInstruction_sbc_al_r14_r3_r7_LSL_r9[] = {
  0x17, 0xe9, 0xc3, 0xe0 // sbc al r14 r3 r7 LSL r9
};
const byte kInstruction_sbc_cs_r14_r2_r14_LSL_r13[] = {
  0x1e, 0xed, 0xc2, 0x20 // sbc cs r14 r2 r14 LSL r13
};
const byte kInstruction_sbc_ls_r11_r10_r6_ASR_r11[] = {
  0x56, 0xbb, 0xca, 0x90 // sbc ls r11 r10 r6 ASR r11
};
const byte kInstruction_sbc_pl_r13_r4_r2_LSL_r4[] = {
  0x12, 0xd4, 0xc4, 0x50 // sbc pl r13 r4 r2 LSL r4
};
const byte kInstruction_sbc_mi_r8_r10_r5_ASR_r0[] = {
  0x55, 0x80, 0xca, 0x40 // sbc mi r8 r10 r5 ASR r0
};
const byte kInstruction_sbc_cs_r2_r1_r6_ASR_r4[] = {
  0x56, 0x24, 0xc1, 0x20 // sbc cs r2 r1 r6 ASR r4
};
const byte kInstruction_sbc_cc_r0_r11_r8_LSR_r14[] = {
  0x38, 0x0e, 0xcb, 0x30 // sbc cc r0 r11 r8 LSR r14
};
const byte kInstruction_sbc_ge_r5_r4_r6_ROR_r1[] = {
  0x76, 0x51, 0xc4, 0xa0 // sbc ge r5 r4 r6 ROR r1
};
const byte kInstruction_sbc_cs_r0_r14_r3_LSR_r11[] = {
  0x33, 0x0b, 0xce, 0x20 // sbc cs r0 r14 r3 LSR r11
};
const byte kInstruction_sbc_ge_r9_r4_r10_LSR_r13[] = {
  0x3a, 0x9d, 0xc4, 0xa0 // sbc ge r9 r4 r10 LSR r13
};
const byte kInstruction_sbc_ne_r11_r0_r9_LSL_r8[] = {
  0x19, 0xb8, 0xc0, 0x10 // sbc ne r11 r0 r9 LSL r8
};
const byte kInstruction_sbc_vs_r4_r1_r0_LSL_r8[] = {
  0x10, 0x48, 0xc1, 0x60 // sbc vs r4 r1 r0 LSL r8
};
const byte kInstruction_sbc_le_r5_r5_r4_ROR_r10[] = {
  0x74, 0x5a, 0xc5, 0xd0 // sbc le r5 r5 r4 ROR r10
};
const byte kInstruction_sbc_al_r9_r5_r0_ROR_r6[] = {
  0x70, 0x96, 0xc5, 0xe0 // sbc al r9 r5 r0 ROR r6
};
const byte kInstruction_sbc_hi_r6_r6_r9_LSR_r12[] = {
  0x39, 0x6c, 0xc6, 0x80 // sbc hi r6 r6 r9 LSR r12
};
const byte kInstruction_sbc_lt_r1_r4_r9_ROR_r4[] = {
  0x79, 0x14, 0xc4, 0xb0 // sbc lt r1 r4 r9 ROR r4
};
const byte kInstruction_sbc_vc_r4_r7_r0_ROR_r11[] = {
  0x70, 0x4b, 0xc7, 0x70 // sbc vc r4 r7 r0 ROR r11
};
const byte kInstruction_sbc_gt_r1_r4_r2_ROR_r8[] = {
  0x72, 0x18, 0xc4, 0xc0 // sbc gt r1 r4 r2 ROR r8
};
const byte kInstruction_sbc_ne_r4_r5_r9_LSL_r6[] = {
  0x19, 0x46, 0xc5, 0x10 // sbc ne r4 r5 r9 LSL r6
};
const byte kInstruction_sbc_gt_r3_r4_r10_LSR_r5[] = {
  0x3a, 0x35, 0xc4, 0xc0 // sbc gt r3 r4 r10 LSR r5
};
const byte kInstruction_sbc_al_r7_r9_r2_ROR_r2[] = {
  0x72, 0x72, 0xc9, 0xe0 // sbc al r7 r9 r2 ROR r2
};
const byte kInstruction_sbc_le_r3_r8_r2_LSL_r2[] = {
  0x12, 0x32, 0xc8, 0xd0 // sbc le r3 r8 r2 LSL r2
};
const byte kInstruction_sbc_hi_r3_r8_r0_LSL_r1[] = {
  0x10, 0x31, 0xc8, 0x80 // sbc hi r3 r8 r0 LSL r1
};
const byte kInstruction_sbc_ge_r11_r4_r4_LSL_r14[] = {
  0x14, 0xbe, 0xc4, 0xa0 // sbc ge r11 r4 r4 LSL r14
};
const byte kInstruction_sbc_mi_r8_r14_r1_LSR_r13[] = {
  0x31, 0x8d, 0xce, 0x40 // sbc mi r8 r14 r1 LSR r13
};
const byte kInstruction_sbc_pl_r6_r1_r10_LSL_r0[] = {
  0x1a, 0x60, 0xc1, 0x50 // sbc pl r6 r1 r10 LSL r0
};
const byte kInstruction_sbc_eq_r11_r7_r13_LSL_r0[] = {
  0x1d, 0xb0, 0xc7, 0x00 // sbc eq r11 r7 r13 LSL r0
};
const byte kInstruction_sbc_cc_r4_r9_r11_LSR_r1[] = {
  0x3b, 0x41, 0xc9, 0x30 // sbc cc r4 r9 r11 LSR r1
};
const byte kInstruction_sbc_cc_r8_r2_r3_LSR_r8[] = {
  0x33, 0x88, 0xc2, 0x30 // sbc cc r8 r2 r3 LSR r8
};
const byte kInstruction_sbc_ne_r5_r1_r14_LSL_r12[] = {
  0x1e, 0x5c, 0xc1, 0x10 // sbc ne r5 r1 r14 LSL r12
};
const byte kInstruction_sbc_le_r13_r5_r2_ASR_r1[] = {
  0x52, 0xd1, 0xc5, 0xd0 // sbc le r13 r5 r2 ASR r1
};
const byte kInstruction_sbc_al_r0_r5_r0_LSL_r4[] = {
  0x10, 0x04, 0xc5, 0xe0 // sbc al r0 r5 r0 LSL r4
};
const byte kInstruction_sbc_mi_r3_r1_r4_LSR_r3[] = {
  0x34, 0x33, 0xc1, 0x40 // sbc mi r3 r1 r4 LSR r3
};
const byte kInstruction_sbc_cs_r3_r7_r0_ROR_r8[] = {
  0x70, 0x38, 0xc7, 0x20 // sbc cs r3 r7 r0 ROR r8
};
const byte kInstruction_sbc_cs_r11_r14_r4_LSR_r13[] = {
  0x34, 0xbd, 0xce, 0x20 // sbc cs r11 r14 r4 LSR r13
};
const byte kInstruction_sbc_vs_r11_r10_r8_ASR_r3[] = {
  0x58, 0xb3, 0xca, 0x60 // sbc vs r11 r10 r8 ASR r3
};
const byte kInstruction_sbc_gt_r10_r8_r9_LSL_r13[] = {
  0x19, 0xad, 0xc8, 0xc0 // sbc gt r10 r8 r9 LSL r13
};
const byte kInstruction_sbc_eq_r10_r1_r8_ASR_r9[] = {
  0x58, 0xa9, 0xc1, 0x00 // sbc eq r10 r1 r8 ASR r9
};
const byte kInstruction_sbc_al_r2_r1_r10_ASR_r8[] = {
  0x5a, 0x28, 0xc1, 0xe0 // sbc al r2 r1 r10 ASR r8
};
const byte kInstruction_sbc_al_r7_r1_r7_ROR_r11[] = {
  0x77, 0x7b, 0xc1, 0xe0 // sbc al r7 r1 r7 ROR r11
};
const byte kInstruction_sbc_cs_r0_r5_r6_ASR_r1[] = {
  0x56, 0x01, 0xc5, 0x20 // sbc cs r0 r5 r6 ASR r1
};
const byte kInstruction_sbc_lt_r12_r11_r10_LSR_r14[] = {
  0x3a, 0xce, 0xcb, 0xb0 // sbc lt r12 r11 r10 LSR r14
};
const byte kInstruction_sbc_pl_r13_r7_r5_LSL_r2[] = {
  0x15, 0xd2, 0xc7, 0x50 // sbc pl r13 r7 r5 LSL r2
};
const byte kInstruction_sbc_ne_r2_r0_r12_LSL_r11[] = {
  0x1c, 0x2b, 0xc0, 0x10 // sbc ne r2 r0 r12 LSL r11
};
const byte kInstruction_sbc_ls_r14_r9_r12_ROR_r6[] = {
  0x7c, 0xe6, 0xc9, 0x90 // sbc ls r14 r9 r12 ROR r6
};
const byte kInstruction_sbc_cc_r9_r2_r8_ASR_r3[] = {
  0x58, 0x93, 0xc2, 0x30 // sbc cc r9 r2 r8 ASR r3
};
const byte kInstruction_sbc_pl_r12_r11_r0_ASR_r7[] = {
  0x50, 0xc7, 0xcb, 0x50 // sbc pl r12 r11 r0 ASR r7
};
const byte kInstruction_sbc_vs_r12_r2_r3_ROR_r1[] = {
  0x73, 0xc1, 0xc2, 0x60 // sbc vs r12 r2 r3 ROR r1
};
const byte kInstruction_sbc_al_r3_r1_r8_LSL_r4[] = {
  0x18, 0x34, 0xc1, 0xe0 // sbc al r3 r1 r8 LSL r4
};
const byte kInstruction_sbc_mi_r7_r9_r13_ASR_r5[] = {
  0x5d, 0x75, 0xc9, 0x40 // sbc mi r7 r9 r13 ASR r5
};
const byte kInstruction_sbc_vs_r13_r4_r10_ROR_r9[] = {
  0x7a, 0xd9, 0xc4, 0x60 // sbc vs r13 r4 r10 ROR r9
};
const byte kInstruction_sbc_eq_r8_r2_r3_LSR_r2[] = {
  0x33, 0x82, 0xc2, 0x00 // sbc eq r8 r2 r3 LSR r2
};
const byte kInstruction_sbc_cs_r0_r3_r11_LSR_r7[] = {
  0x3b, 0x07, 0xc3, 0x20 // sbc cs r0 r3 r11 LSR r7
};
const byte kInstruction_sbc_pl_r2_r10_r9_ASR_r13[] = {
  0x59, 0x2d, 0xca, 0x50 // sbc pl r2 r10 r9 ASR r13
};
const byte kInstruction_sbc_eq_r14_r0_r7_ASR_r0[] = {
  0x57, 0xe0, 0xc0, 0x00 // sbc eq r14 r0 r7 ASR r0
};
const byte kInstruction_sbc_lt_r12_r11_r7_ROR_r7[] = {
  0x77, 0xc7, 0xcb, 0xb0 // sbc lt r12 r11 r7 ROR r7
};
const byte kInstruction_sbc_eq_r4_r10_r1_LSL_r2[] = {
  0x11, 0x42, 0xca, 0x00 // sbc eq r4 r10 r1 LSL r2
};
const byte kInstruction_sbc_al_r7_r14_r12_ASR_r6[] = {
  0x5c, 0x76, 0xce, 0xe0 // sbc al r7 r14 r12 ASR r6
};
const byte kInstruction_sbc_al_r2_r5_r13_ASR_r1[] = {
  0x5d, 0x21, 0xc5, 0xe0 // sbc al r2 r5 r13 ASR r1
};
const byte kInstruction_sbc_hi_r0_r3_r14_LSL_r11[] = {
  0x1e, 0x0b, 0xc3, 0x80 // sbc hi r0 r3 r14 LSL r11
};
const byte kInstruction_sbc_vs_r5_r6_r9_LSR_r13[] = {
  0x39, 0x5d, 0xc6, 0x60 // sbc vs r5 r6 r9 LSR r13
};
const byte kInstruction_sbc_hi_r14_r0_r14_ROR_r14[] = {
  0x7e, 0xee, 0xc0, 0x80 // sbc hi r14 r0 r14 ROR r14
};
const byte kInstruction_sbc_eq_r9_r3_r13_ROR_r9[] = {
  0x7d, 0x99, 0xc3, 0x00 // sbc eq r9 r3 r13 ROR r9
};
const byte kInstruction_sbc_hi_r6_r8_r1_ASR_r14[] = {
  0x51, 0x6e, 0xc8, 0x80 // sbc hi r6 r8 r1 ASR r14
};
const byte kInstruction_sbc_vs_r13_r2_r8_LSR_r7[] = {
  0x38, 0xd7, 0xc2, 0x60 // sbc vs r13 r2 r8 LSR r7
};
const byte kInstruction_sbc_cc_r13_r0_r8_LSR_r7[] = {
  0x38, 0xd7, 0xc0, 0x30 // sbc cc r13 r0 r8 LSR r7
};
const byte kInstruction_sbc_le_r12_r0_r11_ASR_r9[] = {
  0x5b, 0xc9, 0xc0, 0xd0 // sbc le r12 r0 r11 ASR r9
};
const byte kInstruction_sbc_le_r8_r8_r1_LSR_r6[] = {
  0x31, 0x86, 0xc8, 0xd0 // sbc le r8 r8 r1 LSR r6
};
const byte kInstruction_sbc_cs_r5_r14_r7_ASR_r3[] = {
  0x57, 0x53, 0xce, 0x20 // sbc cs r5 r14 r7 ASR r3
};
const byte kInstruction_sbc_eq_r13_r13_r10_ROR_r12[] = {
  0x7a, 0xdc, 0xcd, 0x00 // sbc eq r13 r13 r10 ROR r12
};
const byte kInstruction_sbc_lt_r4_r7_r7_LSR_r5[] = {
  0x37, 0x45, 0xc7, 0xb0 // sbc lt r4 r7 r7 LSR r5
};
const byte kInstruction_sbc_le_r6_r13_r10_LSR_r2[] = {
  0x3a, 0x62, 0xcd, 0xd0 // sbc le r6 r13 r10 LSR r2
};
const byte kInstruction_sbc_eq_r10_r13_r10_ASR_r8[] = {
  0x5a, 0xa8, 0xcd, 0x00 // sbc eq r10 r13 r10 ASR r8
};
const byte kInstruction_sbc_ne_r6_r5_r12_LSR_r12[] = {
  0x3c, 0x6c, 0xc5, 0x10 // sbc ne r6 r5 r12 LSR r12
};
const byte kInstruction_sbc_vc_r10_r8_r10_ROR_r8[] = {
  0x7a, 0xa8, 0xc8, 0x70 // sbc vc r10 r8 r10 ROR r8
};
const byte kInstruction_sbc_gt_r10_r1_r8_LSR_r1[] = {
  0x38, 0xa1, 0xc1, 0xc0 // sbc gt r10 r1 r8 LSR r1
};
const byte kInstruction_sbc_pl_r5_r12_r9_LSR_r13[] = {
  0x39, 0x5d, 0xcc, 0x50 // sbc pl r5 r12 r9 LSR r13
};
const byte kInstruction_sbc_gt_r10_r6_r4_ROR_r12[] = {
  0x74, 0xac, 0xc6, 0xc0 // sbc gt r10 r6 r4 ROR r12
};
const byte kInstruction_sbc_cs_r14_r10_r10_ASR_r6[] = {
  0x5a, 0xe6, 0xca, 0x20 // sbc cs r14 r10 r10 ASR r6
};
const byte kInstruction_sbc_le_r6_r8_r2_ROR_r7[] = {
  0x72, 0x67, 0xc8, 0xd0 // sbc le r6 r8 r2 ROR r7
};
const byte kInstruction_sbc_le_r13_r12_r0_ROR_r14[] = {
  0x70, 0xde, 0xcc, 0xd0 // sbc le r13 r12 r0 ROR r14
};
const byte kInstruction_sbc_le_r7_r6_r0_ASR_r10[] = {
  0x50, 0x7a, 0xc6, 0xd0 // sbc le r7 r6 r0 ASR r10
};
const byte kInstruction_sbc_cs_r10_r4_r1_ASR_r10[] = {
  0x51, 0xaa, 0xc4, 0x20 // sbc cs r10 r4 r1 ASR r10
};
const byte kInstruction_sbc_ne_r12_r9_r11_ASR_r6[] = {
  0x5b, 0xc6, 0xc9, 0x10 // sbc ne r12 r9 r11 ASR r6
};
const byte kInstruction_sbc_vs_r9_r14_r6_ASR_r12[] = {
  0x56, 0x9c, 0xce, 0x60 // sbc vs r9 r14 r6 ASR r12
};
const byte kInstruction_sbc_mi_r1_r8_r0_ASR_r7[] = {
  0x50, 0x17, 0xc8, 0x40 // sbc mi r1 r8 r0 ASR r7
};
const byte kInstruction_sbc_gt_r11_r2_r3_ROR_r11[] = {
  0x73, 0xbb, 0xc2, 0xc0 // sbc gt r11 r2 r3 ROR r11
};
const byte kInstruction_sbc_cs_r3_r1_r12_LSR_r0[] = {
  0x3c, 0x30, 0xc1, 0x20 // sbc cs r3 r1 r12 LSR r0
};
const byte kInstruction_sbc_hi_r12_r14_r11_LSL_r2[] = {
  0x1b, 0xc2, 0xce, 0x80 // sbc hi r12 r14 r11 LSL r2
};
const byte kInstruction_sbc_mi_r10_r11_r14_LSL_r10[] = {
  0x1e, 0xaa, 0xcb, 0x40 // sbc mi r10 r11 r14 LSL r10
};
const byte kInstruction_sbc_al_r11_r6_r13_ASR_r2[] = {
  0x5d, 0xb2, 0xc6, 0xe0 // sbc al r11 r6 r13 ASR r2
};
const byte kInstruction_sbc_gt_r2_r14_r3_ROR_r6[] = {
  0x73, 0x26, 0xce, 0xc0 // sbc gt r2 r14 r3 ROR r6
};
const byte kInstruction_sbc_hi_r1_r10_r6_LSR_r6[] = {
  0x36, 0x16, 0xca, 0x80 // sbc hi r1 r10 r6 LSR r6
};
const byte kInstruction_sbc_gt_r2_r8_r3_LSL_r6[] = {
  0x13, 0x26, 0xc8, 0xc0 // sbc gt r2 r8 r3 LSL r6
};
const byte kInstruction_sbc_ls_r13_r4_r12_ROR_r13[] = {
  0x7c, 0xdd, 0xc4, 0x90 // sbc ls r13 r4 r12 ROR r13
};
const byte kInstruction_sbc_vs_r13_r11_r7_ROR_r8[] = {
  0x77, 0xd8, 0xcb, 0x60 // sbc vs r13 r11 r7 ROR r8
};
const byte kInstruction_sbc_hi_r5_r12_r14_LSR_r3[] = {
  0x3e, 0x53, 0xcc, 0x80 // sbc hi r5 r12 r14 LSR r3
};
const byte kInstruction_sbc_cs_r14_r8_r3_ROR_r13[] = {
  0x73, 0xed, 0xc8, 0x20 // sbc cs r14 r8 r3 ROR r13
};
const byte kInstruction_sbc_cs_r9_r10_r0_LSL_r10[] = {
  0x10, 0x9a, 0xca, 0x20 // sbc cs r9 r10 r0 LSL r10
};
const byte kInstruction_sbc_lt_r0_r13_r12_ASR_r5[] = {
  0x5c, 0x05, 0xcd, 0xb0 // sbc lt r0 r13 r12 ASR r5
};
const byte kInstruction_sbc_cs_r4_r5_r7_ROR_r7[] = {
  0x77, 0x47, 0xc5, 0x20 // sbc cs r4 r5 r7 ROR r7
};
const byte kInstruction_sbc_lt_r0_r14_r7_LSR_r7[] = {
  0x37, 0x07, 0xce, 0xb0 // sbc lt r0 r14 r7 LSR r7
};
const byte kInstruction_sbc_hi_r10_r5_r3_LSL_r10[] = {
  0x13, 0xaa, 0xc5, 0x80 // sbc hi r10 r5 r3 LSL r10
};
const byte kInstruction_sbc_ls_r6_r2_r4_ROR_r0[] = {
  0x74, 0x60, 0xc2, 0x90 // sbc ls r6 r2 r4 ROR r0
};
const byte kInstruction_sbc_hi_r9_r7_r7_ASR_r10[] = {
  0x57, 0x9a, 0xc7, 0x80 // sbc hi r9 r7 r7 ASR r10
};
const byte kInstruction_sbc_cc_r0_r9_r4_LSR_r2[] = {
  0x34, 0x02, 0xc9, 0x30 // sbc cc r0 r9 r4 LSR r2
};
const byte kInstruction_sbc_le_r3_r14_r2_ASR_r0[] = {
  0x52, 0x30, 0xce, 0xd0 // sbc le r3 r14 r2 ASR r0
};
const byte kInstruction_sbc_pl_r2_r8_r7_LSL_r13[] = {
  0x17, 0x2d, 0xc8, 0x50 // sbc pl r2 r8 r7 LSL r13
};
const byte kInstruction_sbc_al_r10_r1_r9_LSR_r6[] = {
  0x39, 0xa6, 0xc1, 0xe0 // sbc al r10 r1 r9 LSR r6
};
const byte kInstruction_sbc_vs_r1_r6_r14_ASR_r14[] = {
  0x5e, 0x1e, 0xc6, 0x60 // sbc vs r1 r6 r14 ASR r14
};
const byte kInstruction_sbc_lt_r3_r3_r13_LSR_r0[] = {
  0x3d, 0x30, 0xc3, 0xb0 // sbc lt r3 r3 r13 LSR r0
};
const byte kInstruction_sbc_le_r9_r3_r2_ASR_r11[] = {
  0x52, 0x9b, 0xc3, 0xd0 // sbc le r9 r3 r2 ASR r11
};
const byte kInstruction_sbc_mi_r4_r14_r6_LSL_r11[] = {
  0x16, 0x4b, 0xce, 0x40 // sbc mi r4 r14 r6 LSL r11
};
const byte kInstruction_sbc_ne_r7_r5_r14_ASR_r9[] = {
  0x5e, 0x79, 0xc5, 0x10 // sbc ne r7 r5 r14 ASR r9
};
const byte kInstruction_sbc_cs_r11_r11_r13_LSR_r11[] = {
  0x3d, 0xbb, 0xcb, 0x20 // sbc cs r11 r11 r13 LSR r11
};
const byte kInstruction_sbc_lt_r12_r9_r5_LSR_r9[] = {
  0x35, 0xc9, 0xc9, 0xb0 // sbc lt r12 r9 r5 LSR r9
};
const byte kInstruction_sbc_hi_r13_r1_r10_LSL_r4[] = {
  0x1a, 0xd4, 0xc1, 0x80 // sbc hi r13 r1 r10 LSL r4
};
const byte kInstruction_sbc_mi_r14_r6_r8_ASR_r14[] = {
  0x58, 0xee, 0xc6, 0x40 // sbc mi r14 r6 r8 ASR r14
};
const byte kInstruction_sbc_vc_r3_r2_r6_ASR_r3[] = {
  0x56, 0x33, 0xc2, 0x70 // sbc vc r3 r2 r6 ASR r3
};
const byte kInstruction_sbc_ne_r13_r14_r0_ASR_r2[] = {
  0x50, 0xd2, 0xce, 0x10 // sbc ne r13 r14 r0 ASR r2
};
const byte kInstruction_sbc_gt_r2_r14_r5_ROR_r1[] = {
  0x75, 0x21, 0xce, 0xc0 // sbc gt r2 r14 r5 ROR r1
};
const byte kInstruction_sbc_ls_r7_r7_r9_LSR_r10[] = {
  0x39, 0x7a, 0xc7, 0x90 // sbc ls r7 r7 r9 LSR r10
};
const byte kInstruction_sbc_gt_r2_r12_r8_ASR_r5[] = {
  0x58, 0x25, 0xcc, 0xc0 // sbc gt r2 r12 r8 ASR r5
};
const byte kInstruction_sbc_lt_r13_r2_r11_ROR_r6[] = {
  0x7b, 0xd6, 0xc2, 0xb0 // sbc lt r13 r2 r11 ROR r6
};
const byte kInstruction_sbc_cc_r2_r13_r13_ASR_r1[] = {
  0x5d, 0x21, 0xcd, 0x30 // sbc cc r2 r13 r13 ASR r1
};
const byte kInstruction_sbc_vs_r0_r6_r14_ROR_r3[] = {
  0x7e, 0x03, 0xc6, 0x60 // sbc vs r0 r6 r14 ROR r3
};
const byte kInstruction_sbc_vs_r2_r13_r8_LSL_r9[] = {
  0x18, 0x29, 0xcd, 0x60 // sbc vs r2 r13 r8 LSL r9
};
const byte kInstruction_sbc_pl_r2_r12_r12_ROR_r6[] = {
  0x7c, 0x26, 0xcc, 0x50 // sbc pl r2 r12 r12 ROR r6
};
const byte kInstruction_sbc_vc_r4_r0_r12_ASR_r13[] = {
  0x5c, 0x4d, 0xc0, 0x70 // sbc vc r4 r0 r12 ASR r13
};
const byte kInstruction_sbc_mi_r8_r12_r7_ASR_r7[] = {
  0x57, 0x87, 0xcc, 0x40 // sbc mi r8 r12 r7 ASR r7
};
const byte kInstruction_sbc_al_r13_r5_r0_LSL_r5[] = {
  0x10, 0xd5, 0xc5, 0xe0 // sbc al r13 r5 r0 LSL r5
};
const byte kInstruction_sbc_le_r9_r1_r12_LSR_r8[] = {
  0x3c, 0x98, 0xc1, 0xd0 // sbc le r9 r1 r12 LSR r8
};
const byte kInstruction_sbc_vs_r5_r10_r13_ROR_r1[] = {
  0x7d, 0x51, 0xca, 0x60 // sbc vs r5 r10 r13 ROR r1
};
const byte kInstruction_sbc_vs_r8_r5_r0_LSR_r11[] = {
  0x30, 0x8b, 0xc5, 0x60 // sbc vs r8 r5 r0 LSR r11
};
const byte kInstruction_sbc_ne_r7_r2_r0_LSL_r4[] = {
  0x10, 0x74, 0xc2, 0x10 // sbc ne r7 r2 r0 LSL r4
};
const byte kInstruction_sbc_lt_r6_r6_r9_LSL_r10[] = {
  0x19, 0x6a, 0xc6, 0xb0 // sbc lt r6 r6 r9 LSL r10
};
const byte kInstruction_sbc_cs_r13_r3_r4_ROR_r12[] = {
  0x74, 0xdc, 0xc3, 0x20 // sbc cs r13 r3 r4 ROR r12
};
const byte kInstruction_sbc_ne_r11_r11_r0_LSL_r7[] = {
  0x10, 0xb7, 0xcb, 0x10 // sbc ne r11 r11 r0 LSL r7
};
const byte kInstruction_sbc_pl_r3_r14_r12_LSR_r13[] = {
  0x3c, 0x3d, 0xce, 0x50 // sbc pl r3 r14 r12 LSR r13
};
const byte kInstruction_sbc_al_r2_r14_r3_LSL_r11[] = {
  0x13, 0x2b, 0xce, 0xe0 // sbc al r2 r14 r3 LSL r11
};
const byte kInstruction_sbc_vc_r4_r6_r3_LSR_r7[] = {
  0x33, 0x47, 0xc6, 0x70 // sbc vc r4 r6 r3 LSR r7
};
const byte kInstruction_sbc_ls_r6_r2_r1_LSR_r6[] = {
  0x31, 0x66, 0xc2, 0x90 // sbc ls r6 r2 r1 LSR r6
};
const byte kInstruction_sbc_le_r0_r2_r5_ASR_r3[] = {
  0x55, 0x03, 0xc2, 0xd0 // sbc le r0 r2 r5 ASR r3
};
const byte kInstruction_sbc_ge_r12_r9_r12_ROR_r13[] = {
  0x7c, 0xcd, 0xc9, 0xa0 // sbc ge r12 r9 r12 ROR r13
};
const byte kInstruction_sbc_cc_r10_r5_r3_ROR_r12[] = {
  0x73, 0xac, 0xc5, 0x30 // sbc cc r10 r5 r3 ROR r12
};
const byte kInstruction_sbc_mi_r14_r0_r10_ASR_r4[] = {
  0x5a, 0xe4, 0xc0, 0x40 // sbc mi r14 r0 r10 ASR r4
};
const byte kInstruction_sbc_al_r12_r0_r3_ROR_r13[] = {
  0x73, 0xcd, 0xc0, 0xe0 // sbc al r12 r0 r3 ROR r13
};
const byte kInstruction_sbc_hi_r1_r8_r13_ASR_r2[] = {
  0x5d, 0x12, 0xc8, 0x80 // sbc hi r1 r8 r13 ASR r2
};
const byte kInstruction_sbc_ls_r7_r9_r9_ASR_r2[] = {
  0x59, 0x72, 0xc9, 0x90 // sbc ls r7 r9 r9 ASR r2
};
const byte kInstruction_sbc_ls_r9_r13_r6_ROR_r11[] = {
  0x76, 0x9b, 0xcd, 0x90 // sbc ls r9 r13 r6 ROR r11
};
const byte kInstruction_sbc_pl_r11_r12_r14_LSL_r14[] = {
  0x1e, 0xbe, 0xcc, 0x50 // sbc pl r11 r12 r14 LSL r14
};
const byte kInstruction_sbc_eq_r1_r3_r10_ASR_r9[] = {
  0x5a, 0x19, 0xc3, 0x00 // sbc eq r1 r3 r10 ASR r9
};
const byte kInstruction_sbc_al_r1_r6_r6_LSL_r9[] = {
  0x16, 0x19, 0xc6, 0xe0 // sbc al r1 r6 r6 LSL r9
};
const byte kInstruction_sbc_ne_r4_r14_r7_ROR_r12[] = {
  0x77, 0x4c, 0xce, 0x10 // sbc ne r4 r14 r7 ROR r12
};
const byte kInstruction_sbc_vc_r2_r13_r1_ROR_r7[] = {
  0x71, 0x27, 0xcd, 0x70 // sbc vc r2 r13 r1 ROR r7
};
const byte kInstruction_sbc_cs_r13_r12_r8_LSR_r11[] = {
  0x38, 0xdb, 0xcc, 0x20 // sbc cs r13 r12 r8 LSR r11
};
const byte kInstruction_sbc_le_r10_r14_r12_LSL_r4[] = {
  0x1c, 0xa4, 0xce, 0xd0 // sbc le r10 r14 r12 LSL r4
};
const byte kInstruction_sbc_cs_r14_r9_r4_ROR_r13[] = {
  0x74, 0xed, 0xc9, 0x20 // sbc cs r14 r9 r4 ROR r13
};
const byte kInstruction_sbc_ge_r10_r12_r8_ASR_r14[] = {
  0x58, 0xae, 0xcc, 0xa0 // sbc ge r10 r12 r8 ASR r14
};
const byte kInstruction_sbc_cs_r14_r10_r3_LSL_r13[] = {
  0x13, 0xed, 0xca, 0x20 // sbc cs r14 r10 r3 LSL r13
};
const byte kInstruction_sbc_lt_r4_r3_r10_LSR_r2[] = {
  0x3a, 0x42, 0xc3, 0xb0 // sbc lt r4 r3 r10 LSR r2
};
const byte kInstruction_sbc_ls_r13_r12_r8_ASR_r14[] = {
  0x58, 0xde, 0xcc, 0x90 // sbc ls r13 r12 r8 ASR r14
};
const byte kInstruction_sbc_ge_r3_r2_r0_ASR_r8[] = {
  0x50, 0x38, 0xc2, 0xa0 // sbc ge r3 r2 r0 ASR r8
};
const byte kInstruction_sbc_vs_r3_r7_r1_LSL_r0[] = {
  0x11, 0x30, 0xc7, 0x60 // sbc vs r3 r7 r1 LSL r0
};
const byte kInstruction_sbc_lt_r5_r13_r7_LSR_r7[] = {
  0x37, 0x57, 0xcd, 0xb0 // sbc lt r5 r13 r7 LSR r7
};
const byte kInstruction_sbc_ls_r8_r4_r3_ROR_r14[] = {
  0x73, 0x8e, 0xc4, 0x90 // sbc ls r8 r4 r3 ROR r14
};
const byte kInstruction_sbc_vc_r5_r4_r13_LSL_r12[] = {
  0x1d, 0x5c, 0xc4, 0x70 // sbc vc r5 r4 r13 LSL r12
};
const byte kInstruction_sbc_pl_r6_r10_r11_LSR_r2[] = {
  0x3b, 0x62, 0xca, 0x50 // sbc pl r6 r10 r11 LSR r2
};
const byte kInstruction_sbc_ne_r4_r0_r6_ASR_r10[] = {
  0x56, 0x4a, 0xc0, 0x10 // sbc ne r4 r0 r6 ASR r10
};
const byte kInstruction_sbc_vc_r2_r6_r7_LSR_r4[] = {
  0x37, 0x24, 0xc6, 0x70 // sbc vc r2 r6 r7 LSR r4
};
const byte kInstruction_sbc_pl_r4_r12_r1_ROR_r14[] = {
  0x71, 0x4e, 0xcc, 0x50 // sbc pl r4 r12 r1 ROR r14
};
const byte kInstruction_sbc_cs_r13_r1_r10_LSL_r12[] = {
  0x1a, 0xdc, 0xc1, 0x20 // sbc cs r13 r1 r10 LSL r12
};
const byte kInstruction_sbc_al_r7_r12_r7_LSL_r10[] = {
  0x17, 0x7a, 0xcc, 0xe0 // sbc al r7 r12 r7 LSL r10
};
const byte kInstruction_sbc_ge_r1_r9_r13_LSR_r8[] = {
  0x3d, 0x18, 0xc9, 0xa0 // sbc ge r1 r9 r13 LSR r8
};
const byte kInstruction_sbc_eq_r12_r5_r11_ASR_r2[] = {
  0x5b, 0xc2, 0xc5, 0x00 // sbc eq r12 r5 r11 ASR r2
};
const byte kInstruction_sbc_ls_r7_r9_r3_ASR_r14[] = {
  0x53, 0x7e, 0xc9, 0x90 // sbc ls r7 r9 r3 ASR r14
};
const byte kInstruction_sbc_pl_r5_r10_r3_LSL_r12[] = {
  0x13, 0x5c, 0xca, 0x50 // sbc pl r5 r10 r3 LSL r12
};
const byte kInstruction_sbc_vs_r5_r14_r11_ASR_r13[] = {
  0x5b, 0x5d, 0xce, 0x60 // sbc vs r5 r14 r11 ASR r13
};
const byte kInstruction_sbc_al_r9_r2_r8_LSR_r10[] = {
  0x38, 0x9a, 0xc2, 0xe0 // sbc al r9 r2 r8 LSR r10
};
const byte kInstruction_sbc_cc_r11_r12_r6_ROR_r11[] = {
  0x76, 0xbb, 0xcc, 0x30 // sbc cc r11 r12 r6 ROR r11
};
const byte kInstruction_sbc_ge_r10_r3_r1_LSR_r5[] = {
  0x31, 0xa5, 0xc3, 0xa0 // sbc ge r10 r3 r1 LSR r5
};
const byte kInstruction_sbc_lt_r13_r4_r7_ROR_r0[] = {
  0x77, 0xd0, 0xc4, 0xb0 // sbc lt r13 r4 r7 ROR r0
};
const byte kInstruction_sbc_ne_r2_r12_r12_LSR_r0[] = {
  0x3c, 0x20, 0xcc, 0x10 // sbc ne r2 r12 r12 LSR r0
};
const byte kInstruction_sbc_gt_r2_r10_r14_ASR_r10[] = {
  0x5e, 0x2a, 0xca, 0xc0 // sbc gt r2 r10 r14 ASR r10
};
const byte kInstruction_sbc_cc_r5_r6_r10_ASR_r11[] = {
  0x5a, 0x5b, 0xc6, 0x30 // sbc cc r5 r6 r10 ASR r11
};
const byte kInstruction_sbc_hi_r8_r13_r1_ROR_r9[] = {
  0x71, 0x89, 0xcd, 0x80 // sbc hi r8 r13 r1 ROR r9
};
const byte kInstruction_sbc_cc_r3_r1_r14_LSR_r3[] = {
  0x3e, 0x33, 0xc1, 0x30 // sbc cc r3 r1 r14 LSR r3
};
const byte kInstruction_sbc_lt_r11_r9_r8_ASR_r13[] = {
  0x58, 0xbd, 0xc9, 0xb0 // sbc lt r11 r9 r8 ASR r13
};
const byte kInstruction_sbc_mi_r0_r3_r13_ASR_r5[] = {
  0x5d, 0x05, 0xc3, 0x40 // sbc mi r0 r3 r13 ASR r5
};
const byte kInstruction_sbc_vc_r7_r6_r10_ASR_r6[] = {
  0x5a, 0x76, 0xc6, 0x70 // sbc vc r7 r6 r10 ASR r6
};
const byte kInstruction_sbc_mi_r2_r6_r4_LSL_r9[] = {
  0x14, 0x29, 0xc6, 0x40 // sbc mi r2 r6 r4 LSL r9
};
const byte kInstruction_sbc_ne_r12_r9_r4_ROR_r6[] = {
  0x74, 0xc6, 0xc9, 0x10 // sbc ne r12 r9 r4 ROR r6
};
const byte kInstruction_sbc_hi_r4_r3_r0_ROR_r4[] = {
  0x70, 0x44, 0xc3, 0x80 // sbc hi r4 r3 r0 ROR r4
};
const byte kInstruction_sbc_gt_r9_r2_r11_LSL_r13[] = {
  0x1b, 0x9d, 0xc2, 0xc0 // sbc gt r9 r2 r11 LSL r13
};
const byte kInstruction_sbc_eq_r14_r4_r3_LSL_r10[] = {
  0x13, 0xea, 0xc4, 0x00 // sbc eq r14 r4 r3 LSL r10
};
const byte kInstruction_sbc_le_r8_r2_r12_LSL_r10[] = {
  0x1c, 0x8a, 0xc2, 0xd0 // sbc le r8 r2 r12 LSL r10
};
const byte kInstruction_sbc_ls_r8_r0_r1_ASR_r8[] = {
  0x51, 0x88, 0xc0, 0x90 // sbc ls r8 r0 r1 ASR r8
};
const byte kInstruction_sbc_cc_r13_r9_r7_LSR_r3[] = {
  0x37, 0xd3, 0xc9, 0x30 // sbc cc r13 r9 r7 LSR r3
};
const byte kInstruction_sbc_gt_r6_r0_r7_ROR_r9[] = {
  0x77, 0x69, 0xc0, 0xc0 // sbc gt r6 r0 r7 ROR r9
};
const byte kInstruction_sbc_hi_r14_r12_r6_LSR_r12[] = {
  0x36, 0xec, 0xcc, 0x80 // sbc hi r14 r12 r6 LSR r12
};
const byte kInstruction_sbc_cs_r3_r7_r10_LSR_r8[] = {
  0x3a, 0x38, 0xc7, 0x20 // sbc cs r3 r7 r10 LSR r8
};
const byte kInstruction_sbc_le_r7_r7_r7_LSL_r11[] = {
  0x17, 0x7b, 0xc7, 0xd0 // sbc le r7 r7 r7 LSL r11
};
const byte kInstruction_sbc_le_r11_r11_r14_ASR_r3[] = {
  0x5e, 0xb3, 0xcb, 0xd0 // sbc le r11 r11 r14 ASR r3
};
const byte kInstruction_sbc_vc_r13_r5_r6_LSL_r13[] = {
  0x16, 0xdd, 0xc5, 0x70 // sbc vc r13 r5 r6 LSL r13
};
const byte kInstruction_sbc_cc_r12_r3_r12_LSL_r8[] = {
  0x1c, 0xc8, 0xc3, 0x30 // sbc cc r12 r3 r12 LSL r8
};
const byte kInstruction_sbc_gt_r4_r14_r12_ASR_r11[] = {
  0x5c, 0x4b, 0xce, 0xc0 // sbc gt r4 r14 r12 ASR r11
};
const byte kInstruction_sbc_cs_r9_r6_r7_LSL_r10[] = {
  0x17, 0x9a, 0xc6, 0x20 // sbc cs r9 r6 r7 LSL r10
};
const byte kInstruction_sbc_ge_r9_r5_r3_ROR_r5[] = {
  0x73, 0x95, 0xc5, 0xa0 // sbc ge r9 r5 r3 ROR r5
};
const byte kInstruction_sbc_vc_r4_r5_r14_LSR_r4[] = {
  0x3e, 0x44, 0xc5, 0x70 // sbc vc r4 r5 r14 LSR r4
};
const byte kInstruction_sbc_ne_r13_r12_r2_ASR_r14[] = {
  0x52, 0xde, 0xcc, 0x10 // sbc ne r13 r12 r2 ASR r14
};
const byte kInstruction_sbc_gt_r2_r9_r11_LSR_r13[] = {
  0x3b, 0x2d, 0xc9, 0xc0 // sbc gt r2 r9 r11 LSR r13
};
const byte kInstruction_sbc_mi_r10_r11_r8_LSR_r1[] = {
  0x38, 0xa1, 0xcb, 0x40 // sbc mi r10 r11 r8 LSR r1
};
const byte kInstruction_sbc_hi_r6_r8_r1_ASR_r6[] = {
  0x51, 0x66, 0xc8, 0x80 // sbc hi r6 r8 r1 ASR r6
};
const byte kInstruction_sbc_eq_r10_r12_r5_ROR_r11[] = {
  0x75, 0xab, 0xcc, 0x00 // sbc eq r10 r12 r5 ROR r11
};
const byte kInstruction_sbc_mi_r9_r6_r4_LSL_r1[] = {
  0x14, 0x91, 0xc6, 0x40 // sbc mi r9 r6 r4 LSL r1
};
const byte kInstruction_sbc_vc_r14_r6_r0_ROR_r7[] = {
  0x70, 0xe7, 0xc6, 0x70 // sbc vc r14 r6 r0 ROR r7
};
const byte kInstruction_sbc_mi_r10_r3_r12_LSL_r2[] = {
  0x1c, 0xa2, 0xc3, 0x40 // sbc mi r10 r3 r12 LSL r2
};
const byte kInstruction_sbc_pl_r9_r6_r9_LSR_r14[] = {
  0x39, 0x9e, 0xc6, 0x50 // sbc pl r9 r6 r9 LSR r14
};
const byte kInstruction_sbc_al_r10_r5_r10_ROR_r1[] = {
  0x7a, 0xa1, 0xc5, 0xe0 // sbc al r10 r5 r10 ROR r1
};
const byte kInstruction_sbc_ne_r9_r6_r2_ASR_r3[] = {
  0x52, 0x93, 0xc6, 0x10 // sbc ne r9 r6 r2 ASR r3
};
const byte kInstruction_sbc_hi_r4_r9_r4_LSL_r6[] = {
  0x14, 0x46, 0xc9, 0x80 // sbc hi r4 r9 r4 LSL r6
};
const byte kInstruction_sbc_vs_r1_r9_r7_ASR_r7[] = {
  0x57, 0x17, 0xc9, 0x60 // sbc vs r1 r9 r7 ASR r7
};
const byte kInstruction_sbc_ne_r10_r13_r9_ASR_r14[] = {
  0x59, 0xae, 0xcd, 0x10 // sbc ne r10 r13 r9 ASR r14
};
const byte kInstruction_sbc_gt_r11_r13_r12_ASR_r12[] = {
  0x5c, 0xbc, 0xcd, 0xc0 // sbc gt r11 r13 r12 ASR r12
};
const byte kInstruction_sbc_lt_r3_r5_r0_LSR_r10[] = {
  0x30, 0x3a, 0xc5, 0xb0 // sbc lt r3 r5 r0 LSR r10
};
const byte kInstruction_sbc_gt_r4_r8_r13_ROR_r7[] = {
  0x7d, 0x47, 0xc8, 0xc0 // sbc gt r4 r8 r13 ROR r7
};
const byte kInstruction_sbc_ls_r14_r14_r0_ASR_r3[] = {
  0x50, 0xe3, 0xce, 0x90 // sbc ls r14 r14 r0 ASR r3
};
const byte kInstruction_sbc_vc_r2_r7_r9_ASR_r5[] = {
  0x59, 0x25, 0xc7, 0x70 // sbc vc r2 r7 r9 ASR r5
};
const byte kInstruction_sbc_mi_r9_r3_r10_LSR_r10[] = {
  0x3a, 0x9a, 0xc3, 0x40 // sbc mi r9 r3 r10 LSR r10
};
const byte kInstruction_sbc_gt_r11_r10_r3_ASR_r11[] = {
  0x53, 0xbb, 0xca, 0xc0 // sbc gt r11 r10 r3 ASR r11
};
const byte kInstruction_sbc_cc_r3_r14_r2_ROR_r12[] = {
  0x72, 0x3c, 0xce, 0x30 // sbc cc r3 r14 r2 ROR r12
};
const byte kInstruction_sbc_ls_r3_r5_r14_ROR_r12[] = {
  0x7e, 0x3c, 0xc5, 0x90 // sbc ls r3 r5 r14 ROR r12
};
const byte kInstruction_sbc_al_r6_r0_r11_ASR_r0[] = {
  0x5b, 0x60, 0xc0, 0xe0 // sbc al r6 r0 r11 ASR r0
};
const byte kInstruction_sbc_al_r14_r12_r13_LSL_r8[] = {
  0x1d, 0xe8, 0xcc, 0xe0 // sbc al r14 r12 r13 LSL r8
};
const byte kInstruction_sbc_cs_r12_r9_r14_ROR_r4[] = {
  0x7e, 0xc4, 0xc9, 0x20 // sbc cs r12 r9 r14 ROR r4
};
const byte kInstruction_sbc_vs_r4_r9_r6_LSL_r10[] = {
  0x16, 0x4a, 0xc9, 0x60 // sbc vs r4 r9 r6 LSL r10
};
const byte kInstruction_sbc_eq_r6_r1_r4_ASR_r6[] = {
  0x54, 0x66, 0xc1, 0x00 // sbc eq r6 r1 r4 ASR r6
};
const byte kInstruction_sbc_ge_r6_r11_r2_LSR_r10[] = {
  0x32, 0x6a, 0xcb, 0xa0 // sbc ge r6 r11 r2 LSR r10
};
const byte kInstruction_sbc_cc_r10_r14_r4_LSR_r0[] = {
  0x34, 0xa0, 0xce, 0x30 // sbc cc r10 r14 r4 LSR r0
};
const byte kInstruction_sbc_ge_r0_r12_r1_ROR_r5[] = {
  0x71, 0x05, 0xcc, 0xa0 // sbc ge r0 r12 r1 ROR r5
};
const byte kInstruction_sbc_ls_r1_r13_r10_ASR_r5[] = {
  0x5a, 0x15, 0xcd, 0x90 // sbc ls r1 r13 r10 ASR r5
};
const byte kInstruction_sbc_cc_r9_r8_r5_ASR_r5[] = {
  0x55, 0x95, 0xc8, 0x30 // sbc cc r9 r8 r5 ASR r5
};
const byte kInstruction_sbc_ls_r6_r5_r1_LSL_r11[] = {
  0x11, 0x6b, 0xc5, 0x90 // sbc ls r6 r5 r1 LSL r11
};
const byte kInstruction_sbc_ne_r2_r12_r1_ROR_r10[] = {
  0x71, 0x2a, 0xcc, 0x10 // sbc ne r2 r12 r1 ROR r10
};
const byte kInstruction_sbc_cc_r2_r9_r9_LSR_r1[] = {
  0x39, 0x21, 0xc9, 0x30 // sbc cc r2 r9 r9 LSR r1
};
const byte kInstruction_sbc_ne_r1_r8_r1_ASR_r14[] = {
  0x51, 0x1e, 0xc8, 0x10 // sbc ne r1 r8 r1 ASR r14
};
const byte kInstruction_sbc_lt_r9_r2_r1_LSR_r10[] = {
  0x31, 0x9a, 0xc2, 0xb0 // sbc lt r9 r2 r1 LSR r10
};
const byte kInstruction_sbc_cc_r14_r11_r9_ROR_r6[] = {
  0x79, 0xe6, 0xcb, 0x30 // sbc cc r14 r11 r9 ROR r6
};
const byte kInstruction_sbc_eq_r3_r12_r13_ASR_r0[] = {
  0x5d, 0x30, 0xcc, 0x00 // sbc eq r3 r12 r13 ASR r0
};
const byte kInstruction_sbc_le_r6_r6_r6_ASR_r2[] = {
  0x56, 0x62, 0xc6, 0xd0 // sbc le r6 r6 r6 ASR r2
};
const byte kInstruction_sbc_mi_r11_r14_r4_ASR_r1[] = {
  0x54, 0xb1, 0xce, 0x40 // sbc mi r11 r14 r4 ASR r1
};
const byte kInstruction_sbc_ls_r5_r9_r10_LSL_r9[] = {
  0x1a, 0x59, 0xc9, 0x90 // sbc ls r5 r9 r10 LSL r9
};
const byte kInstruction_sbc_vc_r12_r9_r3_LSR_r10[] = {
  0x33, 0xca, 0xc9, 0x70 // sbc vc r12 r9 r3 LSR r10
};
const byte kInstruction_sbc_lt_r12_r0_r4_ASR_r0[] = {
  0x54, 0xc0, 0xc0, 0xb0 // sbc lt r12 r0 r4 ASR r0
};
const byte kInstruction_sbc_mi_r0_r10_r6_ROR_r9[] = {
  0x76, 0x09, 0xca, 0x40 // sbc mi r0 r10 r6 ROR r9
};
const byte kInstruction_sbc_hi_r7_r10_r1_LSL_r7[] = {
  0x11, 0x77, 0xca, 0x80 // sbc hi r7 r10 r1 LSL r7
};
const byte kInstruction_sbc_ls_r2_r0_r14_ROR_r5[] = {
  0x7e, 0x25, 0xc0, 0x90 // sbc ls r2 r0 r14 ROR r5
};
const byte kInstruction_sbc_cs_r12_r14_r12_LSR_r10[] = {
  0x3c, 0xca, 0xce, 0x20 // sbc cs r12 r14 r12 LSR r10
};
const byte kInstruction_sbc_le_r9_r0_r6_ROR_r2[] = {
  0x76, 0x92, 0xc0, 0xd0 // sbc le r9 r0 r6 ROR r2
};
const byte kInstruction_sbc_cc_r3_r10_r4_LSR_r12[] = {
  0x34, 0x3c, 0xca, 0x30 // sbc cc r3 r10 r4 LSR r12
};
const byte kInstruction_sbc_mi_r4_r5_r2_ASR_r14[] = {
  0x52, 0x4e, 0xc5, 0x40 // sbc mi r4 r5 r2 ASR r14
};
const byte kInstruction_sbc_vc_r12_r8_r10_ROR_r14[] = {
  0x7a, 0xce, 0xc8, 0x70 // sbc vc r12 r8 r10 ROR r14
};
const byte kInstruction_sbc_al_r5_r14_r4_ASR_r10[] = {
  0x54, 0x5a, 0xce, 0xe0 // sbc al r5 r14 r4 ASR r10
};
const byte kInstruction_sbc_ls_r13_r8_r3_ASR_r1[] = {
  0x53, 0xd1, 0xc8, 0x90 // sbc ls r13 r8 r3 ASR r1
};
const byte kInstruction_sbc_le_r10_r1_r2_LSR_r4[] = {
  0x32, 0xa4, 0xc1, 0xd0 // sbc le r10 r1 r2 LSR r4
};
const byte kInstruction_sbc_ne_r0_r2_r10_ROR_r7[] = {
  0x7a, 0x07, 0xc2, 0x10 // sbc ne r0 r2 r10 ROR r7
};
const byte kInstruction_sbc_vs_r11_r13_r11_LSR_r12[] = {
  0x3b, 0xbc, 0xcd, 0x60 // sbc vs r11 r13 r11 LSR r12
};
const byte kInstruction_sbc_vs_r10_r10_r8_ROR_r8[] = {
  0x78, 0xa8, 0xca, 0x60 // sbc vs r10 r10 r8 ROR r8
};
const byte kInstruction_sbc_ne_r7_r2_r9_LSL_r11[] = {
  0x19, 0x7b, 0xc2, 0x10 // sbc ne r7 r2 r9 LSL r11
};
const byte kInstruction_sbc_mi_r5_r12_r11_ASR_r5[] = {
  0x5b, 0x55, 0xcc, 0x40 // sbc mi r5 r12 r11 ASR r5
};
const byte kInstruction_sbc_le_r1_r10_r5_ROR_r5[] = {
  0x75, 0x15, 0xca, 0xd0 // sbc le r1 r10 r5 ROR r5
};
const byte kInstruction_sbc_cc_r3_r14_r3_ASR_r6[] = {
  0x53, 0x36, 0xce, 0x30 // sbc cc r3 r14 r3 ASR r6
};
const byte kInstruction_sbc_vc_r4_r4_r0_ROR_r2[] = {
  0x70, 0x42, 0xc4, 0x70 // sbc vc r4 r4 r0 ROR r2
};
const byte kInstruction_sbc_le_r3_r4_r12_ROR_r14[] = {
  0x7c, 0x3e, 0xc4, 0xd0 // sbc le r3 r4 r12 ROR r14
};
const byte kInstruction_sbc_al_r3_r7_r14_LSL_r11[] = {
  0x1e, 0x3b, 0xc7, 0xe0 // sbc al r3 r7 r14 LSL r11
};
const byte kInstruction_sbc_vc_r8_r11_r0_LSL_r11[] = {
  0x10, 0x8b, 0xcb, 0x70 // sbc vc r8 r11 r0 LSL r11
};
const byte kInstruction_sbc_vs_r12_r9_r14_LSR_r2[] = {
  0x3e, 0xc2, 0xc9, 0x60 // sbc vs r12 r9 r14 LSR r2
};
const byte kInstruction_sbc_hi_r3_r5_r5_ROR_r6[] = {
  0x75, 0x36, 0xc5, 0x80 // sbc hi r3 r5 r5 ROR r6
};
const byte kInstruction_sbc_cs_r9_r3_r13_ASR_r7[] = {
  0x5d, 0x97, 0xc3, 0x20 // sbc cs r9 r3 r13 ASR r7
};
const byte kInstruction_sbc_eq_r14_r3_r6_LSR_r5[] = {
  0x36, 0xe5, 0xc3, 0x00 // sbc eq r14 r3 r6 LSR r5
};
const byte kInstruction_sbc_lt_r8_r3_r4_LSR_r13[] = {
  0x34, 0x8d, 0xc3, 0xb0 // sbc lt r8 r3 r4 LSR r13
};
const byte kInstruction_sbc_vc_r7_r4_r12_ROR_r6[] = {
  0x7c, 0x76, 0xc4, 0x70 // sbc vc r7 r4 r12 ROR r6
};
const byte kInstruction_sbc_vs_r5_r3_r3_ASR_r1[] = {
  0x53, 0x51, 0xc3, 0x60 // sbc vs r5 r3 r3 ASR r1
};
const byte kInstruction_sbc_le_r5_r6_r1_ROR_r7[] = {
  0x71, 0x57, 0xc6, 0xd0 // sbc le r5 r6 r1 ROR r7
};
const byte kInstruction_sbc_ge_r11_r5_r11_LSL_r12[] = {
  0x1b, 0xbc, 0xc5, 0xa0 // sbc ge r11 r5 r11 LSL r12
};
const byte kInstruction_sbc_lt_r0_r3_r7_ASR_r14[] = {
  0x57, 0x0e, 0xc3, 0xb0 // sbc lt r0 r3 r7 ASR r14
};
const byte kInstruction_sbc_cs_r9_r2_r10_LSL_r1[] = {
  0x1a, 0x91, 0xc2, 0x20 // sbc cs r9 r2 r10 LSL r1
};
const byte kInstruction_sbc_cs_r6_r8_r6_ASR_r1[] = {
  0x56, 0x61, 0xc8, 0x20 // sbc cs r6 r8 r6 ASR r1
};
const byte kInstruction_sbc_lt_r0_r11_r14_ASR_r5[] = {
  0x5e, 0x05, 0xcb, 0xb0 // sbc lt r0 r11 r14 ASR r5
};
const byte kInstruction_sbc_ge_r11_r11_r2_ASR_r3[] = {
  0x52, 0xb3, 0xcb, 0xa0 // sbc ge r11 r11 r2 ASR r3
};
const byte kInstruction_sbc_lt_r0_r0_r14_LSL_r2[] = {
  0x1e, 0x02, 0xc0, 0xb0 // sbc lt r0 r0 r14 LSL r2
};
const byte kInstruction_sbc_cs_r8_r9_r11_ROR_r8[] = {
  0x7b, 0x88, 0xc9, 0x20 // sbc cs r8 r9 r11 ROR r8
};
const byte kInstruction_sbc_pl_r9_r5_r12_ASR_r14[] = {
  0x5c, 0x9e, 0xc5, 0x50 // sbc pl r9 r5 r12 ASR r14
};
const byte kInstruction_sbc_eq_r13_r11_r1_LSR_r1[] = {
  0x31, 0xd1, 0xcb, 0x00 // sbc eq r13 r11 r1 LSR r1
};
const byte kInstruction_sbc_ne_r1_r0_r13_ROR_r0[] = {
  0x7d, 0x10, 0xc0, 0x10 // sbc ne r1 r0 r13 ROR r0
};
const byte kInstruction_sbc_hi_r6_r5_r9_LSR_r10[] = {
  0x39, 0x6a, 0xc5, 0x80 // sbc hi r6 r5 r9 LSR r10
};
const byte kInstruction_sbc_lt_r4_r7_r7_ASR_r9[] = {
  0x57, 0x49, 0xc7, 0xb0 // sbc lt r4 r7 r7 ASR r9
};
const byte kInstruction_sbc_ls_r13_r13_r5_LSR_r1[] = {
  0x35, 0xd1, 0xcd, 0x90 // sbc ls r13 r13 r5 LSR r1
};
const byte kInstruction_sbc_cs_r12_r1_r6_LSR_r14[] = {
  0x36, 0xce, 0xc1, 0x20 // sbc cs r12 r1 r6 LSR r14
};
const byte kInstruction_sbc_hi_r11_r0_r5_LSR_r3[] = {
  0x35, 0xb3, 0xc0, 0x80 // sbc hi r11 r0 r5 LSR r3
};
const byte kInstruction_sbc_ne_r5_r2_r14_LSR_r1[] = {
  0x3e, 0x51, 0xc2, 0x10 // sbc ne r5 r2 r14 LSR r1
};
const byte kInstruction_sbc_le_r6_r12_r9_LSR_r5[] = {
  0x39, 0x65, 0xcc, 0xd0 // sbc le r6 r12 r9 LSR r5
};
const byte kInstruction_sbc_cs_r1_r11_r1_LSL_r2[] = {
  0x11, 0x12, 0xcb, 0x20 // sbc cs r1 r11 r1 LSL r2
};
const byte kInstruction_sbc_al_r14_r10_r8_ASR_r4[] = {
  0x58, 0xe4, 0xca, 0xe0 // sbc al r14 r10 r8 ASR r4
};
const byte kInstruction_sbc_al_r11_r10_r8_LSL_r6[] = {
  0x18, 0xb6, 0xca, 0xe0 // sbc al r11 r10 r8 LSL r6
};
const byte kInstruction_sbc_vs_r1_r2_r1_LSL_r11[] = {
  0x11, 0x1b, 0xc2, 0x60 // sbc vs r1 r2 r1 LSL r11
};
const byte kInstruction_sbc_cs_r10_r14_r14_LSL_r0[] = {
  0x1e, 0xa0, 0xce, 0x20 // sbc cs r10 r14 r14 LSL r0
};
const byte kInstruction_sbc_pl_r0_r1_r14_ROR_r10[] = {
  0x7e, 0x0a, 0xc1, 0x50 // sbc pl r0 r1 r14 ROR r10
};
const byte kInstruction_sbc_pl_r3_r7_r5_LSR_r1[] = {
  0x35, 0x31, 0xc7, 0x50 // sbc pl r3 r7 r5 LSR r1
};
const byte kInstruction_sbc_gt_r2_r14_r10_LSL_r6[] = {
  0x1a, 0x26, 0xce, 0xc0 // sbc gt r2 r14 r10 LSL r6
};
const byte kInstruction_sbc_le_r7_r7_r8_ROR_r0[] = {
  0x78, 0x70, 0xc7, 0xd0 // sbc le r7 r7 r8 ROR r0
};
const byte kInstruction_sbc_cs_r7_r9_r8_LSL_r14[] = {
  0x18, 0x7e, 0xc9, 0x20 // sbc cs r7 r9 r8 LSL r14
};
const byte kInstruction_sbc_cs_r11_r4_r3_LSR_r10[] = {
  0x33, 0xba, 0xc4, 0x20 // sbc cs r11 r4 r3 LSR r10
};
const byte kInstruction_sbc_cc_r9_r1_r12_ROR_r4[] = {
  0x7c, 0x94, 0xc1, 0x30 // sbc cc r9 r1 r12 ROR r4
};
const byte kInstruction_sbc_hi_r10_r0_r10_LSL_r8[] = {
  0x1a, 0xa8, 0xc0, 0x80 // sbc hi r10 r0 r10 LSL r8
};
const byte kInstruction_sbc_eq_r14_r1_r0_LSL_r11[] = {
  0x10, 0xeb, 0xc1, 0x00 // sbc eq r14 r1 r0 LSL r11
};
const byte kInstruction_sbc_mi_r9_r11_r5_ROR_r5[] = {
  0x75, 0x95, 0xcb, 0x40 // sbc mi r9 r11 r5 ROR r5
};
const byte kInstruction_sbc_le_r5_r9_r2_LSL_r1[] = {
  0x12, 0x51, 0xc9, 0xd0 // sbc le r5 r9 r2 LSL r1
};
const byte kInstruction_sbc_pl_r7_r7_r8_ASR_r13[] = {
  0x58, 0x7d, 0xc7, 0x50 // sbc pl r7 r7 r8 ASR r13
};
const byte kInstruction_sbc_gt_r14_r13_r10_ASR_r11[] = {
  0x5a, 0xeb, 0xcd, 0xc0 // sbc gt r14 r13 r10 ASR r11
};
const byte kInstruction_sbc_cs_r4_r6_r5_LSR_r7[] = {
  0x35, 0x47, 0xc6, 0x20 // sbc cs r4 r6 r5 LSR r7
};
const byte kInstruction_sbc_lt_r2_r7_r7_LSL_r6[] = {
  0x17, 0x26, 0xc7, 0xb0 // sbc lt r2 r7 r7 LSL r6
};
const byte kInstruction_sbc_al_r4_r5_r2_ROR_r5[] = {
  0x72, 0x45, 0xc5, 0xe0 // sbc al r4 r5 r2 ROR r5
};
const byte kInstruction_sbc_cc_r6_r2_r9_ROR_r7[] = {
  0x79, 0x67, 0xc2, 0x30 // sbc cc r6 r2 r9 ROR r7
};
const byte kInstruction_sbc_pl_r4_r0_r0_LSR_r11[] = {
  0x30, 0x4b, 0xc0, 0x50 // sbc pl r4 r0 r0 LSR r11
};
const byte kInstruction_sbc_pl_r6_r10_r12_LSL_r11[] = {
  0x1c, 0x6b, 0xca, 0x50 // sbc pl r6 r10 r12 LSL r11
};
const byte kInstruction_sbc_al_r0_r14_r1_LSR_r6[] = {
  0x31, 0x06, 0xce, 0xe0 // sbc al r0 r14 r1 LSR r6
};
const byte kInstruction_sbc_cs_r7_r9_r13_LSR_r1[] = {
  0x3d, 0x71, 0xc9, 0x20 // sbc cs r7 r9 r13 LSR r1
};
const byte kInstruction_sbc_al_r4_r2_r10_ROR_r3[] = {
  0x7a, 0x43, 0xc2, 0xe0 // sbc al r4 r2 r10 ROR r3
};
const byte kInstruction_sbc_gt_r12_r4_r14_ROR_r7[] = {
  0x7e, 0xc7, 0xc4, 0xc0 // sbc gt r12 r4 r14 ROR r7
};
const byte kInstruction_sbc_cs_r11_r0_r14_ASR_r7[] = {
  0x5e, 0xb7, 0xc0, 0x20 // sbc cs r11 r0 r14 ASR r7
};
const byte kInstruction_sbc_pl_r0_r2_r4_ASR_r14[] = {
  0x54, 0x0e, 0xc2, 0x50 // sbc pl r0 r2 r4 ASR r14
};
const byte kInstruction_sbc_mi_r14_r4_r9_LSR_r5[] = {
  0x39, 0xe5, 0xc4, 0x40 // sbc mi r14 r4 r9 LSR r5
};
const byte kInstruction_sbc_ge_r13_r0_r1_ROR_r5[] = {
  0x71, 0xd5, 0xc0, 0xa0 // sbc ge r13 r0 r1 ROR r5
};
const byte kInstruction_sbc_eq_r12_r14_r0_LSL_r11[] = {
  0x10, 0xcb, 0xce, 0x00 // sbc eq r12 r14 r0 LSL r11
};
const byte kInstruction_sbc_ge_r6_r4_r10_ROR_r13[] = {
  0x7a, 0x6d, 0xc4, 0xa0 // sbc ge r6 r4 r10 ROR r13
};
const byte kInstruction_sbc_lt_r3_r7_r2_ASR_r5[] = {
  0x52, 0x35, 0xc7, 0xb0 // sbc lt r3 r7 r2 ASR r5
};
const byte kInstruction_sbc_al_r9_r0_r12_ROR_r0[] = {
  0x7c, 0x90, 0xc0, 0xe0 // sbc al r9 r0 r12 ROR r0
};
const byte kInstruction_sbc_le_r1_r9_r7_LSL_r12[] = {
  0x17, 0x1c, 0xc9, 0xd0 // sbc le r1 r9 r7 LSL r12
};
const byte kInstruction_sbc_lt_r14_r7_r4_ASR_r7[] = {
  0x54, 0xe7, 0xc7, 0xb0 // sbc lt r14 r7 r4 ASR r7
};
const byte kInstruction_sbc_ne_r4_r6_r9_LSR_r8[] = {
  0x39, 0x48, 0xc6, 0x10 // sbc ne r4 r6 r9 LSR r8
};
const byte kInstruction_sbc_cc_r0_r5_r1_ASR_r6[] = {
  0x51, 0x06, 0xc5, 0x30 // sbc cc r0 r5 r1 ASR r6
};
const byte kInstruction_sbc_cc_r2_r13_r2_ROR_r6[] = {
  0x72, 0x26, 0xcd, 0x30 // sbc cc r2 r13 r2 ROR r6
};
const byte kInstruction_sbc_ge_r10_r0_r9_ROR_r6[] = {
  0x79, 0xa6, 0xc0, 0xa0 // sbc ge r10 r0 r9 ROR r6
};
const byte kInstruction_sbc_gt_r8_r1_r11_LSR_r0[] = {
  0x3b, 0x80, 0xc1, 0xc0 // sbc gt r8 r1 r11 LSR r0
};
const byte kInstruction_sbc_al_r14_r0_r9_LSL_r0[] = {
  0x19, 0xe0, 0xc0, 0xe0 // sbc al r14 r0 r9 LSL r0
};
const byte kInstruction_sbc_hi_r12_r3_r12_ROR_r9[] = {
  0x7c, 0xc9, 0xc3, 0x80 // sbc hi r12 r3 r12 ROR r9
};
const byte kInstruction_sbc_eq_r4_r12_r3_LSL_r2[] = {
  0x13, 0x42, 0xcc, 0x00 // sbc eq r4 r12 r3 LSL r2
};
const byte kInstruction_sbc_ne_r5_r3_r4_LSL_r4[] = {
  0x14, 0x54, 0xc3, 0x10 // sbc ne r5 r3 r4 LSL r4
};
const byte kInstruction_sbc_vc_r8_r6_r10_LSL_r11[] = {
  0x1a, 0x8b, 0xc6, 0x70 // sbc vc r8 r6 r10 LSL r11
};
const byte kInstruction_sbc_lt_r0_r1_r4_ASR_r3[] = {
  0x54, 0x03, 0xc1, 0xb0 // sbc lt r0 r1 r4 ASR r3
};
const byte kInstruction_sbc_le_r14_r4_r1_ROR_r7[] = {
  0x71, 0xe7, 0xc4, 0xd0 // sbc le r14 r4 r1 ROR r7
};
const byte kInstruction_sbc_al_r12_r12_r5_LSL_r2[] = {
  0x15, 0xc2, 0xcc, 0xe0 // sbc al r12 r12 r5 LSL r2
};
const byte kInstruction_sbc_eq_r10_r3_r10_ROR_r13[] = {
  0x7a, 0xad, 0xc3, 0x00 // sbc eq r10 r3 r10 ROR r13
};
const byte kInstruction_sbc_ne_r7_r10_r1_LSR_r14[] = {
  0x31, 0x7e, 0xca, 0x10 // sbc ne r7 r10 r1 LSR r14
};
const byte kInstruction_sbc_lt_r10_r4_r10_LSR_r5[] = {
  0x3a, 0xa5, 0xc4, 0xb0 // sbc lt r10 r4 r10 LSR r5
};
const byte kInstruction_sbc_pl_r0_r14_r0_LSL_r2[] = {
  0x10, 0x02, 0xce, 0x50 // sbc pl r0 r14 r0 LSL r2
};
const byte kInstruction_sbc_gt_r7_r4_r11_LSL_r3[] = {
  0x1b, 0x73, 0xc4, 0xc0 // sbc gt r7 r4 r11 LSL r3
};
const byte kInstruction_sbc_cs_r8_r2_r1_LSR_r8[] = {
  0x31, 0x88, 0xc2, 0x20 // sbc cs r8 r2 r1 LSR r8
};
const byte kInstruction_sbc_pl_r9_r11_r4_ASR_r7[] = {
  0x54, 0x97, 0xcb, 0x50 // sbc pl r9 r11 r4 ASR r7
};
const byte kInstruction_sbc_cc_r9_r5_r12_ROR_r4[] = {
  0x7c, 0x94, 0xc5, 0x30 // sbc cc r9 r5 r12 ROR r4
};
const byte kInstruction_sbc_vc_r0_r11_r3_LSR_r12[] = {
  0x33, 0x0c, 0xcb, 0x70 // sbc vc r0 r11 r3 LSR r12
};
const byte kInstruction_sbc_gt_r6_r2_r4_LSR_r4[] = {
  0x34, 0x64, 0xc2, 0xc0 // sbc gt r6 r2 r4 LSR r4
};
const byte kInstruction_sbc_lt_r4_r2_r0_LSL_r12[] = {
  0x10, 0x4c, 0xc2, 0xb0 // sbc lt r4 r2 r0 LSL r12
};
const byte kInstruction_sbc_le_r9_r4_r13_ROR_r5[] = {
  0x7d, 0x95, 0xc4, 0xd0 // sbc le r9 r4 r13 ROR r5
};
const byte kInstruction_sbc_vs_r9_r3_r8_LSR_r8[] = {
  0x38, 0x98, 0xc3, 0x60 // sbc vs r9 r3 r8 LSR r8
};
const byte kInstruction_sbc_ne_r3_r8_r14_ROR_r8[] = {
  0x7e, 0x38, 0xc8, 0x10 // sbc ne r3 r8 r14 ROR r8
};
const byte kInstruction_sbc_vc_r12_r13_r4_LSR_r9[] = {
  0x34, 0xc9, 0xcd, 0x70 // sbc vc r12 r13 r4 LSR r9
};
const byte kInstruction_sbc_cc_r14_r0_r8_LSL_r1[] = {
  0x18, 0xe1, 0xc0, 0x30 // sbc cc r14 r0 r8 LSL r1
};
const byte kInstruction_sbc_hi_r6_r3_r5_ASR_r9[] = {
  0x55, 0x69, 0xc3, 0x80 // sbc hi r6 r3 r5 ASR r9
};
const byte kInstruction_sbc_ne_r14_r4_r3_LSL_r8[] = {
  0x13, 0xe8, 0xc4, 0x10 // sbc ne r14 r4 r3 LSL r8
};
const byte kInstruction_sbc_ge_r1_r10_r13_LSR_r4[] = {
  0x3d, 0x14, 0xca, 0xa0 // sbc ge r1 r10 r13 LSR r4
};
const byte kInstruction_sbc_vc_r12_r7_r6_ROR_r3[] = {
  0x76, 0xc3, 0xc7, 0x70 // sbc vc r12 r7 r6 ROR r3
};
const byte kInstruction_sbc_gt_r0_r6_r7_ROR_r2[] = {
  0x77, 0x02, 0xc6, 0xc0 // sbc gt r0 r6 r7 ROR r2
};
const byte kInstruction_sbc_al_r4_r6_r9_LSL_r0[] = {
  0x19, 0x40, 0xc6, 0xe0 // sbc al r4 r6 r9 LSL r0
};
const byte kInstruction_sbc_ls_r1_r3_r11_LSR_r11[] = {
  0x3b, 0x1b, 0xc3, 0x90 // sbc ls r1 r3 r11 LSR r11
};
const byte kInstruction_sbc_lt_r3_r11_r1_LSR_r14[] = {
  0x31, 0x3e, 0xcb, 0xb0 // sbc lt r3 r11 r1 LSR r14
};
const byte kInstruction_sbc_vc_r6_r13_r7_ROR_r11[] = {
  0x77, 0x6b, 0xcd, 0x70 // sbc vc r6 r13 r7 ROR r11
};
const byte kInstruction_sbc_vc_r5_r14_r13_ROR_r13[] = {
  0x7d, 0x5d, 0xce, 0x70 // sbc vc r5 r14 r13 ROR r13
};
const byte kInstruction_sbc_vc_r1_r4_r11_LSL_r1[] = {
  0x1b, 0x11, 0xc4, 0x70 // sbc vc r1 r4 r11 LSL r1
};
const byte kInstruction_sbc_ls_r7_r3_r5_LSR_r6[] = {
  0x35, 0x76, 0xc3, 0x90 // sbc ls r7 r3 r5 LSR r6
};
const byte kInstruction_sbc_vc_r13_r8_r3_ASR_r4[] = {
  0x53, 0xd4, 0xc8, 0x70 // sbc vc r13 r8 r3 ASR r4
};
const byte kInstruction_sbc_ls_r2_r3_r10_ROR_r11[] = {
  0x7a, 0x2b, 0xc3, 0x90 // sbc ls r2 r3 r10 ROR r11
};
const byte kInstruction_sbc_ge_r6_r1_r12_ASR_r11[] = {
  0x5c, 0x6b, 0xc1, 0xa0 // sbc ge r6 r1 r12 ASR r11
};
const byte kInstruction_sbc_lt_r3_r1_r1_ASR_r14[] = {
  0x51, 0x3e, 0xc1, 0xb0 // sbc lt r3 r1 r1 ASR r14
};
const byte kInstruction_sbc_hi_r2_r7_r14_LSL_r12[] = {
  0x1e, 0x2c, 0xc7, 0x80 // sbc hi r2 r7 r14 LSL r12
};
const byte kInstruction_sbc_ge_r13_r10_r10_LSL_r14[] = {
  0x1a, 0xde, 0xca, 0xa0 // sbc ge r13 r10 r10 LSL r14
};
const byte kInstruction_sbc_le_r0_r1_r3_LSR_r3[] = {
  0x33, 0x03, 0xc1, 0xd0 // sbc le r0 r1 r3 LSR r3
};
const byte kInstruction_sbc_vs_r10_r7_r7_LSR_r6[] = {
  0x37, 0xa6, 0xc7, 0x60 // sbc vs r10 r7 r7 LSR r6
};
const byte kInstruction_sbc_al_r6_r3_r6_LSL_r7[] = {
  0x16, 0x67, 0xc3, 0xe0 // sbc al r6 r3 r6 LSL r7
};
const byte kInstruction_sbc_ne_r3_r8_r14_ASR_r1[] = {
  0x5e, 0x31, 0xc8, 0x10 // sbc ne r3 r8 r14 ASR r1
};
const byte kInstruction_sbc_cc_r4_r10_r4_LSR_r9[] = {
  0x34, 0x49, 0xca, 0x30 // sbc cc r4 r10 r4 LSR r9
};
const byte kInstruction_sbc_cs_r4_r1_r5_LSR_r10[] = {
  0x35, 0x4a, 0xc1, 0x20 // sbc cs r4 r1 r5 LSR r10
};
const byte kInstruction_sbc_eq_r7_r6_r1_LSL_r4[] = {
  0x11, 0x74, 0xc6, 0x00 // sbc eq r7 r6 r1 LSL r4
};
const byte kInstruction_sbc_hi_r3_r7_r1_LSL_r5[] = {
  0x11, 0x35, 0xc7, 0x80 // sbc hi r3 r7 r1 LSL r5
};
const byte kInstruction_sbc_al_r6_r11_r8_LSR_r12[] = {
  0x38, 0x6c, 0xcb, 0xe0 // sbc al r6 r11 r8 LSR r12
};
const byte kInstruction_sbc_ls_r2_r5_r0_LSR_r5[] = {
  0x30, 0x25, 0xc5, 0x90 // sbc ls r2 r5 r0 LSR r5
};
const byte kInstruction_sbc_pl_r4_r5_r13_LSL_r9[] = {
  0x1d, 0x49, 0xc5, 0x50 // sbc pl r4 r5 r13 LSL r9
};
const byte kInstruction_sbc_lt_r13_r12_r0_ASR_r8[] = {
  0x50, 0xd8, 0xcc, 0xb0 // sbc lt r13 r12 r0 ASR r8
};
const byte kInstruction_sbc_cc_r11_r5_r0_LSL_r12[] = {
  0x10, 0xbc, 0xc5, 0x30 // sbc cc r11 r5 r0 LSL r12
};
const byte kInstruction_sbc_ne_r6_r2_r2_ROR_r0[] = {
  0x72, 0x60, 0xc2, 0x10 // sbc ne r6 r2 r2 ROR r0
};
const byte kInstruction_sbc_ne_r9_r13_r12_ASR_r6[] = {
  0x5c, 0x96, 0xcd, 0x10 // sbc ne r9 r13 r12 ASR r6
};
const byte kInstruction_sbc_cs_r8_r6_r10_ROR_r10[] = {
  0x7a, 0x8a, 0xc6, 0x20 // sbc cs r8 r6 r10 ROR r10
};
const byte kInstruction_sbc_vs_r10_r6_r1_LSL_r6[] = {
  0x11, 0xa6, 0xc6, 0x60 // sbc vs r10 r6 r1 LSL r6
};
const byte kInstruction_sbc_vc_r12_r0_r4_ASR_r10[] = {
  0x54, 0xca, 0xc0, 0x70 // sbc vc r12 r0 r4 ASR r10
};
const byte kInstruction_sbc_cs_r10_r2_r11_ROR_r8[] = {
  0x7b, 0xa8, 0xc2, 0x20 // sbc cs r10 r2 r11 ROR r8
};
const byte kInstruction_sbc_ne_r0_r9_r14_ASR_r14[] = {
  0x5e, 0x0e, 0xc9, 0x10 // sbc ne r0 r9 r14 ASR r14
};
const byte kInstruction_sbc_eq_r0_r10_r1_ASR_r8[] = {
  0x51, 0x08, 0xca, 0x00 // sbc eq r0 r10 r1 ASR r8
};
const byte kInstruction_sbc_gt_r0_r11_r3_LSR_r0[] = {
  0x33, 0x00, 0xcb, 0xc0 // sbc gt r0 r11 r3 LSR r0
};
const byte kInstruction_sbc_al_r5_r11_r6_ROR_r14[] = {
  0x76, 0x5e, 0xcb, 0xe0 // sbc al r5 r11 r6 ROR r14
};
const byte kInstruction_sbc_ls_r2_r11_r11_ROR_r2[] = {
  0x7b, 0x22, 0xcb, 0x90 // sbc ls r2 r11 r11 ROR r2
};
const byte kInstruction_sbc_cs_r2_r11_r6_ROR_r11[] = {
  0x76, 0x2b, 0xcb, 0x20 // sbc cs r2 r11 r6 ROR r11
};
const byte kInstruction_sbc_cs_r4_r9_r11_ASR_r5[] = {
  0x5b, 0x45, 0xc9, 0x20 // sbc cs r4 r9 r11 ASR r5
};
const byte kInstruction_sbc_ls_r5_r0_r2_ASR_r3[] = {
  0x52, 0x53, 0xc0, 0x90 // sbc ls r5 r0 r2 ASR r3
};
const byte kInstruction_sbc_cc_r14_r1_r13_LSR_r2[] = {
  0x3d, 0xe2, 0xc1, 0x30 // sbc cc r14 r1 r13 LSR r2
};
const byte kInstruction_sbc_lt_r4_r5_r6_ASR_r0[] = {
  0x56, 0x40, 0xc5, 0xb0 // sbc lt r4 r5 r6 ASR r0
};
const byte kInstruction_sbc_vc_r0_r12_r6_ASR_r6[] = {
  0x56, 0x06, 0xcc, 0x70 // sbc vc r0 r12 r6 ASR r6
};
const byte kInstruction_sbc_pl_r3_r10_r4_LSR_r8[] = {
  0x34, 0x38, 0xca, 0x50 // sbc pl r3 r10 r4 LSR r8
};
const byte kInstruction_sbc_cc_r10_r5_r10_ASR_r10[] = {
  0x5a, 0xaa, 0xc5, 0x30 // sbc cc r10 r5 r10 ASR r10
};
const byte kInstruction_sbc_pl_r2_r14_r1_ASR_r10[] = {
  0x51, 0x2a, 0xce, 0x50 // sbc pl r2 r14 r1 ASR r10
};
const byte kInstruction_sbc_eq_r12_r13_r8_ROR_r12[] = {
  0x78, 0xcc, 0xcd, 0x00 // sbc eq r12 r13 r8 ROR r12
};
const byte kInstruction_sbc_gt_r9_r8_r2_LSL_r2[] = {
  0x12, 0x92, 0xc8, 0xc0 // sbc gt r9 r8 r2 LSL r2
};
const byte kInstruction_sbc_al_r13_r10_r10_LSL_r9[] = {
  0x1a, 0xd9, 0xca, 0xe0 // sbc al r13 r10 r10 LSL r9
};
const byte kInstruction_sbc_eq_r8_r8_r6_ROR_r14[] = {
  0x76, 0x8e, 0xc8, 0x00 // sbc eq r8 r8 r6 ROR r14
};
const byte kInstruction_sbc_le_r14_r12_r4_ASR_r13[] = {
  0x54, 0xed, 0xcc, 0xd0 // sbc le r14 r12 r4 ASR r13
};
const byte kInstruction_sbc_cc_r3_r6_r12_LSR_r2[] = {
  0x3c, 0x32, 0xc6, 0x30 // sbc cc r3 r6 r12 LSR r2
};
const byte kInstruction_sbc_ls_r5_r14_r10_LSL_r6[] = {
  0x1a, 0x56, 0xce, 0x90 // sbc ls r5 r14 r10 LSL r6
};
const byte kInstruction_sbc_hi_r12_r2_r1_ROR_r3[] = {
  0x71, 0xc3, 0xc2, 0x80 // sbc hi r12 r2 r1 ROR r3
};
const byte kInstruction_sbc_vc_r7_r13_r1_LSL_r12[] = {
  0x11, 0x7c, 0xcd, 0x70 // sbc vc r7 r13 r1 LSL r12
};
const byte kInstruction_sbc_cc_r0_r3_r13_LSL_r9[] = {
  0x1d, 0x09, 0xc3, 0x30 // sbc cc r0 r3 r13 LSL r9
};
const byte kInstruction_sbc_hi_r0_r11_r5_LSL_r11[] = {
  0x15, 0x0b, 0xcb, 0x80 // sbc hi r0 r11 r5 LSL r11
};
const byte kInstruction_sbc_ge_r9_r6_r14_LSR_r14[] = {
  0x3e, 0x9e, 0xc6, 0xa0 // sbc ge r9 r6 r14 LSR r14
};
const byte kInstruction_sbc_vc_r2_r5_r2_ROR_r12[] = {
  0x72, 0x2c, 0xc5, 0x70 // sbc vc r2 r5 r2 ROR r12
};
const byte kInstruction_sbc_mi_r9_r6_r9_ASR_r13[] = {
  0x59, 0x9d, 0xc6, 0x40 // sbc mi r9 r6 r9 ASR r13
};
const byte kInstruction_sbc_pl_r1_r3_r10_ASR_r2[] = {
  0x5a, 0x12, 0xc3, 0x50 // sbc pl r1 r3 r10 ASR r2
};
const byte kInstruction_sbc_le_r10_r9_r7_LSL_r4[] = {
  0x17, 0xa4, 0xc9, 0xd0 // sbc le r10 r9 r7 LSL r4
};
const byte kInstruction_sbc_hi_r7_r4_r10_LSR_r6[] = {
  0x3a, 0x76, 0xc4, 0x80 // sbc hi r7 r4 r10 LSR r6
};
const byte kInstruction_sbc_cc_r6_r8_r13_LSR_r3[] = {
  0x3d, 0x63, 0xc8, 0x30 // sbc cc r6 r8 r13 LSR r3
};
const byte kInstruction_sbc_cs_r4_r9_r6_ASR_r0[] = {
  0x56, 0x40, 0xc9, 0x20 // sbc cs r4 r9 r6 ASR r0
};
const byte kInstruction_sbc_ls_r0_r2_r4_ASR_r8[] = {
  0x54, 0x08, 0xc2, 0x90 // sbc ls r0 r2 r4 ASR r8
};
const byte kInstruction_sbc_hi_r11_r5_r11_LSR_r1[] = {
  0x3b, 0xb1, 0xc5, 0x80 // sbc hi r11 r5 r11 LSR r1
};
const byte kInstruction_sbc_vc_r0_r3_r6_LSR_r7[] = {
  0x36, 0x07, 0xc3, 0x70 // sbc vc r0 r3 r6 LSR r7
};
const byte kInstruction_sbc_cs_r13_r10_r8_LSL_r6[] = {
  0x18, 0xd6, 0xca, 0x20 // sbc cs r13 r10 r8 LSL r6
};
const byte kInstruction_sbc_al_r12_r12_r10_ASR_r13[] = {
  0x5a, 0xcd, 0xcc, 0xe0 // sbc al r12 r12 r10 ASR r13
};
const byte kInstruction_sbc_ge_r7_r7_r2_ASR_r8[] = {
  0x52, 0x78, 0xc7, 0xa0 // sbc ge r7 r7 r2 ASR r8
};
const byte kInstruction_sbc_ne_r10_r7_r6_LSL_r14[] = {
  0x16, 0xae, 0xc7, 0x10 // sbc ne r10 r7 r6 LSL r14
};
const byte kInstruction_sbc_cs_r9_r9_r14_ROR_r0[] = {
  0x7e, 0x90, 0xc9, 0x20 // sbc cs r9 r9 r14 ROR r0
};
const byte kInstruction_sbc_lt_r3_r12_r0_ASR_r12[] = {
  0x50, 0x3c, 0xcc, 0xb0 // sbc lt r3 r12 r0 ASR r12
};
const byte kInstruction_sbc_ne_r6_r9_r3_ASR_r11[] = {
  0x53, 0x6b, 0xc9, 0x10 // sbc ne r6 r9 r3 ASR r11
};
const byte kInstruction_sbc_vc_r4_r7_r7_ASR_r7[] = {
  0x57, 0x47, 0xc7, 0x70 // sbc vc r4 r7 r7 ASR r7
};
const byte kInstruction_sbc_ne_r0_r9_r5_LSR_r14[] = {
  0x35, 0x0e, 0xc9, 0x10 // sbc ne r0 r9 r5 LSR r14
};
const byte kInstruction_sbc_hi_r8_r13_r1_ROR_r0[] = {
  0x71, 0x80, 0xcd, 0x80 // sbc hi r8 r13 r1 ROR r0
};
const byte kInstruction_sbc_cc_r6_r1_r7_ROR_r5[] = {
  0x77, 0x65, 0xc1, 0x30 // sbc cc r6 r1 r7 ROR r5
};
const byte kInstruction_sbc_vc_r7_r13_r2_LSL_r4[] = {
  0x12, 0x74, 0xcd, 0x70 // sbc vc r7 r13 r2 LSL r4
};
const byte kInstruction_sbc_al_r4_r2_r3_ROR_r10[] = {
  0x73, 0x4a, 0xc2, 0xe0 // sbc al r4 r2 r3 ROR r10
};
const byte kInstruction_sbc_ls_r0_r7_r3_LSR_r12[] = {
  0x33, 0x0c, 0xc7, 0x90 // sbc ls r0 r7 r3 LSR r12
};
const byte kInstruction_sbc_ls_r5_r8_r8_ASR_r13[] = {
  0x58, 0x5d, 0xc8, 0x90 // sbc ls r5 r8 r8 ASR r13
};
const byte kInstruction_sbc_gt_r0_r6_r12_ASR_r14[] = {
  0x5c, 0x0e, 0xc6, 0xc0 // sbc gt r0 r6 r12 ASR r14
};
const byte kInstruction_sbc_vs_r7_r13_r14_LSR_r11[] = {
  0x3e, 0x7b, 0xcd, 0x60 // sbc vs r7 r13 r14 LSR r11
};
const byte kInstruction_sbc_mi_r12_r9_r11_LSL_r13[] = {
  0x1b, 0xcd, 0xc9, 0x40 // sbc mi r12 r9 r11 LSL r13
};
const byte kInstruction_sbc_ge_r0_r0_r7_ROR_r13[] = {
  0x77, 0x0d, 0xc0, 0xa0 // sbc ge r0 r0 r7 ROR r13
};
const byte kInstruction_sbc_hi_r14_r12_r6_LSR_r8[] = {
  0x36, 0xe8, 0xcc, 0x80 // sbc hi r14 r12 r6 LSR r8
};
const byte kInstruction_sbc_cs_r0_r3_r6_LSL_r6[] = {
  0x16, 0x06, 0xc3, 0x20 // sbc cs r0 r3 r6 LSL r6
};
const byte kInstruction_sbc_al_r6_r9_r4_ASR_r3[] = {
  0x54, 0x63, 0xc9, 0xe0 // sbc al r6 r9 r4 ASR r3
};
const byte kInstruction_sbc_ls_r5_r6_r1_LSR_r3[] = {
  0x31, 0x53, 0xc6, 0x90 // sbc ls r5 r6 r1 LSR r3
};
const byte kInstruction_sbc_ls_r3_r6_r14_ROR_r7[] = {
  0x7e, 0x37, 0xc6, 0x90 // sbc ls r3 r6 r14 ROR r7
};
const byte kInstruction_sbc_le_r10_r5_r1_ASR_r12[] = {
  0x51, 0xac, 0xc5, 0xd0 // sbc le r10 r5 r1 ASR r12
};
const byte kInstruction_sbc_hi_r3_r6_r10_ASR_r5[] = {
  0x5a, 0x35, 0xc6, 0x80 // sbc hi r3 r6 r10 ASR r5
};
const byte kInstruction_sbc_mi_r9_r3_r5_ROR_r8[] = {
  0x75, 0x98, 0xc3, 0x40 // sbc mi r9 r3 r5 ROR r8
};
const byte kInstruction_sbc_hi_r10_r13_r8_ROR_r11[] = {
  0x78, 0xab, 0xcd, 0x80 // sbc hi r10 r13 r8 ROR r11
};
const byte kInstruction_sbc_al_r11_r14_r2_ROR_r1[] = {
  0x72, 0xb1, 0xce, 0xe0 // sbc al r11 r14 r2 ROR r1
};
const byte kInstruction_sbc_gt_r12_r8_r0_ROR_r11[] = {
  0x70, 0xcb, 0xc8, 0xc0 // sbc gt r12 r8 r0 ROR r11
};
const byte kInstruction_sbc_vc_r1_r0_r1_ROR_r9[] = {
  0x71, 0x19, 0xc0, 0x70 // sbc vc r1 r0 r1 ROR r9
};
const byte kInstruction_sbc_mi_r6_r6_r3_ASR_r5[] = {
  0x53, 0x65, 0xc6, 0x40 // sbc mi r6 r6 r3 ASR r5
};
const byte kInstruction_sbc_ge_r12_r12_r4_ROR_r9[] = {
  0x74, 0xc9, 0xcc, 0xa0 // sbc ge r12 r12 r4 ROR r9
};
const byte kInstruction_sbc_ls_r4_r6_r9_ASR_r6[] = {
  0x59, 0x46, 0xc6, 0x90 // sbc ls r4 r6 r9 ASR r6
};
const byte kInstruction_sbc_pl_r11_r3_r4_LSR_r9[] = {
  0x34, 0xb9, 0xc3, 0x50 // sbc pl r11 r3 r4 LSR r9
};
const byte kInstruction_sbc_hi_r0_r2_r2_ROR_r7[] = {
  0x72, 0x07, 0xc2, 0x80 // sbc hi r0 r2 r2 ROR r7
};
const byte kInstruction_sbc_pl_r3_r12_r0_ASR_r2[] = {
  0x50, 0x32, 0xcc, 0x50 // sbc pl r3 r12 r0 ASR r2
};
const byte kInstruction_sbc_ne_r6_r0_r9_LSL_r4[] = {
  0x19, 0x64, 0xc0, 0x10 // sbc ne r6 r0 r9 LSL r4
};
const byte kInstruction_sbc_vc_r1_r2_r6_ROR_r13[] = {
  0x76, 0x1d, 0xc2, 0x70 // sbc vc r1 r2 r6 ROR r13
};
const byte kInstruction_sbc_ge_r9_r1_r12_LSL_r14[] = {
  0x1c, 0x9e, 0xc1, 0xa0 // sbc ge r9 r1 r12 LSL r14
};
const byte kInstruction_sbc_pl_r13_r9_r6_ROR_r14[] = {
  0x76, 0xde, 0xc9, 0x50 // sbc pl r13 r9 r6 ROR r14
};
const byte kInstruction_sbc_gt_r0_r13_r13_LSL_r9[] = {
  0x1d, 0x09, 0xcd, 0xc0 // sbc gt r0 r13 r13 LSL r9
};
const byte kInstruction_sbc_mi_r13_r5_r5_ASR_r8[] = {
  0x55, 0xd8, 0xc5, 0x40 // sbc mi r13 r5 r5 ASR r8
};
const byte kInstruction_sbc_gt_r1_r4_r0_LSL_r6[] = {
  0x10, 0x16, 0xc4, 0xc0 // sbc gt r1 r4 r0 LSL r6
};
const byte kInstruction_sbc_ls_r5_r4_r7_ROR_r4[] = {
  0x77, 0x54, 0xc4, 0x90 // sbc ls r5 r4 r7 ROR r4
};
const byte kInstruction_sbc_vc_r8_r8_r0_ROR_r9[] = {
  0x70, 0x89, 0xc8, 0x70 // sbc vc r8 r8 r0 ROR r9
};
const byte kInstruction_sbc_mi_r12_r12_r10_ROR_r8[] = {
  0x7a, 0xc8, 0xcc, 0x40 // sbc mi r12 r12 r10 ROR r8
};
const byte kInstruction_sbc_hi_r6_r6_r6_LSL_r2[] = {
  0x16, 0x62, 0xc6, 0x80 // sbc hi r6 r6 r6 LSL r2
};
const byte kInstruction_sbc_le_r7_r10_r14_LSL_r1[] = {
  0x1e, 0x71, 0xca, 0xd0 // sbc le r7 r10 r14 LSL r1
};
const byte kInstruction_sbc_ne_r13_r10_r6_ASR_r9[] = {
  0x56, 0xd9, 0xca, 0x10 // sbc ne r13 r10 r6 ASR r9
};
const byte kInstruction_sbc_ne_r8_r8_r2_LSR_r13[] = {
  0x32, 0x8d, 0xc8, 0x10 // sbc ne r8 r8 r2 LSR r13
};
const byte kInstruction_sbc_mi_r0_r10_r14_ROR_r12[] = {
  0x7e, 0x0c, 0xca, 0x40 // sbc mi r0 r10 r14 ROR r12
};
const byte kInstruction_sbc_cc_r11_r14_r4_LSL_r5[] = {
  0x14, 0xb5, 0xce, 0x30 // sbc cc r11 r14 r4 LSL r5
};
const byte kInstruction_sbc_cc_r3_r6_r3_ROR_r4[] = {
  0x73, 0x34, 0xc6, 0x30 // sbc cc r3 r6 r3 ROR r4
};
const byte kInstruction_sbc_mi_r11_r1_r7_LSR_r7[] = {
  0x37, 0xb7, 0xc1, 0x40 // sbc mi r11 r1 r7 LSR r7
};
const byte kInstruction_sbc_vs_r12_r2_r2_LSL_r12[] = {
  0x12, 0xcc, 0xc2, 0x60 // sbc vs r12 r2 r2 LSL r12
};
const byte kInstruction_sbc_pl_r2_r2_r6_LSR_r0[] = {
  0x36, 0x20, 0xc2, 0x50 // sbc pl r2 r2 r6 LSR r0
};
const byte kInstruction_sbc_gt_r11_r12_r7_LSR_r12[] = {
  0x37, 0xbc, 0xcc, 0xc0 // sbc gt r11 r12 r7 LSR r12
};
const byte kInstruction_sbc_al_r13_r4_r4_ASR_r12[] = {
  0x54, 0xdc, 0xc4, 0xe0 // sbc al r13 r4 r4 ASR r12
};
const byte kInstruction_sbc_le_r9_r1_r9_ROR_r1[] = {
  0x79, 0x91, 0xc1, 0xd0 // sbc le r9 r1 r9 ROR r1
};
const byte kInstruction_sbc_le_r1_r12_r8_ASR_r14[] = {
  0x58, 0x1e, 0xcc, 0xd0 // sbc le r1 r12 r8 ASR r14
};
const byte kInstruction_sbc_cs_r1_r0_r7_ROR_r13[] = {
  0x77, 0x1d, 0xc0, 0x20 // sbc cs r1 r0 r7 ROR r13
};
const byte kInstruction_sbc_le_r0_r7_r7_ROR_r5[] = {
  0x77, 0x05, 0xc7, 0xd0 // sbc le r0 r7 r7 ROR r5
};
const byte kInstruction_sbc_hi_r6_r5_r7_ROR_r4[] = {
  0x77, 0x64, 0xc5, 0x80 // sbc hi r6 r5 r7 ROR r4
};
const byte kInstruction_sbc_eq_r6_r14_r13_ASR_r1[] = {
  0x5d, 0x61, 0xce, 0x00 // sbc eq r6 r14 r13 ASR r1
};
const byte kInstruction_sbc_lt_r1_r14_r13_LSR_r13[] = {
  0x3d, 0x1d, 0xce, 0xb0 // sbc lt r1 r14 r13 LSR r13
};
const byte kInstruction_sbc_vs_r13_r1_r2_ROR_r6[] = {
  0x72, 0xd6, 0xc1, 0x60 // sbc vs r13 r1 r2 ROR r6
};
const byte kInstruction_sbc_gt_r11_r7_r8_ASR_r3[] = {
  0x58, 0xb3, 0xc7, 0xc0 // sbc gt r11 r7 r8 ASR r3
};
const byte kInstruction_sbc_hi_r9_r5_r8_ASR_r8[] = {
  0x58, 0x98, 0xc5, 0x80 // sbc hi r9 r5 r8 ASR r8
};
const byte kInstruction_sbc_lt_r10_r9_r5_LSL_r8[] = {
  0x15, 0xa8, 0xc9, 0xb0 // sbc lt r10 r9 r5 LSL r8
};
const byte kInstruction_sbc_vs_r6_r1_r2_LSL_r4[] = {
  0x12, 0x64, 0xc1, 0x60 // sbc vs r6 r1 r2 LSL r4
};
const byte kInstruction_sbc_pl_r13_r4_r10_LSR_r12[] = {
  0x3a, 0xdc, 0xc4, 0x50 // sbc pl r13 r4 r10 LSR r12
};
const byte kInstruction_sbc_cs_r9_r8_r8_LSL_r6[] = {
  0x18, 0x96, 0xc8, 0x20 // sbc cs r9 r8 r8 LSL r6
};
const byte kInstruction_sbc_ne_r1_r7_r0_ASR_r2[] = {
  0x50, 0x12, 0xc7, 0x10 // sbc ne r1 r7 r0 ASR r2
};
const byte kInstruction_sbc_cc_r6_r3_r9_ASR_r3[] = {
  0x59, 0x63, 0xc3, 0x30 // sbc cc r6 r3 r9 ASR r3
};
const byte kInstruction_sbc_hi_r13_r14_r7_ROR_r13[] = {
  0x77, 0xdd, 0xce, 0x80 // sbc hi r13 r14 r7 ROR r13
};
const byte kInstruction_sbc_vc_r7_r11_r0_LSR_r8[] = {
  0x30, 0x78, 0xcb, 0x70 // sbc vc r7 r11 r0 LSR r8
};
const byte kInstruction_sbc_al_r3_r2_r7_LSL_r12[] = {
  0x17, 0x3c, 0xc2, 0xe0 // sbc al r3 r2 r7 LSL r12
};
const byte kInstruction_sbc_lt_r0_r5_r5_LSR_r1[] = {
  0x35, 0x01, 0xc5, 0xb0 // sbc lt r0 r5 r5 LSR r1
};
const byte kInstruction_sbc_ge_r10_r10_r4_ROR_r11[] = {
  0x74, 0xab, 0xca, 0xa0 // sbc ge r10 r10 r4 ROR r11
};
const byte kInstruction_sbc_ne_r13_r9_r1_ROR_r12[] = {
  0x71, 0xdc, 0xc9, 0x10 // sbc ne r13 r9 r1 ROR r12
};
const byte kInstruction_sbc_eq_r6_r6_r2_ROR_r3[] = {
  0x72, 0x63, 0xc6, 0x00 // sbc eq r6 r6 r2 ROR r3
};
const byte kInstruction_sbc_gt_r0_r4_r1_ROR_r5[] = {
  0x71, 0x05, 0xc4, 0xc0 // sbc gt r0 r4 r1 ROR r5
};
const byte kInstruction_sbc_lt_r5_r8_r0_ROR_r0[] = {
  0x70, 0x50, 0xc8, 0xb0 // sbc lt r5 r8 r0 ROR r0
};
const byte kInstruction_sbc_cs_r5_r13_r2_LSR_r8[] = {
  0x32, 0x58, 0xcd, 0x20 // sbc cs r5 r13 r2 LSR r8
};
const byte kInstruction_sbc_le_r7_r13_r2_LSL_r7[] = {
  0x12, 0x77, 0xcd, 0xd0 // sbc le r7 r13 r2 LSL r7
};
const byte kInstruction_sbc_gt_r7_r1_r3_LSL_r1[] = {
  0x13, 0x71, 0xc1, 0xc0 // sbc gt r7 r1 r3 LSL r1
};
const byte kInstruction_sbc_vc_r4_r13_r10_ROR_r8[] = {
  0x7a, 0x48, 0xcd, 0x70 // sbc vc r4 r13 r10 ROR r8
};
const byte kInstruction_sbc_eq_r2_r8_r11_ROR_r4[] = {
  0x7b, 0x24, 0xc8, 0x00 // sbc eq r2 r8 r11 ROR r4
};
const byte kInstruction_sbc_le_r10_r1_r6_LSR_r9[] = {
  0x36, 0xa9, 0xc1, 0xd0 // sbc le r10 r1 r6 LSR r9
};
const byte kInstruction_sbc_ge_r5_r1_r9_ASR_r10[] = {
  0x59, 0x5a, 0xc1, 0xa0 // sbc ge r5 r1 r9 ASR r10
};
const byte kInstruction_sbc_al_r1_r5_r5_LSR_r7[] = {
  0x35, 0x17, 0xc5, 0xe0 // sbc al r1 r5 r5 LSR r7
};
const byte kInstruction_sbc_cs_r2_r13_r5_LSR_r8[] = {
  0x35, 0x28, 0xcd, 0x20 // sbc cs r2 r13 r5 LSR r8
};
const byte kInstruction_sbc_le_r6_r6_r3_ROR_r3[] = {
  0x73, 0x63, 0xc6, 0xd0 // sbc le r6 r6 r3 ROR r3
};
const byte kInstruction_sbc_le_r5_r1_r7_ROR_r12[] = {
  0x77, 0x5c, 0xc1, 0xd0 // sbc le r5 r1 r7 ROR r12
};
const byte kInstruction_sbc_cc_r9_r3_r9_ASR_r4[] = {
  0x59, 0x94, 0xc3, 0x30 // sbc cc r9 r3 r9 ASR r4
};
const byte kInstruction_sbc_mi_r6_r2_r9_LSL_r5[] = {
  0x19, 0x65, 0xc2, 0x40 // sbc mi r6 r2 r9 LSL r5
};
const byte kInstruction_sbc_cc_r5_r0_r4_ASR_r12[] = {
  0x54, 0x5c, 0xc0, 0x30 // sbc cc r5 r0 r4 ASR r12
};
const byte kInstruction_sbc_vc_r8_r13_r12_LSL_r11[] = {
  0x1c, 0x8b, 0xcd, 0x70 // sbc vc r8 r13 r12 LSL r11
};
const byte kInstruction_sbc_lt_r7_r14_r9_LSR_r11[] = {
  0x39, 0x7b, 0xce, 0xb0 // sbc lt r7 r14 r9 LSR r11
};
const byte kInstruction_sbc_cs_r1_r5_r3_ASR_r1[] = {
  0x53, 0x11, 0xc5, 0x20 // sbc cs r1 r5 r3 ASR r1
};
const byte kInstruction_sbc_lt_r14_r11_r6_ASR_r9[] = {
  0x56, 0xe9, 0xcb, 0xb0 // sbc lt r14 r11 r6 ASR r9
};
const byte kInstruction_sbc_gt_r10_r5_r13_LSR_r3[] = {
  0x3d, 0xa3, 0xc5, 0xc0 // sbc gt r10 r5 r13 LSR r3
};
const byte kInstruction_sbc_cc_r6_r4_r12_LSL_r4[] = {
  0x1c, 0x64, 0xc4, 0x30 // sbc cc r6 r4 r12 LSL r4
};
const byte kInstruction_sbc_ne_r2_r12_r10_ROR_r11[] = {
  0x7a, 0x2b, 0xcc, 0x10 // sbc ne r2 r12 r10 ROR r11
};
const byte kInstruction_sbc_eq_r8_r0_r6_ASR_r10[] = {
  0x56, 0x8a, 0xc0, 0x00 // sbc eq r8 r0 r6 ASR r10
};
const byte kInstruction_sbc_cc_r14_r3_r14_LSR_r7[] = {
  0x3e, 0xe7, 0xc3, 0x30 // sbc cc r14 r3 r14 LSR r7
};
const byte kInstruction_sbc_lt_r1_r10_r1_ASR_r13[] = {
  0x51, 0x1d, 0xca, 0xb0 // sbc lt r1 r10 r1 ASR r13
};
const byte kInstruction_sbc_cc_r14_r3_r0_LSL_r12[] = {
  0x10, 0xec, 0xc3, 0x30 // sbc cc r14 r3 r0 LSL r12
};
const byte kInstruction_sbc_vs_r8_r10_r7_LSL_r2[] = {
  0x17, 0x82, 0xca, 0x60 // sbc vs r8 r10 r7 LSL r2
};
const byte kInstruction_sbc_ls_r5_r6_r3_ASR_r2[] = {
  0x53, 0x52, 0xc6, 0x90 // sbc ls r5 r6 r3 ASR r2
};
const byte kInstruction_sbc_vc_r11_r5_r13_LSL_r10[] = {
  0x1d, 0xba, 0xc5, 0x70 // sbc vc r11 r5 r13 LSL r10
};
const byte kInstruction_sbc_hi_r2_r10_r7_LSR_r0[] = {
  0x37, 0x20, 0xca, 0x80 // sbc hi r2 r10 r7 LSR r0
};
const byte kInstruction_sbc_ne_r5_r6_r8_ASR_r4[] = {
  0x58, 0x54, 0xc6, 0x10 // sbc ne r5 r6 r8 ASR r4
};
const byte kInstruction_sbc_cs_r3_r12_r8_ASR_r5[] = {
  0x58, 0x35, 0xcc, 0x20 // sbc cs r3 r12 r8 ASR r5
};
const byte kInstruction_sbc_ge_r3_r4_r4_LSR_r0[] = {
  0x34, 0x30, 0xc4, 0xa0 // sbc ge r3 r4 r4 LSR r0
};
const byte kInstruction_sbc_ge_r13_r13_r6_ROR_r13[] = {
  0x76, 0xdd, 0xcd, 0xa0 // sbc ge r13 r13 r6 ROR r13
};
const byte kInstruction_sbc_eq_r4_r9_r0_LSL_r9[] = {
  0x10, 0x49, 0xc9, 0x00 // sbc eq r4 r9 r0 LSL r9
};
const byte kInstruction_sbc_le_r7_r3_r1_ROR_r8[] = {
  0x71, 0x78, 0xc3, 0xd0 // sbc le r7 r3 r1 ROR r8
};
const byte kInstruction_sbc_gt_r9_r2_r5_LSL_r4[] = {
  0x15, 0x94, 0xc2, 0xc0 // sbc gt r9 r2 r5 LSL r4
};
const byte kInstruction_sbc_gt_r10_r12_r9_ROR_r12[] = {
  0x79, 0xac, 0xcc, 0xc0 // sbc gt r10 r12 r9 ROR r12
};
const byte kInstruction_sbc_hi_r4_r9_r6_LSR_r14[] = {
  0x36, 0x4e, 0xc9, 0x80 // sbc hi r4 r9 r6 LSR r14
};
const byte kInstruction_sbc_pl_r1_r10_r9_LSR_r8[] = {
  0x39, 0x18, 0xca, 0x50 // sbc pl r1 r10 r9 LSR r8
};
const byte kInstruction_sbc_mi_r0_r11_r2_ROR_r13[] = {
  0x72, 0x0d, 0xcb, 0x40 // sbc mi r0 r11 r2 ROR r13
};
const byte kInstruction_sbc_ge_r14_r5_r4_ASR_r2[] = {
  0x54, 0xe2, 0xc5, 0xa0 // sbc ge r14 r5 r4 ASR r2
};
const byte kInstruction_sbc_vc_r7_r8_r9_ROR_r10[] = {
  0x79, 0x7a, 0xc8, 0x70 // sbc vc r7 r8 r9 ROR r10
};
const byte kInstruction_sbc_cs_r3_r1_r0_ROR_r7[] = {
  0x70, 0x37, 0xc1, 0x20 // sbc cs r3 r1 r0 ROR r7
};
const byte kInstruction_sbc_hi_r9_r11_r4_ASR_r14[] = {
  0x54, 0x9e, 0xcb, 0x80 // sbc hi r9 r11 r4 ASR r14
};
const byte kInstruction_sbc_mi_r3_r8_r6_LSR_r12[] = {
  0x36, 0x3c, 0xc8, 0x40 // sbc mi r3 r8 r6 LSR r12
};
const byte kInstruction_sbc_vc_r5_r5_r6_LSL_r1[] = {
  0x16, 0x51, 0xc5, 0x70 // sbc vc r5 r5 r6 LSL r1
};
const byte kInstruction_sbc_mi_r4_r8_r1_ASR_r3[] = {
  0x51, 0x43, 0xc8, 0x40 // sbc mi r4 r8 r1 ASR r3
};
const byte kInstruction_sbc_le_r6_r0_r0_LSL_r0[] = {
  0x10, 0x60, 0xc0, 0xd0 // sbc le r6 r0 r0 LSL r0
};
const byte kInstruction_sbc_hi_r8_r11_r8_LSL_r14[] = {
  0x18, 0x8e, 0xcb, 0x80 // sbc hi r8 r11 r8 LSL r14
};
const byte kInstruction_sbc_gt_r14_r8_r12_ASR_r13[] = {
  0x5c, 0xed, 0xc8, 0xc0 // sbc gt r14 r8 r12 ASR r13
};
const byte kInstruction_sbc_ge_r7_r7_r4_ROR_r7[] = {
  0x74, 0x77, 0xc7, 0xa0 // sbc ge r7 r7 r4 ROR r7
};
const byte kInstruction_sbc_eq_r11_r4_r13_LSL_r3[] = {
  0x1d, 0xb3, 0xc4, 0x00 // sbc eq r11 r4 r13 LSL r3
};
const byte kInstruction_sbc_eq_r3_r6_r6_LSL_r10[] = {
  0x16, 0x3a, 0xc6, 0x00 // sbc eq r3 r6 r6 LSL r10
};
const byte kInstruction_sbc_al_r3_r10_r11_ROR_r12[] = {
  0x7b, 0x3c, 0xca, 0xe0 // sbc al r3 r10 r11 ROR r12
};
const byte kInstruction_sbc_pl_r13_r7_r8_LSL_r13[] = {
  0x18, 0xdd, 0xc7, 0x50 // sbc pl r13 r7 r8 LSL r13
};
const byte kInstruction_sbc_pl_r9_r2_r11_LSR_r2[] = {
  0x3b, 0x92, 0xc2, 0x50 // sbc pl r9 r2 r11 LSR r2
};
const byte kInstruction_sbc_al_r3_r12_r8_LSR_r2[] = {
  0x38, 0x32, 0xcc, 0xe0 // sbc al r3 r12 r8 LSR r2
};
const byte kInstruction_sbc_ne_r4_r14_r6_ROR_r0[] = {
  0x76, 0x40, 0xce, 0x10 // sbc ne r4 r14 r6 ROR r0
};
const byte kInstruction_sbc_cs_r6_r14_r13_ASR_r3[] = {
  0x5d, 0x63, 0xce, 0x20 // sbc cs r6 r14 r13 ASR r3
};
const byte kInstruction_sbc_pl_r10_r6_r8_LSR_r7[] = {
  0x38, 0xa7, 0xc6, 0x50 // sbc pl r10 r6 r8 LSR r7
};
const byte kInstruction_sbc_ls_r10_r1_r12_ROR_r6[] = {
  0x7c, 0xa6, 0xc1, 0x90 // sbc ls r10 r1 r12 ROR r6
};
const byte kInstruction_sbc_eq_r12_r0_r1_LSL_r9[] = {
  0x11, 0xc9, 0xc0, 0x00 // sbc eq r12 r0 r1 LSL r9
};
const byte kInstruction_sbc_hi_r11_r14_r8_ROR_r6[] = {
  0x78, 0xb6, 0xce, 0x80 // sbc hi r11 r14 r8 ROR r6
};
const byte kInstruction_sbc_vc_r9_r2_r5_LSL_r6[] = {
  0x15, 0x96, 0xc2, 0x70 // sbc vc r9 r2 r5 LSL r6
};
const byte kInstruction_sbc_ne_r11_r8_r5_LSR_r11[] = {
  0x35, 0xbb, 0xc8, 0x10 // sbc ne r11 r8 r5 LSR r11
};
const byte kInstruction_sbc_mi_r1_r12_r3_ASR_r5[] = {
  0x53, 0x15, 0xcc, 0x40 // sbc mi r1 r12 r3 ASR r5
};
const byte kInstruction_sbc_pl_r14_r7_r1_ASR_r12[] = {
  0x51, 0xec, 0xc7, 0x50 // sbc pl r14 r7 r1 ASR r12
};
const byte kInstruction_sbc_pl_r9_r4_r1_ASR_r1[] = {
  0x51, 0x91, 0xc4, 0x50 // sbc pl r9 r4 r1 ASR r1
};
const byte kInstruction_sbc_ls_r11_r0_r5_ROR_r14[] = {
  0x75, 0xbe, 0xc0, 0x90 // sbc ls r11 r0 r5 ROR r14
};
const byte kInstruction_sbc_lt_r13_r10_r14_ROR_r13[] = {
  0x7e, 0xdd, 0xca, 0xb0 // sbc lt r13 r10 r14 ROR r13
};
const byte kInstruction_sbc_gt_r3_r14_r10_LSR_r4[] = {
  0x3a, 0x34, 0xce, 0xc0 // sbc gt r3 r14 r10 LSR r4
};
const byte kInstruction_sbc_cc_r1_r0_r5_ROR_r7[] = {
  0x75, 0x17, 0xc0, 0x30 // sbc cc r1 r0 r5 ROR r7
};
const byte kInstruction_sbc_hi_r2_r14_r0_LSR_r14[] = {
  0x30, 0x2e, 0xce, 0x80 // sbc hi r2 r14 r0 LSR r14
};
const byte kInstruction_sbc_pl_r3_r7_r2_ASR_r9[] = {
  0x52, 0x39, 0xc7, 0x50 // sbc pl r3 r7 r2 ASR r9
};
const byte kInstruction_sbc_eq_r7_r5_r0_ROR_r6[] = {
  0x70, 0x76, 0xc5, 0x00 // sbc eq r7 r5 r0 ROR r6
};
const byte kInstruction_sbc_mi_r14_r9_r14_LSR_r5[] = {
  0x3e, 0xe5, 0xc9, 0x40 // sbc mi r14 r9 r14 LSR r5
};
const byte kInstruction_sbc_mi_r6_r1_r1_LSL_r12[] = {
  0x11, 0x6c, 0xc1, 0x40 // sbc mi r6 r1 r1 LSL r12
};
const byte kInstruction_sbc_ge_r12_r0_r8_LSR_r0[] = {
  0x38, 0xc0, 0xc0, 0xa0 // sbc ge r12 r0 r8 LSR r0
};
const byte kInstruction_sbc_cc_r13_r8_r3_ROR_r7[] = {
  0x73, 0xd7, 0xc8, 0x30 // sbc cc r13 r8 r3 ROR r7
};
const byte kInstruction_sbc_vs_r7_r9_r4_LSL_r11[] = {
  0x14, 0x7b, 0xc9, 0x60 // sbc vs r7 r9 r4 LSL r11
};
const byte kInstruction_sbc_ge_r9_r10_r9_LSR_r5[] = {
  0x39, 0x95, 0xca, 0xa0 // sbc ge r9 r10 r9 LSR r5
};
const byte kInstruction_sbc_ls_r5_r3_r0_LSR_r7[] = {
  0x30, 0x57, 0xc3, 0x90 // sbc ls r5 r3 r0 LSR r7
};
const byte kInstruction_sbc_eq_r0_r6_r1_LSL_r11[] = {
  0x11, 0x0b, 0xc6, 0x00 // sbc eq r0 r6 r1 LSL r11
};
const byte kInstruction_sbc_ge_r9_r7_r0_ROR_r11[] = {
  0x70, 0x9b, 0xc7, 0xa0 // sbc ge r9 r7 r0 ROR r11
};
const byte kInstruction_sbc_mi_r4_r2_r3_LSL_r12[] = {
  0x13, 0x4c, 0xc2, 0x40 // sbc mi r4 r2 r3 LSL r12
};
const byte kInstruction_sbc_hi_r7_r5_r0_ASR_r5[] = {
  0x50, 0x75, 0xc5, 0x80 // sbc hi r7 r5 r0 ASR r5
};
const byte kInstruction_sbc_cc_r7_r13_r7_LSL_r14[] = {
  0x17, 0x7e, 0xcd, 0x30 // sbc cc r7 r13 r7 LSL r14
};
const byte kInstruction_sbc_ne_r2_r11_r2_LSL_r14[] = {
  0x12, 0x2e, 0xcb, 0x10 // sbc ne r2 r11 r2 LSL r14
};
const byte kInstruction_sbc_cc_r7_r5_r3_LSR_r11[] = {
  0x33, 0x7b, 0xc5, 0x30 // sbc cc r7 r5 r3 LSR r11
};
const byte kInstruction_sbc_ge_r12_r0_r12_ASR_r10[] = {
  0x5c, 0xca, 0xc0, 0xa0 // sbc ge r12 r0 r12 ASR r10
};
const byte kInstruction_sbc_al_r11_r0_r2_LSR_r11[] = {
  0x32, 0xbb, 0xc0, 0xe0 // sbc al r11 r0 r2 LSR r11
};
const byte kInstruction_sbc_cc_r1_r12_r1_ROR_r1[] = {
  0x71, 0x11, 0xcc, 0x30 // sbc cc r1 r12 r1 ROR r1
};
const byte kInstruction_sbc_ls_r5_r9_r6_ASR_r4[] = {
  0x56, 0x54, 0xc9, 0x90 // sbc ls r5 r9 r6 ASR r4
};
const byte kInstruction_sbc_ne_r5_r13_r2_ROR_r12[] = {
  0x72, 0x5c, 0xcd, 0x10 // sbc ne r5 r13 r2 ROR r12
};
const byte kInstruction_sbc_ge_r9_r10_r12_ROR_r10[] = {
  0x7c, 0x9a, 0xca, 0xa0 // sbc ge r9 r10 r12 ROR r10
};
const byte kInstruction_sbc_cc_r10_r1_r8_LSR_r12[] = {
  0x38, 0xac, 0xc1, 0x30 // sbc cc r10 r1 r8 LSR r12
};
const byte kInstruction_sbc_le_r9_r6_r11_ROR_r3[] = {
  0x7b, 0x93, 0xc6, 0xd0 // sbc le r9 r6 r11 ROR r3
};
const byte kInstruction_sbc_le_r9_r9_r13_ASR_r5[] = {
  0x5d, 0x95, 0xc9, 0xd0 // sbc le r9 r9 r13 ASR r5
};
const byte kInstruction_sbc_ge_r1_r12_r11_LSL_r12[] = {
  0x1b, 0x1c, 0xcc, 0xa0 // sbc ge r1 r12 r11 LSL r12
};
const byte kInstruction_sbc_vs_r11_r4_r6_LSL_r10[] = {
  0x16, 0xba, 0xc4, 0x60 // sbc vs r11 r4 r6 LSL r10
};
const byte kInstruction_sbc_vs_r3_r3_r1_ROR_r2[] = {
  0x71, 0x32, 0xc3, 0x60 // sbc vs r3 r3 r1 ROR r2
};
const byte kInstruction_sbc_ne_r12_r8_r12_ASR_r11[] = {
  0x5c, 0xcb, 0xc8, 0x10 // sbc ne r12 r8 r12 ASR r11
};
const byte kInstruction_sbc_pl_r4_r8_r1_ROR_r8[] = {
  0x71, 0x48, 0xc8, 0x50 // sbc pl r4 r8 r1 ROR r8
};
const byte kInstruction_sbc_gt_r3_r11_r13_ROR_r9[] = {
  0x7d, 0x39, 0xcb, 0xc0 // sbc gt r3 r11 r13 ROR r9
};
const byte kInstruction_sbc_pl_r6_r0_r3_LSR_r9[] = {
  0x33, 0x69, 0xc0, 0x50 // sbc pl r6 r0 r3 LSR r9
};
const byte kInstruction_sbc_ne_r5_r7_r9_LSL_r10[] = {
  0x19, 0x5a, 0xc7, 0x10 // sbc ne r5 r7 r9 LSL r10
};
const byte kInstruction_sbc_lt_r1_r12_r12_LSR_r8[] = {
  0x3c, 0x18, 0xcc, 0xb0 // sbc lt r1 r12 r12 LSR r8
};
const byte kInstruction_sbc_cc_r2_r0_r0_ROR_r5[] = {
  0x70, 0x25, 0xc0, 0x30 // sbc cc r2 r0 r0 ROR r5
};
const byte kInstruction_sbc_vc_r7_r11_r8_LSR_r14[] = {
  0x38, 0x7e, 0xcb, 0x70 // sbc vc r7 r11 r8 LSR r14
};
const byte kInstruction_sbc_ge_r0_r11_r6_ROR_r10[] = {
  0x76, 0x0a, 0xcb, 0xa0 // sbc ge r0 r11 r6 ROR r10
};
const byte kInstruction_sbc_vs_r0_r9_r1_LSR_r0[] = {
  0x31, 0x00, 0xc9, 0x60 // sbc vs r0 r9 r1 LSR r0
};
const byte kInstruction_sbc_gt_r13_r7_r11_LSR_r1[] = {
  0x3b, 0xd1, 0xc7, 0xc0 // sbc gt r13 r7 r11 LSR r1
};
const byte kInstruction_sbc_eq_r9_r10_r2_ROR_r12[] = {
  0x72, 0x9c, 0xca, 0x00 // sbc eq r9 r10 r2 ROR r12
};
const byte kInstruction_sbc_eq_r0_r4_r0_LSR_r3[] = {
  0x30, 0x03, 0xc4, 0x00 // sbc eq r0 r4 r0 LSR r3
};
const byte kInstruction_sbc_cs_r14_r2_r9_ASR_r12[] = {
  0x59, 0xec, 0xc2, 0x20 // sbc cs r14 r2 r9 ASR r12
};
const byte kInstruction_sbc_lt_r9_r4_r9_ASR_r8[] = {
  0x59, 0x98, 0xc4, 0xb0 // sbc lt r9 r4 r9 ASR r8
};
const byte kInstruction_sbc_vs_r6_r12_r3_LSL_r11[] = {
  0x13, 0x6b, 0xcc, 0x60 // sbc vs r6 r12 r3 LSL r11
};
const byte kInstruction_sbc_ge_r9_r14_r10_ROR_r0[] = {
  0x7a, 0x90, 0xce, 0xa0 // sbc ge r9 r14 r10 ROR r0
};
const byte kInstruction_sbc_pl_r10_r2_r5_LSL_r12[] = {
  0x15, 0xac, 0xc2, 0x50 // sbc pl r10 r2 r5 LSL r12
};
const byte kInstruction_sbc_al_r8_r0_r6_ROR_r6[] = {
  0x76, 0x86, 0xc0, 0xe0 // sbc al r8 r0 r6 ROR r6
};
const byte kInstruction_sbc_le_r9_r7_r7_LSR_r11[] = {
  0x37, 0x9b, 0xc7, 0xd0 // sbc le r9 r7 r7 LSR r11
};
const byte kInstruction_sbc_vc_r3_r4_r5_LSR_r1[] = {
  0x35, 0x31, 0xc4, 0x70 // sbc vc r3 r4 r5 LSR r1
};
const byte kInstruction_sbc_cc_r13_r1_r4_LSR_r11[] = {
  0x34, 0xdb, 0xc1, 0x30 // sbc cc r13 r1 r4 LSR r11
};
const byte kInstruction_sbc_vc_r13_r4_r0_LSL_r10[] = {
  0x10, 0xda, 0xc4, 0x70 // sbc vc r13 r4 r0 LSL r10
};
const byte kInstruction_sbc_vc_r5_r0_r1_LSR_r1[] = {
  0x31, 0x51, 0xc0, 0x70 // sbc vc r5 r0 r1 LSR r1
};
const byte kInstruction_sbc_ls_r5_r11_r1_ASR_r9[] = {
  0x51, 0x59, 0xcb, 0x90 // sbc ls r5 r11 r1 ASR r9
};
const byte kInstruction_sbc_vs_r3_r2_r8_ASR_r1[] = {
  0x58, 0x31, 0xc2, 0x60 // sbc vs r3 r2 r8 ASR r1
};
const byte kInstruction_sbc_hi_r8_r4_r6_ASR_r4[] = {
  0x56, 0x84, 0xc4, 0x80 // sbc hi r8 r4 r6 ASR r4
};
const byte kInstruction_sbc_mi_r11_r12_r14_ASR_r13[] = {
  0x5e, 0xbd, 0xcc, 0x40 // sbc mi r11 r12 r14 ASR r13
};
const byte kInstruction_sbc_gt_r7_r12_r12_LSL_r14[] = {
  0x1c, 0x7e, 0xcc, 0xc0 // sbc gt r7 r12 r12 LSL r14
};
const byte kInstruction_sbc_ge_r11_r4_r9_LSR_r7[] = {
  0x39, 0xb7, 0xc4, 0xa0 // sbc ge r11 r4 r9 LSR r7
};
const byte kInstruction_sbc_vs_r0_r4_r10_LSL_r2[] = {
  0x1a, 0x02, 0xc4, 0x60 // sbc vs r0 r4 r10 LSL r2
};
const byte kInstruction_sbc_pl_r6_r4_r13_ASR_r0[] = {
  0x5d, 0x60, 0xc4, 0x50 // sbc pl r6 r4 r13 ASR r0
};
const byte kInstruction_sbc_eq_r2_r3_r11_ROR_r1[] = {
  0x7b, 0x21, 0xc3, 0x00 // sbc eq r2 r3 r11 ROR r1
};
const byte kInstruction_sbc_vs_r10_r9_r0_LSL_r4[] = {
  0x10, 0xa4, 0xc9, 0x60 // sbc vs r10 r9 r0 LSL r4
};
const byte kInstruction_sbc_cs_r0_r7_r10_LSL_r0[] = {
  0x1a, 0x00, 0xc7, 0x20 // sbc cs r0 r7 r10 LSL r0
};
const byte kInstruction_sbc_eq_r11_r2_r3_ASR_r13[] = {
  0x53, 0xbd, 0xc2, 0x00 // sbc eq r11 r2 r3 ASR r13
};
const byte kInstruction_sbc_eq_r14_r3_r7_ASR_r14[] = {
  0x57, 0xee, 0xc3, 0x00 // sbc eq r14 r3 r7 ASR r14
};
const byte kInstruction_sbc_gt_r0_r2_r0_LSL_r12[] = {
  0x10, 0x0c, 0xc2, 0xc0 // sbc gt r0 r2 r0 LSL r12
};
const byte kInstruction_sbc_mi_r0_r12_r6_LSR_r13[] = {
  0x36, 0x0d, 0xcc, 0x40 // sbc mi r0 r12 r6 LSR r13
};
const byte kInstruction_sbc_gt_r4_r4_r9_LSR_r12[] = {
  0x39, 0x4c, 0xc4, 0xc0 // sbc gt r4 r4 r9 LSR r12
};
const byte kInstruction_sbc_vc_r6_r7_r10_ROR_r2[] = {
  0x7a, 0x62, 0xc7, 0x70 // sbc vc r6 r7 r10 ROR r2
};
const byte kInstruction_sbc_lt_r10_r8_r13_ROR_r13[] = {
  0x7d, 0xad, 0xc8, 0xb0 // sbc lt r10 r8 r13 ROR r13
};
const byte kInstruction_sbc_lt_r13_r10_r4_ROR_r0[] = {
  0x74, 0xd0, 0xca, 0xb0 // sbc lt r13 r10 r4 ROR r0
};
const byte kInstruction_sbc_pl_r1_r6_r0_LSR_r12[] = {
  0x30, 0x1c, 0xc6, 0x50 // sbc pl r1 r6 r0 LSR r12
};
const byte kInstruction_sbc_ge_r14_r7_r1_LSR_r8[] = {
  0x31, 0xe8, 0xc7, 0xa0 // sbc ge r14 r7 r1 LSR r8
};
const byte kInstruction_sbc_cc_r8_r13_r6_LSL_r13[] = {
  0x16, 0x8d, 0xcd, 0x30 // sbc cc r8 r13 r6 LSL r13
};
const byte kInstruction_sbc_gt_r13_r4_r7_LSR_r2[] = {
  0x37, 0xd2, 0xc4, 0xc0 // sbc gt r13 r4 r7 LSR r2
};
const byte kInstruction_sbc_eq_r11_r3_r5_LSR_r3[] = {
  0x35, 0xb3, 0xc3, 0x00 // sbc eq r11 r3 r5 LSR r3
};
const byte kInstruction_sbc_vc_r8_r11_r2_ROR_r7[] = {
  0x72, 0x87, 0xcb, 0x70 // sbc vc r8 r11 r2 ROR r7
};
const byte kInstruction_sbc_vc_r11_r2_r0_LSL_r2[] = {
  0x10, 0xb2, 0xc2, 0x70 // sbc vc r11 r2 r0 LSL r2
};
const byte kInstruction_sbc_cs_r9_r11_r11_LSL_r11[] = {
  0x1b, 0x9b, 0xcb, 0x20 // sbc cs r9 r11 r11 LSL r11
};
const byte kInstruction_sbc_ge_r14_r4_r12_LSL_r11[] = {
  0x1c, 0xeb, 0xc4, 0xa0 // sbc ge r14 r4 r12 LSL r11
};
const byte kInstruction_sbc_vs_r4_r10_r3_LSL_r1[] = {
  0x13, 0x41, 0xca, 0x60 // sbc vs r4 r10 r3 LSL r1
};
const byte kInstruction_sbc_mi_r13_r1_r8_LSR_r2[] = {
  0x38, 0xd2, 0xc1, 0x40 // sbc mi r13 r1 r8 LSR r2
};
const byte kInstruction_sbc_le_r3_r13_r13_LSL_r8[] = {
  0x1d, 0x38, 0xcd, 0xd0 // sbc le r3 r13 r13 LSL r8
};
const byte kInstruction_sbc_mi_r9_r12_r8_LSR_r14[] = {
  0x38, 0x9e, 0xcc, 0x40 // sbc mi r9 r12 r8 LSR r14
};
const byte kInstruction_sbc_pl_r7_r11_r10_ASR_r2[] = {
  0x5a, 0x72, 0xcb, 0x50 // sbc pl r7 r11 r10 ASR r2
};
const byte kInstruction_sbc_lt_r12_r2_r9_ASR_r5[] = {
  0x59, 0xc5, 0xc2, 0xb0 // sbc lt r12 r2 r9 ASR r5
};
const byte kInstruction_sbc_gt_r13_r0_r5_LSL_r2[] = {
  0x15, 0xd2, 0xc0, 0xc0 // sbc gt r13 r0 r5 LSL r2
};
const byte kInstruction_sbc_le_r5_r10_r9_ROR_r0[] = {
  0x79, 0x50, 0xca, 0xd0 // sbc le r5 r10 r9 ROR r0
};
const byte kInstruction_sbc_lt_r6_r1_r4_ASR_r11[] = {
  0x54, 0x6b, 0xc1, 0xb0 // sbc lt r6 r1 r4 ASR r11
};
const byte kInstruction_sbc_pl_r11_r5_r14_LSR_r4[] = {
  0x3e, 0xb4, 0xc5, 0x50 // sbc pl r11 r5 r14 LSR r4
};
const byte kInstruction_sbc_eq_r9_r0_r6_ROR_r9[] = {
  0x76, 0x99, 0xc0, 0x00 // sbc eq r9 r0 r6 ROR r9
};
const byte kInstruction_sbc_mi_r3_r11_r2_ASR_r4[] = {
  0x52, 0x34, 0xcb, 0x40 // sbc mi r3 r11 r2 ASR r4
};
const byte kInstruction_sbc_pl_r13_r8_r0_ROR_r6[] = {
  0x70, 0xd6, 0xc8, 0x50 // sbc pl r13 r8 r0 ROR r6
};
const byte kInstruction_sbc_vc_r8_r2_r6_ASR_r4[] = {
  0x56, 0x84, 0xc2, 0x70 // sbc vc r8 r2 r6 ASR r4
};
const byte kInstruction_sbc_ge_r1_r0_r4_ASR_r1[] = {
  0x54, 0x11, 0xc0, 0xa0 // sbc ge r1 r0 r4 ASR r1
};
const byte kInstruction_sbc_vc_r2_r4_r13_LSL_r13[] = {
  0x1d, 0x2d, 0xc4, 0x70 // sbc vc r2 r4 r13 LSL r13
};
const byte kInstruction_sbc_lt_r4_r3_r5_ASR_r11[] = {
  0x55, 0x4b, 0xc3, 0xb0 // sbc lt r4 r3 r5 ASR r11
};
const byte kInstruction_sbc_pl_r5_r12_r3_LSL_r4[] = {
  0x13, 0x54, 0xcc, 0x50 // sbc pl r5 r12 r3 LSL r4
};
const byte kInstruction_sbc_pl_r14_r6_r6_LSR_r10[] = {
  0x36, 0xea, 0xc6, 0x50 // sbc pl r14 r6 r6 LSR r10
};
const byte kInstruction_sbc_gt_r14_r13_r3_LSL_r9[] = {
  0x13, 0xe9, 0xcd, 0xc0 // sbc gt r14 r13 r3 LSL r9
};
const byte kInstruction_sbc_pl_r10_r9_r4_LSL_r3[] = {
  0x14, 0xa3, 0xc9, 0x50 // sbc pl r10 r9 r4 LSL r3
};
const byte kInstruction_sbc_al_r10_r8_r4_ROR_r1[] = {
  0x74, 0xa1, 0xc8, 0xe0 // sbc al r10 r8 r4 ROR r1
};
const byte kInstruction_sbc_pl_r14_r9_r11_ASR_r13[] = {
  0x5b, 0xed, 0xc9, 0x50 // sbc pl r14 r9 r11 ASR r13
};
const byte kInstruction_sbc_cc_r8_r1_r4_ROR_r12[] = {
  0x74, 0x8c, 0xc1, 0x30 // sbc cc r8 r1 r4 ROR r12
};
const byte kInstruction_sbc_vs_r5_r14_r7_LSR_r0[] = {
  0x37, 0x50, 0xce, 0x60 // sbc vs r5 r14 r7 LSR r0
};
const byte kInstruction_sbc_gt_r1_r10_r13_ROR_r9[] = {
  0x7d, 0x19, 0xca, 0xc0 // sbc gt r1 r10 r13 ROR r9
};
const byte kInstruction_sbc_mi_r8_r14_r9_LSR_r5[] = {
  0x39, 0x85, 0xce, 0x40 // sbc mi r8 r14 r9 LSR r5
};
const byte kInstruction_sbc_ge_r12_r10_r7_ROR_r2[] = {
  0x77, 0xc2, 0xca, 0xa0 // sbc ge r12 r10 r7 ROR r2
};
const byte kInstruction_sbc_al_r11_r8_r1_LSR_r10[] = {
  0x31, 0xba, 0xc8, 0xe0 // sbc al r11 r8 r1 LSR r10
};
const byte kInstruction_sbc_al_r7_r13_r11_LSL_r14[] = {
  0x1b, 0x7e, 0xcd, 0xe0 // sbc al r7 r13 r11 LSL r14
};
const byte kInstruction_sbc_vc_r13_r11_r11_ASR_r9[] = {
  0x5b, 0xd9, 0xcb, 0x70 // sbc vc r13 r11 r11 ASR r9
};
const byte kInstruction_sbc_gt_r10_r5_r11_LSR_r14[] = {
  0x3b, 0xae, 0xc5, 0xc0 // sbc gt r10 r5 r11 LSR r14
};
const byte kInstruction_sbc_vc_r10_r11_r7_ROR_r3[] = {
  0x77, 0xa3, 0xcb, 0x70 // sbc vc r10 r11 r7 ROR r3
};
const byte kInstruction_sbc_le_r10_r2_r7_LSL_r6[] = {
  0x17, 0xa6, 0xc2, 0xd0 // sbc le r10 r2 r7 LSL r6
};
const byte kInstruction_sbc_al_r1_r3_r6_ASR_r5[] = {
  0x56, 0x15, 0xc3, 0xe0 // sbc al r1 r3 r6 ASR r5
};
const byte kInstruction_sbc_cs_r14_r9_r7_LSL_r12[] = {
  0x17, 0xec, 0xc9, 0x20 // sbc cs r14 r9 r7 LSL r12
};
const byte kInstruction_sbc_ls_r10_r1_r4_LSL_r4[] = {
  0x14, 0xa4, 0xc1, 0x90 // sbc ls r10 r1 r4 LSL r4
};
const byte kInstruction_sbc_vs_r2_r5_r4_ROR_r3[] = {
  0x74, 0x23, 0xc5, 0x60 // sbc vs r2 r5 r4 ROR r3
};
const byte kInstruction_sbc_vs_r1_r7_r10_ASR_r0[] = {
  0x5a, 0x10, 0xc7, 0x60 // sbc vs r1 r7 r10 ASR r0
};
const byte kInstruction_sbc_cs_r10_r12_r0_LSR_r4[] = {
  0x30, 0xa4, 0xcc, 0x20 // sbc cs r10 r12 r0 LSR r4
};
const byte kInstruction_sbc_vs_r8_r8_r1_LSR_r13[] = {
  0x31, 0x8d, 0xc8, 0x60 // sbc vs r8 r8 r1 LSR r13
};
const byte kInstruction_sbc_mi_r14_r5_r9_LSR_r7[] = {
  0x39, 0xe7, 0xc5, 0x40 // sbc mi r14 r5 r9 LSR r7
};
const byte kInstruction_sbc_vs_r6_r6_r14_ASR_r8[] = {
  0x5e, 0x68, 0xc6, 0x60 // sbc vs r6 r6 r14 ASR r8
};
const byte kInstruction_sbc_vc_r0_r1_r14_ROR_r0[] = {
  0x7e, 0x00, 0xc1, 0x70 // sbc vc r0 r1 r14 ROR r0
};
const byte kInstruction_sbc_ls_r9_r3_r11_ASR_r3[] = {
  0x5b, 0x93, 0xc3, 0x90 // sbc ls r9 r3 r11 ASR r3
};
const byte kInstruction_sbc_ls_r1_r12_r1_ASR_r6[] = {
  0x51, 0x16, 0xcc, 0x90 // sbc ls r1 r12 r1 ASR r6
};
const byte kInstruction_sbc_hi_r6_r10_r0_ASR_r2[] = {
  0x50, 0x62, 0xca, 0x80 // sbc hi r6 r10 r0 ASR r2
};
const byte kInstruction_sbc_vc_r6_r14_r7_ASR_r1[] = {
  0x57, 0x61, 0xce, 0x70 // sbc vc r6 r14 r7 ASR r1
};
const byte kInstruction_sbc_eq_r14_r11_r10_LSL_r13[] = {
  0x1a, 0xed, 0xcb, 0x00 // sbc eq r14 r11 r10 LSL r13
};
const byte kInstruction_sbc_ge_r6_r12_r5_LSR_r9[] = {
  0x35, 0x69, 0xcc, 0xa0 // sbc ge r6 r12 r5 LSR r9
};
const byte kInstruction_sbc_mi_r1_r5_r0_ROR_r9[] = {
  0x70, 0x19, 0xc5, 0x40 // sbc mi r1 r5 r0 ROR r9
};
const byte kInstruction_sbc_al_r7_r8_r2_ROR_r4[] = {
  0x72, 0x74, 0xc8, 0xe0 // sbc al r7 r8 r2 ROR r4
};
const byte kInstruction_sbc_hi_r8_r1_r5_ASR_r10[] = {
  0x55, 0x8a, 0xc1, 0x80 // sbc hi r8 r1 r5 ASR r10
};
const byte kInstruction_sbc_ne_r14_r5_r0_LSR_r7[] = {
  0x30, 0xe7, 0xc5, 0x10 // sbc ne r14 r5 r0 LSR r7
};
const byte kInstruction_sbc_vc_r3_r13_r9_LSL_r9[] = {
  0x19, 0x39, 0xcd, 0x70 // sbc vc r3 r13 r9 LSL r9
};
const byte kInstruction_sbc_vs_r2_r2_r7_LSL_r5[] = {
  0x17, 0x25, 0xc2, 0x60 // sbc vs r2 r2 r7 LSL r5
};
const byte kInstruction_sbc_vc_r7_r3_r6_ASR_r6[] = {
  0x56, 0x76, 0xc3, 0x70 // sbc vc r7 r3 r6 ASR r6
};
const byte kInstruction_sbc_eq_r2_r5_r8_ROR_r1[] = {
  0x78, 0x21, 0xc5, 0x00 // sbc eq r2 r5 r8 ROR r1
};
const byte kInstruction_sbc_eq_r0_r0_r10_ROR_r3[] = {
  0x7a, 0x03, 0xc0, 0x00 // sbc eq r0 r0 r10 ROR r3
};
const byte kInstruction_sbc_lt_r6_r1_r0_ROR_r9[] = {
  0x70, 0x69, 0xc1, 0xb0 // sbc lt r6 r1 r0 ROR r9
};
const byte kInstruction_sbc_ls_r7_r7_r12_LSR_r5[] = {
  0x3c, 0x75, 0xc7, 0x90 // sbc ls r7 r7 r12 LSR r5
};
const byte kInstruction_sbc_vs_r0_r9_r7_ROR_r14[] = {
  0x77, 0x0e, 0xc9, 0x60 // sbc vs r0 r9 r7 ROR r14
};
const byte kInstruction_sbc_al_r0_r8_r2_ROR_r2[] = {
  0x72, 0x02, 0xc8, 0xe0 // sbc al r0 r8 r2 ROR r2
};
const byte kInstruction_sbc_vc_r1_r14_r14_LSL_r11[] = {
  0x1e, 0x1b, 0xce, 0x70 // sbc vc r1 r14 r14 LSL r11
};
const byte kInstruction_sbc_ge_r9_r14_r10_ASR_r11[] = {
  0x5a, 0x9b, 0xce, 0xa0 // sbc ge r9 r14 r10 ASR r11
};
const byte kInstruction_sbc_vs_r0_r3_r9_LSL_r4[] = {
  0x19, 0x04, 0xc3, 0x60 // sbc vs r0 r3 r9 LSL r4
};
const byte kInstruction_sbc_pl_r14_r13_r7_LSR_r14[] = {
  0x37, 0xee, 0xcd, 0x50 // sbc pl r14 r13 r7 LSR r14
};
const byte kInstruction_sbc_le_r2_r4_r6_LSR_r3[] = {
  0x36, 0x23, 0xc4, 0xd0 // sbc le r2 r4 r6 LSR r3
};
const byte kInstruction_sbc_vc_r7_r14_r6_LSR_r10[] = {
  0x36, 0x7a, 0xce, 0x70 // sbc vc r7 r14 r6 LSR r10
};
const byte kInstruction_sbc_mi_r13_r11_r14_ASR_r7[] = {
  0x5e, 0xd7, 0xcb, 0x40 // sbc mi r13 r11 r14 ASR r7
};
const TestResult kReferencesbc[] = {
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r8_r10_r8_LSL_r0),
    kInstruction_sbc_mi_r8_r10_r8_LSL_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r11_r4_r13_ROR_r8),
    kInstruction_sbc_cc_r11_r4_r13_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r13_r11_r3_ROR_r4),
    kInstruction_sbc_al_r13_r11_r3_ROR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r11_r5_r4_LSR_r11),
    kInstruction_sbc_gt_r11_r5_r4_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r12_r0_r8_ROR_r13),
    kInstruction_sbc_vs_r12_r0_r8_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r10_r12_r5_LSL_r5),
    kInstruction_sbc_pl_r10_r12_r5_LSL_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r10_r2_r2_LSL_r9),
    kInstruction_sbc_ls_r10_r2_r2_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r12_r7_r9_LSR_r7),
    kInstruction_sbc_eq_r12_r7_r9_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r3_r13_r0_ROR_r11),
    kInstruction_sbc_mi_r3_r13_r0_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r9_r0_r9_ASR_r12),
    kInstruction_sbc_lt_r9_r0_r9_ASR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r12_r8_r14_ROR_r1),
    kInstruction_sbc_le_r12_r8_r14_ROR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r7_r1_r14_LSL_r0),
    kInstruction_sbc_cc_r7_r1_r14_LSL_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r11_r13_r3_ROR_r6),
    kInstruction_sbc_le_r11_r13_r3_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r5_r8_r9_ASR_r14),
    kInstruction_sbc_al_r5_r8_r9_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r1_r2_r7_ASR_r13),
    kInstruction_sbc_hi_r1_r2_r7_ASR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r13_r8_r7_LSR_r12),
    kInstruction_sbc_al_r13_r8_r7_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r3_r6_r4_ASR_r4),
    kInstruction_sbc_vc_r3_r6_r4_ASR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r12_r4_r6_LSL_r5),
    kInstruction_sbc_lt_r12_r4_r6_LSL_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r13_r5_r11_ROR_r8),
    kInstruction_sbc_ls_r13_r5_r11_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r11_r10_r11_LSL_r9),
    kInstruction_sbc_vc_r11_r10_r11_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r13_r14_r10_LSR_r4),
    kInstruction_sbc_al_r13_r14_r10_LSR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r12_r13_r6_ASR_r12),
    kInstruction_sbc_ge_r12_r13_r6_ASR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r14_r6_r12_ROR_r0),
    kInstruction_sbc_ne_r14_r6_r12_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r13_r14_r14_ASR_r13),
    kInstruction_sbc_ls_r13_r14_r14_ASR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r10_r13_r7_ROR_r8),
    kInstruction_sbc_lt_r10_r13_r7_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r8_r8_r9_ASR_r0),
    kInstruction_sbc_lt_r8_r8_r9_ASR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r7_r5_r4_LSR_r8),
    kInstruction_sbc_ne_r7_r5_r4_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r11_r5_r1_LSL_r13),
    kInstruction_sbc_mi_r11_r5_r1_LSL_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r14_r1_r2_LSL_r1),
    kInstruction_sbc_ge_r14_r1_r2_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r6_r11_r4_ASR_r11),
    kInstruction_sbc_ls_r6_r11_r4_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r11_r12_r4_LSR_r13),
    kInstruction_sbc_hi_r11_r12_r4_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r9_r3_r0_LSL_r7),
    kInstruction_sbc_le_r9_r3_r0_LSL_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r8_r7_r4_ASR_r3),
    kInstruction_sbc_ls_r8_r7_r4_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r9_r13_r11_LSL_r7),
    kInstruction_sbc_pl_r9_r13_r11_LSL_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r12_r7_r11_ASR_r3),
    kInstruction_sbc_eq_r12_r7_r11_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r3_r9_r13_ROR_r10),
    kInstruction_sbc_mi_r3_r9_r13_ROR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r14_r8_r10_ROR_r10),
    kInstruction_sbc_mi_r14_r8_r10_ROR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r5_r3_r5_LSL_r1),
    kInstruction_sbc_lt_r5_r3_r5_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r12_r6_r1_LSL_r7),
    kInstruction_sbc_ne_r12_r6_r1_LSL_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r3_r6_r5_ASR_r1),
    kInstruction_sbc_lt_r3_r6_r5_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r14_r0_r0_LSR_r11),
    kInstruction_sbc_lt_r14_r0_r0_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r11_r10_r4_LSL_r14),
    kInstruction_sbc_eq_r11_r10_r4_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r2_r14_r11_LSL_r9),
    kInstruction_sbc_lt_r2_r14_r11_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r0_r6_r14_ASR_r11),
    kInstruction_sbc_mi_r0_r6_r14_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r4_r6_r3_LSR_r11),
    kInstruction_sbc_le_r4_r6_r3_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r2_r6_r1_ROR_r5),
    kInstruction_sbc_cs_r2_r6_r1_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r10_r9_r10_ROR_r4),
    kInstruction_sbc_ne_r10_r9_r10_ROR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r7_r9_r11_LSR_r14),
    kInstruction_sbc_pl_r7_r9_r11_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r11_r8_r3_ASR_r5),
    kInstruction_sbc_pl_r11_r8_r3_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r10_r4_r10_ROR_r8),
    kInstruction_sbc_le_r10_r4_r10_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r8_r14_r8_LSL_r5),
    kInstruction_sbc_ne_r8_r14_r8_LSL_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r12_r5_r2_LSL_r11),
    kInstruction_sbc_eq_r12_r5_r2_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r9_r9_r8_ASR_r2),
    kInstruction_sbc_pl_r9_r9_r8_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r8_r12_r3_LSL_r5),
    kInstruction_sbc_hi_r8_r12_r3_LSL_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r6_r5_r9_LSL_r3),
    kInstruction_sbc_eq_r6_r5_r9_LSL_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r5_r1_r9_LSR_r6),
    kInstruction_sbc_lt_r5_r1_r9_LSR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r9_r9_r0_LSL_r5),
    kInstruction_sbc_hi_r9_r9_r0_LSL_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r6_r6_r5_LSL_r8),
    kInstruction_sbc_cs_r6_r6_r5_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r0_r1_r6_LSR_r12),
    kInstruction_sbc_cs_r0_r1_r6_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r4_r6_r13_ASR_r6),
    kInstruction_sbc_cc_r4_r6_r13_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r11_r8_r10_LSR_r5),
    kInstruction_sbc_hi_r11_r8_r10_LSR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r8_r1_r14_ROR_r14),
    kInstruction_sbc_ls_r8_r1_r14_ROR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r8_r2_r12_ASR_r7),
    kInstruction_sbc_pl_r8_r2_r12_ASR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r14_r7_r5_ROR_r11),
    kInstruction_sbc_gt_r14_r7_r5_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r3_r6_r13_ROR_r0),
    kInstruction_sbc_eq_r3_r6_r13_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r4_r8_r8_ROR_r11),
    kInstruction_sbc_le_r4_r8_r8_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r2_r7_r5_ASR_r6),
    kInstruction_sbc_ge_r2_r7_r5_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r8_r12_r5_LSL_r11),
    kInstruction_sbc_cc_r8_r12_r5_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r11_r10_r3_ROR_r5),
    kInstruction_sbc_vc_r11_r10_r3_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r11_r9_r11_LSL_r6),
    kInstruction_sbc_vc_r11_r9_r11_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r6_r5_r0_ROR_r9),
    kInstruction_sbc_lt_r6_r5_r0_ROR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r13_r7_r11_ASR_r9),
    kInstruction_sbc_cs_r13_r7_r11_ASR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r9_r7_r9_ROR_r11),
    kInstruction_sbc_cs_r9_r7_r9_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r14_r3_r2_ASR_r11),
    kInstruction_sbc_ls_r14_r3_r2_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r0_r1_r1_LSR_r0),
    kInstruction_sbc_vc_r0_r1_r1_LSR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r10_r8_r8_LSR_r13),
    kInstruction_sbc_mi_r10_r8_r8_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r8_r14_r3_LSL_r8),
    kInstruction_sbc_pl_r8_r14_r3_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r6_r4_r1_LSL_r12),
    kInstruction_sbc_ne_r6_r4_r1_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r2_r2_r7_ROR_r0),
    kInstruction_sbc_lt_r2_r2_r7_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r2_r4_r13_ASR_r5),
    kInstruction_sbc_lt_r2_r4_r13_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r8_r1_r2_ROR_r13),
    kInstruction_sbc_eq_r8_r1_r2_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r1_r8_r10_LSR_r7),
    kInstruction_sbc_lt_r1_r8_r10_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r7_r5_r9_LSL_r9),
    kInstruction_sbc_cs_r7_r5_r9_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r8_r0_r6_LSL_r8),
    kInstruction_sbc_mi_r8_r0_r6_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r7_r12_r3_ROR_r6),
    kInstruction_sbc_cs_r7_r12_r3_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r13_r8_r13_LSR_r4),
    kInstruction_sbc_vs_r13_r8_r13_LSR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r4_r13_r7_ROR_r11),
    kInstruction_sbc_cc_r4_r13_r7_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r10_r5_r9_LSR_r13),
    kInstruction_sbc_ge_r10_r5_r9_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r0_r5_r9_ASR_r4),
    kInstruction_sbc_cc_r0_r5_r9_ASR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r1_r5_r8_LSR_r12),
    kInstruction_sbc_cc_r1_r5_r8_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r12_r3_r5_LSL_r6),
    kInstruction_sbc_ls_r12_r3_r5_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r10_r0_r4_ASR_r7),
    kInstruction_sbc_cs_r10_r0_r4_ASR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r10_r13_r14_ROR_r6),
    kInstruction_sbc_ge_r10_r13_r14_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r9_r0_r9_ROR_r3),
    kInstruction_sbc_al_r9_r0_r9_ROR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r4_r5_r12_ASR_r6),
    kInstruction_sbc_vs_r4_r5_r12_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r4_r1_r14_LSL_r12),
    kInstruction_sbc_lt_r4_r1_r14_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r14_r11_r8_ROR_r4),
    kInstruction_sbc_cs_r14_r11_r8_ROR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r12_r0_r14_LSR_r11),
    kInstruction_sbc_hi_r12_r0_r14_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r8_r6_r4_ASR_r7),
    kInstruction_sbc_le_r8_r6_r4_ASR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r13_r4_r14_LSR_r10),
    kInstruction_sbc_mi_r13_r4_r14_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r11_r10_r5_LSL_r10),
    kInstruction_sbc_vs_r11_r10_r5_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r4_r0_r5_LSR_r2),
    kInstruction_sbc_cc_r4_r0_r5_LSR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r9_r14_r0_LSL_r3),
    kInstruction_sbc_pl_r9_r14_r0_LSL_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r7_r2_r14_ASR_r1),
    kInstruction_sbc_vc_r7_r2_r14_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r4_r14_r1_ROR_r10),
    kInstruction_sbc_gt_r4_r14_r1_ROR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r6_r4_r10_LSL_r7),
    kInstruction_sbc_lt_r6_r4_r10_LSL_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r1_r14_r5_LSL_r12),
    kInstruction_sbc_hi_r1_r14_r5_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r14_r12_r4_ASR_r14),
    kInstruction_sbc_cc_r14_r12_r4_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r0_r8_r5_ROR_r8),
    kInstruction_sbc_cc_r0_r8_r5_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r9_r9_r0_ASR_r4),
    kInstruction_sbc_gt_r9_r9_r0_ASR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r8_r11_r12_ASR_r4),
    kInstruction_sbc_mi_r8_r11_r12_ASR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r0_r12_r0_LSR_r11),
    kInstruction_sbc_vs_r0_r12_r0_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r0_r9_r1_ASR_r0),
    kInstruction_sbc_ge_r0_r9_r1_ASR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r10_r11_r5_LSR_r4),
    kInstruction_sbc_al_r10_r11_r5_LSR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r0_r6_r8_LSR_r10),
    kInstruction_sbc_eq_r0_r6_r8_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r13_r12_r14_ROR_r9),
    kInstruction_sbc_cc_r13_r12_r14_ROR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r4_r11_r0_LSL_r14),
    kInstruction_sbc_ls_r4_r11_r0_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r1_r6_r12_LSR_r13),
    kInstruction_sbc_hi_r1_r6_r12_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r7_r11_r1_ASR_r5),
    kInstruction_sbc_cs_r7_r11_r1_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r7_r5_r4_ASR_r11),
    kInstruction_sbc_cc_r7_r5_r4_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r7_r2_r5_ROR_r5),
    kInstruction_sbc_hi_r7_r2_r5_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r11_r9_r7_LSL_r14),
    kInstruction_sbc_vc_r11_r9_r7_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r12_r1_r3_ROR_r7),
    kInstruction_sbc_le_r12_r1_r3_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r8_r14_r0_ASR_r12),
    kInstruction_sbc_al_r8_r14_r0_ASR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r14_r3_r0_ROR_r1),
    kInstruction_sbc_vc_r14_r3_r0_ROR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r10_r8_r3_ROR_r4),
    kInstruction_sbc_pl_r10_r8_r3_ROR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r9_r14_r12_LSL_r4),
    kInstruction_sbc_al_r9_r14_r12_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r8_r3_r14_ASR_r7),
    kInstruction_sbc_vs_r8_r3_r14_ASR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r4_r8_r13_LSL_r1),
    kInstruction_sbc_hi_r4_r8_r13_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r6_r11_r11_LSL_r14),
    kInstruction_sbc_al_r6_r11_r11_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r7_r2_r4_LSR_r1),
    kInstruction_sbc_al_r7_r2_r4_LSR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r5_r10_r3_ASR_r8),
    kInstruction_sbc_vc_r5_r10_r3_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r3_r10_r9_ROR_r11),
    kInstruction_sbc_cc_r3_r10_r9_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r11_r9_r8_LSL_r2),
    kInstruction_sbc_eq_r11_r9_r8_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r6_r9_r5_ASR_r12),
    kInstruction_sbc_mi_r6_r9_r5_ASR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r6_r6_r0_ASR_r9),
    kInstruction_sbc_hi_r6_r6_r0_ASR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r12_r13_r1_LSL_r9),
    kInstruction_sbc_ge_r12_r13_r1_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r4_r9_r14_ASR_r2),
    kInstruction_sbc_le_r4_r9_r14_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r5_r3_r9_ROR_r5),
    kInstruction_sbc_gt_r5_r3_r9_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r14_r5_r13_ROR_r7),
    kInstruction_sbc_al_r14_r5_r13_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r2_r1_r14_ASR_r8),
    kInstruction_sbc_lt_r2_r1_r14_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r12_r7_r8_LSL_r11),
    kInstruction_sbc_al_r12_r7_r8_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r4_r12_r14_LSL_r1),
    kInstruction_sbc_ne_r4_r12_r14_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r7_r14_r4_LSL_r6),
    kInstruction_sbc_vs_r7_r14_r4_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r12_r5_r11_ASR_r4),
    kInstruction_sbc_ge_r12_r5_r11_ASR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r4_r10_r6_LSR_r6),
    kInstruction_sbc_gt_r4_r10_r6_LSR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r14_r8_r14_LSR_r8),
    kInstruction_sbc_cc_r14_r8_r14_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r1_r14_r11_LSR_r7),
    kInstruction_sbc_al_r1_r14_r11_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r13_r6_r5_ASR_r14),
    kInstruction_sbc_pl_r13_r6_r5_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r10_r6_r9_ROR_r13),
    kInstruction_sbc_cc_r10_r6_r9_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r0_r4_r7_ROR_r13),
    kInstruction_sbc_ne_r0_r4_r7_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r12_r0_r14_LSL_r13),
    kInstruction_sbc_vc_r12_r0_r14_LSL_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r10_r13_r13_ROR_r5),
    kInstruction_sbc_al_r10_r13_r13_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r10_r3_r0_ROR_r7),
    kInstruction_sbc_cs_r10_r3_r0_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r10_r14_r14_ROR_r6),
    kInstruction_sbc_ge_r10_r14_r14_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r0_r10_r10_LSL_r4),
    kInstruction_sbc_pl_r0_r10_r10_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r1_r2_r7_ASR_r6),
    kInstruction_sbc_vs_r1_r2_r7_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r9_r11_r9_LSL_r9),
    kInstruction_sbc_cs_r9_r11_r9_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r10_r8_r4_LSL_r6),
    kInstruction_sbc_eq_r10_r8_r4_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r8_r5_r12_LSL_r8),
    kInstruction_sbc_vc_r8_r5_r12_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r1_r13_r11_LSL_r8),
    kInstruction_sbc_pl_r1_r13_r11_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r9_r10_r5_ROR_r4),
    kInstruction_sbc_le_r9_r10_r5_ROR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r8_r3_r0_ASR_r11),
    kInstruction_sbc_vs_r8_r3_r0_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r12_r0_r13_LSL_r2),
    kInstruction_sbc_hi_r12_r0_r13_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r4_r2_r8_LSL_r5),
    kInstruction_sbc_lt_r4_r2_r8_LSL_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r9_r4_r13_LSL_r13),
    kInstruction_sbc_ge_r9_r4_r13_LSL_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r0_r2_r1_ROR_r8),
    kInstruction_sbc_ge_r0_r2_r1_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r6_r13_r9_LSR_r0),
    kInstruction_sbc_le_r6_r13_r9_LSR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r13_r7_r4_ASR_r3),
    kInstruction_sbc_ls_r13_r7_r4_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r8_r13_r6_LSR_r14),
    kInstruction_sbc_vc_r8_r13_r6_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r10_r5_r3_LSR_r9),
    kInstruction_sbc_pl_r10_r5_r3_LSR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r6_r3_r14_LSR_r7),
    kInstruction_sbc_al_r6_r3_r14_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r3_r5_r3_ROR_r10),
    kInstruction_sbc_cc_r3_r5_r3_ROR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r4_r11_r2_LSR_r10),
    kInstruction_sbc_cs_r4_r11_r2_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r6_r10_r5_ASR_r8),
    kInstruction_sbc_lt_r6_r10_r5_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r0_r13_r10_ASR_r8),
    kInstruction_sbc_ge_r0_r13_r10_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r8_r8_r0_LSL_r9),
    kInstruction_sbc_cs_r8_r8_r0_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r1_r1_r1_ASR_r2),
    kInstruction_sbc_gt_r1_r1_r1_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r5_r0_r14_ROR_r3),
    kInstruction_sbc_al_r5_r0_r14_ROR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r3_r9_r14_LSL_r9),
    kInstruction_sbc_mi_r3_r9_r14_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r9_r6_r5_LSL_r9),
    kInstruction_sbc_ls_r9_r6_r5_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r13_r3_r1_LSL_r13),
    kInstruction_sbc_lt_r13_r3_r1_LSL_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r9_r14_r3_ASR_r3),
    kInstruction_sbc_lt_r9_r14_r3_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r5_r4_r1_LSR_r0),
    kInstruction_sbc_cc_r5_r4_r1_LSR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r9_r7_r8_ASR_r0),
    kInstruction_sbc_cs_r9_r7_r8_ASR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r8_r6_r14_ROR_r7),
    kInstruction_sbc_ge_r8_r6_r14_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r14_r8_r12_LSL_r0),
    kInstruction_sbc_le_r14_r8_r12_LSL_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r0_r13_r14_ASR_r3),
    kInstruction_sbc_mi_r0_r13_r14_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r7_r4_r9_ROR_r8),
    kInstruction_sbc_cs_r7_r4_r9_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r4_r6_r11_ROR_r2),
    kInstruction_sbc_ne_r4_r6_r11_ROR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r8_r8_r9_ROR_r12),
    kInstruction_sbc_gt_r8_r8_r9_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r1_r2_r0_LSR_r13),
    kInstruction_sbc_hi_r1_r2_r0_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r14_r12_r6_ASR_r5),
    kInstruction_sbc_ge_r14_r12_r6_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r5_r4_r7_LSR_r14),
    kInstruction_sbc_ge_r5_r4_r7_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r13_r11_r10_LSR_r2),
    kInstruction_sbc_cc_r13_r11_r10_LSR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r3_r9_r14_LSR_r14),
    kInstruction_sbc_mi_r3_r9_r14_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r10_r3_r4_LSR_r3),
    kInstruction_sbc_ne_r10_r3_r4_LSR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r14_r9_r6_LSL_r9),
    kInstruction_sbc_ls_r14_r9_r6_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r8_r2_r8_ROR_r7),
    kInstruction_sbc_ls_r8_r2_r8_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r2_r6_r3_ROR_r3),
    kInstruction_sbc_ne_r2_r6_r3_ROR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r12_r3_r11_ASR_r11),
    kInstruction_sbc_mi_r12_r3_r11_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r7_r10_r11_LSL_r9),
    kInstruction_sbc_le_r7_r10_r11_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r1_r2_r10_ROR_r8),
    kInstruction_sbc_al_r1_r2_r10_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r7_r9_r14_LSL_r7),
    kInstruction_sbc_cc_r7_r9_r14_LSL_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r9_r3_r5_LSL_r8),
    kInstruction_sbc_cc_r9_r3_r5_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r8_r3_r8_ROR_r2),
    kInstruction_sbc_hi_r8_r3_r8_ROR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r10_r13_r14_LSR_r10),
    kInstruction_sbc_pl_r10_r13_r14_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r13_r4_r13_LSR_r12),
    kInstruction_sbc_lt_r13_r4_r13_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r12_r14_r11_LSR_r13),
    kInstruction_sbc_ls_r12_r14_r11_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r11_r10_r10_ASR_r2),
    kInstruction_sbc_vs_r11_r10_r10_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r5_r8_r13_LSL_r10),
    kInstruction_sbc_cc_r5_r8_r13_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r7_r4_r11_LSR_r14),
    kInstruction_sbc_cs_r7_r4_r11_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r1_r12_r7_ASR_r11),
    kInstruction_sbc_lt_r1_r12_r7_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r11_r4_r4_LSL_r10),
    kInstruction_sbc_vc_r11_r4_r4_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r7_r4_r6_LSR_r7),
    kInstruction_sbc_vc_r7_r4_r6_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r0_r3_r0_ASR_r14),
    kInstruction_sbc_vc_r0_r3_r0_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r11_r8_r13_ASR_r8),
    kInstruction_sbc_mi_r11_r8_r13_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r13_r14_r6_LSL_r11),
    kInstruction_sbc_gt_r13_r14_r6_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r3_r2_r6_LSL_r8),
    kInstruction_sbc_cs_r3_r2_r6_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r7_r5_r5_LSL_r8),
    kInstruction_sbc_ne_r7_r5_r5_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r0_r12_r6_LSR_r0),
    kInstruction_sbc_lt_r0_r12_r6_LSR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r11_r9_r12_ROR_r2),
    kInstruction_sbc_ls_r11_r9_r12_ROR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r6_r0_r8_LSR_r4),
    kInstruction_sbc_ls_r6_r0_r8_LSR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r6_r7_r0_ROR_r13),
    kInstruction_sbc_lt_r6_r7_r0_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r14_r4_r1_LSL_r8),
    kInstruction_sbc_gt_r14_r4_r1_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r14_r5_r6_LSL_r7),
    kInstruction_sbc_al_r14_r5_r6_LSL_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r9_r6_r4_LSR_r8),
    kInstruction_sbc_ge_r9_r6_r4_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r2_r14_r13_ROR_r3),
    kInstruction_sbc_lt_r2_r14_r13_ROR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r11_r1_r13_LSR_r9),
    kInstruction_sbc_al_r11_r1_r13_LSR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r8_r2_r5_LSL_r11),
    kInstruction_sbc_vs_r8_r2_r5_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r8_r14_r8_LSL_r7),
    kInstruction_sbc_pl_r8_r14_r8_LSL_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r10_r5_r5_ASR_r4),
    kInstruction_sbc_cs_r10_r5_r5_ASR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r12_r14_r9_LSR_r11),
    kInstruction_sbc_eq_r12_r14_r9_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r1_r3_r3_LSL_r1),
    kInstruction_sbc_lt_r1_r3_r3_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r4_r13_r4_ASR_r8),
    kInstruction_sbc_le_r4_r13_r4_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r5_r4_r2_LSL_r8),
    kInstruction_sbc_ne_r5_r4_r2_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r3_r14_r13_LSR_r1),
    kInstruction_sbc_le_r3_r14_r13_LSR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r6_r3_r5_LSL_r1),
    kInstruction_sbc_cc_r6_r3_r5_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r9_r6_r11_LSR_r14),
    kInstruction_sbc_lt_r9_r6_r11_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r13_r8_r10_ROR_r1),
    kInstruction_sbc_cc_r13_r8_r10_ROR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r7_r10_r11_LSR_r2),
    kInstruction_sbc_lt_r7_r10_r11_LSR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r0_r9_r5_LSR_r8),
    kInstruction_sbc_pl_r0_r9_r5_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r8_r9_r11_LSR_r13),
    kInstruction_sbc_eq_r8_r9_r11_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r10_r1_r9_ROR_r12),
    kInstruction_sbc_hi_r10_r1_r9_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r13_r1_r14_LSL_r14),
    kInstruction_sbc_pl_r13_r1_r14_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r13_r3_r7_LSR_r13),
    kInstruction_sbc_eq_r13_r3_r7_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r3_r6_r6_ASR_r14),
    kInstruction_sbc_eq_r3_r6_r6_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r5_r4_r8_ROR_r13),
    kInstruction_sbc_gt_r5_r4_r8_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r9_r7_r0_ROR_r3),
    kInstruction_sbc_al_r9_r7_r0_ROR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r13_r11_r3_LSL_r1),
    kInstruction_sbc_mi_r13_r11_r3_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r11_r14_r6_LSL_r14),
    kInstruction_sbc_ls_r11_r14_r6_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r14_r3_r7_LSL_r9),
    kInstruction_sbc_al_r14_r3_r7_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r14_r2_r14_LSL_r13),
    kInstruction_sbc_cs_r14_r2_r14_LSL_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r11_r10_r6_ASR_r11),
    kInstruction_sbc_ls_r11_r10_r6_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r13_r4_r2_LSL_r4),
    kInstruction_sbc_pl_r13_r4_r2_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r8_r10_r5_ASR_r0),
    kInstruction_sbc_mi_r8_r10_r5_ASR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r2_r1_r6_ASR_r4),
    kInstruction_sbc_cs_r2_r1_r6_ASR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r0_r11_r8_LSR_r14),
    kInstruction_sbc_cc_r0_r11_r8_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r5_r4_r6_ROR_r1),
    kInstruction_sbc_ge_r5_r4_r6_ROR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r0_r14_r3_LSR_r11),
    kInstruction_sbc_cs_r0_r14_r3_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r9_r4_r10_LSR_r13),
    kInstruction_sbc_ge_r9_r4_r10_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r11_r0_r9_LSL_r8),
    kInstruction_sbc_ne_r11_r0_r9_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r4_r1_r0_LSL_r8),
    kInstruction_sbc_vs_r4_r1_r0_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r5_r5_r4_ROR_r10),
    kInstruction_sbc_le_r5_r5_r4_ROR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r9_r5_r0_ROR_r6),
    kInstruction_sbc_al_r9_r5_r0_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r6_r6_r9_LSR_r12),
    kInstruction_sbc_hi_r6_r6_r9_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r1_r4_r9_ROR_r4),
    kInstruction_sbc_lt_r1_r4_r9_ROR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r4_r7_r0_ROR_r11),
    kInstruction_sbc_vc_r4_r7_r0_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r1_r4_r2_ROR_r8),
    kInstruction_sbc_gt_r1_r4_r2_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r4_r5_r9_LSL_r6),
    kInstruction_sbc_ne_r4_r5_r9_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r3_r4_r10_LSR_r5),
    kInstruction_sbc_gt_r3_r4_r10_LSR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r7_r9_r2_ROR_r2),
    kInstruction_sbc_al_r7_r9_r2_ROR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r3_r8_r2_LSL_r2),
    kInstruction_sbc_le_r3_r8_r2_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r3_r8_r0_LSL_r1),
    kInstruction_sbc_hi_r3_r8_r0_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r11_r4_r4_LSL_r14),
    kInstruction_sbc_ge_r11_r4_r4_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r8_r14_r1_LSR_r13),
    kInstruction_sbc_mi_r8_r14_r1_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r6_r1_r10_LSL_r0),
    kInstruction_sbc_pl_r6_r1_r10_LSL_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r11_r7_r13_LSL_r0),
    kInstruction_sbc_eq_r11_r7_r13_LSL_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r4_r9_r11_LSR_r1),
    kInstruction_sbc_cc_r4_r9_r11_LSR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r8_r2_r3_LSR_r8),
    kInstruction_sbc_cc_r8_r2_r3_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r5_r1_r14_LSL_r12),
    kInstruction_sbc_ne_r5_r1_r14_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r13_r5_r2_ASR_r1),
    kInstruction_sbc_le_r13_r5_r2_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r0_r5_r0_LSL_r4),
    kInstruction_sbc_al_r0_r5_r0_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r3_r1_r4_LSR_r3),
    kInstruction_sbc_mi_r3_r1_r4_LSR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r3_r7_r0_ROR_r8),
    kInstruction_sbc_cs_r3_r7_r0_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r11_r14_r4_LSR_r13),
    kInstruction_sbc_cs_r11_r14_r4_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r11_r10_r8_ASR_r3),
    kInstruction_sbc_vs_r11_r10_r8_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r10_r8_r9_LSL_r13),
    kInstruction_sbc_gt_r10_r8_r9_LSL_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r10_r1_r8_ASR_r9),
    kInstruction_sbc_eq_r10_r1_r8_ASR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r2_r1_r10_ASR_r8),
    kInstruction_sbc_al_r2_r1_r10_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r7_r1_r7_ROR_r11),
    kInstruction_sbc_al_r7_r1_r7_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r0_r5_r6_ASR_r1),
    kInstruction_sbc_cs_r0_r5_r6_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r12_r11_r10_LSR_r14),
    kInstruction_sbc_lt_r12_r11_r10_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r13_r7_r5_LSL_r2),
    kInstruction_sbc_pl_r13_r7_r5_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r2_r0_r12_LSL_r11),
    kInstruction_sbc_ne_r2_r0_r12_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r14_r9_r12_ROR_r6),
    kInstruction_sbc_ls_r14_r9_r12_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r9_r2_r8_ASR_r3),
    kInstruction_sbc_cc_r9_r2_r8_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r12_r11_r0_ASR_r7),
    kInstruction_sbc_pl_r12_r11_r0_ASR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r12_r2_r3_ROR_r1),
    kInstruction_sbc_vs_r12_r2_r3_ROR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r3_r1_r8_LSL_r4),
    kInstruction_sbc_al_r3_r1_r8_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r7_r9_r13_ASR_r5),
    kInstruction_sbc_mi_r7_r9_r13_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r13_r4_r10_ROR_r9),
    kInstruction_sbc_vs_r13_r4_r10_ROR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r8_r2_r3_LSR_r2),
    kInstruction_sbc_eq_r8_r2_r3_LSR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r0_r3_r11_LSR_r7),
    kInstruction_sbc_cs_r0_r3_r11_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r2_r10_r9_ASR_r13),
    kInstruction_sbc_pl_r2_r10_r9_ASR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r14_r0_r7_ASR_r0),
    kInstruction_sbc_eq_r14_r0_r7_ASR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r12_r11_r7_ROR_r7),
    kInstruction_sbc_lt_r12_r11_r7_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r4_r10_r1_LSL_r2),
    kInstruction_sbc_eq_r4_r10_r1_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r7_r14_r12_ASR_r6),
    kInstruction_sbc_al_r7_r14_r12_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r2_r5_r13_ASR_r1),
    kInstruction_sbc_al_r2_r5_r13_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r0_r3_r14_LSL_r11),
    kInstruction_sbc_hi_r0_r3_r14_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r5_r6_r9_LSR_r13),
    kInstruction_sbc_vs_r5_r6_r9_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r14_r0_r14_ROR_r14),
    kInstruction_sbc_hi_r14_r0_r14_ROR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r9_r3_r13_ROR_r9),
    kInstruction_sbc_eq_r9_r3_r13_ROR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r6_r8_r1_ASR_r14),
    kInstruction_sbc_hi_r6_r8_r1_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r13_r2_r8_LSR_r7),
    kInstruction_sbc_vs_r13_r2_r8_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r13_r0_r8_LSR_r7),
    kInstruction_sbc_cc_r13_r0_r8_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r12_r0_r11_ASR_r9),
    kInstruction_sbc_le_r12_r0_r11_ASR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r8_r8_r1_LSR_r6),
    kInstruction_sbc_le_r8_r8_r1_LSR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r5_r14_r7_ASR_r3),
    kInstruction_sbc_cs_r5_r14_r7_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r13_r13_r10_ROR_r12),
    kInstruction_sbc_eq_r13_r13_r10_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r4_r7_r7_LSR_r5),
    kInstruction_sbc_lt_r4_r7_r7_LSR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r6_r13_r10_LSR_r2),
    kInstruction_sbc_le_r6_r13_r10_LSR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r10_r13_r10_ASR_r8),
    kInstruction_sbc_eq_r10_r13_r10_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r6_r5_r12_LSR_r12),
    kInstruction_sbc_ne_r6_r5_r12_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r10_r8_r10_ROR_r8),
    kInstruction_sbc_vc_r10_r8_r10_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r10_r1_r8_LSR_r1),
    kInstruction_sbc_gt_r10_r1_r8_LSR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r5_r12_r9_LSR_r13),
    kInstruction_sbc_pl_r5_r12_r9_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r10_r6_r4_ROR_r12),
    kInstruction_sbc_gt_r10_r6_r4_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r14_r10_r10_ASR_r6),
    kInstruction_sbc_cs_r14_r10_r10_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r6_r8_r2_ROR_r7),
    kInstruction_sbc_le_r6_r8_r2_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r13_r12_r0_ROR_r14),
    kInstruction_sbc_le_r13_r12_r0_ROR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r7_r6_r0_ASR_r10),
    kInstruction_sbc_le_r7_r6_r0_ASR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r10_r4_r1_ASR_r10),
    kInstruction_sbc_cs_r10_r4_r1_ASR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r12_r9_r11_ASR_r6),
    kInstruction_sbc_ne_r12_r9_r11_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r9_r14_r6_ASR_r12),
    kInstruction_sbc_vs_r9_r14_r6_ASR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r1_r8_r0_ASR_r7),
    kInstruction_sbc_mi_r1_r8_r0_ASR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r11_r2_r3_ROR_r11),
    kInstruction_sbc_gt_r11_r2_r3_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r3_r1_r12_LSR_r0),
    kInstruction_sbc_cs_r3_r1_r12_LSR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r12_r14_r11_LSL_r2),
    kInstruction_sbc_hi_r12_r14_r11_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r10_r11_r14_LSL_r10),
    kInstruction_sbc_mi_r10_r11_r14_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r11_r6_r13_ASR_r2),
    kInstruction_sbc_al_r11_r6_r13_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r2_r14_r3_ROR_r6),
    kInstruction_sbc_gt_r2_r14_r3_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r1_r10_r6_LSR_r6),
    kInstruction_sbc_hi_r1_r10_r6_LSR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r2_r8_r3_LSL_r6),
    kInstruction_sbc_gt_r2_r8_r3_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r13_r4_r12_ROR_r13),
    kInstruction_sbc_ls_r13_r4_r12_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r13_r11_r7_ROR_r8),
    kInstruction_sbc_vs_r13_r11_r7_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r5_r12_r14_LSR_r3),
    kInstruction_sbc_hi_r5_r12_r14_LSR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r14_r8_r3_ROR_r13),
    kInstruction_sbc_cs_r14_r8_r3_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r9_r10_r0_LSL_r10),
    kInstruction_sbc_cs_r9_r10_r0_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r0_r13_r12_ASR_r5),
    kInstruction_sbc_lt_r0_r13_r12_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r4_r5_r7_ROR_r7),
    kInstruction_sbc_cs_r4_r5_r7_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r0_r14_r7_LSR_r7),
    kInstruction_sbc_lt_r0_r14_r7_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r10_r5_r3_LSL_r10),
    kInstruction_sbc_hi_r10_r5_r3_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r6_r2_r4_ROR_r0),
    kInstruction_sbc_ls_r6_r2_r4_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r9_r7_r7_ASR_r10),
    kInstruction_sbc_hi_r9_r7_r7_ASR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r0_r9_r4_LSR_r2),
    kInstruction_sbc_cc_r0_r9_r4_LSR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r3_r14_r2_ASR_r0),
    kInstruction_sbc_le_r3_r14_r2_ASR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r2_r8_r7_LSL_r13),
    kInstruction_sbc_pl_r2_r8_r7_LSL_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r10_r1_r9_LSR_r6),
    kInstruction_sbc_al_r10_r1_r9_LSR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r1_r6_r14_ASR_r14),
    kInstruction_sbc_vs_r1_r6_r14_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r3_r3_r13_LSR_r0),
    kInstruction_sbc_lt_r3_r3_r13_LSR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r9_r3_r2_ASR_r11),
    kInstruction_sbc_le_r9_r3_r2_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r4_r14_r6_LSL_r11),
    kInstruction_sbc_mi_r4_r14_r6_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r7_r5_r14_ASR_r9),
    kInstruction_sbc_ne_r7_r5_r14_ASR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r11_r11_r13_LSR_r11),
    kInstruction_sbc_cs_r11_r11_r13_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r12_r9_r5_LSR_r9),
    kInstruction_sbc_lt_r12_r9_r5_LSR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r13_r1_r10_LSL_r4),
    kInstruction_sbc_hi_r13_r1_r10_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r14_r6_r8_ASR_r14),
    kInstruction_sbc_mi_r14_r6_r8_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r3_r2_r6_ASR_r3),
    kInstruction_sbc_vc_r3_r2_r6_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r13_r14_r0_ASR_r2),
    kInstruction_sbc_ne_r13_r14_r0_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r2_r14_r5_ROR_r1),
    kInstruction_sbc_gt_r2_r14_r5_ROR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r7_r7_r9_LSR_r10),
    kInstruction_sbc_ls_r7_r7_r9_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r2_r12_r8_ASR_r5),
    kInstruction_sbc_gt_r2_r12_r8_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r13_r2_r11_ROR_r6),
    kInstruction_sbc_lt_r13_r2_r11_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r2_r13_r13_ASR_r1),
    kInstruction_sbc_cc_r2_r13_r13_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r0_r6_r14_ROR_r3),
    kInstruction_sbc_vs_r0_r6_r14_ROR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r2_r13_r8_LSL_r9),
    kInstruction_sbc_vs_r2_r13_r8_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r2_r12_r12_ROR_r6),
    kInstruction_sbc_pl_r2_r12_r12_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r4_r0_r12_ASR_r13),
    kInstruction_sbc_vc_r4_r0_r12_ASR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r8_r12_r7_ASR_r7),
    kInstruction_sbc_mi_r8_r12_r7_ASR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r13_r5_r0_LSL_r5),
    kInstruction_sbc_al_r13_r5_r0_LSL_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r9_r1_r12_LSR_r8),
    kInstruction_sbc_le_r9_r1_r12_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r5_r10_r13_ROR_r1),
    kInstruction_sbc_vs_r5_r10_r13_ROR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r8_r5_r0_LSR_r11),
    kInstruction_sbc_vs_r8_r5_r0_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r7_r2_r0_LSL_r4),
    kInstruction_sbc_ne_r7_r2_r0_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r6_r6_r9_LSL_r10),
    kInstruction_sbc_lt_r6_r6_r9_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r13_r3_r4_ROR_r12),
    kInstruction_sbc_cs_r13_r3_r4_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r11_r11_r0_LSL_r7),
    kInstruction_sbc_ne_r11_r11_r0_LSL_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r3_r14_r12_LSR_r13),
    kInstruction_sbc_pl_r3_r14_r12_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r2_r14_r3_LSL_r11),
    kInstruction_sbc_al_r2_r14_r3_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r4_r6_r3_LSR_r7),
    kInstruction_sbc_vc_r4_r6_r3_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r6_r2_r1_LSR_r6),
    kInstruction_sbc_ls_r6_r2_r1_LSR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r0_r2_r5_ASR_r3),
    kInstruction_sbc_le_r0_r2_r5_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r12_r9_r12_ROR_r13),
    kInstruction_sbc_ge_r12_r9_r12_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r10_r5_r3_ROR_r12),
    kInstruction_sbc_cc_r10_r5_r3_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r14_r0_r10_ASR_r4),
    kInstruction_sbc_mi_r14_r0_r10_ASR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r12_r0_r3_ROR_r13),
    kInstruction_sbc_al_r12_r0_r3_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r1_r8_r13_ASR_r2),
    kInstruction_sbc_hi_r1_r8_r13_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r7_r9_r9_ASR_r2),
    kInstruction_sbc_ls_r7_r9_r9_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r9_r13_r6_ROR_r11),
    kInstruction_sbc_ls_r9_r13_r6_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r11_r12_r14_LSL_r14),
    kInstruction_sbc_pl_r11_r12_r14_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r1_r3_r10_ASR_r9),
    kInstruction_sbc_eq_r1_r3_r10_ASR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r1_r6_r6_LSL_r9),
    kInstruction_sbc_al_r1_r6_r6_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r4_r14_r7_ROR_r12),
    kInstruction_sbc_ne_r4_r14_r7_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r2_r13_r1_ROR_r7),
    kInstruction_sbc_vc_r2_r13_r1_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r13_r12_r8_LSR_r11),
    kInstruction_sbc_cs_r13_r12_r8_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r10_r14_r12_LSL_r4),
    kInstruction_sbc_le_r10_r14_r12_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r14_r9_r4_ROR_r13),
    kInstruction_sbc_cs_r14_r9_r4_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r10_r12_r8_ASR_r14),
    kInstruction_sbc_ge_r10_r12_r8_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r14_r10_r3_LSL_r13),
    kInstruction_sbc_cs_r14_r10_r3_LSL_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r4_r3_r10_LSR_r2),
    kInstruction_sbc_lt_r4_r3_r10_LSR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r13_r12_r8_ASR_r14),
    kInstruction_sbc_ls_r13_r12_r8_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r3_r2_r0_ASR_r8),
    kInstruction_sbc_ge_r3_r2_r0_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r3_r7_r1_LSL_r0),
    kInstruction_sbc_vs_r3_r7_r1_LSL_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r5_r13_r7_LSR_r7),
    kInstruction_sbc_lt_r5_r13_r7_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r8_r4_r3_ROR_r14),
    kInstruction_sbc_ls_r8_r4_r3_ROR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r5_r4_r13_LSL_r12),
    kInstruction_sbc_vc_r5_r4_r13_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r6_r10_r11_LSR_r2),
    kInstruction_sbc_pl_r6_r10_r11_LSR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r4_r0_r6_ASR_r10),
    kInstruction_sbc_ne_r4_r0_r6_ASR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r2_r6_r7_LSR_r4),
    kInstruction_sbc_vc_r2_r6_r7_LSR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r4_r12_r1_ROR_r14),
    kInstruction_sbc_pl_r4_r12_r1_ROR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r13_r1_r10_LSL_r12),
    kInstruction_sbc_cs_r13_r1_r10_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r7_r12_r7_LSL_r10),
    kInstruction_sbc_al_r7_r12_r7_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r1_r9_r13_LSR_r8),
    kInstruction_sbc_ge_r1_r9_r13_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r12_r5_r11_ASR_r2),
    kInstruction_sbc_eq_r12_r5_r11_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r7_r9_r3_ASR_r14),
    kInstruction_sbc_ls_r7_r9_r3_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r5_r10_r3_LSL_r12),
    kInstruction_sbc_pl_r5_r10_r3_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r5_r14_r11_ASR_r13),
    kInstruction_sbc_vs_r5_r14_r11_ASR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r9_r2_r8_LSR_r10),
    kInstruction_sbc_al_r9_r2_r8_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r11_r12_r6_ROR_r11),
    kInstruction_sbc_cc_r11_r12_r6_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r10_r3_r1_LSR_r5),
    kInstruction_sbc_ge_r10_r3_r1_LSR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r13_r4_r7_ROR_r0),
    kInstruction_sbc_lt_r13_r4_r7_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r2_r12_r12_LSR_r0),
    kInstruction_sbc_ne_r2_r12_r12_LSR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r2_r10_r14_ASR_r10),
    kInstruction_sbc_gt_r2_r10_r14_ASR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r5_r6_r10_ASR_r11),
    kInstruction_sbc_cc_r5_r6_r10_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r8_r13_r1_ROR_r9),
    kInstruction_sbc_hi_r8_r13_r1_ROR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r3_r1_r14_LSR_r3),
    kInstruction_sbc_cc_r3_r1_r14_LSR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r11_r9_r8_ASR_r13),
    kInstruction_sbc_lt_r11_r9_r8_ASR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r0_r3_r13_ASR_r5),
    kInstruction_sbc_mi_r0_r3_r13_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r7_r6_r10_ASR_r6),
    kInstruction_sbc_vc_r7_r6_r10_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r2_r6_r4_LSL_r9),
    kInstruction_sbc_mi_r2_r6_r4_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r12_r9_r4_ROR_r6),
    kInstruction_sbc_ne_r12_r9_r4_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r4_r3_r0_ROR_r4),
    kInstruction_sbc_hi_r4_r3_r0_ROR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r9_r2_r11_LSL_r13),
    kInstruction_sbc_gt_r9_r2_r11_LSL_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r14_r4_r3_LSL_r10),
    kInstruction_sbc_eq_r14_r4_r3_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r8_r2_r12_LSL_r10),
    kInstruction_sbc_le_r8_r2_r12_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r8_r0_r1_ASR_r8),
    kInstruction_sbc_ls_r8_r0_r1_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r13_r9_r7_LSR_r3),
    kInstruction_sbc_cc_r13_r9_r7_LSR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r6_r0_r7_ROR_r9),
    kInstruction_sbc_gt_r6_r0_r7_ROR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r14_r12_r6_LSR_r12),
    kInstruction_sbc_hi_r14_r12_r6_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r3_r7_r10_LSR_r8),
    kInstruction_sbc_cs_r3_r7_r10_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r7_r7_r7_LSL_r11),
    kInstruction_sbc_le_r7_r7_r7_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r11_r11_r14_ASR_r3),
    kInstruction_sbc_le_r11_r11_r14_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r13_r5_r6_LSL_r13),
    kInstruction_sbc_vc_r13_r5_r6_LSL_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r12_r3_r12_LSL_r8),
    kInstruction_sbc_cc_r12_r3_r12_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r4_r14_r12_ASR_r11),
    kInstruction_sbc_gt_r4_r14_r12_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r9_r6_r7_LSL_r10),
    kInstruction_sbc_cs_r9_r6_r7_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r9_r5_r3_ROR_r5),
    kInstruction_sbc_ge_r9_r5_r3_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r4_r5_r14_LSR_r4),
    kInstruction_sbc_vc_r4_r5_r14_LSR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r13_r12_r2_ASR_r14),
    kInstruction_sbc_ne_r13_r12_r2_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r2_r9_r11_LSR_r13),
    kInstruction_sbc_gt_r2_r9_r11_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r10_r11_r8_LSR_r1),
    kInstruction_sbc_mi_r10_r11_r8_LSR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r6_r8_r1_ASR_r6),
    kInstruction_sbc_hi_r6_r8_r1_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r10_r12_r5_ROR_r11),
    kInstruction_sbc_eq_r10_r12_r5_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r9_r6_r4_LSL_r1),
    kInstruction_sbc_mi_r9_r6_r4_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r14_r6_r0_ROR_r7),
    kInstruction_sbc_vc_r14_r6_r0_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r10_r3_r12_LSL_r2),
    kInstruction_sbc_mi_r10_r3_r12_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r9_r6_r9_LSR_r14),
    kInstruction_sbc_pl_r9_r6_r9_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r10_r5_r10_ROR_r1),
    kInstruction_sbc_al_r10_r5_r10_ROR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r9_r6_r2_ASR_r3),
    kInstruction_sbc_ne_r9_r6_r2_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r4_r9_r4_LSL_r6),
    kInstruction_sbc_hi_r4_r9_r4_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r1_r9_r7_ASR_r7),
    kInstruction_sbc_vs_r1_r9_r7_ASR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r10_r13_r9_ASR_r14),
    kInstruction_sbc_ne_r10_r13_r9_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r11_r13_r12_ASR_r12),
    kInstruction_sbc_gt_r11_r13_r12_ASR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r3_r5_r0_LSR_r10),
    kInstruction_sbc_lt_r3_r5_r0_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r4_r8_r13_ROR_r7),
    kInstruction_sbc_gt_r4_r8_r13_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r14_r14_r0_ASR_r3),
    kInstruction_sbc_ls_r14_r14_r0_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r2_r7_r9_ASR_r5),
    kInstruction_sbc_vc_r2_r7_r9_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r9_r3_r10_LSR_r10),
    kInstruction_sbc_mi_r9_r3_r10_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r11_r10_r3_ASR_r11),
    kInstruction_sbc_gt_r11_r10_r3_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r3_r14_r2_ROR_r12),
    kInstruction_sbc_cc_r3_r14_r2_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r3_r5_r14_ROR_r12),
    kInstruction_sbc_ls_r3_r5_r14_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r6_r0_r11_ASR_r0),
    kInstruction_sbc_al_r6_r0_r11_ASR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r14_r12_r13_LSL_r8),
    kInstruction_sbc_al_r14_r12_r13_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r12_r9_r14_ROR_r4),
    kInstruction_sbc_cs_r12_r9_r14_ROR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r4_r9_r6_LSL_r10),
    kInstruction_sbc_vs_r4_r9_r6_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r6_r1_r4_ASR_r6),
    kInstruction_sbc_eq_r6_r1_r4_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r6_r11_r2_LSR_r10),
    kInstruction_sbc_ge_r6_r11_r2_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r10_r14_r4_LSR_r0),
    kInstruction_sbc_cc_r10_r14_r4_LSR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r0_r12_r1_ROR_r5),
    kInstruction_sbc_ge_r0_r12_r1_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r1_r13_r10_ASR_r5),
    kInstruction_sbc_ls_r1_r13_r10_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r9_r8_r5_ASR_r5),
    kInstruction_sbc_cc_r9_r8_r5_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r6_r5_r1_LSL_r11),
    kInstruction_sbc_ls_r6_r5_r1_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r2_r12_r1_ROR_r10),
    kInstruction_sbc_ne_r2_r12_r1_ROR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r2_r9_r9_LSR_r1),
    kInstruction_sbc_cc_r2_r9_r9_LSR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r1_r8_r1_ASR_r14),
    kInstruction_sbc_ne_r1_r8_r1_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r9_r2_r1_LSR_r10),
    kInstruction_sbc_lt_r9_r2_r1_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r14_r11_r9_ROR_r6),
    kInstruction_sbc_cc_r14_r11_r9_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r3_r12_r13_ASR_r0),
    kInstruction_sbc_eq_r3_r12_r13_ASR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r6_r6_r6_ASR_r2),
    kInstruction_sbc_le_r6_r6_r6_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r11_r14_r4_ASR_r1),
    kInstruction_sbc_mi_r11_r14_r4_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r5_r9_r10_LSL_r9),
    kInstruction_sbc_ls_r5_r9_r10_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r12_r9_r3_LSR_r10),
    kInstruction_sbc_vc_r12_r9_r3_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r12_r0_r4_ASR_r0),
    kInstruction_sbc_lt_r12_r0_r4_ASR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r0_r10_r6_ROR_r9),
    kInstruction_sbc_mi_r0_r10_r6_ROR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r7_r10_r1_LSL_r7),
    kInstruction_sbc_hi_r7_r10_r1_LSL_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r2_r0_r14_ROR_r5),
    kInstruction_sbc_ls_r2_r0_r14_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r12_r14_r12_LSR_r10),
    kInstruction_sbc_cs_r12_r14_r12_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r9_r0_r6_ROR_r2),
    kInstruction_sbc_le_r9_r0_r6_ROR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r3_r10_r4_LSR_r12),
    kInstruction_sbc_cc_r3_r10_r4_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r4_r5_r2_ASR_r14),
    kInstruction_sbc_mi_r4_r5_r2_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r12_r8_r10_ROR_r14),
    kInstruction_sbc_vc_r12_r8_r10_ROR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r5_r14_r4_ASR_r10),
    kInstruction_sbc_al_r5_r14_r4_ASR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r13_r8_r3_ASR_r1),
    kInstruction_sbc_ls_r13_r8_r3_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r10_r1_r2_LSR_r4),
    kInstruction_sbc_le_r10_r1_r2_LSR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r0_r2_r10_ROR_r7),
    kInstruction_sbc_ne_r0_r2_r10_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r11_r13_r11_LSR_r12),
    kInstruction_sbc_vs_r11_r13_r11_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r10_r10_r8_ROR_r8),
    kInstruction_sbc_vs_r10_r10_r8_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r7_r2_r9_LSL_r11),
    kInstruction_sbc_ne_r7_r2_r9_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r5_r12_r11_ASR_r5),
    kInstruction_sbc_mi_r5_r12_r11_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r1_r10_r5_ROR_r5),
    kInstruction_sbc_le_r1_r10_r5_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r3_r14_r3_ASR_r6),
    kInstruction_sbc_cc_r3_r14_r3_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r4_r4_r0_ROR_r2),
    kInstruction_sbc_vc_r4_r4_r0_ROR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r3_r4_r12_ROR_r14),
    kInstruction_sbc_le_r3_r4_r12_ROR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r3_r7_r14_LSL_r11),
    kInstruction_sbc_al_r3_r7_r14_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r8_r11_r0_LSL_r11),
    kInstruction_sbc_vc_r8_r11_r0_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r12_r9_r14_LSR_r2),
    kInstruction_sbc_vs_r12_r9_r14_LSR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r3_r5_r5_ROR_r6),
    kInstruction_sbc_hi_r3_r5_r5_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r9_r3_r13_ASR_r7),
    kInstruction_sbc_cs_r9_r3_r13_ASR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r14_r3_r6_LSR_r5),
    kInstruction_sbc_eq_r14_r3_r6_LSR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r8_r3_r4_LSR_r13),
    kInstruction_sbc_lt_r8_r3_r4_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r7_r4_r12_ROR_r6),
    kInstruction_sbc_vc_r7_r4_r12_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r5_r3_r3_ASR_r1),
    kInstruction_sbc_vs_r5_r3_r3_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r5_r6_r1_ROR_r7),
    kInstruction_sbc_le_r5_r6_r1_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r11_r5_r11_LSL_r12),
    kInstruction_sbc_ge_r11_r5_r11_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r0_r3_r7_ASR_r14),
    kInstruction_sbc_lt_r0_r3_r7_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r9_r2_r10_LSL_r1),
    kInstruction_sbc_cs_r9_r2_r10_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r6_r8_r6_ASR_r1),
    kInstruction_sbc_cs_r6_r8_r6_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r0_r11_r14_ASR_r5),
    kInstruction_sbc_lt_r0_r11_r14_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r11_r11_r2_ASR_r3),
    kInstruction_sbc_ge_r11_r11_r2_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r0_r0_r14_LSL_r2),
    kInstruction_sbc_lt_r0_r0_r14_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r8_r9_r11_ROR_r8),
    kInstruction_sbc_cs_r8_r9_r11_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r9_r5_r12_ASR_r14),
    kInstruction_sbc_pl_r9_r5_r12_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r13_r11_r1_LSR_r1),
    kInstruction_sbc_eq_r13_r11_r1_LSR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r1_r0_r13_ROR_r0),
    kInstruction_sbc_ne_r1_r0_r13_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r6_r5_r9_LSR_r10),
    kInstruction_sbc_hi_r6_r5_r9_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r4_r7_r7_ASR_r9),
    kInstruction_sbc_lt_r4_r7_r7_ASR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r13_r13_r5_LSR_r1),
    kInstruction_sbc_ls_r13_r13_r5_LSR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r12_r1_r6_LSR_r14),
    kInstruction_sbc_cs_r12_r1_r6_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r11_r0_r5_LSR_r3),
    kInstruction_sbc_hi_r11_r0_r5_LSR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r5_r2_r14_LSR_r1),
    kInstruction_sbc_ne_r5_r2_r14_LSR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r6_r12_r9_LSR_r5),
    kInstruction_sbc_le_r6_r12_r9_LSR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r1_r11_r1_LSL_r2),
    kInstruction_sbc_cs_r1_r11_r1_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r14_r10_r8_ASR_r4),
    kInstruction_sbc_al_r14_r10_r8_ASR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r11_r10_r8_LSL_r6),
    kInstruction_sbc_al_r11_r10_r8_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r1_r2_r1_LSL_r11),
    kInstruction_sbc_vs_r1_r2_r1_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r10_r14_r14_LSL_r0),
    kInstruction_sbc_cs_r10_r14_r14_LSL_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r0_r1_r14_ROR_r10),
    kInstruction_sbc_pl_r0_r1_r14_ROR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r3_r7_r5_LSR_r1),
    kInstruction_sbc_pl_r3_r7_r5_LSR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r2_r14_r10_LSL_r6),
    kInstruction_sbc_gt_r2_r14_r10_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r7_r7_r8_ROR_r0),
    kInstruction_sbc_le_r7_r7_r8_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r7_r9_r8_LSL_r14),
    kInstruction_sbc_cs_r7_r9_r8_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r11_r4_r3_LSR_r10),
    kInstruction_sbc_cs_r11_r4_r3_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r9_r1_r12_ROR_r4),
    kInstruction_sbc_cc_r9_r1_r12_ROR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r10_r0_r10_LSL_r8),
    kInstruction_sbc_hi_r10_r0_r10_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r14_r1_r0_LSL_r11),
    kInstruction_sbc_eq_r14_r1_r0_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r9_r11_r5_ROR_r5),
    kInstruction_sbc_mi_r9_r11_r5_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r5_r9_r2_LSL_r1),
    kInstruction_sbc_le_r5_r9_r2_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r7_r7_r8_ASR_r13),
    kInstruction_sbc_pl_r7_r7_r8_ASR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r14_r13_r10_ASR_r11),
    kInstruction_sbc_gt_r14_r13_r10_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r4_r6_r5_LSR_r7),
    kInstruction_sbc_cs_r4_r6_r5_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r2_r7_r7_LSL_r6),
    kInstruction_sbc_lt_r2_r7_r7_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r4_r5_r2_ROR_r5),
    kInstruction_sbc_al_r4_r5_r2_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r6_r2_r9_ROR_r7),
    kInstruction_sbc_cc_r6_r2_r9_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r4_r0_r0_LSR_r11),
    kInstruction_sbc_pl_r4_r0_r0_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r6_r10_r12_LSL_r11),
    kInstruction_sbc_pl_r6_r10_r12_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r0_r14_r1_LSR_r6),
    kInstruction_sbc_al_r0_r14_r1_LSR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r7_r9_r13_LSR_r1),
    kInstruction_sbc_cs_r7_r9_r13_LSR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r4_r2_r10_ROR_r3),
    kInstruction_sbc_al_r4_r2_r10_ROR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r12_r4_r14_ROR_r7),
    kInstruction_sbc_gt_r12_r4_r14_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r11_r0_r14_ASR_r7),
    kInstruction_sbc_cs_r11_r0_r14_ASR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r0_r2_r4_ASR_r14),
    kInstruction_sbc_pl_r0_r2_r4_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r14_r4_r9_LSR_r5),
    kInstruction_sbc_mi_r14_r4_r9_LSR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r13_r0_r1_ROR_r5),
    kInstruction_sbc_ge_r13_r0_r1_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r12_r14_r0_LSL_r11),
    kInstruction_sbc_eq_r12_r14_r0_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r6_r4_r10_ROR_r13),
    kInstruction_sbc_ge_r6_r4_r10_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r3_r7_r2_ASR_r5),
    kInstruction_sbc_lt_r3_r7_r2_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r9_r0_r12_ROR_r0),
    kInstruction_sbc_al_r9_r0_r12_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r1_r9_r7_LSL_r12),
    kInstruction_sbc_le_r1_r9_r7_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r14_r7_r4_ASR_r7),
    kInstruction_sbc_lt_r14_r7_r4_ASR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r4_r6_r9_LSR_r8),
    kInstruction_sbc_ne_r4_r6_r9_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r0_r5_r1_ASR_r6),
    kInstruction_sbc_cc_r0_r5_r1_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r2_r13_r2_ROR_r6),
    kInstruction_sbc_cc_r2_r13_r2_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r10_r0_r9_ROR_r6),
    kInstruction_sbc_ge_r10_r0_r9_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r8_r1_r11_LSR_r0),
    kInstruction_sbc_gt_r8_r1_r11_LSR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r14_r0_r9_LSL_r0),
    kInstruction_sbc_al_r14_r0_r9_LSL_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r12_r3_r12_ROR_r9),
    kInstruction_sbc_hi_r12_r3_r12_ROR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r4_r12_r3_LSL_r2),
    kInstruction_sbc_eq_r4_r12_r3_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r5_r3_r4_LSL_r4),
    kInstruction_sbc_ne_r5_r3_r4_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r8_r6_r10_LSL_r11),
    kInstruction_sbc_vc_r8_r6_r10_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r0_r1_r4_ASR_r3),
    kInstruction_sbc_lt_r0_r1_r4_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r14_r4_r1_ROR_r7),
    kInstruction_sbc_le_r14_r4_r1_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r12_r12_r5_LSL_r2),
    kInstruction_sbc_al_r12_r12_r5_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r10_r3_r10_ROR_r13),
    kInstruction_sbc_eq_r10_r3_r10_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r7_r10_r1_LSR_r14),
    kInstruction_sbc_ne_r7_r10_r1_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r10_r4_r10_LSR_r5),
    kInstruction_sbc_lt_r10_r4_r10_LSR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r0_r14_r0_LSL_r2),
    kInstruction_sbc_pl_r0_r14_r0_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r7_r4_r11_LSL_r3),
    kInstruction_sbc_gt_r7_r4_r11_LSL_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r8_r2_r1_LSR_r8),
    kInstruction_sbc_cs_r8_r2_r1_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r9_r11_r4_ASR_r7),
    kInstruction_sbc_pl_r9_r11_r4_ASR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r9_r5_r12_ROR_r4),
    kInstruction_sbc_cc_r9_r5_r12_ROR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r0_r11_r3_LSR_r12),
    kInstruction_sbc_vc_r0_r11_r3_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r6_r2_r4_LSR_r4),
    kInstruction_sbc_gt_r6_r2_r4_LSR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r4_r2_r0_LSL_r12),
    kInstruction_sbc_lt_r4_r2_r0_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r9_r4_r13_ROR_r5),
    kInstruction_sbc_le_r9_r4_r13_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r9_r3_r8_LSR_r8),
    kInstruction_sbc_vs_r9_r3_r8_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r3_r8_r14_ROR_r8),
    kInstruction_sbc_ne_r3_r8_r14_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r12_r13_r4_LSR_r9),
    kInstruction_sbc_vc_r12_r13_r4_LSR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r14_r0_r8_LSL_r1),
    kInstruction_sbc_cc_r14_r0_r8_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r6_r3_r5_ASR_r9),
    kInstruction_sbc_hi_r6_r3_r5_ASR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r14_r4_r3_LSL_r8),
    kInstruction_sbc_ne_r14_r4_r3_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r1_r10_r13_LSR_r4),
    kInstruction_sbc_ge_r1_r10_r13_LSR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r12_r7_r6_ROR_r3),
    kInstruction_sbc_vc_r12_r7_r6_ROR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r0_r6_r7_ROR_r2),
    kInstruction_sbc_gt_r0_r6_r7_ROR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r4_r6_r9_LSL_r0),
    kInstruction_sbc_al_r4_r6_r9_LSL_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r1_r3_r11_LSR_r11),
    kInstruction_sbc_ls_r1_r3_r11_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r3_r11_r1_LSR_r14),
    kInstruction_sbc_lt_r3_r11_r1_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r6_r13_r7_ROR_r11),
    kInstruction_sbc_vc_r6_r13_r7_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r5_r14_r13_ROR_r13),
    kInstruction_sbc_vc_r5_r14_r13_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r1_r4_r11_LSL_r1),
    kInstruction_sbc_vc_r1_r4_r11_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r7_r3_r5_LSR_r6),
    kInstruction_sbc_ls_r7_r3_r5_LSR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r13_r8_r3_ASR_r4),
    kInstruction_sbc_vc_r13_r8_r3_ASR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r2_r3_r10_ROR_r11),
    kInstruction_sbc_ls_r2_r3_r10_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r6_r1_r12_ASR_r11),
    kInstruction_sbc_ge_r6_r1_r12_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r3_r1_r1_ASR_r14),
    kInstruction_sbc_lt_r3_r1_r1_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r2_r7_r14_LSL_r12),
    kInstruction_sbc_hi_r2_r7_r14_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r13_r10_r10_LSL_r14),
    kInstruction_sbc_ge_r13_r10_r10_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r0_r1_r3_LSR_r3),
    kInstruction_sbc_le_r0_r1_r3_LSR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r10_r7_r7_LSR_r6),
    kInstruction_sbc_vs_r10_r7_r7_LSR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r6_r3_r6_LSL_r7),
    kInstruction_sbc_al_r6_r3_r6_LSL_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r3_r8_r14_ASR_r1),
    kInstruction_sbc_ne_r3_r8_r14_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r4_r10_r4_LSR_r9),
    kInstruction_sbc_cc_r4_r10_r4_LSR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r4_r1_r5_LSR_r10),
    kInstruction_sbc_cs_r4_r1_r5_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r7_r6_r1_LSL_r4),
    kInstruction_sbc_eq_r7_r6_r1_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r3_r7_r1_LSL_r5),
    kInstruction_sbc_hi_r3_r7_r1_LSL_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r6_r11_r8_LSR_r12),
    kInstruction_sbc_al_r6_r11_r8_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r2_r5_r0_LSR_r5),
    kInstruction_sbc_ls_r2_r5_r0_LSR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r4_r5_r13_LSL_r9),
    kInstruction_sbc_pl_r4_r5_r13_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r13_r12_r0_ASR_r8),
    kInstruction_sbc_lt_r13_r12_r0_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r11_r5_r0_LSL_r12),
    kInstruction_sbc_cc_r11_r5_r0_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r6_r2_r2_ROR_r0),
    kInstruction_sbc_ne_r6_r2_r2_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r9_r13_r12_ASR_r6),
    kInstruction_sbc_ne_r9_r13_r12_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r8_r6_r10_ROR_r10),
    kInstruction_sbc_cs_r8_r6_r10_ROR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r10_r6_r1_LSL_r6),
    kInstruction_sbc_vs_r10_r6_r1_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r12_r0_r4_ASR_r10),
    kInstruction_sbc_vc_r12_r0_r4_ASR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r10_r2_r11_ROR_r8),
    kInstruction_sbc_cs_r10_r2_r11_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r0_r9_r14_ASR_r14),
    kInstruction_sbc_ne_r0_r9_r14_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r0_r10_r1_ASR_r8),
    kInstruction_sbc_eq_r0_r10_r1_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r0_r11_r3_LSR_r0),
    kInstruction_sbc_gt_r0_r11_r3_LSR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r5_r11_r6_ROR_r14),
    kInstruction_sbc_al_r5_r11_r6_ROR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r2_r11_r11_ROR_r2),
    kInstruction_sbc_ls_r2_r11_r11_ROR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r2_r11_r6_ROR_r11),
    kInstruction_sbc_cs_r2_r11_r6_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r4_r9_r11_ASR_r5),
    kInstruction_sbc_cs_r4_r9_r11_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r5_r0_r2_ASR_r3),
    kInstruction_sbc_ls_r5_r0_r2_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r14_r1_r13_LSR_r2),
    kInstruction_sbc_cc_r14_r1_r13_LSR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r4_r5_r6_ASR_r0),
    kInstruction_sbc_lt_r4_r5_r6_ASR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r0_r12_r6_ASR_r6),
    kInstruction_sbc_vc_r0_r12_r6_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r3_r10_r4_LSR_r8),
    kInstruction_sbc_pl_r3_r10_r4_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r10_r5_r10_ASR_r10),
    kInstruction_sbc_cc_r10_r5_r10_ASR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r2_r14_r1_ASR_r10),
    kInstruction_sbc_pl_r2_r14_r1_ASR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r12_r13_r8_ROR_r12),
    kInstruction_sbc_eq_r12_r13_r8_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r9_r8_r2_LSL_r2),
    kInstruction_sbc_gt_r9_r8_r2_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r13_r10_r10_LSL_r9),
    kInstruction_sbc_al_r13_r10_r10_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r8_r8_r6_ROR_r14),
    kInstruction_sbc_eq_r8_r8_r6_ROR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r14_r12_r4_ASR_r13),
    kInstruction_sbc_le_r14_r12_r4_ASR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r3_r6_r12_LSR_r2),
    kInstruction_sbc_cc_r3_r6_r12_LSR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r5_r14_r10_LSL_r6),
    kInstruction_sbc_ls_r5_r14_r10_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r12_r2_r1_ROR_r3),
    kInstruction_sbc_hi_r12_r2_r1_ROR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r7_r13_r1_LSL_r12),
    kInstruction_sbc_vc_r7_r13_r1_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r0_r3_r13_LSL_r9),
    kInstruction_sbc_cc_r0_r3_r13_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r0_r11_r5_LSL_r11),
    kInstruction_sbc_hi_r0_r11_r5_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r9_r6_r14_LSR_r14),
    kInstruction_sbc_ge_r9_r6_r14_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r2_r5_r2_ROR_r12),
    kInstruction_sbc_vc_r2_r5_r2_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r9_r6_r9_ASR_r13),
    kInstruction_sbc_mi_r9_r6_r9_ASR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r1_r3_r10_ASR_r2),
    kInstruction_sbc_pl_r1_r3_r10_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r10_r9_r7_LSL_r4),
    kInstruction_sbc_le_r10_r9_r7_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r7_r4_r10_LSR_r6),
    kInstruction_sbc_hi_r7_r4_r10_LSR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r6_r8_r13_LSR_r3),
    kInstruction_sbc_cc_r6_r8_r13_LSR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r4_r9_r6_ASR_r0),
    kInstruction_sbc_cs_r4_r9_r6_ASR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r0_r2_r4_ASR_r8),
    kInstruction_sbc_ls_r0_r2_r4_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r11_r5_r11_LSR_r1),
    kInstruction_sbc_hi_r11_r5_r11_LSR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r0_r3_r6_LSR_r7),
    kInstruction_sbc_vc_r0_r3_r6_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r13_r10_r8_LSL_r6),
    kInstruction_sbc_cs_r13_r10_r8_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r12_r12_r10_ASR_r13),
    kInstruction_sbc_al_r12_r12_r10_ASR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r7_r7_r2_ASR_r8),
    kInstruction_sbc_ge_r7_r7_r2_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r10_r7_r6_LSL_r14),
    kInstruction_sbc_ne_r10_r7_r6_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r9_r9_r14_ROR_r0),
    kInstruction_sbc_cs_r9_r9_r14_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r3_r12_r0_ASR_r12),
    kInstruction_sbc_lt_r3_r12_r0_ASR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r6_r9_r3_ASR_r11),
    kInstruction_sbc_ne_r6_r9_r3_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r4_r7_r7_ASR_r7),
    kInstruction_sbc_vc_r4_r7_r7_ASR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r0_r9_r5_LSR_r14),
    kInstruction_sbc_ne_r0_r9_r5_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r8_r13_r1_ROR_r0),
    kInstruction_sbc_hi_r8_r13_r1_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r6_r1_r7_ROR_r5),
    kInstruction_sbc_cc_r6_r1_r7_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r7_r13_r2_LSL_r4),
    kInstruction_sbc_vc_r7_r13_r2_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r4_r2_r3_ROR_r10),
    kInstruction_sbc_al_r4_r2_r3_ROR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r0_r7_r3_LSR_r12),
    kInstruction_sbc_ls_r0_r7_r3_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r5_r8_r8_ASR_r13),
    kInstruction_sbc_ls_r5_r8_r8_ASR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r0_r6_r12_ASR_r14),
    kInstruction_sbc_gt_r0_r6_r12_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r7_r13_r14_LSR_r11),
    kInstruction_sbc_vs_r7_r13_r14_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r12_r9_r11_LSL_r13),
    kInstruction_sbc_mi_r12_r9_r11_LSL_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r0_r0_r7_ROR_r13),
    kInstruction_sbc_ge_r0_r0_r7_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r14_r12_r6_LSR_r8),
    kInstruction_sbc_hi_r14_r12_r6_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r0_r3_r6_LSL_r6),
    kInstruction_sbc_cs_r0_r3_r6_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r6_r9_r4_ASR_r3),
    kInstruction_sbc_al_r6_r9_r4_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r5_r6_r1_LSR_r3),
    kInstruction_sbc_ls_r5_r6_r1_LSR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r3_r6_r14_ROR_r7),
    kInstruction_sbc_ls_r3_r6_r14_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r10_r5_r1_ASR_r12),
    kInstruction_sbc_le_r10_r5_r1_ASR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r3_r6_r10_ASR_r5),
    kInstruction_sbc_hi_r3_r6_r10_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r9_r3_r5_ROR_r8),
    kInstruction_sbc_mi_r9_r3_r5_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r10_r13_r8_ROR_r11),
    kInstruction_sbc_hi_r10_r13_r8_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r11_r14_r2_ROR_r1),
    kInstruction_sbc_al_r11_r14_r2_ROR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r12_r8_r0_ROR_r11),
    kInstruction_sbc_gt_r12_r8_r0_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r1_r0_r1_ROR_r9),
    kInstruction_sbc_vc_r1_r0_r1_ROR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r6_r6_r3_ASR_r5),
    kInstruction_sbc_mi_r6_r6_r3_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r12_r12_r4_ROR_r9),
    kInstruction_sbc_ge_r12_r12_r4_ROR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r4_r6_r9_ASR_r6),
    kInstruction_sbc_ls_r4_r6_r9_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r11_r3_r4_LSR_r9),
    kInstruction_sbc_pl_r11_r3_r4_LSR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r0_r2_r2_ROR_r7),
    kInstruction_sbc_hi_r0_r2_r2_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r3_r12_r0_ASR_r2),
    kInstruction_sbc_pl_r3_r12_r0_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r6_r0_r9_LSL_r4),
    kInstruction_sbc_ne_r6_r0_r9_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r1_r2_r6_ROR_r13),
    kInstruction_sbc_vc_r1_r2_r6_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r9_r1_r12_LSL_r14),
    kInstruction_sbc_ge_r9_r1_r12_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r13_r9_r6_ROR_r14),
    kInstruction_sbc_pl_r13_r9_r6_ROR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r0_r13_r13_LSL_r9),
    kInstruction_sbc_gt_r0_r13_r13_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r13_r5_r5_ASR_r8),
    kInstruction_sbc_mi_r13_r5_r5_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r1_r4_r0_LSL_r6),
    kInstruction_sbc_gt_r1_r4_r0_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r5_r4_r7_ROR_r4),
    kInstruction_sbc_ls_r5_r4_r7_ROR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r8_r8_r0_ROR_r9),
    kInstruction_sbc_vc_r8_r8_r0_ROR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r12_r12_r10_ROR_r8),
    kInstruction_sbc_mi_r12_r12_r10_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r6_r6_r6_LSL_r2),
    kInstruction_sbc_hi_r6_r6_r6_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r7_r10_r14_LSL_r1),
    kInstruction_sbc_le_r7_r10_r14_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r13_r10_r6_ASR_r9),
    kInstruction_sbc_ne_r13_r10_r6_ASR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r8_r8_r2_LSR_r13),
    kInstruction_sbc_ne_r8_r8_r2_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r0_r10_r14_ROR_r12),
    kInstruction_sbc_mi_r0_r10_r14_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r11_r14_r4_LSL_r5),
    kInstruction_sbc_cc_r11_r14_r4_LSL_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r3_r6_r3_ROR_r4),
    kInstruction_sbc_cc_r3_r6_r3_ROR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r11_r1_r7_LSR_r7),
    kInstruction_sbc_mi_r11_r1_r7_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r12_r2_r2_LSL_r12),
    kInstruction_sbc_vs_r12_r2_r2_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r2_r2_r6_LSR_r0),
    kInstruction_sbc_pl_r2_r2_r6_LSR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r11_r12_r7_LSR_r12),
    kInstruction_sbc_gt_r11_r12_r7_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r13_r4_r4_ASR_r12),
    kInstruction_sbc_al_r13_r4_r4_ASR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r9_r1_r9_ROR_r1),
    kInstruction_sbc_le_r9_r1_r9_ROR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r1_r12_r8_ASR_r14),
    kInstruction_sbc_le_r1_r12_r8_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r1_r0_r7_ROR_r13),
    kInstruction_sbc_cs_r1_r0_r7_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r0_r7_r7_ROR_r5),
    kInstruction_sbc_le_r0_r7_r7_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r6_r5_r7_ROR_r4),
    kInstruction_sbc_hi_r6_r5_r7_ROR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r6_r14_r13_ASR_r1),
    kInstruction_sbc_eq_r6_r14_r13_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r1_r14_r13_LSR_r13),
    kInstruction_sbc_lt_r1_r14_r13_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r13_r1_r2_ROR_r6),
    kInstruction_sbc_vs_r13_r1_r2_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r11_r7_r8_ASR_r3),
    kInstruction_sbc_gt_r11_r7_r8_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r9_r5_r8_ASR_r8),
    kInstruction_sbc_hi_r9_r5_r8_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r10_r9_r5_LSL_r8),
    kInstruction_sbc_lt_r10_r9_r5_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r6_r1_r2_LSL_r4),
    kInstruction_sbc_vs_r6_r1_r2_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r13_r4_r10_LSR_r12),
    kInstruction_sbc_pl_r13_r4_r10_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r9_r8_r8_LSL_r6),
    kInstruction_sbc_cs_r9_r8_r8_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r1_r7_r0_ASR_r2),
    kInstruction_sbc_ne_r1_r7_r0_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r6_r3_r9_ASR_r3),
    kInstruction_sbc_cc_r6_r3_r9_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r13_r14_r7_ROR_r13),
    kInstruction_sbc_hi_r13_r14_r7_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r7_r11_r0_LSR_r8),
    kInstruction_sbc_vc_r7_r11_r0_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r3_r2_r7_LSL_r12),
    kInstruction_sbc_al_r3_r2_r7_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r0_r5_r5_LSR_r1),
    kInstruction_sbc_lt_r0_r5_r5_LSR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r10_r10_r4_ROR_r11),
    kInstruction_sbc_ge_r10_r10_r4_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r13_r9_r1_ROR_r12),
    kInstruction_sbc_ne_r13_r9_r1_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r6_r6_r2_ROR_r3),
    kInstruction_sbc_eq_r6_r6_r2_ROR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r0_r4_r1_ROR_r5),
    kInstruction_sbc_gt_r0_r4_r1_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r5_r8_r0_ROR_r0),
    kInstruction_sbc_lt_r5_r8_r0_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r5_r13_r2_LSR_r8),
    kInstruction_sbc_cs_r5_r13_r2_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r7_r13_r2_LSL_r7),
    kInstruction_sbc_le_r7_r13_r2_LSL_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r7_r1_r3_LSL_r1),
    kInstruction_sbc_gt_r7_r1_r3_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r4_r13_r10_ROR_r8),
    kInstruction_sbc_vc_r4_r13_r10_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r2_r8_r11_ROR_r4),
    kInstruction_sbc_eq_r2_r8_r11_ROR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r10_r1_r6_LSR_r9),
    kInstruction_sbc_le_r10_r1_r6_LSR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r5_r1_r9_ASR_r10),
    kInstruction_sbc_ge_r5_r1_r9_ASR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r1_r5_r5_LSR_r7),
    kInstruction_sbc_al_r1_r5_r5_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r2_r13_r5_LSR_r8),
    kInstruction_sbc_cs_r2_r13_r5_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r6_r6_r3_ROR_r3),
    kInstruction_sbc_le_r6_r6_r3_ROR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r5_r1_r7_ROR_r12),
    kInstruction_sbc_le_r5_r1_r7_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r9_r3_r9_ASR_r4),
    kInstruction_sbc_cc_r9_r3_r9_ASR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r6_r2_r9_LSL_r5),
    kInstruction_sbc_mi_r6_r2_r9_LSL_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r5_r0_r4_ASR_r12),
    kInstruction_sbc_cc_r5_r0_r4_ASR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r8_r13_r12_LSL_r11),
    kInstruction_sbc_vc_r8_r13_r12_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r7_r14_r9_LSR_r11),
    kInstruction_sbc_lt_r7_r14_r9_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r1_r5_r3_ASR_r1),
    kInstruction_sbc_cs_r1_r5_r3_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r14_r11_r6_ASR_r9),
    kInstruction_sbc_lt_r14_r11_r6_ASR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r10_r5_r13_LSR_r3),
    kInstruction_sbc_gt_r10_r5_r13_LSR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r6_r4_r12_LSL_r4),
    kInstruction_sbc_cc_r6_r4_r12_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r2_r12_r10_ROR_r11),
    kInstruction_sbc_ne_r2_r12_r10_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r8_r0_r6_ASR_r10),
    kInstruction_sbc_eq_r8_r0_r6_ASR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r14_r3_r14_LSR_r7),
    kInstruction_sbc_cc_r14_r3_r14_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r1_r10_r1_ASR_r13),
    kInstruction_sbc_lt_r1_r10_r1_ASR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r14_r3_r0_LSL_r12),
    kInstruction_sbc_cc_r14_r3_r0_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r8_r10_r7_LSL_r2),
    kInstruction_sbc_vs_r8_r10_r7_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r5_r6_r3_ASR_r2),
    kInstruction_sbc_ls_r5_r6_r3_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r11_r5_r13_LSL_r10),
    kInstruction_sbc_vc_r11_r5_r13_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r2_r10_r7_LSR_r0),
    kInstruction_sbc_hi_r2_r10_r7_LSR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r5_r6_r8_ASR_r4),
    kInstruction_sbc_ne_r5_r6_r8_ASR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r3_r12_r8_ASR_r5),
    kInstruction_sbc_cs_r3_r12_r8_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r3_r4_r4_LSR_r0),
    kInstruction_sbc_ge_r3_r4_r4_LSR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r13_r13_r6_ROR_r13),
    kInstruction_sbc_ge_r13_r13_r6_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r4_r9_r0_LSL_r9),
    kInstruction_sbc_eq_r4_r9_r0_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r7_r3_r1_ROR_r8),
    kInstruction_sbc_le_r7_r3_r1_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r9_r2_r5_LSL_r4),
    kInstruction_sbc_gt_r9_r2_r5_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r10_r12_r9_ROR_r12),
    kInstruction_sbc_gt_r10_r12_r9_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r4_r9_r6_LSR_r14),
    kInstruction_sbc_hi_r4_r9_r6_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r1_r10_r9_LSR_r8),
    kInstruction_sbc_pl_r1_r10_r9_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r0_r11_r2_ROR_r13),
    kInstruction_sbc_mi_r0_r11_r2_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r14_r5_r4_ASR_r2),
    kInstruction_sbc_ge_r14_r5_r4_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r7_r8_r9_ROR_r10),
    kInstruction_sbc_vc_r7_r8_r9_ROR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r3_r1_r0_ROR_r7),
    kInstruction_sbc_cs_r3_r1_r0_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r9_r11_r4_ASR_r14),
    kInstruction_sbc_hi_r9_r11_r4_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r3_r8_r6_LSR_r12),
    kInstruction_sbc_mi_r3_r8_r6_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r5_r5_r6_LSL_r1),
    kInstruction_sbc_vc_r5_r5_r6_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r4_r8_r1_ASR_r3),
    kInstruction_sbc_mi_r4_r8_r1_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r6_r0_r0_LSL_r0),
    kInstruction_sbc_le_r6_r0_r0_LSL_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r8_r11_r8_LSL_r14),
    kInstruction_sbc_hi_r8_r11_r8_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r14_r8_r12_ASR_r13),
    kInstruction_sbc_gt_r14_r8_r12_ASR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r7_r7_r4_ROR_r7),
    kInstruction_sbc_ge_r7_r7_r4_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r11_r4_r13_LSL_r3),
    kInstruction_sbc_eq_r11_r4_r13_LSL_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r3_r6_r6_LSL_r10),
    kInstruction_sbc_eq_r3_r6_r6_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r3_r10_r11_ROR_r12),
    kInstruction_sbc_al_r3_r10_r11_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r13_r7_r8_LSL_r13),
    kInstruction_sbc_pl_r13_r7_r8_LSL_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r9_r2_r11_LSR_r2),
    kInstruction_sbc_pl_r9_r2_r11_LSR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r3_r12_r8_LSR_r2),
    kInstruction_sbc_al_r3_r12_r8_LSR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r4_r14_r6_ROR_r0),
    kInstruction_sbc_ne_r4_r14_r6_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r6_r14_r13_ASR_r3),
    kInstruction_sbc_cs_r6_r14_r13_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r10_r6_r8_LSR_r7),
    kInstruction_sbc_pl_r10_r6_r8_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r10_r1_r12_ROR_r6),
    kInstruction_sbc_ls_r10_r1_r12_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r12_r0_r1_LSL_r9),
    kInstruction_sbc_eq_r12_r0_r1_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r11_r14_r8_ROR_r6),
    kInstruction_sbc_hi_r11_r14_r8_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r9_r2_r5_LSL_r6),
    kInstruction_sbc_vc_r9_r2_r5_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r11_r8_r5_LSR_r11),
    kInstruction_sbc_ne_r11_r8_r5_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r1_r12_r3_ASR_r5),
    kInstruction_sbc_mi_r1_r12_r3_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r14_r7_r1_ASR_r12),
    kInstruction_sbc_pl_r14_r7_r1_ASR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r9_r4_r1_ASR_r1),
    kInstruction_sbc_pl_r9_r4_r1_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r11_r0_r5_ROR_r14),
    kInstruction_sbc_ls_r11_r0_r5_ROR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r13_r10_r14_ROR_r13),
    kInstruction_sbc_lt_r13_r10_r14_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r3_r14_r10_LSR_r4),
    kInstruction_sbc_gt_r3_r14_r10_LSR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r1_r0_r5_ROR_r7),
    kInstruction_sbc_cc_r1_r0_r5_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r2_r14_r0_LSR_r14),
    kInstruction_sbc_hi_r2_r14_r0_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r3_r7_r2_ASR_r9),
    kInstruction_sbc_pl_r3_r7_r2_ASR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r7_r5_r0_ROR_r6),
    kInstruction_sbc_eq_r7_r5_r0_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r14_r9_r14_LSR_r5),
    kInstruction_sbc_mi_r14_r9_r14_LSR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r6_r1_r1_LSL_r12),
    kInstruction_sbc_mi_r6_r1_r1_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r12_r0_r8_LSR_r0),
    kInstruction_sbc_ge_r12_r0_r8_LSR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r13_r8_r3_ROR_r7),
    kInstruction_sbc_cc_r13_r8_r3_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r7_r9_r4_LSL_r11),
    kInstruction_sbc_vs_r7_r9_r4_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r9_r10_r9_LSR_r5),
    kInstruction_sbc_ge_r9_r10_r9_LSR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r5_r3_r0_LSR_r7),
    kInstruction_sbc_ls_r5_r3_r0_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r0_r6_r1_LSL_r11),
    kInstruction_sbc_eq_r0_r6_r1_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r9_r7_r0_ROR_r11),
    kInstruction_sbc_ge_r9_r7_r0_ROR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r4_r2_r3_LSL_r12),
    kInstruction_sbc_mi_r4_r2_r3_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r7_r5_r0_ASR_r5),
    kInstruction_sbc_hi_r7_r5_r0_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r7_r13_r7_LSL_r14),
    kInstruction_sbc_cc_r7_r13_r7_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r2_r11_r2_LSL_r14),
    kInstruction_sbc_ne_r2_r11_r2_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r7_r5_r3_LSR_r11),
    kInstruction_sbc_cc_r7_r5_r3_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r12_r0_r12_ASR_r10),
    kInstruction_sbc_ge_r12_r0_r12_ASR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r11_r0_r2_LSR_r11),
    kInstruction_sbc_al_r11_r0_r2_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r1_r12_r1_ROR_r1),
    kInstruction_sbc_cc_r1_r12_r1_ROR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r5_r9_r6_ASR_r4),
    kInstruction_sbc_ls_r5_r9_r6_ASR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r5_r13_r2_ROR_r12),
    kInstruction_sbc_ne_r5_r13_r2_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r9_r10_r12_ROR_r10),
    kInstruction_sbc_ge_r9_r10_r12_ROR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r10_r1_r8_LSR_r12),
    kInstruction_sbc_cc_r10_r1_r8_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r9_r6_r11_ROR_r3),
    kInstruction_sbc_le_r9_r6_r11_ROR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r9_r9_r13_ASR_r5),
    kInstruction_sbc_le_r9_r9_r13_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r1_r12_r11_LSL_r12),
    kInstruction_sbc_ge_r1_r12_r11_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r11_r4_r6_LSL_r10),
    kInstruction_sbc_vs_r11_r4_r6_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r3_r3_r1_ROR_r2),
    kInstruction_sbc_vs_r3_r3_r1_ROR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r12_r8_r12_ASR_r11),
    kInstruction_sbc_ne_r12_r8_r12_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r4_r8_r1_ROR_r8),
    kInstruction_sbc_pl_r4_r8_r1_ROR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r3_r11_r13_ROR_r9),
    kInstruction_sbc_gt_r3_r11_r13_ROR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r6_r0_r3_LSR_r9),
    kInstruction_sbc_pl_r6_r0_r3_LSR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r5_r7_r9_LSL_r10),
    kInstruction_sbc_ne_r5_r7_r9_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r1_r12_r12_LSR_r8),
    kInstruction_sbc_lt_r1_r12_r12_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r2_r0_r0_ROR_r5),
    kInstruction_sbc_cc_r2_r0_r0_ROR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r7_r11_r8_LSR_r14),
    kInstruction_sbc_vc_r7_r11_r8_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r0_r11_r6_ROR_r10),
    kInstruction_sbc_ge_r0_r11_r6_ROR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r0_r9_r1_LSR_r0),
    kInstruction_sbc_vs_r0_r9_r1_LSR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r13_r7_r11_LSR_r1),
    kInstruction_sbc_gt_r13_r7_r11_LSR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r9_r10_r2_ROR_r12),
    kInstruction_sbc_eq_r9_r10_r2_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r0_r4_r0_LSR_r3),
    kInstruction_sbc_eq_r0_r4_r0_LSR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r14_r2_r9_ASR_r12),
    kInstruction_sbc_cs_r14_r2_r9_ASR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r9_r4_r9_ASR_r8),
    kInstruction_sbc_lt_r9_r4_r9_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r6_r12_r3_LSL_r11),
    kInstruction_sbc_vs_r6_r12_r3_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r9_r14_r10_ROR_r0),
    kInstruction_sbc_ge_r9_r14_r10_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r10_r2_r5_LSL_r12),
    kInstruction_sbc_pl_r10_r2_r5_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r8_r0_r6_ROR_r6),
    kInstruction_sbc_al_r8_r0_r6_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r9_r7_r7_LSR_r11),
    kInstruction_sbc_le_r9_r7_r7_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r3_r4_r5_LSR_r1),
    kInstruction_sbc_vc_r3_r4_r5_LSR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r13_r1_r4_LSR_r11),
    kInstruction_sbc_cc_r13_r1_r4_LSR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r13_r4_r0_LSL_r10),
    kInstruction_sbc_vc_r13_r4_r0_LSL_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r5_r0_r1_LSR_r1),
    kInstruction_sbc_vc_r5_r0_r1_LSR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r5_r11_r1_ASR_r9),
    kInstruction_sbc_ls_r5_r11_r1_ASR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r3_r2_r8_ASR_r1),
    kInstruction_sbc_vs_r3_r2_r8_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r8_r4_r6_ASR_r4),
    kInstruction_sbc_hi_r8_r4_r6_ASR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r11_r12_r14_ASR_r13),
    kInstruction_sbc_mi_r11_r12_r14_ASR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r7_r12_r12_LSL_r14),
    kInstruction_sbc_gt_r7_r12_r12_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r11_r4_r9_LSR_r7),
    kInstruction_sbc_ge_r11_r4_r9_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r0_r4_r10_LSL_r2),
    kInstruction_sbc_vs_r0_r4_r10_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r6_r4_r13_ASR_r0),
    kInstruction_sbc_pl_r6_r4_r13_ASR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r2_r3_r11_ROR_r1),
    kInstruction_sbc_eq_r2_r3_r11_ROR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r10_r9_r0_LSL_r4),
    kInstruction_sbc_vs_r10_r9_r0_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r0_r7_r10_LSL_r0),
    kInstruction_sbc_cs_r0_r7_r10_LSL_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r11_r2_r3_ASR_r13),
    kInstruction_sbc_eq_r11_r2_r3_ASR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r14_r3_r7_ASR_r14),
    kInstruction_sbc_eq_r14_r3_r7_ASR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r0_r2_r0_LSL_r12),
    kInstruction_sbc_gt_r0_r2_r0_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r0_r12_r6_LSR_r13),
    kInstruction_sbc_mi_r0_r12_r6_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r4_r4_r9_LSR_r12),
    kInstruction_sbc_gt_r4_r4_r9_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r6_r7_r10_ROR_r2),
    kInstruction_sbc_vc_r6_r7_r10_ROR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r10_r8_r13_ROR_r13),
    kInstruction_sbc_lt_r10_r8_r13_ROR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r13_r10_r4_ROR_r0),
    kInstruction_sbc_lt_r13_r10_r4_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r1_r6_r0_LSR_r12),
    kInstruction_sbc_pl_r1_r6_r0_LSR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r14_r7_r1_LSR_r8),
    kInstruction_sbc_ge_r14_r7_r1_LSR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r8_r13_r6_LSL_r13),
    kInstruction_sbc_cc_r8_r13_r6_LSL_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r13_r4_r7_LSR_r2),
    kInstruction_sbc_gt_r13_r4_r7_LSR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r11_r3_r5_LSR_r3),
    kInstruction_sbc_eq_r11_r3_r5_LSR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r8_r11_r2_ROR_r7),
    kInstruction_sbc_vc_r8_r11_r2_ROR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r11_r2_r0_LSL_r2),
    kInstruction_sbc_vc_r11_r2_r0_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r9_r11_r11_LSL_r11),
    kInstruction_sbc_cs_r9_r11_r11_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r14_r4_r12_LSL_r11),
    kInstruction_sbc_ge_r14_r4_r12_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r4_r10_r3_LSL_r1),
    kInstruction_sbc_vs_r4_r10_r3_LSL_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r13_r1_r8_LSR_r2),
    kInstruction_sbc_mi_r13_r1_r8_LSR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r3_r13_r13_LSL_r8),
    kInstruction_sbc_le_r3_r13_r13_LSL_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r9_r12_r8_LSR_r14),
    kInstruction_sbc_mi_r9_r12_r8_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r7_r11_r10_ASR_r2),
    kInstruction_sbc_pl_r7_r11_r10_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r12_r2_r9_ASR_r5),
    kInstruction_sbc_lt_r12_r2_r9_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r13_r0_r5_LSL_r2),
    kInstruction_sbc_gt_r13_r0_r5_LSL_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r5_r10_r9_ROR_r0),
    kInstruction_sbc_le_r5_r10_r9_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r6_r1_r4_ASR_r11),
    kInstruction_sbc_lt_r6_r1_r4_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r11_r5_r14_LSR_r4),
    kInstruction_sbc_pl_r11_r5_r14_LSR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r9_r0_r6_ROR_r9),
    kInstruction_sbc_eq_r9_r0_r6_ROR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r3_r11_r2_ASR_r4),
    kInstruction_sbc_mi_r3_r11_r2_ASR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r13_r8_r0_ROR_r6),
    kInstruction_sbc_pl_r13_r8_r0_ROR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r8_r2_r6_ASR_r4),
    kInstruction_sbc_vc_r8_r2_r6_ASR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r1_r0_r4_ASR_r1),
    kInstruction_sbc_ge_r1_r0_r4_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r2_r4_r13_LSL_r13),
    kInstruction_sbc_vc_r2_r4_r13_LSL_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r4_r3_r5_ASR_r11),
    kInstruction_sbc_lt_r4_r3_r5_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r5_r12_r3_LSL_r4),
    kInstruction_sbc_pl_r5_r12_r3_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r14_r6_r6_LSR_r10),
    kInstruction_sbc_pl_r14_r6_r6_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r14_r13_r3_LSL_r9),
    kInstruction_sbc_gt_r14_r13_r3_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r10_r9_r4_LSL_r3),
    kInstruction_sbc_pl_r10_r9_r4_LSL_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r10_r8_r4_ROR_r1),
    kInstruction_sbc_al_r10_r8_r4_ROR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r14_r9_r11_ASR_r13),
    kInstruction_sbc_pl_r14_r9_r11_ASR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cc_r8_r1_r4_ROR_r12),
    kInstruction_sbc_cc_r8_r1_r4_ROR_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r5_r14_r7_LSR_r0),
    kInstruction_sbc_vs_r5_r14_r7_LSR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r1_r10_r13_ROR_r9),
    kInstruction_sbc_gt_r1_r10_r13_ROR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r8_r14_r9_LSR_r5),
    kInstruction_sbc_mi_r8_r14_r9_LSR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r12_r10_r7_ROR_r2),
    kInstruction_sbc_ge_r12_r10_r7_ROR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r11_r8_r1_LSR_r10),
    kInstruction_sbc_al_r11_r8_r1_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r7_r13_r11_LSL_r14),
    kInstruction_sbc_al_r7_r13_r11_LSL_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r13_r11_r11_ASR_r9),
    kInstruction_sbc_vc_r13_r11_r11_ASR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_gt_r10_r5_r11_LSR_r14),
    kInstruction_sbc_gt_r10_r5_r11_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r10_r11_r7_ROR_r3),
    kInstruction_sbc_vc_r10_r11_r7_ROR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r10_r2_r7_LSL_r6),
    kInstruction_sbc_le_r10_r2_r7_LSL_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r1_r3_r6_ASR_r5),
    kInstruction_sbc_al_r1_r3_r6_ASR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r14_r9_r7_LSL_r12),
    kInstruction_sbc_cs_r14_r9_r7_LSL_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r10_r1_r4_LSL_r4),
    kInstruction_sbc_ls_r10_r1_r4_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r2_r5_r4_ROR_r3),
    kInstruction_sbc_vs_r2_r5_r4_ROR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r1_r7_r10_ASR_r0),
    kInstruction_sbc_vs_r1_r7_r10_ASR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_cs_r10_r12_r0_LSR_r4),
    kInstruction_sbc_cs_r10_r12_r0_LSR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r8_r8_r1_LSR_r13),
    kInstruction_sbc_vs_r8_r8_r1_LSR_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r14_r5_r9_LSR_r7),
    kInstruction_sbc_mi_r14_r5_r9_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r6_r6_r14_ASR_r8),
    kInstruction_sbc_vs_r6_r6_r14_ASR_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r0_r1_r14_ROR_r0),
    kInstruction_sbc_vc_r0_r1_r14_ROR_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r9_r3_r11_ASR_r3),
    kInstruction_sbc_ls_r9_r3_r11_ASR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r1_r12_r1_ASR_r6),
    kInstruction_sbc_ls_r1_r12_r1_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r6_r10_r0_ASR_r2),
    kInstruction_sbc_hi_r6_r10_r0_ASR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r6_r14_r7_ASR_r1),
    kInstruction_sbc_vc_r6_r14_r7_ASR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r14_r11_r10_LSL_r13),
    kInstruction_sbc_eq_r14_r11_r10_LSL_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r6_r12_r5_LSR_r9),
    kInstruction_sbc_ge_r6_r12_r5_LSR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r1_r5_r0_ROR_r9),
    kInstruction_sbc_mi_r1_r5_r0_ROR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r7_r8_r2_ROR_r4),
    kInstruction_sbc_al_r7_r8_r2_ROR_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_hi_r8_r1_r5_ASR_r10),
    kInstruction_sbc_hi_r8_r1_r5_ASR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ne_r14_r5_r0_LSR_r7),
    kInstruction_sbc_ne_r14_r5_r0_LSR_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r3_r13_r9_LSL_r9),
    kInstruction_sbc_vc_r3_r13_r9_LSL_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r2_r2_r7_LSL_r5),
    kInstruction_sbc_vs_r2_r2_r7_LSL_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r7_r3_r6_ASR_r6),
    kInstruction_sbc_vc_r7_r3_r6_ASR_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r2_r5_r8_ROR_r1),
    kInstruction_sbc_eq_r2_r5_r8_ROR_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_eq_r0_r0_r10_ROR_r3),
    kInstruction_sbc_eq_r0_r0_r10_ROR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_lt_r6_r1_r0_ROR_r9),
    kInstruction_sbc_lt_r6_r1_r0_ROR_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ls_r7_r7_r12_LSR_r5),
    kInstruction_sbc_ls_r7_r7_r12_LSR_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r0_r9_r7_ROR_r14),
    kInstruction_sbc_vs_r0_r9_r7_ROR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_al_r0_r8_r2_ROR_r2),
    kInstruction_sbc_al_r0_r8_r2_ROR_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r1_r14_r14_LSL_r11),
    kInstruction_sbc_vc_r1_r14_r14_LSL_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_ge_r9_r14_r10_ASR_r11),
    kInstruction_sbc_ge_r9_r14_r10_ASR_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vs_r0_r3_r9_LSL_r4),
    kInstruction_sbc_vs_r0_r3_r9_LSL_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_pl_r14_r13_r7_LSR_r14),
    kInstruction_sbc_pl_r14_r13_r7_LSR_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_le_r2_r4_r6_LSR_r3),
    kInstruction_sbc_le_r2_r4_r6_LSR_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_vc_r7_r14_r6_LSR_r10),
    kInstruction_sbc_vc_r7_r14_r6_LSR_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sbc_mi_r13_r11_r14_ASR_r7),
    kInstruction_sbc_mi_r13_r11_r14_ASR_r7,
  },
};

#endif  // VIXL_ASSEMBLER_COND_RD_RN_OPERAND_RM_SHIFT_RS_SBC_A32_H_
