// The Great Computer Language Shootout
//  http://shootout.alioth.debian.org
//
//  Contributed by Ian Osgood

var last = 42, A = 3877, C = 29573, M = 139968;

function rand(max) {
  last = (last * A + C) % M;
  return max * last / M;
}

var ALU =
  "GGCCGGGCGCGGTGGCTCACGCCTGTAATCCCAGCACTTTGG" +
  "GAGGCCGAGGCGGGCGGATCACCTGAGGTCAGGAGTTCGAGA" +
  "CCAGCCTGGCCAACATGGTGAAACCCCGTCTCTACTAAAAAT" +
  "ACAAAAATTAGCCGGGCGTGGTGGCGCGCGCCTGTAATCCCA" +
  "GCTACTCGGGAGGCTGAGGCAGGAGAATCGCTTGAACCCGGG" +
  "AGGCGGAGGTTGCAGTGAGCCGAGATCGCGCCACTGCACTCC" +
  "AGCCTGGGCGACAGAGCGAGACTCCGTCTCAAAAA";

var IUB = {
  a:0.27, c:0.12, g:0.12, t:0.27,
  B:0.02, D:0.02, H:0.02, K:0.02,
  M:0.02, N:0.02, R:0.02, S:0.02,
  V:0.02, W:0.02, Y:0.02
}

var HomoSap = {
  a: 0.3029549426680,
  c: 0.1979883004921,
  g: 0.1975473066391,
  t: 0.3015094502008
}

function makeCumulative(table) {
  var last = null;
  /* BEGIN LOOP */
  for (var c in table) {
    if (last) table[c] += table[last];
    last = c;
  }
  /* END LOOP */
}

function fastaRepeat(n, seq) {
  var seqi = 0, lenOut = 60;
  /* BEGIN LOOP */
  while (n>0) {
    if (n<lenOut) lenOut = n;
    if (seqi + lenOut < seq.length) {
      ret = seq.substring(seqi, seqi+lenOut);
      seqi += lenOut;
    } else {
      var s = seq.substring(seqi);
      seqi = lenOut - s.length;
      ret = s + seq.substring(0, seqi);
    }
    n -= lenOut;
  }
  /* END LOOP */
}

function fastaRandom(n, table) {
  var line = new Array(60);
  makeCumulative(table);
  /* BEGIN LOOP */
  while (n>0) {
    if (n<line.length) line = new Array(n);
  /* BEGIN LOOP */
    for (var i=0; i<line.length; i++) {
      var r = rand(1);
  /* BEGIN LOOP */
      for (var c in table) {
        if (r < table[c]) {
          line[i] = c;
          break;
        }
      }
  /* END LOOP */
    }
  /* END LOOP */
    ret = line.join('');
    n -= line.length;
  }
  /* END LOOP */
}

var ret;

var count = 7;
ret = fastaRepeat(2*count*100000, ALU);
ret = fastaRandom(3*count*1000, IUB);
ret = fastaRandom(5*count*1000, HomoSap);

