; ***** BEGIN LICENSE BLOCK *****
; Version: MPL 1.1/GPL 2.0/LGPL 2.1
; 
; The contents of this file are subject to the Mozilla Public License Version
; 1.1 (the "License"); you may not use this file except in compliance with
; the License. You may obtain a copy of the License at
; http://www.mozilla.org/MPL/
; 
; Software distributed under the License is distributed on an "AS IS" basis,
; WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
; for the specific language governing rights and limitations under the
; License.
; 
; The Original Code is Windows CE Reflect
; 
; The Initial Developer of the Original Code is John Wolfe
; Portions created by the Initial Developer are Copyright (C) 2005
; the Initial Developer. All Rights Reserved.
; 
; Contributor(s):
; 
; Alternatively, the contents of this file may be used under the terms of
; either the GNU General Public License Version 2 or later (the "GPL"), or
; the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
; in which case the provisions of the GPL or the LGPL are applicable instead
; of those above. If you wish to allow use of your version of this file only
; under the terms of either the GPL or the LGPL, and not to allow others to
; use your version of this file under the terms of the MPL, indicate your
; decision by deleting the provisions above and replace them with the notice
; and other provisions required by the GPL or the LGPL. If you do not delete
; the provisions above, a recipient may use your version of this file under
; the terms of any one of the MPL, the GPL or the LGPL.
; 
; ***** END LICENSE BLOCK *****


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; This is to call a given method of class that is passed in
;   through the function's one argument, according to APCS
;
;   APCS  = ARM Procedure Calling Standard
;
; Compile this file by running the command:
; 
;   armasm -ARCH 4 -32 xptc_arm_wince.asm xptc_arm_wince.obj
; 
; The parameter is a my_params_struct, which looks like this:
;
;;    extern "C" {
;;    struct my_params_struct {
;;        nsISupports* that;      
;;        PRUint32 Index;         
;;        PRUint32 Count;         
;;        nsXPTCVariant* params;  
;;        PRUint32 fn_count;     
;;        PRUint32 fn_copy;      
;;        };
;;        };
;
; 
; The routine will issue calls to count the number of words
; required for argument passing and to copy the arguments to
; the stack.
;
; Since APCS passes the first 3 params in r1-r3, we need to
; load the first three words from the stack and correct the stack
; pointer (sp) in the appropriate way. This means:
;
; 1.) more than 3 arguments: load r1-r3, correct sp and remember No.
;			      of bytes left on the stack in r4
;
; 2.) <= 2 args: load r1-r3 (we won't be causing a stack overflow I hope),
;		  restore sp as if nothing had happened and set the marker r4 to zero.
;
; Afterwards sp will be restored using the value in r4 (which is not a temporary register
; and will be preserved by the function/method called according to APCS [ARM Procedure
; Calling Standard]).
;
; !!! IMPORTANT !!!
; This routine makes assumptions about the vtable layout of the c++ compiler. It's implemented
; for arm-WinCE MS Visual C++ Studio  >= v7!
;
;
; int XPTC_InvokeByIndexWorker(struct my_params *my_params);
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	INCLUDE kxarm.h


	MACRO
	MY_NESTED_ARMENTRY	$Name
FuncName    SETS    VBar:CC:"$Name":CC:VBar
PrologName  SETS    VBar:CC:"$Name":CC:"_Prolog":CC:VBar
FuncEndName SETS    VBar:CC:"$Name":CC:"_end":CC:VBar

	AREA |.pdata|,ALIGN=2,PDATA
	DCD	    $FuncName
    DCD     (($PrologName-$FuncName)/4) :OR: ((($FuncEndName-$FuncName)/4):SHL:8) :OR: 0x40000000
	AREA $AreaName,CODE,READONLY
	ALIGN	2
	GLOBAL  $FuncName
	EXPORT	$FuncName
$FuncName
	ROUT
$PrologName
	MEND


	MACRO
	MY_STUB_NESTED_ARMENTRY	$Number
FuncName    SETS    VBar:CC:"?Stub$Number@nsXPTCStubBase@@UAAIXZ":CC:VBar
PrologName  SETS    VBar:CC:"?Stub$Number@nsXPTCStubBase@@UAAIXZ":CC:"_Prolog":CC:VBar
FuncEndName SETS    VBar:CC:"?Stub$Number@nsXPTCStubBase@@UAAIXZ":CC:"_end":CC:VBar
;FuncName    SETS    VBar:CC:"?asmXPTCStubBase_Stub$Number@@YAIXZ":CC:VBar ; 
;PrologName  SETS    VBar:CC:"?asmXPTCStubBase_Stub$Number@@YAIXZ":CC:"_Prolog":CC:VBar
;FuncEndName SETS    VBar:CC:"?asmXPTCStubBase_Stub$Number@@YAIXZ":CC:"_end":CC:VBar

	AREA |.pdata|,ALIGN=2,PDATA
	DCD	    $FuncName
    DCD     (($PrologName-$FuncName)/4) :OR: ((($FuncEndName-$FuncName)/4):SHL:8) :OR: 0x40000000
	AREA $AreaName,CODE,READONLY
	ALIGN	2
	GLOBAL  $FuncName
	EXPORT	$FuncName
$FuncName
	ROUT
$PrologName
	mov	ip, #$Number
	b	SharedStub
$FuncEndName
	ENDP
	MEND


	MACRO
	OLD_STUB_ENTRY	$Number
FuncName    SETS    VBar:CC:"?Stub$Number@nsXPTCStubBase@@UAAIXZ":CC:VBar
	AREA |.text|,CODE
	ALIGN	2
	GLOBAL  $FuncName
	EXPORT  $FuncName
$FuncName PROC
	mov	ip, #$Number
	b	SharedStub
	MEND








;;	INCLUDE ..\..\..\public\xptcstubsdef.inc

	MY_STUB_NESTED_ARMENTRY 3
	MY_STUB_NESTED_ARMENTRY 4
	MY_STUB_NESTED_ARMENTRY 5
	MY_STUB_NESTED_ARMENTRY 6
	MY_STUB_NESTED_ARMENTRY 7
	MY_STUB_NESTED_ARMENTRY 8
	MY_STUB_NESTED_ARMENTRY 9
	MY_STUB_NESTED_ARMENTRY 10
	MY_STUB_NESTED_ARMENTRY 11
	MY_STUB_NESTED_ARMENTRY 12
	MY_STUB_NESTED_ARMENTRY 13
	MY_STUB_NESTED_ARMENTRY 14
	MY_STUB_NESTED_ARMENTRY 15
	MY_STUB_NESTED_ARMENTRY 16
	MY_STUB_NESTED_ARMENTRY 17
	MY_STUB_NESTED_ARMENTRY 18
	MY_STUB_NESTED_ARMENTRY 19
	MY_STUB_NESTED_ARMENTRY 20
	MY_STUB_NESTED_ARMENTRY 21
	MY_STUB_NESTED_ARMENTRY 22
	MY_STUB_NESTED_ARMENTRY 23
	MY_STUB_NESTED_ARMENTRY 24
	MY_STUB_NESTED_ARMENTRY 25
	MY_STUB_NESTED_ARMENTRY 26
	MY_STUB_NESTED_ARMENTRY 27
	MY_STUB_NESTED_ARMENTRY 28
	MY_STUB_NESTED_ARMENTRY 29
	MY_STUB_NESTED_ARMENTRY 30
	MY_STUB_NESTED_ARMENTRY 31
	MY_STUB_NESTED_ARMENTRY 32
	MY_STUB_NESTED_ARMENTRY 33
	MY_STUB_NESTED_ARMENTRY 34
	MY_STUB_NESTED_ARMENTRY 35
	MY_STUB_NESTED_ARMENTRY 36
	MY_STUB_NESTED_ARMENTRY 37
	MY_STUB_NESTED_ARMENTRY 38
	MY_STUB_NESTED_ARMENTRY 39
	MY_STUB_NESTED_ARMENTRY 40
	MY_STUB_NESTED_ARMENTRY 41
	MY_STUB_NESTED_ARMENTRY 42
	MY_STUB_NESTED_ARMENTRY 43
	MY_STUB_NESTED_ARMENTRY 44
	MY_STUB_NESTED_ARMENTRY 45
	MY_STUB_NESTED_ARMENTRY 46
	MY_STUB_NESTED_ARMENTRY 47
	MY_STUB_NESTED_ARMENTRY 48
	MY_STUB_NESTED_ARMENTRY 49
	MY_STUB_NESTED_ARMENTRY 50
	MY_STUB_NESTED_ARMENTRY 51
	MY_STUB_NESTED_ARMENTRY 52
	MY_STUB_NESTED_ARMENTRY 53
	MY_STUB_NESTED_ARMENTRY 54
	MY_STUB_NESTED_ARMENTRY 55
	MY_STUB_NESTED_ARMENTRY 56
	MY_STUB_NESTED_ARMENTRY 57
	MY_STUB_NESTED_ARMENTRY 58
	MY_STUB_NESTED_ARMENTRY 59
	MY_STUB_NESTED_ARMENTRY 60
	MY_STUB_NESTED_ARMENTRY 61
	MY_STUB_NESTED_ARMENTRY 62
	MY_STUB_NESTED_ARMENTRY 63
	MY_STUB_NESTED_ARMENTRY 64
	MY_STUB_NESTED_ARMENTRY 65
	MY_STUB_NESTED_ARMENTRY 66
	MY_STUB_NESTED_ARMENTRY 67
	MY_STUB_NESTED_ARMENTRY 68
	MY_STUB_NESTED_ARMENTRY 69
	MY_STUB_NESTED_ARMENTRY 70
	MY_STUB_NESTED_ARMENTRY 71
	MY_STUB_NESTED_ARMENTRY 72
	MY_STUB_NESTED_ARMENTRY 73
	MY_STUB_NESTED_ARMENTRY 74
	MY_STUB_NESTED_ARMENTRY 75
	MY_STUB_NESTED_ARMENTRY 76
	MY_STUB_NESTED_ARMENTRY 77
	MY_STUB_NESTED_ARMENTRY 78
	MY_STUB_NESTED_ARMENTRY 79
	MY_STUB_NESTED_ARMENTRY 80
	MY_STUB_NESTED_ARMENTRY 81
	MY_STUB_NESTED_ARMENTRY 82
	MY_STUB_NESTED_ARMENTRY 83
	MY_STUB_NESTED_ARMENTRY 84
	MY_STUB_NESTED_ARMENTRY 85
	MY_STUB_NESTED_ARMENTRY 86
	MY_STUB_NESTED_ARMENTRY 87
	MY_STUB_NESTED_ARMENTRY 88
	MY_STUB_NESTED_ARMENTRY 89
	MY_STUB_NESTED_ARMENTRY 90
	MY_STUB_NESTED_ARMENTRY 91
	MY_STUB_NESTED_ARMENTRY 92
	MY_STUB_NESTED_ARMENTRY 93
	MY_STUB_NESTED_ARMENTRY 94
	MY_STUB_NESTED_ARMENTRY 95
	MY_STUB_NESTED_ARMENTRY 96
	MY_STUB_NESTED_ARMENTRY 97
	MY_STUB_NESTED_ARMENTRY 98
	MY_STUB_NESTED_ARMENTRY 99
	MY_STUB_NESTED_ARMENTRY 100
	MY_STUB_NESTED_ARMENTRY 101
	MY_STUB_NESTED_ARMENTRY 102
	MY_STUB_NESTED_ARMENTRY 103
	MY_STUB_NESTED_ARMENTRY 104
	MY_STUB_NESTED_ARMENTRY 105
	MY_STUB_NESTED_ARMENTRY 106
	MY_STUB_NESTED_ARMENTRY 107
	MY_STUB_NESTED_ARMENTRY 108
	MY_STUB_NESTED_ARMENTRY 109
	MY_STUB_NESTED_ARMENTRY 110
	MY_STUB_NESTED_ARMENTRY 111
	MY_STUB_NESTED_ARMENTRY 112
	MY_STUB_NESTED_ARMENTRY 113
	MY_STUB_NESTED_ARMENTRY 114
	MY_STUB_NESTED_ARMENTRY 115
	MY_STUB_NESTED_ARMENTRY 116
	MY_STUB_NESTED_ARMENTRY 117
	MY_STUB_NESTED_ARMENTRY 118
	MY_STUB_NESTED_ARMENTRY 119
	MY_STUB_NESTED_ARMENTRY 120
	MY_STUB_NESTED_ARMENTRY 121
	MY_STUB_NESTED_ARMENTRY 122
	MY_STUB_NESTED_ARMENTRY 123
	MY_STUB_NESTED_ARMENTRY 124
	MY_STUB_NESTED_ARMENTRY 125
	MY_STUB_NESTED_ARMENTRY 126
	MY_STUB_NESTED_ARMENTRY 127
	MY_STUB_NESTED_ARMENTRY 128
	MY_STUB_NESTED_ARMENTRY 129
	MY_STUB_NESTED_ARMENTRY 130
	MY_STUB_NESTED_ARMENTRY 131
	MY_STUB_NESTED_ARMENTRY 132
	MY_STUB_NESTED_ARMENTRY 133
	MY_STUB_NESTED_ARMENTRY 134
	MY_STUB_NESTED_ARMENTRY 135
	MY_STUB_NESTED_ARMENTRY 136
	MY_STUB_NESTED_ARMENTRY 137
	MY_STUB_NESTED_ARMENTRY 138
	MY_STUB_NESTED_ARMENTRY 139
	MY_STUB_NESTED_ARMENTRY 140
	MY_STUB_NESTED_ARMENTRY 141
	MY_STUB_NESTED_ARMENTRY 142
	MY_STUB_NESTED_ARMENTRY 143
	MY_STUB_NESTED_ARMENTRY 144
	MY_STUB_NESTED_ARMENTRY 145
	MY_STUB_NESTED_ARMENTRY 146
	MY_STUB_NESTED_ARMENTRY 147
	MY_STUB_NESTED_ARMENTRY 148
	MY_STUB_NESTED_ARMENTRY 149
	MY_STUB_NESTED_ARMENTRY 150
	MY_STUB_NESTED_ARMENTRY 151
	MY_STUB_NESTED_ARMENTRY 152
	MY_STUB_NESTED_ARMENTRY 153
	MY_STUB_NESTED_ARMENTRY 154
	MY_STUB_NESTED_ARMENTRY 155
	MY_STUB_NESTED_ARMENTRY 156
	MY_STUB_NESTED_ARMENTRY 157
	MY_STUB_NESTED_ARMENTRY 158
	MY_STUB_NESTED_ARMENTRY 159
	MY_STUB_NESTED_ARMENTRY 160
	MY_STUB_NESTED_ARMENTRY 161
	MY_STUB_NESTED_ARMENTRY 162
	MY_STUB_NESTED_ARMENTRY 163
	MY_STUB_NESTED_ARMENTRY 164
	MY_STUB_NESTED_ARMENTRY 165
	MY_STUB_NESTED_ARMENTRY 166
	MY_STUB_NESTED_ARMENTRY 167
	MY_STUB_NESTED_ARMENTRY 168
	MY_STUB_NESTED_ARMENTRY 169
	MY_STUB_NESTED_ARMENTRY 170
	MY_STUB_NESTED_ARMENTRY 171
	MY_STUB_NESTED_ARMENTRY 172
	MY_STUB_NESTED_ARMENTRY 173
	MY_STUB_NESTED_ARMENTRY 174
	MY_STUB_NESTED_ARMENTRY 175
	MY_STUB_NESTED_ARMENTRY 176
	MY_STUB_NESTED_ARMENTRY 177
	MY_STUB_NESTED_ARMENTRY 178
	MY_STUB_NESTED_ARMENTRY 179
	MY_STUB_NESTED_ARMENTRY 180
	MY_STUB_NESTED_ARMENTRY 181
	MY_STUB_NESTED_ARMENTRY 182
	MY_STUB_NESTED_ARMENTRY 183
	MY_STUB_NESTED_ARMENTRY 184
	MY_STUB_NESTED_ARMENTRY 185
	MY_STUB_NESTED_ARMENTRY 186
	MY_STUB_NESTED_ARMENTRY 187
	MY_STUB_NESTED_ARMENTRY 188
	MY_STUB_NESTED_ARMENTRY 189
	MY_STUB_NESTED_ARMENTRY 190
	MY_STUB_NESTED_ARMENTRY 191
	MY_STUB_NESTED_ARMENTRY 192
	MY_STUB_NESTED_ARMENTRY 193
	MY_STUB_NESTED_ARMENTRY 194
	MY_STUB_NESTED_ARMENTRY 195
	MY_STUB_NESTED_ARMENTRY 196
	MY_STUB_NESTED_ARMENTRY 197
	MY_STUB_NESTED_ARMENTRY 198
	MY_STUB_NESTED_ARMENTRY 199
	MY_STUB_NESTED_ARMENTRY 200
	MY_STUB_NESTED_ARMENTRY 201
	MY_STUB_NESTED_ARMENTRY 202
	MY_STUB_NESTED_ARMENTRY 203
	MY_STUB_NESTED_ARMENTRY 204
	MY_STUB_NESTED_ARMENTRY 205
	MY_STUB_NESTED_ARMENTRY 206
	MY_STUB_NESTED_ARMENTRY 207
	MY_STUB_NESTED_ARMENTRY 208
	MY_STUB_NESTED_ARMENTRY 209
	MY_STUB_NESTED_ARMENTRY 210
	MY_STUB_NESTED_ARMENTRY 211
	MY_STUB_NESTED_ARMENTRY 212
	MY_STUB_NESTED_ARMENTRY 213
	MY_STUB_NESTED_ARMENTRY 214
	MY_STUB_NESTED_ARMENTRY 215
	MY_STUB_NESTED_ARMENTRY 216
	MY_STUB_NESTED_ARMENTRY 217
	MY_STUB_NESTED_ARMENTRY 218
	MY_STUB_NESTED_ARMENTRY 219
	MY_STUB_NESTED_ARMENTRY 220
	MY_STUB_NESTED_ARMENTRY 221
	MY_STUB_NESTED_ARMENTRY 222
	MY_STUB_NESTED_ARMENTRY 223
	MY_STUB_NESTED_ARMENTRY 224
	MY_STUB_NESTED_ARMENTRY 225
	MY_STUB_NESTED_ARMENTRY 226
	MY_STUB_NESTED_ARMENTRY 227
	MY_STUB_NESTED_ARMENTRY 228
	MY_STUB_NESTED_ARMENTRY 229
	MY_STUB_NESTED_ARMENTRY 230
	MY_STUB_NESTED_ARMENTRY 231
	MY_STUB_NESTED_ARMENTRY 232
	MY_STUB_NESTED_ARMENTRY 233
	MY_STUB_NESTED_ARMENTRY 234
	MY_STUB_NESTED_ARMENTRY 235
	MY_STUB_NESTED_ARMENTRY 236
	MY_STUB_NESTED_ARMENTRY 237
	MY_STUB_NESTED_ARMENTRY 238
	MY_STUB_NESTED_ARMENTRY 239
	MY_STUB_NESTED_ARMENTRY 240
	MY_STUB_NESTED_ARMENTRY 241
	MY_STUB_NESTED_ARMENTRY 242
	MY_STUB_NESTED_ARMENTRY 243
	MY_STUB_NESTED_ARMENTRY 244
	MY_STUB_NESTED_ARMENTRY 245
	MY_STUB_NESTED_ARMENTRY 246
	MY_STUB_NESTED_ARMENTRY 247
	MY_STUB_NESTED_ARMENTRY 248
	MY_STUB_NESTED_ARMENTRY 249

	IMPORT PrepareAndDispatch
	
SharedStub
	stmfd	sp!, {r1, r2, r3}
	mov	r2, sp
	str	lr, [sp, #-4]!
	mov	r1, ip
	bl	PrepareAndDispatch
	ldr	pc, [sp], #16
	ENDP


	END

