/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.BuildListener;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.FileDeletedEvent;
import org.jetbrains.jps.incremental.messages.FileGeneratedEvent;
import org.jetbrains.jps.maven.MavenJpsBundle;
import org.jetbrains.jps.maven.compiler.MavenPatternFileFilter;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenFilteredJarConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;

public class MavenFilteredJarModuleBuilder
extends ModuleLevelBuilder {
    private static final Key<MavenProjectConfiguration> CACHE_JAR_CONFIG = Key.create((String)"MavenFilteredJarModuleBuilder.MavenProjectConfiguration.cache");
    private final ConcurrentMap<String, BuildListener> listenerMap = new ConcurrentHashMap<String, BuildListener>();

    protected MavenFilteredJarModuleBuilder() {
        super(BuilderCategory.CLASS_INSTRUMENTER);
    }

    public void chunkBuildStarted(final CompileContext context, final ModuleChunk chunk) {
        final List<MavenFilteredJarConfiguration> jarsConfig = MavenFilteredJarModuleBuilder.getJarsConfig(context, chunk);
        if (jarsConfig.isEmpty()) {
            return;
        }
        BuildListener listener = new BuildListener(){

            public void filesGenerated(@NotNull FileGeneratedEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                event.getPaths().forEach(pair -> {
                    List configs = ContainerUtil.filter((Collection)jarsConfig, c -> c.originalOutput.equals(pair.first));
                    configs.forEach(config -> MavenFilteredJarModuleBuilder.copyCreatedFileIfNeeded((Pair<String, String>)pair, config, context));
                });
            }

            public void filesDeleted(@NotNull FileDeletedEvent event) {
                List<MavenFilteredJarConfiguration> jarsConfig2;
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((jarsConfig2 = MavenFilteredJarModuleBuilder.getJarsConfig(context, chunk)).isEmpty()) {
                    return;
                }
                event.getFilePaths().forEach(deletedFilePath -> {
                    List configs = ContainerUtil.filter((Collection)jarsConfig2, c -> FileUtil.isAncestor((String)c.originalOutput, (String)deletedFilePath, (boolean)true));
                    configs.forEach(config -> MavenFilteredJarModuleBuilder.deleteFile(config, deletedFilePath));
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/jps/maven/compiler/MavenFilteredJarModuleBuilder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "filesGenerated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "filesDeleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.listenerMap.put(MavenFilteredJarModuleBuilder.nameFor(chunk), listener);
        context.addBuildListener(listener);
    }

    private static String nameFor(ModuleChunk chunk) {
        return chunk.getTargets().stream().map(t -> t.getPresentableName()).collect(Collectors.joining());
    }

    private static void deleteFile(MavenFilteredJarConfiguration config, String path) {
        String relative = FileUtil.getRelativePath((File)new File(config.originalOutput), (File)new File(path));
        if (relative == null) {
            return;
        }
        FileUtil.delete((File)new File(new File(config.jarOutput), relative));
    }

    private static void copyCreatedFileIfNeeded(Pair<String, String> pair, MavenFilteredJarConfiguration config, CompileContext context) {
        File from = new File(new File((String)pair.first), (String)pair.second);
        File to = new File(new File(config.jarOutput), (String)pair.second);
        MavenPatternFileFilter filter = new MavenPatternFileFilter(config.includes, config.excludes);
        if (filter.accept((String)pair.second)) {
            try {
                FSOperations.copy((File)from, (File)to);
            }
            catch (IOException e) {
                context.processMessage((BuildMessage)new CompilerMessage(MavenJpsBundle.message("maven.filter.jar.compiler", new Object[0]), BuildMessage.Kind.ERROR, e.getMessage()));
            }
        }
    }

    @NotNull
    private static List<MavenFilteredJarConfiguration> getJarsConfig(CompileContext context, ModuleChunk chunk) {
        List<MavenFilteredJarConfiguration> list = chunk.getTargets().stream().flatMap(target -> MavenFilteredJarModuleBuilder.getJarConfigurations(context, target).stream()).collect(Collectors.toList());
        if (list == null) {
            MavenFilteredJarModuleBuilder.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void chunkBuildFinished(CompileContext context, ModuleChunk chunk) {
        BuildListener buildListener = (BuildListener)this.listenerMap.remove(MavenFilteredJarModuleBuilder.nameFor(chunk));
        if (buildListener != null) {
            context.removeBuildListener(buildListener);
        }
    }

    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        return ModuleLevelBuilder.ExitCode.OK;
    }

    @NotNull
    private static List<MavenFilteredJarConfiguration> getJarConfigurations(CompileContext context, ModuleBuildTarget target) {
        MavenProjectConfiguration projectConfig = MavenFilteredJarModuleBuilder.getOrLoadConfiguration(context);
        if (projectConfig == null) {
            List<MavenFilteredJarConfiguration> list = Collections.emptyList();
            if (list == null) {
                MavenFilteredJarModuleBuilder.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = ContainerUtil.filter(projectConfig.jarsConfiguration.values(), it -> it.moduleName.equals(target.getModule().getName()) && it.isTest == target.isTests());
        if (list == null) {
            MavenFilteredJarModuleBuilder.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    private static MavenProjectConfiguration getOrLoadConfiguration(CompileContext context) {
        MavenProjectConfiguration projectConfig = (MavenProjectConfiguration)context.getUserData(CACHE_JAR_CONFIG);
        if (projectConfig != null) {
            return projectConfig;
        }
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        projectConfig = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(dataPaths);
        context.putUserData(CACHE_JAR_CONFIG, (Object)projectConfig);
        return projectConfig;
    }

    @NotNull
    public List<String> getCompilableFileExtensions() {
        List<String> list = List.of();
        if (list == null) {
            MavenFilteredJarModuleBuilder.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getPresentableName() {
        String string = MavenJpsBundle.message("maven.filter.jar.compiler", new Object[0]);
        if (string == null) {
            MavenFilteredJarModuleBuilder.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/maven/compiler/MavenFilteredJarModuleBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarsConfig";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarConfigurations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilableFileExtensions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

