/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.tools.Tools;

public class EnglishUnpairedBracketsRule
extends GenericUnpairedBracketsRule {
    private static final List<String> EN_START_SYMBOLS = Arrays.asList("[", "(", "{");
    private static final List<String> EN_END_SYMBOLS = Arrays.asList("]", ")", "}");

    public EnglishUnpairedBracketsRule(ResourceBundle messages, Language language) {
        super(messages, EN_START_SYMBOLS, EN_END_SYMBOLS);
        this.setUrl(Tools.getUrl("https://languagetool.org/insights/post/punctuation-guide/#what-are-parentheses"));
        this.addExamplePair(Example.wrong("He lived in a <marker>(</marker>large house."), Example.fixed("He lived in a <marker>(</marker>large) house."));
    }

    @Override
    public String getId() {
        return "EN_UNPAIRED_BRACKETS";
    }
}

