/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.impl.FrameworkDetectionUtil;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;

@Deprecated
public abstract class FacetImporter<FACET_TYPE extends Facet, FACET_CONFIG_TYPE extends FacetConfiguration, FACET_TYPE_TYPE extends FacetType<FACET_TYPE, FACET_CONFIG_TYPE>>
extends MavenImporter {
    protected final FACET_TYPE_TYPE myFacetType;
    protected final String myDefaultFacetName;

    protected FacetImporter(@NonNls String pluginGroupID, @NonNls String pluginArtifactID, FACET_TYPE_TYPE type) {
        this(pluginGroupID, pluginArtifactID, type, type.getDefaultFacetName());
    }

    public FacetImporter(@NonNls String pluginGroupID, @NonNls String pluginArtifactID, FACET_TYPE_TYPE type, @NonNls String defaultFacetName) {
        super(pluginGroupID, pluginArtifactID);
        this.myFacetType = type;
        this.myDefaultFacetName = defaultFacetName;
    }

    public FACET_TYPE_TYPE getFacetType() {
        return this.myFacetType;
    }

    public String getDefaultFacetName() {
        return this.myDefaultFacetName;
    }

    @Override
    public void preProcess(Module module, MavenProject mavenProject, MavenProjectChanges changes, IdeModifiableModelsProvider modifiableModelsProvider) {
        if (!this.isFacetDetectionDisabled(module.getProject())) {
            this.disableFacetAutodetection(module, modifiableModelsProvider);
            this.ensureFacetExists(module, mavenProject, modifiableModelsProvider);
        }
    }

    private void ensureFacetExists(Module module, MavenProject mavenProject, IdeModifiableModelsProvider modifiableModelsProvider) {
        ModifiableFacetModel model = modifiableModelsProvider.getModifiableFacetModel(module);
        Object f = this.findFacet((FacetModel)model);
        if (f != null) {
            return;
        }
        f = this.myFacetType.createFacet(module, this.myDefaultFacetName, this.myFacetType.createDefaultConfiguration(), null);
        model.addFacet(f, MavenRootModelAdapter.getMavenExternalSource());
        this.setupFacet(f, mavenProject);
    }

    protected boolean isDisableFacetAutodetection(Module module) {
        return true;
    }

    private void disableFacetAutodetection(Module module, IdeModifiableModelsProvider provider) {
        if (!this.isDisableFacetAutodetection(module)) {
            return;
        }
        DetectionExcludesConfiguration excludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)module.getProject());
        FrameworkType frameworkType = FrameworkDetectionUtil.findFrameworkTypeForFacetDetector(this.myFacetType);
        if (frameworkType != null) {
            for (VirtualFile file : provider.getContentRoots(module)) {
                excludesConfiguration.addExcludedFile(file, frameworkType);
            }
        }
    }

    protected void setupFacet(FACET_TYPE f, MavenProject mavenProject) {
    }

    @Override
    public void process(@NotNull IdeModifiableModelsProvider modifiableModelsProvider, @NotNull Module module, @NotNull MavenRootModelAdapter rootModel, @NotNull MavenProjectsTree mavenModel, @NotNull MavenProject mavenProject, @NotNull MavenProjectChanges changes, @NotNull Map<MavenProject, String> mavenProjectToModuleName, @NotNull List<MavenProjectsProcessorTask> postTasks) {
        FACET_TYPE f;
        if (modifiableModelsProvider == null) {
            FacetImporter.$$$reportNull$$$0(0);
        }
        if (module == null) {
            FacetImporter.$$$reportNull$$$0(1);
        }
        if (rootModel == null) {
            FacetImporter.$$$reportNull$$$0(2);
        }
        if (mavenModel == null) {
            FacetImporter.$$$reportNull$$$0(3);
        }
        if (mavenProject == null) {
            FacetImporter.$$$reportNull$$$0(4);
        }
        if (changes == null) {
            FacetImporter.$$$reportNull$$$0(5);
        }
        if (mavenProjectToModuleName == null) {
            FacetImporter.$$$reportNull$$$0(6);
        }
        if (postTasks == null) {
            FacetImporter.$$$reportNull$$$0(7);
        }
        if ((f = this.findFacet((FacetModel)modifiableModelsProvider.getModifiableFacetModel(module))) == null) {
            return;
        }
        if (!this.isFacetDetectionDisabled(module.getProject())) {
            this.reimportFacet(modifiableModelsProvider, module, rootModel, f, mavenModel, mavenProject, changes, mavenProjectToModuleName, postTasks);
        }
    }

    private FACET_TYPE findFacet(FacetModel model) {
        return (FACET_TYPE)this.findFacet(model, (FacetType)this.myFacetType, this.myDefaultFacetName);
    }

    protected <T extends Facet> T findFacet(FacetModel model, FacetType<T, ?> type, @NonNls String defaultFacetName) {
        Facet result2 = model.findFacet(type.getId(), defaultFacetName);
        if (result2 == null) {
            result2 = model.getFacetByType(type.getId());
        }
        return (T)result2;
    }

    protected abstract void reimportFacet(@NotNull IdeModifiableModelsProvider var1, @NotNull Module var2, @NotNull MavenRootModelAdapter var3, @NotNull FACET_TYPE var4, @NotNull MavenProjectsTree var5, @NotNull MavenProject var6, @NotNull MavenProjectChanges var7, @NotNull Map<MavenProject, String> var8, @NotNull List<MavenProjectsProcessorTask> var9);

    protected String getTargetName(MavenProject p) {
        return p.getFinalName();
    }

    protected String getTargetFileName(MavenProject p) {
        return this.getTargetFileName(p, "." + this.getTargetExtension(p));
    }

    protected String getTargetFileName(MavenProject p, @NonNls String suffix) {
        return this.getTargetName(p) + suffix;
    }

    protected String getTargetFilePath(MavenProject p, @NonNls String suffix) {
        return this.makePath(p, p.getBuildDirectory(), this.getTargetName(p) + suffix);
    }

    protected String makePath(MavenProject p, String ... elements) {
        StringBuilder tailBuff = new StringBuilder();
        for (String e : elements) {
            if (tailBuff.length() > 0) {
                tailBuff.append("/");
            }
            tailBuff.append(e);
        }
        String tail = tailBuff.toString();
        String result2 = FileUtil.isAbsolute((String)tail) ? tail : new File(p.getDirectory(), tail).getPath();
        return FileUtil.toSystemIndependentName((String)FileUtil.toCanonicalPath((String)result2));
    }

    protected String getTargetExtension(MavenProject p) {
        return p.getPackaging();
    }

    public boolean isFacetDetectionDisabled(Project project) {
        DetectionExcludesConfiguration excludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)project);
        FrameworkType frameworkType = FrameworkDetectionUtil.findFrameworkTypeForFacetDetector(this.myFacetType);
        if (frameworkType == null) {
            return false;
        }
        return excludesConfiguration.isExcludedFromDetection(frameworkType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "modifiableModelsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "rootModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "mavenModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "mavenProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "changes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "mavenProjectToModuleName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "postTasks";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/importing/FacetImporter";
        objectArray[2] = "process";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

