/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigator;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public final class SelectInMavenNavigatorTarget
implements SelectInTarget,
DumbAware {
    public boolean canSelect(SelectInContext context2) {
        return SelectInMavenNavigatorTarget.getMavenProject(context2) != null;
    }

    public void selectIn(SelectInContext context2, boolean requestFocus) {
        Runnable r = () -> MavenProjectsNavigator.getInstance(context2.getProject()).selectInTree(SelectInMavenNavigatorTarget.getMavenProject(context2));
        if (requestFocus) {
            ToolWindow window = ToolWindowManager.getInstance((Project)context2.getProject()).getToolWindow(this.getToolWindowId());
            if (window != null) {
                window.activate(r);
            }
        } else {
            r.run();
        }
    }

    private static MavenProject getMavenProject(SelectInContext context2) {
        VirtualFile file = context2.getVirtualFile();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(context2.getProject());
        Module module = ProjectRootManager.getInstance((Project)context2.getProject()).getFileIndex().getModuleForFile(file);
        return module == null ? null : manager.findProject(module);
    }

    public String getToolWindowId() {
        return "Maven";
    }

    public String toString() {
        return MavenProjectBundle.message("maven.name", new Object[0]);
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 20.0f;
    }
}

