/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.api;

import com.intellij.collaboration.util.URIUtilKt;
import com.intellij.openapi.util.NlsSafe;
import git4idea.remote.GitRemoteUrlCoordinates;
import git4idea.remote.hosting.HostedRepositoryCoordinates;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabProjectCoordinates$;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath$;
import org.jetbrains.plugins.gitlab.util.GitLabProjectPath;
import org.jetbrains.plugins.gitlab.util.GitLabProjectPath$;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 %2\u00020\u0001:\u0002%&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B/\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0017J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00d6\u0001J%\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0001\u00a2\u0006\u0002\b$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "Lgit4idea/remote/hosting/HostedRepositoryCoordinates;", "serverPath", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "projectPath", "Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;", "<init>", "(Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILorg/jetbrains/plugins/gitlab/api/GitLabServerPath;Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getServerPath", "()Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "getProjectPath", "()Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;", "getWebURI", "Ljava/net/URI;", "toString", "", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_vcs_gitlab", "Companion", "$serializer", "intellij.vcs.gitlab"})
public final class GitLabProjectCoordinates
implements HostedRepositoryCoordinates {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitLabServerPath serverPath;
    @NotNull
    private final GitLabProjectPath projectPath;

    public GitLabProjectCoordinates(@NotNull GitLabServerPath serverPath, @NotNull GitLabProjectPath projectPath) {
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        this.serverPath = serverPath;
        this.projectPath = projectPath;
    }

    @NotNull
    public GitLabServerPath getServerPath() {
        return this.serverPath;
    }

    @NotNull
    public final GitLabProjectPath getProjectPath() {
        return this.projectPath;
    }

    @NotNull
    public URI getWebURI() {
        return URIUtilKt.resolveRelative((URI)this.getServerPath().toURI(), (String)GitLabProjectPath.fullPath$default(this.projectPath, false, 1, null));
    }

    @NlsSafe
    @NotNull
    public String toString() {
        return this.getServerPath() + "/" + this.projectPath;
    }

    @NotNull
    public final GitLabServerPath component1() {
        return this.serverPath;
    }

    @NotNull
    public final GitLabProjectPath component2() {
        return this.projectPath;
    }

    @NotNull
    public final GitLabProjectCoordinates copy(@NotNull GitLabServerPath serverPath, @NotNull GitLabProjectPath projectPath) {
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return new GitLabProjectCoordinates(serverPath, projectPath);
    }

    public static /* synthetic */ GitLabProjectCoordinates copy$default(GitLabProjectCoordinates gitLabProjectCoordinates, GitLabServerPath gitLabServerPath, GitLabProjectPath gitLabProjectPath, int n, Object object) {
        if ((n & 1) != 0) {
            gitLabServerPath = gitLabProjectCoordinates.serverPath;
        }
        if ((n & 2) != 0) {
            gitLabProjectPath = gitLabProjectCoordinates.projectPath;
        }
        return gitLabProjectCoordinates.copy(gitLabServerPath, gitLabProjectPath);
    }

    public int hashCode() {
        int result2 = this.serverPath.hashCode();
        result2 = result2 * 31 + this.projectPath.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitLabProjectCoordinates)) {
            return false;
        }
        GitLabProjectCoordinates gitLabProjectCoordinates = (GitLabProjectCoordinates)other;
        if (!Intrinsics.areEqual((Object)this.serverPath, (Object)gitLabProjectCoordinates.serverPath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.projectPath, (Object)gitLabProjectCoordinates.projectPath);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$intellij_vcs_gitlab(GitLabProjectCoordinates self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)GitLabServerPath$.serializer.INSTANCE, (Object)self.getServerPath());
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)GitLabProjectPath$.serializer.INSTANCE, (Object)self.projectPath);
    }

    public /* synthetic */ GitLabProjectCoordinates(int seen0, GitLabServerPath serverPath, GitLabProjectPath projectPath, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.serverPath = serverPath;
        this.projectPath = projectPath;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "server", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "remote", "Lgit4idea/remote/GitRemoteUrlCoordinates;", "serializer", "Lkotlinx/serialization/KSerializer;", "intellij.vcs.gitlab"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final GitLabProjectCoordinates create(@NotNull GitLabServerPath server, @NotNull GitRemoteUrlCoordinates remote) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            GitLabProjectPath gitLabProjectPath = GitLabProjectPath.Companion.create(server, remote);
            if (gitLabProjectPath == null) {
                return null;
            }
            GitLabProjectPath projectPath = gitLabProjectPath;
            return new GitLabProjectCoordinates(server, projectPath);
        }

        @NotNull
        public final KSerializer<GitLabProjectCoordinates> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

