/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchScriptException;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptLog;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.jetbrains.annotations.NotNull;

public class ScriptSupport {
    private static final Logger LOG = Logger.getInstance(ScriptSupport.class);
    @NlsSafe
    public static final String UUID = "a3cd264774bf4efb9ab609b250c5165c";
    private final Script myScript;
    private final ScriptLog myScriptLog;
    private final String myName;
    private final Collection<String> myVariableNames;

    public ScriptSupport(Project project2, Script script, String name, Collection<String> variableNames) {
        this.myScriptLog = new ScriptLog(project2);
        this.myName = name;
        this.myVariableNames = variableNames;
        this.myScript = script;
    }

    private static Map<String, Object> buildVariableMap(@NotNull MatchResult result2, @NotNull Map<String, Object> out) {
        String name;
        if (result2 == null) {
            ScriptSupport.$$$reportNull$$$0(0);
        }
        if (out == null) {
            ScriptSupport.$$$reportNull$$$0(1);
        }
        if ((name = result2.getName()) != null && !result2.isMultipleMatch()) {
            Object value = out.get(name);
            PsiElement match2 = StructuralSearchUtil.getPresentableElement(result2.getMatch());
            if (value == null) {
                out.put(name, match2);
            } else if (value instanceof List) {
                list = (ArrayList<PsiElement>)value;
                list.add(match2);
            } else if (value instanceof PsiElement) {
                list = new ArrayList<PsiElement>();
                list.add((PsiElement)value);
                list.add(match2);
                out.put(name, list);
            } else {
                throw new AssertionError();
            }
        }
        for (MatchResult son : result2.getChildren()) {
            ScriptSupport.buildVariableMap(son, out);
        }
        return out;
    }

    public Object evaluate(MatchResult result2, PsiElement context) {
        try {
            HashMap<String, Object> variableMap = new HashMap<String, Object>();
            this.myVariableNames.forEach(n -> variableMap.put((String)n, null));
            variableMap.put("__log__", this.myScriptLog);
            if (result2 != null) {
                ScriptSupport.buildVariableMap(result2.getRoot(), variableMap);
                if (context == null) {
                    context = result2.getMatch();
                }
            }
            context = StructuralSearchUtil.getPresentableElement(context);
            variableMap.put(this.myName, context);
            variableMap.put("__context__", context);
            this.myScript.setBinding(new Binding(variableMap));
            Object object = this.myScript.run();
            return object;
        }
        catch (ProcessCanceledException | ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            Logger.getInstance(ScriptSupport.class).info("Exception thrown by Structural Search Groovy Script", t);
            throw new StructuralSearchScriptException(t);
        }
        finally {
            this.myScript.setBinding(null);
        }
    }

    public static Script buildScript(@NotNull String scriptName, @NotNull String scriptText, @NotNull MatchOptions matchOptions) throws MalformedPatternException {
        if (scriptName == null) {
            ScriptSupport.$$$reportNull$$$0(2);
        }
        if (scriptText == null) {
            ScriptSupport.$$$reportNull$$$0(3);
        }
        if (matchOptions == null) {
            ScriptSupport.$$$reportNull$$$0(4);
        }
        try {
            GroovyShell shell = new GroovyShell(Objects.requireNonNull(matchOptions.getDialect()).getClass().getClassLoader());
            return shell.parse(scriptText, scriptName + "a3cd264774bf4efb9ab609b250c5165c.groovy");
        }
        catch (MultipleCompilationErrorsException e) {
            ErrorCollector errorCollector = e.getErrorCollector();
            List errors = errorCollector.getErrors();
            for (Message error : errors) {
                if (!(error instanceof SyntaxErrorMessage)) continue;
                SyntaxErrorMessage syntaxError = (SyntaxErrorMessage)error;
                SyntaxException cause = syntaxError.getCause();
                throw new MalformedPatternException(cause.getLocalizedMessage());
            }
            throw new MalformedPatternException(e.getLocalizedMessage());
        }
        catch (CompilationFailedException ex) {
            throw new MalformedPatternException(ex.getLocalizedMessage());
        }
        catch (Throwable e) {
            LOG.warn(e);
            throw new MalformedPatternException(SSRBundle.message("error.in.groovy.parser", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchOptions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/predicates/ScriptSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVariableMap";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "buildScript";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

