/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.modelAction;

import com.intellij.gradle.toolingExtension.impl.modelAction.GradleModelHolderState;
import com.intellij.gradle.toolingExtension.impl.modelAction.GradleModelId;
import com.intellij.gradle.toolingExtension.impl.modelSerialization.ToolingSerializer;
import com.intellij.gradle.toolingExtension.impl.telemetry.TelemetryHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PathMapper;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultGradleLightBuild;
import org.jetbrains.plugins.gradle.model.GradleLightBuild;
import org.jetbrains.plugins.gradle.util.GradleObjectTraverser;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 B2\u00020\u0001:\u0001BB\u001f\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\u0019\u001a\u00020\tJ\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u001bJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001bJ\u0012\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 J!\u0010!\u001a\u0004\u0018\u0001H\"\"\u0004\b\u0000\u0010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0 \u00a2\u0006\u0002\u0010$J)\u0010%\u001a\u0004\u0018\u0001H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010&\u001a\u00020'2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\"0 \u00a2\u0006\u0002\u0010(J)\u0010)\u001a\u0004\u0018\u0001H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010*\u001a\u00020+2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\"0 \u00a2\u0006\u0002\u0010,J+\u0010!\u001a\u0004\u0018\u0001H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010-\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\"0 H\u0002\u00a2\u0006\u0002\u0010.J\u0014\u0010/\u001a\u0002002\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0002J7\u00101\u001a\u0004\u0018\u0001H\"\"\b\b\u0000\u0010\"*\u00020\u00012\u0006\u00102\u001a\u00020\u00012\u0006\u0010-\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\"0 H\u0002\u00a2\u0006\u0002\u00103J3\u00104\u001a\u000200\"\b\b\u0000\u0010\"*\u00020\u00012\u0006\u00105\u001a\u00020+2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\"0 2\u0006\u00102\u001a\u0002H\"\u00a2\u0006\u0002\u00106J\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00130\u001bJ\u000e\u00108\u001a\u0002002\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u0002002\u0006\u00102\u001a\u00020\u0001H\u0002J\u0010\u0010<\u001a\u0002002\u0006\u0010=\u001a\u00020\tH\u0002J\u0010\u0010>\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000fH\u0002J\u001c\u0010?\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0002J\u001c\u0010@\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0002J\b\u0010A\u001a\u00020\u0011H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\t0\u000bj\b\u0012\u0004\u0012\u00020\t`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u000bj\b\u0012\u0004\u0012\u00020\u0013`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/plugins/gradle/service/modelAction/GradleIdeaModelHolder;", "", "pathMapper", "Lcom/intellij/util/PathMapper;", "buildEnvironment", "Lorg/gradle/tooling/model/build/BuildEnvironment;", "<init>", "(Lcom/intellij/util/PathMapper;Lorg/gradle/tooling/model/build/BuildEnvironment;)V", "rootBuild", "Lorg/jetbrains/plugins/gradle/model/GradleLightBuild;", "nestedBuilds", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "models", "", "Lcom/intellij/gradle/toolingExtension/impl/modelAction/GradleModelId;", "buildIdMapping", "", "telemetry", "Lcom/intellij/gradle/toolingExtension/impl/telemetry/TelemetryHolder;", "serializer", "Lcom/intellij/gradle/toolingExtension/impl/modelSerialization/ToolingSerializer;", "modelPathConverter", "Lorg/jetbrains/plugins/gradle/util/GradleObjectTraverser;", "getBuildEnvironment", "getRootBuild", "getNestedBuilds", "", "getAllBuilds", "hasModulesWithModel", "", "modelClass", "Ljava/lang/Class;", "getRootModel", "T", "modelClazz", "(Ljava/lang/Class;)Ljava/lang/Object;", "getBuildModel", "buildModel", "Lorg/gradle/tooling/model/BuildModel;", "(Lorg/gradle/tooling/model/BuildModel;Ljava/lang/Class;)Ljava/lang/Object;", "getProjectModel", "projectModel", "Lorg/gradle/tooling/model/ProjectModel;", "(Lorg/gradle/tooling/model/ProjectModel;Ljava/lang/Class;)Ljava/lang/Object;", "modelId", "(Lcom/intellij/gradle/toolingExtension/impl/modelAction/GradleModelId;Ljava/lang/Class;)Ljava/lang/Object;", "convertModelsWithType", "", "deserializeModel", "model", "(Ljava/lang/Object;Lcom/intellij/gradle/toolingExtension/impl/modelAction/GradleModelId;Ljava/lang/Class;)Ljava/lang/Object;", "addProjectModel", "project", "(Lorg/gradle/tooling/model/ProjectModel;Ljava/lang/Class;Ljava/lang/Object;)V", "getTelemetry", "addState", "state", "Lcom/intellij/gradle/toolingExtension/impl/modelAction/GradleModelHolderState;", "convertModelPathsInPlace", "convertBuildModelPathsInPlace", "build", "applyBuildIdMapping", "getBuildModelId", "getProjectModelId", "toString", "Companion", "intellij.gradle"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGradleIdeaModelHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleIdeaModelHolder.kt\norg/jetbrains/plugins/gradle/service/modelAction/GradleIdeaModelHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n1755#2,3:222\n*S KotlinDebug\n*F\n+ 1 GradleIdeaModelHolder.kt\norg/jetbrains/plugins/gradle/service/modelAction/GradleIdeaModelHolder\n*L\n60#1:222,3\n*E\n"})
public final class GradleIdeaModelHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PathMapper pathMapper;
    @Nullable
    private BuildEnvironment buildEnvironment;
    @Nullable
    private GradleLightBuild rootBuild;
    @NotNull
    private final ArrayList<GradleLightBuild> nestedBuilds;
    @NotNull
    private final Map<GradleModelId, Object> models;
    @NotNull
    private final Map<String, String> buildIdMapping;
    @NotNull
    private final ArrayList<TelemetryHolder> telemetry;
    @NotNull
    private final ToolingSerializer serializer;
    @NotNull
    private final GradleObjectTraverser modelPathConverter;
    @NotNull
    private static final Logger LOG;

    public GradleIdeaModelHolder(@Nullable PathMapper pathMapper, @Nullable BuildEnvironment buildEnvironment) {
        this.pathMapper = pathMapper;
        this.buildEnvironment = buildEnvironment;
        this.nestedBuilds = new ArrayList();
        this.models = new LinkedHashMap();
        this.buildIdMapping = new LinkedHashMap();
        this.telemetry = new ArrayList();
        this.serializer = new ToolingSerializer();
        Object[] objectArray = new Class[]{Object.class, File.class};
        this.modelPathConverter = new GradleObjectTraverser(SetsKt.setOf(String.class), SetsKt.setOf((Object[])objectArray));
    }

    public /* synthetic */ GradleIdeaModelHolder(PathMapper pathMapper, BuildEnvironment buildEnvironment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pathMapper = null;
        }
        if ((n & 2) != 0) {
            buildEnvironment = null;
        }
        this(pathMapper, buildEnvironment);
    }

    @Nullable
    public final BuildEnvironment getBuildEnvironment() {
        return this.buildEnvironment;
    }

    @NotNull
    public final GradleLightBuild getRootBuild() {
        GradleLightBuild gradleLightBuild = this.rootBuild;
        Intrinsics.checkNotNull((Object)gradleLightBuild);
        return gradleLightBuild;
    }

    @NotNull
    public final List<GradleLightBuild> getNestedBuilds() {
        return this.nestedBuilds;
    }

    @NotNull
    public final List<GradleLightBuild> getAllBuilds() {
        ArrayList<GradleLightBuild> result = new ArrayList<GradleLightBuild>();
        result.add(this.getRootBuild());
        result.addAll((Collection)this.getNestedBuilds());
        return result;
    }

    public final boolean hasModulesWithModel(@NotNull Class<?> modelClass) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Iterable $this$any$iv = this.models.keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GradleModelId it = (GradleModelId)element$iv;
                    boolean bl2 = false;
                    if (!it.isForClass(modelClass)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final <T> T getRootModel(@NotNull Class<T> modelClazz) {
        Intrinsics.checkNotNullParameter(modelClazz, (String)"modelClazz");
        return this.getBuildModel((BuildModel)this.getRootBuild(), modelClazz);
    }

    @Nullable
    public final <T> T getBuildModel(@NotNull BuildModel buildModel, @NotNull Class<T> modelClass) {
        Intrinsics.checkNotNullParameter((Object)buildModel, (String)"buildModel");
        Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
        GradleModelId modelId = this.getBuildModelId(buildModel, modelClass);
        return this.getRootModel(modelId, modelClass);
    }

    @Nullable
    public final <T> T getProjectModel(@NotNull ProjectModel projectModel, @NotNull Class<T> modelClass) {
        Intrinsics.checkNotNullParameter((Object)projectModel, (String)"projectModel");
        Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
        GradleModelId modelId = this.getProjectModelId(projectModel, modelClass);
        return this.getRootModel(modelId, modelClass);
    }

    private final <T> T getRootModel(GradleModelId modelId, Class<T> modelClass) {
        Object model = this.models.get(modelId);
        if (model == null) {
            return null;
        }
        if (modelClass.isInstance(model)) {
            return (T)model;
        }
        this.convertModelsWithType(modelClass);
        return (T)this.models.get(modelId);
    }

    private final void convertModelsWithType(Class<?> modelClass) {
        Iterator<Map.Entry<GradleModelId, Object>> iterator = this.models.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<GradleModelId, Object> entry = iterator.next();
            GradleModelId modelId = entry.getKey();
            Object model = entry.getValue();
            if (!modelId.isForClass(modelClass)) continue;
            Object deserializedModel = this.deserializeModel(model, modelId, modelClass);
            if (deserializedModel == null) {
                iterator.remove();
                continue;
            }
            this.convertModelPathsInPlace(deserializedModel);
            this.models.put(modelId, deserializedModel);
        }
    }

    private final <T> T deserializeModel(Object model, GradleModelId modelId, Class<T> modelClass) {
        Object object;
        if (!(model instanceof byte[])) {
            return null;
        }
        try {
            object = this.serializer.read((byte[])model, modelClass);
        }
        catch (Exception e) {
            LOG.error("Failed to deserialize model with id [" + modelId + "]", (Throwable)e);
            return null;
        }
        Object deserializedModel = object;
        if (deserializedModel == null || !modelClass.isInstance(deserializedModel)) {
            return null;
        }
        return (T)deserializedModel;
    }

    public final <T> void addProjectModel(@NotNull ProjectModel project2, @NotNull Class<T> modelClass, @NotNull T model) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        GradleModelId modelId = this.getProjectModelId(project2, modelClass);
        this.models.put(modelId, model);
    }

    @NotNull
    public final List<TelemetryHolder> getTelemetry() {
        return this.telemetry;
    }

    public final void addState(@NotNull GradleModelHolderState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        DefaultGradleLightBuild rootBuild = state.getRootBuild();
        Collection collection = state.getNestedBuilds();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getNestedBuilds(...)");
        Collection nestedBuilds = collection;
        BuildEnvironment buildEnvironment = state.getBuildEnvironment();
        TelemetryHolder telemetryHolder = state.getOpenTelemetry();
        Intrinsics.checkNotNullExpressionValue((Object)telemetryHolder, (String)"getOpenTelemetry(...)");
        TelemetryHolder telemetry = telemetryHolder;
        Map map = state.getModels();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getModels(...)");
        Map models = map;
        if (rootBuild != null) {
            this.convertBuildModelPathsInPlace((GradleLightBuild)rootBuild);
            this.rootBuild = (GradleLightBuild)rootBuild;
        }
        for (DefaultGradleLightBuild nestedBuild : nestedBuilds) {
            Intrinsics.checkNotNull((Object)nestedBuild);
            this.convertBuildModelPathsInPlace((GradleLightBuild)nestedBuild);
            this.nestedBuilds.add((GradleLightBuild)nestedBuild);
        }
        if (buildEnvironment != null) {
            this.convertModelPathsInPlace(buildEnvironment);
            this.buildEnvironment = buildEnvironment;
        }
        this.models.putAll(models);
        byte[] byArray = telemetry.getTraces();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getTraces(...)");
        if (!(byArray.length == 0)) {
            this.telemetry.add(telemetry);
        }
    }

    private final void convertModelPathsInPlace(Object model) {
        if (this.pathMapper == null) {
            return;
        }
        this.modelPathConverter.walk(model, arg_0 -> GradleIdeaModelHolder.convertModelPathsInPlace$lambda$1(this, arg_0));
    }

    private final void convertBuildModelPathsInPlace(GradleLightBuild build) {
        String string = GradleModelId.createBuildId((BuildIdentifier)build.getBuildIdentifier());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"createBuildId(...)");
        String originalBuildId = string;
        this.convertModelPathsInPlace(build);
        String string2 = GradleModelId.createBuildId((BuildIdentifier)build.getBuildIdentifier());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"createBuildId(...)");
        String currentBuildId = string2;
        if (!Intrinsics.areEqual((Object)originalBuildId, (Object)currentBuildId)) {
            this.buildIdMapping.put(currentBuildId, originalBuildId);
        }
    }

    private final GradleModelId applyBuildIdMapping(GradleModelId modelId) {
        String string = this.buildIdMapping.get(modelId.getBuildId());
        if (string == null) {
            return modelId;
        }
        String originalBuildId = string;
        return new GradleModelId(modelId.getClassId(), originalBuildId, modelId.getProjectId());
    }

    private final GradleModelId getBuildModelId(BuildModel buildModel, Class<?> modelClass) {
        GradleModelId gradleModelId = GradleModelId.createBuildModelId((BuildModel)buildModel, modelClass);
        Intrinsics.checkNotNullExpressionValue((Object)gradleModelId, (String)"createBuildModelId(...)");
        GradleModelId modelId = gradleModelId;
        return this.applyBuildIdMapping(modelId);
    }

    private final GradleModelId getProjectModelId(ProjectModel projectModel, Class<?> modelClass) {
        GradleModelId gradleModelId = GradleModelId.createProjectModelId((ProjectModel)projectModel, modelClass);
        Intrinsics.checkNotNullExpressionValue((Object)gradleModelId, (String)"createProjectModelId(...)");
        GradleModelId modelId = gradleModelId;
        return this.applyBuildIdMapping(modelId);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u242.append("Models{\n");
        $this$toString_u24lambda_u242.append("rootModel=" + this.rootBuild + "\n");
        $this$toString_u24lambda_u242.append("myModelsById=\n");
        for (Map.Entry<GradleModelId, Object> entry : this.models.entrySet()) {
            GradleModelId modelId = entry.getKey();
            Object model = entry.getValue();
            $this$toString_u24lambda_u242.append(modelId + "=" + model + "\n");
        }
        $this$toString_u24lambda_u242.append("}");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void convertModelPathsInPlace$lambda$1(GradleIdeaModelHolder this$0, Object remoteFile) {
        String remotePath;
        Intrinsics.checkNotNullParameter((Object)remoteFile, (String)"remoteFile");
        if (remoteFile instanceof File && this$0.pathMapper.canReplaceRemote(remotePath = ((File)remoteFile).getPath())) {
            String string = this$0.pathMapper.convertToLocal(remotePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertToLocal(...)");
            String localPath = string;
            try {
                Field field = File.class.getDeclaredField("path");
                field.setAccessible(true);
                field.set(remoteFile, localPath);
            }
            catch (Throwable reflectionError) {
                LOG.error("Failed to update mapped file", reflectionError);
            }
        }
    }

    public GradleIdeaModelHolder() {
        this(null, null, 3, null);
    }

    static {
        Logger logger = Logger.getInstance(GradleIdeaModelHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/service/modelAction/GradleIdeaModelHolder$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

