/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util.telemetry;

import com.intellij.codeWithMe.ClientId;
import com.intellij.gradle.toolingExtension.impl.telemetry.TelemetryHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.diagnostic.telemetry.exporters.OpenTelemetryRawTraceExporter;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.telemetry.GradleOpenTelemetryTraceService;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/util/telemetry/GradleOpenTelemetryTraceService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "exportTraces", "", "holder", "Lcom/intellij/gradle/toolingExtension/impl/telemetry/TelemetryHolder;", "path", "Ljava/nio/file/Path;", "url", "Ljava/net/URI;", "sendTelemetryToOtlp", "telemetryHost", "dumpTelemetryToFile", "targetFolder", "Companion", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleOpenTelemetryTraceService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleOpenTelemetryTraceService.kt\norg/jetbrains/plugins/gradle/util/telemetry/GradleOpenTelemetryTraceService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,67:1\n1#2:68\n14#3:69\n*S KotlinDebug\n*F\n+ 1 GradleOpenTelemetryTraceService.kt\norg/jetbrains/plugins/gradle/util/telemetry/GradleOpenTelemetryTraceService\n*L\n59#1:69\n*E\n"})
public final class GradleOpenTelemetryTraceService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private static final Logger LOG;

    public GradleOpenTelemetryTraceService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
    }

    private final void exportTraces(TelemetryHolder holder, Path path, URI url) {
        block2: {
            Comparable<URI> comparable;
            byte[] byArray = holder.getTraces();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getTraces(...)");
            if (byArray.length == 0) {
                return;
            }
            URI uRI = url;
            if (uRI != null) {
                URI $this$exportTraces_u24lambda_u240 = comparable = uRI;
                boolean bl = false;
                this.sendTelemetryToOtlp(holder, $this$exportTraces_u24lambda_u240);
            }
            Path path2 = path;
            if (path2 == null) break block2;
            Comparable<URI> $this$exportTraces_u24lambda_u241 = comparable = path2;
            boolean bl = false;
            this.dumpTelemetryToFile(holder, (Path)$this$exportTraces_u24lambda_u241);
        }
    }

    private final void sendTelemetryToOtlp(TelemetryHolder holder, URI telemetryHost) {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(holder, telemetryHost, null){
            int label;
            final /* synthetic */ TelemetryHolder $holder;
            final /* synthetic */ URI $telemetryHost;
            {
                this.$holder = $holder;
                this.$telemetryHost = $telemetryHost;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        switch (sendTelemetryToOtlp.WhenMappings.$EnumSwitchMapping$0[this.$holder.getFormat().ordinal()]) {
                            case 1: {
                                byte[] byArray = this.$holder.getTraces();
                                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getTraces(...)");
                                OpenTelemetryRawTraceExporter.INSTANCE.sendProtobuf(this.$telemetryHost, byArray);
                                break;
                            }
                            case 2: {
                                byte[] byArray = this.$holder.getTraces();
                                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getTraces(...)");
                                OpenTelemetryRawTraceExporter.INSTANCE.sendJson(this.$telemetryHost, byArray);
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void dumpTelemetryToFile(TelemetryHolder holder, Path targetFolder) {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(targetFolder, holder, null){
            int label;
            final /* synthetic */ Path $targetFolder;
            final /* synthetic */ TelemetryHolder $holder;
            {
                this.$targetFolder = $targetFolder;
                this.$holder = $holder;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            Path targetFile;
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            if (!Files.exists(this.$targetFolder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectory(this.$targetFolder, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectory(...)");
                            }
                            Path path = this.$targetFolder.resolve("gradle-telemetry-" + System.currentTimeMillis() + ".json");
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                            Path path2 = path;
                            Object[] objectArray = new FileAttribute[]{};
                            Path path3 = Files.createFile(path2, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createFile(...)");
                            path2 = targetFile = path3;
                            byte[] byArray = this.$holder.getTraces();
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getTraces(...)");
                            objectArray = byArray;
                            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND};
                            Files.write(path2, (byte[])objectArray, Arrays.copyOf(openOptionArray, openOptionArray.length));
                        }
                        catch (Exception e) {
                            GradleOpenTelemetryTraceService.access$getLOG$cp().warn("Unable to dump performance traces to the folder (" + this.$targetFolder + "); Cause: " + e.getMessage());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @JvmStatic
    public static final void exportOpenTelemetry(@NotNull TelemetryHolder holder, @Nullable Path path, @Nullable URI url) {
        Companion.exportOpenTelemetry(holder, path, url);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleOpenTelemetryTraceService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gradle/util/telemetry/GradleOpenTelemetryTraceService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "exportOpenTelemetry", "", "holder", "Lcom/intellij/gradle/toolingExtension/impl/telemetry/TelemetryHolder;", "path", "Ljava/nio/file/Path;", "url", "Ljava/net/URI;", "intellij.gradle"})
    @SourceDebugExtension(value={"SMAP\nGradleOpenTelemetryTraceService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleOpenTelemetryTraceService.kt\norg/jetbrains/plugins/gradle/util/telemetry/GradleOpenTelemetryTraceService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,67:1\n40#2,3:68\n*S KotlinDebug\n*F\n+ 1 GradleOpenTelemetryTraceService.kt\norg/jetbrains/plugins/gradle/util/telemetry/GradleOpenTelemetryTraceService$Companion\n*L\n63#1:68,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void exportOpenTelemetry(@NotNull TelemetryHolder holder, @Nullable Path path, @Nullable URI url) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            boolean $i$f$service = false;
            Class<GradleOpenTelemetryTraceService> serviceClass$iv = GradleOpenTelemetryTraceService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((GradleOpenTelemetryTraceService)object).exportTraces(holder, path, url);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

