/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHEnterpriseServerMeta;
import org.jetbrains.plugins.github.api.data.GithubPullRequestMergeMethod;
import org.jetbrains.plugins.github.pullrequest.GHPRAction;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineVirtualFile;
import org.jetbrains.plugins.github.pullrequest.ui.filters.GHPRListSearchValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u0016\u0010/\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00103\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00104\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00105\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00106\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00107\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00108\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00109\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u0010:\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u0010;\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u001e\u0010<\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010=\u001a\u00020(2\u0006\u0010>\u001a\u00020)J\u000e\u0010?\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u0016\u0010@\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010A\u001a\u00020\u001aJ\u001e\u0010B\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "COUNTERS_GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGroup", "SELECTORS_OPENED_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "LIST_OPENED_EVENT", "FILTER_SEARCH_PRESENT", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "FILTER_STATE_PRESENT", "FILTER_AUTHOR_PRESENT", "FILTER_ASSIGNEE_PRESENT", "FILTER_REVIEW_PRESENT", "FILTER_LABEL_PRESENT", "FILTERS_APPLIED_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "DETAILS_OPENED_EVENT", "NEW_OPENED_EVENT", "TIMELINE_OPENED_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "DIFF_OPENED_EVENT", "MERGED_EVENT", "Lorg/jetbrains/plugins/github/api/data/GithubPullRequestMergeMethod;", "anonymizedId", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "", "SERVER_META_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "DETAILS_BRANCHES_EVENT", "DETAILS_BRANCH_CHECKED_OUT_EVENT", "DETAILS_COMMIT_CHOSEN_EVENT", "DETAILS_NEXT_COMMIT_EVENT", "DETAILS_PREV_COMMIT_EVENT", "DETAILS_CHANGE_EVENT", "DETAILS_CHECKS_EVENT", "DETAILS_ACTION_EVENT", "Lorg/jetbrains/plugins/github/pullrequest/GHPRAction;", "", "logSelectorsOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "logListOpened", "logListFiltersApplied", "filters", "Lorg/jetbrains/plugins/github/pullrequest/ui/filters/GHPRListSearchValue;", "logDetailsOpened", "logNewPRViewOpened", "logTimelineOpened", "logDiffOpened", "logDetailsBranchesOpened", "logDetailsBranchCheckedOut", "logDetailsCommitChosen", "logDetailsNextCommitChosen", "logDetailsPrevCommitChosen", "logDetailsChecksOpened", "logDetailsActionInvoked", "action", "isDefault", "logChangeSelected", "logMergedEvent", "method", "logEnterpriseServerMeta", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "meta", "Lorg/jetbrains/plugins/github/api/data/GHEnterpriseServerMeta;", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRStatisticsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRStatisticsCollector.kt\norg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,199:1\n12734#2,3:200\n12734#2,3:203\n264#3:206\n262#3,3:207\n*S KotlinDebug\n*F\n+ 1 GHPRStatisticsCollector.kt\norg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector\n*L\n100#1:200,3\n105#1:203,3\n52#1:206\n69#1:207,3\n*E\n"})
public final class GHPRStatisticsCollector
extends CounterUsagesCollector {
    @NotNull
    public static final GHPRStatisticsCollector INSTANCE;
    @NotNull
    private static final EventLogGroup COUNTERS_GROUP;
    @NotNull
    private static final EventId SELECTORS_OPENED_EVENT;
    @NotNull
    private static final EventId LIST_OPENED_EVENT;
    @NotNull
    private static final BooleanEventField FILTER_SEARCH_PRESENT;
    @NotNull
    private static final BooleanEventField FILTER_STATE_PRESENT;
    @NotNull
    private static final BooleanEventField FILTER_AUTHOR_PRESENT;
    @NotNull
    private static final BooleanEventField FILTER_ASSIGNEE_PRESENT;
    @NotNull
    private static final BooleanEventField FILTER_REVIEW_PRESENT;
    @NotNull
    private static final BooleanEventField FILTER_LABEL_PRESENT;
    @NotNull
    private static final VarargEventId FILTERS_APPLIED_EVENT;
    @NotNull
    private static final EventId DETAILS_OPENED_EVENT;
    @NotNull
    private static final EventId NEW_OPENED_EVENT;
    @NotNull
    private static final EventId1<Integer> TIMELINE_OPENED_EVENT;
    @NotNull
    private static final EventId1<Integer> DIFF_OPENED_EVENT;
    @NotNull
    private static final EventId1<GithubPullRequestMergeMethod> MERGED_EVENT;
    @NotNull
    private static final PrimitiveEventField<String> anonymizedId;
    @NotNull
    private static final EventId2<String, String> SERVER_META_EVENT;
    @NotNull
    private static final EventId DETAILS_BRANCHES_EVENT;
    @NotNull
    private static final EventId DETAILS_BRANCH_CHECKED_OUT_EVENT;
    @NotNull
    private static final EventId DETAILS_COMMIT_CHOSEN_EVENT;
    @NotNull
    private static final EventId DETAILS_NEXT_COMMIT_EVENT;
    @NotNull
    private static final EventId DETAILS_PREV_COMMIT_EVENT;
    @NotNull
    private static final EventId DETAILS_CHANGE_EVENT;
    @NotNull
    private static final EventId DETAILS_CHECKS_EVENT;
    @NotNull
    private static final EventId2<GHPRAction, Boolean> DETAILS_ACTION_EVENT;

    private GHPRStatisticsCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return COUNTERS_GROUP;
    }

    public final void logSelectorsOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SELECTORS_OPENED_EVENT.log(project);
    }

    public final void logListOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LIST_OPENED_EVENT.log(project);
    }

    public final void logListFiltersApplied(@NotNull Project project, @NotNull GHPRListSearchValue filters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        EventPair[] eventPairArray = new EventPair[]{new EventPair((EventField)FILTER_SEARCH_PRESENT, (Object)(filters.getSearchQuery() != null ? 1 : 0)), new EventPair((EventField)FILTER_STATE_PRESENT, (Object)(filters.getState() != null ? 1 : 0)), new EventPair((EventField)FILTER_AUTHOR_PRESENT, (Object)(filters.getAuthor() != null ? 1 : 0)), new EventPair((EventField)FILTER_ASSIGNEE_PRESENT, (Object)(filters.getAssignee() != null ? 1 : 0)), new EventPair((EventField)FILTER_REVIEW_PRESENT, (Object)(filters.getReviewState() != null ? 1 : 0)), new EventPair((EventField)FILTER_LABEL_PRESENT, (Object)(filters.getLabel() != null ? 1 : 0))};
        FILTERS_APPLIED_EVENT.log(project, eventPairArray);
    }

    public final void logDetailsOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_OPENED_EVENT.log(project);
    }

    public final void logNewPRViewOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NEW_OPENED_EVENT.log(project);
    }

    public final void logTimelineOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        Object[] $this$count$iv = virtualFileArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            if (!(it instanceof GHPRTimelineVirtualFile)) continue;
            ++count$iv;
        }
        int count = count$iv;
        TIMELINE_OPENED_EVENT.log(project, (Object)count);
    }

    public final void logDiffOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        Object[] $this$count$iv = virtualFileArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            if (!(it instanceof GHPRDiffVirtualFile)) continue;
            ++count$iv;
        }
        int count = count$iv;
        DIFF_OPENED_EVENT.log(project, (Object)count);
    }

    public final void logDetailsBranchesOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_BRANCHES_EVENT.log(project);
    }

    public final void logDetailsBranchCheckedOut(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_BRANCH_CHECKED_OUT_EVENT.log(project);
    }

    public final void logDetailsCommitChosen(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_COMMIT_CHOSEN_EVENT.log(project);
    }

    public final void logDetailsNextCommitChosen(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_NEXT_COMMIT_EVENT.log(project);
    }

    public final void logDetailsPrevCommitChosen(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_PREV_COMMIT_EVENT.log(project);
    }

    public final void logDetailsChecksOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_CHECKS_EVENT.log(project);
    }

    public final void logDetailsActionInvoked(@NotNull Project project, @NotNull GHPRAction action, boolean isDefault) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        DETAILS_ACTION_EVENT.log(project, (Object)action, (Object)isDefault);
    }

    public final void logChangeSelected(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DETAILS_CHANGE_EVENT.log(project);
    }

    public final void logMergedEvent(@NotNull Project project, @NotNull GithubPullRequestMergeMethod method) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        MERGED_EVENT.log(project, (Object)method);
    }

    public final void logEnterpriseServerMeta(@NotNull Project project, @NotNull GithubServerPath server, @NotNull GHEnterpriseServerMeta meta) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        SERVER_META_EVENT.log(project, (Object)server.toUrl(), (Object)meta.getInstalledVersion());
    }

    private static final String MERGED_EVENT$lambda$0(GithubPullRequestMergeMethod it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        String string = it.name();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$iv;
        String name$iv;
        INSTANCE = new GHPRStatisticsCollector();
        COUNTERS_GROUP = new EventLogGroup("vcs.github.pullrequest.counters", 7, null, 4, null);
        SELECTORS_OPENED_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)COUNTERS_GROUP, (String)"selectors.opened", null, (int)2, null);
        LIST_OPENED_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)COUNTERS_GROUP, (String)"list.opened", null, (int)2, null);
        FILTER_SEARCH_PRESENT = EventFields.Boolean((String)"has_search");
        FILTER_STATE_PRESENT = EventFields.Boolean((String)"has_state");
        FILTER_AUTHOR_PRESENT = EventFields.Boolean((String)"has_author");
        FILTER_ASSIGNEE_PRESENT = EventFields.Boolean((String)"has_assignee");
        FILTER_REVIEW_PRESENT = EventFields.Boolean((String)"has_review_state");
        FILTER_LABEL_PRESENT = EventFields.Boolean((String)"has_label");
        EventFields eventFields = new EventFields[]{FILTER_SEARCH_PRESENT, FILTER_STATE_PRESENT, FILTER_AUTHOR_PRESENT, FILTER_ASSIGNEE_PRESENT, FILTER_REVIEW_PRESENT, FILTER_LABEL_PRESENT};
        FILTERS_APPLIED_EVENT = COUNTERS_GROUP.registerVarargEvent("list.filters.applied", (EventField[])eventFields);
        DETAILS_OPENED_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)COUNTERS_GROUP, (String)"details.opened", null, (int)2, null);
        NEW_OPENED_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)COUNTERS_GROUP, (String)"new.pr.view.opened", null, (int)2, null);
        TIMELINE_OPENED_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)COUNTERS_GROUP, (String)"timeline.opened", (EventField)((EventField)EventFields.Int((String)"count")), null, (int)4, null);
        DIFF_OPENED_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)COUNTERS_GROUP, (String)"diff.opened", (EventField)((EventField)EventFields.Int((String)"count")), null, (int)4, null);
        eventFields = EventFields.INSTANCE;
        String string = "method";
        Function1 transform$iv = GHPRStatisticsCollector::MERGED_EVENT$lambda$0;
        boolean $i$f$Enum = false;
        MERGED_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)COUNTERS_GROUP, (String)"merged", (EventField)((EventField)new EnumEventField(name$iv, GithubPullRequestMergeMethod.class, null, transform$iv)), null, (int)4, null);
        anonymizedId = EventFields.AnonymizedId;
        SERVER_META_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)COUNTERS_GROUP, (String)"server.meta.collected", (EventField)((EventField)anonymizedId), (EventField)((EventField)EventFields.Version), null, (int)8, null);
        DETAILS_BRANCHES_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)COUNTERS_GROUP, (String)"details.branches.opened", null, (int)2, null);
        DETAILS_BRANCH_CHECKED_OUT_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)COUNTERS_GROUP, (String)"details.branch.checked.out", null, (int)2, null);
        DETAILS_COMMIT_CHOSEN_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)COUNTERS_GROUP, (String)"details.commit.chosen", null, (int)2, null);
        DETAILS_NEXT_COMMIT_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)COUNTERS_GROUP, (String)"details.next.commit.chosen", null, (int)2, null);
        DETAILS_PREV_COMMIT_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)COUNTERS_GROUP, (String)"details.prev.commit.chosen", null, (int)2, null);
        DETAILS_CHANGE_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)COUNTERS_GROUP, (String)"details.change.selected", null, (int)2, null);
        DETAILS_CHECKS_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)COUNTERS_GROUP, (String)"details.checks.opened", null, (int)2, null);
        EventFields this_$iv = EventFields.INSTANCE;
        name$iv = "action";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        DETAILS_ACTION_EVENT = EventLogGroup.registerEvent$default((EventLogGroup)COUNTERS_GROUP, (String)"details.additional.actions.invoked", (EventField)((EventField)new EnumEventField(name$iv, GHPRAction.class, null, transform$iv)), (EventField)((EventField)EventFields.Boolean((String)"is_default")), null, (int)8, null);
    }
}

