/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.platform.PlatformSpecificDiagnosticComponents;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0096\u0002J\t\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/DeclarationWithDiagnosticComponents;", "", "", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticComponents", "Lorg/jetbrains/kotlin/platform/PlatformSpecificDiagnosticComponents;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/platform/PlatformSpecificDiagnosticComponents;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getDiagnosticComponents", "()Lorg/jetbrains/kotlin/platform/PlatformSpecificDiagnosticComponents;", "iterator", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "frontend"})
public final class DeclarationWithDiagnosticComponents
implements Iterable<Object>,
KMappedMarker {
    @NotNull
    private final DeclarationDescriptor declaration;
    @NotNull
    private final PlatformSpecificDiagnosticComponents diagnosticComponents;

    public DeclarationWithDiagnosticComponents(@NotNull DeclarationDescriptor declaration, @NotNull PlatformSpecificDiagnosticComponents diagnosticComponents) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)diagnosticComponents, (String)"diagnosticComponents");
        this.declaration = declaration;
        this.diagnosticComponents = diagnosticComponents;
    }

    @NotNull
    public final DeclarationDescriptor getDeclaration() {
        return this.declaration;
    }

    @NotNull
    public final PlatformSpecificDiagnosticComponents getDiagnosticComponents() {
        return this.diagnosticComponents;
    }

    @Override
    @NotNull
    public Iterator<Object> iterator() {
        Object[] objectArray = new Object[]{this.declaration, this.diagnosticComponents};
        return SequencesKt.sequenceOf((Object[])objectArray).iterator();
    }

    @NotNull
    public final DeclarationDescriptor component1() {
        return this.declaration;
    }

    @NotNull
    public final PlatformSpecificDiagnosticComponents component2() {
        return this.diagnosticComponents;
    }

    @NotNull
    public final DeclarationWithDiagnosticComponents copy(@NotNull DeclarationDescriptor declaration, @NotNull PlatformSpecificDiagnosticComponents diagnosticComponents) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)diagnosticComponents, (String)"diagnosticComponents");
        return new DeclarationWithDiagnosticComponents(declaration, diagnosticComponents);
    }

    public static /* synthetic */ DeclarationWithDiagnosticComponents copy$default(DeclarationWithDiagnosticComponents declarationWithDiagnosticComponents, DeclarationDescriptor declarationDescriptor, PlatformSpecificDiagnosticComponents platformSpecificDiagnosticComponents, int n, Object object) {
        if ((n & 1) != 0) {
            declarationDescriptor = declarationWithDiagnosticComponents.declaration;
        }
        if ((n & 2) != 0) {
            platformSpecificDiagnosticComponents = declarationWithDiagnosticComponents.diagnosticComponents;
        }
        return declarationWithDiagnosticComponents.copy(declarationDescriptor, platformSpecificDiagnosticComponents);
    }

    @NotNull
    public String toString() {
        return "DeclarationWithDiagnosticComponents(declaration=" + this.declaration + ", diagnosticComponents=" + this.diagnosticComponents + ')';
    }

    public int hashCode() {
        int result = this.declaration.hashCode();
        result = result * 31 + this.diagnosticComponents.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeclarationWithDiagnosticComponents)) {
            return false;
        }
        DeclarationWithDiagnosticComponents declarationWithDiagnosticComponents = (DeclarationWithDiagnosticComponents)other;
        if (!Intrinsics.areEqual((Object)this.declaration, (Object)declarationWithDiagnosticComponents.declaration)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.diagnosticComponents, (Object)declarationWithDiagnosticComponents.diagnosticComponents);
    }
}

