/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.KtDescriptorUtilKt;
import org.jetbrains.kotlin.resolve.MissingSupertypesResolver;
import org.jetbrains.kotlin.resolve.RecursiveContractHelperKt;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.KotlinCallResolver;
import org.jetbrains.kotlin.resolve.calls.components.ClassicTypeSystemContextForCSKt;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.resolve.calls.components.ReturnArgumentsAnalysisResult;
import org.jetbrains.kotlin.resolve.calls.components.ReturnArgumentsInfo;
import org.jetbrains.kotlin.resolve.calls.components.candidate.CallableReferenceResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.components.candidate.SimpleResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceSession;
import org.jetbrains.kotlin.resolve.calls.inference.NewConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.components.KotlinConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.components.ResultTypeResolver;
import org.jetbrains.kotlin.resolve.calls.inference.components.TypeVariableDirectionCalculator;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewTypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.LHSResult;
import org.jetbrains.kotlin.resolve.calls.model.LambdaKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ReceiverKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedLambdaAtom;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyImpl;
import org.jetbrains.kotlin.resolve.calls.tower.EmptyLabeledReturn;
import org.jetbrains.kotlin.resolve.calls.tower.FunctionExpressionImpl;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.KotlinToResolvedCallTransformer;
import org.jetbrains.kotlin.resolve.calls.tower.LambdaContextInfo;
import org.jetbrains.kotlin.resolve.calls.tower.LambdaKotlinCallArgumentImpl;
import org.jetbrains.kotlin.resolve.calls.tower.NewCallArgumentsKt;
import org.jetbrains.kotlin.resolve.calls.tower.PSICallResolver;
import org.jetbrains.kotlin.resolve.calls.tower.PSIFunctionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCall;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallImpl;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.StubTypeForBuilderInference;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.expressions.DoubleColonExpressionResolver;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001yB\u00af\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u0012\u0006\u0010\"\u001a\u00020#\u0012\u0006\u0010$\u001a\u00020%\u0012\u0006\u0010&\u001a\u00020'\u0012\u0006\u0010(\u001a\u00020)\u0012\u0006\u0010*\u001a\u00020+\u00a2\u0006\u0004\b,\u0010-J\u001a\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000205H\u0016J(\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010@\u001a\u00020AH\u0016J\u001c\u0010B\u001a\u00060CR\u00020\u00172\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0016Jd\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\b\u0010N\u001a\u0004\u0018\u00010?2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020?0P2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020?0P2\b\u0010R\u001a\u0004\u0018\u00010?2\u0006\u0010S\u001a\u00020T2\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020W\u0012\u0004\u0012\u00020X0VH\u0016J\u0012\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010[\u001a\u00020\\H\u0002J\u0010\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`H\u0016J\u0018\u0010a\u001a\u00020M2\u0006\u0010b\u001a\u00020`2\u0006\u0010>\u001a\u00020?H\u0016J\u001a\u0010c\u001a\u00020Z2\u0006\u0010d\u001a\u00020Z2\b\u0010e\u001a\u0004\u0018\u00010fH\u0002J\u0012\u0010g\u001a\u0004\u0018\u00010?2\u0006\u0010b\u001a\u00020`H\u0016J\u0010\u0010h\u001a\u00020^2\u0006\u0010b\u001a\u00020`H\u0016J\u0012\u0010i\u001a\u0004\u0018\u00010j2\u0006\u0010<\u001a\u00020kH\u0016J\"\u0010l\u001a\u00020^2\u0018\u0010m\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020p\u0012\u0004\u0012\u00020q0o0nH\u0016J\u0010\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020GH\u0016J\u0012\u0010i\u001a\u0004\u0018\u00010j2\u0006\u0010u\u001a\u00020ZH\u0002J\u0014\u0010v\u001a\u00020M2\n\u0010w\u001a\u0006\u0012\u0002\b\u00030xH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006z"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/KotlinResolutionCallbacksImpl;", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "typeApproximator", "Lorg/jetbrains/kotlin/types/TypeApproximator;", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "kotlinToResolvedCallTransformer", "Lorg/jetbrains/kotlin/resolve/calls/tower/KotlinToResolvedCallTransformer;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "inferenceSession", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "psiCallResolver", "Lorg/jetbrains/kotlin/resolve/calls/tower/PSICallResolver;", "postponedArgumentsAnalyzer", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "kotlinConstraintSystemCompleter", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;", "callComponents", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "doubleColonExpressionResolver", "Lorg/jetbrains/kotlin/types/expressions/DoubleColonExpressionResolver;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "topLevelCallContext", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "missingSupertypesResolver", "Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;", "kotlinCallResolver", "Lorg/jetbrains/kotlin/resolve/calls/KotlinCallResolver;", "resultTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ResultTypeResolver;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/types/TypeApproximator;Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/tower/KotlinToResolvedCallTransformer;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/resolve/calls/tower/PSICallResolver;Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;Lorg/jetbrains/kotlin/types/expressions/DoubleColonExpressionResolver;Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;Lorg/jetbrains/kotlin/resolve/calls/KotlinCallResolver;Lorg/jetbrains/kotlin/resolve/calls/inference/components/ResultTypeResolver;)V", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getInferenceSession", "()Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "findResultType", "Lorg/jetbrains/kotlin/types/KotlinType;", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/NewConstraintSystem;", "typeVariable", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/TypeVariableTypeConstructor;", "createEmptyConstraintSystem", "resolveCallableReferenceArgument", "", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/CallableReferenceResolutionCandidate;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferenceKotlinCallArgument;", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "baseSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;", "getCandidateFactoryForInvoke", "Lorg/jetbrains/kotlin/resolve/calls/tower/PSICallResolver$FactoryProviderForInvoke;", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "kotlinCall", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "analyzeAndGetLambdaReturnArguments", "Lorg/jetbrains/kotlin/resolve/calls/components/ReturnArgumentsAnalysisResult;", "lambdaArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/LambdaKotlinCallArgument;", "isSuspend", "", "receiverType", "contextReceiversTypes", "", "parameters", "expectedReturnType", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "stubsForPostponedVariables", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/NewTypeVariable;", "Lorg/jetbrains/kotlin/types/StubTypeForBuilderInference;", "getLastDeparentesizedExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "psiCallArgument", "Lorg/jetbrains/kotlin/resolve/calls/tower/PSIKotlinCallArgument;", "bindStubResolvedCallForCandidate", "", "candidate", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;", "isCompileTimeConstant", "resolvedAtom", "findCommonParent", "callElement", "receiver", "Lorg/jetbrains/kotlin/resolve/calls/model/ReceiverKotlinCallArgument;", "getExpectedTypeFromAsExpressionAndRecordItInTrace", "disableContractsIfNecessary", "convertSignedConstantToUnsigned", "Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstant;", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "recordInlinabilityOfLambda", "atom", "", "", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/SimpleResolutionCandidate;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedLambdaAtom;", "getLhsResult", "Lorg/jetbrains/kotlin/resolve/calls/model/LHSResult;", "call", "expression", "constantCanBeConvertedToUnsigned", "constant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "LambdaInfo", "frontend"})
@SourceDebugExtension(value={"SMAP\nKotlinResolutionCallbacksImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinResolutionCallbacksImpl.kt\norg/jetbrains/kotlin/resolve/calls/tower/KotlinResolutionCallbacksImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,385:1\n1557#2:386\n1628#2,3:387\n1619#2:391\n1863#2:392\n1864#2:394\n1620#2:395\n1755#2,3:396\n1734#2,3:399\n1#3:390\n1#3:393\n*S KotlinDebug\n*F\n+ 1 KotlinResolutionCallbacksImpl.kt\norg/jetbrains/kotlin/resolve/calls/tower/KotlinResolutionCallbacksImpl\n*L\n191#1:386\n191#1:387,3\n244#1:391\n244#1:392\n244#1:394\n244#1:395\n261#1:396,3\n357#1:399,3\n244#1:393\n*E\n"})
public final class KotlinResolutionCallbacksImpl
implements KotlinResolutionCallbacks {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    @NotNull
    private final TypeApproximator typeApproximator;
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final KotlinToResolvedCallTransformer kotlinToResolvedCallTransformer;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    private final InferenceSession inferenceSession;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final PSICallResolver psiCallResolver;
    @NotNull
    private final PostponedArgumentsAnalyzer postponedArgumentsAnalyzer;
    @NotNull
    private final KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter;
    @NotNull
    private final KotlinCallComponents callComponents;
    @NotNull
    private final DoubleColonExpressionResolver doubleColonExpressionResolver;
    @NotNull
    private final DeprecationResolver deprecationResolver;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final BasicCallResolutionContext topLevelCallContext;
    @NotNull
    private final MissingSupertypesResolver missingSupertypesResolver;
    @NotNull
    private final KotlinCallResolver kotlinCallResolver;
    @NotNull
    private final ResultTypeResolver resultTypeResolver;

    public KotlinResolutionCallbacksImpl(@NotNull BindingTrace trace, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull TypeApproximator typeApproximator, @NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull KotlinToResolvedCallTransformer kotlinToResolvedCallTransformer, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull InferenceSession inferenceSession, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull TypeResolver typeResolver, @NotNull PSICallResolver psiCallResolver, @NotNull PostponedArgumentsAnalyzer postponedArgumentsAnalyzer, @NotNull KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter, @NotNull KotlinCallComponents callComponents, @NotNull DoubleColonExpressionResolver doubleColonExpressionResolver, @NotNull DeprecationResolver deprecationResolver, @NotNull ModuleDescriptor moduleDescriptor, @NotNull BasicCallResolutionContext topLevelCallContext, @NotNull MissingSupertypesResolver missingSupertypesResolver, @NotNull KotlinCallResolver kotlinCallResolver, @NotNull ResultTypeResolver resultTypeResolver) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)expressionTypingServices, (String)"expressionTypingServices");
        Intrinsics.checkNotNullParameter((Object)((Object)typeApproximator), (String)"typeApproximator");
        Intrinsics.checkNotNullParameter((Object)argumentTypeResolver, (String)"argumentTypeResolver");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)kotlinToResolvedCallTransformer, (String)"kotlinToResolvedCallTransformer");
        Intrinsics.checkNotNullParameter((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        Intrinsics.checkNotNullParameter((Object)inferenceSession, (String)"inferenceSession");
        Intrinsics.checkNotNullParameter((Object)constantExpressionEvaluator, (String)"constantExpressionEvaluator");
        Intrinsics.checkNotNullParameter((Object)typeResolver, (String)"typeResolver");
        Intrinsics.checkNotNullParameter((Object)psiCallResolver, (String)"psiCallResolver");
        Intrinsics.checkNotNullParameter((Object)postponedArgumentsAnalyzer, (String)"postponedArgumentsAnalyzer");
        Intrinsics.checkNotNullParameter((Object)kotlinConstraintSystemCompleter, (String)"kotlinConstraintSystemCompleter");
        Intrinsics.checkNotNullParameter((Object)callComponents, (String)"callComponents");
        Intrinsics.checkNotNullParameter((Object)doubleColonExpressionResolver, (String)"doubleColonExpressionResolver");
        Intrinsics.checkNotNullParameter((Object)deprecationResolver, (String)"deprecationResolver");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)topLevelCallContext, (String)"topLevelCallContext");
        Intrinsics.checkNotNullParameter((Object)missingSupertypesResolver, (String)"missingSupertypesResolver");
        Intrinsics.checkNotNullParameter((Object)kotlinCallResolver, (String)"kotlinCallResolver");
        Intrinsics.checkNotNullParameter((Object)resultTypeResolver, (String)"resultTypeResolver");
        this.trace = trace;
        this.expressionTypingServices = expressionTypingServices;
        this.typeApproximator = typeApproximator;
        this.argumentTypeResolver = argumentTypeResolver;
        this.languageVersionSettings = languageVersionSettings;
        this.kotlinToResolvedCallTransformer = kotlinToResolvedCallTransformer;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.inferenceSession = inferenceSession;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.typeResolver = typeResolver;
        this.psiCallResolver = psiCallResolver;
        this.postponedArgumentsAnalyzer = postponedArgumentsAnalyzer;
        this.kotlinConstraintSystemCompleter = kotlinConstraintSystemCompleter;
        this.callComponents = callComponents;
        this.doubleColonExpressionResolver = doubleColonExpressionResolver;
        this.deprecationResolver = deprecationResolver;
        this.moduleDescriptor = moduleDescriptor;
        this.topLevelCallContext = topLevelCallContext;
        this.missingSupertypesResolver = missingSupertypesResolver;
        this.kotlinCallResolver = kotlinCallResolver;
        this.resultTypeResolver = resultTypeResolver;
    }

    @NotNull
    public final BindingTrace getTrace() {
        return this.trace;
    }

    @Override
    @NotNull
    public InferenceSession getInferenceSession() {
        return this.inferenceSession;
    }

    @Override
    @Nullable
    public KotlinType findResultType(@NotNull NewConstraintSystem constraintSystem, @NotNull TypeVariableTypeConstructor typeVariable) {
        Intrinsics.checkNotNullParameter((Object)constraintSystem, (String)"constraintSystem");
        Intrinsics.checkNotNullParameter((Object)typeVariable, (String)"typeVariable");
        VariableWithConstraints variableWithConstraints = (VariableWithConstraints)constraintSystem.getBuilder().currentStorage().getNotFixedTypeVariables().get(typeVariable);
        if (variableWithConstraints == null) {
            return null;
        }
        VariableWithConstraints variableWithConstraints2 = variableWithConstraints;
        KotlinTypeMarker kotlinTypeMarker = this.resultTypeResolver.findResultType((ResultTypeResolver.Context)constraintSystem.asConstraintSystemCompleterContext(), variableWithConstraints2, TypeVariableDirectionCalculator.ResolveDirection.UNKNOWN);
        Intrinsics.checkNotNull((Object)kotlinTypeMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.KotlinType");
        return (KotlinType)kotlinTypeMarker;
    }

    @Override
    @NotNull
    public NewConstraintSystem createEmptyConstraintSystem() {
        return (NewConstraintSystem)ClassicTypeSystemContextForCSKt.NewConstraintSystemImpl(this.callComponents.getConstraintInjector(), this.callComponents.getBuiltIns(), this.callComponents.getKotlinTypeRefiner(), this.callComponents.getLanguageVersionSettings());
    }

    @Override
    @NotNull
    public Collection<CallableReferenceResolutionCandidate> resolveCallableReferenceArgument(@NotNull CallableReferenceKotlinCallArgument argument, @Nullable UnwrappedType expectedType, @NotNull ConstraintStorage baseSystem) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)baseSystem, (String)"baseSystem");
        return this.kotlinCallResolver.resolveCallableReferenceArgument(argument, expectedType, baseSystem, this);
    }

    @NotNull
    public PSICallResolver.FactoryProviderForInvoke getCandidateFactoryForInvoke(@NotNull ImplicitScopeTower scopeTower, @NotNull KotlinCall kotlinCall) {
        Intrinsics.checkNotNullParameter((Object)scopeTower, (String)"scopeTower");
        Intrinsics.checkNotNullParameter((Object)kotlinCall, (String)"kotlinCall");
        return this.psiCallResolver.new PSICallResolver.FactoryProviderForInvoke(this.topLevelCallContext, scopeTower, (PSIKotlinCallImpl)kotlinCall);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ReturnArgumentsAnalysisResult analyzeAndGetLambdaReturnArguments(@NotNull LambdaKotlinCallArgument lambdaArgument, boolean isSuspend, @Nullable UnwrappedType receiverType, @NotNull List<? extends UnwrappedType> contextReceiversTypes, @NotNull List<? extends UnwrappedType> parameters, @Nullable UnwrappedType expectedReturnType, @NotNull Annotations annotations, @NotNull Map<NewTypeVariable, StubTypeForBuilderInference> stubsForPostponedVariables) {
        boolean lastExpressionCoercedToUnit;
        PSIKotlinCallArgument pSIKotlinCallArgument;
        KtReturnExpression expression2;
        Pair pair;
        void $this$mapNotNullTo$iv;
        TemporaryBindingTrace temporaryTrace;
        Object object;
        UnwrappedType approximatesExpectedType;
        BasicCallResolutionContext it;
        void $this$mapTo$iv$iv;
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)lambdaArgument, (String)"lambdaArgument");
        Intrinsics.checkNotNullParameter(contextReceiversTypes, (String)"contextReceiversTypes");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter(stubsForPostponedVariables, (String)"stubsForPostponedVariables");
        PSIKotlinCallArgument pSIKotlinCallArgument2 = NewCallArgumentsKt.getPsiCallArgument(lambdaArgument);
        Intrinsics.checkNotNull((Object)pSIKotlinCallArgument2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.tower.PSIFunctionKotlinCallArgument");
        PSIFunctionKotlinCallArgument psiCallArgument = (PSIFunctionKotlinCallArgument)pSIKotlinCallArgument2;
        BasicCallResolutionContext outerCallContext = psiCallArgument.getOuterCallContext();
        UnwrappedType unwrappedType = expectedReturnType;
        if (unwrappedType == null) {
            SimpleType simpleType = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"NO_EXPECTED_TYPE");
            unwrappedType = simpleType;
        }
        LambdaInfo lambdaInfo = new LambdaInfo(unwrappedType, expectedReturnType == null ? ContextDependency.DEPENDENT : ContextDependency.INDEPENDENT);
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(outerCallContext.scope.getOwnerDescriptor());
        UnwrappedType unwrappedType2 = receiverType;
        if (unwrappedType2 != null) {
            UnwrappedType it2 = unwrappedType2;
            boolean bl = false;
            kotlinType = this.callComponents.getKotlinTypeChecker().getKotlinTypeRefiner().refineType(it2);
        } else {
            kotlinType = null;
        }
        KotlinType refinedReceiverType = kotlinType;
        Iterable $this$map$iv = contextReceiversTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            UnwrappedType unwrappedType3 = (UnwrappedType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.callComponents.getKotlinTypeChecker().getKotlinTypeRefiner().refineType((KotlinTypeMarker)it));
        }
        List refinedContextReceiverTypes = (List)destination$iv$iv;
        SimpleType expectedType = FunctionTypesKt.createFunctionType(builtIns, annotations, refinedReceiverType, refinedContextReceiverTypes, parameters, null, lambdaInfo.getExpectedType(), isSuspend);
        UnwrappedType unwrappedType4 = this.typeApproximator.approximateToSubType(expectedType, (TypeApproximatorConfiguration)TypeApproximatorConfiguration.LocalDeclaration.INSTANCE);
        if (unwrappedType4 == null) {
            unwrappedType4 = approximatesExpectedType = (UnwrappedType)expectedType;
        }
        if (!stubsForPostponedVariables.isEmpty()) {
            Object $this$analyzeAndGetLambdaReturnArguments_u24lambda_u243 = destination$iv$iv = new BuilderInferenceSession(this.psiCallResolver, this.postponedArgumentsAnalyzer, this.kotlinConstraintSystemCompleter, this.callComponents, builtIns, this.topLevelCallContext, stubsForPostponedVariables, this.trace, this.kotlinToResolvedCallTransformer, this.expressionTypingServices, this.argumentTypeResolver, this.doubleColonExpressionResolver, this.deprecationResolver, this.moduleDescriptor, this.typeApproximator, this.missingSupertypesResolver, lambdaArgument);
            boolean bl = false;
            lambdaArgument.setBuilderInferenceSession((InferenceSession)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u243);
            object = destination$iv$iv;
        } else {
            object = null;
        }
        Object builderInferenceSession = object;
        TemporaryBindingTrace temporaryBindingTrace = temporaryTrace = builderInferenceSession != null ? TemporaryBindingTrace.create(this.trace, "Trace to resolve builder inference lambda: " + lambdaArgument) : null;
        (temporaryBindingTrace != null ? (BindingTrace)temporaryBindingTrace : this.trace).record(BindingContext.NEW_INFERENCE_LAMBDA_INFO, psiCallArgument.getKtFunction(), lambdaInfo);
        TemporaryBindingTrace temporaryBindingTrace2 = temporaryTrace;
        it = (BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)outerCallContext.replaceBindingTrace(temporaryBindingTrace2 != null ? (BindingTrace)temporaryBindingTrace2 : this.trace)).replaceContextDependency(lambdaInfo.getContextDependency())).replaceExpectedType(approximatesExpectedType)).replaceDataFlowInfo(psiCallArgument.getDataFlowInfoBeforeThisArgument());
        boolean bl = false;
        Object object2 = builderInferenceSession;
        BasicCallResolutionContext basicCallResolutionContext = object2 != null ? (BasicCallResolutionContext)it.replaceInferenceSession((InferenceSession)object2) : it;
        Intrinsics.checkNotNullExpressionValue((Object)basicCallResolutionContext, (String)"let(...)");
        BasicCallResolutionContext actualContext = basicCallResolutionContext;
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(psiCallArgument.getExpression(), actualContext);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo, (String)"getTypeInfo(...)");
        KotlinTypeInfo functionTypeInfo = kotlinTypeInfo;
        TemporaryBindingTrace temporaryBindingTrace3 = temporaryTrace;
        (temporaryBindingTrace3 != null ? (BindingTrace)temporaryBindingTrace3 : this.trace).record(BindingContext.NEW_INFERENCE_LAMBDA_INFO, psiCallArgument.getKtFunction(), LambdaInfo.Companion.getSTUB_EMPTY());
        Object object3 = builderInferenceSession;
        boolean bl2 = object3 != null ? ((BuilderInferenceSession)object3).hasInapplicableCall() : false;
        if (bl2) {
            return new ReturnArgumentsAnalysisResult(ReturnArgumentsInfo.Companion.getEmpty(), (InferenceSession)builderInferenceSession, true);
        }
        TemporaryBindingTrace temporaryBindingTrace4 = temporaryTrace;
        if (temporaryBindingTrace4 != null) {
            temporaryBindingTrace4.commit();
        }
        boolean hasReturnWithoutExpression = false;
        boolean returnArgumentFound = false;
        Iterable iterable2 = lambdaInfo.getReturnStatements();
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            KotlinCallArgument kotlinCallArgument;
            Object element$iv = element$iv$iv;
            boolean bl3 = false;
            pair = (Pair)element$iv;
            boolean bl4 = false;
            expression2 = (KtReturnExpression)pair.component1();
            LambdaContextInfo contextInfo = (LambdaContextInfo)pair.component2();
            returnArgumentFound = true;
            KtExpression returnedExpression = expression2.getReturnedExpression();
            if (returnedExpression != null) {
                Object object4 = contextInfo;
                if (object4 == null || (object4 = ((LambdaContextInfo)object4).getTypeInfo()) == null) {
                    throw new AssertionError((Object)"typeInfo should be non-null for return with expression");
                }
                kotlinCallArgument = KotlinResolutionCallbacksImpl.analyzeAndGetLambdaReturnArguments$createCallArgument(outerCallContext, this, returnedExpression, (KotlinTypeInfo)object4, contextInfo.getLexicalScope(), contextInfo.getTrace());
            } else {
                hasReturnWithoutExpression = true;
                kotlinCallArgument = new EmptyLabeledReturn(expression2, builtIns);
            }
            if (kotlinCallArgument == null) continue;
            KotlinCallArgument it$iv = kotlinCallArgument;
            boolean bl5 = false;
            destination$iv.add(it$iv);
        }
        ArrayList returnArguments = (ArrayList)destination$iv;
        KtExpression ktExpression = this.getLastDeparentesizedExpression(psiCallArgument);
        if (ktExpression != null) {
            boolean bl6;
            KtExpression lastExpression;
            block22: {
                lastExpression = ktExpression;
                boolean bl7 = false;
                Iterable $this$any$iv = lambdaInfo.getReturnStatements();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl6 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        pair = (Pair)element$iv;
                        boolean bl8 = false;
                        expression2 = (KtReturnExpression)pair.component1();
                        if (!Intrinsics.areEqual((Object)expression2, (Object)lastExpression)) continue;
                        bl6 = true;
                        break block22;
                    }
                    bl6 = false;
                }
            }
            if (bl6) {
                pSIKotlinCallArgument = null;
            } else {
                KotlinType lastExpressionType = this.trace.getType(lastExpression);
                LambdaContextInfo contextInfo = lambdaInfo.getLastExpressionInfo();
                DataFlowInfo dataFlowInfo = contextInfo.getDataFlowInfoAfter();
                if (dataFlowInfo == null) {
                    dataFlowInfo = functionTypeInfo.getDataFlowInfo();
                }
                KotlinTypeInfo lastExpressionTypeInfo = new KotlinTypeInfo(lastExpressionType, dataFlowInfo, false, null, 12, null);
                pSIKotlinCallArgument = KotlinResolutionCallbacksImpl.analyzeAndGetLambdaReturnArguments$createCallArgument(outerCallContext, this, lastExpression, lastExpressionTypeInfo, contextInfo.getLexicalScope(), contextInfo.getTrace());
            }
        } else {
            pSIKotlinCallArgument = null;
        }
        PSIKotlinCallArgument lastExpressionArgument = pSIKotlinCallArgument;
        UnwrappedType unwrappedType5 = expectedReturnType;
        boolean bl9 = lastExpressionCoercedToUnit = (unwrappedType5 != null ? TypeUtilsKt.isUnit(unwrappedType5) : false) || hasReturnWithoutExpression;
        if (!lastExpressionCoercedToUnit && lastExpressionArgument != null) {
            returnArgumentFound = true;
            ((Collection)returnArguments).add(lastExpressionArgument);
        }
        return new ReturnArgumentsAnalysisResult(new ReturnArgumentsInfo(returnArguments, lastExpressionArgument, lastExpressionCoercedToUnit, returnArgumentFound), (InferenceSession)builderInferenceSession, false, 4, null);
    }

    private final KtExpression getLastDeparentesizedExpression(PSIKotlinCallArgument psiCallArgument) {
        Object object;
        if (psiCallArgument instanceof LambdaKotlinCallArgumentImpl) {
            Object object2 = ((LambdaKotlinCallArgumentImpl)psiCallArgument).getKtLambdaExpression().getBodyExpression();
            object = object2 != null && (object2 = object2.getStatements()) != null ? (KtExpression)CollectionsKt.lastOrNull((List)object2) : null;
        } else {
            Intrinsics.checkNotNull((Object)psiCallArgument, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.tower.FunctionExpressionImpl");
            KtExpression ktExpression = ((FunctionExpressionImpl)psiCallArgument).getKtFunction().getBodyExpression();
            object = ktExpression != null ? KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)ktExpression) : null;
        }
        KtExpression lastExpression = object;
        return KtPsiUtil.deparenthesize((KtExpression)lastExpression);
    }

    @Override
    public void bindStubResolvedCallForCandidate(@NotNull ResolvedCallAtom candidate) {
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        this.kotlinToResolvedCallTransformer.createStubResolvedCallAndWriteItToTrace(candidate, this.trace, CollectionsKt.emptyList(), null);
    }

    @Override
    public boolean isCompileTimeConstant(@NotNull ResolvedCallAtom resolvedAtom, @NotNull UnwrappedType expectedType) {
        Intrinsics.checkNotNullParameter((Object)resolvedAtom, (String)"resolvedAtom");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        CallableDescriptor descriptor = resolvedAtom.getCandidateDescriptor();
        if (!KotlinBuiltIns.isUnderKotlinPackage(descriptor)) {
            return false;
        }
        KotlinType kotlinType = descriptor.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType returnType = kotlinType;
        if (!KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType(returnType) || !KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType(expectedType)) {
            return false;
        }
        KtElement ktElement = PSIKotlinCallsKt.getPsiKotlinCall(resolvedAtom.getAtom()).getPsiCall().getCallElement();
        KtExpression ktExpression = ktElement instanceof KtExpression ? (KtExpression)ktElement : null;
        if (ktExpression == null) {
            return false;
        }
        KtExpression callElement = ktExpression;
        KtExpression expression2 = this.findCommonParent(callElement, PSIKotlinCallsKt.getPsiKotlinCall(resolvedAtom.getAtom()).getExplicitReceiver());
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(this.trace, "Trace to check if some expression is constant, we have to avoid writing probably wrong COMPILE_TIME_VALUE slice");
        Intrinsics.checkNotNullExpressionValue((Object)temporaryBindingTrace, (String)"create(...)");
        TemporaryBindingTrace temporaryBindingTrace2 = temporaryBindingTrace;
        return this.constantExpressionEvaluator.evaluateExpression(expression2, temporaryBindingTrace2, expectedType) != null;
    }

    private final KtExpression findCommonParent(KtExpression callElement, ReceiverKotlinCallArgument receiver) {
        if (receiver == null) {
            return callElement;
        }
        PsiElement[] psiElementArray = new PsiElement[]{callElement, NewCallArgumentsKt.getPsiExpression(receiver)};
        PsiElement psiElement = PsiTreeUtil.findCommonParent((PsiElement[])psiElementArray);
        KtExpression ktExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
        if (ktExpression == null) {
            ktExpression = callElement;
        }
        return ktExpression;
    }

    @Override
    @Nullable
    public UnwrappedType getExpectedTypeFromAsExpressionAndRecordItInTrace(@NotNull ResolvedCallAtom resolvedAtom) {
        IElementType iElementType;
        Intrinsics.checkNotNullParameter((Object)resolvedAtom, (String)"resolvedAtom");
        CallableDescriptor callableDescriptor = resolvedAtom.getCandidateDescriptor();
        FunctionDescriptor functionDescriptor = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
        if (functionDescriptor == null) {
            return null;
        }
        FunctionDescriptor candidateDescriptor = functionDescriptor;
        KotlinCall kotlinCall = resolvedAtom.getAtom();
        Object object = kotlinCall instanceof PSIKotlinCall ? (PSIKotlinCall)kotlinCall : null;
        if (object == null || (object = ((PSIKotlinCall)object).getPsiCall()) == null) {
            return null;
        }
        Object call2 = object;
        if (call2.getTypeArgumentList() != null || !KtDescriptorUtilKt.isFunctionForExpectTypeFromCastFeature(candidateDescriptor)) {
            return null;
        }
        KtExpression ktExpression = call2.getCalleeExpression();
        if (ktExpression == null || (ktExpression = KtPsiUtilKt.getBinaryWithTypeParent((KtExpression)ktExpression)) == null) {
            return null;
        }
        KtExpression binaryParent = ktExpression;
        IElementType it = iElementType = binaryParent.getOperationReference().getReferencedNameElementType();
        boolean bl = false;
        Object object2 = Intrinsics.areEqual((Object)it, (Object)KtTokens.AS_KEYWORD) || Intrinsics.areEqual((Object)it, (Object)KtTokens.AS_SAFE) ? iElementType : null;
        if (object2 == null) {
            return null;
        }
        IElementType operationType = object2;
        KtTypeReference ktTypeReference = binaryParent.getRight();
        if (ktTypeReference == null) {
            return null;
        }
        KotlinType kotlinType = (KotlinType)this.trace.get(BindingContext.TYPE, ktTypeReference);
        if (kotlinType == null) {
            return null;
        }
        KotlinType leftType = kotlinType;
        KotlinType expectedType = Intrinsics.areEqual((Object)operationType, (Object)KtTokens.AS_SAFE) ? TypeUtilsKt.makeNullable(leftType) : leftType;
        UnwrappedType resultType = expectedType.unwrap();
        this.trace.record(BindingContext.CAST_TYPE_USED_AS_EXPECTED_TYPE, binaryParent);
        return resultType;
    }

    @Override
    public void disableContractsIfNecessary(@NotNull ResolvedCallAtom resolvedAtom) {
        Intrinsics.checkNotNullParameter((Object)resolvedAtom, (String)"resolvedAtom");
        KotlinCall kotlinCall = resolvedAtom.getAtom();
        PSIKotlinCall pSIKotlinCall = kotlinCall instanceof PSIKotlinCall ? (PSIKotlinCall)kotlinCall : null;
        if (pSIKotlinCall == null) {
            return;
        }
        PSIKotlinCall atom = pSIKotlinCall;
        Call call2 = atom.getPsiCall();
        CallableDescriptor callableDescriptor = resolvedAtom.getCandidateDescriptor();
        LexicalScope lexicalScope = this.topLevelCallContext.scope;
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"scope");
        RecursiveContractHelperKt.disableContractsInsideContractsBlock(call2, callableDescriptor, lexicalScope, this.trace);
    }

    @Override
    @Nullable
    public IntegerValueTypeConstant convertSignedConstantToUnsigned(@NotNull KotlinCallArgument argument) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        KtExpression ktExpression = NewCallArgumentsKt.getPsiExpression(argument);
        if (ktExpression == null) {
            return null;
        }
        KtExpression argumentExpression = ktExpression;
        return this.convertSignedConstantToUnsigned(argumentExpression);
    }

    @Override
    public void recordInlinabilityOfLambda(@NotNull Set<? extends Map.Entry<? extends SimpleResolutionCandidate, ResolvedLambdaAtom>> atom) {
        boolean bl;
        KtLambdaExpression literal;
        block7: {
            Intrinsics.checkNotNullParameter(atom, (String)"atom");
            ValueArgument valueArgument = NewCallArgumentsKt.getPsiCallArgument(((ResolvedLambdaAtom)((Map.Entry)CollectionsKt.first((Iterable)atom)).getValue()).getAtom()).getValueArgument();
            KtLambdaArgument ktLambdaArgument = valueArgument instanceof KtLambdaArgument ? (KtLambdaArgument)valueArgument : null;
            if (ktLambdaArgument == null) {
                return;
            }
            KtLambdaArgument call2 = ktLambdaArgument;
            KtLambdaExpression ktLambdaExpression = call2.getLambdaExpression();
            if (ktLambdaExpression == null || (ktLambdaExpression = ktLambdaExpression.getFunctionLiteral()) == null) {
                return;
            }
            literal = ktLambdaExpression;
            Iterable $this$all$iv = atom;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ValueParameterDescriptor valueParameterDescriptor;
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    SimpleResolutionCandidate candidate = (SimpleResolutionCandidate)entry.getKey();
                    ResolvedLambdaAtom atom2 = (ResolvedLambdaAtom)entry.getValue();
                    if (!InlineUtil.isInline(candidate.getResolvedCall().getCandidateDescriptor())) {
                        return;
                    }
                    if (candidate.getResolvedCall().getArgumentToCandidateParameter().get(atom2.getAtom()) == null) {
                        return;
                    }
                    if (InlineUtil.isInlineParameter(valueParameterDescriptor)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        Boolean bl3 = bl;
        boolean it = bl3;
        boolean bl4 = false;
        Boolean isLambdaInline = it ? bl3 : null;
        this.trace.record(BindingContext.NEW_INFERENCE_IS_LAMBDA_FOR_OVERLOAD_RESOLUTION_INLINE, literal, isLambdaInline);
    }

    @Override
    @NotNull
    public LHSResult getLhsResult(@NotNull KotlinCall call2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        KtCallableReferenceExpression ktCallableReferenceExpression = CallUtilKt.extractCallableReferenceExpression(call2);
        if (ktCallableReferenceExpression == null) {
            throw new IllegalStateException("Not a callable reference");
        }
        KtCallableReferenceExpression callableReferenceExpression = ktCallableReferenceExpression;
        LHSResult lhsResult = (LHSResult)this.psiCallResolver.getLhsResult(this.topLevelCallContext, callableReferenceExpression).component2();
        return lhsResult;
    }

    private final IntegerValueTypeConstant convertSignedConstantToUnsigned(KtExpression expression2) {
        CompileTimeConstant constant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression2);
        if (!(constant instanceof IntegerValueTypeConstant) || !this.constantCanBeConvertedToUnsigned(constant)) {
            return null;
        }
        IntegerValueTypeConstant.Companion $this$convertSignedConstantToUnsigned_u24lambda_u2411 = IntegerValueTypeConstant.Companion;
        boolean bl = false;
        return $this$convertSignedConstantToUnsigned_u24lambda_u2411.convertToUnsignedConstant((IntegerValueTypeConstant)constant, this.moduleDescriptor);
    }

    private final boolean constantCanBeConvertedToUnsigned(CompileTimeConstant<?> constant) {
        return !constant.isError() && constant.getParameters().isPure();
    }

    private static final PSIKotlinCallArgument analyzeAndGetLambdaReturnArguments$createCallArgument(BasicCallResolutionContext outerCallContext, KotlinResolutionCallbacksImpl this$0, KtExpression ktExpression, KotlinTypeInfo typeInfo, LexicalScope scope, BindingTrace newTrace) {
        PSIKotlinCallArgument pSIKotlinCallArgument;
        KtExpression deparenthesizedExpression;
        BasicCallResolutionContext newContext = outerCallContext;
        if (scope != null) {
            newContext = (BasicCallResolutionContext)newContext.replaceScope(scope);
        }
        if (newTrace != null) {
            newContext = (BasicCallResolutionContext)newContext.replaceBindingTrace(newTrace);
        }
        DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
        ValueArgument valueArgument = CallMaker.makeExternalValueArgument(ktExpression);
        Intrinsics.checkNotNullExpressionValue((Object)valueArgument, (String)"makeExternalValueArgument(...)");
        PSIKotlinCallArgument pSIKotlinCallArgument2 = NewCallArgumentsKt.processFunctionalExpression(newContext, ktExpression, dataFlowInfo, valueArgument, null, DescriptorUtilsKt.getBuiltIns(outerCallContext.scope.getOwnerDescriptor()), this$0.typeResolver);
        if (pSIKotlinCallArgument2 != null) {
            PSIKotlinCallArgument it = pSIKotlinCallArgument2;
            boolean bl = false;
            NewCallArgumentsKt.setResultDataFlowInfoIfRelevant(it, typeInfo.getDataFlowInfo());
            return it;
        }
        KtExpression ktExpression2 = KtPsiUtil.deparenthesize((KtExpression)ktExpression);
        if (ktExpression2 == null) {
            ktExpression2 = ktExpression;
        }
        if ((deparenthesizedExpression = ktExpression2) instanceof KtCallableReferenceExpression) {
            PSICallResolver pSICallResolver = this$0.psiCallResolver;
            KtCallableReferenceExpression ktCallableReferenceExpression = (KtCallableReferenceExpression)deparenthesizedExpression;
            DataFlowInfo dataFlowInfo2 = DataFlowInfo.Companion.getEMPTY();
            ValueArgument valueArgument2 = CallMaker.makeExternalValueArgument(deparenthesizedExpression);
            Intrinsics.checkNotNullExpressionValue((Object)valueArgument2, (String)"makeExternalValueArgument(...)");
            TracingStrategy tracingStrategy = TracingStrategyImpl.create((KtReferenceExpression)((KtCallableReferenceExpression)deparenthesizedExpression).getCallableReference(), newContext.call);
            Intrinsics.checkNotNullExpressionValue((Object)tracingStrategy, (String)"create(...)");
            pSIKotlinCallArgument = pSICallResolver.createCallableReferenceKotlinCallArgument(newContext, ktCallableReferenceExpression, dataFlowInfo2, valueArgument2, null, outerCallContext, tracingStrategy);
        } else {
            BindingContext bindingContext = this$0.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            StatementFilter statementFilter = outerCallContext.statementFilter;
            Intrinsics.checkNotNullExpressionValue((Object)statementFilter, (String)"statementFilter");
            DeclarationDescriptor declarationDescriptor = outerCallContext.scope.getOwnerDescriptor();
            ValueArgument valueArgument3 = CallMaker.makeExternalValueArgument(ktExpression);
            Intrinsics.checkNotNullExpressionValue((Object)valueArgument3, (String)"makeExternalValueArgument(...)");
            DataFlowInfo dataFlowInfo3 = DataFlowInfo.Companion.getEMPTY();
            LanguageVersionSettings languageVersionSettings = this$0.languageVersionSettings;
            DataFlowValueFactory dataFlowValueFactory = this$0.dataFlowValueFactory;
            Call call2 = outerCallContext.call;
            Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"call");
            pSIKotlinCallArgument = NewCallArgumentsKt.createSimplePSICallArgument(bindingContext, statementFilter, declarationDescriptor, valueArgument3, dataFlowInfo3, typeInfo, languageVersionSettings, dataFlowValueFactory, call2);
        }
        return pSIKotlinCallArgument;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR=\u0010\f\u001a.\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e0\rj\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/KotlinResolutionCallbacksImpl$LambdaInfo;", "", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "contextDependency", "Lorg/jetbrains/kotlin/resolve/calls/context/ContextDependency;", "<init>", "(Lorg/jetbrains/kotlin/types/UnwrappedType;Lorg/jetbrains/kotlin/resolve/calls/context/ContextDependency;)V", "getExpectedType", "()Lorg/jetbrains/kotlin/types/UnwrappedType;", "getContextDependency", "()Lorg/jetbrains/kotlin/resolve/calls/context/ContextDependency;", "returnStatements", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "Lorg/jetbrains/kotlin/resolve/calls/tower/LambdaContextInfo;", "Lkotlin/collections/ArrayList;", "getReturnStatements", "()Ljava/util/ArrayList;", "lastExpressionInfo", "getLastExpressionInfo", "()Lorg/jetbrains/kotlin/resolve/calls/tower/LambdaContextInfo;", "Companion", "frontend"})
    public static final class LambdaInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final UnwrappedType expectedType;
        @NotNull
        private final ContextDependency contextDependency;
        @NotNull
        private final ArrayList<Pair<KtReturnExpression, LambdaContextInfo>> returnStatements;
        @NotNull
        private final LambdaContextInfo lastExpressionInfo;
        @NotNull
        private static final LambdaInfo STUB_EMPTY;

        public LambdaInfo(@NotNull UnwrappedType expectedType, @NotNull ContextDependency contextDependency) {
            Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
            Intrinsics.checkNotNullParameter((Object)((Object)contextDependency), (String)"contextDependency");
            this.expectedType = expectedType;
            this.contextDependency = contextDependency;
            this.returnStatements = new ArrayList();
            this.lastExpressionInfo = new LambdaContextInfo(null, null, null, null, 15, null);
        }

        @NotNull
        public final UnwrappedType getExpectedType() {
            return this.expectedType;
        }

        @NotNull
        public final ContextDependency getContextDependency() {
            return this.contextDependency;
        }

        @NotNull
        public final ArrayList<Pair<KtReturnExpression, LambdaContextInfo>> getReturnStatements() {
            return this.returnStatements;
        }

        @NotNull
        public final LambdaContextInfo getLastExpressionInfo() {
            return this.lastExpressionInfo;
        }

        static {
            SimpleType simpleType = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"NO_EXPECTED_TYPE");
            STUB_EMPTY = new LambdaInfo(simpleType, ContextDependency.INDEPENDENT);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/KotlinResolutionCallbacksImpl$LambdaInfo$Companion;", "", "<init>", "()V", "STUB_EMPTY", "Lorg/jetbrains/kotlin/resolve/calls/tower/KotlinResolutionCallbacksImpl$LambdaInfo;", "getSTUB_EMPTY", "()Lorg/jetbrains/kotlin/resolve/calls/tower/KotlinResolutionCallbacksImpl$LambdaInfo;", "frontend"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LambdaInfo getSTUB_EMPTY() {
                return STUB_EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

