/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;

public class GrModifierFix
extends ModCommandQuickFix {
    public static final Function<ProblemDescriptor, PsiModifierList> MODIFIER_LIST = descriptor -> {
        PsiElement element = descriptor.getPsiElement();
        assert (element instanceof PsiModifierList) : element;
        return (PsiModifierList)element;
    };
    public static final Function<ProblemDescriptor, PsiModifierList> MODIFIER_LIST_OWNER = descriptor -> {
        PsiElement element = descriptor.getPsiElement();
        assert (element instanceof PsiModifierListOwner) : element;
        return ((PsiModifierListOwner)element).getModifierList();
    };
    public static final Function<ProblemDescriptor, PsiModifierList> MODIFIER_LIST_CHILD = descriptor -> {
        PsiElement element = descriptor.getPsiElement().getParent();
        assert (element instanceof PsiModifierList) : element;
        return (PsiModifierList)element;
    };
    private final String myModifier;
    @IntentionName
    private final String myText;
    private final boolean myDoSet;
    private final Function<? super ProblemDescriptor, ? extends PsiModifierList> myModifierListProvider;

    public GrModifierFix(@NotNull GrVariable member, @GrModifier.GrModifierConstant String modifier, boolean doSet, @NotNull Function<? super ProblemDescriptor, ? extends PsiModifierList> modifierListProvider) {
        if (member == null) {
            GrModifierFix.$$$reportNull$$$0(0);
        }
        if (modifierListProvider == null) {
            GrModifierFix.$$$reportNull$$$0(1);
        }
        this(GrModifierFix.initText(doSet, member.getName(), modifier), modifier, doSet, modifierListProvider);
    }

    public GrModifierFix(@NotNull PsiMember member, @GrModifier.GrModifierConstant String modifier, boolean showContainingClass, boolean doSet, @NotNull Function<? super ProblemDescriptor, ? extends PsiModifierList> modifierListProvider) {
        if (member == null) {
            GrModifierFix.$$$reportNull$$$0(2);
        }
        if (modifierListProvider == null) {
            GrModifierFix.$$$reportNull$$$0(3);
        }
        this(GrModifierFix.initText(doSet, GrModifierFix.getMemberName(member, showContainingClass), modifier), modifier, doSet, modifierListProvider);
    }

    public GrModifierFix(@IntentionName @NotNull String text, @GrModifier.GrModifierConstant String modifier, boolean doSet, @NotNull Function<? super ProblemDescriptor, ? extends PsiModifierList> modifierListProvider) {
        if (text == null) {
            GrModifierFix.$$$reportNull$$$0(4);
        }
        if (modifierListProvider == null) {
            GrModifierFix.$$$reportNull$$$0(5);
        }
        this.myText = text;
        this.myModifier = modifier;
        this.myModifierListProvider = modifierListProvider;
        this.myDoSet = doSet;
    }

    @IntentionName
    public static String initText(boolean doSet, @NlsSafe @NotNull String name, @NlsSafe @NotNull String modifier) {
        if (name == null) {
            GrModifierFix.$$$reportNull$$$0(6);
        }
        if (modifier == null) {
            GrModifierFix.$$$reportNull$$$0(7);
        }
        return GroovyBundle.message(doSet ? "change.modifier" : "change.modifier.not", name, GrModifierFix.toPresentableText(modifier));
    }

    private static String getMemberName(PsiMember member, boolean showContainingClass) {
        if (showContainingClass) {
            PsiClass containingClass = member.getContainingClass();
            String containingClassName = containingClass != null ? containingClass.getName() + "." : "";
            return containingClassName + member.getName();
        }
        return member.getName();
    }

    public static String toPresentableText(String modifier) {
        return GroovyBundle.message(modifier + ".visibility.presentation", new Object[0]);
    }

    @NotNull
    public String getName() {
        String string = this.myText;
        if (string == null) {
            GrModifierFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("change.modifier.family.name", new Object[0]);
        if (string == null) {
            GrModifierFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            GrModifierFix.$$$reportNull$$$0(10);
        }
        if (descriptor == null) {
            GrModifierFix.$$$reportNull$$$0(11);
        }
        PsiModifierList modifierList = this.getModifierList(descriptor);
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)modifierList, m -> m.setModifierProperty(this.myModifier, this.myDoSet));
        if (modCommand == null) {
            GrModifierFix.$$$reportNull$$$0(12);
        }
        return modCommand;
    }

    private PsiModifierList getModifierList(ProblemDescriptor descriptor) {
        return (PsiModifierList)this.myModifierListProvider.fun((Object)descriptor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/bugs/GrModifierFix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/bugs/GrModifierFix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initText";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 12 -> new IllegalStateException(string);
        };
    }
}

