/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JComboBox;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JComboBoxCellReader;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.util.TextMatcher;

final class JComboBoxMatchingItemQuery {
    @RunsInEDT
    static int matchingItemIndex(@Nonnull JComboBox<?> comboBox, @Nonnull TextMatcher matcher2, @Nonnull JComboBoxCellReader cellReader) {
        Integer result = GuiActionRunner.execute(() -> {
            int itemCount = comboBox.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                String value = cellReader.valueAt(comboBox, i);
                if (value == null || !matcher2.isMatching(value)) continue;
                return i;
            }
            return -1;
        });
        return Preconditions.checkNotNull(result);
    }

    private JComboBoxMatchingItemQuery() {
    }
}

