/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.TransformEdit;

public class MoveHandle
extends LocatorHandle {
    private Point2D.Double oldPoint;

    public MoveHandle(Figure figure, Locator locator) {
        super(figure, locator);
    }

    public static void addMoveHandles(Figure figure, Collection<Handle> collection) {
        collection.add(MoveHandle.southEast(figure));
        collection.add(MoveHandle.southWest(figure));
        collection.add(MoveHandle.northEast(figure));
        collection.add(MoveHandle.northWest(figure));
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.getOwner().isTransformable()) {
            this.drawRectangle(graphics2D, this.getEditor().getHandleAttribute(HandleAttributeKeys.MOVE_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.MOVE_HANDLE_STROKE_COLOR));
        } else {
            this.drawRectangle(graphics2D, this.getEditor().getHandleAttribute(HandleAttributeKeys.NULL_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.NULL_HANDLE_STROKE_COLOR));
        }
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 13 : 0);
    }

    @Override
    public void trackStart(Point point, int n) {
        this.oldPoint = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(point));
    }

    @Override
    public void trackStep(Point point, Point point2, int n) {
        Figure figure = this.getOwner();
        if (figure.isTransformable()) {
            Point2D.Double double_ = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(point2));
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(double_.x - this.oldPoint.x, double_.y - this.oldPoint.y);
            figure.willChange();
            figure.transform(affineTransform);
            figure.changed();
            this.oldPoint = double_;
        }
    }

    @Override
    public void trackEnd(Point point, Point point2, int n) {
        if (this.getOwner().isTransformable()) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(point2.x - point.x, point2.y - point.y);
            this.fireUndoableEditHappened(new TransformEdit(this.getOwner(), affineTransform));
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Figure figure = this.getOwner();
        if (figure.isTransformable()) {
            AffineTransform affineTransform = new AffineTransform();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    affineTransform.translate(0.0, -1.0);
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    affineTransform.translate(0.0, 1.0);
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    affineTransform.translate(-1.0, 0.0);
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    affineTransform.translate(1.0, 0.0);
                    keyEvent.consume();
                }
            }
            figure.willChange();
            figure.transform(affineTransform);
            figure.changed();
            this.fireUndoableEditHappened(new TransformEdit(figure, affineTransform));
        }
    }

    public static Handle south(Figure figure) {
        return new MoveHandle(figure, RelativeLocator.south());
    }

    public static Handle southEast(Figure figure) {
        return new MoveHandle(figure, RelativeLocator.southEast());
    }

    public static Handle southWest(Figure figure) {
        return new MoveHandle(figure, RelativeLocator.southWest());
    }

    public static Handle north(Figure figure) {
        return new MoveHandle(figure, RelativeLocator.north());
    }

    public static Handle northEast(Figure figure) {
        return new MoveHandle(figure, RelativeLocator.northEast());
    }

    public static Handle northWest(Figure figure) {
        return new MoveHandle(figure, RelativeLocator.northWest());
    }

    public static Handle east(Figure figure) {
        return new MoveHandle(figure, RelativeLocator.east());
    }

    public static Handle west(Figure figure) {
        return new MoveHandle(figure, RelativeLocator.west());
    }
}

