/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.WorkloadType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OCPUs
extends ExplicitlySetBmcModel {
    @JsonProperty(value="totalCpu")
    private final Float totalCpu;
    @JsonProperty(value="consumedCpu")
    private final Float consumedCpu;
    @JsonProperty(value="byWorkloadType")
    private final WorkloadType byWorkloadType;

    @Deprecated
    @ConstructorProperties(value={"totalCpu", "consumedCpu", "byWorkloadType"})
    public OCPUs(Float totalCpu, Float consumedCpu, WorkloadType byWorkloadType) {
        this.totalCpu = totalCpu;
        this.consumedCpu = consumedCpu;
        this.byWorkloadType = byWorkloadType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Float getTotalCpu() {
        return this.totalCpu;
    }

    public Float getConsumedCpu() {
        return this.consumedCpu;
    }

    public WorkloadType getByWorkloadType() {
        return this.byWorkloadType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OCPUs(");
        sb.append("super=").append(super.toString());
        sb.append("totalCpu=").append(String.valueOf(this.totalCpu));
        sb.append(", consumedCpu=").append(String.valueOf(this.consumedCpu));
        sb.append(", byWorkloadType=").append(String.valueOf((Object)this.byWorkloadType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OCPUs)) {
            return false;
        }
        OCPUs other = (OCPUs)((Object)o);
        return Objects.equals(this.totalCpu, other.totalCpu) && Objects.equals(this.consumedCpu, other.consumedCpu) && Objects.equals((Object)this.byWorkloadType, (Object)other.byWorkloadType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.totalCpu == null ? 43 : this.totalCpu.hashCode());
        result = result * 59 + (this.consumedCpu == null ? 43 : this.consumedCpu.hashCode());
        result = result * 59 + (this.byWorkloadType == null ? 43 : this.byWorkloadType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="totalCpu")
        private Float totalCpu;
        @JsonProperty(value="consumedCpu")
        private Float consumedCpu;
        @JsonProperty(value="byWorkloadType")
        private WorkloadType byWorkloadType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder totalCpu(Float totalCpu) {
            this.totalCpu = totalCpu;
            this.__explicitlySet__.add("totalCpu");
            return this;
        }

        public Builder consumedCpu(Float consumedCpu) {
            this.consumedCpu = consumedCpu;
            this.__explicitlySet__.add("consumedCpu");
            return this;
        }

        public Builder byWorkloadType(WorkloadType byWorkloadType) {
            this.byWorkloadType = byWorkloadType;
            this.__explicitlySet__.add("byWorkloadType");
            return this;
        }

        public OCPUs build() {
            OCPUs model = new OCPUs(this.totalCpu, this.consumedCpu, this.byWorkloadType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OCPUs model) {
            if (model.wasPropertyExplicitlySet("totalCpu")) {
                this.totalCpu(model.getTotalCpu());
            }
            if (model.wasPropertyExplicitlySet("consumedCpu")) {
                this.consumedCpu(model.getConsumedCpu());
            }
            if (model.wasPropertyExplicitlySet("byWorkloadType")) {
                this.byWorkloadType(model.getByWorkloadType());
            }
            return this;
        }
    }
}

