/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl;

import org.apache.subversion.javahl.types.RuntimeVersion;
import org.apache.subversion.javahl.types.Version;

public class NativeResources {
    private static Version version;
    private static RuntimeVersion runtimeVersion;

    public static Version getVersion() {
        return version;
    }

    public static RuntimeVersion getRuntimeVersion() {
        return runtimeVersion;
    }

    public static synchronized void loadNativeLibrary() {
        String[] libraryNames;
        UnsatisfiedLinkError loadException = null;
        try {
            String specifiedLibraryName = System.getProperty("subversion.native.library");
            if (specifiedLibraryName != null) {
                System.load(specifiedLibraryName);
                NativeResources.init();
                return;
            }
        }
        catch (UnsatisfiedLinkError ex) {
            loadException = ex;
        }
        for (String libraryName : libraryNames = new String[]{"svnjavahl-1", "libsvnjavahl-1", "svnjavahl"}) {
            try {
                System.loadLibrary(libraryName);
                NativeResources.init();
                return;
            }
            catch (UnsatisfiedLinkError ex) {
                if (loadException != null) continue;
                loadException = ex;
            }
        }
        if (loadException == null) {
            loadException = new UnsatisfiedLinkError("Unable to load JavaHL native library");
        }
        throw loadException;
    }

    private static final void init() {
        boolean SVN_VER_MAJOR = true;
        int SVN_VER_MINOR = 12;
        NativeResources.initNativeLibrary();
        version = new Version();
        if (!version.isAtLeast(1, 12, 0)) {
            throw new LinkageError("Native library version must be at least 1.12.0,but is only " + version);
        }
        runtimeVersion = new RuntimeVersion();
        if (runtimeVersion.getMajor() < version.getMajor() || runtimeVersion.getMajor() == version.getMajor() && runtimeVersion.getMinor() < version.getMinor()) {
            throw new LinkageError("Compile-time Native library version is " + version + " but the run-time version is " + runtimeVersion);
        }
    }

    private static native void initNativeLibrary();
}

