/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.options;

import java.awt.Image;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.lsp.client.options.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class GenericDataObject
extends MultiDataObject {
    private static final Set<Reference<GenericDataObject>> REGISTRY = new HashSet<Reference<GenericDataObject>>();
    private static final Map<String, Image> mimeType2Icon = new HashMap<String, Image>();
    private final String mimeType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        this.mimeType = FileUtil.getMIMEType((FileObject)pf);
        this.registerEditor(this.mimeType, false);
        Set<Reference<GenericDataObject>> set = REGISTRY;
        synchronized (set) {
            REGISTRY.add(new WeakReference<GenericDataObject>(this));
        }
    }

    protected int associateLookup() {
        return 1;
    }

    protected Node createNodeDelegate() {
        DataNode node = new DataNode((DataObject)this, Children.LEAF, this.getLookup()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Image getIcon(int type) {
                Map<String, Image> map = mimeType2Icon;
                synchronized (map) {
                    return mimeType2Icon.computeIfAbsent(GenericDataObject.this.mimeType, mt -> {
                        FileObject iconFile = FileUtil.getConfigFile((String)("Loaders/" + GenericDataObject.this.mimeType + "/Factories/icon.png"));
                        return Utils.loadIcon(iconFile, type);
                    });
                }
            }

            public Image getOpenedIcon(int type) {
                return this.getIcon(type);
            }
        };
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidate() {
        HashSet<Reference<GenericDataObject>> regCopy;
        Map<String, Image> map = REGISTRY;
        synchronized (map) {
            regCopy = new HashSet<Reference<GenericDataObject>>(REGISTRY);
        }
        for (Reference reference : regCopy) {
            GenericDataObject god = (GenericDataObject)((Object)reference.get());
            if (god == null) continue;
            try {
                god.setValid(false);
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        map = mimeType2Icon;
        synchronized (map) {
            mimeType2Icon.clear();
        }
    }

    public static DataObject.Factory factory() {
        return (fo, recognized) -> {
            MultiFileLoader defaultLoader;
            try {
                Method getDefaultFileLoader = DataLoaderPool.class.getDeclaredMethod("getDefaultFileLoader", new Class[0]);
                getDefaultFileLoader.setAccessible(true);
                defaultLoader = (MultiFileLoader)getDefaultFileLoader.invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
            try {
                return new GenericDataObject(fo, defaultLoader);
            }
            catch (DataObjectExistsException ex) {
                try {
                    if (ex.getDataObject() instanceof GenericDataObject) {
                        throw ex;
                    }
                    ex.getDataObject().setValid(false);
                }
                catch (PropertyVetoException ex1) {
                    Exceptions.printStackTrace((Throwable)ex1);
                    return null;
                }
                return new GenericDataObject(fo, defaultLoader);
            }
        };
    }
}

