/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cpplite.editor.Utils;
import org.netbeans.modules.cpplite.editor.lsp.LanguageServerImpl;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class UnconfiguredHint
implements Runnable {
    private static final Set<String> C_MIME_TYPES = new HashSet<String>(Arrays.asList("text/X-c", "text/X-c++", "text/X-h", "text/X-h++"));
    private JTextComponent selectedComponent;

    @Override
    public void run() {
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                UnconfiguredHint.this.updateFocused();
            }
        });
        Utils.settings().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                UnconfiguredHint.this.updateFocused();
            }
        });
        this.updateFocused();
    }

    private synchronized void updateFocused() {
        this.selectedComponent = EditorRegistry.focusedComponent();
        if (this.selectedComponent == null) {
            return;
        }
        Document doc = this.selectedComponent.getDocument();
        FileObject file = NbEditorUtilities.getFileObject((Document)doc);
        if (file == null || !C_MIME_TYPES.contains(FileUtil.getMIMEType((FileObject)file))) {
            return;
        }
        ArrayList<ErrorDescription> errors = new ArrayList<ErrorDescription>();
        String ccls = Utils.getCCLSPath();
        String clangd = Utils.getCLANGDPath();
        if (!(ccls != null && new File(ccls).canExecute() || clangd != null && new File(clangd).canExecute())) {
            errors.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.WARNING, (String)"Neither ccls nor clangd configured!", Collections.singletonList(new ConfigureCCLS()), (Document)doc, (int)0));
        } else {
            Project prj = FileOwnerQuery.getOwner((FileObject)file);
            if (prj != null && LanguageServerImpl.getCompileCommandsDir(prj) == null) {
                errors.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.WARNING, (String)"compile commands not configured", (Document)doc, (int)0));
            }
        }
        HintsController.setErrors((Document)doc, (String)UnconfiguredHint.class.getName(), errors);
    }

    private static final class ConfigureCCLS
    implements Fix {
        private ConfigureCCLS() {
        }

        public String getText() {
            return "Configure ccls";
        }

        public ChangeInfo implement() throws Exception {
            OptionsDisplayer.getDefault().open("CPlusPlus/cpplite");
            return null;
        }
    }
}

