/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.ui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.List;
import org.netbeans.modules.javascript2.debug.ui.TextLineHandler;
import org.netbeans.modules.javascript2.debug.ui.editor.FutureLine;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

public class LineDelegate
implements TextLineHandler {
    private Line line;
    private final PropertyChangeSupport pchs = new PropertyChangeSupport(this);
    private final LineChangesListener lineChangeslistener = new LineChangesListener();
    private PropertyChangeListener lineChangesWeak;

    public LineDelegate(Line line) {
        this.line = line;
        this.lineChangesWeak = WeakListeners.propertyChange((PropertyChangeListener)this.lineChangeslistener, (Object)line);
        line.addPropertyChangeListener(this.lineChangesWeak);
    }

    @Override
    public Line getLine() {
        return this.line;
    }

    public FileObject getFileObject() {
        if (this.line instanceof FutureLine) {
            URL url = this.getURL();
            FileObject fo = URLMapper.findFileObject((URL)url);
            if (fo != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    LineCookie lineCookie = (LineCookie)dobj.getLookup().lookup(LineCookie.class);
                    if (lineCookie == null) {
                        return null;
                    }
                    Line l = lineCookie.getLineSet().getCurrent(this.getLineNumber() - 1);
                    this.setLine(l);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            return fo;
        }
        return (FileObject)this.line.getLookup().lookup(FileObject.class);
    }

    public URL getURL() {
        if (this.line instanceof FutureLine) {
            return ((FutureLine)this.line).getURL();
        }
        return ((FileObject)this.line.getLookup().lookup(FileObject.class)).toURL();
    }

    public int getLineNumber() {
        return this.line.getLineNumber() + 1;
    }

    public void setLineNumber(int lineNumber) {
        Line cline;
        int lastLineNumber;
        if (this.line.getLineNumber() == --lineNumber) {
            return;
        }
        LineCookie lineCookie = (LineCookie)this.line.getLookup().lookup(LineCookie.class);
        Line.Set lineSet = lineCookie.getLineSet();
        List lines = lineSet.getLines();
        if (lines.size() > 0 && lineNumber > (lastLineNumber = ((Line)lines.get(lines.size() - 1)).getLineNumber())) {
            lineNumber = lastLineNumber;
        }
        try {
            cline = lineSet.getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException ioobex) {
            cline = lineSet.getCurrent(0);
        }
        this.setLine(cline);
    }

    private void setLine(Line line) {
        this.dispose();
        int oldLineNumber = this.getLineNumber();
        this.line = line;
        this.lineChangesWeak = WeakListeners.propertyChange((PropertyChangeListener)this.lineChangeslistener, (Object)line);
        line.addPropertyChangeListener(this.lineChangesWeak);
        this.pchs.firePropertyChange("lineNumber", oldLineNumber, this.getLineNumber());
    }

    public void dispose() {
        this.line.removePropertyChangeListener(this.lineChangesWeak);
        this.lineChangesWeak = null;
    }

    public void addPropertyChangeListener(PropertyChangeListener pchl) {
        this.pchs.addPropertyChangeListener(pchl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pchl) {
        this.pchs.removePropertyChangeListener(pchl);
    }

    private class LineChangesListener
    implements PropertyChangeListener {
        private LineChangesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("lineNumber".equals(evt.getPropertyName())) {
                LineDelegate.this.pchs.firePropertyChange("lineNumber", evt.getOldValue(), evt.getNewValue());
            }
        }
    }
}

