/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PlacementConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="faultDomain")
    private final List<String> faultDomain;
    @JsonProperty(value="subnetId")
    private final String subnetId;

    @Deprecated
    @ConstructorProperties(value={"availabilityDomain", "faultDomain", "subnetId"})
    public PlacementConfiguration(String availabilityDomain, List<String> faultDomain, String subnetId) {
        this.availabilityDomain = availabilityDomain;
        this.faultDomain = faultDomain;
        this.subnetId = subnetId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public List<String> getFaultDomain() {
        return this.faultDomain;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PlacementConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", faultDomain=").append(String.valueOf(this.faultDomain));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlacementConfiguration)) {
            return false;
        }
        PlacementConfiguration other = (PlacementConfiguration)((Object)o);
        return Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.faultDomain, other.faultDomain) && Objects.equals(this.subnetId, other.subnetId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.faultDomain == null ? 43 : this.faultDomain.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="faultDomain")
        private List<String> faultDomain;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder faultDomain(List<String> faultDomain) {
            this.faultDomain = faultDomain;
            this.__explicitlySet__.add("faultDomain");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public PlacementConfiguration build() {
            PlacementConfiguration model = new PlacementConfiguration(this.availabilityDomain, this.faultDomain, this.subnetId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PlacementConfiguration model) {
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("faultDomain")) {
                this.faultDomain(model.getFaultDomain());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            return this;
        }
    }
}

