/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.WizardUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.project.NewProjectIterator;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class SelectProjectPanel
extends BasicWizardIterator.Panel {
    private NewProjectIterator.DataModel data;
    private final Object EMPTY = SelectProjectPanel.getMessage("MSG_No_Projects");
    private JButton btnProject;
    private JComboBox comProject;
    private JLabel lblProject;
    private JPanel pnlHeightAdjuster;

    public SelectProjectPanel(WizardDescriptor setting, NewProjectIterator.DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccessibility();
        this.putClientProperty("NewFileWizard_Title", SelectProjectPanel.getMessage("LBL_ProjectWizardTitle"));
        this.loadComboBox();
        this.comProject.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectProjectPanel.this.checkValidity();
            }
        });
        this.comProject.setRenderer(WizardUtils.createProjectRenderer());
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(SelectProjectPanel.class, (String)key);
    }

    private void initComponents() {
        this.lblProject = new JLabel();
        this.comProject = new JComboBox();
        this.btnProject = new JButton();
        this.pnlHeightAdjuster = new JPanel();
        this.setLayout(new GridBagLayout());
        this.lblProject.setLabelFor(this.comProject);
        Mnemonics.setLocalizedText((JLabel)this.lblProject, (String)NbBundle.getMessage(SelectProjectPanel.class, (String)"LBL_Project_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add(this.lblProject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add(this.comProject, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnProject, (String)NbBundle.getMessage(SelectProjectPanel.class, (String)"LBL_Browse"));
        this.btnProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectProjectPanel.this.btnProjectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add(this.btnProject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        this.add(this.pnlHeightAdjuster, gridBagConstraints);
    }

    private void btnProjectActionPerformed(ActionEvent evt) {
        File fil;
        FileObject fo;
        JFileChooser chooser = ProjectChooser.projectChooser();
        int res = chooser.showOpenDialog(SwingUtilities.getWindowAncestor((Component)((Object)this)));
        if (res == 0 && (fo = FileUtil.toFileObject((File)(fil = chooser.getSelectedFile()))) != null) {
            try {
                Project p = ProjectManager.getDefault().findProject(fo);
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.comProject.getModel();
                model.addElement(p);
                model.setSelectedItem(p);
                if (this.EMPTY == model.getElementAt(0)) {
                    model.removeElement(this.EMPTY);
                }
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
        }
    }

    @Override
    protected void storeToDataModel() {
        this.data.setTemplate((Project)this.comProject.getSelectedItem());
    }

    @Override
    protected void readFromDataModel() {
        this.checkValidity();
    }

    private void loadComboBox() {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
        Project[] prjs = OpenProjects.getDefault().getOpenProjects();
        Arrays.sort(prjs, Util.projectDisplayNameComparator());
        for (int i = 0; i < prjs.length; ++i) {
            if (prjs[i] == this.data.getProject()) continue;
            model.addElement(prjs[i]);
        }
        if (model.getSize() == 0) {
            model.addElement(this.EMPTY);
        }
        this.comProject.setModel(model);
    }

    private void checkValidity() {
        Object sel = this.comProject.getModel().getSelectedItem();
        if (sel == this.EMPTY) {
            this.setError(SelectProjectPanel.getMessage("MSG_NoProjectSelected"));
            return;
        }
        Sources srcs = ProjectUtils.getSources((Project)((Project)sel));
        if (srcs.getSourceGroups("generic").length > 1) {
            this.setError(SelectProjectPanel.getMessage("MSG_NoExternalRoots"));
            return;
        }
        this.markValid();
    }

    @Override
    protected String getPanelName() {
        return SelectProjectPanel.getMessage("LBL_ProjectSelection_Title");
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(SelectProjectPanel.class);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(SelectProjectPanel.getMessage("ACS_SelectProjectPanel"));
        this.btnProject.getAccessibleContext().setAccessibleDescription(SelectProjectPanel.getMessage("ACS_CTL_btnProject"));
        this.comProject.getAccessibleContext().setAccessibleDescription(SelectProjectPanel.getMessage("ACS_CTL_comProject"));
    }
}

