/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.IssueQuickSearch;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.ui.repository.RepositoryComboSupport;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchComboBar;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class QuickSearchPanel
extends JPanel
implements ItemListener,
ChangeListener {
    private final QuickSearchComboBar qs;
    private ChangeListener listener;
    private final FileObject referenceFile;
    private final JButton newButton;
    private JLabel issueLabel;
    private JPanel issuePanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    final JComboBox repositoryComboBox = new JComboBox();
    private JLabel repositoryLabel;

    public QuickSearchPanel(FileObject referenceFile, IssueQuickSearch.RepositoryFilter filter) {
        this.initComponents();
        this.newButton = this.createNewRepoButton();
        ((GroupLayout)this.getLayout()).replace(this.jLabel1, this.newButton);
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickSearchPanel.this.onNewRepo();
            }
        });
        this.referenceFile = referenceFile;
        this.qs = new QuickSearchComboBar(this);
        this.issuePanel.add((Component)this.qs, "North");
        this.issueLabel.setLabelFor(this.qs);
        if (referenceFile != null) {
            RepositoryComboSupport.setup((JComponent)this, this.repositoryComboBox, filter, referenceFile);
        } else {
            RepositoryComboSupport.setup((JComponent)this, this.repositoryComboBox, filter, false);
        }
        this.repositoryComboBox.addItemListener(this);
    }

    public Issue getIssue() {
        Issue issue = this.qs.getIssue();
        Repository selectedRepository = this.getSelectedRepository();
        if (issue != null && selectedRepository != null) {
            if (this.referenceFile != null) {
                BugtrackingOwnerSupport.getInstance().setFirmAssociations(new FileObject[]{this.referenceFile}, APIAccessor.IMPL.getImpl(selectedRepository));
            } else {
                BugtrackingOwnerSupport.getInstance().setLooseAssociation(BugtrackingOwnerSupport.ContextType.MAIN_PROJECT_ONLY, APIAccessor.IMPL.getImpl(selectedRepository));
            }
        }
        return issue;
    }

    public void setIssue(IssueImpl impl) {
        this.qs.setIssue(impl);
    }

    private void initComponents() {
        this.repositoryLabel = new JLabel();
        this.issueLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.issuePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.repositoryLabel.setLabelFor(this.repositoryComboBox);
        Mnemonics.setLocalizedText((JLabel)this.repositoryLabel, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.repositoryLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.issueLabel, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.issueLabel.text"));
        this.jLabel2.setForeground(UIManager.getDefaults().getColor("Label.disabledForeground"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.jLabel2.text"));
        this.issuePanel.setLayout(new BorderLayout());
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.issuePanel, -1, 477, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.issuePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2)));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.jLabel1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.repositoryLabel).addComponent(this.issueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.repositoryComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addContainerGap()).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.repositoryLabel).addComponent(this.repositoryComboBox, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.issueLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.repositoryComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.repositoryComboBox.AccessibleContext.accessibleDescription"));
    }

    private void onNewRepo() {
        RepositoryImpl repoImpl = BugtrackingUtil.createRepository();
        if (repoImpl == null) {
            return;
        }
        Repository repo = repoImpl.getRepository();
        this.repositoryComboBox.addItem(repo);
        this.repositoryComboBox.setSelectedItem(repo);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object item;
        if (this.repositoryComboBox.isEnabled()) {
            this.enableFields();
        }
        if (e.getStateChange() == 1 && (item = e.getItem()) instanceof Repository) {
            Repository repo = (Repository)item;
            this.qs.setRepository(repo);
        }
    }

    @Override
    public void addNotify() {
        this.qs.addChangeListener(this);
        this.qs.addChangeListener(this.listener);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.qs.removeChangeListener(this);
        this.qs.removeChangeListener(this.listener);
        super.removeNotify();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.enableFields();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enableFields(enabled);
        this.repositoryLabel.setEnabled(enabled);
        this.repositoryComboBox.setEnabled(enabled);
        this.newButton.setEnabled(enabled);
    }

    public void setChangeListener(ChangeListener listener) {
        this.listener = listener;
        this.qs.addChangeListener(listener);
    }

    private void enableFields() {
        this.enableFields(true);
    }

    public void enableFields(boolean enable) {
        boolean repoSelected = this.repositoryComboBox.getSelectedItem() instanceof Repository;
        this.issueLabel.setEnabled(repoSelected && enable);
        this.qs.enableFields(repoSelected && enable);
    }

    public Repository getSelectedRepository() {
        Object obj = this.repositoryComboBox.getSelectedItem();
        return obj instanceof Repository ? (Repository)obj : null;
    }

    public void setRepository(Repository repository) {
        this.repositoryComboBox.setSelectedItem(repository);
    }

    private JButton createNewRepoButton() {
        class DoubleWidthButton
        extends JButton {
            DoubleWidthButton() {
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension defPrefSize = super.getPreferredSize();
                return new Dimension((int)(1.8f * (float)defPrefSize.width), defPrefSize.height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        }
        DoubleWidthButton bt = new DoubleWidthButton();
        Mnemonics.setLocalizedText((AbstractButton)bt, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.newButton.text"));
        return bt;
    }
}

