/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.Document;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.hints.pom.Bundle;
import org.netbeans.modules.maven.hints.pom.PomModelUtils;
import org.netbeans.modules.maven.hints.pom.UpdateDependencyHintCustomizer;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.BuildBase;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.DependencyManagement;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMQName;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginManagement;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.modules.maven.model.pom.ReportPlugin;
import org.netbeans.modules.maven.model.pom.Reporting;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;

public class UpdateDependencyHint
implements POMErrorFixProvider {
    private static final Configuration config = new Configuration(UpdateDependencyHint.class.getSimpleName(), Bundle.TIT_UpdateDependencyHint(), Bundle.DESC_UpdateDependencyHint(), true, Configuration.HintSeverity.WARNING);
    static final String KEY_NO_MAJOR_UPGRADE = "no_major_upgrade";
    private boolean noMajorUpgrde;
    private UpdateDependencyHintCustomizer customizer;

    @Override
    public List<ErrorDescription> getErrorsForDocument(POMModel model, Project prj) {
        List profiles;
        Reporting reporting;
        this.noMajorUpgrde = UpdateDependencyHint.getNoMajorUpgradeOption();
        HashMap<POMComponent, ErrorDescription> hints = new HashMap<POMComponent, ErrorDescription>();
        org.netbeans.modules.maven.model.pom.Project project = model.getProject();
        this.addHintsToDependencies(project.getDependencies(), project.getDependencyManagement(), hints);
        Build build = project.getBuild();
        if (build != null) {
            this.addHintsToPlugins(build.getPlugins(), build.getPluginManagement(), hints);
        }
        if ((reporting = project.getReporting()) != null && reporting.getReportPlugins() != null) {
            this.addHintsTo(reporting.getReportPlugins(), hints);
        }
        if ((profiles = project.getProfiles()) != null) {
            for (Profile profile : profiles) {
                this.addHintsToDependencies(profile.getDependencies(), profile.getDependencyManagement(), hints);
                BuildBase base = profile.getBuildBase();
                if (base == null) continue;
                this.addHintsToPlugins(base.getPlugins(), base.getPluginManagement(), hints);
            }
        }
        return new ArrayList<ErrorDescription>(hints.values());
    }

    private void addHintsToDependencies(List<Dependency> deps, DependencyManagement depman, Map<POMComponent, ErrorDescription> hints) {
        if (deps != null) {
            this.addHintsTo(deps, hints);
        }
        if (depman != null && depman.getDependencies() != null) {
            this.addHintsTo(depman.getDependencies(), hints);
        }
    }

    private void addHintsToPlugins(List<Plugin> plugins, PluginManagement plugman, Map<POMComponent, ErrorDescription> hints) {
        if (plugins != null) {
            this.addHintsTo(plugins, hints);
        }
        if (plugman != null && plugman.getPlugins() != null) {
            this.addHintsTo(plugman.getPlugins(), hints);
        }
    }

    private void addHintsTo(List<? extends POMComponent> components, Map<POMComponent, ErrorDescription> hints) {
        for (POMComponent pOMComponent : components) {
            record HintCandidate(String version, POMExtensibilityElement component) {
            }
            Object object;
            Plugin plugin;
            String groupId = UpdateDependencyHint.getTextOrNull(pOMComponent, pOMComponent.getModel().getPOMQNames().GROUPID);
            String artifactId = UpdateDependencyHint.getTextOrNull(pOMComponent, pOMComponent.getModel().getPOMQNames().ARTIFACTID);
            String version = UpdateDependencyHint.getTextOrNull(pOMComponent, pOMComponent.getModel().getPOMQNames().VERSION);
            if (groupId == null && (pOMComponent instanceof Plugin || pOMComponent instanceof ReportPlugin)) {
                groupId = "org.apache.maven.plugins";
            }
            if ("org.apache.maven.plugins".equals(groupId) && "maven-compiler-plugin".equals(artifactId) && pOMComponent instanceof Plugin && (plugin = (Plugin)pOMComponent).getConfiguration() != null && (object = PomModelUtils.getFirstChild((POMComponent)plugin.getConfiguration(), "annotationProcessorPaths")) instanceof POMExtensibilityElement) {
                POMExtensibilityElement procs = (POMExtensibilityElement)object;
                this.addHintsTo(procs.getExtensibilityElements(), hints);
            }
            if (artifactId == null || groupId == null || version == null) continue;
            List<Object> candidates = List.of();
            if (PomModelUtils.isPropertyExpression(version)) {
                List profiles;
                Object object2;
                candidates = new ArrayList();
                String propName = PomModelUtils.getPropertyName(version);
                Properties props = pOMComponent.getModel().getProject().getProperties();
                if (props != null && (object2 = PomModelUtils.getFirstChild((POMComponent)props, propName)) instanceof POMExtensibilityElement) {
                    POMExtensibilityElement e = (POMExtensibilityElement)object2;
                    candidates.add(new HintCandidate(props.getProperty(propName), e));
                }
                if ((profiles = pOMComponent.getModel().getProject().getProfiles()) != null) {
                    object2 = profiles.iterator();
                    while (object2.hasNext()) {
                        POMComponent pOMComponent2;
                        Profile profile = (Profile)object2.next();
                        Properties profProps = profile.getProperties();
                        if (profProps == null || !((pOMComponent2 = PomModelUtils.getFirstChild((POMComponent)profProps, propName)) instanceof POMExtensibilityElement)) continue;
                        POMExtensibilityElement e = (POMExtensibilityElement)pOMComponent2;
                        candidates.add(new HintCandidate(profProps.getProperty(propName), e));
                    }
                }
            } else {
                object = PomModelUtils.getFirstChild(pOMComponent, "version");
                if (object instanceof POMExtensibilityElement) {
                    POMExtensibilityElement e = (POMExtensibilityElement)object;
                    candidates = List.of(new HintCandidate(version, e));
                }
            }
            if (candidates.isEmpty()) continue;
            List versions = RepositoryQueries.getVersionsResult((String)groupId, (String)artifactId, null).getResults();
            object = candidates.iterator();
            while (object.hasNext()) {
                ErrorDescription previous;
                String requiredPrefix;
                HintCandidate candidate = (HintCandidate)object.next();
                boolean allow_qualifier = !UpdateDependencyHint.isNumerical(candidate.version);
                boolean allow_timestamp = !UpdateDependencyHint.noTimestamp(candidate.version);
                String string = requiredPrefix = this.noMajorUpgrde ? UpdateDependencyHint.getMajorComponentPrefix(candidate.version) : "";
                Optional<ComparableVersion> latest = versions.stream().map(NBVersionInfo::getVersion).filter(v -> !v.isEmpty() && v.startsWith(requiredPrefix)).filter(v -> allow_qualifier || !Character.isDigit(v.charAt(0)) || UpdateDependencyHint.isNumerical(v)).filter(v -> allow_timestamp || !Character.isDigit(v.charAt(0)) || UpdateDependencyHint.noTimestamp(v)).map(ComparableVersion::new).max(ComparableVersion::compareTo);
                if (!latest.isPresent() || latest.get().compareTo(new ComparableVersion(candidate.version)) <= 0 || (previous = hints.get(candidate.component)) != null && UpdateDependencyHint.compare(((UpdateVersionFix)previous.getFixes().getFixes().get((int)0)).version, candidate.version) <= 0) continue;
                hints.put((POMComponent)candidate.component, this.createHintForComponent(candidate.component, latest.get().toString()));
            }
        }
    }

    private static String getTextOrNull(POMComponent comp, POMQName name) {
        String text = comp.getChildElementText(name.getQName());
        return text != null && !text.isBlank() ? text : null;
    }

    private static boolean isNumerical(String v) {
        for (char c : v.toCharArray()) {
            if (Character.isDigit(c) || c == '.') continue;
            return false;
        }
        return true;
    }

    private static boolean noTimestamp(String v) {
        char[] chars = v.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) continue;
            return i == 0 || Integer.parseInt(v.substring(0, i)) < 10000;
        }
        return v.isEmpty() || Integer.parseInt(v) < 10000;
    }

    private static String getMajorComponentPrefix(String v) {
        String major;
        int dot = v.indexOf(46);
        if (dot > 0 && UpdateDependencyHint.isNumerical(major = v.substring(0, dot + 1))) {
            return major;
        }
        return "";
    }

    private static int compare(String version1, String version2) {
        return new ComparableVersion(version1).compareTo(new ComparableVersion(version2));
    }

    private ErrorDescription createHintForComponent(POMExtensibilityElement comp, String version) {
        Document doc = comp.getModel().getBaseDocument();
        int line = NbEditorUtilities.getLine((Document)doc, (int)comp.findPosition(), (boolean)false).getLineNumber() + 1;
        List<UpdateVersionFix> fix = List.of(new UpdateVersionFix(comp, version));
        return ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)(Bundle.HINT_UpdateDependencyHint() + version), fix, (Document)doc, (int)line);
    }

    @Override
    public void cancel() {
        this.customizer = null;
    }

    @Override
    public Configuration getConfiguration() {
        return config;
    }

    private static boolean getNoMajorUpgradeOption() {
        return config.getPreferences().getBoolean(KEY_NO_MAJOR_UPGRADE, false);
    }

    @Override
    public String getSavedValue(JComponent customizer, String key) {
        if (KEY_NO_MAJOR_UPGRADE.equals(key) && customizer instanceof UpdateDependencyHintCustomizer) {
            return Boolean.toString(((UpdateDependencyHintCustomizer)customizer).getSavedNoMajorUpgradeOption());
        }
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences prefsCopy) {
        if (this.customizer == null) {
            this.customizer = new UpdateDependencyHintCustomizer(prefsCopy, UpdateDependencyHint.getNoMajorUpgradeOption());
        }
        return this.customizer;
    }

    private static class UpdateVersionFix
    implements Fix {
        private final POMExtensibilityElement version_comp;
        private final String version;

        private UpdateVersionFix(POMExtensibilityElement component, String toVersion) {
            this.version_comp = component;
            this.version = toVersion;
        }

        public String getText() {
            return Bundle.FIX_UpdateDependencyHint() + this.version;
        }

        public ChangeInfo implement() throws Exception {
            PomModelUtils.implementInTransaction((Model)this.version_comp.getModel(), () -> this.version_comp.setElementText(this.version));
            return new ChangeInfo();
        }
    }
}

