/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.ConnectProvider;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.vmd.VMDColorScheme;
import org.netbeans.api.visual.vmd.VMDConnectionWidget;
import org.netbeans.api.visual.vmd.VMDFactory;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.netbeans.api.visual.vmd.VMDPinWidget;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.web.jsf.navigation.NavigationCaseEdge;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowView;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.graph.PFENodeWidget;
import org.netbeans.modules.web.jsf.navigation.graph.PFENotModifiableScheme;
import org.netbeans.modules.web.jsf.navigation.graph.PFObjectSceneListener;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneElement;
import org.netbeans.modules.web.jsf.navigation.graph.actions.LinkCreateProvider;
import org.netbeans.modules.web.jsf.navigation.graph.actions.MapActionUtility;
import org.netbeans.modules.web.jsf.navigation.graph.actions.MyActionMapAction;
import org.netbeans.modules.web.jsf.navigation.graph.actions.PageFlowDeleteAction;
import org.netbeans.modules.web.jsf.navigation.graph.actions.PageFlowPopupProvider;
import org.netbeans.modules.web.jsf.navigation.graph.layout.ConnectionWrapperLayout;
import org.netbeans.modules.web.jsf.navigation.graph.layout.FreePlaceNodesLayouter;
import org.openide.actions.DeleteAction;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public class PageFlowScene
extends GraphPinScene<Page, NavigationCaseEdge, Pin> {
    private static final VMDColorScheme scheme = VMDFactory.getNetBeans60Scheme();
    private final LayerWidget backgroundLayer = new LayerWidget((Scene)this);
    private final LayerWidget mainLayer = new LayerWidget((Scene)this);
    private final LayerWidget connectionLayer = new LayerWidget((Scene)this);
    private final LayerWidget upperLayer = new LayerWidget((Scene)this);
    private Router router;
    private static final int MAX_EDGES = 20;
    private static final int MAX_PAGES = 20;
    private static final int MAX_ELEMENTS = 30;
    private final Router routerDirect = RouterFactory.createDirectRouter();
    private final WidgetAction moveControlPointAction = ActionFactory.createOrthogonalMoveControlPointAction();
    private final WidgetAction moveAction = ActionFactory.createMoveAction();
    private final WidgetAction connectAction = ActionFactory.createConnectAction((LayerWidget)this.connectionLayer, (ConnectProvider)new LinkCreateProvider(this));
    private final WidgetAction selectAction = ActionFactory.createSelectAction((SelectProvider)new PageFlowSelectProvider());
    private final WidgetAction doubleClickAction = ActionFactory.createEditAction((EditProvider)new PageNodeEditAction());
    private final WidgetAction pagePopupAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)new PageFlowPopupProvider());
    private WeakReference<PageFlowView> refPageFlowView;
    private PopupMenuProvider popupProvider;
    private PFObjectSceneListener pfObjectSceneListener;
    private static Paint PAINT_BACKGROUND;
    private FreePlaceNodesLayouter fpnl;
    private final LabelWidget malFormedLabel = new LabelWidget((Scene)this, "Your XML is Malformed.");
    private WidgetAction pageSpecificActionMapAction = null;

    public PageFlowScene(PageFlowView view) {
        this.refPageFlowView = new WeakReference<PageFlowView>(view);
        this.setOpaque(true);
        this.setBackground(PAINT_BACKGROUND);
        this.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_PARENTS);
        this.addChild((Widget)this.backgroundLayer);
        this.addChild((Widget)this.mainLayer);
        this.addChild((Widget)this.connectionLayer);
        this.addChild((Widget)this.upperLayer);
        this.router = RouterFactory.createOrthogonalSearchRouter((LayerWidget[])new LayerWidget[]{this.mainLayer, this.connectionLayer});
        WidgetAction.Chain actions = this.getActions();
        actions.addAction(ActionFactory.createZoomAction());
        actions.addAction(ActionFactory.createPanAction());
        actions.addAction(ActionFactory.createRectangularSelectAction((ObjectScene)this, (LayerWidget)this.backgroundLayer));
        actions.addAction(this.pagePopupAction);
        actions.addAction(this.createActionMap());
        this.pfObjectSceneListener = new PFObjectSceneListener();
        this.addObjectSceneListener(this.pfObjectSceneListener, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
        this.fpnl = new FreePlaceNodesLayouter(this, view.getVisibleRect());
    }

    public void destoryPageFlowScene() {
        this.removeObjectSceneListener(this.pfObjectSceneListener, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
        this.pfObjectSceneListener = null;
        this.popupProvider = null;
        this.fpnl.unregisterListeners(this);
        this.fpnl = null;
        this.router = null;
        WidgetAction.Chain chainActions = this.getActions();
        for (WidgetAction action : new ArrayList(chainActions.getActions())) {
            chainActions.removeAction(action);
        }
    }

    private WidgetAction createActionMap() {
        ActionMap actionMap = ((PageFlowView)((Object)this.refPageFlowView.get())).getActionMap();
        CallbackSystemAction a = (CallbackSystemAction)SystemAction.get(DeleteAction.class);
        actionMap.put(a.getActionMapKey(), new PageFlowDeleteAction(this));
        return new MyActionMapAction(MapActionUtility.initInputMap(), MapActionUtility.initActionMap());
    }

    public PageFlowView getPageFlowView() {
        return (PageFlowView)((Object)this.refPageFlowView.get());
    }

    public void createMalFormedWidget() {
        List widgets = this.getChildren();
        if (!widgets.contains(this.malFormedLabel)) {
            this.addChild((Widget)this.malFormedLabel);
            this.validate();
        }
    }

    public void removeMalFormedWidget() {
        List widgets = this.getChildren();
        if (widgets.contains(this.malFormedLabel)) {
            this.removeChild((Widget)this.malFormedLabel);
            this.validate();
        }
    }

    protected Widget attachNodeWidget(Page page) {
        assert (page != null);
        PFENodeWidget nodeWidget = new PFENodeWidget(this, scheme);
        String displayName = page.getDisplayName();
        nodeWidget.setNodeName(displayName);
        Widget header = nodeWidget.getHeader();
        DefaultAnchorWidget imageWidget = new DefaultAnchorWidget(this, ImageUtilities.loadImage((String)"org/netbeans/modules/visual/resources/vmd-pin.png"));
        imageWidget.getActions().addAction(this.connectAction);
        imageWidget.getActions().addAction(this.createWidgetHoverAction());
        header.addChild((Widget)imageWidget);
        header.getActions().addAction(this.createWidgetHoverAction());
        LabelWidget lblWidget = nodeWidget.getNodeNameWidget();
        lblWidget.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new PageNodeTextFieldInplaceEditor(nodeWidget)));
        this.mainLayer.addChild((Widget)nodeWidget);
        nodeWidget.getHeader().getActions().addAction(this.createObjectHoverAction());
        nodeWidget.getHeader().getActions().addAction(this.doubleClickAction);
        nodeWidget.getActions().addAction(this.selectAction);
        nodeWidget.getActions().addAction(this.moveAction);
        nodeWidget.setMinimized(true);
        return nodeWidget;
    }

    public final void updateNodeWidgetActions(Page page) {
        Widget nodeWidget = this.findWidget(page);
        if (nodeWidget != null) {
            if (this.pageSpecificActionMapAction != null) {
                nodeWidget.getActions().removeAction(this.pageSpecificActionMapAction);
            }
            this.pageSpecificActionMapAction = this.createActionMapAction(page);
            if (this.pageSpecificActionMapAction != null) {
                nodeWidget.getActions().addAction(this.pageSpecificActionMapAction);
            }
        }
    }

    private WidgetAction createActionMapAction(Page page) {
        Action[] actions;
        InputMap inputMap = new InputMap();
        ActionMap actionMap = new ActionMap();
        for (Action action : actions = page.getActions(true)) {
            KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
            if (keyStroke == null) continue;
            inputMap.put(keyStroke, action.toString());
            actionMap.put(action.toString(), action);
        }
        if (actionMap.size() < 1) {
            return null;
        }
        return new MyActionMapAction(inputMap, actionMap);
    }

    public Rectangle getVisibleRect() {
        return ((PageFlowView)((Object)this.refPageFlowView.get())).getVisibleRect();
    }

    protected void detachNodeWidget(Page node, Widget widget) {
        super.detachNodeWidget((Object)node, widget);
    }

    public Pin getDefaultPin(Page pageNode) {
        Collection pins = this.getNodePins(pageNode);
        if (pins == null) {
            System.err.println("Node is null?: " + pageNode);
        }
        for (Pin pin : pins) {
            if (!pin.isDefault()) continue;
            return pin;
        }
        System.err.println("Some reason this node: " + pageNode + " does not have a pin.");
        return null;
    }

    protected Widget attachPinWidget(Page pageNode, Pin pinNode) {
        assert (pageNode != null);
        if (pinNode.isDefault()) {
            return null;
        }
        VMDPinWidget widget = new VMDPinWidget((Scene)this, scheme);
        VMDNodeWidget nodeWidget = (VMDNodeWidget)this.findWidget(pageNode);
        if (nodeWidget != null) {
            nodeWidget.attachPinWidget((Widget)widget);
            widget.setProperties(pinNode.getName(), Arrays.asList(pinNode.getIcon(0)));
            WidgetAction.Chain actions = widget.getActions();
            actions.addAction(this.createObjectHoverAction());
            actions.addAction(this.createSelectAction());
            actions.addAction(this.connectAction);
            actions.addAction(this.doubleClickAction);
        } else {
            System.err.println("Node widget should not be null.");
        }
        return widget;
    }

    protected Widget attachEdgeWidget(NavigationCaseEdge edge) {
        assert (edge != null);
        VMDConnectionWidget connectionWidget = edge.isModifiable() ? new VMDConnectionWidget((Scene)this, scheme) : new VMDConnectionWidget((Scene)this, (VMDColorScheme)new PFENotModifiableScheme());
        if (this.getEdges().size() > 20 || this.getNodes().size() > 20 || this.getEdges().size() + this.getNodes().size() > 30) {
            connectionWidget.setRouter(this.routerDirect);
        } else {
            connectionWidget.setRouter(this.router);
        }
        LabelWidget label = new LabelWidget((Scene)this, edge.getName());
        label.setOpaque(true);
        label.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new CaseNodeTextFieldInplaceEditor()));
        this.connectionLayer.addChild((Widget)connectionWidget);
        connectionWidget.getActions().addAction(this.createObjectHoverAction());
        connectionWidget.getActions().addAction(this.selectAction);
        connectionWidget.getActions().addAction(this.moveControlPointAction);
        connectionWidget.getActions().addAction(this.doubleClickAction);
        connectionWidget.setLayout((Layout)new ConnectionWrapperLayout((ConnectionWidget)connectionWidget, label));
        connectionWidget.setConstraint((Widget)label, LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_RIGHT, 10);
        connectionWidget.addChild((Widget)label);
        return connectionWidget;
    }

    public void renameEdgeWidget(NavigationCaseEdge edge, String newName, String oldName) {
        VMDConnectionWidget edgeWidget = (VMDConnectionWidget)this.findWidget(edge);
        List widgets = edgeWidget.getChildren();
        for (Widget widget : widgets) {
            if (!(widget instanceof LabelWidget) || !((LabelWidget)widget).getLabel().equals(oldName)) continue;
            ((LabelWidget)widget).setLabel(newName);
            return;
        }
    }

    protected void attachEdgeSourceAnchor(NavigationCaseEdge edge, Pin oldSourcePin, Pin sourcePin) {
        ConnectionWidget connectionWidget = (ConnectionWidget)this.findWidget(edge);
        Anchor anchor = this.getPinAnchor(sourcePin);
        connectionWidget.setSourceAnchor(anchor);
    }

    protected void attachEdgeTargetAnchor(NavigationCaseEdge edge, Pin oldTargetPin, Pin targetPin) {
        ((ConnectionWidget)this.findWidget(edge)).setTargetAnchor(this.getPinAnchor(targetPin));
    }

    private Anchor getPinAnchor(Pin pin) {
        Anchor anchor;
        if (pin == null) {
            return null;
        }
        VMDNodeWidget nodeWidget = (VMDNodeWidget)this.findWidget(this.getPinNode(pin));
        Widget pinMainWidget = this.findWidget(pin);
        if (pinMainWidget != null) {
            anchor = AnchorFactory.createDirectionalAnchor((Widget)pinMainWidget, (AnchorFactory.DirectionalAnchorKind)AnchorFactory.DirectionalAnchorKind.HORIZONTAL, (int)8);
            anchor = nodeWidget.createAnchorPin(anchor);
        } else {
            anchor = nodeWidget.getNodeAnchor();
        }
        return anchor;
    }

    public LayerWidget getConnectionLayer() {
        return this.connectionLayer;
    }

    public PopupMenuProvider getPopupMenuProvider() {
        return this.popupProvider;
    }

    static {
        Image sourceImage = ImageUtilities.loadImage((String)"org/netbeans/modules/web/jsf/navigation/graph/resources/paper_grid.png");
        int width = sourceImage.getWidth(null);
        int height = sourceImage.getHeight(null);
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.drawImage(sourceImage, 0, 0, null);
        graphics.dispose();
        PAINT_BACKGROUND = new TexturePaint(image, new Rectangle(0, 0, width, height));
    }

    private final class PageFlowSelectProvider
    implements SelectProvider {
        private PageFlowSelectProvider() {
        }

        public boolean isAimingAllowed(Widget widget, Point localLocation, boolean invertSelection) {
            return false;
        }

        public boolean isSelectionAllowed(Widget widget, Point localLocation, boolean invertSelection) {
            Object object = PageFlowScene.this.findObject(widget);
            return object != null && (invertSelection || !PageFlowScene.this.getSelectedObjects().contains(object));
        }

        public void select(Widget widget, Point localLocation, boolean invertSelection) {
            Object object = PageFlowScene.this.findObject(widget);
            if (object != null) {
                PageFlowScene.this.setFocusedObject(object);
                if (PageFlowScene.this.getSelectedObjects().contains(object)) {
                    return;
                }
                PageFlowScene.this.userSelectionSuggested(Collections.singleton(object), invertSelection);
            } else {
                PageFlowScene.this.userSelectionSuggested(Collections.emptySet(), invertSelection);
            }
        }
    }

    public final class PageNodeEditAction
    implements EditProvider {
        public void edit(Widget widget) {
            PageFlowScene scene = (PageFlowScene)widget.getScene();
            PageFlowSceneElement element = (PageFlowSceneElement)scene.findObject(widget);
            MapActionUtility.openPageFlowSceneElement(element);
        }
    }

    private static class DefaultAnchorWidget
    extends ImageWidget {
        public DefaultAnchorWidget(PageFlowScene scene, Image image) {
            super((Scene)scene, image);
        }

        protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
            Border BORDER_HOVERED = BorderFactory.createLineBorder(Color.BLACK);
            Border BORDER = BorderFactory.createEmptyBorder();
            if (previousState.isHovered() == state.isHovered()) {
                return;
            }
            this.setBorder(state.isHovered() ? BORDER_HOVERED : BORDER);
        }
    }

    public final class PageNodeTextFieldInplaceEditor
    implements TextFieldInplaceEditor {
        private final VMDNodeWidget nodeWidget;

        public PageNodeTextFieldInplaceEditor(VMDNodeWidget nodeWidget) {
            this.nodeWidget = nodeWidget;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            Page pageNode = (Page)PageFlowScene.this.findObject((Widget)this.nodeWidget);
            return pageNode.getName();
        }

        public void setText(Widget widget, String text) {
            Page pageNode = (Page)PageFlowScene.this.findObject((Widget)this.nodeWidget);
            if (pageNode.canRename() && !text.equals(pageNode.getName())) {
                String oldName = pageNode.getDisplayName();
                pageNode.setName(text);
                String newName = pageNode.getDisplayName();
                if (widget instanceof LabelWidget) {
                    ((LabelWidget)widget).setLabel(newName);
                } else if (widget instanceof VMDNodeWidget) {
                    ((VMDNodeWidget)widget).getNodeNameWidget().setLabel(newName);
                }
                PageFlowScene.this.validate();
            }
        }
    }

    public final class CaseNodeTextFieldInplaceEditor
    implements TextFieldInplaceEditor {
        public boolean isEnabled(Widget widget) {
            NavigationCaseEdge caseNode = (NavigationCaseEdge)PageFlowScene.this.findObject(widget.getParentWidget());
            return caseNode.isModifiable();
        }

        public String getText(Widget widget) {
            NavigationCaseEdge caseNode = (NavigationCaseEdge)PageFlowScene.this.findObject(widget.getParentWidget());
            return ((LabelWidget)widget).getLabel();
        }

        public void setText(Widget widget, String newName) {
            if (newName.equals("")) {
                return;
            }
            NavigationCaseEdge caseNode = (NavigationCaseEdge)PageFlowScene.this.findObject(widget.getParentWidget());
            String oldName = caseNode.getName();
            if (caseNode.canRename()) {
                caseNode.setName(newName);
            }
            ((LabelWidget)widget).setLabel(newName);
        }
    }

    static class SceneTestAccessor {
        SceneTestAccessor() {
        }

        static FreePlaceNodesLayouter getFreePlaceNodesLayouter(PageFlowScene scene) {
            return scene.fpnl;
        }

        static PopupMenuProvider getPopupProvider(PageFlowScene scene) {
            return scene.popupProvider;
        }

        static PFObjectSceneListener getPfObjectSceneListener(PageFlowScene scene) {
            return scene.pfObjectSceneListener;
        }
    }
}

