/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.ContentNegotiationProperties;
import com.sun.xml.rpc.client.HandlerChainImpl;
import com.sun.xml.rpc.client.dii.CallEx;
import com.sun.xml.rpc.client.dii.CallInvoker;
import com.sun.xml.rpc.client.dii.CallInvokerImpl;
import com.sun.xml.rpc.client.dii.CallRequest;
import com.sun.xml.rpc.client.dii.DynamicInvocationException;
import com.sun.xml.rpc.client.dii.OperationInfo;
import com.sun.xml.rpc.client.dii.ParameterMemberInfo;
import com.sun.xml.rpc.encoding.DynamicInternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.ReferenceableSerializerImpl;
import com.sun.xml.rpc.encoding.SOAPFaultInfoSerializer;
import com.sun.xml.rpc.encoding.literal.LiteralRequestSerializer;
import com.sun.xml.rpc.encoding.literal.LiteralResponseSerializer;
import com.sun.xml.rpc.encoding.soap.SOAPRequestSerializer;
import com.sun.xml.rpc.encoding.soap.SOAPResponseSerializer;
import com.sun.xml.rpc.encoding.soap.SOAPResponseStructure;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPNamespaceConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerRegistry;
import javax.xml.rpc.soap.SOAPFaultException;

public class BasicCall
implements CallEx {
    protected static final QName EMPTY_QNAME = new QName("");
    protected static final QName RESULT_QNAME = null;
    protected static final int RETURN_VALUE_INDEX = 0;
    private boolean isProxy = false;
    protected boolean isOneWay;
    protected static final JAXRPCDeserializer faultDeserializer = new ReferenceableSerializerImpl(false, new SOAPFaultInfoSerializer(false, false));
    protected static final Set recognizedProperties;
    protected JAXRPCSerializer requestSerializer = null;
    protected JAXRPCDeserializer responseDeserializer = null;
    protected List inParameterNames = new ArrayList();
    protected List outParameterNames = new ArrayList();
    protected List inParameterXmlTypes = new ArrayList();
    protected List outParameterXmlTypes = new ArrayList();
    protected List inParameterXmlTypeQNames = new ArrayList();
    protected List outParameterXmlTypeQNames = new ArrayList();
    protected List inParameterClasses = new ArrayList();
    protected List outParameterClasses = new ArrayList();
    protected SOAPResponseStructure response = null;
    protected List inParameterMembers = new ArrayList();
    protected List outParameterMembers = new ArrayList();
    protected QName returnXmlType = null;
    protected QName returnXmlTypeQName = null;
    protected Class returnClass = null;
    protected String returnClassName = null;
    protected QName returnTypeQName = null;
    protected ParameterMemberInfo[] returnParameterMembers = null;
    protected QName operationName = EMPTY_QNAME;
    protected QName portName = EMPTY_QNAME;
    protected QName portTypeName = EMPTY_QNAME;
    protected String targetEndpointAddress = null;
    protected Map properties = new HashMap();
    protected InternalTypeMappingRegistry typeRegistry;
    protected CallInvoker invoker = new CallInvokerImpl();
    protected Collection packages;
    protected HandlerRegistry handlerRegistry;
    protected OperationInfo operationInfo;
    private SOAPNamespaceConstants soapNamespaceConstants = null;

    private void init(SOAPVersion ver) {
        this.soapNamespaceConstants = SOAPConstantsFactory.getSOAPNamespaceConstants(ver);
    }

    public BasicCall(InternalTypeMappingRegistry registry, HandlerRegistry handlerRegistry) {
        this(registry, handlerRegistry, SOAPVersion.SOAP_11);
    }

    public BasicCall(InternalTypeMappingRegistry registry, HandlerRegistry handlerRegistry, SOAPVersion ver) {
        if (registry == null) {
            throw new DynamicInvocationException("dii.typeregistry.missing.in.call");
        }
        this.init(ver);
        this.typeRegistry = new DynamicInternalTypeMappingRegistry(registry, this);
        String operationStyle = (String)this.getProperty("javax.xml.rpc.soap.operation.style");
        ((DynamicInternalTypeMappingRegistry)this.typeRegistry).setStyles(operationStyle);
        this.handlerRegistry = handlerRegistry;
        this.setProperty("javax.xml.rpc.soap.http.soapaction.use", new Boolean(false));
        ContentNegotiationProperties.initFromSystemProperties(this.properties);
    }

    public boolean isParameterAndReturnSpecRequired(QName operation) {
        return true;
    }

    public HandlerChain getHandlerChain() {
        if (this.handlerRegistry.getHandlerChain(this.portName) == null) {
            return null;
        }
        return new HandlerChainImpl(this.handlerRegistry.getHandlerChain(this.portName));
    }

    public void addParameter(String paramName, QName paramXmlType, ParameterMode parameterMode) {
        this.checkIsParameterAndReturnTypeSpecAllowed();
        this.doAddParameter(paramName, paramXmlType, parameterMode);
    }

    protected void doAddParameter(String paramName, QName paramXmlType, ParameterMode parameterMode) {
        this.doAddParameter(paramName, paramXmlType, null, parameterMode);
    }

    public void addParameter(String paramName, QName paramXmlType, Class paramClass, ParameterMode parameterMode) {
        this.checkIsParameterAndReturnTypeSpecAllowed();
        this.doAddParameter(paramName, paramXmlType, paramClass, parameterMode);
    }

    protected void doAddParameter(String paramName, QName paramXmlType, Class paramClass, ParameterMode parameterMode) {
        this.resetSerializers();
        if (parameterMode == ParameterMode.OUT) {
            this.outParameterNames.add(new QName(paramName));
            this.outParameterXmlTypes.add(paramXmlType);
            this.outParameterClasses.add(paramClass);
        } else if (parameterMode == ParameterMode.IN) {
            this.inParameterNames.add(new QName(paramName));
            this.inParameterXmlTypes.add(paramXmlType);
            this.inParameterClasses.add(paramClass);
        } else if (parameterMode == ParameterMode.INOUT) {
            this.inParameterNames.add(new QName(paramName));
            this.inParameterXmlTypes.add(paramXmlType);
            this.inParameterClasses.add(paramClass);
            this.outParameterNames.add(new QName(paramName));
            this.outParameterXmlTypes.add(paramXmlType);
            this.outParameterClasses.add(paramClass);
        }
    }

    protected void doAddParameter(String paramName, QName paramXmlType, Class paramClass, ParameterMemberInfo[] parameterMemberInfos, ParameterMode parameterMode) {
        this.resetSerializers();
        if (parameterMode == ParameterMode.OUT) {
            this.outParameterNames.add(new QName(paramName));
            this.outParameterXmlTypes.add(paramXmlType);
            this.outParameterClasses.add(paramClass);
            this.outParameterMembers.add(parameterMemberInfos);
        } else if (parameterMode == ParameterMode.IN) {
            this.inParameterNames.add(new QName(paramName));
            this.inParameterXmlTypes.add(paramXmlType);
            this.inParameterClasses.add(paramClass);
            this.inParameterMembers.add(parameterMemberInfos);
        } else if (parameterMode == ParameterMode.INOUT) {
            this.inParameterNames.add(new QName(paramName));
            this.inParameterXmlTypes.add(paramXmlType);
            this.inParameterClasses.add(paramClass);
            this.inParameterMembers.add(parameterMemberInfos);
            this.outParameterNames.add(new QName(paramName));
            this.outParameterXmlTypes.add(paramXmlType);
            this.outParameterClasses.add(paramClass);
            this.outParameterMembers.add(parameterMemberInfos);
        }
    }

    protected void doAddParameter(String paramName, QName paramXmlType, QName paramXmlTypeQName, Class paramClass, ParameterMemberInfo[] parameterMemberInfos, ParameterMode parameterMode) {
        this.resetSerializers();
        if (parameterMode == ParameterMode.OUT) {
            this.outParameterNames.add(new QName(paramName));
            this.outParameterXmlTypes.add(paramXmlType);
            this.outParameterXmlTypeQNames.add(paramXmlTypeQName);
            this.outParameterClasses.add(paramClass);
            this.outParameterMembers.add(parameterMemberInfos);
        } else if (parameterMode == ParameterMode.IN) {
            this.inParameterNames.add(new QName(paramName));
            this.inParameterXmlTypes.add(paramXmlType);
            this.inParameterXmlTypeQNames.add(paramXmlTypeQName);
            this.inParameterClasses.add(paramClass);
            this.inParameterMembers.add(parameterMemberInfos);
        } else if (parameterMode == ParameterMode.INOUT) {
            this.inParameterNames.add(new QName(paramName));
            this.inParameterXmlTypes.add(paramXmlType);
            this.inParameterXmlTypeQNames.add(paramXmlTypeQName);
            this.inParameterClasses.add(paramClass);
            this.inParameterMembers.add(parameterMemberInfos);
            this.outParameterNames.add(new QName(paramName));
            this.outParameterXmlTypes.add(paramXmlType);
            this.outParameterXmlTypeQNames.add(paramXmlTypeQName);
            this.outParameterClasses.add(paramClass);
            this.outParameterMembers.add(parameterMemberInfos);
        }
    }

    public QName[] getInParameterXmlTypes() {
        return this.inParameterXmlTypes.toArray(new QName[this.inParameterXmlTypes.size()]);
    }

    public QName getParameterTypeByName(String parameterName) {
        String currentName;
        ListIterator eachName = this.inParameterNames.listIterator();
        while (eachName.hasNext()) {
            currentName = ((QName)eachName.next()).getLocalPart();
            if (!currentName.equals(parameterName)) continue;
            return (QName)this.inParameterXmlTypes.get(eachName.previousIndex());
        }
        eachName = this.outParameterNames.listIterator();
        while (eachName.hasNext()) {
            currentName = ((QName)eachName.next()).getLocalPart();
            if (!currentName.equals(parameterName)) continue;
            return (QName)this.outParameterXmlTypes.get(eachName.previousIndex());
        }
        return null;
    }

    protected boolean isProxy() {
        return this.isProxy;
    }

    protected void setIsProxy(boolean value) {
        this.isProxy = value;
    }

    public void setReturnTypeQName(QName returnTypeQName) {
        this.returnTypeQName = returnTypeQName;
    }

    public void setReturnXmlTypeQName(QName returnXmlTypeQName) {
        this.returnXmlTypeQName = returnXmlTypeQName;
    }

    public void setReturnType(QName type) {
        if (type != null) {
            this.checkIsParameterAndReturnTypeSpecAllowed();
        }
        this.doSetReturnType(type);
    }

    protected void doSetReturnType(QName type) {
        this.setReturnType(type, null);
    }

    public void setReturnParameterInfos(ParameterMemberInfo[] infos) {
        this.returnParameterMembers = infos;
    }

    public ParameterMemberInfo[] getReturnParameterMembers() {
        return this.returnParameterMembers;
    }

    public void setReturnType(QName type, Class javaType) {
        if (type != null && javaType != null) {
            this.checkIsParameterAndReturnTypeSpecAllowed();
        }
        this.doSetReturnType(type, javaType);
    }

    protected void doSetReturnType(QName type, Class javaType) {
        this.resetSerializers();
        this.returnXmlType = type;
        this.returnClass = javaType;
    }

    public QName getReturnType() {
        return this.returnXmlType;
    }

    protected void setReturnTypeName(String name) {
        this.returnClassName = name;
    }

    public void removeAllParameters() {
        this.doRemoveAllParameters();
    }

    protected void doRemoveAllParameters() {
        this.resetSerializers();
        this.inParameterNames.clear();
        this.inParameterXmlTypes.clear();
        this.inParameterClasses.clear();
        this.outParameterNames.clear();
        this.outParameterXmlTypes.clear();
        this.outParameterClasses.clear();
    }

    protected void resetSerializers() {
        this.requestSerializer = null;
        this.responseDeserializer = null;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(QName portType) {
        this.portTypeName = portType;
    }

    @Override
    public QName getPortName() {
        return this.portName;
    }

    @Override
    public void setPortName(QName port) {
        this.portName = port;
    }

    public QName getOperationName() {
        return this.operationName;
    }

    protected void setOperationInfo(OperationInfo info) {
        this.operationInfo = info;
    }

    public OperationInfo getOperationInfo() {
        return this.operationInfo;
    }

    public void setOperationName(QName operationName) {
        this.operationName = operationName;
    }

    public void setTargetEndpointAddress(String address) {
        this.targetEndpointAddress = address;
        this.invoker = new CallInvokerImpl();
    }

    public String getTargetEndpointAddress() {
        return this.targetEndpointAddress;
    }

    public void setProperty(String name, Object value) {
        if (!recognizedProperties.contains(name)) {
            throw new DynamicInvocationException("dii.call.property.set.unrecognized", new Object[]{name});
        }
        if (name.equals("com.sun.xml.rpc.client.ContentNegotiation")) {
            this.properties.put(name, ((String)value).intern());
        } else {
            this.properties.put(name, value);
        }
    }

    public Object getProperty(String name) {
        if (!recognizedProperties.contains(name)) {
            throw new DynamicInvocationException("dii.call.property.get.unrecognized", new Object[]{name});
        }
        return this.properties.get(name);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public Iterator getPropertyNames() {
        return recognizedProperties.iterator();
    }

    public Object invoke(Object[] parameters) throws RemoteException {
        if (this.isOneWay) {
            this.invokeOneWay(parameters);
        } else {
            block15: {
                if (this.packages != null) {
                    this.packages.clear();
                }
                if (parameters == null) {
                    parameters = new Object[]{};
                } else {
                    this.packages = this.collectPackages(parameters);
                }
                this.inParameterClasses = this.validateParameters(this.inParameterClasses, null, this.packages);
                this.returnClass = this.validateReturnClass(this.returnClass, this.returnClassName, this.packages);
                try {
                    String operationStyle = (String)this.getProperty("javax.xml.rpc.soap.operation.style");
                    ((DynamicInternalTypeMappingRegistry)this.typeRegistry).setStyles(operationStyle);
                    String encodingStyle = (String)this.getProperty("javax.xml.rpc.encodingstyle.namespace.uri");
                    if ("document".equals(operationStyle) && "".equals(encodingStyle)) {
                        this.response = this.getInvoker().doInvoke(new CallRequest(this, parameters), this.getRequestSerializer(), this.getResponseDeserializer(), this.getFaultDeserializer());
                        break block15;
                    }
                    if ("rpc".equals(operationStyle) && "".equals(encodingStyle)) {
                        this.response = this.getInvoker().doInvoke(new CallRequest(this, parameters), this.getRequestSerializer(), this.getResponseDeserializer(), this.getFaultDeserializer());
                        break block15;
                    }
                    if ("rpc".equals(operationStyle) && this.soapNamespaceConstants.getEncoding().equals(encodingStyle)) {
                        this.response = this.getInvoker().doInvoke(new CallRequest(this, parameters), this.getRequestSerializer(), this.getResponseDeserializer(), this.getFaultDeserializer());
                        break block15;
                    }
                    throw this.unsupportedOperationStyleException(operationStyle);
                }
                catch (RemoteException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (e instanceof SOAPFaultException) {
                        if (this.isProxy()) {
                            throw (SOAPFaultException)e;
                        }
                        throw new RemoteException(((SOAPFaultException)e).getFaultString());
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RemoteException("", (Throwable)((Object)new DynamicInvocationException(new LocalizableExceptionAdapter(e))));
                }
            }
            if (this.response != null) {
                return this.response.returnValue;
            }
        }
        return null;
    }

    public Object invoke(QName operationName, Object[] inputParams) throws RemoteException {
        this.setOperationName(operationName);
        Object returnValue = this.invoke(inputParams);
        return returnValue;
    }

    public void invokeOneWay(Object[] parameters) {
        block7: {
            if (parameters == null) {
                parameters = new Object[]{};
            }
            try {
                String operationStyle = (String)this.getProperty("javax.xml.rpc.soap.operation.style");
                String encodingStyle = (String)this.getProperty("javax.xml.rpc.encodingstyle.namespace.uri");
                if ("document".equals(operationStyle) && "".equals(encodingStyle)) {
                    this.getInvoker().doInvokeOneWay(new CallRequest(this, parameters), this.getRequestSerializer());
                    break block7;
                }
                if ("rpc".equals(operationStyle) && "".equals(encodingStyle)) {
                    this.getInvoker().doInvokeOneWay(new CallRequest(this, parameters), this.getRequestSerializer());
                    break block7;
                }
                if ("rpc".equals(operationStyle) && this.soapNamespaceConstants.getEncoding().equals(encodingStyle)) {
                    this.getInvoker().doInvokeOneWay(new CallRequest(this, parameters), this.getRequestSerializer());
                    break block7;
                }
                throw this.unsupportedOperationStyleException(operationStyle);
            }
            catch (Exception e) {
                if (e instanceof SOAPFaultException) break block7;
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new DynamicInvocationException(new LocalizableExceptionAdapter(e));
            }
        }
    }

    protected DynamicInvocationException unsupportedOperationStyleException(String operationStyle) {
        return new DynamicInvocationException("dii.operation.style.unsupported", new Object[]{operationStyle});
    }

    public Map getOutputParams() {
        if (this.response == null) {
            throw new DynamicInvocationException("dii.outparameters.not.available");
        }
        return Collections.unmodifiableMap(this.response.outParametersStringKeys);
    }

    public Map getOutputParamsQNames() {
        if (this.response == null) {
            throw new DynamicInvocationException("dii.outparameters.not.available");
        }
        return Collections.unmodifiableMap(this.response.outParameters);
    }

    public List getOutputValues() {
        return Collections.unmodifiableList((List)this.response.outParameters.values());
    }

    Object getRequiredProperty(String requiredProperty) {
        Object property = this.getProperty(requiredProperty);
        if (property == null) {
            throw this.propertyNotFoundException(requiredProperty);
        }
        return property;
    }

    protected void checkIsParameterAndReturnTypeSpecAllowed() {
        if (!this.isParameterAndReturnSpecRequired(this.operationName)) {
            throw new DynamicInvocationException("dii.parameterandreturntypespec.not.allowed");
        }
    }

    protected CallInvoker getInvoker() {
        return this.invoker;
    }

    protected JAXRPCSerializer getRequestSerializer() throws Exception {
        String operationStyle = (String)this.getProperty("javax.xml.rpc.soap.operation.style");
        String encodingStyle = (String)this.getProperty("javax.xml.rpc.encodingstyle.namespace.uri");
        if (this.requestSerializer == null) {
            if (this.soapNamespaceConstants.getEncoding().equals(encodingStyle) && "rpc".equals(operationStyle)) {
                this.createRpcRequestSerializer();
            } else if ("".equals(encodingStyle) && "rpc".equals(operationStyle)) {
                this.createRpcLiteralRequestSerializer();
            } else if ("".equals(encodingStyle) && "document".equals(operationStyle)) {
                this.createLiteralRequestSerializer();
            } else {
                throw new DynamicInvocationException("dii.encoding.style.unsupported", new Object[]{encodingStyle});
            }
        }
        return this.requestSerializer;
    }

    protected void createRpcRequestSerializer() throws Exception {
        int parameterCount = this.inParameterNames.size();
        this.requestSerializer = new SOAPRequestSerializer(EMPTY_QNAME, this.inParameterNames.toArray(new QName[parameterCount]), this.inParameterXmlTypes.toArray(new QName[parameterCount]), this.inParameterClasses.toArray(new Class[parameterCount]));
        ((Initializable)((Object)this.requestSerializer)).initialize(this.typeRegistry);
    }

    protected void createLiteralRequestSerializer() throws Exception {
        String operationStyle = (String)this.getProperty("javax.xml.rpc.soap.operation.style");
        int parameterCount = this.inParameterNames.size();
        this.requestSerializer = new LiteralRequestSerializer((QName)this.inParameterXmlTypes.get(0), false, true, "", operationStyle, this.inParameterNames.toArray(new QName[parameterCount]), this.inParameterXmlTypes.toArray(new QName[parameterCount]), this.inParameterXmlTypeQNames.toArray(new QName[parameterCount]), this.inParameterClasses.toArray(new Class[parameterCount]), (ArrayList)this.inParameterMembers);
        ((Initializable)((Object)this.requestSerializer)).initialize(this.typeRegistry);
    }

    protected void createRpcLiteralRequestSerializer() throws Exception {
        String operationStyle = (String)this.getProperty("javax.xml.rpc.soap.operation.style");
        int parameterCount = this.inParameterNames.size();
        this.requestSerializer = new LiteralRequestSerializer(this.getOperationName(), false, true, "", operationStyle, this.inParameterNames.toArray(new QName[parameterCount]), this.inParameterXmlTypes.toArray(new QName[parameterCount]), this.inParameterClasses.toArray(new Class[parameterCount]), (ArrayList)this.inParameterMembers);
        ((Initializable)((Object)this.requestSerializer)).initialize(this.typeRegistry);
    }

    protected JAXRPCDeserializer getResponseDeserializer() throws Exception {
        if (this.responseDeserializer == null) {
            String operationStyle = (String)this.getProperty("javax.xml.rpc.soap.operation.style");
            String encodingStyle = (String)this.getProperty("javax.xml.rpc.encodingstyle.namespace.uri");
            if (this.soapNamespaceConstants.getEncoding().equals(encodingStyle) && "rpc".equals(operationStyle)) {
                this.createRpcResponseSerializer();
            } else if ("".equals(encodingStyle) && "rpc".equals(operationStyle)) {
                this.createRpcLiteralResponseSerializer();
            } else if ("".equals(encodingStyle) && "document".equals(operationStyle)) {
                this.createLiteralResponseSerializer();
            } else {
                throw new DynamicInvocationException("dii.encoding.style.unsupported", new Object[]{encodingStyle});
            }
        }
        return this.responseDeserializer;
    }

    protected void createRpcResponseSerializer() throws Exception {
        int parameterCount = this.outParameterNames.size();
        this.responseDeserializer = new ReferenceableSerializerImpl(false, new SOAPResponseSerializer(EMPTY_QNAME, this.outParameterNames.toArray(new QName[parameterCount]), this.outParameterXmlTypes.toArray(new QName[parameterCount]), this.outParameterClasses.toArray(new Class[parameterCount]), this.returnXmlType, this.returnClass));
        ((Initializable)((Object)this.responseDeserializer)).initialize(this.typeRegistry);
    }

    protected void createLiteralResponseSerializer() throws Exception {
        String operationStyle = (String)this.getProperty("javax.xml.rpc.soap.operation.style");
        int parameterCount = this.outParameterNames.size();
        if (this.returnClass == null && this.returnXmlType != null) {
            throw this.serializerNotFoundException(0, this.returnXmlType, null, this.returnXmlType);
        }
        this.responseDeserializer = new LiteralResponseSerializer(this.returnXmlType, false, true, "", operationStyle, this.outParameterNames.toArray(new QName[parameterCount]), this.outParameterXmlTypes.toArray(new QName[parameterCount]), this.outParameterXmlTypeQNames.toArray(new QName[parameterCount]), this.outParameterClasses.toArray(new Class[parameterCount]), (ArrayList)this.outParameterMembers, this.returnXmlType, this.returnXmlTypeQName, this.returnClass, this.returnParameterMembers);
        ((Initializable)((Object)this.responseDeserializer)).initialize(this.typeRegistry);
    }

    protected void createRpcLiteralResponseSerializer() throws Exception {
        String operationStyle = (String)this.getProperty("javax.xml.rpc.soap.operation.style");
        QName responseQName = new QName(this.operationName.getNamespaceURI(), this.operationName.getLocalPart() + "Response");
        int parameterCount = this.outParameterNames.size();
        this.responseDeserializer = new LiteralResponseSerializer(responseQName, false, true, "", operationStyle, this.outParameterNames.toArray(new QName[parameterCount]), this.outParameterXmlTypes.toArray(new QName[parameterCount]), this.outParameterClasses.toArray(new Class[parameterCount]), (ArrayList)this.outParameterMembers, this.returnXmlType, this.returnClass, this.returnParameterMembers);
        ((Initializable)((Object)this.responseDeserializer)).initialize(this.typeRegistry);
    }

    protected JAXRPCDeserializer getFaultDeserializer() {
        return faultDeserializer;
    }

    protected String getOperationStyle() {
        return (String)this.getRequiredProperty("javax.xml.rpc.soap.operation.style");
    }

    protected DynamicInvocationException serializerNotFoundException(int index, QName name, Class clazz, QName xmlType) {
        Integer indexObject = new Integer(index);
        if (clazz == null) {
            if (xmlType == null) {
                return new DynamicInvocationException("dii.parameter.type.underspecified", new Object[]{indexObject, name});
            }
            return new DynamicInvocationException("dii.parameter.type.ambiguous.no.class", new Object[]{indexObject, name, xmlType});
        }
        if (xmlType == null) {
            return new DynamicInvocationException("dii.parameter.type.ambiguous.no.typename", new Object[]{indexObject, name, clazz});
        }
        return new DynamicInvocationException("dii.parameter.type.unknown", new Object[]{indexObject, name, clazz, xmlType});
    }

    protected DynamicInvocationException propertyNotFoundException(String property) {
        return new DynamicInvocationException("dii.required.property.not.set", new Object[]{property});
    }

    protected Collection collectPackages(Object[] params) {
        if (this.packages != null) {
            this.packages.clear();
        }
        ArrayList<String> packages = new ArrayList<String>();
        if (params == null) {
            return packages;
        }
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) {
                return null;
            }
            Class<?> clazz = params[i].getClass();
            Package pack = null;
            if (clazz != null) {
                pack = clazz.getPackage();
            }
            if (pack == null) continue;
            this.breakPackageDown(pack.getName(), packages);
            packages.add(pack.getName());
        }
        return packages;
    }

    private List validateParameters(List parameterClasses, String[] classNames, Collection packages) {
        if (packages == null) {
            return parameterClasses;
        }
        Iterator iter = parameterClasses.iterator();
        boolean i = false;
        while (iter.hasNext()) {
            Class pclass = (Class)iter.next();
            pclass = this.validateClassPackage(pclass, null, packages);
        }
        return parameterClasses;
    }

    private Class validateReturnClass(Class returnClass, String returnClassName, Collection packages) {
        if (returnClass == null) {
            returnClass = this.getClassForName(returnClassName, packages);
        }
        return this.validateClassPackage(returnClass, returnClassName, packages);
    }

    protected Class getClassForName(String name, Collection packages) {
        if (name == null) {
            return null;
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            if (packages == null) {
                return null;
            }
            Iterator iter = packages.iterator();
            while (iter.hasNext()) {
                String qualifiedName = (String)iter.next() + "." + name;
                try {
                    return Class.forName(qualifiedName);
                }
                catch (ClassNotFoundException cfe) {
                }
            }
            return null;
        }
    }

    protected Class validateClassPackage(Class returnClass, String classname, Collection packages) {
        if (packages == null) {
            return returnClass;
        }
        if (returnClass != null) {
            Package clPack = null;
            try {
                clPack = returnClass.getPackage();
            }
            catch (NullPointerException npe) {
                return returnClass;
            }
            if (clPack == null) {
                return returnClass;
            }
            String packName = clPack.getName();
            if (packName == null) {
                return returnClass;
            }
            Iterator piter = packages.iterator();
            boolean found = false;
            while (piter.hasNext()) {
                if (!packName.equals((String)piter.next())) continue;
                found = true;
                break;
            }
            if (found) {
                return returnClass;
            }
            Class newClass = this.getClassForName(classname, packages);
            if (newClass != null) {
                return newClass;
            }
            return returnClass;
        }
        return returnClass;
    }

    private void breakPackageDown(String packName, Collection packages) {
        int idx = 0;
        while (idx != -1) {
            idx = packName.lastIndexOf(".");
            String newPack = null;
            if (idx == -1) {
                return;
            }
            newPack = packName.substring(0, idx);
            packages.add(newPack);
            packName = newPack;
        }
    }

    static {
        HashSet<String> temp = new HashSet<String>();
        temp.add("javax.xml.rpc.security.auth.username");
        temp.add("javax.xml.rpc.security.auth.password");
        temp.add("javax.xml.rpc.endpoint");
        temp.add("javax.xml.rpc.soap.operation.style");
        temp.add("javax.xml.rpc.soap.http.soapaction.use");
        temp.add("javax.xml.rpc.soap.http.soapaction.uri");
        temp.add("javax.xml.rpc.session.maintain");
        temp.add("javax.xml.rpc.encodingstyle.namespace.uri");
        temp.add("com.sun.xml.rpc.client.http.CookieJar");
        temp.add("com.sun.xml.rpc.client.http.HostnameVerificationProperty");
        temp.add("com.sun.xml.rpc.client.http.RedirectRequestProperty");
        temp.add("com.sun.xml.rpc.security.context");
        temp.add("com.sun.xml.rpc.attachment.SetAttachmentContext");
        temp.add("com.sun.xml.rpc.attachment.GetAttachmentContext");
        temp.add("com.sun.xml.rpc.client.ContentNegotiation");
        recognizedProperties = Collections.unmodifiableSet(temp);
    }
}

